// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/billing/usage_records/v1/consumption_core_service.proto

package usageRecords

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request for retrieving usage report data.
//
// This message defines the parameters for requesting usage reports across
// all ConsumptionCoreService methods. It supports filtering by various
// entity types and specifying the time range and aggregation period.
type UsageReportRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Required. Billing account identifier.
	BillingAccountId string `protobuf:"bytes,1,opt,name=billing_account_id,json=billingAccountId,proto3" json:"billing_account_id,omitempty"`
	// Required. Inclusive start date for metrics selection (UTC).
	// This timestamp defines the beginning of the reporting period.
	// All usage data starting from this timestamp will be included in the report.
	// Note: The time component (hours/minutes/seconds) is ignored since the smallest
	// aggregation period is a day. For example, both 2023-04-15T00:00:00 and
	// 2023-04-15T23:59:59 will include the entire day of April 15, 2023.
	// For best results, align with natural time boundaries (start of day, month)
	// based on your aggregation_period value.
	StartDate *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Required. Inclusive end date for metrics selection (UTC).
	// This timestamp defines the end of the reporting period.
	// All usage data up to and including this timestamp will be included in the report.
	// Note: The time component (hours/minutes/seconds) is ignored since the smallest
	// aggregation period is a day. For example, both 2023-04-15T00:00:00 and
	// 2023-04-15T23:59:59 will include the entire day of April 15, 2023.
	// For best results, align with natural time boundaries (end of day, month)
	// based on your aggregation_period value.
	EndDate *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Optional. List of cloud IDs to filter the data.
	// If specified, only usage data from these clouds will be included in the report.
	// If omitted, data from all clouds available to the billing account will be included.
	// The filter is applied with OR logic (results include data matching any of the specified cloud IDs).
	CloudIds []string `protobuf:"bytes,4,rep,name=cloud_ids,json=cloudIds,proto3" json:"cloud_ids,omitempty"`
	// Optional. List of folder IDs to filter the data.
	// If specified, only usage data from these folders will be included in the report.
	// If omitted, data from all folders available to the billing account will be included.
	// The filter is applied with OR logic (results include data matching any of the specified folder IDs).
	FolderIds []string `protobuf:"bytes,5,rep,name=folder_ids,json=folderIds,proto3" json:"folder_ids,omitempty"`
	// Optional. List of Service IDs to filter the data.
	// If specified, only usage data from these services (e.g., Compute, Storage, AI) will be included.
	// If omitted, data from all services used by the billing account will be included.
	// The filter is applied with OR logic (results include data matching any of the specified service IDs).
	ServiceIds []string `protobuf:"bytes,6,rep,name=service_ids,json=serviceIds,proto3" json:"service_ids,omitempty"`
	// Optional. List of SKU (Stock Keeping Unit) IDs to filter the data.
	// If specified, only usage data from these specific SKUs will be included.
	// If omitted, data from all SKUs used by the billing account will be included.
	// The filter is applied with OR logic (results include data matching any of the specified SKU IDs).
	SkuIds []string `protobuf:"bytes,7,rep,name=sku_ids,json=skuIds,proto3" json:"sku_ids,omitempty"`
	// Optional. Filter by labels: key is label key (e.g., "env", "team", "region"),
	// value is list of label values to match (e.g., ["prod", "stage"] for key "env").
	// This allows filtering resources based on their attached labels.
	//
	// Example: To filter resources that have either (env=prod OR env=test) AND (team=finance),
	// use the following filter:
	//
	//	{
	//	  "env": { "values": ["prod", "test"] },
	//	  "team": { "values": ["finance"] }
	//	}
	//
	// Note: The filter logic is (value1 OR value2 OR ...) for each key,
	// and (key1 AND key2 AND ...) between different keys.
	Labels map[string]*LabelList `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional. List of resource IDs to filter the data.
	// If specified, only usage data from these specific resources (e.g., individual VMs, disks) will be included.
	// If omitted, data from all resources used by the billing account will be included.
	// Filter is applied with OR logic (results include data matching any of the specified resource IDs).
	ResourceIds []string `protobuf:"bytes,9,rep,name=resource_ids,json=resourceIds,proto3" json:"resource_ids,omitempty"`
	// Optional. Aggregation granularity for the report, controlling how data points are grouped
	// in time series results. Available options include:
	// - DAY: Group metrics by day, providing daily breakdowns
	// - WEEK: Group metrics by week, providing weekly breakdowns
	// - MONTH: Group metrics by month, providing monthly breakdowns
	// - QUARTER: Group metrics by quarter, providing quarterly breakdowns
	// - YEAR: Group metrics by year, providing yearly breakdowns
	//
	// This setting affects the time series data returned in the periodic field of each entity.
	// If omitted, the service will typically use DAY as the default granularity.
	AggregationPeriod TimeGrouping `protobuf:"varint,10,opt,name=aggregation_period,json=aggregationPeriod,proto3,enum=yandex.cloud.billing.usage_records.v1.TimeGrouping" json:"aggregation_period,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *UsageReportRequest) Reset() {
	*x = UsageReportRequest{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UsageReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UsageReportRequest) ProtoMessage() {}

func (x *UsageReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UsageReportRequest.ProtoReflect.Descriptor instead.
func (*UsageReportRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{0}
}

func (x *UsageReportRequest) GetBillingAccountId() string {
	if x != nil {
		return x.BillingAccountId
	}
	return ""
}

func (x *UsageReportRequest) GetStartDate() *timestamppb.Timestamp {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *UsageReportRequest) GetEndDate() *timestamppb.Timestamp {
	if x != nil {
		return x.EndDate
	}
	return nil
}

func (x *UsageReportRequest) GetCloudIds() []string {
	if x != nil {
		return x.CloudIds
	}
	return nil
}

func (x *UsageReportRequest) GetFolderIds() []string {
	if x != nil {
		return x.FolderIds
	}
	return nil
}

func (x *UsageReportRequest) GetServiceIds() []string {
	if x != nil {
		return x.ServiceIds
	}
	return nil
}

func (x *UsageReportRequest) GetSkuIds() []string {
	if x != nil {
		return x.SkuIds
	}
	return nil
}

func (x *UsageReportRequest) GetLabels() map[string]*LabelList {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UsageReportRequest) GetResourceIds() []string {
	if x != nil {
		return x.ResourceIds
	}
	return nil
}

func (x *UsageReportRequest) GetAggregationPeriod() TimeGrouping {
	if x != nil {
		return x.AggregationPeriod
	}
	return TimeGrouping_TIME_GROUPING_UNSPECIFIED
}

// Response for usage report requests by billing account.
//
// Contains aggregated usage, cost, and credit information for a billing account,
// with both summary totals and detailed breakdowns by billing account entity.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for the specified billing account
// 3. Time series breakdown for the billing account according to the requested aggregation period
type BillingAccountUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for the specified billing account entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for the requested billing account, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*BillingAccountUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *BillingAccountUsageReportResponse) Reset() {
	*x = BillingAccountUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BillingAccountUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BillingAccountUsageReportResponse) ProtoMessage() {}

func (x *BillingAccountUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BillingAccountUsageReportResponse.ProtoReflect.Descriptor instead.
func (*BillingAccountUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{1}
}

func (x *BillingAccountUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *BillingAccountUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *BillingAccountUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *BillingAccountUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *BillingAccountUsageReportResponse) GetEntitiesData() []*BillingAccountUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by cloud.
//
// Contains aggregated usage, cost, and credit information organized by cloud entities,
// with both summary totals and detailed breakdowns for each cloud.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each cloud
// 3. Time series breakdown for each cloud according to the requested aggregation period
type CloudUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each cloud entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual cloud, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*CloudUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloudUsageReportResponse) Reset() {
	*x = CloudUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudUsageReportResponse) ProtoMessage() {}

func (x *CloudUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudUsageReportResponse.ProtoReflect.Descriptor instead.
func (*CloudUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{2}
}

func (x *CloudUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *CloudUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *CloudUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *CloudUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *CloudUsageReportResponse) GetEntitiesData() []*CloudUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by folder.
//
// Contains aggregated usage, cost, and credit information organized by folder entities,
// with both summary totals and detailed breakdowns for each folder.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each folder
// 3. Time series breakdown for each folder according to the requested aggregation period
type FolderUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each folder entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual folder, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*FolderUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FolderUsageReportResponse) Reset() {
	*x = FolderUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FolderUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FolderUsageReportResponse) ProtoMessage() {}

func (x *FolderUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FolderUsageReportResponse.ProtoReflect.Descriptor instead.
func (*FolderUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{3}
}

func (x *FolderUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *FolderUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *FolderUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *FolderUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *FolderUsageReportResponse) GetEntitiesData() []*FolderUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by service.
//
// Contains aggregated usage, cost, and credit information organized by service entities,
// with both summary totals and detailed breakdowns for each service. Services represent
// broad product categories (like Compute, Storage, AI) that can contain multiple SKUs.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each service
// 3. Time series breakdown for each service according to the requested aggregation period
type ServiceUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each service entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual service, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*ServiceUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServiceUsageReportResponse) Reset() {
	*x = ServiceUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceUsageReportResponse) ProtoMessage() {}

func (x *ServiceUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceUsageReportResponse.ProtoReflect.Descriptor instead.
func (*ServiceUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{4}
}

func (x *ServiceUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *ServiceUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *ServiceUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *ServiceUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *ServiceUsageReportResponse) GetEntitiesData() []*ServiceUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by SKU.
//
// Contains aggregated usage, cost, and credit information organized by SKU (Stock Keeping Unit) entities,
// with both summary totals and detailed breakdowns for each SKU. SKUs are specific billable offerings
// (like particular VM types or disk types) that belong to a parent service.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each SKU
// 3. Time series breakdown for each SKU according to the requested aggregation period
type SKUUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each SKU entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual SKU, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense, pricing_quantity)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*SKUUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SKUUsageReportResponse) Reset() {
	*x = SKUUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SKUUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SKUUsageReportResponse) ProtoMessage() {}

func (x *SKUUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SKUUsageReportResponse.ProtoReflect.Descriptor instead.
func (*SKUUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{5}
}

func (x *SKUUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *SKUUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *SKUUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *SKUUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *SKUUsageReportResponse) GetEntitiesData() []*SKUUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by resource.
//
// Contains aggregated usage, cost, and credit information organized by resource entities,
// with both summary totals and detailed breakdowns for each individual resource.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each resource
// 3. Time series breakdown for each resource according to the requested aggregation period
type ResourceUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each resource entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual resource, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*ResourceUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceUsageReportResponse) Reset() {
	*x = ResourceUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceUsageReportResponse) ProtoMessage() {}

func (x *ResourceUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceUsageReportResponse.ProtoReflect.Descriptor instead.
func (*ResourceUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{6}
}

func (x *ResourceUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *ResourceUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *ResourceUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *ResourceUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *ResourceUsageReportResponse) GetEntitiesData() []*ResourceUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

// Response for usage report requests by label-based grouping.
//
// Contains aggregated usage, cost, and credit information organized by label key-value pairs
// (e.g., "env:prod", "team:finance"), with both summary totals and detailed breakdowns for each label group.
// This allows analyzing costs across custom business dimensions defined by user-attached labels.
// The response includes:
// 1. Overall totals for the entire period (cost, credits, expense)
// 2. Entity-level totals for each label key-value pair
// 3. Time series breakdown for each label key-value pair according to the requested aggregation period
type LabelKeyUsageReportResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Currency code (e.g., "RUB", "USD") for all monetary values in the response.
	// Determined by the billing account's settings.
	Currency Currency `protobuf:"varint,1,opt,name=currency,proto3,enum=yandex.cloud.billing.usage_records.v1.Currency" json:"currency,omitempty"`
	// Total usage cost for the selected time period.
	// This represents the raw cost before any credits or discounts are applied.
	// Calculated based on the resource consumption and the corresponding price rates.
	Cost *StringDecimal `protobuf:"bytes,2,opt,name=cost,proto3" json:"cost,omitempty"`
	// Total credits (monetary grants, volume incentives, committed use discounts, and free credits) applied in the selected period.
	// Contains a detailed breakdown of all credit types that reduced the final billable amount.
	CreditDetails *CreditDetails `protobuf:"bytes,3,opt,name=credit_details,json=creditDetails,proto3" json:"credit_details,omitempty"`
	// Total expense (including cost and credit) for the selected time period.
	// This is the final billable amount after all credits have been applied.
	// Formula: expense = cost - sum of all credits.
	Expense *StringDecimal `protobuf:"bytes,4,opt,name=expense,proto3" json:"expense,omitempty"`
	// Detailed usage and billing data for each label entity.
	// This field contains a structured breakdown of costs, credits, and expenses
	// for each individual label, including:
	// 1. Entity-level totals for the entire period (cost, credits, expense)
	// 2. Time series data broken down by the specified aggregation period (day/week/month/quarter/year)
	// This represents the second and third levels in the overall three-level response structure.
	EntitiesData  []*LabelUsageReportEntityData `protobuf:"bytes,5,rep,name=entities_data,json=entitiesData,proto3" json:"entities_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LabelKeyUsageReportResponse) Reset() {
	*x = LabelKeyUsageReportResponse{}
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelKeyUsageReportResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelKeyUsageReportResponse) ProtoMessage() {}

func (x *LabelKeyUsageReportResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LabelKeyUsageReportResponse.ProtoReflect.Descriptor instead.
func (*LabelKeyUsageReportResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP(), []int{7}
}

func (x *LabelKeyUsageReportResponse) GetCurrency() Currency {
	if x != nil {
		return x.Currency
	}
	return Currency_CURRENCY_UNSPECIFIED
}

func (x *LabelKeyUsageReportResponse) GetCost() *StringDecimal {
	if x != nil {
		return x.Cost
	}
	return nil
}

func (x *LabelKeyUsageReportResponse) GetCreditDetails() *CreditDetails {
	if x != nil {
		return x.CreditDetails
	}
	return nil
}

func (x *LabelKeyUsageReportResponse) GetExpense() *StringDecimal {
	if x != nil {
		return x.Expense
	}
	return nil
}

func (x *LabelKeyUsageReportResponse) GetEntitiesData() []*LabelUsageReportEntityData {
	if x != nil {
		return x.EntitiesData
	}
	return nil
}

var File_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDesc = "" +
	"\n" +
	"Dyandex/cloud/billing/usage_records/v1/consumption_core_service.proto\x12%yandex.cloud.billing.usage_records.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a9yandex/cloud/billing/usage_records/v1/billing_types.proto\x1a8yandex/cloud/billing/usage_records/v1/common_types.proto\x1a2yandex/cloud/billing/usage_records/v1/credit.proto\x1a<yandex/cloud/billing/usage_records/v1/consumption_core.proto\x1a\x1dyandex/cloud/validation.proto\"\x8f\x05\n" +
	"\x12UsageReportRequest\x122\n" +
	"\x12billing_account_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x10billingAccountId\x12?\n" +
	"\n" +
	"start_date\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampB\x04\xe8\xc71\x01R\tstartDate\x12;\n" +
	"\bend_date\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampB\x04\xe8\xc71\x01R\aendDate\x12\x1b\n" +
	"\tcloud_ids\x18\x04 \x03(\tR\bcloudIds\x12\x1d\n" +
	"\n" +
	"folder_ids\x18\x05 \x03(\tR\tfolderIds\x12\x1f\n" +
	"\vservice_ids\x18\x06 \x03(\tR\n" +
	"serviceIds\x12\x17\n" +
	"\asku_ids\x18\a \x03(\tR\x06skuIds\x12]\n" +
	"\x06labels\x18\b \x03(\v2E.yandex.cloud.billing.usage_records.v1.UsageReportRequest.LabelsEntryR\x06labels\x12!\n" +
	"\fresource_ids\x18\t \x03(\tR\vresourceIds\x12b\n" +
	"\x12aggregation_period\x18\n" +
	" \x01(\x0e23.yandex.cloud.billing.usage_records.v1.TimeGroupingR\x11aggregationPeriod\x1ak\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12F\n" +
	"\x05value\x18\x02 \x01(\v20.yandex.cloud.billing.usage_records.v1.LabelListR\x05value:\x028\x01\"\xd8\x03\n" +
	"!BillingAccountUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12o\n" +
	"\rentities_data\x18\x05 \x03(\v2J.yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportEntityDataR\fentitiesData\"\xc6\x03\n" +
	"\x18CloudUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12f\n" +
	"\rentities_data\x18\x05 \x03(\v2A.yandex.cloud.billing.usage_records.v1.CloudUsageReportEntityDataR\fentitiesData\"\xc8\x03\n" +
	"\x19FolderUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12g\n" +
	"\rentities_data\x18\x05 \x03(\v2B.yandex.cloud.billing.usage_records.v1.FolderUsageReportEntityDataR\fentitiesData\"\xca\x03\n" +
	"\x1aServiceUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12h\n" +
	"\rentities_data\x18\x05 \x03(\v2C.yandex.cloud.billing.usage_records.v1.ServiceUsageReportEntityDataR\fentitiesData\"\xc2\x03\n" +
	"\x16SKUUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12d\n" +
	"\rentities_data\x18\x05 \x03(\v2?.yandex.cloud.billing.usage_records.v1.SKUUsageReportEntityDataR\fentitiesData\"\xcc\x03\n" +
	"\x1bResourceUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12i\n" +
	"\rentities_data\x18\x05 \x03(\v2D.yandex.cloud.billing.usage_records.v1.ResourceUsageReportEntityDataR\fentitiesData\"\xc9\x03\n" +
	"\x1bLabelKeyUsageReportResponse\x12K\n" +
	"\bcurrency\x18\x01 \x01(\x0e2/.yandex.cloud.billing.usage_records.v1.CurrencyR\bcurrency\x12H\n" +
	"\x04cost\x18\x02 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\x04cost\x12[\n" +
	"\x0ecredit_details\x18\x03 \x01(\v24.yandex.cloud.billing.usage_records.v1.CreditDetailsR\rcreditDetails\x12N\n" +
	"\aexpense\x18\x04 \x01(\v24.yandex.cloud.billing.usage_records.v1.StringDecimalR\aexpense\x12f\n" +
	"\rentities_data\x18\x05 \x03(\v2A.yandex.cloud.billing.usage_records.v1.LabelUsageReportEntityDataR\fentitiesData2\xc4\b\n" +
	"\x16ConsumptionCoreService\x12\xa3\x01\n" +
	"\x1cGetBillingAccountUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1aH.yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse\x12\x91\x01\n" +
	"\x13GetCloudUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1a?.yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse\x12\x93\x01\n" +
	"\x14GetFolderUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1a@.yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse\x12\x95\x01\n" +
	"\x15GetServiceUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1aA.yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse\x12\x8d\x01\n" +
	"\x11GetSKUUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1a=.yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse\x12\x97\x01\n" +
	"\x16GetResourceUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1aB.yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse\x12\x97\x01\n" +
	"\x16GetLabelKeyUsageReport\x129.yandex.cloud.billing.usage_records.v1.UsageReportRequest\x1aB.yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponseB\x83\x01\n" +
	")yandex.cloud.api.billing.usage_records.v1ZVgithub.com/yandex-cloud/go-genproto/yandex/cloud/billing/usage_records/v1;usageRecordsb\x06proto3"

var (
	file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescData []byte
)

func file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDesc), len(file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDesc)))
	})
	return file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDescData
}

var file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_goTypes = []any{
	(*UsageReportRequest)(nil),                  // 0: yandex.cloud.billing.usage_records.v1.UsageReportRequest
	(*BillingAccountUsageReportResponse)(nil),   // 1: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse
	(*CloudUsageReportResponse)(nil),            // 2: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse
	(*FolderUsageReportResponse)(nil),           // 3: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse
	(*ServiceUsageReportResponse)(nil),          // 4: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse
	(*SKUUsageReportResponse)(nil),              // 5: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse
	(*ResourceUsageReportResponse)(nil),         // 6: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse
	(*LabelKeyUsageReportResponse)(nil),         // 7: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse
	nil,                                         // 8: yandex.cloud.billing.usage_records.v1.UsageReportRequest.LabelsEntry
	(*timestamppb.Timestamp)(nil),               // 9: google.protobuf.Timestamp
	(TimeGrouping)(0),                           // 10: yandex.cloud.billing.usage_records.v1.TimeGrouping
	(Currency)(0),                               // 11: yandex.cloud.billing.usage_records.v1.Currency
	(*StringDecimal)(nil),                       // 12: yandex.cloud.billing.usage_records.v1.StringDecimal
	(*CreditDetails)(nil),                       // 13: yandex.cloud.billing.usage_records.v1.CreditDetails
	(*BillingAccountUsageReportEntityData)(nil), // 14: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportEntityData
	(*CloudUsageReportEntityData)(nil),          // 15: yandex.cloud.billing.usage_records.v1.CloudUsageReportEntityData
	(*FolderUsageReportEntityData)(nil),         // 16: yandex.cloud.billing.usage_records.v1.FolderUsageReportEntityData
	(*ServiceUsageReportEntityData)(nil),        // 17: yandex.cloud.billing.usage_records.v1.ServiceUsageReportEntityData
	(*SKUUsageReportEntityData)(nil),            // 18: yandex.cloud.billing.usage_records.v1.SKUUsageReportEntityData
	(*ResourceUsageReportEntityData)(nil),       // 19: yandex.cloud.billing.usage_records.v1.ResourceUsageReportEntityData
	(*LabelUsageReportEntityData)(nil),          // 20: yandex.cloud.billing.usage_records.v1.LabelUsageReportEntityData
	(*LabelList)(nil),                           // 21: yandex.cloud.billing.usage_records.v1.LabelList
}
var file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_depIdxs = []int32{
	9,  // 0: yandex.cloud.billing.usage_records.v1.UsageReportRequest.start_date:type_name -> google.protobuf.Timestamp
	9,  // 1: yandex.cloud.billing.usage_records.v1.UsageReportRequest.end_date:type_name -> google.protobuf.Timestamp
	8,  // 2: yandex.cloud.billing.usage_records.v1.UsageReportRequest.labels:type_name -> yandex.cloud.billing.usage_records.v1.UsageReportRequest.LabelsEntry
	10, // 3: yandex.cloud.billing.usage_records.v1.UsageReportRequest.aggregation_period:type_name -> yandex.cloud.billing.usage_records.v1.TimeGrouping
	11, // 4: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 5: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 6: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 7: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	14, // 8: yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportEntityData
	11, // 9: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 10: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 11: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 12: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	15, // 13: yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.CloudUsageReportEntityData
	11, // 14: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 15: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 16: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 17: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	16, // 18: yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.FolderUsageReportEntityData
	11, // 19: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 20: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 21: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 22: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	17, // 23: yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.ServiceUsageReportEntityData
	11, // 24: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 25: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 26: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 27: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	18, // 28: yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.SKUUsageReportEntityData
	11, // 29: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 30: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 31: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 32: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	19, // 33: yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.ResourceUsageReportEntityData
	11, // 34: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse.currency:type_name -> yandex.cloud.billing.usage_records.v1.Currency
	12, // 35: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse.cost:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	13, // 36: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse.credit_details:type_name -> yandex.cloud.billing.usage_records.v1.CreditDetails
	12, // 37: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse.expense:type_name -> yandex.cloud.billing.usage_records.v1.StringDecimal
	20, // 38: yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse.entities_data:type_name -> yandex.cloud.billing.usage_records.v1.LabelUsageReportEntityData
	21, // 39: yandex.cloud.billing.usage_records.v1.UsageReportRequest.LabelsEntry.value:type_name -> yandex.cloud.billing.usage_records.v1.LabelList
	0,  // 40: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetBillingAccountUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 41: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetCloudUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 42: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetFolderUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 43: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetServiceUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 44: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetSKUUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 45: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetResourceUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	0,  // 46: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetLabelKeyUsageReport:input_type -> yandex.cloud.billing.usage_records.v1.UsageReportRequest
	1,  // 47: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetBillingAccountUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.BillingAccountUsageReportResponse
	2,  // 48: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetCloudUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.CloudUsageReportResponse
	3,  // 49: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetFolderUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.FolderUsageReportResponse
	4,  // 50: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetServiceUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.ServiceUsageReportResponse
	5,  // 51: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetSKUUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.SKUUsageReportResponse
	6,  // 52: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetResourceUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.ResourceUsageReportResponse
	7,  // 53: yandex.cloud.billing.usage_records.v1.ConsumptionCoreService.GetLabelKeyUsageReport:output_type -> yandex.cloud.billing.usage_records.v1.LabelKeyUsageReportResponse
	47, // [47:54] is the sub-list for method output_type
	40, // [40:47] is the sub-list for method input_type
	40, // [40:40] is the sub-list for extension type_name
	40, // [40:40] is the sub-list for extension extendee
	0,  // [0:40] is the sub-list for field type_name
}

func init() { file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_init() }
func file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_init() {
	if File_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto != nil {
		return
	}
	file_yandex_cloud_billing_usage_records_v1_billing_types_proto_init()
	file_yandex_cloud_billing_usage_records_v1_common_types_proto_init()
	file_yandex_cloud_billing_usage_records_v1_credit_proto_init()
	file_yandex_cloud_billing_usage_records_v1_consumption_core_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDesc), len(file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto = out.File
	file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_goTypes = nil
	file_yandex_cloud_billing_usage_records_v1_consumption_core_service_proto_depIdxs = nil
}
