// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/apploadbalancer/v1/load_balancer.proto

package apploadbalancer

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LoadBalancer_Status int32

const (
	LoadBalancer_STATUS_UNSPECIFIED LoadBalancer_Status = 0
	// The application load balancer is being created.
	LoadBalancer_CREATING LoadBalancer_Status = 1
	// The application load balancer is being started.
	LoadBalancer_STARTING LoadBalancer_Status = 2
	// The application load balancer is active and sends traffic to the targets.
	LoadBalancer_ACTIVE LoadBalancer_Status = 3
	// The application load balancer is being stopped.
	LoadBalancer_STOPPING LoadBalancer_Status = 4
	// The application load balancer is stopped and doesn't send traffic to the targets.
	LoadBalancer_STOPPED LoadBalancer_Status = 5
	// The application load balancer is being deleted.
	LoadBalancer_DELETING LoadBalancer_Status = 6
)

// Enum value maps for LoadBalancer_Status.
var (
	LoadBalancer_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "CREATING",
		2: "STARTING",
		3: "ACTIVE",
		4: "STOPPING",
		5: "STOPPED",
		6: "DELETING",
	}
	LoadBalancer_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"CREATING":           1,
		"STARTING":           2,
		"ACTIVE":             3,
		"STOPPING":           4,
		"STOPPED":            5,
		"DELETING":           6,
	}
)

func (x LoadBalancer_Status) Enum() *LoadBalancer_Status {
	p := new(LoadBalancer_Status)
	*p = x
	return p
}

func (x LoadBalancer_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LoadBalancer_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[0].Descriptor()
}

func (LoadBalancer_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[0]
}

func (x LoadBalancer_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LoadBalancer_Status.Descriptor instead.
func (LoadBalancer_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{0, 0}
}

// Supported target statuses.
type TargetState_Status int32

const (
	TargetState_STATUS_UNSPECIFIED TargetState_Status = 0
	// All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] are passed
	// (the number depends on the [HealthCheck.healthy_threshold] setting) and the target is ready to receive traffic.
	TargetState_HEALTHY TargetState_Status = 1
	// Some of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
	// (the number depends on the [HealthCheck.unhealthy_threshold] setting).
	// The target is ready to receive traffic from the load balancer nodes which, based on their health checks,
	// consider the target healthy.
	TargetState_PARTIALLY_HEALTHY TargetState_Status = 2
	// All of the health checks specified in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks] failed
	// (the number depends on the [HealthCheck.unhealthy_threshold] setting) and the target is not receiving traffic.
	TargetState_UNHEALTHY TargetState_Status = 3
	// Target is being deleted and the application load balancer is no longer sending traffic to this target.
	TargetState_DRAINING TargetState_Status = 4
	TargetState_TIMEOUT  TargetState_Status = 5
)

// Enum value maps for TargetState_Status.
var (
	TargetState_Status_name = map[int32]string{
		0: "STATUS_UNSPECIFIED",
		1: "HEALTHY",
		2: "PARTIALLY_HEALTHY",
		3: "UNHEALTHY",
		4: "DRAINING",
		5: "TIMEOUT",
	}
	TargetState_Status_value = map[string]int32{
		"STATUS_UNSPECIFIED": 0,
		"HEALTHY":            1,
		"PARTIALLY_HEALTHY":  2,
		"UNHEALTHY":          3,
		"DRAINING":           4,
		"TIMEOUT":            5,
	}
)

func (x TargetState_Status) Enum() *TargetState_Status {
	p := new(TargetState_Status)
	*p = x
	return p
}

func (x TargetState_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TargetState_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[1].Descriptor()
}

func (TargetState_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes[1]
}

func (x TargetState_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TargetState_Status.Descriptor instead.
func (TargetState_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 0}
}

// An application load balancer resource.
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer).
type LoadBalancer struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the application load balancer. Generated at creation time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the application load balancer. The name is unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the application load balancer.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// ID of the folder that the application load balancer belongs to.
	FolderId string `protobuf:"bytes,4,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Application load balancer labels as `key:value` pairs.
	// For details about the concept, see [documentation](/docs/overview/concepts/services#labels).
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Status of the application load balancer.
	Status LoadBalancer_Status `protobuf:"varint,6,opt,name=status,proto3,enum=yandex.cloud.apploadbalancer.v1.LoadBalancer_Status" json:"status,omitempty"`
	// ID of the region that the application load balancer is located at.
	RegionId string `protobuf:"bytes,7,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	// ID of the network that the application load balancer belongs to.
	NetworkId string `protobuf:"bytes,8,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Listeners that belong to the application load balancer.
	//
	// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
	Listeners []*Listener `protobuf:"bytes,9,rep,name=listeners,proto3" json:"listeners,omitempty"`
	// Locality settings of the application load balancer.
	//
	// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
	AllocationPolicy *AllocationPolicy `protobuf:"bytes,10,opt,name=allocation_policy,json=allocationPolicy,proto3" json:"allocation_policy,omitempty"`
	// ID of the log group that stores access logs of the application load balancer.
	//
	// The logs can be accessed using a Cloud Functions [trigger for Cloud Logs](/docs/functions/operations/trigger/cloud-logging-trigger-create).
	LogGroupId string `protobuf:"bytes,11,opt,name=log_group_id,json=logGroupId,proto3" json:"log_group_id,omitempty"`
	// ID's of the security groups attributed to the application load balancer.
	//
	// For details about the concept,
	// see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#security-groups).
	SecurityGroupIds []string `protobuf:"bytes,12,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Creation timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Scaling settings of the application load balancer.
	//
	// The scaling settings relate to a special internal instance group which facilitates the balancer's work.
	// Instances in this group are called _resource units_. The group is scaled automatically based on incoming load
	// and within limitations specified in these settings.
	//
	// For details about the concept,
	// see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lcu-scaling).
	AutoScalePolicy *AutoScalePolicy `protobuf:"bytes,14,opt,name=auto_scale_policy,json=autoScalePolicy,proto3" json:"auto_scale_policy,omitempty"`
	// Cloud logging settings of the application load balancer.
	LogOptions *LogOptions `protobuf:"bytes,15,opt,name=log_options,json=logOptions,proto3" json:"log_options,omitempty"`
	// Specifies whether application load balancer is available to zonal shift.
	AllowZonalShift bool `protobuf:"varint,16,opt,name=allow_zonal_shift,json=allowZonalShift,proto3" json:"allow_zonal_shift,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LoadBalancer) Reset() {
	*x = LoadBalancer{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadBalancer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadBalancer) ProtoMessage() {}

func (x *LoadBalancer) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadBalancer.ProtoReflect.Descriptor instead.
func (*LoadBalancer) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{0}
}

func (x *LoadBalancer) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *LoadBalancer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LoadBalancer) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LoadBalancer) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *LoadBalancer) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LoadBalancer) GetStatus() LoadBalancer_Status {
	if x != nil {
		return x.Status
	}
	return LoadBalancer_STATUS_UNSPECIFIED
}

func (x *LoadBalancer) GetRegionId() string {
	if x != nil {
		return x.RegionId
	}
	return ""
}

func (x *LoadBalancer) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *LoadBalancer) GetListeners() []*Listener {
	if x != nil {
		return x.Listeners
	}
	return nil
}

func (x *LoadBalancer) GetAllocationPolicy() *AllocationPolicy {
	if x != nil {
		return x.AllocationPolicy
	}
	return nil
}

func (x *LoadBalancer) GetLogGroupId() string {
	if x != nil {
		return x.LogGroupId
	}
	return ""
}

func (x *LoadBalancer) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *LoadBalancer) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *LoadBalancer) GetAutoScalePolicy() *AutoScalePolicy {
	if x != nil {
		return x.AutoScalePolicy
	}
	return nil
}

func (x *LoadBalancer) GetLogOptions() *LogOptions {
	if x != nil {
		return x.LogOptions
	}
	return nil
}

func (x *LoadBalancer) GetAllowZonalShift() bool {
	if x != nil {
		return x.AllowZonalShift
	}
	return false
}

// An endpoint address resource.
type Address struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Endpoint address of one of the types: public (external) IPv4 address, internal IPv4 address, public IPv6 address.
	//
	// Types that are valid to be assigned to Address:
	//
	//	*Address_ExternalIpv4Address
	//	*Address_InternalIpv4Address
	//	*Address_ExternalIpv6Address
	Address       isAddress_Address `protobuf_oneof:"address"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{1}
}

func (x *Address) GetAddress() isAddress_Address {
	if x != nil {
		return x.Address
	}
	return nil
}

func (x *Address) GetExternalIpv4Address() *ExternalIpv4Address {
	if x != nil {
		if x, ok := x.Address.(*Address_ExternalIpv4Address); ok {
			return x.ExternalIpv4Address
		}
	}
	return nil
}

func (x *Address) GetInternalIpv4Address() *InternalIpv4Address {
	if x != nil {
		if x, ok := x.Address.(*Address_InternalIpv4Address); ok {
			return x.InternalIpv4Address
		}
	}
	return nil
}

func (x *Address) GetExternalIpv6Address() *ExternalIpv6Address {
	if x != nil {
		if x, ok := x.Address.(*Address_ExternalIpv6Address); ok {
			return x.ExternalIpv6Address
		}
	}
	return nil
}

type isAddress_Address interface {
	isAddress_Address()
}

type Address_ExternalIpv4Address struct {
	// Public IPv4 endpoint address.
	ExternalIpv4Address *ExternalIpv4Address `protobuf:"bytes,1,opt,name=external_ipv4_address,json=externalIpv4Address,proto3,oneof"`
}

type Address_InternalIpv4Address struct {
	// Internal IPv4 endpoint address.
	//
	// To enable the use of listeners with internal addresses, [contact support](/docs/support/overview#response-time).
	InternalIpv4Address *InternalIpv4Address `protobuf:"bytes,2,opt,name=internal_ipv4_address,json=internalIpv4Address,proto3,oneof"`
}

type Address_ExternalIpv6Address struct {
	// Public IPv6 endpoint address.
	ExternalIpv6Address *ExternalIpv6Address `protobuf:"bytes,3,opt,name=external_ipv6_address,json=externalIpv6Address,proto3,oneof"`
}

func (*Address_ExternalIpv4Address) isAddress_Address() {}

func (*Address_InternalIpv4Address) isAddress_Address() {}

func (*Address_ExternalIpv6Address) isAddress_Address() {}

// A public (external) IPv4 endpoint address resource.
type ExternalIpv4Address struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IPv4 address.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExternalIpv4Address) Reset() {
	*x = ExternalIpv4Address{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalIpv4Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalIpv4Address) ProtoMessage() {}

func (x *ExternalIpv4Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalIpv4Address.ProtoReflect.Descriptor instead.
func (*ExternalIpv4Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{2}
}

func (x *ExternalIpv4Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// An internal IPv4 endpoint address resource.
type InternalIpv4Address struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IPv4 address.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// ID of the subnet that the address belongs to.
	SubnetId      string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InternalIpv4Address) Reset() {
	*x = InternalIpv4Address{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InternalIpv4Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InternalIpv4Address) ProtoMessage() {}

func (x *InternalIpv4Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InternalIpv4Address.ProtoReflect.Descriptor instead.
func (*InternalIpv4Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{3}
}

func (x *InternalIpv4Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *InternalIpv4Address) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

// A public (external) IPv4 endpoint address resource.
type ExternalIpv6Address struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// IPv6 address.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExternalIpv6Address) Reset() {
	*x = ExternalIpv6Address{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExternalIpv6Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExternalIpv6Address) ProtoMessage() {}

func (x *ExternalIpv6Address) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExternalIpv6Address.ProtoReflect.Descriptor instead.
func (*ExternalIpv6Address) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{4}
}

func (x *ExternalIpv6Address) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// An application load balancer location resource.
//
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#lb-location).
type Location struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the availability zone where the application load balancer resides.
	//
	// Each availability zone can only be specified once.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the application load balancer belongs to.
	SubnetId string `protobuf:"bytes,2,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Disables the load balancer node in the specified availability zone.
	//
	// Backends in the availability zone are not directly affected by this setting.
	// They still may receive traffic from the load balancer nodes in other availability zones,
	// subject to [LoadBalancingConfig.locality_aware_routing_percent] and [LoadBalancingConfig.strict_locality] settings.
	DisableTraffic bool `protobuf:"varint,3,opt,name=disable_traffic,json=disableTraffic,proto3" json:"disable_traffic,omitempty"`
	// Show zonal shift status for the location.
	// Deprecated: use [zonal_traffic_disabled] below to track traffic status.
	//
	// Deprecated: Marked as deprecated in yandex/cloud/apploadbalancer/v1/load_balancer.proto.
	ZonalShiftActive bool `protobuf:"varint,4,opt,name=zonal_shift_active,json=zonalShiftActive,proto3" json:"zonal_shift_active,omitempty"`
	// Computed field: will be set to true if all traffic in zone is disabled
	// either manually by user or automatically by Cloud infrastructure.
	ZonalTrafficDisabled bool `protobuf:"varint,5,opt,name=zonal_traffic_disabled,json=zonalTrafficDisabled,proto3" json:"zonal_traffic_disabled,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Location) Reset() {
	*x = Location{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Location) ProtoMessage() {}

func (x *Location) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Location.ProtoReflect.Descriptor instead.
func (*Location) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{5}
}

func (x *Location) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *Location) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *Location) GetDisableTraffic() bool {
	if x != nil {
		return x.DisableTraffic
	}
	return false
}

// Deprecated: Marked as deprecated in yandex/cloud/apploadbalancer/v1/load_balancer.proto.
func (x *Location) GetZonalShiftActive() bool {
	if x != nil {
		return x.ZonalShiftActive
	}
	return false
}

func (x *Location) GetZonalTrafficDisabled() bool {
	if x != nil {
		return x.ZonalTrafficDisabled
	}
	return false
}

// A locality settings (allocation policy) resource.
type AllocationPolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Availability zones and subnets that the application load balancer resides.
	Locations     []*Location `protobuf:"bytes,1,rep,name=locations,proto3" json:"locations,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllocationPolicy) Reset() {
	*x = AllocationPolicy{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocationPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocationPolicy) ProtoMessage() {}

func (x *AllocationPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocationPolicy.ProtoReflect.Descriptor instead.
func (*AllocationPolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{6}
}

func (x *AllocationPolicy) GetLocations() []*Location {
	if x != nil {
		return x.Locations
	}
	return nil
}

// A listener resource.
//
// For details about the concept, see [documentation](/docs/application-load-balancer/concepts/application-load-balancer#listener).
type Listener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the listener. The name is unique within the application load balancer.
	// The string length in characters is 3-63.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Endpoints of the listener.
	//
	// Endpoints are defined by their IP addresses and ports.
	Endpoints []*Endpoint `protobuf:"bytes,2,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Listener type and settings.
	//
	// Types that are valid to be assigned to Listener:
	//
	//	*Listener_Http
	//	*Listener_Tls
	//	*Listener_Stream
	Listener      isListener_Listener `protobuf_oneof:"listener"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Listener) Reset() {
	*x = Listener{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Listener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener) ProtoMessage() {}

func (x *Listener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener.ProtoReflect.Descriptor instead.
func (*Listener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{7}
}

func (x *Listener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener) GetEndpoints() []*Endpoint {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *Listener) GetListener() isListener_Listener {
	if x != nil {
		return x.Listener
	}
	return nil
}

func (x *Listener) GetHttp() *HttpListener {
	if x != nil {
		if x, ok := x.Listener.(*Listener_Http); ok {
			return x.Http
		}
	}
	return nil
}

func (x *Listener) GetTls() *TlsListener {
	if x != nil {
		if x, ok := x.Listener.(*Listener_Tls); ok {
			return x.Tls
		}
	}
	return nil
}

func (x *Listener) GetStream() *StreamListener {
	if x != nil {
		if x, ok := x.Listener.(*Listener_Stream); ok {
			return x.Stream
		}
	}
	return nil
}

type isListener_Listener interface {
	isListener_Listener()
}

type Listener_Http struct {
	// Unencrypted HTTP listener settings.
	Http *HttpListener `protobuf:"bytes,3,opt,name=http,proto3,oneof"`
}

type Listener_Tls struct {
	// TLS-encrypted HTTP or TCP stream listener settings.
	//
	// All handlers within a listener ([TlsListener.default_handler] and [TlsListener.sni_handlers]) must be of one
	// type, [HttpHandler] or [StreamHandler]. Mixing HTTP and TCP stream traffic in a TLS-encrypted listener is not
	// supported.
	Tls *TlsListener `protobuf:"bytes,4,opt,name=tls,proto3,oneof"`
}

type Listener_Stream struct {
	// Unencrypted stream (TCP) listener settings.
	Stream *StreamListener `protobuf:"bytes,5,opt,name=stream,proto3,oneof"`
}

func (*Listener_Http) isListener_Listener() {}

func (*Listener_Tls) isListener_Listener() {}

func (*Listener_Stream) isListener_Listener() {}

// An endpoint resource.
type Endpoint struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Endpoint public (external) and internal addresses.
	Addresses []*Address `protobuf:"bytes,1,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Endpoint ports.
	Ports         []int64 `protobuf:"varint,2,rep,packed,name=ports,proto3" json:"ports,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Endpoint) Reset() {
	*x = Endpoint{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Endpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoint) ProtoMessage() {}

func (x *Endpoint) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoint.ProtoReflect.Descriptor instead.
func (*Endpoint) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{8}
}

func (x *Endpoint) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

func (x *Endpoint) GetPorts() []int64 {
	if x != nil {
		return x.Ports
	}
	return nil
}

// An HTTP listener resource.
type HttpListener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings for handling HTTP requests.
	//
	// Only one of `handler` and [redirects] can be specified.
	Handler *HttpHandler `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
	// Redirects settings.
	//
	// Only one of `redirects` and [handler] can be specified.
	Redirects     *Redirects `protobuf:"bytes,2,opt,name=redirects,proto3" json:"redirects,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HttpListener) Reset() {
	*x = HttpListener{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpListener) ProtoMessage() {}

func (x *HttpListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpListener.ProtoReflect.Descriptor instead.
func (*HttpListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{9}
}

func (x *HttpListener) GetHandler() *HttpHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

func (x *HttpListener) GetRedirects() *Redirects {
	if x != nil {
		return x.Redirects
	}
	return nil
}

// TLS-encrypted (HTTP or TCP stream) listener resource.
type TlsListener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings for handling requests by default, with Server Name
	// Indication (SNI) not matching any of the [sni_handlers].
	DefaultHandler *TlsHandler `protobuf:"bytes,1,opt,name=default_handler,json=defaultHandler,proto3" json:"default_handler,omitempty"`
	// Settings for handling requests with Server Name Indication (SNI)
	// matching one of [SniMatch.server_names] values.
	SniHandlers   []*SniMatch `protobuf:"bytes,2,rep,name=sni_handlers,json=sniHandlers,proto3" json:"sni_handlers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TlsListener) Reset() {
	*x = TlsListener{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TlsListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsListener) ProtoMessage() {}

func (x *TlsListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsListener.ProtoReflect.Descriptor instead.
func (*TlsListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{10}
}

func (x *TlsListener) GetDefaultHandler() *TlsHandler {
	if x != nil {
		return x.DefaultHandler
	}
	return nil
}

func (x *TlsListener) GetSniHandlers() []*SniMatch {
	if x != nil {
		return x.SniHandlers
	}
	return nil
}

// A stream (TCP) listener resource.
type StreamListener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings for handling stream (TCP) requests.
	Handler       *StreamHandler `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StreamListener) Reset() {
	*x = StreamListener{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamListener) ProtoMessage() {}

func (x *StreamListener) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamListener.ProtoReflect.Descriptor instead.
func (*StreamListener) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{11}
}

func (x *StreamListener) GetHandler() *StreamHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

// An HTTP/2 options resource.
type Http2Options struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Maximum number of concurrent HTTP/2 streams in a connection.
	MaxConcurrentStreams int64 `protobuf:"varint,1,opt,name=max_concurrent_streams,json=maxConcurrentStreams,proto3" json:"max_concurrent_streams,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Http2Options) Reset() {
	*x = Http2Options{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Http2Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Http2Options) ProtoMessage() {}

func (x *Http2Options) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Http2Options.ProtoReflect.Descriptor instead.
func (*Http2Options) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{12}
}

func (x *Http2Options) GetMaxConcurrentStreams() int64 {
	if x != nil {
		return x.MaxConcurrentStreams
	}
	return 0
}

// A stream (TCP) handler resource.
type StreamHandler struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the backend group processing requests. For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/backend-group).
	//
	// The backend group type, specified via [BackendGroup.backend], must be `stream`.
	//
	// To get the list of all available backend groups, make a [BackendGroupService.List] request.
	BackendGroupId string `protobuf:"bytes,1,opt,name=backend_group_id,json=backendGroupId,proto3" json:"backend_group_id,omitempty"`
	// The idle timeout is duration during which no data is transmitted or received on either the upstream or downstream connection.
	// If not configured, the default idle timeout is 1 hour. Setting it to 0 disables the timeout.
	IdleTimeout   *durationpb.Duration `protobuf:"bytes,2,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StreamHandler) Reset() {
	*x = StreamHandler{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamHandler) ProtoMessage() {}

func (x *StreamHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamHandler.ProtoReflect.Descriptor instead.
func (*StreamHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{13}
}

func (x *StreamHandler) GetBackendGroupId() string {
	if x != nil {
		return x.BackendGroupId
	}
	return ""
}

func (x *StreamHandler) GetIdleTimeout() *durationpb.Duration {
	if x != nil {
		return x.IdleTimeout
	}
	return nil
}

// An HTTP handler resource.
type HttpHandler struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the HTTP router processing requests. For details about the concept, see
	// [documentation](/docs/application-load-balancer/concepts/http-router).
	//
	// To get the list of all available HTTP routers, make a [HttpRouterService.List] request.
	HttpRouterId string `protobuf:"bytes,1,opt,name=http_router_id,json=httpRouterId,proto3" json:"http_router_id,omitempty"`
	// Protocol settings.
	//
	// For HTTPS (HTTP over TLS) connections, settings are applied to the protocol
	// negotiated using TLS [ALPN](https://en.wikipedia.org/wiki/Application-Layer_Protocol_Negotiation) extension.
	//
	// Types that are valid to be assigned to ProtocolSettings:
	//
	//	*HttpHandler_Http2Options
	//	*HttpHandler_AllowHttp10
	ProtocolSettings isHttpHandler_ProtocolSettings `protobuf_oneof:"protocol_settings"`
	// When unset, will preserve the incoming x-request-id header, otherwise would rewrite it with a new value.
	RewriteRequestId bool `protobuf:"varint,4,opt,name=rewrite_request_id,json=rewriteRequestId,proto3" json:"rewrite_request_id,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *HttpHandler) Reset() {
	*x = HttpHandler{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpHandler) ProtoMessage() {}

func (x *HttpHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpHandler.ProtoReflect.Descriptor instead.
func (*HttpHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{14}
}

func (x *HttpHandler) GetHttpRouterId() string {
	if x != nil {
		return x.HttpRouterId
	}
	return ""
}

func (x *HttpHandler) GetProtocolSettings() isHttpHandler_ProtocolSettings {
	if x != nil {
		return x.ProtocolSettings
	}
	return nil
}

func (x *HttpHandler) GetHttp2Options() *Http2Options {
	if x != nil {
		if x, ok := x.ProtocolSettings.(*HttpHandler_Http2Options); ok {
			return x.Http2Options
		}
	}
	return nil
}

func (x *HttpHandler) GetAllowHttp10() bool {
	if x != nil {
		if x, ok := x.ProtocolSettings.(*HttpHandler_AllowHttp10); ok {
			return x.AllowHttp10
		}
	}
	return false
}

func (x *HttpHandler) GetRewriteRequestId() bool {
	if x != nil {
		return x.RewriteRequestId
	}
	return false
}

type isHttpHandler_ProtocolSettings interface {
	isHttpHandler_ProtocolSettings()
}

type HttpHandler_Http2Options struct {
	// HTTP/2 settings.
	//
	// If specified, incoming HTTP/2 requests are supported by the listener.
	Http2Options *Http2Options `protobuf:"bytes,2,opt,name=http2_options,json=http2Options,proto3,oneof"`
}

type HttpHandler_AllowHttp10 struct {
	// Enables support for incoming HTTP/1.0 and HTTP/1.1 requests and disables it for HTTP/2 requests.
	AllowHttp10 bool `protobuf:"varint,3,opt,name=allow_http10,json=allowHttp10,proto3,oneof"`
}

func (*HttpHandler_Http2Options) isHttpHandler_ProtocolSettings() {}

func (*HttpHandler_AllowHttp10) isHttpHandler_ProtocolSettings() {}

// A listener redirects resource.
type Redirects struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Redirects all unencrypted HTTP requests to the same URI with scheme changed to `https`.
	//
	// The setting has the same effect as a single, catch-all [HttpRoute]
	// with [RedirectAction.replace_scheme] set to `https`.
	HttpToHttps   bool `protobuf:"varint,1,opt,name=http_to_https,json=httpToHttps,proto3" json:"http_to_https,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Redirects) Reset() {
	*x = Redirects{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Redirects) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Redirects) ProtoMessage() {}

func (x *Redirects) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Redirects.ProtoReflect.Descriptor instead.
func (*Redirects) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{15}
}

func (x *Redirects) GetHttpToHttps() bool {
	if x != nil {
		return x.HttpToHttps
	}
	return false
}

// A SNI handler resource.
type SniMatch struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the SNI handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Server names that are matched by the SNI handler.
	ServerNames []string `protobuf:"bytes,2,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
	// Settings for handling requests with Server Name Indication (SNI) matching one of [server_names] values.
	Handler       *TlsHandler `protobuf:"bytes,3,opt,name=handler,proto3" json:"handler,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SniMatch) Reset() {
	*x = SniMatch{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SniMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SniMatch) ProtoMessage() {}

func (x *SniMatch) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SniMatch.ProtoReflect.Descriptor instead.
func (*SniMatch) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{16}
}

func (x *SniMatch) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SniMatch) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

func (x *SniMatch) GetHandler() *TlsHandler {
	if x != nil {
		return x.Handler
	}
	return nil
}

// A TLS-encrypted (HTTP or TCP stream) handler resource.
type TlsHandler struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Settings for handling requests.
	//
	// Types that are valid to be assigned to Handler:
	//
	//	*TlsHandler_HttpHandler
	//	*TlsHandler_StreamHandler
	Handler isTlsHandler_Handler `protobuf_oneof:"handler"`
	// ID's of the TLS server certificates from [Certificate Manager](/docs/certificate-manager/).
	//
	// RSA and ECDSA certificates are supported, and only the first certificate of each type is used.
	CertificateIds []string `protobuf:"bytes,3,rep,name=certificate_ids,json=certificateIds,proto3" json:"certificate_ids,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *TlsHandler) Reset() {
	*x = TlsHandler{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TlsHandler) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsHandler) ProtoMessage() {}

func (x *TlsHandler) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsHandler.ProtoReflect.Descriptor instead.
func (*TlsHandler) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{17}
}

func (x *TlsHandler) GetHandler() isTlsHandler_Handler {
	if x != nil {
		return x.Handler
	}
	return nil
}

func (x *TlsHandler) GetHttpHandler() *HttpHandler {
	if x != nil {
		if x, ok := x.Handler.(*TlsHandler_HttpHandler); ok {
			return x.HttpHandler
		}
	}
	return nil
}

func (x *TlsHandler) GetStreamHandler() *StreamHandler {
	if x != nil {
		if x, ok := x.Handler.(*TlsHandler_StreamHandler); ok {
			return x.StreamHandler
		}
	}
	return nil
}

func (x *TlsHandler) GetCertificateIds() []string {
	if x != nil {
		return x.CertificateIds
	}
	return nil
}

type isTlsHandler_Handler interface {
	isTlsHandler_Handler()
}

type TlsHandler_HttpHandler struct {
	// HTTP handler.
	HttpHandler *HttpHandler `protobuf:"bytes,2,opt,name=http_handler,json=httpHandler,proto3,oneof"`
}

type TlsHandler_StreamHandler struct {
	// Stream (TCP) handler.
	StreamHandler *StreamHandler `protobuf:"bytes,4,opt,name=stream_handler,json=streamHandler,proto3,oneof"`
}

func (*TlsHandler_HttpHandler) isTlsHandler_Handler() {}

func (*TlsHandler_StreamHandler) isTlsHandler_Handler() {}

// A target state resource.
type TargetState struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Health of the target, i.e. its statuses in all availability zones.
	Status *TargetState_HealthcheckStatus `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// Target.
	Target        *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TargetState) Reset() {
	*x = TargetState{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState) ProtoMessage() {}

func (x *TargetState) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState.ProtoReflect.Descriptor instead.
func (*TargetState) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18}
}

func (x *TargetState) GetStatus() *TargetState_HealthcheckStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *TargetState) GetTarget() *Target {
	if x != nil {
		return x.Target
	}
	return nil
}

// A resource for scaling settings of an application load balancer.
type AutoScalePolicy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Lower limit for the number of resource units in each availability zone.
	//
	// If not specified previously (using other instruments such as management console), the default value is 2.
	// To revert to it, specify it explicitly.
	//
	// The minimum value is 2.
	MinZoneSize int64 `protobuf:"varint,1,opt,name=min_zone_size,json=minZoneSize,proto3" json:"min_zone_size,omitempty"`
	// Upper limit for the total number of resource units across all availability zones.
	//
	// If a positive value is specified, it must be at least [min_zone_size] multiplied by the size of
	// [AllocationPolicy.locations].
	//
	// If the value is 0, there is no upper limit.
	MaxSize       int64 `protobuf:"varint,2,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutoScalePolicy) Reset() {
	*x = AutoScalePolicy{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutoScalePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoScalePolicy) ProtoMessage() {}

func (x *AutoScalePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoScalePolicy.ProtoReflect.Descriptor instead.
func (*AutoScalePolicy) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{19}
}

func (x *AutoScalePolicy) GetMinZoneSize() int64 {
	if x != nil {
		return x.MinZoneSize
	}
	return 0
}

func (x *AutoScalePolicy) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

// Health of the target.
type TargetState_HealthcheckStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Statuses of the target in its availability zones.
	ZoneStatuses  []*TargetState_ZoneHealthcheckStatus `protobuf:"bytes,1,rep,name=zone_statuses,json=zoneStatuses,proto3" json:"zone_statuses,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TargetState_HealthcheckStatus) Reset() {
	*x = TargetState_HealthcheckStatus{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetState_HealthcheckStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState_HealthcheckStatus) ProtoMessage() {}

func (x *TargetState_HealthcheckStatus) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState_HealthcheckStatus.ProtoReflect.Descriptor instead.
func (*TargetState_HealthcheckStatus) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 0}
}

func (x *TargetState_HealthcheckStatus) GetZoneStatuses() []*TargetState_ZoneHealthcheckStatus {
	if x != nil {
		return x.ZoneStatuses
	}
	return nil
}

// Health of the target in the availability zone.
type TargetState_ZoneHealthcheckStatus struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the availability zone.
	ZoneId string `protobuf:"bytes,1,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// Status of the target in the availability zone.
	Status TargetState_Status `protobuf:"varint,2,opt,name=status,proto3,enum=yandex.cloud.apploadbalancer.v1.TargetState_Status" json:"status,omitempty"`
	// Indicates whether the target has been marked `UNHEALTHY` due to failing active health checks,
	// which determine target statuses as configured in [HttpBackend.healthchecks] or [GrpcBackend.healthchecks].
	//
	// Currently the only type of health checks is active, as described above.
	// Passive health checks, which determine the health of a target based on its responses to production requests
	// (HTTP 5xx status codes, connection errors etc.), are not implemented yet.
	FailedActiveHc bool `protobuf:"varint,3,opt,name=failed_active_hc,json=failedActiveHc,proto3" json:"failed_active_hc,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *TargetState_ZoneHealthcheckStatus) Reset() {
	*x = TargetState_ZoneHealthcheckStatus{}
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetState_ZoneHealthcheckStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetState_ZoneHealthcheckStatus) ProtoMessage() {}

func (x *TargetState_ZoneHealthcheckStatus) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetState_ZoneHealthcheckStatus.ProtoReflect.Descriptor instead.
func (*TargetState_ZoneHealthcheckStatus) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP(), []int{18, 1}
}

func (x *TargetState_ZoneHealthcheckStatus) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *TargetState_ZoneHealthcheckStatus) GetStatus() TargetState_Status {
	if x != nil {
		return x.Status
	}
	return TargetState_STATUS_UNSPECIFIED
}

func (x *TargetState_ZoneHealthcheckStatus) GetFailedActiveHc() bool {
	if x != nil {
		return x.FailedActiveHc
	}
	return false
}

var File_yandex_cloud_apploadbalancer_v1_load_balancer_proto protoreflect.FileDescriptor

const file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc = "" +
	"\n" +
	"3yandex/cloud/apploadbalancer/v1/load_balancer.proto\x12\x1fyandex.cloud.apploadbalancer.v1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1dyandex/cloud/validation.proto\x1a-yandex/cloud/apploadbalancer/v1/logging.proto\x1a2yandex/cloud/apploadbalancer/v1/target_group.proto\"\x88\b\n" +
	"\fLoadBalancer\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x03 \x01(\tR\vdescription\x12\x1b\n" +
	"\tfolder_id\x18\x04 \x01(\tR\bfolderId\x12Q\n" +
	"\x06labels\x18\x05 \x03(\v29.yandex.cloud.apploadbalancer.v1.LoadBalancer.LabelsEntryR\x06labels\x12L\n" +
	"\x06status\x18\x06 \x01(\x0e24.yandex.cloud.apploadbalancer.v1.LoadBalancer.StatusR\x06status\x12\x1b\n" +
	"\tregion_id\x18\a \x01(\tR\bregionId\x12\x1d\n" +
	"\n" +
	"network_id\x18\b \x01(\tR\tnetworkId\x12G\n" +
	"\tlisteners\x18\t \x03(\v2).yandex.cloud.apploadbalancer.v1.ListenerR\tlisteners\x12^\n" +
	"\x11allocation_policy\x18\n" +
	" \x01(\v21.yandex.cloud.apploadbalancer.v1.AllocationPolicyR\x10allocationPolicy\x12 \n" +
	"\flog_group_id\x18\v \x01(\tR\n" +
	"logGroupId\x12,\n" +
	"\x12security_group_ids\x18\f \x03(\tR\x10securityGroupIds\x129\n" +
	"\n" +
	"created_at\x18\r \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12\\\n" +
	"\x11auto_scale_policy\x18\x0e \x01(\v20.yandex.cloud.apploadbalancer.v1.AutoScalePolicyR\x0fautoScalePolicy\x12L\n" +
	"\vlog_options\x18\x0f \x01(\v2+.yandex.cloud.apploadbalancer.v1.LogOptionsR\n" +
	"logOptions\x12*\n" +
	"\x11allow_zonal_shift\x18\x10 \x01(\bR\x0fallowZonalShift\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"q\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\f\n" +
	"\bSTARTING\x10\x02\x12\n" +
	"\n" +
	"\x06ACTIVE\x10\x03\x12\f\n" +
	"\bSTOPPING\x10\x04\x12\v\n" +
	"\aSTOPPED\x10\x05\x12\f\n" +
	"\bDELETING\x10\x06\"\xde\x02\n" +
	"\aAddress\x12j\n" +
	"\x15external_ipv4_address\x18\x01 \x01(\v24.yandex.cloud.apploadbalancer.v1.ExternalIpv4AddressH\x00R\x13externalIpv4Address\x12j\n" +
	"\x15internal_ipv4_address\x18\x02 \x01(\v24.yandex.cloud.apploadbalancer.v1.InternalIpv4AddressH\x00R\x13internalIpv4Address\x12j\n" +
	"\x15external_ipv6_address\x18\x03 \x01(\v24.yandex.cloud.apploadbalancer.v1.ExternalIpv6AddressH\x00R\x13externalIpv6AddressB\x0f\n" +
	"\aaddress\x12\x04\xc0\xc11\x01\"/\n" +
	"\x13ExternalIpv4Address\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"L\n" +
	"\x13InternalIpv4Address\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12\x1b\n" +
	"\tsubnet_id\x18\x02 \x01(\tR\bsubnetId\"/\n" +
	"\x13ExternalIpv6Address\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\"\xd7\x01\n" +
	"\bLocation\x12\x1d\n" +
	"\azone_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06zoneId\x12\x1b\n" +
	"\tsubnet_id\x18\x02 \x01(\tR\bsubnetId\x12'\n" +
	"\x0fdisable_traffic\x18\x03 \x01(\bR\x0edisableTraffic\x120\n" +
	"\x12zonal_shift_active\x18\x04 \x01(\bB\x02\x18\x01R\x10zonalShiftActive\x124\n" +
	"\x16zonal_traffic_disabled\x18\x05 \x01(\bR\x14zonalTrafficDisabled\"h\n" +
	"\x10AllocationPolicy\x12T\n" +
	"\tlocations\x18\x01 \x03(\v2).yandex.cloud.apploadbalancer.v1.LocationB\v\x82\xc81\x03>=1\x90\xc81\x01R\tlocations\"\xd1\x02\n" +
	"\bListener\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12G\n" +
	"\tendpoints\x18\x02 \x03(\v2).yandex.cloud.apploadbalancer.v1.EndpointR\tendpoints\x12C\n" +
	"\x04http\x18\x03 \x01(\v2-.yandex.cloud.apploadbalancer.v1.HttpListenerH\x00R\x04http\x12@\n" +
	"\x03tls\x18\x04 \x01(\v2,.yandex.cloud.apploadbalancer.v1.TlsListenerH\x00R\x03tls\x12I\n" +
	"\x06stream\x18\x05 \x01(\v2/.yandex.cloud.apploadbalancer.v1.StreamListenerH\x00R\x06streamB\x10\n" +
	"\blistener\x12\x04\xc0\xc11\x01\"\x83\x01\n" +
	"\bEndpoint\x12N\n" +
	"\taddresses\x18\x01 \x03(\v2(.yandex.cloud.apploadbalancer.v1.AddressB\x06\x82\xc81\x02>0R\taddresses\x12'\n" +
	"\x05ports\x18\x02 \x03(\x03B\x11\xfa\xc71\a1-65535\x82\xc81\x02>0R\x05ports\"\xa0\x01\n" +
	"\fHttpListener\x12F\n" +
	"\ahandler\x18\x01 \x01(\v2,.yandex.cloud.apploadbalancer.v1.HttpHandlerR\ahandler\x12H\n" +
	"\tredirects\x18\x02 \x01(\v2*.yandex.cloud.apploadbalancer.v1.RedirectsR\tredirects\"\xb7\x01\n" +
	"\vTlsListener\x12Z\n" +
	"\x0fdefault_handler\x18\x01 \x01(\v2+.yandex.cloud.apploadbalancer.v1.TlsHandlerB\x04\xe8\xc71\x01R\x0edefaultHandler\x12L\n" +
	"\fsni_handlers\x18\x02 \x03(\v2).yandex.cloud.apploadbalancer.v1.SniMatchR\vsniHandlers\"`\n" +
	"\x0eStreamListener\x12N\n" +
	"\ahandler\x18\x01 \x01(\v2..yandex.cloud.apploadbalancer.v1.StreamHandlerB\x04\xe8\xc71\x01R\ahandler\"D\n" +
	"\fHttp2Options\x124\n" +
	"\x16max_concurrent_streams\x18\x01 \x01(\x03R\x14maxConcurrentStreams\"}\n" +
	"\rStreamHandler\x12.\n" +
	"\x10backend_group_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x0ebackendGroupId\x12<\n" +
	"\fidle_timeout\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\vidleTimeout\"\xf1\x01\n" +
	"\vHttpHandler\x12$\n" +
	"\x0ehttp_router_id\x18\x01 \x01(\tR\fhttpRouterId\x12T\n" +
	"\rhttp2_options\x18\x02 \x01(\v2-.yandex.cloud.apploadbalancer.v1.Http2OptionsH\x00R\fhttp2Options\x12#\n" +
	"\fallow_http10\x18\x03 \x01(\bH\x00R\vallowHttp10\x12,\n" +
	"\x12rewrite_request_id\x18\x04 \x01(\bR\x10rewriteRequestIdB\x13\n" +
	"\x11protocol_settings\"/\n" +
	"\tRedirects\x12\"\n" +
	"\rhttp_to_https\x18\x01 \x01(\bR\vhttpToHttps\"\x9c\x01\n" +
	"\bSniMatch\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12)\n" +
	"\fserver_names\x18\x02 \x03(\tB\x06\x82\xc81\x02>0R\vserverNames\x12K\n" +
	"\ahandler\x18\x03 \x01(\v2+.yandex.cloud.apploadbalancer.v1.TlsHandlerB\x04\xe8\xc71\x01R\ahandler\"\xfa\x01\n" +
	"\n" +
	"TlsHandler\x12Q\n" +
	"\fhttp_handler\x18\x02 \x01(\v2,.yandex.cloud.apploadbalancer.v1.HttpHandlerH\x00R\vhttpHandler\x12W\n" +
	"\x0estream_handler\x18\x04 \x01(\v2..yandex.cloud.apploadbalancer.v1.StreamHandlerH\x00R\rstreamHandler\x12/\n" +
	"\x0fcertificate_ids\x18\x03 \x03(\tB\x06\x82\xc81\x02>0R\x0ecertificateIdsB\x0f\n" +
	"\ahandler\x12\x04\xc0\xc11\x01\"\xca\x04\n" +
	"\vTargetState\x12V\n" +
	"\x06status\x18\x01 \x01(\v2>.yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatusR\x06status\x12E\n" +
	"\x06target\x18\x02 \x01(\v2'.yandex.cloud.apploadbalancer.v1.TargetB\x04\xe8\xc71\x01R\x06target\x1a|\n" +
	"\x11HealthcheckStatus\x12g\n" +
	"\rzone_statuses\x18\x01 \x03(\v2B.yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatusR\fzoneStatuses\x1a\xad\x01\n" +
	"\x15ZoneHealthcheckStatus\x12\x1d\n" +
	"\azone_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x06zoneId\x12K\n" +
	"\x06status\x18\x02 \x01(\x0e23.yandex.cloud.apploadbalancer.v1.TargetState.StatusR\x06status\x12(\n" +
	"\x10failed_active_hc\x18\x03 \x01(\bR\x0efailedActiveHc\"n\n" +
	"\x06Status\x12\x16\n" +
	"\x12STATUS_UNSPECIFIED\x10\x00\x12\v\n" +
	"\aHEALTHY\x10\x01\x12\x15\n" +
	"\x11PARTIALLY_HEALTHY\x10\x02\x12\r\n" +
	"\tUNHEALTHY\x10\x03\x12\f\n" +
	"\bDRAINING\x10\x04\x12\v\n" +
	"\aTIMEOUT\x10\x05\"h\n" +
	"\x0fAutoScalePolicy\x12.\n" +
	"\rmin_zone_size\x18\x01 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\vminZoneSize\x12%\n" +
	"\bmax_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\amaxSizeBz\n" +
	"#yandex.cloud.api.apploadbalancer.v1ZSgithub.com/yandex-cloud/go-genproto/yandex/cloud/apploadbalancer/v1;apploadbalancerb\x06proto3"

var (
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescOnce sync.Once
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData []byte
)

func file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescGZIP() []byte {
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc), len(file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc)))
	})
	return file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDescData
}

var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes = []any{
	(LoadBalancer_Status)(0),                  // 0: yandex.cloud.apploadbalancer.v1.LoadBalancer.Status
	(TargetState_Status)(0),                   // 1: yandex.cloud.apploadbalancer.v1.TargetState.Status
	(*LoadBalancer)(nil),                      // 2: yandex.cloud.apploadbalancer.v1.LoadBalancer
	(*Address)(nil),                           // 3: yandex.cloud.apploadbalancer.v1.Address
	(*ExternalIpv4Address)(nil),               // 4: yandex.cloud.apploadbalancer.v1.ExternalIpv4Address
	(*InternalIpv4Address)(nil),               // 5: yandex.cloud.apploadbalancer.v1.InternalIpv4Address
	(*ExternalIpv6Address)(nil),               // 6: yandex.cloud.apploadbalancer.v1.ExternalIpv6Address
	(*Location)(nil),                          // 7: yandex.cloud.apploadbalancer.v1.Location
	(*AllocationPolicy)(nil),                  // 8: yandex.cloud.apploadbalancer.v1.AllocationPolicy
	(*Listener)(nil),                          // 9: yandex.cloud.apploadbalancer.v1.Listener
	(*Endpoint)(nil),                          // 10: yandex.cloud.apploadbalancer.v1.Endpoint
	(*HttpListener)(nil),                      // 11: yandex.cloud.apploadbalancer.v1.HttpListener
	(*TlsListener)(nil),                       // 12: yandex.cloud.apploadbalancer.v1.TlsListener
	(*StreamListener)(nil),                    // 13: yandex.cloud.apploadbalancer.v1.StreamListener
	(*Http2Options)(nil),                      // 14: yandex.cloud.apploadbalancer.v1.Http2Options
	(*StreamHandler)(nil),                     // 15: yandex.cloud.apploadbalancer.v1.StreamHandler
	(*HttpHandler)(nil),                       // 16: yandex.cloud.apploadbalancer.v1.HttpHandler
	(*Redirects)(nil),                         // 17: yandex.cloud.apploadbalancer.v1.Redirects
	(*SniMatch)(nil),                          // 18: yandex.cloud.apploadbalancer.v1.SniMatch
	(*TlsHandler)(nil),                        // 19: yandex.cloud.apploadbalancer.v1.TlsHandler
	(*TargetState)(nil),                       // 20: yandex.cloud.apploadbalancer.v1.TargetState
	(*AutoScalePolicy)(nil),                   // 21: yandex.cloud.apploadbalancer.v1.AutoScalePolicy
	nil,                                       // 22: yandex.cloud.apploadbalancer.v1.LoadBalancer.LabelsEntry
	(*TargetState_HealthcheckStatus)(nil),     // 23: yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus
	(*TargetState_ZoneHealthcheckStatus)(nil), // 24: yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus
	(*timestamppb.Timestamp)(nil),             // 25: google.protobuf.Timestamp
	(*LogOptions)(nil),                        // 26: yandex.cloud.apploadbalancer.v1.LogOptions
	(*durationpb.Duration)(nil),               // 27: google.protobuf.Duration
	(*Target)(nil),                            // 28: yandex.cloud.apploadbalancer.v1.Target
}
var file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs = []int32{
	22, // 0: yandex.cloud.apploadbalancer.v1.LoadBalancer.labels:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancer.LabelsEntry
	0,  // 1: yandex.cloud.apploadbalancer.v1.LoadBalancer.status:type_name -> yandex.cloud.apploadbalancer.v1.LoadBalancer.Status
	9,  // 2: yandex.cloud.apploadbalancer.v1.LoadBalancer.listeners:type_name -> yandex.cloud.apploadbalancer.v1.Listener
	8,  // 3: yandex.cloud.apploadbalancer.v1.LoadBalancer.allocation_policy:type_name -> yandex.cloud.apploadbalancer.v1.AllocationPolicy
	25, // 4: yandex.cloud.apploadbalancer.v1.LoadBalancer.created_at:type_name -> google.protobuf.Timestamp
	21, // 5: yandex.cloud.apploadbalancer.v1.LoadBalancer.auto_scale_policy:type_name -> yandex.cloud.apploadbalancer.v1.AutoScalePolicy
	26, // 6: yandex.cloud.apploadbalancer.v1.LoadBalancer.log_options:type_name -> yandex.cloud.apploadbalancer.v1.LogOptions
	4,  // 7: yandex.cloud.apploadbalancer.v1.Address.external_ipv4_address:type_name -> yandex.cloud.apploadbalancer.v1.ExternalIpv4Address
	5,  // 8: yandex.cloud.apploadbalancer.v1.Address.internal_ipv4_address:type_name -> yandex.cloud.apploadbalancer.v1.InternalIpv4Address
	6,  // 9: yandex.cloud.apploadbalancer.v1.Address.external_ipv6_address:type_name -> yandex.cloud.apploadbalancer.v1.ExternalIpv6Address
	7,  // 10: yandex.cloud.apploadbalancer.v1.AllocationPolicy.locations:type_name -> yandex.cloud.apploadbalancer.v1.Location
	10, // 11: yandex.cloud.apploadbalancer.v1.Listener.endpoints:type_name -> yandex.cloud.apploadbalancer.v1.Endpoint
	11, // 12: yandex.cloud.apploadbalancer.v1.Listener.http:type_name -> yandex.cloud.apploadbalancer.v1.HttpListener
	12, // 13: yandex.cloud.apploadbalancer.v1.Listener.tls:type_name -> yandex.cloud.apploadbalancer.v1.TlsListener
	13, // 14: yandex.cloud.apploadbalancer.v1.Listener.stream:type_name -> yandex.cloud.apploadbalancer.v1.StreamListener
	3,  // 15: yandex.cloud.apploadbalancer.v1.Endpoint.addresses:type_name -> yandex.cloud.apploadbalancer.v1.Address
	16, // 16: yandex.cloud.apploadbalancer.v1.HttpListener.handler:type_name -> yandex.cloud.apploadbalancer.v1.HttpHandler
	17, // 17: yandex.cloud.apploadbalancer.v1.HttpListener.redirects:type_name -> yandex.cloud.apploadbalancer.v1.Redirects
	19, // 18: yandex.cloud.apploadbalancer.v1.TlsListener.default_handler:type_name -> yandex.cloud.apploadbalancer.v1.TlsHandler
	18, // 19: yandex.cloud.apploadbalancer.v1.TlsListener.sni_handlers:type_name -> yandex.cloud.apploadbalancer.v1.SniMatch
	15, // 20: yandex.cloud.apploadbalancer.v1.StreamListener.handler:type_name -> yandex.cloud.apploadbalancer.v1.StreamHandler
	27, // 21: yandex.cloud.apploadbalancer.v1.StreamHandler.idle_timeout:type_name -> google.protobuf.Duration
	14, // 22: yandex.cloud.apploadbalancer.v1.HttpHandler.http2_options:type_name -> yandex.cloud.apploadbalancer.v1.Http2Options
	19, // 23: yandex.cloud.apploadbalancer.v1.SniMatch.handler:type_name -> yandex.cloud.apploadbalancer.v1.TlsHandler
	16, // 24: yandex.cloud.apploadbalancer.v1.TlsHandler.http_handler:type_name -> yandex.cloud.apploadbalancer.v1.HttpHandler
	15, // 25: yandex.cloud.apploadbalancer.v1.TlsHandler.stream_handler:type_name -> yandex.cloud.apploadbalancer.v1.StreamHandler
	23, // 26: yandex.cloud.apploadbalancer.v1.TargetState.status:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus
	28, // 27: yandex.cloud.apploadbalancer.v1.TargetState.target:type_name -> yandex.cloud.apploadbalancer.v1.Target
	24, // 28: yandex.cloud.apploadbalancer.v1.TargetState.HealthcheckStatus.zone_statuses:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus
	1,  // 29: yandex.cloud.apploadbalancer.v1.TargetState.ZoneHealthcheckStatus.status:type_name -> yandex.cloud.apploadbalancer.v1.TargetState.Status
	30, // [30:30] is the sub-list for method output_type
	30, // [30:30] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_init() }
func file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_init() {
	if File_yandex_cloud_apploadbalancer_v1_load_balancer_proto != nil {
		return
	}
	file_yandex_cloud_apploadbalancer_v1_logging_proto_init()
	file_yandex_cloud_apploadbalancer_v1_target_group_proto_init()
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[1].OneofWrappers = []any{
		(*Address_ExternalIpv4Address)(nil),
		(*Address_InternalIpv4Address)(nil),
		(*Address_ExternalIpv6Address)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[7].OneofWrappers = []any{
		(*Listener_Http)(nil),
		(*Listener_Tls)(nil),
		(*Listener_Stream)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[14].OneofWrappers = []any{
		(*HttpHandler_Http2Options)(nil),
		(*HttpHandler_AllowHttp10)(nil),
	}
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes[17].OneofWrappers = []any{
		(*TlsHandler_HttpHandler)(nil),
		(*TlsHandler_StreamHandler)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc), len(file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_msgTypes,
	}.Build()
	File_yandex_cloud_apploadbalancer_v1_load_balancer_proto = out.File
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_goTypes = nil
	file_yandex_cloud_apploadbalancer_v1_load_balancer_proto_depIdxs = nil
}
