// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/mdb/greenplum/v1/cluster.proto

package greenplum

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	timeofday "google.golang.org/genproto/googleapis/type/timeofday"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Cluster_Environment int32

const (
	Cluster_ENVIRONMENT_UNSPECIFIED Cluster_Environment = 0
	// Stable environment with a conservative update policy: only hotfixes are applied during regular maintenance.
	Cluster_PRODUCTION Cluster_Environment = 1
	// Environment with more aggressive update policy: new versions are rolled out irrespective of backward compatibility.
	Cluster_PRESTABLE Cluster_Environment = 2
)

// Enum value maps for Cluster_Environment.
var (
	Cluster_Environment_name = map[int32]string{
		0: "ENVIRONMENT_UNSPECIFIED",
		1: "PRODUCTION",
		2: "PRESTABLE",
	}
	Cluster_Environment_value = map[string]int32{
		"ENVIRONMENT_UNSPECIFIED": 0,
		"PRODUCTION":              1,
		"PRESTABLE":               2,
	}
)

func (x Cluster_Environment) Enum() *Cluster_Environment {
	p := new(Cluster_Environment)
	*p = x
	return p
}

func (x Cluster_Environment) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Environment) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[0].Descriptor()
}

func (Cluster_Environment) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[0]
}

func (x Cluster_Environment) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Environment.Descriptor instead.
func (Cluster_Environment) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{0, 0}
}

type Cluster_Health int32

const (
	// Health of the cluster is unknown ([Host.health] for every host in the cluster is UNKNOWN).
	Cluster_HEALTH_UNKNOWN Cluster_Health = 0
	// Cluster is working normally ([Host.health] for every host in the cluster is ALIVE).
	Cluster_ALIVE Cluster_Health = 1
	// Cluster is inoperable ([Host.health] for every host in the cluster is DEAD).
	Cluster_DEAD Cluster_Health = 2
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is not ALIVE).
	Cluster_DEGRADED Cluster_Health = 3
	// Cluster is working below capacity ([Host.health] for at least one host in the cluster is UNBALANCED).
	Cluster_UNBALANCED Cluster_Health = 4
)

// Enum value maps for Cluster_Health.
var (
	Cluster_Health_name = map[int32]string{
		0: "HEALTH_UNKNOWN",
		1: "ALIVE",
		2: "DEAD",
		3: "DEGRADED",
		4: "UNBALANCED",
	}
	Cluster_Health_value = map[string]int32{
		"HEALTH_UNKNOWN": 0,
		"ALIVE":          1,
		"DEAD":           2,
		"DEGRADED":       3,
		"UNBALANCED":     4,
	}
)

func (x Cluster_Health) Enum() *Cluster_Health {
	p := new(Cluster_Health)
	*p = x
	return p
}

func (x Cluster_Health) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Health) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[1].Descriptor()
}

func (Cluster_Health) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[1]
}

func (x Cluster_Health) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Health.Descriptor instead.
func (Cluster_Health) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{0, 1}
}

type Cluster_Status int32

const (
	// Cluster state is unknown.
	Cluster_STATUS_UNKNOWN Cluster_Status = 0
	// Cluster is being created.
	Cluster_CREATING Cluster_Status = 1
	// Cluster is running normally.
	Cluster_RUNNING Cluster_Status = 2
	// Cluster has encountered a problem and cannot operate.
	Cluster_ERROR Cluster_Status = 3
	// Cluster is being updated.
	Cluster_UPDATING Cluster_Status = 4
	// Cluster is stopping.
	Cluster_STOPPING Cluster_Status = 5
	// Cluster has stopped.
	Cluster_STOPPED Cluster_Status = 6
	// Cluster is starting.
	Cluster_STARTING Cluster_Status = 7
)

// Enum value maps for Cluster_Status.
var (
	Cluster_Status_name = map[int32]string{
		0: "STATUS_UNKNOWN",
		1: "CREATING",
		2: "RUNNING",
		3: "ERROR",
		4: "UPDATING",
		5: "STOPPING",
		6: "STOPPED",
		7: "STARTING",
	}
	Cluster_Status_value = map[string]int32{
		"STATUS_UNKNOWN": 0,
		"CREATING":       1,
		"RUNNING":        2,
		"ERROR":          3,
		"UPDATING":       4,
		"STOPPING":       5,
		"STOPPED":        6,
		"STARTING":       7,
	}
)

func (x Cluster_Status) Enum() *Cluster_Status {
	p := new(Cluster_Status)
	*p = x
	return p
}

func (x Cluster_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Cluster_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[2].Descriptor()
}

func (Cluster_Status) Type() protoreflect.EnumType {
	return &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes[2]
}

func (x Cluster_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Cluster_Status.Descriptor instead.
func (Cluster_Status) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{0, 2}
}

// A Greenplum® cluster resource.
type Cluster struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the Greenplum® cluster.
	// This ID is assigned by the platform at the moment of cluster creation.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// ID of the folder that the Greenplum® cluster belongs to.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Time when the cluster was created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Name of the Greenplum® cluster.
	// The name is unique within the folder.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Greenplum® cluster configuration.
	Config *GreenplumConfig `protobuf:"bytes,5,opt,name=config,proto3" json:"config,omitempty"`
	// Description of the Greenplum® cluster.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Custom labels for the Greenplum® cluster as `key:value` pairs. Maximum 64 labels per resource.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Deployment environment of the Greenplum® cluster.
	Environment Cluster_Environment `protobuf:"varint,8,opt,name=environment,proto3,enum=yandex.cloud.mdb.greenplum.v1.Cluster_Environment" json:"environment,omitempty"`
	// Description of monitoring systems relevant to the Greenplum® cluster.
	Monitoring []*Monitoring `protobuf:"bytes,9,rep,name=monitoring,proto3" json:"monitoring,omitempty"`
	// Configuration of the Greenplum® master subcluster.
	MasterConfig *MasterSubclusterConfig `protobuf:"bytes,10,opt,name=master_config,json=masterConfig,proto3" json:"master_config,omitempty"`
	// Configuration of the Greenplum® segment subcluster.
	SegmentConfig *SegmentSubclusterConfig `protobuf:"bytes,11,opt,name=segment_config,json=segmentConfig,proto3" json:"segment_config,omitempty"`
	// Number of hosts in the master subcluster.
	MasterHostCount int64 `protobuf:"varint,12,opt,name=master_host_count,json=masterHostCount,proto3" json:"master_host_count,omitempty"`
	// Number of hosts in the segment subcluster.
	SegmentHostCount int64 `protobuf:"varint,13,opt,name=segment_host_count,json=segmentHostCount,proto3" json:"segment_host_count,omitempty"`
	// Number of segments per host.
	SegmentInHost int64 `protobuf:"varint,14,opt,name=segment_in_host,json=segmentInHost,proto3" json:"segment_in_host,omitempty"`
	// ID of the cloud network that the cluster belongs to.
	NetworkId string `protobuf:"bytes,15,opt,name=network_id,json=networkId,proto3" json:"network_id,omitempty"`
	// Aggregated cluster health.
	Health Cluster_Health `protobuf:"varint,16,opt,name=health,proto3,enum=yandex.cloud.mdb.greenplum.v1.Cluster_Health" json:"health,omitempty"`
	// Current state of the cluster.
	Status Cluster_Status `protobuf:"varint,17,opt,name=status,proto3,enum=yandex.cloud.mdb.greenplum.v1.Cluster_Status" json:"status,omitempty"`
	// A Greenplum® cluster maintenance window. Should be defined by either one of the two options.
	MaintenanceWindow *MaintenanceWindow `protobuf:"bytes,18,opt,name=maintenance_window,json=maintenanceWindow,proto3" json:"maintenance_window,omitempty"`
	// Maintenance operation planned at nearest [maintenance_window].
	PlannedOperation *MaintenanceOperation `protobuf:"bytes,19,opt,name=planned_operation,json=plannedOperation,proto3" json:"planned_operation,omitempty"`
	// User security groups.
	SecurityGroupIds []string `protobuf:"bytes,20,rep,name=security_group_ids,json=securityGroupIds,proto3" json:"security_group_ids,omitempty"`
	// Owner user name.
	UserName string `protobuf:"bytes,21,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// Determines whether the cluster is protected from being deleted.
	DeletionProtection bool `protobuf:"varint,22,opt,name=deletion_protection,json=deletionProtection,proto3" json:"deletion_protection,omitempty"`
	// Host groups hosting VMs of the cluster.
	HostGroupIds []string `protobuf:"bytes,23,rep,name=host_group_ids,json=hostGroupIds,proto3" json:"host_group_ids,omitempty"`
	// Greenplum® and Odyssey® configuration.
	ClusterConfig *ClusterConfigSet `protobuf:"bytes,24,opt,name=cluster_config,json=clusterConfig,proto3" json:"cluster_config,omitempty"`
	// Cloud storage settings
	CloudStorage *CloudStorage `protobuf:"bytes,26,opt,name=cloud_storage,json=cloudStorage,proto3" json:"cloud_storage,omitempty"`
	// Host groups hosting VMs of the master subcluster.
	MasterHostGroupIds []string `protobuf:"bytes,27,rep,name=master_host_group_ids,json=masterHostGroupIds,proto3" json:"master_host_group_ids,omitempty"`
	// Host groups hosting VMs of the segment subcluster.
	SegmentHostGroupIds []string `protobuf:"bytes,28,rep,name=segment_host_group_ids,json=segmentHostGroupIds,proto3" json:"segment_host_group_ids,omitempty"`
	// Service account that will be used to access a Yandex Cloud resources
	ServiceAccountId string `protobuf:"bytes,29,opt,name=service_account_id,json=serviceAccountId,proto3" json:"service_account_id,omitempty"`
	// Cloud logging configuration
	Logging       *LoggingConfig `protobuf:"bytes,30,opt,name=logging,proto3" json:"logging,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Cluster) Reset() {
	*x = Cluster{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Cluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cluster) ProtoMessage() {}

func (x *Cluster) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cluster.ProtoReflect.Descriptor instead.
func (*Cluster) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{0}
}

func (x *Cluster) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Cluster) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *Cluster) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Cluster) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Cluster) GetConfig() *GreenplumConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Cluster) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Cluster) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Cluster) GetEnvironment() Cluster_Environment {
	if x != nil {
		return x.Environment
	}
	return Cluster_ENVIRONMENT_UNSPECIFIED
}

func (x *Cluster) GetMonitoring() []*Monitoring {
	if x != nil {
		return x.Monitoring
	}
	return nil
}

func (x *Cluster) GetMasterConfig() *MasterSubclusterConfig {
	if x != nil {
		return x.MasterConfig
	}
	return nil
}

func (x *Cluster) GetSegmentConfig() *SegmentSubclusterConfig {
	if x != nil {
		return x.SegmentConfig
	}
	return nil
}

func (x *Cluster) GetMasterHostCount() int64 {
	if x != nil {
		return x.MasterHostCount
	}
	return 0
}

func (x *Cluster) GetSegmentHostCount() int64 {
	if x != nil {
		return x.SegmentHostCount
	}
	return 0
}

func (x *Cluster) GetSegmentInHost() int64 {
	if x != nil {
		return x.SegmentInHost
	}
	return 0
}

func (x *Cluster) GetNetworkId() string {
	if x != nil {
		return x.NetworkId
	}
	return ""
}

func (x *Cluster) GetHealth() Cluster_Health {
	if x != nil {
		return x.Health
	}
	return Cluster_HEALTH_UNKNOWN
}

func (x *Cluster) GetStatus() Cluster_Status {
	if x != nil {
		return x.Status
	}
	return Cluster_STATUS_UNKNOWN
}

func (x *Cluster) GetMaintenanceWindow() *MaintenanceWindow {
	if x != nil {
		return x.MaintenanceWindow
	}
	return nil
}

func (x *Cluster) GetPlannedOperation() *MaintenanceOperation {
	if x != nil {
		return x.PlannedOperation
	}
	return nil
}

func (x *Cluster) GetSecurityGroupIds() []string {
	if x != nil {
		return x.SecurityGroupIds
	}
	return nil
}

func (x *Cluster) GetUserName() string {
	if x != nil {
		return x.UserName
	}
	return ""
}

func (x *Cluster) GetDeletionProtection() bool {
	if x != nil {
		return x.DeletionProtection
	}
	return false
}

func (x *Cluster) GetHostGroupIds() []string {
	if x != nil {
		return x.HostGroupIds
	}
	return nil
}

func (x *Cluster) GetClusterConfig() *ClusterConfigSet {
	if x != nil {
		return x.ClusterConfig
	}
	return nil
}

func (x *Cluster) GetCloudStorage() *CloudStorage {
	if x != nil {
		return x.CloudStorage
	}
	return nil
}

func (x *Cluster) GetMasterHostGroupIds() []string {
	if x != nil {
		return x.MasterHostGroupIds
	}
	return nil
}

func (x *Cluster) GetSegmentHostGroupIds() []string {
	if x != nil {
		return x.SegmentHostGroupIds
	}
	return nil
}

func (x *Cluster) GetServiceAccountId() string {
	if x != nil {
		return x.ServiceAccountId
	}
	return ""
}

func (x *Cluster) GetLogging() *LoggingConfig {
	if x != nil {
		return x.Logging
	}
	return nil
}

type ClusterConfigSet struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to GreenplumConfig:
	//
	//	*ClusterConfigSet_GreenplumConfigSet_6
	GreenplumConfig isClusterConfigSet_GreenplumConfig `protobuf_oneof:"greenplum_config"`
	// Odyssey® pool settings.
	Pool *ConnectionPoolerConfigSet `protobuf:"bytes,3,opt,name=pool,proto3" json:"pool,omitempty"`
	// Managed Greenplum® background tasks configuration.
	BackgroundActivities *BackgroundActivitiesConfig `protobuf:"bytes,6,opt,name=background_activities,json=backgroundActivities,proto3" json:"background_activities,omitempty"`
	PxfConfig            *PXFConfigSet               `protobuf:"bytes,8,opt,name=pxf_config,json=pxfConfig,proto3" json:"pxf_config,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ClusterConfigSet) Reset() {
	*x = ClusterConfigSet{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClusterConfigSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClusterConfigSet) ProtoMessage() {}

func (x *ClusterConfigSet) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClusterConfigSet.ProtoReflect.Descriptor instead.
func (*ClusterConfigSet) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{1}
}

func (x *ClusterConfigSet) GetGreenplumConfig() isClusterConfigSet_GreenplumConfig {
	if x != nil {
		return x.GreenplumConfig
	}
	return nil
}

func (x *ClusterConfigSet) GetGreenplumConfigSet_6() *GreenplumConfigSet6 {
	if x != nil {
		if x, ok := x.GreenplumConfig.(*ClusterConfigSet_GreenplumConfigSet_6); ok {
			return x.GreenplumConfigSet_6
		}
	}
	return nil
}

func (x *ClusterConfigSet) GetPool() *ConnectionPoolerConfigSet {
	if x != nil {
		return x.Pool
	}
	return nil
}

func (x *ClusterConfigSet) GetBackgroundActivities() *BackgroundActivitiesConfig {
	if x != nil {
		return x.BackgroundActivities
	}
	return nil
}

func (x *ClusterConfigSet) GetPxfConfig() *PXFConfigSet {
	if x != nil {
		return x.PxfConfig
	}
	return nil
}

type isClusterConfigSet_GreenplumConfig interface {
	isClusterConfigSet_GreenplumConfig()
}

type ClusterConfigSet_GreenplumConfigSet_6 struct {
	GreenplumConfigSet_6 *GreenplumConfigSet6 `protobuf:"bytes,9,opt,name=greenplum_config_set_6,json=greenplumConfigSet_6,proto3,oneof"`
}

func (*ClusterConfigSet_GreenplumConfigSet_6) isClusterConfigSet_GreenplumConfig() {}

// Monitoring system metadata.
type Monitoring struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the monitoring system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the monitoring system.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Link to the monitoring system charts for the Greenplum® cluster.
	Link          string `protobuf:"bytes,3,opt,name=link,proto3" json:"link,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Monitoring) Reset() {
	*x = Monitoring{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Monitoring) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Monitoring) ProtoMessage() {}

func (x *Monitoring) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Monitoring.ProtoReflect.Descriptor instead.
func (*Monitoring) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{2}
}

func (x *Monitoring) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Monitoring) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Monitoring) GetLink() string {
	if x != nil {
		return x.Link
	}
	return ""
}

type GreenplumConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the Greenplum® server software.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,2,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Retention policy of automated backups.
	BackupRetainPeriodDays *wrapperspb.Int64Value `protobuf:"bytes,9,opt,name=backup_retain_period_days,json=backupRetainPeriodDays,proto3" json:"backup_retain_period_days,omitempty"`
	// Access policy for external services.
	Access *Access `protobuf:"bytes,3,opt,name=access,proto3" json:"access,omitempty"`
	// ID of the availability zone the cluster belongs to.
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,4,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet the cluster belongs to. This subnet should be a part of the cloud network the cluster belongs to (see [Cluster.network_id]).
	SubnetId string `protobuf:"bytes,5,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Determines whether the cluster has a public IP address.
	//
	// After the cluster has been created, this setting cannot be changed.
	AssignPublicIp bool `protobuf:"varint,6,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	// Full version
	FullVersion   string `protobuf:"bytes,10,opt,name=full_version,json=fullVersion,proto3" json:"full_version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GreenplumConfig) Reset() {
	*x = GreenplumConfig{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GreenplumConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GreenplumConfig) ProtoMessage() {}

func (x *GreenplumConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GreenplumConfig.ProtoReflect.Descriptor instead.
func (*GreenplumConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{3}
}

func (x *GreenplumConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GreenplumConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *GreenplumConfig) GetBackupRetainPeriodDays() *wrapperspb.Int64Value {
	if x != nil {
		return x.BackupRetainPeriodDays
	}
	return nil
}

func (x *GreenplumConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *GreenplumConfig) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *GreenplumConfig) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *GreenplumConfig) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

func (x *GreenplumConfig) GetFullVersion() string {
	if x != nil {
		return x.FullVersion
	}
	return ""
}

type Access struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Allows data export from the cluster to DataLens.
	DataLens bool `protobuf:"varint,1,opt,name=data_lens,json=dataLens,proto3" json:"data_lens,omitempty"`
	// Allows SQL queries to the cluster databases from the management console.
	WebSql bool `protobuf:"varint,2,opt,name=web_sql,json=webSql,proto3" json:"web_sql,omitempty"`
	// Allows access for DataTransfer.
	DataTransfer bool `protobuf:"varint,3,opt,name=data_transfer,json=dataTransfer,proto3" json:"data_transfer,omitempty"`
	// Allow access for YandexQuery.
	YandexQuery   bool `protobuf:"varint,5,opt,name=yandex_query,json=yandexQuery,proto3" json:"yandex_query,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Access) Reset() {
	*x = Access{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Access) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Access) ProtoMessage() {}

func (x *Access) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Access.ProtoReflect.Descriptor instead.
func (*Access) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{4}
}

func (x *Access) GetDataLens() bool {
	if x != nil {
		return x.DataLens
	}
	return false
}

func (x *Access) GetWebSql() bool {
	if x != nil {
		return x.WebSql
	}
	return false
}

func (x *Access) GetDataTransfer() bool {
	if x != nil {
		return x.DataTransfer
	}
	return false
}

func (x *Access) GetYandexQuery() bool {
	if x != nil {
		return x.YandexQuery
	}
	return false
}

type GreenplumRestoreConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Time to start the daily backup, in the UTC timezone.
	BackupWindowStart *timeofday.TimeOfDay `protobuf:"bytes,1,opt,name=backup_window_start,json=backupWindowStart,proto3" json:"backup_window_start,omitempty"`
	// Access policy for external services.
	Access *Access `protobuf:"bytes,2,opt,name=access,proto3" json:"access,omitempty"`
	// ID of the availability zone where the host resides.
	//
	// To get a list of available zones, use the [yandex.cloud.compute.v1.ZoneService.List] request.
	ZoneId string `protobuf:"bytes,3,opt,name=zone_id,json=zoneId,proto3" json:"zone_id,omitempty"`
	// ID of the subnet that the host should belong to. This subnet should be a part of the network that the cluster belongs to.
	// The ID of the network is set in the field [Cluster.network_id].
	SubnetId string `protobuf:"bytes,4,opt,name=subnet_id,json=subnetId,proto3" json:"subnet_id,omitempty"`
	// Determines whether the host should get a public IP address on creation.
	//
	// After a host has been created, this setting cannot be changed.
	//
	// To remove an assigned public IP, or to assign a public IP to a host without one, recreate the host with [assign_public_ip] set as needed.
	//
	// Possible values:
	// * `false` - do not assign a public IP to the master host.
	// * `true` - assign a public IP to the master host.
	AssignPublicIp bool `protobuf:"varint,5,opt,name=assign_public_ip,json=assignPublicIp,proto3" json:"assign_public_ip,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *GreenplumRestoreConfig) Reset() {
	*x = GreenplumRestoreConfig{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GreenplumRestoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GreenplumRestoreConfig) ProtoMessage() {}

func (x *GreenplumRestoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GreenplumRestoreConfig.ProtoReflect.Descriptor instead.
func (*GreenplumRestoreConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{5}
}

func (x *GreenplumRestoreConfig) GetBackupWindowStart() *timeofday.TimeOfDay {
	if x != nil {
		return x.BackupWindowStart
	}
	return nil
}

func (x *GreenplumRestoreConfig) GetAccess() *Access {
	if x != nil {
		return x.Access
	}
	return nil
}

func (x *GreenplumRestoreConfig) GetZoneId() string {
	if x != nil {
		return x.ZoneId
	}
	return ""
}

func (x *GreenplumRestoreConfig) GetSubnetId() string {
	if x != nil {
		return x.SubnetId
	}
	return ""
}

func (x *GreenplumRestoreConfig) GetAssignPublicIp() bool {
	if x != nil {
		return x.AssignPublicIp
	}
	return false
}

type RestoreResources struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the preset for computational resources available to a host (CPU, memory, etc.).
	ResourcePresetId string `protobuf:"bytes,1,opt,name=resource_preset_id,json=resourcePresetId,proto3" json:"resource_preset_id,omitempty"`
	// Volume of the storage available to a host.
	DiskSize      int64 `protobuf:"varint,2,opt,name=disk_size,json=diskSize,proto3" json:"disk_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RestoreResources) Reset() {
	*x = RestoreResources{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreResources) ProtoMessage() {}

func (x *RestoreResources) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreResources.ProtoReflect.Descriptor instead.
func (*RestoreResources) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{6}
}

func (x *RestoreResources) GetResourcePresetId() string {
	if x != nil {
		return x.ResourcePresetId
	}
	return ""
}

func (x *RestoreResources) GetDiskSize() int64 {
	if x != nil {
		return x.DiskSize
	}
	return 0
}

// Cloud Storage Settings
type CloudStorage struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// enable Cloud Storage for cluster
	Enable        bool `protobuf:"varint,1,opt,name=enable,proto3" json:"enable,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloudStorage) Reset() {
	*x = CloudStorage{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorage) ProtoMessage() {}

func (x *CloudStorage) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorage.ProtoReflect.Descriptor instead.
func (*CloudStorage) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{7}
}

func (x *CloudStorage) GetEnable() bool {
	if x != nil {
		return x.Enable
	}
	return false
}

type LoggingConfig struct {
	state   protoimpl.MessageState `protogen:"open.v1"`
	Enabled bool                   `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Types that are valid to be assigned to Destination:
	//
	//	*LoggingConfig_FolderId
	//	*LoggingConfig_LogGroupId
	Destination isLoggingConfig_Destination `protobuf_oneof:"destination"`
	// send Yandex Command Center logs
	CommandCenterEnabled bool `protobuf:"varint,5,opt,name=command_center_enabled,json=commandCenterEnabled,proto3" json:"command_center_enabled,omitempty"`
	// send Greenplum logs
	GreenplumEnabled bool `protobuf:"varint,6,opt,name=greenplum_enabled,json=greenplumEnabled,proto3" json:"greenplum_enabled,omitempty"`
	// send Pooler logs
	PoolerEnabled bool `protobuf:"varint,7,opt,name=pooler_enabled,json=poolerEnabled,proto3" json:"pooler_enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LoggingConfig) Reset() {
	*x = LoggingConfig{}
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoggingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggingConfig) ProtoMessage() {}

func (x *LoggingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggingConfig.ProtoReflect.Descriptor instead.
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP(), []int{8}
}

func (x *LoggingConfig) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *LoggingConfig) GetDestination() isLoggingConfig_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *LoggingConfig) GetFolderId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_FolderId); ok {
			return x.FolderId
		}
	}
	return ""
}

func (x *LoggingConfig) GetLogGroupId() string {
	if x != nil {
		if x, ok := x.Destination.(*LoggingConfig_LogGroupId); ok {
			return x.LogGroupId
		}
	}
	return ""
}

func (x *LoggingConfig) GetCommandCenterEnabled() bool {
	if x != nil {
		return x.CommandCenterEnabled
	}
	return false
}

func (x *LoggingConfig) GetGreenplumEnabled() bool {
	if x != nil {
		return x.GreenplumEnabled
	}
	return false
}

func (x *LoggingConfig) GetPoolerEnabled() bool {
	if x != nil {
		return x.PoolerEnabled
	}
	return false
}

type isLoggingConfig_Destination interface {
	isLoggingConfig_Destination()
}

type LoggingConfig_FolderId struct {
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3,oneof"`
}

type LoggingConfig_LogGroupId struct {
	LogGroupId string `protobuf:"bytes,3,opt,name=log_group_id,json=logGroupId,proto3,oneof"`
}

func (*LoggingConfig_FolderId) isLoggingConfig_Destination() {}

func (*LoggingConfig_LogGroupId) isLoggingConfig_Destination() {}

var File_yandex_cloud_mdb_greenplum_v1_cluster_proto protoreflect.FileDescriptor

const file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDesc = "" +
	"\n" +
	"+yandex/cloud/mdb/greenplum/v1/cluster.proto\x12\x1dyandex.cloud.mdb.greenplum.v1\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a\x1bgoogle/type/timeofday.proto\x1a*yandex/cloud/mdb/greenplum/v1/config.proto\x1a/yandex/cloud/mdb/greenplum/v1/maintenance.proto\x1a'yandex/cloud/mdb/greenplum/v1/pxf.proto\x1a\x1dyandex/cloud/validation.proto\"\xa4\x10\n" +
	"\aCluster\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x1b\n" +
	"\tfolder_id\x18\x02 \x01(\tR\bfolderId\x129\n" +
	"\n" +
	"created_at\x18\x03 \x01(\v2\x1a.google.protobuf.TimestampR\tcreatedAt\x12 \n" +
	"\x04name\x18\x04 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=63R\x04name\x12F\n" +
	"\x06config\x18\x05 \x01(\v2..yandex.cloud.mdb.greenplum.v1.GreenplumConfigR\x06config\x12+\n" +
	"\vdescription\x18\x06 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12J\n" +
	"\x06labels\x18\a \x03(\v22.yandex.cloud.mdb.greenplum.v1.Cluster.LabelsEntryR\x06labels\x12T\n" +
	"\venvironment\x18\b \x01(\x0e22.yandex.cloud.mdb.greenplum.v1.Cluster.EnvironmentR\venvironment\x12I\n" +
	"\n" +
	"monitoring\x18\t \x03(\v2).yandex.cloud.mdb.greenplum.v1.MonitoringR\n" +
	"monitoring\x12Z\n" +
	"\rmaster_config\x18\n" +
	" \x01(\v25.yandex.cloud.mdb.greenplum.v1.MasterSubclusterConfigR\fmasterConfig\x12]\n" +
	"\x0esegment_config\x18\v \x01(\v26.yandex.cloud.mdb.greenplum.v1.SegmentSubclusterConfigR\rsegmentConfig\x12*\n" +
	"\x11master_host_count\x18\f \x01(\x03R\x0fmasterHostCount\x12,\n" +
	"\x12segment_host_count\x18\r \x01(\x03R\x10segmentHostCount\x12&\n" +
	"\x0fsegment_in_host\x18\x0e \x01(\x03R\rsegmentInHost\x12\x1d\n" +
	"\n" +
	"network_id\x18\x0f \x01(\tR\tnetworkId\x12E\n" +
	"\x06health\x18\x10 \x01(\x0e2-.yandex.cloud.mdb.greenplum.v1.Cluster.HealthR\x06health\x12E\n" +
	"\x06status\x18\x11 \x01(\x0e2-.yandex.cloud.mdb.greenplum.v1.Cluster.StatusR\x06status\x12_\n" +
	"\x12maintenance_window\x18\x12 \x01(\v20.yandex.cloud.mdb.greenplum.v1.MaintenanceWindowR\x11maintenanceWindow\x12`\n" +
	"\x11planned_operation\x18\x13 \x01(\v23.yandex.cloud.mdb.greenplum.v1.MaintenanceOperationR\x10plannedOperation\x12,\n" +
	"\x12security_group_ids\x18\x14 \x03(\tR\x10securityGroupIds\x12\x1b\n" +
	"\tuser_name\x18\x15 \x01(\tR\buserName\x12/\n" +
	"\x13deletion_protection\x18\x16 \x01(\bR\x12deletionProtection\x12$\n" +
	"\x0ehost_group_ids\x18\x17 \x03(\tR\fhostGroupIds\x12V\n" +
	"\x0ecluster_config\x18\x18 \x01(\v2/.yandex.cloud.mdb.greenplum.v1.ClusterConfigSetR\rclusterConfig\x12P\n" +
	"\rcloud_storage\x18\x1a \x01(\v2+.yandex.cloud.mdb.greenplum.v1.CloudStorageR\fcloudStorage\x121\n" +
	"\x15master_host_group_ids\x18\x1b \x03(\tR\x12masterHostGroupIds\x123\n" +
	"\x16segment_host_group_ids\x18\x1c \x03(\tR\x13segmentHostGroupIds\x12,\n" +
	"\x12service_account_id\x18\x1d \x01(\tR\x10serviceAccountId\x12F\n" +
	"\alogging\x18\x1e \x01(\v2,.yandex.cloud.mdb.greenplum.v1.LoggingConfigR\alogging\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"I\n" +
	"\vEnvironment\x12\x1b\n" +
	"\x17ENVIRONMENT_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"PRODUCTION\x10\x01\x12\r\n" +
	"\tPRESTABLE\x10\x02\"O\n" +
	"\x06Health\x12\x12\n" +
	"\x0eHEALTH_UNKNOWN\x10\x00\x12\t\n" +
	"\x05ALIVE\x10\x01\x12\b\n" +
	"\x04DEAD\x10\x02\x12\f\n" +
	"\bDEGRADED\x10\x03\x12\x0e\n" +
	"\n" +
	"UNBALANCED\x10\x04\"y\n" +
	"\x06Status\x12\x12\n" +
	"\x0eSTATUS_UNKNOWN\x10\x00\x12\f\n" +
	"\bCREATING\x10\x01\x12\v\n" +
	"\aRUNNING\x10\x02\x12\t\n" +
	"\x05ERROR\x10\x03\x12\f\n" +
	"\bUPDATING\x10\x04\x12\f\n" +
	"\bSTOPPING\x10\x05\x12\v\n" +
	"\aSTOPPED\x10\x06\x12\f\n" +
	"\bSTARTING\x10\aJ\x04\b\x19\x10\x1a\"\xba\x03\n" +
	"\x10ClusterConfigSet\x12j\n" +
	"\x16greenplum_config_set_6\x18\t \x01(\v22.yandex.cloud.mdb.greenplum.v1.GreenplumConfigSet6H\x00R\x14greenplumConfigSet_6\x12L\n" +
	"\x04pool\x18\x03 \x01(\v28.yandex.cloud.mdb.greenplum.v1.ConnectionPoolerConfigSetR\x04pool\x12n\n" +
	"\x15background_activities\x18\x06 \x01(\v29.yandex.cloud.mdb.greenplum.v1.BackgroundActivitiesConfigR\x14backgroundActivities\x12J\n" +
	"\n" +
	"pxf_config\x18\b \x01(\v2+.yandex.cloud.mdb.greenplum.v1.PXFConfigSetR\tpxfConfigB\x12\n" +
	"\x10greenplum_configJ\x04\b\x01\x10\x02J\x04\b\x02\x10\x03J\x04\b\x04\x10\x05J\x04\b\x05\x10\x06J\x04\b\a\x10\b\"V\n" +
	"\n" +
	"Monitoring\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12 \n" +
	"\vdescription\x18\x02 \x01(\tR\vdescription\x12\x12\n" +
	"\x04link\x18\x03 \x01(\tR\x04link\"\xb1\x03\n" +
	"\x0fGreenplumConfig\x12\x18\n" +
	"\aversion\x18\x01 \x01(\tR\aversion\x12F\n" +
	"\x13backup_window_start\x18\x02 \x01(\v2\x16.google.type.TimeOfDayR\x11backupWindowStart\x12`\n" +
	"\x19backup_retain_period_days\x18\t \x01(\v2\x1b.google.protobuf.Int64ValueB\b\xfa\xc71\x041-60R\x16backupRetainPeriodDays\x12=\n" +
	"\x06access\x18\x03 \x01(\v2%.yandex.cloud.mdb.greenplum.v1.AccessR\x06access\x12!\n" +
	"\azone_id\x18\x04 \x01(\tB\b\x8a\xc81\x04<=50R\x06zoneId\x12%\n" +
	"\tsubnet_id\x18\x05 \x01(\tB\b\x8a\xc81\x04<=50R\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\x06 \x01(\bR\x0eassignPublicIp\x12!\n" +
	"\ffull_version\x18\n" +
	" \x01(\tR\vfullVersionJ\x04\b\a\x10\t\"\x8c\x01\n" +
	"\x06Access\x12\x1b\n" +
	"\tdata_lens\x18\x01 \x01(\bR\bdataLens\x12\x17\n" +
	"\aweb_sql\x18\x02 \x01(\bR\x06webSql\x12#\n" +
	"\rdata_transfer\x18\x03 \x01(\bR\fdataTransfer\x12!\n" +
	"\fyandex_query\x18\x05 \x01(\bR\vyandexQueryJ\x04\b\x04\x10\x05\"\x93\x02\n" +
	"\x16GreenplumRestoreConfig\x12F\n" +
	"\x13backup_window_start\x18\x01 \x01(\v2\x16.google.type.TimeOfDayR\x11backupWindowStart\x12=\n" +
	"\x06access\x18\x02 \x01(\v2%.yandex.cloud.mdb.greenplum.v1.AccessR\x06access\x12!\n" +
	"\azone_id\x18\x03 \x01(\tB\b\x8a\xc81\x04<=50R\x06zoneId\x12%\n" +
	"\tsubnet_id\x18\x04 \x01(\tB\b\x8a\xc81\x04<=50R\bsubnetId\x12(\n" +
	"\x10assign_public_ip\x18\x05 \x01(\bR\x0eassignPublicIp\"]\n" +
	"\x10RestoreResources\x12,\n" +
	"\x12resource_preset_id\x18\x01 \x01(\tR\x10resourcePresetId\x12\x1b\n" +
	"\tdisk_size\x18\x02 \x01(\x03R\bdiskSize\"&\n" +
	"\fCloudStorage\x12\x16\n" +
	"\x06enable\x18\x01 \x01(\bR\x06enable\"\xd5\x02\n" +
	"\rLoggingConfig\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12B\n" +
	"\tfolder_id\x18\x02 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\bfolderId\x12G\n" +
	"\flog_group_id\x18\x03 \x01(\tB#\xf2\xc71\x1f([a-zA-Z][-a-zA-Z0-9_.]{0,63})?H\x00R\n" +
	"logGroupId\x124\n" +
	"\x16command_center_enabled\x18\x05 \x01(\bR\x14commandCenterEnabled\x12+\n" +
	"\x11greenplum_enabled\x18\x06 \x01(\bR\x10greenplumEnabled\x12%\n" +
	"\x0epooler_enabled\x18\a \x01(\bR\rpoolerEnabledB\r\n" +
	"\vdestinationJ\x04\b\x04\x10\x05Bp\n" +
	"!yandex.cloud.api.mdb.greenplum.v1ZKgithub.com/yandex-cloud/go-genproto/yandex/cloud/mdb/greenplum/v1;greenplumb\x06proto3"

var (
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescOnce sync.Once
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescData []byte
)

func file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescGZIP() []byte {
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDesc)))
	})
	return file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDescData
}

var file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_yandex_cloud_mdb_greenplum_v1_cluster_proto_goTypes = []any{
	(Cluster_Environment)(0),           // 0: yandex.cloud.mdb.greenplum.v1.Cluster.Environment
	(Cluster_Health)(0),                // 1: yandex.cloud.mdb.greenplum.v1.Cluster.Health
	(Cluster_Status)(0),                // 2: yandex.cloud.mdb.greenplum.v1.Cluster.Status
	(*Cluster)(nil),                    // 3: yandex.cloud.mdb.greenplum.v1.Cluster
	(*ClusterConfigSet)(nil),           // 4: yandex.cloud.mdb.greenplum.v1.ClusterConfigSet
	(*Monitoring)(nil),                 // 5: yandex.cloud.mdb.greenplum.v1.Monitoring
	(*GreenplumConfig)(nil),            // 6: yandex.cloud.mdb.greenplum.v1.GreenplumConfig
	(*Access)(nil),                     // 7: yandex.cloud.mdb.greenplum.v1.Access
	(*GreenplumRestoreConfig)(nil),     // 8: yandex.cloud.mdb.greenplum.v1.GreenplumRestoreConfig
	(*RestoreResources)(nil),           // 9: yandex.cloud.mdb.greenplum.v1.RestoreResources
	(*CloudStorage)(nil),               // 10: yandex.cloud.mdb.greenplum.v1.CloudStorage
	(*LoggingConfig)(nil),              // 11: yandex.cloud.mdb.greenplum.v1.LoggingConfig
	nil,                                // 12: yandex.cloud.mdb.greenplum.v1.Cluster.LabelsEntry
	(*timestamppb.Timestamp)(nil),      // 13: google.protobuf.Timestamp
	(*MasterSubclusterConfig)(nil),     // 14: yandex.cloud.mdb.greenplum.v1.MasterSubclusterConfig
	(*SegmentSubclusterConfig)(nil),    // 15: yandex.cloud.mdb.greenplum.v1.SegmentSubclusterConfig
	(*MaintenanceWindow)(nil),          // 16: yandex.cloud.mdb.greenplum.v1.MaintenanceWindow
	(*MaintenanceOperation)(nil),       // 17: yandex.cloud.mdb.greenplum.v1.MaintenanceOperation
	(*GreenplumConfigSet6)(nil),        // 18: yandex.cloud.mdb.greenplum.v1.GreenplumConfigSet6
	(*ConnectionPoolerConfigSet)(nil),  // 19: yandex.cloud.mdb.greenplum.v1.ConnectionPoolerConfigSet
	(*BackgroundActivitiesConfig)(nil), // 20: yandex.cloud.mdb.greenplum.v1.BackgroundActivitiesConfig
	(*PXFConfigSet)(nil),               // 21: yandex.cloud.mdb.greenplum.v1.PXFConfigSet
	(*timeofday.TimeOfDay)(nil),        // 22: google.type.TimeOfDay
	(*wrapperspb.Int64Value)(nil),      // 23: google.protobuf.Int64Value
}
var file_yandex_cloud_mdb_greenplum_v1_cluster_proto_depIdxs = []int32{
	13, // 0: yandex.cloud.mdb.greenplum.v1.Cluster.created_at:type_name -> google.protobuf.Timestamp
	6,  // 1: yandex.cloud.mdb.greenplum.v1.Cluster.config:type_name -> yandex.cloud.mdb.greenplum.v1.GreenplumConfig
	12, // 2: yandex.cloud.mdb.greenplum.v1.Cluster.labels:type_name -> yandex.cloud.mdb.greenplum.v1.Cluster.LabelsEntry
	0,  // 3: yandex.cloud.mdb.greenplum.v1.Cluster.environment:type_name -> yandex.cloud.mdb.greenplum.v1.Cluster.Environment
	5,  // 4: yandex.cloud.mdb.greenplum.v1.Cluster.monitoring:type_name -> yandex.cloud.mdb.greenplum.v1.Monitoring
	14, // 5: yandex.cloud.mdb.greenplum.v1.Cluster.master_config:type_name -> yandex.cloud.mdb.greenplum.v1.MasterSubclusterConfig
	15, // 6: yandex.cloud.mdb.greenplum.v1.Cluster.segment_config:type_name -> yandex.cloud.mdb.greenplum.v1.SegmentSubclusterConfig
	1,  // 7: yandex.cloud.mdb.greenplum.v1.Cluster.health:type_name -> yandex.cloud.mdb.greenplum.v1.Cluster.Health
	2,  // 8: yandex.cloud.mdb.greenplum.v1.Cluster.status:type_name -> yandex.cloud.mdb.greenplum.v1.Cluster.Status
	16, // 9: yandex.cloud.mdb.greenplum.v1.Cluster.maintenance_window:type_name -> yandex.cloud.mdb.greenplum.v1.MaintenanceWindow
	17, // 10: yandex.cloud.mdb.greenplum.v1.Cluster.planned_operation:type_name -> yandex.cloud.mdb.greenplum.v1.MaintenanceOperation
	4,  // 11: yandex.cloud.mdb.greenplum.v1.Cluster.cluster_config:type_name -> yandex.cloud.mdb.greenplum.v1.ClusterConfigSet
	10, // 12: yandex.cloud.mdb.greenplum.v1.Cluster.cloud_storage:type_name -> yandex.cloud.mdb.greenplum.v1.CloudStorage
	11, // 13: yandex.cloud.mdb.greenplum.v1.Cluster.logging:type_name -> yandex.cloud.mdb.greenplum.v1.LoggingConfig
	18, // 14: yandex.cloud.mdb.greenplum.v1.ClusterConfigSet.greenplum_config_set_6:type_name -> yandex.cloud.mdb.greenplum.v1.GreenplumConfigSet6
	19, // 15: yandex.cloud.mdb.greenplum.v1.ClusterConfigSet.pool:type_name -> yandex.cloud.mdb.greenplum.v1.ConnectionPoolerConfigSet
	20, // 16: yandex.cloud.mdb.greenplum.v1.ClusterConfigSet.background_activities:type_name -> yandex.cloud.mdb.greenplum.v1.BackgroundActivitiesConfig
	21, // 17: yandex.cloud.mdb.greenplum.v1.ClusterConfigSet.pxf_config:type_name -> yandex.cloud.mdb.greenplum.v1.PXFConfigSet
	22, // 18: yandex.cloud.mdb.greenplum.v1.GreenplumConfig.backup_window_start:type_name -> google.type.TimeOfDay
	23, // 19: yandex.cloud.mdb.greenplum.v1.GreenplumConfig.backup_retain_period_days:type_name -> google.protobuf.Int64Value
	7,  // 20: yandex.cloud.mdb.greenplum.v1.GreenplumConfig.access:type_name -> yandex.cloud.mdb.greenplum.v1.Access
	22, // 21: yandex.cloud.mdb.greenplum.v1.GreenplumRestoreConfig.backup_window_start:type_name -> google.type.TimeOfDay
	7,  // 22: yandex.cloud.mdb.greenplum.v1.GreenplumRestoreConfig.access:type_name -> yandex.cloud.mdb.greenplum.v1.Access
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_yandex_cloud_mdb_greenplum_v1_cluster_proto_init() }
func file_yandex_cloud_mdb_greenplum_v1_cluster_proto_init() {
	if File_yandex_cloud_mdb_greenplum_v1_cluster_proto != nil {
		return
	}
	file_yandex_cloud_mdb_greenplum_v1_config_proto_init()
	file_yandex_cloud_mdb_greenplum_v1_maintenance_proto_init()
	file_yandex_cloud_mdb_greenplum_v1_pxf_proto_init()
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[1].OneofWrappers = []any{
		(*ClusterConfigSet_GreenplumConfigSet_6)(nil),
	}
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes[8].OneofWrappers = []any{
		(*LoggingConfig_FolderId)(nil),
		(*LoggingConfig_LogGroupId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDesc), len(file_yandex_cloud_mdb_greenplum_v1_cluster_proto_rawDesc)),
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_yandex_cloud_mdb_greenplum_v1_cluster_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_mdb_greenplum_v1_cluster_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_mdb_greenplum_v1_cluster_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_mdb_greenplum_v1_cluster_proto_msgTypes,
	}.Build()
	File_yandex_cloud_mdb_greenplum_v1_cluster_proto = out.File
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_goTypes = nil
	file_yandex_cloud_mdb_greenplum_v1_cluster_proto_depIdxs = nil
}
