// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        v3.21.12
// source: yandex/cloud/serverless/triggers/v1/trigger_service.proto

package triggers

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to return.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetTriggerRequest) Reset() {
	*x = GetTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTriggerRequest) ProtoMessage() {}

func (x *GetTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTriggerRequest.ProtoReflect.Descriptor instead.
func (*GetTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type ListTriggersRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list triggers in.
	//
	// To get a folder ID use a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// The maximum number of results per page to return. If the number of available
	// results is larger than `pageSize`, the service returns a [ListTriggersResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListTriggersResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters triggers listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	// Example of a filter: `name=my-trigger`.
	Filter        string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTriggersRequest) Reset() {
	*x = ListTriggersRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTriggersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTriggersRequest) ProtoMessage() {}

func (x *ListTriggersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTriggersRequest.ProtoReflect.Descriptor instead.
func (*ListTriggersRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListTriggersRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *ListTriggersRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTriggersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTriggersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListTriggersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of triggers in the specified folder.
	Triggers []*Trigger `protobuf:"bytes,1,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListTriggersRequest.page_size], use `nextPageToken` as the value
	// for the [ListTriggersRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTriggersResponse) Reset() {
	*x = ListTriggersResponse{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTriggersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTriggersResponse) ProtoMessage() {}

func (x *ListTriggersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTriggersResponse.ProtoReflect.Descriptor instead.
func (*ListTriggersResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListTriggersResponse) GetTriggers() []*Trigger {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *ListTriggersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to create a trigger in.
	//
	// To get a folder ID make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Name of the trigger.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the trigger.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Resource labels as `key:value` pairs.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Trigger type.
	Rule          *Trigger_Rule `protobuf:"bytes,5,opt,name=rule,proto3" json:"rule,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateTriggerRequest) Reset() {
	*x = CreateTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTriggerRequest) ProtoMessage() {}

func (x *CreateTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTriggerRequest.ProtoReflect.Descriptor instead.
func (*CreateTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateTriggerRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateTriggerRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CreateTriggerRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CreateTriggerRequest) GetRule() *Trigger_Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type CreateTriggerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger that is being created.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateTriggerMetadata) Reset() {
	*x = CreateTriggerMetadata{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTriggerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTriggerMetadata) ProtoMessage() {}

func (x *CreateTriggerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTriggerMetadata.ProtoReflect.Descriptor instead.
func (*CreateTriggerMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateTriggerMetadata) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type UpdateTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to update.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Field mask that specifies which attributes of the trigger should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// New name for the trigger.
	// The name must be unique within the folder.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// New description of the trigger.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Trigger labels as `key:value` pairs.
	//
	// Existing set of labels is completely replaced by the provided set, so if you just want
	// to add or remove a label, request the current set of labels with a [TriggerService.Get] request.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// New parameters for trigger.
	Rule          *Trigger_Rule `protobuf:"bytes,6,opt,name=rule,proto3" json:"rule,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateTriggerRequest) Reset() {
	*x = UpdateTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTriggerRequest) ProtoMessage() {}

func (x *UpdateTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTriggerRequest.ProtoReflect.Descriptor instead.
func (*UpdateTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *UpdateTriggerRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTriggerRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateTriggerRequest) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *UpdateTriggerRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *UpdateTriggerRequest) GetRule() *Trigger_Rule {
	if x != nil {
		return x.Rule
	}
	return nil
}

type UpdateTriggerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger that is being updated.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateTriggerMetadata) Reset() {
	*x = UpdateTriggerMetadata{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTriggerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTriggerMetadata) ProtoMessage() {}

func (x *UpdateTriggerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTriggerMetadata.ProtoReflect.Descriptor instead.
func (*UpdateTriggerMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateTriggerMetadata) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type DeleteTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to delete.
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTriggerRequest) Reset() {
	*x = DeleteTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTriggerRequest) ProtoMessage() {}

func (x *DeleteTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTriggerRequest.ProtoReflect.Descriptor instead.
func (*DeleteTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type DeleteTriggerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger that is being deleted.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteTriggerMetadata) Reset() {
	*x = DeleteTriggerMetadata{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTriggerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTriggerMetadata) ProtoMessage() {}

func (x *DeleteTriggerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTriggerMetadata.ProtoReflect.Descriptor instead.
func (*DeleteTriggerMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteTriggerMetadata) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type PauseTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to pause
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PauseTriggerRequest) Reset() {
	*x = PauseTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseTriggerRequest) ProtoMessage() {}

func (x *PauseTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseTriggerRequest.ProtoReflect.Descriptor instead.
func (*PauseTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{9}
}

func (x *PauseTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type PauseTriggerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger that is being paused.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PauseTriggerMetadata) Reset() {
	*x = PauseTriggerMetadata{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseTriggerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseTriggerMetadata) ProtoMessage() {}

func (x *PauseTriggerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseTriggerMetadata.ProtoReflect.Descriptor instead.
func (*PauseTriggerMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{10}
}

func (x *PauseTriggerMetadata) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type ResumeTriggerRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to pause
	//
	// To get a trigger ID make a [TriggerService.List] request.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResumeTriggerRequest) Reset() {
	*x = ResumeTriggerRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeTriggerRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeTriggerRequest) ProtoMessage() {}

func (x *ResumeTriggerRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeTriggerRequest.ProtoReflect.Descriptor instead.
func (*ResumeTriggerRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{11}
}

func (x *ResumeTriggerRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type ResumeTriggerMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger that is being paused.
	TriggerId     string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResumeTriggerMetadata) Reset() {
	*x = ResumeTriggerMetadata{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeTriggerMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeTriggerMetadata) ProtoMessage() {}

func (x *ResumeTriggerMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeTriggerMetadata.ProtoReflect.Descriptor instead.
func (*ResumeTriggerMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{12}
}

func (x *ResumeTriggerMetadata) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

type ListTriggerOperationsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the trigger to list operations for.
	TriggerId string `protobuf:"bytes,1,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// The maximum number of results per page that should be returned. If the number of available
	// results is larger than `pageSize`, the service returns a [ListTriggerOperationsResponse.next_page_token]
	// that can be used to get the next page of results in subsequent list requests.
	//
	// Default value: 100.
	PageSize int64 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token. To get the next page of results, set `pageToken` to the
	// [ListTriggerOperationsResponse.next_page_token] returned by a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	//
	// The expression must specify:
	// 1. The field name. Currently filtering can only be applied to the [Trigger.name] field.
	// 2. An `=` operator.
	// 3. The value in double quotes (`"`). Must be 3-63 characters long and match the regular expression `[a-z][-a-z0-9]{1,61}[a-z0-9]`.
	// Example of a filter: `name=my-function`.
	Filter        string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTriggerOperationsRequest) Reset() {
	*x = ListTriggerOperationsRequest{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTriggerOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTriggerOperationsRequest) ProtoMessage() {}

func (x *ListTriggerOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTriggerOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListTriggerOperationsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListTriggerOperationsRequest) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *ListTriggerOperationsRequest) GetPageSize() int64 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTriggerOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTriggerOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type ListTriggerOperationsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of operations for the specified trigger.
	Operations []*operation.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// Token for getting the next page of the list. If the number of results is greater than
	// the specified [ListTriggerOperationsRequest.page_size], use `nextPageToken` as the value
	// for the [ListTriggerOperationsRequest.page_token] parameter in the next list request.
	//
	// Each subsequent page will have its own `nextPageToken` to continue paging through the results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListTriggerOperationsResponse) Reset() {
	*x = ListTriggerOperationsResponse{}
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTriggerOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTriggerOperationsResponse) ProtoMessage() {}

func (x *ListTriggerOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTriggerOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListTriggerOperationsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListTriggerOperationsResponse) GetOperations() []*operation.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListTriggerOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_yandex_cloud_serverless_triggers_v1_trigger_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDesc = "" +
	"\n" +
	"9yandex/cloud/serverless/triggers/v1/trigger_service.proto\x12#yandex.cloud.serverless.triggers.v1\x1a google/protobuf/field_mask.proto\x1a\x1cgoogle/api/annotations.proto\x1a yandex/cloud/api/operation.proto\x1a1yandex/cloud/serverless/triggers/v1/trigger.proto\x1a&yandex/cloud/operation/operation.proto\x1a\x1dyandex/cloud/validation.proto\"8\n" +
	"\x11GetTriggerRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\"\x8c\x01\n" +
	"\x13ListTriggersRequest\x12!\n" +
	"\tfolder_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\bfolderId\x12\x1b\n" +
	"\tpage_size\x18\x02 \x01(\x03R\bpageSize\x12\x1d\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tR\tpageToken\x12\x16\n" +
	"\x06filter\x18\x04 \x01(\tR\x06filter\"\x88\x01\n" +
	"\x14ListTriggersResponse\x12H\n" +
	"\btriggers\x18\x01 \x03(\v2,.yandex.cloud.serverless.triggers.v1.TriggerR\btriggers\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken\"\xca\x03\n" +
	"\x14CreateTriggerRequest\x12!\n" +
	"\tfolder_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\bfolderId\x125\n" +
	"\x04name\x18\x02 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x03 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\xa2\x01\n" +
	"\x06labels\x18\x04 \x03(\v2E.yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12K\n" +
	"\x04rule\x18\x05 \x01(\v21.yandex.cloud.serverless.triggers.v1.Trigger.RuleB\x04\xe8\xc71\x01R\x04rule\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"6\n" +
	"\x15CreateTriggerMetadata\x12\x1d\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tR\ttriggerId\"\x83\x04\n" +
	"\x14UpdateTriggerRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\x12;\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskR\n" +
	"updateMask\x125\n" +
	"\x04name\x18\x03 \x01(\tB!\xf2\xc71\x1d|[a-z][-a-z0-9]{1,61}[a-z0-9]R\x04name\x12+\n" +
	"\vdescription\x18\x04 \x01(\tB\t\x8a\xc81\x05<=256R\vdescription\x12\xa2\x01\n" +
	"\x06labels\x18\x05 \x03(\v2E.yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.LabelsEntryBC\xf2\xc71\x0f[-_./\\@0-9a-z]*\x82\xc81\x04<=64\x8a\xc81\x04<=63\xb2\xc81\x1c\x12\x14[a-z][-_./\\@0-9a-z]*\x1a\x041-63R\x06labels\x12E\n" +
	"\x04rule\x18\x06 \x01(\v21.yandex.cloud.serverless.triggers.v1.Trigger.RuleR\x04rule\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"<\n" +
	"\x15UpdateTriggerMetadata\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\";\n" +
	"\x14DeleteTriggerRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\"<\n" +
	"\x15DeleteTriggerMetadata\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\":\n" +
	"\x13PauseTriggerRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\";\n" +
	"\x14PauseTriggerMetadata\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\";\n" +
	"\x14ResumeTriggerRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\"<\n" +
	"\x15ResumeTriggerMetadata\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\"\xba\x01\n" +
	"\x1cListTriggerOperationsRequest\x12#\n" +
	"\n" +
	"trigger_id\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\ttriggerId\x12'\n" +
	"\tpage_size\x18\x02 \x01(\x03B\n" +
	"\xfa\xc71\x060-1000R\bpageSize\x12(\n" +
	"\n" +
	"page_token\x18\x03 \x01(\tB\t\x8a\xc81\x05<=100R\tpageToken\x12\"\n" +
	"\x06filter\x18\x04 \x01(\tB\n" +
	"\x8a\xc81\x06<=1000R\x06filter\"\x8a\x01\n" +
	"\x1dListTriggerOperationsResponse\x12A\n" +
	"\n" +
	"operations\x18\x01 \x03(\v2!.yandex.cloud.operation.OperationR\n" +
	"operations\x12&\n" +
	"\x0fnext_page_token\x18\x02 \x01(\tR\rnextPageToken2\xcc\v\n" +
	"\x0eTriggerService\x12\x97\x01\n" +
	"\x03Get\x126.yandex.cloud.serverless.triggers.v1.GetTriggerRequest\x1a,.yandex.cloud.serverless.triggers.v1.Trigger\"*\x82\xd3\xe4\x93\x02$\x12\"/triggers/v1/triggers/{trigger_id}\x12\x9a\x01\n" +
	"\x04List\x128.yandex.cloud.serverless.triggers.v1.ListTriggersRequest\x1a9.yandex.cloud.serverless.triggers.v1.ListTriggersResponse\"\x1d\x82\xd3\xe4\x93\x02\x17\x12\x15/triggers/v1/triggers\x12\xac\x01\n" +
	"\x06Create\x129.yandex.cloud.serverless.triggers.v1.CreateTriggerRequest\x1a!.yandex.cloud.operation.Operation\"D\xb2\xd2* \n" +
	"\x15CreateTriggerMetadata\x12\aTrigger\x82\xd3\xe4\x93\x02\x1a:\x01*\"\x15/triggers/v1/triggers\x12\xb9\x01\n" +
	"\x06Update\x129.yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest\x1a!.yandex.cloud.operation.Operation\"Q\xb2\xd2* \n" +
	"\x15UpdateTriggerMetadata\x12\aTrigger\x82\xd3\xe4\x93\x02':\x01*2\"/triggers/v1/triggers/{trigger_id}\x12\xc4\x01\n" +
	"\x06Delete\x129.yandex.cloud.serverless.triggers.v1.DeleteTriggerRequest\x1a!.yandex.cloud.operation.Operation\"\\\xb2\xd2*.\n" +
	"\x15DeleteTriggerMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02$*\"/triggers/v1/triggers/{trigger_id}\x12\xbc\x01\n" +
	"\x05Pause\x128.yandex.cloud.serverless.triggers.v1.PauseTriggerRequest\x1a!.yandex.cloud.operation.Operation\"V\xb2\xd2*\x1f\n" +
	"\x14PauseTriggerMetadata\x12\aTrigger\x82\xd3\xe4\x93\x02-:\x01*\"(/triggers/v1/triggers/{trigger_id}:pause\x12\xc0\x01\n" +
	"\x06Resume\x129.yandex.cloud.serverless.triggers.v1.ResumeTriggerRequest\x1a!.yandex.cloud.operation.Operation\"X\xb2\xd2* \n" +
	"\x15ResumeTriggerMetadata\x12\aTrigger\x82\xd3\xe4\x93\x02.:\x01*\")/triggers/v1/triggers/{trigger_id}:resume\x12\xce\x01\n" +
	"\x0eListOperations\x12A.yandex.cloud.serverless.triggers.v1.ListTriggerOperationsRequest\x1aB.yandex.cloud.serverless.triggers.v1.ListTriggerOperationsResponse\"5\x82\xd3\xe4\x93\x02/\x12-/triggers/v1/triggers/{trigger_id}/operationsB{\n" +
	"'yandex.cloud.api.serverless.triggers.v1ZPgithub.com/yandex-cloud/go-genproto/yandex/cloud/serverless/triggers/v1;triggersb\x06proto3"

var (
	file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescData []byte
)

func file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDesc), len(file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDesc)))
	})
	return file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDescData
}

var file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_goTypes = []any{
	(*GetTriggerRequest)(nil),             // 0: yandex.cloud.serverless.triggers.v1.GetTriggerRequest
	(*ListTriggersRequest)(nil),           // 1: yandex.cloud.serverless.triggers.v1.ListTriggersRequest
	(*ListTriggersResponse)(nil),          // 2: yandex.cloud.serverless.triggers.v1.ListTriggersResponse
	(*CreateTriggerRequest)(nil),          // 3: yandex.cloud.serverless.triggers.v1.CreateTriggerRequest
	(*CreateTriggerMetadata)(nil),         // 4: yandex.cloud.serverless.triggers.v1.CreateTriggerMetadata
	(*UpdateTriggerRequest)(nil),          // 5: yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest
	(*UpdateTriggerMetadata)(nil),         // 6: yandex.cloud.serverless.triggers.v1.UpdateTriggerMetadata
	(*DeleteTriggerRequest)(nil),          // 7: yandex.cloud.serverless.triggers.v1.DeleteTriggerRequest
	(*DeleteTriggerMetadata)(nil),         // 8: yandex.cloud.serverless.triggers.v1.DeleteTriggerMetadata
	(*PauseTriggerRequest)(nil),           // 9: yandex.cloud.serverless.triggers.v1.PauseTriggerRequest
	(*PauseTriggerMetadata)(nil),          // 10: yandex.cloud.serverless.triggers.v1.PauseTriggerMetadata
	(*ResumeTriggerRequest)(nil),          // 11: yandex.cloud.serverless.triggers.v1.ResumeTriggerRequest
	(*ResumeTriggerMetadata)(nil),         // 12: yandex.cloud.serverless.triggers.v1.ResumeTriggerMetadata
	(*ListTriggerOperationsRequest)(nil),  // 13: yandex.cloud.serverless.triggers.v1.ListTriggerOperationsRequest
	(*ListTriggerOperationsResponse)(nil), // 14: yandex.cloud.serverless.triggers.v1.ListTriggerOperationsResponse
	nil,                                   // 15: yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.LabelsEntry
	nil,                                   // 16: yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.LabelsEntry
	(*Trigger)(nil),                       // 17: yandex.cloud.serverless.triggers.v1.Trigger
	(*Trigger_Rule)(nil),                  // 18: yandex.cloud.serverless.triggers.v1.Trigger.Rule
	(*fieldmaskpb.FieldMask)(nil),         // 19: google.protobuf.FieldMask
	(*operation.Operation)(nil),           // 20: yandex.cloud.operation.Operation
}
var file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_depIdxs = []int32{
	17, // 0: yandex.cloud.serverless.triggers.v1.ListTriggersResponse.triggers:type_name -> yandex.cloud.serverless.triggers.v1.Trigger
	15, // 1: yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.labels:type_name -> yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.LabelsEntry
	18, // 2: yandex.cloud.serverless.triggers.v1.CreateTriggerRequest.rule:type_name -> yandex.cloud.serverless.triggers.v1.Trigger.Rule
	19, // 3: yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.update_mask:type_name -> google.protobuf.FieldMask
	16, // 4: yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.labels:type_name -> yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.LabelsEntry
	18, // 5: yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest.rule:type_name -> yandex.cloud.serverless.triggers.v1.Trigger.Rule
	20, // 6: yandex.cloud.serverless.triggers.v1.ListTriggerOperationsResponse.operations:type_name -> yandex.cloud.operation.Operation
	0,  // 7: yandex.cloud.serverless.triggers.v1.TriggerService.Get:input_type -> yandex.cloud.serverless.triggers.v1.GetTriggerRequest
	1,  // 8: yandex.cloud.serverless.triggers.v1.TriggerService.List:input_type -> yandex.cloud.serverless.triggers.v1.ListTriggersRequest
	3,  // 9: yandex.cloud.serverless.triggers.v1.TriggerService.Create:input_type -> yandex.cloud.serverless.triggers.v1.CreateTriggerRequest
	5,  // 10: yandex.cloud.serverless.triggers.v1.TriggerService.Update:input_type -> yandex.cloud.serverless.triggers.v1.UpdateTriggerRequest
	7,  // 11: yandex.cloud.serverless.triggers.v1.TriggerService.Delete:input_type -> yandex.cloud.serverless.triggers.v1.DeleteTriggerRequest
	9,  // 12: yandex.cloud.serverless.triggers.v1.TriggerService.Pause:input_type -> yandex.cloud.serverless.triggers.v1.PauseTriggerRequest
	11, // 13: yandex.cloud.serverless.triggers.v1.TriggerService.Resume:input_type -> yandex.cloud.serverless.triggers.v1.ResumeTriggerRequest
	13, // 14: yandex.cloud.serverless.triggers.v1.TriggerService.ListOperations:input_type -> yandex.cloud.serverless.triggers.v1.ListTriggerOperationsRequest
	17, // 15: yandex.cloud.serverless.triggers.v1.TriggerService.Get:output_type -> yandex.cloud.serverless.triggers.v1.Trigger
	2,  // 16: yandex.cloud.serverless.triggers.v1.TriggerService.List:output_type -> yandex.cloud.serverless.triggers.v1.ListTriggersResponse
	20, // 17: yandex.cloud.serverless.triggers.v1.TriggerService.Create:output_type -> yandex.cloud.operation.Operation
	20, // 18: yandex.cloud.serverless.triggers.v1.TriggerService.Update:output_type -> yandex.cloud.operation.Operation
	20, // 19: yandex.cloud.serverless.triggers.v1.TriggerService.Delete:output_type -> yandex.cloud.operation.Operation
	20, // 20: yandex.cloud.serverless.triggers.v1.TriggerService.Pause:output_type -> yandex.cloud.operation.Operation
	20, // 21: yandex.cloud.serverless.triggers.v1.TriggerService.Resume:output_type -> yandex.cloud.operation.Operation
	14, // 22: yandex.cloud.serverless.triggers.v1.TriggerService.ListOperations:output_type -> yandex.cloud.serverless.triggers.v1.ListTriggerOperationsResponse
	15, // [15:23] is the sub-list for method output_type
	7,  // [7:15] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_init() }
func file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_init() {
	if File_yandex_cloud_serverless_triggers_v1_trigger_service_proto != nil {
		return
	}
	file_yandex_cloud_serverless_triggers_v1_trigger_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDesc), len(file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_depIdxs,
		MessageInfos:      file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_serverless_triggers_v1_trigger_service_proto = out.File
	file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_goTypes = nil
	file_yandex_cloud_serverless_triggers_v1_trigger_service_proto_depIdxs = nil
}
