// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.6.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/stream_line_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	StreamLineService_Get_FullMethodName             = "/yandex.cloud.video.v1.StreamLineService/Get"
	StreamLineService_List_FullMethodName            = "/yandex.cloud.video.v1.StreamLineService/List"
	StreamLineService_BatchGet_FullMethodName        = "/yandex.cloud.video.v1.StreamLineService/BatchGet"
	StreamLineService_Create_FullMethodName          = "/yandex.cloud.video.v1.StreamLineService/Create"
	StreamLineService_Update_FullMethodName          = "/yandex.cloud.video.v1.StreamLineService/Update"
	StreamLineService_Delete_FullMethodName          = "/yandex.cloud.video.v1.StreamLineService/Delete"
	StreamLineService_BatchDelete_FullMethodName     = "/yandex.cloud.video.v1.StreamLineService/BatchDelete"
	StreamLineService_PerformAction_FullMethodName   = "/yandex.cloud.video.v1.StreamLineService/PerformAction"
	StreamLineService_GetStreamKey_FullMethodName    = "/yandex.cloud.video.v1.StreamLineService/GetStreamKey"
	StreamLineService_UpdateStreamKey_FullMethodName = "/yandex.cloud.video.v1.StreamLineService/UpdateStreamKey"
)

// StreamLineServiceClient is the client API for StreamLineService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Stream line management service.
// Provides methods for creating, retrieving, updating, and deleting stream lines,
// which define the technical configuration for receiving and processing video signals.
type StreamLineServiceClient interface {
	// Retrieves detailed information about a specific stream line by its ID.
	// Returns all stream line metadata, configuration, and related information.
	Get(ctx context.Context, in *GetStreamLineRequest, opts ...grpc.CallOption) (*StreamLine, error)
	// Lists all stream lines in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListStreamLinesRequest, opts ...grpc.CallOption) (*ListStreamLinesResponse, error)
	// Retrieves multiple stream lines by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several stream lines.
	BatchGet(ctx context.Context, in *BatchGetStreamLinesRequest, opts ...grpc.CallOption) (*BatchGetStreamLinesResponse, error)
	// Creates a new stream line in the specified channel with the provided configuration.
	// Stream lines define the technical settings for receiving and processing video signals.
	Create(ctx context.Context, in *CreateStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates an existing stream line's metadata and configuration.
	// Only fields specified in the field_mask will be updated.
	Update(ctx context.Context, in *UpdateStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes a specific stream line by its ID.
	Delete(ctx context.Context, in *DeleteStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes multiple stream lines in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several stream lines.
	BatchDelete(ctx context.Context, in *BatchDeleteStreamLinesRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Performs a specific action on a stream line, such as activation or deactivation.
	// Actions change the stream line's state without modifying its configuration.
	PerformAction(ctx context.Context, in *PerformLineActionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Retrieves the unique stream key for a push-type stream line.
	// This key is used to authenticate when pushing video streams to the platform.
	GetStreamKey(ctx context.Context, in *GetStreamKeyRequest, opts ...grpc.CallOption) (*PushStreamKey, error)
	// Regenerates and updates the stream key for a push-type stream line.
	// This is useful for security purposes when the existing key may be compromised.
	UpdateStreamKey(ctx context.Context, in *UpdateStreamKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type streamLineServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreamLineServiceClient(cc grpc.ClientConnInterface) StreamLineServiceClient {
	return &streamLineServiceClient{cc}
}

func (c *streamLineServiceClient) Get(ctx context.Context, in *GetStreamLineRequest, opts ...grpc.CallOption) (*StreamLine, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(StreamLine)
	err := c.cc.Invoke(ctx, StreamLineService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) List(ctx context.Context, in *ListStreamLinesRequest, opts ...grpc.CallOption) (*ListStreamLinesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListStreamLinesResponse)
	err := c.cc.Invoke(ctx, StreamLineService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) BatchGet(ctx context.Context, in *BatchGetStreamLinesRequest, opts ...grpc.CallOption) (*BatchGetStreamLinesResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGetStreamLinesResponse)
	err := c.cc.Invoke(ctx, StreamLineService_BatchGet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) Create(ctx context.Context, in *CreateStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) Update(ctx context.Context, in *UpdateStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) Delete(ctx context.Context, in *DeleteStreamLineRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) BatchDelete(ctx context.Context, in *BatchDeleteStreamLinesRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_BatchDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) PerformAction(ctx context.Context, in *PerformLineActionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_PerformAction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) GetStreamKey(ctx context.Context, in *GetStreamKeyRequest, opts ...grpc.CallOption) (*PushStreamKey, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(PushStreamKey)
	err := c.cc.Invoke(ctx, StreamLineService_GetStreamKey_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *streamLineServiceClient) UpdateStreamKey(ctx context.Context, in *UpdateStreamKeyRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, StreamLineService_UpdateStreamKey_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StreamLineServiceServer is the server API for StreamLineService service.
// All implementations should embed UnimplementedStreamLineServiceServer
// for forward compatibility.
//
// Stream line management service.
// Provides methods for creating, retrieving, updating, and deleting stream lines,
// which define the technical configuration for receiving and processing video signals.
type StreamLineServiceServer interface {
	// Retrieves detailed information about a specific stream line by its ID.
	// Returns all stream line metadata, configuration, and related information.
	Get(context.Context, *GetStreamLineRequest) (*StreamLine, error)
	// Lists all stream lines in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListStreamLinesRequest) (*ListStreamLinesResponse, error)
	// Retrieves multiple stream lines by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several stream lines.
	BatchGet(context.Context, *BatchGetStreamLinesRequest) (*BatchGetStreamLinesResponse, error)
	// Creates a new stream line in the specified channel with the provided configuration.
	// Stream lines define the technical settings for receiving and processing video signals.
	Create(context.Context, *CreateStreamLineRequest) (*operation.Operation, error)
	// Updates an existing stream line's metadata and configuration.
	// Only fields specified in the field_mask will be updated.
	Update(context.Context, *UpdateStreamLineRequest) (*operation.Operation, error)
	// Deletes a specific stream line by its ID.
	Delete(context.Context, *DeleteStreamLineRequest) (*operation.Operation, error)
	// Deletes multiple stream lines in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several stream lines.
	BatchDelete(context.Context, *BatchDeleteStreamLinesRequest) (*operation.Operation, error)
	// Performs a specific action on a stream line, such as activation or deactivation.
	// Actions change the stream line's state without modifying its configuration.
	PerformAction(context.Context, *PerformLineActionRequest) (*operation.Operation, error)
	// Retrieves the unique stream key for a push-type stream line.
	// This key is used to authenticate when pushing video streams to the platform.
	GetStreamKey(context.Context, *GetStreamKeyRequest) (*PushStreamKey, error)
	// Regenerates and updates the stream key for a push-type stream line.
	// This is useful for security purposes when the existing key may be compromised.
	UpdateStreamKey(context.Context, *UpdateStreamKeyRequest) (*operation.Operation, error)
}

// UnimplementedStreamLineServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedStreamLineServiceServer struct{}

func (UnimplementedStreamLineServiceServer) Get(context.Context, *GetStreamLineRequest) (*StreamLine, error) {
	return nil, status.Error(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedStreamLineServiceServer) List(context.Context, *ListStreamLinesRequest) (*ListStreamLinesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedStreamLineServiceServer) BatchGet(context.Context, *BatchGetStreamLinesRequest) (*BatchGetStreamLinesResponse, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchGet not implemented")
}
func (UnimplementedStreamLineServiceServer) Create(context.Context, *CreateStreamLineRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedStreamLineServiceServer) Update(context.Context, *UpdateStreamLineRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedStreamLineServiceServer) Delete(context.Context, *DeleteStreamLineRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedStreamLineServiceServer) BatchDelete(context.Context, *BatchDeleteStreamLinesRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method BatchDelete not implemented")
}
func (UnimplementedStreamLineServiceServer) PerformAction(context.Context, *PerformLineActionRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method PerformAction not implemented")
}
func (UnimplementedStreamLineServiceServer) GetStreamKey(context.Context, *GetStreamKeyRequest) (*PushStreamKey, error) {
	return nil, status.Error(codes.Unimplemented, "method GetStreamKey not implemented")
}
func (UnimplementedStreamLineServiceServer) UpdateStreamKey(context.Context, *UpdateStreamKeyRequest) (*operation.Operation, error) {
	return nil, status.Error(codes.Unimplemented, "method UpdateStreamKey not implemented")
}
func (UnimplementedStreamLineServiceServer) testEmbeddedByValue() {}

// UnsafeStreamLineServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to StreamLineServiceServer will
// result in compilation errors.
type UnsafeStreamLineServiceServer interface {
	mustEmbedUnimplementedStreamLineServiceServer()
}

func RegisterStreamLineServiceServer(s grpc.ServiceRegistrar, srv StreamLineServiceServer) {
	// If the following call panics, it indicates UnimplementedStreamLineServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&StreamLineService_ServiceDesc, srv)
}

func _StreamLineService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStreamLineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).Get(ctx, req.(*GetStreamLineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStreamLinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).List(ctx, req.(*ListStreamLinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_BatchGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetStreamLinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).BatchGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_BatchGet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).BatchGet(ctx, req.(*BatchGetStreamLinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStreamLineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).Create(ctx, req.(*CreateStreamLineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStreamLineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).Update(ctx, req.(*UpdateStreamLineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStreamLineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).Delete(ctx, req.(*DeleteStreamLineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_BatchDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteStreamLinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).BatchDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_BatchDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).BatchDelete(ctx, req.(*BatchDeleteStreamLinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_PerformAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PerformLineActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).PerformAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_PerformAction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).PerformAction(ctx, req.(*PerformLineActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_GetStreamKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStreamKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).GetStreamKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_GetStreamKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).GetStreamKey(ctx, req.(*GetStreamKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StreamLineService_UpdateStreamKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateStreamKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StreamLineServiceServer).UpdateStreamKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: StreamLineService_UpdateStreamKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StreamLineServiceServer).UpdateStreamKey(ctx, req.(*UpdateStreamKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// StreamLineService_ServiceDesc is the grpc.ServiceDesc for StreamLineService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var StreamLineService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.StreamLineService",
	HandlerType: (*StreamLineServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _StreamLineService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _StreamLineService_List_Handler,
		},
		{
			MethodName: "BatchGet",
			Handler:    _StreamLineService_BatchGet_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _StreamLineService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _StreamLineService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _StreamLineService_Delete_Handler,
		},
		{
			MethodName: "BatchDelete",
			Handler:    _StreamLineService_BatchDelete_Handler,
		},
		{
			MethodName: "PerformAction",
			Handler:    _StreamLineService_PerformAction_Handler,
		},
		{
			MethodName: "GetStreamKey",
			Handler:    _StreamLineService_GetStreamKey_Handler,
		},
		{
			MethodName: "UpdateStreamKey",
			Handler:    _StreamLineService_UpdateStreamKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/stream_line_service.proto",
}
