package xlsx

import (
	"testing"

	qt "github.com/frankban/quicktest"
)

// Test that we can successfully read an XLSX file generated by
// Google Docs.
func TestGoogleDocsExcel(t *testing.T) {
	c := qt.New(t)
	csRunO(c, "OpenExcel", func(c *qt.C, option FileOption) {
		xlsxFile, err := OpenFile("./testdocs/googleDocsTest.xlsx", option)
		c.Assert(err, qt.IsNil)
		c.Assert(xlsxFile, qt.Not(qt.IsNil))
	})
}

// Test that we can successfully read an XLSX file generated by
// Microsoft Excel for Mac.  In particular this requires that we
// respect the contents of workbook.xml.rels, which maps the sheet IDs
// to their internal file names.
func TestMacExcel(t *testing.T) {
	c := qt.New(t)
	csRunO(c, "OpenMacExcel", func(c *qt.C, option FileOption) {
		xlsxFile, err := OpenFile("./testdocs/macExcelTest.xlsx", option)
		c.Assert(err, qt.IsNil)
		c.Assert(xlsxFile, qt.Not(qt.IsNil))
		sheet, ok := xlsxFile.Sheet["普通技能"]
		c.Assert(ok, qt.Equals, true)

		defer sheet.Close()
		cell, err := sheet.Cell(0, 0)
		c.Assert(err, qt.Equals, nil)
		if val, err := cell.FormattedValue(); err != nil {
			c.Error(err)
		} else {
			c.Assert(val, qt.Equals, "编号")
		}
	})
}

// Test that we can successfully read an XLSX file generated by
// Numbers for Mac.
func TestMacNumbers(t *testing.T) {
	c := qt.New(t)
	csRunO(c, "OpenMacNumbers", func(c *qt.C, option FileOption) {
		xlsxFile, err := OpenFile("./testdocs/macNumbersTest.xlsx", option)
		c.Assert(err, qt.IsNil)
		c.Assert(xlsxFile, qt.Not(qt.IsNil))
		sheet, ok := xlsxFile.Sheet["主动技能"]
		c.Assert(ok, qt.Equals, true)
		defer sheet.Close()
		cell, err := sheet.Cell(0, 0)
		c.Assert(err, qt.Equals, nil)
		if val, err := cell.FormattedValue(); err != nil {
			c.Error(err)
		} else {
			c.Assert(val, qt.Equals, "编号")
		}
	})
}

// Test that we can successfully read an XLSX file generated by
// Wps on windows. you can download it freely from http://www.wps.cn/
func TestWpsBlankLine(t *testing.T) {
	c := qt.New(t)
	csRunO(c, "OpenWps", func(c *qt.C, option FileOption) {
		xlsxFile, err := OpenFile("./testdocs/wpsBlankLineTest.xlsx", option)
		c.Assert(err, qt.Equals, nil)
		c.Assert(xlsxFile, qt.Not(qt.IsNil))
		sheet := xlsxFile.Sheet["Sheet1"]
		row, err := sheet.Row(0)
		c.Assert(err, qt.Equals, nil)
		cell := row.GetCell(0)

		expected := "编号"
		var val string

		if val, err = cell.FormattedValue(); err != nil {
			c.Error(err)
		}
		c.Assert(val, qt.Equals, expected)

		row, err = sheet.Row(2)
		c.Assert(err, qt.Equals, nil)
		cell = row.GetCell(0)
		if val, err = cell.FormattedValue(); err != nil {
			c.Error(err)
		}
		c.Assert(val, qt.Equals, expected)

		row, err = sheet.Row(4)
		c.Assert(err, qt.Equals, nil)
		cell = row.GetCell(1)
		if val, err = cell.FormattedValue(); err != nil {
			c.Error(err)
		}
		c.Assert(val, qt.Equals, "")

		if val, err = row.GetCell(2).FormattedValue(); err != nil {
			c.Error(err)
		}
		c.Assert(val, qt.Equals, expected)
	})
}
