// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/resourcemanager/v3/tag_bindings.proto

package resourcemanagerpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	TagBindings_ListTagBindings_FullMethodName   = "/google.cloud.resourcemanager.v3.TagBindings/ListTagBindings"
	TagBindings_CreateTagBinding_FullMethodName  = "/google.cloud.resourcemanager.v3.TagBindings/CreateTagBinding"
	TagBindings_DeleteTagBinding_FullMethodName  = "/google.cloud.resourcemanager.v3.TagBindings/DeleteTagBinding"
	TagBindings_ListEffectiveTags_FullMethodName = "/google.cloud.resourcemanager.v3.TagBindings/ListEffectiveTags"
)

// TagBindingsClient is the client API for TagBindings service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TagBindingsClient interface {
	// Lists the TagBindings for the given Google Cloud resource, as specified
	// with `parent`.
	//
	// NOTE: The `parent` field is expected to be a full resource name:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ListTagBindings(ctx context.Context, in *ListTagBindingsRequest, opts ...grpc.CallOption) (*ListTagBindingsResponse, error)
	// Creates a TagBinding between a TagValue and a Google Cloud resource.
	CreateTagBinding(ctx context.Context, in *CreateTagBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a TagBinding.
	DeleteTagBinding(ctx context.Context, in *DeleteTagBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Return a list of effective tags for the given Google Cloud resource, as
	// specified in `parent`.
	ListEffectiveTags(ctx context.Context, in *ListEffectiveTagsRequest, opts ...grpc.CallOption) (*ListEffectiveTagsResponse, error)
}

type tagBindingsClient struct {
	cc grpc.ClientConnInterface
}

func NewTagBindingsClient(cc grpc.ClientConnInterface) TagBindingsClient {
	return &tagBindingsClient{cc}
}

func (c *tagBindingsClient) ListTagBindings(ctx context.Context, in *ListTagBindingsRequest, opts ...grpc.CallOption) (*ListTagBindingsResponse, error) {
	out := new(ListTagBindingsResponse)
	err := c.cc.Invoke(ctx, TagBindings_ListTagBindings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagBindingsClient) CreateTagBinding(ctx context.Context, in *CreateTagBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagBindings_CreateTagBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagBindingsClient) DeleteTagBinding(ctx context.Context, in *DeleteTagBindingRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, TagBindings_DeleteTagBinding_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tagBindingsClient) ListEffectiveTags(ctx context.Context, in *ListEffectiveTagsRequest, opts ...grpc.CallOption) (*ListEffectiveTagsResponse, error) {
	out := new(ListEffectiveTagsResponse)
	err := c.cc.Invoke(ctx, TagBindings_ListEffectiveTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TagBindingsServer is the server API for TagBindings service.
// All implementations should embed UnimplementedTagBindingsServer
// for forward compatibility
type TagBindingsServer interface {
	// Lists the TagBindings for the given Google Cloud resource, as specified
	// with `parent`.
	//
	// NOTE: The `parent` field is expected to be a full resource name:
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	ListTagBindings(context.Context, *ListTagBindingsRequest) (*ListTagBindingsResponse, error)
	// Creates a TagBinding between a TagValue and a Google Cloud resource.
	CreateTagBinding(context.Context, *CreateTagBindingRequest) (*longrunningpb.Operation, error)
	// Deletes a TagBinding.
	DeleteTagBinding(context.Context, *DeleteTagBindingRequest) (*longrunningpb.Operation, error)
	// Return a list of effective tags for the given Google Cloud resource, as
	// specified in `parent`.
	ListEffectiveTags(context.Context, *ListEffectiveTagsRequest) (*ListEffectiveTagsResponse, error)
}

// UnimplementedTagBindingsServer should be embedded to have forward compatible implementations.
type UnimplementedTagBindingsServer struct {
}

func (UnimplementedTagBindingsServer) ListTagBindings(context.Context, *ListTagBindingsRequest) (*ListTagBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTagBindings not implemented")
}
func (UnimplementedTagBindingsServer) CreateTagBinding(context.Context, *CreateTagBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTagBinding not implemented")
}
func (UnimplementedTagBindingsServer) DeleteTagBinding(context.Context, *DeleteTagBindingRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTagBinding not implemented")
}
func (UnimplementedTagBindingsServer) ListEffectiveTags(context.Context, *ListEffectiveTagsRequest) (*ListEffectiveTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEffectiveTags not implemented")
}

// UnsafeTagBindingsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TagBindingsServer will
// result in compilation errors.
type UnsafeTagBindingsServer interface {
	mustEmbedUnimplementedTagBindingsServer()
}

func RegisterTagBindingsServer(s grpc.ServiceRegistrar, srv TagBindingsServer) {
	s.RegisterService(&TagBindings_ServiceDesc, srv)
}

func _TagBindings_ListTagBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagBindingsServer).ListTagBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagBindings_ListTagBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagBindingsServer).ListTagBindings(ctx, req.(*ListTagBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagBindings_CreateTagBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagBindingsServer).CreateTagBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagBindings_CreateTagBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagBindingsServer).CreateTagBinding(ctx, req.(*CreateTagBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagBindings_DeleteTagBinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagBindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagBindingsServer).DeleteTagBinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagBindings_DeleteTagBinding_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagBindingsServer).DeleteTagBinding(ctx, req.(*DeleteTagBindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TagBindings_ListEffectiveTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEffectiveTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TagBindingsServer).ListEffectiveTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: TagBindings_ListEffectiveTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TagBindingsServer).ListEffectiveTags(ctx, req.(*ListEffectiveTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// TagBindings_ServiceDesc is the grpc.ServiceDesc for TagBindings service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var TagBindings_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.resourcemanager.v3.TagBindings",
	HandlerType: (*TagBindingsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTagBindings",
			Handler:    _TagBindings_ListTagBindings_Handler,
		},
		{
			MethodName: "CreateTagBinding",
			Handler:    _TagBindings_CreateTagBinding_Handler,
		},
		{
			MethodName: "DeleteTagBinding",
			Handler:    _TagBindings_DeleteTagBinding_Handler,
		},
		{
			MethodName: "ListEffectiveTags",
			Handler:    _TagBindings_ListEffectiveTags_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/resourcemanager/v3/tag_bindings.proto",
}
