#include "ccextractor.h"

// Functions to parse a AVC/H.264 data stream, see ISO/IEC 14496-10 

int ccblocks_in_avc_total=0;
int ccblocks_in_avc_lost=0;

// local functions
static unsigned char *remove_03emu(unsigned char *from, unsigned char *to);
static void sei_rbsp (unsigned char *seibuf, unsigned char *seiend);
static unsigned char *sei_message (unsigned char *seibuf, unsigned char *seiend);
static void user_data_registered_itu_t_t35 (unsigned char *userbuf, unsigned char *userend);
static void seq_parameter_set_rbsp (unsigned char *seqbuf, unsigned char *seqend);
static void slice_header (unsigned char *heabuf, unsigned char *heaend, int nal_unit_type);

static unsigned char cc_count;
// buffer to hold cc data
static unsigned char *cc_data = (unsigned char*)malloc(1024);
static long cc_databufsize = 1024;
int cc_buffer_saved=1; // Was the CC buffer saved after it was last updated?

static int got_seq_para=0;
static unsigned nal_ref_idc;
static LLONG seq_parameter_set_id;
static int log2_max_frame_num=0;
static int pic_order_cnt_type;
static int log2_max_pic_order_cnt_lsb=0;
static int frame_mbs_only_flag;

// Use and throw stats for debug, remove this uglyness soon
long num_nal_unit_type_7=0;
long num_vcl_hrd=0;
long num_nal_hrd=0;
long num_jump_in_frames=0;
long num_unexpected_sei_length=0;

// Process inbuf bytes in buffer holding and AVC (H.264) video stream.
// The number of processed bytes is returned.
LLONG process_avc (unsigned char *avcbuf, LLONG avcbuflen)
{
    unsigned char *bpos = avcbuf;
    unsigned char *NALstart;
    unsigned char *NALstop;

    // At least 5 bytes are needed for a NAL unit
    if(avcbuflen <= 5)
    {
        fatal(EXIT_BUG_BUG,
              "NAL unit need at last 5 bytes ...");
    } 

    // Warning there should be only leading zeros, nothing else 
    if( !(bpos[0]==0x00 && bpos[1]==0x00) )
    {
        fatal(EXIT_BUG_BUG,
              "Broken AVC stream - no 0x0000 ...");
    } 
    bpos = bpos+2;

    int firstloop=1; // Check for valid start code at buffer start

    // Loop over NAL units
    do
    {
        int zeropad=0; // Count leading zeros

        // Find next NALstart
        while (bpos < avcbuf + avcbuflen)
        {
            if(*bpos == 0x01)
            {
                // OK, found a start code
                break;
            }
            else if(firstloop && *bpos != 0x00)
            {
                // Not 0x00 or 0x01
                fatal(EXIT_BUG_BUG,
                      "Broken AVC stream - no 0x00 ...");
            }
            bpos++;
            zeropad++;
        }
        firstloop=0;
        if (bpos >= avcbuf + avcbuflen)
        {
            // No new start sequence
            break;
        }
        NALstart = bpos+1;

        // Find next start code or buffer end
        long restlen;
        do
        {
            // Search for next 000000 or 000001
            bpos++;
            restlen = avcbuf - bpos + avcbuflen - 2; // leave room for two more bytes

            // Find the next zero
            if (restlen > 0)
            {
                bpos = (unsigned char *) memchr (bpos, 0x00, restlen);

                if(!bpos)
                {
                    // No 0x00 till the end of the buffer
                    NALstop = avcbuf + avcbuflen;
                    bpos = NALstop;
                    break;
                }

                if(bpos[1]==0x00 && (bpos[2]|0x01)==0x01)
                {
                    // Found new start code
                    NALstop = bpos;
                    bpos = bpos + 2; // Move after the two leading 0x00
                    break;
                }
            }
            else
            {
                NALstop = avcbuf + avcbuflen;
                bpos = NALstop;
                break;
            }
        }
        while(restlen); // Should never be true - loop is exited via break

        if(*NALstart & 0x80)
        {
            dump(NALstart-4,10, 0);
            fatal(EXIT_BUG_BUG,
                  "Broken AVC stream - forbidden_zero_bit not zero ...");
        }

        nal_ref_idc = *NALstart >> 5;
        unsigned nal_unit_type = *NALstart & 0x1F;

		dvprint("BEGIN NAL unit type: %d length %d  zeros: %d  ref_idc: %d - Buffered captions before: %d\n",
                nal_unit_type,  NALstop-NALstart-1, zeropad, nal_ref_idc, !cc_buffer_saved);

        if ( nal_unit_type == NAL_TYPE_ACCESS_UNIT_DELIMITER_9 )
        {
            // Found Access Unit Delimiter
        }
        else if ( nal_unit_type == NAL_TYPE_SEQUENCE_PARAMETER_SET_7 )
        {
            // Found sequence parameter set
            // We need this to parse NAL type 1 (NAL_TYPE_CODED_SLICE_NON_IDR_PICTURE_1)
			num_nal_unit_type_7++;
            NALstop = remove_03emu(NALstart+1, NALstop);
            seq_parameter_set_rbsp(NALstart+1, NALstop);
            got_seq_para = 1;
        }
        else if ( got_seq_para && (nal_unit_type == NAL_TYPE_CODED_SLICE_NON_IDR_PICTURE_1 || nal_unit_type == 5)) // Only if nal_unit_type=1
        {
            // Found coded slice of a non-IDR picture
            NALstop = remove_03emu(NALstart+1, NALstop);
            // We only need the slice header data, no need to implement
            // slice_layer_without_partitioning_rbsp( );
            slice_header(NALstart+1, NALstop, nal_unit_type);
        }
        else if ( got_seq_para && nal_unit_type == NAL_TYPE_SEI )
        {
            // Found SEI (used for subtitles)

            //set_fts(); // FIXME - check this!!!
            NALstop = remove_03emu(NALstart+1, NALstop);
            sei_rbsp(NALstart+1, NALstop);
        }
        else if ( got_seq_para && nal_unit_type == NAL_TYPE_PICTURE_PARAMETER_SET )
        {
            // Found Picture parameter set
        }
		dvprint("END   NAL unit type: %d length %d  zeros: %d  ref_idc: %d - Buffered captions after: %d\n",
                nal_unit_type,  NALstop-NALstart-1, zeropad, nal_ref_idc, !cc_buffer_saved);
    }
    while(bpos < avcbuf + avcbuflen - 2); // bpos points to 0x01 plus at least two bytes

    return avcbuflen;
}

#define ZEROBYTES_SHORTSTARTCODE 2 

// Copied for reference decoder, see if it behaves different that Volker's code
int EBSPtoRBSP(unsigned char *streamBuffer, int end_bytepos, int begin_bytepos)
{
  int i, j, count;
  count = 0;

  if(end_bytepos < begin_bytepos)
    return end_bytepos;

  j = begin_bytepos;

  for(i = begin_bytepos; i < end_bytepos; ++i)
  { //starting from begin_bytepos to avoid header information
    //in NAL unit, 0x000000, 0x000001 or 0x000002 shall not occur at any byte-aligned position
    if(count == ZEROBYTES_SHORTSTARTCODE && streamBuffer[i] < 0x03) 
      return -1;
    if(count == ZEROBYTES_SHORTSTARTCODE && streamBuffer[i] == 0x03)
    {
      //check the 4th byte after 0x000003, except when cabac_zero_word is used, in which case the last three bytes of this NAL unit must be 0x000003
      if((i < end_bytepos-1) && (streamBuffer[i+1] > 0x03))
        return -1;
      //if cabac_zero_word is used, the final byte of this NAL unit(0x03) is discarded, and the last two bytes of RBSP must be 0x0000
      if(i == end_bytepos-1)
        return j;

      ++i;
      count = 0;
    }
    streamBuffer[j] = streamBuffer[i];
    if(streamBuffer[i] == 0x00)
      ++count;
    else
      count = 0;
    ++j;
  }

  return j;
}


// Remove 0x000003 emulation sequences.
unsigned char *remove_03emu(unsigned char *from, unsigned char *to)
{
    int offset=0;
	int num=to-from;
	int newsize = EBSPtoRBSP (from,num,0); //TODO: Do something if newsize == -1 (broken NAL)

    return from+newsize;
	
}


// Process SEI payload in AVC data. This function combines sei_rbsp()
// and rbsp_trailing_bits().
void sei_rbsp (unsigned char *seibuf, unsigned char *seiend)
{
    unsigned char *tbuf = seibuf;
    while(tbuf < seiend - 1) // Use -1 because of trailing marker
    {
        tbuf = sei_message(tbuf, seiend - 1);
    }
    if(tbuf == seiend - 1 )
    {
        if(*tbuf != 0x80)
            printf("Strange rbsp_trailing_bits value: %02X\n",*tbuf);
    }	
    else
	{
		// TODO: This really really looks bad
		printf ("WARNING: Unexpected SEI unit length...trying to continue.");
		num_unexpected_sei_length++;
	}
}


// This combines sei_message() and sei_payload().
unsigned char *sei_message (unsigned char *seibuf, unsigned char *seiend)
{
    int payloadType = 0;
	while (*seibuf==0xff)
	{
		payloadType+=255;
		seibuf++;
	}
    payloadType += *seibuf; 
	seibuf++;

    
    int payloadSize = 0;
	while (*seibuf==0xff)
	{
		payloadSize+=255;
		seibuf++;
	}
    payloadSize += *seibuf; 
	seibuf++;
		
	int broken=0;
    unsigned char *paystart = seibuf;
    seibuf+=payloadSize;
	
    dvprint("Payload type: %d size: %d - ", payloadType, payloadSize);
	if(seibuf > seiend ) 
	{
		// TODO: What do we do here?
		broken=1;
		if (payloadType==4)		
		{
			if (debug_verbose)
				printf ("Warning: Subtitles payload seems incorrect (too long), continuing but it doesn't look good..");
		}
		else 
		{
			if (debug_verbose)
				printf ("Warning: Non-subtitles payload seems incorrect (too long), continuing but it doesn't look good..");
		}
	}
	if (debug_verbose)
		printf ("\n");
    // Ignore all except user_data_registered_itu_t_t35() payload
    if(!broken && payloadType == 4)
        user_data_registered_itu_t_t35(paystart, paystart+payloadSize);

    return seibuf;
}

void copy_ccdata_to_buffer (char *source, int new_cc_count)
{
	ccblocks_in_avc_total++;
	if (cc_buffer_saved==0)
	{
		if (cc_count!=1)
		{
			printf ("CFS: Interesting case: Non 1 cc_count (%d)\n",cc_count);
		}
		printf ("Warning: Probably loss of CC data, unsaved buffer being rewritten\n");
		ccblocks_in_avc_lost++;
		if (cc_data[1]!=0x80 || cc_data[2]!=0x80)
		{
			FILE *f=fopen ("f:\\lost.txt","a+t");
			fprintf (f,"%02X %02X %02X | %c%c | %c%c\n",cc_data[0],cc_data[1],cc_data[2],cc_data[1]&0x7f,cc_data[2]&0x7f,source[1]&0x07f, source[2]&0x07f);
			fclose (f);
		}
	}
	memcpy(cc_data+cc_count*3, source, new_cc_count*3+1); 
	cc_count+=new_cc_count;
	cc_buffer_saved=0;
}


void user_data_registered_itu_t_t35 (unsigned char *userbuf, unsigned char *userend)
{
    unsigned char *tbuf = userbuf;
	unsigned char *cc_tmpdata;
	unsigned char process_cc_data_flag;
	int user_data_type_code;
	int user_data_len ;
	int mandatory_0, mandatory_1;
	int local_cc_count=0;
	// int cc_count;
    int itu_t_t35_country_code = *((uint8_t*)tbuf);
    tbuf++;
    int itu_t_35_provider_code = *tbuf * 255 + *(tbuf+1); //TODO: Why 255 and not 256?
    tbuf+=2;

    // ANSI/SCTE 128 2008:
    // itu_t_t35_country_code == 0xB5
    // itu_t_35_provider_code == 0x0031
    // see spec for details - no example -> no support

    // Example files (sample.ts, ...):
    // itu_t_t35_country_code == 0xB5
    // itu_t_35_provider_code == 0x002F
    // user_data_type_code == 0x03 (cc_data)
    // user_data_len == next byte (length after this byte up to (incl) marker.)
    // cc_data struct (CEA-708)
    // marker == 0xFF

    if(itu_t_t35_country_code != 0xB5)
    {
        printf("Not a supported user data SEI\n");
        printf("  itu_t_35_country_code: %02x\n", itu_t_t35_country_code);
        return;
    }

	switch (itu_t_35_provider_code)
	{		
		case 0x0031: // ANSI/SCTE 128
			if (debug_verbose)
				printf ("Caption block in ANSI/SCTE 128...");
			if (*tbuf==0x47 && *(tbuf+1)==0x41 && *(tbuf+2)==0x39 && *(tbuf+3)==0x34) // ATSC1_data()
			{
				if (debug_verbose)
					printf ("ATSC1_data()...");
				tbuf+=4;
				unsigned char user_data_type_code=*tbuf;
				tbuf++;
				switch (user_data_type_code)
				{
					case 0x03:
						if (debug_verbose)
							printf ("cc_data (finally)!\n");
						/*
						cc_count = 2; // Forced test
						process_cc_data_flag = (*tbuf & 2) >> 1;
						mandatory_1 = (*tbuf & 1);
						mandatory_0 = (*tbuf & 4) >>2;
						if (!mandatory_1 || mandatory_0)
						{
							printf ("Essential tests not passed.\n");
							break;
						}
						*/
						local_cc_count= *tbuf & 0x1F;
						process_cc_data_flag = (*tbuf & 0x40) >> 6;
						
						if (!process_cc_data_flag)
						{
							printf ("process_cc_data_flag == 0, skipping this caption block.\n");
							break;
						}
	/*					if (userbuf[11]!=0x80 || userbuf[12]!=0x80)
							dump(userbuf,32, 0); // CFS - figuring it out */
	/*
						The following tests are not passed in Comcast's sample videos. *tbuf here is always 0x41. 
						if (! (*tbuf & 0x80)) // First bit must be 1
						{
							printf ("Fixed bit should be 1, but it's 0 - skipping this caption block.\n");
							break;
						}
						if (*tbuf & 0x20) // Third bit must be 0
						{
							printf ("Fixed bit should be 0, but it's 1 - skipping this caption block.\n");
							break;
						} */
						tbuf++;
						/*
						Another test that the samples ignore. They contain 00!
						if (*tbuf!=0xFF)
						{
							printf ("Fixed value should be 0xFF, but it's %02X - skipping this caption block.\n", *tbuf);
						} */
						// OK, all checks passed!
						tbuf++;
						cc_tmpdata = tbuf;

						/* TODO: I don't think we have user_data_len here
						if (cc_count*3+3 != user_data_len)
						fatal(EXIT_BUG_BUG,
							"Syntax problem: user_data_len != cc_count*3+3."); */

						// Enough room for CC captions?
						if (cc_tmpdata+local_cc_count*3 >= userend)
							fatal(EXIT_BUG_BUG,
								"Syntax problem: Too many caption blocks.");
						if (cc_tmpdata[local_cc_count*3]!=0xFF)
							fatal(EXIT_BUG_BUG,
								"Syntax problem: Final 0xFF marker missing.");

						// Save the data and process once we know the sequence number
						if (local_cc_count*3+1 > cc_databufsize)
						{
							cc_data = (unsigned char*)realloc(cc_data, (size_t) cc_count*6+1);
							if (!cc_data)
								fatal(EXIT_NOT_ENOUGH_MEMORY, "Out of memory");
							cc_databufsize = (long) cc_count*6+1;
						}
						// memcpy cc_data
						copy_ccdata_to_buffer ((char *) cc_tmpdata, local_cc_count);
						// memcpy(cc_data, cc_tmpdata, cc_count*3+1); // CFS: Commented out and replaced with line above to assist with debug
						/* CFS - aqui se reescriben cosas 
						for (int i=0;i<cc_count;i++)
							do_cb(cc_tmpdata+3*i);   */

						break;
					case 0x06:
						if (debug_verbose)
							printf ("bar_data (unsupported for now)\n");
						break;
					default:
						if (debug_verbose)
							printf ("SCTE/ATSC reserved.\n");
				}
				
			}
			else if (*tbuf==0x44 && *(tbuf+1)==0x54 && *(tbuf+2)==0x47 && *(tbuf+3)==0x31) // afd_data()
			{
				printf ("afd_data() - unsupported, we don't have samples.\n");
			}
			else
			{
				if (debug_verbose)
					printf ("SCTE/ATSC reserved.\n");
			}
			break;
		case 0x002F:
			user_data_type_code = *((uint8_t*)tbuf);
			if(user_data_type_code != 0x03)
			{
				if (debug_verbose)
				{
					printf("Not supported  user_data_type_code: %02x\n",
					   user_data_type_code);
				}
				return;
			}
			tbuf++;
			user_data_len = *((uint8_t*)tbuf);
			tbuf++;

			cc_count = *tbuf & 0x1F;
			process_cc_data_flag = (*tbuf & 0x40) >> 6;
			if (!process_cc_data_flag)
				return;
			cc_tmpdata = tbuf+2;

			if (cc_count*3+3 != user_data_len)
				fatal(EXIT_BUG_BUG,
					  "Syntax problem: user_data_len != cc_count*3+3.");

			// Enough room for CC captions?
			if (cc_tmpdata+cc_count*3 >= userend)
				fatal(EXIT_BUG_BUG,
					  "Syntax problem: Too many caption blocks.");
			if (cc_tmpdata[cc_count*3]!=0xFF)
				fatal(EXIT_BUG_BUG,
					  "Syntax problem: Final 0xFF marker missing.");

			// Save the data and process once we know the sequence number
			if (cc_count*3+1 > cc_databufsize)
			{
				cc_data = (unsigned char*)realloc(cc_data, (size_t) cc_count*6+1);
				if (!cc_data)
					fatal(EXIT_NOT_ENOUGH_MEMORY, "Out of memory");
				cc_databufsize = (long) cc_count*6+1;
			}
			// memcpy cc_data
			memcpy(cc_data, cc_tmpdata, cc_count*3+1);

			//dump(tbuf,user_data_len-1);
			//exit(1);
			break;
		default:
			printf("Not a supported user data SEI\n");
			printf("  itu_t_35_provider_code: %04x\n", itu_t_35_provider_code);
			break;
	}
}


// Process sequence parameters in AVC data.
void seq_parameter_set_rbsp (unsigned char *seqbuf, unsigned char *seqend)
{
    LLONG tmp, tmp1;
    struct bitstream q1;
    init_bitstream(&q1, seqbuf, seqend);

    dvprint("SEQUENCE PARAMETER SET (bitlen: %lld)\n", q1.bitsleft);
    tmp=u(&q1,8);
    dvprint("profile_idc=                                   %llX\n", tmp);
    tmp=u(&q1,1);
    dvprint("constraint_set0_flag=                          %llX\n", tmp);
    tmp=u(&q1,1);
    dvprint("constraint_set1_flag=                          %llX\n", tmp);
    tmp=u(&q1,1);
    dvprint("constraint_set2_flag=                          %llX\n", tmp);
    tmp=u(&q1,5);
    dvprint("reserved=                                      %llX\n", tmp);
    tmp=u(&q1,8);
    dvprint("level_idc=                                     %llX\n", tmp);
    seq_parameter_set_id = ue(&q1);
    dvprint("seq_parameter_set_id=                          %llX\n", seq_parameter_set_id);
    log2_max_frame_num = ue(&q1)+4;
    dvprint("log2_max_frame_num4=                           %X\n", log2_max_frame_num);
    pic_order_cnt_type=ue(&q1);
    dvprint("pic_order_cnt_type=                            %X\n", pic_order_cnt_type);
    if( pic_order_cnt_type == 0 )
    {
        log2_max_pic_order_cnt_lsb = ue(&q1)+4;
        dvprint("log2_max_pic_order_cnt_lsb=                    %X\n", log2_max_pic_order_cnt_lsb);
    }
    else
    {
        fatal(EXIT_BUG_BUG, "AVC: pic_order_cnt_type != 0 is not yet supported.");
    }
    tmp=ue(&q1);
    dvprint("num_ref_frames=                                %llX\n", tmp);
    tmp=u(&q1,1);
    dvprint("gaps allowed=                                  %llX\n", tmp);
    tmp=ue(&q1);
    dvprint("pic_width_in_mbs_minus1=                       %llX\n", tmp);
    tmp=ue(&q1);
    dvprint("pic_height_in_map_units_minus1=                %llX\n", tmp);
    frame_mbs_only_flag = u(&q1,1);
    dvprint("frame_mbs_only_flag=                           %X\n", frame_mbs_only_flag);
    if ( !frame_mbs_only_flag )
    {
        tmp=u(&q1,1);
        dvprint("mb_adaptive_fr_fi_flag=                        %llX\n", tmp);
    }
    tmp=u(&q1,1);
    dvprint("direct_8x8_inference_f=                        %llX\n", tmp);
    tmp=u(&q1,1);
    dvprint("frame_cropping_flag=                           %llX\n", tmp);
    if ( tmp )
    {
        tmp=ue(&q1);
        dvprint("frame_crop_left_offset=                        %llX\n", tmp);
        tmp=ue(&q1);
        dvprint("frame_crop_right_offset=                       %llX\n", tmp);
        tmp=ue(&q1);
        dvprint("frame_crop_top_offset=                         %llX\n", tmp);
        tmp=ue(&q1);
        dvprint("frame_crop_bottom_offset=                      %llX\n", tmp);
    }
    tmp=u(&q1,1);
    dvprint("vui_parameters_present=                        %llX\n", tmp);
    if ( tmp )
    {
        dvprint("\nVUI parameters\n");
        tmp=u(&q1,1);
        dvprint("aspect_ratio_info_pres=                        %llX\n", tmp);
        if ( tmp )
        {
            tmp=u(&q1,8);
            dvprint("aspect_ratio_idc=                              %llX\n", tmp);
            if ( tmp == 255 )
            {
                tmp=u(&q1,16);
                dvprint("sar_width=                                     %llX\n", tmp);
                tmp=u(&q1,16);
                dvprint("sar_height=                                    %llX\n", tmp);
            }
        }
        tmp=u(&q1,1);
        dvprint("overscan_info_pres_flag=                       %llX\n", tmp);
        if ( tmp )
        {
            tmp=u(&q1,1);
            dvprint("overscan_appropriate_flag=                     %llX\n", tmp);
        }
        tmp=u(&q1,1);
        dvprint("video_signal_type_present_flag=                %llX\n", tmp);
        if ( tmp )
        {
            tmp=u(&q1,3);
            dvprint("video_format=                                  %llX\n", tmp);
            tmp=u(&q1,1);
            dvprint("video_full_range_flag=                         %llX\n", tmp);
            tmp=u(&q1,1);
            dvprint("colour_description_present_flag=               %llX\n", tmp);
            if ( tmp )
            {
                tmp=u(&q1,8);
                dvprint("colour_primaries=                              %llX\n", tmp);
                tmp=u(&q1,8);
                dvprint("transfer_characteristics=                      %llX\n", tmp);
                tmp=u(&q1,8);
                dvprint("matrix_coefficients=                           %llX\n", tmp);
            }
        }
        tmp=u(&q1,1);
        dvprint("chroma_loc_info_present_flag=                  %llX\n", tmp);
        if ( tmp )
        {
            tmp=ue(&q1);
            dvprint("chroma_sample_loc_type_top_field=                  %llX\n", tmp);
            tmp=ue(&q1);
            dvprint("chroma_sample_loc_type_bottom_field=               %llX\n", tmp);
        }
        tmp=u(&q1,1);
        dvprint("timing_info_present_flag=                      %llX\n", tmp);
        if ( tmp )
        {
            tmp=u(&q1,32);
            dvprint("num_units_in_tick=                             %llX\n", tmp);
            tmp=u(&q1,32);
            dvprint("time_scale=                                    %llX\n", tmp);
            tmp=u(&q1,1);
            dvprint("fixed_frame_rate_flag=                         %llX\n", tmp);
        }
        tmp=u(&q1,1);
        dvprint("nal_hrd_parameters_present_flag=               %llX\n", tmp);
        if ( tmp )
        {
			dvprint ("nal_hrd. Not implemented for now. Hopefully not needed. Skiping rest of NAL\n");            
            //printf("Boom nal_hrd\n");
            // exit(1);
			num_nal_hrd++;
			return;
        } 
        tmp1=u(&q1,1);
        dvprint("vcl_hrd_parameters_present_flag=               %llX\n", tmp1);
        if ( tmp )
        {
			// TODO.
			printf ("vcl_hrd. Not implemented for now. Hopefully not needed. Skiping rest of NAL\n");            
			num_vcl_hrd++;
            // exit(1);
        } 
        if ( tmp || tmp1 )
        {
            tmp=u(&q1,1);
            dvprint("low_delay_hrd_flag=                                %llX\n", tmp);
			return;
        }
        tmp=u(&q1,1);
        dvprint("pic_struct_present_flag=                       %llX\n", tmp);
        tmp=u(&q1,1);
        dvprint("bitstream_restriction_flag=                    %llX\n", tmp);
        // ..
        // The hope was to find the GOP length in max_dec_frame_buffering, but
        // it was not set in the testfile.  Ignore the rest here, it's
        // currently not needed.
    }
    //exit(1);
}


// Process slice header in AVC data.
void slice_header (unsigned char *heabuf, unsigned char *heaend, int nal_unit_type)
{
    LLONG tmp;
    struct bitstream q1;
    init_bitstream(&q1, heabuf, heaend);

    LLONG slice_type, bottom_field_flag=0, pic_order_cnt_lsb;
    static LLONG frame_num=-1, lastframe_num = -1;
    static int currref=0, maxidx=-1, lastmaxidx=0;
    int curridx;
	int IdrPicFlag = ((nal_unit_type ==5 )?1:0);

    dvprint("\nSLICE HEADER\n");
    tmp=ue(&q1);
    dvprint("first_mb_in_slice=     %llX\n", tmp);
    slice_type=ue(&q1);
    dvprint("slice_type=            %llX\n", slice_type);
    tmp=ue(&q1);
    dvprint("pic_parameter_set_id=  %llX\n", tmp);

    lastframe_num = frame_num;
    int maxframe_num = int((1<<log2_max_frame_num) - 1);

    // Needs log2_max_frame_num_minus4 + 4 bits
    frame_num=u(&q1,log2_max_frame_num);
    dvprint("frame_num=             %llX\n", frame_num);

    if( !frame_mbs_only_flag )
    {
        LLONG field_pic_flag = u(&q1,1);
        dvprint("field_pic_flag=        %llX\n", field_pic_flag);
        if( field_pic_flag )
        {
            // bottom_field_flag
            bottom_field_flag = u(&q1,1);
            dvprint("bottom_field_flag=     %llX\n", bottom_field_flag);

            // TODO - Do this right.
            // When bottom_field_flag is set the video is interlaced,
            // override current_fps.
            current_fps = framerates_values[7];
        }
    }

	dvprint("IdrPicFlag=            %d\n", IdrPicFlag	);

    if( nal_unit_type == 5 )
    {
        // fatal(EXIT_BUG_BUG, "AVC: nal_unit_type == 5 is not yet supported."); CFS: Trying to add support for this 
		tmp=ue(&q1);
		dvprint("idr_pic_id=     %llX\n", tmp);
        //TODO
    }
    if( pic_order_cnt_type == 0 )
    {
        pic_order_cnt_lsb=u(&q1,log2_max_pic_order_cnt_lsb);
        dvprint("pic_order_cnt_lsb=     %llX\n", pic_order_cnt_lsb);
    }
    else
    {
        fatal(EXIT_BUG_BUG, "AVC: pic_order_cnt_type != 0 not yet supported.");
        //TODO
        // Calculate picture order count (POC) according to 8.2.1
    }
    // The rest of the data in slice_header() is currently unused.

    // A reference pic (I or P is always the last displayed picture of a POC
    // sequence. B slices can be reference pics, so ignore nal_ref_idc.
    int isref = 0;
    switch (slice_type)
    {
        // P-SLICES
    case 0:
    case 5:
        // I-SLICES
    case 2:
    case 7:
        isref=1;
        break;
    }

    int maxrefcnt = int((1<<log2_max_pic_order_cnt_lsb) - 1);

    // If we saw a jump set maxidx, lastmaxidx to -1
    int dif = frame_num - lastframe_num;
    if (dif == -maxframe_num)
        dif = 0;
    if ( lastframe_num > -1 && (dif < 0 || dif > 1) )
    {
		num_jump_in_frames++;
        dvprint("\nJump in frame numbers (%lld/%lld)\n", frame_num, lastframe_num);
        // This will prohibit setting current_tref on potential
        // jumps.
        maxidx=-1;
        lastmaxidx=-1;
    }

    // if slices are buffered - flush
    if (isref && !bottom_field_flag)
    {
        dvprint("\nReference pic! [%s]\n", slice_types[slice_type]);

        // Flush buffered cc blocks before doing the housekeeping
        if (has_ccdata_buffered)
        {
            process_hdcc();
        }
        frames_since_last_gop=0;
        lastmaxidx = maxidx;
        maxidx=0;

        // Make sure that curridx never wraps for curidx values that
        // are smaller than currref
        currref = pic_order_cnt_lsb;
        if (currref < maxrefcnt/3)
        {
            currref += maxrefcnt+1;
        }

        anchor_hdcc( currref );

        // If we wrapped arround lastmaxidx might be larger than
        // the current index - fix this.
        if (lastmaxidx > currref + maxrefcnt/2) // implies lastmaxidx > 0
            lastmaxidx -=maxrefcnt+1;
    }
    // Wrap (add max index value) curridx if needed.
    if( currref - pic_order_cnt_lsb > maxrefcnt/2 )
        curridx = pic_order_cnt_lsb + maxrefcnt+1;
    else
        curridx = pic_order_cnt_lsb;

    // Track maximum index for this GOP
    if ( curridx > maxidx )
        maxidx = curridx;

    // Calculate tref
    if ( lastmaxidx > 0 )
        current_tref = curridx - lastmaxidx -1;
    else
        current_tref = 0;

    set_fts(); // Keep frames_since_ref_time==0, use current_tref

    if (debug_time) {
        printf("PTS: %s (%8u) - cnt# %3lld/%d idx: %3d/%d - %s since GOP: %2u",
               print_mstime(current_pts/(MPEG_CLOCK_FREQ/1000)),
               unsigned(current_pts),
               pic_order_cnt_lsb, current_tref,
               curridx, currref,
	       slice_types[slice_type],
               unsigned(frames_since_last_gop));
        printf("  b:%lld  frame# %lld", bottom_field_flag, frame_num);
        printf("  FTS: %s\n", print_mstime(get_fts()));
    }

    // curridx is one larger than last GOP's maximum index
    if (lastmaxidx > 0 && current_tref == 0)
    {
        if (debug_time)
        {
            printf("\nNew temporal reference:\n");
            print_debug_timing();
        }
    }

    total_frames_count++;
    frames_since_last_gop++;

    store_hdcc(cc_data, cc_count, curridx, fts_now); 
	cc_buffer_saved=1; // CFS: store_hdcc supposedly saves the CC buffer to a sequence buffer
	cc_count=0;

    //exit(1);
}

// max_dec_frame_buffering .. Max frames in buffer
