// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/backup_plan_binding.proto

package gkebackuppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State
type BackupPlanBinding_BackupPlanDetails_State int32

const (
	// Default first value for Enums.
	BackupPlanBinding_BackupPlanDetails_STATE_UNSPECIFIED BackupPlanBinding_BackupPlanDetails_State = 0
	// Waiting for cluster state to be RUNNING.
	BackupPlanBinding_BackupPlanDetails_CLUSTER_PENDING BackupPlanBinding_BackupPlanDetails_State = 1
	// The BackupPlan is in the process of being created.
	BackupPlanBinding_BackupPlanDetails_PROVISIONING BackupPlanBinding_BackupPlanDetails_State = 2
	// The BackupPlan has successfully been created and is ready for Backups.
	BackupPlanBinding_BackupPlanDetails_READY BackupPlanBinding_BackupPlanDetails_State = 3
	// BackupPlan creation has failed.
	BackupPlanBinding_BackupPlanDetails_FAILED BackupPlanBinding_BackupPlanDetails_State = 4
	// The BackupPlan has been deactivated.
	BackupPlanBinding_BackupPlanDetails_DEACTIVATED BackupPlanBinding_BackupPlanDetails_State = 5
	// The BackupPlan is in the process of being deleted.
	BackupPlanBinding_BackupPlanDetails_DELETING BackupPlanBinding_BackupPlanDetails_State = 6
)

// Enum value maps for BackupPlanBinding_BackupPlanDetails_State.
var (
	BackupPlanBinding_BackupPlanDetails_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CLUSTER_PENDING",
		2: "PROVISIONING",
		3: "READY",
		4: "FAILED",
		5: "DEACTIVATED",
		6: "DELETING",
	}
	BackupPlanBinding_BackupPlanDetails_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CLUSTER_PENDING":   1,
		"PROVISIONING":      2,
		"READY":             3,
		"FAILED":            4,
		"DEACTIVATED":       5,
		"DELETING":          6,
	}
)

func (x BackupPlanBinding_BackupPlanDetails_State) Enum() *BackupPlanBinding_BackupPlanDetails_State {
	p := new(BackupPlanBinding_BackupPlanDetails_State)
	*p = x
	return p
}

func (x BackupPlanBinding_BackupPlanDetails_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupPlanBinding_BackupPlanDetails_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_backup_plan_binding_proto_enumTypes[0].Descriptor()
}

func (BackupPlanBinding_BackupPlanDetails_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_backup_plan_binding_proto_enumTypes[0]
}

func (x BackupPlanBinding_BackupPlanDetails_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupPlanBinding_BackupPlanDetails_State.Descriptor instead.
func (BackupPlanBinding_BackupPlanDetails_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescGZIP(), []int{0, 0, 0}
}

// A BackupPlanBinding binds a BackupPlan with a BackupChannel.
// This resource is created automatically when a BackupPlan is created using a
// BackupChannel. This also serves as a holder for cross-project fields
// that need to be displayed in the current project.
type BackupPlanBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The fully qualified name of the BackupPlanBinding.
	// `projects/*/locations/*/backupChannels/*/backupPlanBindings/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this binding was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this binding was created.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Immutable. The fully qualified name of the BackupPlan bound
	// with the parent BackupChannel.
	// `projects/*/locations/*/backupPlans/{backup_plan}`
	BackupPlan string `protobuf:"bytes,5,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Output only. Immutable. The fully qualified name of the cluster that is
	// being backed up Valid formats:
	//
	// - `projects/*/locations/*/clusters/*`
	// - `projects/*/zones/*/clusters/*`
	Cluster string `protobuf:"bytes,6,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. Contains details about the backup plan/backup.
	BackupPlanDetails *BackupPlanBinding_BackupPlanDetails `protobuf:"bytes,7,opt,name=backup_plan_details,json=backupPlanDetails,proto3" json:"backup_plan_details,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a BackupPlanBinding from overwriting
	// each other. It is strongly suggested that systems make use of the 'etag' in
	// the read-modify-write cycle to perform BackupPlanBinding updates in
	// order to avoid race conditions: An `etag` is returned in the response to
	// `GetBackupPlanBinding`, and systems are expected to put that etag in
	// the request to `UpdateBackupPlanBinding` or
	// `DeleteBackupPlanBinding` to ensure that their change will be applied
	// to the same version of the resource.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *BackupPlanBinding) Reset() {
	*x = BackupPlanBinding{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlanBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlanBinding) ProtoMessage() {}

func (x *BackupPlanBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlanBinding.ProtoReflect.Descriptor instead.
func (*BackupPlanBinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescGZIP(), []int{0}
}

func (x *BackupPlanBinding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupPlanBinding) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *BackupPlanBinding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupPlanBinding) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BackupPlanBinding) GetBackupPlan() string {
	if x != nil {
		return x.BackupPlan
	}
	return ""
}

func (x *BackupPlanBinding) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *BackupPlanBinding) GetBackupPlanDetails() *BackupPlanBinding_BackupPlanDetails {
	if x != nil {
		return x.BackupPlanDetails
	}
	return nil
}

func (x *BackupPlanBinding) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Contains metadata about the backup plan/backup.
type BackupPlanBinding_BackupPlanDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number of Kubernetes Pods backed up in the
	// last successful Backup created via this BackupPlan.
	ProtectedPodCount int32 `protobuf:"varint,1,opt,name=protected_pod_count,json=protectedPodCount,proto3" json:"protected_pod_count,omitempty"`
	// Output only. State of the BackupPlan.
	State BackupPlanBinding_BackupPlanDetails_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.BackupPlanBinding_BackupPlanDetails_State" json:"state,omitempty"`
	// Output only. Completion time of the last successful Backup. This is
	// sourced from a successful Backup's complete_time field.
	LastSuccessfulBackupTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_successful_backup_time,json=lastSuccessfulBackupTime,proto3" json:"last_successful_backup_time,omitempty"`
	// Output only. Start time of next scheduled backup under this BackupPlan by
	// either cron_schedule or rpo config. This is sourced from BackupPlan.
	NextScheduledBackupTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=next_scheduled_backup_time,json=nextScheduledBackupTime,proto3" json:"next_scheduled_backup_time,omitempty"`
	// Output only. A number that represents the current risk level of this
	// BackupPlan from RPO perspective with 1 being no risk and 5 being highest
	// risk.
	RpoRiskLevel int32 `protobuf:"varint,5,opt,name=rpo_risk_level,json=rpoRiskLevel,proto3" json:"rpo_risk_level,omitempty"`
	// Output only. The fully qualified name of the last successful Backup
	// created under this BackupPlan.
	// `projects/*/locations/*/backupPlans/*/backups/*`
	LastSuccessfulBackup string `protobuf:"bytes,6,opt,name=last_successful_backup,json=lastSuccessfulBackup,proto3" json:"last_successful_backup,omitempty"`
}

func (x *BackupPlanBinding_BackupPlanDetails) Reset() {
	*x = BackupPlanBinding_BackupPlanDetails{}
	mi := &file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlanBinding_BackupPlanDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlanBinding_BackupPlanDetails) ProtoMessage() {}

func (x *BackupPlanBinding_BackupPlanDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlanBinding_BackupPlanDetails.ProtoReflect.Descriptor instead.
func (*BackupPlanBinding_BackupPlanDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BackupPlanBinding_BackupPlanDetails) GetProtectedPodCount() int32 {
	if x != nil {
		return x.ProtectedPodCount
	}
	return 0
}

func (x *BackupPlanBinding_BackupPlanDetails) GetState() BackupPlanBinding_BackupPlanDetails_State {
	if x != nil {
		return x.State
	}
	return BackupPlanBinding_BackupPlanDetails_STATE_UNSPECIFIED
}

func (x *BackupPlanBinding_BackupPlanDetails) GetLastSuccessfulBackupTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSuccessfulBackupTime
	}
	return nil
}

func (x *BackupPlanBinding_BackupPlanDetails) GetNextScheduledBackupTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextScheduledBackupTime
	}
	return nil
}

func (x *BackupPlanBinding_BackupPlanDetails) GetRpoRiskLevel() int32 {
	if x != nil {
		return x.RpoRiskLevel
	}
	return 0
}

func (x *BackupPlanBinding_BackupPlanDetails) GetLastSuccessfulBackup() string {
	if x != nil {
		return x.LastSuccessfulBackup
	}
	return ""
}

var File_google_cloud_gkebackup_v1_backup_plan_binding_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x0a, 0x0a, 0x11, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08,
	0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x45, 0x0a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61,
	0x69, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x73, 0x0a, 0x13, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x1a, 0xca, 0x04, 0x0a, 0x11, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x5f, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5e,
	0x0a, 0x1b, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x66, 0x75, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c,
	0x0a, 0x1a, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x17, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e,
	0x72, 0x70, 0x6f, 0x5f, 0x72, 0x69, 0x73, 0x6b, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x72, 0x70, 0x6f, 0x52, 0x69,
	0x73, 0x6b, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x39, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f,
	0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6c, 0x61,
	0x73, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x22, 0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49,
	0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41,
	0x44, 0x59, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x3a,
	0xc9, 0x01, 0xea, 0x41, 0xc5, 0x01, 0x0a, 0x2a, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x12, 0x70, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x62, 0x69, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x7d, 0x2a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x11, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0xcd, 0x01, 0x0a, 0x1d,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescData = file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_backup_plan_binding_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_cloud_gkebackup_v1_backup_plan_binding_proto_goTypes = []any{
	(BackupPlanBinding_BackupPlanDetails_State)(0), // 0: google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails.State
	(*BackupPlanBinding)(nil),                      // 1: google.cloud.gkebackup.v1.BackupPlanBinding
	(*BackupPlanBinding_BackupPlanDetails)(nil),    // 2: google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails
	(*timestamppb.Timestamp)(nil),                  // 3: google.protobuf.Timestamp
}
var file_google_cloud_gkebackup_v1_backup_plan_binding_proto_depIdxs = []int32{
	3, // 0: google.cloud.gkebackup.v1.BackupPlanBinding.create_time:type_name -> google.protobuf.Timestamp
	3, // 1: google.cloud.gkebackup.v1.BackupPlanBinding.update_time:type_name -> google.protobuf.Timestamp
	2, // 2: google.cloud.gkebackup.v1.BackupPlanBinding.backup_plan_details:type_name -> google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails
	0, // 3: google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails.state:type_name -> google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails.State
	3, // 4: google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails.last_successful_backup_time:type_name -> google.protobuf.Timestamp
	3, // 5: google.cloud.gkebackup.v1.BackupPlanBinding.BackupPlanDetails.next_scheduled_backup_time:type_name -> google.protobuf.Timestamp
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_backup_plan_binding_proto_init() }
func file_google_cloud_gkebackup_v1_backup_plan_binding_proto_init() {
	if File_google_cloud_gkebackup_v1_backup_plan_binding_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_backup_plan_binding_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_backup_plan_binding_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_backup_plan_binding_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_backup_plan_binding_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_backup_plan_binding_proto = out.File
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_backup_plan_binding_proto_depIdxs = nil
}
