// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.9
// source: google/cloud/datapipelines/logging/v1/logging.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of a Data Pipelines API request.
type RequestLogEntry_RequestType int32

const (
	// Default value. This value is not used.
	RequestLogEntry_REQUEST_TYPE_UNSPECIFIED RequestLogEntry_RequestType = 0
	// A Data Pipelines Create Pipeline request.
	RequestLogEntry_CREATE_PIPELINE RequestLogEntry_RequestType = 1
	// A Data Pipelines Update Pipeline request.
	RequestLogEntry_UPDATE_PIPELINE RequestLogEntry_RequestType = 2
	// A Data Pipelines Delete Pipeline request.
	RequestLogEntry_DELETE_PIPELINE RequestLogEntry_RequestType = 3
	// A Data Pipelines List Pipelines request.
	RequestLogEntry_LIST_PIPELINES RequestLogEntry_RequestType = 4
	// A Data Pipelines Get Pipeline request.
	RequestLogEntry_GET_PIPELINE RequestLogEntry_RequestType = 5
	// A Data Pipelines Stop Pipeline request.
	RequestLogEntry_STOP_PIPELINE RequestLogEntry_RequestType = 6
	// A Data Pipelines Run Pipeline request.
	RequestLogEntry_RUN_PIPELINE RequestLogEntry_RequestType = 7
	// A Data Pipelines List Jobs request.
	RequestLogEntry_LIST_JOBS RequestLogEntry_RequestType = 8
)

// Enum value maps for RequestLogEntry_RequestType.
var (
	RequestLogEntry_RequestType_name = map[int32]string{
		0: "REQUEST_TYPE_UNSPECIFIED",
		1: "CREATE_PIPELINE",
		2: "UPDATE_PIPELINE",
		3: "DELETE_PIPELINE",
		4: "LIST_PIPELINES",
		5: "GET_PIPELINE",
		6: "STOP_PIPELINE",
		7: "RUN_PIPELINE",
		8: "LIST_JOBS",
	}
	RequestLogEntry_RequestType_value = map[string]int32{
		"REQUEST_TYPE_UNSPECIFIED": 0,
		"CREATE_PIPELINE":          1,
		"UPDATE_PIPELINE":          2,
		"DELETE_PIPELINE":          3,
		"LIST_PIPELINES":           4,
		"GET_PIPELINE":             5,
		"STOP_PIPELINE":            6,
		"RUN_PIPELINE":             7,
		"LIST_JOBS":                8,
	}
)

func (x RequestLogEntry_RequestType) Enum() *RequestLogEntry_RequestType {
	p := new(RequestLogEntry_RequestType)
	*p = x
	return p
}

func (x RequestLogEntry_RequestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RequestLogEntry_RequestType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes[0].Descriptor()
}

func (RequestLogEntry_RequestType) Type() protoreflect.EnumType {
	return &file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes[0]
}

func (x RequestLogEntry_RequestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RequestLogEntry_RequestType.Descriptor instead.
func (RequestLogEntry_RequestType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescGZIP(), []int{0, 0}
}

// Cause code for a Data Pipelines API request error.
type RequestLogEntry_ErrorCause int32

const (
	// Default value. This value is not used.
	RequestLogEntry_ERROR_CAUSE_UNSPECIFIED RequestLogEntry_ErrorCause = 0
	// The request is invalid.
	RequestLogEntry_INVALID_REQUEST RequestLogEntry_ErrorCause = 1
	// Failed to fetch project number for the provided project id.
	RequestLogEntry_PROJECT_NUMBER_NOT_FOUND RequestLogEntry_ErrorCause = 2
	// The given pipeline already exists.
	RequestLogEntry_PIPELINE_ID_ALREADY_EXISTS RequestLogEntry_ErrorCause = 3
	// Failed to allocate a token for the per project pipeline count quota.
	RequestLogEntry_PIPELINE_QUOTA_ALLOCATION_FAILED RequestLogEntry_ErrorCause = 4
	// The given pipeline is not found.
	RequestLogEntry_PIPELINE_NOT_FOUND RequestLogEntry_ErrorCause = 5
	// The pipeline's workload is invalid.
	RequestLogEntry_INVALID_PIPELINE_WORKLOAD RequestLogEntry_ErrorCause = 6
	// The user cannot act as the Dataflow worker service account.
	RequestLogEntry_DATAFLOW_WORKER_SERVICE_ACCOUNT_PERMISSION_DENIED RequestLogEntry_ErrorCause = 7
	// The user cannot act as the Cloud Scheduler service account.
	RequestLogEntry_CLOUD_SCHEDULER_SERVICE_ACCOUNT_PERMISSION_DENIED RequestLogEntry_ErrorCause = 8
	// Issues related to the per service per project service account.
	RequestLogEntry_INTERNAL_DATA_PIPELINES_SERVICE_ACCOUNT_ISSUE RequestLogEntry_ErrorCause = 9
	// Invalid argument in Cloud Scheduler service call.
	RequestLogEntry_CLOUD_SCHEDULER_INVALID_ARGUMENT RequestLogEntry_ErrorCause = 10
	// Exceeds Cloud Scheduler service quota limit.
	RequestLogEntry_CLOUD_SCHEDULER_RESOURCE_EXHAUSTED RequestLogEntry_ErrorCause = 11
	// Cloud Scheduler job not found.
	RequestLogEntry_CLOUD_SCHEDULER_JOB_NOT_FOUND RequestLogEntry_ErrorCause = 12
	// Other Cloud Scheduler related issues.
	RequestLogEntry_OTHER_CLOUD_SCHEDULER_ISSUE RequestLogEntry_ErrorCause = 13
	// Dataflow job with the same name already exists.
	RequestLogEntry_DATAFLOW_JOB_ALREADY_EXISTS RequestLogEntry_ErrorCause = 14
	// Invalid argument in Dataflow service call.
	RequestLogEntry_DATAFLOW_INVALID_ARGUMENT RequestLogEntry_ErrorCause = 15
	// Exceeds Dataflow service quota limit.
	RequestLogEntry_DATAFLOW_RESOURCE_EXHAUSTED RequestLogEntry_ErrorCause = 16
	// Dataflow job not found.
	RequestLogEntry_DATAFLOW_JOB_NOT_FOUND RequestLogEntry_ErrorCause = 17
	// Other Dataflow related issues.
	RequestLogEntry_OTHER_DATAFLOW_ISSUE RequestLogEntry_ErrorCause = 18
	// Database related issues.
	RequestLogEntry_DATABASE_ERROR RequestLogEntry_ErrorCause = 19
	// Request with the wrong pipeline type. For example, RunPipeline cannot be
	// used with a streaming pipeline.
	RequestLogEntry_WRONG_PIPELINE_TYPE RequestLogEntry_ErrorCause = 20
	// Issues related to other Google internal services/systems.
	RequestLogEntry_INTERNAL_ERROR RequestLogEntry_ErrorCause = 21
	// Cannot find the given pipeline or project.
	RequestLogEntry_PIPELINE_OR_PROJECT_NOT_FOUND RequestLogEntry_ErrorCause = 22
)

// Enum value maps for RequestLogEntry_ErrorCause.
var (
	RequestLogEntry_ErrorCause_name = map[int32]string{
		0:  "ERROR_CAUSE_UNSPECIFIED",
		1:  "INVALID_REQUEST",
		2:  "PROJECT_NUMBER_NOT_FOUND",
		3:  "PIPELINE_ID_ALREADY_EXISTS",
		4:  "PIPELINE_QUOTA_ALLOCATION_FAILED",
		5:  "PIPELINE_NOT_FOUND",
		6:  "INVALID_PIPELINE_WORKLOAD",
		7:  "DATAFLOW_WORKER_SERVICE_ACCOUNT_PERMISSION_DENIED",
		8:  "CLOUD_SCHEDULER_SERVICE_ACCOUNT_PERMISSION_DENIED",
		9:  "INTERNAL_DATA_PIPELINES_SERVICE_ACCOUNT_ISSUE",
		10: "CLOUD_SCHEDULER_INVALID_ARGUMENT",
		11: "CLOUD_SCHEDULER_RESOURCE_EXHAUSTED",
		12: "CLOUD_SCHEDULER_JOB_NOT_FOUND",
		13: "OTHER_CLOUD_SCHEDULER_ISSUE",
		14: "DATAFLOW_JOB_ALREADY_EXISTS",
		15: "DATAFLOW_INVALID_ARGUMENT",
		16: "DATAFLOW_RESOURCE_EXHAUSTED",
		17: "DATAFLOW_JOB_NOT_FOUND",
		18: "OTHER_DATAFLOW_ISSUE",
		19: "DATABASE_ERROR",
		20: "WRONG_PIPELINE_TYPE",
		21: "INTERNAL_ERROR",
		22: "PIPELINE_OR_PROJECT_NOT_FOUND",
	}
	RequestLogEntry_ErrorCause_value = map[string]int32{
		"ERROR_CAUSE_UNSPECIFIED":                           0,
		"INVALID_REQUEST":                                   1,
		"PROJECT_NUMBER_NOT_FOUND":                          2,
		"PIPELINE_ID_ALREADY_EXISTS":                        3,
		"PIPELINE_QUOTA_ALLOCATION_FAILED":                  4,
		"PIPELINE_NOT_FOUND":                                5,
		"INVALID_PIPELINE_WORKLOAD":                         6,
		"DATAFLOW_WORKER_SERVICE_ACCOUNT_PERMISSION_DENIED": 7,
		"CLOUD_SCHEDULER_SERVICE_ACCOUNT_PERMISSION_DENIED": 8,
		"INTERNAL_DATA_PIPELINES_SERVICE_ACCOUNT_ISSUE":     9,
		"CLOUD_SCHEDULER_INVALID_ARGUMENT":                  10,
		"CLOUD_SCHEDULER_RESOURCE_EXHAUSTED":                11,
		"CLOUD_SCHEDULER_JOB_NOT_FOUND":                     12,
		"OTHER_CLOUD_SCHEDULER_ISSUE":                       13,
		"DATAFLOW_JOB_ALREADY_EXISTS":                       14,
		"DATAFLOW_INVALID_ARGUMENT":                         15,
		"DATAFLOW_RESOURCE_EXHAUSTED":                       16,
		"DATAFLOW_JOB_NOT_FOUND":                            17,
		"OTHER_DATAFLOW_ISSUE":                              18,
		"DATABASE_ERROR":                                    19,
		"WRONG_PIPELINE_TYPE":                               20,
		"INTERNAL_ERROR":                                    21,
		"PIPELINE_OR_PROJECT_NOT_FOUND":                     22,
	}
)

func (x RequestLogEntry_ErrorCause) Enum() *RequestLogEntry_ErrorCause {
	p := new(RequestLogEntry_ErrorCause)
	*p = x
	return p
}

func (x RequestLogEntry_ErrorCause) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RequestLogEntry_ErrorCause) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes[1].Descriptor()
}

func (RequestLogEntry_ErrorCause) Type() protoreflect.EnumType {
	return &file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes[1]
}

func (x RequestLogEntry_ErrorCause) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RequestLogEntry_ErrorCause.Descriptor instead.
func (RequestLogEntry_ErrorCause) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescGZIP(), []int{0, 1}
}

// Cloud Logging structured payload for events generated from Data Pipelines API
// requests.
type RequestLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the Data Pipelines API request.
	RequestType RequestLogEntry_RequestType `protobuf:"varint,1,opt,name=request_type,json=requestType,proto3,enum=google.cloud.datapipelines.logging.v1.RequestLogEntry_RequestType" json:"request_type,omitempty"`
	// The resulting status of the Data Pipelines API request.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Cause of the error status.
	ErrorCause RequestLogEntry_ErrorCause `protobuf:"varint,3,opt,name=error_cause,json=errorCause,proto3,enum=google.cloud.datapipelines.logging.v1.RequestLogEntry_ErrorCause" json:"error_cause,omitempty"`
}

func (x *RequestLogEntry) Reset() {
	*x = RequestLogEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datapipelines_logging_v1_logging_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestLogEntry) ProtoMessage() {}

func (x *RequestLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datapipelines_logging_v1_logging_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestLogEntry.ProtoReflect.Descriptor instead.
func (*RequestLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescGZIP(), []int{0}
}

func (x *RequestLogEntry) GetRequestType() RequestLogEntry_RequestType {
	if x != nil {
		return x.RequestType
	}
	return RequestLogEntry_REQUEST_TYPE_UNSPECIFIED
}

func (x *RequestLogEntry) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *RequestLogEntry) GetErrorCause() RequestLogEntry_ErrorCause {
	if x != nil {
		return x.ErrorCause
	}
	return RequestLogEntry_ERROR_CAUSE_UNSPECIFIED
}

var File_google_cloud_datapipelines_logging_v1_logging_proto protoreflect.FileDescriptor

var file_google_cloud_datapipelines_logging_v1_logging_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd9, 0x09, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x65, 0x0a, 0x0c, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2e, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c,
	0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x62, 0x0a, 0x0b,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x61, 0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x61, 0x75, 0x73, 0x65, 0x52, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x61, 0x75, 0x73, 0x65,
	0x22, 0xc4, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e,
	0x45, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x49,
	0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x12, 0x0a,
	0x0e, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x53, 0x10,
	0x04, 0x12, 0x10, 0x0a, 0x0c, 0x47, 0x45, 0x54, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e,
	0x45, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x4f, 0x50, 0x5f, 0x50, 0x49, 0x50, 0x45,
	0x4c, 0x49, 0x4e, 0x45, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x55, 0x4e, 0x5f, 0x50, 0x49,
	0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x49, 0x53, 0x54,
	0x5f, 0x4a, 0x4f, 0x42, 0x53, 0x10, 0x08, 0x22, 0x87, 0x06, 0x0a, 0x0a, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x43, 0x61, 0x75, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f,
	0x43, 0x41, 0x55, 0x53, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52,
	0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x4f, 0x4a,
	0x45, 0x43, 0x54, 0x5f, 0x4e, 0x55, 0x4d, 0x42, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46,
	0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49,
	0x4e, 0x45, 0x5f, 0x49, 0x44, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x45, 0x58,
	0x49, 0x53, 0x54, 0x53, 0x10, 0x03, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49,
	0x4e, 0x45, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12,
	0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x05, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41,
	0x44, 0x10, 0x06, 0x12, 0x35, 0x0a, 0x31, 0x44, 0x41, 0x54, 0x41, 0x46, 0x4c, 0x4f, 0x57, 0x5f,
	0x57, 0x4f, 0x52, 0x4b, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41,
	0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x07, 0x12, 0x35, 0x0a, 0x31, 0x43, 0x4c,
	0x4f, 0x55, 0x44, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x50, 0x45,
	0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10,
	0x08, 0x12, 0x31, 0x0a, 0x2d, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x44, 0x41,
	0x54, 0x41, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x53, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x49, 0x53, 0x53,
	0x55, 0x45, 0x10, 0x09, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x43,
	0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x41, 0x52, 0x47, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x0a, 0x12, 0x26, 0x0a, 0x22, 0x43, 0x4c,
	0x4f, 0x55, 0x44, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x58, 0x48, 0x41, 0x55, 0x53, 0x54, 0x45, 0x44,
	0x10, 0x0b, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x43, 0x48, 0x45,
	0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f,
	0x55, 0x4e, 0x44, 0x10, 0x0c, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x52, 0x5f, 0x49,
	0x53, 0x53, 0x55, 0x45, 0x10, 0x0d, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x46, 0x4c,
	0x4f, 0x57, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x45,
	0x58, 0x49, 0x53, 0x54, 0x53, 0x10, 0x0e, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x46,
	0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x41, 0x52, 0x47, 0x55,
	0x4d, 0x45, 0x4e, 0x54, 0x10, 0x0f, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x46, 0x4c,
	0x4f, 0x57, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x58, 0x48, 0x41,
	0x55, 0x53, 0x54, 0x45, 0x44, 0x10, 0x10, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x41, 0x54, 0x41, 0x46,
	0x4c, 0x4f, 0x57, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e,
	0x44, 0x10, 0x11, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54,
	0x41, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x12, 0x12, 0x12, 0x0a,
	0x0e, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x13, 0x12, 0x17, 0x0a, 0x13, 0x57, 0x52, 0x4f, 0x4e, 0x47, 0x5f, 0x50, 0x49, 0x50, 0x45, 0x4c,
	0x49, 0x4e, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x14, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x15, 0x12, 0x21,
	0x0a, 0x1d, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x50, 0x52,
	0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10,
	0x16, 0x42, 0x89, 0x01, 0x0a, 0x29, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x73, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x42,
	0x0c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescOnce sync.Once
	file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescData = file_google_cloud_datapipelines_logging_v1_logging_proto_rawDesc
)

func file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescGZIP() []byte {
	file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescOnce.Do(func() {
		file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescData)
	})
	return file_google_cloud_datapipelines_logging_v1_logging_proto_rawDescData
}

var file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_datapipelines_logging_v1_logging_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_datapipelines_logging_v1_logging_proto_goTypes = []interface{}{
	(RequestLogEntry_RequestType)(0), // 0: google.cloud.datapipelines.logging.v1.RequestLogEntry.RequestType
	(RequestLogEntry_ErrorCause)(0),  // 1: google.cloud.datapipelines.logging.v1.RequestLogEntry.ErrorCause
	(*RequestLogEntry)(nil),          // 2: google.cloud.datapipelines.logging.v1.RequestLogEntry
	(*status.Status)(nil),            // 3: google.rpc.Status
}
var file_google_cloud_datapipelines_logging_v1_logging_proto_depIdxs = []int32{
	0, // 0: google.cloud.datapipelines.logging.v1.RequestLogEntry.request_type:type_name -> google.cloud.datapipelines.logging.v1.RequestLogEntry.RequestType
	3, // 1: google.cloud.datapipelines.logging.v1.RequestLogEntry.status:type_name -> google.rpc.Status
	1, // 2: google.cloud.datapipelines.logging.v1.RequestLogEntry.error_cause:type_name -> google.cloud.datapipelines.logging.v1.RequestLogEntry.ErrorCause
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_datapipelines_logging_v1_logging_proto_init() }
func file_google_cloud_datapipelines_logging_v1_logging_proto_init() {
	if File_google_cloud_datapipelines_logging_v1_logging_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datapipelines_logging_v1_logging_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestLogEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datapipelines_logging_v1_logging_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datapipelines_logging_v1_logging_proto_goTypes,
		DependencyIndexes: file_google_cloud_datapipelines_logging_v1_logging_proto_depIdxs,
		EnumInfos:         file_google_cloud_datapipelines_logging_v1_logging_proto_enumTypes,
		MessageInfos:      file_google_cloud_datapipelines_logging_v1_logging_proto_msgTypes,
	}.Build()
	File_google_cloud_datapipelines_logging_v1_logging_proto = out.File
	file_google_cloud_datapipelines_logging_v1_logging_proto_rawDesc = nil
	file_google_cloud_datapipelines_logging_v1_logging_proto_goTypes = nil
	file_google_cloud_datapipelines_logging_v1_logging_proto_depIdxs = nil
}
