// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2/generator.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The event that triggers the generator and LLM execution.
type TriggerEvent int32

const (
	// Default value for TriggerEvent.
	TriggerEvent_TRIGGER_EVENT_UNSPECIFIED TriggerEvent = 0
	// Triggers when each chat message or voice utterance ends.
	TriggerEvent_END_OF_UTTERANCE TriggerEvent = 1
	// Triggers on the conversation manually by API calls, such as
	// Conversations.GenerateStatelessSuggestion and
	// Conversations.GenerateSuggestions.
	TriggerEvent_MANUAL_CALL TriggerEvent = 2
	// Triggers after each customer message only.
	TriggerEvent_CUSTOMER_MESSAGE TriggerEvent = 3
	// Triggers after each agent message only.
	TriggerEvent_AGENT_MESSAGE TriggerEvent = 4
)

// Enum value maps for TriggerEvent.
var (
	TriggerEvent_name = map[int32]string{
		0: "TRIGGER_EVENT_UNSPECIFIED",
		1: "END_OF_UTTERANCE",
		2: "MANUAL_CALL",
		3: "CUSTOMER_MESSAGE",
		4: "AGENT_MESSAGE",
	}
	TriggerEvent_value = map[string]int32{
		"TRIGGER_EVENT_UNSPECIFIED": 0,
		"END_OF_UTTERANCE":          1,
		"MANUAL_CALL":               2,
		"CUSTOMER_MESSAGE":          3,
		"AGENT_MESSAGE":             4,
	}
)

func (x TriggerEvent) Enum() *TriggerEvent {
	p := new(TriggerEvent)
	*p = x
	return p
}

func (x TriggerEvent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TriggerEvent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_generator_proto_enumTypes[0].Descriptor()
}

func (TriggerEvent) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_generator_proto_enumTypes[0]
}

func (x TriggerEvent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TriggerEvent.Descriptor instead.
func (TriggerEvent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{0}
}

// Enumeration of the roles a participant can play in a conversation.
type MessageEntry_Role int32

const (
	// Participant role not set.
	MessageEntry_ROLE_UNSPECIFIED MessageEntry_Role = 0
	// Participant is a human agent.
	MessageEntry_HUMAN_AGENT MessageEntry_Role = 1
	// Participant is an automated agent, such as a Dialogflow agent.
	MessageEntry_AUTOMATED_AGENT MessageEntry_Role = 2
	// Participant is an end user that has called or chatted with
	// Dialogflow services.
	MessageEntry_END_USER MessageEntry_Role = 3
)

// Enum value maps for MessageEntry_Role.
var (
	MessageEntry_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "HUMAN_AGENT",
		2: "AUTOMATED_AGENT",
		3: "END_USER",
	}
	MessageEntry_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"HUMAN_AGENT":      1,
		"AUTOMATED_AGENT":  2,
		"END_USER":         3,
	}
)

func (x MessageEntry_Role) Enum() *MessageEntry_Role {
	p := new(MessageEntry_Role)
	*p = x
	return p
}

func (x MessageEntry_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MessageEntry_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_generator_proto_enumTypes[1].Descriptor()
}

func (MessageEntry_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_generator_proto_enumTypes[1]
}

func (x MessageEntry_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MessageEntry_Role.Descriptor instead.
func (MessageEntry_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{6, 0}
}

// Type enum of the summarization sections.
type SummarizationSection_Type int32

const (
	// Undefined section type, does not return anything.
	SummarizationSection_TYPE_UNSPECIFIED SummarizationSection_Type = 0
	// What the customer needs help with or has question about.
	// Section name: "situation".
	SummarizationSection_SITUATION SummarizationSection_Type = 1
	// What the agent does to help the customer.
	// Section name: "action".
	SummarizationSection_ACTION SummarizationSection_Type = 2
	// Result of the customer service. A single word describing the result
	// of the conversation.
	// Section name: "resolution".
	SummarizationSection_RESOLUTION SummarizationSection_Type = 3
	// Reason for cancellation if the customer requests for a cancellation.
	// "N/A" otherwise.
	// Section name: "reason_for_cancellation".
	SummarizationSection_REASON_FOR_CANCELLATION SummarizationSection_Type = 4
	// "Unsatisfied" or "Satisfied" depending on the customer's feelings at
	// the end of the conversation.
	// Section name: "customer_satisfaction".
	SummarizationSection_CUSTOMER_SATISFACTION SummarizationSection_Type = 5
	// Key entities extracted from the conversation, such as ticket number,
	// order number, dollar amount, etc.
	// Section names are prefixed by "entities/".
	SummarizationSection_ENTITIES SummarizationSection_Type = 6
	// Customer defined sections.
	SummarizationSection_CUSTOMER_DEFINED SummarizationSection_Type = 7
	// Concise version of the situation section. This type is only available if
	// type SITUATION is not selected.
	SummarizationSection_SITUATION_CONCISE SummarizationSection_Type = 9
	// Concise version of the action section. This type is only available if
	// type ACTION is not selected.
	SummarizationSection_ACTION_CONCISE SummarizationSection_Type = 10
)

// Enum value maps for SummarizationSection_Type.
var (
	SummarizationSection_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "SITUATION",
		2:  "ACTION",
		3:  "RESOLUTION",
		4:  "REASON_FOR_CANCELLATION",
		5:  "CUSTOMER_SATISFACTION",
		6:  "ENTITIES",
		7:  "CUSTOMER_DEFINED",
		9:  "SITUATION_CONCISE",
		10: "ACTION_CONCISE",
	}
	SummarizationSection_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":        0,
		"SITUATION":               1,
		"ACTION":                  2,
		"RESOLUTION":              3,
		"REASON_FOR_CANCELLATION": 4,
		"CUSTOMER_SATISFACTION":   5,
		"ENTITIES":                6,
		"CUSTOMER_DEFINED":        7,
		"SITUATION_CONCISE":       9,
		"ACTION_CONCISE":          10,
	}
)

func (x SummarizationSection_Type) Enum() *SummarizationSection_Type {
	p := new(SummarizationSection_Type)
	*p = x
	return p
}

func (x SummarizationSection_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SummarizationSection_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_generator_proto_enumTypes[2].Descriptor()
}

func (SummarizationSection_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_generator_proto_enumTypes[2]
}

func (x SummarizationSection_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SummarizationSection_Type.Descriptor instead.
func (SummarizationSection_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{12, 0}
}

// Enum for RAI category.
type RaiSettings_RaiCategoryConfig_RaiCategory int32

const (
	// Default value.
	RaiSettings_RaiCategoryConfig_RAI_CATEGORY_UNSPECIFIED RaiSettings_RaiCategoryConfig_RaiCategory = 0
	// Dangerous content.
	RaiSettings_RaiCategoryConfig_DANGEROUS_CONTENT RaiSettings_RaiCategoryConfig_RaiCategory = 1
	// Sexually explicit content.
	RaiSettings_RaiCategoryConfig_SEXUALLY_EXPLICIT RaiSettings_RaiCategoryConfig_RaiCategory = 2
	// Harassment content.
	RaiSettings_RaiCategoryConfig_HARASSMENT RaiSettings_RaiCategoryConfig_RaiCategory = 3
	// Hate speech content.
	RaiSettings_RaiCategoryConfig_HATE_SPEECH RaiSettings_RaiCategoryConfig_RaiCategory = 4
)

// Enum value maps for RaiSettings_RaiCategoryConfig_RaiCategory.
var (
	RaiSettings_RaiCategoryConfig_RaiCategory_name = map[int32]string{
		0: "RAI_CATEGORY_UNSPECIFIED",
		1: "DANGEROUS_CONTENT",
		2: "SEXUALLY_EXPLICIT",
		3: "HARASSMENT",
		4: "HATE_SPEECH",
	}
	RaiSettings_RaiCategoryConfig_RaiCategory_value = map[string]int32{
		"RAI_CATEGORY_UNSPECIFIED": 0,
		"DANGEROUS_CONTENT":        1,
		"SEXUALLY_EXPLICIT":        2,
		"HARASSMENT":               3,
		"HATE_SPEECH":              4,
	}
)

func (x RaiSettings_RaiCategoryConfig_RaiCategory) Enum() *RaiSettings_RaiCategoryConfig_RaiCategory {
	p := new(RaiSettings_RaiCategoryConfig_RaiCategory)
	*p = x
	return p
}

func (x RaiSettings_RaiCategoryConfig_RaiCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiSettings_RaiCategoryConfig_RaiCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_generator_proto_enumTypes[3].Descriptor()
}

func (RaiSettings_RaiCategoryConfig_RaiCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_generator_proto_enumTypes[3]
}

func (x RaiSettings_RaiCategoryConfig_RaiCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiSettings_RaiCategoryConfig_RaiCategory.Descriptor instead.
func (RaiSettings_RaiCategoryConfig_RaiCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{21, 0, 0}
}

// Enum for user-configurable sensitivity levels.
type RaiSettings_RaiCategoryConfig_SensitivityLevel int32

const (
	// Default value.
	// If unspecified, the default behavior is:
	// - DANGEROUS_CONTENT: BLOCK_FEW
	// - SEXUALLY_EXPLICIT: BLOCK_SOME
	// - HARASSMENT: BLOCK_SOME
	// - HATE_SPEECH: BLOCK_SOME
	RaiSettings_RaiCategoryConfig_SENSITIVITY_LEVEL_UNSPECIFIED RaiSettings_RaiCategoryConfig_SensitivityLevel = 0
	// Block most potentially sensitive responses.
	RaiSettings_RaiCategoryConfig_BLOCK_MOST RaiSettings_RaiCategoryConfig_SensitivityLevel = 1
	// Block some potentially sensitive responses.
	RaiSettings_RaiCategoryConfig_BLOCK_SOME RaiSettings_RaiCategoryConfig_SensitivityLevel = 2
	// Block a few potentially sensitive responses.
	RaiSettings_RaiCategoryConfig_BLOCK_FEW RaiSettings_RaiCategoryConfig_SensitivityLevel = 3
	// No filtering for this category.
	RaiSettings_RaiCategoryConfig_BLOCK_NONE RaiSettings_RaiCategoryConfig_SensitivityLevel = 4
)

// Enum value maps for RaiSettings_RaiCategoryConfig_SensitivityLevel.
var (
	RaiSettings_RaiCategoryConfig_SensitivityLevel_name = map[int32]string{
		0: "SENSITIVITY_LEVEL_UNSPECIFIED",
		1: "BLOCK_MOST",
		2: "BLOCK_SOME",
		3: "BLOCK_FEW",
		4: "BLOCK_NONE",
	}
	RaiSettings_RaiCategoryConfig_SensitivityLevel_value = map[string]int32{
		"SENSITIVITY_LEVEL_UNSPECIFIED": 0,
		"BLOCK_MOST":                    1,
		"BLOCK_SOME":                    2,
		"BLOCK_FEW":                     3,
		"BLOCK_NONE":                    4,
	}
)

func (x RaiSettings_RaiCategoryConfig_SensitivityLevel) Enum() *RaiSettings_RaiCategoryConfig_SensitivityLevel {
	p := new(RaiSettings_RaiCategoryConfig_SensitivityLevel)
	*p = x
	return p
}

func (x RaiSettings_RaiCategoryConfig_SensitivityLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RaiSettings_RaiCategoryConfig_SensitivityLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2_generator_proto_enumTypes[4].Descriptor()
}

func (RaiSettings_RaiCategoryConfig_SensitivityLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2_generator_proto_enumTypes[4]
}

func (x RaiSettings_RaiCategoryConfig_SensitivityLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RaiSettings_RaiCategoryConfig_SensitivityLevel.Descriptor instead.
func (RaiSettings_RaiCategoryConfig_SensitivityLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{21, 0, 1}
}

// Request message of CreateGenerator.
type CreateGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project/location to create generator for. Format:
	// `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The generator to create.
	Generator *Generator `protobuf:"bytes,2,opt,name=generator,proto3" json:"generator,omitempty"`
	// Optional. The ID to use for the generator, which will become the final
	// component of the generator's resource name.
	//
	// The generator ID must be compliant with the regression formula
	// `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
	// If the field is not provided, an Id will be auto-generated.
	// If the field is provided, the caller is responsible for
	// 1. the uniqueness of the ID, otherwise the request will be rejected.
	// 2. the consistency for whether to use custom ID or not under a project to
	// better ensure uniqueness.
	GeneratorId string `protobuf:"bytes,3,opt,name=generator_id,json=generatorId,proto3" json:"generator_id,omitempty"`
}

func (x *CreateGeneratorRequest) Reset() {
	*x = CreateGeneratorRequest{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGeneratorRequest) ProtoMessage() {}

func (x *CreateGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGeneratorRequest.ProtoReflect.Descriptor instead.
func (*CreateGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{0}
}

func (x *CreateGeneratorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGeneratorRequest) GetGenerator() *Generator {
	if x != nil {
		return x.Generator
	}
	return nil
}

func (x *CreateGeneratorRequest) GetGeneratorId() string {
	if x != nil {
		return x.GeneratorId
	}
	return ""
}

// Request message of GetGenerator.
type GetGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator resource name to retrieve. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGeneratorRequest) Reset() {
	*x = GetGeneratorRequest{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGeneratorRequest) ProtoMessage() {}

func (x *GetGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGeneratorRequest.ProtoReflect.Descriptor instead.
func (*GetGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{1}
}

func (x *GetGeneratorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message of ListGenerators.
type ListGeneratorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project/location to list generators for. Format:
	// `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of conversation models to return in a single page.
	// Default to 10.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGeneratorsRequest) Reset() {
	*x = ListGeneratorsRequest{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGeneratorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorsRequest) ProtoMessage() {}

func (x *ListGeneratorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorsRequest.ProtoReflect.Descriptor instead.
func (*ListGeneratorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{2}
}

func (x *ListGeneratorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGeneratorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGeneratorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of ListGenerators.
type ListGeneratorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of generators retrieved.
	Generators []*Generator `protobuf:"bytes,1,rep,name=generators,proto3" json:"generators,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGeneratorsResponse) Reset() {
	*x = ListGeneratorsResponse{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGeneratorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGeneratorsResponse) ProtoMessage() {}

func (x *ListGeneratorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGeneratorsResponse.ProtoReflect.Descriptor instead.
func (*ListGeneratorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{3}
}

func (x *ListGeneratorsResponse) GetGenerators() []*Generator {
	if x != nil {
		return x.Generators
	}
	return nil
}

func (x *ListGeneratorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request of DeleteGenerator.
type DeleteGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator resource name to delete. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGeneratorRequest) Reset() {
	*x = DeleteGeneratorRequest{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGeneratorRequest) ProtoMessage() {}

func (x *DeleteGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGeneratorRequest.ProtoReflect.Descriptor instead.
func (*DeleteGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteGeneratorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request of UpdateGenerator.
type UpdateGeneratorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The generator to update.
	// The name field of generator is to identify the generator to update.
	Generator *Generator `protobuf:"bytes,1,opt,name=generator,proto3" json:"generator,omitempty"`
	// Optional. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGeneratorRequest) Reset() {
	*x = UpdateGeneratorRequest{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGeneratorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGeneratorRequest) ProtoMessage() {}

func (x *UpdateGeneratorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGeneratorRequest.ProtoReflect.Descriptor instead.
func (*UpdateGeneratorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateGeneratorRequest) GetGenerator() *Generator {
	if x != nil {
		return x.Generator
	}
	return nil
}

func (x *UpdateGeneratorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents a message entry of a conversation.
type MessageEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Participant role of the message.
	Role MessageEntry_Role `protobuf:"varint,1,opt,name=role,proto3,enum=google.cloud.dialogflow.v2.MessageEntry_Role" json:"role,omitempty"`
	// Optional. Transcript content of the message.
	Text string `protobuf:"bytes,2,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The language of the text. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language) for a
	// list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Create time of the message entry.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *MessageEntry) Reset() {
	*x = MessageEntry{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageEntry) ProtoMessage() {}

func (x *MessageEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageEntry.ProtoReflect.Descriptor instead.
func (*MessageEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{6}
}

func (x *MessageEntry) GetRole() MessageEntry_Role {
	if x != nil {
		return x.Role
	}
	return MessageEntry_ROLE_UNSPECIFIED
}

func (x *MessageEntry) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *MessageEntry) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *MessageEntry) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Context of the conversation, including transcripts.
type ConversationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of message transcripts in the conversation.
	MessageEntries []*MessageEntry `protobuf:"bytes,1,rep,name=message_entries,json=messageEntries,proto3" json:"message_entries,omitempty"`
}

func (x *ConversationContext) Reset() {
	*x = ConversationContext{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversationContext) ProtoMessage() {}

func (x *ConversationContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversationContext.ProtoReflect.Descriptor instead.
func (*ConversationContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{7}
}

func (x *ConversationContext) GetMessageEntries() []*MessageEntry {
	if x != nil {
		return x.MessageEntries
	}
	return nil
}

// List of summarization sections.
type SummarizationSectionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Summarization sections.
	SummarizationSections []*SummarizationSection `protobuf:"bytes,1,rep,name=summarization_sections,json=summarizationSections,proto3" json:"summarization_sections,omitempty"`
}

func (x *SummarizationSectionList) Reset() {
	*x = SummarizationSectionList{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationSectionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationSectionList) ProtoMessage() {}

func (x *SummarizationSectionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationSectionList.ProtoReflect.Descriptor instead.
func (*SummarizationSectionList) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{8}
}

func (x *SummarizationSectionList) GetSummarizationSections() []*SummarizationSection {
	if x != nil {
		return x.SummarizationSections
	}
	return nil
}

// Providing examples in the generator (i.e. building a few-shot generator)
// helps convey the desired format of the LLM response.
type FewShotExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Conversation transcripts.
	ConversationContext *ConversationContext `protobuf:"bytes,3,opt,name=conversation_context,json=conversationContext,proto3" json:"conversation_context,omitempty"`
	// Optional. Key is the placeholder field name in input, value is the value of
	// the placeholder. E.g. instruction contains "@price", and ingested data has
	// <"price", "10">
	ExtraInfo map[string]string `protobuf:"bytes,4,rep,name=extra_info,json=extraInfo,proto3" json:"extra_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Instruction list of this few_shot example.
	//
	// Types that are assignable to InstructionList:
	//
	//	*FewShotExample_SummarizationSectionList
	InstructionList isFewShotExample_InstructionList `protobuf_oneof:"instruction_list"`
	// Required. Example output of the model.
	Output *GeneratorSuggestion `protobuf:"bytes,7,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *FewShotExample) Reset() {
	*x = FewShotExample{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FewShotExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FewShotExample) ProtoMessage() {}

func (x *FewShotExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FewShotExample.ProtoReflect.Descriptor instead.
func (*FewShotExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{9}
}

func (x *FewShotExample) GetConversationContext() *ConversationContext {
	if x != nil {
		return x.ConversationContext
	}
	return nil
}

func (x *FewShotExample) GetExtraInfo() map[string]string {
	if x != nil {
		return x.ExtraInfo
	}
	return nil
}

func (m *FewShotExample) GetInstructionList() isFewShotExample_InstructionList {
	if m != nil {
		return m.InstructionList
	}
	return nil
}

func (x *FewShotExample) GetSummarizationSectionList() *SummarizationSectionList {
	if x, ok := x.GetInstructionList().(*FewShotExample_SummarizationSectionList); ok {
		return x.SummarizationSectionList
	}
	return nil
}

func (x *FewShotExample) GetOutput() *GeneratorSuggestion {
	if x != nil {
		return x.Output
	}
	return nil
}

type isFewShotExample_InstructionList interface {
	isFewShotExample_InstructionList()
}

type FewShotExample_SummarizationSectionList struct {
	// Summarization sections.
	SummarizationSectionList *SummarizationSectionList `protobuf:"bytes,6,opt,name=summarization_section_list,json=summarizationSectionList,proto3,oneof"`
}

func (*FewShotExample_SummarizationSectionList) isFewShotExample_InstructionList() {}

// The parameters of inference.
type InferenceParameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Maximum number of the output tokens for the generator.
	MaxOutputTokens *int32 `protobuf:"varint,1,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
	// Optional. Controls the randomness of LLM predictions.
	// Low temperature = less random. High temperature = more random.
	// If unset (or 0), uses a default value of 0.
	Temperature *float64 `protobuf:"fixed64,2,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. Top-k changes how the model selects tokens for output. A top-k of
	// 1 means the selected token is the most probable among all tokens in the
	// model's vocabulary (also called greedy decoding), while a top-k of 3 means
	// that the next token is selected from among the 3 most probable tokens
	// (using temperature). For each token selection step, the top K tokens with
	// the highest probabilities are sampled. Then tokens are further filtered
	// based on topP with the final token selected using temperature sampling.
	// Specify a lower value for less random responses and a higher value for more
	// random responses. Acceptable value is [1, 40], default to 40.
	TopK *int32 `protobuf:"varint,3,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// Optional. Top-p changes how the model selects tokens for output. Tokens are
	// selected from most K (see topK parameter) probable to least until the sum
	// of their probabilities equals the top-p value. For example, if tokens A, B,
	// and C have a probability of 0.3, 0.2, and 0.1 and the top-p value is 0.5,
	// then the model will select either A or B as the next token (using
	// temperature) and doesn't consider C. The default top-p value is 0.95.
	// Specify a lower value for less random responses and a higher value for more
	// random responses. Acceptable value is [0.0, 1.0], default to 0.95.
	TopP *float64 `protobuf:"fixed64,4,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
}

func (x *InferenceParameter) Reset() {
	*x = InferenceParameter{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InferenceParameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InferenceParameter) ProtoMessage() {}

func (x *InferenceParameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InferenceParameter.ProtoReflect.Descriptor instead.
func (*InferenceParameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{10}
}

func (x *InferenceParameter) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

func (x *InferenceParameter) GetTemperature() float64 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *InferenceParameter) GetTopK() int32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *InferenceParameter) GetTopP() float64 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

// Agent Coaching context that customer can configure.
type AgentCoachingContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The overarching guidance for the agent coaching. This should be
	// set only for v1.5 and later versions.
	OverarchingGuidance string `protobuf:"bytes,7,opt,name=overarching_guidance,json=overarchingGuidance,proto3" json:"overarching_guidance,omitempty"`
	// Optional. Customized instructions for agent coaching.
	Instructions []*AgentCoachingInstruction `protobuf:"bytes,1,rep,name=instructions,proto3" json:"instructions,omitempty"`
	// Optional. Version of the feature. If not set, default to latest version.
	// Current candidates are ["1.2"].
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. Output language code.
	OutputLanguageCode string `protobuf:"bytes,9,opt,name=output_language_code,json=outputLanguageCode,proto3" json:"output_language_code,omitempty"`
}

func (x *AgentCoachingContext) Reset() {
	*x = AgentCoachingContext{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingContext) ProtoMessage() {}

func (x *AgentCoachingContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingContext.ProtoReflect.Descriptor instead.
func (*AgentCoachingContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{11}
}

func (x *AgentCoachingContext) GetOverarchingGuidance() string {
	if x != nil {
		return x.OverarchingGuidance
	}
	return ""
}

func (x *AgentCoachingContext) GetInstructions() []*AgentCoachingInstruction {
	if x != nil {
		return x.Instructions
	}
	return nil
}

func (x *AgentCoachingContext) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *AgentCoachingContext) GetOutputLanguageCode() string {
	if x != nil {
		return x.OutputLanguageCode
	}
	return ""
}

// Represents the section of summarization.
type SummarizationSection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Name of the section, for example, "situation".
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. Definition of the section, for example, "what the customer needs
	// help with or has question about."
	Definition string `protobuf:"bytes,2,opt,name=definition,proto3" json:"definition,omitempty"`
	// Optional. Type of the summarization section.
	Type SummarizationSection_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.dialogflow.v2.SummarizationSection_Type" json:"type,omitempty"`
}

func (x *SummarizationSection) Reset() {
	*x = SummarizationSection{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationSection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationSection) ProtoMessage() {}

func (x *SummarizationSection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationSection.ProtoReflect.Descriptor instead.
func (*SummarizationSection) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{12}
}

func (x *SummarizationSection) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SummarizationSection) GetDefinition() string {
	if x != nil {
		return x.Definition
	}
	return ""
}

func (x *SummarizationSection) GetType() SummarizationSection_Type {
	if x != nil {
		return x.Type
	}
	return SummarizationSection_TYPE_UNSPECIFIED
}

// Summarization context that customer can configure.
type SummarizationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of sections. Note it contains both predefined section sand
	// customer defined sections.
	SummarizationSections []*SummarizationSection `protobuf:"bytes,1,rep,name=summarization_sections,json=summarizationSections,proto3" json:"summarization_sections,omitempty"`
	// Optional. List of few shot examples.
	FewShotExamples []*FewShotExample `protobuf:"bytes,2,rep,name=few_shot_examples,json=fewShotExamples,proto3" json:"few_shot_examples,omitempty"`
	// Optional. Version of the feature. If not set, default to latest version.
	// Current candidates are ["1.0"].
	Version string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. The target language of the generated summary. The language code
	// for conversation will be used if this field is empty. Supported 2.0 and
	// later versions.
	OutputLanguageCode string `protobuf:"bytes,6,opt,name=output_language_code,json=outputLanguageCode,proto3" json:"output_language_code,omitempty"`
}

func (x *SummarizationContext) Reset() {
	*x = SummarizationContext{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationContext) ProtoMessage() {}

func (x *SummarizationContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationContext.ProtoReflect.Descriptor instead.
func (*SummarizationContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{13}
}

func (x *SummarizationContext) GetSummarizationSections() []*SummarizationSection {
	if x != nil {
		return x.SummarizationSections
	}
	return nil
}

func (x *SummarizationContext) GetFewShotExamples() []*FewShotExample {
	if x != nil {
		return x.FewShotExamples
	}
	return nil
}

func (x *SummarizationContext) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SummarizationContext) GetOutputLanguageCode() string {
	if x != nil {
		return x.OutputLanguageCode
	}
	return ""
}

// Free form generator context that customer can configure.
type FreeFormContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Free form text input to LLM.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *FreeFormContext) Reset() {
	*x = FreeFormContext{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FreeFormContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FreeFormContext) ProtoMessage() {}

func (x *FreeFormContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FreeFormContext.ProtoReflect.Descriptor instead.
func (*FreeFormContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{14}
}

func (x *FreeFormContext) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// LLM generator.
type Generator struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the generator. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Human readable description of the generator.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Input context of the generator.
	//
	// Types that are assignable to Context:
	//
	//	*Generator_FreeFormContext
	//	*Generator_AgentCoachingContext
	//	*Generator_SummarizationContext
	Context isGenerator_Context `protobuf_oneof:"context"`
	// Optional. Inference parameters for this generator.
	InferenceParameter *InferenceParameter `protobuf:"bytes,4,opt,name=inference_parameter,json=inferenceParameter,proto3" json:"inference_parameter,omitempty"`
	// Optional. The trigger event of the generator. It defines when the generator
	// is triggered in a conversation.
	TriggerEvent TriggerEvent `protobuf:"varint,5,opt,name=trigger_event,json=triggerEvent,proto3,enum=google.cloud.dialogflow.v2.TriggerEvent" json:"trigger_event,omitempty"`
	// The foundation model to use for generating suggestions. If a foundation
	// model isn't specified here, a model specifically tuned for the feature
	// type (and version when applicable) will be used.
	//
	// Types that are assignable to FoundationModel:
	//
	//	*Generator_PublishedModel
	FoundationModel isGenerator_FoundationModel `protobuf_oneof:"foundation_model"`
	// Output only. Creation time of this generator.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time of this generator.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Resource names of the tools that the generator can choose from.
	// Format: `projects/<Project ID>/locations/<Location ID>/tools/<tool ID>`.
	Tools []string `protobuf:"bytes,14,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Configuration for suggestion deduping. This is only applicable to
	// AI Coach feature.
	SuggestionDedupingConfig *SuggestionDedupingConfig `protobuf:"bytes,23,opt,name=suggestion_deduping_config,json=suggestionDedupingConfig,proto3" json:"suggestion_deduping_config,omitempty"`
}

func (x *Generator) Reset() {
	*x = Generator{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Generator) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Generator) ProtoMessage() {}

func (x *Generator) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Generator.ProtoReflect.Descriptor instead.
func (*Generator) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{15}
}

func (x *Generator) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Generator) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *Generator) GetContext() isGenerator_Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (x *Generator) GetFreeFormContext() *FreeFormContext {
	if x, ok := x.GetContext().(*Generator_FreeFormContext); ok {
		return x.FreeFormContext
	}
	return nil
}

func (x *Generator) GetAgentCoachingContext() *AgentCoachingContext {
	if x, ok := x.GetContext().(*Generator_AgentCoachingContext); ok {
		return x.AgentCoachingContext
	}
	return nil
}

func (x *Generator) GetSummarizationContext() *SummarizationContext {
	if x, ok := x.GetContext().(*Generator_SummarizationContext); ok {
		return x.SummarizationContext
	}
	return nil
}

func (x *Generator) GetInferenceParameter() *InferenceParameter {
	if x != nil {
		return x.InferenceParameter
	}
	return nil
}

func (x *Generator) GetTriggerEvent() TriggerEvent {
	if x != nil {
		return x.TriggerEvent
	}
	return TriggerEvent_TRIGGER_EVENT_UNSPECIFIED
}

func (m *Generator) GetFoundationModel() isGenerator_FoundationModel {
	if m != nil {
		return m.FoundationModel
	}
	return nil
}

func (x *Generator) GetPublishedModel() string {
	if x, ok := x.GetFoundationModel().(*Generator_PublishedModel); ok {
		return x.PublishedModel
	}
	return ""
}

func (x *Generator) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Generator) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Generator) GetTools() []string {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *Generator) GetSuggestionDedupingConfig() *SuggestionDedupingConfig {
	if x != nil {
		return x.SuggestionDedupingConfig
	}
	return nil
}

type isGenerator_Context interface {
	isGenerator_Context()
}

type Generator_FreeFormContext struct {
	// Input of free from generator to LLM.
	FreeFormContext *FreeFormContext `protobuf:"bytes,11,opt,name=free_form_context,json=freeFormContext,proto3,oneof"`
}

type Generator_AgentCoachingContext struct {
	// Input of prebuilt Agent Coaching feature.
	AgentCoachingContext *AgentCoachingContext `protobuf:"bytes,12,opt,name=agent_coaching_context,json=agentCoachingContext,proto3,oneof"`
}

type Generator_SummarizationContext struct {
	// Input of prebuilt Summarization feature.
	SummarizationContext *SummarizationContext `protobuf:"bytes,13,opt,name=summarization_context,json=summarizationContext,proto3,oneof"`
}

func (*Generator_FreeFormContext) isGenerator_Context() {}

func (*Generator_AgentCoachingContext) isGenerator_Context() {}

func (*Generator_SummarizationContext) isGenerator_Context() {}

type isGenerator_FoundationModel interface {
	isGenerator_FoundationModel()
}

type Generator_PublishedModel struct {
	// Optional. The published Large Language Model name.
	//   - To use the latest model version, specify the model name without version
	//     number. Example: `text-bison`
	//   - To use a stable model version, specify the version number as well.
	//     Example: `text-bison@002`.
	PublishedModel string `protobuf:"bytes,15,opt,name=published_model,json=publishedModel,proto3,oneof"`
}

func (*Generator_PublishedModel) isGenerator_FoundationModel() {}

// Suggestion generated using free form generator.
type FreeFormSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Free form suggestion.
	Response string `protobuf:"bytes,1,opt,name=response,proto3" json:"response,omitempty"`
}

func (x *FreeFormSuggestion) Reset() {
	*x = FreeFormSuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FreeFormSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FreeFormSuggestion) ProtoMessage() {}

func (x *FreeFormSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FreeFormSuggestion.ProtoReflect.Descriptor instead.
func (*FreeFormSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{16}
}

func (x *FreeFormSuggestion) GetResponse() string {
	if x != nil {
		return x.Response
	}
	return ""
}

// Suggested summary of the conversation.
type SummarySuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. All the parts of generated summary.
	SummarySections []*SummarySuggestion_SummarySection `protobuf:"bytes,1,rep,name=summary_sections,json=summarySections,proto3" json:"summary_sections,omitempty"`
}

func (x *SummarySuggestion) Reset() {
	*x = SummarySuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarySuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarySuggestion) ProtoMessage() {}

func (x *SummarySuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarySuggestion.ProtoReflect.Descriptor instead.
func (*SummarySuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{17}
}

func (x *SummarySuggestion) GetSummarySections() []*SummarySuggestion_SummarySection {
	if x != nil {
		return x.SummarySections
	}
	return nil
}

// Suggestion for coaching agents.
type AgentCoachingSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Instructions applicable based on the current context.
	ApplicableInstructions []*AgentCoachingInstruction `protobuf:"bytes,1,rep,name=applicable_instructions,json=applicableInstructions,proto3" json:"applicable_instructions,omitempty"`
	// Optional. Suggested actions for the agent to take.
	AgentActionSuggestions []*AgentCoachingSuggestion_AgentActionSuggestion `protobuf:"bytes,2,rep,name=agent_action_suggestions,json=agentActionSuggestions,proto3" json:"agent_action_suggestions,omitempty"`
	// Optional. Sample response for the Agent.
	SampleResponses []*AgentCoachingSuggestion_SampleResponse `protobuf:"bytes,3,rep,name=sample_responses,json=sampleResponses,proto3" json:"sample_responses,omitempty"`
}

func (x *AgentCoachingSuggestion) Reset() {
	*x = AgentCoachingSuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion) ProtoMessage() {}

func (x *AgentCoachingSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18}
}

func (x *AgentCoachingSuggestion) GetApplicableInstructions() []*AgentCoachingInstruction {
	if x != nil {
		return x.ApplicableInstructions
	}
	return nil
}

func (x *AgentCoachingSuggestion) GetAgentActionSuggestions() []*AgentCoachingSuggestion_AgentActionSuggestion {
	if x != nil {
		return x.AgentActionSuggestions
	}
	return nil
}

func (x *AgentCoachingSuggestion) GetSampleResponses() []*AgentCoachingSuggestion_SampleResponse {
	if x != nil {
		return x.SampleResponses
	}
	return nil
}

// Suggestion generated using a Generator.
type GeneratorSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion could be one of the many types
	//
	// Types that are assignable to Suggestion:
	//
	//	*GeneratorSuggestion_FreeFormSuggestion
	//	*GeneratorSuggestion_SummarySuggestion
	//	*GeneratorSuggestion_AgentCoachingSuggestion
	Suggestion isGeneratorSuggestion_Suggestion `protobuf_oneof:"suggestion"`
	// Optional. List of request and response for tool calls executed.
	ToolCallInfo []*GeneratorSuggestion_ToolCallInfo `protobuf:"bytes,9,rep,name=tool_call_info,json=toolCallInfo,proto3" json:"tool_call_info,omitempty"`
}

func (x *GeneratorSuggestion) Reset() {
	*x = GeneratorSuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorSuggestion) ProtoMessage() {}

func (x *GeneratorSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorSuggestion.ProtoReflect.Descriptor instead.
func (*GeneratorSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{19}
}

func (m *GeneratorSuggestion) GetSuggestion() isGeneratorSuggestion_Suggestion {
	if m != nil {
		return m.Suggestion
	}
	return nil
}

func (x *GeneratorSuggestion) GetFreeFormSuggestion() *FreeFormSuggestion {
	if x, ok := x.GetSuggestion().(*GeneratorSuggestion_FreeFormSuggestion); ok {
		return x.FreeFormSuggestion
	}
	return nil
}

func (x *GeneratorSuggestion) GetSummarySuggestion() *SummarySuggestion {
	if x, ok := x.GetSuggestion().(*GeneratorSuggestion_SummarySuggestion); ok {
		return x.SummarySuggestion
	}
	return nil
}

func (x *GeneratorSuggestion) GetAgentCoachingSuggestion() *AgentCoachingSuggestion {
	if x, ok := x.GetSuggestion().(*GeneratorSuggestion_AgentCoachingSuggestion); ok {
		return x.AgentCoachingSuggestion
	}
	return nil
}

func (x *GeneratorSuggestion) GetToolCallInfo() []*GeneratorSuggestion_ToolCallInfo {
	if x != nil {
		return x.ToolCallInfo
	}
	return nil
}

type isGeneratorSuggestion_Suggestion interface {
	isGeneratorSuggestion_Suggestion()
}

type GeneratorSuggestion_FreeFormSuggestion struct {
	// Optional. Free form suggestion.
	FreeFormSuggestion *FreeFormSuggestion `protobuf:"bytes,1,opt,name=free_form_suggestion,json=freeFormSuggestion,proto3,oneof"`
}

type GeneratorSuggestion_SummarySuggestion struct {
	// Optional. Suggested summary.
	SummarySuggestion *SummarySuggestion `protobuf:"bytes,2,opt,name=summary_suggestion,json=summarySuggestion,proto3,oneof"`
}

type GeneratorSuggestion_AgentCoachingSuggestion struct {
	// Optional. Suggestion to coach the agent.
	AgentCoachingSuggestion *AgentCoachingSuggestion `protobuf:"bytes,3,opt,name=agent_coaching_suggestion,json=agentCoachingSuggestion,proto3,oneof"`
}

func (*GeneratorSuggestion_FreeFormSuggestion) isGeneratorSuggestion_Suggestion() {}

func (*GeneratorSuggestion_SummarySuggestion) isGeneratorSuggestion_Suggestion() {}

func (*GeneratorSuggestion_AgentCoachingSuggestion) isGeneratorSuggestion_Suggestion() {}

// Config for suggestion deduping.
// NEXT_ID: 3
type SuggestionDedupingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to enable suggestion deduping.
	EnableDeduping bool `protobuf:"varint,1,opt,name=enable_deduping,json=enableDeduping,proto3" json:"enable_deduping,omitempty"`
	// Optional. The threshold for similarity between two suggestions.
	// Acceptable value is [0.0, 1.0], default to 0.8
	SimilarityThreshold float32 `protobuf:"fixed32,2,opt,name=similarity_threshold,json=similarityThreshold,proto3" json:"similarity_threshold,omitempty"`
}

func (x *SuggestionDedupingConfig) Reset() {
	*x = SuggestionDedupingConfig{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestionDedupingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionDedupingConfig) ProtoMessage() {}

func (x *SuggestionDedupingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionDedupingConfig.ProtoReflect.Descriptor instead.
func (*SuggestionDedupingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{20}
}

func (x *SuggestionDedupingConfig) GetEnableDeduping() bool {
	if x != nil {
		return x.EnableDeduping
	}
	return false
}

func (x *SuggestionDedupingConfig) GetSimilarityThreshold() float32 {
	if x != nil {
		return x.SimilarityThreshold
	}
	return 0
}

// Settings for Responsible AI checks.
type RaiSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for a set of RAI categories.
	RaiCategoryConfigs []*RaiSettings_RaiCategoryConfig `protobuf:"bytes,1,rep,name=rai_category_configs,json=raiCategoryConfigs,proto3" json:"rai_category_configs,omitempty"`
}

func (x *RaiSettings) Reset() {
	*x = RaiSettings{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiSettings) ProtoMessage() {}

func (x *RaiSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiSettings.ProtoReflect.Descriptor instead.
func (*RaiSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{21}
}

func (x *RaiSettings) GetRaiCategoryConfigs() []*RaiSettings_RaiCategoryConfig {
	if x != nil {
		return x.RaiCategoryConfigs
	}
	return nil
}

// A component of the generated summary.
type SummarySuggestion_SummarySection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the section.
	Section string `protobuf:"bytes,1,opt,name=section,proto3" json:"section,omitempty"`
	// Required. Summary text for the section.
	Summary string `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
}

func (x *SummarySuggestion_SummarySection) Reset() {
	*x = SummarySuggestion_SummarySection{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarySuggestion_SummarySection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarySuggestion_SummarySection) ProtoMessage() {}

func (x *SummarySuggestion_SummarySection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarySuggestion_SummarySection.ProtoReflect.Descriptor instead.
func (*SummarySuggestion_SummarySection) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{17, 0}
}

func (x *SummarySuggestion_SummarySection) GetSection() string {
	if x != nil {
		return x.Section
	}
	return ""
}

func (x *SummarySuggestion_SummarySection) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

// Sources for the suggestion.
type AgentCoachingSuggestion_Sources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Source instruction indexes for the suggestion. This is the
	// index of the applicable_instructions field.
	InstructionIndexes []int32 `protobuf:"varint,2,rep,packed,name=instruction_indexes,json=instructionIndexes,proto3" json:"instruction_indexes,omitempty"`
}

func (x *AgentCoachingSuggestion_Sources) Reset() {
	*x = AgentCoachingSuggestion_Sources{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion_Sources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion_Sources) ProtoMessage() {}

func (x *AgentCoachingSuggestion_Sources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion_Sources.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion_Sources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18, 0}
}

func (x *AgentCoachingSuggestion_Sources) GetInstructionIndexes() []int32 {
	if x != nil {
		return x.InstructionIndexes
	}
	return nil
}

// Duplication check for the suggestion.
type AgentCoachingSuggestion_DuplicateCheckResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The duplicate suggestions.
	DuplicateSuggestions []*AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion `protobuf:"bytes,1,rep,name=duplicate_suggestions,json=duplicateSuggestions,proto3" json:"duplicate_suggestions,omitempty"`
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult) Reset() {
	*x = AgentCoachingSuggestion_DuplicateCheckResult{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion_DuplicateCheckResult) ProtoMessage() {}

func (x *AgentCoachingSuggestion_DuplicateCheckResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion_DuplicateCheckResult.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion_DuplicateCheckResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18, 1}
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult) GetDuplicateSuggestions() []*AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion {
	if x != nil {
		return x.DuplicateSuggestions
	}
	return nil
}

// Actions suggested for the agent. This is based on applicable instructions.
type AgentCoachingSuggestion_AgentActionSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The suggested action for the agent.
	AgentAction string `protobuf:"bytes,1,opt,name=agent_action,json=agentAction,proto3" json:"agent_action,omitempty"`
	// Output only. Sources for the agent action suggestion.
	Sources *AgentCoachingSuggestion_Sources `protobuf:"bytes,2,opt,name=sources,proto3" json:"sources,omitempty"`
	// Output only. Duplicate check result for the agent action suggestion.
	DuplicateCheckResult *AgentCoachingSuggestion_DuplicateCheckResult `protobuf:"bytes,3,opt,name=duplicate_check_result,json=duplicateCheckResult,proto3" json:"duplicate_check_result,omitempty"`
}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) Reset() {
	*x = AgentCoachingSuggestion_AgentActionSuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion_AgentActionSuggestion) ProtoMessage() {}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion_AgentActionSuggestion.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion_AgentActionSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18, 2}
}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) GetAgentAction() string {
	if x != nil {
		return x.AgentAction
	}
	return ""
}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) GetSources() *AgentCoachingSuggestion_Sources {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *AgentCoachingSuggestion_AgentActionSuggestion) GetDuplicateCheckResult() *AgentCoachingSuggestion_DuplicateCheckResult {
	if x != nil {
		return x.DuplicateCheckResult
	}
	return nil
}

// Sample response that the agent can use. This could be based on applicable
// instructions and ingested data from other systems.
type AgentCoachingSuggestion_SampleResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Sample response for Agent in text.
	ResponseText string `protobuf:"bytes,1,opt,name=response_text,json=responseText,proto3" json:"response_text,omitempty"`
	// Output only. Sources for the Sample Response.
	Sources *AgentCoachingSuggestion_Sources `protobuf:"bytes,2,opt,name=sources,proto3" json:"sources,omitempty"`
	// Output only. Duplicate check result for the sample response.
	DuplicateCheckResult *AgentCoachingSuggestion_DuplicateCheckResult `protobuf:"bytes,3,opt,name=duplicate_check_result,json=duplicateCheckResult,proto3" json:"duplicate_check_result,omitempty"`
}

func (x *AgentCoachingSuggestion_SampleResponse) Reset() {
	*x = AgentCoachingSuggestion_SampleResponse{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion_SampleResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion_SampleResponse) ProtoMessage() {}

func (x *AgentCoachingSuggestion_SampleResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion_SampleResponse.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion_SampleResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18, 3}
}

func (x *AgentCoachingSuggestion_SampleResponse) GetResponseText() string {
	if x != nil {
		return x.ResponseText
	}
	return ""
}

func (x *AgentCoachingSuggestion_SampleResponse) GetSources() *AgentCoachingSuggestion_Sources {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *AgentCoachingSuggestion_SampleResponse) GetDuplicateCheckResult() *AgentCoachingSuggestion_DuplicateCheckResult {
	if x != nil {
		return x.DuplicateCheckResult
	}
	return nil
}

// The duplicate suggestion details.
// Keeping answer_record and sources together as they are identifiers for
// duplicate suggestions.
type AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The answer record id of the past duplicate suggestion.
	AnswerRecord string `protobuf:"bytes,1,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// Output only. Sources for the suggestion.
	Sources *AgentCoachingSuggestion_Sources `protobuf:"bytes,2,opt,name=sources,proto3" json:"sources,omitempty"`
	// Output only. The index of the duplicate suggestion in the past
	// suggestion list.
	SuggestionIndex int32 `protobuf:"varint,3,opt,name=suggestion_index,json=suggestionIndex,proto3" json:"suggestion_index,omitempty"`
	// Output only. The similarity score of between the past and current
	// suggestion.
	SimilarityScore float32 `protobuf:"fixed32,4,opt,name=similarity_score,json=similarityScore,proto3" json:"similarity_score,omitempty"`
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) Reset() {
	*x = AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) ProtoMessage() {}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion.ProtoReflect.Descriptor instead.
func (*AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{18, 1, 0}
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) GetSources() *AgentCoachingSuggestion_Sources {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) GetSuggestionIndex() int32 {
	if x != nil {
		return x.SuggestionIndex
	}
	return 0
}

func (x *AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion) GetSimilarityScore() float32 {
	if x != nil {
		return x.SimilarityScore
	}
	return 0
}

// Request and response for a tool call.
type GeneratorSuggestion_ToolCallInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Request for a tool call.
	ToolCall *ToolCall `protobuf:"bytes,1,opt,name=tool_call,json=toolCall,proto3" json:"tool_call,omitempty"`
	// Required. Response for a tool call.
	ToolCallResult *ToolCallResult `protobuf:"bytes,2,opt,name=tool_call_result,json=toolCallResult,proto3" json:"tool_call_result,omitempty"`
}

func (x *GeneratorSuggestion_ToolCallInfo) Reset() {
	*x = GeneratorSuggestion_ToolCallInfo{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GeneratorSuggestion_ToolCallInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GeneratorSuggestion_ToolCallInfo) ProtoMessage() {}

func (x *GeneratorSuggestion_ToolCallInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GeneratorSuggestion_ToolCallInfo.ProtoReflect.Descriptor instead.
func (*GeneratorSuggestion_ToolCallInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{19, 0}
}

func (x *GeneratorSuggestion_ToolCallInfo) GetToolCall() *ToolCall {
	if x != nil {
		return x.ToolCall
	}
	return nil
}

func (x *GeneratorSuggestion_ToolCallInfo) GetToolCallResult() *ToolCallResult {
	if x != nil {
		return x.ToolCallResult
	}
	return nil
}

// Configuration for a specific RAI category.
type RaiSettings_RaiCategoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The RAI category.
	Category RaiSettings_RaiCategoryConfig_RaiCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.dialogflow.v2.RaiSettings_RaiCategoryConfig_RaiCategory" json:"category,omitempty"`
	// Optional. The sensitivity level for this category.
	SensitivityLevel RaiSettings_RaiCategoryConfig_SensitivityLevel `protobuf:"varint,2,opt,name=sensitivity_level,json=sensitivityLevel,proto3,enum=google.cloud.dialogflow.v2.RaiSettings_RaiCategoryConfig_SensitivityLevel" json:"sensitivity_level,omitempty"`
}

func (x *RaiSettings_RaiCategoryConfig) Reset() {
	*x = RaiSettings_RaiCategoryConfig{}
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaiSettings_RaiCategoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaiSettings_RaiCategoryConfig) ProtoMessage() {}

func (x *RaiSettings_RaiCategoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2_generator_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaiSettings_RaiCategoryConfig.ProtoReflect.Descriptor instead.
func (*RaiSettings_RaiCategoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP(), []int{21, 0}
}

func (x *RaiSettings_RaiCategoryConfig) GetCategory() RaiSettings_RaiCategoryConfig_RaiCategory {
	if x != nil {
		return x.Category
	}
	return RaiSettings_RaiCategoryConfig_RAI_CATEGORY_UNSPECIFIED
}

func (x *RaiSettings_RaiCategoryConfig) GetSensitivityLevel() RaiSettings_RaiCategoryConfig_SensitivityLevel {
	if x != nil {
		return x.SensitivityLevel
	}
	return RaiSettings_RaiCategoryConfig_SENSITIVITY_LEVEL_UNSPECIFIED
}

var File_google_cloud_dialogflow_v2_generator_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2_generator_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x76, 0x32, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd7, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x09,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x26, 0x0a, 0x0c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x22, 0x56,
	0x0a, 0x13, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaa, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x87, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45,
	0x0a, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a,
	0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22,
	0xad, 0x02, 0x0a, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x46, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x50, 0x0a,
	0x04, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x48,
	0x55, 0x4d, 0x41, 0x4e, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x03, 0x22,
	0x6d, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x56, 0x0a, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x22, 0x88,
	0x01, 0x0a, 0x18, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x6c, 0x0a, 0x16, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xee, 0x03, 0x0a, 0x0e, 0x46, 0x65,
	0x77, 0x53, 0x68, 0x6f, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x67, 0x0a, 0x14,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x5d, 0x0a, 0x0a, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x77, 0x53, 0x68, 0x6f, 0x74, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x78, 0x74, 0x72, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x74, 0x0a, 0x1a, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x18, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0x3c, 0x0a, 0x0e, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x22, 0xee, 0x01, 0x0a, 0x12, 0x49,
	0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x12, 0x34, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x88,
	0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x50, 0x88, 0x01,
	0x01, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f,
	0x6b, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x22, 0x83, 0x02, 0x0a, 0x14,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x36, 0x0a, 0x14, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x5f, 0x67, 0x75, 0x69, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x47, 0x75, 0x69, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5d, 0x0a, 0x0c,
	0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x14, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0xf3, 0x02, 0x0a, 0x14, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xce, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49, 0x54, 0x55, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03,
	0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x19, 0x0a,
	0x15, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x53, 0x41, 0x54, 0x49, 0x53, 0x46,
	0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x49, 0x45, 0x53, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d,
	0x45, 0x52, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x45, 0x44, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x49, 0x54, 0x55, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x53,
	0x45, 0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f,
	0x4e, 0x43, 0x49, 0x53, 0x45, 0x10, 0x0a, 0x22, 0xb7, 0x02, 0x0a, 0x14, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x6c, 0x0a, 0x16, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5b,
	0x0a, 0x11, 0x66, 0x65, 0x77, 0x5f, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x77, 0x53, 0x68, 0x6f, 0x74, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x66, 0x65, 0x77, 0x53,
	0x68, 0x6f, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x0a, 0x14, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x22, 0x2a, 0x0a, 0x0f, 0x46, 0x72, 0x65, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xc1, 0x08,
	0x0a, 0x09, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x1a, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59,
	0x0a, 0x11, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x72, 0x65, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x66, 0x72, 0x65, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x68, 0x0a, 0x16, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x14, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x67, 0x0a, 0x15, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x14, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x64, 0x0a, 0x13,
	0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12,
	0x69, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x12, 0x52, 0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x05, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f,
	0x6c, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x77, 0x0a, 0x1a, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x64, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x64, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x23, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x3e, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x7d, 0x2a, 0x0a, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x32, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x12, 0x0a,
	0x10, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0x35, 0x0a, 0x12, 0x46, 0x72, 0x65, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd1, 0x01, 0x0a, 0x11, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c,
	0x0a, 0x10, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x79, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x4e, 0x0a, 0x0e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d,
	0x0a, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x22, 0xc0, 0x0b, 0x0a,
	0x17, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x88, 0x01, 0x0a,
	0x18, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x16, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x72, 0x0a, 0x10, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x73, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x07, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x65, 0x73, 0x1a, 0xad, 0x03, 0x0a,
	0x14, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x96, 0x01, 0x0a, 0x15, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xfb,
	0x01, 0x0a, 0x13, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x12, 0x5a, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2e, 0x0a, 0x10,
	0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x73, 0x69, 0x6d,
	0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0xa1, 0x02, 0x0a,
	0x15, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a,
	0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x16, 0x64,
	0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x64, 0x75, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x1a, 0x9c, 0x02, 0x0a, 0x0e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x5a, 0x0a,
	0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x16, 0x64, 0x75,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x64, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x86, 0x05, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x14, 0x66, 0x72, 0x65, 0x65, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x72, 0x65, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x66, 0x72,
	0x65, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x63, 0x0a, 0x12, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x11, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x76, 0x0a, 0x19, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63,
	0x6f, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x17, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x67, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a,
	0x0e, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x49,
	0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61,
	0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xb1, 0x01, 0x0a, 0x0c, 0x54, 0x6f, 0x6f, 0x6c, 0x43,
	0x61, 0x6c, 0x6c, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x46, 0x0a, 0x09, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x63, 0x61, 0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x12,
	0x59, 0x0a, 0x10, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x6f, 0x6f, 0x6c,
	0x43, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x18, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x64, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x64, 0x65, 0x64, 0x75, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x65, 0x64, 0x75, 0x70,
	0x69, 0x6e, 0x67, 0x12, 0x36, 0x0a, 0x14, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xe8, 0x04, 0x0a, 0x0b,
	0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x6b, 0x0a, 0x14, 0x72,
	0x61, 0x69, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x72, 0x61, 0x69, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0xeb, 0x03, 0x0a, 0x11, 0x52, 0x61, 0x69,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66,
	0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61,
	0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x61, 0x69, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x7c, 0x0a, 0x11, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x61, 0x69, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x52, 0x61, 0x69, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x22, 0x7a, 0x0a, 0x0b, 0x52, 0x61, 0x69, 0x43, 0x61, 0x74, 0x65, 0x67,
	0x6f, 0x72, 0x79, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x41, 0x49, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47,
	0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x45, 0x58, 0x55,
	0x41, 0x4c, 0x4c, 0x59, 0x5f, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x02, 0x12,
	0x0e, 0x0a, 0x0a, 0x48, 0x41, 0x52, 0x41, 0x53, 0x53, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12,
	0x0f, 0x0a, 0x0b, 0x48, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x45, 0x43, 0x48, 0x10, 0x04,
	0x22, 0x74, 0x0a, 0x10, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56,
	0x49, 0x54, 0x59, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x4d, 0x4f, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x53, 0x4f, 0x4d, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x46, 0x45, 0x57, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x04, 0x2a, 0x7d, 0x0a, 0x0c, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x52, 0x49, 0x47, 0x47, 0x45,
	0x52, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x45, 0x4e, 0x44, 0x5f, 0x4f, 0x46, 0x5f,
	0x55, 0x54, 0x54, 0x45, 0x52, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x4d,
	0x41, 0x4e, 0x55, 0x41, 0x4c, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10,
	0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45,
	0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x10, 0x04, 0x32, 0x86, 0x09, 0x0a, 0x0a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x12, 0x81, 0x02, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x22, 0x92, 0x01, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6c, 0x3a, 0x09, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5a, 0x2f, 0x3a, 0x09, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x22, 0x22, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x12, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xde, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x65, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x5a, 0x24, 0x12, 0x22, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x73, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x73, 0x12, 0x9c, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30,
	0x2a, 0x2e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd1, 0x01, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22,
	0x63, 0xda, 0x41, 0x15, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a,
	0x09, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x32, 0x38, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x91,
	0x02, 0xea, 0x41, 0x7a, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x0a, 0x1e,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x42, 0x0e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62,
	0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2_generator_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2_generator_proto_rawDescData = file_google_cloud_dialogflow_v2_generator_proto_rawDesc
)

func file_google_cloud_dialogflow_v2_generator_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2_generator_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2_generator_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2_generator_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2_generator_proto_rawDescData
}

var file_google_cloud_dialogflow_v2_generator_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_dialogflow_v2_generator_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_google_cloud_dialogflow_v2_generator_proto_goTypes = []any{
	(TriggerEvent)(0),                                     // 0: google.cloud.dialogflow.v2.TriggerEvent
	(MessageEntry_Role)(0),                                // 1: google.cloud.dialogflow.v2.MessageEntry.Role
	(SummarizationSection_Type)(0),                        // 2: google.cloud.dialogflow.v2.SummarizationSection.Type
	(RaiSettings_RaiCategoryConfig_RaiCategory)(0),        // 3: google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.RaiCategory
	(RaiSettings_RaiCategoryConfig_SensitivityLevel)(0),   // 4: google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.SensitivityLevel
	(*CreateGeneratorRequest)(nil),                        // 5: google.cloud.dialogflow.v2.CreateGeneratorRequest
	(*GetGeneratorRequest)(nil),                           // 6: google.cloud.dialogflow.v2.GetGeneratorRequest
	(*ListGeneratorsRequest)(nil),                         // 7: google.cloud.dialogflow.v2.ListGeneratorsRequest
	(*ListGeneratorsResponse)(nil),                        // 8: google.cloud.dialogflow.v2.ListGeneratorsResponse
	(*DeleteGeneratorRequest)(nil),                        // 9: google.cloud.dialogflow.v2.DeleteGeneratorRequest
	(*UpdateGeneratorRequest)(nil),                        // 10: google.cloud.dialogflow.v2.UpdateGeneratorRequest
	(*MessageEntry)(nil),                                  // 11: google.cloud.dialogflow.v2.MessageEntry
	(*ConversationContext)(nil),                           // 12: google.cloud.dialogflow.v2.ConversationContext
	(*SummarizationSectionList)(nil),                      // 13: google.cloud.dialogflow.v2.SummarizationSectionList
	(*FewShotExample)(nil),                                // 14: google.cloud.dialogflow.v2.FewShotExample
	(*InferenceParameter)(nil),                            // 15: google.cloud.dialogflow.v2.InferenceParameter
	(*AgentCoachingContext)(nil),                          // 16: google.cloud.dialogflow.v2.AgentCoachingContext
	(*SummarizationSection)(nil),                          // 17: google.cloud.dialogflow.v2.SummarizationSection
	(*SummarizationContext)(nil),                          // 18: google.cloud.dialogflow.v2.SummarizationContext
	(*FreeFormContext)(nil),                               // 19: google.cloud.dialogflow.v2.FreeFormContext
	(*Generator)(nil),                                     // 20: google.cloud.dialogflow.v2.Generator
	(*FreeFormSuggestion)(nil),                            // 21: google.cloud.dialogflow.v2.FreeFormSuggestion
	(*SummarySuggestion)(nil),                             // 22: google.cloud.dialogflow.v2.SummarySuggestion
	(*AgentCoachingSuggestion)(nil),                       // 23: google.cloud.dialogflow.v2.AgentCoachingSuggestion
	(*GeneratorSuggestion)(nil),                           // 24: google.cloud.dialogflow.v2.GeneratorSuggestion
	(*SuggestionDedupingConfig)(nil),                      // 25: google.cloud.dialogflow.v2.SuggestionDedupingConfig
	(*RaiSettings)(nil),                                   // 26: google.cloud.dialogflow.v2.RaiSettings
	nil,                                                   // 27: google.cloud.dialogflow.v2.FewShotExample.ExtraInfoEntry
	(*SummarySuggestion_SummarySection)(nil),              // 28: google.cloud.dialogflow.v2.SummarySuggestion.SummarySection
	(*AgentCoachingSuggestion_Sources)(nil),               // 29: google.cloud.dialogflow.v2.AgentCoachingSuggestion.Sources
	(*AgentCoachingSuggestion_DuplicateCheckResult)(nil),  // 30: google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult
	(*AgentCoachingSuggestion_AgentActionSuggestion)(nil), // 31: google.cloud.dialogflow.v2.AgentCoachingSuggestion.AgentActionSuggestion
	(*AgentCoachingSuggestion_SampleResponse)(nil),        // 32: google.cloud.dialogflow.v2.AgentCoachingSuggestion.SampleResponse
	(*AgentCoachingSuggestion_DuplicateCheckResult_DuplicateSuggestion)(nil), // 33: google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult.DuplicateSuggestion
	(*GeneratorSuggestion_ToolCallInfo)(nil),                                 // 34: google.cloud.dialogflow.v2.GeneratorSuggestion.ToolCallInfo
	(*RaiSettings_RaiCategoryConfig)(nil),                                    // 35: google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig
	(*fieldmaskpb.FieldMask)(nil),                                            // 36: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                                            // 37: google.protobuf.Timestamp
	(*AgentCoachingInstruction)(nil),                                         // 38: google.cloud.dialogflow.v2.AgentCoachingInstruction
	(*ToolCall)(nil),                                                         // 39: google.cloud.dialogflow.v2.ToolCall
	(*ToolCallResult)(nil),                                                   // 40: google.cloud.dialogflow.v2.ToolCallResult
	(*emptypb.Empty)(nil),                                                    // 41: google.protobuf.Empty
}
var file_google_cloud_dialogflow_v2_generator_proto_depIdxs = []int32{
	20, // 0: google.cloud.dialogflow.v2.CreateGeneratorRequest.generator:type_name -> google.cloud.dialogflow.v2.Generator
	20, // 1: google.cloud.dialogflow.v2.ListGeneratorsResponse.generators:type_name -> google.cloud.dialogflow.v2.Generator
	20, // 2: google.cloud.dialogflow.v2.UpdateGeneratorRequest.generator:type_name -> google.cloud.dialogflow.v2.Generator
	36, // 3: google.cloud.dialogflow.v2.UpdateGeneratorRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 4: google.cloud.dialogflow.v2.MessageEntry.role:type_name -> google.cloud.dialogflow.v2.MessageEntry.Role
	37, // 5: google.cloud.dialogflow.v2.MessageEntry.create_time:type_name -> google.protobuf.Timestamp
	11, // 6: google.cloud.dialogflow.v2.ConversationContext.message_entries:type_name -> google.cloud.dialogflow.v2.MessageEntry
	17, // 7: google.cloud.dialogflow.v2.SummarizationSectionList.summarization_sections:type_name -> google.cloud.dialogflow.v2.SummarizationSection
	12, // 8: google.cloud.dialogflow.v2.FewShotExample.conversation_context:type_name -> google.cloud.dialogflow.v2.ConversationContext
	27, // 9: google.cloud.dialogflow.v2.FewShotExample.extra_info:type_name -> google.cloud.dialogflow.v2.FewShotExample.ExtraInfoEntry
	13, // 10: google.cloud.dialogflow.v2.FewShotExample.summarization_section_list:type_name -> google.cloud.dialogflow.v2.SummarizationSectionList
	24, // 11: google.cloud.dialogflow.v2.FewShotExample.output:type_name -> google.cloud.dialogflow.v2.GeneratorSuggestion
	38, // 12: google.cloud.dialogflow.v2.AgentCoachingContext.instructions:type_name -> google.cloud.dialogflow.v2.AgentCoachingInstruction
	2,  // 13: google.cloud.dialogflow.v2.SummarizationSection.type:type_name -> google.cloud.dialogflow.v2.SummarizationSection.Type
	17, // 14: google.cloud.dialogflow.v2.SummarizationContext.summarization_sections:type_name -> google.cloud.dialogflow.v2.SummarizationSection
	14, // 15: google.cloud.dialogflow.v2.SummarizationContext.few_shot_examples:type_name -> google.cloud.dialogflow.v2.FewShotExample
	19, // 16: google.cloud.dialogflow.v2.Generator.free_form_context:type_name -> google.cloud.dialogflow.v2.FreeFormContext
	16, // 17: google.cloud.dialogflow.v2.Generator.agent_coaching_context:type_name -> google.cloud.dialogflow.v2.AgentCoachingContext
	18, // 18: google.cloud.dialogflow.v2.Generator.summarization_context:type_name -> google.cloud.dialogflow.v2.SummarizationContext
	15, // 19: google.cloud.dialogflow.v2.Generator.inference_parameter:type_name -> google.cloud.dialogflow.v2.InferenceParameter
	0,  // 20: google.cloud.dialogflow.v2.Generator.trigger_event:type_name -> google.cloud.dialogflow.v2.TriggerEvent
	37, // 21: google.cloud.dialogflow.v2.Generator.create_time:type_name -> google.protobuf.Timestamp
	37, // 22: google.cloud.dialogflow.v2.Generator.update_time:type_name -> google.protobuf.Timestamp
	25, // 23: google.cloud.dialogflow.v2.Generator.suggestion_deduping_config:type_name -> google.cloud.dialogflow.v2.SuggestionDedupingConfig
	28, // 24: google.cloud.dialogflow.v2.SummarySuggestion.summary_sections:type_name -> google.cloud.dialogflow.v2.SummarySuggestion.SummarySection
	38, // 25: google.cloud.dialogflow.v2.AgentCoachingSuggestion.applicable_instructions:type_name -> google.cloud.dialogflow.v2.AgentCoachingInstruction
	31, // 26: google.cloud.dialogflow.v2.AgentCoachingSuggestion.agent_action_suggestions:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.AgentActionSuggestion
	32, // 27: google.cloud.dialogflow.v2.AgentCoachingSuggestion.sample_responses:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.SampleResponse
	21, // 28: google.cloud.dialogflow.v2.GeneratorSuggestion.free_form_suggestion:type_name -> google.cloud.dialogflow.v2.FreeFormSuggestion
	22, // 29: google.cloud.dialogflow.v2.GeneratorSuggestion.summary_suggestion:type_name -> google.cloud.dialogflow.v2.SummarySuggestion
	23, // 30: google.cloud.dialogflow.v2.GeneratorSuggestion.agent_coaching_suggestion:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion
	34, // 31: google.cloud.dialogflow.v2.GeneratorSuggestion.tool_call_info:type_name -> google.cloud.dialogflow.v2.GeneratorSuggestion.ToolCallInfo
	35, // 32: google.cloud.dialogflow.v2.RaiSettings.rai_category_configs:type_name -> google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig
	33, // 33: google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult.duplicate_suggestions:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult.DuplicateSuggestion
	29, // 34: google.cloud.dialogflow.v2.AgentCoachingSuggestion.AgentActionSuggestion.sources:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.Sources
	30, // 35: google.cloud.dialogflow.v2.AgentCoachingSuggestion.AgentActionSuggestion.duplicate_check_result:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult
	29, // 36: google.cloud.dialogflow.v2.AgentCoachingSuggestion.SampleResponse.sources:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.Sources
	30, // 37: google.cloud.dialogflow.v2.AgentCoachingSuggestion.SampleResponse.duplicate_check_result:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult
	29, // 38: google.cloud.dialogflow.v2.AgentCoachingSuggestion.DuplicateCheckResult.DuplicateSuggestion.sources:type_name -> google.cloud.dialogflow.v2.AgentCoachingSuggestion.Sources
	39, // 39: google.cloud.dialogflow.v2.GeneratorSuggestion.ToolCallInfo.tool_call:type_name -> google.cloud.dialogflow.v2.ToolCall
	40, // 40: google.cloud.dialogflow.v2.GeneratorSuggestion.ToolCallInfo.tool_call_result:type_name -> google.cloud.dialogflow.v2.ToolCallResult
	3,  // 41: google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.category:type_name -> google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.RaiCategory
	4,  // 42: google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.sensitivity_level:type_name -> google.cloud.dialogflow.v2.RaiSettings.RaiCategoryConfig.SensitivityLevel
	5,  // 43: google.cloud.dialogflow.v2.Generators.CreateGenerator:input_type -> google.cloud.dialogflow.v2.CreateGeneratorRequest
	6,  // 44: google.cloud.dialogflow.v2.Generators.GetGenerator:input_type -> google.cloud.dialogflow.v2.GetGeneratorRequest
	7,  // 45: google.cloud.dialogflow.v2.Generators.ListGenerators:input_type -> google.cloud.dialogflow.v2.ListGeneratorsRequest
	9,  // 46: google.cloud.dialogflow.v2.Generators.DeleteGenerator:input_type -> google.cloud.dialogflow.v2.DeleteGeneratorRequest
	10, // 47: google.cloud.dialogflow.v2.Generators.UpdateGenerator:input_type -> google.cloud.dialogflow.v2.UpdateGeneratorRequest
	20, // 48: google.cloud.dialogflow.v2.Generators.CreateGenerator:output_type -> google.cloud.dialogflow.v2.Generator
	20, // 49: google.cloud.dialogflow.v2.Generators.GetGenerator:output_type -> google.cloud.dialogflow.v2.Generator
	8,  // 50: google.cloud.dialogflow.v2.Generators.ListGenerators:output_type -> google.cloud.dialogflow.v2.ListGeneratorsResponse
	41, // 51: google.cloud.dialogflow.v2.Generators.DeleteGenerator:output_type -> google.protobuf.Empty
	20, // 52: google.cloud.dialogflow.v2.Generators.UpdateGenerator:output_type -> google.cloud.dialogflow.v2.Generator
	48, // [48:53] is the sub-list for method output_type
	43, // [43:48] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2_generator_proto_init() }
func file_google_cloud_dialogflow_v2_generator_proto_init() {
	if File_google_cloud_dialogflow_v2_generator_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2_agent_coaching_instruction_proto_init()
	file_google_cloud_dialogflow_v2_tool_call_proto_init()
	file_google_cloud_dialogflow_v2_generator_proto_msgTypes[9].OneofWrappers = []any{
		(*FewShotExample_SummarizationSectionList)(nil),
	}
	file_google_cloud_dialogflow_v2_generator_proto_msgTypes[10].OneofWrappers = []any{}
	file_google_cloud_dialogflow_v2_generator_proto_msgTypes[15].OneofWrappers = []any{
		(*Generator_FreeFormContext)(nil),
		(*Generator_AgentCoachingContext)(nil),
		(*Generator_SummarizationContext)(nil),
		(*Generator_PublishedModel)(nil),
	}
	file_google_cloud_dialogflow_v2_generator_proto_msgTypes[19].OneofWrappers = []any{
		(*GeneratorSuggestion_FreeFormSuggestion)(nil),
		(*GeneratorSuggestion_SummarySuggestion)(nil),
		(*GeneratorSuggestion_AgentCoachingSuggestion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2_generator_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2_generator_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2_generator_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2_generator_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2_generator_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2_generator_proto = out.File
	file_google_cloud_dialogflow_v2_generator_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2_generator_proto_goTypes = nil
	file_google_cloud_dialogflow_v2_generator_proto_depIdxs = nil
}
