package util

type Language struct {
	Code    string
	English string
	Local   string
}

var Languages = []Language{
	{Code: "", English: "None", Local: "None"},
	{Code: "aa", English: "Afar", Local: "Afaraf"},
	{Code: "ab", English: "Abkhaz", Local: "аҧсуа бызшәа"},
	{Code: "ae", English: "Avestan", Local: "avesta"},
	{Code: "af", English: "Afrikaans", Local: "Afrikaans"},
	{Code: "ak", English: "Akan", Local: "Akan"},
	{Code: "am", English: "Amharic", Local: "አማርኛ"},
	{Code: "an", English: "Aragonese", Local: "aragonés"},
	{Code: "ar", English: "Arabic", Local: "اللغة العربية"},
	{Code: "as", English: "Assamese", Local: "অসমীয়া"},
	{Code: "av", English: "Avaric", Local: "авар мацӀ"},
	{Code: "ay", English: "Aymara", Local: "aymar aru"},
	{Code: "az", English: "Azerbaijani", Local: "azərbaycan dili"},
	{Code: "ba", English: "Bashkir", Local: "башҡорт теле"},
	{Code: "be", English: "Belarusian", Local: "беларуская мова"},
	{Code: "bg", English: "Bulgarian", Local: "български език"},
	{Code: "bh", English: "Bihari", Local: "भोजपुरी"},
	{Code: "bi", English: "Bislama", Local: "Bislama"},
	{Code: "bm", English: "Bambara", Local: "bamanankan"},
	{Code: "bn", English: "Bengali", Local: "বাংলা"},
	{Code: "bo", English: "Tibetan", Local: "བོད་ཡིག"},
	{Code: "br", English: "Breton", Local: "brezhoneg"},
	{Code: "bs", English: "Bosnian", Local: "bosanski jezik"},
	{Code: "ca", English: "Catalan", Local: "Català"},
	{Code: "ce", English: "Chechen", Local: "нохчийн мотт"},
	{Code: "ch", English: "Chamorro", Local: "Chamoru"},
	{Code: "co", English: "Corsican", Local: "corsu"},
	{Code: "cr", English: "Cree", Local: "ᓀᐦᐃᔭᐍᐏᐣ"},
	{Code: "cs", English: "Czech", Local: "čeština"},
	{Code: "cu", English: "Old Church Slavonic", Local: "ѩзыкъ словѣньскъ"},
	{Code: "cv", English: "Chuvash", Local: "чӑваш чӗлхи"},
	{Code: "cy", English: "Welsh", Local: "Cymraeg"},
	{Code: "da", English: "Danish", Local: "dansk"},
	{Code: "de", English: "German", Local: "Deutsch"},
	{Code: "dv", English: "Divehi", Local: "Dhivehi"},
	{Code: "dz", English: "Dzongkha", Local: "རྫོང་ཁ"},
	{Code: "ee", English: "Ewe", Local: "Eʋegbe"},
	{Code: "el", English: "Greek", Local: "Ελληνικά"},
	{Code: "en", English: "English", Local: "English"},
	{Code: "eo", English: "Esperanto", Local: "Esperanto"},
	{Code: "es", English: "Spanish", Local: "Español"},
	{Code: "et", English: "Estonian", Local: "eesti"},
	{Code: "eu", English: "Basque", Local: "euskara"},
	{Code: "fa", English: "Persian", Local: "فارسی"},
	{Code: "ff", English: "Fula", Local: "Fulfulde"},
	{Code: "fi", English: "Finnish", Local: "suomi"},
	{Code: "fj", English: "Fijian", Local: "Vakaviti"},
	{Code: "fo", English: "Faroese", Local: "føroyskt"},
	{Code: "fr", English: "French", Local: "Français"},
	{Code: "fy", English: "Western Frisian", Local: "Frysk"},
	{Code: "ga", English: "Irish", Local: "Gaeilge"},
	{Code: "gd", English: "Scottish Gaelic", Local: "Gàidhlig"},
	{Code: "gl", English: "Galician", Local: "galego"},
	{Code: "gu", English: "Gujarati", Local: "ગુજરાતી"},
	{Code: "gv", English: "Manx", Local: "Gaelg"},
	{Code: "ha", English: "Hausa", Local: "هَوُسَ"},
	{Code: "he", English: "Hebrew", Local: "עברית"},
	{Code: "hi", English: "Hindi", Local: "हिन्दी"},
	{Code: "ho", English: "Hiri Motu", Local: "Hiri Motu"},
	{Code: "hr", English: "Croatian", Local: "Hrvatski"},
	{Code: "ht", English: "Haitian", Local: "Kreyòl ayisyen"},
	{Code: "hu", English: "Hungarian", Local: "magyar"},
	{Code: "hy", English: "Armenian", Local: "Հայերեն"},
	{Code: "hz", English: "Herero", Local: "Otjiherero"},
	{Code: "ia", English: "Interlingua", Local: "Interlingua"},
	{Code: "id", English: "Indonesian", Local: "Bahasa Indonesia"},
	{Code: "ie", English: "Interlingue", Local: "Interlingue"},
	{Code: "ig", English: "Igbo", Local: "Asụsụ Igbo"},
	{Code: "ii", English: "Nuosu", Local: "ꆈꌠ꒿ Nuosuhxop"},
	{Code: "ik", English: "Inupiaq", Local: "Iñupiaq"},
	{Code: "io", English: "Ido", Local: "Ido"},
	{Code: "is", English: "Icelandic", Local: "Íslenska"},
	{Code: "it", English: "Italian", Local: "Italiano"},
	{Code: "iu", English: "Inuktitut", Local: "ᐃᓄᒃᑎᑐᑦ"},
	{Code: "ja", English: "Japanese", Local: "日本語"},
	{Code: "jv", English: "Javanese", Local: "basa Jawa"},
	{Code: "ka", English: "Georgian", Local: "ქართული"},
	{Code: "kg", English: "Kongo", Local: "Kikongo"},
	{Code: "ki", English: "Kikuyu", Local: "Gĩkũyũ"},
	{Code: "kj", English: "Kwanyama", Local: "Kuanyama"},
	{Code: "kk", English: "Kazakh", Local: "қазақ тілі"},
	{Code: "kl", English: "Kalaallisut", Local: "kalaallisut"},
	{Code: "km", English: "Khmer", Local: "ខេមរភាសា"},
	{Code: "kn", English: "Kannada", Local: "ಕನ್ನಡ"},
	{Code: "ko", English: "Korean", Local: "한국어"},
	{Code: "kr", English: "Kanuri", Local: "Kanuri"},
	{Code: "ks", English: "Kashmiri", Local: "कश्मीरी"},
	{Code: "ku", English: "Kurmanji (Kurdish)", Local: "Kurmancî"},
	{Code: "kv", English: "Komi", Local: "коми кыв"},
	{Code: "kw", English: "Cornish", Local: "Kernewek"},
	{Code: "ky", English: "Kyrgyz", Local: "Кыргызча"},
	{Code: "la", English: "Latin", Local: "latine"},
	{Code: "lb", English: "Luxembourgish", Local: "Lëtzebuergesch"},
	{Code: "lg", English: "Ganda", Local: "Luganda"},
	{Code: "li", English: "Limburgish", Local: "Limburgs"},
	{Code: "ln", English: "Lingala", Local: "Lingála"},
	{Code: "lo", English: "Lao", Local: "ລາວ"},
	{Code: "lt", English: "Lithuanian", Local: "lietuvių kalba"},
	{Code: "lu", English: "Luba-Katanga", Local: "Tshiluba"},
	{Code: "lv", English: "Latvian", Local: "latviešu valoda"},
	{Code: "mg", English: "Malagasy", Local: "fiteny malagasy"},
	{Code: "mh", English: "Marshallese", Local: "Kajin M̧ajeļ"},
	{Code: "mi", English: "Māori", Local: "te reo Māori"},
	{Code: "mk", English: "Macedonian", Local: "македонски јазик"},
	{Code: "ml", English: "Malayalam", Local: "മലയാളം"},
	{Code: "mn", English: "Mongolian", Local: "Монгол хэл"},
	{Code: "mr", English: "Marathi", Local: "मराठी"},
	{Code: "ms", English: "Malay", Local: "Bahasa Melayu"},
	{Code: "mt", English: "Maltese", Local: "Malti"},
	{Code: "my", English: "Burmese", Local: "ဗမာစာ"},
	{Code: "na", English: "Nauru", Local: "Ekakairũ Naoero"},
	{Code: "nb", English: "Norwegian Bokmål", Local: "Norsk bokmål"},
	{Code: "nd", English: "Northern Ndebele", Local: "isiNdebele"},
	{Code: "ne", English: "Nepali", Local: "नेपाली"},
	{Code: "ng", English: "Ndonga", Local: "Owambo"},
	{Code: "nl", English: "Dutch", Local: "Nederlands"},
	{Code: "nn", English: "Norwegian Nynorsk", Local: "Norsk Nynorsk"},
	{Code: "no", English: "Norwegian", Local: "Norsk"},
	{Code: "nr", English: "Southern Ndebele", Local: "isiNdebele"},
	{Code: "nv", English: "Navajo", Local: "Diné bizaad"},
	{Code: "ny", English: "Chichewa", Local: "chiCheŵa"},
	{Code: "oc", English: "Occitan", Local: "occitan"},
	{Code: "oj", English: "Ojibwe", Local: "ᐊᓂᔑᓈᐯᒧᐎᓐ"},
	{Code: "om", English: "Oromo", Local: "Afaan Oromoo"},
	{Code: "or", English: "Oriya", Local: "ଓଡ଼ିଆ"},
	{Code: "os", English: "Ossetian", Local: "ирон æвзаг"},
	{Code: "pa", English: "Panjabi", Local: "ਪੰਜਾਬੀ"},
	{Code: "pi", English: "Pāli", Local: "पाऴि"},
	{Code: "pl", English: "Polish", Local: "Polski"},
	{Code: "ps", English: "Pashto", Local: "پښتو"},
	{Code: "pt", English: "Portuguese", Local: "Português"},
	{Code: "qu", English: "Quechua", Local: "Runa Simi"},
	{Code: "rm", English: "Romansh", Local: "rumantsch grischun"},
	{Code: "rn", English: "Kirundi", Local: "Ikirundi"},
	{Code: "ro", English: "Romanian", Local: "Română"},
	{Code: "ru", English: "Russian", Local: "Русский"},
	{Code: "rw", English: "Kinyarwanda", Local: "Ikinyarwanda"},
	{Code: "sa", English: "Sanskrit", Local: "संस्कृतम्"},
	{Code: "sc", English: "Sardinian", Local: "sardu"},
	{Code: "sd", English: "Sindhi", Local: "सिन्धी"},
	{Code: "se", English: "Northern Sami", Local: "Davvisámegiella"},
	{Code: "sg", English: "Sango", Local: "yângâ tî sängö"},
	{Code: "si", English: "Sinhala", Local: "සිංහල"},
	{Code: "sk", English: "Slovak", Local: "slovenčina"},
	{Code: "sl", English: "Slovenian", Local: "slovenščina"},
	{Code: "sn", English: "Shona", Local: "chiShona"},
	{Code: "so", English: "Somali", Local: "Soomaaliga"},
	{Code: "sq", English: "Albanian", Local: "Shqip"},
	{Code: "sr", English: "Serbian", Local: "српски језик"},
	{Code: "ss", English: "Swati", Local: "SiSwati"},
	{Code: "st", English: "Southern Sotho", Local: "Sesotho"},
	{Code: "su", English: "Sundanese", Local: "Basa Sunda"},
	{Code: "sv", English: "Swedish", Local: "Svenska"},
	{Code: "sw", English: "Swahili", Local: "Kiswahili"},
	{Code: "ta", English: "Tamil", Local: "தமிழ்"},
	{Code: "te", English: "Telugu", Local: "తెలుగు"},
	{Code: "tg", English: "Tajik", Local: "тоҷикӣ"},
	{Code: "th", English: "Thai", Local: "ไทย"},
	{Code: "ti", English: "Tigrinya", Local: "ትግርኛ"},
	{Code: "tk", English: "Turkmen", Local: "Türkmen"},
	{Code: "tl", English: "Tagalog", Local: "Wikang Tagalog"},
	{Code: "tn", English: "Tswana", Local: "Setswana"},
	{Code: "to", English: "Tonga", Local: "faka Tonga"},
	{Code: "tr", English: "Turkish", Local: "Türkçe"},
	{Code: "ts", English: "Tsonga", Local: "Xitsonga"},
	{Code: "tt", English: "Tatar", Local: "татар теле"},
	{Code: "tw", English: "Twi", Local: "Twi"},
	{Code: "ty", English: "Tahitian", Local: "Reo Tahiti"},
	{Code: "ug", English: "Uyghur", Local: "ئۇيغۇرچە‎"},
	{Code: "uk", English: "Ukrainian", Local: "Українська"},
	{Code: "ur", English: "Urdu", Local: "اردو"},
	{Code: "uz", English: "Uzbek", Local: "Ўзбек"},
	{Code: "ve", English: "Venda", Local: "Tshivenḓa"},
	{Code: "vi", English: "Vietnamese", Local: "Tiếng Việt"},
	{Code: "vo", English: "Volapük", Local: "Volapük"},
	{Code: "wa", English: "Walloon", Local: "walon"},
	{Code: "wo", English: "Wolof", Local: "Wollof"},
	{Code: "xh", English: "Xhosa", Local: "isiXhosa"},
	{Code: "yi", English: "Yiddish", Local: "ייִדיש"},
	{Code: "yo", English: "Yoruba", Local: "Yorùbá"},
	{Code: "za", English: "Zhuang", Local: "Saɯ cueŋƅ"},
	{Code: "zh", English: "Chinese", Local: "中文"},
	{Code: "zu", English: "Zulu", Local: "isiZulu"},
	{Code: "ast", English: "Asturian", Local: "Asturianu"},
	{Code: "ckb", English: "Sorani (Kurdish)", Local: "سۆرانی"},
	{Code: "jbo", English: "Lojban", Local: "la .lojban."},
	{Code: "kab", English: "Kabyle", Local: "Taqbaylit"},
	{Code: "kmr", English: "Kurmanji (Kurdish)", Local: "Kurmancî"},
	{Code: "ldn", English: "Láadan", Local: "Láadan"},
	{Code: "lfn", English: "Lingua Franca Nova", Local: "lingua franca nova"},
	{Code: "sco", English: "Scots", Local: "Scots"},
	{Code: "tok", English: "Toki Pona", Local: "toki pona"},
	{Code: "zba", English: "Balaibalan", Local: "باليبلن"},
	{Code: "zgh", English: "Standard Moroccan Tamazight", Local: "ⵜⴰⵎⴰⵣⵉⵖⵜ"},
}
