// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networksecurity/v1beta1/network_security.proto

package networksecuritypb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NetworkSecurity_ListAuthorizationPolicies_FullMethodName = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/ListAuthorizationPolicies"
	NetworkSecurity_GetAuthorizationPolicy_FullMethodName    = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/GetAuthorizationPolicy"
	NetworkSecurity_CreateAuthorizationPolicy_FullMethodName = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/CreateAuthorizationPolicy"
	NetworkSecurity_UpdateAuthorizationPolicy_FullMethodName = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/UpdateAuthorizationPolicy"
	NetworkSecurity_DeleteAuthorizationPolicy_FullMethodName = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/DeleteAuthorizationPolicy"
	NetworkSecurity_ListServerTlsPolicies_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/ListServerTlsPolicies"
	NetworkSecurity_GetServerTlsPolicy_FullMethodName        = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/GetServerTlsPolicy"
	NetworkSecurity_CreateServerTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/CreateServerTlsPolicy"
	NetworkSecurity_UpdateServerTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/UpdateServerTlsPolicy"
	NetworkSecurity_DeleteServerTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/DeleteServerTlsPolicy"
	NetworkSecurity_ListClientTlsPolicies_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/ListClientTlsPolicies"
	NetworkSecurity_GetClientTlsPolicy_FullMethodName        = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/GetClientTlsPolicy"
	NetworkSecurity_CreateClientTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/CreateClientTlsPolicy"
	NetworkSecurity_UpdateClientTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/UpdateClientTlsPolicy"
	NetworkSecurity_DeleteClientTlsPolicy_FullMethodName     = "/google.cloud.networksecurity.v1beta1.NetworkSecurity/DeleteClientTlsPolicy"
)

// NetworkSecurityClient is the client API for NetworkSecurity service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkSecurityClient interface {
	// Lists AuthorizationPolicies in a given project and location.
	ListAuthorizationPolicies(ctx context.Context, in *ListAuthorizationPoliciesRequest, opts ...grpc.CallOption) (*ListAuthorizationPoliciesResponse, error)
	// Gets details of a single AuthorizationPolicy.
	GetAuthorizationPolicy(ctx context.Context, in *GetAuthorizationPolicyRequest, opts ...grpc.CallOption) (*AuthorizationPolicy, error)
	// Creates a new AuthorizationPolicy in a given project and location.
	CreateAuthorizationPolicy(ctx context.Context, in *CreateAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AuthorizationPolicy.
	UpdateAuthorizationPolicy(ctx context.Context, in *UpdateAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AuthorizationPolicy.
	DeleteAuthorizationPolicy(ctx context.Context, in *DeleteAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ServerTlsPolicies in a given project and location.
	ListServerTlsPolicies(ctx context.Context, in *ListServerTlsPoliciesRequest, opts ...grpc.CallOption) (*ListServerTlsPoliciesResponse, error)
	// Gets details of a single ServerTlsPolicy.
	GetServerTlsPolicy(ctx context.Context, in *GetServerTlsPolicyRequest, opts ...grpc.CallOption) (*ServerTlsPolicy, error)
	// Creates a new ServerTlsPolicy in a given project and location.
	CreateServerTlsPolicy(ctx context.Context, in *CreateServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServerTlsPolicy.
	UpdateServerTlsPolicy(ctx context.Context, in *UpdateServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServerTlsPolicy.
	DeleteServerTlsPolicy(ctx context.Context, in *DeleteServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ClientTlsPolicies in a given project and location.
	ListClientTlsPolicies(ctx context.Context, in *ListClientTlsPoliciesRequest, opts ...grpc.CallOption) (*ListClientTlsPoliciesResponse, error)
	// Gets details of a single ClientTlsPolicy.
	GetClientTlsPolicy(ctx context.Context, in *GetClientTlsPolicyRequest, opts ...grpc.CallOption) (*ClientTlsPolicy, error)
	// Creates a new ClientTlsPolicy in a given project and location.
	CreateClientTlsPolicy(ctx context.Context, in *CreateClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientTlsPolicy.
	UpdateClientTlsPolicy(ctx context.Context, in *UpdateClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ClientTlsPolicy.
	DeleteClientTlsPolicy(ctx context.Context, in *DeleteClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type networkSecurityClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkSecurityClient(cc grpc.ClientConnInterface) NetworkSecurityClient {
	return &networkSecurityClient{cc}
}

func (c *networkSecurityClient) ListAuthorizationPolicies(ctx context.Context, in *ListAuthorizationPoliciesRequest, opts ...grpc.CallOption) (*ListAuthorizationPoliciesResponse, error) {
	out := new(ListAuthorizationPoliciesResponse)
	err := c.cc.Invoke(ctx, NetworkSecurity_ListAuthorizationPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) GetAuthorizationPolicy(ctx context.Context, in *GetAuthorizationPolicyRequest, opts ...grpc.CallOption) (*AuthorizationPolicy, error) {
	out := new(AuthorizationPolicy)
	err := c.cc.Invoke(ctx, NetworkSecurity_GetAuthorizationPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) CreateAuthorizationPolicy(ctx context.Context, in *CreateAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_CreateAuthorizationPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) UpdateAuthorizationPolicy(ctx context.Context, in *UpdateAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_UpdateAuthorizationPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) DeleteAuthorizationPolicy(ctx context.Context, in *DeleteAuthorizationPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_DeleteAuthorizationPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) ListServerTlsPolicies(ctx context.Context, in *ListServerTlsPoliciesRequest, opts ...grpc.CallOption) (*ListServerTlsPoliciesResponse, error) {
	out := new(ListServerTlsPoliciesResponse)
	err := c.cc.Invoke(ctx, NetworkSecurity_ListServerTlsPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) GetServerTlsPolicy(ctx context.Context, in *GetServerTlsPolicyRequest, opts ...grpc.CallOption) (*ServerTlsPolicy, error) {
	out := new(ServerTlsPolicy)
	err := c.cc.Invoke(ctx, NetworkSecurity_GetServerTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) CreateServerTlsPolicy(ctx context.Context, in *CreateServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_CreateServerTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) UpdateServerTlsPolicy(ctx context.Context, in *UpdateServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_UpdateServerTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) DeleteServerTlsPolicy(ctx context.Context, in *DeleteServerTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_DeleteServerTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) ListClientTlsPolicies(ctx context.Context, in *ListClientTlsPoliciesRequest, opts ...grpc.CallOption) (*ListClientTlsPoliciesResponse, error) {
	out := new(ListClientTlsPoliciesResponse)
	err := c.cc.Invoke(ctx, NetworkSecurity_ListClientTlsPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) GetClientTlsPolicy(ctx context.Context, in *GetClientTlsPolicyRequest, opts ...grpc.CallOption) (*ClientTlsPolicy, error) {
	out := new(ClientTlsPolicy)
	err := c.cc.Invoke(ctx, NetworkSecurity_GetClientTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) CreateClientTlsPolicy(ctx context.Context, in *CreateClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_CreateClientTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) UpdateClientTlsPolicy(ctx context.Context, in *UpdateClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_UpdateClientTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkSecurityClient) DeleteClientTlsPolicy(ctx context.Context, in *DeleteClientTlsPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NetworkSecurity_DeleteClientTlsPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkSecurityServer is the server API for NetworkSecurity service.
// All implementations should embed UnimplementedNetworkSecurityServer
// for forward compatibility
type NetworkSecurityServer interface {
	// Lists AuthorizationPolicies in a given project and location.
	ListAuthorizationPolicies(context.Context, *ListAuthorizationPoliciesRequest) (*ListAuthorizationPoliciesResponse, error)
	// Gets details of a single AuthorizationPolicy.
	GetAuthorizationPolicy(context.Context, *GetAuthorizationPolicyRequest) (*AuthorizationPolicy, error)
	// Creates a new AuthorizationPolicy in a given project and location.
	CreateAuthorizationPolicy(context.Context, *CreateAuthorizationPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AuthorizationPolicy.
	UpdateAuthorizationPolicy(context.Context, *UpdateAuthorizationPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single AuthorizationPolicy.
	DeleteAuthorizationPolicy(context.Context, *DeleteAuthorizationPolicyRequest) (*longrunningpb.Operation, error)
	// Lists ServerTlsPolicies in a given project and location.
	ListServerTlsPolicies(context.Context, *ListServerTlsPoliciesRequest) (*ListServerTlsPoliciesResponse, error)
	// Gets details of a single ServerTlsPolicy.
	GetServerTlsPolicy(context.Context, *GetServerTlsPolicyRequest) (*ServerTlsPolicy, error)
	// Creates a new ServerTlsPolicy in a given project and location.
	CreateServerTlsPolicy(context.Context, *CreateServerTlsPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServerTlsPolicy.
	UpdateServerTlsPolicy(context.Context, *UpdateServerTlsPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServerTlsPolicy.
	DeleteServerTlsPolicy(context.Context, *DeleteServerTlsPolicyRequest) (*longrunningpb.Operation, error)
	// Lists ClientTlsPolicies in a given project and location.
	ListClientTlsPolicies(context.Context, *ListClientTlsPoliciesRequest) (*ListClientTlsPoliciesResponse, error)
	// Gets details of a single ClientTlsPolicy.
	GetClientTlsPolicy(context.Context, *GetClientTlsPolicyRequest) (*ClientTlsPolicy, error)
	// Creates a new ClientTlsPolicy in a given project and location.
	CreateClientTlsPolicy(context.Context, *CreateClientTlsPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ClientTlsPolicy.
	UpdateClientTlsPolicy(context.Context, *UpdateClientTlsPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single ClientTlsPolicy.
	DeleteClientTlsPolicy(context.Context, *DeleteClientTlsPolicyRequest) (*longrunningpb.Operation, error)
}

// UnimplementedNetworkSecurityServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkSecurityServer struct {
}

func (UnimplementedNetworkSecurityServer) ListAuthorizationPolicies(context.Context, *ListAuthorizationPoliciesRequest) (*ListAuthorizationPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuthorizationPolicies not implemented")
}
func (UnimplementedNetworkSecurityServer) GetAuthorizationPolicy(context.Context, *GetAuthorizationPolicyRequest) (*AuthorizationPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuthorizationPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) CreateAuthorizationPolicy(context.Context, *CreateAuthorizationPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAuthorizationPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) UpdateAuthorizationPolicy(context.Context, *UpdateAuthorizationPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAuthorizationPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) DeleteAuthorizationPolicy(context.Context, *DeleteAuthorizationPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuthorizationPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) ListServerTlsPolicies(context.Context, *ListServerTlsPoliciesRequest) (*ListServerTlsPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServerTlsPolicies not implemented")
}
func (UnimplementedNetworkSecurityServer) GetServerTlsPolicy(context.Context, *GetServerTlsPolicyRequest) (*ServerTlsPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServerTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) CreateServerTlsPolicy(context.Context, *CreateServerTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServerTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) UpdateServerTlsPolicy(context.Context, *UpdateServerTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServerTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) DeleteServerTlsPolicy(context.Context, *DeleteServerTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServerTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) ListClientTlsPolicies(context.Context, *ListClientTlsPoliciesRequest) (*ListClientTlsPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClientTlsPolicies not implemented")
}
func (UnimplementedNetworkSecurityServer) GetClientTlsPolicy(context.Context, *GetClientTlsPolicyRequest) (*ClientTlsPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClientTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) CreateClientTlsPolicy(context.Context, *CreateClientTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateClientTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) UpdateClientTlsPolicy(context.Context, *UpdateClientTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateClientTlsPolicy not implemented")
}
func (UnimplementedNetworkSecurityServer) DeleteClientTlsPolicy(context.Context, *DeleteClientTlsPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteClientTlsPolicy not implemented")
}

// UnsafeNetworkSecurityServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkSecurityServer will
// result in compilation errors.
type UnsafeNetworkSecurityServer interface {
	mustEmbedUnimplementedNetworkSecurityServer()
}

func RegisterNetworkSecurityServer(s grpc.ServiceRegistrar, srv NetworkSecurityServer) {
	s.RegisterService(&NetworkSecurity_ServiceDesc, srv)
}

func _NetworkSecurity_ListAuthorizationPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuthorizationPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).ListAuthorizationPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_ListAuthorizationPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).ListAuthorizationPolicies(ctx, req.(*ListAuthorizationPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_GetAuthorizationPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAuthorizationPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).GetAuthorizationPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_GetAuthorizationPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).GetAuthorizationPolicy(ctx, req.(*GetAuthorizationPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_CreateAuthorizationPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAuthorizationPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).CreateAuthorizationPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_CreateAuthorizationPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).CreateAuthorizationPolicy(ctx, req.(*CreateAuthorizationPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_UpdateAuthorizationPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAuthorizationPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).UpdateAuthorizationPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_UpdateAuthorizationPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).UpdateAuthorizationPolicy(ctx, req.(*UpdateAuthorizationPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_DeleteAuthorizationPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuthorizationPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).DeleteAuthorizationPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_DeleteAuthorizationPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).DeleteAuthorizationPolicy(ctx, req.(*DeleteAuthorizationPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_ListServerTlsPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServerTlsPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).ListServerTlsPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_ListServerTlsPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).ListServerTlsPolicies(ctx, req.(*ListServerTlsPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_GetServerTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).GetServerTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_GetServerTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).GetServerTlsPolicy(ctx, req.(*GetServerTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_CreateServerTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServerTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).CreateServerTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_CreateServerTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).CreateServerTlsPolicy(ctx, req.(*CreateServerTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_UpdateServerTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServerTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).UpdateServerTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_UpdateServerTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).UpdateServerTlsPolicy(ctx, req.(*UpdateServerTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_DeleteServerTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServerTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).DeleteServerTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_DeleteServerTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).DeleteServerTlsPolicy(ctx, req.(*DeleteServerTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_ListClientTlsPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClientTlsPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).ListClientTlsPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_ListClientTlsPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).ListClientTlsPolicies(ctx, req.(*ListClientTlsPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_GetClientTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClientTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).GetClientTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_GetClientTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).GetClientTlsPolicy(ctx, req.(*GetClientTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_CreateClientTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).CreateClientTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_CreateClientTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).CreateClientTlsPolicy(ctx, req.(*CreateClientTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_UpdateClientTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClientTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).UpdateClientTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_UpdateClientTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).UpdateClientTlsPolicy(ctx, req.(*UpdateClientTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkSecurity_DeleteClientTlsPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClientTlsPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkSecurityServer).DeleteClientTlsPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkSecurity_DeleteClientTlsPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkSecurityServer).DeleteClientTlsPolicy(ctx, req.(*DeleteClientTlsPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkSecurity_ServiceDesc is the grpc.ServiceDesc for NetworkSecurity service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkSecurity_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networksecurity.v1beta1.NetworkSecurity",
	HandlerType: (*NetworkSecurityServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAuthorizationPolicies",
			Handler:    _NetworkSecurity_ListAuthorizationPolicies_Handler,
		},
		{
			MethodName: "GetAuthorizationPolicy",
			Handler:    _NetworkSecurity_GetAuthorizationPolicy_Handler,
		},
		{
			MethodName: "CreateAuthorizationPolicy",
			Handler:    _NetworkSecurity_CreateAuthorizationPolicy_Handler,
		},
		{
			MethodName: "UpdateAuthorizationPolicy",
			Handler:    _NetworkSecurity_UpdateAuthorizationPolicy_Handler,
		},
		{
			MethodName: "DeleteAuthorizationPolicy",
			Handler:    _NetworkSecurity_DeleteAuthorizationPolicy_Handler,
		},
		{
			MethodName: "ListServerTlsPolicies",
			Handler:    _NetworkSecurity_ListServerTlsPolicies_Handler,
		},
		{
			MethodName: "GetServerTlsPolicy",
			Handler:    _NetworkSecurity_GetServerTlsPolicy_Handler,
		},
		{
			MethodName: "CreateServerTlsPolicy",
			Handler:    _NetworkSecurity_CreateServerTlsPolicy_Handler,
		},
		{
			MethodName: "UpdateServerTlsPolicy",
			Handler:    _NetworkSecurity_UpdateServerTlsPolicy_Handler,
		},
		{
			MethodName: "DeleteServerTlsPolicy",
			Handler:    _NetworkSecurity_DeleteServerTlsPolicy_Handler,
		},
		{
			MethodName: "ListClientTlsPolicies",
			Handler:    _NetworkSecurity_ListClientTlsPolicies_Handler,
		},
		{
			MethodName: "GetClientTlsPolicy",
			Handler:    _NetworkSecurity_GetClientTlsPolicy_Handler,
		},
		{
			MethodName: "CreateClientTlsPolicy",
			Handler:    _NetworkSecurity_CreateClientTlsPolicy_Handler,
		},
		{
			MethodName: "UpdateClientTlsPolicy",
			Handler:    _NetworkSecurity_UpdateClientTlsPolicy_Handler,
		},
		{
			MethodName: "DeleteClientTlsPolicy",
			Handler:    _NetworkSecurity_DeleteClientTlsPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networksecurity/v1beta1/network_security.proto",
}
