// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Database Management API
//
// Use the Database Management API to monitor and manage resources such as
// Oracle Databases, MySQL Databases, and External Database Systems.
// For more information, see Database Management (https://docs.cloud.oracle.com/iaas/database-management/home.htm).
//

package databasemanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// DisableExternalPluggableDatabaseManagementFeatureDetails The details required to disable a Database Management feature for an external pluggable database.
type DisableExternalPluggableDatabaseManagementFeatureDetails struct {

	// The name of the Database Management feature.
	Feature DbManagementFeatureEnum `mandatory:"true" json:"feature"`
}

func (m DisableExternalPluggableDatabaseManagementFeatureDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m DisableExternalPluggableDatabaseManagementFeatureDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingDbManagementFeatureEnum(string(m.Feature)); !ok && m.Feature != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Feature: %s. Supported values are: %s.", m.Feature, strings.Join(GetDbManagementFeatureEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
