// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Application Dependency Management API
//
// Use the Application Dependency Management API to create knowledge bases and vulnerability audits.  For more information, see ADM (https://docs.cloud.oracle.com/Content/application-dependency-management/home.htm).
//

package adm

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ApplicationDependencyVulnerabilitySummary An application dependency Vulnerability represents a single dependency in the application.
// An application dependency Vulnerability can be associated with eventual Vulnerabilities.
// Each application dependency is uniquely defined by a nodeId and lists eventual dependencies on which it depends.
type ApplicationDependencyVulnerabilitySummary struct {

	// Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0.
	// "N/A" for non-maven artifacts.
	Gav *string `mandatory:"true" json:"gav"`

	// Unique identifier of an application dependency, for example nodeId1.
	NodeId *string `mandatory:"true" json:"nodeId"`

	// List of application dependencies on which this application dependency depends, each identified by its nodeId.
	ApplicationDependencyNodeIds []string `mandatory:"true" json:"applicationDependencyNodeIds"`

	// List of vulnerabilities for the application dependency.
	Vulnerabilities []Vulnerability `mandatory:"true" json:"vulnerabilities"`

	// Indicates if the artifact is found in the knowledge base.
	IsFoundInKnowledgeBase *bool `mandatory:"true" json:"isFoundInKnowledgeBase"`

	// Package URL defined in https://github.com/package-url/purl-spec, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0
	Purl *string `mandatory:"false" json:"purl"`
}

func (m ApplicationDependencyVulnerabilitySummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ApplicationDependencyVulnerabilitySummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
