// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListVulnerabilityImpactedContainersRequest wrapper for the ListVulnerabilityImpactedContainers operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilityImpactedContainers.go.html to see an example of how to use ListVulnerabilityImpactedContainersRequest.
type ListVulnerabilityImpactedContainersRequest struct {

	// unique vulnerability identifier
	VulnerabilityId *string `mandatory:"true" contributesTo:"path" name:"vulnerabilityId"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListVulnerabilityImpactedContainersSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// The field to sort by. Only one sort order may be provided. Default order is Ascending. If no value is specified image name is default.
	SortBy ListVulnerabilityImpactedContainersSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListVulnerabilityImpactedContainersRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListVulnerabilityImpactedContainersRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListVulnerabilityImpactedContainersRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListVulnerabilityImpactedContainersRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListVulnerabilityImpactedContainersRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListVulnerabilityImpactedContainersSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListVulnerabilityImpactedContainersSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListVulnerabilityImpactedContainersSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListVulnerabilityImpactedContainersSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListVulnerabilityImpactedContainersResponse wrapper for the ListVulnerabilityImpactedContainers operation
type ListVulnerabilityImpactedContainersResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of VulnerabilityImpactedContainerSummaryCollection instances
	VulnerabilityImpactedContainerSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListVulnerabilityImpactedContainersResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListVulnerabilityImpactedContainersResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListVulnerabilityImpactedContainersSortOrderEnum Enum with underlying type: string
type ListVulnerabilityImpactedContainersSortOrderEnum string

// Set of constants representing the allowable values for ListVulnerabilityImpactedContainersSortOrderEnum
const (
	ListVulnerabilityImpactedContainersSortOrderAsc  ListVulnerabilityImpactedContainersSortOrderEnum = "ASC"
	ListVulnerabilityImpactedContainersSortOrderDesc ListVulnerabilityImpactedContainersSortOrderEnum = "DESC"
)

var mappingListVulnerabilityImpactedContainersSortOrderEnum = map[string]ListVulnerabilityImpactedContainersSortOrderEnum{
	"ASC":  ListVulnerabilityImpactedContainersSortOrderAsc,
	"DESC": ListVulnerabilityImpactedContainersSortOrderDesc,
}

var mappingListVulnerabilityImpactedContainersSortOrderEnumLowerCase = map[string]ListVulnerabilityImpactedContainersSortOrderEnum{
	"asc":  ListVulnerabilityImpactedContainersSortOrderAsc,
	"desc": ListVulnerabilityImpactedContainersSortOrderDesc,
}

// GetListVulnerabilityImpactedContainersSortOrderEnumValues Enumerates the set of values for ListVulnerabilityImpactedContainersSortOrderEnum
func GetListVulnerabilityImpactedContainersSortOrderEnumValues() []ListVulnerabilityImpactedContainersSortOrderEnum {
	values := make([]ListVulnerabilityImpactedContainersSortOrderEnum, 0)
	for _, v := range mappingListVulnerabilityImpactedContainersSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityImpactedContainersSortOrderEnumStringValues Enumerates the set of values in String for ListVulnerabilityImpactedContainersSortOrderEnum
func GetListVulnerabilityImpactedContainersSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListVulnerabilityImpactedContainersSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityImpactedContainersSortOrderEnum(val string) (ListVulnerabilityImpactedContainersSortOrderEnum, bool) {
	enum, ok := mappingListVulnerabilityImpactedContainersSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListVulnerabilityImpactedContainersSortByEnum Enum with underlying type: string
type ListVulnerabilityImpactedContainersSortByEnum string

// Set of constants representing the allowable values for ListVulnerabilityImpactedContainersSortByEnum
const (
	ListVulnerabilityImpactedContainersSortByImage      ListVulnerabilityImpactedContainersSortByEnum = "image"
	ListVulnerabilityImpactedContainersSortByRepository ListVulnerabilityImpactedContainersSortByEnum = "repository"
	ListVulnerabilityImpactedContainersSortByRegistry   ListVulnerabilityImpactedContainersSortByEnum = "registry"
)

var mappingListVulnerabilityImpactedContainersSortByEnum = map[string]ListVulnerabilityImpactedContainersSortByEnum{
	"image":      ListVulnerabilityImpactedContainersSortByImage,
	"repository": ListVulnerabilityImpactedContainersSortByRepository,
	"registry":   ListVulnerabilityImpactedContainersSortByRegistry,
}

var mappingListVulnerabilityImpactedContainersSortByEnumLowerCase = map[string]ListVulnerabilityImpactedContainersSortByEnum{
	"image":      ListVulnerabilityImpactedContainersSortByImage,
	"repository": ListVulnerabilityImpactedContainersSortByRepository,
	"registry":   ListVulnerabilityImpactedContainersSortByRegistry,
}

// GetListVulnerabilityImpactedContainersSortByEnumValues Enumerates the set of values for ListVulnerabilityImpactedContainersSortByEnum
func GetListVulnerabilityImpactedContainersSortByEnumValues() []ListVulnerabilityImpactedContainersSortByEnum {
	values := make([]ListVulnerabilityImpactedContainersSortByEnum, 0)
	for _, v := range mappingListVulnerabilityImpactedContainersSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListVulnerabilityImpactedContainersSortByEnumStringValues Enumerates the set of values in String for ListVulnerabilityImpactedContainersSortByEnum
func GetListVulnerabilityImpactedContainersSortByEnumStringValues() []string {
	return []string{
		"image",
		"repository",
		"registry",
	}
}

// GetMappingListVulnerabilityImpactedContainersSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListVulnerabilityImpactedContainersSortByEnum(val string) (ListVulnerabilityImpactedContainersSortByEnum, bool) {
	enum, ok := mappingListVulnerabilityImpactedContainersSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
