// Code generated by ent, DO NOT EDIT.

package ent

import (
	"fmt"
	"strings"
	"time"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/metric"
)

// Metric is the model entity for the Metric schema.
type Metric struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Type of the metrics source: LP=logprocessor, RC=remediation
	GeneratedType metric.GeneratedType `json:"generated_type,omitempty"`
	// Source of the metrics: machine id, bouncer name...
	// It must come from the auth middleware.
	GeneratedBy string `json:"generated_by,omitempty"`
	// When the metrics are received by LAPI
	ReceivedAt time.Time `json:"received_at,omitempty"`
	// When the metrics are sent to the console
	PushedAt *time.Time `json:"pushed_at,omitempty"`
	// The actual metrics (item0)
	Payload      string `json:"payload,omitempty"`
	selectValues sql.SelectValues
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Metric) scanValues(columns []string) ([]any, error) {
	values := make([]any, len(columns))
	for i := range columns {
		switch columns[i] {
		case metric.FieldID:
			values[i] = new(sql.NullInt64)
		case metric.FieldGeneratedType, metric.FieldGeneratedBy, metric.FieldPayload:
			values[i] = new(sql.NullString)
		case metric.FieldReceivedAt, metric.FieldPushedAt:
			values[i] = new(sql.NullTime)
		default:
			values[i] = new(sql.UnknownType)
		}
	}
	return values, nil
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Metric fields.
func (m *Metric) assignValues(columns []string, values []any) error {
	if m, n := len(values), len(columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	for i := range columns {
		switch columns[i] {
		case metric.FieldID:
			value, ok := values[i].(*sql.NullInt64)
			if !ok {
				return fmt.Errorf("unexpected type %T for field id", value)
			}
			m.ID = int(value.Int64)
		case metric.FieldGeneratedType:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field generated_type", values[i])
			} else if value.Valid {
				m.GeneratedType = metric.GeneratedType(value.String)
			}
		case metric.FieldGeneratedBy:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field generated_by", values[i])
			} else if value.Valid {
				m.GeneratedBy = value.String
			}
		case metric.FieldReceivedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field received_at", values[i])
			} else if value.Valid {
				m.ReceivedAt = value.Time
			}
		case metric.FieldPushedAt:
			if value, ok := values[i].(*sql.NullTime); !ok {
				return fmt.Errorf("unexpected type %T for field pushed_at", values[i])
			} else if value.Valid {
				m.PushedAt = new(time.Time)
				*m.PushedAt = value.Time
			}
		case metric.FieldPayload:
			if value, ok := values[i].(*sql.NullString); !ok {
				return fmt.Errorf("unexpected type %T for field payload", values[i])
			} else if value.Valid {
				m.Payload = value.String
			}
		default:
			m.selectValues.Set(columns[i], values[i])
		}
	}
	return nil
}

// Value returns the ent.Value that was dynamically selected and assigned to the Metric.
// This includes values selected through modifiers, order, etc.
func (m *Metric) Value(name string) (ent.Value, error) {
	return m.selectValues.Get(name)
}

// Update returns a builder for updating this Metric.
// Note that you need to call Metric.Unwrap() before calling this method if this Metric
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Metric) Update() *MetricUpdateOne {
	return NewMetricClient(m.config).UpdateOne(m)
}

// Unwrap unwraps the Metric entity that was returned from a transaction after it was closed,
// so that all future queries will be executed through the driver which created the transaction.
func (m *Metric) Unwrap() *Metric {
	_tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("ent: Metric is not a transactional entity")
	}
	m.config.driver = _tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Metric) String() string {
	var builder strings.Builder
	builder.WriteString("Metric(")
	builder.WriteString(fmt.Sprintf("id=%v, ", m.ID))
	builder.WriteString("generated_type=")
	builder.WriteString(fmt.Sprintf("%v", m.GeneratedType))
	builder.WriteString(", ")
	builder.WriteString("generated_by=")
	builder.WriteString(m.GeneratedBy)
	builder.WriteString(", ")
	builder.WriteString("received_at=")
	builder.WriteString(m.ReceivedAt.Format(time.ANSIC))
	builder.WriteString(", ")
	if v := m.PushedAt; v != nil {
		builder.WriteString("pushed_at=")
		builder.WriteString(v.Format(time.ANSIC))
	}
	builder.WriteString(", ")
	builder.WriteString("payload=")
	builder.WriteString(m.Payload)
	builder.WriteByte(')')
	return builder.String()
}

// Metrics is a parsable slice of Metric.
type Metrics []*Metric
