// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/artifactregistry/v1/service.proto

package artifactregistrypb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ArtifactRegistry_ListDockerImages_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListDockerImages"
	ArtifactRegistry_GetDockerImage_FullMethodName        = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetDockerImage"
	ArtifactRegistry_ListMavenArtifacts_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListMavenArtifacts"
	ArtifactRegistry_GetMavenArtifact_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetMavenArtifact"
	ArtifactRegistry_ListNpmPackages_FullMethodName       = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListNpmPackages"
	ArtifactRegistry_GetNpmPackage_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetNpmPackage"
	ArtifactRegistry_ListPythonPackages_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListPythonPackages"
	ArtifactRegistry_GetPythonPackage_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetPythonPackage"
	ArtifactRegistry_ImportAptArtifacts_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ImportAptArtifacts"
	ArtifactRegistry_ImportYumArtifacts_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ImportYumArtifacts"
	ArtifactRegistry_ListRepositories_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListRepositories"
	ArtifactRegistry_GetRepository_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetRepository"
	ArtifactRegistry_CreateRepository_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/CreateRepository"
	ArtifactRegistry_UpdateRepository_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateRepository"
	ArtifactRegistry_DeleteRepository_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteRepository"
	ArtifactRegistry_ListPackages_FullMethodName          = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListPackages"
	ArtifactRegistry_GetPackage_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetPackage"
	ArtifactRegistry_DeletePackage_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeletePackage"
	ArtifactRegistry_ListVersions_FullMethodName          = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListVersions"
	ArtifactRegistry_GetVersion_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetVersion"
	ArtifactRegistry_DeleteVersion_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteVersion"
	ArtifactRegistry_BatchDeleteVersions_FullMethodName   = "/google.devtools.artifactregistry.v1.ArtifactRegistry/BatchDeleteVersions"
	ArtifactRegistry_UpdateVersion_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateVersion"
	ArtifactRegistry_ListFiles_FullMethodName             = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListFiles"
	ArtifactRegistry_GetFile_FullMethodName               = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetFile"
	ArtifactRegistry_DeleteFile_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteFile"
	ArtifactRegistry_UpdateFile_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateFile"
	ArtifactRegistry_ListTags_FullMethodName              = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListTags"
	ArtifactRegistry_GetTag_FullMethodName                = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetTag"
	ArtifactRegistry_CreateTag_FullMethodName             = "/google.devtools.artifactregistry.v1.ArtifactRegistry/CreateTag"
	ArtifactRegistry_UpdateTag_FullMethodName             = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateTag"
	ArtifactRegistry_DeleteTag_FullMethodName             = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteTag"
	ArtifactRegistry_CreateRule_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/CreateRule"
	ArtifactRegistry_ListRules_FullMethodName             = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListRules"
	ArtifactRegistry_GetRule_FullMethodName               = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetRule"
	ArtifactRegistry_UpdateRule_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateRule"
	ArtifactRegistry_DeleteRule_FullMethodName            = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteRule"
	ArtifactRegistry_SetIamPolicy_FullMethodName          = "/google.devtools.artifactregistry.v1.ArtifactRegistry/SetIamPolicy"
	ArtifactRegistry_GetIamPolicy_FullMethodName          = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetIamPolicy"
	ArtifactRegistry_TestIamPermissions_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/TestIamPermissions"
	ArtifactRegistry_GetProjectSettings_FullMethodName    = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetProjectSettings"
	ArtifactRegistry_UpdateProjectSettings_FullMethodName = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateProjectSettings"
	ArtifactRegistry_GetVPCSCConfig_FullMethodName        = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetVPCSCConfig"
	ArtifactRegistry_UpdateVPCSCConfig_FullMethodName     = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdateVPCSCConfig"
	ArtifactRegistry_UpdatePackage_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/UpdatePackage"
	ArtifactRegistry_ListAttachments_FullMethodName       = "/google.devtools.artifactregistry.v1.ArtifactRegistry/ListAttachments"
	ArtifactRegistry_GetAttachment_FullMethodName         = "/google.devtools.artifactregistry.v1.ArtifactRegistry/GetAttachment"
	ArtifactRegistry_CreateAttachment_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/CreateAttachment"
	ArtifactRegistry_DeleteAttachment_FullMethodName      = "/google.devtools.artifactregistry.v1.ArtifactRegistry/DeleteAttachment"
)

// ArtifactRegistryClient is the client API for ArtifactRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ArtifactRegistryClient interface {
	// Lists docker images.
	ListDockerImages(ctx context.Context, in *ListDockerImagesRequest, opts ...grpc.CallOption) (*ListDockerImagesResponse, error)
	// Gets a docker image.
	GetDockerImage(ctx context.Context, in *GetDockerImageRequest, opts ...grpc.CallOption) (*DockerImage, error)
	// Lists maven artifacts.
	ListMavenArtifacts(ctx context.Context, in *ListMavenArtifactsRequest, opts ...grpc.CallOption) (*ListMavenArtifactsResponse, error)
	// Gets a maven artifact.
	GetMavenArtifact(ctx context.Context, in *GetMavenArtifactRequest, opts ...grpc.CallOption) (*MavenArtifact, error)
	// Lists npm packages.
	ListNpmPackages(ctx context.Context, in *ListNpmPackagesRequest, opts ...grpc.CallOption) (*ListNpmPackagesResponse, error)
	// Gets a npm package.
	GetNpmPackage(ctx context.Context, in *GetNpmPackageRequest, opts ...grpc.CallOption) (*NpmPackage, error)
	// Lists python packages.
	ListPythonPackages(ctx context.Context, in *ListPythonPackagesRequest, opts ...grpc.CallOption) (*ListPythonPackagesResponse, error)
	// Gets a python package.
	GetPythonPackage(ctx context.Context, in *GetPythonPackageRequest, opts ...grpc.CallOption) (*PythonPackage, error)
	// Imports Apt artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportAptArtifacts(ctx context.Context, in *ImportAptArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports Yum (RPM) artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportYumArtifacts(ctx context.Context, in *ImportYumArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists repositories.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Gets a repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Creates a repository. The returned Operation will finish once the
	// repository has been created. Its response will be the created Repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a repository.
	UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Deletes a repository and all of its contents. The returned Operation will
	// finish once the repository has been deleted. It will not have any Operation
	// metadata and will return a google.protobuf.Empty response.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists packages.
	ListPackages(ctx context.Context, in *ListPackagesRequest, opts ...grpc.CallOption) (*ListPackagesResponse, error)
	// Gets a package.
	GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error)
	// Deletes a package and all of its versions and tags. The returned operation
	// will complete once the package has been deleted.
	DeletePackage(ctx context.Context, in *DeletePackageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists versions.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets a version
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deletes a version and all of its content. The returned operation will
	// complete once the version has been deleted.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes multiple versions across a repository. The returned operation will
	// complete once the versions have been deleted.
	BatchDeleteVersions(ctx context.Context, in *BatchDeleteVersionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a version.
	UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Lists files.
	ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (*ListFilesResponse, error)
	// Gets a file.
	GetFile(ctx context.Context, in *GetFileRequest, opts ...grpc.CallOption) (*File, error)
	// Deletes a file and all of its content. It is only allowed on generic
	// repositories. The returned operation will complete once the file has been
	// deleted.
	DeleteFile(ctx context.Context, in *DeleteFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a file.
	UpdateFile(ctx context.Context, in *UpdateFileRequest, opts ...grpc.CallOption) (*File, error)
	// Lists tags.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Gets a tag.
	GetTag(ctx context.Context, in *GetTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Creates a tag.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates a tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a rule.
	CreateRule(ctx context.Context, in *CreateRuleRequest, opts ...grpc.CallOption) (*Rule, error)
	// Lists rules.
	ListRules(ctx context.Context, in *ListRulesRequest, opts ...grpc.CallOption) (*ListRulesResponse, error)
	// Gets a rule.
	GetRule(ctx context.Context, in *GetRuleRequest, opts ...grpc.CallOption) (*Rule, error)
	// Updates a rule.
	UpdateRule(ctx context.Context, in *UpdateRuleRequest, opts ...grpc.CallOption) (*Rule, error)
	// Deletes a rule.
	DeleteRule(ctx context.Context, in *DeleteRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates the IAM policy for a given resource.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the IAM policy for a given resource.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests if the caller has a list of permissions on a resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Retrieves the Settings for the Project.
	GetProjectSettings(ctx context.Context, in *GetProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error)
	// Updates the Settings for the Project.
	UpdateProjectSettings(ctx context.Context, in *UpdateProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error)
	// Retrieves the VPCSC Config for the Project.
	GetVPCSCConfig(ctx context.Context, in *GetVPCSCConfigRequest, opts ...grpc.CallOption) (*VPCSCConfig, error)
	// Updates the VPCSC Config for the Project.
	UpdateVPCSCConfig(ctx context.Context, in *UpdateVPCSCConfigRequest, opts ...grpc.CallOption) (*VPCSCConfig, error)
	// Updates a package.
	UpdatePackage(ctx context.Context, in *UpdatePackageRequest, opts ...grpc.CallOption) (*Package, error)
	// Lists attachments.
	ListAttachments(ctx context.Context, in *ListAttachmentsRequest, opts ...grpc.CallOption) (*ListAttachmentsResponse, error)
	// Gets an attachment.
	GetAttachment(ctx context.Context, in *GetAttachmentRequest, opts ...grpc.CallOption) (*Attachment, error)
	// Creates an attachment. The returned Operation will finish once the
	// attachment has been created. Its response will be the created attachment.
	CreateAttachment(ctx context.Context, in *CreateAttachmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an attachment. The returned Operation will
	// finish once the attachments has been deleted. It will not have any
	// Operation metadata and will return a `google.protobuf.Empty` response.
	DeleteAttachment(ctx context.Context, in *DeleteAttachmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type artifactRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactRegistryClient(cc grpc.ClientConnInterface) ArtifactRegistryClient {
	return &artifactRegistryClient{cc}
}

func (c *artifactRegistryClient) ListDockerImages(ctx context.Context, in *ListDockerImagesRequest, opts ...grpc.CallOption) (*ListDockerImagesResponse, error) {
	out := new(ListDockerImagesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListDockerImages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetDockerImage(ctx context.Context, in *GetDockerImageRequest, opts ...grpc.CallOption) (*DockerImage, error) {
	out := new(DockerImage)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetDockerImage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListMavenArtifacts(ctx context.Context, in *ListMavenArtifactsRequest, opts ...grpc.CallOption) (*ListMavenArtifactsResponse, error) {
	out := new(ListMavenArtifactsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListMavenArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetMavenArtifact(ctx context.Context, in *GetMavenArtifactRequest, opts ...grpc.CallOption) (*MavenArtifact, error) {
	out := new(MavenArtifact)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetMavenArtifact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListNpmPackages(ctx context.Context, in *ListNpmPackagesRequest, opts ...grpc.CallOption) (*ListNpmPackagesResponse, error) {
	out := new(ListNpmPackagesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListNpmPackages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetNpmPackage(ctx context.Context, in *GetNpmPackageRequest, opts ...grpc.CallOption) (*NpmPackage, error) {
	out := new(NpmPackage)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetNpmPackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListPythonPackages(ctx context.Context, in *ListPythonPackagesRequest, opts ...grpc.CallOption) (*ListPythonPackagesResponse, error) {
	out := new(ListPythonPackagesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListPythonPackages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetPythonPackage(ctx context.Context, in *GetPythonPackageRequest, opts ...grpc.CallOption) (*PythonPackage, error) {
	out := new(PythonPackage)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetPythonPackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ImportAptArtifacts(ctx context.Context, in *ImportAptArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ImportAptArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ImportYumArtifacts(ctx context.Context, in *ImportYumArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ImportYumArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListPackages(ctx context.Context, in *ListPackagesRequest, opts ...grpc.CallOption) (*ListPackagesResponse, error) {
	out := new(ListPackagesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListPackages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error) {
	out := new(Package)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetPackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeletePackage(ctx context.Context, in *DeletePackageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeletePackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) BatchDeleteVersions(ctx context.Context, in *BatchDeleteVersionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_BatchDeleteVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (*ListFilesResponse, error) {
	out := new(ListFilesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetFile(ctx context.Context, in *GetFileRequest, opts ...grpc.CallOption) (*File, error) {
	out := new(File)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteFile(ctx context.Context, in *DeleteFileRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateFile(ctx context.Context, in *UpdateFileRequest, opts ...grpc.CallOption) (*File, error) {
	out := new(File)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetTag(ctx context.Context, in *GetTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateRule(ctx context.Context, in *CreateRuleRequest, opts ...grpc.CallOption) (*Rule, error) {
	out := new(Rule)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListRules(ctx context.Context, in *ListRulesRequest, opts ...grpc.CallOption) (*ListRulesResponse, error) {
	out := new(ListRulesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetRule(ctx context.Context, in *GetRuleRequest, opts ...grpc.CallOption) (*Rule, error) {
	out := new(Rule)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateRule(ctx context.Context, in *UpdateRuleRequest, opts ...grpc.CallOption) (*Rule, error) {
	out := new(Rule)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteRule(ctx context.Context, in *DeleteRuleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ArtifactRegistry_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetProjectSettings(ctx context.Context, in *GetProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error) {
	out := new(ProjectSettings)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetProjectSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateProjectSettings(ctx context.Context, in *UpdateProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error) {
	out := new(ProjectSettings)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateProjectSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetVPCSCConfig(ctx context.Context, in *GetVPCSCConfigRequest, opts ...grpc.CallOption) (*VPCSCConfig, error) {
	out := new(VPCSCConfig)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetVPCSCConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateVPCSCConfig(ctx context.Context, in *UpdateVPCSCConfigRequest, opts ...grpc.CallOption) (*VPCSCConfig, error) {
	out := new(VPCSCConfig)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateVPCSCConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdatePackage(ctx context.Context, in *UpdatePackageRequest, opts ...grpc.CallOption) (*Package, error) {
	out := new(Package)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdatePackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListAttachments(ctx context.Context, in *ListAttachmentsRequest, opts ...grpc.CallOption) (*ListAttachmentsResponse, error) {
	out := new(ListAttachmentsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListAttachments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetAttachment(ctx context.Context, in *GetAttachmentRequest, opts ...grpc.CallOption) (*Attachment, error) {
	out := new(Attachment)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetAttachment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateAttachment(ctx context.Context, in *CreateAttachmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateAttachment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteAttachment(ctx context.Context, in *DeleteAttachmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteAttachment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArtifactRegistryServer is the server API for ArtifactRegistry service.
// All implementations should embed UnimplementedArtifactRegistryServer
// for forward compatibility
type ArtifactRegistryServer interface {
	// Lists docker images.
	ListDockerImages(context.Context, *ListDockerImagesRequest) (*ListDockerImagesResponse, error)
	// Gets a docker image.
	GetDockerImage(context.Context, *GetDockerImageRequest) (*DockerImage, error)
	// Lists maven artifacts.
	ListMavenArtifacts(context.Context, *ListMavenArtifactsRequest) (*ListMavenArtifactsResponse, error)
	// Gets a maven artifact.
	GetMavenArtifact(context.Context, *GetMavenArtifactRequest) (*MavenArtifact, error)
	// Lists npm packages.
	ListNpmPackages(context.Context, *ListNpmPackagesRequest) (*ListNpmPackagesResponse, error)
	// Gets a npm package.
	GetNpmPackage(context.Context, *GetNpmPackageRequest) (*NpmPackage, error)
	// Lists python packages.
	ListPythonPackages(context.Context, *ListPythonPackagesRequest) (*ListPythonPackagesResponse, error)
	// Gets a python package.
	GetPythonPackage(context.Context, *GetPythonPackageRequest) (*PythonPackage, error)
	// Imports Apt artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportAptArtifacts(context.Context, *ImportAptArtifactsRequest) (*longrunningpb.Operation, error)
	// Imports Yum (RPM) artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportYumArtifacts(context.Context, *ImportYumArtifactsRequest) (*longrunningpb.Operation, error)
	// Lists repositories.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Gets a repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Creates a repository. The returned Operation will finish once the
	// repository has been created. Its response will be the created Repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error)
	// Updates a repository.
	UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error)
	// Deletes a repository and all of its contents. The returned Operation will
	// finish once the repository has been deleted. It will not have any Operation
	// metadata and will return a google.protobuf.Empty response.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error)
	// Lists packages.
	ListPackages(context.Context, *ListPackagesRequest) (*ListPackagesResponse, error)
	// Gets a package.
	GetPackage(context.Context, *GetPackageRequest) (*Package, error)
	// Deletes a package and all of its versions and tags. The returned operation
	// will complete once the package has been deleted.
	DeletePackage(context.Context, *DeletePackageRequest) (*longrunningpb.Operation, error)
	// Lists versions.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets a version
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deletes a version and all of its content. The returned operation will
	// complete once the version has been deleted.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error)
	// Deletes multiple versions across a repository. The returned operation will
	// complete once the versions have been deleted.
	BatchDeleteVersions(context.Context, *BatchDeleteVersionsRequest) (*longrunningpb.Operation, error)
	// Updates a version.
	UpdateVersion(context.Context, *UpdateVersionRequest) (*Version, error)
	// Lists files.
	ListFiles(context.Context, *ListFilesRequest) (*ListFilesResponse, error)
	// Gets a file.
	GetFile(context.Context, *GetFileRequest) (*File, error)
	// Deletes a file and all of its content. It is only allowed on generic
	// repositories. The returned operation will complete once the file has been
	// deleted.
	DeleteFile(context.Context, *DeleteFileRequest) (*longrunningpb.Operation, error)
	// Updates a file.
	UpdateFile(context.Context, *UpdateFileRequest) (*File, error)
	// Lists tags.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Gets a tag.
	GetTag(context.Context, *GetTagRequest) (*Tag, error)
	// Creates a tag.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates a tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Creates a rule.
	CreateRule(context.Context, *CreateRuleRequest) (*Rule, error)
	// Lists rules.
	ListRules(context.Context, *ListRulesRequest) (*ListRulesResponse, error)
	// Gets a rule.
	GetRule(context.Context, *GetRuleRequest) (*Rule, error)
	// Updates a rule.
	UpdateRule(context.Context, *UpdateRuleRequest) (*Rule, error)
	// Deletes a rule.
	DeleteRule(context.Context, *DeleteRuleRequest) (*emptypb.Empty, error)
	// Updates the IAM policy for a given resource.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the IAM policy for a given resource.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Tests if the caller has a list of permissions on a resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Retrieves the Settings for the Project.
	GetProjectSettings(context.Context, *GetProjectSettingsRequest) (*ProjectSettings, error)
	// Updates the Settings for the Project.
	UpdateProjectSettings(context.Context, *UpdateProjectSettingsRequest) (*ProjectSettings, error)
	// Retrieves the VPCSC Config for the Project.
	GetVPCSCConfig(context.Context, *GetVPCSCConfigRequest) (*VPCSCConfig, error)
	// Updates the VPCSC Config for the Project.
	UpdateVPCSCConfig(context.Context, *UpdateVPCSCConfigRequest) (*VPCSCConfig, error)
	// Updates a package.
	UpdatePackage(context.Context, *UpdatePackageRequest) (*Package, error)
	// Lists attachments.
	ListAttachments(context.Context, *ListAttachmentsRequest) (*ListAttachmentsResponse, error)
	// Gets an attachment.
	GetAttachment(context.Context, *GetAttachmentRequest) (*Attachment, error)
	// Creates an attachment. The returned Operation will finish once the
	// attachment has been created. Its response will be the created attachment.
	CreateAttachment(context.Context, *CreateAttachmentRequest) (*longrunningpb.Operation, error)
	// Deletes an attachment. The returned Operation will
	// finish once the attachments has been deleted. It will not have any
	// Operation metadata and will return a `google.protobuf.Empty` response.
	DeleteAttachment(context.Context, *DeleteAttachmentRequest) (*longrunningpb.Operation, error)
}

// UnimplementedArtifactRegistryServer should be embedded to have forward compatible implementations.
type UnimplementedArtifactRegistryServer struct {
}

func (UnimplementedArtifactRegistryServer) ListDockerImages(context.Context, *ListDockerImagesRequest) (*ListDockerImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDockerImages not implemented")
}
func (UnimplementedArtifactRegistryServer) GetDockerImage(context.Context, *GetDockerImageRequest) (*DockerImage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDockerImage not implemented")
}
func (UnimplementedArtifactRegistryServer) ListMavenArtifacts(context.Context, *ListMavenArtifactsRequest) (*ListMavenArtifactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMavenArtifacts not implemented")
}
func (UnimplementedArtifactRegistryServer) GetMavenArtifact(context.Context, *GetMavenArtifactRequest) (*MavenArtifact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMavenArtifact not implemented")
}
func (UnimplementedArtifactRegistryServer) ListNpmPackages(context.Context, *ListNpmPackagesRequest) (*ListNpmPackagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNpmPackages not implemented")
}
func (UnimplementedArtifactRegistryServer) GetNpmPackage(context.Context, *GetNpmPackageRequest) (*NpmPackage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNpmPackage not implemented")
}
func (UnimplementedArtifactRegistryServer) ListPythonPackages(context.Context, *ListPythonPackagesRequest) (*ListPythonPackagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPythonPackages not implemented")
}
func (UnimplementedArtifactRegistryServer) GetPythonPackage(context.Context, *GetPythonPackageRequest) (*PythonPackage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPythonPackage not implemented")
}
func (UnimplementedArtifactRegistryServer) ImportAptArtifacts(context.Context, *ImportAptArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAptArtifacts not implemented")
}
func (UnimplementedArtifactRegistryServer) ImportYumArtifacts(context.Context, *ImportYumArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportYumArtifacts not implemented")
}
func (UnimplementedArtifactRegistryServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (UnimplementedArtifactRegistryServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) ListPackages(context.Context, *ListPackagesRequest) (*ListPackagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPackages not implemented")
}
func (UnimplementedArtifactRegistryServer) GetPackage(context.Context, *GetPackageRequest) (*Package, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPackage not implemented")
}
func (UnimplementedArtifactRegistryServer) DeletePackage(context.Context, *DeletePackageRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePackage not implemented")
}
func (UnimplementedArtifactRegistryServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (UnimplementedArtifactRegistryServer) GetVersion(context.Context, *GetVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVersion not implemented")
}
func (UnimplementedArtifactRegistryServer) BatchDeleteVersions(context.Context, *BatchDeleteVersionsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteVersions not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateVersion(context.Context, *UpdateVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVersion not implemented")
}
func (UnimplementedArtifactRegistryServer) ListFiles(context.Context, *ListFilesRequest) (*ListFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFiles not implemented")
}
func (UnimplementedArtifactRegistryServer) GetFile(context.Context, *GetFileRequest) (*File, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFile not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteFile(context.Context, *DeleteFileRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFile not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateFile(context.Context, *UpdateFileRequest) (*File, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFile not implemented")
}
func (UnimplementedArtifactRegistryServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (UnimplementedArtifactRegistryServer) GetTag(context.Context, *GetTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTag not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateRule(context.Context, *CreateRuleRequest) (*Rule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRule not implemented")
}
func (UnimplementedArtifactRegistryServer) ListRules(context.Context, *ListRulesRequest) (*ListRulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRules not implemented")
}
func (UnimplementedArtifactRegistryServer) GetRule(context.Context, *GetRuleRequest) (*Rule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRule not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateRule(context.Context, *UpdateRuleRequest) (*Rule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRule not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteRule(context.Context, *DeleteRuleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRule not implemented")
}
func (UnimplementedArtifactRegistryServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedArtifactRegistryServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedArtifactRegistryServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedArtifactRegistryServer) GetProjectSettings(context.Context, *GetProjectSettingsRequest) (*ProjectSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectSettings not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateProjectSettings(context.Context, *UpdateProjectSettingsRequest) (*ProjectSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProjectSettings not implemented")
}
func (UnimplementedArtifactRegistryServer) GetVPCSCConfig(context.Context, *GetVPCSCConfigRequest) (*VPCSCConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVPCSCConfig not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateVPCSCConfig(context.Context, *UpdateVPCSCConfigRequest) (*VPCSCConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVPCSCConfig not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdatePackage(context.Context, *UpdatePackageRequest) (*Package, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePackage not implemented")
}
func (UnimplementedArtifactRegistryServer) ListAttachments(context.Context, *ListAttachmentsRequest) (*ListAttachmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAttachments not implemented")
}
func (UnimplementedArtifactRegistryServer) GetAttachment(context.Context, *GetAttachmentRequest) (*Attachment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAttachment not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateAttachment(context.Context, *CreateAttachmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAttachment not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteAttachment(context.Context, *DeleteAttachmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAttachment not implemented")
}

// UnsafeArtifactRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArtifactRegistryServer will
// result in compilation errors.
type UnsafeArtifactRegistryServer interface {
	mustEmbedUnimplementedArtifactRegistryServer()
}

func RegisterArtifactRegistryServer(s grpc.ServiceRegistrar, srv ArtifactRegistryServer) {
	s.RegisterService(&ArtifactRegistry_ServiceDesc, srv)
}

func _ArtifactRegistry_ListDockerImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDockerImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListDockerImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListDockerImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListDockerImages(ctx, req.(*ListDockerImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetDockerImage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDockerImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetDockerImage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetDockerImage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetDockerImage(ctx, req.(*GetDockerImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListMavenArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMavenArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListMavenArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListMavenArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListMavenArtifacts(ctx, req.(*ListMavenArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetMavenArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMavenArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetMavenArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetMavenArtifact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetMavenArtifact(ctx, req.(*GetMavenArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListNpmPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNpmPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListNpmPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListNpmPackages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListNpmPackages(ctx, req.(*ListNpmPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetNpmPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNpmPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetNpmPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetNpmPackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetNpmPackage(ctx, req.(*GetNpmPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListPythonPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPythonPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListPythonPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListPythonPackages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListPythonPackages(ctx, req.(*ListPythonPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetPythonPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPythonPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetPythonPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetPythonPackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetPythonPackage(ctx, req.(*GetPythonPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ImportAptArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAptArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ImportAptArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ImportAptArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ImportAptArtifacts(ctx, req.(*ImportAptArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ImportYumArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportYumArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ImportYumArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ImportYumArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ImportYumArtifacts(ctx, req.(*ImportYumArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateRepository(ctx, req.(*UpdateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListPackages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListPackages(ctx, req.(*ListPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetPackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetPackage(ctx, req.(*GetPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeletePackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeletePackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeletePackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeletePackage(ctx, req.(*DeletePackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_BatchDeleteVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).BatchDeleteVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_BatchDeleteVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).BatchDeleteVersions(ctx, req.(*BatchDeleteVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateVersion(ctx, req.(*UpdateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListFiles(ctx, req.(*ListFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetFile(ctx, req.(*GetFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteFile(ctx, req.(*DeleteFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateFile(ctx, req.(*UpdateFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetTag(ctx, req.(*GetTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateRule(ctx, req.(*CreateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListRules(ctx, req.(*ListRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetRule(ctx, req.(*GetRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateRule(ctx, req.(*UpdateRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteRule(ctx, req.(*DeleteRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetProjectSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetProjectSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetProjectSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetProjectSettings(ctx, req.(*GetProjectSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateProjectSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateProjectSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateProjectSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateProjectSettings(ctx, req.(*UpdateProjectSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetVPCSCConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVPCSCConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetVPCSCConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetVPCSCConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetVPCSCConfig(ctx, req.(*GetVPCSCConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateVPCSCConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVPCSCConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateVPCSCConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateVPCSCConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateVPCSCConfig(ctx, req.(*UpdateVPCSCConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdatePackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdatePackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdatePackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdatePackage(ctx, req.(*UpdatePackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListAttachments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListAttachments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListAttachments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListAttachments(ctx, req.(*ListAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetAttachment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetAttachment(ctx, req.(*GetAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateAttachment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateAttachment(ctx, req.(*CreateAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteAttachment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteAttachment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteAttachment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteAttachment(ctx, req.(*DeleteAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ArtifactRegistry_ServiceDesc is the grpc.ServiceDesc for ArtifactRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ArtifactRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.artifactregistry.v1.ArtifactRegistry",
	HandlerType: (*ArtifactRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDockerImages",
			Handler:    _ArtifactRegistry_ListDockerImages_Handler,
		},
		{
			MethodName: "GetDockerImage",
			Handler:    _ArtifactRegistry_GetDockerImage_Handler,
		},
		{
			MethodName: "ListMavenArtifacts",
			Handler:    _ArtifactRegistry_ListMavenArtifacts_Handler,
		},
		{
			MethodName: "GetMavenArtifact",
			Handler:    _ArtifactRegistry_GetMavenArtifact_Handler,
		},
		{
			MethodName: "ListNpmPackages",
			Handler:    _ArtifactRegistry_ListNpmPackages_Handler,
		},
		{
			MethodName: "GetNpmPackage",
			Handler:    _ArtifactRegistry_GetNpmPackage_Handler,
		},
		{
			MethodName: "ListPythonPackages",
			Handler:    _ArtifactRegistry_ListPythonPackages_Handler,
		},
		{
			MethodName: "GetPythonPackage",
			Handler:    _ArtifactRegistry_GetPythonPackage_Handler,
		},
		{
			MethodName: "ImportAptArtifacts",
			Handler:    _ArtifactRegistry_ImportAptArtifacts_Handler,
		},
		{
			MethodName: "ImportYumArtifacts",
			Handler:    _ArtifactRegistry_ImportYumArtifacts_Handler,
		},
		{
			MethodName: "ListRepositories",
			Handler:    _ArtifactRegistry_ListRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _ArtifactRegistry_GetRepository_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _ArtifactRegistry_CreateRepository_Handler,
		},
		{
			MethodName: "UpdateRepository",
			Handler:    _ArtifactRegistry_UpdateRepository_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _ArtifactRegistry_DeleteRepository_Handler,
		},
		{
			MethodName: "ListPackages",
			Handler:    _ArtifactRegistry_ListPackages_Handler,
		},
		{
			MethodName: "GetPackage",
			Handler:    _ArtifactRegistry_GetPackage_Handler,
		},
		{
			MethodName: "DeletePackage",
			Handler:    _ArtifactRegistry_DeletePackage_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ArtifactRegistry_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ArtifactRegistry_GetVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _ArtifactRegistry_DeleteVersion_Handler,
		},
		{
			MethodName: "BatchDeleteVersions",
			Handler:    _ArtifactRegistry_BatchDeleteVersions_Handler,
		},
		{
			MethodName: "UpdateVersion",
			Handler:    _ArtifactRegistry_UpdateVersion_Handler,
		},
		{
			MethodName: "ListFiles",
			Handler:    _ArtifactRegistry_ListFiles_Handler,
		},
		{
			MethodName: "GetFile",
			Handler:    _ArtifactRegistry_GetFile_Handler,
		},
		{
			MethodName: "DeleteFile",
			Handler:    _ArtifactRegistry_DeleteFile_Handler,
		},
		{
			MethodName: "UpdateFile",
			Handler:    _ArtifactRegistry_UpdateFile_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _ArtifactRegistry_ListTags_Handler,
		},
		{
			MethodName: "GetTag",
			Handler:    _ArtifactRegistry_GetTag_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _ArtifactRegistry_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _ArtifactRegistry_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _ArtifactRegistry_DeleteTag_Handler,
		},
		{
			MethodName: "CreateRule",
			Handler:    _ArtifactRegistry_CreateRule_Handler,
		},
		{
			MethodName: "ListRules",
			Handler:    _ArtifactRegistry_ListRules_Handler,
		},
		{
			MethodName: "GetRule",
			Handler:    _ArtifactRegistry_GetRule_Handler,
		},
		{
			MethodName: "UpdateRule",
			Handler:    _ArtifactRegistry_UpdateRule_Handler,
		},
		{
			MethodName: "DeleteRule",
			Handler:    _ArtifactRegistry_DeleteRule_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ArtifactRegistry_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ArtifactRegistry_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ArtifactRegistry_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetProjectSettings",
			Handler:    _ArtifactRegistry_GetProjectSettings_Handler,
		},
		{
			MethodName: "UpdateProjectSettings",
			Handler:    _ArtifactRegistry_UpdateProjectSettings_Handler,
		},
		{
			MethodName: "GetVPCSCConfig",
			Handler:    _ArtifactRegistry_GetVPCSCConfig_Handler,
		},
		{
			MethodName: "UpdateVPCSCConfig",
			Handler:    _ArtifactRegistry_UpdateVPCSCConfig_Handler,
		},
		{
			MethodName: "UpdatePackage",
			Handler:    _ArtifactRegistry_UpdatePackage_Handler,
		},
		{
			MethodName: "ListAttachments",
			Handler:    _ArtifactRegistry_ListAttachments_Handler,
		},
		{
			MethodName: "GetAttachment",
			Handler:    _ArtifactRegistry_GetAttachment_Handler,
		},
		{
			MethodName: "CreateAttachment",
			Handler:    _ArtifactRegistry_CreateAttachment_Handler,
		},
		{
			MethodName: "DeleteAttachment",
			Handler:    _ArtifactRegistry_DeleteAttachment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/artifactregistry/v1/service.proto",
}
