// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/datacatalog/v1/schema.proto

package datacatalogpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies inclusion of the column in an index
type ColumnSchema_IndexingType int32

const (
	// Unspecified.
	ColumnSchema_INDEXING_TYPE_UNSPECIFIED ColumnSchema_IndexingType = 0
	// Column not a part of an index.
	ColumnSchema_INDEXING_TYPE_NONE ColumnSchema_IndexingType = 1
	// Column Part of non unique index.
	ColumnSchema_INDEXING_TYPE_NON_UNIQUE ColumnSchema_IndexingType = 2
	// Column part of unique index.
	ColumnSchema_INDEXING_TYPE_UNIQUE ColumnSchema_IndexingType = 3
	// Column part of the primary key.
	ColumnSchema_INDEXING_TYPE_PRIMARY_KEY ColumnSchema_IndexingType = 4
)

// Enum value maps for ColumnSchema_IndexingType.
var (
	ColumnSchema_IndexingType_name = map[int32]string{
		0: "INDEXING_TYPE_UNSPECIFIED",
		1: "INDEXING_TYPE_NONE",
		2: "INDEXING_TYPE_NON_UNIQUE",
		3: "INDEXING_TYPE_UNIQUE",
		4: "INDEXING_TYPE_PRIMARY_KEY",
	}
	ColumnSchema_IndexingType_value = map[string]int32{
		"INDEXING_TYPE_UNSPECIFIED": 0,
		"INDEXING_TYPE_NONE":        1,
		"INDEXING_TYPE_NON_UNIQUE":  2,
		"INDEXING_TYPE_UNIQUE":      3,
		"INDEXING_TYPE_PRIMARY_KEY": 4,
	}
)

func (x ColumnSchema_IndexingType) Enum() *ColumnSchema_IndexingType {
	p := new(ColumnSchema_IndexingType)
	*p = x
	return p
}

func (x ColumnSchema_IndexingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ColumnSchema_IndexingType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_schema_proto_enumTypes[0].Descriptor()
}

func (ColumnSchema_IndexingType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_schema_proto_enumTypes[0]
}

func (x ColumnSchema_IndexingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ColumnSchema_IndexingType.Descriptor instead.
func (ColumnSchema_IndexingType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{1, 0}
}

// Column type in Looker.
type ColumnSchema_LookerColumnSpec_LookerColumnType int32

const (
	// Unspecified.
	ColumnSchema_LookerColumnSpec_LOOKER_COLUMN_TYPE_UNSPECIFIED ColumnSchema_LookerColumnSpec_LookerColumnType = 0
	// Dimension.
	ColumnSchema_LookerColumnSpec_DIMENSION ColumnSchema_LookerColumnSpec_LookerColumnType = 1
	// Dimension group - parent for Dimension.
	ColumnSchema_LookerColumnSpec_DIMENSION_GROUP ColumnSchema_LookerColumnSpec_LookerColumnType = 2
	// Filter.
	ColumnSchema_LookerColumnSpec_FILTER ColumnSchema_LookerColumnSpec_LookerColumnType = 3
	// Measure.
	ColumnSchema_LookerColumnSpec_MEASURE ColumnSchema_LookerColumnSpec_LookerColumnType = 4
	// Parameter.
	ColumnSchema_LookerColumnSpec_PARAMETER ColumnSchema_LookerColumnSpec_LookerColumnType = 5
)

// Enum value maps for ColumnSchema_LookerColumnSpec_LookerColumnType.
var (
	ColumnSchema_LookerColumnSpec_LookerColumnType_name = map[int32]string{
		0: "LOOKER_COLUMN_TYPE_UNSPECIFIED",
		1: "DIMENSION",
		2: "DIMENSION_GROUP",
		3: "FILTER",
		4: "MEASURE",
		5: "PARAMETER",
	}
	ColumnSchema_LookerColumnSpec_LookerColumnType_value = map[string]int32{
		"LOOKER_COLUMN_TYPE_UNSPECIFIED": 0,
		"DIMENSION":                      1,
		"DIMENSION_GROUP":                2,
		"FILTER":                         3,
		"MEASURE":                        4,
		"PARAMETER":                      5,
	}
)

func (x ColumnSchema_LookerColumnSpec_LookerColumnType) Enum() *ColumnSchema_LookerColumnSpec_LookerColumnType {
	p := new(ColumnSchema_LookerColumnSpec_LookerColumnType)
	*p = x
	return p
}

func (x ColumnSchema_LookerColumnSpec_LookerColumnType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ColumnSchema_LookerColumnSpec_LookerColumnType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1_schema_proto_enumTypes[1].Descriptor()
}

func (ColumnSchema_LookerColumnSpec_LookerColumnType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1_schema_proto_enumTypes[1]
}

func (x ColumnSchema_LookerColumnSpec_LookerColumnType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ColumnSchema_LookerColumnSpec_LookerColumnType.Descriptor instead.
func (ColumnSchema_LookerColumnSpec_LookerColumnType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{1, 0, 0}
}

// Represents a schema, for example, a BigQuery, GoogleSQL, or Avro schema.
type Schema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unified GoogleSQL-like schema of columns.
	//
	// The overall maximum number of columns and nested columns is 10,000.
	// The maximum nested depth is 15 levels.
	Columns []*ColumnSchema `protobuf:"bytes,2,rep,name=columns,proto3" json:"columns,omitempty"`
}

func (x *Schema) Reset() {
	*x = Schema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{0}
}

func (x *Schema) GetColumns() []*ColumnSchema {
	if x != nil {
		return x.Columns
	}
	return nil
}

// A column within a schema. Columns can be nested inside
// other columns.
type ColumnSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the column.
	//
	// Must be a UTF-8 string without dots (.).
	// The maximum size is 64 bytes.
	Column string `protobuf:"bytes,6,opt,name=column,proto3" json:"column,omitempty"`
	// Required. Type of the column.
	//
	// Must be a UTF-8 string with the maximum size of 128 bytes.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Description of the column. Default value is an empty string.
	//
	// The description must be a UTF-8 string with the maximum size of 2000
	// bytes.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. A column's mode indicates whether values in this column are
	// required, nullable, or repeated.
	//
	// Only `NULLABLE`, `REQUIRED`, and `REPEATED` values are supported.
	// Default mode is `NULLABLE`.
	Mode string `protobuf:"bytes,3,opt,name=mode,proto3" json:"mode,omitempty"`
	// Optional. Default value for the column.
	DefaultValue string `protobuf:"bytes,8,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Optional. Ordinal position
	OrdinalPosition int32 `protobuf:"varint,9,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
	// Optional. Most important inclusion of this column.
	HighestIndexingType ColumnSchema_IndexingType `protobuf:"varint,10,opt,name=highest_indexing_type,json=highestIndexingType,proto3,enum=google.cloud.datacatalog.v1.ColumnSchema_IndexingType" json:"highest_indexing_type,omitempty"`
	// Optional. Schema of sub-columns. A column can have zero or more
	// sub-columns.
	Subcolumns []*ColumnSchema `protobuf:"bytes,7,rep,name=subcolumns,proto3" json:"subcolumns,omitempty"`
	// Information only applying for columns in Entries from a specific system.
	//
	// Types that are assignable to SystemSpec:
	//
	//	*ColumnSchema_LookerColumnSpec_
	SystemSpec isColumnSchema_SystemSpec `protobuf_oneof:"system_spec"`
	// Optional. The subtype of the RANGE, if the type of this field is RANGE. If
	// the type is RANGE, this field is required. Possible values for the field
	// element type of a RANGE include:
	// * DATE
	// * DATETIME
	// * TIMESTAMP
	RangeElementType *ColumnSchema_FieldElementType `protobuf:"bytes,19,opt,name=range_element_type,json=rangeElementType,proto3" json:"range_element_type,omitempty"`
	// Optional. Garbage collection policy for the column or column family.
	// Applies to systems like Cloud Bigtable.
	GcRule string `protobuf:"bytes,11,opt,name=gc_rule,json=gcRule,proto3" json:"gc_rule,omitempty"`
}

func (x *ColumnSchema) Reset() {
	*x = ColumnSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnSchema) ProtoMessage() {}

func (x *ColumnSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnSchema.ProtoReflect.Descriptor instead.
func (*ColumnSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{1}
}

func (x *ColumnSchema) GetColumn() string {
	if x != nil {
		return x.Column
	}
	return ""
}

func (x *ColumnSchema) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ColumnSchema) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ColumnSchema) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *ColumnSchema) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

func (x *ColumnSchema) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

func (x *ColumnSchema) GetHighestIndexingType() ColumnSchema_IndexingType {
	if x != nil {
		return x.HighestIndexingType
	}
	return ColumnSchema_INDEXING_TYPE_UNSPECIFIED
}

func (x *ColumnSchema) GetSubcolumns() []*ColumnSchema {
	if x != nil {
		return x.Subcolumns
	}
	return nil
}

func (m *ColumnSchema) GetSystemSpec() isColumnSchema_SystemSpec {
	if m != nil {
		return m.SystemSpec
	}
	return nil
}

func (x *ColumnSchema) GetLookerColumnSpec() *ColumnSchema_LookerColumnSpec {
	if x, ok := x.GetSystemSpec().(*ColumnSchema_LookerColumnSpec_); ok {
		return x.LookerColumnSpec
	}
	return nil
}

func (x *ColumnSchema) GetRangeElementType() *ColumnSchema_FieldElementType {
	if x != nil {
		return x.RangeElementType
	}
	return nil
}

func (x *ColumnSchema) GetGcRule() string {
	if x != nil {
		return x.GcRule
	}
	return ""
}

type isColumnSchema_SystemSpec interface {
	isColumnSchema_SystemSpec()
}

type ColumnSchema_LookerColumnSpec_ struct {
	// Looker specific column info of this column.
	LookerColumnSpec *ColumnSchema_LookerColumnSpec `protobuf:"bytes,18,opt,name=looker_column_spec,json=lookerColumnSpec,proto3,oneof"`
}

func (*ColumnSchema_LookerColumnSpec_) isColumnSchema_SystemSpec() {}

// Column info specific to Looker System.
type ColumnSchema_LookerColumnSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Looker specific column type of this column.
	Type ColumnSchema_LookerColumnSpec_LookerColumnType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.datacatalog.v1.ColumnSchema_LookerColumnSpec_LookerColumnType" json:"type,omitempty"`
}

func (x *ColumnSchema_LookerColumnSpec) Reset() {
	*x = ColumnSchema_LookerColumnSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnSchema_LookerColumnSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnSchema_LookerColumnSpec) ProtoMessage() {}

func (x *ColumnSchema_LookerColumnSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnSchema_LookerColumnSpec.ProtoReflect.Descriptor instead.
func (*ColumnSchema_LookerColumnSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ColumnSchema_LookerColumnSpec) GetType() ColumnSchema_LookerColumnSpec_LookerColumnType {
	if x != nil {
		return x.Type
	}
	return ColumnSchema_LookerColumnSpec_LOOKER_COLUMN_TYPE_UNSPECIFIED
}

// Represents the type of a field element.
type ColumnSchema_FieldElementType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of a field element. See
	// [ColumnSchema.type][google.cloud.datacatalog.v1.ColumnSchema.type].
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *ColumnSchema_FieldElementType) Reset() {
	*x = ColumnSchema_FieldElementType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ColumnSchema_FieldElementType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnSchema_FieldElementType) ProtoMessage() {}

func (x *ColumnSchema_FieldElementType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1_schema_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnSchema_FieldElementType.ProtoReflect.Descriptor instead.
func (*ColumnSchema_FieldElementType) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP(), []int{1, 1}
}

func (x *ColumnSchema_FieldElementType) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

var File_google_cloud_datacatalog_v1_schema_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1_schema_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4d, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x12, 0x43, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x07,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x22, 0xee, 0x08, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x1b, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c,
	0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x15, 0x68, 0x69, 0x67, 0x68,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x73, 0x75, 0x62,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73,
	0x75, 0x62, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x6c, 0x6f, 0x6f,
	0x6b, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x6f, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x6d, 0x0a, 0x12, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x67, 0x63, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x67, 0x63, 0x52, 0x75,
	0x6c, 0x65, 0x1a, 0xf8, 0x01, 0x0a, 0x10, 0x4c, 0x6f, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x82, 0x01, 0x0a, 0x10, 0x4c, 0x6f, 0x6f,
	0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a,
	0x1e, 0x4c, 0x4f, 0x4f, 0x4b, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01,
	0x12, 0x13, 0x0a, 0x0f, 0x44, 0x49, 0x4d, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x47, 0x52,
	0x4f, 0x55, 0x50, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x10,
	0x03, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x45, 0x41, 0x53, 0x55, 0x52, 0x45, 0x10, 0x04, 0x12, 0x0d,
	0x0a, 0x09, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x10, 0x05, 0x1a, 0x2b, 0x0a,
	0x10, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x9c, 0x01, 0x0a, 0x0c, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x49,
	0x4e, 0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45,
	0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x10, 0x02,
	0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x10, 0x03, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x52, 0x49, 0x4d,
	0x41, 0x52, 0x59, 0x5f, 0x4b, 0x45, 0x59, 0x10, 0x04, 0x42, 0x0d, 0x0a, 0x0b, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x42, 0xc6, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x41,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f,
	0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x70,
	0x62, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1_schema_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1_schema_proto_rawDescData = file_google_cloud_datacatalog_v1_schema_proto_rawDesc
)

func file_google_cloud_datacatalog_v1_schema_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1_schema_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1_schema_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1_schema_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1_schema_proto_rawDescData
}

var file_google_cloud_datacatalog_v1_schema_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_datacatalog_v1_schema_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_datacatalog_v1_schema_proto_goTypes = []interface{}{
	(ColumnSchema_IndexingType)(0),                      // 0: google.cloud.datacatalog.v1.ColumnSchema.IndexingType
	(ColumnSchema_LookerColumnSpec_LookerColumnType)(0), // 1: google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
	(*Schema)(nil),                        // 2: google.cloud.datacatalog.v1.Schema
	(*ColumnSchema)(nil),                  // 3: google.cloud.datacatalog.v1.ColumnSchema
	(*ColumnSchema_LookerColumnSpec)(nil), // 4: google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
	(*ColumnSchema_FieldElementType)(nil), // 5: google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
}
var file_google_cloud_datacatalog_v1_schema_proto_depIdxs = []int32{
	3, // 0: google.cloud.datacatalog.v1.Schema.columns:type_name -> google.cloud.datacatalog.v1.ColumnSchema
	0, // 1: google.cloud.datacatalog.v1.ColumnSchema.highest_indexing_type:type_name -> google.cloud.datacatalog.v1.ColumnSchema.IndexingType
	3, // 2: google.cloud.datacatalog.v1.ColumnSchema.subcolumns:type_name -> google.cloud.datacatalog.v1.ColumnSchema
	4, // 3: google.cloud.datacatalog.v1.ColumnSchema.looker_column_spec:type_name -> google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec
	5, // 4: google.cloud.datacatalog.v1.ColumnSchema.range_element_type:type_name -> google.cloud.datacatalog.v1.ColumnSchema.FieldElementType
	1, // 5: google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.type:type_name -> google.cloud.datacatalog.v1.ColumnSchema.LookerColumnSpec.LookerColumnType
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1_schema_proto_init() }
func file_google_cloud_datacatalog_v1_schema_proto_init() {
	if File_google_cloud_datacatalog_v1_schema_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datacatalog_v1_schema_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Schema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_schema_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_schema_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnSchema_LookerColumnSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datacatalog_v1_schema_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ColumnSchema_FieldElementType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datacatalog_v1_schema_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ColumnSchema_LookerColumnSpec_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1_schema_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datacatalog_v1_schema_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1_schema_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_v1_schema_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_v1_schema_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1_schema_proto = out.File
	file_google_cloud_datacatalog_v1_schema_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1_schema_proto_goTypes = nil
	file_google_cloud_datacatalog_v1_schema_proto_depIdxs = nil
}
