// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/vision/v1/image_annotator.proto

package visionpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A bucketized representation of likelihood, which is intended to give clients
// highly stable results across model upgrades.
type Likelihood int32

const (
	// Unknown likelihood.
	Likelihood_UNKNOWN Likelihood = 0
	// It is very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// It is unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// It is possible.
	Likelihood_POSSIBLE Likelihood = 3
	// It is likely.
	Likelihood_LIKELY Likelihood = 4
	// It is very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

// Enum value maps for Likelihood.
var (
	Likelihood_name = map[int32]string{
		0: "UNKNOWN",
		1: "VERY_UNLIKELY",
		2: "UNLIKELY",
		3: "POSSIBLE",
		4: "LIKELY",
		5: "VERY_LIKELY",
	}
	Likelihood_value = map[string]int32{
		"UNKNOWN":       0,
		"VERY_UNLIKELY": 1,
		"UNLIKELY":      2,
		"POSSIBLE":      3,
		"LIKELY":        4,
		"VERY_LIKELY":   5,
	}
)

func (x Likelihood) Enum() *Likelihood {
	p := new(Likelihood)
	*p = x
	return p
}

func (x Likelihood) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Likelihood) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1_image_annotator_proto_enumTypes[0].Descriptor()
}

func (Likelihood) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1_image_annotator_proto_enumTypes[0]
}

func (x Likelihood) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Likelihood.Descriptor instead.
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{0}
}

// Type of Google Cloud Vision API feature to be extracted.
type Feature_Type int32

const (
	// Unspecified feature type.
	Feature_TYPE_UNSPECIFIED Feature_Type = 0
	// Run face detection.
	Feature_FACE_DETECTION Feature_Type = 1
	// Run landmark detection.
	Feature_LANDMARK_DETECTION Feature_Type = 2
	// Run logo detection.
	Feature_LOGO_DETECTION Feature_Type = 3
	// Run label detection.
	Feature_LABEL_DETECTION Feature_Type = 4
	// Run text detection / optical character recognition (OCR). Text detection
	// is optimized for areas of text within a larger image; if the image is
	// a document, use `DOCUMENT_TEXT_DETECTION` instead.
	Feature_TEXT_DETECTION Feature_Type = 5
	// Run dense text document OCR. Takes precedence when both
	// `DOCUMENT_TEXT_DETECTION` and `TEXT_DETECTION` are present.
	Feature_DOCUMENT_TEXT_DETECTION Feature_Type = 11
	// Run Safe Search to detect potentially unsafe
	// or undesirable content.
	Feature_SAFE_SEARCH_DETECTION Feature_Type = 6
	// Compute a set of image properties, such as the
	// image's dominant colors.
	Feature_IMAGE_PROPERTIES Feature_Type = 7
	// Run crop hints.
	Feature_CROP_HINTS Feature_Type = 9
	// Run web detection.
	Feature_WEB_DETECTION Feature_Type = 10
	// Run Product Search.
	Feature_PRODUCT_SEARCH Feature_Type = 12
	// Run localizer for object detection.
	Feature_OBJECT_LOCALIZATION Feature_Type = 19
)

// Enum value maps for Feature_Type.
var (
	Feature_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "FACE_DETECTION",
		2:  "LANDMARK_DETECTION",
		3:  "LOGO_DETECTION",
		4:  "LABEL_DETECTION",
		5:  "TEXT_DETECTION",
		11: "DOCUMENT_TEXT_DETECTION",
		6:  "SAFE_SEARCH_DETECTION",
		7:  "IMAGE_PROPERTIES",
		9:  "CROP_HINTS",
		10: "WEB_DETECTION",
		12: "PRODUCT_SEARCH",
		19: "OBJECT_LOCALIZATION",
	}
	Feature_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":        0,
		"FACE_DETECTION":          1,
		"LANDMARK_DETECTION":      2,
		"LOGO_DETECTION":          3,
		"LABEL_DETECTION":         4,
		"TEXT_DETECTION":          5,
		"DOCUMENT_TEXT_DETECTION": 11,
		"SAFE_SEARCH_DETECTION":   6,
		"IMAGE_PROPERTIES":        7,
		"CROP_HINTS":              9,
		"WEB_DETECTION":           10,
		"PRODUCT_SEARCH":          12,
		"OBJECT_LOCALIZATION":     19,
	}
)

func (x Feature_Type) Enum() *Feature_Type {
	p := new(Feature_Type)
	*p = x
	return p
}

func (x Feature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Feature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1_image_annotator_proto_enumTypes[1].Descriptor()
}

func (Feature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1_image_annotator_proto_enumTypes[1]
}

func (x Feature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Feature_Type.Descriptor instead.
func (Feature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{0, 0}
}

// Face landmark (feature) type.
// Left and right are defined from the vantage of the viewer of the image
// without considering mirror projections typical of photos. So, `LEFT_EYE`,
// typically, is the person's right eye.
type FaceAnnotation_Landmark_Type int32

const (
	// Unknown face landmark detected. Should not be filled.
	FaceAnnotation_Landmark_UNKNOWN_LANDMARK FaceAnnotation_Landmark_Type = 0
	// Left eye.
	FaceAnnotation_Landmark_LEFT_EYE FaceAnnotation_Landmark_Type = 1
	// Right eye.
	FaceAnnotation_Landmark_RIGHT_EYE FaceAnnotation_Landmark_Type = 2
	// Left of left eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 3
	// Right of left eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_LEFT_EYEBROW FaceAnnotation_Landmark_Type = 4
	// Left of right eyebrow.
	FaceAnnotation_Landmark_LEFT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 5
	// Right of right eyebrow.
	FaceAnnotation_Landmark_RIGHT_OF_RIGHT_EYEBROW FaceAnnotation_Landmark_Type = 6
	// Midpoint between eyes.
	FaceAnnotation_Landmark_MIDPOINT_BETWEEN_EYES FaceAnnotation_Landmark_Type = 7
	// Nose tip.
	FaceAnnotation_Landmark_NOSE_TIP FaceAnnotation_Landmark_Type = 8
	// Upper lip.
	FaceAnnotation_Landmark_UPPER_LIP FaceAnnotation_Landmark_Type = 9
	// Lower lip.
	FaceAnnotation_Landmark_LOWER_LIP FaceAnnotation_Landmark_Type = 10
	// Mouth left.
	FaceAnnotation_Landmark_MOUTH_LEFT FaceAnnotation_Landmark_Type = 11
	// Mouth right.
	FaceAnnotation_Landmark_MOUTH_RIGHT FaceAnnotation_Landmark_Type = 12
	// Mouth center.
	FaceAnnotation_Landmark_MOUTH_CENTER FaceAnnotation_Landmark_Type = 13
	// Nose, bottom right.
	FaceAnnotation_Landmark_NOSE_BOTTOM_RIGHT FaceAnnotation_Landmark_Type = 14
	// Nose, bottom left.
	FaceAnnotation_Landmark_NOSE_BOTTOM_LEFT FaceAnnotation_Landmark_Type = 15
	// Nose, bottom center.
	FaceAnnotation_Landmark_NOSE_BOTTOM_CENTER FaceAnnotation_Landmark_Type = 16
	// Left eye, top boundary.
	FaceAnnotation_Landmark_LEFT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 17
	// Left eye, right corner.
	FaceAnnotation_Landmark_LEFT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 18
	// Left eye, bottom boundary.
	FaceAnnotation_Landmark_LEFT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 19
	// Left eye, left corner.
	FaceAnnotation_Landmark_LEFT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 20
	// Right eye, top boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_TOP_BOUNDARY FaceAnnotation_Landmark_Type = 21
	// Right eye, right corner.
	FaceAnnotation_Landmark_RIGHT_EYE_RIGHT_CORNER FaceAnnotation_Landmark_Type = 22
	// Right eye, bottom boundary.
	FaceAnnotation_Landmark_RIGHT_EYE_BOTTOM_BOUNDARY FaceAnnotation_Landmark_Type = 23
	// Right eye, left corner.
	FaceAnnotation_Landmark_RIGHT_EYE_LEFT_CORNER FaceAnnotation_Landmark_Type = 24
	// Left eyebrow, upper midpoint.
	FaceAnnotation_Landmark_LEFT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 25
	// Right eyebrow, upper midpoint.
	FaceAnnotation_Landmark_RIGHT_EYEBROW_UPPER_MIDPOINT FaceAnnotation_Landmark_Type = 26
	// Left ear tragion.
	FaceAnnotation_Landmark_LEFT_EAR_TRAGION FaceAnnotation_Landmark_Type = 27
	// Right ear tragion.
	FaceAnnotation_Landmark_RIGHT_EAR_TRAGION FaceAnnotation_Landmark_Type = 28
	// Left eye pupil.
	FaceAnnotation_Landmark_LEFT_EYE_PUPIL FaceAnnotation_Landmark_Type = 29
	// Right eye pupil.
	FaceAnnotation_Landmark_RIGHT_EYE_PUPIL FaceAnnotation_Landmark_Type = 30
	// Forehead glabella.
	FaceAnnotation_Landmark_FOREHEAD_GLABELLA FaceAnnotation_Landmark_Type = 31
	// Chin gnathion.
	FaceAnnotation_Landmark_CHIN_GNATHION FaceAnnotation_Landmark_Type = 32
	// Chin left gonion.
	FaceAnnotation_Landmark_CHIN_LEFT_GONION FaceAnnotation_Landmark_Type = 33
	// Chin right gonion.
	FaceAnnotation_Landmark_CHIN_RIGHT_GONION FaceAnnotation_Landmark_Type = 34
	// Left cheek center.
	FaceAnnotation_Landmark_LEFT_CHEEK_CENTER FaceAnnotation_Landmark_Type = 35
	// Right cheek center.
	FaceAnnotation_Landmark_RIGHT_CHEEK_CENTER FaceAnnotation_Landmark_Type = 36
)

// Enum value maps for FaceAnnotation_Landmark_Type.
var (
	FaceAnnotation_Landmark_Type_name = map[int32]string{
		0:  "UNKNOWN_LANDMARK",
		1:  "LEFT_EYE",
		2:  "RIGHT_EYE",
		3:  "LEFT_OF_LEFT_EYEBROW",
		4:  "RIGHT_OF_LEFT_EYEBROW",
		5:  "LEFT_OF_RIGHT_EYEBROW",
		6:  "RIGHT_OF_RIGHT_EYEBROW",
		7:  "MIDPOINT_BETWEEN_EYES",
		8:  "NOSE_TIP",
		9:  "UPPER_LIP",
		10: "LOWER_LIP",
		11: "MOUTH_LEFT",
		12: "MOUTH_RIGHT",
		13: "MOUTH_CENTER",
		14: "NOSE_BOTTOM_RIGHT",
		15: "NOSE_BOTTOM_LEFT",
		16: "NOSE_BOTTOM_CENTER",
		17: "LEFT_EYE_TOP_BOUNDARY",
		18: "LEFT_EYE_RIGHT_CORNER",
		19: "LEFT_EYE_BOTTOM_BOUNDARY",
		20: "LEFT_EYE_LEFT_CORNER",
		21: "RIGHT_EYE_TOP_BOUNDARY",
		22: "RIGHT_EYE_RIGHT_CORNER",
		23: "RIGHT_EYE_BOTTOM_BOUNDARY",
		24: "RIGHT_EYE_LEFT_CORNER",
		25: "LEFT_EYEBROW_UPPER_MIDPOINT",
		26: "RIGHT_EYEBROW_UPPER_MIDPOINT",
		27: "LEFT_EAR_TRAGION",
		28: "RIGHT_EAR_TRAGION",
		29: "LEFT_EYE_PUPIL",
		30: "RIGHT_EYE_PUPIL",
		31: "FOREHEAD_GLABELLA",
		32: "CHIN_GNATHION",
		33: "CHIN_LEFT_GONION",
		34: "CHIN_RIGHT_GONION",
		35: "LEFT_CHEEK_CENTER",
		36: "RIGHT_CHEEK_CENTER",
	}
	FaceAnnotation_Landmark_Type_value = map[string]int32{
		"UNKNOWN_LANDMARK":             0,
		"LEFT_EYE":                     1,
		"RIGHT_EYE":                    2,
		"LEFT_OF_LEFT_EYEBROW":         3,
		"RIGHT_OF_LEFT_EYEBROW":        4,
		"LEFT_OF_RIGHT_EYEBROW":        5,
		"RIGHT_OF_RIGHT_EYEBROW":       6,
		"MIDPOINT_BETWEEN_EYES":        7,
		"NOSE_TIP":                     8,
		"UPPER_LIP":                    9,
		"LOWER_LIP":                    10,
		"MOUTH_LEFT":                   11,
		"MOUTH_RIGHT":                  12,
		"MOUTH_CENTER":                 13,
		"NOSE_BOTTOM_RIGHT":            14,
		"NOSE_BOTTOM_LEFT":             15,
		"NOSE_BOTTOM_CENTER":           16,
		"LEFT_EYE_TOP_BOUNDARY":        17,
		"LEFT_EYE_RIGHT_CORNER":        18,
		"LEFT_EYE_BOTTOM_BOUNDARY":     19,
		"LEFT_EYE_LEFT_CORNER":         20,
		"RIGHT_EYE_TOP_BOUNDARY":       21,
		"RIGHT_EYE_RIGHT_CORNER":       22,
		"RIGHT_EYE_BOTTOM_BOUNDARY":    23,
		"RIGHT_EYE_LEFT_CORNER":        24,
		"LEFT_EYEBROW_UPPER_MIDPOINT":  25,
		"RIGHT_EYEBROW_UPPER_MIDPOINT": 26,
		"LEFT_EAR_TRAGION":             27,
		"RIGHT_EAR_TRAGION":            28,
		"LEFT_EYE_PUPIL":               29,
		"RIGHT_EYE_PUPIL":              30,
		"FOREHEAD_GLABELLA":            31,
		"CHIN_GNATHION":                32,
		"CHIN_LEFT_GONION":             33,
		"CHIN_RIGHT_GONION":            34,
		"LEFT_CHEEK_CENTER":            35,
		"RIGHT_CHEEK_CENTER":           36,
	}
)

func (x FaceAnnotation_Landmark_Type) Enum() *FaceAnnotation_Landmark_Type {
	p := new(FaceAnnotation_Landmark_Type)
	*p = x
	return p
}

func (x FaceAnnotation_Landmark_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FaceAnnotation_Landmark_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1_image_annotator_proto_enumTypes[2].Descriptor()
}

func (FaceAnnotation_Landmark_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1_image_annotator_proto_enumTypes[2]
}

func (x FaceAnnotation_Landmark_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FaceAnnotation_Landmark_Type.Descriptor instead.
func (FaceAnnotation_Landmark_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Batch operation states.
type OperationMetadata_State int32

const (
	// Invalid.
	OperationMetadata_STATE_UNSPECIFIED OperationMetadata_State = 0
	// Request is received.
	OperationMetadata_CREATED OperationMetadata_State = 1
	// Request is actively being processed.
	OperationMetadata_RUNNING OperationMetadata_State = 2
	// The batch processing is done.
	OperationMetadata_DONE OperationMetadata_State = 3
	// The batch processing was cancelled.
	OperationMetadata_CANCELLED OperationMetadata_State = 4
)

// Enum value maps for OperationMetadata_State.
var (
	OperationMetadata_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATED",
		2: "RUNNING",
		3: "DONE",
		4: "CANCELLED",
	}
	OperationMetadata_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATED":           1,
		"RUNNING":           2,
		"DONE":              3,
		"CANCELLED":         4,
	}
)

func (x OperationMetadata_State) Enum() *OperationMetadata_State {
	p := new(OperationMetadata_State)
	*p = x
	return p
}

func (x OperationMetadata_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OperationMetadata_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vision_v1_image_annotator_proto_enumTypes[3].Descriptor()
}

func (OperationMetadata_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vision_v1_image_annotator_proto_enumTypes[3]
}

func (x OperationMetadata_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OperationMetadata_State.Descriptor instead.
func (OperationMetadata_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{38, 0}
}

// The type of Google Cloud Vision API detection to perform, and the maximum
// number of results to return for that type. Multiple `Feature` objects can
// be specified in the `features` list.
type Feature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The feature type.
	Type Feature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vision.v1.Feature_Type" json:"type,omitempty"`
	// Maximum number of results of this type. Does not apply to
	// `TEXT_DETECTION`, `DOCUMENT_TEXT_DETECTION`, or `CROP_HINTS`.
	MaxResults int32 `protobuf:"varint,2,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Model to use for the feature.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest". `DOCUMENT_TEXT_DETECTION` and `TEXT_DETECTION` also
	// support "builtin/weekly" for the bleeding edge release updated weekly.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *Feature) Reset() {
	*x = Feature{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Feature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feature) ProtoMessage() {}

func (x *Feature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feature.ProtoReflect.Descriptor instead.
func (*Feature) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{0}
}

func (x *Feature) GetType() Feature_Type {
	if x != nil {
		return x.Type
	}
	return Feature_TYPE_UNSPECIFIED
}

func (x *Feature) GetMaxResults() int32 {
	if x != nil {
		return x.MaxResults
	}
	return 0
}

func (x *Feature) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// External image source (Google Cloud Storage or web URL image location).
type ImageSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// **Use `image_uri` instead.**
	//
	// The Google Cloud Storage  URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported. See
	// [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris) for more info.
	GcsImageUri string `protobuf:"bytes,1,opt,name=gcs_image_uri,json=gcsImageUri,proto3" json:"gcs_image_uri,omitempty"`
	// The URI of the source image. Can be either:
	//
	//  1. A Google Cloud Storage URI of the form
	//     `gs://bucket_name/object_name`. Object versioning is not supported. See
	//     [Google Cloud Storage Request
	//     URIs](https://cloud.google.com/storage/docs/reference-uris) for more
	//     info.
	//
	//  2. A publicly-accessible image HTTP/HTTPS URL. When fetching images from
	//     HTTP/HTTPS URLs, Google cannot guarantee that the request will be
	//     completed. Your request may fail if the specified host denies the
	//     request (e.g. due to request throttling or DOS prevention), or if Google
	//     throttles requests to the site for abuse prevention. You should not
	//     depend on externally-hosted images for production applications.
	//
	// When both `gcs_image_uri` and `image_uri` are specified, `image_uri` takes
	// precedence.
	ImageUri string `protobuf:"bytes,2,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
}

func (x *ImageSource) Reset() {
	*x = ImageSource{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageSource) ProtoMessage() {}

func (x *ImageSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageSource.ProtoReflect.Descriptor instead.
func (*ImageSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{1}
}

func (x *ImageSource) GetGcsImageUri() string {
	if x != nil {
		return x.GcsImageUri
	}
	return ""
}

func (x *ImageSource) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

// Client image to perform Google Cloud Vision API tasks over.
type Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Image content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	//
	// Currently, this field only works for BatchAnnotateImages requests. It does
	// not work for AsyncBatchAnnotateImages requests.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Google Cloud Storage image location, or publicly-accessible image
	// URL. If both `content` and `source` are provided for an image, `content`
	// takes precedence and is used to perform the image annotation request.
	Source *ImageSource `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
}

func (x *Image) Reset() {
	*x = Image{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Image) ProtoMessage() {}

func (x *Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Image.ProtoReflect.Descriptor instead.
func (*Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{2}
}

func (x *Image) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Image) GetSource() *ImageSource {
	if x != nil {
		return x.Source
	}
	return nil
}

// A face annotation object contains the results of face detection.
type FaceAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon around the face. The coordinates of the bounding box
	// are in the original image's scale.
	// The bounding box is computed to "frame" the face in accordance with human
	// expectations. It is based on the landmarker results.
	// Note that one or more x and/or y coordinates may not be generated in the
	// `BoundingPoly` (the polygon will be unbounded) if only a partial face
	// appears in the image to be annotated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The `fd_bounding_poly` bounding polygon is tighter than the
	// `boundingPoly`, and encloses only the skin part of the face. Typically, it
	// is used to eliminate the face from any image analysis that detects the
	// "amount of skin" visible in an image. It is not based on the
	// landmarker results, only on the initial face detection, hence
	// the <code>fd</code> (face detection) prefix.
	FdBoundingPoly *BoundingPoly `protobuf:"bytes,2,opt,name=fd_bounding_poly,json=fdBoundingPoly,proto3" json:"fd_bounding_poly,omitempty"`
	// Detected face landmarks.
	Landmarks []*FaceAnnotation_Landmark `protobuf:"bytes,3,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	// Roll angle, which indicates the amount of clockwise/anti-clockwise rotation
	// of the face relative to the image vertical about the axis perpendicular to
	// the face. Range [-180,180].
	RollAngle float32 `protobuf:"fixed32,4,opt,name=roll_angle,json=rollAngle,proto3" json:"roll_angle,omitempty"`
	// Yaw angle, which indicates the leftward/rightward angle that the face is
	// pointing relative to the vertical plane perpendicular to the image. Range
	// [-180,180].
	PanAngle float32 `protobuf:"fixed32,5,opt,name=pan_angle,json=panAngle,proto3" json:"pan_angle,omitempty"`
	// Pitch angle, which indicates the upwards/downwards angle that the face is
	// pointing relative to the image's horizontal plane. Range [-180,180].
	TiltAngle float32 `protobuf:"fixed32,6,opt,name=tilt_angle,json=tiltAngle,proto3" json:"tilt_angle,omitempty"`
	// Detection confidence. Range [0, 1].
	DetectionConfidence float32 `protobuf:"fixed32,7,opt,name=detection_confidence,json=detectionConfidence,proto3" json:"detection_confidence,omitempty"`
	// Face landmarking confidence. Range [0, 1].
	LandmarkingConfidence float32 `protobuf:"fixed32,8,opt,name=landmarking_confidence,json=landmarkingConfidence,proto3" json:"landmarking_confidence,omitempty"`
	// Joy likelihood.
	JoyLikelihood Likelihood `protobuf:"varint,9,opt,name=joy_likelihood,json=joyLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"joy_likelihood,omitempty"`
	// Sorrow likelihood.
	SorrowLikelihood Likelihood `protobuf:"varint,10,opt,name=sorrow_likelihood,json=sorrowLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"sorrow_likelihood,omitempty"`
	// Anger likelihood.
	AngerLikelihood Likelihood `protobuf:"varint,11,opt,name=anger_likelihood,json=angerLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"anger_likelihood,omitempty"`
	// Surprise likelihood.
	SurpriseLikelihood Likelihood `protobuf:"varint,12,opt,name=surprise_likelihood,json=surpriseLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"surprise_likelihood,omitempty"`
	// Under-exposed likelihood.
	UnderExposedLikelihood Likelihood `protobuf:"varint,13,opt,name=under_exposed_likelihood,json=underExposedLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"under_exposed_likelihood,omitempty"`
	// Blurred likelihood.
	BlurredLikelihood Likelihood `protobuf:"varint,14,opt,name=blurred_likelihood,json=blurredLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"blurred_likelihood,omitempty"`
	// Headwear likelihood.
	HeadwearLikelihood Likelihood `protobuf:"varint,15,opt,name=headwear_likelihood,json=headwearLikelihood,proto3,enum=google.cloud.vision.v1.Likelihood" json:"headwear_likelihood,omitempty"`
}

func (x *FaceAnnotation) Reset() {
	*x = FaceAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FaceAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceAnnotation) ProtoMessage() {}

func (x *FaceAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceAnnotation.ProtoReflect.Descriptor instead.
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{3}
}

func (x *FaceAnnotation) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *FaceAnnotation) GetFdBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.FdBoundingPoly
	}
	return nil
}

func (x *FaceAnnotation) GetLandmarks() []*FaceAnnotation_Landmark {
	if x != nil {
		return x.Landmarks
	}
	return nil
}

func (x *FaceAnnotation) GetRollAngle() float32 {
	if x != nil {
		return x.RollAngle
	}
	return 0
}

func (x *FaceAnnotation) GetPanAngle() float32 {
	if x != nil {
		return x.PanAngle
	}
	return 0
}

func (x *FaceAnnotation) GetTiltAngle() float32 {
	if x != nil {
		return x.TiltAngle
	}
	return 0
}

func (x *FaceAnnotation) GetDetectionConfidence() float32 {
	if x != nil {
		return x.DetectionConfidence
	}
	return 0
}

func (x *FaceAnnotation) GetLandmarkingConfidence() float32 {
	if x != nil {
		return x.LandmarkingConfidence
	}
	return 0
}

func (x *FaceAnnotation) GetJoyLikelihood() Likelihood {
	if x != nil {
		return x.JoyLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetSorrowLikelihood() Likelihood {
	if x != nil {
		return x.SorrowLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetAngerLikelihood() Likelihood {
	if x != nil {
		return x.AngerLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetSurpriseLikelihood() Likelihood {
	if x != nil {
		return x.SurpriseLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetUnderExposedLikelihood() Likelihood {
	if x != nil {
		return x.UnderExposedLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetBlurredLikelihood() Likelihood {
	if x != nil {
		return x.BlurredLikelihood
	}
	return Likelihood_UNKNOWN
}

func (x *FaceAnnotation) GetHeadwearLikelihood() Likelihood {
	if x != nil {
		return x.HeadwearLikelihood
	}
	return Likelihood_UNKNOWN
}

// Detected entity location information.
type LocationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// lat/long location coordinates.
	LatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
}

func (x *LocationInfo) Reset() {
	*x = LocationInfo{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationInfo) ProtoMessage() {}

func (x *LocationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationInfo.ProtoReflect.Descriptor instead.
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{4}
}

func (x *LocationInfo) GetLatLng() *latlng.LatLng {
	if x != nil {
		return x.LatLng
	}
	return nil
}

// A `Property` consists of a user-supplied name/value pair.
type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the property.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the property.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Value of numeric properties.
	Uint64Value uint64 `protobuf:"varint,3,opt,name=uint64_value,json=uint64Value,proto3" json:"uint64_value,omitempty"`
}

func (x *Property) Reset() {
	*x = Property{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{5}
}

func (x *Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Property) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *Property) GetUint64Value() uint64 {
	if x != nil {
		return x.Uint64Value
	}
	return 0
}

// Set of detected entity features.
type EntityAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The language code for the locale in which the entity textual
	// `description` is expressed.
	Locale string `protobuf:"bytes,2,opt,name=locale,proto3" json:"locale,omitempty"`
	// Entity textual description, expressed in its `locale` language.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Overall score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// **Deprecated. Use `score` instead.**
	// The accuracy of the entity detection in an image.
	// For example, for an image in which the "Eiffel Tower" entity is detected,
	// this field represents the confidence that there is a tower in the query
	// image. Range [0, 1].
	//
	// Deprecated: Marked as deprecated in google/cloud/vision/v1/image_annotator.proto.
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The relevancy of the ICA (Image Content Annotation) label to the
	// image. For example, the relevancy of "tower" is likely higher to an image
	// containing the detected "Eiffel Tower" than to an image containing a
	// detected distant towering building, even though the confidence that
	// there is a tower in each image may be the same. Range [0, 1].
	Topicality float32 `protobuf:"fixed32,6,opt,name=topicality,proto3" json:"topicality,omitempty"`
	// Image region to which this entity belongs. Not produced
	// for `LABEL_DETECTION` features.
	BoundingPoly *BoundingPoly `protobuf:"bytes,7,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// The location information for the detected entity. Multiple
	// `LocationInfo` elements can be present because one location may
	// indicate the location of the scene in the image, and another location
	// may indicate the location of the place where the image was taken.
	// Location information is usually present for landmarks.
	Locations []*LocationInfo `protobuf:"bytes,8,rep,name=locations,proto3" json:"locations,omitempty"`
	// Some entities may have optional user-supplied `Property` (name/value)
	// fields, such a score or string that qualifies the entity.
	Properties []*Property `protobuf:"bytes,9,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (x *EntityAnnotation) Reset() {
	*x = EntityAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityAnnotation) ProtoMessage() {}

func (x *EntityAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityAnnotation.ProtoReflect.Descriptor instead.
func (*EntityAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{6}
}

func (x *EntityAnnotation) GetMid() string {
	if x != nil {
		return x.Mid
	}
	return ""
}

func (x *EntityAnnotation) GetLocale() string {
	if x != nil {
		return x.Locale
	}
	return ""
}

func (x *EntityAnnotation) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntityAnnotation) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/vision/v1/image_annotator.proto.
func (x *EntityAnnotation) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *EntityAnnotation) GetTopicality() float32 {
	if x != nil {
		return x.Topicality
	}
	return 0
}

func (x *EntityAnnotation) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *EntityAnnotation) GetLocations() []*LocationInfo {
	if x != nil {
		return x.Locations
	}
	return nil
}

func (x *EntityAnnotation) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Set of detected objects with bounding boxes.
type LocalizedObjectAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Object ID that should align with EntityAnnotation mid.
	Mid string `protobuf:"bytes,1,opt,name=mid,proto3" json:"mid,omitempty"`
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Object name, expressed in its `language_code` language.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Score of the result. Range [0, 1].
	Score float32 `protobuf:"fixed32,4,opt,name=score,proto3" json:"score,omitempty"`
	// Image region to which this object belongs. This must be populated.
	BoundingPoly *BoundingPoly `protobuf:"bytes,5,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
}

func (x *LocalizedObjectAnnotation) Reset() {
	*x = LocalizedObjectAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocalizedObjectAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalizedObjectAnnotation) ProtoMessage() {}

func (x *LocalizedObjectAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalizedObjectAnnotation.ProtoReflect.Descriptor instead.
func (*LocalizedObjectAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{7}
}

func (x *LocalizedObjectAnnotation) GetMid() string {
	if x != nil {
		return x.Mid
	}
	return ""
}

func (x *LocalizedObjectAnnotation) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *LocalizedObjectAnnotation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LocalizedObjectAnnotation) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *LocalizedObjectAnnotation) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

// Set of features pertaining to the image, computed by computer vision
// methods over safe-search verticals (for example, adult, spoof, medical,
// violence).
type SafeSearchAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the adult content likelihood for the image. Adult content may
	// contain elements such as nudity, pornographic images or cartoons, or
	// sexual activities.
	Adult Likelihood `protobuf:"varint,1,opt,name=adult,proto3,enum=google.cloud.vision.v1.Likelihood" json:"adult,omitempty"`
	// Spoof likelihood. The likelihood that an modification
	// was made to the image's canonical version to make it appear
	// funny or offensive.
	Spoof Likelihood `protobuf:"varint,2,opt,name=spoof,proto3,enum=google.cloud.vision.v1.Likelihood" json:"spoof,omitempty"`
	// Likelihood that this is a medical image.
	Medical Likelihood `protobuf:"varint,3,opt,name=medical,proto3,enum=google.cloud.vision.v1.Likelihood" json:"medical,omitempty"`
	// Likelihood that this image contains violent content. Violent content may
	// include death, serious harm, or injury to individuals or groups of
	// individuals.
	Violence Likelihood `protobuf:"varint,4,opt,name=violence,proto3,enum=google.cloud.vision.v1.Likelihood" json:"violence,omitempty"`
	// Likelihood that the request image contains racy content. Racy content may
	// include (but is not limited to) skimpy or sheer clothing, strategically
	// covered nudity, lewd or provocative poses, or close-ups of sensitive
	// body areas.
	Racy Likelihood `protobuf:"varint,9,opt,name=racy,proto3,enum=google.cloud.vision.v1.Likelihood" json:"racy,omitempty"`
}

func (x *SafeSearchAnnotation) Reset() {
	*x = SafeSearchAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafeSearchAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafeSearchAnnotation) ProtoMessage() {}

func (x *SafeSearchAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafeSearchAnnotation.ProtoReflect.Descriptor instead.
func (*SafeSearchAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{8}
}

func (x *SafeSearchAnnotation) GetAdult() Likelihood {
	if x != nil {
		return x.Adult
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetSpoof() Likelihood {
	if x != nil {
		return x.Spoof
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetMedical() Likelihood {
	if x != nil {
		return x.Medical
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetViolence() Likelihood {
	if x != nil {
		return x.Violence
	}
	return Likelihood_UNKNOWN
}

func (x *SafeSearchAnnotation) GetRacy() Likelihood {
	if x != nil {
		return x.Racy
	}
	return Likelihood_UNKNOWN
}

// Rectangle determined by min and max `LatLng` pairs.
type LatLongRect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Min lat/long pair.
	MinLatLng *latlng.LatLng `protobuf:"bytes,1,opt,name=min_lat_lng,json=minLatLng,proto3" json:"min_lat_lng,omitempty"`
	// Max lat/long pair.
	MaxLatLng *latlng.LatLng `protobuf:"bytes,2,opt,name=max_lat_lng,json=maxLatLng,proto3" json:"max_lat_lng,omitempty"`
}

func (x *LatLongRect) Reset() {
	*x = LatLongRect{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LatLongRect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LatLongRect) ProtoMessage() {}

func (x *LatLongRect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LatLongRect.ProtoReflect.Descriptor instead.
func (*LatLongRect) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{9}
}

func (x *LatLongRect) GetMinLatLng() *latlng.LatLng {
	if x != nil {
		return x.MinLatLng
	}
	return nil
}

func (x *LatLongRect) GetMaxLatLng() *latlng.LatLng {
	if x != nil {
		return x.MaxLatLng
	}
	return nil
}

// Color information consists of RGB channels, score, and the fraction of
// the image that the color occupies in the image.
type ColorInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RGB components of the color.
	Color *color.Color `protobuf:"bytes,1,opt,name=color,proto3" json:"color,omitempty"`
	// Image-specific score for this color. Value in range [0, 1].
	Score float32 `protobuf:"fixed32,2,opt,name=score,proto3" json:"score,omitempty"`
	// The fraction of pixels the color occupies in the image.
	// Value in range [0, 1].
	PixelFraction float32 `protobuf:"fixed32,3,opt,name=pixel_fraction,json=pixelFraction,proto3" json:"pixel_fraction,omitempty"`
}

func (x *ColorInfo) Reset() {
	*x = ColorInfo{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ColorInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColorInfo) ProtoMessage() {}

func (x *ColorInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColorInfo.ProtoReflect.Descriptor instead.
func (*ColorInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{10}
}

func (x *ColorInfo) GetColor() *color.Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *ColorInfo) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *ColorInfo) GetPixelFraction() float32 {
	if x != nil {
		return x.PixelFraction
	}
	return 0
}

// Set of dominant colors and their corresponding scores.
type DominantColorsAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// RGB color values with their score and pixel fraction.
	Colors []*ColorInfo `protobuf:"bytes,1,rep,name=colors,proto3" json:"colors,omitempty"`
}

func (x *DominantColorsAnnotation) Reset() {
	*x = DominantColorsAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DominantColorsAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DominantColorsAnnotation) ProtoMessage() {}

func (x *DominantColorsAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DominantColorsAnnotation.ProtoReflect.Descriptor instead.
func (*DominantColorsAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{11}
}

func (x *DominantColorsAnnotation) GetColors() []*ColorInfo {
	if x != nil {
		return x.Colors
	}
	return nil
}

// Stores image properties, such as dominant colors.
type ImageProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If present, dominant colors completed successfully.
	DominantColors *DominantColorsAnnotation `protobuf:"bytes,1,opt,name=dominant_colors,json=dominantColors,proto3" json:"dominant_colors,omitempty"`
}

func (x *ImageProperties) Reset() {
	*x = ImageProperties{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageProperties) ProtoMessage() {}

func (x *ImageProperties) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageProperties.ProtoReflect.Descriptor instead.
func (*ImageProperties) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{12}
}

func (x *ImageProperties) GetDominantColors() *DominantColorsAnnotation {
	if x != nil {
		return x.DominantColors
	}
	return nil
}

// Single crop hint that is used to generate a new crop when serving an image.
type CropHint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bounding polygon for the crop region. The coordinates of the bounding
	// box are in the original image's scale.
	BoundingPoly *BoundingPoly `protobuf:"bytes,1,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Confidence of this being a salient region.  Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Fraction of importance of this salient region with respect to the original
	// image.
	ImportanceFraction float32 `protobuf:"fixed32,3,opt,name=importance_fraction,json=importanceFraction,proto3" json:"importance_fraction,omitempty"`
}

func (x *CropHint) Reset() {
	*x = CropHint{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CropHint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHint) ProtoMessage() {}

func (x *CropHint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHint.ProtoReflect.Descriptor instead.
func (*CropHint) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{13}
}

func (x *CropHint) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *CropHint) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *CropHint) GetImportanceFraction() float32 {
	if x != nil {
		return x.ImportanceFraction
	}
	return 0
}

// Set of crop hints that are used to generate new crops when serving images.
type CropHintsAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Crop hint results.
	CropHints []*CropHint `protobuf:"bytes,1,rep,name=crop_hints,json=cropHints,proto3" json:"crop_hints,omitempty"`
}

func (x *CropHintsAnnotation) Reset() {
	*x = CropHintsAnnotation{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CropHintsAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHintsAnnotation) ProtoMessage() {}

func (x *CropHintsAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHintsAnnotation.ProtoReflect.Descriptor instead.
func (*CropHintsAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{14}
}

func (x *CropHintsAnnotation) GetCropHints() []*CropHint {
	if x != nil {
		return x.CropHints
	}
	return nil
}

// Parameters for crop hints annotation request.
type CropHintsParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Aspect ratios in floats, representing the ratio of the width to the height
	// of the image. For example, if the desired aspect ratio is 4/3, the
	// corresponding float value should be 1.33333.  If not specified, the
	// best possible crop is returned. The number of provided aspect ratios is
	// limited to a maximum of 16; any aspect ratios provided after the 16th are
	// ignored.
	AspectRatios []float32 `protobuf:"fixed32,1,rep,packed,name=aspect_ratios,json=aspectRatios,proto3" json:"aspect_ratios,omitempty"`
}

func (x *CropHintsParams) Reset() {
	*x = CropHintsParams{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CropHintsParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CropHintsParams) ProtoMessage() {}

func (x *CropHintsParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CropHintsParams.ProtoReflect.Descriptor instead.
func (*CropHintsParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{15}
}

func (x *CropHintsParams) GetAspectRatios() []float32 {
	if x != nil {
		return x.AspectRatios
	}
	return nil
}

// Parameters for web detection request.
type WebDetectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This field has no effect on results.
	//
	// Deprecated: Marked as deprecated in google/cloud/vision/v1/image_annotator.proto.
	IncludeGeoResults bool `protobuf:"varint,2,opt,name=include_geo_results,json=includeGeoResults,proto3" json:"include_geo_results,omitempty"`
}

func (x *WebDetectionParams) Reset() {
	*x = WebDetectionParams{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebDetectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebDetectionParams) ProtoMessage() {}

func (x *WebDetectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebDetectionParams.ProtoReflect.Descriptor instead.
func (*WebDetectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{16}
}

// Deprecated: Marked as deprecated in google/cloud/vision/v1/image_annotator.proto.
func (x *WebDetectionParams) GetIncludeGeoResults() bool {
	if x != nil {
		return x.IncludeGeoResults
	}
	return false
}

// Parameters for text detections. This is used to control TEXT_DETECTION and
// DOCUMENT_TEXT_DETECTION features.
type TextDetectionParams struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// By default, Cloud Vision API only includes confidence score for
	// DOCUMENT_TEXT_DETECTION result. Set the flag to true to include confidence
	// score for TEXT_DETECTION as well.
	EnableTextDetectionConfidenceScore bool `protobuf:"varint,9,opt,name=enable_text_detection_confidence_score,json=enableTextDetectionConfidenceScore,proto3" json:"enable_text_detection_confidence_score,omitempty"`
	// A list of advanced OCR options to further fine-tune OCR behavior.
	// Current valid values are:
	//
	// - `legacy_layout`: a heuristics layout detection algorithm, which serves as
	// an alternative to the current ML-based layout detection algorithm.
	// Customers can choose the best suitable layout algorithm based on their
	// situation.
	AdvancedOcrOptions []string `protobuf:"bytes,11,rep,name=advanced_ocr_options,json=advancedOcrOptions,proto3" json:"advanced_ocr_options,omitempty"`
}

func (x *TextDetectionParams) Reset() {
	*x = TextDetectionParams{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TextDetectionParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextDetectionParams) ProtoMessage() {}

func (x *TextDetectionParams) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextDetectionParams.ProtoReflect.Descriptor instead.
func (*TextDetectionParams) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{17}
}

func (x *TextDetectionParams) GetEnableTextDetectionConfidenceScore() bool {
	if x != nil {
		return x.EnableTextDetectionConfidenceScore
	}
	return false
}

func (x *TextDetectionParams) GetAdvancedOcrOptions() []string {
	if x != nil {
		return x.AdvancedOcrOptions
	}
	return nil
}

// Image context and/or feature-specific parameters.
type ImageContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Not used.
	LatLongRect *LatLongRect `protobuf:"bytes,1,opt,name=lat_long_rect,json=latLongRect,proto3" json:"lat_long_rect,omitempty"`
	// List of languages to use for TEXT_DETECTION. In most cases, an empty value
	// yields the best results since it enables automatic language detection. For
	// languages based on the Latin alphabet, setting `language_hints` is not
	// needed. In rare cases, when the language of the text in the image is known,
	// setting a hint will help get better results (although it will be a
	// significant hindrance if the hint is wrong). Text detection returns an
	// error if one or more of the specified languages is not one of the
	// [supported languages](https://cloud.google.com/vision/docs/languages).
	LanguageHints []string `protobuf:"bytes,2,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Parameters for crop hints annotation request.
	CropHintsParams *CropHintsParams `protobuf:"bytes,4,opt,name=crop_hints_params,json=cropHintsParams,proto3" json:"crop_hints_params,omitempty"`
	// Parameters for product search.
	ProductSearchParams *ProductSearchParams `protobuf:"bytes,5,opt,name=product_search_params,json=productSearchParams,proto3" json:"product_search_params,omitempty"`
	// Parameters for web detection.
	WebDetectionParams *WebDetectionParams `protobuf:"bytes,6,opt,name=web_detection_params,json=webDetectionParams,proto3" json:"web_detection_params,omitempty"`
	// Parameters for text detection and document text detection.
	TextDetectionParams *TextDetectionParams `protobuf:"bytes,12,opt,name=text_detection_params,json=textDetectionParams,proto3" json:"text_detection_params,omitempty"`
}

func (x *ImageContext) Reset() {
	*x = ImageContext{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageContext) ProtoMessage() {}

func (x *ImageContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageContext.ProtoReflect.Descriptor instead.
func (*ImageContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{18}
}

func (x *ImageContext) GetLatLongRect() *LatLongRect {
	if x != nil {
		return x.LatLongRect
	}
	return nil
}

func (x *ImageContext) GetLanguageHints() []string {
	if x != nil {
		return x.LanguageHints
	}
	return nil
}

func (x *ImageContext) GetCropHintsParams() *CropHintsParams {
	if x != nil {
		return x.CropHintsParams
	}
	return nil
}

func (x *ImageContext) GetProductSearchParams() *ProductSearchParams {
	if x != nil {
		return x.ProductSearchParams
	}
	return nil
}

func (x *ImageContext) GetWebDetectionParams() *WebDetectionParams {
	if x != nil {
		return x.WebDetectionParams
	}
	return nil
}

func (x *ImageContext) GetTextDetectionParams() *TextDetectionParams {
	if x != nil {
		return x.TextDetectionParams
	}
	return nil
}

// Request for performing Google Cloud Vision API tasks over a user-provided
// image, with user-requested features, and with context information.
type AnnotateImageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The image to be processed.
	Image *Image `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
}

func (x *AnnotateImageRequest) Reset() {
	*x = AnnotateImageRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnnotateImageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateImageRequest) ProtoMessage() {}

func (x *AnnotateImageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateImageRequest.ProtoReflect.Descriptor instead.
func (*AnnotateImageRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{19}
}

func (x *AnnotateImageRequest) GetImage() *Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *AnnotateImageRequest) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateImageRequest) GetImageContext() *ImageContext {
	if x != nil {
		return x.ImageContext
	}
	return nil
}

// If an image was produced from a file (e.g. a PDF), this message gives
// information about the source of that image.
type ImageAnnotationContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the file used to produce the image.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// If the file was a PDF or TIFF, this field gives the page number within
	// the file used to produce the image.
	PageNumber int32 `protobuf:"varint,2,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
}

func (x *ImageAnnotationContext) Reset() {
	*x = ImageAnnotationContext{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageAnnotationContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageAnnotationContext) ProtoMessage() {}

func (x *ImageAnnotationContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageAnnotationContext.ProtoReflect.Descriptor instead.
func (*ImageAnnotationContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{20}
}

func (x *ImageAnnotationContext) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ImageAnnotationContext) GetPageNumber() int32 {
	if x != nil {
		return x.PageNumber
	}
	return 0
}

// Response to an image annotation request.
type AnnotateImageResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If present, face detection has completed successfully.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,1,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// If present, landmark detection has completed successfully.
	LandmarkAnnotations []*EntityAnnotation `protobuf:"bytes,2,rep,name=landmark_annotations,json=landmarkAnnotations,proto3" json:"landmark_annotations,omitempty"`
	// If present, logo detection has completed successfully.
	LogoAnnotations []*EntityAnnotation `protobuf:"bytes,3,rep,name=logo_annotations,json=logoAnnotations,proto3" json:"logo_annotations,omitempty"`
	// If present, label detection has completed successfully.
	LabelAnnotations []*EntityAnnotation `protobuf:"bytes,4,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// If present, localized object detection has completed successfully.
	// This will be sorted descending by confidence score.
	LocalizedObjectAnnotations []*LocalizedObjectAnnotation `protobuf:"bytes,22,rep,name=localized_object_annotations,json=localizedObjectAnnotations,proto3" json:"localized_object_annotations,omitempty"`
	// If present, text (OCR) detection has completed successfully.
	TextAnnotations []*EntityAnnotation `protobuf:"bytes,5,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// If present, text (OCR) detection or document (OCR) text detection has
	// completed successfully.
	// This annotation provides the structural hierarchy for the OCR detected
	// text.
	FullTextAnnotation *TextAnnotation `protobuf:"bytes,12,opt,name=full_text_annotation,json=fullTextAnnotation,proto3" json:"full_text_annotation,omitempty"`
	// If present, safe-search annotation has completed successfully.
	SafeSearchAnnotation *SafeSearchAnnotation `protobuf:"bytes,6,opt,name=safe_search_annotation,json=safeSearchAnnotation,proto3" json:"safe_search_annotation,omitempty"`
	// If present, image properties were extracted successfully.
	ImagePropertiesAnnotation *ImageProperties `protobuf:"bytes,8,opt,name=image_properties_annotation,json=imagePropertiesAnnotation,proto3" json:"image_properties_annotation,omitempty"`
	// If present, crop hints have completed successfully.
	CropHintsAnnotation *CropHintsAnnotation `protobuf:"bytes,11,opt,name=crop_hints_annotation,json=cropHintsAnnotation,proto3" json:"crop_hints_annotation,omitempty"`
	// If present, web detection has completed successfully.
	WebDetection *WebDetection `protobuf:"bytes,13,opt,name=web_detection,json=webDetection,proto3" json:"web_detection,omitempty"`
	// If present, product search has completed successfully.
	ProductSearchResults *ProductSearchResults `protobuf:"bytes,14,opt,name=product_search_results,json=productSearchResults,proto3" json:"product_search_results,omitempty"`
	// If set, represents the error message for the operation.
	// Note that filled-in image annotations are guaranteed to be
	// correct, even when `error` is set.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// If present, contextual information is needed to understand where this image
	// comes from.
	Context *ImageAnnotationContext `protobuf:"bytes,21,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *AnnotateImageResponse) Reset() {
	*x = AnnotateImageResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnnotateImageResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateImageResponse) ProtoMessage() {}

func (x *AnnotateImageResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateImageResponse.ProtoReflect.Descriptor instead.
func (*AnnotateImageResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{21}
}

func (x *AnnotateImageResponse) GetFaceAnnotations() []*FaceAnnotation {
	if x != nil {
		return x.FaceAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLandmarkAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LandmarkAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLogoAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LogoAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLabelAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.LabelAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetLocalizedObjectAnnotations() []*LocalizedObjectAnnotation {
	if x != nil {
		return x.LocalizedObjectAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetTextAnnotations() []*EntityAnnotation {
	if x != nil {
		return x.TextAnnotations
	}
	return nil
}

func (x *AnnotateImageResponse) GetFullTextAnnotation() *TextAnnotation {
	if x != nil {
		return x.FullTextAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetSafeSearchAnnotation() *SafeSearchAnnotation {
	if x != nil {
		return x.SafeSearchAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetImagePropertiesAnnotation() *ImageProperties {
	if x != nil {
		return x.ImagePropertiesAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetCropHintsAnnotation() *CropHintsAnnotation {
	if x != nil {
		return x.CropHintsAnnotation
	}
	return nil
}

func (x *AnnotateImageResponse) GetWebDetection() *WebDetection {
	if x != nil {
		return x.WebDetection
	}
	return nil
}

func (x *AnnotateImageResponse) GetProductSearchResults() *ProductSearchResults {
	if x != nil {
		return x.ProductSearchResults
	}
	return nil
}

func (x *AnnotateImageResponse) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *AnnotateImageResponse) GetContext() *ImageAnnotationContext {
	if x != nil {
		return x.Context
	}
	return nil
}

// Multiple image annotation requests are batched into a single service call.
type BatchAnnotateImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Optional. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no parent is specified, a region will be chosen automatically.
	//
	// Supported location-ids:
	//
	//	`us`: USA country only,
	//	`asia`: East asia areas, like Japan, Taiwan,
	//	`eu`: The European Union.
	//
	// Example: `projects/project-A/locations/eu`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchAnnotateImagesRequest) Reset() {
	*x = BatchAnnotateImagesRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchAnnotateImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateImagesRequest) ProtoMessage() {}

func (x *BatchAnnotateImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateImagesRequest.ProtoReflect.Descriptor instead.
func (*BatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{22}
}

func (x *BatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchAnnotateImagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchAnnotateImagesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Response to a batch image annotation request.
type BatchAnnotateImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Individual responses to image annotation requests within the batch.
	Responses []*AnnotateImageResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchAnnotateImagesResponse) Reset() {
	*x = BatchAnnotateImagesResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchAnnotateImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateImagesResponse) ProtoMessage() {}

func (x *BatchAnnotateImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateImagesResponse.ProtoReflect.Descriptor instead.
func (*BatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{23}
}

func (x *BatchAnnotateImagesResponse) GetResponses() []*AnnotateImageResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// A request to annotate one single file, e.g. a PDF, TIFF or GIF file.
type AnnotateFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image(s) in the file.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	// Pages of the file to perform image annotation.
	//
	// Pages starts from 1, we assume the first page of the file is page 1.
	// At most 5 pages are supported per request. Pages can be negative.
	//
	// Page 1 means the first page.
	// Page 2 means the second page.
	// Page -1 means the last page.
	// Page -2 means the second to the last page.
	//
	// If the file is GIF instead of PDF or TIFF, page refers to GIF frames.
	//
	// If this field is empty, by default the service performs image annotation
	// for the first 5 pages of the file.
	Pages []int32 `protobuf:"varint,4,rep,packed,name=pages,proto3" json:"pages,omitempty"`
}

func (x *AnnotateFileRequest) Reset() {
	*x = AnnotateFileRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnnotateFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateFileRequest) ProtoMessage() {}

func (x *AnnotateFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateFileRequest.ProtoReflect.Descriptor instead.
func (*AnnotateFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{24}
}

func (x *AnnotateFileRequest) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *AnnotateFileRequest) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AnnotateFileRequest) GetImageContext() *ImageContext {
	if x != nil {
		return x.ImageContext
	}
	return nil
}

func (x *AnnotateFileRequest) GetPages() []int32 {
	if x != nil {
		return x.Pages
	}
	return nil
}

// Response to a single file annotation request. A file may contain one or more
// images, which individually have their own responses.
type AnnotateFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the file for which this response is generated.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Individual responses to images found within the file. This field will be
	// empty if the `error` field is set.
	Responses []*AnnotateImageResponse `protobuf:"bytes,2,rep,name=responses,proto3" json:"responses,omitempty"`
	// This field gives the total number of pages in the file.
	TotalPages int32 `protobuf:"varint,3,opt,name=total_pages,json=totalPages,proto3" json:"total_pages,omitempty"`
	// If set, represents the error message for the failed request. The
	// `responses` field will not be set in this case.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *AnnotateFileResponse) Reset() {
	*x = AnnotateFileResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnnotateFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotateFileResponse) ProtoMessage() {}

func (x *AnnotateFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotateFileResponse.ProtoReflect.Descriptor instead.
func (*AnnotateFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{25}
}

func (x *AnnotateFileResponse) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *AnnotateFileResponse) GetResponses() []*AnnotateImageResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *AnnotateFileResponse) GetTotalPages() int32 {
	if x != nil {
		return x.TotalPages
	}
	return 0
}

func (x *AnnotateFileResponse) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A list of requests to annotate files using the BatchAnnotateFiles API.
type BatchAnnotateFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of file annotation requests. Right now we support only
	// one AnnotateFileRequest in BatchAnnotateFilesRequest.
	Requests []*AnnotateFileRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Optional. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no parent is specified, a region will be chosen automatically.
	//
	// Supported location-ids:
	//
	//	`us`: USA country only,
	//	`asia`: East asia areas, like Japan, Taiwan,
	//	`eu`: The European Union.
	//
	// Example: `projects/project-A/locations/eu`.
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *BatchAnnotateFilesRequest) Reset() {
	*x = BatchAnnotateFilesRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchAnnotateFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateFilesRequest) ProtoMessage() {}

func (x *BatchAnnotateFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateFilesRequest.ProtoReflect.Descriptor instead.
func (*BatchAnnotateFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{26}
}

func (x *BatchAnnotateFilesRequest) GetRequests() []*AnnotateFileRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchAnnotateFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchAnnotateFilesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// A list of file annotation responses.
type BatchAnnotateFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of file annotation responses, each response corresponding to each
	// AnnotateFileRequest in BatchAnnotateFilesRequest.
	Responses []*AnnotateFileResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *BatchAnnotateFilesResponse) Reset() {
	*x = BatchAnnotateFilesResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BatchAnnotateFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchAnnotateFilesResponse) ProtoMessage() {}

func (x *BatchAnnotateFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchAnnotateFilesResponse.ProtoReflect.Descriptor instead.
func (*BatchAnnotateFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{27}
}

func (x *BatchAnnotateFilesResponse) GetResponses() []*AnnotateFileResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// An offline file annotation request.
type AsyncAnnotateFileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Information about the input file.
	InputConfig *InputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. Requested features.
	Features []*Feature `protobuf:"bytes,2,rep,name=features,proto3" json:"features,omitempty"`
	// Additional context that may accompany the image(s) in the file.
	ImageContext *ImageContext `protobuf:"bytes,3,opt,name=image_context,json=imageContext,proto3" json:"image_context,omitempty"`
	// Required. The desired output location and metadata (e.g. format).
	OutputConfig *OutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *AsyncAnnotateFileRequest) Reset() {
	*x = AsyncAnnotateFileRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncAnnotateFileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncAnnotateFileRequest) ProtoMessage() {}

func (x *AsyncAnnotateFileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncAnnotateFileRequest.ProtoReflect.Descriptor instead.
func (*AsyncAnnotateFileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{28}
}

func (x *AsyncAnnotateFileRequest) GetInputConfig() *InputConfig {
	if x != nil {
		return x.InputConfig
	}
	return nil
}

func (x *AsyncAnnotateFileRequest) GetFeatures() []*Feature {
	if x != nil {
		return x.Features
	}
	return nil
}

func (x *AsyncAnnotateFileRequest) GetImageContext() *ImageContext {
	if x != nil {
		return x.ImageContext
	}
	return nil
}

func (x *AsyncAnnotateFileRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// The response for a single offline file annotation request.
type AsyncAnnotateFileResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output location and metadata from AsyncAnnotateFileRequest.
	OutputConfig *OutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *AsyncAnnotateFileResponse) Reset() {
	*x = AsyncAnnotateFileResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncAnnotateFileResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncAnnotateFileResponse) ProtoMessage() {}

func (x *AsyncAnnotateFileResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncAnnotateFileResponse.ProtoReflect.Descriptor instead.
func (*AsyncAnnotateFileResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{29}
}

func (x *AsyncAnnotateFileResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Request for async image annotation for a list of images.
type AsyncBatchAnnotateImagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Individual image annotation requests for this batch.
	Requests []*AnnotateImageRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Required. The desired output location and metadata (e.g. format).
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Optional. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no parent is specified, a region will be chosen automatically.
	//
	// Supported location-ids:
	//
	//	`us`: USA country only,
	//	`asia`: East asia areas, like Japan, Taiwan,
	//	`eu`: The European Union.
	//
	// Example: `projects/project-A/locations/eu`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AsyncBatchAnnotateImagesRequest) Reset() {
	*x = AsyncBatchAnnotateImagesRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncBatchAnnotateImagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncBatchAnnotateImagesRequest) ProtoMessage() {}

func (x *AsyncBatchAnnotateImagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncBatchAnnotateImagesRequest.ProtoReflect.Descriptor instead.
func (*AsyncBatchAnnotateImagesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{30}
}

func (x *AsyncBatchAnnotateImagesRequest) GetRequests() []*AnnotateImageRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *AsyncBatchAnnotateImagesRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *AsyncBatchAnnotateImagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AsyncBatchAnnotateImagesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Response to an async batch image annotation request.
type AsyncBatchAnnotateImagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output location and metadata from AsyncBatchAnnotateImagesRequest.
	OutputConfig *OutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *AsyncBatchAnnotateImagesResponse) Reset() {
	*x = AsyncBatchAnnotateImagesResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncBatchAnnotateImagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncBatchAnnotateImagesResponse) ProtoMessage() {}

func (x *AsyncBatchAnnotateImagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncBatchAnnotateImagesResponse.ProtoReflect.Descriptor instead.
func (*AsyncBatchAnnotateImagesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{31}
}

func (x *AsyncBatchAnnotateImagesResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Multiple async file annotation requests are batched into a single service
// call.
type AsyncBatchAnnotateFilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Individual async file annotation requests for this batch.
	Requests []*AsyncAnnotateFileRequest `protobuf:"bytes,1,rep,name=requests,proto3" json:"requests,omitempty"`
	// Optional. Target project and location to make a call.
	//
	// Format: `projects/{project-id}/locations/{location-id}`.
	//
	// If no parent is specified, a region will be chosen automatically.
	//
	// Supported location-ids:
	//
	//	`us`: USA country only,
	//	`asia`: East asia areas, like Japan, Taiwan,
	//	`eu`: The European Union.
	//
	// Example: `projects/project-A/locations/eu`.
	Parent string `protobuf:"bytes,4,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The labels with user-defined metadata for the request.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AsyncBatchAnnotateFilesRequest) Reset() {
	*x = AsyncBatchAnnotateFilesRequest{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncBatchAnnotateFilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncBatchAnnotateFilesRequest) ProtoMessage() {}

func (x *AsyncBatchAnnotateFilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncBatchAnnotateFilesRequest.ProtoReflect.Descriptor instead.
func (*AsyncBatchAnnotateFilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{32}
}

func (x *AsyncBatchAnnotateFilesRequest) GetRequests() []*AsyncAnnotateFileRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *AsyncBatchAnnotateFilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AsyncBatchAnnotateFilesRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Response to an async batch file annotation request.
type AsyncBatchAnnotateFilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of file annotation responses, one for each request in
	// AsyncBatchAnnotateFilesRequest.
	Responses []*AsyncAnnotateFileResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
}

func (x *AsyncBatchAnnotateFilesResponse) Reset() {
	*x = AsyncBatchAnnotateFilesResponse{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AsyncBatchAnnotateFilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AsyncBatchAnnotateFilesResponse) ProtoMessage() {}

func (x *AsyncBatchAnnotateFilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AsyncBatchAnnotateFilesResponse.ProtoReflect.Descriptor instead.
func (*AsyncBatchAnnotateFilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{33}
}

func (x *AsyncBatchAnnotateFilesResponse) GetResponses() []*AsyncAnnotateFileResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

// The desired input location and metadata.
type InputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage location to read the input from.
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3" json:"gcs_source,omitempty"`
	// File content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	//
	// Currently, this field only works for BatchAnnotateFiles requests. It does
	// not work for AsyncBatchAnnotateFiles requests.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// The type of the file. Currently only "application/pdf", "image/tiff" and
	// "image/gif" are supported. Wildcards are not supported.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *InputConfig) Reset() {
	*x = InputConfig{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputConfig) ProtoMessage() {}

func (x *InputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputConfig.ProtoReflect.Descriptor instead.
func (*InputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{34}
}

func (x *InputConfig) GetGcsSource() *GcsSource {
	if x != nil {
		return x.GcsSource
	}
	return nil
}

func (x *InputConfig) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *InputConfig) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// The desired output location and metadata.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud Storage location to write the output(s) to.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3" json:"gcs_destination,omitempty"`
	// The max number of response protos to put into each output JSON file on
	// Google Cloud Storage.
	// The valid range is [1, 100]. If not specified, the default value is 20.
	//
	// For example, for one pdf file with 100 pages, 100 response protos will
	// be generated. If `batch_size` = 20, then 5 json files each
	// containing 20 response protos will be written under the prefix
	// `gcs_destination`.`uri`.
	//
	// Currently, batch_size only applies to GcsDestination, with potential future
	// support for other output configurations.
	BatchSize int32 `protobuf:"varint,2,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{35}
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x != nil {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

// The Google Cloud Storage location where the input will be read from.
type GcsSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage URI for the input file. This must only be a
	// Google Cloud Storage object. Wildcards are not currently supported.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *GcsSource) Reset() {
	*x = GcsSource{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsSource) ProtoMessage() {}

func (x *GcsSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsSource.ProtoReflect.Descriptor instead.
func (*GcsSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{36}
}

func (x *GcsSource) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// The Google Cloud Storage location where the output will be written to.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Google Cloud Storage URI prefix where the results will be stored. Results
	// will be in JSON format and preceded by its corresponding input URI prefix.
	// This field can either represent a gcs file prefix or gcs directory. In
	// either case, the uri should be unique because in order to get all of the
	// output files, you will need to do a wildcard gcs search on the uri prefix
	// you provide.
	//
	// Examples:
	//
	// *    File Prefix: gs://bucket-name/here/filenameprefix   The output files
	// will be created in gs://bucket-name/here/ and the names of the
	// output files will begin with "filenameprefix".
	//
	// *    Directory Prefix: gs://bucket-name/some/location/   The output files
	// will be created in gs://bucket-name/some/location/ and the names of the
	// output files could be anything because there was no filename prefix
	// specified.
	//
	// If multiple outputs, each response is still AnnotateFileResponse, each of
	// which contains some subset of the full list of AnnotateImageResponse.
	// Multiple outputs can happen if, for example, the output JSON is too large
	// and overflows into multiple sharded files.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{37}
}

func (x *GcsDestination) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Contains metadata for the BatchAnnotateImages operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Current state of the batch operation.
	State OperationMetadata_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.vision.v1.OperationMetadata_State" json:"state,omitempty"`
	// The time when the batch request was received.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time when the operation result was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{38}
}

func (x *OperationMetadata) GetState() OperationMetadata_State {
	if x != nil {
		return x.State
	}
	return OperationMetadata_STATE_UNSPECIFIED
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A face-specific landmark (for example, a face feature).
type FaceAnnotation_Landmark struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Face landmark type.
	Type FaceAnnotation_Landmark_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.vision.v1.FaceAnnotation_Landmark_Type" json:"type,omitempty"`
	// Face landmark position.
	Position *Position `protobuf:"bytes,4,opt,name=position,proto3" json:"position,omitempty"`
}

func (x *FaceAnnotation_Landmark) Reset() {
	*x = FaceAnnotation_Landmark{}
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FaceAnnotation_Landmark) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaceAnnotation_Landmark) ProtoMessage() {}

func (x *FaceAnnotation_Landmark) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vision_v1_image_annotator_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaceAnnotation_Landmark.ProtoReflect.Descriptor instead.
func (*FaceAnnotation_Landmark) Descriptor() ([]byte, []int) {
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP(), []int{3, 0}
}

func (x *FaceAnnotation_Landmark) GetType() FaceAnnotation_Landmark_Type {
	if x != nil {
		return x.Type
	}
	return FaceAnnotation_Landmark_UNKNOWN_LANDMARK
}

func (x *FaceAnnotation_Landmark) GetPosition() *Position {
	if x != nil {
		return x.Position
	}
	return nil
}

var File_google_cloud_vision_v1_image_annotator_proto protoreflect.FileDescriptor

var file_google_cloud_vision_v1_image_annotator_proto_rawDesc = []byte{
	0x0a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa0,
	0x03, 0x0a, 0x07, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x38, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xa3, 0x02, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x41,
	0x43, 0x45, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x4c, 0x41, 0x4e, 0x44, 0x4d, 0x41, 0x52, 0x4b, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x47, 0x4f, 0x5f, 0x44,
	0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x41,
	0x42, 0x45, 0x4c, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12,
	0x12, 0x0a, 0x0e, 0x54, 0x45, 0x58, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x05, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x54, 0x45, 0x58, 0x54, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0b,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x41, 0x46, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x5f,
	0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x06, 0x12, 0x14, 0x0a, 0x10, 0x49,
	0x4d, 0x41, 0x47, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x50, 0x45, 0x52, 0x54, 0x49, 0x45, 0x53, 0x10,
	0x07, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x52, 0x4f, 0x50, 0x5f, 0x48, 0x49, 0x4e, 0x54, 0x53, 0x10,
	0x09, 0x12, 0x11, 0x0a, 0x0d, 0x57, 0x45, 0x42, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x52, 0x4f, 0x44, 0x55, 0x43, 0x54, 0x5f,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x42, 0x4a, 0x45,
	0x43, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x13, 0x22, 0x4e, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x22, 0x0a, 0x0d, 0x67, 0x63, 0x73, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x67, 0x63, 0x73, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72,
	0x69, 0x22, 0x5e, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0x80, 0x10, 0x0a, 0x0e, 0x46, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x79, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12,
	0x4e, 0x0a, 0x10, 0x66, 0x64, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x6f, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52,
	0x0e, 0x66, 0x64, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12,
	0x4d, 0x0a, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x63, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x6e, 0x64, 0x6d,
	0x61, 0x72, 0x6b, 0x52, 0x09, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x73, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x6f, 0x6c, 0x6c, 0x5f, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x09, 0x72, 0x6f, 0x6c, 0x6c, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x6e, 0x5f, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x08, 0x70, 0x61, 0x6e, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x69,
	0x6c, 0x74, 0x5f, 0x61, 0x6e, 0x67, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09,
	0x74, 0x69, 0x6c, 0x74, 0x41, 0x6e, 0x67, 0x6c, 0x65, 0x12, 0x31, 0x0a, 0x14, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x16,
	0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x52, 0x15, 0x6c, 0x61,
	0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x49, 0x0a, 0x0e, 0x6a, 0x6f, 0x79, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52,
	0x0d, 0x6a, 0x6f, 0x79, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x4f,
	0x0a, 0x11, 0x73, 0x6f, 0x72, 0x72, 0x6f, 0x77, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x10, 0x73,
	0x6f, 0x72, 0x72, 0x6f, 0x77, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12,
	0x4d, 0x0a, 0x10, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x0f, 0x61,
	0x6e, 0x67, 0x65, 0x72, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x53,
	0x0a, 0x13, 0x73, 0x75, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52,
	0x12, 0x73, 0x75, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x12, 0x5c, 0x0a, 0x18, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x70,
	0x6f, 0x73, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x16, 0x75, 0x6e, 0x64, 0x65, 0x72,
	0x45, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x12, 0x51, 0x0a, 0x12, 0x62, 0x6c, 0x75, 0x72, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x52, 0x11, 0x62, 0x6c, 0x75, 0x72, 0x72, 0x65, 0x64, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69,
	0x68, 0x6f, 0x6f, 0x64, 0x12, 0x53, 0x0a, 0x13, 0x68, 0x65, 0x61, 0x64, 0x77, 0x65, 0x61, 0x72,
	0x5f, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c,
	0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x12, 0x68, 0x65, 0x61, 0x64, 0x77, 0x65, 0x61, 0x72, 0x4c,
	0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x1a, 0xf8, 0x07, 0x0a, 0x08, 0x4c, 0x61,
	0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x12, 0x48, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61,
	0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x6e,
	0x64, 0x6d, 0x61, 0x72, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x3c, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe3,
	0x06, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x5f, 0x4c, 0x41, 0x4e, 0x44, 0x4d, 0x41, 0x52, 0x4b, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x45,
	0x46, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52,
	0x4f, 0x57, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x4f, 0x46,
	0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x10, 0x04, 0x12,
	0x19, 0x0a, 0x15, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54,
	0x5f, 0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45,
	0x42, 0x52, 0x4f, 0x57, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x49, 0x44, 0x50, 0x4f, 0x49,
	0x4e, 0x54, 0x5f, 0x42, 0x45, 0x54, 0x57, 0x45, 0x45, 0x4e, 0x5f, 0x45, 0x59, 0x45, 0x53, 0x10,
	0x07, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x54, 0x49, 0x50, 0x10, 0x08, 0x12,
	0x0d, 0x0a, 0x09, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x4c, 0x49, 0x50, 0x10, 0x09, 0x12, 0x0d,
	0x0a, 0x09, 0x4c, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x4c, 0x49, 0x50, 0x10, 0x0a, 0x12, 0x0e, 0x0a,
	0x0a, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x0b, 0x12, 0x0f, 0x0a,
	0x0b, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x0c, 0x12, 0x10,
	0x0a, 0x0c, 0x4d, 0x4f, 0x55, 0x54, 0x48, 0x5f, 0x43, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x0d,
	0x12, 0x15, 0x0a, 0x11, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x4f, 0x53, 0x45, 0x5f,
	0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x10, 0x0f, 0x12, 0x16, 0x0a,
	0x12, 0x4e, 0x4f, 0x53, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x43, 0x45, 0x4e,
	0x54, 0x45, 0x52, 0x10, 0x10, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59,
	0x45, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x11,
	0x12, 0x19, 0x0a, 0x15, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x12, 0x12, 0x1c, 0x0a, 0x18, 0x4c,
	0x45, 0x46, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x42,
	0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x13, 0x12, 0x18, 0x0a, 0x14, 0x4c, 0x45, 0x46,
	0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45,
	0x52, 0x10, 0x14, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45,
	0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x15, 0x12,
	0x1a, 0x0a, 0x16, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x43, 0x4f, 0x52, 0x4e, 0x45, 0x52, 0x10, 0x16, 0x12, 0x1d, 0x0a, 0x19, 0x52,
	0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f,
	0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x17, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x49,
	0x47, 0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x43, 0x4f, 0x52,
	0x4e, 0x45, 0x52, 0x10, 0x18, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59,
	0x45, 0x42, 0x52, 0x4f, 0x57, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x4d, 0x49, 0x44, 0x50,
	0x4f, 0x49, 0x4e, 0x54, 0x10, 0x19, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f,
	0x45, 0x59, 0x45, 0x42, 0x52, 0x4f, 0x57, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x4d, 0x49,
	0x44, 0x50, 0x4f, 0x49, 0x4e, 0x54, 0x10, 0x1a, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x45, 0x46, 0x54,
	0x5f, 0x45, 0x41, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x47, 0x49, 0x4f, 0x4e, 0x10, 0x1b, 0x12, 0x15,
	0x0a, 0x11, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x45, 0x41, 0x52, 0x5f, 0x54, 0x52, 0x41, 0x47,
	0x49, 0x4f, 0x4e, 0x10, 0x1c, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x45, 0x59,
	0x45, 0x5f, 0x50, 0x55, 0x50, 0x49, 0x4c, 0x10, 0x1d, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x5f, 0x45, 0x59, 0x45, 0x5f, 0x50, 0x55, 0x50, 0x49, 0x4c, 0x10, 0x1e, 0x12, 0x15,
	0x0a, 0x11, 0x46, 0x4f, 0x52, 0x45, 0x48, 0x45, 0x41, 0x44, 0x5f, 0x47, 0x4c, 0x41, 0x42, 0x45,
	0x4c, 0x4c, 0x41, 0x10, 0x1f, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x48, 0x49, 0x4e, 0x5f, 0x47, 0x4e,
	0x41, 0x54, 0x48, 0x49, 0x4f, 0x4e, 0x10, 0x20, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x48, 0x49, 0x4e,
	0x5f, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x47, 0x4f, 0x4e, 0x49, 0x4f, 0x4e, 0x10, 0x21, 0x12, 0x15,
	0x0a, 0x11, 0x43, 0x48, 0x49, 0x4e, 0x5f, 0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x47, 0x4f, 0x4e,
	0x49, 0x4f, 0x4e, 0x10, 0x22, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x45, 0x46, 0x54, 0x5f, 0x43, 0x48,
	0x45, 0x45, 0x4b, 0x5f, 0x43, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x23, 0x12, 0x16, 0x0a, 0x12,
	0x52, 0x49, 0x47, 0x48, 0x54, 0x5f, 0x43, 0x48, 0x45, 0x45, 0x4b, 0x5f, 0x43, 0x45, 0x4e, 0x54,
	0x45, 0x52, 0x10, 0x24, 0x22, 0x3c, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x07, 0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x06, 0x6c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x22, 0x57, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x75, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0b,
	0x75, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x89, 0x03, 0x0a, 0x10,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d,
	0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x49, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x79, 0x12, 0x42, 0x0a, 0x09, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x22, 0xc7, 0x01, 0x0a, 0x19, 0x4c, 0x6f, 0x63, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6d, 0x69, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c,
	0x79, 0x22, 0xc0, 0x02, 0x0a, 0x14, 0x53, 0x61, 0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x05, 0x61, 0x64,
	0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x05, 0x61,
	0x64, 0x75, 0x6c, 0x74, 0x12, 0x38, 0x0a, 0x05, 0x73, 0x70, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x05, 0x73, 0x70, 0x6f, 0x6f, 0x66, 0x12, 0x3c,
	0x0a, 0x07, 0x6d, 0x65, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68,
	0x6f, 0x6f, 0x64, 0x52, 0x07, 0x6d, 0x65, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x3e, 0x0a, 0x08,
	0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f,
	0x6f, 0x64, 0x52, 0x08, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x04,
	0x72, 0x61, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x52, 0x04,
	0x72, 0x61, 0x63, 0x79, 0x22, 0x77, 0x0a, 0x0b, 0x4c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52,
	0x65, 0x63, 0x74, 0x12, 0x33, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x74, 0x5f, 0x6c,
	0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x12, 0x33, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f,
	0x6c, 0x61, 0x74, 0x5f, 0x6c, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c,
	0x6e, 0x67, 0x52, 0x09, 0x6d, 0x61, 0x78, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x22, 0x72, 0x0a,
	0x09, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x05, 0x63, 0x6f,
	0x6c, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x05, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x69,
	0x78, 0x65, 0x6c, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0d, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x55, 0x0a, 0x18, 0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6c,
	0x6f, 0x72, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a,
	0x06, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x06, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x22, 0x6c, 0x0a, 0x0f, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x64,
	0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6e, 0x74,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x22, 0xa6, 0x01, 0x0a, 0x08, 0x43, 0x72, 0x6f, 0x70, 0x48,
	0x69, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x6f, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79,
	0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2f,
	0x0a, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x66, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x12, 0x69, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x46, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x56, 0x0a, 0x13, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0a, 0x63, 0x72, 0x6f, 0x70, 0x5f, 0x68,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x63, 0x72,
	0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x22, 0x36, 0x0a, 0x0f, 0x43, 0x72, 0x6f, 0x70, 0x48,
	0x69, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x02, 0x52, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x73, 0x22,
	0x48, 0x0a, 0x12, 0x57, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x32, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
	0x5f, 0x67, 0x65, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x47,
	0x65, 0x6f, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x54, 0x65,
	0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x12, 0x52, 0x0a, 0x26, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x22, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x64, 0x5f, 0x6f, 0x63, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4f, 0x63, 0x72,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xf3, 0x03, 0x0a, 0x0c, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x47, 0x0a, 0x0d, 0x6c, 0x61, 0x74, 0x5f,
	0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67,
	0x52, 0x65, 0x63, 0x74, 0x52, 0x0b, 0x6c, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x65, 0x63,
	0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x68, 0x69,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x53, 0x0a, 0x11, 0x63, 0x72, 0x6f, 0x70,
	0x5f, 0x68, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x6f,
	0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x0f, 0x63, 0x72,
	0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5f, 0x0a,
	0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5c,
	0x0a, 0x14, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x12, 0x77, 0x65, 0x62, 0x44, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5f, 0x0a, 0x15,
	0x74, 0x65, 0x78, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x52, 0x13, 0x74, 0x65, 0x78, 0x74, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xd3, 0x01,
	0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x22, 0x4b, 0x0a, 0x16, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x22, 0xe8, 0x09, 0x0a, 0x15, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x51, 0x0a, 0x10, 0x66, 0x61,
	0x63, 0x65, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61,
	0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x66, 0x61,
	0x63, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5b, 0x0a,
	0x14, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x6c, 0x61, 0x6e, 0x64, 0x6d, 0x61, 0x72, 0x6b, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x10, 0x6c, 0x6f,
	0x67, 0x6f, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x6c, 0x6f, 0x67, 0x6f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x55, 0x0a, 0x11, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x73, 0x0a, 0x1c, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x1a, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x53, 0x0a, 0x10, 0x74,
	0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0f, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x58, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x54, 0x65, 0x78, 0x74,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x16, 0x73, 0x61,
	0x66, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x73, 0x61, 0x66, 0x65, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67,
	0x0a, 0x1b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x19, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x15, 0x63, 0x72, 0x6f, 0x70, 0x5f,
	0x68, 0x69, 0x6e, 0x74, 0x73, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x72, 0x6f, 0x70, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0d, 0x77, 0x65, 0x62, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x77, 0x65, 0x62, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x16, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x14, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x48, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x15, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x9b, 0x02, 0x0a, 0x1a,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6a, 0x0a, 0x1b, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0xfb, 0x01, 0x0a, 0x13, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52,
	0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a,
	0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x05, 0x52, 0x05, 0x70, 0x61,
	0x67, 0x65, 0x73, 0x22, 0xf6, 0x01, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0c,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x98, 0x02, 0x0a,
	0x19, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x5a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x68, 0x0a, 0x1a, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x73, 0x22, 0xb5, 0x02, 0x0a, 0x18, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x49,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x66, 0x0a, 0x19, 0x41, 0x73, 0x79,
	0x6e, 0x63, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0xf5, 0x02, 0x0a, 0x1f, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x12, 0x4e, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x6d, 0x0a, 0x20, 0x41, 0x73, 0x79,
	0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a,
	0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa7, 0x02, 0x0a, 0x1e, 0x41, 0x73, 0x79,
	0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x5f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x72, 0x0a, 0x1f, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x22, 0x86, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x67,
	0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22,
	0x7e, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x4f, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x1d, 0x0a, 0x09, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x10, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x22,
	0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x22, 0xa7, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x51, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e,
	0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a,
	0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x2a, 0x65, 0x0a, 0x0a,
	0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x56, 0x45, 0x52, 0x59, 0x5f,
	0x55, 0x4e, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e,
	0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x4f, 0x53, 0x53,
	0x49, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x49, 0x4b, 0x45, 0x4c, 0x59,
	0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x4c, 0x49, 0x4b, 0x45, 0x4c,
	0x59, 0x10, 0x05, 0x32, 0xf5, 0x0a, 0x0a, 0x0e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x93, 0x02, 0x0a, 0x13, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x92, 0x01, 0xda, 0x41, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x80, 0x01, 0x3a, 0x01, 0x2a, 0x5a,
	0x38, 0x3a, 0x01, 0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x3a, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x12, 0x8c, 0x02, 0x0a,
	0x12, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8e, 0x01, 0xda, 0x41, 0x08,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x7d, 0x3a, 0x01,
	0x2a, 0x5a, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x2b, 0x3a, 0x01, 0x2a, 0x22,
	0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x3a, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x3a, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x12, 0xeb, 0x02, 0x0a, 0x18,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xf6, 0x01, 0xca, 0x41, 0x35, 0x0a, 0x20, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x2c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x42,
	0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x3a,
	0x61, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x65, 0x5a, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x3a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x3a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x12, 0xd7, 0x02, 0x0a, 0x17, 0x41, 0x73,
	0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe4, 0x01, 0xca,
	0x41, 0x34, 0x0a, 0x1f, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9b, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x41, 0x3a, 0x01, 0x2a,
	0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x3a, 0x61, 0x73, 0x79, 0x6e,
	0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5a, 0x35,
	0x3a, 0x01, 0x2a, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x3a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x65, 0x22, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x3a, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x42, 0x61, 0x74, 0x63, 0x68, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x65, 0x1a, 0x76, 0xca, 0x41, 0x15, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5b,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x74, 0x0a, 0x1a, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x13, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x35, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x32, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x04, 0x47, 0x43, 0x56,
	0x4e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vision_v1_image_annotator_proto_rawDescOnce sync.Once
	file_google_cloud_vision_v1_image_annotator_proto_rawDescData = file_google_cloud_vision_v1_image_annotator_proto_rawDesc
)

func file_google_cloud_vision_v1_image_annotator_proto_rawDescGZIP() []byte {
	file_google_cloud_vision_v1_image_annotator_proto_rawDescOnce.Do(func() {
		file_google_cloud_vision_v1_image_annotator_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vision_v1_image_annotator_proto_rawDescData)
	})
	return file_google_cloud_vision_v1_image_annotator_proto_rawDescData
}

var file_google_cloud_vision_v1_image_annotator_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_vision_v1_image_annotator_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_google_cloud_vision_v1_image_annotator_proto_goTypes = []any{
	(Likelihood)(0),                          // 0: google.cloud.vision.v1.Likelihood
	(Feature_Type)(0),                        // 1: google.cloud.vision.v1.Feature.Type
	(FaceAnnotation_Landmark_Type)(0),        // 2: google.cloud.vision.v1.FaceAnnotation.Landmark.Type
	(OperationMetadata_State)(0),             // 3: google.cloud.vision.v1.OperationMetadata.State
	(*Feature)(nil),                          // 4: google.cloud.vision.v1.Feature
	(*ImageSource)(nil),                      // 5: google.cloud.vision.v1.ImageSource
	(*Image)(nil),                            // 6: google.cloud.vision.v1.Image
	(*FaceAnnotation)(nil),                   // 7: google.cloud.vision.v1.FaceAnnotation
	(*LocationInfo)(nil),                     // 8: google.cloud.vision.v1.LocationInfo
	(*Property)(nil),                         // 9: google.cloud.vision.v1.Property
	(*EntityAnnotation)(nil),                 // 10: google.cloud.vision.v1.EntityAnnotation
	(*LocalizedObjectAnnotation)(nil),        // 11: google.cloud.vision.v1.LocalizedObjectAnnotation
	(*SafeSearchAnnotation)(nil),             // 12: google.cloud.vision.v1.SafeSearchAnnotation
	(*LatLongRect)(nil),                      // 13: google.cloud.vision.v1.LatLongRect
	(*ColorInfo)(nil),                        // 14: google.cloud.vision.v1.ColorInfo
	(*DominantColorsAnnotation)(nil),         // 15: google.cloud.vision.v1.DominantColorsAnnotation
	(*ImageProperties)(nil),                  // 16: google.cloud.vision.v1.ImageProperties
	(*CropHint)(nil),                         // 17: google.cloud.vision.v1.CropHint
	(*CropHintsAnnotation)(nil),              // 18: google.cloud.vision.v1.CropHintsAnnotation
	(*CropHintsParams)(nil),                  // 19: google.cloud.vision.v1.CropHintsParams
	(*WebDetectionParams)(nil),               // 20: google.cloud.vision.v1.WebDetectionParams
	(*TextDetectionParams)(nil),              // 21: google.cloud.vision.v1.TextDetectionParams
	(*ImageContext)(nil),                     // 22: google.cloud.vision.v1.ImageContext
	(*AnnotateImageRequest)(nil),             // 23: google.cloud.vision.v1.AnnotateImageRequest
	(*ImageAnnotationContext)(nil),           // 24: google.cloud.vision.v1.ImageAnnotationContext
	(*AnnotateImageResponse)(nil),            // 25: google.cloud.vision.v1.AnnotateImageResponse
	(*BatchAnnotateImagesRequest)(nil),       // 26: google.cloud.vision.v1.BatchAnnotateImagesRequest
	(*BatchAnnotateImagesResponse)(nil),      // 27: google.cloud.vision.v1.BatchAnnotateImagesResponse
	(*AnnotateFileRequest)(nil),              // 28: google.cloud.vision.v1.AnnotateFileRequest
	(*AnnotateFileResponse)(nil),             // 29: google.cloud.vision.v1.AnnotateFileResponse
	(*BatchAnnotateFilesRequest)(nil),        // 30: google.cloud.vision.v1.BatchAnnotateFilesRequest
	(*BatchAnnotateFilesResponse)(nil),       // 31: google.cloud.vision.v1.BatchAnnotateFilesResponse
	(*AsyncAnnotateFileRequest)(nil),         // 32: google.cloud.vision.v1.AsyncAnnotateFileRequest
	(*AsyncAnnotateFileResponse)(nil),        // 33: google.cloud.vision.v1.AsyncAnnotateFileResponse
	(*AsyncBatchAnnotateImagesRequest)(nil),  // 34: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
	(*AsyncBatchAnnotateImagesResponse)(nil), // 35: google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse
	(*AsyncBatchAnnotateFilesRequest)(nil),   // 36: google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
	(*AsyncBatchAnnotateFilesResponse)(nil),  // 37: google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse
	(*InputConfig)(nil),                      // 38: google.cloud.vision.v1.InputConfig
	(*OutputConfig)(nil),                     // 39: google.cloud.vision.v1.OutputConfig
	(*GcsSource)(nil),                        // 40: google.cloud.vision.v1.GcsSource
	(*GcsDestination)(nil),                   // 41: google.cloud.vision.v1.GcsDestination
	(*OperationMetadata)(nil),                // 42: google.cloud.vision.v1.OperationMetadata
	(*FaceAnnotation_Landmark)(nil),          // 43: google.cloud.vision.v1.FaceAnnotation.Landmark
	nil,                                      // 44: google.cloud.vision.v1.BatchAnnotateImagesRequest.LabelsEntry
	nil,                                      // 45: google.cloud.vision.v1.BatchAnnotateFilesRequest.LabelsEntry
	nil,                                      // 46: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.LabelsEntry
	nil,                                      // 47: google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.LabelsEntry
	(*BoundingPoly)(nil),                     // 48: google.cloud.vision.v1.BoundingPoly
	(*latlng.LatLng)(nil),                    // 49: google.type.LatLng
	(*color.Color)(nil),                      // 50: google.type.Color
	(*ProductSearchParams)(nil),              // 51: google.cloud.vision.v1.ProductSearchParams
	(*TextAnnotation)(nil),                   // 52: google.cloud.vision.v1.TextAnnotation
	(*WebDetection)(nil),                     // 53: google.cloud.vision.v1.WebDetection
	(*ProductSearchResults)(nil),             // 54: google.cloud.vision.v1.ProductSearchResults
	(*status.Status)(nil),                    // 55: google.rpc.Status
	(*timestamppb.Timestamp)(nil),            // 56: google.protobuf.Timestamp
	(*Position)(nil),                         // 57: google.cloud.vision.v1.Position
	(*longrunningpb.Operation)(nil),          // 58: google.longrunning.Operation
}
var file_google_cloud_vision_v1_image_annotator_proto_depIdxs = []int32{
	1,  // 0: google.cloud.vision.v1.Feature.type:type_name -> google.cloud.vision.v1.Feature.Type
	5,  // 1: google.cloud.vision.v1.Image.source:type_name -> google.cloud.vision.v1.ImageSource
	48, // 2: google.cloud.vision.v1.FaceAnnotation.bounding_poly:type_name -> google.cloud.vision.v1.BoundingPoly
	48, // 3: google.cloud.vision.v1.FaceAnnotation.fd_bounding_poly:type_name -> google.cloud.vision.v1.BoundingPoly
	43, // 4: google.cloud.vision.v1.FaceAnnotation.landmarks:type_name -> google.cloud.vision.v1.FaceAnnotation.Landmark
	0,  // 5: google.cloud.vision.v1.FaceAnnotation.joy_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 6: google.cloud.vision.v1.FaceAnnotation.sorrow_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 7: google.cloud.vision.v1.FaceAnnotation.anger_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 8: google.cloud.vision.v1.FaceAnnotation.surprise_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 9: google.cloud.vision.v1.FaceAnnotation.under_exposed_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 10: google.cloud.vision.v1.FaceAnnotation.blurred_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 11: google.cloud.vision.v1.FaceAnnotation.headwear_likelihood:type_name -> google.cloud.vision.v1.Likelihood
	49, // 12: google.cloud.vision.v1.LocationInfo.lat_lng:type_name -> google.type.LatLng
	48, // 13: google.cloud.vision.v1.EntityAnnotation.bounding_poly:type_name -> google.cloud.vision.v1.BoundingPoly
	8,  // 14: google.cloud.vision.v1.EntityAnnotation.locations:type_name -> google.cloud.vision.v1.LocationInfo
	9,  // 15: google.cloud.vision.v1.EntityAnnotation.properties:type_name -> google.cloud.vision.v1.Property
	48, // 16: google.cloud.vision.v1.LocalizedObjectAnnotation.bounding_poly:type_name -> google.cloud.vision.v1.BoundingPoly
	0,  // 17: google.cloud.vision.v1.SafeSearchAnnotation.adult:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 18: google.cloud.vision.v1.SafeSearchAnnotation.spoof:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 19: google.cloud.vision.v1.SafeSearchAnnotation.medical:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 20: google.cloud.vision.v1.SafeSearchAnnotation.violence:type_name -> google.cloud.vision.v1.Likelihood
	0,  // 21: google.cloud.vision.v1.SafeSearchAnnotation.racy:type_name -> google.cloud.vision.v1.Likelihood
	49, // 22: google.cloud.vision.v1.LatLongRect.min_lat_lng:type_name -> google.type.LatLng
	49, // 23: google.cloud.vision.v1.LatLongRect.max_lat_lng:type_name -> google.type.LatLng
	50, // 24: google.cloud.vision.v1.ColorInfo.color:type_name -> google.type.Color
	14, // 25: google.cloud.vision.v1.DominantColorsAnnotation.colors:type_name -> google.cloud.vision.v1.ColorInfo
	15, // 26: google.cloud.vision.v1.ImageProperties.dominant_colors:type_name -> google.cloud.vision.v1.DominantColorsAnnotation
	48, // 27: google.cloud.vision.v1.CropHint.bounding_poly:type_name -> google.cloud.vision.v1.BoundingPoly
	17, // 28: google.cloud.vision.v1.CropHintsAnnotation.crop_hints:type_name -> google.cloud.vision.v1.CropHint
	13, // 29: google.cloud.vision.v1.ImageContext.lat_long_rect:type_name -> google.cloud.vision.v1.LatLongRect
	19, // 30: google.cloud.vision.v1.ImageContext.crop_hints_params:type_name -> google.cloud.vision.v1.CropHintsParams
	51, // 31: google.cloud.vision.v1.ImageContext.product_search_params:type_name -> google.cloud.vision.v1.ProductSearchParams
	20, // 32: google.cloud.vision.v1.ImageContext.web_detection_params:type_name -> google.cloud.vision.v1.WebDetectionParams
	21, // 33: google.cloud.vision.v1.ImageContext.text_detection_params:type_name -> google.cloud.vision.v1.TextDetectionParams
	6,  // 34: google.cloud.vision.v1.AnnotateImageRequest.image:type_name -> google.cloud.vision.v1.Image
	4,  // 35: google.cloud.vision.v1.AnnotateImageRequest.features:type_name -> google.cloud.vision.v1.Feature
	22, // 36: google.cloud.vision.v1.AnnotateImageRequest.image_context:type_name -> google.cloud.vision.v1.ImageContext
	7,  // 37: google.cloud.vision.v1.AnnotateImageResponse.face_annotations:type_name -> google.cloud.vision.v1.FaceAnnotation
	10, // 38: google.cloud.vision.v1.AnnotateImageResponse.landmark_annotations:type_name -> google.cloud.vision.v1.EntityAnnotation
	10, // 39: google.cloud.vision.v1.AnnotateImageResponse.logo_annotations:type_name -> google.cloud.vision.v1.EntityAnnotation
	10, // 40: google.cloud.vision.v1.AnnotateImageResponse.label_annotations:type_name -> google.cloud.vision.v1.EntityAnnotation
	11, // 41: google.cloud.vision.v1.AnnotateImageResponse.localized_object_annotations:type_name -> google.cloud.vision.v1.LocalizedObjectAnnotation
	10, // 42: google.cloud.vision.v1.AnnotateImageResponse.text_annotations:type_name -> google.cloud.vision.v1.EntityAnnotation
	52, // 43: google.cloud.vision.v1.AnnotateImageResponse.full_text_annotation:type_name -> google.cloud.vision.v1.TextAnnotation
	12, // 44: google.cloud.vision.v1.AnnotateImageResponse.safe_search_annotation:type_name -> google.cloud.vision.v1.SafeSearchAnnotation
	16, // 45: google.cloud.vision.v1.AnnotateImageResponse.image_properties_annotation:type_name -> google.cloud.vision.v1.ImageProperties
	18, // 46: google.cloud.vision.v1.AnnotateImageResponse.crop_hints_annotation:type_name -> google.cloud.vision.v1.CropHintsAnnotation
	53, // 47: google.cloud.vision.v1.AnnotateImageResponse.web_detection:type_name -> google.cloud.vision.v1.WebDetection
	54, // 48: google.cloud.vision.v1.AnnotateImageResponse.product_search_results:type_name -> google.cloud.vision.v1.ProductSearchResults
	55, // 49: google.cloud.vision.v1.AnnotateImageResponse.error:type_name -> google.rpc.Status
	24, // 50: google.cloud.vision.v1.AnnotateImageResponse.context:type_name -> google.cloud.vision.v1.ImageAnnotationContext
	23, // 51: google.cloud.vision.v1.BatchAnnotateImagesRequest.requests:type_name -> google.cloud.vision.v1.AnnotateImageRequest
	44, // 52: google.cloud.vision.v1.BatchAnnotateImagesRequest.labels:type_name -> google.cloud.vision.v1.BatchAnnotateImagesRequest.LabelsEntry
	25, // 53: google.cloud.vision.v1.BatchAnnotateImagesResponse.responses:type_name -> google.cloud.vision.v1.AnnotateImageResponse
	38, // 54: google.cloud.vision.v1.AnnotateFileRequest.input_config:type_name -> google.cloud.vision.v1.InputConfig
	4,  // 55: google.cloud.vision.v1.AnnotateFileRequest.features:type_name -> google.cloud.vision.v1.Feature
	22, // 56: google.cloud.vision.v1.AnnotateFileRequest.image_context:type_name -> google.cloud.vision.v1.ImageContext
	38, // 57: google.cloud.vision.v1.AnnotateFileResponse.input_config:type_name -> google.cloud.vision.v1.InputConfig
	25, // 58: google.cloud.vision.v1.AnnotateFileResponse.responses:type_name -> google.cloud.vision.v1.AnnotateImageResponse
	55, // 59: google.cloud.vision.v1.AnnotateFileResponse.error:type_name -> google.rpc.Status
	28, // 60: google.cloud.vision.v1.BatchAnnotateFilesRequest.requests:type_name -> google.cloud.vision.v1.AnnotateFileRequest
	45, // 61: google.cloud.vision.v1.BatchAnnotateFilesRequest.labels:type_name -> google.cloud.vision.v1.BatchAnnotateFilesRequest.LabelsEntry
	29, // 62: google.cloud.vision.v1.BatchAnnotateFilesResponse.responses:type_name -> google.cloud.vision.v1.AnnotateFileResponse
	38, // 63: google.cloud.vision.v1.AsyncAnnotateFileRequest.input_config:type_name -> google.cloud.vision.v1.InputConfig
	4,  // 64: google.cloud.vision.v1.AsyncAnnotateFileRequest.features:type_name -> google.cloud.vision.v1.Feature
	22, // 65: google.cloud.vision.v1.AsyncAnnotateFileRequest.image_context:type_name -> google.cloud.vision.v1.ImageContext
	39, // 66: google.cloud.vision.v1.AsyncAnnotateFileRequest.output_config:type_name -> google.cloud.vision.v1.OutputConfig
	39, // 67: google.cloud.vision.v1.AsyncAnnotateFileResponse.output_config:type_name -> google.cloud.vision.v1.OutputConfig
	23, // 68: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.requests:type_name -> google.cloud.vision.v1.AnnotateImageRequest
	39, // 69: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.output_config:type_name -> google.cloud.vision.v1.OutputConfig
	46, // 70: google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.labels:type_name -> google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest.LabelsEntry
	39, // 71: google.cloud.vision.v1.AsyncBatchAnnotateImagesResponse.output_config:type_name -> google.cloud.vision.v1.OutputConfig
	32, // 72: google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.requests:type_name -> google.cloud.vision.v1.AsyncAnnotateFileRequest
	47, // 73: google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.labels:type_name -> google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest.LabelsEntry
	33, // 74: google.cloud.vision.v1.AsyncBatchAnnotateFilesResponse.responses:type_name -> google.cloud.vision.v1.AsyncAnnotateFileResponse
	40, // 75: google.cloud.vision.v1.InputConfig.gcs_source:type_name -> google.cloud.vision.v1.GcsSource
	41, // 76: google.cloud.vision.v1.OutputConfig.gcs_destination:type_name -> google.cloud.vision.v1.GcsDestination
	3,  // 77: google.cloud.vision.v1.OperationMetadata.state:type_name -> google.cloud.vision.v1.OperationMetadata.State
	56, // 78: google.cloud.vision.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	56, // 79: google.cloud.vision.v1.OperationMetadata.update_time:type_name -> google.protobuf.Timestamp
	2,  // 80: google.cloud.vision.v1.FaceAnnotation.Landmark.type:type_name -> google.cloud.vision.v1.FaceAnnotation.Landmark.Type
	57, // 81: google.cloud.vision.v1.FaceAnnotation.Landmark.position:type_name -> google.cloud.vision.v1.Position
	26, // 82: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateImages:input_type -> google.cloud.vision.v1.BatchAnnotateImagesRequest
	30, // 83: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateFiles:input_type -> google.cloud.vision.v1.BatchAnnotateFilesRequest
	34, // 84: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateImages:input_type -> google.cloud.vision.v1.AsyncBatchAnnotateImagesRequest
	36, // 85: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateFiles:input_type -> google.cloud.vision.v1.AsyncBatchAnnotateFilesRequest
	27, // 86: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateImages:output_type -> google.cloud.vision.v1.BatchAnnotateImagesResponse
	31, // 87: google.cloud.vision.v1.ImageAnnotator.BatchAnnotateFiles:output_type -> google.cloud.vision.v1.BatchAnnotateFilesResponse
	58, // 88: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateImages:output_type -> google.longrunning.Operation
	58, // 89: google.cloud.vision.v1.ImageAnnotator.AsyncBatchAnnotateFiles:output_type -> google.longrunning.Operation
	86, // [86:90] is the sub-list for method output_type
	82, // [82:86] is the sub-list for method input_type
	82, // [82:82] is the sub-list for extension type_name
	82, // [82:82] is the sub-list for extension extendee
	0,  // [0:82] is the sub-list for field type_name
}

func init() { file_google_cloud_vision_v1_image_annotator_proto_init() }
func file_google_cloud_vision_v1_image_annotator_proto_init() {
	if File_google_cloud_vision_v1_image_annotator_proto != nil {
		return
	}
	file_google_cloud_vision_v1_geometry_proto_init()
	file_google_cloud_vision_v1_product_search_proto_init()
	file_google_cloud_vision_v1_text_annotation_proto_init()
	file_google_cloud_vision_v1_web_detection_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_vision_v1_image_annotator_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_vision_v1_image_annotator_proto_goTypes,
		DependencyIndexes: file_google_cloud_vision_v1_image_annotator_proto_depIdxs,
		EnumInfos:         file_google_cloud_vision_v1_image_annotator_proto_enumTypes,
		MessageInfos:      file_google_cloud_vision_v1_image_annotator_proto_msgTypes,
	}.Build()
	File_google_cloud_vision_v1_image_annotator_proto = out.File
	file_google_cloud_vision_v1_image_annotator_proto_rawDesc = nil
	file_google_cloud_vision_v1_image_annotator_proto_goTypes = nil
	file_google_cloud_vision_v1_image_annotator_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ImageAnnotatorClient is the client API for ImageAnnotator service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ImageAnnotatorClient interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type imageAnnotatorClient struct {
	cc grpc.ClientConnInterface
}

func NewImageAnnotatorClient(cc grpc.ClientConnInterface) ImageAnnotatorClient {
	return &imageAnnotatorClient{cc}
}

func (c *imageAnnotatorClient) BatchAnnotateImages(ctx context.Context, in *BatchAnnotateImagesRequest, opts ...grpc.CallOption) (*BatchAnnotateImagesResponse, error) {
	out := new(BatchAnnotateImagesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) BatchAnnotateFiles(ctx context.Context, in *BatchAnnotateFilesRequest, opts ...grpc.CallOption) (*BatchAnnotateFilesResponse, error) {
	out := new(BatchAnnotateFilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateImages(ctx context.Context, in *AsyncBatchAnnotateImagesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateImages", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imageAnnotatorClient) AsyncBatchAnnotateFiles(ctx context.Context, in *AsyncBatchAnnotateFilesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateFiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageAnnotatorServer is the server API for ImageAnnotator service.
type ImageAnnotatorServer interface {
	// Run image detection and annotation for a batch of images.
	BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error)
	// Service that performs image detection and annotation for a batch of files.
	// Now only "application/pdf", "image/tiff" and "image/gif" are supported.
	//
	// This service will extract at most 5 (customers can specify which 5 in
	// AnnotateFileRequest.pages) frames (gif) or pages (pdf or tiff) from each
	// file provided and perform detection and annotation for each image
	// extracted.
	BatchAnnotateFiles(context.Context, *BatchAnnotateFilesRequest) (*BatchAnnotateFilesResponse, error)
	// Run asynchronous image detection and annotation for a list of images.
	//
	// Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateImagesResponse` (results).
	//
	// This service will write image annotation outputs to json files in customer
	// GCS bucket, each json file containing BatchAnnotateImagesResponse proto.
	AsyncBatchAnnotateImages(context.Context, *AsyncBatchAnnotateImagesRequest) (*longrunningpb.Operation, error)
	// Run asynchronous image detection and annotation for a list of generic
	// files, such as PDF files, which may contain multiple pages and multiple
	// images per page. Progress and results can be retrieved through the
	// `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `OperationMetadata` (metadata).
	// `Operation.response` contains `AsyncBatchAnnotateFilesResponse` (results).
	AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedImageAnnotatorServer can be embedded to have forward compatible implementations.
type UnimplementedImageAnnotatorServer struct {
}

func (*UnimplementedImageAnnotatorServer) BatchAnnotateImages(context.Context, *BatchAnnotateImagesRequest) (*BatchAnnotateImagesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchAnnotateImages not implemented")
}
func (*UnimplementedImageAnnotatorServer) BatchAnnotateFiles(context.Context, *BatchAnnotateFilesRequest) (*BatchAnnotateFilesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchAnnotateFiles not implemented")
}
func (*UnimplementedImageAnnotatorServer) AsyncBatchAnnotateImages(context.Context, *AsyncBatchAnnotateImagesRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AsyncBatchAnnotateImages not implemented")
}
func (*UnimplementedImageAnnotatorServer) AsyncBatchAnnotateFiles(context.Context, *AsyncBatchAnnotateFilesRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AsyncBatchAnnotateFiles not implemented")
}

func RegisterImageAnnotatorServer(s *grpc.Server, srv ImageAnnotatorServer) {
	s.RegisterService(&_ImageAnnotator_serviceDesc, srv)
}

func _ImageAnnotator_BatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateImages(ctx, req.(*BatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_BatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/BatchAnnotateFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).BatchAnnotateFiles(ctx, req.(*BatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateImages",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateImages(ctx, req.(*AsyncBatchAnnotateImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ImageAnnotator_AsyncBatchAnnotateFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncBatchAnnotateFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.vision.v1.ImageAnnotator/AsyncBatchAnnotateFiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageAnnotatorServer).AsyncBatchAnnotateFiles(ctx, req.(*AsyncBatchAnnotateFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ImageAnnotator_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vision.v1.ImageAnnotator",
	HandlerType: (*ImageAnnotatorServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "BatchAnnotateImages",
			Handler:    _ImageAnnotator_BatchAnnotateImages_Handler,
		},
		{
			MethodName: "BatchAnnotateFiles",
			Handler:    _ImageAnnotator_BatchAnnotateFiles_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateImages",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateImages_Handler,
		},
		{
			MethodName: "AsyncBatchAnnotateFiles",
			Handler:    _ImageAnnotator_AsyncBatchAnnotateFiles_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vision/v1/image_annotator.proto",
}
