// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: buf/validate/conformance/harness/harness.proto

//go:build !protoopaque

package harness

import (
	validate "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TestConformanceRequest is the request for Conformance Tests.
// The FileDescriptorSet is the FileDescriptorSet to test against.
// The cases map is a map of case name to the Any message that represents the case.
type TestConformanceRequest struct {
	state         protoimpl.MessageState          `protogen:"hybrid.v1"`
	Fdset         *descriptorpb.FileDescriptorSet `protobuf:"bytes,2,opt,name=fdset,proto3" json:"fdset,omitempty"`
	Cases         map[string]*anypb.Any           `protobuf:"bytes,3,rep,name=cases,proto3" json:"cases,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestConformanceRequest) Reset() {
	*x = TestConformanceRequest{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestConformanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestConformanceRequest) ProtoMessage() {}

func (x *TestConformanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestConformanceRequest) GetFdset() *descriptorpb.FileDescriptorSet {
	if x != nil {
		return x.Fdset
	}
	return nil
}

func (x *TestConformanceRequest) GetCases() map[string]*anypb.Any {
	if x != nil {
		return x.Cases
	}
	return nil
}

func (x *TestConformanceRequest) SetFdset(v *descriptorpb.FileDescriptorSet) {
	x.Fdset = v
}

func (x *TestConformanceRequest) SetCases(v map[string]*anypb.Any) {
	x.Cases = v
}

func (x *TestConformanceRequest) HasFdset() bool {
	if x == nil {
		return false
	}
	return x.Fdset != nil
}

func (x *TestConformanceRequest) ClearFdset() {
	x.Fdset = nil
}

type TestConformanceRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Fdset *descriptorpb.FileDescriptorSet
	Cases map[string]*anypb.Any
}

func (b0 TestConformanceRequest_builder) Build() *TestConformanceRequest {
	m0 := &TestConformanceRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.Fdset = b.Fdset
	x.Cases = b.Cases
	return m0
}

// TestConformanceResponse is the response for Conformance Tests.
// The results map is a map of case name to the TestResult.
type TestConformanceResponse struct {
	state         protoimpl.MessageState `protogen:"hybrid.v1"`
	Results       map[string]*TestResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestConformanceResponse) Reset() {
	*x = TestConformanceResponse{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestConformanceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestConformanceResponse) ProtoMessage() {}

func (x *TestConformanceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestConformanceResponse) GetResults() map[string]*TestResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *TestConformanceResponse) SetResults(v map[string]*TestResult) {
	x.Results = v
}

type TestConformanceResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Results map[string]*TestResult
}

func (b0 TestConformanceResponse_builder) Build() *TestConformanceResponse {
	m0 := &TestConformanceResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.Results = b.Results
	return m0
}

// TestResult is the result of a single test. Only one of the fields will be set.
type TestResult struct {
	state protoimpl.MessageState `protogen:"hybrid.v1"`
	// Types that are valid to be assigned to Result:
	//
	//	*TestResult_Success
	//	*TestResult_ValidationError
	//	*TestResult_CompilationError
	//	*TestResult_RuntimeError
	//	*TestResult_UnexpectedError
	Result        isTestResult_Result `protobuf_oneof:"result"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestResult) Reset() {
	*x = TestResult{}
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestResult) ProtoMessage() {}

func (x *TestResult) ProtoReflect() protoreflect.Message {
	mi := &file_buf_validate_conformance_harness_harness_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TestResult) GetResult() isTestResult_Result {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *TestResult) GetSuccess() bool {
	if x != nil {
		if x, ok := x.Result.(*TestResult_Success); ok {
			return x.Success
		}
	}
	return false
}

func (x *TestResult) GetValidationError() *validate.Violations {
	if x != nil {
		if x, ok := x.Result.(*TestResult_ValidationError); ok {
			return x.ValidationError
		}
	}
	return nil
}

func (x *TestResult) GetCompilationError() string {
	if x != nil {
		if x, ok := x.Result.(*TestResult_CompilationError); ok {
			return x.CompilationError
		}
	}
	return ""
}

func (x *TestResult) GetRuntimeError() string {
	if x != nil {
		if x, ok := x.Result.(*TestResult_RuntimeError); ok {
			return x.RuntimeError
		}
	}
	return ""
}

func (x *TestResult) GetUnexpectedError() string {
	if x != nil {
		if x, ok := x.Result.(*TestResult_UnexpectedError); ok {
			return x.UnexpectedError
		}
	}
	return ""
}

func (x *TestResult) SetSuccess(v bool) {
	x.Result = &TestResult_Success{v}
}

func (x *TestResult) SetValidationError(v *validate.Violations) {
	if v == nil {
		x.Result = nil
		return
	}
	x.Result = &TestResult_ValidationError{v}
}

func (x *TestResult) SetCompilationError(v string) {
	x.Result = &TestResult_CompilationError{v}
}

func (x *TestResult) SetRuntimeError(v string) {
	x.Result = &TestResult_RuntimeError{v}
}

func (x *TestResult) SetUnexpectedError(v string) {
	x.Result = &TestResult_UnexpectedError{v}
}

func (x *TestResult) HasResult() bool {
	if x == nil {
		return false
	}
	return x.Result != nil
}

func (x *TestResult) HasSuccess() bool {
	if x == nil {
		return false
	}
	_, ok := x.Result.(*TestResult_Success)
	return ok
}

func (x *TestResult) HasValidationError() bool {
	if x == nil {
		return false
	}
	_, ok := x.Result.(*TestResult_ValidationError)
	return ok
}

func (x *TestResult) HasCompilationError() bool {
	if x == nil {
		return false
	}
	_, ok := x.Result.(*TestResult_CompilationError)
	return ok
}

func (x *TestResult) HasRuntimeError() bool {
	if x == nil {
		return false
	}
	_, ok := x.Result.(*TestResult_RuntimeError)
	return ok
}

func (x *TestResult) HasUnexpectedError() bool {
	if x == nil {
		return false
	}
	_, ok := x.Result.(*TestResult_UnexpectedError)
	return ok
}

func (x *TestResult) ClearResult() {
	x.Result = nil
}

func (x *TestResult) ClearSuccess() {
	if _, ok := x.Result.(*TestResult_Success); ok {
		x.Result = nil
	}
}

func (x *TestResult) ClearValidationError() {
	if _, ok := x.Result.(*TestResult_ValidationError); ok {
		x.Result = nil
	}
}

func (x *TestResult) ClearCompilationError() {
	if _, ok := x.Result.(*TestResult_CompilationError); ok {
		x.Result = nil
	}
}

func (x *TestResult) ClearRuntimeError() {
	if _, ok := x.Result.(*TestResult_RuntimeError); ok {
		x.Result = nil
	}
}

func (x *TestResult) ClearUnexpectedError() {
	if _, ok := x.Result.(*TestResult_UnexpectedError); ok {
		x.Result = nil
	}
}

const TestResult_Result_not_set_case case_TestResult_Result = 0
const TestResult_Success_case case_TestResult_Result = 1
const TestResult_ValidationError_case case_TestResult_Result = 2
const TestResult_CompilationError_case case_TestResult_Result = 3
const TestResult_RuntimeError_case case_TestResult_Result = 4
const TestResult_UnexpectedError_case case_TestResult_Result = 5

func (x *TestResult) WhichResult() case_TestResult_Result {
	if x == nil {
		return TestResult_Result_not_set_case
	}
	switch x.Result.(type) {
	case *TestResult_Success:
		return TestResult_Success_case
	case *TestResult_ValidationError:
		return TestResult_ValidationError_case
	case *TestResult_CompilationError:
		return TestResult_CompilationError_case
	case *TestResult_RuntimeError:
		return TestResult_RuntimeError_case
	case *TestResult_UnexpectedError:
		return TestResult_UnexpectedError_case
	default:
		return TestResult_Result_not_set_case
	}
}

type TestResult_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof Result:
	// success is true if the test succeeded.
	Success *bool
	// validation_error is the error if the test failed due to validation errors.
	ValidationError *validate.Violations
	// compilation_error is the error if the test failed due to compilation errors.
	CompilationError *string
	// runtime_error is the error if the test failed due to runtime errors.
	RuntimeError *string
	// unexpected_error is any other error that may have occurred.
	UnexpectedError *string
	// -- end of Result
}

func (b0 TestResult_builder) Build() *TestResult {
	m0 := &TestResult{}
	b, x := &b0, m0
	_, _ = b, x
	if b.Success != nil {
		x.Result = &TestResult_Success{*b.Success}
	}
	if b.ValidationError != nil {
		x.Result = &TestResult_ValidationError{b.ValidationError}
	}
	if b.CompilationError != nil {
		x.Result = &TestResult_CompilationError{*b.CompilationError}
	}
	if b.RuntimeError != nil {
		x.Result = &TestResult_RuntimeError{*b.RuntimeError}
	}
	if b.UnexpectedError != nil {
		x.Result = &TestResult_UnexpectedError{*b.UnexpectedError}
	}
	return m0
}

type case_TestResult_Result protoreflect.FieldNumber

func (x case_TestResult_Result) String() string {
	md := file_buf_validate_conformance_harness_harness_proto_msgTypes[2].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isTestResult_Result interface {
	isTestResult_Result()
}

type TestResult_Success struct {
	// success is true if the test succeeded.
	Success bool `protobuf:"varint,1,opt,name=success,proto3,oneof"`
}

type TestResult_ValidationError struct {
	// validation_error is the error if the test failed due to validation errors.
	ValidationError *validate.Violations `protobuf:"bytes,2,opt,name=validation_error,json=validationError,proto3,oneof"`
}

type TestResult_CompilationError struct {
	// compilation_error is the error if the test failed due to compilation errors.
	CompilationError string `protobuf:"bytes,3,opt,name=compilation_error,json=compilationError,proto3,oneof"`
}

type TestResult_RuntimeError struct {
	// runtime_error is the error if the test failed due to runtime errors.
	RuntimeError string `protobuf:"bytes,4,opt,name=runtime_error,json=runtimeError,proto3,oneof"`
}

type TestResult_UnexpectedError struct {
	// unexpected_error is any other error that may have occurred.
	UnexpectedError string `protobuf:"bytes,5,opt,name=unexpected_error,json=unexpectedError,proto3,oneof"`
}

func (*TestResult_Success) isTestResult_Result() {}

func (*TestResult_ValidationError) isTestResult_Result() {}

func (*TestResult_CompilationError) isTestResult_Result() {}

func (*TestResult_RuntimeError) isTestResult_Result() {}

func (*TestResult_UnexpectedError) isTestResult_Result() {}

var File_buf_validate_conformance_harness_harness_proto protoreflect.FileDescriptor

const file_buf_validate_conformance_harness_harness_proto_rawDesc = "" +
	"\n" +
	".buf/validate/conformance/harness/harness.proto\x12 buf.validate.conformance.harness\x1a\x1bbuf/validate/validate.proto\x1a\x19google/protobuf/any.proto\x1a google/protobuf/descriptor.proto\"\xfd\x01\n" +
	"\x16TestConformanceRequest\x128\n" +
	"\x05fdset\x18\x02 \x01(\v2\".google.protobuf.FileDescriptorSetR\x05fdset\x12Y\n" +
	"\x05cases\x18\x03 \x03(\v2C.buf.validate.conformance.harness.TestConformanceRequest.CasesEntryR\x05cases\x1aN\n" +
	"\n" +
	"CasesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12*\n" +
	"\x05value\x18\x02 \x01(\v2\x14.google.protobuf.AnyR\x05value:\x028\x01\"\xe5\x01\n" +
	"\x17TestConformanceResponse\x12`\n" +
	"\aresults\x18\x01 \x03(\v2F.buf.validate.conformance.harness.TestConformanceResponse.ResultsEntryR\aresults\x1ah\n" +
	"\fResultsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12B\n" +
	"\x05value\x18\x02 \x01(\v2,.buf.validate.conformance.harness.TestResultR\x05value:\x028\x01\"\xfc\x01\n" +
	"\n" +
	"TestResult\x12\x1a\n" +
	"\asuccess\x18\x01 \x01(\bH\x00R\asuccess\x12E\n" +
	"\x10validation_error\x18\x02 \x01(\v2\x18.buf.validate.ViolationsH\x00R\x0fvalidationError\x12-\n" +
	"\x11compilation_error\x18\x03 \x01(\tH\x00R\x10compilationError\x12%\n" +
	"\rruntime_error\x18\x04 \x01(\tH\x00R\fruntimeError\x12+\n" +
	"\x10unexpected_error\x18\x05 \x01(\tH\x00R\x0funexpectedErrorB\b\n" +
	"\x06resultB\xa2\x02\n" +
	"$com.buf.validate.conformance.harnessB\fHarnessProtoP\x01ZHbuf.build/go/protovalidate/internal/gen/buf/validate/conformance/harness\xa2\x02\x04BVCH\xaa\x02 Buf.Validate.Conformance.Harness\xca\x02 Buf\\Validate\\Conformance\\Harness\xe2\x02,Buf\\Validate\\Conformance\\Harness\\GPBMetadata\xea\x02#Buf::Validate::Conformance::Harnessb\x06proto3"

var file_buf_validate_conformance_harness_harness_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_buf_validate_conformance_harness_harness_proto_goTypes = []any{
	(*TestConformanceRequest)(nil),         // 0: buf.validate.conformance.harness.TestConformanceRequest
	(*TestConformanceResponse)(nil),        // 1: buf.validate.conformance.harness.TestConformanceResponse
	(*TestResult)(nil),                     // 2: buf.validate.conformance.harness.TestResult
	nil,                                    // 3: buf.validate.conformance.harness.TestConformanceRequest.CasesEntry
	nil,                                    // 4: buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry
	(*descriptorpb.FileDescriptorSet)(nil), // 5: google.protobuf.FileDescriptorSet
	(*validate.Violations)(nil),            // 6: buf.validate.Violations
	(*anypb.Any)(nil),                      // 7: google.protobuf.Any
}
var file_buf_validate_conformance_harness_harness_proto_depIdxs = []int32{
	5, // 0: buf.validate.conformance.harness.TestConformanceRequest.fdset:type_name -> google.protobuf.FileDescriptorSet
	3, // 1: buf.validate.conformance.harness.TestConformanceRequest.cases:type_name -> buf.validate.conformance.harness.TestConformanceRequest.CasesEntry
	4, // 2: buf.validate.conformance.harness.TestConformanceResponse.results:type_name -> buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry
	6, // 3: buf.validate.conformance.harness.TestResult.validation_error:type_name -> buf.validate.Violations
	7, // 4: buf.validate.conformance.harness.TestConformanceRequest.CasesEntry.value:type_name -> google.protobuf.Any
	2, // 5: buf.validate.conformance.harness.TestConformanceResponse.ResultsEntry.value:type_name -> buf.validate.conformance.harness.TestResult
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_buf_validate_conformance_harness_harness_proto_init() }
func file_buf_validate_conformance_harness_harness_proto_init() {
	if File_buf_validate_conformance_harness_harness_proto != nil {
		return
	}
	file_buf_validate_conformance_harness_harness_proto_msgTypes[2].OneofWrappers = []any{
		(*TestResult_Success)(nil),
		(*TestResult_ValidationError)(nil),
		(*TestResult_CompilationError)(nil),
		(*TestResult_RuntimeError)(nil),
		(*TestResult_UnexpectedError)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_validate_conformance_harness_harness_proto_rawDesc), len(file_buf_validate_conformance_harness_harness_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_validate_conformance_harness_harness_proto_goTypes,
		DependencyIndexes: file_buf_validate_conformance_harness_harness_proto_depIdxs,
		MessageInfos:      file_buf_validate_conformance_harness_harness_proto_msgTypes,
	}.Build()
	File_buf_validate_conformance_harness_harness_proto = out.File
	file_buf_validate_conformance_harness_harness_proto_goTypes = nil
	file_buf_validate_conformance_harness_harness_proto_depIdxs = nil
}
