package customerlockboxapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/customerlockbox/mgmt/2018-02-28-preview/customerlockbox"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result customerlockbox.OperationListResultPage, err error)
}

var _ OperationsClientAPI = (*customerlockbox.OperationsClient)(nil)

// RequestsClientAPI contains the set of methods on the RequestsClient type.
type RequestsClientAPI interface {
	Get(ctx context.Context, requestID string, subscriptionID string) (result customerlockbox.LockboxRequestResponse, err error)
	List(ctx context.Context, subscriptionID string, filter string) (result customerlockbox.RequestListResultPage, err error)
	UpdateStatus(ctx context.Context, approval customerlockbox.Approval, subscriptionID string, requestID string) (result customerlockbox.Approval, err error)
}

var _ RequestsClientAPI = (*customerlockbox.RequestsClient)(nil)
