package trafficmanagerapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/trafficmanager/mgmt/2015-11-01/trafficmanager"
	"github.com/Azure/go-autorest/autorest"
)

// EndpointsClientAPI contains the set of methods on the EndpointsClient type.
type EndpointsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string, parameters trafficmanager.Endpoint) (result trafficmanager.Endpoint, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string) (result trafficmanager.Endpoint, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string, parameters trafficmanager.Endpoint) (result trafficmanager.Endpoint, err error)
}

var _ EndpointsClientAPI = (*trafficmanager.EndpointsClient)(nil)

// ProfilesClientAPI contains the set of methods on the ProfilesClient type.
type ProfilesClientAPI interface {
	CheckTrafficManagerRelativeDNSNameAvailability(ctx context.Context, parameters trafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters) (result trafficmanager.NameAvailability, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, profileName string, parameters trafficmanager.Profile) (result trafficmanager.Profile, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string) (result trafficmanager.Profile, err error)
	ListAll(ctx context.Context) (result trafficmanager.ProfileListResult, err error)
	ListAllInResourceGroup(ctx context.Context, resourceGroupName string) (result trafficmanager.ProfileListResult, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, parameters trafficmanager.Profile) (result trafficmanager.Profile, err error)
}

var _ ProfilesClientAPI = (*trafficmanager.ProfilesClient)(nil)
