// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package securityinsight

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/securityinsight/mgmt/2019-01-01-preview/securityinsight"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AlertRuleKind = original.AlertRuleKind

const (
	AlertRuleKindAnomaly                           AlertRuleKind = original.AlertRuleKindAnomaly
	AlertRuleKindFusion                            AlertRuleKind = original.AlertRuleKindFusion
	AlertRuleKindMicrosoftSecurityIncidentCreation AlertRuleKind = original.AlertRuleKindMicrosoftSecurityIncidentCreation
	AlertRuleKindMLBehaviorAnalytics               AlertRuleKind = original.AlertRuleKindMLBehaviorAnalytics
	AlertRuleKindScheduled                         AlertRuleKind = original.AlertRuleKindScheduled
	AlertRuleKindThreatIntelligence                AlertRuleKind = original.AlertRuleKindThreatIntelligence
)

type AlertSeverity = original.AlertSeverity

const (
	High          AlertSeverity = original.High
	Informational AlertSeverity = original.Informational
	Low           AlertSeverity = original.Low
	Medium        AlertSeverity = original.Medium
)

type AlertStatus = original.AlertStatus

const (
	AlertStatusDismissed  AlertStatus = original.AlertStatusDismissed
	AlertStatusInProgress AlertStatus = original.AlertStatusInProgress
	AlertStatusNew        AlertStatus = original.AlertStatusNew
	AlertStatusResolved   AlertStatus = original.AlertStatusResolved
	AlertStatusUnknown    AlertStatus = original.AlertStatusUnknown
)

type AntispamMailDirection = original.AntispamMailDirection

const (
	Inbound  AntispamMailDirection = original.Inbound
	Intraorg AntispamMailDirection = original.Intraorg
	Outbound AntispamMailDirection = original.Outbound
	Unknown  AntispamMailDirection = original.Unknown
)

type AttackTactic = original.AttackTactic

const (
	Collection          AttackTactic = original.Collection
	CommandAndControl   AttackTactic = original.CommandAndControl
	CredentialAccess    AttackTactic = original.CredentialAccess
	DefenseEvasion      AttackTactic = original.DefenseEvasion
	Discovery           AttackTactic = original.Discovery
	Execution           AttackTactic = original.Execution
	Exfiltration        AttackTactic = original.Exfiltration
	Impact              AttackTactic = original.Impact
	InitialAccess       AttackTactic = original.InitialAccess
	LateralMovement     AttackTactic = original.LateralMovement
	Persistence         AttackTactic = original.Persistence
	PreAttack           AttackTactic = original.PreAttack
	PrivilegeEscalation AttackTactic = original.PrivilegeEscalation
)

type CaseSeverity = original.CaseSeverity

const (
	CaseSeverityCritical      CaseSeverity = original.CaseSeverityCritical
	CaseSeverityHigh          CaseSeverity = original.CaseSeverityHigh
	CaseSeverityInformational CaseSeverity = original.CaseSeverityInformational
	CaseSeverityLow           CaseSeverity = original.CaseSeverityLow
	CaseSeverityMedium        CaseSeverity = original.CaseSeverityMedium
)

type CaseStatus = original.CaseStatus

const (
	CaseStatusClosed     CaseStatus = original.CaseStatusClosed
	CaseStatusDraft      CaseStatus = original.CaseStatusDraft
	CaseStatusInProgress CaseStatus = original.CaseStatusInProgress
	CaseStatusNew        CaseStatus = original.CaseStatusNew
)

type CloseReason = original.CloseReason

const (
	Dismissed     CloseReason = original.Dismissed
	FalsePositive CloseReason = original.FalsePositive
	Other         CloseReason = original.Other
	Resolved      CloseReason = original.Resolved
	TruePositive  CloseReason = original.TruePositive
)

type ConfidenceLevel = original.ConfidenceLevel

const (
	ConfidenceLevelHigh    ConfidenceLevel = original.ConfidenceLevelHigh
	ConfidenceLevelLow     ConfidenceLevel = original.ConfidenceLevelLow
	ConfidenceLevelUnknown ConfidenceLevel = original.ConfidenceLevelUnknown
)

type ConfidenceScoreStatus = original.ConfidenceScoreStatus

const (
	Final         ConfidenceScoreStatus = original.Final
	InProcess     ConfidenceScoreStatus = original.InProcess
	NotApplicable ConfidenceScoreStatus = original.NotApplicable
	NotFinal      ConfidenceScoreStatus = original.NotFinal
)

type DataConnectorAuthorizationState = original.DataConnectorAuthorizationState

const (
	Invalid DataConnectorAuthorizationState = original.Invalid
	Valid   DataConnectorAuthorizationState = original.Valid
)

type DataConnectorKind = original.DataConnectorKind

const (
	DataConnectorKindAmazonWebServicesCloudTrail               DataConnectorKind = original.DataConnectorKindAmazonWebServicesCloudTrail
	DataConnectorKindAzureActiveDirectory                      DataConnectorKind = original.DataConnectorKindAzureActiveDirectory
	DataConnectorKindAzureAdvancedThreatProtection             DataConnectorKind = original.DataConnectorKindAzureAdvancedThreatProtection
	DataConnectorKindAzureSecurityCenter                       DataConnectorKind = original.DataConnectorKindAzureSecurityCenter
	DataConnectorKindDynamics365                               DataConnectorKind = original.DataConnectorKindDynamics365
	DataConnectorKindMicrosoftCloudAppSecurity                 DataConnectorKind = original.DataConnectorKindMicrosoftCloudAppSecurity
	DataConnectorKindMicrosoftDefenderAdvancedThreatProtection DataConnectorKind = original.DataConnectorKindMicrosoftDefenderAdvancedThreatProtection
	DataConnectorKindOffice365                                 DataConnectorKind = original.DataConnectorKindOffice365
	DataConnectorKindOfficeATP                                 DataConnectorKind = original.DataConnectorKindOfficeATP
	DataConnectorKindThreatIntelligence                        DataConnectorKind = original.DataConnectorKindThreatIntelligence
	DataConnectorKindThreatIntelligenceTaxii                   DataConnectorKind = original.DataConnectorKindThreatIntelligenceTaxii
)

type DataConnectorLicenseState = original.DataConnectorLicenseState

const (
	DataConnectorLicenseStateInvalid DataConnectorLicenseState = original.DataConnectorLicenseStateInvalid
	DataConnectorLicenseStateUnknown DataConnectorLicenseState = original.DataConnectorLicenseStateUnknown
	DataConnectorLicenseStateValid   DataConnectorLicenseState = original.DataConnectorLicenseStateValid
)

type DataTypeState = original.DataTypeState

const (
	Disabled DataTypeState = original.Disabled
	Enabled  DataTypeState = original.Enabled
)

type DeliveryAction = original.DeliveryAction

const (
	DeliveryActionBlocked         DeliveryAction = original.DeliveryActionBlocked
	DeliveryActionDelivered       DeliveryAction = original.DeliveryActionDelivered
	DeliveryActionDeliveredAsSpam DeliveryAction = original.DeliveryActionDeliveredAsSpam
	DeliveryActionReplaced        DeliveryAction = original.DeliveryActionReplaced
	DeliveryActionUnknown         DeliveryAction = original.DeliveryActionUnknown
)

type DeliveryLocation = original.DeliveryLocation

const (
	DeliveryLocationDeletedFolder DeliveryLocation = original.DeliveryLocationDeletedFolder
	DeliveryLocationDropped       DeliveryLocation = original.DeliveryLocationDropped
	DeliveryLocationExternal      DeliveryLocation = original.DeliveryLocationExternal
	DeliveryLocationFailed        DeliveryLocation = original.DeliveryLocationFailed
	DeliveryLocationForwarded     DeliveryLocation = original.DeliveryLocationForwarded
	DeliveryLocationInbox         DeliveryLocation = original.DeliveryLocationInbox
	DeliveryLocationJunkFolder    DeliveryLocation = original.DeliveryLocationJunkFolder
	DeliveryLocationQuarantine    DeliveryLocation = original.DeliveryLocationQuarantine
	DeliveryLocationUnknown       DeliveryLocation = original.DeliveryLocationUnknown
)

type ElevationToken = original.ElevationToken

const (
	Default ElevationToken = original.Default
	Full    ElevationToken = original.Full
	Limited ElevationToken = original.Limited
)

type EntitiesMatchingMethod = original.EntitiesMatchingMethod

const (
	All    EntitiesMatchingMethod = original.All
	Custom EntitiesMatchingMethod = original.Custom
	None   EntitiesMatchingMethod = original.None
)

type EntityKind = original.EntityKind

const (
	EntityKindAccount          EntityKind = original.EntityKindAccount
	EntityKindAzureResource    EntityKind = original.EntityKindAzureResource
	EntityKindBookmark         EntityKind = original.EntityKindBookmark
	EntityKindCloudApplication EntityKind = original.EntityKindCloudApplication
	EntityKindDNSResolution    EntityKind = original.EntityKindDNSResolution
	EntityKindFile             EntityKind = original.EntityKindFile
	EntityKindFileHash         EntityKind = original.EntityKindFileHash
	EntityKindHost             EntityKind = original.EntityKindHost
	EntityKindIoTDevice        EntityKind = original.EntityKindIoTDevice
	EntityKindIP               EntityKind = original.EntityKindIP
	EntityKindMailbox          EntityKind = original.EntityKindMailbox
	EntityKindMailCluster      EntityKind = original.EntityKindMailCluster
	EntityKindMailMessage      EntityKind = original.EntityKindMailMessage
	EntityKindMalware          EntityKind = original.EntityKindMalware
	EntityKindProcess          EntityKind = original.EntityKindProcess
	EntityKindRegistryKey      EntityKind = original.EntityKindRegistryKey
	EntityKindRegistryValue    EntityKind = original.EntityKindRegistryValue
	EntityKindSecurityAlert    EntityKind = original.EntityKindSecurityAlert
	EntityKindSecurityGroup    EntityKind = original.EntityKindSecurityGroup
	EntityKindSubmissionMail   EntityKind = original.EntityKindSubmissionMail
	EntityKindURL              EntityKind = original.EntityKindURL
)

type EntityQueryKind = original.EntityQueryKind

const (
	Expansion EntityQueryKind = original.Expansion
	Insight   EntityQueryKind = original.Insight
)

type EntityTimelineKind = original.EntityTimelineKind

const (
	EntityTimelineKindActivity      EntityTimelineKind = original.EntityTimelineKindActivity
	EntityTimelineKindBookmark      EntityTimelineKind = original.EntityTimelineKindBookmark
	EntityTimelineKindSecurityAlert EntityTimelineKind = original.EntityTimelineKindSecurityAlert
)

type EntityType = original.EntityType

const (
	EntityTypeAccount          EntityType = original.EntityTypeAccount
	EntityTypeAzureResource    EntityType = original.EntityTypeAzureResource
	EntityTypeCloudApplication EntityType = original.EntityTypeCloudApplication
	EntityTypeDNS              EntityType = original.EntityTypeDNS
	EntityTypeFile             EntityType = original.EntityTypeFile
	EntityTypeFileHash         EntityType = original.EntityTypeFileHash
	EntityTypeHost             EntityType = original.EntityTypeHost
	EntityTypeHuntingBookmark  EntityType = original.EntityTypeHuntingBookmark
	EntityTypeIoTDevice        EntityType = original.EntityTypeIoTDevice
	EntityTypeIP               EntityType = original.EntityTypeIP
	EntityTypeMailbox          EntityType = original.EntityTypeMailbox
	EntityTypeMailCluster      EntityType = original.EntityTypeMailCluster
	EntityTypeMailMessage      EntityType = original.EntityTypeMailMessage
	EntityTypeMalware          EntityType = original.EntityTypeMalware
	EntityTypeProcess          EntityType = original.EntityTypeProcess
	EntityTypeRegistryKey      EntityType = original.EntityTypeRegistryKey
	EntityTypeRegistryValue    EntityType = original.EntityTypeRegistryValue
	EntityTypeSecurityAlert    EntityType = original.EntityTypeSecurityAlert
	EntityTypeSecurityGroup    EntityType = original.EntityTypeSecurityGroup
	EntityTypeSubmissionMail   EntityType = original.EntityTypeSubmissionMail
	EntityTypeURL              EntityType = original.EntityTypeURL
)

type EventGroupingAggregationKind = original.EventGroupingAggregationKind

const (
	AlertPerResult EventGroupingAggregationKind = original.AlertPerResult
	SingleAlert    EventGroupingAggregationKind = original.SingleAlert
)

type FileHashAlgorithm = original.FileHashAlgorithm

const (
	FileHashAlgorithmMD5      FileHashAlgorithm = original.FileHashAlgorithmMD5
	FileHashAlgorithmSHA1     FileHashAlgorithm = original.FileHashAlgorithmSHA1
	FileHashAlgorithmSHA256   FileHashAlgorithm = original.FileHashAlgorithmSHA256
	FileHashAlgorithmSHA256AC FileHashAlgorithm = original.FileHashAlgorithmSHA256AC
	FileHashAlgorithmUnknown  FileHashAlgorithm = original.FileHashAlgorithmUnknown
)

type GroupingEntityType = original.GroupingEntityType

const (
	Account  GroupingEntityType = original.Account
	FileHash GroupingEntityType = original.FileHash
	Host     GroupingEntityType = original.Host
	IP       GroupingEntityType = original.IP
	URL      GroupingEntityType = original.URL
)

type IncidentClassification = original.IncidentClassification

const (
	IncidentClassificationBenignPositive IncidentClassification = original.IncidentClassificationBenignPositive
	IncidentClassificationFalsePositive  IncidentClassification = original.IncidentClassificationFalsePositive
	IncidentClassificationTruePositive   IncidentClassification = original.IncidentClassificationTruePositive
	IncidentClassificationUndetermined   IncidentClassification = original.IncidentClassificationUndetermined
)

type IncidentClassificationReason = original.IncidentClassificationReason

const (
	InaccurateData        IncidentClassificationReason = original.InaccurateData
	IncorrectAlertLogic   IncidentClassificationReason = original.IncorrectAlertLogic
	SuspiciousActivity    IncidentClassificationReason = original.SuspiciousActivity
	SuspiciousButExpected IncidentClassificationReason = original.SuspiciousButExpected
)

type IncidentLabelType = original.IncidentLabelType

const (
	System IncidentLabelType = original.System
	User   IncidentLabelType = original.User
)

type IncidentSeverity = original.IncidentSeverity

const (
	IncidentSeverityHigh          IncidentSeverity = original.IncidentSeverityHigh
	IncidentSeverityInformational IncidentSeverity = original.IncidentSeverityInformational
	IncidentSeverityLow           IncidentSeverity = original.IncidentSeverityLow
	IncidentSeverityMedium        IncidentSeverity = original.IncidentSeverityMedium
)

type IncidentStatus = original.IncidentStatus

const (
	IncidentStatusActive IncidentStatus = original.IncidentStatusActive
	IncidentStatusClosed IncidentStatus = original.IncidentStatusClosed
	IncidentStatusNew    IncidentStatus = original.IncidentStatusNew
)

type KillChainIntent = original.KillChainIntent

const (
	KillChainIntentCollection          KillChainIntent = original.KillChainIntentCollection
	KillChainIntentCommandAndControl   KillChainIntent = original.KillChainIntentCommandAndControl
	KillChainIntentCredentialAccess    KillChainIntent = original.KillChainIntentCredentialAccess
	KillChainIntentDefenseEvasion      KillChainIntent = original.KillChainIntentDefenseEvasion
	KillChainIntentDiscovery           KillChainIntent = original.KillChainIntentDiscovery
	KillChainIntentExecution           KillChainIntent = original.KillChainIntentExecution
	KillChainIntentExfiltration        KillChainIntent = original.KillChainIntentExfiltration
	KillChainIntentExploitation        KillChainIntent = original.KillChainIntentExploitation
	KillChainIntentImpact              KillChainIntent = original.KillChainIntentImpact
	KillChainIntentLateralMovement     KillChainIntent = original.KillChainIntentLateralMovement
	KillChainIntentPersistence         KillChainIntent = original.KillChainIntentPersistence
	KillChainIntentPrivilegeEscalation KillChainIntent = original.KillChainIntentPrivilegeEscalation
	KillChainIntentProbing             KillChainIntent = original.KillChainIntentProbing
	KillChainIntentUnknown             KillChainIntent = original.KillChainIntentUnknown
)

type Kind = original.Kind

const (
	KindAggregations     Kind = original.KindAggregations
	KindCasesAggregation Kind = original.KindCasesAggregation
)

type KindBasicAlertRule = original.KindBasicAlertRule

const (
	KindAlertRule                         KindBasicAlertRule = original.KindAlertRule
	KindFusion                            KindBasicAlertRule = original.KindFusion
	KindMicrosoftSecurityIncidentCreation KindBasicAlertRule = original.KindMicrosoftSecurityIncidentCreation
	KindMLBehaviorAnalytics               KindBasicAlertRule = original.KindMLBehaviorAnalytics
	KindScheduled                         KindBasicAlertRule = original.KindScheduled
)

type KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplate

const (
	KindBasicAlertRuleTemplateKindAlertRuleTemplate                 KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindAlertRuleTemplate
	KindBasicAlertRuleTemplateKindFusion                            KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindFusion
	KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindMicrosoftSecurityIncidentCreation
	KindBasicAlertRuleTemplateKindMLBehaviorAnalytics               KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindMLBehaviorAnalytics
	KindBasicAlertRuleTemplateKindScheduled                         KindBasicAlertRuleTemplate = original.KindBasicAlertRuleTemplateKindScheduled
)

type KindBasicDataConnector = original.KindBasicDataConnector

const (
	KindAmazonWebServicesCloudTrail               KindBasicDataConnector = original.KindAmazonWebServicesCloudTrail
	KindAzureActiveDirectory                      KindBasicDataConnector = original.KindAzureActiveDirectory
	KindAzureAdvancedThreatProtection             KindBasicDataConnector = original.KindAzureAdvancedThreatProtection
	KindAzureSecurityCenter                       KindBasicDataConnector = original.KindAzureSecurityCenter
	KindDataConnector                             KindBasicDataConnector = original.KindDataConnector
	KindDynamics365                               KindBasicDataConnector = original.KindDynamics365
	KindMicrosoftCloudAppSecurity                 KindBasicDataConnector = original.KindMicrosoftCloudAppSecurity
	KindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnector = original.KindMicrosoftDefenderAdvancedThreatProtection
	KindOffice365                                 KindBasicDataConnector = original.KindOffice365
	KindOfficeATP                                 KindBasicDataConnector = original.KindOfficeATP
	KindThreatIntelligence                        KindBasicDataConnector = original.KindThreatIntelligence
	KindThreatIntelligenceTaxii                   KindBasicDataConnector = original.KindThreatIntelligenceTaxii
)

type KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirements

const (
	KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail               KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAmazonWebServicesCloudTrail
	KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory                      KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureActiveDirectory
	KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection             KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureAdvancedThreatProtection
	KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter                       KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindAzureSecurityCenter
	KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements           KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindDataConnectorsCheckRequirements
	KindBasicDataConnectorsCheckRequirementsKindDynamics365                               KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindDynamics365
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity                 KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftCloudAppSecurity
	KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindMicrosoftDefenderAdvancedThreatProtection
	KindBasicDataConnectorsCheckRequirementsKindOfficeATP                                 KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindOfficeATP
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence                        KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindThreatIntelligence
	KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii                   KindBasicDataConnectorsCheckRequirements = original.KindBasicDataConnectorsCheckRequirementsKindThreatIntelligenceTaxii
)

type KindBasicEntity = original.KindBasicEntity

const (
	KindAccount          KindBasicEntity = original.KindAccount
	KindAzureResource    KindBasicEntity = original.KindAzureResource
	KindBookmark         KindBasicEntity = original.KindBookmark
	KindCloudApplication KindBasicEntity = original.KindCloudApplication
	KindDNSResolution    KindBasicEntity = original.KindDNSResolution
	KindEntity           KindBasicEntity = original.KindEntity
	KindFile             KindBasicEntity = original.KindFile
	KindFileHash         KindBasicEntity = original.KindFileHash
	KindHost             KindBasicEntity = original.KindHost
	KindIoTDevice        KindBasicEntity = original.KindIoTDevice
	KindIP               KindBasicEntity = original.KindIP
	KindMailbox          KindBasicEntity = original.KindMailbox
	KindMailCluster      KindBasicEntity = original.KindMailCluster
	KindMailMessage      KindBasicEntity = original.KindMailMessage
	KindMalware          KindBasicEntity = original.KindMalware
	KindProcess          KindBasicEntity = original.KindProcess
	KindRegistryKey      KindBasicEntity = original.KindRegistryKey
	KindRegistryValue    KindBasicEntity = original.KindRegistryValue
	KindSecurityAlert    KindBasicEntity = original.KindSecurityAlert
	KindSecurityGroup    KindBasicEntity = original.KindSecurityGroup
	KindSubmissionMail   KindBasicEntity = original.KindSubmissionMail
	KindURL              KindBasicEntity = original.KindURL
)

type KindBasicEntityQuery = original.KindBasicEntityQuery

const (
	KindEntityQuery KindBasicEntityQuery = original.KindEntityQuery
	KindExpansion   KindBasicEntityQuery = original.KindExpansion
)

type KindBasicEntityQueryItem = original.KindBasicEntityQueryItem

const (
	KindEntityQueryItem KindBasicEntityQueryItem = original.KindEntityQueryItem
	KindInsight         KindBasicEntityQueryItem = original.KindInsight
)

type KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItem

const (
	KindBasicEntityTimelineItemKindActivity           KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindActivity
	KindBasicEntityTimelineItemKindBookmark           KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindBookmark
	KindBasicEntityTimelineItemKindEntityTimelineItem KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindEntityTimelineItem
	KindBasicEntityTimelineItemKindSecurityAlert      KindBasicEntityTimelineItem = original.KindBasicEntityTimelineItemKindSecurityAlert
)

type KindBasicSettings = original.KindBasicSettings

const (
	KindEntityAnalytics KindBasicSettings = original.KindEntityAnalytics
	KindEyesOn          KindBasicSettings = original.KindEyesOn
	KindSettings        KindBasicSettings = original.KindSettings
	KindUeba            KindBasicSettings = original.KindUeba
)

type KindBasicThreatIntelligenceInformation = original.KindBasicThreatIntelligenceInformation

const (
	KindIndicator                     KindBasicThreatIntelligenceInformation = original.KindIndicator
	KindThreatIntelligenceInformation KindBasicThreatIntelligenceInformation = original.KindThreatIntelligenceInformation
)

type MicrosoftSecurityProductName = original.MicrosoftSecurityProductName

const (
	AzureActiveDirectoryIdentityProtection    MicrosoftSecurityProductName = original.AzureActiveDirectoryIdentityProtection
	AzureAdvancedThreatProtection             MicrosoftSecurityProductName = original.AzureAdvancedThreatProtection
	AzureSecurityCenter                       MicrosoftSecurityProductName = original.AzureSecurityCenter
	AzureSecurityCenterforIoT                 MicrosoftSecurityProductName = original.AzureSecurityCenterforIoT
	MicrosoftCloudAppSecurity                 MicrosoftSecurityProductName = original.MicrosoftCloudAppSecurity
	MicrosoftDefenderAdvancedThreatProtection MicrosoftSecurityProductName = original.MicrosoftDefenderAdvancedThreatProtection
	Office365AdvancedThreatProtection         MicrosoftSecurityProductName = original.Office365AdvancedThreatProtection
)

type OSFamily = original.OSFamily

const (
	OSFamilyAndroid OSFamily = original.OSFamilyAndroid
	OSFamilyIOS     OSFamily = original.OSFamilyIOS
	OSFamilyLinux   OSFamily = original.OSFamilyLinux
	OSFamilyUnknown OSFamily = original.OSFamilyUnknown
	OSFamilyWindows OSFamily = original.OSFamilyWindows
)

type OutputType = original.OutputType

const (
	OutputTypeDate   OutputType = original.OutputTypeDate
	OutputTypeEntity OutputType = original.OutputTypeEntity
	OutputTypeNumber OutputType = original.OutputTypeNumber
	OutputTypeString OutputType = original.OutputTypeString
)

type RegistryHive = original.RegistryHive

const (
	HKEYA                        RegistryHive = original.HKEYA
	HKEYCLASSESROOT              RegistryHive = original.HKEYCLASSESROOT
	HKEYCURRENTCONFIG            RegistryHive = original.HKEYCURRENTCONFIG
	HKEYCURRENTUSER              RegistryHive = original.HKEYCURRENTUSER
	HKEYCURRENTUSERLOCALSETTINGS RegistryHive = original.HKEYCURRENTUSERLOCALSETTINGS
	HKEYLOCALMACHINE             RegistryHive = original.HKEYLOCALMACHINE
	HKEYPERFORMANCEDATA          RegistryHive = original.HKEYPERFORMANCEDATA
	HKEYPERFORMANCENLSTEXT       RegistryHive = original.HKEYPERFORMANCENLSTEXT
	HKEYPERFORMANCETEXT          RegistryHive = original.HKEYPERFORMANCETEXT
	HKEYUSERS                    RegistryHive = original.HKEYUSERS
)

type RegistryValueKind = original.RegistryValueKind

const (
	RegistryValueKindBinary       RegistryValueKind = original.RegistryValueKindBinary
	RegistryValueKindDWord        RegistryValueKind = original.RegistryValueKindDWord
	RegistryValueKindExpandString RegistryValueKind = original.RegistryValueKindExpandString
	RegistryValueKindMultiString  RegistryValueKind = original.RegistryValueKindMultiString
	RegistryValueKindNone         RegistryValueKind = original.RegistryValueKindNone
	RegistryValueKindQWord        RegistryValueKind = original.RegistryValueKindQWord
	RegistryValueKindString       RegistryValueKind = original.RegistryValueKindString
	RegistryValueKindUnknown      RegistryValueKind = original.RegistryValueKindUnknown
)

type RelationNodeKind = original.RelationNodeKind

const (
	RelationNodeKindBookmark RelationNodeKind = original.RelationNodeKindBookmark
	RelationNodeKindCase     RelationNodeKind = original.RelationNodeKindCase
)

type RelationTypes = original.RelationTypes

const (
	CasesToBookmarks RelationTypes = original.CasesToBookmarks
)

type SettingKind = original.SettingKind

const (
	SettingKindEntityAnalytics SettingKind = original.SettingKindEntityAnalytics
	SettingKindEyesOn          SettingKind = original.SettingKindEyesOn
	SettingKindUeba            SettingKind = original.SettingKindUeba
)

type Source = original.Source

const (
	Localfile     Source = original.Localfile
	Remotestorage Source = original.Remotestorage
)

type TemplateStatus = original.TemplateStatus

const (
	Available    TemplateStatus = original.Available
	Installed    TemplateStatus = original.Installed
	NotAvailable TemplateStatus = original.NotAvailable
)

type ThreatIntelligenceResourceKind = original.ThreatIntelligenceResourceKind

const (
	Indicator ThreatIntelligenceResourceKind = original.Indicator
)

type ThreatIntelligenceSortingCriteria = original.ThreatIntelligenceSortingCriteria

const (
	Ascending  ThreatIntelligenceSortingCriteria = original.Ascending
	Descending ThreatIntelligenceSortingCriteria = original.Descending
	Unsorted   ThreatIntelligenceSortingCriteria = original.Unsorted
)

type TriggerOperator = original.TriggerOperator

const (
	Equal       TriggerOperator = original.Equal
	GreaterThan TriggerOperator = original.GreaterThan
	LessThan    TriggerOperator = original.LessThan
	NotEqual    TriggerOperator = original.NotEqual
)

type UebaDataSources = original.UebaDataSources

const (
	AuditLogs     UebaDataSources = original.AuditLogs
	AzureActivity UebaDataSources = original.AzureActivity
	SecurityEvent UebaDataSources = original.SecurityEvent
	SigninLogs    UebaDataSources = original.SigninLogs
)

type AADCheckRequirements = original.AADCheckRequirements
type AADCheckRequirementsProperties = original.AADCheckRequirementsProperties
type AADDataConnector = original.AADDataConnector
type AADDataConnectorProperties = original.AADDataConnectorProperties
type AATPCheckRequirements = original.AATPCheckRequirements
type AATPCheckRequirementsProperties = original.AATPCheckRequirementsProperties
type AATPDataConnector = original.AATPDataConnector
type AATPDataConnectorProperties = original.AATPDataConnectorProperties
type ASCCheckRequirements = original.ASCCheckRequirements
type ASCCheckRequirementsProperties = original.ASCCheckRequirementsProperties
type ASCDataConnector = original.ASCDataConnector
type ASCDataConnectorProperties = original.ASCDataConnectorProperties
type AccountEntity = original.AccountEntity
type AccountEntityProperties = original.AccountEntityProperties
type ActionPropertiesBase = original.ActionPropertiesBase
type ActionRequest = original.ActionRequest
type ActionRequestProperties = original.ActionRequestProperties
type ActionResponse = original.ActionResponse
type ActionResponseProperties = original.ActionResponseProperties
type ActionsClient = original.ActionsClient
type ActionsList = original.ActionsList
type ActionsListIterator = original.ActionsListIterator
type ActionsListPage = original.ActionsListPage
type ActivityTimelineItem = original.ActivityTimelineItem
type Aggregations = original.Aggregations
type AggregationsKind = original.AggregationsKind
type AggregationsModel = original.AggregationsModel
type AlertRule = original.AlertRule
type AlertRuleKind1 = original.AlertRuleKind1
type AlertRuleModel = original.AlertRuleModel
type AlertRuleTemplate = original.AlertRuleTemplate
type AlertRuleTemplateDataSource = original.AlertRuleTemplateDataSource
type AlertRuleTemplateModel = original.AlertRuleTemplateModel
type AlertRuleTemplatePropertiesBase = original.AlertRuleTemplatePropertiesBase
type AlertRuleTemplatesClient = original.AlertRuleTemplatesClient
type AlertRuleTemplatesList = original.AlertRuleTemplatesList
type AlertRuleTemplatesListIterator = original.AlertRuleTemplatesListIterator
type AlertRuleTemplatesListPage = original.AlertRuleTemplatesListPage
type AlertRulesClient = original.AlertRulesClient
type AlertRulesList = original.AlertRulesList
type AlertRulesListIterator = original.AlertRulesListIterator
type AlertRulesListPage = original.AlertRulesListPage
type AlertsDataTypeOfDataConnector = original.AlertsDataTypeOfDataConnector
type AlertsDataTypeOfDataConnectorAlerts = original.AlertsDataTypeOfDataConnectorAlerts
type AwsCloudTrailCheckRequirements = original.AwsCloudTrailCheckRequirements
type AwsCloudTrailDataConnector = original.AwsCloudTrailDataConnector
type AwsCloudTrailDataConnectorDataTypes = original.AwsCloudTrailDataConnectorDataTypes
type AwsCloudTrailDataConnectorDataTypesLogs = original.AwsCloudTrailDataConnectorDataTypesLogs
type AwsCloudTrailDataConnectorProperties = original.AwsCloudTrailDataConnectorProperties
type AzureResourceEntity = original.AzureResourceEntity
type AzureResourceEntityProperties = original.AzureResourceEntityProperties
type BaseClient = original.BaseClient
type BasicAggregations = original.BasicAggregations
type BasicAlertRule = original.BasicAlertRule
type BasicAlertRuleTemplate = original.BasicAlertRuleTemplate
type BasicDataConnector = original.BasicDataConnector
type BasicDataConnectorsCheckRequirements = original.BasicDataConnectorsCheckRequirements
type BasicEntity = original.BasicEntity
type BasicEntityQuery = original.BasicEntityQuery
type BasicEntityQueryItem = original.BasicEntityQueryItem
type BasicEntityTimelineItem = original.BasicEntityTimelineItem
type BasicSettings = original.BasicSettings
type BasicThreatIntelligenceInformation = original.BasicThreatIntelligenceInformation
type Bookmark = original.Bookmark
type BookmarkClient = original.BookmarkClient
type BookmarkExpandParameters = original.BookmarkExpandParameters
type BookmarkExpandResponse = original.BookmarkExpandResponse
type BookmarkExpandResponseValue = original.BookmarkExpandResponseValue
type BookmarkList = original.BookmarkList
type BookmarkListIterator = original.BookmarkListIterator
type BookmarkListPage = original.BookmarkListPage
type BookmarkProperties = original.BookmarkProperties
type BookmarkRelationsClient = original.BookmarkRelationsClient
type BookmarkTimelineItem = original.BookmarkTimelineItem
type BookmarksClient = original.BookmarksClient
type Case = original.Case
type CaseComment = original.CaseComment
type CaseCommentList = original.CaseCommentList
type CaseCommentListIterator = original.CaseCommentListIterator
type CaseCommentListPage = original.CaseCommentListPage
type CaseCommentProperties = original.CaseCommentProperties
type CaseCommentsClient = original.CaseCommentsClient
type CaseList = original.CaseList
type CaseListIterator = original.CaseListIterator
type CaseListPage = original.CaseListPage
type CaseProperties = original.CaseProperties
type CaseRelation = original.CaseRelation
type CaseRelationList = original.CaseRelationList
type CaseRelationListIterator = original.CaseRelationListIterator
type CaseRelationListPage = original.CaseRelationListPage
type CaseRelationProperties = original.CaseRelationProperties
type CaseRelationsClient = original.CaseRelationsClient
type CasesAggregation = original.CasesAggregation
type CasesAggregationBySeverityProperties = original.CasesAggregationBySeverityProperties
type CasesAggregationByStatusProperties = original.CasesAggregationByStatusProperties
type CasesAggregationProperties = original.CasesAggregationProperties
type CasesAggregationsClient = original.CasesAggregationsClient
type CasesClient = original.CasesClient
type ClientInfo = original.ClientInfo
type CloudApplicationEntity = original.CloudApplicationEntity
type CloudApplicationEntityProperties = original.CloudApplicationEntityProperties
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CommentsClient = original.CommentsClient
type DNSEntity = original.DNSEntity
type DNSEntityProperties = original.DNSEntityProperties
type DataConnector = original.DataConnector
type DataConnectorDataTypeCommon = original.DataConnectorDataTypeCommon
type DataConnectorKind1 = original.DataConnectorKind1
type DataConnectorList = original.DataConnectorList
type DataConnectorListIterator = original.DataConnectorListIterator
type DataConnectorListPage = original.DataConnectorListPage
type DataConnectorModel = original.DataConnectorModel
type DataConnectorRequirementsState = original.DataConnectorRequirementsState
type DataConnectorTenantID = original.DataConnectorTenantID
type DataConnectorWithAlertsProperties = original.DataConnectorWithAlertsProperties
type DataConnectorsCheckRequirements = original.DataConnectorsCheckRequirements
type DataConnectorsCheckRequirementsClient = original.DataConnectorsCheckRequirementsClient
type DataConnectorsClient = original.DataConnectorsClient
type Dynamics365CheckRequirements = original.Dynamics365CheckRequirements
type Dynamics365CheckRequirementsProperties = original.Dynamics365CheckRequirementsProperties
type Dynamics365DataConnector = original.Dynamics365DataConnector
type Dynamics365DataConnectorDataTypes = original.Dynamics365DataConnectorDataTypes
type Dynamics365DataConnectorDataTypesDynamics365CdsActivities = original.Dynamics365DataConnectorDataTypesDynamics365CdsActivities
type Dynamics365DataConnectorProperties = original.Dynamics365DataConnectorProperties
type EntitiesClient = original.EntitiesClient
type EntitiesGetTimelineClient = original.EntitiesGetTimelineClient
type EntitiesRelationsClient = original.EntitiesRelationsClient
type Entity = original.Entity
type EntityAnalytics = original.EntityAnalytics
type EntityAnalyticsProperties = original.EntityAnalyticsProperties
type EntityCommonProperties = original.EntityCommonProperties
type EntityExpandParameters = original.EntityExpandParameters
type EntityExpandResponse = original.EntityExpandResponse
type EntityExpandResponseValue = original.EntityExpandResponseValue
type EntityGetInsightsParameters = original.EntityGetInsightsParameters
type EntityGetInsightsResponse = original.EntityGetInsightsResponse
type EntityInsightItem = original.EntityInsightItem
type EntityInsightItemQueryTimeInterval = original.EntityInsightItemQueryTimeInterval
type EntityKind1 = original.EntityKind1
type EntityList = original.EntityList
type EntityListIterator = original.EntityListIterator
type EntityListPage = original.EntityListPage
type EntityModel = original.EntityModel
type EntityQueriesClient = original.EntityQueriesClient
type EntityQuery = original.EntityQuery
type EntityQueryItem = original.EntityQueryItem
type EntityQueryItemProperties = original.EntityQueryItemProperties
type EntityQueryItemPropertiesDataTypesItem = original.EntityQueryItemPropertiesDataTypesItem
type EntityQueryKind1 = original.EntityQueryKind1
type EntityQueryList = original.EntityQueryList
type EntityQueryListIterator = original.EntityQueryListIterator
type EntityQueryListPage = original.EntityQueryListPage
type EntityQueryModel = original.EntityQueryModel
type EntityRelationsClient = original.EntityRelationsClient
type EntityTimelineItem = original.EntityTimelineItem
type EntityTimelineParameters = original.EntityTimelineParameters
type EntityTimelineResponse = original.EntityTimelineResponse
type EventGroupingSettings = original.EventGroupingSettings
type ExpansionEntityQueriesProperties = original.ExpansionEntityQueriesProperties
type ExpansionEntityQuery = original.ExpansionEntityQuery
type ExpansionResultAggregation = original.ExpansionResultAggregation
type ExpansionResultsMetadata = original.ExpansionResultsMetadata
type EyesOn = original.EyesOn
type EyesOnSettingsProperties = original.EyesOnSettingsProperties
type FileEntity = original.FileEntity
type FileEntityProperties = original.FileEntityProperties
type FileHashEntity = original.FileHashEntity
type FileHashEntityProperties = original.FileHashEntityProperties
type FusionAlertRule = original.FusionAlertRule
type FusionAlertRuleProperties = original.FusionAlertRuleProperties
type FusionAlertRuleTemplate = original.FusionAlertRuleTemplate
type FusionAlertRuleTemplateProperties = original.FusionAlertRuleTemplateProperties
type GeoLocation = original.GeoLocation
type GetInsightsError = original.GetInsightsError
type GetInsightsResultsMetadata = original.GetInsightsResultsMetadata
type GetQueriesResponse = original.GetQueriesResponse
type GroupingConfiguration = original.GroupingConfiguration
type HostEntity = original.HostEntity
type HostEntityProperties = original.HostEntityProperties
type HuntingBookmark = original.HuntingBookmark
type HuntingBookmarkProperties = original.HuntingBookmarkProperties
type IPEntity = original.IPEntity
type IPEntityProperties = original.IPEntityProperties
type Incident = original.Incident
type IncidentAdditionalData = original.IncidentAdditionalData
type IncidentAlertList = original.IncidentAlertList
type IncidentBookmarkList = original.IncidentBookmarkList
type IncidentComment = original.IncidentComment
type IncidentCommentList = original.IncidentCommentList
type IncidentCommentListIterator = original.IncidentCommentListIterator
type IncidentCommentListPage = original.IncidentCommentListPage
type IncidentCommentProperties = original.IncidentCommentProperties
type IncidentCommentsClient = original.IncidentCommentsClient
type IncidentConfiguration = original.IncidentConfiguration
type IncidentEntitiesResponse = original.IncidentEntitiesResponse
type IncidentEntitiesResultsMetadata = original.IncidentEntitiesResultsMetadata
type IncidentInfo = original.IncidentInfo
type IncidentLabel = original.IncidentLabel
type IncidentList = original.IncidentList
type IncidentListIterator = original.IncidentListIterator
type IncidentListPage = original.IncidentListPage
type IncidentOwnerInfo = original.IncidentOwnerInfo
type IncidentProperties = original.IncidentProperties
type IncidentRelationsClient = original.IncidentRelationsClient
type IncidentsClient = original.IncidentsClient
type InsightQueryItem = original.InsightQueryItem
type InsightQueryItemProperties = original.InsightQueryItemProperties
type InsightQueryItemPropertiesAdditionalQuery = original.InsightQueryItemPropertiesAdditionalQuery
type InsightQueryItemPropertiesDefaultTimeRange = original.InsightQueryItemPropertiesDefaultTimeRange
type InsightQueryItemPropertiesReferenceTimeRange = original.InsightQueryItemPropertiesReferenceTimeRange
type InsightQueryItemPropertiesTableQuery = original.InsightQueryItemPropertiesTableQuery
type InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem = original.InsightQueryItemPropertiesTableQueryColumnsDefinitionsItem
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem = original.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItem
type InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem = original.InsightQueryItemPropertiesTableQueryQueriesDefinitionsItemLinkColumnsDefinitionsItem
type InsightsTableResult = original.InsightsTableResult
type InsightsTableResultColumnsItem = original.InsightsTableResultColumnsItem
type IoTDeviceEntity = original.IoTDeviceEntity
type IoTDeviceEntityProperties = original.IoTDeviceEntityProperties
type MCASCheckRequirements = original.MCASCheckRequirements
type MCASCheckRequirementsProperties = original.MCASCheckRequirementsProperties
type MCASDataConnector = original.MCASDataConnector
type MCASDataConnectorDataTypes = original.MCASDataConnectorDataTypes
type MCASDataConnectorDataTypesDiscoveryLogs = original.MCASDataConnectorDataTypesDiscoveryLogs
type MCASDataConnectorProperties = original.MCASDataConnectorProperties
type MDATPCheckRequirements = original.MDATPCheckRequirements
type MDATPCheckRequirementsProperties = original.MDATPCheckRequirementsProperties
type MDATPDataConnector = original.MDATPDataConnector
type MDATPDataConnectorProperties = original.MDATPDataConnectorProperties
type MLBehaviorAnalyticsAlertRule = original.MLBehaviorAnalyticsAlertRule
type MLBehaviorAnalyticsAlertRuleProperties = original.MLBehaviorAnalyticsAlertRuleProperties
type MLBehaviorAnalyticsAlertRuleTemplate = original.MLBehaviorAnalyticsAlertRuleTemplate
type MLBehaviorAnalyticsAlertRuleTemplateProperties = original.MLBehaviorAnalyticsAlertRuleTemplateProperties
type MailClusterEntity = original.MailClusterEntity
type MailClusterEntityProperties = original.MailClusterEntityProperties
type MailMessageEntity = original.MailMessageEntity
type MailMessageEntityProperties = original.MailMessageEntityProperties
type MailboxEntity = original.MailboxEntity
type MailboxEntityProperties = original.MailboxEntityProperties
type MalwareEntity = original.MalwareEntity
type MalwareEntityProperties = original.MalwareEntityProperties
type MicrosoftSecurityIncidentCreationAlertRule = original.MicrosoftSecurityIncidentCreationAlertRule
type MicrosoftSecurityIncidentCreationAlertRuleCommonProperties = original.MicrosoftSecurityIncidentCreationAlertRuleCommonProperties
type MicrosoftSecurityIncidentCreationAlertRuleProperties = original.MicrosoftSecurityIncidentCreationAlertRuleProperties
type MicrosoftSecurityIncidentCreationAlertRuleTemplate = original.MicrosoftSecurityIncidentCreationAlertRuleTemplate
type MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties = original.MicrosoftSecurityIncidentCreationAlertRuleTemplateProperties
type OfficeATPCheckRequirements = original.OfficeATPCheckRequirements
type OfficeATPCheckRequirementsProperties = original.OfficeATPCheckRequirementsProperties
type OfficeATPDataConnector = original.OfficeATPDataConnector
type OfficeATPDataConnectorProperties = original.OfficeATPDataConnectorProperties
type OfficeConsent = original.OfficeConsent
type OfficeConsentList = original.OfficeConsentList
type OfficeConsentListIterator = original.OfficeConsentListIterator
type OfficeConsentListPage = original.OfficeConsentListPage
type OfficeConsentProperties = original.OfficeConsentProperties
type OfficeConsentsClient = original.OfficeConsentsClient
type OfficeDataConnector = original.OfficeDataConnector
type OfficeDataConnectorDataTypes = original.OfficeDataConnectorDataTypes
type OfficeDataConnectorDataTypesExchange = original.OfficeDataConnectorDataTypesExchange
type OfficeDataConnectorDataTypesSharePoint = original.OfficeDataConnectorDataTypesSharePoint
type OfficeDataConnectorDataTypesTeams = original.OfficeDataConnectorDataTypesTeams
type OfficeDataConnectorProperties = original.OfficeDataConnectorProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationsClient = original.OperationsClient
type OperationsList = original.OperationsList
type OperationsListIterator = original.OperationsListIterator
type OperationsListPage = original.OperationsListPage
type ProcessEntity = original.ProcessEntity
type ProcessEntityProperties = original.ProcessEntityProperties
type ProductSettingsClient = original.ProductSettingsClient
type RegistryKeyEntity = original.RegistryKeyEntity
type RegistryKeyEntityProperties = original.RegistryKeyEntityProperties
type RegistryValueEntity = original.RegistryValueEntity
type RegistryValueEntityProperties = original.RegistryValueEntityProperties
type Relation = original.Relation
type RelationBase = original.RelationBase
type RelationList = original.RelationList
type RelationListIterator = original.RelationListIterator
type RelationListPage = original.RelationListPage
type RelationNode = original.RelationNode
type RelationProperties = original.RelationProperties
type RelationsModelInput = original.RelationsModelInput
type RelationsModelInputProperties = original.RelationsModelInputProperties
type Resource = original.Resource
type ResourceWithEtag = original.ResourceWithEtag
type ScheduledAlertRule = original.ScheduledAlertRule
type ScheduledAlertRuleCommonProperties = original.ScheduledAlertRuleCommonProperties
type ScheduledAlertRuleProperties = original.ScheduledAlertRuleProperties
type ScheduledAlertRuleTemplate = original.ScheduledAlertRuleTemplate
type ScheduledAlertRuleTemplateProperties = original.ScheduledAlertRuleTemplateProperties
type SecurityAlert = original.SecurityAlert
type SecurityAlertProperties = original.SecurityAlertProperties
type SecurityAlertPropertiesConfidenceReasonsItem = original.SecurityAlertPropertiesConfidenceReasonsItem
type SecurityAlertTimelineItem = original.SecurityAlertTimelineItem
type SecurityGroupEntity = original.SecurityGroupEntity
type SecurityGroupEntityProperties = original.SecurityGroupEntityProperties
type SettingList = original.SettingList
type Settings = original.Settings
type SettingsKind = original.SettingsKind
type SettingsModel = original.SettingsModel
type SubmissionMailEntity = original.SubmissionMailEntity
type SubmissionMailEntityProperties = original.SubmissionMailEntityProperties
type TICheckRequirements = original.TICheckRequirements
type TICheckRequirementsProperties = original.TICheckRequirementsProperties
type TIDataConnector = original.TIDataConnector
type TIDataConnectorDataTypes = original.TIDataConnectorDataTypes
type TIDataConnectorDataTypesIndicators = original.TIDataConnectorDataTypesIndicators
type TIDataConnectorProperties = original.TIDataConnectorProperties
type ThreatIntelligence = original.ThreatIntelligence
type ThreatIntelligenceAppendTags = original.ThreatIntelligenceAppendTags
type ThreatIntelligenceFilteringCriteria = original.ThreatIntelligenceFilteringCriteria
type ThreatIntelligenceGranularMarkingModel = original.ThreatIntelligenceGranularMarkingModel
type ThreatIntelligenceIndicatorClient = original.ThreatIntelligenceIndicatorClient
type ThreatIntelligenceIndicatorMetricsClient = original.ThreatIntelligenceIndicatorMetricsClient
type ThreatIntelligenceIndicatorModel = original.ThreatIntelligenceIndicatorModel
type ThreatIntelligenceIndicatorModelForRequestBody = original.ThreatIntelligenceIndicatorModelForRequestBody
type ThreatIntelligenceIndicatorProperties = original.ThreatIntelligenceIndicatorProperties
type ThreatIntelligenceIndicatorsClient = original.ThreatIntelligenceIndicatorsClient
type ThreatIntelligenceInformation = original.ThreatIntelligenceInformation
type ThreatIntelligenceInformationList = original.ThreatIntelligenceInformationList
type ThreatIntelligenceInformationListIterator = original.ThreatIntelligenceInformationListIterator
type ThreatIntelligenceInformationListPage = original.ThreatIntelligenceInformationListPage
type ThreatIntelligenceInformationModel = original.ThreatIntelligenceInformationModel
type ThreatIntelligenceKillChainPhase = original.ThreatIntelligenceKillChainPhase
type ThreatIntelligenceMetric = original.ThreatIntelligenceMetric
type ThreatIntelligenceMetricEntity = original.ThreatIntelligenceMetricEntity
type ThreatIntelligenceMetrics = original.ThreatIntelligenceMetrics
type ThreatIntelligenceMetricsList = original.ThreatIntelligenceMetricsList
type ThreatIntelligenceResourceKind1 = original.ThreatIntelligenceResourceKind1
type ThreatIntelligenceSortingCriteria1 = original.ThreatIntelligenceSortingCriteria1
type TiTaxiiCheckRequirements = original.TiTaxiiCheckRequirements
type TiTaxiiCheckRequirementsProperties = original.TiTaxiiCheckRequirementsProperties
type TiTaxiiDataConnector = original.TiTaxiiDataConnector
type TiTaxiiDataConnectorDataTypes = original.TiTaxiiDataConnectorDataTypes
type TiTaxiiDataConnectorDataTypesTaxiiClient = original.TiTaxiiDataConnectorDataTypesTaxiiClient
type TiTaxiiDataConnectorProperties = original.TiTaxiiDataConnectorProperties
type TimelineAggregation = original.TimelineAggregation
type TimelineError = original.TimelineError
type TimelineResultsMetadata = original.TimelineResultsMetadata
type URLEntity = original.URLEntity
type URLEntityProperties = original.URLEntityProperties
type Ueba = original.Ueba
type UebaProperties = original.UebaProperties
type UserInfo = original.UserInfo
type Watchlist = original.Watchlist
type WatchlistItem = original.WatchlistItem
type WatchlistItemClient = original.WatchlistItemClient
type WatchlistItemProperties = original.WatchlistItemProperties
type WatchlistList = original.WatchlistList
type WatchlistListIterator = original.WatchlistListIterator
type WatchlistListPage = original.WatchlistListPage
type WatchlistProperties = original.WatchlistProperties
type WatchlistsClient = original.WatchlistsClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewActionsClient(subscriptionID string) ActionsClient {
	return original.NewActionsClient(subscriptionID)
}
func NewActionsClientWithBaseURI(baseURI string, subscriptionID string) ActionsClient {
	return original.NewActionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewActionsListIterator(page ActionsListPage) ActionsListIterator {
	return original.NewActionsListIterator(page)
}
func NewActionsListPage(cur ActionsList, getNextPage func(context.Context, ActionsList) (ActionsList, error)) ActionsListPage {
	return original.NewActionsListPage(cur, getNextPage)
}
func NewAlertRuleTemplatesClient(subscriptionID string) AlertRuleTemplatesClient {
	return original.NewAlertRuleTemplatesClient(subscriptionID)
}
func NewAlertRuleTemplatesClientWithBaseURI(baseURI string, subscriptionID string) AlertRuleTemplatesClient {
	return original.NewAlertRuleTemplatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRuleTemplatesListIterator(page AlertRuleTemplatesListPage) AlertRuleTemplatesListIterator {
	return original.NewAlertRuleTemplatesListIterator(page)
}
func NewAlertRuleTemplatesListPage(cur AlertRuleTemplatesList, getNextPage func(context.Context, AlertRuleTemplatesList) (AlertRuleTemplatesList, error)) AlertRuleTemplatesListPage {
	return original.NewAlertRuleTemplatesListPage(cur, getNextPage)
}
func NewAlertRulesClient(subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClient(subscriptionID)
}
func NewAlertRulesClientWithBaseURI(baseURI string, subscriptionID string) AlertRulesClient {
	return original.NewAlertRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewAlertRulesListIterator(page AlertRulesListPage) AlertRulesListIterator {
	return original.NewAlertRulesListIterator(page)
}
func NewAlertRulesListPage(cur AlertRulesList, getNextPage func(context.Context, AlertRulesList) (AlertRulesList, error)) AlertRulesListPage {
	return original.NewAlertRulesListPage(cur, getNextPage)
}
func NewBookmarkClient(subscriptionID string) BookmarkClient {
	return original.NewBookmarkClient(subscriptionID)
}
func NewBookmarkClientWithBaseURI(baseURI string, subscriptionID string) BookmarkClient {
	return original.NewBookmarkClientWithBaseURI(baseURI, subscriptionID)
}
func NewBookmarkListIterator(page BookmarkListPage) BookmarkListIterator {
	return original.NewBookmarkListIterator(page)
}
func NewBookmarkListPage(cur BookmarkList, getNextPage func(context.Context, BookmarkList) (BookmarkList, error)) BookmarkListPage {
	return original.NewBookmarkListPage(cur, getNextPage)
}
func NewBookmarkRelationsClient(subscriptionID string) BookmarkRelationsClient {
	return original.NewBookmarkRelationsClient(subscriptionID)
}
func NewBookmarkRelationsClientWithBaseURI(baseURI string, subscriptionID string) BookmarkRelationsClient {
	return original.NewBookmarkRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBookmarksClient(subscriptionID string) BookmarksClient {
	return original.NewBookmarksClient(subscriptionID)
}
func NewBookmarksClientWithBaseURI(baseURI string, subscriptionID string) BookmarksClient {
	return original.NewBookmarksClientWithBaseURI(baseURI, subscriptionID)
}
func NewCaseCommentListIterator(page CaseCommentListPage) CaseCommentListIterator {
	return original.NewCaseCommentListIterator(page)
}
func NewCaseCommentListPage(cur CaseCommentList, getNextPage func(context.Context, CaseCommentList) (CaseCommentList, error)) CaseCommentListPage {
	return original.NewCaseCommentListPage(cur, getNextPage)
}
func NewCaseCommentsClient(subscriptionID string) CaseCommentsClient {
	return original.NewCaseCommentsClient(subscriptionID)
}
func NewCaseCommentsClientWithBaseURI(baseURI string, subscriptionID string) CaseCommentsClient {
	return original.NewCaseCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCaseListIterator(page CaseListPage) CaseListIterator {
	return original.NewCaseListIterator(page)
}
func NewCaseListPage(cur CaseList, getNextPage func(context.Context, CaseList) (CaseList, error)) CaseListPage {
	return original.NewCaseListPage(cur, getNextPage)
}
func NewCaseRelationListIterator(page CaseRelationListPage) CaseRelationListIterator {
	return original.NewCaseRelationListIterator(page)
}
func NewCaseRelationListPage(cur CaseRelationList, getNextPage func(context.Context, CaseRelationList) (CaseRelationList, error)) CaseRelationListPage {
	return original.NewCaseRelationListPage(cur, getNextPage)
}
func NewCaseRelationsClient(subscriptionID string) CaseRelationsClient {
	return original.NewCaseRelationsClient(subscriptionID)
}
func NewCaseRelationsClientWithBaseURI(baseURI string, subscriptionID string) CaseRelationsClient {
	return original.NewCaseRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCasesAggregationsClient(subscriptionID string) CasesAggregationsClient {
	return original.NewCasesAggregationsClient(subscriptionID)
}
func NewCasesAggregationsClientWithBaseURI(baseURI string, subscriptionID string) CasesAggregationsClient {
	return original.NewCasesAggregationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCasesClient(subscriptionID string) CasesClient {
	return original.NewCasesClient(subscriptionID)
}
func NewCasesClientWithBaseURI(baseURI string, subscriptionID string) CasesClient {
	return original.NewCasesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCommentsClient(subscriptionID string) CommentsClient {
	return original.NewCommentsClient(subscriptionID)
}
func NewCommentsClientWithBaseURI(baseURI string, subscriptionID string) CommentsClient {
	return original.NewCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataConnectorListIterator(page DataConnectorListPage) DataConnectorListIterator {
	return original.NewDataConnectorListIterator(page)
}
func NewDataConnectorListPage(cur DataConnectorList, getNextPage func(context.Context, DataConnectorList) (DataConnectorList, error)) DataConnectorListPage {
	return original.NewDataConnectorListPage(cur, getNextPage)
}
func NewDataConnectorsCheckRequirementsClient(subscriptionID string) DataConnectorsCheckRequirementsClient {
	return original.NewDataConnectorsCheckRequirementsClient(subscriptionID)
}
func NewDataConnectorsCheckRequirementsClientWithBaseURI(baseURI string, subscriptionID string) DataConnectorsCheckRequirementsClient {
	return original.NewDataConnectorsCheckRequirementsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataConnectorsClient(subscriptionID string) DataConnectorsClient {
	return original.NewDataConnectorsClient(subscriptionID)
}
func NewDataConnectorsClientWithBaseURI(baseURI string, subscriptionID string) DataConnectorsClient {
	return original.NewDataConnectorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesClient(subscriptionID string) EntitiesClient {
	return original.NewEntitiesClient(subscriptionID)
}
func NewEntitiesClientWithBaseURI(baseURI string, subscriptionID string) EntitiesClient {
	return original.NewEntitiesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesGetTimelineClient(subscriptionID string) EntitiesGetTimelineClient {
	return original.NewEntitiesGetTimelineClient(subscriptionID)
}
func NewEntitiesGetTimelineClientWithBaseURI(baseURI string, subscriptionID string) EntitiesGetTimelineClient {
	return original.NewEntitiesGetTimelineClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntitiesRelationsClient(subscriptionID string) EntitiesRelationsClient {
	return original.NewEntitiesRelationsClient(subscriptionID)
}
func NewEntitiesRelationsClientWithBaseURI(baseURI string, subscriptionID string) EntitiesRelationsClient {
	return original.NewEntitiesRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntityListIterator(page EntityListPage) EntityListIterator {
	return original.NewEntityListIterator(page)
}
func NewEntityListPage(cur EntityList, getNextPage func(context.Context, EntityList) (EntityList, error)) EntityListPage {
	return original.NewEntityListPage(cur, getNextPage)
}
func NewEntityQueriesClient(subscriptionID string) EntityQueriesClient {
	return original.NewEntityQueriesClient(subscriptionID)
}
func NewEntityQueriesClientWithBaseURI(baseURI string, subscriptionID string) EntityQueriesClient {
	return original.NewEntityQueriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEntityQueryListIterator(page EntityQueryListPage) EntityQueryListIterator {
	return original.NewEntityQueryListIterator(page)
}
func NewEntityQueryListPage(cur EntityQueryList, getNextPage func(context.Context, EntityQueryList) (EntityQueryList, error)) EntityQueryListPage {
	return original.NewEntityQueryListPage(cur, getNextPage)
}
func NewEntityRelationsClient(subscriptionID string) EntityRelationsClient {
	return original.NewEntityRelationsClient(subscriptionID)
}
func NewEntityRelationsClientWithBaseURI(baseURI string, subscriptionID string) EntityRelationsClient {
	return original.NewEntityRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentCommentListIterator(page IncidentCommentListPage) IncidentCommentListIterator {
	return original.NewIncidentCommentListIterator(page)
}
func NewIncidentCommentListPage(cur IncidentCommentList, getNextPage func(context.Context, IncidentCommentList) (IncidentCommentList, error)) IncidentCommentListPage {
	return original.NewIncidentCommentListPage(cur, getNextPage)
}
func NewIncidentCommentsClient(subscriptionID string) IncidentCommentsClient {
	return original.NewIncidentCommentsClient(subscriptionID)
}
func NewIncidentCommentsClientWithBaseURI(baseURI string, subscriptionID string) IncidentCommentsClient {
	return original.NewIncidentCommentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentListIterator(page IncidentListPage) IncidentListIterator {
	return original.NewIncidentListIterator(page)
}
func NewIncidentListPage(cur IncidentList, getNextPage func(context.Context, IncidentList) (IncidentList, error)) IncidentListPage {
	return original.NewIncidentListPage(cur, getNextPage)
}
func NewIncidentRelationsClient(subscriptionID string) IncidentRelationsClient {
	return original.NewIncidentRelationsClient(subscriptionID)
}
func NewIncidentRelationsClientWithBaseURI(baseURI string, subscriptionID string) IncidentRelationsClient {
	return original.NewIncidentRelationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIncidentsClient(subscriptionID string) IncidentsClient {
	return original.NewIncidentsClient(subscriptionID)
}
func NewIncidentsClientWithBaseURI(baseURI string, subscriptionID string) IncidentsClient {
	return original.NewIncidentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOfficeConsentListIterator(page OfficeConsentListPage) OfficeConsentListIterator {
	return original.NewOfficeConsentListIterator(page)
}
func NewOfficeConsentListPage(cur OfficeConsentList, getNextPage func(context.Context, OfficeConsentList) (OfficeConsentList, error)) OfficeConsentListPage {
	return original.NewOfficeConsentListPage(cur, getNextPage)
}
func NewOfficeConsentsClient(subscriptionID string) OfficeConsentsClient {
	return original.NewOfficeConsentsClient(subscriptionID)
}
func NewOfficeConsentsClientWithBaseURI(baseURI string, subscriptionID string) OfficeConsentsClient {
	return original.NewOfficeConsentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return original.NewOperationsListIterator(page)
}
func NewOperationsListPage(cur OperationsList, getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return original.NewOperationsListPage(cur, getNextPage)
}
func NewProductSettingsClient(subscriptionID string) ProductSettingsClient {
	return original.NewProductSettingsClient(subscriptionID)
}
func NewProductSettingsClientWithBaseURI(baseURI string, subscriptionID string) ProductSettingsClient {
	return original.NewProductSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRelationListIterator(page RelationListPage) RelationListIterator {
	return original.NewRelationListIterator(page)
}
func NewRelationListPage(cur RelationList, getNextPage func(context.Context, RelationList) (RelationList, error)) RelationListPage {
	return original.NewRelationListPage(cur, getNextPage)
}
func NewThreatIntelligenceIndicatorClient(subscriptionID string) ThreatIntelligenceIndicatorClient {
	return original.NewThreatIntelligenceIndicatorClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorClient {
	return original.NewThreatIntelligenceIndicatorClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceIndicatorMetricsClient(subscriptionID string) ThreatIntelligenceIndicatorMetricsClient {
	return original.NewThreatIntelligenceIndicatorMetricsClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorMetricsClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorMetricsClient {
	return original.NewThreatIntelligenceIndicatorMetricsClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceIndicatorsClient(subscriptionID string) ThreatIntelligenceIndicatorsClient {
	return original.NewThreatIntelligenceIndicatorsClient(subscriptionID)
}
func NewThreatIntelligenceIndicatorsClientWithBaseURI(baseURI string, subscriptionID string) ThreatIntelligenceIndicatorsClient {
	return original.NewThreatIntelligenceIndicatorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewThreatIntelligenceInformationListIterator(page ThreatIntelligenceInformationListPage) ThreatIntelligenceInformationListIterator {
	return original.NewThreatIntelligenceInformationListIterator(page)
}
func NewThreatIntelligenceInformationListPage(cur ThreatIntelligenceInformationList, getNextPage func(context.Context, ThreatIntelligenceInformationList) (ThreatIntelligenceInformationList, error)) ThreatIntelligenceInformationListPage {
	return original.NewThreatIntelligenceInformationListPage(cur, getNextPage)
}
func NewWatchlistItemClient(subscriptionID string) WatchlistItemClient {
	return original.NewWatchlistItemClient(subscriptionID)
}
func NewWatchlistItemClientWithBaseURI(baseURI string, subscriptionID string) WatchlistItemClient {
	return original.NewWatchlistItemClientWithBaseURI(baseURI, subscriptionID)
}
func NewWatchlistListIterator(page WatchlistListPage) WatchlistListIterator {
	return original.NewWatchlistListIterator(page)
}
func NewWatchlistListPage(cur WatchlistList, getNextPage func(context.Context, WatchlistList) (WatchlistList, error)) WatchlistListPage {
	return original.NewWatchlistListPage(cur, getNextPage)
}
func NewWatchlistsClient(subscriptionID string) WatchlistsClient {
	return original.NewWatchlistsClient(subscriptionID)
}
func NewWatchlistsClientWithBaseURI(baseURI string, subscriptionID string) WatchlistsClient {
	return original.NewWatchlistsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAlertRuleKindValues() []AlertRuleKind {
	return original.PossibleAlertRuleKindValues()
}
func PossibleAlertSeverityValues() []AlertSeverity {
	return original.PossibleAlertSeverityValues()
}
func PossibleAlertStatusValues() []AlertStatus {
	return original.PossibleAlertStatusValues()
}
func PossibleAntispamMailDirectionValues() []AntispamMailDirection {
	return original.PossibleAntispamMailDirectionValues()
}
func PossibleAttackTacticValues() []AttackTactic {
	return original.PossibleAttackTacticValues()
}
func PossibleCaseSeverityValues() []CaseSeverity {
	return original.PossibleCaseSeverityValues()
}
func PossibleCaseStatusValues() []CaseStatus {
	return original.PossibleCaseStatusValues()
}
func PossibleCloseReasonValues() []CloseReason {
	return original.PossibleCloseReasonValues()
}
func PossibleConfidenceLevelValues() []ConfidenceLevel {
	return original.PossibleConfidenceLevelValues()
}
func PossibleConfidenceScoreStatusValues() []ConfidenceScoreStatus {
	return original.PossibleConfidenceScoreStatusValues()
}
func PossibleDataConnectorAuthorizationStateValues() []DataConnectorAuthorizationState {
	return original.PossibleDataConnectorAuthorizationStateValues()
}
func PossibleDataConnectorKindValues() []DataConnectorKind {
	return original.PossibleDataConnectorKindValues()
}
func PossibleDataConnectorLicenseStateValues() []DataConnectorLicenseState {
	return original.PossibleDataConnectorLicenseStateValues()
}
func PossibleDataTypeStateValues() []DataTypeState {
	return original.PossibleDataTypeStateValues()
}
func PossibleDeliveryActionValues() []DeliveryAction {
	return original.PossibleDeliveryActionValues()
}
func PossibleDeliveryLocationValues() []DeliveryLocation {
	return original.PossibleDeliveryLocationValues()
}
func PossibleElevationTokenValues() []ElevationToken {
	return original.PossibleElevationTokenValues()
}
func PossibleEntitiesMatchingMethodValues() []EntitiesMatchingMethod {
	return original.PossibleEntitiesMatchingMethodValues()
}
func PossibleEntityKindValues() []EntityKind {
	return original.PossibleEntityKindValues()
}
func PossibleEntityQueryKindValues() []EntityQueryKind {
	return original.PossibleEntityQueryKindValues()
}
func PossibleEntityTimelineKindValues() []EntityTimelineKind {
	return original.PossibleEntityTimelineKindValues()
}
func PossibleEntityTypeValues() []EntityType {
	return original.PossibleEntityTypeValues()
}
func PossibleEventGroupingAggregationKindValues() []EventGroupingAggregationKind {
	return original.PossibleEventGroupingAggregationKindValues()
}
func PossibleFileHashAlgorithmValues() []FileHashAlgorithm {
	return original.PossibleFileHashAlgorithmValues()
}
func PossibleGroupingEntityTypeValues() []GroupingEntityType {
	return original.PossibleGroupingEntityTypeValues()
}
func PossibleIncidentClassificationReasonValues() []IncidentClassificationReason {
	return original.PossibleIncidentClassificationReasonValues()
}
func PossibleIncidentClassificationValues() []IncidentClassification {
	return original.PossibleIncidentClassificationValues()
}
func PossibleIncidentLabelTypeValues() []IncidentLabelType {
	return original.PossibleIncidentLabelTypeValues()
}
func PossibleIncidentSeverityValues() []IncidentSeverity {
	return original.PossibleIncidentSeverityValues()
}
func PossibleIncidentStatusValues() []IncidentStatus {
	return original.PossibleIncidentStatusValues()
}
func PossibleKillChainIntentValues() []KillChainIntent {
	return original.PossibleKillChainIntentValues()
}
func PossibleKindBasicAlertRuleTemplateValues() []KindBasicAlertRuleTemplate {
	return original.PossibleKindBasicAlertRuleTemplateValues()
}
func PossibleKindBasicAlertRuleValues() []KindBasicAlertRule {
	return original.PossibleKindBasicAlertRuleValues()
}
func PossibleKindBasicDataConnectorValues() []KindBasicDataConnector {
	return original.PossibleKindBasicDataConnectorValues()
}
func PossibleKindBasicDataConnectorsCheckRequirementsValues() []KindBasicDataConnectorsCheckRequirements {
	return original.PossibleKindBasicDataConnectorsCheckRequirementsValues()
}
func PossibleKindBasicEntityQueryItemValues() []KindBasicEntityQueryItem {
	return original.PossibleKindBasicEntityQueryItemValues()
}
func PossibleKindBasicEntityQueryValues() []KindBasicEntityQuery {
	return original.PossibleKindBasicEntityQueryValues()
}
func PossibleKindBasicEntityTimelineItemValues() []KindBasicEntityTimelineItem {
	return original.PossibleKindBasicEntityTimelineItemValues()
}
func PossibleKindBasicEntityValues() []KindBasicEntity {
	return original.PossibleKindBasicEntityValues()
}
func PossibleKindBasicSettingsValues() []KindBasicSettings {
	return original.PossibleKindBasicSettingsValues()
}
func PossibleKindBasicThreatIntelligenceInformationValues() []KindBasicThreatIntelligenceInformation {
	return original.PossibleKindBasicThreatIntelligenceInformationValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleMicrosoftSecurityProductNameValues() []MicrosoftSecurityProductName {
	return original.PossibleMicrosoftSecurityProductNameValues()
}
func PossibleOSFamilyValues() []OSFamily {
	return original.PossibleOSFamilyValues()
}
func PossibleOutputTypeValues() []OutputType {
	return original.PossibleOutputTypeValues()
}
func PossibleRegistryHiveValues() []RegistryHive {
	return original.PossibleRegistryHiveValues()
}
func PossibleRegistryValueKindValues() []RegistryValueKind {
	return original.PossibleRegistryValueKindValues()
}
func PossibleRelationNodeKindValues() []RelationNodeKind {
	return original.PossibleRelationNodeKindValues()
}
func PossibleRelationTypesValues() []RelationTypes {
	return original.PossibleRelationTypesValues()
}
func PossibleSettingKindValues() []SettingKind {
	return original.PossibleSettingKindValues()
}
func PossibleSourceValues() []Source {
	return original.PossibleSourceValues()
}
func PossibleTemplateStatusValues() []TemplateStatus {
	return original.PossibleTemplateStatusValues()
}
func PossibleThreatIntelligenceResourceKindValues() []ThreatIntelligenceResourceKind {
	return original.PossibleThreatIntelligenceResourceKindValues()
}
func PossibleThreatIntelligenceSortingCriteriaValues() []ThreatIntelligenceSortingCriteria {
	return original.PossibleThreatIntelligenceSortingCriteriaValues()
}
func PossibleTriggerOperatorValues() []TriggerOperator {
	return original.PossibleTriggerOperatorValues()
}
func PossibleUebaDataSourcesValues() []UebaDataSources {
	return original.PossibleUebaDataSourcesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
