package attestation

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// TeeKind enumerates the values for tee kind.
type TeeKind string

const (
	// CyResComponent IoT Edge validation
	CyResComponent TeeKind = "CyResComponent"
	// OpenEnclave OpenEnclave extensions to SGX
	OpenEnclave TeeKind = "OpenEnclave"
	// SgxEnclave Intel Software Guard eXtensions
	SgxEnclave TeeKind = "SgxEnclave"
	// VSMEnclave VSM Enclave Attestation
	VSMEnclave TeeKind = "VSMEnclave"
)

// PossibleTeeKindValues returns an array of possible values for the TeeKind const type.
func PossibleTeeKindValues() []TeeKind {
	return []TeeKind{CyResComponent, OpenEnclave, SgxEnclave, VSMEnclave}
}
