package attestation

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicyClient is the describes the interface for the per-tenant enclave service.
type PolicyClient struct {
	BaseClient
}

// NewPolicyClient creates an instance of the PolicyClient client.
func NewPolicyClient() PolicyClient {
	return PolicyClient{New()}
}

// Get sends the get request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
// attestationType - specifies the trusted execution environment to be used to validate the evidence
func (client PolicyClient) Get(ctx context.Context, instanceURL string, attestationType Type) (result PolicyResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, instanceURL, attestationType)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PolicyClient) GetPreparer(ctx context.Context, instanceURL string, attestationType Type) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	pathParameters := map[string]interface{}{
		"attestationType": autorest.Encode("path", attestationType),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPathParameters("/policies/{attestationType}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PolicyClient) GetResponder(resp *http.Response) (result PolicyResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Reset sends the reset request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
// attestationType - specifies the trusted execution environment to be used to validate the evidence
// policyJws - JSON Web Signature with an empty policy document
func (client PolicyClient) Reset(ctx context.Context, instanceURL string, attestationType Type, policyJws string) (result PolicyResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyClient.Reset")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: policyJws,
			Constraints: []validation.Constraint{{Target: "policyJws", Name: validation.Pattern, Rule: `[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("attestation.PolicyClient", "Reset", err.Error())
	}

	req, err := client.ResetPreparer(ctx, instanceURL, attestationType, policyJws)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Reset", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Reset", resp, "Failure sending request")
		return
	}

	result, err = client.ResetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Reset", resp, "Failure responding to request")
		return
	}

	return
}

// ResetPreparer prepares the Reset request.
func (client PolicyClient) ResetPreparer(ctx context.Context, instanceURL string, attestationType Type, policyJws string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	pathParameters := map[string]interface{}{
		"attestationType": autorest.Encode("path", attestationType),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPathParameters("/policies/{attestationType}:reset", pathParameters),
		autorest.WithJSON(policyJws),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetSender sends the Reset request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyClient) ResetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ResetResponder handles the response to the Reset request. The method always
// closes the http.Response Body.
func (client PolicyClient) ResetResponder(resp *http.Response) (result PolicyResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Set sends the set request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
// attestationType - specifies the trusted execution environment to be used to validate the evidence
// newAttestationPolicy - JWT Expressing the new policy whose body is a StoredAttestationPolicy object.
func (client PolicyClient) Set(ctx context.Context, instanceURL string, attestationType Type, newAttestationPolicy string) (result PolicyResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyClient.Set")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: newAttestationPolicy,
			Constraints: []validation.Constraint{{Target: "newAttestationPolicy", Name: validation.Pattern, Rule: `[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("attestation.PolicyClient", "Set", err.Error())
	}

	req, err := client.SetPreparer(ctx, instanceURL, attestationType, newAttestationPolicy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Set", nil, "Failure preparing request")
		return
	}

	resp, err := client.SetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Set", resp, "Failure sending request")
		return
	}

	result, err = client.SetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyClient", "Set", resp, "Failure responding to request")
		return
	}

	return
}

// SetPreparer prepares the Set request.
func (client PolicyClient) SetPreparer(ctx context.Context, instanceURL string, attestationType Type, newAttestationPolicy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	pathParameters := map[string]interface{}{
		"attestationType": autorest.Encode("path", attestationType),
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPathParameters("/policies/{attestationType}", pathParameters),
		autorest.WithJSON(newAttestationPolicy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SetSender sends the Set request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyClient) SetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SetResponder handles the response to the Set request. The method always
// closes the http.Response Body.
func (client PolicyClient) SetResponder(resp *http.Response) (result PolicyResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
