package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/hdinsight/2018-11-01-preview/hdinsight"

// AppState the State of the application.
type AppState struct {
	autorest.Response `json:"-"`
	// State - The State of the application. Possible values include: 'NEW', 'NEWSAVING', 'SUBMITTED', 'ACCEPTED', 'RUNNING', 'FINISHED', 'FINISHING', 'FAILED', 'KILLED'
	State ApplicationState `json:"state,omitempty"`
}

// JobDetailRootJSONObject the object containing the job details.
type JobDetailRootJSONObject struct {
	autorest.Response `json:"-"`
	// Callback - The callback URL, if any.
	Callback interface{} `json:"callback,omitempty"`
	// Completed - The string representing completed status, for example 'done'.
	Completed *string `json:"completed,omitempty"`
	// ExitValue - The job's exit value.
	ExitValue *int32 `json:"exitValue,omitempty"`
	// ID - The job ID.
	ID *string `json:"id,omitempty"`
	// Msg - The message returned.
	Msg interface{} `json:"msg,omitempty"`
	// ParentID - The parent job ID.
	ParentID *string `json:"parentId,omitempty"`
	// PercentComplete - The job completion percentage, for example '75% complete'.
	PercentComplete *string `json:"percentComplete,omitempty"`
	// Profile - The object containing the job profile information.
	Profile *Profile `json:"profile,omitempty"`
	// Status - The object containing the job status information.
	Status *Status `json:"status,omitempty"`
	// User - The user name of the job creator.
	User *string `json:"user,omitempty"`
	// Userargs - The arguments passed in by the user.
	Userargs *Userargs `json:"userargs,omitempty"`
}

// JobID the object with the Job ID.
type JobID struct {
	// ID - The job number.
	ID *int64 `json:"id,omitempty"`
	// JtIdentifier - The jobTracker identifier.
	JtIdentifier *string `json:"jtIdentifier,omitempty"`
}

// JobListJSONObject the List Job operation response.
type JobListJSONObject struct {
	// Detail - The detail of the job.
	Detail *JobDetailRootJSONObject `json:"detail,omitempty"`
	// ID - The Id of the job.
	ID *string `json:"id,omitempty"`
}

// JobOperationsErrorResponse describes the format of Error response.
type JobOperationsErrorResponse struct {
	// Error - Error message indicating why the operation failed.
	Error *string `json:"error,omitempty"`
}

// JobSubmissionJSONResponse the job submission json response.
type JobSubmissionJSONResponse struct {
	autorest.Response `json:"-"`
	// ID - The Id of the created job.
	ID *string `json:"id,omitempty"`
}

// ListJobListJSONObject ...
type ListJobListJSONObject struct {
	autorest.Response `json:"-"`
	Value             *[]JobListJSONObject `json:"value,omitempty"`
}

// Profile the object containing the job profile information.
type Profile struct {
	// JobFile - The job configuration file.
	JobFile *string `json:"jobFile,omitempty"`
	// JobID - The full ID of the job.
	JobID *string `json:"jobId,omitempty"`
	// JobName - The user-specified job name.
	JobName *string `json:"jobName,omitempty"`
	// QueueName - The name of the queue to which the job is submitted.
	QueueName *string `json:"queueName,omitempty"`
	// URL - The link to the web-ui for details of the job.
	URL *string `json:"url,omitempty"`
	// User - The userid of the person who submitted the job.
	User *string `json:"user,omitempty"`
}

// SparkBatchJob ...
type SparkBatchJob struct {
	autorest.Response `json:"-"`
	// ID - The livy id of the spark batch job.
	ID *int32 `json:"id,omitempty"`
	// AppID - The application id of this job.
	AppID *string `json:"appId,omitempty"`
	// AppInfo - The detailed application info.
	AppInfo map[string]*string `json:"appInfo"`
	// State - The current state of the spark batch job. Possible values include: 'NotStarted', 'Starting', 'Idle', 'Running', 'Busy', 'ShuttingDown', 'Error', 'Dead', 'Killed', 'Success', 'Recovering'
	State JobState `json:"state,omitempty"`
	// LogLines - The log lines.
	LogLines *[]string `json:"log,omitempty"`
}

// MarshalJSON is the custom marshaler for SparkBatchJob.
func (sbj SparkBatchJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbj.ID != nil {
		objectMap["id"] = sbj.ID
	}
	if sbj.AppID != nil {
		objectMap["appId"] = sbj.AppID
	}
	if sbj.AppInfo != nil {
		objectMap["appInfo"] = sbj.AppInfo
	}
	if sbj.State != "" {
		objectMap["state"] = sbj.State
	}
	if sbj.LogLines != nil {
		objectMap["log"] = sbj.LogLines
	}
	return json.Marshal(objectMap)
}

// SparkBatchJobCollection ...
type SparkBatchJobCollection struct {
	autorest.Response `json:"-"`
	// From - The start index to fetch Spark Batch jobs.
	From *int32 `json:"from,omitempty"`
	// Total - Number of Spark Batch jobs to fetch.
	Total *int32 `json:"total,omitempty"`
	// Sessions - List of spark batch jobs.
	Sessions *[]SparkBatchJob `json:"sessions,omitempty"`
}

// SparkBatchJobRequest ...
type SparkBatchJobRequest struct {
	// File - File containing the application to execute.
	File *string `json:"file,omitempty"`
	// ProxyUser - User to impersonate when running the job.
	ProxyUser *string `json:"proxyUser,omitempty"`
	// ClassName - Application Java/Spark main class.
	ClassName *string `json:"className,omitempty"`
	// Arguments - Command line arguments for the application.
	Arguments *[]string `json:"args,omitempty"`
	// Jars - Jars to be used in this batch job.
	Jars *[]string `json:"jars,omitempty"`
	// PythonFiles - Python files to be used in this batch job.
	PythonFiles *[]string `json:"pyFiles,omitempty"`
	// Files - Files to be used in this batch job.
	Files *[]string `json:"files,omitempty"`
	// DriverMemory - Amount of memory to use for the driver process.
	DriverMemory *string `json:"driverMemory,omitempty"`
	// DriverCores - Number of cores to use for the driver process.
	DriverCores *int32 `json:"driverCores,omitempty"`
	// ExecutorMemory - Amount of memory to use per executor process.
	ExecutorMemory *string `json:"executorMemory,omitempty"`
	// ExecutorCores - Number of cores to use for each executor.
	ExecutorCores *int32 `json:"executorCores,omitempty"`
	// ExecutorCount - Number of executors to launch for this batch job.
	ExecutorCount *int32 `json:"numExecutors,omitempty"`
	// Archives - Archives to be used in this batch job.
	Archives *[]string `json:"archives,omitempty"`
	// Queue - The name of the YARN queue to which submitted.
	Queue *string `json:"queue,omitempty"`
	// Name - The name of this batch job.
	Name *string `json:"name,omitempty"`
	// Configuration - Spark configuration properties.
	Configuration map[string]*string `json:"conf"`
}

// MarshalJSON is the custom marshaler for SparkBatchJobRequest.
func (sbjr SparkBatchJobRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbjr.File != nil {
		objectMap["file"] = sbjr.File
	}
	if sbjr.ProxyUser != nil {
		objectMap["proxyUser"] = sbjr.ProxyUser
	}
	if sbjr.ClassName != nil {
		objectMap["className"] = sbjr.ClassName
	}
	if sbjr.Arguments != nil {
		objectMap["args"] = sbjr.Arguments
	}
	if sbjr.Jars != nil {
		objectMap["jars"] = sbjr.Jars
	}
	if sbjr.PythonFiles != nil {
		objectMap["pyFiles"] = sbjr.PythonFiles
	}
	if sbjr.Files != nil {
		objectMap["files"] = sbjr.Files
	}
	if sbjr.DriverMemory != nil {
		objectMap["driverMemory"] = sbjr.DriverMemory
	}
	if sbjr.DriverCores != nil {
		objectMap["driverCores"] = sbjr.DriverCores
	}
	if sbjr.ExecutorMemory != nil {
		objectMap["executorMemory"] = sbjr.ExecutorMemory
	}
	if sbjr.ExecutorCores != nil {
		objectMap["executorCores"] = sbjr.ExecutorCores
	}
	if sbjr.ExecutorCount != nil {
		objectMap["numExecutors"] = sbjr.ExecutorCount
	}
	if sbjr.Archives != nil {
		objectMap["archives"] = sbjr.Archives
	}
	if sbjr.Queue != nil {
		objectMap["queue"] = sbjr.Queue
	}
	if sbjr.Name != nil {
		objectMap["name"] = sbjr.Name
	}
	if sbjr.Configuration != nil {
		objectMap["conf"] = sbjr.Configuration
	}
	return json.Marshal(objectMap)
}

// SparkJobDeletedResult ...
type SparkJobDeletedResult struct {
	autorest.Response `json:"-"`
	DeletedMessage    *string `json:"msg,omitempty"`
}

// SparkJobLog ...
type SparkJobLog struct {
	autorest.Response `json:"-"`
	// ID - The livy id of the spark job.
	ID *int32 `json:"id,omitempty"`
	// From - Offset from start of log.
	From *int32 `json:"from,omitempty"`
	// Size - Max number of log lines.
	Size *int32 `json:"size,omitempty"`
	// Total - Total number of log lines.
	Total *int64 `json:"total,omitempty"`
	// LogLines - The log lines.
	LogLines *[]string `json:"log,omitempty"`
}

// SparkJobState ...
type SparkJobState struct {
	autorest.Response `json:"-"`
	// ID - The livy id of the spark job.
	ID *int32 `json:"id,omitempty"`
	// State - The current state of the spark job. Possible values include: 'NotStarted', 'Starting', 'Idle', 'Running', 'Busy', 'ShuttingDown', 'Error', 'Dead', 'Killed', 'Success', 'Recovering'
	State JobState `json:"state,omitempty"`
}

// SparkSessionCollection ...
type SparkSessionCollection struct {
	autorest.Response `json:"-"`
	// From - The start index to fetch spark sessions.
	From *int32 `json:"from,omitempty"`
	// Total - Number of spark sessions to fetch.
	Total *int32 `json:"total,omitempty"`
	// Sessions - List of spark sessions.
	Sessions *[]SparkSessionJob `json:"sessions,omitempty"`
}

// SparkSessionJob ...
type SparkSessionJob struct {
	autorest.Response `json:"-"`
	// ID - The livy id of the spark session job.
	ID *int32 `json:"id,omitempty"`
	// AppID - The application id of this job.
	AppID *string `json:"appId,omitempty"`
	// Owner - Remote user who submitted this job.
	Owner *string `json:"owner,omitempty"`
	// ProxyUser - User to impersonate when running.
	ProxyUser *string `json:"proxyUser,omitempty"`
	// Kind - Spark session job kind. Possible values include: 'Spark', 'Pyspark', 'Sparkr', 'SQL'
	Kind SessionJobKind `json:"kind,omitempty"`
	// LogLines - The log lines.
	LogLines *[]string `json:"log,omitempty"`
	// State - The current state of the spark session job. Possible values include: 'NotStarted', 'Starting', 'Idle', 'Running', 'Busy', 'ShuttingDown', 'Error', 'Dead', 'Killed', 'Success', 'Recovering'
	State JobState `json:"state,omitempty"`
	// AppInfo - The detailed application info.
	AppInfo map[string]*string `json:"appInfo"`
}

// MarshalJSON is the custom marshaler for SparkSessionJob.
func (ssj SparkSessionJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssj.ID != nil {
		objectMap["id"] = ssj.ID
	}
	if ssj.AppID != nil {
		objectMap["appId"] = ssj.AppID
	}
	if ssj.Owner != nil {
		objectMap["owner"] = ssj.Owner
	}
	if ssj.ProxyUser != nil {
		objectMap["proxyUser"] = ssj.ProxyUser
	}
	if ssj.Kind != "" {
		objectMap["kind"] = ssj.Kind
	}
	if ssj.LogLines != nil {
		objectMap["log"] = ssj.LogLines
	}
	if ssj.State != "" {
		objectMap["state"] = ssj.State
	}
	if ssj.AppInfo != nil {
		objectMap["appInfo"] = ssj.AppInfo
	}
	return json.Marshal(objectMap)
}

// SparkSessionJobRequest ...
type SparkSessionJobRequest struct {
	// Kind - Spark session job kind. Possible values include: 'Spark', 'Pyspark', 'Sparkr', 'SQL'
	Kind SessionJobKind `json:"kind,omitempty"`
	// ProxyUser - User to impersonate when starting the session.
	ProxyUser *string `json:"proxyUser,omitempty"`
	// Jars - Jars to be used in this session.
	Jars *[]string `json:"jars,omitempty"`
	// PythonFiles - Python files to be used in this session.
	PythonFiles *[]string `json:"pyFiles,omitempty"`
	// Files - Files to be used in this session.
	Files *[]string `json:"files,omitempty"`
	// DriverMemory - Amount of memory to use for the driver process.
	DriverMemory *string `json:"driverMemory,omitempty"`
	// DriverCores - Number of cores to use for the driver process.
	DriverCores *int32 `json:"driverCores,omitempty"`
	// ExecutorMemory - Amount of memory to use per executor process.
	ExecutorMemory *string `json:"executorMemory,omitempty"`
	// ExecutorCores - Number of cores to use for each executor.
	ExecutorCores *int32 `json:"executorCores,omitempty"`
	// ExecutorCount - Number of executors to launch for this session.
	ExecutorCount *int32 `json:"numExecutors,omitempty"`
	// Archives - Archives to be used in this session.
	Archives *[]string `json:"archives,omitempty"`
	// Queue - The name of the YARN queue to which submitted.
	Queue *string `json:"queue,omitempty"`
	// Name - The name of this session.
	Name *string `json:"name,omitempty"`
	// Configuration - Spark configuration properties.
	Configuration map[string]*string `json:"conf"`
	// HeartbeatTimeoutInSecond - Timeout in second to which session be orphaned.
	HeartbeatTimeoutInSecond *int32 `json:"heartbeatTimeoutInSecond,omitempty"`
}

// MarshalJSON is the custom marshaler for SparkSessionJobRequest.
func (ssjr SparkSessionJobRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssjr.Kind != "" {
		objectMap["kind"] = ssjr.Kind
	}
	if ssjr.ProxyUser != nil {
		objectMap["proxyUser"] = ssjr.ProxyUser
	}
	if ssjr.Jars != nil {
		objectMap["jars"] = ssjr.Jars
	}
	if ssjr.PythonFiles != nil {
		objectMap["pyFiles"] = ssjr.PythonFiles
	}
	if ssjr.Files != nil {
		objectMap["files"] = ssjr.Files
	}
	if ssjr.DriverMemory != nil {
		objectMap["driverMemory"] = ssjr.DriverMemory
	}
	if ssjr.DriverCores != nil {
		objectMap["driverCores"] = ssjr.DriverCores
	}
	if ssjr.ExecutorMemory != nil {
		objectMap["executorMemory"] = ssjr.ExecutorMemory
	}
	if ssjr.ExecutorCores != nil {
		objectMap["executorCores"] = ssjr.ExecutorCores
	}
	if ssjr.ExecutorCount != nil {
		objectMap["numExecutors"] = ssjr.ExecutorCount
	}
	if ssjr.Archives != nil {
		objectMap["archives"] = ssjr.Archives
	}
	if ssjr.Queue != nil {
		objectMap["queue"] = ssjr.Queue
	}
	if ssjr.Name != nil {
		objectMap["name"] = ssjr.Name
	}
	if ssjr.Configuration != nil {
		objectMap["conf"] = ssjr.Configuration
	}
	if ssjr.HeartbeatTimeoutInSecond != nil {
		objectMap["heartbeatTimeoutInSecond"] = ssjr.HeartbeatTimeoutInSecond
	}
	return json.Marshal(objectMap)
}

// SparkStatement ...
type SparkStatement struct {
	autorest.Response `json:"-"`
	// ID - The livy id of the spark statement job.
	ID *int32 `json:"id,omitempty"`
	// Code - The execution code.
	Code *string `json:"code,omitempty"`
	// State - The current state of the spark statement. Possible values include: 'StatementStateWaiting', 'StatementStateRunning', 'StatementStateAvailable', 'StatementStateError', 'StatementStateCancelling', 'StatementStateCancelled'
	State StatementState `json:"state,omitempty"`
	// Output - The execution output.
	Output *SparkStatementOutput `json:"output,omitempty"`
	// Progress - The execution progress.
	Progress *float64 `json:"progress,omitempty"`
}

// SparkStatementCancellationResult ...
type SparkStatementCancellationResult struct {
	autorest.Response `json:"-"`
	CancelMessage     *string `json:"msg,omitempty"`
}

// SparkStatementCollection ...
type SparkStatementCollection struct {
	autorest.Response `json:"-"`
	// Statements - List of spark statements.
	Statements *[]SparkStatement `json:"statements,omitempty"`
}

// SparkStatementOutput ...
type SparkStatementOutput struct {
	// Status - Execution status. Possible values include: 'StatementExecutionStatusOk', 'StatementExecutionStatusError', 'StatementExecutionStatusAbort'
	Status StatementExecutionStatus `json:"status,omitempty"`
	// ExecutionCount - A monotonically increasing number.
	ExecutionCount *int32 `json:"execution_count,omitempty"`
	// Data - Statement output.
	Data interface{} `json:"data,omitempty"`
}

// SparkStatementRequest ...
type SparkStatementRequest struct {
	Code *string `json:"code,omitempty"`
	// Kind - Possible values include: 'Spark', 'Pyspark', 'Sparkr', 'SQL'
	Kind SessionJobKind `json:"kind,omitempty"`
}

// Status gets or sets the object containing the job status information.
type Status struct {
	// CleanupProgress - The progress made on the cleanup.
	CleanupProgress *float64 `json:"cleanupProgress,omitempty"`
	// FailureInfo - The information about any failures that have occurred.
	FailureInfo *string `json:"failureInfo,omitempty"`
	// FinishTime - The time at which the job completed. It is an integer in milliseconds, as a Unix timestamp relative to 1/1/1970 00:00:00.
	FinishTime *int64 `json:"finishTime,omitempty"`
	// HistoryFile - The history file of the job.
	HistoryFile *string `json:"historyFile,omitempty"`
	// JobACLs - The ACLs of the job.
	JobACLs interface{} `json:"jobACLs,omitempty"`
	// JobComplete - Whether or not the job has completed.
	JobComplete *bool `json:"jobComplete,omitempty"`
	// JobFile - The job configuration file.
	JobFile *string `json:"jobFile,omitempty"`
	// JobID - The full ID of the job.
	JobID *string `json:"jobId,omitempty"`
	// JobName - The user-specified job name.
	JobName *string `json:"jobName,omitempty"`
	// JobPriority - The priority of the job.
	JobPriority *string `json:"jobPriority,omitempty"`
	// MapProgress - The progress made on the maps.
	MapProgress *float64 `json:"mapProgress,omitempty"`
	// NeededMem - The amount of memory needed for the job.
	NeededMem *int64 `json:"neededMem,omitempty"`
	// NumReservedSlots - The number of slots reserved.
	NumReservedSlots *int32 `json:"numReservedSlots,omitempty"`
	// NumUsedSlots - The number of slots used for the job.
	NumUsedSlots *int32 `json:"numUsedSlots,omitempty"`
	// Priority - The priority of the job.
	Priority *string `json:"priority,omitempty"`
	// Queue - The job queue name.
	Queue *string `json:"queue,omitempty"`
	// ReduceProgress - The progress made on the reduces.
	ReduceProgress *float64 `json:"reduceProgress,omitempty"`
	// ReservedMem - The amount of memory reserved for the job.
	ReservedMem *int64 `json:"reservedMem,omitempty"`
	// Retired - Whether or not the job has been retired.
	Retired *bool `json:"retired,omitempty"`
	// RunState - The current state of the job.
	RunState *int32 `json:"runState,omitempty"`
	// SchedulingInfo - The information about the scheduling of the job.
	SchedulingInfo *string `json:"schedulingInfo,omitempty"`
	// SetupProgress - The progress made on the setup.
	SetupProgress *float64 `json:"setupProgress,omitempty"`
	// StartTime - The time at which the job started. It is an integer in milliseconds, as a Unix timestamp relative to 1/1/1970 00:00:00.
	StartTime *int64 `json:"startTime,omitempty"`
	// State - The state of the job.
	State *string `json:"state,omitempty"`
	// TrackingURL - The link to the web-ui for details of the job.
	TrackingURL *string `json:"trackingUrl,omitempty"`
	// Uber - Whether job running in uber mode.
	Uber *bool `json:"uber,omitempty"`
	// UsedMem - The amount of memory used by the job.
	UsedMem *int64 `json:"usedMem,omitempty"`
	// Username - The userid of the person who submitted the job.
	Username *string `json:"username,omitempty"`
}

// Userargs gets or sets the object containing the user arguments.
type Userargs struct {
	// Arg - READ-ONLY; The list of args defined by the user.
	Arg *[]string `json:"arg,omitempty"`
	// Callback - The callback URL, if any.
	Callback interface{} `json:"callback,omitempty"`
	// Define - READ-ONLY; The define properties defined by the user.
	Define *[]string `json:"define,omitempty"`
	// Enablelog - Whether or not the user enabled logs.
	Enablelog *string `json:"enablelog,omitempty"`
	// Execute - The query defined by the user.
	Execute *string `json:"execute,omitempty"`
	// File - The query file provided by the user.
	File interface{} `json:"file,omitempty"`
	// Files - The files defined by the user.
	Files interface{} `json:"files,omitempty"`
	// Jar - The JAR file provided by the user.
	Jar *string `json:"jar,omitempty"`
	// Statusdir - The status directory defined by the user.
	Statusdir interface{} `json:"statusdir,omitempty"`
}

// MarshalJSON is the custom marshaler for Userargs.
func (u Userargs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Callback != nil {
		objectMap["callback"] = u.Callback
	}
	if u.Enablelog != nil {
		objectMap["enablelog"] = u.Enablelog
	}
	if u.Execute != nil {
		objectMap["execute"] = u.Execute
	}
	if u.File != nil {
		objectMap["file"] = u.File
	}
	if u.Files != nil {
		objectMap["files"] = u.Files
	}
	if u.Jar != nil {
		objectMap["jar"] = u.Jar
	}
	if u.Statusdir != nil {
		objectMap["statusdir"] = u.Statusdir
	}
	return json.Marshal(objectMap)
}
