package accesscontrol

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleDefinitionsClient is the client for the RoleDefinitions methods of the Accesscontrol service.
type RoleDefinitionsClient struct {
	BaseClient
}

// NewRoleDefinitionsClient creates an instance of the RoleDefinitionsClient client.
func NewRoleDefinitionsClient(endpoint string) RoleDefinitionsClient {
	return RoleDefinitionsClient{New(endpoint)}
}

// GetRoleDefinitionByID get role definition by role definition Id.
// Parameters:
// roleDefinitionID - synapse Built-In Role Definition Id.
func (client RoleDefinitionsClient) GetRoleDefinitionByID(ctx context.Context, roleDefinitionID string) (result SynapseRoleDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionsClient.GetRoleDefinitionByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRoleDefinitionByIDPreparer(ctx, roleDefinitionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "GetRoleDefinitionByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleDefinitionByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "GetRoleDefinitionByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoleDefinitionByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "GetRoleDefinitionByID", resp, "Failure responding to request")
		return
	}

	return
}

// GetRoleDefinitionByIDPreparer prepares the GetRoleDefinitionByID request.
func (client RoleDefinitionsClient) GetRoleDefinitionByIDPreparer(ctx context.Context, roleDefinitionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleDefinitionId": autorest.Encode("path", roleDefinitionID),
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/roleDefinitions/{roleDefinitionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleDefinitionByIDSender sends the GetRoleDefinitionByID request. The method will close the
// http.Response Body if it receives an error.
func (client RoleDefinitionsClient) GetRoleDefinitionByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleDefinitionByIDResponder handles the response to the GetRoleDefinitionByID request. The method always
// closes the http.Response Body.
func (client RoleDefinitionsClient) GetRoleDefinitionByIDResponder(resp *http.Response) (result SynapseRoleDefinition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListRoleDefinitions list role definitions.
// Parameters:
// isBuiltIn - is a Synapse Built-In Role or not.
// scope - scope of the Synapse Built-in Role.
func (client RoleDefinitionsClient) ListRoleDefinitions(ctx context.Context, isBuiltIn *bool, scope string) (result ListSynapseRoleDefinition, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionsClient.ListRoleDefinitions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListRoleDefinitionsPreparer(ctx, isBuiltIn, scope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListRoleDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRoleDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListRoleDefinitions", resp, "Failure sending request")
		return
	}

	result, err = client.ListRoleDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListRoleDefinitions", resp, "Failure responding to request")
		return
	}

	return
}

// ListRoleDefinitionsPreparer prepares the ListRoleDefinitions request.
func (client RoleDefinitionsClient) ListRoleDefinitionsPreparer(ctx context.Context, isBuiltIn *bool, scope string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if isBuiltIn != nil {
		queryParameters["isBuiltIn"] = autorest.Encode("query", *isBuiltIn)
	}
	if len(scope) > 0 {
		queryParameters["scope"] = autorest.Encode("query", scope)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/roleDefinitions"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRoleDefinitionsSender sends the ListRoleDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client RoleDefinitionsClient) ListRoleDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListRoleDefinitionsResponder handles the response to the ListRoleDefinitions request. The method always
// closes the http.Response Body.
func (client RoleDefinitionsClient) ListRoleDefinitionsResponder(resp *http.Response) (result ListSynapseRoleDefinition, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListScopes list rbac scopes.
func (client RoleDefinitionsClient) ListScopes(ctx context.Context) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleDefinitionsClient.ListScopes")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListScopesPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListScopes", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListScopesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListScopes", resp, "Failure sending request")
		return
	}

	result, err = client.ListScopesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.RoleDefinitionsClient", "ListScopes", resp, "Failure responding to request")
		return
	}

	return
}

// ListScopesPreparer prepares the ListScopes request.
func (client RoleDefinitionsClient) ListScopesPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/rbacScopes"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListScopesSender sends the ListScopes request. The method will close the
// http.Response Body if it receives an error.
func (client RoleDefinitionsClient) ListScopesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListScopesResponder handles the response to the ListScopes request. The method always
// closes the http.Response Body.
func (client RoleDefinitionsClient) ListScopesResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
