package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SitesClient is the webSite Management Client
type SitesClient struct {
	BaseClient
}

// NewSitesClient creates an instance of the SitesClient client.
func NewSitesClient(subscriptionID string) SitesClient {
	return NewSitesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSitesClientWithBaseURI creates an instance of the SitesClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSitesClientWithBaseURI(baseURI string, subscriptionID string) SitesClient {
	return SitesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// AddSitePremierAddOn sends the add site premier add on request.
func (client SitesClient) AddSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.AddSitePremierAddOn")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddSitePremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName, premierAddOn)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.AddSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOn", resp, "Failure responding to request")
		return
	}

	return
}

// AddSitePremierAddOnPreparer prepares the AddSitePremierAddOn request.
func (client SitesClient) AddSitePremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSitePremierAddOnSender sends the AddSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) AddSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AddSitePremierAddOnResponder handles the response to the AddSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) AddSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddSitePremierAddOnSlot sends the add site premier add on slot request.
func (client SitesClient) AddSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.AddSitePremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddSitePremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, premierAddOn, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.AddSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "AddSitePremierAddOnSlot", resp, "Failure responding to request")
		return
	}

	return
}

// AddSitePremierAddOnSlotPreparer prepares the AddSitePremierAddOnSlot request.
func (client SitesClient) AddSitePremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn PremierAddOnRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithJSON(premierAddOn),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSitePremierAddOnSlotSender sends the AddSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) AddSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// AddSitePremierAddOnSlotResponder handles the response to the AddSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) AddSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigSlot sends the apply slot config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name. Settings from that slot will be applied on
// the source slot
// slot - name of the source slot. Settings from the target slot will be applied onto this slot
func (client SitesClient) ApplySlotConfigSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ApplySlotConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ApplySlotConfigSlotPreparer(ctx, resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ApplySlotConfigSlotPreparer prepares the ApplySlotConfigSlot request.
func (client SitesClient) ApplySlotConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApplySlotConfigSlotSender sends the ApplySlotConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ApplySlotConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigSlotResponder handles the response to the ApplySlotConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ApplySlotConfigSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ApplySlotConfigToProduction sends the apply slot config to production request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name. Settings from that slot will be applied on
// the source slot
func (client SitesClient) ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ApplySlotConfigToProduction")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ApplySlotConfigToProductionPreparer(ctx, resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.ApplySlotConfigToProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", resp, "Failure sending request")
		return
	}

	result, err = client.ApplySlotConfigToProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ApplySlotConfigToProduction", resp, "Failure responding to request")
		return
	}

	return
}

// ApplySlotConfigToProductionPreparer prepares the ApplySlotConfigToProduction request.
func (client SitesClient) ApplySlotConfigToProductionPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApplySlotConfigToProductionSender sends the ApplySlotConfigToProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ApplySlotConfigToProductionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ApplySlotConfigToProductionResponder handles the response to the ApplySlotConfigToProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) ApplySlotConfigToProductionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSite sends the backup site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on backup request
func (client SitesClient) BackupSite(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.BackupSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.BackupSitePreparer(ctx, resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", resp, "Failure sending request")
		return
	}

	result, err = client.BackupSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSite", resp, "Failure responding to request")
		return
	}

	return
}

// BackupSitePreparer prepares the BackupSite request.
func (client SitesClient) BackupSitePreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// BackupSiteSender sends the BackupSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) BackupSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// BackupSiteResponder handles the response to the BackupSite request. The method always
// closes the http.Response Body.
func (client SitesClient) BackupSiteResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// BackupSiteSlot sends the backup site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on backup request
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) BackupSiteSlot(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.BackupSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.BackupSiteSlotPreparer(ctx, resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.BackupSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.BackupSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "BackupSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// BackupSiteSlotPreparer prepares the BackupSiteSlot request.
func (client SitesClient) BackupSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// BackupSiteSlotSender sends the BackupSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) BackupSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// BackupSiteSlotResponder handles the response to the BackupSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) BackupSiteSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeployment sends the create deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// deployment - details of deployment
func (client SitesClient) CreateDeployment(ctx context.Context, resourceGroupName string, name string, ID string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateDeploymentPreparer(ctx, resourceGroupName, name, ID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// CreateDeploymentPreparer prepares the CreateDeployment request.
func (client SitesClient) CreateDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDeploymentSender sends the CreateDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentResponder handles the response to the CreateDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateDeploymentSlot sends the create deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
// deployment - details of deployment
func (client SitesClient) CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateDeploymentSlotPreparer prepares the CreateDeploymentSlot request.
func (client SitesClient) CreateDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateDeploymentSlotSender sends the CreateDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateDeploymentSlotResponder handles the response to the CreateDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeployment sends the create instance deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// instanceID - id of web app instance
// deployment - details of deployment
func (client SitesClient) CreateInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateInstanceDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateInstanceDeploymentPreparer(ctx, resourceGroupName, name, ID, instanceID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// CreateInstanceDeploymentPreparer prepares the CreateInstanceDeployment request.
func (client SitesClient) CreateInstanceDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateInstanceDeploymentSender sends the CreateInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateInstanceDeploymentResponder handles the response to the CreateInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateInstanceDeploymentSlot sends the create instance deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - id of web app instance
// deployment - details of deployment
func (client SitesClient) CreateInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string, deployment Deployment) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateInstanceDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateInstanceDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot, instanceID, deployment)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateInstanceDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateInstanceDeploymentSlotPreparer prepares the CreateInstanceDeploymentSlot request.
func (client SitesClient) CreateInstanceDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string, deployment Deployment) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithJSON(deployment),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateInstanceDeploymentSlotSender sends the CreateInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateInstanceDeploymentSlotResponder handles the response to the CreateInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSite sends the create or update site request.
// Parameters:
// resourceGroupName - name of the resource group
// name - name of the web app
// siteEnvelope - details of web app if it exists already
// skipDNSRegistration - if true web app hostname is not registered with DNS on creation. This parameter is
// only used for app creation
// skipCustomDomainVerification - if true, custom (non *.azurewebsites.net) domains associated with web app are
// not verified.
// forceDNSRegistration - if true, web app hostname is force registered with DNS
// TTLInSeconds - time to live in seconds for web app's default domain name
func (client SitesClient) CreateOrUpdateSite(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (result SitesCreateOrUpdateSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSitePreparer(ctx, resourceGroupName, name, siteEnvelope, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSite", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSite", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateSitePreparer prepares the CreateOrUpdateSite request.
func (client SitesClient) CreateOrUpdateSitePreparer(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(skipCustomDomainVerification) > 0 {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", skipCustomDomainVerification)
	}
	if len(forceDNSRegistration) > 0 {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteSender sends the CreateOrUpdateSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSender(req *http.Request) (future SitesCreateOrUpdateSiteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (s Site, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesCreateOrUpdateSiteFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		s.Response.Response, err = future.GetResult(sender)
		if s.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
			s, err = client.CreateOrUpdateSiteResponder(s.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteFuture", "Result", s.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateSiteResponder handles the response to the CreateOrUpdateSite request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteConfig sends the create or update site config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteConfig - request body that contains the configuration setting for the web app
func (client SitesClient) CreateOrUpdateSiteConfig(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteConfigPreparer(ctx, resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfig", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteConfigPreparer prepares the CreateOrUpdateSiteConfig request.
func (client SitesClient) CreateOrUpdateSiteConfigPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteConfigSender sends the CreateOrUpdateSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteConfigResponder handles the response to the CreateOrUpdateSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteConfigSlot sends the create or update site config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteConfig - request body that contains the configuration setting for the web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) CreateOrUpdateSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig, slot string) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteConfigSlotPreparer(ctx, resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteConfigSlotPreparer prepares the CreateOrUpdateSiteConfigSlot request.
func (client SitesClient) CreateOrUpdateSiteConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteConfigSlotSender sends the CreateOrUpdateSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteConfigSlotResponder handles the response to the CreateOrUpdateSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteHostNameBinding sends the create or update site host name binding request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// hostName - name of host
// hostNameBinding - host name binding information
func (client SitesClient) CreateOrUpdateSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteHostNameBinding")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteHostNameBindingPreparer(ctx, resourceGroupName, name, hostName, hostNameBinding)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBinding", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteHostNameBindingPreparer prepares the CreateOrUpdateSiteHostNameBinding request.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteHostNameBindingSender sends the CreateOrUpdateSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteHostNameBindingResponder handles the response to the CreateOrUpdateSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteHostNameBindingSlot sends the create or update site host name binding slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// hostName - name of host
// hostNameBinding - host name binding information
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteHostNameBindingSlotPreparer(ctx, resourceGroupName, name, hostName, hostNameBinding, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteHostNameBindingSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteHostNameBindingSlotPreparer prepares the CreateOrUpdateSiteHostNameBindingSlot request.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding HostNameBinding, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithJSON(hostNameBinding),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteHostNameBindingSlotSender sends the CreateOrUpdateSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteHostNameBindingSlotResponder handles the response to the CreateOrUpdateSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteRelayServiceConnection sends the create or update site relay service connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// connectionEnvelope - the details of the Hybrid Connection
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnection", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteRelayServiceConnectionPreparer prepares the CreateOrUpdateSiteRelayServiceConnection request.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteRelayServiceConnectionSender sends the CreateOrUpdateSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteRelayServiceConnectionResponder handles the response to the CreateOrUpdateSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteRelayServiceConnectionSlot sends the create or update site relay service connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// connectionEnvelope - the details of the Hybrid Connection
// slot - the name of the slot for the web app.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteRelayServiceConnectionSlotPreparer prepares the CreateOrUpdateSiteRelayServiceConnectionSlot request.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteRelayServiceConnectionSlotSender sends the CreateOrUpdateSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteRelayServiceConnectionSlotResponder handles the response to the CreateOrUpdateSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteSlot sends the create or update site slot request.
// Parameters:
// resourceGroupName - name of the resource group
// name - name of the web app
// siteEnvelope - details of web app if it exists already
// slot - name of web app slot. If not specified then will default to production slot.
// skipDNSRegistration - if true web app hostname is not registered with DNS on creation. This parameter is
// only used for app creation
// skipCustomDomainVerification - if true, custom (non *.azurewebsites.net) domains associated with web app are
// not verified.
// forceDNSRegistration - if true, web app hostname is force registered with DNS
// TTLInSeconds - time to live in seconds for web app's default domain name
func (client SitesClient) CreateOrUpdateSiteSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (result SitesCreateOrUpdateSiteSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteSlot")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteSlotPreparer(ctx, resourceGroupName, name, siteEnvelope, slot, skipDNSRegistration, skipCustomDomainVerification, forceDNSRegistration, TTLInSeconds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSiteSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSlot", nil, "Failure sending request")
		return
	}

	return
}

// CreateOrUpdateSiteSlotPreparer prepares the CreateOrUpdateSiteSlot request.
func (client SitesClient) CreateOrUpdateSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteEnvelope Site, slot string, skipDNSRegistration string, skipCustomDomainVerification string, forceDNSRegistration string, TTLInSeconds string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(skipCustomDomainVerification) > 0 {
		queryParameters["skipCustomDomainVerification"] = autorest.Encode("query", skipCustomDomainVerification)
	}
	if len(forceDNSRegistration) > 0 {
		queryParameters["forceDnsRegistration"] = autorest.Encode("query", forceDNSRegistration)
	}
	if len(TTLInSeconds) > 0 {
		queryParameters["ttlInSeconds"] = autorest.Encode("query", TTLInSeconds)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithJSON(siteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteSlotSender sends the CreateOrUpdateSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSlotSender(req *http.Request) (future SitesCreateOrUpdateSiteSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (s Site, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteSlotFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesCreateOrUpdateSiteSlotFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		s.Response.Response, err = future.GetResult(sender)
		if s.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteSlotFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
			s, err = client.CreateOrUpdateSiteSlotResponder(s.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesCreateOrUpdateSiteSlotFuture", "Result", s.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// CreateOrUpdateSiteSlotResponder handles the response to the CreateOrUpdateSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteSourceControl sends the create or update site source control request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteSourceControl - request body that contains the source control parameters
func (client SitesClient) CreateOrUpdateSiteSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteSourceControlPreparer(ctx, resourceGroupName, name, siteSourceControl)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControl", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteSourceControlPreparer prepares the CreateOrUpdateSiteSourceControl request.
func (client SitesClient) CreateOrUpdateSiteSourceControlPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteSourceControlSender sends the CreateOrUpdateSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteSourceControlResponder handles the response to the CreateOrUpdateSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteSourceControlSlot sends the create or update site source control slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteSourceControl - request body that contains the source control parameters
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteSourceControlSlotPreparer(ctx, resourceGroupName, name, siteSourceControl, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteSourceControlSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteSourceControlSlotPreparer prepares the CreateOrUpdateSiteSourceControlSlot request.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteSourceControlSlotSender sends the CreateOrUpdateSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteSourceControlSlotResponder handles the response to the CreateOrUpdateSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnection sends the create or update site vnet connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// connectionEnvelope - the properties of this Virtual Network Connection
func (client SitesClient) CreateOrUpdateSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteVNETConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteVNETConnectionPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnection", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteVNETConnectionPreparer prepares the CreateOrUpdateSiteVNETConnection request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteVNETConnectionSender sends the CreateOrUpdateSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteVNETConnectionResponder handles the response to the CreateOrUpdateSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionGateway sends the create or update site vnet connection gateway request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope - the properties to update this gateway with.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteVNETConnectionGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteVNETConnectionGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGateway", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteVNETConnectionGatewayPreparer prepares the CreateOrUpdateSiteVNETConnectionGateway request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteVNETConnectionGatewaySender sends the CreateOrUpdateSiteVNETConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteVNETConnectionGatewayResponder handles the response to the CreateOrUpdateSiteVNETConnectionGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionGatewaySlot sends the create or update site vnet connection gateway slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope - the properties to update this gateway with.
// slot - the name of the slot for this web app.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteVNETConnectionGatewaySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionGatewaySlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer prepares the CreateOrUpdateSiteVNETConnectionGatewaySlot request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotSender sends the CreateOrUpdateSiteVNETConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteVNETConnectionGatewaySlotResponder handles the response to the CreateOrUpdateSiteVNETConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateSiteVNETConnectionSlot sends the create or update site vnet connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// connectionEnvelope - the properties of this Virtual Network Connection
// slot - the name of the slot for this web app.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.CreateOrUpdateSiteVNETConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateOrUpdateSiteVNETConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "CreateOrUpdateSiteVNETConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateSiteVNETConnectionSlotPreparer prepares the CreateOrUpdateSiteVNETConnectionSlot request.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSiteVNETConnectionSlotSender sends the CreateOrUpdateSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateSiteVNETConnectionSlotResponder handles the response to the CreateOrUpdateSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) CreateOrUpdateSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteBackup sends the delete backup request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
func (client SitesClient) DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteBackup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteBackupPreparer(ctx, resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackup", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteBackupPreparer prepares the DeleteBackup request.
func (client SitesClient) DeleteBackupPreparer(ctx context.Context, resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupSender sends the DeleteBackup request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteBackupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupResponder handles the response to the DeleteBackup request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteBackupResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteBackupSlot sends the delete backup slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteBackupSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteBackupSlotPreparer(ctx, resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteBackupSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteBackupSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteBackupSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteBackupSlotPreparer prepares the DeleteBackupSlot request.
func (client SitesClient) DeleteBackupSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteBackupSlotSender sends the DeleteBackupSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteBackupSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteBackupSlotResponder handles the response to the DeleteBackupSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteBackupSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDeployment sends the delete deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
func (client SitesClient) DeleteDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteDeploymentPreparer(ctx, resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteDeploymentPreparer prepares the DeleteDeployment request.
func (client SitesClient) DeleteDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDeploymentSender sends the DeleteDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentResponder handles the response to the DeleteDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteDeploymentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteDeploymentSlot sends the delete deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteDeploymentSlotPreparer prepares the DeleteDeploymentSlot request.
func (client SitesClient) DeleteDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDeploymentSlotSender sends the DeleteDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteDeploymentSlotResponder handles the response to the DeleteDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteDeploymentSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteInstanceDeployment sends the delete instance deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// instanceID - id of web app instance
func (client SitesClient) DeleteInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteInstanceDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteInstanceDeploymentPreparer(ctx, resourceGroupName, name, ID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteInstanceDeploymentPreparer prepares the DeleteInstanceDeployment request.
func (client SitesClient) DeleteInstanceDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteInstanceDeploymentSender sends the DeleteInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceDeploymentResponder handles the response to the DeleteInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteInstanceDeploymentResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteInstanceDeploymentSlot sends the delete instance deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - id of web app instance
func (client SitesClient) DeleteInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteInstanceDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteInstanceDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteInstanceDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteInstanceDeploymentSlotPreparer prepares the DeleteInstanceDeploymentSlot request.
func (client SitesClient) DeleteInstanceDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteInstanceDeploymentSlotSender sends the DeleteInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteInstanceDeploymentSlotResponder handles the response to the DeleteInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteInstanceDeploymentSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSite sends the delete site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// deleteMetrics - if true, web app metrics are also deleted
// deleteEmptyServerFarm - if true and App Service Plan is empty after web app deletion, App Service Plan is
// also deleted
// skipDNSRegistration - if true, DNS registration is skipped
// deleteAllSlots - if true, all slots associated with web app are also deleted
func (client SitesClient) DeleteSite(ctx context.Context, resourceGroupName string, name string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSitePreparer(ctx, resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration, deleteAllSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSite", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSitePreparer prepares the DeleteSite request.
func (client SitesClient) DeleteSitePreparer(ctx context.Context, resourceGroupName string, name string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(deleteMetrics) > 0 {
		queryParameters["deleteMetrics"] = autorest.Encode("query", deleteMetrics)
	}
	if len(deleteEmptyServerFarm) > 0 {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", deleteEmptyServerFarm)
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(deleteAllSlots) > 0 {
		queryParameters["deleteAllSlots"] = autorest.Encode("query", deleteAllSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteSender sends the DeleteSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteResponder handles the response to the DeleteSite request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteHostNameBinding sends the delete site host name binding request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// hostName - name of host
func (client SitesClient) DeleteSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteHostNameBinding")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteHostNameBindingPreparer(ctx, resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBinding", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteHostNameBindingPreparer prepares the DeleteSiteHostNameBinding request.
func (client SitesClient) DeleteSiteHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteHostNameBindingSender sends the DeleteSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteHostNameBindingResponder handles the response to the DeleteSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteHostNameBindingResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteHostNameBindingSlot sends the delete site host name binding slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// hostName - name of host
func (client SitesClient) DeleteSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteHostNameBindingSlotPreparer(ctx, resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteHostNameBindingSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteHostNameBindingSlotPreparer prepares the DeleteSiteHostNameBindingSlot request.
func (client SitesClient) DeleteSiteHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteHostNameBindingSlotSender sends the DeleteSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteHostNameBindingSlotResponder handles the response to the DeleteSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteHostNameBindingSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSitePremierAddOn sends the delete site premier add on request.
func (client SitesClient) DeleteSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSitePremierAddOn")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSitePremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOn", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSitePremierAddOnPreparer prepares the DeleteSitePremierAddOn request.
func (client SitesClient) DeleteSitePremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSitePremierAddOnSender sends the DeleteSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSitePremierAddOnResponder handles the response to the DeleteSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSitePremierAddOnSlot sends the delete site premier add on slot request.
func (client SitesClient) DeleteSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSitePremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSitePremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSitePremierAddOnSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSitePremierAddOnSlotPreparer prepares the DeleteSitePremierAddOnSlot request.
func (client SitesClient) DeleteSitePremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSitePremierAddOnSlotSender sends the DeleteSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSitePremierAddOnSlotResponder handles the response to the DeleteSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteRelayServiceConnection sends the delete site relay service connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
func (client SitesClient) DeleteSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnection", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteRelayServiceConnectionPreparer prepares the DeleteSiteRelayServiceConnection request.
func (client SitesClient) DeleteSiteRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteRelayServiceConnectionSender sends the DeleteSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteRelayServiceConnectionResponder handles the response to the DeleteSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteRelayServiceConnectionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteRelayServiceConnectionSlot sends the delete site relay service connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// slot - the name of the slot for the web app.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteRelayServiceConnectionSlotPreparer prepares the DeleteSiteRelayServiceConnectionSlot request.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteRelayServiceConnectionSlotSender sends the DeleteSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteRelayServiceConnectionSlotResponder handles the response to the DeleteSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSlot sends the delete site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// deleteMetrics - if true, web app metrics are also deleted
// deleteEmptyServerFarm - if true and App Service Plan is empty after web app deletion, App Service Plan is
// also deleted
// skipDNSRegistration - if true, DNS registration is skipped
// deleteAllSlots - if true, all slots associated with web app are also deleted
func (client SitesClient) DeleteSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteSlotPreparer(ctx, resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, skipDNSRegistration, deleteAllSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteSlotPreparer prepares the DeleteSiteSlot request.
func (client SitesClient) DeleteSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics string, deleteEmptyServerFarm string, skipDNSRegistration string, deleteAllSlots string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(deleteMetrics) > 0 {
		queryParameters["deleteMetrics"] = autorest.Encode("query", deleteMetrics)
	}
	if len(deleteEmptyServerFarm) > 0 {
		queryParameters["deleteEmptyServerFarm"] = autorest.Encode("query", deleteEmptyServerFarm)
	}
	if len(skipDNSRegistration) > 0 {
		queryParameters["skipDnsRegistration"] = autorest.Encode("query", skipDNSRegistration)
	}
	if len(deleteAllSlots) > 0 {
		queryParameters["deleteAllSlots"] = autorest.Encode("query", deleteAllSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteSlotSender sends the DeleteSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteSlotResponder handles the response to the DeleteSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSourceControl sends the delete site source control request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) DeleteSiteSourceControl(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteSourceControlPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControl", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteSourceControlPreparer prepares the DeleteSiteSourceControl request.
func (client SitesClient) DeleteSiteSourceControlPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteSourceControlSender sends the DeleteSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteSourceControlResponder handles the response to the DeleteSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSourceControlResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteSourceControlSlot sends the delete site source control slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) DeleteSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteSourceControlSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteSourceControlSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteSourceControlSlotPreparer prepares the DeleteSiteSourceControlSlot request.
func (client SitesClient) DeleteSiteSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteSourceControlSlotSender sends the DeleteSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteSourceControlSlotResponder handles the response to the DeleteSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteSourceControlSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteVNETConnection sends the delete site vnet connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
func (client SitesClient) DeleteSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteVNETConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteVNETConnectionPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnection", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteVNETConnectionPreparer prepares the DeleteSiteVNETConnection request.
func (client SitesClient) DeleteSiteVNETConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteVNETConnectionSender sends the DeleteSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteVNETConnectionResponder handles the response to the DeleteSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteVNETConnectionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSiteVNETConnectionSlot sends the delete site vnet connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// slot - the name of the slot for this web app.
func (client SitesClient) DeleteSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DeleteSiteVNETConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSiteVNETConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DeleteSiteVNETConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteSiteVNETConnectionSlotPreparer prepares the DeleteSiteVNETConnectionSlot request.
func (client SitesClient) DeleteSiteVNETConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSiteVNETConnectionSlotSender sends the DeleteSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DeleteSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteSiteVNETConnectionSlotResponder handles the response to the DeleteSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DeleteSiteVNETConnectionSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverSiteRestore sends the discover site restore request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on restore request
func (client SitesClient) DiscoverSiteRestore(ctx context.Context, resourceGroupName string, name string, request RestoreRequest) (result RestoreRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DiscoverSiteRestore")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DiscoverSiteRestorePreparer(ctx, resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverSiteRestoreSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverSiteRestoreResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestore", resp, "Failure responding to request")
		return
	}

	return
}

// DiscoverSiteRestorePreparer prepares the DiscoverSiteRestore request.
func (client SitesClient) DiscoverSiteRestorePreparer(ctx context.Context, resourceGroupName string, name string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DiscoverSiteRestoreSender sends the DiscoverSiteRestore request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DiscoverSiteRestoreSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DiscoverSiteRestoreResponder handles the response to the DiscoverSiteRestore request. The method always
// closes the http.Response Body.
func (client SitesClient) DiscoverSiteRestoreResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DiscoverSiteRestoreSlot sends the discover site restore slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on restore request
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) DiscoverSiteRestoreSlot(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, slot string) (result RestoreRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.DiscoverSiteRestoreSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DiscoverSiteRestoreSlotPreparer(ctx, resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.DiscoverSiteRestoreSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", resp, "Failure sending request")
		return
	}

	result, err = client.DiscoverSiteRestoreSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "DiscoverSiteRestoreSlot", resp, "Failure responding to request")
		return
	}

	return
}

// DiscoverSiteRestoreSlotPreparer prepares the DiscoverSiteRestoreSlot request.
func (client SitesClient) DiscoverSiteRestoreSlotPreparer(ctx context.Context, resourceGroupName string, name string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DiscoverSiteRestoreSlotSender sends the DiscoverSiteRestoreSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) DiscoverSiteRestoreSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DiscoverSiteRestoreSlotResponder handles the response to the DiscoverSiteRestoreSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) DiscoverSiteRestoreSlotResponder(resp *http.Response) (result RestoreRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPassword sends the generate new site publishing password request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GenerateNewSitePublishingPassword")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GenerateNewSitePublishingPasswordPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPassword", resp, "Failure responding to request")
		return
	}

	return
}

// GenerateNewSitePublishingPasswordPreparer prepares the GenerateNewSitePublishingPassword request.
func (client SitesClient) GenerateNewSitePublishingPasswordPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GenerateNewSitePublishingPasswordSender sends the GenerateNewSitePublishingPassword request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GenerateNewSitePublishingPasswordSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordResponder handles the response to the GenerateNewSitePublishingPassword request. The method always
// closes the http.Response Body.
func (client SitesClient) GenerateNewSitePublishingPasswordResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GenerateNewSitePublishingPasswordSlot sends the generate new site publishing password slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GenerateNewSitePublishingPasswordSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GenerateNewSitePublishingPasswordSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GenerateNewSitePublishingPasswordSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GenerateNewSitePublishingPasswordSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GenerateNewSitePublishingPasswordSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GenerateNewSitePublishingPasswordSlotPreparer prepares the GenerateNewSitePublishingPasswordSlot request.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GenerateNewSitePublishingPasswordSlotSender sends the GenerateNewSitePublishingPasswordSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GenerateNewSitePublishingPasswordSlotResponder handles the response to the GenerateNewSitePublishingPasswordSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GenerateNewSitePublishingPasswordSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeletedSites sends the get deleted sites request.
// Parameters:
// resourceGroupName - name of resource group
// propertiesToInclude - additional web app properties included in the response
// includeSiteTypes - types of apps included in the response
func (client SitesClient) GetDeletedSites(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (result DeletedSiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeletedSites")
		defer func() {
			sc := -1
			if result.dsc.Response.Response != nil {
				sc = result.dsc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDeletedSitesNextResults
	req, err := client.GetDeletedSitesPreparer(ctx, resourceGroupName, propertiesToInclude, includeSiteTypes)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeletedSitesSender(req)
	if err != nil {
		result.dsc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", resp, "Failure sending request")
		return
	}

	result.dsc, err = client.GetDeletedSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeletedSites", resp, "Failure responding to request")
		return
	}
	if result.dsc.hasNextLink() && result.dsc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDeletedSitesPreparer prepares the GetDeletedSites request.
func (client SitesClient) GetDeletedSitesPreparer(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}
	if len(includeSiteTypes) > 0 {
		queryParameters["includeSiteTypes"] = autorest.Encode("query", includeSiteTypes)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/deletedSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeletedSitesSender sends the GetDeletedSites request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeletedSitesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeletedSitesResponder handles the response to the GetDeletedSites request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeletedSitesResponder(resp *http.Response) (result DeletedSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDeletedSitesNextResults retrieves the next set of results, if any.
func (client SitesClient) getDeletedSitesNextResults(ctx context.Context, lastResults DeletedSiteCollection) (result DeletedSiteCollection, err error) {
	req, err := lastResults.deletedSiteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeletedSitesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDeletedSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeletedSitesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDeletedSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getDeletedSitesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDeletedSitesComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetDeletedSitesComplete(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string) (result DeletedSiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeletedSites")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDeletedSites(ctx, resourceGroupName, propertiesToInclude, includeSiteTypes)
	return
}

// GetDeployment sends the get deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
func (client SitesClient) GetDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDeploymentPreparer(ctx, resourceGroupName, name, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// GetDeploymentPreparer prepares the GetDeployment request.
func (client SitesClient) GetDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentSender sends the GetDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentResponder handles the response to the GetDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeployments sends the get deployments request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetDeployments(ctx context.Context, resourceGroupName string, name string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeployments")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDeploymentsNextResults
	req, err := client.GetDeploymentsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentsSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", resp, "Failure sending request")
		return
	}

	result.dc, err = client.GetDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeployments", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDeploymentsPreparer prepares the GetDeployments request.
func (client SitesClient) GetDeploymentsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentsSender sends the GetDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentsResponder handles the response to the GetDeployments request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDeploymentsNextResults retrieves the next set of results, if any.
func (client SitesClient) getDeploymentsNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDeploymentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetDeploymentsComplete(ctx context.Context, resourceGroupName string, name string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeployments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDeployments(ctx, resourceGroupName, name)
	return
}

// GetDeploymentSlot sends the get deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetDeploymentSlotPreparer prepares the GetDeploymentSlot request.
func (client SitesClient) GetDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentSlotSender sends the GetDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentSlotResponder handles the response to the GetDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeploymentsSlot sends the get deployments slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeploymentsSlot")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDeploymentsSlotNextResults
	req, err := client.GetDeploymentsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeploymentsSlotSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result.dc, err = client.GetDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetDeploymentsSlot", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDeploymentsSlotPreparer prepares the GetDeploymentsSlot request.
func (client SitesClient) GetDeploymentsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeploymentsSlotSender sends the GetDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeploymentsSlotResponder handles the response to the GetDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getDeploymentsSlotNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getDeploymentsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDeploymentsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetDeploymentsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetDeploymentsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDeploymentsSlot(ctx, resourceGroupName, name, slot)
	return
}

// GetInstanceDeployment sends the get instance deployment request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// instanceID - id of web app instance
func (client SitesClient) GetInstanceDeployment(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeployment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetInstanceDeploymentPreparer(ctx, resourceGroupName, name, ID, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceDeploymentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployment", resp, "Failure responding to request")
		return
	}

	return
}

// GetInstanceDeploymentPreparer prepares the GetInstanceDeployment request.
func (client SitesClient) GetInstanceDeploymentPreparer(ctx context.Context, resourceGroupName string, name string, ID string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceDeploymentSender sends the GetInstanceDeployment request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceDeploymentResponder handles the response to the GetInstanceDeployment request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeployments sends the get instance deployments request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// instanceID - id of web app instance
func (client SitesClient) GetInstanceDeployments(ctx context.Context, resourceGroupName string, name string, instanceID string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeployments")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getInstanceDeploymentsNextResults
	req, err := client.GetInstanceDeploymentsPreparer(ctx, resourceGroupName, name, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentsSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", resp, "Failure sending request")
		return
	}

	result.dc, err = client.GetInstanceDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeployments", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetInstanceDeploymentsPreparer prepares the GetInstanceDeployments request.
func (client SitesClient) GetInstanceDeploymentsPreparer(ctx context.Context, resourceGroupName string, name string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceDeploymentsSender sends the GetInstanceDeployments request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceDeploymentsResponder handles the response to the GetInstanceDeployments request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentsResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getInstanceDeploymentsNextResults retrieves the next set of results, if any.
func (client SitesClient) getInstanceDeploymentsNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetInstanceDeploymentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetInstanceDeploymentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetInstanceDeploymentsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetInstanceDeploymentsComplete(ctx context.Context, resourceGroupName string, name string, instanceID string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeployments")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetInstanceDeployments(ctx, resourceGroupName, name, instanceID)
	return
}

// GetInstanceDeploymentSlot sends the get instance deployment slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// ID - id of the deployment
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - id of web app instance
func (client SitesClient) GetInstanceDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (result Deployment, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeploymentSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetInstanceDeploymentSlotPreparer(ctx, resourceGroupName, name, ID, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetInstanceDeploymentSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetInstanceDeploymentSlotPreparer prepares the GetInstanceDeploymentSlot request.
func (client SitesClient) GetInstanceDeploymentSlotPreparer(ctx context.Context, resourceGroupName string, name string, ID string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id":                autorest.Encode("path", ID),
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceDeploymentSlotSender sends the GetInstanceDeploymentSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceDeploymentSlotResponder handles the response to the GetInstanceDeploymentSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentSlotResponder(resp *http.Response) (result Deployment, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetInstanceDeploymentsSlot sends the get instance deployments slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// instanceID - id of web app instance
func (client SitesClient) GetInstanceDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result DeploymentCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeploymentsSlot")
		defer func() {
			sc := -1
			if result.dc.Response.Response != nil {
				sc = result.dc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getInstanceDeploymentsSlotNextResults
	req, err := client.GetInstanceDeploymentsSlotPreparer(ctx, resourceGroupName, name, slot, instanceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetInstanceDeploymentsSlotSender(req)
	if err != nil {
		result.dc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", resp, "Failure sending request")
		return
	}

	result.dc, err = client.GetInstanceDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetInstanceDeploymentsSlot", resp, "Failure responding to request")
		return
	}
	if result.dc.hasNextLink() && result.dc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetInstanceDeploymentsSlotPreparer prepares the GetInstanceDeploymentsSlot request.
func (client SitesClient) GetInstanceDeploymentsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"instanceId":        autorest.Encode("path", instanceID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetInstanceDeploymentsSlotSender sends the GetInstanceDeploymentsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetInstanceDeploymentsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetInstanceDeploymentsSlotResponder handles the response to the GetInstanceDeploymentsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetInstanceDeploymentsSlotResponder(resp *http.Response) (result DeploymentCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getInstanceDeploymentsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getInstanceDeploymentsSlotNextResults(ctx context.Context, lastResults DeploymentCollection) (result DeploymentCollection, err error) {
	req, err := lastResults.deploymentCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetInstanceDeploymentsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetInstanceDeploymentsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getInstanceDeploymentsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetInstanceDeploymentsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetInstanceDeploymentsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result DeploymentCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetInstanceDeploymentsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetInstanceDeploymentsSlot(ctx, resourceGroupName, name, slot, instanceID)
	return
}

// GetSite sends the get site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// propertiesToInclude - additional web app properties included in the response
func (client SitesClient) GetSite(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result Site, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSitePreparer(ctx, resourceGroupName, name, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSite", resp, "Failure responding to request")
		return
	}

	return
}

// GetSitePreparer prepares the GetSite request.
func (client SitesClient) GetSitePreparer(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSender sends the GetSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteResponder handles the response to the GetSite request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupConfiguration sends the get site backup configuration request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupConfigurationPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfiguration", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupConfigurationPreparer prepares the GetSiteBackupConfiguration request.
func (client SitesClient) GetSiteBackupConfigurationPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupConfigurationSender sends the GetSiteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupConfigurationResponder handles the response to the GetSiteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupConfigurationSlot sends the get site backup configuration slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupConfigurationSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupConfigurationSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupConfigurationSlotPreparer prepares the GetSiteBackupConfigurationSlot request.
func (client SitesClient) GetSiteBackupConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupConfigurationSlotSender sends the GetSiteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupConfigurationSlotResponder handles the response to the GetSiteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatus sends the get site backup status request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
func (client SitesClient) GetSiteBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupStatus")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupStatusPreparer(ctx, resourceGroupName, name, backupID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatus", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupStatusPreparer prepares the GetSiteBackupStatus request.
func (client SitesClient) GetSiteBackupStatusPreparer(ctx context.Context, resourceGroupName string, name string, backupID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupStatusSender sends the GetSiteBackupStatus request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupStatusResponder handles the response to the GetSiteBackupStatus request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSecrets sends the get site backup status secrets request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
// request - information on backup request
func (client SitesClient) GetSiteBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupStatusSecrets")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupStatusSecretsPreparer(ctx, resourceGroupName, name, backupID, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupStatusSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupStatusSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecrets", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupStatusSecretsPreparer prepares the GetSiteBackupStatusSecrets request.
func (client SitesClient) GetSiteBackupStatusSecretsPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupStatusSecretsSender sends the GetSiteBackupStatusSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupStatusSecretsResponder handles the response to the GetSiteBackupStatusSecrets request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSecretsResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSecretsSlot sends the get site backup status secrets slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
// request - information on backup request
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupStatusSecretsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupStatusSecretsSlotPreparer(ctx, resourceGroupName, name, backupID, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupStatusSecretsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupStatusSecretsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSecretsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupStatusSecretsSlotPreparer prepares the GetSiteBackupStatusSecretsSlot request.
func (client SitesClient) GetSiteBackupStatusSecretsSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupStatusSecretsSlotSender sends the GetSiteBackupStatusSecretsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSecretsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupStatusSecretsSlotResponder handles the response to the GetSiteBackupStatusSecretsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSecretsSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteBackupStatusSlot sends the get site backup status slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result BackupItem, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteBackupStatusSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteBackupStatusSlotPreparer(ctx, resourceGroupName, name, backupID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteBackupStatusSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteBackupStatusSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteBackupStatusSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteBackupStatusSlotPreparer prepares the GetSiteBackupStatusSlot request.
func (client SitesClient) GetSiteBackupStatusSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteBackupStatusSlotSender sends the GetSiteBackupStatusSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteBackupStatusSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteBackupStatusSlotResponder handles the response to the GetSiteBackupStatusSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteBackupStatusSlotResponder(resp *http.Response) (result BackupItem, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteConfig sends the get site config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteConfig(ctx context.Context, resourceGroupName string, name string) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteConfigPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfig", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteConfigPreparer prepares the GetSiteConfig request.
func (client SitesClient) GetSiteConfigPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteConfigSender sends the GetSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteConfigResponder handles the response to the GetSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteConfigSlot sends the get site config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteConfigSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteConfigSlotPreparer prepares the GetSiteConfigSlot request.
func (client SitesClient) GetSiteConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteConfigSlotSender sends the GetSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteConfigSlotResponder handles the response to the GetSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBinding sends the get site host name binding request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// hostName - name of host
func (client SitesClient) GetSiteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBinding")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteHostNameBindingPreparer(ctx, resourceGroupName, name, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteHostNameBindingSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteHostNameBindingResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBinding", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteHostNameBindingPreparer prepares the GetSiteHostNameBinding request.
func (client SitesClient) GetSiteHostNameBindingPreparer(ctx context.Context, resourceGroupName string, name string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteHostNameBindingSender sends the GetSiteHostNameBinding request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteHostNameBindingResponder handles the response to the GetSiteHostNameBinding request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBindings sends the get site host name bindings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteHostNameBindings(ctx context.Context, resourceGroupName string, name string) (result HostNameBindingCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBindings")
		defer func() {
			sc := -1
			if result.hnbc.Response.Response != nil {
				sc = result.hnbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteHostNameBindingsNextResults
	req, err := client.GetSiteHostNameBindingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteHostNameBindingsSender(req)
	if err != nil {
		result.hnbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", resp, "Failure sending request")
		return
	}

	result.hnbc, err = client.GetSiteHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindings", resp, "Failure responding to request")
		return
	}
	if result.hnbc.hasNextLink() && result.hnbc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteHostNameBindingsPreparer prepares the GetSiteHostNameBindings request.
func (client SitesClient) GetSiteHostNameBindingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteHostNameBindingsSender sends the GetSiteHostNameBindings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteHostNameBindingsResponder handles the response to the GetSiteHostNameBindings request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingsResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteHostNameBindingsNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteHostNameBindingsNextResults(ctx context.Context, lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.hostNameBindingCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteHostNameBindingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteHostNameBindingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteHostNameBindingsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteHostNameBindingsComplete(ctx context.Context, resourceGroupName string, name string) (result HostNameBindingCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBindings")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteHostNameBindings(ctx, resourceGroupName, name)
	return
}

// GetSiteHostNameBindingSlot sends the get site host name binding slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// hostName - name of host
func (client SitesClient) GetSiteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result HostNameBinding, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBindingSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteHostNameBindingSlotPreparer(ctx, resourceGroupName, name, slot, hostName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteHostNameBindingSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteHostNameBindingSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteHostNameBindingSlotPreparer prepares the GetSiteHostNameBindingSlot request.
func (client SitesClient) GetSiteHostNameBindingSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"hostName":          autorest.Encode("path", hostName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteHostNameBindingSlotSender sends the GetSiteHostNameBindingSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteHostNameBindingSlotResponder handles the response to the GetSiteHostNameBindingSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingSlotResponder(resp *http.Response) (result HostNameBinding, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteHostNameBindingsSlot sends the get site host name bindings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteHostNameBindingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result HostNameBindingCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBindingsSlot")
		defer func() {
			sc := -1
			if result.hnbc.Response.Response != nil {
				sc = result.hnbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteHostNameBindingsSlotNextResults
	req, err := client.GetSiteHostNameBindingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteHostNameBindingsSlotSender(req)
	if err != nil {
		result.hnbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", resp, "Failure sending request")
		return
	}

	result.hnbc, err = client.GetSiteHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteHostNameBindingsSlot", resp, "Failure responding to request")
		return
	}
	if result.hnbc.hasNextLink() && result.hnbc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteHostNameBindingsSlotPreparer prepares the GetSiteHostNameBindingsSlot request.
func (client SitesClient) GetSiteHostNameBindingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteHostNameBindingsSlotSender sends the GetSiteHostNameBindingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteHostNameBindingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteHostNameBindingsSlotResponder handles the response to the GetSiteHostNameBindingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteHostNameBindingsSlotResponder(resp *http.Response) (result HostNameBindingCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteHostNameBindingsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteHostNameBindingsSlotNextResults(ctx context.Context, lastResults HostNameBindingCollection) (result HostNameBindingCollection, err error) {
	req, err := lastResults.hostNameBindingCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteHostNameBindingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteHostNameBindingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteHostNameBindingsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteHostNameBindingsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteHostNameBindingsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result HostNameBindingCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteHostNameBindingsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteHostNameBindingsSlot(ctx, resourceGroupName, name, slot)
	return
}

// GetSiteInstanceIdentifiers sends the get site instance identifiers request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteInstanceIdentifiers(ctx context.Context, resourceGroupName string, name string) (result SiteInstanceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteInstanceIdentifiers")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteInstanceIdentifiersNextResults
	req, err := client.GetSiteInstanceIdentifiersPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteInstanceIdentifiersSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", resp, "Failure sending request")
		return
	}

	result.sic, err = client.GetSiteInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiers", resp, "Failure responding to request")
		return
	}
	if result.sic.hasNextLink() && result.sic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteInstanceIdentifiersPreparer prepares the GetSiteInstanceIdentifiers request.
func (client SitesClient) GetSiteInstanceIdentifiersPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteInstanceIdentifiersSender sends the GetSiteInstanceIdentifiers request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteInstanceIdentifiersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteInstanceIdentifiersResponder handles the response to the GetSiteInstanceIdentifiers request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteInstanceIdentifiersResponder(resp *http.Response) (result SiteInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteInstanceIdentifiersNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteInstanceIdentifiersNextResults(ctx context.Context, lastResults SiteInstanceCollection) (result SiteInstanceCollection, err error) {
	req, err := lastResults.siteInstanceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteInstanceIdentifiersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteInstanceIdentifiersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteInstanceIdentifiersComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteInstanceIdentifiersComplete(ctx context.Context, resourceGroupName string, name string) (result SiteInstanceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteInstanceIdentifiers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteInstanceIdentifiers(ctx, resourceGroupName, name)
	return
}

// GetSiteInstanceIdentifiersSlot sends the get site instance identifiers slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteInstanceIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteInstanceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteInstanceIdentifiersSlot")
		defer func() {
			sc := -1
			if result.sic.Response.Response != nil {
				sc = result.sic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteInstanceIdentifiersSlotNextResults
	req, err := client.GetSiteInstanceIdentifiersSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.sic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", resp, "Failure sending request")
		return
	}

	result.sic, err = client.GetSiteInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteInstanceIdentifiersSlot", resp, "Failure responding to request")
		return
	}
	if result.sic.hasNextLink() && result.sic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteInstanceIdentifiersSlotPreparer prepares the GetSiteInstanceIdentifiersSlot request.
func (client SitesClient) GetSiteInstanceIdentifiersSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteInstanceIdentifiersSlotSender sends the GetSiteInstanceIdentifiersSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteInstanceIdentifiersSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteInstanceIdentifiersSlotResponder handles the response to the GetSiteInstanceIdentifiersSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteInstanceIdentifiersSlotResponder(resp *http.Response) (result SiteInstanceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteInstanceIdentifiersSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteInstanceIdentifiersSlotNextResults(ctx context.Context, lastResults SiteInstanceCollection) (result SiteInstanceCollection, err error) {
	req, err := lastResults.siteInstanceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteInstanceIdentifiersSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteInstanceIdentifiersSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteInstanceIdentifiersSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteInstanceIdentifiersSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteInstanceIdentifiersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteInstanceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteInstanceIdentifiersSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteInstanceIdentifiersSlot(ctx, resourceGroupName, name, slot)
	return
}

// GetSiteLogsConfig sends the get site logs config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteLogsConfig(ctx context.Context, resourceGroupName string, name string) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteLogsConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteLogsConfigPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteLogsConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteLogsConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfig", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteLogsConfigPreparer prepares the GetSiteLogsConfig request.
func (client SitesClient) GetSiteLogsConfigPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteLogsConfigSender sends the GetSiteLogsConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteLogsConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteLogsConfigResponder handles the response to the GetSiteLogsConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteLogsConfigResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteLogsConfigSlot sends the get site logs config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteLogsConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteLogsConfigSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteLogsConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteLogsConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteLogsConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteLogsConfigSlotPreparer prepares the GetSiteLogsConfigSlot request.
func (client SitesClient) GetSiteLogsConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteLogsConfigSlotSender sends the GetSiteLogsConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteLogsConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteLogsConfigSlotResponder handles the response to the GetSiteLogsConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteLogsConfigSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteMetricDefinitions sends the get site metric definitions request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricDefinitions")
		defer func() {
			sc := -1
			if result.mdc.Response.Response != nil {
				sc = result.mdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteMetricDefinitionsNextResults
	req, err := client.GetSiteMetricDefinitionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteMetricDefinitionsSender(req)
	if err != nil {
		result.mdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", resp, "Failure sending request")
		return
	}

	result.mdc, err = client.GetSiteMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitions", resp, "Failure responding to request")
		return
	}
	if result.mdc.hasNextLink() && result.mdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteMetricDefinitionsPreparer prepares the GetSiteMetricDefinitions request.
func (client SitesClient) GetSiteMetricDefinitionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteMetricDefinitionsSender sends the GetSiteMetricDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteMetricDefinitionsResponder handles the response to the GetSiteMetricDefinitions request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricDefinitionsResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteMetricDefinitionsNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteMetricDefinitionsNextResults(ctx context.Context, lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.metricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteMetricDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteMetricDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteMetricDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string) (result MetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteMetricDefinitions(ctx, resourceGroupName, name)
	return
}

// GetSiteMetricDefinitionsSlot sends the get site metric definitions slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteMetricDefinitionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result MetricDefinitionCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricDefinitionsSlot")
		defer func() {
			sc := -1
			if result.mdc.Response.Response != nil {
				sc = result.mdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteMetricDefinitionsSlotNextResults
	req, err := client.GetSiteMetricDefinitionsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteMetricDefinitionsSlotSender(req)
	if err != nil {
		result.mdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", resp, "Failure sending request")
		return
	}

	result.mdc, err = client.GetSiteMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricDefinitionsSlot", resp, "Failure responding to request")
		return
	}
	if result.mdc.hasNextLink() && result.mdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteMetricDefinitionsSlotPreparer prepares the GetSiteMetricDefinitionsSlot request.
func (client SitesClient) GetSiteMetricDefinitionsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteMetricDefinitionsSlotSender sends the GetSiteMetricDefinitionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricDefinitionsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteMetricDefinitionsSlotResponder handles the response to the GetSiteMetricDefinitionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricDefinitionsSlotResponder(resp *http.Response) (result MetricDefinitionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteMetricDefinitionsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteMetricDefinitionsSlotNextResults(ctx context.Context, lastResults MetricDefinitionCollection) (result MetricDefinitionCollection, err error) {
	req, err := lastResults.metricDefinitionCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteMetricDefinitionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteMetricDefinitionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricDefinitionsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteMetricDefinitionsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteMetricDefinitionsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result MetricDefinitionCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricDefinitionsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteMetricDefinitionsSlot(ctx, resourceGroupName, name, slot)
	return
}

// GetSiteMetrics sends the get site metrics request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// details - if true, metric details are included in response
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteMetrics(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetrics")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteMetricsNextResults
	req, err := client.GetSiteMetricsPreparer(ctx, resourceGroupName, name, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteMetricsSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetSiteMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetrics", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteMetricsPreparer prepares the GetSiteMetrics request.
func (client SitesClient) GetSiteMetricsPreparer(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteMetricsSender sends the GetSiteMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteMetricsResponder handles the response to the GetSiteMetrics request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricsResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteMetricsNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteMetricsNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteMetricsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteMetricsComplete(ctx context.Context, resourceGroupName string, name string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetrics")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteMetrics(ctx, resourceGroupName, name, details, filter)
	return
}

// GetSiteMetricsSlot sends the get site metrics slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// details - if true, metric details are included in response
// filter - return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteMetricsSlot(ctx context.Context, resourceGroupName string, name string, slot string, details *bool, filter string) (result ResourceMetricCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricsSlot")
		defer func() {
			sc := -1
			if result.rmc.Response.Response != nil {
				sc = result.rmc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteMetricsSlotNextResults
	req, err := client.GetSiteMetricsSlotPreparer(ctx, resourceGroupName, name, slot, details, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteMetricsSlotSender(req)
	if err != nil {
		result.rmc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", resp, "Failure sending request")
		return
	}

	result.rmc, err = client.GetSiteMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteMetricsSlot", resp, "Failure responding to request")
		return
	}
	if result.rmc.hasNextLink() && result.rmc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteMetricsSlotPreparer prepares the GetSiteMetricsSlot request.
func (client SitesClient) GetSiteMetricsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, details *bool, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if details != nil {
		queryParameters["details"] = autorest.Encode("query", *details)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = filter
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteMetricsSlotSender sends the GetSiteMetricsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteMetricsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteMetricsSlotResponder handles the response to the GetSiteMetricsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteMetricsSlotResponder(resp *http.Response) (result ResourceMetricCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteMetricsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteMetricsSlotNextResults(ctx context.Context, lastResults ResourceMetricCollection) (result ResourceMetricCollection, err error) {
	req, err := lastResults.resourceMetricCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteMetricsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteMetricsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteMetricsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteMetricsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteMetricsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, details *bool, filter string) (result ResourceMetricCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteMetricsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteMetricsSlot(ctx, resourceGroupName, name, slot, details, filter)
	return
}

// GetSiteNetworkFeatures sends the get site network features request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// view - the type of view. This can either be "summary" or "detailed".
func (client SitesClient) GetSiteNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string) (result NetworkFeatures, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteNetworkFeatures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteNetworkFeaturesPreparer(ctx, resourceGroupName, name, view)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteNetworkFeaturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteNetworkFeaturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeatures", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteNetworkFeaturesPreparer prepares the GetSiteNetworkFeatures request.
func (client SitesClient) GetSiteNetworkFeaturesPreparer(ctx context.Context, resourceGroupName string, name string, view string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteNetworkFeaturesSender sends the GetSiteNetworkFeatures request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteNetworkFeaturesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteNetworkFeaturesResponder handles the response to the GetSiteNetworkFeatures request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteNetworkFeaturesResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteNetworkFeaturesSlot sends the get site network features slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// view - the type of view. This can either be "summary" or "detailed".
// slot - the name of the slot for this web app.
func (client SitesClient) GetSiteNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string) (result NetworkFeatures, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteNetworkFeaturesSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteNetworkFeaturesSlotPreparer(ctx, resourceGroupName, name, view, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteNetworkFeaturesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteNetworkFeaturesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteNetworkFeaturesSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteNetworkFeaturesSlotPreparer prepares the GetSiteNetworkFeaturesSlot request.
func (client SitesClient) GetSiteNetworkFeaturesSlotPreparer(ctx context.Context, resourceGroupName string, name string, view string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"view":              autorest.Encode("path", view),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteNetworkFeaturesSlotSender sends the GetSiteNetworkFeaturesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteNetworkFeaturesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteNetworkFeaturesSlotResponder handles the response to the GetSiteNetworkFeaturesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteNetworkFeaturesSlotResponder(resp *http.Response) (result NetworkFeatures, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteOperation sends the get site operation request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// operationID - id of an operation
func (client SitesClient) GetSiteOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteOperation")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteOperationPreparer(ctx, resourceGroupName, name, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteOperationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteOperationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperation", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteOperationPreparer prepares the GetSiteOperation request.
func (client SitesClient) GetSiteOperationPreparer(ctx context.Context, resourceGroupName string, name string, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteOperationSender sends the GetSiteOperation request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteOperationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteOperationResponder handles the response to the GetSiteOperation request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteOperationResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteOperationSlot sends the get site operation slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// operationID - id of an operation
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteOperationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteOperationSlotPreparer(ctx, resourceGroupName, name, operationID, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteOperationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteOperationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteOperationSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteOperationSlotPreparer prepares the GetSiteOperationSlot request.
func (client SitesClient) GetSiteOperationSlotPreparer(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"operationId":       autorest.Encode("path", operationID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/operationresults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteOperationSlotSender sends the GetSiteOperationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteOperationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteOperationSlotResponder handles the response to the GetSiteOperationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteOperationSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePremierAddOn sends the get site premier add on request.
func (client SitesClient) GetSitePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSitePremierAddOn")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSitePremierAddOnPreparer(ctx, resourceGroupName, name, premierAddOnName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePremierAddOnSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePremierAddOnResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOn", resp, "Failure responding to request")
		return
	}

	return
}

// GetSitePremierAddOnPreparer prepares the GetSitePremierAddOn request.
func (client SitesClient) GetSitePremierAddOnPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSitePremierAddOnSender sends the GetSitePremierAddOn request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitePremierAddOnSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSitePremierAddOnResponder handles the response to the GetSitePremierAddOn request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitePremierAddOnResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSitePremierAddOnSlot sends the get site premier add on slot request.
func (client SitesClient) GetSitePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSitePremierAddOnSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSitePremierAddOnSlotPreparer(ctx, resourceGroupName, name, premierAddOnName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitePremierAddOnSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSitePremierAddOnSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSitePremierAddOnSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSitePremierAddOnSlotPreparer prepares the GetSitePremierAddOnSlot request.
func (client SitesClient) GetSitePremierAddOnSlotPreparer(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"premierAddOnName":  autorest.Encode("path", premierAddOnName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSitePremierAddOnSlotSender sends the GetSitePremierAddOnSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitePremierAddOnSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSitePremierAddOnSlotResponder handles the response to the GetSitePremierAddOnSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitePremierAddOnSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteRelayServiceConnection sends the get site relay service connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
func (client SitesClient) GetSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnection", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteRelayServiceConnectionPreparer prepares the GetSiteRelayServiceConnection request.
func (client SitesClient) GetSiteRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteRelayServiceConnectionSender sends the GetSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteRelayServiceConnectionResponder handles the response to the GetSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteRelayServiceConnectionSlot sends the get site relay service connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// slot - the name of the slot for the web app.
func (client SitesClient) GetSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteRelayServiceConnectionSlotPreparer prepares the GetSiteRelayServiceConnectionSlot request.
func (client SitesClient) GetSiteRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteRelayServiceConnectionSlotSender sends the GetSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteRelayServiceConnectionSlotResponder handles the response to the GetSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSites sends the get sites request.
// Parameters:
// resourceGroupName - name of resource group
// propertiesToInclude - additional web app properties included in the response
// includeSiteTypes - types of apps included in the response
// includeSlots - whether or not to include deployments slots in results
func (client SitesClient) GetSites(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (result SiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSites")
		defer func() {
			sc := -1
			if result.sc.Response.Response != nil {
				sc = result.sc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSitesNextResults
	req, err := client.GetSitesPreparer(ctx, resourceGroupName, propertiesToInclude, includeSiteTypes, includeSlots)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSitesSender(req)
	if err != nil {
		result.sc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", resp, "Failure sending request")
		return
	}

	result.sc, err = client.GetSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSites", resp, "Failure responding to request")
		return
	}
	if result.sc.hasNextLink() && result.sc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSitesPreparer prepares the GetSites request.
func (client SitesClient) GetSitesPreparer(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}
	if len(includeSiteTypes) > 0 {
		queryParameters["includeSiteTypes"] = autorest.Encode("query", includeSiteTypes)
	}
	if includeSlots != nil {
		queryParameters["includeSlots"] = autorest.Encode("query", *includeSlots)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSitesSender sends the GetSites request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSitesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSitesResponder handles the response to the GetSites request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSitesResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSitesNextResults retrieves the next set of results, if any.
func (client SitesClient) getSitesNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSitesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSitesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSitesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSitesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSitesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSitesComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSitesComplete(ctx context.Context, resourceGroupName string, propertiesToInclude string, includeSiteTypes string, includeSlots *bool) (result SiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSites")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSites(ctx, resourceGroupName, propertiesToInclude, includeSiteTypes, includeSlots)
	return
}

// GetSiteSlot sends the get site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// propertiesToInclude - additional web app properties included in the response
func (client SitesClient) GetSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, propertiesToInclude string) (result Site, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteSlotPreparer(ctx, resourceGroupName, name, slot, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteSlotPreparer prepares the GetSiteSlot request.
func (client SitesClient) GetSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSlotSender sends the GetSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSlotResponder handles the response to the GetSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSlots sends the get site slots request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// propertiesToInclude - list of app properties to include in the response
func (client SitesClient) GetSiteSlots(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result SiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSlots")
		defer func() {
			sc := -1
			if result.sc.Response.Response != nil {
				sc = result.sc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteSlotsNextResults
	req, err := client.GetSiteSlotsPreparer(ctx, resourceGroupName, name, propertiesToInclude)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSlotsSender(req)
	if err != nil {
		result.sc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", resp, "Failure sending request")
		return
	}

	result.sc, err = client.GetSiteSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSlots", resp, "Failure responding to request")
		return
	}
	if result.sc.hasNextLink() && result.sc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteSlotsPreparer prepares the GetSiteSlots request.
func (client SitesClient) GetSiteSlotsPreparer(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(propertiesToInclude) > 0 {
		queryParameters["propertiesToInclude"] = autorest.Encode("query", propertiesToInclude)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSlotsSender sends the GetSiteSlots request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSlotsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSlotsResponder handles the response to the GetSiteSlots request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSlotsResponder(resp *http.Response) (result SiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteSlotsNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteSlotsNextResults(ctx context.Context, lastResults SiteCollection) (result SiteCollection, err error) {
	req, err := lastResults.siteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteSlotsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteSlotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteSlotsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteSlotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteSlotsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteSlotsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteSlotsComplete(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result SiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSlots")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteSlots(ctx, resourceGroupName, name, propertiesToInclude)
	return
}

// GetSiteSnapshots sends the get site snapshots request.
// Parameters:
// resourceGroupName - webspace
// name - website Name
func (client SitesClient) GetSiteSnapshots(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSnapshots")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteSnapshotsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSnapshotsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteSnapshotsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshots", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteSnapshotsPreparer prepares the GetSiteSnapshots request.
func (client SitesClient) GetSiteSnapshotsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSnapshotsSender sends the GetSiteSnapshots request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSnapshotsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSnapshotsResponder handles the response to the GetSiteSnapshots request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSnapshotsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSnapshotsSlot sends the get site snapshots slot request.
// Parameters:
// resourceGroupName - webspace
// name - website Name
// slot - website Slot
func (client SitesClient) GetSiteSnapshotsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSnapshotsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteSnapshotsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSnapshotsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteSnapshotsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSnapshotsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteSnapshotsSlotPreparer prepares the GetSiteSnapshotsSlot request.
func (client SitesClient) GetSiteSnapshotsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSnapshotsSlotSender sends the GetSiteSnapshotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSnapshotsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSnapshotsSlotResponder handles the response to the GetSiteSnapshotsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSnapshotsSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSourceControl sends the get site source control request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSiteSourceControl(ctx context.Context, resourceGroupName string, name string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteSourceControlPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControl", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteSourceControlPreparer prepares the GetSiteSourceControl request.
func (client SitesClient) GetSiteSourceControlPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSourceControlSender sends the GetSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSourceControlResponder handles the response to the GetSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteSourceControlSlot sends the get site source control slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) GetSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteSourceControlSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteSourceControlSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteSourceControlSlotPreparer prepares the GetSiteSourceControlSlot request.
func (client SitesClient) GetSiteSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteSourceControlSlotSender sends the GetSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteSourceControlSlotResponder handles the response to the GetSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteUsages sends the get site usages request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// filter - return only usages specified in the filter. Filter is specified by using OData syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteUsages")
		defer func() {
			sc := -1
			if result.cuqc.Response.Response != nil {
				sc = result.cuqc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteUsagesNextResults
	req, err := client.GetSiteUsagesPreparer(ctx, resourceGroupName, name, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteUsagesSender(req)
	if err != nil {
		result.cuqc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", resp, "Failure sending request")
		return
	}

	result.cuqc, err = client.GetSiteUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsages", resp, "Failure responding to request")
		return
	}
	if result.cuqc.hasNextLink() && result.cuqc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteUsagesPreparer prepares the GetSiteUsages request.
func (client SitesClient) GetSiteUsagesPreparer(ctx context.Context, resourceGroupName string, name string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteUsagesSender sends the GetSiteUsages request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteUsagesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteUsagesResponder handles the response to the GetSiteUsages request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteUsagesResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteUsagesNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteUsagesNextResults(ctx context.Context, lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.csmUsageQuotaCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteUsagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteUsagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteUsagesComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result CsmUsageQuotaCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteUsages")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteUsages(ctx, resourceGroupName, name, filter)
	return
}

// GetSiteUsagesSlot sends the get site usages slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// filter - return only usages specified in the filter. Filter is specified by using OData syntax. Example:
// $filter=(name.value eq 'Metric1' or name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and
// endTime eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
func (client SitesClient) GetSiteUsagesSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result CsmUsageQuotaCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteUsagesSlot")
		defer func() {
			sc := -1
			if result.cuqc.Response.Response != nil {
				sc = result.cuqc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSiteUsagesSlotNextResults
	req, err := client.GetSiteUsagesSlotPreparer(ctx, resourceGroupName, name, slot, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteUsagesSlotSender(req)
	if err != nil {
		result.cuqc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", resp, "Failure sending request")
		return
	}

	result.cuqc, err = client.GetSiteUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteUsagesSlot", resp, "Failure responding to request")
		return
	}
	if result.cuqc.hasNextLink() && result.cuqc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSiteUsagesSlotPreparer prepares the GetSiteUsagesSlot request.
func (client SitesClient) GetSiteUsagesSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteUsagesSlotSender sends the GetSiteUsagesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteUsagesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteUsagesSlotResponder handles the response to the GetSiteUsagesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteUsagesSlotResponder(resp *http.Response) (result CsmUsageQuotaCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSiteUsagesSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSiteUsagesSlotNextResults(ctx context.Context, lastResults CsmUsageQuotaCollection) (result CsmUsageQuotaCollection, err error) {
	req, err := lastResults.csmUsageQuotaCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSiteUsagesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSiteUsagesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSiteUsagesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSiteUsagesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSiteUsagesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result CsmUsageQuotaCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteUsagesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSiteUsagesSlot(ctx, resourceGroupName, name, slot, filter)
	return
}

// GetSiteVNETConnection sends the get site vnet connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
func (client SitesClient) GetSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVNETConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVNETConnectionPreparer(ctx, resourceGroupName, name, vnetName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnection", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVNETConnectionPreparer prepares the GetSiteVNETConnection request.
func (client SitesClient) GetSiteVNETConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVNETConnectionSender sends the GetSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVNETConnectionResponder handles the response to the GetSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnections sends the get site vnet connections request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
func (client SitesClient) GetSiteVNETConnections(ctx context.Context, resourceGroupName string, name string) (result ListVnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVNETConnections")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVNETConnectionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVNETConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVNETConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnections", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVNETConnectionsPreparer prepares the GetSiteVNETConnections request.
func (client SitesClient) GetSiteVNETConnectionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVNETConnectionsSender sends the GetSiteVNETConnections request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVNETConnectionsResponder handles the response to the GetSiteVNETConnections request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionsResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnectionSlot sends the get site vnet connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// slot - the name of the slot for this web app.
func (client SitesClient) GetSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVNETConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVNETConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVNETConnectionSlotPreparer prepares the GetSiteVNETConnectionSlot request.
func (client SitesClient) GetSiteVNETConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVNETConnectionSlotSender sends the GetSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVNETConnectionSlotResponder handles the response to the GetSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVNETConnectionsSlot sends the get site vnet connections slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// slot - the name of the slot for this web app.
func (client SitesClient) GetSiteVNETConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ListVnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVNETConnectionsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVNETConnectionsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVNETConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVNETConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVNETConnectionsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVNETConnectionsSlotPreparer prepares the GetSiteVNETConnectionsSlot request.
func (client SitesClient) GetSiteVNETConnectionsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVNETConnectionsSlotSender sends the GetSiteVNETConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVNETConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVNETConnectionsSlotResponder handles the response to the GetSiteVNETConnectionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVNETConnectionsSlotResponder(resp *http.Response) (result ListVnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVnetGateway sends the get site vnet gateway request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
func (client SitesClient) GetSiteVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVnetGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVnetGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVnetGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVnetGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGateway", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVnetGatewayPreparer prepares the GetSiteVnetGateway request.
func (client SitesClient) GetSiteVnetGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVnetGatewaySender sends the GetSiteVnetGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVnetGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVnetGatewayResponder handles the response to the GetSiteVnetGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVnetGatewayResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSiteVnetGatewaySlot sends the get site vnet gateway slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
// slot - the name of the slot for this web app.
func (client SitesClient) GetSiteVnetGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSiteVnetGatewaySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSiteVnetGatewaySlotPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSiteVnetGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.GetSiteVnetGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSiteVnetGatewaySlot", resp, "Failure responding to request")
		return
	}

	return
}

// GetSiteVnetGatewaySlotPreparer prepares the GetSiteVnetGatewaySlot request.
func (client SitesClient) GetSiteVnetGatewaySlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSiteVnetGatewaySlotSender sends the GetSiteVnetGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSiteVnetGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSiteVnetGatewaySlotResponder handles the response to the GetSiteVnetGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSiteVnetGatewaySlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlotConfigNames sends the get slot config names request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) GetSlotConfigNames(ctx context.Context, resourceGroupName string, name string) (result SlotConfigNamesResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSlotConfigNames")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSlotConfigNamesPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotConfigNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", resp, "Failure sending request")
		return
	}

	result, err = client.GetSlotConfigNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotConfigNames", resp, "Failure responding to request")
		return
	}

	return
}

// GetSlotConfigNamesPreparer prepares the GetSlotConfigNames request.
func (client SitesClient) GetSlotConfigNamesPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSlotConfigNamesSender sends the GetSlotConfigNames request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotConfigNamesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSlotConfigNamesResponder handles the response to the GetSlotConfigNames request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotConfigNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSlotsDifferencesFromProduction sends the get slots differences from production request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name
func (client SitesClient) GetSlotsDifferencesFromProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SlotDifferenceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSlotsDifferencesFromProduction")
		defer func() {
			sc := -1
			if result.sdc.Response.Response != nil {
				sc = result.sdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSlotsDifferencesFromProductionNextResults
	req, err := client.GetSlotsDifferencesFromProductionPreparer(ctx, resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotsDifferencesFromProductionSender(req)
	if err != nil {
		result.sdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", resp, "Failure sending request")
		return
	}

	result.sdc, err = client.GetSlotsDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesFromProduction", resp, "Failure responding to request")
		return
	}
	if result.sdc.hasNextLink() && result.sdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSlotsDifferencesFromProductionPreparer prepares the GetSlotsDifferencesFromProduction request.
func (client SitesClient) GetSlotsDifferencesFromProductionPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSlotsDifferencesFromProductionSender sends the GetSlotsDifferencesFromProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotsDifferencesFromProductionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSlotsDifferencesFromProductionResponder handles the response to the GetSlotsDifferencesFromProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotsDifferencesFromProductionResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSlotsDifferencesFromProductionNextResults retrieves the next set of results, if any.
func (client SitesClient) getSlotsDifferencesFromProductionNextResults(ctx context.Context, lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.slotDifferenceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesFromProductionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSlotsDifferencesFromProductionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesFromProductionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSlotsDifferencesFromProductionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesFromProductionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSlotsDifferencesFromProductionComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSlotsDifferencesFromProductionComplete(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SlotDifferenceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSlotsDifferencesFromProduction")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSlotsDifferencesFromProduction(ctx, resourceGroupName, name, slotSwapEntity)
	return
}

// GetSlotsDifferencesSlot sends the get slots differences slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name
// slot - name of the source slot
func (client SitesClient) GetSlotsDifferencesSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SlotDifferenceCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSlotsDifferencesSlot")
		defer func() {
			sc := -1
			if result.sdc.Response.Response != nil {
				sc = result.sdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getSlotsDifferencesSlotNextResults
	req, err := client.GetSlotsDifferencesSlotPreparer(ctx, resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSlotsDifferencesSlotSender(req)
	if err != nil {
		result.sdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", resp, "Failure sending request")
		return
	}

	result.sdc, err = client.GetSlotsDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "GetSlotsDifferencesSlot", resp, "Failure responding to request")
		return
	}
	if result.sdc.hasNextLink() && result.sdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetSlotsDifferencesSlotPreparer prepares the GetSlotsDifferencesSlot request.
func (client SitesClient) GetSlotsDifferencesSlotPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSlotsDifferencesSlotSender sends the GetSlotsDifferencesSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) GetSlotsDifferencesSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetSlotsDifferencesSlotResponder handles the response to the GetSlotsDifferencesSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) GetSlotsDifferencesSlotResponder(resp *http.Response) (result SlotDifferenceCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getSlotsDifferencesSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) getSlotsDifferencesSlotNextResults(ctx context.Context, lastResults SlotDifferenceCollection) (result SlotDifferenceCollection, err error) {
	req, err := lastResults.slotDifferenceCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSlotsDifferencesSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetSlotsDifferencesSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "getSlotsDifferencesSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetSlotsDifferencesSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) GetSlotsDifferencesSlotComplete(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SlotDifferenceCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.GetSlotsDifferencesSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetSlotsDifferencesSlot(ctx, resourceGroupName, name, slotSwapEntity, slot)
	return
}

// IsSiteCloneable sends the is site cloneable request.
// Parameters:
// resourceGroupName - name of the resource group
// name - name of the web app
func (client SitesClient) IsSiteCloneable(ctx context.Context, resourceGroupName string, name string) (result SiteCloneability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.IsSiteCloneable")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.IsSiteCloneablePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsSiteCloneableSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", resp, "Failure sending request")
		return
	}

	result, err = client.IsSiteCloneableResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneable", resp, "Failure responding to request")
		return
	}

	return
}

// IsSiteCloneablePreparer prepares the IsSiteCloneable request.
func (client SitesClient) IsSiteCloneablePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsSiteCloneableSender sends the IsSiteCloneable request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) IsSiteCloneableSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsSiteCloneableResponder handles the response to the IsSiteCloneable request. The method always
// closes the http.Response Body.
func (client SitesClient) IsSiteCloneableResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// IsSiteCloneableSlot sends the is site cloneable slot request.
// Parameters:
// resourceGroupName - name of the resource group
// name - name of the web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) IsSiteCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteCloneability, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.IsSiteCloneableSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.IsSiteCloneableSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.IsSiteCloneableSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", resp, "Failure sending request")
		return
	}

	result, err = client.IsSiteCloneableSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "IsSiteCloneableSlot", resp, "Failure responding to request")
		return
	}

	return
}

// IsSiteCloneableSlotPreparer prepares the IsSiteCloneableSlot request.
func (client SitesClient) IsSiteCloneableSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// IsSiteCloneableSlotSender sends the IsSiteCloneableSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) IsSiteCloneableSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// IsSiteCloneableSlotResponder handles the response to the IsSiteCloneableSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) IsSiteCloneableSlotResponder(resp *http.Response) (result SiteCloneability, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAppSettings sends the list site app settings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSiteAppSettings(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteAppSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteAppSettingsPreparer prepares the ListSiteAppSettings request.
func (client SitesClient) ListSiteAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAppSettingsSender sends the ListSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAppSettingsResponder handles the response to the ListSiteAppSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAppSettingsSlot sends the list site app settings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSiteAppSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteAppSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteAppSettingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAppSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteAppSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAppSettingsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteAppSettingsSlotPreparer prepares the ListSiteAppSettingsSlot request.
func (client SitesClient) ListSiteAppSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAppSettingsSlotSender sends the ListSiteAppSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAppSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAppSettingsSlotResponder handles the response to the ListSiteAppSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAppSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAuthSettings sends the list site auth settings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSiteAuthSettings(ctx context.Context, resourceGroupName string, name string) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteAuthSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteAuthSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettings", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteAuthSettingsPreparer prepares the ListSiteAuthSettings request.
func (client SitesClient) ListSiteAuthSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAuthSettingsSender sends the ListSiteAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAuthSettingsResponder handles the response to the ListSiteAuthSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteAuthSettingsSlot sends the list site auth settings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSiteAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteAuthSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteAuthSettingsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteAuthSettingsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteAuthSettingsSlotPreparer prepares the ListSiteAuthSettingsSlot request.
func (client SitesClient) ListSiteAuthSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteAuthSettingsSlotSender sends the ListSiteAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteAuthSettingsSlotResponder handles the response to the ListSiteAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteBackups sends the list site backups request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSiteBackups(ctx context.Context, resourceGroupName string, name string) (result BackupItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteBackups")
		defer func() {
			sc := -1
			if result.bic.Response.Response != nil {
				sc = result.bic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSiteBackupsNextResults
	req, err := client.ListSiteBackupsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteBackupsSender(req)
	if err != nil {
		result.bic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", resp, "Failure sending request")
		return
	}

	result.bic, err = client.ListSiteBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackups", resp, "Failure responding to request")
		return
	}
	if result.bic.hasNextLink() && result.bic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSiteBackupsPreparer prepares the ListSiteBackups request.
func (client SitesClient) ListSiteBackupsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteBackupsSender sends the ListSiteBackups request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteBackupsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteBackupsResponder handles the response to the ListSiteBackups request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteBackupsResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteBackupsNextResults retrieves the next set of results, if any.
func (client SitesClient) listSiteBackupsNextResults(ctx context.Context, lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.backupItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteBackupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteBackupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteBackupsComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) ListSiteBackupsComplete(ctx context.Context, resourceGroupName string, name string) (result BackupItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteBackups")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteBackups(ctx, resourceGroupName, name)
	return
}

// ListSiteBackupsSlot sends the list site backups slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSiteBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupItemCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteBackupsSlot")
		defer func() {
			sc := -1
			if result.bic.Response.Response != nil {
				sc = result.bic.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listSiteBackupsSlotNextResults
	req, err := client.ListSiteBackupsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteBackupsSlotSender(req)
	if err != nil {
		result.bic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", resp, "Failure sending request")
		return
	}

	result.bic, err = client.ListSiteBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteBackupsSlot", resp, "Failure responding to request")
		return
	}
	if result.bic.hasNextLink() && result.bic.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListSiteBackupsSlotPreparer prepares the ListSiteBackupsSlot request.
func (client SitesClient) ListSiteBackupsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteBackupsSlotSender sends the ListSiteBackupsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteBackupsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteBackupsSlotResponder handles the response to the ListSiteBackupsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteBackupsSlotResponder(resp *http.Response) (result BackupItemCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listSiteBackupsSlotNextResults retrieves the next set of results, if any.
func (client SitesClient) listSiteBackupsSlotNextResults(ctx context.Context, lastResults BackupItemCollection) (result BackupItemCollection, err error) {
	req, err := lastResults.backupItemCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsSlotNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSiteBackupsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsSlotNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListSiteBackupsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "listSiteBackupsSlotNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListSiteBackupsSlotComplete enumerates all values, automatically crossing page boundaries as required.
func (client SitesClient) ListSiteBackupsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result BackupItemCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteBackupsSlot")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListSiteBackupsSlot(ctx, resourceGroupName, name, slot)
	return
}

// ListSiteConnectionStrings sends the list site connection strings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSiteConnectionStrings(ctx context.Context, resourceGroupName string, name string) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteConnectionStrings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteConnectionStringsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStrings", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteConnectionStringsPreparer prepares the ListSiteConnectionStrings request.
func (client SitesClient) ListSiteConnectionStringsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteConnectionStringsSender sends the ListSiteConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteConnectionStringsResponder handles the response to the ListSiteConnectionStrings request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteConnectionStringsSlot sends the list site connection strings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSiteConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteConnectionStringsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteConnectionStringsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteConnectionStringsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteConnectionStringsSlotPreparer prepares the ListSiteConnectionStringsSlot request.
func (client SitesClient) ListSiteConnectionStringsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteConnectionStringsSlotSender sends the ListSiteConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteConnectionStringsSlotResponder handles the response to the ListSiteConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteMetadata sends the list site metadata request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSiteMetadata(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteMetadataPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadata", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteMetadataPreparer prepares the ListSiteMetadata request.
func (client SitesClient) ListSiteMetadataPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteMetadataSender sends the ListSiteMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteMetadataResponder handles the response to the ListSiteMetadata request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteMetadataSlot sends the list site metadata slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSiteMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteMetadataSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteMetadataSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteMetadataSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteMetadataSlotPreparer prepares the ListSiteMetadataSlot request.
func (client SitesClient) ListSiteMetadataSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteMetadataSlotSender sends the ListSiteMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteMetadataSlotResponder handles the response to the ListSiteMetadataSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePremierAddOns sends the list site premier add ons request.
func (client SitesClient) ListSitePremierAddOns(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePremierAddOns")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePremierAddOnsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePremierAddOnsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePremierAddOnsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOns", resp, "Failure responding to request")
		return
	}

	return
}

// ListSitePremierAddOnsPreparer prepares the ListSitePremierAddOns request.
func (client SitesClient) ListSitePremierAddOnsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePremierAddOnsSender sends the ListSitePremierAddOns request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePremierAddOnsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSitePremierAddOnsResponder handles the response to the ListSitePremierAddOns request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePremierAddOnsResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePremierAddOnsSlot sends the list site premier add ons slot request.
func (client SitesClient) ListSitePremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePremierAddOnsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePremierAddOnsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePremierAddOnsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePremierAddOnsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePremierAddOnsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSitePremierAddOnsSlotPreparer prepares the ListSitePremierAddOnsSlot request.
func (client SitesClient) ListSitePremierAddOnsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePremierAddOnsSlotSender sends the ListSitePremierAddOnsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePremierAddOnsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSitePremierAddOnsSlotResponder handles the response to the ListSitePremierAddOnsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePremierAddOnsSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingCredentials sends the list site publishing credentials request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ListSitePublishingCredentials(ctx context.Context, resourceGroupName string, name string) (result SitesListSitePublishingCredentialsFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePublishingCredentials")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePublishingCredentialsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentials", nil, "Failure preparing request")
		return
	}

	result, err = client.ListSitePublishingCredentialsSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentials", nil, "Failure sending request")
		return
	}

	return
}

// ListSitePublishingCredentialsPreparer prepares the ListSitePublishingCredentials request.
func (client SitesClient) ListSitePublishingCredentialsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePublishingCredentialsSender sends the ListSitePublishingCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingCredentialsSender(req *http.Request) (future SitesListSitePublishingCredentialsFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (u User, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesListSitePublishingCredentialsFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		u.Response.Response, err = future.GetResult(sender)
		if u.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
			u, err = client.ListSitePublishingCredentialsResponder(u.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsFuture", "Result", u.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// ListSitePublishingCredentialsResponder handles the response to the ListSitePublishingCredentials request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingCredentialsResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingCredentialsSlot sends the list site publishing credentials slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSitePublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SitesListSitePublishingCredentialsSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePublishingCredentialsSlot")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePublishingCredentialsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentialsSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.ListSitePublishingCredentialsSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingCredentialsSlot", nil, "Failure sending request")
		return
	}

	return
}

// ListSitePublishingCredentialsSlotPreparer prepares the ListSitePublishingCredentialsSlot request.
func (client SitesClient) ListSitePublishingCredentialsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePublishingCredentialsSlotSender sends the ListSitePublishingCredentialsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingCredentialsSlotSender(req *http.Request) (future SitesListSitePublishingCredentialsSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (u User, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsSlotFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesListSitePublishingCredentialsSlotFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		u.Response.Response, err = future.GetResult(sender)
		if u.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsSlotFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && u.Response.Response.StatusCode != http.StatusNoContent {
			u, err = client.ListSitePublishingCredentialsSlotResponder(u.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesListSitePublishingCredentialsSlotFuture", "Result", u.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// ListSitePublishingCredentialsSlotResponder handles the response to the ListSitePublishingCredentialsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingCredentialsSlotResponder(resp *http.Response) (result User, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingProfileXML sends the list site publishing profile xml request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// options - specifies options for publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
// FileZilla FTP format.
func (client SitesClient) ListSitePublishingProfileXML(ctx context.Context, resourceGroupName string, name string, options CsmPublishingProfileOptions) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePublishingProfileXML")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePublishingProfileXMLPreparer(ctx, resourceGroupName, name, options)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePublishingProfileXMLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePublishingProfileXMLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXML", resp, "Failure responding to request")
		return
	}

	return
}

// ListSitePublishingProfileXMLPreparer prepares the ListSitePublishingProfileXML request.
func (client SitesClient) ListSitePublishingProfileXMLPreparer(ctx context.Context, resourceGroupName string, name string, options CsmPublishingProfileOptions) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml", pathParameters),
		autorest.WithJSON(options),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePublishingProfileXMLSender sends the ListSitePublishingProfileXML request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingProfileXMLSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSitePublishingProfileXMLResponder handles the response to the ListSitePublishingProfileXML request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingProfileXMLResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSitePublishingProfileXMLSlot sends the list site publishing profile xml slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// options - specifies options for publishing profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for
// FileZilla FTP format.
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ListSitePublishingProfileXMLSlot(ctx context.Context, resourceGroupName string, name string, options CsmPublishingProfileOptions, slot string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSitePublishingProfileXMLSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSitePublishingProfileXMLSlotPreparer(ctx, resourceGroupName, name, options, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSitePublishingProfileXMLSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSitePublishingProfileXMLSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSitePublishingProfileXMLSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSitePublishingProfileXMLSlotPreparer prepares the ListSitePublishingProfileXMLSlot request.
func (client SitesClient) ListSitePublishingProfileXMLSlotPreparer(ctx context.Context, resourceGroupName string, name string, options CsmPublishingProfileOptions, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml", pathParameters),
		autorest.WithJSON(options),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSitePublishingProfileXMLSlotSender sends the ListSitePublishingProfileXMLSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSitePublishingProfileXMLSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSitePublishingProfileXMLSlotResponder handles the response to the ListSitePublishingProfileXMLSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSitePublishingProfileXMLSlotResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteRelayServiceConnections sends the list site relay service connections request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
func (client SitesClient) ListSiteRelayServiceConnections(ctx context.Context, resourceGroupName string, name string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteRelayServiceConnections")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteRelayServiceConnectionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteRelayServiceConnectionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteRelayServiceConnectionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnections", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteRelayServiceConnectionsPreparer prepares the ListSiteRelayServiceConnections request.
func (client SitesClient) ListSiteRelayServiceConnectionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteRelayServiceConnectionsSender sends the ListSiteRelayServiceConnections request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteRelayServiceConnectionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteRelayServiceConnectionsResponder handles the response to the ListSiteRelayServiceConnections request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteRelayServiceConnectionsResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSiteRelayServiceConnectionsSlot sends the list site relay service connections slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// slot - the name of the slot for the web app.
func (client SitesClient) ListSiteRelayServiceConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ListSiteRelayServiceConnectionsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSiteRelayServiceConnectionsSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSiteRelayServiceConnectionsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ListSiteRelayServiceConnectionsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ListSiteRelayServiceConnectionsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ListSiteRelayServiceConnectionsSlotPreparer prepares the ListSiteRelayServiceConnectionsSlot request.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSiteRelayServiceConnectionsSlotSender sends the ListSiteRelayServiceConnectionsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSiteRelayServiceConnectionsSlotResponder handles the response to the ListSiteRelayServiceConnectionsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ListSiteRelayServiceConnectionsSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RecoverSite sends the recover site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// recoveryEntity - snapshot data used for web app recovery. Snapshot information can be obtained by calling
// GetDeletedSites or GetSiteSnapshots API.
func (client SitesClient) RecoverSite(ctx context.Context, resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity) (result SitesRecoverSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RecoverSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RecoverSitePreparer(ctx, resourceGroupName, name, recoveryEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSite", nil, "Failure preparing request")
		return
	}

	result, err = client.RecoverSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSite", nil, "Failure sending request")
		return
	}

	return
}

// RecoverSitePreparer prepares the RecoverSite request.
func (client SitesClient) RecoverSitePreparer(ctx context.Context, resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RecoverSiteSender sends the RecoverSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RecoverSiteSender(req *http.Request) (future SitesRecoverSiteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (s Site, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesRecoverSiteFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		s.Response.Response, err = future.GetResult(sender)
		if s.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
			s, err = client.RecoverSiteResponder(s.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteFuture", "Result", s.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// RecoverSiteResponder handles the response to the RecoverSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RecoverSiteResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RecoverSiteSlot sends the recover site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// recoveryEntity - snapshot data used for web app recovery. Snapshot information can be obtained by calling
// GetDeletedSites or GetSiteSnapshots API.
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) RecoverSiteSlot(ctx context.Context, resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string) (result SitesRecoverSiteSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RecoverSiteSlot")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RecoverSiteSlotPreparer(ctx, resourceGroupName, name, recoveryEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSiteSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.RecoverSiteSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RecoverSiteSlot", nil, "Failure sending request")
		return
	}

	return
}

// RecoverSiteSlotPreparer prepares the RecoverSiteSlot request.
func (client SitesClient) RecoverSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, recoveryEntity CsmSiteRecoveryEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover", pathParameters),
		autorest.WithJSON(recoveryEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RecoverSiteSlotSender sends the RecoverSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RecoverSiteSlotSender(req *http.Request) (future SitesRecoverSiteSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (s Site, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteSlotFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesRecoverSiteSlotFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		s.Response.Response, err = future.GetResult(sender)
		if s.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteSlotFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
			s, err = client.RecoverSiteSlotResponder(s.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesRecoverSiteSlotFuture", "Result", s.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// RecoverSiteSlotResponder handles the response to the RecoverSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RecoverSiteSlotResponder(resp *http.Response) (result Site, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNotFound),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResetProductionSlotConfig sends the reset production slot config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) ResetProductionSlotConfig(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ResetProductionSlotConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ResetProductionSlotConfigPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetProductionSlotConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", resp, "Failure sending request")
		return
	}

	result, err = client.ResetProductionSlotConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetProductionSlotConfig", resp, "Failure responding to request")
		return
	}

	return
}

// ResetProductionSlotConfigPreparer prepares the ResetProductionSlotConfig request.
func (client SitesClient) ResetProductionSlotConfigPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetProductionSlotConfigSender sends the ResetProductionSlotConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ResetProductionSlotConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ResetProductionSlotConfigResponder handles the response to the ResetProductionSlotConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) ResetProductionSlotConfigResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ResetSlotConfigSlot sends the reset slot config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) ResetSlotConfigSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.ResetSlotConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ResetSlotConfigSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetSlotConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.ResetSlotConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "ResetSlotConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// ResetSlotConfigSlotPreparer prepares the ResetSlotConfigSlot request.
func (client SitesClient) ResetSlotConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetSlotConfigSlotSender sends the ResetSlotConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) ResetSlotConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ResetSlotConfigSlotResponder handles the response to the ResetSlotConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) ResetSlotConfigSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSite sends the restart site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// softRestart - soft restart applies the configuration settings and restarts the app if necessary. Hard
// restart always restarts and reprovisions the app
// synchronous - if true then the API will block until the app has been restarted
func (client SitesClient) RestartSite(ctx context.Context, resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RestartSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RestartSitePreparer(ctx, resourceGroupName, name, softRestart, synchronous)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", resp, "Failure sending request")
		return
	}

	result, err = client.RestartSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSite", resp, "Failure responding to request")
		return
	}

	return
}

// RestartSitePreparer prepares the RestartSite request.
func (client SitesClient) RestartSitePreparer(ctx context.Context, resourceGroupName string, name string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestartSiteSender sends the RestartSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestartSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RestartSiteResponder handles the response to the RestartSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RestartSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestartSiteSlot sends the restart site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
// softRestart - soft restart applies the configuration settings and restarts the app if necessary. Hard
// restart always restarts and reprovisions the app
// synchronous - if true then the API will block until the app has been restarted
func (client SitesClient) RestartSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RestartSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RestartSiteSlotPreparer(ctx, resourceGroupName, name, slot, softRestart, synchronous)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.RestartSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.RestartSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestartSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// RestartSiteSlotPreparer prepares the RestartSiteSlot request.
func (client SitesClient) RestartSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if softRestart != nil {
		queryParameters["softRestart"] = autorest.Encode("query", *softRestart)
	}
	if synchronous != nil {
		queryParameters["synchronous"] = autorest.Encode("query", *synchronous)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestartSiteSlotSender sends the RestartSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestartSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// RestartSiteSlotResponder handles the response to the RestartSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RestartSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestoreSite sends the restore site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup to restore
// request - information on restore request
func (client SitesClient) RestoreSite(ctx context.Context, resourceGroupName string, name string, backupID string, request RestoreRequest) (result SitesRestoreSiteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RestoreSite")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RestoreSitePreparer(ctx, resourceGroupName, name, backupID, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSite", nil, "Failure preparing request")
		return
	}

	result, err = client.RestoreSiteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSite", nil, "Failure sending request")
		return
	}

	return
}

// RestoreSitePreparer prepares the RestoreSite request.
func (client SitesClient) RestoreSitePreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request RestoreRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestoreSiteSender sends the RestoreSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestoreSiteSender(req *http.Request) (future SitesRestoreSiteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (rr RestoreResponse, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesRestoreSiteFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		rr.Response.Response, err = future.GetResult(sender)
		if rr.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
			rr, err = client.RestoreSiteResponder(rr.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteFuture", "Result", rr.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// RestoreSiteResponder handles the response to the RestoreSite request. The method always
// closes the http.Response Body.
func (client SitesClient) RestoreSiteResponder(resp *http.Response) (result RestoreResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// RestoreSiteSlot sends the restore site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// backupID - id of backup to restore
// request - information on restore request
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) RestoreSiteSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request RestoreRequest, slot string) (result SitesRestoreSiteSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.RestoreSiteSlot")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.RestoreSiteSlotPreparer(ctx, resourceGroupName, name, backupID, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSiteSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.RestoreSiteSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "RestoreSiteSlot", nil, "Failure sending request")
		return
	}

	return
}

// RestoreSiteSlotPreparer prepares the RestoreSiteSlot request.
func (client SitesClient) RestoreSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, backupID string, request RestoreRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupId":          autorest.Encode("path", backupID),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RestoreSiteSlotSender sends the RestoreSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) RestoreSiteSlotSender(req *http.Request) (future SitesRestoreSiteSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (rr RestoreResponse, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteSlotFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesRestoreSiteSlotFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		rr.Response.Response, err = future.GetResult(sender)
		if rr.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteSlotFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && rr.Response.Response.StatusCode != http.StatusNoContent {
			rr, err = client.RestoreSiteSlotResponder(rr.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesRestoreSiteSlotFuture", "Result", rr.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// RestoreSiteSlotResponder handles the response to the RestoreSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) RestoreSiteSlotResponder(resp *http.Response) (result RestoreResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StartSite sends the start site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) StartSite(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.StartSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.StartSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", resp, "Failure sending request")
		return
	}

	result, err = client.StartSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSite", resp, "Failure responding to request")
		return
	}

	return
}

// StartSitePreparer prepares the StartSite request.
func (client SitesClient) StartSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartSiteSender sends the StartSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StartSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// StartSiteResponder handles the response to the StartSite request. The method always
// closes the http.Response Body.
func (client SitesClient) StartSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StartSiteSlot sends the start site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) StartSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.StartSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.StartSiteSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StartSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StartSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StartSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// StartSiteSlotPreparer prepares the StartSiteSlot request.
func (client SitesClient) StartSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartSiteSlotSender sends the StartSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StartSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// StartSiteSlotResponder handles the response to the StartSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) StartSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopSite sends the stop site request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
func (client SitesClient) StopSite(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.StopSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.StopSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", resp, "Failure sending request")
		return
	}

	result, err = client.StopSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSite", resp, "Failure responding to request")
		return
	}

	return
}

// StopSitePreparer prepares the StopSite request.
func (client SitesClient) StopSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopSiteSender sends the StopSite request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StopSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// StopSiteResponder handles the response to the StopSite request. The method always
// closes the http.Response Body.
func (client SitesClient) StopSiteResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopSiteSlot sends the stop site slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) StopSiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.StopSiteSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.StopSiteSlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.StopSiteSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", resp, "Failure sending request")
		return
	}

	result, err = client.StopSiteSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "StopSiteSlot", resp, "Failure responding to request")
		return
	}

	return
}

// StopSiteSlotPreparer prepares the StopSiteSlot request.
func (client SitesClient) StopSiteSlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopSiteSlotSender sends the StopSiteSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) StopSiteSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// StopSiteSlotResponder handles the response to the StopSiteSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) StopSiteSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SwapSlotsSlot sends the swap slots slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name
// slot - name of source slot for the swap
func (client SitesClient) SwapSlotsSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (result SitesSwapSlotsSlotFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.SwapSlotsSlot")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SwapSlotsSlotPreparer(ctx, resourceGroupName, name, slotSwapEntity, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotsSlot", nil, "Failure preparing request")
		return
	}

	result, err = client.SwapSlotsSlotSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotsSlot", nil, "Failure sending request")
		return
	}

	return
}

// SwapSlotsSlotPreparer prepares the SwapSlotsSlot request.
func (client SitesClient) SwapSlotsSlotPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SwapSlotsSlotSender sends the SwapSlotsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SwapSlotsSlotSender(req *http.Request) (future SitesSwapSlotsSlotFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (so SetObject, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotsSlotFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesSwapSlotsSlotFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		so.Response.Response, err = future.GetResult(sender)
		if so.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotsSlotFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
			so, err = client.SwapSlotsSlotResponder(so.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesSwapSlotsSlotFuture", "Result", so.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// SwapSlotsSlotResponder handles the response to the SwapSlotsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) SwapSlotsSlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SwapSlotWithProduction sends the swap slot with production request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotSwapEntity - request body that contains the target slot name
func (client SitesClient) SwapSlotWithProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (result SitesSwapSlotWithProductionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.SwapSlotWithProduction")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SwapSlotWithProductionPreparer(ctx, resourceGroupName, name, slotSwapEntity)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotWithProduction", nil, "Failure preparing request")
		return
	}

	result, err = client.SwapSlotWithProductionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SwapSlotWithProduction", nil, "Failure sending request")
		return
	}

	return
}

// SwapSlotWithProductionPreparer prepares the SwapSlotWithProduction request.
func (client SitesClient) SwapSlotWithProductionPreparer(ctx context.Context, resourceGroupName string, name string, slotSwapEntity CsmSlotEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap", pathParameters),
		autorest.WithJSON(slotSwapEntity),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SwapSlotWithProductionSender sends the SwapSlotWithProduction request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SwapSlotWithProductionSender(req *http.Request) (future SitesSwapSlotWithProductionFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = func(client SitesClient) (so SetObject, err error) {
		var done bool
		done, err = future.DoneWithContext(context.Background(), client)
		if err != nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotWithProductionFuture", "Result", future.Response(), "Polling failure")
			return
		}
		if !done {
			err = azure.NewAsyncOpIncompleteError("web.SitesSwapSlotWithProductionFuture")
			return
		}
		sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
		so.Response.Response, err = future.GetResult(sender)
		if so.Response.Response == nil && err == nil {
			err = autorest.NewErrorWithError(err, "web.SitesSwapSlotWithProductionFuture", "Result", nil, "received nil response and error")
		}
		if err == nil && so.Response.Response.StatusCode != http.StatusNoContent {
			so, err = client.SwapSlotWithProductionResponder(so.Response.Response)
			if err != nil {
				err = autorest.NewErrorWithError(err, "web.SitesSwapSlotWithProductionFuture", "Result", so.Response.Response, "Failure responding to request")
			}
		}
		return
	}
	return
}

// SwapSlotWithProductionResponder handles the response to the SwapSlotWithProduction request. The method always
// closes the http.Response Body.
func (client SitesClient) SwapSlotWithProductionResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SyncSiteRepository sends the sync site repository request.
func (client SitesClient) SyncSiteRepository(ctx context.Context, resourceGroupName string, name string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.SyncSiteRepository")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SyncSiteRepositoryPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncSiteRepositorySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", resp, "Failure sending request")
		return
	}

	result, err = client.SyncSiteRepositoryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepository", resp, "Failure responding to request")
		return
	}

	return
}

// SyncSiteRepositoryPreparer prepares the SyncSiteRepository request.
func (client SitesClient) SyncSiteRepositoryPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SyncSiteRepositorySender sends the SyncSiteRepository request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SyncSiteRepositorySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SyncSiteRepositoryResponder handles the response to the SyncSiteRepository request. The method always
// closes the http.Response Body.
func (client SitesClient) SyncSiteRepositoryResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SyncSiteRepositorySlot sends the sync site repository slot request.
func (client SitesClient) SyncSiteRepositorySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result SetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.SyncSiteRepositorySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SyncSiteRepositorySlotPreparer(ctx, resourceGroupName, name, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.SyncSiteRepositorySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", resp, "Failure sending request")
		return
	}

	result, err = client.SyncSiteRepositorySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "SyncSiteRepositorySlot", resp, "Failure responding to request")
		return
	}

	return
}

// SyncSiteRepositorySlotPreparer prepares the SyncSiteRepositorySlot request.
func (client SitesClient) SyncSiteRepositorySlotPreparer(ctx context.Context, resourceGroupName string, name string, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SyncSiteRepositorySlotSender sends the SyncSiteRepositorySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) SyncSiteRepositorySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// SyncSiteRepositorySlotResponder handles the response to the SyncSiteRepositorySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) SyncSiteRepositorySlotResponder(resp *http.Response) (result SetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAppSettings sends the update site app settings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// appSettings - application settings of web app
func (client SitesClient) UpdateSiteAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteAppSettingsPreparer(ctx, resourceGroupName, name, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettings", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteAppSettingsPreparer prepares the UpdateSiteAppSettings request.
func (client SitesClient) UpdateSiteAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteAppSettingsSender sends the UpdateSiteAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteAppSettingsResponder handles the response to the UpdateSiteAppSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAppSettingsSlot sends the update site app settings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// appSettings - application settings of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteAppSettingsSlot(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteAppSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteAppSettingsSlotPreparer(ctx, resourceGroupName, name, appSettings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteAppSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteAppSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAppSettingsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteAppSettingsSlotPreparer prepares the UpdateSiteAppSettingsSlot request.
func (client SitesClient) UpdateSiteAppSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteAppSettingsSlotSender sends the UpdateSiteAppSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAppSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteAppSettingsSlotResponder handles the response to the UpdateSiteAppSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAppSettingsSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAuthSettings sends the update site auth settings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteAuthSettings - auth settings associated with web app
func (client SitesClient) UpdateSiteAuthSettings(ctx context.Context, resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteAuthSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteAuthSettingsPreparer(ctx, resourceGroupName, name, siteAuthSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteAuthSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteAuthSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettings", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteAuthSettingsPreparer prepares the UpdateSiteAuthSettings request.
func (client SitesClient) UpdateSiteAuthSettingsPreparer(ctx context.Context, resourceGroupName string, name string, siteAuthSettings SiteAuthSettings) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteAuthSettingsSender sends the UpdateSiteAuthSettings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAuthSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteAuthSettingsResponder handles the response to the UpdateSiteAuthSettings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAuthSettingsResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteAuthSettingsSlot sends the update site auth settings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteAuthSettings - auth settings associated with web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (result SiteAuthSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteAuthSettingsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteAuthSettingsSlotPreparer(ctx, resourceGroupName, name, siteAuthSettings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteAuthSettingsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteAuthSettingsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteAuthSettingsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteAuthSettingsSlotPreparer prepares the UpdateSiteAuthSettingsSlot request.
func (client SitesClient) UpdateSiteAuthSettingsSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteAuthSettings SiteAuthSettings, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings", pathParameters),
		autorest.WithJSON(siteAuthSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteAuthSettingsSlotSender sends the UpdateSiteAuthSettingsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteAuthSettingsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteAuthSettingsSlotResponder handles the response to the UpdateSiteAuthSettingsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteAuthSettingsSlotResponder(resp *http.Response) (result SiteAuthSettings, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteBackupConfiguration sends the update site backup configuration request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on backup request
func (client SitesClient) UpdateSiteBackupConfiguration(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteBackupConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteBackupConfigurationPreparer(ctx, resourceGroupName, name, request)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteBackupConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteBackupConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfiguration", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteBackupConfigurationPreparer prepares the UpdateSiteBackupConfiguration request.
func (client SitesClient) UpdateSiteBackupConfigurationPreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteBackupConfigurationSender sends the UpdateSiteBackupConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteBackupConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteBackupConfigurationResponder handles the response to the UpdateSiteBackupConfiguration request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteBackupConfigurationResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteBackupConfigurationSlot sends the update site backup configuration slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// request - information on backup request
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (result BackupRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteBackupConfigurationSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteBackupConfigurationSlotPreparer(ctx, resourceGroupName, name, request, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteBackupConfigurationSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteBackupConfigurationSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteBackupConfigurationSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteBackupConfigurationSlotPreparer prepares the UpdateSiteBackupConfigurationSlot request.
func (client SitesClient) UpdateSiteBackupConfigurationSlotPreparer(ctx context.Context, resourceGroupName string, name string, request BackupRequest, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup", pathParameters),
		autorest.WithJSON(request),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteBackupConfigurationSlotSender sends the UpdateSiteBackupConfigurationSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteBackupConfigurationSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteBackupConfigurationSlotResponder handles the response to the UpdateSiteBackupConfigurationSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteBackupConfigurationSlotResponder(resp *http.Response) (result BackupRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConfig sends the update site config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteConfig - request body that contains the configuration setting for the web app
func (client SitesClient) UpdateSiteConfig(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteConfigPreparer(ctx, resourceGroupName, name, siteConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfig", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteConfigPreparer prepares the UpdateSiteConfig request.
func (client SitesClient) UpdateSiteConfigPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteConfigSender sends the UpdateSiteConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteConfigResponder handles the response to the UpdateSiteConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConfigResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConfigSlot sends the update site config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteConfig - request body that contains the configuration setting for the web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteConfigSlot(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig, slot string) (result SiteConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteConfigSlotPreparer(ctx, resourceGroupName, name, siteConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteConfigSlotPreparer prepares the UpdateSiteConfigSlot request.
func (client SitesClient) UpdateSiteConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteConfig SiteConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web", pathParameters),
		autorest.WithJSON(siteConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteConfigSlotSender sends the UpdateSiteConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteConfigSlotResponder handles the response to the UpdateSiteConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConfigSlotResponder(resp *http.Response) (result SiteConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConnectionStrings sends the update site connection strings request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// connectionStrings - connection strings associated with web app
func (client SitesClient) UpdateSiteConnectionStrings(ctx context.Context, resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteConnectionStrings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteConnectionStringsPreparer(ctx, resourceGroupName, name, connectionStrings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteConnectionStringsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteConnectionStringsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStrings", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteConnectionStringsPreparer prepares the UpdateSiteConnectionStrings request.
func (client SitesClient) UpdateSiteConnectionStringsPreparer(ctx context.Context, resourceGroupName string, name string, connectionStrings ConnectionStringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteConnectionStringsSender sends the UpdateSiteConnectionStrings request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConnectionStringsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteConnectionStringsResponder handles the response to the UpdateSiteConnectionStrings request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConnectionStringsResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteConnectionStringsSlot sends the update site connection strings slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// connectionStrings - connection strings associated with web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (result ConnectionStringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteConnectionStringsSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteConnectionStringsSlotPreparer(ctx, resourceGroupName, name, connectionStrings, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteConnectionStringsSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteConnectionStringsSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteConnectionStringsSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteConnectionStringsSlotPreparer prepares the UpdateSiteConnectionStringsSlot request.
func (client SitesClient) UpdateSiteConnectionStringsSlotPreparer(ctx context.Context, resourceGroupName string, name string, connectionStrings ConnectionStringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings", pathParameters),
		autorest.WithJSON(connectionStrings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteConnectionStringsSlotSender sends the UpdateSiteConnectionStringsSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteConnectionStringsSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteConnectionStringsSlotResponder handles the response to the UpdateSiteConnectionStringsSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteConnectionStringsSlotResponder(resp *http.Response) (result ConnectionStringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteLogsConfig sends the update site logs config request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteLogsConfig - site logs configuration
func (client SitesClient) UpdateSiteLogsConfig(ctx context.Context, resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteLogsConfig")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteLogsConfigPreparer(ctx, resourceGroupName, name, siteLogsConfig)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteLogsConfigSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteLogsConfigResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfig", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteLogsConfigPreparer prepares the UpdateSiteLogsConfig request.
func (client SitesClient) UpdateSiteLogsConfigPreparer(ctx context.Context, resourceGroupName string, name string, siteLogsConfig SiteLogsConfig) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteLogsConfigSender sends the UpdateSiteLogsConfig request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteLogsConfigSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteLogsConfigResponder handles the response to the UpdateSiteLogsConfig request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteLogsConfigResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteLogsConfigSlot sends the update site logs config slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteLogsConfig - site logs configuration
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (result SiteLogsConfig, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteLogsConfigSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteLogsConfigSlotPreparer(ctx, resourceGroupName, name, siteLogsConfig, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteLogsConfigSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteLogsConfigSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteLogsConfigSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteLogsConfigSlotPreparer prepares the UpdateSiteLogsConfigSlot request.
func (client SitesClient) UpdateSiteLogsConfigSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteLogsConfig SiteLogsConfig, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs", pathParameters),
		autorest.WithJSON(siteLogsConfig),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteLogsConfigSlotSender sends the UpdateSiteLogsConfigSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteLogsConfigSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteLogsConfigSlotResponder handles the response to the UpdateSiteLogsConfigSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteLogsConfigSlotResponder(resp *http.Response) (result SiteLogsConfig, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteMetadata sends the update site metadata request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// metadata - meta data of web app
func (client SitesClient) UpdateSiteMetadata(ctx context.Context, resourceGroupName string, name string, metadata StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteMetadataPreparer(ctx, resourceGroupName, name, metadata)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadata", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteMetadataPreparer prepares the UpdateSiteMetadata request.
func (client SitesClient) UpdateSiteMetadataPreparer(ctx context.Context, resourceGroupName string, name string, metadata StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteMetadataSender sends the UpdateSiteMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteMetadataResponder handles the response to the UpdateSiteMetadata request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteMetadataResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteMetadataSlot sends the update site metadata slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// metadata - meta data of web app
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteMetadataSlot(ctx context.Context, resourceGroupName string, name string, metadata StringDictionary, slot string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteMetadataSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteMetadataSlotPreparer(ctx, resourceGroupName, name, metadata, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteMetadataSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteMetadataSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteMetadataSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteMetadataSlotPreparer prepares the UpdateSiteMetadataSlot request.
func (client SitesClient) UpdateSiteMetadataSlotPreparer(ctx context.Context, resourceGroupName string, name string, metadata StringDictionary, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata", pathParameters),
		autorest.WithJSON(metadata),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteMetadataSlotSender sends the UpdateSiteMetadataSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteMetadataSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteMetadataSlotResponder handles the response to the UpdateSiteMetadataSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteMetadataSlotResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteRelayServiceConnection sends the update site relay service connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// connectionEnvelope - the details of the Hybrid Connection
func (client SitesClient) UpdateSiteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteRelayServiceConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteRelayServiceConnectionPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteRelayServiceConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteRelayServiceConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnection", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteRelayServiceConnectionPreparer prepares the UpdateSiteRelayServiceConnection request.
func (client SitesClient) UpdateSiteRelayServiceConnectionPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteRelayServiceConnectionSender sends the UpdateSiteRelayServiceConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteRelayServiceConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteRelayServiceConnectionResponder handles the response to the UpdateSiteRelayServiceConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteRelayServiceConnectionResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteRelayServiceConnectionSlot sends the update site relay service connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// entityName - the name by which the Hybrid Connection is identified
// connectionEnvelope - the details of the Hybrid Connection
// slot - the name of the slot for the web app.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (result RelayServiceConnectionEntity, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteRelayServiceConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteRelayServiceConnectionSlotPreparer(ctx, resourceGroupName, name, entityName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteRelayServiceConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteRelayServiceConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteRelayServiceConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteRelayServiceConnectionSlotPreparer prepares the UpdateSiteRelayServiceConnectionSlot request.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope RelayServiceConnectionEntity, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"entityName":        autorest.Encode("path", entityName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteRelayServiceConnectionSlotSender sends the UpdateSiteRelayServiceConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteRelayServiceConnectionSlotResponder handles the response to the UpdateSiteRelayServiceConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteRelayServiceConnectionSlotResponder(resp *http.Response) (result RelayServiceConnectionEntity, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteSourceControl sends the update site source control request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteSourceControl - request body that contains the source control parameters
func (client SitesClient) UpdateSiteSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteSourceControl")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteSourceControlPreparer(ctx, resourceGroupName, name, siteSourceControl)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteSourceControlSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteSourceControlResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControl", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteSourceControlPreparer prepares the UpdateSiteSourceControl request.
func (client SitesClient) UpdateSiteSourceControlPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteSourceControlSender sends the UpdateSiteSourceControl request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteSourceControlSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteSourceControlResponder handles the response to the UpdateSiteSourceControl request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteSourceControlResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteSourceControlSlot sends the update site source control slot request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// siteSourceControl - request body that contains the source control parameters
// slot - name of web app slot. If not specified then will default to production slot.
func (client SitesClient) UpdateSiteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (result SiteSourceControl, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteSourceControlSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteSourceControlSlotPreparer(ctx, resourceGroupName, name, siteSourceControl, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteSourceControlSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteSourceControlSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteSourceControlSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteSourceControlSlotPreparer prepares the UpdateSiteSourceControlSlot request.
func (client SitesClient) UpdateSiteSourceControlSlotPreparer(ctx context.Context, resourceGroupName string, name string, siteSourceControl SiteSourceControl, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web", pathParameters),
		autorest.WithJSON(siteSourceControl),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteSourceControlSlotSender sends the UpdateSiteSourceControlSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteSourceControlSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteSourceControlSlotResponder handles the response to the UpdateSiteSourceControlSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteSourceControlSlotResponder(resp *http.Response) (result SiteSourceControl, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnection sends the update site vnet connection request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// connectionEnvelope - the properties of this Virtual Network Connection
func (client SitesClient) UpdateSiteVNETConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteVNETConnection")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteVNETConnectionPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteVNETConnectionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteVNETConnectionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnection", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteVNETConnectionPreparer prepares the UpdateSiteVNETConnection request.
func (client SitesClient) UpdateSiteVNETConnectionPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteVNETConnectionSender sends the UpdateSiteVNETConnection request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteVNETConnectionResponder handles the response to the UpdateSiteVNETConnection request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionGateway sends the update site vnet connection gateway request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope - the properties to update this gateway with.
func (client SitesClient) UpdateSiteVNETConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteVNETConnectionGateway")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteVNETConnectionGatewayPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteVNETConnectionGatewaySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteVNETConnectionGatewayResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGateway", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteVNETConnectionGatewayPreparer prepares the UpdateSiteVNETConnectionGateway request.
func (client SitesClient) UpdateSiteVNETConnectionGatewayPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteVNETConnectionGatewaySender sends the UpdateSiteVNETConnectionGateway request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteVNETConnectionGatewayResponder handles the response to the UpdateSiteVNETConnectionGateway request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionGatewayResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionGatewaySlot sends the update site vnet connection gateway slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// gatewayName - the name of the gateway. The only gateway that exists presently is "primary"
// connectionEnvelope - the properties to update this gateway with.
// slot - the name of the slot for this web app.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (result VnetGateway, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteVNETConnectionGatewaySlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteVNETConnectionGatewaySlotPreparer(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteVNETConnectionGatewaySlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteVNETConnectionGatewaySlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionGatewaySlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteVNETConnectionGatewaySlotPreparer prepares the UpdateSiteVNETConnectionGatewaySlot request.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"gatewayName":       autorest.Encode("path", gatewayName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteVNETConnectionGatewaySlotSender sends the UpdateSiteVNETConnectionGatewaySlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteVNETConnectionGatewaySlotResponder handles the response to the UpdateSiteVNETConnectionGatewaySlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionGatewaySlotResponder(resp *http.Response) (result VnetGateway, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSiteVNETConnectionSlot sends the update site vnet connection slot request.
// Parameters:
// resourceGroupName - the resource group name
// name - the name of the web app
// vnetName - the name of the Virtual Network
// connectionEnvelope - the properties of this Virtual Network Connection
// slot - the name of the slot for this web app.
func (client SitesClient) UpdateSiteVNETConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (result VnetInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSiteVNETConnectionSlot")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSiteVNETConnectionSlotPreparer(ctx, resourceGroupName, name, vnetName, connectionEnvelope, slot)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSiteVNETConnectionSlotSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSiteVNETConnectionSlotResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSiteVNETConnectionSlot", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSiteVNETConnectionSlotPreparer prepares the UpdateSiteVNETConnectionSlot request.
func (client SitesClient) UpdateSiteVNETConnectionSlotPreparer(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope VnetInfo, slot string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"slot":              autorest.Encode("path", slot),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vnetName":          autorest.Encode("path", vnetName),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}", pathParameters),
		autorest.WithJSON(connectionEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSiteVNETConnectionSlotSender sends the UpdateSiteVNETConnectionSlot request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSiteVNETConnectionSlotSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSiteVNETConnectionSlotResponder handles the response to the UpdateSiteVNETConnectionSlot request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSiteVNETConnectionSlotResponder(resp *http.Response) (result VnetInfo, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSlotConfigNames sends the update slot config names request.
// Parameters:
// resourceGroupName - name of resource group
// name - name of web app
// slotConfigNames - request body containing the names of application settings and connection strings
func (client SitesClient) UpdateSlotConfigNames(ctx context.Context, resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (result SlotConfigNamesResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SitesClient.UpdateSlotConfigNames")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSlotConfigNamesPreparer(ctx, resourceGroupName, name, slotConfigNames)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSlotConfigNamesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSlotConfigNamesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.SitesClient", "UpdateSlotConfigNames", resp, "Failure responding to request")
		return
	}

	return
}

// UpdateSlotConfigNamesPreparer prepares the UpdateSlotConfigNames request.
func (client SitesClient) UpdateSlotConfigNamesPreparer(ctx context.Context, resourceGroupName string, name string, slotConfigNames SlotConfigNamesResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames", pathParameters),
		autorest.WithJSON(slotConfigNames),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSlotConfigNamesSender sends the UpdateSlotConfigNames request. The method will close the
// http.Response Body if it receives an error.
func (client SitesClient) UpdateSlotConfigNamesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateSlotConfigNamesResponder handles the response to the UpdateSlotConfigNames request. The method always
// closes the http.Response Body.
func (client SitesClient) UpdateSlotConfigNamesResponder(resp *http.Response) (result SlotConfigNamesResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
