package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessRightsDescription enumerates the values for access rights description.
type AccessRightsDescription string

const (
	// DeviceConnect ...
	DeviceConnect AccessRightsDescription = "DeviceConnect"
	// EnrollmentRead ...
	EnrollmentRead AccessRightsDescription = "EnrollmentRead"
	// EnrollmentWrite ...
	EnrollmentWrite AccessRightsDescription = "EnrollmentWrite"
	// RegistrationStatusRead ...
	RegistrationStatusRead AccessRightsDescription = "RegistrationStatusRead"
	// RegistrationStatusWrite ...
	RegistrationStatusWrite AccessRightsDescription = "RegistrationStatusWrite"
	// ServiceConfig ...
	ServiceConfig AccessRightsDescription = "ServiceConfig"
)

// PossibleAccessRightsDescriptionValues returns an array of possible values for the AccessRightsDescription const type.
func PossibleAccessRightsDescriptionValues() []AccessRightsDescription {
	return []AccessRightsDescription{DeviceConnect, EnrollmentRead, EnrollmentWrite, RegistrationStatusRead, RegistrationStatusWrite, ServiceConfig}
}

// AllocationPolicy enumerates the values for allocation policy.
type AllocationPolicy string

const (
	// GeoLatency ...
	GeoLatency AllocationPolicy = "GeoLatency"
	// Hashed ...
	Hashed AllocationPolicy = "Hashed"
	// Static ...
	Static AllocationPolicy = "Static"
)

// PossibleAllocationPolicyValues returns an array of possible values for the AllocationPolicy const type.
func PossibleAllocationPolicyValues() []AllocationPolicy {
	return []AllocationPolicy{GeoLatency, Hashed, Static}
}

// CertificatePurpose enumerates the values for certificate purpose.
type CertificatePurpose string

const (
	// ClientAuthentication ...
	ClientAuthentication CertificatePurpose = "clientAuthentication"
	// ServerAuthentication ...
	ServerAuthentication CertificatePurpose = "serverAuthentication"
)

// PossibleCertificatePurposeValues returns an array of possible values for the CertificatePurpose const type.
func PossibleCertificatePurposeValues() []CertificatePurpose {
	return []CertificatePurpose{ClientAuthentication, ServerAuthentication}
}

// IotDpsSku enumerates the values for iot dps sku.
type IotDpsSku string

const (
	// S1 ...
	S1 IotDpsSku = "S1"
)

// PossibleIotDpsSkuValues returns an array of possible values for the IotDpsSku const type.
func PossibleIotDpsSkuValues() []IotDpsSku {
	return []IotDpsSku{S1}
}

// NameUnavailabilityReason enumerates the values for name unavailability reason.
type NameUnavailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists NameUnavailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid NameUnavailabilityReason = "Invalid"
)

// PossibleNameUnavailabilityReasonValues returns an array of possible values for the NameUnavailabilityReason const type.
func PossibleNameUnavailabilityReasonValues() []NameUnavailabilityReason {
	return []NameUnavailabilityReason{AlreadyExists, Invalid}
}

// State enumerates the values for state.
type State string

const (
	// Activating ...
	Activating State = "Activating"
	// ActivationFailed ...
	ActivationFailed State = "ActivationFailed"
	// Active ...
	Active State = "Active"
	// Deleted ...
	Deleted State = "Deleted"
	// Deleting ...
	Deleting State = "Deleting"
	// DeletionFailed ...
	DeletionFailed State = "DeletionFailed"
	// FailingOver ...
	FailingOver State = "FailingOver"
	// FailoverFailed ...
	FailoverFailed State = "FailoverFailed"
	// Resuming ...
	Resuming State = "Resuming"
	// Suspended ...
	Suspended State = "Suspended"
	// Suspending ...
	Suspending State = "Suspending"
	// Transitioning ...
	Transitioning State = "Transitioning"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{Activating, ActivationFailed, Active, Deleted, Deleting, DeletionFailed, FailingOver, FailoverFailed, Resuming, Suspended, Suspending, Transitioning}
}
