package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// SQLVulnerabilityAssessmentScanResultsClient is the API spec for Microsoft.Security (Azure Security Center) resource
// provider
type SQLVulnerabilityAssessmentScanResultsClient struct {
	BaseClient
}

// NewSQLVulnerabilityAssessmentScanResultsClient creates an instance of the
// SQLVulnerabilityAssessmentScanResultsClient client.
func NewSQLVulnerabilityAssessmentScanResultsClient(subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentScanResultsClient {
	return NewSQLVulnerabilityAssessmentScanResultsClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewSQLVulnerabilityAssessmentScanResultsClientWithBaseURI creates an instance of the
// SQLVulnerabilityAssessmentScanResultsClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewSQLVulnerabilityAssessmentScanResultsClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) SQLVulnerabilityAssessmentScanResultsClient {
	return SQLVulnerabilityAssessmentScanResultsClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// Get sends the get request.
// Parameters:
// scanID - the scan Id. Type 'latest' to get the scan results for the latest scan.
// scanResultID - the rule Id of the results.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentScanResultsClient) Get(ctx context.Context, scanID string, scanResultID string, workspaceID string, APIVersion string, resourceID string) (result ScanResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentScanResultsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scanID, scanResultID, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client SQLVulnerabilityAssessmentScanResultsClient) GetPreparer(ctx context.Context, scanID string, scanResultID string, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId":   resourceID,
		"scanId":       autorest.Encode("path", scanID),
		"scanResultId": autorest.Encode("path", scanResultID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentScanResultsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentScanResultsClient) GetResponder(resp *http.Response) (result ScanResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List sends the list request.
// Parameters:
// scanID - the scan Id. Type 'latest' to get the scan results for the latest scan.
// workspaceID - the workspace Id.
// APIVersion - the api version.
// resourceID - the identifier of the resource.
func (client SQLVulnerabilityAssessmentScanResultsClient) List(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (result ScanResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SQLVulnerabilityAssessmentScanResultsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, scanID, workspaceID, APIVersion, resourceID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.SQLVulnerabilityAssessmentScanResultsClient", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client SQLVulnerabilityAssessmentScanResultsClient) ListPreparer(ctx context.Context, scanID string, workspaceID string, APIVersion string, resourceID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceId": resourceID,
		"scanId":     autorest.Encode("path", scanID),
	}

	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"workspaceId": autorest.Encode("query", workspaceID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SQLVulnerabilityAssessmentScanResultsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SQLVulnerabilityAssessmentScanResultsClient) ListResponder(resp *http.Response) (result ScanResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
