package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// JobClient is the the HDInsight Job Client.
type JobClient struct {
	BaseClient
}

// NewJobClient creates an instance of the JobClient client.
func NewJobClient(clusterDNSName string, userName string) JobClient {
	return JobClient{New(clusterDNSName, userName)}
}

// Get gets job details from the specified HDInsight cluster.
// Parameters:
// jobID - the id of the job.
func (client JobClient) Get(ctx context.Context, jobID string) (result JobDetailRootJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client JobClient) GetPreparer(ctx context.Context, jobID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	pathParameters := map[string]interface{}{
		"jobId": autorest.Encode("path", jobID),
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPathParameters("/templeton/v1/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client JobClient) GetResponder(resp *http.Response) (result JobDetailRootJSONObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAppState gets application state from the specified HDInsight cluster.
// Parameters:
// appID - the id of the job.
func (client JobClient) GetAppState(ctx context.Context, appID string) (result AppState, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetAppState")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAppStatePreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAppStateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", resp, "Failure sending request")
		return
	}

	result, err = client.GetAppStateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", resp, "Failure responding to request")
	}

	return
}

// GetAppStatePreparer prepares the GetAppState request.
func (client JobClient) GetAppStatePreparer(ctx context.Context, appID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPathParameters("/ws/v1/cluster/apps/{appId}/state", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAppStateSender sends the GetAppState request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetAppStateSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetAppStateResponder handles the response to the GetAppState request. The method always
// closes the http.Response Body.
func (client JobClient) GetAppStateResponder(resp *http.Response) (result AppState, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Kill initiates cancel on given running job in the specified HDInsight.
// Parameters:
// jobID - the id of the job.
func (client JobClient) Kill(ctx context.Context, jobID string) (result JobDetailRootJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.Kill")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: jobID,
			Constraints: []validation.Constraint{{Target: "jobID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("hdinsight.JobClient", "Kill", err.Error())
	}

	req, err := client.KillPreparer(ctx, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", nil, "Failure preparing request")
		return
	}

	resp, err := client.KillSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", resp, "Failure sending request")
		return
	}

	result, err = client.KillResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", resp, "Failure responding to request")
	}

	return
}

// KillPreparer prepares the Kill request.
func (client JobClient) KillPreparer(ctx context.Context, jobID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	pathParameters := map[string]interface{}{
		"jobId": autorest.Encode("path", jobID),
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPathParameters("/templeton/v1/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// KillSender sends the Kill request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) KillSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// KillResponder handles the response to the Kill request. The method always
// closes the http.Response Body.
func (client JobClient) KillResponder(resp *http.Response) (result JobDetailRootJSONObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the list of jobs from the specified HDInsight cluster.
func (client JobClient) List(ctx context.Context) (result ListJobListJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client JobClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"showall":   autorest.Encode("query", "true"),
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/jobs"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client JobClient) ListResponder(resp *http.Response) (result ListJobListJSONObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAfterJobID gets numrecords Of Jobs after jobid from the specified HDInsight cluster.
// Parameters:
// jobid - jobId from where to list jobs.
// numrecords - number of jobs to fetch.
func (client JobClient) ListAfterJobID(ctx context.Context, jobid string, numrecords *int32) (result ListJobListJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.ListAfterJobID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: numrecords,
			Constraints: []validation.Constraint{{Target: "numrecords", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "numrecords", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("hdinsight.JobClient", "ListAfterJobID", err.Error())
	}

	req, err := client.ListAfterJobIDPreparer(ctx, jobid, numrecords)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAfterJobIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", resp, "Failure sending request")
		return
	}

	result, err = client.ListAfterJobIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", resp, "Failure responding to request")
	}

	return
}

// ListAfterJobIDPreparer prepares the ListAfterJobID request.
func (client JobClient) ListAfterJobIDPreparer(ctx context.Context, jobid string, numrecords *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"showall":   autorest.Encode("query", "true"),
		"user.name": autorest.Encode("query", client.UserName),
	}
	if len(jobid) > 0 {
		queryParameters["jobid"] = autorest.Encode("query", jobid)
	}
	if numrecords != nil {
		queryParameters["numrecords"] = autorest.Encode("query", *numrecords)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/jobs"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAfterJobIDSender sends the ListAfterJobID request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListAfterJobIDSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ListAfterJobIDResponder handles the response to the ListAfterJobID request. The method always
// closes the http.Response Body.
func (client JobClient) ListAfterJobIDResponder(resp *http.Response) (result ListJobListJSONObject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitHiveJob submits a Hive job to an HDInsight cluster.
// Parameters:
// content - the content of the Hive job request.
func (client JobClient) SubmitHiveJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitHiveJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitHiveJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitHiveJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitHiveJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", resp, "Failure responding to request")
	}

	return
}

// SubmitHiveJobPreparer prepares the SubmitHiveJob request.
func (client JobClient) SubmitHiveJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/text"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/hive"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitHiveJobSender sends the SubmitHiveJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitHiveJobSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SubmitHiveJobResponder handles the response to the SubmitHiveJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitHiveJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitMapReduceJob submits a MapReduce job to an HDInsight cluster.
// Parameters:
// content - the content of the MapReduce job request.
func (client JobClient) SubmitMapReduceJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitMapReduceJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitMapReduceJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitMapReduceJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitMapReduceJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", resp, "Failure responding to request")
	}

	return
}

// SubmitMapReduceJobPreparer prepares the SubmitMapReduceJob request.
func (client JobClient) SubmitMapReduceJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/mapreduce/jar"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitMapReduceJobSender sends the SubmitMapReduceJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitMapReduceJobSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SubmitMapReduceJobResponder handles the response to the SubmitMapReduceJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitMapReduceJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitMapReduceStreamingJob submits a MapReduce streaming job to an HDInsight cluster.
// Parameters:
// content - the content of the MapReduce job request.
func (client JobClient) SubmitMapReduceStreamingJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitMapReduceStreamingJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitMapReduceStreamingJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitMapReduceStreamingJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitMapReduceStreamingJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", resp, "Failure responding to request")
	}

	return
}

// SubmitMapReduceStreamingJobPreparer prepares the SubmitMapReduceStreamingJob request.
func (client JobClient) SubmitMapReduceStreamingJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/mapreduce/streaming"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitMapReduceStreamingJobSender sends the SubmitMapReduceStreamingJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitMapReduceStreamingJobSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SubmitMapReduceStreamingJobResponder handles the response to the SubmitMapReduceStreamingJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitMapReduceStreamingJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitPigJob submits a Pig job to an HDInsight cluster.
// Parameters:
// content - the content of the Pig job request.
func (client JobClient) SubmitPigJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitPigJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitPigJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitPigJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitPigJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", resp, "Failure responding to request")
	}

	return
}

// SubmitPigJobPreparer prepares the SubmitPigJob request.
func (client JobClient) SubmitPigJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/pig"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitPigJobSender sends the SubmitPigJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitPigJobSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SubmitPigJobResponder handles the response to the SubmitPigJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitPigJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitSqoopJob submits a Sqoop job to an HDInsight cluster.
// Parameters:
// content - the content of the Sqoop job request.
func (client JobClient) SubmitSqoopJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitSqoopJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitSqoopJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitSqoopJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitSqoopJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", resp, "Failure responding to request")
	}

	return
}

// SubmitSqoopJobPreparer prepares the SubmitSqoopJob request.
func (client JobClient) SubmitSqoopJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"clusterDnsName": client.ClusterDNSName,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{clusterDnsName}", urlParameters),
		autorest.WithPath("/templeton/v1/sqoop"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitSqoopJobSender sends the SubmitSqoopJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitSqoopJobSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SubmitSqoopJobResponder handles the response to the SubmitSqoopJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitSqoopJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
