package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/digitaltwins/mgmt/2020-12-01/digitaltwins"

// CheckNameRequest the result returned from a database check name availability request.
type CheckNameRequest struct {
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, for instance Microsoft.DigitalTwins/digitalTwinsInstances.
	Type *string `json:"type,omitempty"`
}

// CheckNameResult the result returned from a check name availability request.
type CheckNameResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - Specifies a Boolean value that indicates if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Message - Message indicating an unavailable name due to a conflict, or a description of the naming rules that are violated.
	Message *string `json:"message,omitempty"`
	// Reason - Message providing the reason why the given name is invalid. Possible values include: 'Invalid', 'AlreadyExists'
	Reason Reason `json:"reason,omitempty"`
}

// ConnectionProperties the properties of a private endpoint connection.
type ConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	ProvisioningState ConnectionPropertiesProvisioningState `json:"provisioningState,omitempty"`
	PrivateEndpoint   *ConnectionPropertiesPrivateEndpoint  `json:"privateEndpoint,omitempty"`
	// GroupIds - The list of group ids for the private endpoint connection.
	GroupIds                          *[]string                                              `json:"groupIds,omitempty"`
	PrivateLinkServiceConnectionState *ConnectionPropertiesPrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionProperties.
func (cp ConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = cp.PrivateEndpoint
	}
	if cp.GroupIds != nil {
		objectMap["groupIds"] = cp.GroupIds
	}
	if cp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = cp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// ConnectionPropertiesPrivateEndpoint ...
type ConnectionPropertiesPrivateEndpoint struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
}

// ConnectionPropertiesPrivateLinkServiceConnectionState ...
type ConnectionPropertiesPrivateLinkServiceConnectionState struct {
	// Status - The status of a private endpoint connection. Possible values include: 'PrivateLinkServiceConnectionStatusPending', 'PrivateLinkServiceConnectionStatusApproved', 'PrivateLinkServiceConnectionStatusRejected', 'PrivateLinkServiceConnectionStatusDisconnected'
	Status PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
	// Description - The description for the current state of a private endpoint connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - Actions required for a private endpoint connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// ConnectionState the current state of a private endpoint connection.
type ConnectionState struct {
	// Status - The status of a private endpoint connection. Possible values include: 'PrivateLinkServiceConnectionStatusPending', 'PrivateLinkServiceConnectionStatusApproved', 'PrivateLinkServiceConnectionStatusRejected', 'PrivateLinkServiceConnectionStatusDisconnected'
	Status PrivateLinkServiceConnectionStatus `json:"status,omitempty"`
	// Description - The description for the current state of a private endpoint connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - Actions required for a private endpoint connection.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Description, error)
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Description, error)
}

// Description the description of the DigitalTwins service.
type Description struct {
	autorest.Response `json:"-"`
	// Properties - DigitalTwins instance properties.
	*Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - The managed identity for the DigitalTwinsInstance.
	Identity *Identity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for Description.
func (d Description) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.Identity != nil {
		objectMap["identity"] = d.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Description struct.
func (d *Description) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				d.Properties = &properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				d.Identity = &identity
			}
		}
	}

	return nil
}

// DescriptionListResult a list of DigitalTwins description objects with a next link.
type DescriptionListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of DigitalTwins description objects.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - A list of DigitalTwins description objects.
	Value *[]Description `json:"value,omitempty"`
}

// DescriptionListResultIterator provides access to a complete listing of Description values.
type DescriptionListResultIterator struct {
	i    int
	page DescriptionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DescriptionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DescriptionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DescriptionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DescriptionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DescriptionListResultIterator) Response() DescriptionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DescriptionListResultIterator) Value() Description {
	if !iter.page.NotDone() {
		return Description{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DescriptionListResultIterator type.
func NewDescriptionListResultIterator(page DescriptionListResultPage) DescriptionListResultIterator {
	return DescriptionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DescriptionListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DescriptionListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// descriptionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DescriptionListResult) descriptionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DescriptionListResultPage contains a page of Description values.
type DescriptionListResultPage struct {
	fn  func(context.Context, DescriptionListResult) (DescriptionListResult, error)
	dlr DescriptionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DescriptionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DescriptionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DescriptionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DescriptionListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DescriptionListResultPage) Response() DescriptionListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DescriptionListResultPage) Values() []Description {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DescriptionListResultPage type.
func NewDescriptionListResultPage(cur DescriptionListResult, getNextPage func(context.Context, DescriptionListResult) (DescriptionListResult, error)) DescriptionListResultPage {
	return DescriptionListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// EndpointCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointClient) (EndpointResource, error)
}

// EndpointDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EndpointClient) (EndpointResource, error)
}

// EndpointResource digitalTwinsInstance endpoint resource.
type EndpointResource struct {
	autorest.Response `json:"-"`
	// Properties - DigitalTwinsInstance endpoint resource properties.
	Properties BasicEndpointResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Extension resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointResource.
func (er EndpointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = er.Properties
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointResource struct.
func (er *EndpointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicEndpointResourceProperties(*v)
				if err != nil {
					return err
				}
				er.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				er.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				er.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				er.Type = &typeVar
			}
		}
	}

	return nil
}

// EndpointResourceListResult a list of DigitalTwinsInstance Endpoints with a next link.
type EndpointResourceListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of DigitalTwinsInstance Endpoints.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - A list of DigitalTwinsInstance Endpoints.
	Value *[]EndpointResource `json:"value,omitempty"`
}

// EndpointResourceListResultIterator provides access to a complete listing of EndpointResource values.
type EndpointResourceListResultIterator struct {
	i    int
	page EndpointResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EndpointResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointResourceListResultIterator) Response() EndpointResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointResourceListResultIterator) Value() EndpointResource {
	if !iter.page.NotDone() {
		return EndpointResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EndpointResourceListResultIterator type.
func NewEndpointResourceListResultIterator(page EndpointResourceListResultPage) EndpointResourceListResultIterator {
	return EndpointResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (erlr EndpointResourceListResult) IsEmpty() bool {
	return erlr.Value == nil || len(*erlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (erlr EndpointResourceListResult) hasNextLink() bool {
	return erlr.NextLink != nil && len(*erlr.NextLink) != 0
}

// endpointResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (erlr EndpointResourceListResult) endpointResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !erlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(erlr.NextLink)))
}

// EndpointResourceListResultPage contains a page of EndpointResource values.
type EndpointResourceListResultPage struct {
	fn   func(context.Context, EndpointResourceListResult) (EndpointResourceListResult, error)
	erlr EndpointResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EndpointResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.erlr)
		if err != nil {
			return err
		}
		page.erlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EndpointResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointResourceListResultPage) NotDone() bool {
	return !page.erlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointResourceListResultPage) Response() EndpointResourceListResult {
	return page.erlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointResourceListResultPage) Values() []EndpointResource {
	if page.erlr.IsEmpty() {
		return nil
	}
	return *page.erlr.Value
}

// Creates a new instance of the EndpointResourceListResultPage type.
func NewEndpointResourceListResultPage(cur EndpointResourceListResult, getNextPage func(context.Context, EndpointResourceListResult) (EndpointResourceListResult, error)) EndpointResourceListResultPage {
	return EndpointResourceListResultPage{
		fn:   getNextPage,
		erlr: cur,
	}
}

// BasicEndpointResourceProperties properties related to Digital Twins Endpoint
type BasicEndpointResourceProperties interface {
	AsServiceBus() (*ServiceBus, bool)
	AsEventHub() (*EventHub, bool)
	AsEventGrid() (*EventGrid, bool)
	AsEndpointResourceProperties() (*EndpointResourceProperties, bool)
}

// EndpointResourceProperties properties related to Digital Twins Endpoint
type EndpointResourceProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Provisioning', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'Warning', 'Suspending', 'Restoring', 'Moving', 'Disabled'
	ProvisioningState EndpointProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// AuthenticationType - Specifies the authentication type being used for connecting to the endpoint. Possible values include: 'KeyBased', 'IdentityBased'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// DeadLetterSecret - Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string `json:"deadLetterSecret,omitempty"`
	// DeadLetterURI - Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string `json:"deadLetterUri,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDigitalTwinsEndpointResourceProperties', 'EndpointTypeServiceBus', 'EndpointTypeEventHub', 'EndpointTypeEventGrid'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

func unmarshalBasicEndpointResourceProperties(body []byte) (BasicEndpointResourceProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["endpointType"] {
	case string(EndpointTypeServiceBus):
		var sb ServiceBus
		err := json.Unmarshal(body, &sb)
		return sb, err
	case string(EndpointTypeEventHub):
		var eh EventHub
		err := json.Unmarshal(body, &eh)
		return eh, err
	case string(EndpointTypeEventGrid):
		var eg EventGrid
		err := json.Unmarshal(body, &eg)
		return eg, err
	default:
		var erp EndpointResourceProperties
		err := json.Unmarshal(body, &erp)
		return erp, err
	}
}
func unmarshalBasicEndpointResourcePropertiesArray(body []byte) ([]BasicEndpointResourceProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	erpArray := make([]BasicEndpointResourceProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		erp, err := unmarshalBasicEndpointResourceProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		erpArray[index] = erp
	}
	return erpArray, nil
}

// MarshalJSON is the custom marshaler for EndpointResourceProperties.
func (erp EndpointResourceProperties) MarshalJSON() ([]byte, error) {
	erp.EndpointType = EndpointTypeDigitalTwinsEndpointResourceProperties
	objectMap := make(map[string]interface{})
	if erp.AuthenticationType != "" {
		objectMap["authenticationType"] = erp.AuthenticationType
	}
	if erp.DeadLetterSecret != nil {
		objectMap["deadLetterSecret"] = erp.DeadLetterSecret
	}
	if erp.DeadLetterURI != nil {
		objectMap["deadLetterUri"] = erp.DeadLetterURI
	}
	if erp.EndpointType != "" {
		objectMap["endpointType"] = erp.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsServiceBus is the BasicEndpointResourceProperties implementation for EndpointResourceProperties.
func (erp EndpointResourceProperties) AsServiceBus() (*ServiceBus, bool) {
	return nil, false
}

// AsEventHub is the BasicEndpointResourceProperties implementation for EndpointResourceProperties.
func (erp EndpointResourceProperties) AsEventHub() (*EventHub, bool) {
	return nil, false
}

// AsEventGrid is the BasicEndpointResourceProperties implementation for EndpointResourceProperties.
func (erp EndpointResourceProperties) AsEventGrid() (*EventGrid, bool) {
	return nil, false
}

// AsEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EndpointResourceProperties.
func (erp EndpointResourceProperties) AsEndpointResourceProperties() (*EndpointResourceProperties, bool) {
	return &erp, true
}

// AsBasicEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EndpointResourceProperties.
func (erp EndpointResourceProperties) AsBasicEndpointResourceProperties() (BasicEndpointResourceProperties, bool) {
	return &erp, true
}

// ErrorDefinition error definition.
type ErrorDefinition struct {
	// Code - READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; Internal error details.
	Details *[]ErrorDefinition `json:"details,omitempty"`
}

// ErrorResponse error response.
type ErrorResponse struct {
	// Error - Error description
	Error *ErrorDefinition `json:"error,omitempty"`
}

// EventGrid properties related to EventGrid.
type EventGrid struct {
	// TopicEndpoint - EventGrid Topic Endpoint
	TopicEndpoint *string `json:"TopicEndpoint,omitempty"`
	// AccessKey1 - EventGrid secondary accesskey. Will be obfuscated during read.
	AccessKey1 *string `json:"accessKey1,omitempty"`
	// AccessKey2 - EventGrid secondary accesskey. Will be obfuscated during read.
	AccessKey2 *string `json:"accessKey2,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Provisioning', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'Warning', 'Suspending', 'Restoring', 'Moving', 'Disabled'
	ProvisioningState EndpointProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// AuthenticationType - Specifies the authentication type being used for connecting to the endpoint. Possible values include: 'KeyBased', 'IdentityBased'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// DeadLetterSecret - Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string `json:"deadLetterSecret,omitempty"`
	// DeadLetterURI - Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string `json:"deadLetterUri,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDigitalTwinsEndpointResourceProperties', 'EndpointTypeServiceBus', 'EndpointTypeEventHub', 'EndpointTypeEventGrid'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for EventGrid.
func (eg EventGrid) MarshalJSON() ([]byte, error) {
	eg.EndpointType = EndpointTypeEventGrid
	objectMap := make(map[string]interface{})
	if eg.TopicEndpoint != nil {
		objectMap["TopicEndpoint"] = eg.TopicEndpoint
	}
	if eg.AccessKey1 != nil {
		objectMap["accessKey1"] = eg.AccessKey1
	}
	if eg.AccessKey2 != nil {
		objectMap["accessKey2"] = eg.AccessKey2
	}
	if eg.AuthenticationType != "" {
		objectMap["authenticationType"] = eg.AuthenticationType
	}
	if eg.DeadLetterSecret != nil {
		objectMap["deadLetterSecret"] = eg.DeadLetterSecret
	}
	if eg.DeadLetterURI != nil {
		objectMap["deadLetterUri"] = eg.DeadLetterURI
	}
	if eg.EndpointType != "" {
		objectMap["endpointType"] = eg.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsServiceBus is the BasicEndpointResourceProperties implementation for EventGrid.
func (eg EventGrid) AsServiceBus() (*ServiceBus, bool) {
	return nil, false
}

// AsEventHub is the BasicEndpointResourceProperties implementation for EventGrid.
func (eg EventGrid) AsEventHub() (*EventHub, bool) {
	return nil, false
}

// AsEventGrid is the BasicEndpointResourceProperties implementation for EventGrid.
func (eg EventGrid) AsEventGrid() (*EventGrid, bool) {
	return &eg, true
}

// AsEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EventGrid.
func (eg EventGrid) AsEndpointResourceProperties() (*EndpointResourceProperties, bool) {
	return nil, false
}

// AsBasicEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EventGrid.
func (eg EventGrid) AsBasicEndpointResourceProperties() (BasicEndpointResourceProperties, bool) {
	return &eg, true
}

// EventHub properties related to EventHub.
type EventHub struct {
	// ConnectionStringPrimaryKey - PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	ConnectionStringPrimaryKey *string `json:"connectionStringPrimaryKey,omitempty"`
	// ConnectionStringSecondaryKey - SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	ConnectionStringSecondaryKey *string `json:"connectionStringSecondaryKey,omitempty"`
	// EndpointURI - The URL of the EventHub namespace for identity-based authentication. It must include the protocol sb://
	EndpointURI *string `json:"endpointUri,omitempty"`
	// EntityPath - The EventHub name in the EventHub namespace for identity-based authentication.
	EntityPath *string `json:"entityPath,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Provisioning', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'Warning', 'Suspending', 'Restoring', 'Moving', 'Disabled'
	ProvisioningState EndpointProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// AuthenticationType - Specifies the authentication type being used for connecting to the endpoint. Possible values include: 'KeyBased', 'IdentityBased'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// DeadLetterSecret - Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string `json:"deadLetterSecret,omitempty"`
	// DeadLetterURI - Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string `json:"deadLetterUri,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDigitalTwinsEndpointResourceProperties', 'EndpointTypeServiceBus', 'EndpointTypeEventHub', 'EndpointTypeEventGrid'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for EventHub.
func (eh EventHub) MarshalJSON() ([]byte, error) {
	eh.EndpointType = EndpointTypeEventHub
	objectMap := make(map[string]interface{})
	if eh.ConnectionStringPrimaryKey != nil {
		objectMap["connectionStringPrimaryKey"] = eh.ConnectionStringPrimaryKey
	}
	if eh.ConnectionStringSecondaryKey != nil {
		objectMap["connectionStringSecondaryKey"] = eh.ConnectionStringSecondaryKey
	}
	if eh.EndpointURI != nil {
		objectMap["endpointUri"] = eh.EndpointURI
	}
	if eh.EntityPath != nil {
		objectMap["entityPath"] = eh.EntityPath
	}
	if eh.AuthenticationType != "" {
		objectMap["authenticationType"] = eh.AuthenticationType
	}
	if eh.DeadLetterSecret != nil {
		objectMap["deadLetterSecret"] = eh.DeadLetterSecret
	}
	if eh.DeadLetterURI != nil {
		objectMap["deadLetterUri"] = eh.DeadLetterURI
	}
	if eh.EndpointType != "" {
		objectMap["endpointType"] = eh.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsServiceBus is the BasicEndpointResourceProperties implementation for EventHub.
func (eh EventHub) AsServiceBus() (*ServiceBus, bool) {
	return nil, false
}

// AsEventHub is the BasicEndpointResourceProperties implementation for EventHub.
func (eh EventHub) AsEventHub() (*EventHub, bool) {
	return &eh, true
}

// AsEventGrid is the BasicEndpointResourceProperties implementation for EventHub.
func (eh EventHub) AsEventGrid() (*EventGrid, bool) {
	return nil, false
}

// AsEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EventHub.
func (eh EventHub) AsEndpointResourceProperties() (*EndpointResourceProperties, bool) {
	return nil, false
}

// AsBasicEndpointResourceProperties is the BasicEndpointResourceProperties implementation for EventHub.
func (eh EventHub) AsBasicEndpointResourceProperties() (BasicEndpointResourceProperties, bool) {
	return &eh, true
}

// ExternalResource definition of a resource.
type ExternalResource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Extension resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// GroupIDInformation the group information for creating a private endpoint on Digital Twin.
type GroupIDInformation struct {
	autorest.Response `json:"-"`
	Properties        *GroupIDInformationPropertiesModel `json:"properties,omitempty"`
	// ID - The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupIDInformation.
func (gii GroupIDInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gii.Properties != nil {
		objectMap["properties"] = gii.Properties
	}
	if gii.ID != nil {
		objectMap["id"] = gii.ID
	}
	return json.Marshal(objectMap)
}

// GroupIDInformationProperties the properties for a group information object.
type GroupIDInformationProperties struct {
	// GroupID - The group id
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - The required members for a specific group id.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The required DNS zones for a specific group id.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// GroupIDInformationPropertiesModel ...
type GroupIDInformationPropertiesModel struct {
	// GroupID - The group id
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - The required members for a specific group id.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The required DNS zones for a specific group id.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// GroupIDInformationResponse the available private link resources for a Digital Twin.
type GroupIDInformationResponse struct {
	autorest.Response `json:"-"`
	// Value - The list of available private link resources for a Digital Twin.
	Value *[]GroupIDInformation `json:"value,omitempty"`
}

// Identity the managed identity for the DigitalTwinsInstance.
type Identity struct {
	// Type - The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is supported. Possible values include: 'None', 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The object id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a systemAssigned(implicit) identity
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the Managed Identity Resource. This will be sent to the RP from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a systemAssigned(implicit) identity
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// Operation digitalTwins service REST API operation
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string `json:"name,omitempty"`
	// Display - Operation properties display
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`
	// IsDataAction - READ-ONLY; If the operation is a data action (for data plane rbac).
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft DigitalTwins
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource Type: DigitalTwinsInstances
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Name of the operation
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; Friendly description for the operation,
	Description *string `json:"description,omitempty"`
}

// OperationListResult a list of DigitalTwins service operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// NextLink - The link used to get the next page of DigitalTwins description objects.
	NextLink *string `json:"nextLink,omitempty"`
	// Value - READ-ONLY; A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if olr.NextLink != nil {
		objectMap["nextLink"] = olr.NextLink
	}
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PatchDescription the description of the DigitalTwins service.
type PatchDescription struct {
	// Tags - Instance patch properties
	Tags map[string]*string `json:"tags"`
	// Identity - The managed identity for the DigitalTwinsInstance.
	Identity *Identity `json:"identity,omitempty"`
	// Properties - Properties for the DigitalTwinsInstance.
	Properties *PatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PatchDescription.
func (pd PatchDescription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pd.Tags != nil {
		objectMap["tags"] = pd.Tags
	}
	if pd.Identity != nil {
		objectMap["identity"] = pd.Identity
	}
	if pd.Properties != nil {
		objectMap["properties"] = pd.Properties
	}
	return json.Marshal(objectMap)
}

// PatchProperties the properties of a DigitalTwinsInstance.
type PatchProperties struct {
	// PublicNetworkAccess - Public network access for the DigitalTwinsInstance. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// PrivateEndpoint the private endpoint property of a private endpoint connection.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection the private endpoint connection of a Digital Twin.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type       *string                              `json:"type,omitempty"`
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.Properties != nil {
		objectMap["properties"] = pec.Properties
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionProperties ...
type PrivateEndpointConnectionProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	ProvisioningState ConnectionPropertiesProvisioningState `json:"provisioningState,omitempty"`
	PrivateEndpoint   *ConnectionPropertiesPrivateEndpoint  `json:"privateEndpoint,omitempty"`
	// GroupIds - The list of group ids for the private endpoint connection.
	GroupIds                          *[]string                                              `json:"groupIds,omitempty"`
	PrivateLinkServiceConnectionState *ConnectionPropertiesPrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pec PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pec.PrivateEndpoint
	}
	if pec.GroupIds != nil {
		objectMap["groupIds"] = pec.GroupIds
	}
	if pec.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pec.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// PrivateEndpointConnectionsResponse the available private link connections for a Digital Twin.
type PrivateEndpointConnectionsResponse struct {
	autorest.Response `json:"-"`
	// Value - The list of available private link connections for a Digital Twin.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// Properties the properties of a DigitalTwinsInstance.
type Properties struct {
	// CreatedTime - READ-ONLY; Time when DigitalTwinsInstance was created.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// LastUpdatedTime - READ-ONLY; Time when DigitalTwinsInstance was updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'ProvisioningStateProvisioning', 'ProvisioningStateDeleting', 'ProvisioningStateUpdating', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateDeleted', 'ProvisioningStateWarning', 'ProvisioningStateSuspending', 'ProvisioningStateRestoring', 'ProvisioningStateMoving'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// HostName - READ-ONLY; Api endpoint to work with DigitalTwinsInstance.
	HostName                   *string                      `json:"hostName,omitempty"`
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Public network access for the DigitalTwinsInstance. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PrivateEndpointConnections != nil {
		objectMap["privateEndpointConnections"] = p.PrivateEndpointConnections
	}
	if p.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = p.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// Resource the common properties of a DigitalTwinsInstance.
type Resource struct {
	// ID - READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
	// Location - The resource location.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Identity - The managed identity for the DigitalTwinsInstance.
	Identity *Identity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	return json.Marshal(objectMap)
}

// ServiceBus properties related to ServiceBus.
type ServiceBus struct {
	// PrimaryConnectionString - PrimaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty"`
	// SecondaryConnectionString - SecondaryConnectionString of the endpoint for key-based authentication. Will be obfuscated during read.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty"`
	// EndpointURI - The URL of the ServiceBus namespace for identity-based authentication. It must include the protocol sb://
	EndpointURI *string `json:"endpointUri,omitempty"`
	// EntityPath - The ServiceBus Topic name for identity-based authentication
	EntityPath *string `json:"entityPath,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state. Possible values include: 'Provisioning', 'Deleting', 'Succeeded', 'Failed', 'Canceled', 'Deleted', 'Warning', 'Suspending', 'Restoring', 'Moving', 'Disabled'
	ProvisioningState EndpointProvisioningState `json:"provisioningState,omitempty"`
	// CreatedTime - READ-ONLY; Time when the Endpoint was added to DigitalTwinsInstance.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// AuthenticationType - Specifies the authentication type being used for connecting to the endpoint. Possible values include: 'KeyBased', 'IdentityBased'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
	// DeadLetterSecret - Dead letter storage secret for key-based authentication. Will be obfuscated during read.
	DeadLetterSecret *string `json:"deadLetterSecret,omitempty"`
	// DeadLetterURI - Dead letter storage URL for identity-based authentication.
	DeadLetterURI *string `json:"deadLetterUri,omitempty"`
	// EndpointType - Possible values include: 'EndpointTypeDigitalTwinsEndpointResourceProperties', 'EndpointTypeServiceBus', 'EndpointTypeEventHub', 'EndpointTypeEventGrid'
	EndpointType EndpointType `json:"endpointType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceBus.
func (sb ServiceBus) MarshalJSON() ([]byte, error) {
	sb.EndpointType = EndpointTypeServiceBus
	objectMap := make(map[string]interface{})
	if sb.PrimaryConnectionString != nil {
		objectMap["primaryConnectionString"] = sb.PrimaryConnectionString
	}
	if sb.SecondaryConnectionString != nil {
		objectMap["secondaryConnectionString"] = sb.SecondaryConnectionString
	}
	if sb.EndpointURI != nil {
		objectMap["endpointUri"] = sb.EndpointURI
	}
	if sb.EntityPath != nil {
		objectMap["entityPath"] = sb.EntityPath
	}
	if sb.AuthenticationType != "" {
		objectMap["authenticationType"] = sb.AuthenticationType
	}
	if sb.DeadLetterSecret != nil {
		objectMap["deadLetterSecret"] = sb.DeadLetterSecret
	}
	if sb.DeadLetterURI != nil {
		objectMap["deadLetterUri"] = sb.DeadLetterURI
	}
	if sb.EndpointType != "" {
		objectMap["endpointType"] = sb.EndpointType
	}
	return json.Marshal(objectMap)
}

// AsServiceBus is the BasicEndpointResourceProperties implementation for ServiceBus.
func (sb ServiceBus) AsServiceBus() (*ServiceBus, bool) {
	return &sb, true
}

// AsEventHub is the BasicEndpointResourceProperties implementation for ServiceBus.
func (sb ServiceBus) AsEventHub() (*EventHub, bool) {
	return nil, false
}

// AsEventGrid is the BasicEndpointResourceProperties implementation for ServiceBus.
func (sb ServiceBus) AsEventGrid() (*EventGrid, bool) {
	return nil, false
}

// AsEndpointResourceProperties is the BasicEndpointResourceProperties implementation for ServiceBus.
func (sb ServiceBus) AsEndpointResourceProperties() (*EndpointResourceProperties, bool) {
	return nil, false
}

// AsBasicEndpointResourceProperties is the BasicEndpointResourceProperties implementation for ServiceBus.
func (sb ServiceBus) AsBasicEndpointResourceProperties() (BasicEndpointResourceProperties, bool) {
	return &sb, true
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (Description, error)
}
