package templatespecs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindTemplate ...
	KindTemplate Kind = "template"
	// KindTemplateSpecArtifact ...
	KindTemplateSpecArtifact Kind = "TemplateSpecArtifact"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindTemplate, KindTemplateSpecArtifact}
}

// TemplateSpecExpandKind enumerates the values for template spec expand kind.
type TemplateSpecExpandKind string

const (
	// Versions Includes version information with the Template Spec.
	Versions TemplateSpecExpandKind = "versions"
)

// PossibleTemplateSpecExpandKindValues returns an array of possible values for the TemplateSpecExpandKind const type.
func PossibleTemplateSpecExpandKindValues() []TemplateSpecExpandKind {
	return []TemplateSpecExpandKind{Versions}
}
