package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/2017-03-01-preview/sql"

// AutomaticTuningOptions automatic tuning properties for individual advisors.
type AutomaticTuningOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'Default', 'Disabled', 'AutoConfigured', 'InheritedFromServer', 'QueryStoreOff', 'QueryStoreReadOnly', 'NotSupported'
	ReasonDesc AutomaticTuningDisabledReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningOptions.
func (ato AutomaticTuningOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ato.DesiredState != "" {
		objectMap["desiredState"] = ato.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerOptions automatic tuning properties for individual advisors.
type AutomaticTuningServerOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - READ-ONLY; Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - READ-ONLY; Reason description if desired and actual state are different. Possible values include: 'AutomaticTuningServerReasonDefault', 'AutomaticTuningServerReasonDisabled', 'AutomaticTuningServerReasonAutoConfigured'
	ReasonDesc AutomaticTuningServerReason `json:"reasonDesc,omitempty"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerOptions.
func (atso AutomaticTuningServerOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atso.DesiredState != "" {
		objectMap["desiredState"] = atso.DesiredState
	}
	return json.Marshal(objectMap)
}

// AutomaticTuningServerProperties server-level Automatic Tuning properties.
type AutomaticTuningServerProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	DesiredState AutomaticTuningServerMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	ActualState AutomaticTuningServerMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningServerOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerProperties.
func (atsp AutomaticTuningServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atsp.DesiredState != "" {
		objectMap["desiredState"] = atsp.DesiredState
	}
	if atsp.Options != nil {
		objectMap["options"] = atsp.Options
	}
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityRequest a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	// Name - The name whose availability is to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource that is used as the scope of the availability check.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse a response indicating whether the specified name for a resource is
// available.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Available - READ-ONLY; True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty"`
	// Message - READ-ONLY; A message explaining why the name is unavailable. Will be null if the name is available.
	Message *string `json:"message,omitempty"`
	// Name - READ-ONLY; The name whose availability was checked.
	Name *string `json:"name,omitempty"`
	// Reason - READ-ONLY; The reason code explaining why the name is unavailable. Will be null if the name is available. Possible values include: 'Invalid', 'AlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// CompleteDatabaseRestoreDefinition contains the information necessary to perform a complete database
// restore operation.
type CompleteDatabaseRestoreDefinition struct {
	// LastBackupName - The last backup name to apply
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// CreateDatabaseRestorePointDefinition contains the information necessary to perform a create database
// restore point operation.
type CreateDatabaseRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// Database represents a database.
type Database struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of database.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuning database-level Automatic Tuning.
type DatabaseAutomaticTuning struct {
	autorest.Response `json:"-"`
	// DatabaseAutomaticTuningProperties - Resource properties.
	*DatabaseAutomaticTuningProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuning.
func (dat DatabaseAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dat.DatabaseAutomaticTuningProperties != nil {
		objectMap["properties"] = dat.DatabaseAutomaticTuningProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAutomaticTuning struct.
func (dat *DatabaseAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseAutomaticTuningProperties DatabaseAutomaticTuningProperties
				err = json.Unmarshal(*v, &databaseAutomaticTuningProperties)
				if err != nil {
					return err
				}
				dat.DatabaseAutomaticTuningProperties = &databaseAutomaticTuningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dat.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuningProperties database-level Automatic Tuning properties.
type DatabaseAutomaticTuningProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	DesiredState AutomaticTuningMode `json:"desiredState,omitempty"`
	// ActualState - READ-ONLY; Automatic tuning actual state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	ActualState AutomaticTuningMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuningProperties.
func (datp DatabaseAutomaticTuningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if datp.DesiredState != "" {
		objectMap["desiredState"] = datp.DesiredState
	}
	if datp.Options != nil {
		objectMap["options"] = datp.Options
	}
	return json.Marshal(objectMap)
}

// DatabaseBlobAuditingPolicy a database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseBlobAuditingPolicyProperties - Resource properties.
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseBlobAuditingPolicy.
func (dbap DatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbap.DatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = dbap.DatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseBlobAuditingPolicy struct.
func (dbap *DatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseBlobAuditingPolicyProperties DatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &databaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				dbap.DatabaseBlobAuditingPolicyProperties = &databaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseBlobAuditingPolicyListResult a list of database auditing settings.
type DatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page DatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Response() DatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseBlobAuditingPolicyListResultIterator) Value() DatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return DatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultIterator type.
func NewDatabaseBlobAuditingPolicyListResultIterator(page DatabaseBlobAuditingPolicyListResultPage) DatabaseBlobAuditingPolicyListResultIterator {
	return DatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dbaplr DatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return dbaplr.Value == nil || len(*dbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dbaplr DatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return dbaplr.NextLink != nil && len(*dbaplr.NextLink) != 0
}

// databaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dbaplr DatabaseBlobAuditingPolicyListResult) databaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dbaplr.NextLink)))
}

// DatabaseBlobAuditingPolicyListResultPage contains a page of DatabaseBlobAuditingPolicy values.
type DatabaseBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)
	dbaplr DatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dbaplr)
		if err != nil {
			return err
		}
		page.dbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.dbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseBlobAuditingPolicyListResultPage) Response() DatabaseBlobAuditingPolicyListResult {
	return page.dbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseBlobAuditingPolicyListResultPage) Values() []DatabaseBlobAuditingPolicy {
	if page.dbaplr.IsEmpty() {
		return nil
	}
	return *page.dbaplr.Value
}

// Creates a new instance of the DatabaseBlobAuditingPolicyListResultPage type.
func NewDatabaseBlobAuditingPolicyListResultPage(cur DatabaseBlobAuditingPolicyListResult, getNextPage func(context.Context, DatabaseBlobAuditingPolicyListResult) (DatabaseBlobAuditingPolicyListResult, error)) DatabaseBlobAuditingPolicyListResultPage {
	return DatabaseBlobAuditingPolicyListResultPage{
		fn:     getNextPage,
		dbaplr: cur,
	}
}

// DatabaseBlobAuditingPolicyProperties properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// DatabaseListResult represents the response to a list database request.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of databases housed in the server.
	Value *[]Database `json:"value,omitempty"`
}

// DatabaseOperation a database operation.
type DatabaseOperation struct {
	// DatabaseOperationProperties - Resource properties.
	*DatabaseOperationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperation.
func (do DatabaseOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.DatabaseOperationProperties != nil {
		objectMap["properties"] = do.DatabaseOperationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseOperation struct.
func (do *DatabaseOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseOperationProperties DatabaseOperationProperties
				err = json.Unmarshal(*v, &databaseOperationProperties)
				if err != nil {
					return err
				}
				do.DatabaseOperationProperties = &databaseOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				do.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				do.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				do.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseOperationListResult the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseOperationListResultIterator provides access to a complete listing of DatabaseOperation values.
type DatabaseOperationListResultIterator struct {
	i    int
	page DatabaseOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseOperationListResultIterator) Response() DatabaseOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseOperationListResultIterator) Value() DatabaseOperation {
	if !iter.page.NotDone() {
		return DatabaseOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseOperationListResultIterator type.
func NewDatabaseOperationListResultIterator(page DatabaseOperationListResultPage) DatabaseOperationListResultIterator {
	return DatabaseOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DatabaseOperationListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DatabaseOperationListResult) hasNextLink() bool {
	return dolr.NextLink != nil && len(*dolr.NextLink) != 0
}

// databaseOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DatabaseOperationListResult) databaseOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DatabaseOperationListResultPage contains a page of DatabaseOperation values.
type DatabaseOperationListResultPage struct {
	fn   func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)
	dolr DatabaseOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseOperationListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseOperationListResultPage) Response() DatabaseOperationListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseOperationListResultPage) Values() []DatabaseOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DatabaseOperationListResultPage type.
func NewDatabaseOperationListResultPage(cur DatabaseOperationListResult, getNextPage func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)) DatabaseOperationListResultPage {
	return DatabaseOperationListResultPage{
		fn:   getNextPage,
		dolr: cur,
	}
}

// DatabaseOperationProperties the properties of a database operation.
type DatabaseOperationProperties struct {
	// DatabaseName - READ-ONLY; The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - READ-ONLY; The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - READ-ONLY; The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - READ-ONLY; The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - READ-ONLY; The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - READ-ONLY; The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - READ-ONLY; Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - READ-ONLY; The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - READ-ONLY; The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - READ-ONLY; Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// DatabaseProperties represents the properties of a database.
type DatabaseProperties struct {
	// Collation - The collation of the database. If createMode is not Default, this value is ignored.
	Collation *string `json:"collation,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ContainmentState - READ-ONLY; The containment state of the database.
	ContainmentState *int64 `json:"containmentState,omitempty"`
	// CurrentServiceObjectiveID - READ-ONLY; The current service level objective ID of the database. This is the ID of the service level objective that is currently active.
	CurrentServiceObjectiveID *uuid.UUID `json:"currentServiceObjectiveId,omitempty"`
	// DatabaseID - READ-ONLY; The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// EarliestRestoreDate - READ-ONLY; This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// CreateMode - Specifies the mode of database creation.
	// Default: regular database creation.
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	// OnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	// Copy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeCopy', 'CreateModeDefault', 'CreateModeNonReadableSecondary', 'CreateModeOnlineSecondary', 'CreateModePointInTimeRestore', 'CreateModeRecovery', 'CreateModeRestore', 'CreateModeRestoreLongTermRetentionBackup'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// SourceDatabaseID - Conditional. If createMode is Copy, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, or Restore, then this value is required. Specifies the resource ID of the source database. If createMode is NonReadableSecondary or OnlineSecondary, the name of the source database must be the same as the new database being created.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// SourceDatabaseDeletionDate - Conditional. If createMode is Restore and sourceDatabaseId is the deleted database's original resource id when it existed (as opposed to its current restorable dropped database id), then this value is required. Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. If createMode is Restore, this value is optional. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. Must be greater than or equal to the source database's earliestRestoreDate value.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// RecoveryServicesRecoveryPointResourceID - Conditional. If createMode is RestoreLongTermRetentionBackup, then this value is required. Specifies the resource ID of the recovery point to restore from.
	RecoveryServicesRecoveryPointResourceID *string `json:"recoveryServicesRecoveryPointResourceId,omitempty"`
	// Edition - The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2', 'GeneralPurpose', 'BusinessCritical', 'Hyperscale'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes. If createMode is not Default, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation."
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// RequestedServiceObjectiveID - The configured service level objective ID of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of currentServiceObjectiveId property. If requestedServiceObjectiveId and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveId overrides the value of requestedServiceObjectiveName.
	//
	// The list of SKUs may vary by region and support offer. To determine the service objective ids that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API.
	RequestedServiceObjectiveID *uuid.UUID `json:"requestedServiceObjectiveId,omitempty"`
	// RequestedServiceObjectiveName - The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	RequestedServiceObjectiveName ServiceObjectiveName `json:"requestedServiceObjectiveName,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The current service level objective of the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// Status - READ-ONLY; The status of the database.
	Status *string `json:"status,omitempty"`
	// ElasticPoolName - The name of the elastic pool the database is in. If elasticPoolName and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveName is ignored. Not supported for DataWarehouse edition.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// ServiceTierAdvisors - READ-ONLY; The list of service tier advisors for this database. Expanded property
	ServiceTierAdvisors *[]ServiceTierAdvisor `json:"serviceTierAdvisors,omitempty"`
	// TransparentDataEncryption - READ-ONLY; The transparent data encryption info for this database.
	TransparentDataEncryption *[]TransparentDataEncryption `json:"transparentDataEncryption,omitempty"`
	// RecommendedIndex - READ-ONLY; The recommended indices for this database.
	RecommendedIndex *[]RecommendedIndex `json:"recommendedIndex,omitempty"`
	// FailoverGroupID - READ-ONLY; The resource identifier of the failover group containing this database.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// ReadScale - Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition. Possible values include: 'ReadScaleEnabled', 'ReadScaleDisabled'
	ReadScale ReadScale `json:"readScale,omitempty"`
	// SampleName - Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition. Possible values include: 'AdventureWorksLT'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseProperties.
func (dp DatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dp.Collation != nil {
		objectMap["collation"] = dp.Collation
	}
	if dp.CreateMode != "" {
		objectMap["createMode"] = dp.CreateMode
	}
	if dp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = dp.SourceDatabaseID
	}
	if dp.SourceDatabaseDeletionDate != nil {
		objectMap["sourceDatabaseDeletionDate"] = dp.SourceDatabaseDeletionDate
	}
	if dp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = dp.RestorePointInTime
	}
	if dp.RecoveryServicesRecoveryPointResourceID != nil {
		objectMap["recoveryServicesRecoveryPointResourceId"] = dp.RecoveryServicesRecoveryPointResourceID
	}
	if dp.Edition != "" {
		objectMap["edition"] = dp.Edition
	}
	if dp.MaxSizeBytes != nil {
		objectMap["maxSizeBytes"] = dp.MaxSizeBytes
	}
	if dp.RequestedServiceObjectiveID != nil {
		objectMap["requestedServiceObjectiveId"] = dp.RequestedServiceObjectiveID
	}
	if dp.RequestedServiceObjectiveName != "" {
		objectMap["requestedServiceObjectiveName"] = dp.RequestedServiceObjectiveName
	}
	if dp.ElasticPoolName != nil {
		objectMap["elasticPoolName"] = dp.ElasticPoolName
	}
	if dp.ReadScale != "" {
		objectMap["readScale"] = dp.ReadScale
	}
	if dp.SampleName != "" {
		objectMap["sampleName"] = dp.SampleName
	}
	if dp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = dp.ZoneRedundant
	}
	return json.Marshal(objectMap)
}

// DatabasesCreateImportOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesCreateImportOperationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// DatabaseSecurityAlertPolicy contains information about a database Threat Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseSecurityAlertPolicyProperties - Properties of the security alert policy.
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertPolicy.
func (dsap DatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsap.Location != nil {
		objectMap["location"] = dsap.Location
	}
	if dsap.DatabaseSecurityAlertPolicyProperties != nil {
		objectMap["properties"] = dsap.DatabaseSecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSecurityAlertPolicy struct.
func (dsap *DatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dsap.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dsap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseSecurityAlertPolicyProperties DatabaseSecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &databaseSecurityAlertPolicyProperties)
				if err != nil {
					return err
				}
				dsap.DatabaseSecurityAlertPolicyProperties = &databaseSecurityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSecurityAlertPolicyProperties properties for a database Threat Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
	DisabledAlerts *string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
	EmailAddresses *string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators. Possible values include: 'SecurityAlertPolicyEmailAccountAdminsEnabled', 'SecurityAlertPolicyEmailAccountAdminsDisabled'
	EmailAccountAdmins SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// UseServerDefault - Specifies whether to use the default server policy. Possible values include: 'SecurityAlertPolicyUseServerDefaultEnabled', 'SecurityAlertPolicyUseServerDefaultDisabled'
	UseServerDefault SecurityAlertPolicyUseServerDefault `json:"useServerDefault,omitempty"`
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesExportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesImportFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (ImportExportResponse, error)
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesPauseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (autorest.Response, error)
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabasesClient) (Database, error)
}

// DatabaseUpdate represents a database update.
type DatabaseUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseUsage the database usages.
type DatabaseUsage struct {
	// Name - READ-ONLY; The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// DatabaseUsageListResult the response to a list database metrics request.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database usages for the database.
	Value *[]DatabaseUsage `json:"value,omitempty"`
}

// DatabaseVulnerabilityAssessment a database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessment.
func (dva DatabaseVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dva.DatabaseVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = dva.DatabaseVulnerabilityAssessmentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessment struct.
func (dva *DatabaseVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentProperties DatabaseVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				dva.DatabaseVulnerabilityAssessmentProperties = &databaseVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dva.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentListResult a list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]DatabaseVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultIterator struct {
	i    int
	page DatabaseVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Response() DatabaseVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Value() DatabaseVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return DatabaseVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultIterator type.
func NewDatabaseVulnerabilityAssessmentListResultIterator(page DatabaseVulnerabilityAssessmentListResultPage) DatabaseVulnerabilityAssessmentListResultIterator {
	return DatabaseVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvalr DatabaseVulnerabilityAssessmentListResult) IsEmpty() bool {
	return dvalr.Value == nil || len(*dvalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvalr DatabaseVulnerabilityAssessmentListResult) hasNextLink() bool {
	return dvalr.NextLink != nil && len(*dvalr.NextLink) != 0
}

// databaseVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvalr DatabaseVulnerabilityAssessmentListResult) databaseVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvalr.NextLink)))
}

// DatabaseVulnerabilityAssessmentListResultPage contains a page of DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)
	dvalr DatabaseVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvalr)
		if err != nil {
			return err
		}
		page.dvalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.dvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseVulnerabilityAssessmentListResultPage) Response() DatabaseVulnerabilityAssessmentListResult {
	return page.dvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseVulnerabilityAssessmentListResultPage) Values() []DatabaseVulnerabilityAssessment {
	if page.dvalr.IsEmpty() {
		return nil
	}
	return *page.dvalr.Value
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultPage type.
func NewDatabaseVulnerabilityAssessmentListResultPage(cur DatabaseVulnerabilityAssessmentListResult, getNextPage func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)) DatabaseVulnerabilityAssessmentListResultPage {
	return DatabaseVulnerabilityAssessmentListResultPage{
		fn:    getNextPage,
		dvalr: cur,
	}
}

// DatabaseVulnerabilityAssessmentProperties properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has read and write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline a database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentRuleBaseline.
func (dvarb DatabaseVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentRuleBaseline struct.
func (dvarb *DatabaseVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentRuleBaselineProperties DatabaseVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties = &databaseVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem properties for an Azure SQL Database Vulnerability
// Assessment rule baseline's result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties properties of a database Vulnerability Assessment
// rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DataMaskingPolicy represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - READ-ONLY; The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - READ-ONLY; The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicyProperties.
func (dmpp DataMaskingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmpp.DataMaskingState != "" {
		objectMap["dataMaskingState"] = dmpp.DataMaskingState
	}
	if dmpp.ExemptPrincipals != nil {
		objectMap["exemptPrincipals"] = dmpp.ExemptPrincipals
	}
	return json.Marshal(objectMap)
}

// DataMaskingRule represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// ID - READ-ONLY; The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRuleProperties.
func (dmrp DataMaskingRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmrp.AliasName != nil {
		objectMap["aliasName"] = dmrp.AliasName
	}
	if dmrp.RuleState != "" {
		objectMap["ruleState"] = dmrp.RuleState
	}
	if dmrp.SchemaName != nil {
		objectMap["schemaName"] = dmrp.SchemaName
	}
	if dmrp.TableName != nil {
		objectMap["tableName"] = dmrp.TableName
	}
	if dmrp.ColumnName != nil {
		objectMap["columnName"] = dmrp.ColumnName
	}
	if dmrp.MaskingFunction != "" {
		objectMap["maskingFunction"] = dmrp.MaskingFunction
	}
	if dmrp.NumberFrom != nil {
		objectMap["numberFrom"] = dmrp.NumberFrom
	}
	if dmrp.NumberTo != nil {
		objectMap["numberTo"] = dmrp.NumberTo
	}
	if dmrp.PrefixSize != nil {
		objectMap["prefixSize"] = dmrp.PrefixSize
	}
	if dmrp.SuffixSize != nil {
		objectMap["suffixSize"] = dmrp.SuffixSize
	}
	if dmrp.ReplacementString != nil {
		objectMap["replacementString"] = dmrp.ReplacementString
	}
	return json.Marshal(objectMap)
}

// DataWarehouseUserActivities user activities of a data warehouse
type DataWarehouseUserActivities struct {
	autorest.Response `json:"-"`
	// DataWarehouseUserActivitiesProperties - Resource properties.
	*DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivities.
func (dwua DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwua.DataWarehouseUserActivitiesProperties != nil {
		objectMap["properties"] = dwua.DataWarehouseUserActivitiesProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataWarehouseUserActivities struct.
func (dwua *DataWarehouseUserActivities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataWarehouseUserActivitiesProperties DataWarehouseUserActivitiesProperties
				err = json.Unmarshal(*v, &dataWarehouseUserActivitiesProperties)
				if err != nil {
					return err
				}
				dwua.DataWarehouseUserActivitiesProperties = &dataWarehouseUserActivitiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dwua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dwua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dwua.Type = &typeVar
			}
		}
	}

	return nil
}

// DataWarehouseUserActivitiesProperties user activities of a data warehouse. This currently includes the
// count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests
// dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// ActiveQueriesCount - READ-ONLY; Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty"`
}

// EditionCapability the database edition capabilities.
type EditionCapability struct {
	// Name - READ-ONLY; The edition name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServiceLevelObjectives - READ-ONLY; The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPool represents a database elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of elastic pool.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivity represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolActivityProperties - The properties representing the resource.
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivity.
func (epa ElasticPoolActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epa.Location != nil {
		objectMap["location"] = epa.Location
	}
	if epa.ElasticPoolActivityProperties != nil {
		objectMap["properties"] = epa.ElasticPoolActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolActivity struct.
func (epa *ElasticPoolActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epa.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolActivityProperties ElasticPoolActivityProperties
				err = json.Unmarshal(*v, &elasticPoolActivityProperties)
				if err != nil {
					return err
				}
				epa.ElasticPoolActivityProperties = &elasticPoolActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epa.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivityListResult represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool activities.
	Value *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedDatabaseDtuMax - READ-ONLY; The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty"`
	// RequestedDatabaseDtuMin - READ-ONLY; The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty"`
	// RequestedDtu - READ-ONLY; The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// RequestedStorageLimitInGB - READ-ONLY; The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty"`
	// ElasticPoolName - READ-ONLY; The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
	// RequestedStorageLimitInMB - READ-ONLY; The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty"`
	// RequestedDatabaseDtuGuarantee - READ-ONLY; The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty"`
	// RequestedDatabaseDtuCap - READ-ONLY; The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty"`
	// RequestedDtuGuarantee - READ-ONLY; The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty"`
}

// ElasticPoolDatabaseActivity represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolDatabaseActivityProperties - The properties representing the resource.
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivity.
func (epda ElasticPoolDatabaseActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epda.Location != nil {
		objectMap["location"] = epda.Location
	}
	if epda.ElasticPoolDatabaseActivityProperties != nil {
		objectMap["properties"] = epda.ElasticPoolDatabaseActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolDatabaseActivity struct.
func (epda *ElasticPoolDatabaseActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epda.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolDatabaseActivityProperties ElasticPoolDatabaseActivityProperties
				err = json.Unmarshal(*v, &elasticPoolDatabaseActivityProperties)
				if err != nil {
					return err
				}
				epda.ElasticPoolDatabaseActivityProperties = &elasticPoolDatabaseActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epda.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolDatabaseActivityListResult represents the response to a list elastic pool database activity
// request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool database activities.
	Value *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// EndTime - READ-ONLY; The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - READ-ONLY; The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - READ-ONLY; The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - READ-ONLY; The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - READ-ONLY; The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - READ-ONLY; The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - READ-ONLY; The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedElasticPoolName - READ-ONLY; The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// CurrentElasticPoolName - READ-ONLY; The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty"`
	// CurrentServiceObjective - READ-ONLY; The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty"`
	// RequestedServiceObjective - READ-ONLY; The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty"`
	// ServerName - READ-ONLY; The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - READ-ONLY; The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - READ-ONLY; The current state of the operation.
	State *string `json:"state,omitempty"`
}

// ElasticPoolDtuCapability the Elastic Pool DTU capability.
type ElasticPoolDtuCapability struct {
	// Limit - READ-ONLY; The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// MaxDatabaseCount - READ-ONLY; The maximum number of databases supported.
	MaxDatabaseCount *int64 `json:"maxDatabaseCount,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedPerDatabaseMaxSizes - READ-ONLY; The list of supported max database sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxDtus - READ-ONLY; The list of supported max database DTUs.
	SupportedPerDatabaseMaxDtus *[]ElasticPoolPerDatabaseMaxDtuCapability `json:"supportedPerDatabaseMaxDtus,omitempty"`
}

// ElasticPoolEditionCapability the elastic pool edition capabilities.
type ElasticPoolEditionCapability struct {
	// Name - READ-ONLY; The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the elastic pool edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedElasticPoolDtus - READ-ONLY; The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolDtus *[]ElasticPoolDtuCapability `json:"supportedElasticPoolDtus,omitempty"`
	// ZoneRedundant - READ-ONLY; Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPoolListResult represents the response to a list elastic pool request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pools hosted in the server.
	Value *[]ElasticPool `json:"value,omitempty"`
}

// ElasticPoolPerDatabaseMaxDtuCapability the max per-database DTU capability.
type ElasticPoolPerDatabaseMaxDtuCapability struct {
	// Limit - READ-ONLY; The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedPerDatabaseMinDtus - READ-ONLY; The list of supported min database DTUs.
	SupportedPerDatabaseMinDtus *[]ElasticPoolPerDatabaseMinDtuCapability `json:"supportedPerDatabaseMinDtus,omitempty"`
}

// ElasticPoolPerDatabaseMinDtuCapability the minimum per-database DTU capability.
type ElasticPoolPerDatabaseMinDtuCapability struct {
	// Limit - READ-ONLY; The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - READ-ONLY; The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// ElasticPoolProperties represents the properties of an elastic pool.
type ElasticPoolProperties struct {
	// CreationDate - READ-ONLY; The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// State - READ-ONLY; The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// Edition - The edition of the elastic pool. Possible values include: 'ElasticPoolEditionBasic', 'ElasticPoolEditionStandard', 'ElasticPoolEditionPremium', 'ElasticPoolEditionGeneralPurpose', 'ElasticPoolEditionBusinessCritical'
	Edition ElasticPoolEdition `json:"edition,omitempty"`
	// Dtu - The total shared DTU for the database elastic pool.
	Dtu *int32 `json:"dtu,omitempty"`
	// DatabaseDtuMax - The maximum DTU any one database can consume.
	DatabaseDtuMax *int32 `json:"databaseDtuMax,omitempty"`
	// DatabaseDtuMin - The minimum DTU all databases are guaranteed.
	DatabaseDtuMin *int32 `json:"databaseDtuMin,omitempty"`
	// StorageMB - Gets storage limit for the database elastic pool in MB.
	StorageMB *int32 `json:"storageMB,omitempty"`
	// ZoneRedundant - Whether or not this database elastic pool is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolProperties.
func (epp ElasticPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.Edition != "" {
		objectMap["edition"] = epp.Edition
	}
	if epp.Dtu != nil {
		objectMap["dtu"] = epp.Dtu
	}
	if epp.DatabaseDtuMax != nil {
		objectMap["databaseDtuMax"] = epp.DatabaseDtuMax
	}
	if epp.DatabaseDtuMin != nil {
		objectMap["databaseDtuMin"] = epp.DatabaseDtuMin
	}
	if epp.StorageMB != nil {
		objectMap["storageMB"] = epp.StorageMB
	}
	if epp.ZoneRedundant != nil {
		objectMap["zoneRedundant"] = epp.ZoneRedundant
	}
	return json.Marshal(objectMap)
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ElasticPoolsClient) (ElasticPool, error)
}

// ElasticPoolUpdate represents an elastic pool update.
type ElasticPoolUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	if epu.ElasticPoolProperties != nil {
		objectMap["properties"] = epu.ElasticPoolProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolProperties = &elasticPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epu.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtector the server encryption protector.
type EncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// EncryptionProtectorProperties - Resource properties.
	*EncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtector.
func (ep EncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.EncryptionProtectorProperties != nil {
		objectMap["properties"] = ep.EncryptionProtectorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionProtector struct.
func (ep *EncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "properties":
			if v != nil {
				var encryptionProtectorProperties EncryptionProtectorProperties
				err = json.Unmarshal(*v, &encryptionProtectorProperties)
				if err != nil {
					return err
				}
				ep.EncryptionProtectorProperties = &encryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtectorListResult a list of server encryption protectors.
type EncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]EncryptionProtector `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EncryptionProtectorListResultIterator provides access to a complete listing of EncryptionProtector
// values.
type EncryptionProtectorListResultIterator struct {
	i    int
	page EncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionProtectorListResultIterator) Response() EncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionProtectorListResultIterator) Value() EncryptionProtector {
	if !iter.page.NotDone() {
		return EncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionProtectorListResultIterator type.
func NewEncryptionProtectorListResultIterator(page EncryptionProtectorListResultPage) EncryptionProtectorListResultIterator {
	return EncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr EncryptionProtectorListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr EncryptionProtectorListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// encryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr EncryptionProtectorListResult) encryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// EncryptionProtectorListResultPage contains a page of EncryptionProtector values.
type EncryptionProtectorListResultPage struct {
	fn   func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)
	eplr EncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionProtectorListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionProtectorListResultPage) Response() EncryptionProtectorListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionProtectorListResultPage) Values() []EncryptionProtector {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the EncryptionProtectorListResultPage type.
func NewEncryptionProtectorListResultPage(cur EncryptionProtectorListResult, getNextPage func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)) EncryptionProtectorListResultPage {
	return EncryptionProtectorListResultPage{
		fn:   getNextPage,
		eplr: cur,
	}
}

// EncryptionProtectorProperties properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// Subregion - READ-ONLY; Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyName - The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - READ-ONLY; The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - READ-ONLY; Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtectorProperties.
func (epp EncryptionProtectorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.ServerKeyName != nil {
		objectMap["serverKeyName"] = epp.ServerKeyName
	}
	if epp.ServerKeyType != "" {
		objectMap["serverKeyType"] = epp.ServerKeyType
	}
	return json.Marshal(objectMap)
}

// EncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EncryptionProtectorsClient) (EncryptionProtector, error)
}

// EncryptionProtectorsRevalidateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsRevalidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(EncryptionProtectorsClient) (autorest.Response, error)
}

// ExportRequest export database parameters.
type ExportRequest struct {
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicy an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedDatabaseBlobAuditingPolicyProperties - Resource properties.
	*ExtendedDatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedDatabaseBlobAuditingPolicy.
func (edbap ExtendedDatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if edbap.ExtendedDatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = edbap.ExtendedDatabaseBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedDatabaseBlobAuditingPolicy struct.
func (edbap *ExtendedDatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedDatabaseBlobAuditingPolicyProperties ExtendedDatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedDatabaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				edbap.ExtendedDatabaseBlobAuditingPolicyProperties = &extendedDatabaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				edbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				edbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				edbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedDatabaseBlobAuditingPolicyListResult a list of database extended auditing settings.
type ExtendedDatabaseBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedDatabaseBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedDatabaseBlobAuditingPolicy values.
type ExtendedDatabaseBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedDatabaseBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedDatabaseBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedDatabaseBlobAuditingPolicyListResultIterator) Value() ExtendedDatabaseBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedDatabaseBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultIterator type.
func NewExtendedDatabaseBlobAuditingPolicyListResultIterator(page ExtendedDatabaseBlobAuditingPolicyListResultPage) ExtendedDatabaseBlobAuditingPolicyListResultIterator {
	return ExtendedDatabaseBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) IsEmpty() bool {
	return edbaplr.Value == nil || len(*edbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) hasNextLink() bool {
	return edbaplr.NextLink != nil && len(*edbaplr.NextLink) != 0
}

// extendedDatabaseBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (edbaplr ExtendedDatabaseBlobAuditingPolicyListResult) extendedDatabaseBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !edbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(edbaplr.NextLink)))
}

// ExtendedDatabaseBlobAuditingPolicyListResultPage contains a page of ExtendedDatabaseBlobAuditingPolicy
// values.
type ExtendedDatabaseBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)
	edbaplr ExtendedDatabaseBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedDatabaseBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.edbaplr)
		if err != nil {
			return err
		}
		page.edbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedDatabaseBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.edbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Response() ExtendedDatabaseBlobAuditingPolicyListResult {
	return page.edbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedDatabaseBlobAuditingPolicyListResultPage) Values() []ExtendedDatabaseBlobAuditingPolicy {
	if page.edbaplr.IsEmpty() {
		return nil
	}
	return *page.edbaplr.Value
}

// Creates a new instance of the ExtendedDatabaseBlobAuditingPolicyListResultPage type.
func NewExtendedDatabaseBlobAuditingPolicyListResultPage(cur ExtendedDatabaseBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedDatabaseBlobAuditingPolicyListResult) (ExtendedDatabaseBlobAuditingPolicyListResult, error)) ExtendedDatabaseBlobAuditingPolicyListResultPage {
	return ExtendedDatabaseBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		edbaplr: cur,
	}
}

// ExtendedDatabaseBlobAuditingPolicyProperties properties of an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtendedServerBlobAuditingPoliciesClient) (ExtendedServerBlobAuditingPolicy, error)
}

// ExtendedServerBlobAuditingPolicy an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedServerBlobAuditingPolicyProperties - Resource properties.
	*ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicy.
func (esbap ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esbap.ExtendedServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = esbap.ExtendedServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedServerBlobAuditingPolicy struct.
func (esbap *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedServerBlobAuditingPolicyProperties ExtendedServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedServerBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				esbap.ExtendedServerBlobAuditingPolicyProperties = &extendedServerBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedServerBlobAuditingPolicyListResult a list of server extended auditing settings.
type ExtendedServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ExtendedServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExtendedServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ExtendedServerBlobAuditingPolicy values.
type ExtendedServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ExtendedServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtendedServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Response() ExtendedServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtendedServerBlobAuditingPolicyListResultIterator) Value() ExtendedServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ExtendedServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultIterator type.
func NewExtendedServerBlobAuditingPolicyListResultIterator(page ExtendedServerBlobAuditingPolicyListResultPage) ExtendedServerBlobAuditingPolicyListResultIterator {
	return ExtendedServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return esbaplr.Value == nil || len(*esbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return esbaplr.NextLink != nil && len(*esbaplr.NextLink) != 0
}

// extendedServerBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (esbaplr ExtendedServerBlobAuditingPolicyListResult) extendedServerBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !esbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(esbaplr.NextLink)))
}

// ExtendedServerBlobAuditingPolicyListResultPage contains a page of ExtendedServerBlobAuditingPolicy
// values.
type ExtendedServerBlobAuditingPolicyListResultPage struct {
	fn      func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)
	esbaplr ExtendedServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtendedServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.esbaplr)
		if err != nil {
			return err
		}
		page.esbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtendedServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtendedServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.esbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Response() ExtendedServerBlobAuditingPolicyListResult {
	return page.esbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtendedServerBlobAuditingPolicyListResultPage) Values() []ExtendedServerBlobAuditingPolicy {
	if page.esbaplr.IsEmpty() {
		return nil
	}
	return *page.esbaplr.Value
}

// Creates a new instance of the ExtendedServerBlobAuditingPolicyListResultPage type.
func NewExtendedServerBlobAuditingPolicyListResultPage(cur ExtendedServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ExtendedServerBlobAuditingPolicyListResult) (ExtendedServerBlobAuditingPolicyListResult, error)) ExtendedServerBlobAuditingPolicyListResultPage {
	return ExtendedServerBlobAuditingPolicyListResultPage{
		fn:      getNextPage,
		esbaplr: cur,
	}
}

// ExtendedServerBlobAuditingPolicyProperties properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// FailoverGroup a failover group.
type FailoverGroup struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// FailoverGroupProperties - Resource properties.
	*FailoverGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroup.
func (fg FailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fg.Tags != nil {
		objectMap["tags"] = fg.Tags
	}
	if fg.FailoverGroupProperties != nil {
		objectMap["properties"] = fg.FailoverGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroup struct.
func (fg *FailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fg.Tags = tags
			}
		case "properties":
			if v != nil {
				var failoverGroupProperties FailoverGroupProperties
				err = json.Unmarshal(*v, &failoverGroupProperties)
				if err != nil {
					return err
				}
				fg.FailoverGroupProperties = &failoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fg.Type = &typeVar
			}
		}
	}

	return nil
}

// FailoverGroupListResult a list of failover groups.
type FailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]FailoverGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FailoverGroupListResultIterator provides access to a complete listing of FailoverGroup values.
type FailoverGroupListResultIterator struct {
	i    int
	page FailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FailoverGroupListResultIterator) Response() FailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FailoverGroupListResultIterator) Value() FailoverGroup {
	if !iter.page.NotDone() {
		return FailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FailoverGroupListResultIterator type.
func NewFailoverGroupListResultIterator(page FailoverGroupListResultPage) FailoverGroupListResultIterator {
	return FailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fglr FailoverGroupListResult) IsEmpty() bool {
	return fglr.Value == nil || len(*fglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fglr FailoverGroupListResult) hasNextLink() bool {
	return fglr.NextLink != nil && len(*fglr.NextLink) != 0
}

// failoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fglr FailoverGroupListResult) failoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !fglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fglr.NextLink)))
}

// FailoverGroupListResultPage contains a page of FailoverGroup values.
type FailoverGroupListResultPage struct {
	fn   func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)
	fglr FailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fglr)
		if err != nil {
			return err
		}
		page.fglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FailoverGroupListResultPage) NotDone() bool {
	return !page.fglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FailoverGroupListResultPage) Response() FailoverGroupListResult {
	return page.fglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FailoverGroupListResultPage) Values() []FailoverGroup {
	if page.fglr.IsEmpty() {
		return nil
	}
	return *page.fglr.Value
}

// Creates a new instance of the FailoverGroupListResultPage type.
func NewFailoverGroupListResultPage(cur FailoverGroupListResult, getNextPage func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)) FailoverGroupListResultPage {
	return FailoverGroupListResultPage{
		fn:   getNextPage,
		fglr: cur,
	}
}

// FailoverGroupProperties properties of a failover group.
type FailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - READ-ONLY; Local replication role of the failover group instance. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - READ-ONLY; Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerServers - List of partner server information for the failover group.
	PartnerServers *[]PartnerInfo `json:"partnerServers,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroupProperties.
func (fgp FailoverGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgp.ReadWriteEndpoint != nil {
		objectMap["readWriteEndpoint"] = fgp.ReadWriteEndpoint
	}
	if fgp.ReadOnlyEndpoint != nil {
		objectMap["readOnlyEndpoint"] = fgp.ReadOnlyEndpoint
	}
	if fgp.PartnerServers != nil {
		objectMap["partnerServers"] = fgp.PartnerServers
	}
	if fgp.Databases != nil {
		objectMap["databases"] = fgp.Databases
	}
	return json.Marshal(objectMap)
}

// FailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FailoverGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// FailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (autorest.Response, error)
}

// FailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// FailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type FailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// FailoverGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(FailoverGroupsClient) (FailoverGroup, error)
}

// FailoverGroupUpdate a failover group update request.
type FailoverGroupUpdate struct {
	// FailoverGroupUpdateProperties - Resource properties.
	*FailoverGroupUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FailoverGroupUpdate.
func (fgu FailoverGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgu.FailoverGroupUpdateProperties != nil {
		objectMap["properties"] = fgu.FailoverGroupUpdateProperties
	}
	if fgu.Tags != nil {
		objectMap["tags"] = fgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroupUpdate struct.
func (fgu *FailoverGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var failoverGroupUpdateProperties FailoverGroupUpdateProperties
				err = json.Unmarshal(*v, &failoverGroupUpdateProperties)
				if err != nil {
					return err
				}
				fgu.FailoverGroupUpdateProperties = &failoverGroupUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fgu.Tags = tags
			}
		}
	}

	return nil
}

// FailoverGroupUpdateProperties properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Kind of server that contains this firewall rule.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// FirewallRuleProperties - The properties representing the resource.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fr.Location = &location
			}
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult represents the response to a List Firewall Rules request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server firewall rules.
	Value *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties represents the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - READ-ONLY; Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - READ-ONLY; The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicyProperties.
func (gbpp GeoBackupPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbpp.State != "" {
		objectMap["state"] = gbpp.State
	}
	return json.Marshal(objectMap)
}

// ImportExportResponse response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response `json:"-"`
	// ImportExportResponseProperties - The import/export operation properties.
	*ImportExportResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportResponse.
func (ier ImportExportResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.ImportExportResponseProperties != nil {
		objectMap["properties"] = ier.ImportExportResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportResponse struct.
func (ier *ImportExportResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportResponseProperties ImportExportResponseProperties
				err = json.Unmarshal(*v, &importExportResponseProperties)
				if err != nil {
					return err
				}
				ier.ImportExportResponseProperties = &importExportResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ier.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportResponseProperties response for Import/Export Status operation.
type ImportExportResponseProperties struct {
	// RequestType - READ-ONLY; The request type of the operation.
	RequestType *string `json:"requestType,omitempty"`
	// RequestID - READ-ONLY; The request type of the operation.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// ServerName - READ-ONLY; The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - READ-ONLY; The status message returned from the server.
	Status *string `json:"status,omitempty"`
	// LastModifiedTime - READ-ONLY; The operation status last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// QueuedTime - READ-ONLY; The operation queued time.
	QueuedTime *string `json:"queuedTime,omitempty"`
	// BlobURI - READ-ONLY; The blob uri.
	BlobURI *string `json:"blobUri,omitempty"`
	// ErrorMessage - READ-ONLY; The error message returned from the server.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ImportExtensionProperties represents the properties for an import operation
type ImportExtensionProperties struct {
	// OperationMode - The type of import operation being performed. This is always Import.
	OperationMode *string `json:"operationMode,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ImportExtensionRequest import database parameters.
type ImportExtensionRequest struct {
	// Name - The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extension.
	Type *string `json:"type,omitempty"`
	// ImportExtensionProperties - Represents the properties of the resource.
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExtensionRequest.
func (ier ImportExtensionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.Name != nil {
		objectMap["name"] = ier.Name
	}
	if ier.Type != nil {
		objectMap["type"] = ier.Type
	}
	if ier.ImportExtensionProperties != nil {
		objectMap["properties"] = ier.ImportExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExtensionRequest struct.
func (ier *ImportExtensionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var importExtensionProperties ImportExtensionProperties
				err = json.Unmarshal(*v, &importExtensionProperties)
				if err != nil {
					return err
				}
				ier.ImportExtensionProperties = &importExtensionProperties
			}
		}
	}

	return nil
}

// ImportRequest import database parameters.
type ImportRequest struct {
	// DatabaseName - The name of the database to import.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - The edition for the database being created.
	//
	// The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
	//
	// ```azurecli
	// az sql db list-editions -l <location> -o table
	// ````
	//
	// ```powershell
	// Get-AzSqlServerServiceObjective -Location <location>
	// ````
	// . Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2', 'GeneralPurpose', 'BusinessCritical', 'Hyperscale'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// ServiceObjectiveName - The name of the service objective to assign to the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceObjectiveName ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	// MaxSizeBytes - The maximum size for the newly imported database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// Job a job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - Resource properties.
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgent an Azure SQL job agent.
type JobAgent struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// JobAgentProperties - Resource properties.
	*JobAgentProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgent.
func (ja JobAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ja.Sku != nil {
		objectMap["sku"] = ja.Sku
	}
	if ja.JobAgentProperties != nil {
		objectMap["properties"] = ja.JobAgentProperties
	}
	if ja.Location != nil {
		objectMap["location"] = ja.Location
	}
	if ja.Tags != nil {
		objectMap["tags"] = ja.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobAgent struct.
func (ja *JobAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ja.Sku = &sku
			}
		case "properties":
			if v != nil {
				var jobAgentProperties JobAgentProperties
				err = json.Unmarshal(*v, &jobAgentProperties)
				if err != nil {
					return err
				}
				ja.JobAgentProperties = &jobAgentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ja.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ja.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ja.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ja.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgentListResult a list of Azure SQL job agents.
type JobAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobAgent `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobAgentListResultIterator provides access to a complete listing of JobAgent values.
type JobAgentListResultIterator struct {
	i    int
	page JobAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobAgentListResultIterator) Response() JobAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobAgentListResultIterator) Value() JobAgent {
	if !iter.page.NotDone() {
		return JobAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobAgentListResultIterator type.
func NewJobAgentListResultIterator(page JobAgentListResultPage) JobAgentListResultIterator {
	return JobAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jalr JobAgentListResult) IsEmpty() bool {
	return jalr.Value == nil || len(*jalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jalr JobAgentListResult) hasNextLink() bool {
	return jalr.NextLink != nil && len(*jalr.NextLink) != 0
}

// jobAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jalr JobAgentListResult) jobAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jalr.NextLink)))
}

// JobAgentListResultPage contains a page of JobAgent values.
type JobAgentListResultPage struct {
	fn   func(context.Context, JobAgentListResult) (JobAgentListResult, error)
	jalr JobAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jalr)
		if err != nil {
			return err
		}
		page.jalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobAgentListResultPage) NotDone() bool {
	return !page.jalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobAgentListResultPage) Response() JobAgentListResult {
	return page.jalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobAgentListResultPage) Values() []JobAgent {
	if page.jalr.IsEmpty() {
		return nil
	}
	return *page.jalr.Value
}

// Creates a new instance of the JobAgentListResultPage type.
func NewJobAgentListResultPage(cur JobAgentListResult, getNextPage func(context.Context, JobAgentListResult) (JobAgentListResult, error)) JobAgentListResultPage {
	return JobAgentListResultPage{
		fn:   getNextPage,
		jalr: cur,
	}
}

// JobAgentProperties properties of a job agent.
type JobAgentProperties struct {
	// DatabaseID - Resource ID of the database to store job metadata in.
	DatabaseID *string `json:"databaseId,omitempty"`
	// State - READ-ONLY; The state of the job agent. Possible values include: 'JobAgentStateCreating', 'JobAgentStateReady', 'JobAgentStateUpdating', 'JobAgentStateDeleting', 'JobAgentStateDisabled'
	State JobAgentState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgentProperties.
func (jap JobAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jap.DatabaseID != nil {
		objectMap["databaseId"] = jap.DatabaseID
	}
	return json.Marshal(objectMap)
}

// JobAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (JobAgent, error)
}

// JobAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (autorest.Response, error)
}

// JobAgentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobAgentsClient) (JobAgent, error)
}

// JobAgentUpdate an update to an Azure SQL job agent.
type JobAgentUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobAgentUpdate.
func (jau JobAgentUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jau.Tags != nil {
		objectMap["tags"] = jau.Tags
	}
	return json.Marshal(objectMap)
}

// JobCredential a stored credential that can be used by a job to connect to target databases.
type JobCredential struct {
	autorest.Response `json:"-"`
	// JobCredentialProperties - Resource properties.
	*JobCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCredential.
func (jc JobCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jc.JobCredentialProperties != nil {
		objectMap["properties"] = jc.JobCredentialProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCredential struct.
func (jc *JobCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCredentialProperties JobCredentialProperties
				err = json.Unmarshal(*v, &jobCredentialProperties)
				if err != nil {
					return err
				}
				jc.JobCredentialProperties = &jobCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jc.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCredentialListResult a list of job credentials.
type JobCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobCredential `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCredentialListResultIterator provides access to a complete listing of JobCredential values.
type JobCredentialListResultIterator struct {
	i    int
	page JobCredentialListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCredentialListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCredentialListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCredentialListResultIterator) Response() JobCredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCredentialListResultIterator) Value() JobCredential {
	if !iter.page.NotDone() {
		return JobCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCredentialListResultIterator type.
func NewJobCredentialListResultIterator(page JobCredentialListResultPage) JobCredentialListResultIterator {
	return JobCredentialListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jclr JobCredentialListResult) IsEmpty() bool {
	return jclr.Value == nil || len(*jclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jclr JobCredentialListResult) hasNextLink() bool {
	return jclr.NextLink != nil && len(*jclr.NextLink) != 0
}

// jobCredentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jclr JobCredentialListResult) jobCredentialListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jclr.NextLink)))
}

// JobCredentialListResultPage contains a page of JobCredential values.
type JobCredentialListResultPage struct {
	fn   func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)
	jclr JobCredentialListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCredentialListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jclr)
		if err != nil {
			return err
		}
		page.jclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCredentialListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCredentialListResultPage) NotDone() bool {
	return !page.jclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCredentialListResultPage) Response() JobCredentialListResult {
	return page.jclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCredentialListResultPage) Values() []JobCredential {
	if page.jclr.IsEmpty() {
		return nil
	}
	return *page.jclr.Value
}

// Creates a new instance of the JobCredentialListResultPage type.
func NewJobCredentialListResultPage(cur JobCredentialListResult, getNextPage func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)) JobCredentialListResultPage {
	return JobCredentialListResultPage{
		fn:   getNextPage,
		jclr: cur,
	}
}

// JobCredentialProperties properties of a job credential.
type JobCredentialProperties struct {
	// Username - The credential user name.
	Username *string `json:"username,omitempty"`
	// Password - The credential password.
	Password *string `json:"password,omitempty"`
}

// JobExecution an execution of a job
type JobExecution struct {
	autorest.Response `json:"-"`
	// JobExecutionProperties - Resource properties.
	*JobExecutionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecution.
func (je JobExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if je.JobExecutionProperties != nil {
		objectMap["properties"] = je.JobExecutionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobExecution struct.
func (je *JobExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobExecutionProperties JobExecutionProperties
				err = json.Unmarshal(*v, &jobExecutionProperties)
				if err != nil {
					return err
				}
				je.JobExecutionProperties = &jobExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				je.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				je.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				je.Type = &typeVar
			}
		}
	}

	return nil
}

// JobExecutionListResult a list of job executions.
type JobExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobExecution `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobExecutionListResultIterator provides access to a complete listing of JobExecution values.
type JobExecutionListResultIterator struct {
	i    int
	page JobExecutionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobExecutionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobExecutionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobExecutionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobExecutionListResultIterator) Response() JobExecutionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobExecutionListResultIterator) Value() JobExecution {
	if !iter.page.NotDone() {
		return JobExecution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobExecutionListResultIterator type.
func NewJobExecutionListResultIterator(page JobExecutionListResultPage) JobExecutionListResultIterator {
	return JobExecutionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jelr JobExecutionListResult) IsEmpty() bool {
	return jelr.Value == nil || len(*jelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jelr JobExecutionListResult) hasNextLink() bool {
	return jelr.NextLink != nil && len(*jelr.NextLink) != 0
}

// jobExecutionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jelr JobExecutionListResult) jobExecutionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jelr.NextLink)))
}

// JobExecutionListResultPage contains a page of JobExecution values.
type JobExecutionListResultPage struct {
	fn   func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)
	jelr JobExecutionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobExecutionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jelr)
		if err != nil {
			return err
		}
		page.jelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobExecutionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobExecutionListResultPage) NotDone() bool {
	return !page.jelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobExecutionListResultPage) Response() JobExecutionListResult {
	return page.jelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobExecutionListResultPage) Values() []JobExecution {
	if page.jelr.IsEmpty() {
		return nil
	}
	return *page.jelr.Value
}

// Creates a new instance of the JobExecutionListResultPage type.
func NewJobExecutionListResultPage(cur JobExecutionListResult, getNextPage func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)) JobExecutionListResultPage {
	return JobExecutionListResultPage{
		fn:   getNextPage,
		jelr: cur,
	}
}

// JobExecutionProperties properties for an Azure SQL Database Elastic job execution.
type JobExecutionProperties struct {
	// JobVersion - READ-ONLY; The job version number.
	JobVersion *int32 `json:"jobVersion,omitempty"`
	// StepName - READ-ONLY; The job step name.
	StepName *string `json:"stepName,omitempty"`
	// StepID - READ-ONLY; The job step id.
	StepID *int32 `json:"stepId,omitempty"`
	// JobExecutionID - READ-ONLY; The unique identifier of the job execution.
	JobExecutionID *uuid.UUID `json:"jobExecutionId,omitempty"`
	// Lifecycle - READ-ONLY; The detailed state of the job execution. Possible values include: 'Created', 'InProgress', 'WaitingForChildJobExecutions', 'WaitingForRetry', 'Succeeded', 'SucceededWithSkipped', 'Failed', 'TimedOut', 'Canceled', 'Skipped'
	Lifecycle JobExecutionLifecycle `json:"lifecycle,omitempty"`
	// ProvisioningState - READ-ONLY; The ARM provisioning state of the job execution. Possible values include: 'ProvisioningStateCreated', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreateTime - READ-ONLY; The time that the job execution was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - READ-ONLY; The time that the job execution started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The time that the job execution completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// CurrentAttempts - Number of times the job execution has been attempted.
	CurrentAttempts *int32 `json:"currentAttempts,omitempty"`
	// CurrentAttemptStartTime - READ-ONLY; Start time of the current attempt.
	CurrentAttemptStartTime *date.Time `json:"currentAttemptStartTime,omitempty"`
	// LastMessage - READ-ONLY; The last status or error message.
	LastMessage *string `json:"lastMessage,omitempty"`
	// Target - READ-ONLY; The target that this execution is executed on.
	Target *JobExecutionTarget `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecutionProperties.
func (jep JobExecutionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jep.CurrentAttempts != nil {
		objectMap["currentAttempts"] = jep.CurrentAttempts
	}
	return json.Marshal(objectMap)
}

// JobExecutionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobExecutionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobExecutionsClient) (JobExecution, error)
}

// JobExecutionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type JobExecutionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobExecutionsClient) (JobExecution, error)
}

// JobExecutionTarget the target that a job execution is executed on.
type JobExecutionTarget struct {
	// Type - READ-ONLY; The type of the target. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - READ-ONLY; The server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// JobListResult a list of jobs.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jlr JobListResult) hasNextLink() bool {
	return jlr.NextLink != nil && len(*jlr.NextLink) != 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jlr)
		if err != nil {
			return err
		}
		page.jlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(cur JobListResult, getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{
		fn:  getNextPage,
		jlr: cur,
	}
}

// JobProperties properties of a job.
type JobProperties struct {
	// Description - User-defined description of the job.
	Description *string `json:"description,omitempty"`
	// Version - READ-ONLY; The job version number.
	Version *int32 `json:"version,omitempty"`
	// Schedule - Schedule properties of the job.
	Schedule *JobSchedule `json:"schedule,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Description != nil {
		objectMap["description"] = jp.Description
	}
	if jp.Schedule != nil {
		objectMap["schedule"] = jp.Schedule
	}
	return json.Marshal(objectMap)
}

// JobSchedule scheduling properties of a job.
type JobSchedule struct {
	// StartTime - Schedule start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Schedule end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Type - Schedule interval type. Possible values include: 'Once', 'Recurring'
	Type JobScheduleType `json:"type,omitempty"`
	// Enabled - Whether or not the schedule is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Interval - Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
	Interval *string `json:"interval,omitempty"`
}

// JobStep a job step.
type JobStep struct {
	autorest.Response `json:"-"`
	// JobStepProperties - Resource properties.
	*JobStepProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStep.
func (js JobStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobStepProperties != nil {
		objectMap["properties"] = js.JobStepProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobStep struct.
func (js *JobStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobStepProperties JobStepProperties
				err = json.Unmarshal(*v, &jobStepProperties)
				if err != nil {
					return err
				}
				js.JobStepProperties = &jobStepProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		}
	}

	return nil
}

// JobStepAction the action to be executed by a job step.
type JobStepAction struct {
	// Type - Type of action being executed by the job step. Possible values include: 'TSQL'
	Type JobStepActionType `json:"type,omitempty"`
	// Source - The source of the action to execute. Possible values include: 'Inline'
	Source JobStepActionSource `json:"source,omitempty"`
	// Value - The action value, for example the text of the T-SQL script to execute.
	Value *string `json:"value,omitempty"`
}

// JobStepExecutionOptions the execution options of a job step.
type JobStepExecutionOptions struct {
	// TimeoutSeconds - Execution timeout for the job step.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// RetryAttempts - Maximum number of times the job step will be reattempted if the first attempt fails.
	RetryAttempts *int32 `json:"retryAttempts,omitempty"`
	// InitialRetryIntervalSeconds - Initial delay between retries for job step execution.
	InitialRetryIntervalSeconds *int32 `json:"initialRetryIntervalSeconds,omitempty"`
	// MaximumRetryIntervalSeconds - The maximum amount of time to wait between retries for job step execution.
	MaximumRetryIntervalSeconds *int32 `json:"maximumRetryIntervalSeconds,omitempty"`
	// RetryIntervalBackoffMultiplier - The backoff multiplier for the time between retries.
	RetryIntervalBackoffMultiplier *float64 `json:"retryIntervalBackoffMultiplier,omitempty"`
}

// JobStepListResult a list of job steps.
type JobStepListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobStep `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobStepListResultIterator provides access to a complete listing of JobStep values.
type JobStepListResultIterator struct {
	i    int
	page JobStepListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStepListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobStepListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStepListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStepListResultIterator) Response() JobStepListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStepListResultIterator) Value() JobStep {
	if !iter.page.NotDone() {
		return JobStep{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobStepListResultIterator type.
func NewJobStepListResultIterator(page JobStepListResultPage) JobStepListResultIterator {
	return JobStepListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStepListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jslr JobStepListResult) hasNextLink() bool {
	return jslr.NextLink != nil && len(*jslr.NextLink) != 0
}

// jobStepListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStepListResult) jobStepListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jslr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStepListResultPage contains a page of JobStep values.
type JobStepListResultPage struct {
	fn   func(context.Context, JobStepListResult) (JobStepListResult, error)
	jslr JobStepListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStepListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jslr)
		if err != nil {
			return err
		}
		page.jslr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobStepListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStepListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStepListResultPage) Response() JobStepListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStepListResultPage) Values() []JobStep {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobStepListResultPage type.
func NewJobStepListResultPage(cur JobStepListResult, getNextPage func(context.Context, JobStepListResult) (JobStepListResult, error)) JobStepListResultPage {
	return JobStepListResultPage{
		fn:   getNextPage,
		jslr: cur,
	}
}

// JobStepOutput the output configuration of a job step.
type JobStepOutput struct {
	// Type - The output destination type. Possible values include: 'SQLDatabase'
	Type JobStepOutputType `json:"type,omitempty"`
	// SubscriptionID - The output destination subscription id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The output destination resource group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ServerName - The output destination server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The output destination database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - The output destination schema.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The output destination table.
	TableName *string `json:"tableName,omitempty"`
	// Credential - The resource ID of the credential to use to connect to the output destination.
	Credential *string `json:"credential,omitempty"`
}

// JobStepProperties properties of a job step.
type JobStepProperties struct {
	// StepID - The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
	StepID *int32 `json:"stepId,omitempty"`
	// TargetGroup - The resource ID of the target group that the job step will be executed on.
	TargetGroup *string `json:"targetGroup,omitempty"`
	// Credential - The resource ID of the job credential that will be used to connect to the targets.
	Credential *string `json:"credential,omitempty"`
	// Action - The action payload of the job step.
	Action *JobStepAction `json:"action,omitempty"`
	// Output - Output destination properties of the job step.
	Output *JobStepOutput `json:"output,omitempty"`
	// ExecutionOptions - Execution options for the job step.
	ExecutionOptions *JobStepExecutionOptions `json:"executionOptions,omitempty"`
}

// JobTarget a job target, for example a specific database or a container of databases that is evaluated
// during job execution.
type JobTarget struct {
	// MembershipType - Whether the target is included or excluded from the group. Possible values include: 'Include', 'Exclude'
	MembershipType JobTargetGroupMembershipType `json:"membershipType,omitempty"`
	// Type - The target type. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - The target server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The target database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ElasticPoolName - The target elastic pool name.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ShardMapName - The target shard map.
	ShardMapName *string `json:"shardMapName,omitempty"`
	// RefreshCredential - The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
	RefreshCredential *string `json:"refreshCredential,omitempty"`
}

// JobTargetGroup a group of job targets.
type JobTargetGroup struct {
	autorest.Response `json:"-"`
	// JobTargetGroupProperties - Resource properties.
	*JobTargetGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTargetGroup.
func (jtg JobTargetGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jtg.JobTargetGroupProperties != nil {
		objectMap["properties"] = jtg.JobTargetGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobTargetGroup struct.
func (jtg *JobTargetGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobTargetGroupProperties JobTargetGroupProperties
				err = json.Unmarshal(*v, &jobTargetGroupProperties)
				if err != nil {
					return err
				}
				jtg.JobTargetGroupProperties = &jobTargetGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jtg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jtg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jtg.Type = &typeVar
			}
		}
	}

	return nil
}

// JobTargetGroupListResult a list of target groups.
type JobTargetGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobTargetGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobTargetGroupListResultIterator provides access to a complete listing of JobTargetGroup values.
type JobTargetGroupListResultIterator struct {
	i    int
	page JobTargetGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobTargetGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobTargetGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobTargetGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobTargetGroupListResultIterator) Response() JobTargetGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobTargetGroupListResultIterator) Value() JobTargetGroup {
	if !iter.page.NotDone() {
		return JobTargetGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobTargetGroupListResultIterator type.
func NewJobTargetGroupListResultIterator(page JobTargetGroupListResultPage) JobTargetGroupListResultIterator {
	return JobTargetGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jtglr JobTargetGroupListResult) IsEmpty() bool {
	return jtglr.Value == nil || len(*jtglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jtglr JobTargetGroupListResult) hasNextLink() bool {
	return jtglr.NextLink != nil && len(*jtglr.NextLink) != 0
}

// jobTargetGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jtglr JobTargetGroupListResult) jobTargetGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jtglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jtglr.NextLink)))
}

// JobTargetGroupListResultPage contains a page of JobTargetGroup values.
type JobTargetGroupListResultPage struct {
	fn    func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)
	jtglr JobTargetGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobTargetGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jtglr)
		if err != nil {
			return err
		}
		page.jtglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobTargetGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobTargetGroupListResultPage) NotDone() bool {
	return !page.jtglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobTargetGroupListResultPage) Response() JobTargetGroupListResult {
	return page.jtglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobTargetGroupListResultPage) Values() []JobTargetGroup {
	if page.jtglr.IsEmpty() {
		return nil
	}
	return *page.jtglr.Value
}

// Creates a new instance of the JobTargetGroupListResultPage type.
func NewJobTargetGroupListResultPage(cur JobTargetGroupListResult, getNextPage func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)) JobTargetGroupListResultPage {
	return JobTargetGroupListResultPage{
		fn:    getNextPage,
		jtglr: cur,
	}
}

// JobTargetGroupProperties properties of job target group.
type JobTargetGroupProperties struct {
	// Members - Members of the target group.
	Members *[]JobTarget `json:"members,omitempty"`
}

// JobVersion a job version.
type JobVersion struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// JobVersionListResult a list of job versions.
type JobVersionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]JobVersion `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobVersionListResultIterator provides access to a complete listing of JobVersion values.
type JobVersionListResultIterator struct {
	i    int
	page JobVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobVersionListResultIterator) Response() JobVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobVersionListResultIterator) Value() JobVersion {
	if !iter.page.NotDone() {
		return JobVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobVersionListResultIterator type.
func NewJobVersionListResultIterator(page JobVersionListResultPage) JobVersionListResultIterator {
	return JobVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jvlr JobVersionListResult) IsEmpty() bool {
	return jvlr.Value == nil || len(*jvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jvlr JobVersionListResult) hasNextLink() bool {
	return jvlr.NextLink != nil && len(*jvlr.NextLink) != 0
}

// jobVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jvlr JobVersionListResult) jobVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !jvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jvlr.NextLink)))
}

// JobVersionListResultPage contains a page of JobVersion values.
type JobVersionListResultPage struct {
	fn   func(context.Context, JobVersionListResult) (JobVersionListResult, error)
	jvlr JobVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jvlr)
		if err != nil {
			return err
		}
		page.jvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobVersionListResultPage) NotDone() bool {
	return !page.jvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobVersionListResultPage) Response() JobVersionListResult {
	return page.jvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobVersionListResultPage) Values() []JobVersion {
	if page.jvlr.IsEmpty() {
		return nil
	}
	return *page.jvlr.Value
}

// Creates a new instance of the JobVersionListResultPage type.
func NewJobVersionListResultPage(cur JobVersionListResult, getNextPage func(context.Context, JobVersionListResult) (JobVersionListResult, error)) JobVersionListResultPage {
	return JobVersionListResultPage{
		fn:   getNextPage,
		jvlr: cur,
	}
}

// LocationCapabilities the capabilities for a location.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - READ-ONLY; The location name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Azure SQL Database's status for the location. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServerVersions - READ-ONLY; The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// LogicalServerSecurityAlertPolicyListResult a list of the server's security alert policies.
type LogicalServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page LogicalServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Response() LogicalServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Value() ServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultIterator type.
func NewLogicalServerSecurityAlertPolicyListResultIterator(page LogicalServerSecurityAlertPolicyListResultPage) LogicalServerSecurityAlertPolicyListResultIterator {
	return LogicalServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return lssaplr.Value == nil || len(*lssaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) hasNextLink() bool {
	return lssaplr.NextLink != nil && len(*lssaplr.NextLink) != 0
}

// logicalServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) logicalServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lssaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lssaplr.NextLink)))
}

// LogicalServerSecurityAlertPolicyListResultPage contains a page of ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)
	lssaplr LogicalServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lssaplr)
		if err != nil {
			return err
		}
		page.lssaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.lssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalServerSecurityAlertPolicyListResultPage) Response() LogicalServerSecurityAlertPolicyListResult {
	return page.lssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalServerSecurityAlertPolicyListResultPage) Values() []ServerSecurityAlertPolicy {
	if page.lssaplr.IsEmpty() {
		return nil
	}
	return *page.lssaplr.Value
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultPage type.
func NewLogicalServerSecurityAlertPolicyListResultPage(cur LogicalServerSecurityAlertPolicyListResult, getNextPage func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)) LogicalServerSecurityAlertPolicyListResultPage {
	return LogicalServerSecurityAlertPolicyListResultPage{
		fn:      getNextPage,
		lssaplr: cur,
	}
}

// ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// ManagedBackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedBackupShortTermRetentionPoliciesClient) (ManagedBackupShortTermRetentionPolicy, error)
}

// ManagedBackupShortTermRetentionPolicy a short term retention policy.
type ManagedBackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// ManagedBackupShortTermRetentionPolicyProperties - Resource properties.
	*ManagedBackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedBackupShortTermRetentionPolicy.
func (mbstrp ManagedBackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbstrp.ManagedBackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = mbstrp.ManagedBackupShortTermRetentionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedBackupShortTermRetentionPolicy struct.
func (mbstrp *ManagedBackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedBackupShortTermRetentionPolicyProperties ManagedBackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &managedBackupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				mbstrp.ManagedBackupShortTermRetentionPolicyProperties = &managedBackupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedBackupShortTermRetentionPolicyListResult a list of short term retention policies.
type ManagedBackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedBackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedBackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedBackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Value() ManagedBackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedBackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultIterator type.
func NewManagedBackupShortTermRetentionPolicyListResultIterator(page ManagedBackupShortTermRetentionPolicyListResultPage) ManagedBackupShortTermRetentionPolicyListResultIterator {
	return ManagedBackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return mbstrplr.Value == nil || len(*mbstrplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) hasNextLink() bool {
	return mbstrplr.NextLink != nil && len(*mbstrplr.NextLink) != 0
}

// managedBackupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) managedBackupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mbstrplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mbstrplr.NextLink)))
}

// ManagedBackupShortTermRetentionPolicyListResultPage contains a page of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)
	mbstrplr ManagedBackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mbstrplr)
		if err != nil {
			return err
		}
		page.mbstrplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.mbstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return page.mbstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Values() []ManagedBackupShortTermRetentionPolicy {
	if page.mbstrplr.IsEmpty() {
		return nil
	}
	return *page.mbstrplr.Value
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultPage type.
func NewManagedBackupShortTermRetentionPolicyListResultPage(cur ManagedBackupShortTermRetentionPolicyListResult, getNextPage func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)) ManagedBackupShortTermRetentionPolicyListResultPage {
	return ManagedBackupShortTermRetentionPolicyListResultPage{
		fn:       getNextPage,
		mbstrplr: cur,
	}
}

// ManagedBackupShortTermRetentionPolicyProperties properties of a short term retention policy
type ManagedBackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// ManagedDatabase a managed database resource.
type ManagedDatabase struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabase.
func (md ManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.ManagedDatabaseProperties != nil {
		objectMap["properties"] = md.ManagedDatabaseProperties
	}
	if md.Location != nil {
		objectMap["location"] = md.Location
	}
	if md.Tags != nil {
		objectMap["tags"] = md.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabase struct.
func (md *ManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				md.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				md.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				md.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseListResult a list of managed databases.
type ManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedDatabaseListResultIterator provides access to a complete listing of ManagedDatabase values.
type ManagedDatabaseListResultIterator struct {
	i    int
	page ManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseListResultIterator) Response() ManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseListResultIterator) Value() ManagedDatabase {
	if !iter.page.NotDone() {
		return ManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseListResultIterator type.
func NewManagedDatabaseListResultIterator(page ManagedDatabaseListResultPage) ManagedDatabaseListResultIterator {
	return ManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdlr ManagedDatabaseListResult) IsEmpty() bool {
	return mdlr.Value == nil || len(*mdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mdlr ManagedDatabaseListResult) hasNextLink() bool {
	return mdlr.NextLink != nil && len(*mdlr.NextLink) != 0
}

// managedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdlr ManagedDatabaseListResult) managedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdlr.NextLink)))
}

// ManagedDatabaseListResultPage contains a page of ManagedDatabase values.
type ManagedDatabaseListResultPage struct {
	fn   func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)
	mdlr ManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mdlr)
		if err != nil {
			return err
		}
		page.mdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseListResultPage) NotDone() bool {
	return !page.mdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseListResultPage) Response() ManagedDatabaseListResult {
	return page.mdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseListResultPage) Values() []ManagedDatabase {
	if page.mdlr.IsEmpty() {
		return nil
	}
	return *page.mdlr.Value
}

// Creates a new instance of the ManagedDatabaseListResultPage type.
func NewManagedDatabaseListResultPage(cur ManagedDatabaseListResult, getNextPage func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)) ManagedDatabaseListResultPage {
	return ManagedDatabaseListResultPage{
		fn:   getNextPage,
		mdlr: cur,
	}
}

// ManagedDatabaseProperties the managed database's properties.
type ManagedDatabaseProperties struct {
	// Collation - Collation of the managed database.
	Collation *string `json:"collation,omitempty"`
	// Status - READ-ONLY; Status of the database. Possible values include: 'Online', 'Offline', 'Shutdown', 'Creating', 'Inaccessible', 'Restoring', 'Updating'
	Status ManagedDatabaseStatus `json:"status,omitempty"`
	// CreationDate - READ-ONLY; Creation date of the database.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// EarliestRestorePoint - READ-ONLY; Earliest restore point in time for point in time restore.
	EarliestRestorePoint *date.Time `json:"earliestRestorePoint,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// DefaultSecondaryLocation - READ-ONLY; Geo paired region.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'DATABASEDEFAULT', 'SQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// CreateMode - Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. Possible values include: 'ManagedDatabaseCreateModeDefault', 'ManagedDatabaseCreateModeRestoreExternalBackup', 'ManagedDatabaseCreateModePointInTimeRestore', 'ManagedDatabaseCreateModeRecovery', 'ManagedDatabaseCreateModeRestoreLongTermRetentionBackup'
	CreateMode ManagedDatabaseCreateMode `json:"createMode,omitempty"`
	// StorageContainerURI - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
	StorageContainerURI *string `json:"storageContainerUri,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The restorable dropped database resource id to restore when creating this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// StorageContainerSasToken - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
	StorageContainerSasToken *string `json:"storageContainerSasToken,omitempty"`
	// FailoverGroupID - READ-ONLY; Instance Failover Group resource identifier that this managed database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
	// LongTermRetentionBackupResourceID - The name of the Long Term Retention backup to be used for restore of this managed database.
	LongTermRetentionBackupResourceID *string `json:"longTermRetentionBackupResourceId,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseProperties.
func (mdp ManagedDatabaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdp.Collation != nil {
		objectMap["collation"] = mdp.Collation
	}
	if mdp.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mdp.RestorePointInTime
	}
	if mdp.CatalogCollation != "" {
		objectMap["catalogCollation"] = mdp.CatalogCollation
	}
	if mdp.CreateMode != "" {
		objectMap["createMode"] = mdp.CreateMode
	}
	if mdp.StorageContainerURI != nil {
		objectMap["storageContainerUri"] = mdp.StorageContainerURI
	}
	if mdp.SourceDatabaseID != nil {
		objectMap["sourceDatabaseId"] = mdp.SourceDatabaseID
	}
	if mdp.RestorableDroppedDatabaseID != nil {
		objectMap["restorableDroppedDatabaseId"] = mdp.RestorableDroppedDatabaseID
	}
	if mdp.StorageContainerSasToken != nil {
		objectMap["storageContainerSasToken"] = mdp.StorageContainerSasToken
	}
	if mdp.RecoverableDatabaseID != nil {
		objectMap["recoverableDatabaseId"] = mdp.RecoverableDatabaseID
	}
	if mdp.LongTermRetentionBackupResourceID != nil {
		objectMap["longTermRetentionBackupResourceId"] = mdp.LongTermRetentionBackupResourceID
	}
	return json.Marshal(objectMap)
}

// ManagedDatabasesCompleteRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCompleteRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// ManagedDatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (ManagedDatabase, error)
}

// ManagedDatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (autorest.Response, error)
}

// ManagedDatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedDatabasesClient) (ManagedDatabase, error)
}

// ManagedDatabaseUpdate an managed database update.
type ManagedDatabaseUpdate struct {
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseUpdate.
func (mdu ManagedDatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdu.ManagedDatabaseProperties != nil {
		objectMap["properties"] = mdu.ManagedDatabaseProperties
	}
	if mdu.Tags != nil {
		objectMap["tags"] = mdu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseUpdate struct.
func (mdu *ManagedDatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				mdu.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedInstance an Azure SQL managed instance.
type ManagedInstance struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the managed instance.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Sku - Managed instance SKU. Allowed values for sku.name: GP_Gen4, GP_Gen5, BC_Gen4, BC_Gen5
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstance.
func (mi ManagedInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Identity != nil {
		objectMap["identity"] = mi.Identity
	}
	if mi.Sku != nil {
		objectMap["sku"] = mi.Sku
	}
	if mi.ManagedInstanceProperties != nil {
		objectMap["properties"] = mi.ManagedInstanceProperties
	}
	if mi.Location != nil {
		objectMap["location"] = mi.Location
	}
	if mi.Tags != nil {
		objectMap["tags"] = mi.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstance struct.
func (mi *ManagedInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mi.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				mi.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mi.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mi.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministrator an Azure SQL managed instance administrator.
type ManagedInstanceAdministrator struct {
	autorest.Response `json:"-"`
	// ManagedInstanceAdministratorProperties - Resource properties.
	*ManagedInstanceAdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceAdministrator.
func (mia ManagedInstanceAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mia.ManagedInstanceAdministratorProperties != nil {
		objectMap["properties"] = mia.ManagedInstanceAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceAdministrator struct.
func (mia *ManagedInstanceAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedInstanceAdministratorProperties ManagedInstanceAdministratorProperties
				err = json.Unmarshal(*v, &managedInstanceAdministratorProperties)
				if err != nil {
					return err
				}
				mia.ManagedInstanceAdministratorProperties = &managedInstanceAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mia.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mia.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mia.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceAdministratorListResult a list of managed instance administrators.
type ManagedInstanceAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstanceAdministrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceAdministratorListResultIterator provides access to a complete listing of
// ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultIterator struct {
	i    int
	page ManagedInstanceAdministratorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceAdministratorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceAdministratorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceAdministratorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceAdministratorListResultIterator) Response() ManagedInstanceAdministratorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceAdministratorListResultIterator) Value() ManagedInstanceAdministrator {
	if !iter.page.NotDone() {
		return ManagedInstanceAdministrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceAdministratorListResultIterator type.
func NewManagedInstanceAdministratorListResultIterator(page ManagedInstanceAdministratorListResultPage) ManagedInstanceAdministratorListResultIterator {
	return ManagedInstanceAdministratorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mialr ManagedInstanceAdministratorListResult) IsEmpty() bool {
	return mialr.Value == nil || len(*mialr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mialr ManagedInstanceAdministratorListResult) hasNextLink() bool {
	return mialr.NextLink != nil && len(*mialr.NextLink) != 0
}

// managedInstanceAdministratorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mialr ManagedInstanceAdministratorListResult) managedInstanceAdministratorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mialr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mialr.NextLink)))
}

// ManagedInstanceAdministratorListResultPage contains a page of ManagedInstanceAdministrator values.
type ManagedInstanceAdministratorListResultPage struct {
	fn    func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)
	mialr ManagedInstanceAdministratorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceAdministratorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceAdministratorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mialr)
		if err != nil {
			return err
		}
		page.mialr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceAdministratorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceAdministratorListResultPage) NotDone() bool {
	return !page.mialr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceAdministratorListResultPage) Response() ManagedInstanceAdministratorListResult {
	return page.mialr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceAdministratorListResultPage) Values() []ManagedInstanceAdministrator {
	if page.mialr.IsEmpty() {
		return nil
	}
	return *page.mialr.Value
}

// Creates a new instance of the ManagedInstanceAdministratorListResultPage type.
func NewManagedInstanceAdministratorListResultPage(cur ManagedInstanceAdministratorListResult, getNextPage func(context.Context, ManagedInstanceAdministratorListResult) (ManagedInstanceAdministratorListResult, error)) ManagedInstanceAdministratorListResultPage {
	return ManagedInstanceAdministratorListResultPage{
		fn:    getNextPage,
		mialr: cur,
	}
}

// ManagedInstanceAdministratorProperties the properties of a managed instance administrator.
type ManagedInstanceAdministratorProperties struct {
	// AdministratorType - Type of the managed instance administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - Login name of the managed instance administrator.
	Login *string `json:"login,omitempty"`
	// Sid - SID (object ID) of the managed instance administrator.
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - Tenant ID of the managed instance administrator.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ManagedInstanceAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedInstanceAdministratorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAdministratorsClient) (ManagedInstanceAdministrator, error)
}

// ManagedInstanceAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstanceAdministratorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstanceAdministratorsClient) (autorest.Response, error)
}

// ManagedInstanceListResult a list of managed instances.
type ManagedInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ManagedInstance `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceListResultIterator provides access to a complete listing of ManagedInstance values.
type ManagedInstanceListResultIterator struct {
	i    int
	page ManagedInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceListResultIterator) Response() ManagedInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceListResultIterator) Value() ManagedInstance {
	if !iter.page.NotDone() {
		return ManagedInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceListResultIterator type.
func NewManagedInstanceListResultIterator(page ManagedInstanceListResultPage) ManagedInstanceListResultIterator {
	return ManagedInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (milr ManagedInstanceListResult) IsEmpty() bool {
	return milr.Value == nil || len(*milr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (milr ManagedInstanceListResult) hasNextLink() bool {
	return milr.NextLink != nil && len(*milr.NextLink) != 0
}

// managedInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (milr ManagedInstanceListResult) managedInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !milr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(milr.NextLink)))
}

// ManagedInstanceListResultPage contains a page of ManagedInstance values.
type ManagedInstanceListResultPage struct {
	fn   func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)
	milr ManagedInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.milr)
		if err != nil {
			return err
		}
		page.milr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceListResultPage) NotDone() bool {
	return !page.milr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceListResultPage) Response() ManagedInstanceListResult {
	return page.milr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceListResultPage) Values() []ManagedInstance {
	if page.milr.IsEmpty() {
		return nil
	}
	return *page.milr.Value
}

// Creates a new instance of the ManagedInstanceListResultPage type.
func NewManagedInstanceListResultPage(cur ManagedInstanceListResult, getNextPage func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)) ManagedInstanceListResultPage {
	return ManagedInstanceListResultPage{
		fn:   getNextPage,
		milr: cur,
	}
}

// ManagedInstanceProperties the properties of a managed instance.
type ManagedInstanceProperties struct {
	// ManagedInstanceCreateMode - Specifies the mode of database creation.
	//
	// Default: Regular instance creation.
	//
	// Restore: Creates an instance by restoring a set of backups to specific point in time. RestorePointInTime and SourceManagedInstanceId must be specified. Possible values include: 'ManagedServerCreateModeDefault', 'ManagedServerCreateModePointInTimeRestore'
	ManagedInstanceCreateMode ManagedServerCreateMode `json:"managedInstanceCreateMode,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the managed instance.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// AdministratorLogin - Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for managed instance creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// SubnetID - Subnet resource ID for the managed instance.
	SubnetID *string `json:"subnetId,omitempty"`
	// State - READ-ONLY; The state of the managed instance.
	State *string `json:"state,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' (regular price inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL licenses). Possible values include: 'LicenseIncluded', 'BasePrice'
	LicenseType ManagedInstanceLicenseType `json:"licenseType,omitempty"`
	// VCores - The number of vCores. Allowed values: 8, 16, 24, 32, 40, 64, 80.
	VCores *int32 `json:"vCores,omitempty"`
	// StorageSizeInGB - Storage size in GB. Minimum value: 32. Maximum value: 8192. Increments of 32 GB allowed only.
	StorageSizeInGB *int32 `json:"storageSizeInGB,omitempty"`
	// Collation - Collation of the managed instance.
	Collation *string `json:"collation,omitempty"`
	// DNSZone - READ-ONLY; The Dns Zone that the managed instance is in.
	DNSZone *string `json:"dnsZone,omitempty"`
	// DNSZonePartner - The resource id of another managed instance whose DNS zone this managed instance will share after creation.
	DNSZonePartner *string `json:"dnsZonePartner,omitempty"`
	// PublicDataEndpointEnabled - Whether or not the public data endpoint is enabled.
	PublicDataEndpointEnabled *bool `json:"publicDataEndpointEnabled,omitempty"`
	// SourceManagedInstanceID - The resource identifier of the source managed instance associated with create operation of this instance.
	SourceManagedInstanceID *string `json:"sourceManagedInstanceId,omitempty"`
	// RestorePointInTime - Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// ProxyOverride - Connection type used for connecting to the instance. Possible values include: 'ManagedInstanceProxyOverrideProxy', 'ManagedInstanceProxyOverrideRedirect', 'ManagedInstanceProxyOverrideDefault'
	ProxyOverride ManagedInstanceProxyOverride `json:"proxyOverride,omitempty"`
	// TimezoneID - Id of the timezone. Allowed values are timezones supported by Windows.
	// Windows keeps details on supported timezones, including the id, in registry under
	// KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
	// You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
	// List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
	// An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
	TimezoneID *string `json:"timezoneId,omitempty"`
	// InstancePoolID - The Id of the instance pool this managed server belongs to.
	InstancePoolID *string `json:"instancePoolId,omitempty"`
	// MaintenanceConfigurationID - Specifies maintenance configuration id to apply to this managed instance.
	MaintenanceConfigurationID *string `json:"maintenanceConfigurationId,omitempty"`
	// MinimalTLSVersion - Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'
	MinimalTLSVersion *string `json:"minimalTlsVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceProperties.
func (mip ManagedInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mip.ManagedInstanceCreateMode != "" {
		objectMap["managedInstanceCreateMode"] = mip.ManagedInstanceCreateMode
	}
	if mip.AdministratorLogin != nil {
		objectMap["administratorLogin"] = mip.AdministratorLogin
	}
	if mip.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = mip.AdministratorLoginPassword
	}
	if mip.SubnetID != nil {
		objectMap["subnetId"] = mip.SubnetID
	}
	if mip.LicenseType != "" {
		objectMap["licenseType"] = mip.LicenseType
	}
	if mip.VCores != nil {
		objectMap["vCores"] = mip.VCores
	}
	if mip.StorageSizeInGB != nil {
		objectMap["storageSizeInGB"] = mip.StorageSizeInGB
	}
	if mip.Collation != nil {
		objectMap["collation"] = mip.Collation
	}
	if mip.DNSZonePartner != nil {
		objectMap["dnsZonePartner"] = mip.DNSZonePartner
	}
	if mip.PublicDataEndpointEnabled != nil {
		objectMap["publicDataEndpointEnabled"] = mip.PublicDataEndpointEnabled
	}
	if mip.SourceManagedInstanceID != nil {
		objectMap["sourceManagedInstanceId"] = mip.SourceManagedInstanceID
	}
	if mip.RestorePointInTime != nil {
		objectMap["restorePointInTime"] = mip.RestorePointInTime
	}
	if mip.ProxyOverride != "" {
		objectMap["proxyOverride"] = mip.ProxyOverride
	}
	if mip.TimezoneID != nil {
		objectMap["timezoneId"] = mip.TimezoneID
	}
	if mip.InstancePoolID != nil {
		objectMap["instancePoolId"] = mip.InstancePoolID
	}
	if mip.MaintenanceConfigurationID != nil {
		objectMap["maintenanceConfigurationId"] = mip.MaintenanceConfigurationID
	}
	if mip.MinimalTLSVersion != nil {
		objectMap["minimalTlsVersion"] = mip.MinimalTLSVersion
	}
	return json.Marshal(objectMap)
}

// ManagedInstancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstancesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (ManagedInstance, error)
}

// ManagedInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (autorest.Response, error)
}

// ManagedInstancesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedInstancesClient) (ManagedInstance, error)
}

// ManagedInstanceUpdate an update request for an Azure SQL Database managed instance.
type ManagedInstanceUpdate struct {
	// Sku - Managed instance sku
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceUpdate.
func (miu ManagedInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miu.Sku != nil {
		objectMap["sku"] = miu.Sku
	}
	if miu.ManagedInstanceProperties != nil {
		objectMap["properties"] = miu.ManagedInstanceProperties
	}
	if miu.Tags != nil {
		objectMap["tags"] = miu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceUpdate struct.
func (miu *ManagedInstanceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				miu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				miu.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				miu.Tags = tags
			}
		}
	}

	return nil
}

// MaxSizeCapability the maximum size limits for a database.
type MaxSizeCapability struct {
	// Limit - READ-ONLY; The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units that the limit is expressed in. Possible values include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
	Unit MaxSizeUnits `json:"unit,omitempty"`
	// Status - READ-ONLY; The status of the maximum size capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// Metric database metrics.
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability a metric availability value.
type MetricAvailability struct {
	// Retention - READ-ONLY; The length of retention for the database metric.
	Retention *string `json:"retention,omitempty"`
	// TimeGrain - READ-ONLY; The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricDefinition a database metric definition.
type MetricDefinition struct {
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type defining how metric values are displayed. Possible values include: 'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Unit - READ-ONLY; The unit of the metric. Possible values include: 'UnitDefinitionTypeCount', 'UnitDefinitionTypeBytes', 'UnitDefinitionTypeSeconds', 'UnitDefinitionTypePercent', 'UnitDefinitionTypeCountPerSecond', 'UnitDefinitionTypeBytesPerSecond'
	Unit UnitDefinitionType `json:"unit,omitempty"`
	// MetricAvailabilities - READ-ONLY; The list of database metric availabilities for the metric.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
}

// MetricDefinitionListResult the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the database.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the database.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a database metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the database metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents database metrics.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation. Possible values include: 'OperationOriginUser', 'OperationOriginSystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationImpact the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// Name - READ-ONLY; The name of the impact dimension.
	Name *string `json:"name,omitempty"`
	// Unit - READ-ONLY; The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty"`
	// ChangeValueAbsolute - READ-ONLY; The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - READ-ONLY; The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// OperationListResult result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PartnerInfo partner server information for the failover group.
type PartnerInfo struct {
	// ID - Resource identifier of the partner server.
	ID *string `json:"id,omitempty"`
	// Location - READ-ONLY; Geo location of the partner server.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - READ-ONLY; Replication role of the partner server. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// MarshalJSON is the custom marshaler for PartnerInfo.
func (pi PartnerInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ID != nil {
		objectMap["id"] = pi.ID
	}
	return json.Marshal(objectMap)
}

// PerformanceLevel a possible performance level of a service objective capability.
type PerformanceLevel struct {
	// Unit - READ-ONLY; Unit type used to measure service objective performance level. Possible values include: 'DTU'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Value - READ-ONLY; Performance level value.
	Value *int32 `json:"value,omitempty"`
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// RecommendedIndex represents a database recommended index.
type RecommendedIndex struct {
	// RecommendedIndexProperties - READ-ONLY; The properties representing the resource.
	*RecommendedIndexProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedIndex.
func (ri RecommendedIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedIndex struct.
func (ri *RecommendedIndex) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedIndexProperties RecommendedIndexProperties
				err = json.Unmarshal(*v, &recommendedIndexProperties)
				if err != nil {
					return err
				}
				ri.RecommendedIndexProperties = &recommendedIndexProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ri.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedIndexProperties represents the properties of a database recommended index.
type RecommendedIndexProperties struct {
	// Action - READ-ONLY; The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance. Possible values include: 'Create', 'Drop', 'Rebuild'
	Action RecommendedIndexAction `json:"action,omitempty"`
	// State - READ-ONLY; The current recommendation state. Possible values include: 'Active', 'Pending', 'Executing', 'Verifying', 'PendingRevert', 'Reverting', 'Reverted', 'Ignored', 'Expired', 'Blocked', 'Success'
	State RecommendedIndexState `json:"state,omitempty"`
	// Created - READ-ONLY; The UTC datetime showing when this resource was created (ISO8601 format).
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The UTC datetime of when was this resource last changed (ISO8601 format).
	LastModified *date.Time `json:"lastModified,omitempty"`
	// IndexType - READ-ONLY; The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED', 'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTEREDCOLUMNSTORE'
	IndexType RecommendedIndexType `json:"indexType,omitempty"`
	// Schema - READ-ONLY; The schema where table to build index over resides
	Schema *string `json:"schema,omitempty"`
	// Table - READ-ONLY; The table on which to build index.
	Table *string `json:"table,omitempty"`
	// Columns - READ-ONLY; Columns over which to build index
	Columns *[]string `json:"columns,omitempty"`
	// IncludedColumns - READ-ONLY; The list of column names to be included in the index
	IncludedColumns *[]string `json:"includedColumns,omitempty"`
	// IndexScript - READ-ONLY; The full build index script
	IndexScript *string `json:"indexScript,omitempty"`
	// EstimatedImpact - READ-ONLY; The estimated impact of doing recommended index action.
	EstimatedImpact *[]OperationImpact `json:"estimatedImpact,omitempty"`
	// ReportedImpact - READ-ONLY; The values reported after index action is complete.
	ReportedImpact *[]OperationImpact `json:"reportedImpact,omitempty"`
}

// RecoverableDatabase a recoverable database
type RecoverableDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableDatabaseProperties - The properties of a recoverable database
	*RecoverableDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableDatabase.
func (rd RecoverableDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RecoverableDatabaseProperties != nil {
		objectMap["properties"] = rd.RecoverableDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableDatabase struct.
func (rd *RecoverableDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableDatabaseProperties RecoverableDatabaseProperties
				err = json.Unmarshal(*v, &recoverableDatabaseProperties)
				if err != nil {
					return err
				}
				rd.RecoverableDatabaseProperties = &recoverableDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableDatabaseListResult the response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of recoverable databases
	Value *[]RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties the properties of a recoverable database
type RecoverableDatabaseProperties struct {
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// LastAvailableBackupDate - READ-ONLY; The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// ReplicationLink represents a database replication link.
type ReplicationLink struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List database replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database replication links housed in the database.
	Value *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties represents the properties of a database replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - READ-ONLY; Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - READ-ONLY; Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - READ-ONLY; The name of the server hosting the partner database.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - READ-ONLY; The name of the partner database.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - READ-ONLY; The Azure Region of the partner database.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - READ-ONLY; The role of the database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - READ-ONLY; The role of the partner database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - READ-ONLY; The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - READ-ONLY; The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - READ-ONLY; The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// ReplicationLinksFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationLinksFailoverAllowDataLossFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// ReplicationLinksFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationLinksFailoverFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// ReplicationLinksUnlinkFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationLinksUnlinkFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationLinksClient) (autorest.Response, error)
}

// Resource ARM resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// PrincipalID - READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Type - The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource. Possible values include: 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; The Azure Active Directory tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != "" {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// ResourceMoveDefinition contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// ID - The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// RestorableDroppedDatabase a restorable dropped database
type RestorableDroppedDatabase struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// RestorableDroppedDatabaseProperties - The properties of a restorable dropped database
	*RestorableDroppedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedDatabase.
func (rdd RestorableDroppedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdd.RestorableDroppedDatabaseProperties != nil {
		objectMap["properties"] = rdd.RestorableDroppedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedDatabase struct.
func (rdd *RestorableDroppedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdd.Location = &location
			}
		case "properties":
			if v != nil {
				var restorableDroppedDatabaseProperties RestorableDroppedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedDatabaseProperties)
				if err != nil {
					return err
				}
				rdd.RestorableDroppedDatabaseProperties = &restorableDroppedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedDatabaseListResult the response to a list restorable dropped databases request
type RestorableDroppedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of restorable dropped databases
	Value *[]RestorableDroppedDatabase `json:"value,omitempty"`
}

// RestorableDroppedDatabaseProperties the properties of a restorable dropped database
type RestorableDroppedDatabaseProperties struct {
	// DatabaseName - READ-ONLY; The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - READ-ONLY; The edition of the database
	Edition *string `json:"edition,omitempty"`
	// MaxSizeBytes - READ-ONLY; The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// ServiceLevelObjective - READ-ONLY; The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - READ-ONLY; The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format)
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format)
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorableDroppedManagedDatabase a restorable dropped managed database resource.
type RestorableDroppedManagedDatabase struct {
	autorest.Response `json:"-"`
	// RestorableDroppedManagedDatabaseProperties - Resource properties.
	*RestorableDroppedManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedManagedDatabase.
func (rdmd RestorableDroppedManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdmd.RestorableDroppedManagedDatabaseProperties != nil {
		objectMap["properties"] = rdmd.RestorableDroppedManagedDatabaseProperties
	}
	if rdmd.Location != nil {
		objectMap["location"] = rdmd.Location
	}
	if rdmd.Tags != nil {
		objectMap["tags"] = rdmd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedManagedDatabase struct.
func (rdmd *RestorableDroppedManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableDroppedManagedDatabaseProperties RestorableDroppedManagedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedManagedDatabaseProperties)
				if err != nil {
					return err
				}
				rdmd.RestorableDroppedManagedDatabaseProperties = &restorableDroppedManagedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdmd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdmd.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdmd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdmd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedManagedDatabaseListResult a list of restorable dropped managed databases.
type RestorableDroppedManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorableDroppedManagedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorableDroppedManagedDatabaseListResultIterator provides access to a complete listing of
// RestorableDroppedManagedDatabase values.
type RestorableDroppedManagedDatabaseListResultIterator struct {
	i    int
	page RestorableDroppedManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorableDroppedManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Response() RestorableDroppedManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Value() RestorableDroppedManagedDatabase {
	if !iter.page.NotDone() {
		return RestorableDroppedManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultIterator type.
func NewRestorableDroppedManagedDatabaseListResultIterator(page RestorableDroppedManagedDatabaseListResultPage) RestorableDroppedManagedDatabaseListResultIterator {
	return RestorableDroppedManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) IsEmpty() bool {
	return rdmdlr.Value == nil || len(*rdmdlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) hasNextLink() bool {
	return rdmdlr.NextLink != nil && len(*rdmdlr.NextLink) != 0
}

// restorableDroppedManagedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) restorableDroppedManagedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rdmdlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdmdlr.NextLink)))
}

// RestorableDroppedManagedDatabaseListResultPage contains a page of RestorableDroppedManagedDatabase
// values.
type RestorableDroppedManagedDatabaseListResultPage struct {
	fn     func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)
	rdmdlr RestorableDroppedManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorableDroppedManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rdmdlr)
		if err != nil {
			return err
		}
		page.rdmdlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorableDroppedManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorableDroppedManagedDatabaseListResultPage) NotDone() bool {
	return !page.rdmdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorableDroppedManagedDatabaseListResultPage) Response() RestorableDroppedManagedDatabaseListResult {
	return page.rdmdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorableDroppedManagedDatabaseListResultPage) Values() []RestorableDroppedManagedDatabase {
	if page.rdmdlr.IsEmpty() {
		return nil
	}
	return *page.rdmdlr.Value
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultPage type.
func NewRestorableDroppedManagedDatabaseListResultPage(cur RestorableDroppedManagedDatabaseListResult, getNextPage func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)) RestorableDroppedManagedDatabaseListResultPage {
	return RestorableDroppedManagedDatabaseListResultPage{
		fn:     getNextPage,
		rdmdlr: cur,
	}
}

// RestorableDroppedManagedDatabaseProperties the restorable dropped managed database's properties.
type RestorableDroppedManagedDatabaseProperties struct {
	// DatabaseName - READ-ONLY; The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - READ-ONLY; The deletion date of the database (ISO8601 format).
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest restore date of the database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorePoint database restore points.
type RestorePoint struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// RestorePointProperties - Resource properties.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult a list of long term retention backups.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]RestorePoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointProperties properties of a database restore point
type RestorePointProperties struct {
	// RestorePointType - READ-ONLY; The type of restore point. Possible values include: 'CONTINUOUS', 'DISCRETE'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// EarliestRestoreDate - READ-ONLY; The earliest time to which this database can be restored
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// RestorePointCreationDate - READ-ONLY; The time the backup was taken
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// RestorePointLabel - READ-ONLY; The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// RestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RestorePointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RestorePointsClient) (RestorePoint, error)
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - READ-ONLY; Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// MarshalJSON is the custom marshaler for SecurityAlertPolicyProperties.
func (sapp SecurityAlertPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sapp.State != "" {
		objectMap["state"] = sapp.State
	}
	if sapp.DisabledAlerts != nil {
		objectMap["disabledAlerts"] = sapp.DisabledAlerts
	}
	if sapp.EmailAddresses != nil {
		objectMap["emailAddresses"] = sapp.EmailAddresses
	}
	if sapp.EmailAccountAdmins != nil {
		objectMap["emailAccountAdmins"] = sapp.EmailAccountAdmins
	}
	if sapp.StorageEndpoint != nil {
		objectMap["storageEndpoint"] = sapp.StorageEndpoint
	}
	if sapp.StorageAccountAccessKey != nil {
		objectMap["storageAccountAccessKey"] = sapp.StorageAccountAccessKey
	}
	if sapp.RetentionDays != nil {
		objectMap["retentionDays"] = sapp.RetentionDays
	}
	return json.Marshal(objectMap)
}

// SensitivityLabel a sensitivity label.
type SensitivityLabel struct {
	autorest.Response `json:"-"`
	// SensitivityLabelProperties - Resource properties.
	*SensitivityLabelProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabel.
func (sl SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.SensitivityLabelProperties != nil {
		objectMap["properties"] = sl.SensitivityLabelProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SensitivityLabel struct.
func (sl *SensitivityLabel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sensitivityLabelProperties SensitivityLabelProperties
				err = json.Unmarshal(*v, &sensitivityLabelProperties)
				if err != nil {
					return err
				}
				sl.SensitivityLabelProperties = &sensitivityLabelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// SensitivityLabelListResult a list of sensitivity labels.
type SensitivityLabelListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SensitivityLabel `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SensitivityLabelListResultIterator provides access to a complete listing of SensitivityLabel values.
type SensitivityLabelListResultIterator struct {
	i    int
	page SensitivityLabelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SensitivityLabelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SensitivityLabelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SensitivityLabelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SensitivityLabelListResultIterator) Response() SensitivityLabelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SensitivityLabelListResultIterator) Value() SensitivityLabel {
	if !iter.page.NotDone() {
		return SensitivityLabel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SensitivityLabelListResultIterator type.
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return SensitivityLabelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr SensitivityLabelListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sllr SensitivityLabelListResult) hasNextLink() bool {
	return sllr.NextLink != nil && len(*sllr.NextLink) != 0
}

// sensitivityLabelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr SensitivityLabelListResult) sensitivityLabelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// SensitivityLabelListResultPage contains a page of SensitivityLabel values.
type SensitivityLabelListResultPage struct {
	fn   func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)
	sllr SensitivityLabelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SensitivityLabelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sllr)
		if err != nil {
			return err
		}
		page.sllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SensitivityLabelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SensitivityLabelListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SensitivityLabelListResultPage) Response() SensitivityLabelListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SensitivityLabelListResultPage) Values() []SensitivityLabel {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the SensitivityLabelListResultPage type.
func NewSensitivityLabelListResultPage(cur SensitivityLabelListResult, getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return SensitivityLabelListResultPage{
		fn:   getNextPage,
		sllr: cur,
	}
}

// SensitivityLabelProperties properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// LabelName - The label name.
	LabelName *string `json:"labelName,omitempty"`
	// LabelID - The label ID.
	LabelID *string `json:"labelId,omitempty"`
	// InformationType - The information type.
	InformationType *string `json:"informationType,omitempty"`
	// InformationTypeID - The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`
	// IsDisabled - READ-ONLY; Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
	IsDisabled *bool `json:"isDisabled,omitempty"`
	// Rank - Possible values include: 'SensitivityLabelRankNone', 'SensitivityLabelRankLow', 'SensitivityLabelRankMedium', 'SensitivityLabelRankHigh', 'SensitivityLabelRankCritical'
	Rank SensitivityLabelRank `json:"rank,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabelProperties.
func (slp SensitivityLabelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slp.LabelName != nil {
		objectMap["labelName"] = slp.LabelName
	}
	if slp.LabelID != nil {
		objectMap["labelId"] = slp.LabelID
	}
	if slp.InformationType != nil {
		objectMap["informationType"] = slp.InformationType
	}
	if slp.InformationTypeID != nil {
		objectMap["informationTypeId"] = slp.InformationTypeID
	}
	if slp.Rank != "" {
		objectMap["rank"] = slp.Rank
	}
	return json.Marshal(objectMap)
}

// Server an Azure SQL Database server.
type Server struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Kind - READ-ONLY; Kind of sql server. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAdministratorListResult the response to a list Active Directory Administrators request.
type ServerAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server Active Directory Administrators for the server.
	Value *[]ServerAzureADAdministrator `json:"value,omitempty"`
}

// ServerAdministratorProperties the properties of an server Administrator.
type ServerAdministratorProperties struct {
	// AdministratorType - The type of administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - The server administrator login value.
	Login *string `json:"login,omitempty"`
	// Sid - The server administrator Sid (Secure ID).
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - The server Active Directory Administrator tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ServerAutomaticTuning server-level Automatic Tuning.
type ServerAutomaticTuning struct {
	autorest.Response `json:"-"`
	// AutomaticTuningServerProperties - Resource properties.
	*AutomaticTuningServerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAutomaticTuning.
func (sat ServerAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sat.AutomaticTuningServerProperties != nil {
		objectMap["properties"] = sat.AutomaticTuningServerProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAutomaticTuning struct.
func (sat *ServerAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automaticTuningServerProperties AutomaticTuningServerProperties
				err = json.Unmarshal(*v, &automaticTuningServerProperties)
				if err != nil {
					return err
				}
				sat.AutomaticTuningServerProperties = &automaticTuningServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sat.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministrator an server Active Directory Administrator.
type ServerAzureADAdministrator struct {
	autorest.Response `json:"-"`
	// ServerAdministratorProperties - The properties of the resource.
	*ServerAdministratorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAzureADAdministrator.
func (saaa ServerAzureADAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saaa.ServerAdministratorProperties != nil {
		objectMap["properties"] = saaa.ServerAdministratorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAzureADAdministrator struct.
func (saaa *ServerAzureADAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverAdministratorProperties ServerAdministratorProperties
				err = json.Unmarshal(*v, &serverAdministratorProperties)
				if err != nil {
					return err
				}
				saaa.ServerAdministratorProperties = &serverAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saaa.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerAzureADAdministratorsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerAzureADAdministratorsClient) (ServerAzureADAdministrator, error)
}

// ServerAzureADAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerAzureADAdministratorsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerAzureADAdministratorsClient) (ServerAzureADAdministrator, error)
}

// ServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerBlobAuditingPoliciesClient) (ServerBlobAuditingPolicy, error)
}

// ServerBlobAuditingPolicy a server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ServerBlobAuditingPolicyProperties - Resource properties.
	*ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerBlobAuditingPolicy.
func (sbap ServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbap.ServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = sbap.ServerBlobAuditingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerBlobAuditingPolicy struct.
func (sbap *ServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverBlobAuditingPolicyProperties ServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &serverBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				sbap.ServerBlobAuditingPolicyProperties = &serverBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerBlobAuditingPolicyListResult a list of server auditing settings.
type ServerBlobAuditingPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerBlobAuditingPolicy `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerBlobAuditingPolicyListResultIterator provides access to a complete listing of
// ServerBlobAuditingPolicy values.
type ServerBlobAuditingPolicyListResultIterator struct {
	i    int
	page ServerBlobAuditingPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerBlobAuditingPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerBlobAuditingPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerBlobAuditingPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerBlobAuditingPolicyListResultIterator) Response() ServerBlobAuditingPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerBlobAuditingPolicyListResultIterator) Value() ServerBlobAuditingPolicy {
	if !iter.page.NotDone() {
		return ServerBlobAuditingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultIterator type.
func NewServerBlobAuditingPolicyListResultIterator(page ServerBlobAuditingPolicyListResultPage) ServerBlobAuditingPolicyListResultIterator {
	return ServerBlobAuditingPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sbaplr ServerBlobAuditingPolicyListResult) IsEmpty() bool {
	return sbaplr.Value == nil || len(*sbaplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sbaplr ServerBlobAuditingPolicyListResult) hasNextLink() bool {
	return sbaplr.NextLink != nil && len(*sbaplr.NextLink) != 0
}

// serverBlobAuditingPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sbaplr ServerBlobAuditingPolicyListResult) serverBlobAuditingPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sbaplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sbaplr.NextLink)))
}

// ServerBlobAuditingPolicyListResultPage contains a page of ServerBlobAuditingPolicy values.
type ServerBlobAuditingPolicyListResultPage struct {
	fn     func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)
	sbaplr ServerBlobAuditingPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerBlobAuditingPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerBlobAuditingPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sbaplr)
		if err != nil {
			return err
		}
		page.sbaplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerBlobAuditingPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerBlobAuditingPolicyListResultPage) NotDone() bool {
	return !page.sbaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerBlobAuditingPolicyListResultPage) Response() ServerBlobAuditingPolicyListResult {
	return page.sbaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerBlobAuditingPolicyListResultPage) Values() []ServerBlobAuditingPolicy {
	if page.sbaplr.IsEmpty() {
		return nil
	}
	return *page.sbaplr.Value
}

// Creates a new instance of the ServerBlobAuditingPolicyListResultPage type.
func NewServerBlobAuditingPolicyListResultPage(cur ServerBlobAuditingPolicyListResult, getNextPage func(context.Context, ServerBlobAuditingPolicyListResult) (ServerBlobAuditingPolicyListResult, error)) ServerBlobAuditingPolicyListResultPage {
	return ServerBlobAuditingPolicyListResultPage{
		fn:     getNextPage,
		sbaplr: cur,
	}
}

// ServerBlobAuditingPolicyProperties properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account.
	// If state is Enabled and storageEndpoint is specified, not specifying the storageAccountAccessKey will use SQL server system-assigned managed identity to access the storage.
	// Prerequisites for using managed identity authentication:
	// 1. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
	// 2. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data Contributor' RBAC role to the server identity.
	// For more information, see [Auditing to storage using Managed Identity authentication](https://go.microsoft.com/fwlink/?linkid=2114355)
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'state' as 'Enabled' and 'isAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
	// QueueDelayMs - Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
	// The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
	QueueDelayMs *int32 `json:"queueDelayMs,omitempty"`
}

// ServerCommunicationLink server communication link.
type ServerCommunicationLink struct {
	autorest.Response `json:"-"`
	// ServerCommunicationLinkProperties - The properties of resource.
	*ServerCommunicationLinkProperties `json:"properties,omitempty"`
	// Location - READ-ONLY; Communication link location.
	Location *string `json:"location,omitempty"`
	// Kind - READ-ONLY; Communication link kind.  This property is used for Azure Portal metadata.
	Kind *string `json:"kind,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLink.
func (scl ServerCommunicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scl.ServerCommunicationLinkProperties != nil {
		objectMap["properties"] = scl.ServerCommunicationLinkProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerCommunicationLink struct.
func (scl *ServerCommunicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverCommunicationLinkProperties ServerCommunicationLinkProperties
				err = json.Unmarshal(*v, &serverCommunicationLinkProperties)
				if err != nil {
					return err
				}
				scl.ServerCommunicationLinkProperties = &serverCommunicationLinkProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scl.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scl.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerCommunicationLinkListResult a list of server communication links.
type ServerCommunicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server communication links.
	Value *[]ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties the properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	// State - READ-ONLY; The state.
	State *string `json:"state,omitempty"`
	// PartnerServer - The name of the partner server.
	PartnerServer *string `json:"partnerServer,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLinkProperties.
func (sclp ServerCommunicationLinkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sclp.PartnerServer != nil {
		objectMap["partnerServer"] = sclp.PartnerServer
	}
	return json.Marshal(objectMap)
}

// ServerCommunicationLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServerCommunicationLinksCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerCommunicationLinksClient) (ServerCommunicationLink, error)
}

// ServerConnectionPolicy a server secure connection policy.
type ServerConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - READ-ONLY; Metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerConnectionPolicyProperties - The properties of the server secure connection policy.
	*ServerConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerConnectionPolicy.
func (scp ServerConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.ServerConnectionPolicyProperties != nil {
		objectMap["properties"] = scp.ServerConnectionPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerConnectionPolicy struct.
func (scp *ServerConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scp.Location = &location
			}
		case "properties":
			if v != nil {
				var serverConnectionPolicyProperties ServerConnectionPolicyProperties
				err = json.Unmarshal(*v, &serverConnectionPolicyProperties)
				if err != nil {
					return err
				}
				scp.ServerConnectionPolicyProperties = &serverConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerConnectionPolicyProperties the properties of a server secure connection policy.
type ServerConnectionPolicyProperties struct {
	// ConnectionType - The server connection type. Possible values include: 'ServerConnectionTypeDefault', 'ServerConnectionTypeProxy', 'ServerConnectionTypeRedirect'
	ConnectionType ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerDNSAlias a server DNS alias.
type ServerDNSAlias struct {
	autorest.Response `json:"-"`
	// ServerDNSAliasProperties - Resource properties.
	*ServerDNSAliasProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerDNSAlias.
func (sda ServerDNSAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sda.ServerDNSAliasProperties != nil {
		objectMap["properties"] = sda.ServerDNSAliasProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerDNSAlias struct.
func (sda *ServerDNSAlias) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverDNSAliasProperties ServerDNSAliasProperties
				err = json.Unmarshal(*v, &serverDNSAliasProperties)
				if err != nil {
					return err
				}
				sda.ServerDNSAliasProperties = &serverDNSAliasProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sda.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerDNSAliasAcquisition a server DNS alias acquisition request.
type ServerDNSAliasAcquisition struct {
	// OldServerDNSAliasID - The id of the server alias that will be acquired to point to this server instead.
	OldServerDNSAliasID *string `json:"oldServerDnsAliasId,omitempty"`
}

// ServerDNSAliasesAcquireFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesAcquireFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerDNSAliasesClient) (autorest.Response, error)
}

// ServerDNSAliasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerDNSAliasesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerDNSAliasesClient) (ServerDNSAlias, error)
}

// ServerDNSAliasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerDNSAliasesClient) (autorest.Response, error)
}

// ServerDNSAliasListResult a list of server DNS aliases.
type ServerDNSAliasListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerDNSAlias `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerDNSAliasListResultIterator provides access to a complete listing of ServerDNSAlias values.
type ServerDNSAliasListResultIterator struct {
	i    int
	page ServerDNSAliasListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerDNSAliasListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerDNSAliasListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerDNSAliasListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerDNSAliasListResultIterator) Response() ServerDNSAliasListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerDNSAliasListResultIterator) Value() ServerDNSAlias {
	if !iter.page.NotDone() {
		return ServerDNSAlias{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerDNSAliasListResultIterator type.
func NewServerDNSAliasListResultIterator(page ServerDNSAliasListResultPage) ServerDNSAliasListResultIterator {
	return ServerDNSAliasListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdalr ServerDNSAliasListResult) IsEmpty() bool {
	return sdalr.Value == nil || len(*sdalr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdalr ServerDNSAliasListResult) hasNextLink() bool {
	return sdalr.NextLink != nil && len(*sdalr.NextLink) != 0
}

// serverDNSAliasListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdalr ServerDNSAliasListResult) serverDNSAliasListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdalr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdalr.NextLink)))
}

// ServerDNSAliasListResultPage contains a page of ServerDNSAlias values.
type ServerDNSAliasListResultPage struct {
	fn    func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)
	sdalr ServerDNSAliasListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerDNSAliasListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdalr)
		if err != nil {
			return err
		}
		page.sdalr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerDNSAliasListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerDNSAliasListResultPage) NotDone() bool {
	return !page.sdalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerDNSAliasListResultPage) Response() ServerDNSAliasListResult {
	return page.sdalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerDNSAliasListResultPage) Values() []ServerDNSAlias {
	if page.sdalr.IsEmpty() {
		return nil
	}
	return *page.sdalr.Value
}

// Creates a new instance of the ServerDNSAliasListResultPage type.
func NewServerDNSAliasListResultPage(cur ServerDNSAliasListResult, getNextPage func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)) ServerDNSAliasListResultPage {
	return ServerDNSAliasListResultPage{
		fn:    getNextPage,
		sdalr: cur,
	}
}

// ServerDNSAliasProperties properties of a server DNS alias.
type ServerDNSAliasProperties struct {
	// AzureDNSRecord - READ-ONLY; The fully qualified DNS record for alias
	AzureDNSRecord *string `json:"azureDnsRecord,omitempty"`
}

// ServerKey a server key.
type ServerKey struct {
	autorest.Response `json:"-"`
	// Kind - Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// ServerKeyProperties - Resource properties.
	*ServerKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerKey.
func (sk ServerKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sk.Kind != nil {
		objectMap["kind"] = sk.Kind
	}
	if sk.ServerKeyProperties != nil {
		objectMap["properties"] = sk.ServerKeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerKey struct.
func (sk *ServerKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sk.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sk.Location = &location
			}
		case "properties":
			if v != nil {
				var serverKeyProperties ServerKeyProperties
				err = json.Unmarshal(*v, &serverKeyProperties)
				if err != nil {
					return err
				}
				sk.ServerKeyProperties = &serverKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sk.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sk.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sk.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerKeyListResult a list of server keys.
type ServerKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]ServerKey `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerKeyListResultIterator provides access to a complete listing of ServerKey values.
type ServerKeyListResultIterator struct {
	i    int
	page ServerKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerKeyListResultIterator) Response() ServerKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerKeyListResultIterator) Value() ServerKey {
	if !iter.page.NotDone() {
		return ServerKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerKeyListResultIterator type.
func NewServerKeyListResultIterator(page ServerKeyListResultPage) ServerKeyListResultIterator {
	return ServerKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sklr ServerKeyListResult) IsEmpty() bool {
	return sklr.Value == nil || len(*sklr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sklr ServerKeyListResult) hasNextLink() bool {
	return sklr.NextLink != nil && len(*sklr.NextLink) != 0
}

// serverKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sklr ServerKeyListResult) serverKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sklr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sklr.NextLink)))
}

// ServerKeyListResultPage contains a page of ServerKey values.
type ServerKeyListResultPage struct {
	fn   func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)
	sklr ServerKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sklr)
		if err != nil {
			return err
		}
		page.sklr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerKeyListResultPage) NotDone() bool {
	return !page.sklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerKeyListResultPage) Response() ServerKeyListResult {
	return page.sklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerKeyListResultPage) Values() []ServerKey {
	if page.sklr.IsEmpty() {
		return nil
	}
	return *page.sklr.Value
}

// Creates a new instance of the ServerKeyListResultPage type.
func NewServerKeyListResultPage(cur ServerKeyListResult, getNextPage func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)) ServerKeyListResultPage {
	return ServerKeyListResultPage{
		fn:   getNextPage,
		sklr: cur,
	}
}

// ServerKeyProperties properties for a server key execution.
type ServerKeyProperties struct {
	// Subregion - READ-ONLY; Subregion of the server key.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyType - The server key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - The server key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerKeyProperties.
func (skp ServerKeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if skp.ServerKeyType != "" {
		objectMap["serverKeyType"] = skp.ServerKeyType
	}
	if skp.URI != nil {
		objectMap["uri"] = skp.URI
	}
	if skp.Thumbprint != nil {
		objectMap["thumbprint"] = skp.Thumbprint
	}
	if skp.CreationDate != nil {
		objectMap["creationDate"] = skp.CreationDate
	}
	return json.Marshal(objectMap)
}

// ServerKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerKeysCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerKeysClient) (ServerKey, error)
}

// ServerKeysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerKeysDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerKeysClient) (autorest.Response, error)
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]Server `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerListResultIterator provides access to a complete listing of Server values.
type ServerListResultIterator struct {
	i    int
	page ServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerListResultIterator) Response() ServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerListResultIterator) Value() Server {
	if !iter.page.NotDone() {
		return Server{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerListResultIterator type.
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return ServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServerListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServerListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serverListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServerListResult) serverListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServerListResultPage contains a page of Server values.
type ServerListResultPage struct {
	fn  func(context.Context, ServerListResult) (ServerListResult, error)
	slr ServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerListResultPage) Response() ServerListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerListResultPage) Values() []Server {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServerListResultPage type.
func NewServerListResultPage(cur ServerListResult, getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return ServerListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - Administrator username for the server. Once created it cannot be changed.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - The version of the server.
	Version *string `json:"version,omitempty"`
	// State - READ-ONLY; The state of the server.
	State *string `json:"state,omitempty"`
	// FullyQualifiedDomainName - READ-ONLY; The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerProperties.
func (sp ServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.AdministratorLogin != nil {
		objectMap["administratorLogin"] = sp.AdministratorLogin
	}
	if sp.AdministratorLoginPassword != nil {
		objectMap["administratorLoginPassword"] = sp.AdministratorLoginPassword
	}
	if sp.Version != nil {
		objectMap["version"] = sp.Version
	}
	return json.Marshal(objectMap)
}

// ServersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (autorest.Response, error)
}

// ServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServerSecurityAlertPoliciesClient) (ServerSecurityAlertPolicy, error)
}

// ServerSecurityAlertPolicy a server security alert policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicy.
func (ssap ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = ssap.SecurityAlertPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerSecurityAlertPolicy struct.
func (ssap *ServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				ssap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ServersClient) (Server, error)
}

// ServerUpdate an update request for an Azure SQL Database server.
type ServerUpdate struct {
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerUpdate.
func (su ServerUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.ServerProperties != nil {
		objectMap["properties"] = su.ServerProperties
	}
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerUpdate struct.
func (su *ServerUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				su.ServerProperties = &serverProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		}
	}

	return nil
}

// ServerUsage represents server metrics.
type ServerUsage struct {
	// Name - READ-ONLY; Name of the server usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - READ-ONLY; The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The current limit of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; The units of the metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - READ-ONLY; The next reset time for the metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerUsageListResult represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server metrics for the server.
	Value *[]ServerUsage `json:"value,omitempty"`
}

// ServerVersionCapability the server capabilities.
type ServerVersionCapability struct {
	// Name - READ-ONLY; The server version name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the server version. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedEditions - READ-ONLY; The list of supported database editions.
	SupportedEditions *[]EditionCapability `json:"supportedEditions,omitempty"`
	// SupportedElasticPoolEditions - READ-ONLY; The list of supported elastic pool editions.
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
}

// ServiceObjective represents a database service objective.
type ServiceObjective struct {
	autorest.Response `json:"-"`
	// ServiceObjectiveProperties - Represents the properties of the resource.
	*ServiceObjectiveProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjective.
func (so ServiceObjective) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if so.ServiceObjectiveProperties != nil {
		objectMap["properties"] = so.ServiceObjectiveProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjective struct.
func (so *ServiceObjective) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceObjectiveProperties ServiceObjectiveProperties
				err = json.Unmarshal(*v, &serviceObjectiveProperties)
				if err != nil {
					return err
				}
				so.ServiceObjectiveProperties = &serviceObjectiveProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				so.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				so.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				so.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceObjectiveCapability the service objectives capability.
type ServiceObjectiveCapability struct {
	// Name - READ-ONLY; The service objective name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; The status of the service objective. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// PerformanceLevel - READ-ONLY; The performance level of the service objective capability.
	*PerformanceLevel `json:"performanceLevel,omitempty"`
	// ID - READ-ONLY; The unique ID of the service objective.
	ID *uuid.UUID `json:"id,omitempty"`
	// SupportedMaxSizes - READ-ONLY; The list of supported maximum database sizes for this service objective.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - READ-ONLY; The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveCapability.
func (soc ServiceObjectiveCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjectiveCapability struct.
func (soc *ServiceObjectiveCapability) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				soc.Name = &name
			}
		case "status":
			if v != nil {
				var status CapabilityStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				soc.Status = status
			}
		case "performanceLevel":
			if v != nil {
				var performanceLevel PerformanceLevel
				err = json.Unmarshal(*v, &performanceLevel)
				if err != nil {
					return err
				}
				soc.PerformanceLevel = &performanceLevel
			}
		case "id":
			if v != nil {
				var ID uuid.UUID
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				soc.ID = &ID
			}
		case "supportedMaxSizes":
			if v != nil {
				var supportedMaxSizes []MaxSizeCapability
				err = json.Unmarshal(*v, &supportedMaxSizes)
				if err != nil {
					return err
				}
				soc.SupportedMaxSizes = &supportedMaxSizes
			}
		case "includedMaxSize":
			if v != nil {
				var includedMaxSize MaxSizeCapability
				err = json.Unmarshal(*v, &includedMaxSize)
				if err != nil {
					return err
				}
				soc.IncludedMaxSize = &includedMaxSize
			}
		}
	}

	return nil
}

// ServiceObjectiveListResult represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database service objectives.
	Value *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	// ServiceObjectiveName - READ-ONLY; The name for the service objective.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	// IsDefault - READ-ONLY; Gets whether the service level objective is the default service objective.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsSystem - READ-ONLY; Gets whether the service level objective is a system service objective.
	IsSystem *bool `json:"isSystem,omitempty"`
	// Description - READ-ONLY; The description for the service level objective.
	Description *string `json:"description,omitempty"`
	// Enabled - READ-ONLY; Gets whether the service level objective is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServiceTierAdvisor represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response `json:"-"`
	// ServiceTierAdvisorProperties - READ-ONLY; The properties representing the resource.
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceTierAdvisor.
func (sta ServiceTierAdvisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceTierAdvisor struct.
func (sta *ServiceTierAdvisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceTierAdvisorProperties ServiceTierAdvisorProperties
				err = json.Unmarshal(*v, &serviceTierAdvisorProperties)
				if err != nil {
					return err
				}
				sta.ServiceTierAdvisorProperties = &serviceTierAdvisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sta.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sta.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sta.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceTierAdvisorListResult represents the response to a list service tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of service tier advisors for specified database.
	Value *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties represents the properties of a Service Tier Advisor.
type ServiceTierAdvisorProperties struct {
	// ObservationPeriodStart - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - READ-ONLY; The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// ActiveTimeRatio - READ-ONLY; The activeTimeRatio for service tier advisor.
	ActiveTimeRatio *float64 `json:"activeTimeRatio,omitempty"`
	// MinDtu - READ-ONLY; Gets or sets minDtu for service tier advisor.
	MinDtu *float64 `json:"minDtu,omitempty"`
	// AvgDtu - READ-ONLY; Gets or sets avgDtu for service tier advisor.
	AvgDtu *float64 `json:"avgDtu,omitempty"`
	// MaxDtu - READ-ONLY; Gets or sets maxDtu for service tier advisor.
	MaxDtu *float64 `json:"maxDtu,omitempty"`
	// MaxSizeInGB - READ-ONLY; Gets or sets maxSizeInGB for service tier advisor.
	MaxSizeInGB *float64 `json:"maxSizeInGB,omitempty"`
	// ServiceLevelObjectiveUsageMetrics - READ-ONLY; Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor.
	ServiceLevelObjectiveUsageMetrics *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	// CurrentServiceLevelObjective - READ-ONLY; Gets or sets currentServiceLevelObjective for service tier advisor.
	CurrentServiceLevelObjective *string `json:"currentServiceLevelObjective,omitempty"`
	// CurrentServiceLevelObjectiveID - READ-ONLY; Gets or sets currentServiceLevelObjectiveId for service tier advisor.
	CurrentServiceLevelObjectiveID *uuid.UUID `json:"currentServiceLevelObjectiveId,omitempty"`
	// UsageBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor.
	UsageBasedRecommendationServiceLevelObjective *string `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	// UsageBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	UsageBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjective *string `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjective - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjective *string `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// OverallRecommendationServiceLevelObjective - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjective for service tier advisor.
	OverallRecommendationServiceLevelObjective *string `json:"overallRecommendationServiceLevelObjective,omitempty"`
	// OverallRecommendationServiceLevelObjectiveID - READ-ONLY; Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor.
	OverallRecommendationServiceLevelObjectiveID *uuid.UUID `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	// Confidence - READ-ONLY; Gets or sets confidence for service tier advisor.
	Confidence *float64 `json:"confidence,omitempty"`
}

// Sku an ARM Resource SKU.
type Sku struct {
	// Name - The name of the SKU, typically, a letter + Number code, e.g. P3.
	Name *string `json:"name,omitempty"`
	// Tier - The tier or edition of the particular SKU, e.g. Basic, Premium.
	Tier *string `json:"tier,omitempty"`
	// Size - Size of the particular SKU
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - Capacity of the particular SKU.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SloUsageMetric a Slo Usage Metric.
type SloUsageMetric struct {
	// ServiceLevelObjective - READ-ONLY; The serviceLevelObjective for SLO usage metric. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// ServiceLevelObjectiveID - READ-ONLY; The serviceLevelObjectiveId for SLO usage metric.
	ServiceLevelObjectiveID *uuid.UUID `json:"serviceLevelObjectiveId,omitempty"`
	// InRangeTimeRatio - READ-ONLY; Gets or sets inRangeTimeRatio for SLO usage metric.
	InRangeTimeRatio *float64 `json:"inRangeTimeRatio,omitempty"`
}

// SubscriptionUsage usage Metric of a Subscription in a Location.
type SubscriptionUsage struct {
	autorest.Response `json:"-"`
	// SubscriptionUsageProperties - Resource properties.
	*SubscriptionUsageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionUsage.
func (su SubscriptionUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.SubscriptionUsageProperties != nil {
		objectMap["properties"] = su.SubscriptionUsageProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionUsage struct.
func (su *SubscriptionUsage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionUsageProperties SubscriptionUsageProperties
				err = json.Unmarshal(*v, &subscriptionUsageProperties)
				if err != nil {
					return err
				}
				su.SubscriptionUsageProperties = &subscriptionUsageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				su.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				su.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				su.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionUsageListResult a list of subscription usage metrics in a location.
type SubscriptionUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SubscriptionUsage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionUsageListResultIterator provides access to a complete listing of SubscriptionUsage values.
type SubscriptionUsageListResultIterator struct {
	i    int
	page SubscriptionUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionUsageListResultIterator) Response() SubscriptionUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionUsageListResultIterator) Value() SubscriptionUsage {
	if !iter.page.NotDone() {
		return SubscriptionUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionUsageListResultIterator type.
func NewSubscriptionUsageListResultIterator(page SubscriptionUsageListResultPage) SubscriptionUsageListResultIterator {
	return SubscriptionUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sulr SubscriptionUsageListResult) IsEmpty() bool {
	return sulr.Value == nil || len(*sulr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sulr SubscriptionUsageListResult) hasNextLink() bool {
	return sulr.NextLink != nil && len(*sulr.NextLink) != 0
}

// subscriptionUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sulr SubscriptionUsageListResult) subscriptionUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sulr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sulr.NextLink)))
}

// SubscriptionUsageListResultPage contains a page of SubscriptionUsage values.
type SubscriptionUsageListResultPage struct {
	fn   func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)
	sulr SubscriptionUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sulr)
		if err != nil {
			return err
		}
		page.sulr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionUsageListResultPage) NotDone() bool {
	return !page.sulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionUsageListResultPage) Response() SubscriptionUsageListResult {
	return page.sulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionUsageListResultPage) Values() []SubscriptionUsage {
	if page.sulr.IsEmpty() {
		return nil
	}
	return *page.sulr.Value
}

// Creates a new instance of the SubscriptionUsageListResultPage type.
func NewSubscriptionUsageListResultPage(cur SubscriptionUsageListResult, getNextPage func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)) SubscriptionUsageListResultPage {
	return SubscriptionUsageListResultPage{
		fn:   getNextPage,
		sulr: cur,
	}
}

// SubscriptionUsageProperties properties of a subscription usage.
type SubscriptionUsageProperties struct {
	// DisplayName - READ-ONLY; User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - READ-ONLY; Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty"`
}

// SyncAgent an Azure SQL Database sync agent.
type SyncAgent struct {
	autorest.Response `json:"-"`
	// SyncAgentProperties - Resource properties.
	*SyncAgentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgent.
func (sa SyncAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SyncAgentProperties != nil {
		objectMap["properties"] = sa.SyncAgentProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgent struct.
func (sa *SyncAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentProperties SyncAgentProperties
				err = json.Unmarshal(*v, &syncAgentProperties)
				if err != nil {
					return err
				}
				sa.SyncAgentProperties = &syncAgentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentKeyProperties properties of an Azure SQL Database sync agent key.
type SyncAgentKeyProperties struct {
	autorest.Response `json:"-"`
	// SyncAgentKey - READ-ONLY; Key of sync agent.
	SyncAgentKey *string `json:"syncAgentKey,omitempty"`
}

// SyncAgentLinkedDatabase an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabase struct {
	// SyncAgentLinkedDatabaseProperties - Resource properties.
	*SyncAgentLinkedDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgentLinkedDatabase.
func (sald SyncAgentLinkedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sald.SyncAgentLinkedDatabaseProperties != nil {
		objectMap["properties"] = sald.SyncAgentLinkedDatabaseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgentLinkedDatabase struct.
func (sald *SyncAgentLinkedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentLinkedDatabaseProperties SyncAgentLinkedDatabaseProperties
				err = json.Unmarshal(*v, &syncAgentLinkedDatabaseProperties)
				if err != nil {
					return err
				}
				sald.SyncAgentLinkedDatabaseProperties = &syncAgentLinkedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sald.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sald.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sald.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentLinkedDatabaseListResult a list of sync agent linked databases.
type SyncAgentLinkedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncAgentLinkedDatabase `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentLinkedDatabaseListResultIterator provides access to a complete listing of
// SyncAgentLinkedDatabase values.
type SyncAgentLinkedDatabaseListResultIterator struct {
	i    int
	page SyncAgentLinkedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentLinkedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentLinkedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentLinkedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentLinkedDatabaseListResultIterator) Response() SyncAgentLinkedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentLinkedDatabaseListResultIterator) Value() SyncAgentLinkedDatabase {
	if !iter.page.NotDone() {
		return SyncAgentLinkedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultIterator type.
func NewSyncAgentLinkedDatabaseListResultIterator(page SyncAgentLinkedDatabaseListResultPage) SyncAgentLinkedDatabaseListResultIterator {
	return SyncAgentLinkedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saldlr SyncAgentLinkedDatabaseListResult) IsEmpty() bool {
	return saldlr.Value == nil || len(*saldlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (saldlr SyncAgentLinkedDatabaseListResult) hasNextLink() bool {
	return saldlr.NextLink != nil && len(*saldlr.NextLink) != 0
}

// syncAgentLinkedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saldlr SyncAgentLinkedDatabaseListResult) syncAgentLinkedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !saldlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saldlr.NextLink)))
}

// SyncAgentLinkedDatabaseListResultPage contains a page of SyncAgentLinkedDatabase values.
type SyncAgentLinkedDatabaseListResultPage struct {
	fn     func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)
	saldlr SyncAgentLinkedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentLinkedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.saldlr)
		if err != nil {
			return err
		}
		page.saldlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentLinkedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentLinkedDatabaseListResultPage) NotDone() bool {
	return !page.saldlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentLinkedDatabaseListResultPage) Response() SyncAgentLinkedDatabaseListResult {
	return page.saldlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentLinkedDatabaseListResultPage) Values() []SyncAgentLinkedDatabase {
	if page.saldlr.IsEmpty() {
		return nil
	}
	return *page.saldlr.Value
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultPage type.
func NewSyncAgentLinkedDatabaseListResultPage(cur SyncAgentLinkedDatabaseListResult, getNextPage func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)) SyncAgentLinkedDatabaseListResultPage {
	return SyncAgentLinkedDatabaseListResultPage{
		fn:     getNextPage,
		saldlr: cur,
	}
}

// SyncAgentLinkedDatabaseProperties properties of an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabaseProperties struct {
	// DatabaseType - READ-ONLY; Type of the sync agent linked database. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// DatabaseID - READ-ONLY; Id of the sync agent linked database.
	DatabaseID *string `json:"databaseId,omitempty"`
	// Description - READ-ONLY; Description of the sync agent linked database.
	Description *string `json:"description,omitempty"`
	// ServerName - READ-ONLY; Server name of the sync agent linked database.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - READ-ONLY; Database name of the sync agent linked database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - READ-ONLY; User name of the sync agent linked database.
	UserName *string `json:"userName,omitempty"`
}

// SyncAgentListResult a list of sync agents.
type SyncAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncAgent `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentListResultIterator provides access to a complete listing of SyncAgent values.
type SyncAgentListResultIterator struct {
	i    int
	page SyncAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentListResultIterator) Response() SyncAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentListResultIterator) Value() SyncAgent {
	if !iter.page.NotDone() {
		return SyncAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentListResultIterator type.
func NewSyncAgentListResultIterator(page SyncAgentListResultPage) SyncAgentListResultIterator {
	return SyncAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (salr SyncAgentListResult) IsEmpty() bool {
	return salr.Value == nil || len(*salr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (salr SyncAgentListResult) hasNextLink() bool {
	return salr.NextLink != nil && len(*salr.NextLink) != 0
}

// syncAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (salr SyncAgentListResult) syncAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !salr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(salr.NextLink)))
}

// SyncAgentListResultPage contains a page of SyncAgent values.
type SyncAgentListResultPage struct {
	fn   func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)
	salr SyncAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.salr)
		if err != nil {
			return err
		}
		page.salr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentListResultPage) NotDone() bool {
	return !page.salr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentListResultPage) Response() SyncAgentListResult {
	return page.salr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentListResultPage) Values() []SyncAgent {
	if page.salr.IsEmpty() {
		return nil
	}
	return *page.salr.Value
}

// Creates a new instance of the SyncAgentListResultPage type.
func NewSyncAgentListResultPage(cur SyncAgentListResult, getNextPage func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)) SyncAgentListResultPage {
	return SyncAgentListResultPage{
		fn:   getNextPage,
		salr: cur,
	}
}

// SyncAgentProperties properties of an Azure SQL Database sync agent.
type SyncAgentProperties struct {
	// Name - READ-ONLY; Name of the sync agent.
	Name *string `json:"name,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync agent.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// LastAliveTime - READ-ONLY; Last alive time of the sync agent.
	LastAliveTime *date.Time `json:"lastAliveTime,omitempty"`
	// State - READ-ONLY; State of the sync agent. Possible values include: 'SyncAgentStateOnline', 'SyncAgentStateOffline', 'SyncAgentStateNeverConnected'
	State SyncAgentState `json:"state,omitempty"`
	// IsUpToDate - READ-ONLY; If the sync agent version is up to date.
	IsUpToDate *bool `json:"isUpToDate,omitempty"`
	// ExpiryTime - READ-ONLY; Expiration time of the sync agent version.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Version - READ-ONLY; Version of the sync agent.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgentProperties.
func (sap SyncAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sap.SyncDatabaseID != nil {
		objectMap["syncDatabaseId"] = sap.SyncDatabaseID
	}
	return json.Marshal(objectMap)
}

// SyncAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncAgentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncAgentsClient) (SyncAgent, error)
}

// SyncAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncAgentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncAgentsClient) (autorest.Response, error)
}

// SyncDatabaseIDListResult a list of sync database ID properties.
type SyncDatabaseIDListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncDatabaseIDProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncDatabaseIDListResultIterator provides access to a complete listing of SyncDatabaseIDProperties
// values.
type SyncDatabaseIDListResultIterator struct {
	i    int
	page SyncDatabaseIDListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncDatabaseIDListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncDatabaseIDListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncDatabaseIDListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncDatabaseIDListResultIterator) Response() SyncDatabaseIDListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncDatabaseIDListResultIterator) Value() SyncDatabaseIDProperties {
	if !iter.page.NotDone() {
		return SyncDatabaseIDProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncDatabaseIDListResultIterator type.
func NewSyncDatabaseIDListResultIterator(page SyncDatabaseIDListResultPage) SyncDatabaseIDListResultIterator {
	return SyncDatabaseIDListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdilr SyncDatabaseIDListResult) IsEmpty() bool {
	return sdilr.Value == nil || len(*sdilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdilr SyncDatabaseIDListResult) hasNextLink() bool {
	return sdilr.NextLink != nil && len(*sdilr.NextLink) != 0
}

// syncDatabaseIDListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdilr SyncDatabaseIDListResult) syncDatabaseIDListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sdilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdilr.NextLink)))
}

// SyncDatabaseIDListResultPage contains a page of SyncDatabaseIDProperties values.
type SyncDatabaseIDListResultPage struct {
	fn    func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)
	sdilr SyncDatabaseIDListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncDatabaseIDListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdilr)
		if err != nil {
			return err
		}
		page.sdilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncDatabaseIDListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncDatabaseIDListResultPage) NotDone() bool {
	return !page.sdilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncDatabaseIDListResultPage) Response() SyncDatabaseIDListResult {
	return page.sdilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncDatabaseIDListResultPage) Values() []SyncDatabaseIDProperties {
	if page.sdilr.IsEmpty() {
		return nil
	}
	return *page.sdilr.Value
}

// Creates a new instance of the SyncDatabaseIDListResultPage type.
func NewSyncDatabaseIDListResultPage(cur SyncDatabaseIDListResult, getNextPage func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)) SyncDatabaseIDListResultPage {
	return SyncDatabaseIDListResultPage{
		fn:    getNextPage,
		sdilr: cur,
	}
}

// SyncDatabaseIDProperties properties of the sync database id.
type SyncDatabaseIDProperties struct {
	// ID - READ-ONLY; ARM resource id of sync database.
	ID *string `json:"id,omitempty"`
}

// SyncFullSchemaProperties properties of the database full schema.
type SyncFullSchemaProperties struct {
	// Tables - READ-ONLY; List of tables in the database full schema.
	Tables *[]SyncFullSchemaTable `json:"tables,omitempty"`
	// LastUpdateTime - READ-ONLY; Last update time of the database schema.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
}

// SyncFullSchemaPropertiesListResult a list of sync schema properties.
type SyncFullSchemaPropertiesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncFullSchemaProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncFullSchemaPropertiesListResultIterator provides access to a complete listing of
// SyncFullSchemaProperties values.
type SyncFullSchemaPropertiesListResultIterator struct {
	i    int
	page SyncFullSchemaPropertiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncFullSchemaPropertiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncFullSchemaPropertiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncFullSchemaPropertiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncFullSchemaPropertiesListResultIterator) Response() SyncFullSchemaPropertiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncFullSchemaPropertiesListResultIterator) Value() SyncFullSchemaProperties {
	if !iter.page.NotDone() {
		return SyncFullSchemaProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultIterator type.
func NewSyncFullSchemaPropertiesListResultIterator(page SyncFullSchemaPropertiesListResultPage) SyncFullSchemaPropertiesListResultIterator {
	return SyncFullSchemaPropertiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfsplr SyncFullSchemaPropertiesListResult) IsEmpty() bool {
	return sfsplr.Value == nil || len(*sfsplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sfsplr SyncFullSchemaPropertiesListResult) hasNextLink() bool {
	return sfsplr.NextLink != nil && len(*sfsplr.NextLink) != 0
}

// syncFullSchemaPropertiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfsplr SyncFullSchemaPropertiesListResult) syncFullSchemaPropertiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sfsplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfsplr.NextLink)))
}

// SyncFullSchemaPropertiesListResultPage contains a page of SyncFullSchemaProperties values.
type SyncFullSchemaPropertiesListResultPage struct {
	fn     func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)
	sfsplr SyncFullSchemaPropertiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncFullSchemaPropertiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sfsplr)
		if err != nil {
			return err
		}
		page.sfsplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncFullSchemaPropertiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncFullSchemaPropertiesListResultPage) NotDone() bool {
	return !page.sfsplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncFullSchemaPropertiesListResultPage) Response() SyncFullSchemaPropertiesListResult {
	return page.sfsplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncFullSchemaPropertiesListResultPage) Values() []SyncFullSchemaProperties {
	if page.sfsplr.IsEmpty() {
		return nil
	}
	return *page.sfsplr.Value
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultPage type.
func NewSyncFullSchemaPropertiesListResultPage(cur SyncFullSchemaPropertiesListResult, getNextPage func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)) SyncFullSchemaPropertiesListResultPage {
	return SyncFullSchemaPropertiesListResultPage{
		fn:     getNextPage,
		sfsplr: cur,
	}
}

// SyncFullSchemaTable properties of the table in the database full schema.
type SyncFullSchemaTable struct {
	// Columns - READ-ONLY; List of columns in the table of database full schema.
	Columns *[]SyncFullSchemaTableColumn `json:"columns,omitempty"`
	// ErrorID - READ-ONLY; Error id of the table.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// Name - READ-ONLY; Name of the table.
	Name *string `json:"name,omitempty"`
	// QuotedName - READ-ONLY; Quoted name of the table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncFullSchemaTableColumn properties of the column in the table of database full schema.
type SyncFullSchemaTableColumn struct {
	// DataSize - READ-ONLY; Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - READ-ONLY; Data type of the column.
	DataType *string `json:"dataType,omitempty"`
	// ErrorID - READ-ONLY; Error id of the column.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - READ-ONLY; If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// IsPrimaryKey - READ-ONLY; If it is the primary key of the table.
	IsPrimaryKey *bool `json:"isPrimaryKey,omitempty"`
	// Name - READ-ONLY; Name of the column.
	Name *string `json:"name,omitempty"`
	// QuotedName - READ-ONLY; Quoted name of the column.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroup an Azure SQL Database sync group.
type SyncGroup struct {
	autorest.Response `json:"-"`
	// SyncGroupProperties - Resource properties.
	*SyncGroupProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroup.
func (sg SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SyncGroupProperties != nil {
		objectMap["properties"] = sg.SyncGroupProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncGroup struct.
func (sg *SyncGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncGroupProperties SyncGroupProperties
				err = json.Unmarshal(*v, &syncGroupProperties)
				if err != nil {
					return err
				}
				sg.SyncGroupProperties = &syncGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncGroupListResult a list of sync groups.
type SyncGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncGroup `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupListResultIterator provides access to a complete listing of SyncGroup values.
type SyncGroupListResultIterator struct {
	i    int
	page SyncGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupListResultIterator) Response() SyncGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupListResultIterator) Value() SyncGroup {
	if !iter.page.NotDone() {
		return SyncGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupListResultIterator type.
func NewSyncGroupListResultIterator(page SyncGroupListResultPage) SyncGroupListResultIterator {
	return SyncGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SyncGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sglr SyncGroupListResult) hasNextLink() bool {
	return sglr.NextLink != nil && len(*sglr.NextLink) != 0
}

// syncGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SyncGroupListResult) syncGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sglr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SyncGroupListResultPage contains a page of SyncGroup values.
type SyncGroupListResultPage struct {
	fn   func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)
	sglr SyncGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sglr)
		if err != nil {
			return err
		}
		page.sglr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupListResultPage) Response() SyncGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupListResultPage) Values() []SyncGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SyncGroupListResultPage type.
func NewSyncGroupListResultPage(cur SyncGroupListResult, getNextPage func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)) SyncGroupListResultPage {
	return SyncGroupListResultPage{
		fn:   getNextPage,
		sglr: cur,
	}
}

// SyncGroupLogListResult a list of sync group log properties.
type SyncGroupLogListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncGroupLogProperties `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupLogListResultIterator provides access to a complete listing of SyncGroupLogProperties values.
type SyncGroupLogListResultIterator struct {
	i    int
	page SyncGroupLogListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupLogListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupLogListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupLogListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupLogListResultIterator) Response() SyncGroupLogListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupLogListResultIterator) Value() SyncGroupLogProperties {
	if !iter.page.NotDone() {
		return SyncGroupLogProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupLogListResultIterator type.
func NewSyncGroupLogListResultIterator(page SyncGroupLogListResultPage) SyncGroupLogListResultIterator {
	return SyncGroupLogListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgllr SyncGroupLogListResult) IsEmpty() bool {
	return sgllr.Value == nil || len(*sgllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sgllr SyncGroupLogListResult) hasNextLink() bool {
	return sgllr.NextLink != nil && len(*sgllr.NextLink) != 0
}

// syncGroupLogListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgllr SyncGroupLogListResult) syncGroupLogListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sgllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgllr.NextLink)))
}

// SyncGroupLogListResultPage contains a page of SyncGroupLogProperties values.
type SyncGroupLogListResultPage struct {
	fn    func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)
	sgllr SyncGroupLogListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupLogListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sgllr)
		if err != nil {
			return err
		}
		page.sgllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupLogListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupLogListResultPage) NotDone() bool {
	return !page.sgllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupLogListResultPage) Response() SyncGroupLogListResult {
	return page.sgllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupLogListResultPage) Values() []SyncGroupLogProperties {
	if page.sgllr.IsEmpty() {
		return nil
	}
	return *page.sgllr.Value
}

// Creates a new instance of the SyncGroupLogListResultPage type.
func NewSyncGroupLogListResultPage(cur SyncGroupLogListResult, getNextPage func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)) SyncGroupLogListResultPage {
	return SyncGroupLogListResultPage{
		fn:    getNextPage,
		sgllr: cur,
	}
}

// SyncGroupLogProperties properties of an Azure SQL Database sync group log.
type SyncGroupLogProperties struct {
	// Timestamp - READ-ONLY; Timestamp of the sync group log.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Type - READ-ONLY; Type of the sync group log. Possible values include: 'SyncGroupLogTypeAll', 'SyncGroupLogTypeError', 'SyncGroupLogTypeWarning', 'SyncGroupLogTypeSuccess'
	Type SyncGroupLogType `json:"type,omitempty"`
	// Source - READ-ONLY; Source of the sync group log.
	Source *string `json:"source,omitempty"`
	// Details - READ-ONLY; Details of the sync group log.
	Details *string `json:"details,omitempty"`
	// TracingID - READ-ONLY; TracingId of the sync group log.
	TracingID *uuid.UUID `json:"tracingId,omitempty"`
	// OperationStatus - READ-ONLY; OperationStatus of the sync group log.
	OperationStatus *string `json:"operationStatus,omitempty"`
}

// SyncGroupProperties properties of a sync group.
type SyncGroupProperties struct {
	// Interval - Sync interval of the sync group.
	Interval *int32 `json:"interval,omitempty"`
	// LastSyncTime - READ-ONLY; Last sync time of the sync group.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// ConflictResolutionPolicy - Conflict resolution policy of the sync group. Possible values include: 'HubWin', 'MemberWin'
	ConflictResolutionPolicy SyncConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync group.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// HubDatabaseUserName - User name for the sync group hub database credential.
	HubDatabaseUserName *string `json:"hubDatabaseUserName,omitempty"`
	// HubDatabasePassword - Password for the sync group hub database credential.
	HubDatabasePassword *string `json:"hubDatabasePassword,omitempty"`
	// SyncState - READ-ONLY; Sync state of the sync group. Possible values include: 'NotReady', 'Error', 'Warning', 'Progressing', 'Good'
	SyncState SyncGroupState `json:"syncState,omitempty"`
	// Schema - Sync schema of the sync group.
	Schema *SyncGroupSchema `json:"schema,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroupProperties.
func (sgp SyncGroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sgp.Interval != nil {
		objectMap["interval"] = sgp.Interval
	}
	if sgp.ConflictResolutionPolicy != "" {
		objectMap["conflictResolutionPolicy"] = sgp.ConflictResolutionPolicy
	}
	if sgp.SyncDatabaseID != nil {
		objectMap["syncDatabaseId"] = sgp.SyncDatabaseID
	}
	if sgp.HubDatabaseUserName != nil {
		objectMap["hubDatabaseUserName"] = sgp.HubDatabaseUserName
	}
	if sgp.HubDatabasePassword != nil {
		objectMap["hubDatabasePassword"] = sgp.HubDatabasePassword
	}
	if sgp.Schema != nil {
		objectMap["schema"] = sgp.Schema
	}
	return json.Marshal(objectMap)
}

// SyncGroupSchema properties of sync group schema.
type SyncGroupSchema struct {
	// Tables - List of tables in sync group schema.
	Tables *[]SyncGroupSchemaTable `json:"tables,omitempty"`
	// MasterSyncMemberName - Name of master sync member where the schema is from.
	MasterSyncMemberName *string `json:"masterSyncMemberName,omitempty"`
}

// SyncGroupSchemaTable properties of table in sync group schema.
type SyncGroupSchemaTable struct {
	// Columns - List of columns in sync group schema.
	Columns *[]SyncGroupSchemaTableColumn `json:"columns,omitempty"`
	// QuotedName - Quoted name of sync group schema table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroupSchemaTableColumn properties of column in sync group table.
type SyncGroupSchemaTableColumn struct {
	// QuotedName - Quoted name of sync group table column.
	QuotedName *string `json:"quotedName,omitempty"`
	// DataSize - Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - Data type of the column.
	DataType *string `json:"dataType,omitempty"`
}

// SyncGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncGroupsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncGroupsClient) (SyncGroup, error)
}

// SyncGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncGroupsClient) (autorest.Response, error)
}

// SyncGroupsRefreshHubSchemaFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncGroupsRefreshHubSchemaFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncGroupsClient) (autorest.Response, error)
}

// SyncGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncGroupsClient) (SyncGroup, error)
}

// SyncMember an Azure SQL Database sync member.
type SyncMember struct {
	autorest.Response `json:"-"`
	// SyncMemberProperties - Resource properties.
	*SyncMemberProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncMember.
func (sm SyncMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sm.SyncMemberProperties != nil {
		objectMap["properties"] = sm.SyncMemberProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncMember struct.
func (sm *SyncMember) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncMemberProperties SyncMemberProperties
				err = json.Unmarshal(*v, &syncMemberProperties)
				if err != nil {
					return err
				}
				sm.SyncMemberProperties = &syncMemberProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sm.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncMemberListResult a list of Azure SQL Database sync members.
type SyncMemberListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]SyncMember `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncMemberListResultIterator provides access to a complete listing of SyncMember values.
type SyncMemberListResultIterator struct {
	i    int
	page SyncMemberListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncMemberListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncMemberListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncMemberListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncMemberListResultIterator) Response() SyncMemberListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncMemberListResultIterator) Value() SyncMember {
	if !iter.page.NotDone() {
		return SyncMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncMemberListResultIterator type.
func NewSyncMemberListResultIterator(page SyncMemberListResultPage) SyncMemberListResultIterator {
	return SyncMemberListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smlr SyncMemberListResult) IsEmpty() bool {
	return smlr.Value == nil || len(*smlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (smlr SyncMemberListResult) hasNextLink() bool {
	return smlr.NextLink != nil && len(*smlr.NextLink) != 0
}

// syncMemberListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smlr SyncMemberListResult) syncMemberListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !smlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smlr.NextLink)))
}

// SyncMemberListResultPage contains a page of SyncMember values.
type SyncMemberListResultPage struct {
	fn   func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)
	smlr SyncMemberListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncMemberListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.smlr)
		if err != nil {
			return err
		}
		page.smlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncMemberListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncMemberListResultPage) NotDone() bool {
	return !page.smlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncMemberListResultPage) Response() SyncMemberListResult {
	return page.smlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncMemberListResultPage) Values() []SyncMember {
	if page.smlr.IsEmpty() {
		return nil
	}
	return *page.smlr.Value
}

// Creates a new instance of the SyncMemberListResultPage type.
func NewSyncMemberListResultPage(cur SyncMemberListResult, getNextPage func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)) SyncMemberListResultPage {
	return SyncMemberListResultPage{
		fn:   getNextPage,
		smlr: cur,
	}
}

// SyncMemberProperties properties of a sync member.
type SyncMemberProperties struct {
	// DatabaseType - Database type of the sync member. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// SyncAgentID - ARM resource id of the sync agent in the sync member.
	SyncAgentID *string `json:"syncAgentId,omitempty"`
	// SQLServerDatabaseID - SQL Server database id of the sync member.
	SQLServerDatabaseID *uuid.UUID `json:"sqlServerDatabaseId,omitempty"`
	// ServerName - Server name of the member database in the sync member
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Database name of the member database in the sync member.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - User name of the member database in the sync member.
	UserName *string `json:"userName,omitempty"`
	// Password - Password of the member database in the sync member.
	Password *string `json:"password,omitempty"`
	// SyncDirection - Sync direction of the sync member. Possible values include: 'Bidirectional', 'OneWayMemberToHub', 'OneWayHubToMember'
	SyncDirection SyncDirection `json:"syncDirection,omitempty"`
	// SyncState - READ-ONLY; Sync state of the sync member. Possible values include: 'SyncInProgress', 'SyncSucceeded', 'SyncFailed', 'DisabledTombstoneCleanup', 'DisabledBackupRestore', 'SyncSucceededWithWarnings', 'SyncCancelling', 'SyncCancelled', 'UnProvisioned', 'Provisioning', 'Provisioned', 'ProvisionFailed', 'DeProvisioning', 'DeProvisioned', 'DeProvisionFailed', 'Reprovisioning', 'ReprovisionFailed', 'UnReprovisioned'
	SyncState SyncMemberState `json:"syncState,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncMemberProperties.
func (smp SyncMemberProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smp.DatabaseType != "" {
		objectMap["databaseType"] = smp.DatabaseType
	}
	if smp.SyncAgentID != nil {
		objectMap["syncAgentId"] = smp.SyncAgentID
	}
	if smp.SQLServerDatabaseID != nil {
		objectMap["sqlServerDatabaseId"] = smp.SQLServerDatabaseID
	}
	if smp.ServerName != nil {
		objectMap["serverName"] = smp.ServerName
	}
	if smp.DatabaseName != nil {
		objectMap["databaseName"] = smp.DatabaseName
	}
	if smp.UserName != nil {
		objectMap["userName"] = smp.UserName
	}
	if smp.Password != nil {
		objectMap["password"] = smp.Password
	}
	if smp.SyncDirection != "" {
		objectMap["syncDirection"] = smp.SyncDirection
	}
	return json.Marshal(objectMap)
}

// SyncMembersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncMembersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncMembersClient) (SyncMember, error)
}

// SyncMembersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncMembersClient) (autorest.Response, error)
}

// SyncMembersRefreshMemberSchemaFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncMembersRefreshMemberSchemaFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncMembersClient) (autorest.Response, error)
}

// SyncMembersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SyncMembersClient) (SyncMember, error)
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a database transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivity represents a database transparent data encryption Scan.
type TransparentDataEncryptionActivity struct {
	// Location - READ-ONLY; Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionActivityProperties - Represents the properties of the resource.
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryptionActivity.
func (tdea TransparentDataEncryptionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdea.TransparentDataEncryptionActivityProperties != nil {
		objectMap["properties"] = tdea.TransparentDataEncryptionActivityProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryptionActivity struct.
func (tdea *TransparentDataEncryptionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tdea.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionActivityProperties TransparentDataEncryptionActivityProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionActivityProperties)
				if err != nil {
					return err
				}
				tdea.TransparentDataEncryptionActivityProperties = &transparentDataEncryptionActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdea.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivityListResult represents the response to a list database transparent data
// encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database transparent data encryption activities.
	Value *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties represents the properties of a database transparent data
// encryption Scan.
type TransparentDataEncryptionActivityProperties struct {
	// Status - READ-ONLY; The status of the database. Possible values include: 'Encrypting', 'Decrypting'
	Status TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	// PercentComplete - READ-ONLY; The percent complete of the transparent data encryption scan for a database.
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// UnlinkParameters represents the parameters for Unlink Replication Link request.
type UnlinkParameters struct {
	// ForcedTermination - Determines whether link will be terminated in a forced or a friendly way.
	ForcedTermination *bool `json:"forcedTermination,omitempty"`
}

// VirtualCluster an Azure SQL virtual cluster.
type VirtualCluster struct {
	autorest.Response `json:"-"`
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualCluster.
func (vc VirtualCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vc.VirtualClusterProperties != nil {
		objectMap["properties"] = vc.VirtualClusterProperties
	}
	if vc.Location != nil {
		objectMap["location"] = vc.Location
	}
	if vc.Tags != nil {
		objectMap["tags"] = vc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualCluster struct.
func (vc *VirtualCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vc.VirtualClusterProperties = &virtualClusterProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vc.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualClusterListResult a list of virtual clusters.
type VirtualClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VirtualCluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualClusterListResultIterator provides access to a complete listing of VirtualCluster values.
type VirtualClusterListResultIterator struct {
	i    int
	page VirtualClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualClusterListResultIterator) Response() VirtualClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualClusterListResultIterator) Value() VirtualCluster {
	if !iter.page.NotDone() {
		return VirtualCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualClusterListResultIterator type.
func NewVirtualClusterListResultIterator(page VirtualClusterListResultPage) VirtualClusterListResultIterator {
	return VirtualClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vclr VirtualClusterListResult) IsEmpty() bool {
	return vclr.Value == nil || len(*vclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vclr VirtualClusterListResult) hasNextLink() bool {
	return vclr.NextLink != nil && len(*vclr.NextLink) != 0
}

// virtualClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vclr VirtualClusterListResult) virtualClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vclr.NextLink)))
}

// VirtualClusterListResultPage contains a page of VirtualCluster values.
type VirtualClusterListResultPage struct {
	fn   func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)
	vclr VirtualClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vclr)
		if err != nil {
			return err
		}
		page.vclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualClusterListResultPage) NotDone() bool {
	return !page.vclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualClusterListResultPage) Response() VirtualClusterListResult {
	return page.vclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualClusterListResultPage) Values() []VirtualCluster {
	if page.vclr.IsEmpty() {
		return nil
	}
	return *page.vclr.Value
}

// Creates a new instance of the VirtualClusterListResultPage type.
func NewVirtualClusterListResultPage(cur VirtualClusterListResult, getNextPage func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)) VirtualClusterListResultPage {
	return VirtualClusterListResultPage{
		fn:   getNextPage,
		vclr: cur,
	}
}

// VirtualClusterProperties the properties of a virtual cluster.
type VirtualClusterProperties struct {
	// SubnetID - READ-ONLY; Subnet resource ID for the virtual cluster.
	SubnetID *string `json:"subnetId,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// ChildResources - READ-ONLY; List of resources in this virtual cluster.
	ChildResources *[]string `json:"childResources,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualClusterProperties.
func (vcp VirtualClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcp.Family != nil {
		objectMap["family"] = vcp.Family
	}
	return json.Marshal(objectMap)
}

// VirtualClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualClustersClient) (autorest.Response, error)
}

// VirtualClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualClustersClient) (VirtualCluster, error)
}

// VirtualClusterUpdate an update request for an Azure SQL Database virtual cluster.
type VirtualClusterUpdate struct {
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualClusterUpdate.
func (vcu VirtualClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcu.VirtualClusterProperties != nil {
		objectMap["properties"] = vcu.VirtualClusterProperties
	}
	if vcu.Tags != nil {
		objectMap["tags"] = vcu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualClusterUpdate struct.
func (vcu *VirtualClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vcu.VirtualClusterProperties = &virtualClusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vcu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkRule a virtual network rule.
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - Resource properties.
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnr.VirtualNetworkRuleProperties != nil {
		objectMap["properties"] = vnr.VirtualNetworkRuleProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult a list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; Array of results.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vnrlr VirtualNetworkRuleListResult) hasNextLink() bool {
	return vnrlr.NextLink != nil && len(*vnrlr.NextLink) != 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vnrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vnrlr)
		if err != nil {
			return err
		}
		page.vnrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(cur VirtualNetworkRuleListResult, getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{
		fn:    getNextPage,
		vnrlr: cur,
	}
}

// VirtualNetworkRuleProperties properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// VirtualNetworkSubnetID - The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
	// State - READ-ONLY; Virtual Network Rule State. Possible values include: 'VirtualNetworkRuleStateInitializing', 'VirtualNetworkRuleStateInProgress', 'VirtualNetworkRuleStateReady', 'VirtualNetworkRuleStateDeleting', 'VirtualNetworkRuleStateUnknown'
	State VirtualNetworkRuleState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRuleProperties.
func (vnrp VirtualNetworkRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnrp.VirtualNetworkSubnetID != nil {
		objectMap["virtualNetworkSubnetId"] = vnrp.VirtualNetworkSubnetID
	}
	if vnrp.IgnoreMissingVnetServiceEndpoint != nil {
		objectMap["ignoreMissingVnetServiceEndpoint"] = vnrp.IgnoreMissingVnetServiceEndpoint
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkRulesClient) (VirtualNetworkRule, error)
}

// VirtualNetworkRulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VirtualNetworkRulesClient) (autorest.Response, error)
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring
// scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}
