package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"io"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/web/mgmt/2020-09-01/web"

// AbnormalTimePeriod class representing Abnormal Time Period identified in diagnosis
type AbnormalTimePeriod struct {
	// StartTime - Start time of the downtime
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the downtime
	EndTime *date.Time `json:"endTime,omitempty"`
	// Events - List of Possible Cause of downtime
	Events *[]DetectorAbnormalTimePeriod `json:"events,omitempty"`
	// Solutions - List of proposed solutions
	Solutions *[]Solution `json:"solutions,omitempty"`
}

// Address address information for domain registration.
type Address struct {
	// Address1 - First line of an Address.
	Address1 *string `json:"address1,omitempty"`
	// Address2 - The second line of the Address. Optional.
	Address2 *string `json:"address2,omitempty"`
	// City - The city for the address.
	City *string `json:"city,omitempty"`
	// Country - The country for the address.
	Country *string `json:"country,omitempty"`
	// PostalCode - The postal code for the address.
	PostalCode *string `json:"postalCode,omitempty"`
	// State - The state or province for the address.
	State *string `json:"state,omitempty"`
}

// AddressResponse describes main public IP address and any extra virtual IPs.
type AddressResponse struct {
	autorest.Response `json:"-"`
	// AddressResponseProperties - AddressResponse resource specific properties
	*AddressResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressResponse.
func (ar AddressResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AddressResponseProperties != nil {
		objectMap["properties"] = ar.AddressResponseProperties
	}
	if ar.Kind != nil {
		objectMap["kind"] = ar.Kind
	}
	if ar.SystemData != nil {
		objectMap["systemData"] = ar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressResponse struct.
func (ar *AddressResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressResponseProperties AddressResponseProperties
				err = json.Unmarshal(*v, &addressResponseProperties)
				if err != nil {
					return err
				}
				ar.AddressResponseProperties = &addressResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ar.SystemData = &systemData
			}
		}
	}

	return nil
}

// AddressResponseProperties addressResponse resource specific properties
type AddressResponseProperties struct {
	// ServiceIPAddress - Main public virtual IP.
	ServiceIPAddress *string `json:"serviceIpAddress,omitempty"`
	// InternalIPAddress - Virtual Network internal IP address of the App Service Environment if it is in internal load-balancing mode.
	InternalIPAddress *string `json:"internalIpAddress,omitempty"`
	// OutboundIPAddresses - IP addresses appearing on outbound connections.
	OutboundIPAddresses *[]string `json:"outboundIpAddresses,omitempty"`
	// VipMappings - Additional virtual IPs.
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
}

// AllowedAudiencesValidation ...
type AllowedAudiencesValidation struct {
	// AllowedAudiencesValidationProperties - AllowedAudiencesValidation resource specific properties
	*AllowedAudiencesValidationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AllowedAudiencesValidation.
func (aav AllowedAudiencesValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aav.AllowedAudiencesValidationProperties != nil {
		objectMap["properties"] = aav.AllowedAudiencesValidationProperties
	}
	if aav.Kind != nil {
		objectMap["kind"] = aav.Kind
	}
	if aav.SystemData != nil {
		objectMap["systemData"] = aav.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AllowedAudiencesValidation struct.
func (aav *AllowedAudiencesValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var allowedAudiencesValidationProperties AllowedAudiencesValidationProperties
				err = json.Unmarshal(*v, &allowedAudiencesValidationProperties)
				if err != nil {
					return err
				}
				aav.AllowedAudiencesValidationProperties = &allowedAudiencesValidationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aav.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aav.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aav.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aav.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aav.SystemData = &systemData
			}
		}
	}

	return nil
}

// AllowedAudiencesValidationProperties allowedAudiencesValidation resource specific properties
type AllowedAudiencesValidationProperties struct {
	AllowedAudiences *[]string `json:"allowedAudiences,omitempty"`
}

// AnalysisData class Representing Detector Evidence used for analysis
type AnalysisData struct {
	// Source - Name of the Detector
	Source *string `json:"source,omitempty"`
	// DetectorDefinition - Detector Definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`
	// Metrics - Source Metrics
	Metrics *[]DiagnosticMetricSet `json:"metrics,omitempty"`
	// Data - Additional Source Data
	Data *[][]NameValuePair `json:"data,omitempty"`
	// DetectorMetaData - Detector Meta Data
	DetectorMetaData *ResponseMetaData `json:"detectorMetaData,omitempty"`
}

// AnalysisDefinition definition of Analysis
type AnalysisDefinition struct {
	autorest.Response `json:"-"`
	// AnalysisDefinitionProperties - AnalysisDefinition resource specific properties
	*AnalysisDefinitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AnalysisDefinition.
func (ad AnalysisDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.AnalysisDefinitionProperties != nil {
		objectMap["properties"] = ad.AnalysisDefinitionProperties
	}
	if ad.Kind != nil {
		objectMap["kind"] = ad.Kind
	}
	if ad.SystemData != nil {
		objectMap["systemData"] = ad.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AnalysisDefinition struct.
func (ad *AnalysisDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var analysisDefinitionProperties AnalysisDefinitionProperties
				err = json.Unmarshal(*v, &analysisDefinitionProperties)
				if err != nil {
					return err
				}
				ad.AnalysisDefinitionProperties = &analysisDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ad.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ad.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ad.SystemData = &systemData
			}
		}
	}

	return nil
}

// AnalysisDefinitionProperties analysisDefinition resource specific properties
type AnalysisDefinitionProperties struct {
	// Description - READ-ONLY; Description of the Analysis
	Description *string `json:"description,omitempty"`
}

// APIDefinitionInfo information about the formal API definition for the app.
type APIDefinitionInfo struct {
	// URL - The URL of the API definition.
	URL *string `json:"url,omitempty"`
}

// APIManagementConfig azure API management (APIM) configuration linked to the app.
type APIManagementConfig struct {
	// ID - APIM-Api Identifier.
	ID *string `json:"id,omitempty"`
}

// AppCollection collection of App Service apps.
type AppCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Site `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppCollection.
func (ac AppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ac.Value != nil {
		objectMap["value"] = ac.Value
	}
	return json.Marshal(objectMap)
}

// AppCollectionIterator provides access to a complete listing of Site values.
type AppCollectionIterator struct {
	i    int
	page AppCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppCollectionIterator) Response() AppCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppCollectionIterator) Value() Site {
	if !iter.page.NotDone() {
		return Site{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppCollectionIterator type.
func NewAppCollectionIterator(page AppCollectionPage) AppCollectionIterator {
	return AppCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AppCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac AppCollection) hasNextLink() bool {
	return ac.NextLink != nil && len(*ac.NextLink) != 0
}

// appCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AppCollection) appCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.NextLink)))
}

// AppCollectionPage contains a page of Site values.
type AppCollectionPage struct {
	fn func(context.Context, AppCollection) (AppCollection, error)
	ac AppCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppCollectionPage) Response() AppCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppCollectionPage) Values() []Site {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the AppCollectionPage type.
func NewAppCollectionPage(cur AppCollection, getNextPage func(context.Context, AppCollection) (AppCollection, error)) AppCollectionPage {
	return AppCollectionPage{
		fn: getNextPage,
		ac: cur,
	}
}

// AppInstanceStatusCollection collection of app instances.
type AppInstanceStatusCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteInstanceStatus `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppInstanceStatusCollection.
func (aisc AppInstanceStatusCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aisc.Value != nil {
		objectMap["value"] = aisc.Value
	}
	return json.Marshal(objectMap)
}

// AppInstanceStatusCollectionIterator provides access to a complete listing of SiteInstanceStatus values.
type AppInstanceStatusCollectionIterator struct {
	i    int
	page AppInstanceStatusCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppInstanceStatusCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppInstanceStatusCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppInstanceStatusCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppInstanceStatusCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppInstanceStatusCollectionIterator) Response() AppInstanceStatusCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppInstanceStatusCollectionIterator) Value() SiteInstanceStatus {
	if !iter.page.NotDone() {
		return SiteInstanceStatus{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppInstanceStatusCollectionIterator type.
func NewAppInstanceStatusCollectionIterator(page AppInstanceStatusCollectionPage) AppInstanceStatusCollectionIterator {
	return AppInstanceStatusCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aisc AppInstanceStatusCollection) IsEmpty() bool {
	return aisc.Value == nil || len(*aisc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aisc AppInstanceStatusCollection) hasNextLink() bool {
	return aisc.NextLink != nil && len(*aisc.NextLink) != 0
}

// appInstanceStatusCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aisc AppInstanceStatusCollection) appInstanceStatusCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !aisc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aisc.NextLink)))
}

// AppInstanceStatusCollectionPage contains a page of SiteInstanceStatus values.
type AppInstanceStatusCollectionPage struct {
	fn   func(context.Context, AppInstanceStatusCollection) (AppInstanceStatusCollection, error)
	aisc AppInstanceStatusCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppInstanceStatusCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppInstanceStatusCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aisc)
		if err != nil {
			return err
		}
		page.aisc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppInstanceStatusCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppInstanceStatusCollectionPage) NotDone() bool {
	return !page.aisc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppInstanceStatusCollectionPage) Response() AppInstanceStatusCollection {
	return page.aisc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppInstanceStatusCollectionPage) Values() []SiteInstanceStatus {
	if page.aisc.IsEmpty() {
		return nil
	}
	return *page.aisc.Value
}

// Creates a new instance of the AppInstanceStatusCollectionPage type.
func NewAppInstanceStatusCollectionPage(cur AppInstanceStatusCollection, getNextPage func(context.Context, AppInstanceStatusCollection) (AppInstanceStatusCollection, error)) AppInstanceStatusCollectionPage {
	return AppInstanceStatusCollectionPage{
		fn:   getNextPage,
		aisc: cur,
	}
}

// ApplicationLogsConfig application logs configuration.
type ApplicationLogsConfig struct {
	// FileSystem - Application logs to file system configuration.
	FileSystem *FileSystemApplicationLogsConfig `json:"fileSystem,omitempty"`
	// AzureTableStorage - Application logs to azure table storage configuration.
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`
	// AzureBlobStorage - Application logs to blob storage configuration.
	AzureBlobStorage *AzureBlobStorageApplicationLogsConfig `json:"azureBlobStorage,omitempty"`
}

// ApplicationStack application stack.
type ApplicationStack struct {
	// Name - Application stack name.
	Name *string `json:"name,omitempty"`
	// Display - Application stack display name.
	Display *string `json:"display,omitempty"`
	// Dependency - Application stack dependency.
	Dependency *string `json:"dependency,omitempty"`
	// MajorVersions - List of major versions available.
	MajorVersions *[]StackMajorVersion `json:"majorVersions,omitempty"`
	// Frameworks - List of frameworks associated with application stack.
	Frameworks *[]ApplicationStack `json:"frameworks,omitempty"`
}

// ApplicationStackCollection collection of Application Stacks
type ApplicationStackCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ApplicationStackResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationStackCollection.
func (asc ApplicationStackCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asc.Value != nil {
		objectMap["value"] = asc.Value
	}
	return json.Marshal(objectMap)
}

// ApplicationStackCollectionIterator provides access to a complete listing of ApplicationStackResource
// values.
type ApplicationStackCollectionIterator struct {
	i    int
	page ApplicationStackCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationStackCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationStackCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplicationStackCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationStackCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationStackCollectionIterator) Response() ApplicationStackCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationStackCollectionIterator) Value() ApplicationStackResource {
	if !iter.page.NotDone() {
		return ApplicationStackResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplicationStackCollectionIterator type.
func NewApplicationStackCollectionIterator(page ApplicationStackCollectionPage) ApplicationStackCollectionIterator {
	return ApplicationStackCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asc ApplicationStackCollection) IsEmpty() bool {
	return asc.Value == nil || len(*asc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asc ApplicationStackCollection) hasNextLink() bool {
	return asc.NextLink != nil && len(*asc.NextLink) != 0
}

// applicationStackCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asc ApplicationStackCollection) applicationStackCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asc.NextLink)))
}

// ApplicationStackCollectionPage contains a page of ApplicationStackResource values.
type ApplicationStackCollectionPage struct {
	fn  func(context.Context, ApplicationStackCollection) (ApplicationStackCollection, error)
	asc ApplicationStackCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationStackCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplicationStackCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asc)
		if err != nil {
			return err
		}
		page.asc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplicationStackCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationStackCollectionPage) NotDone() bool {
	return !page.asc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationStackCollectionPage) Response() ApplicationStackCollection {
	return page.asc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationStackCollectionPage) Values() []ApplicationStackResource {
	if page.asc.IsEmpty() {
		return nil
	}
	return *page.asc.Value
}

// Creates a new instance of the ApplicationStackCollectionPage type.
func NewApplicationStackCollectionPage(cur ApplicationStackCollection, getNextPage func(context.Context, ApplicationStackCollection) (ApplicationStackCollection, error)) ApplicationStackCollectionPage {
	return ApplicationStackCollectionPage{
		fn:  getNextPage,
		asc: cur,
	}
}

// ApplicationStackResource ARM resource for a ApplicationStack.
type ApplicationStackResource struct {
	// ApplicationStack - Core resource properties
	*ApplicationStack `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationStackResource.
func (asr ApplicationStackResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.ApplicationStack != nil {
		objectMap["properties"] = asr.ApplicationStack
	}
	if asr.Kind != nil {
		objectMap["kind"] = asr.Kind
	}
	if asr.SystemData != nil {
		objectMap["systemData"] = asr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplicationStackResource struct.
func (asr *ApplicationStackResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applicationStack ApplicationStack
				err = json.Unmarshal(*v, &applicationStack)
				if err != nil {
					return err
				}
				asr.ApplicationStack = &applicationStack
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppRegistration ...
type AppRegistration struct {
	// AppRegistrationProperties - AppRegistration resource specific properties
	*AppRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppRegistration.
func (ar AppRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ar.AppRegistrationProperties != nil {
		objectMap["properties"] = ar.AppRegistrationProperties
	}
	if ar.Kind != nil {
		objectMap["kind"] = ar.Kind
	}
	if ar.SystemData != nil {
		objectMap["systemData"] = ar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppRegistration struct.
func (ar *AppRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appRegistrationProperties AppRegistrationProperties
				err = json.Unmarshal(*v, &appRegistrationProperties)
				if err != nil {
					return err
				}
				ar.AppRegistrationProperties = &appRegistrationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ar.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppRegistrationProperties appRegistration resource specific properties
type AppRegistrationProperties struct {
	AppID                *string `json:"appId,omitempty"`
	AppSecretSettingName *string `json:"appSecretSettingName,omitempty"`
}

// AppsApproveOrRejectPrivateEndpointConnectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AppsApproveOrRejectPrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (PrivateEndpointConnectionResource, error)
}

// AppsCopyProductionSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCopyProductionSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsCopySlotSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCopySlotSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsCreateFunctionFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateFunctionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (FunctionEnvelope, error)
}

// AppsCreateInstanceFunctionSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateInstanceFunctionSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (FunctionEnvelope, error)
}

// AppsCreateInstanceMSDeployOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateInstanceMSDeployOperationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (MSDeployStatus, error)
}

// AppsCreateInstanceMSDeployOperationSlotFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AppsCreateInstanceMSDeployOperationSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (MSDeployStatus, error)
}

// AppsCreateMSDeployOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateMSDeployOperationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (MSDeployStatus, error)
}

// AppsCreateMSDeployOperationSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateMSDeployOperationSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (MSDeployStatus, error)
}

// AppsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (Site, error)
}

// AppsCreateOrUpdateSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsCreateOrUpdateSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (Site, error)
}

// AppsCreateOrUpdateSourceControlFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateOrUpdateSourceControlFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (SiteSourceControl, error)
}

// AppsCreateOrUpdateSourceControlSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsCreateOrUpdateSourceControlSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (SiteSourceControl, error)
}

// AppsDeletePrivateEndpointConnectionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsDeletePrivateEndpointConnectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (SetObject, error)
}

// AppServiceCertificate key Vault container for a certificate that is purchased through Azure.
type AppServiceCertificate struct {
	// KeyVaultID - Key Vault resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// ProvisioningState - READ-ONLY; Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	ProvisioningState KeyVaultSecretStatus `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificate.
func (asc AppServiceCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asc.KeyVaultID != nil {
		objectMap["keyVaultId"] = asc.KeyVaultID
	}
	if asc.KeyVaultSecretName != nil {
		objectMap["keyVaultSecretName"] = asc.KeyVaultSecretName
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateCollection collection of certificate order certificates.
type AppServiceCertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceCertificateResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateCollection.
func (ascc AppServiceCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascc.Value != nil {
		objectMap["value"] = ascc.Value
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateCollectionIterator provides access to a complete listing of
// AppServiceCertificateResource values.
type AppServiceCertificateCollectionIterator struct {
	i    int
	page AppServiceCertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceCertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceCertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceCertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceCertificateCollectionIterator) Response() AppServiceCertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceCertificateCollectionIterator) Value() AppServiceCertificateResource {
	if !iter.page.NotDone() {
		return AppServiceCertificateResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceCertificateCollectionIterator type.
func NewAppServiceCertificateCollectionIterator(page AppServiceCertificateCollectionPage) AppServiceCertificateCollectionIterator {
	return AppServiceCertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ascc AppServiceCertificateCollection) IsEmpty() bool {
	return ascc.Value == nil || len(*ascc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ascc AppServiceCertificateCollection) hasNextLink() bool {
	return ascc.NextLink != nil && len(*ascc.NextLink) != 0
}

// appServiceCertificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ascc AppServiceCertificateCollection) appServiceCertificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ascc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ascc.NextLink)))
}

// AppServiceCertificateCollectionPage contains a page of AppServiceCertificateResource values.
type AppServiceCertificateCollectionPage struct {
	fn   func(context.Context, AppServiceCertificateCollection) (AppServiceCertificateCollection, error)
	ascc AppServiceCertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceCertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ascc)
		if err != nil {
			return err
		}
		page.ascc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceCertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceCertificateCollectionPage) NotDone() bool {
	return !page.ascc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceCertificateCollectionPage) Response() AppServiceCertificateCollection {
	return page.ascc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceCertificateCollectionPage) Values() []AppServiceCertificateResource {
	if page.ascc.IsEmpty() {
		return nil
	}
	return *page.ascc.Value
}

// Creates a new instance of the AppServiceCertificateCollectionPage type.
func NewAppServiceCertificateCollectionPage(cur AppServiceCertificateCollection, getNextPage func(context.Context, AppServiceCertificateCollection) (AppServiceCertificateCollection, error)) AppServiceCertificateCollectionPage {
	return AppServiceCertificateCollectionPage{
		fn:   getNextPage,
		ascc: cur,
	}
}

// AppServiceCertificateOrder SSL certificate purchase order.
type AppServiceCertificateOrder struct {
	autorest.Response `json:"-"`
	// AppServiceCertificateOrderProperties - AppServiceCertificateOrder resource specific properties
	*AppServiceCertificateOrderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrder.
func (asco AppServiceCertificateOrder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asco.AppServiceCertificateOrderProperties != nil {
		objectMap["properties"] = asco.AppServiceCertificateOrderProperties
	}
	if asco.Kind != nil {
		objectMap["kind"] = asco.Kind
	}
	if asco.Location != nil {
		objectMap["location"] = asco.Location
	}
	if asco.Tags != nil {
		objectMap["tags"] = asco.Tags
	}
	if asco.SystemData != nil {
		objectMap["systemData"] = asco.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateOrder struct.
func (asco *AppServiceCertificateOrder) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificateOrderProperties AppServiceCertificateOrderProperties
				err = json.Unmarshal(*v, &appServiceCertificateOrderProperties)
				if err != nil {
					return err
				}
				asco.AppServiceCertificateOrderProperties = &appServiceCertificateOrderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asco.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asco.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asco.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asco.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asco.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asco.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asco.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceCertificateOrderCollection collection of certificate orders.
type AppServiceCertificateOrderCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceCertificateOrder `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderCollection.
func (ascoc AppServiceCertificateOrderCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascoc.Value != nil {
		objectMap["value"] = ascoc.Value
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateOrderCollectionIterator provides access to a complete listing of
// AppServiceCertificateOrder values.
type AppServiceCertificateOrderCollectionIterator struct {
	i    int
	page AppServiceCertificateOrderCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceCertificateOrderCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrderCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceCertificateOrderCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceCertificateOrderCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceCertificateOrderCollectionIterator) Response() AppServiceCertificateOrderCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceCertificateOrderCollectionIterator) Value() AppServiceCertificateOrder {
	if !iter.page.NotDone() {
		return AppServiceCertificateOrder{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceCertificateOrderCollectionIterator type.
func NewAppServiceCertificateOrderCollectionIterator(page AppServiceCertificateOrderCollectionPage) AppServiceCertificateOrderCollectionIterator {
	return AppServiceCertificateOrderCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ascoc AppServiceCertificateOrderCollection) IsEmpty() bool {
	return ascoc.Value == nil || len(*ascoc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ascoc AppServiceCertificateOrderCollection) hasNextLink() bool {
	return ascoc.NextLink != nil && len(*ascoc.NextLink) != 0
}

// appServiceCertificateOrderCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ascoc AppServiceCertificateOrderCollection) appServiceCertificateOrderCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ascoc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ascoc.NextLink)))
}

// AppServiceCertificateOrderCollectionPage contains a page of AppServiceCertificateOrder values.
type AppServiceCertificateOrderCollectionPage struct {
	fn    func(context.Context, AppServiceCertificateOrderCollection) (AppServiceCertificateOrderCollection, error)
	ascoc AppServiceCertificateOrderCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceCertificateOrderCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceCertificateOrderCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ascoc)
		if err != nil {
			return err
		}
		page.ascoc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceCertificateOrderCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceCertificateOrderCollectionPage) NotDone() bool {
	return !page.ascoc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceCertificateOrderCollectionPage) Response() AppServiceCertificateOrderCollection {
	return page.ascoc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceCertificateOrderCollectionPage) Values() []AppServiceCertificateOrder {
	if page.ascoc.IsEmpty() {
		return nil
	}
	return *page.ascoc.Value
}

// Creates a new instance of the AppServiceCertificateOrderCollectionPage type.
func NewAppServiceCertificateOrderCollectionPage(cur AppServiceCertificateOrderCollection, getNextPage func(context.Context, AppServiceCertificateOrderCollection) (AppServiceCertificateOrderCollection, error)) AppServiceCertificateOrderCollectionPage {
	return AppServiceCertificateOrderCollectionPage{
		fn:    getNextPage,
		ascoc: cur,
	}
}

// AppServiceCertificateOrderPatchResource ARM resource for a certificate order that is purchased through
// Azure.
type AppServiceCertificateOrderPatchResource struct {
	// AppServiceCertificateOrderPatchResourceProperties - AppServiceCertificateOrderPatchResource resource specific properties
	*AppServiceCertificateOrderPatchResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderPatchResource.
func (ascopr AppServiceCertificateOrderPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascopr.AppServiceCertificateOrderPatchResourceProperties != nil {
		objectMap["properties"] = ascopr.AppServiceCertificateOrderPatchResourceProperties
	}
	if ascopr.Kind != nil {
		objectMap["kind"] = ascopr.Kind
	}
	if ascopr.SystemData != nil {
		objectMap["systemData"] = ascopr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateOrderPatchResource struct.
func (ascopr *AppServiceCertificateOrderPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificateOrderPatchResourceProperties AppServiceCertificateOrderPatchResourceProperties
				err = json.Unmarshal(*v, &appServiceCertificateOrderPatchResourceProperties)
				if err != nil {
					return err
				}
				ascopr.AppServiceCertificateOrderPatchResourceProperties = &appServiceCertificateOrderPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascopr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascopr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascopr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascopr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ascopr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceCertificateOrderPatchResourceProperties appServiceCertificateOrderPatchResource resource
// specific properties
type AppServiceCertificateOrderPatchResourceProperties struct {
	// Certificates - State of the Key Vault secret.
	Certificates map[string]*AppServiceCertificate `json:"certificates"`
	// DistinguishedName - Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// DomainVerificationToken - READ-ONLY; Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty"`
	// ValidityInYears - Duration in years (must be between 1 and 3).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`
	// KeySize - Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`
	// ProductType - Certificate product type. Possible values include: 'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
	ProductType CertificateProductType `json:"productType,omitempty"`
	// AutoRenew - <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ProvisioningState - READ-ONLY; Status of certificate order. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Current order status. Possible values include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
	Status CertificateOrderStatus `json:"status,omitempty"`
	// SignedCertificate - READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty"`
	// Csr - Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`
	// Intermediate - READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty"`
	// Root - READ-ONLY; Root certificate.
	Root *CertificateDetails `json:"root,omitempty"`
	// SerialNumber - READ-ONLY; Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// LastCertificateIssuanceTime - READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *date.Time `json:"lastCertificateIssuanceTime,omitempty"`
	// ExpirationTime - READ-ONLY; Certificate expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// IsPrivateKeyExternal - READ-ONLY; <code>true</code> if private key is external; otherwise, <code>false</code>.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
	// AppServiceCertificateNotRenewableReasons - READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons *[]string `json:"appServiceCertificateNotRenewableReasons,omitempty"`
	// NextAutoRenewalTimeStamp - READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *date.Time `json:"nextAutoRenewalTimeStamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderPatchResourceProperties.
func (ascopr AppServiceCertificateOrderPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascopr.Certificates != nil {
		objectMap["certificates"] = ascopr.Certificates
	}
	if ascopr.DistinguishedName != nil {
		objectMap["distinguishedName"] = ascopr.DistinguishedName
	}
	if ascopr.ValidityInYears != nil {
		objectMap["validityInYears"] = ascopr.ValidityInYears
	}
	if ascopr.KeySize != nil {
		objectMap["keySize"] = ascopr.KeySize
	}
	if ascopr.ProductType != "" {
		objectMap["productType"] = ascopr.ProductType
	}
	if ascopr.AutoRenew != nil {
		objectMap["autoRenew"] = ascopr.AutoRenew
	}
	if ascopr.Csr != nil {
		objectMap["csr"] = ascopr.Csr
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateOrderProperties appServiceCertificateOrder resource specific properties
type AppServiceCertificateOrderProperties struct {
	// Certificates - State of the Key Vault secret.
	Certificates map[string]*AppServiceCertificate `json:"certificates"`
	// DistinguishedName - Certificate distinguished name.
	DistinguishedName *string `json:"distinguishedName,omitempty"`
	// DomainVerificationToken - READ-ONLY; Domain verification token.
	DomainVerificationToken *string `json:"domainVerificationToken,omitempty"`
	// ValidityInYears - Duration in years (must be between 1 and 3).
	ValidityInYears *int32 `json:"validityInYears,omitempty"`
	// KeySize - Certificate key size.
	KeySize *int32 `json:"keySize,omitempty"`
	// ProductType - Certificate product type. Possible values include: 'StandardDomainValidatedSsl', 'StandardDomainValidatedWildCardSsl'
	ProductType CertificateProductType `json:"productType,omitempty"`
	// AutoRenew - <code>true</code> if the certificate should be automatically renewed when it expires; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ProvisioningState - READ-ONLY; Status of certificate order. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Current order status. Possible values include: 'Pendingissuance', 'Issued', 'Revoked', 'Canceled', 'Denied', 'Pendingrevocation', 'PendingRekey', 'Unused', 'Expired', 'NotSubmitted'
	Status CertificateOrderStatus `json:"status,omitempty"`
	// SignedCertificate - READ-ONLY; Signed certificate.
	SignedCertificate *CertificateDetails `json:"signedCertificate,omitempty"`
	// Csr - Last CSR that was created for this order.
	Csr *string `json:"csr,omitempty"`
	// Intermediate - READ-ONLY; Intermediate certificate.
	Intermediate *CertificateDetails `json:"intermediate,omitempty"`
	// Root - READ-ONLY; Root certificate.
	Root *CertificateDetails `json:"root,omitempty"`
	// SerialNumber - READ-ONLY; Current serial number of the certificate.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// LastCertificateIssuanceTime - READ-ONLY; Certificate last issuance time.
	LastCertificateIssuanceTime *date.Time `json:"lastCertificateIssuanceTime,omitempty"`
	// ExpirationTime - READ-ONLY; Certificate expiration time.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// IsPrivateKeyExternal - READ-ONLY; <code>true</code> if private key is external; otherwise, <code>false</code>.
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
	// AppServiceCertificateNotRenewableReasons - READ-ONLY; Reasons why App Service Certificate is not renewable at the current moment.
	AppServiceCertificateNotRenewableReasons *[]string `json:"appServiceCertificateNotRenewableReasons,omitempty"`
	// NextAutoRenewalTimeStamp - READ-ONLY; Time stamp when the certificate would be auto renewed next
	NextAutoRenewalTimeStamp *date.Time `json:"nextAutoRenewalTimeStamp,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateOrderProperties.
func (asco AppServiceCertificateOrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asco.Certificates != nil {
		objectMap["certificates"] = asco.Certificates
	}
	if asco.DistinguishedName != nil {
		objectMap["distinguishedName"] = asco.DistinguishedName
	}
	if asco.ValidityInYears != nil {
		objectMap["validityInYears"] = asco.ValidityInYears
	}
	if asco.KeySize != nil {
		objectMap["keySize"] = asco.KeySize
	}
	if asco.ProductType != "" {
		objectMap["productType"] = asco.ProductType
	}
	if asco.AutoRenew != nil {
		objectMap["autoRenew"] = asco.AutoRenew
	}
	if asco.Csr != nil {
		objectMap["csr"] = asco.Csr
	}
	return json.Marshal(objectMap)
}

// AppServiceCertificateOrdersCreateOrUpdateCertificateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type AppServiceCertificateOrdersCreateOrUpdateCertificateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceCertificateOrdersClient) (AppServiceCertificateResource, error)
}

// AppServiceCertificateOrdersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AppServiceCertificateOrdersCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceCertificateOrdersClient) (AppServiceCertificateOrder, error)
}

// AppServiceCertificatePatchResource key Vault container ARM resource for a certificate that is purchased
// through Azure.
type AppServiceCertificatePatchResource struct {
	// AppServiceCertificate - Core resource properties
	*AppServiceCertificate `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificatePatchResource.
func (ascpr AppServiceCertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascpr.AppServiceCertificate != nil {
		objectMap["properties"] = ascpr.AppServiceCertificate
	}
	if ascpr.Kind != nil {
		objectMap["kind"] = ascpr.Kind
	}
	if ascpr.SystemData != nil {
		objectMap["systemData"] = ascpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificatePatchResource struct.
func (ascpr *AppServiceCertificatePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificate AppServiceCertificate
				err = json.Unmarshal(*v, &appServiceCertificate)
				if err != nil {
					return err
				}
				ascpr.AppServiceCertificate = &appServiceCertificate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ascpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceCertificateResource key Vault container ARM resource for a certificate that is purchased
// through Azure.
type AppServiceCertificateResource struct {
	autorest.Response `json:"-"`
	// AppServiceCertificate - Core resource properties
	*AppServiceCertificate `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceCertificateResource.
func (ascr AppServiceCertificateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ascr.AppServiceCertificate != nil {
		objectMap["properties"] = ascr.AppServiceCertificate
	}
	if ascr.Kind != nil {
		objectMap["kind"] = ascr.Kind
	}
	if ascr.Location != nil {
		objectMap["location"] = ascr.Location
	}
	if ascr.Tags != nil {
		objectMap["tags"] = ascr.Tags
	}
	if ascr.SystemData != nil {
		objectMap["systemData"] = ascr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceCertificateResource struct.
func (ascr *AppServiceCertificateResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceCertificate AppServiceCertificate
				err = json.Unmarshal(*v, &appServiceCertificate)
				if err != nil {
					return err
				}
				ascr.AppServiceCertificate = &appServiceCertificate
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ascr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ascr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ascr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ascr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ascr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ascr.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ascr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceEnvironment description of an App Service Environment.
type AppServiceEnvironment struct {
	// Name - Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Location - Location of the App Service Environment, e.g. "West US".
	Location *string `json:"location,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Current status of the App Service Environment. Possible values include: 'Preparing', 'Ready', 'Scaling', 'Deleting'
	Status HostingEnvironmentStatus `json:"status,omitempty"`
	// VnetName - Name of the Virtual Network for the App Service Environment.
	VnetName *string `json:"vnetName,omitempty"`
	// VnetResourceGroupName - Resource group of the Virtual Network.
	VnetResourceGroupName *string `json:"vnetResourceGroupName,omitempty"`
	// VnetSubnetName - Subnet of the Virtual Network.
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
	// VirtualNetwork - Description of the Virtual Network.
	VirtualNetwork *VirtualNetworkProfile `json:"virtualNetwork,omitempty"`
	// InternalLoadBalancingMode - Specifies which endpoints to serve internally in the Virtual Network for the App Service Environment. Possible values include: 'LoadBalancingModeNone', 'LoadBalancingModeWeb', 'LoadBalancingModePublishing', 'LoadBalancingModeWebPublishing'
	InternalLoadBalancingMode LoadBalancingMode `json:"internalLoadBalancingMode,omitempty"`
	// MultiSize - Front-end VM size, e.g. "Medium", "Large".
	MultiSize *string `json:"multiSize,omitempty"`
	// MultiRoleCount - Number of front-end instances.
	MultiRoleCount *int32 `json:"multiRoleCount,omitempty"`
	// WorkerPools - Description of worker pools with worker size IDs, VM sizes, and number of workers in each pool.
	WorkerPools *[]WorkerPool `json:"workerPools,omitempty"`
	// IpsslAddressCount - Number of IP SSL addresses reserved for the App Service Environment.
	IpsslAddressCount *int32 `json:"ipsslAddressCount,omitempty"`
	// DatabaseEdition - READ-ONLY; Edition of the metadata database for the App Service Environment, e.g. "Standard".
	DatabaseEdition *string `json:"databaseEdition,omitempty"`
	// DatabaseServiceObjective - READ-ONLY; Service objective of the metadata database for the App Service Environment, e.g. "S0".
	DatabaseServiceObjective *string `json:"databaseServiceObjective,omitempty"`
	// UpgradeDomains - READ-ONLY; Number of upgrade domains of the App Service Environment.
	UpgradeDomains *int32 `json:"upgradeDomains,omitempty"`
	// SubscriptionID - READ-ONLY; Subscription of the App Service Environment.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// DNSSuffix - DNS suffix of the App Service Environment.
	DNSSuffix *string `json:"dnsSuffix,omitempty"`
	// LastAction - READ-ONLY; Last deployment action on the App Service Environment.
	LastAction *string `json:"lastAction,omitempty"`
	// LastActionResult - READ-ONLY; Result of the last deployment action on the App Service Environment.
	LastActionResult *string `json:"lastActionResult,omitempty"`
	// AllowedMultiSizes - READ-ONLY; List of comma separated strings describing which VM sizes are allowed for front-ends.
	AllowedMultiSizes *string `json:"allowedMultiSizes,omitempty"`
	// AllowedWorkerSizes - READ-ONLY; List of comma separated strings describing which VM sizes are allowed for workers.
	AllowedWorkerSizes *string `json:"allowedWorkerSizes,omitempty"`
	// MaximumNumberOfMachines - READ-ONLY; Maximum number of VMs in the App Service Environment.
	MaximumNumberOfMachines *int32 `json:"maximumNumberOfMachines,omitempty"`
	// VipMappings - READ-ONLY; Description of IP SSL mapping for the App Service Environment.
	VipMappings *[]VirtualIPMapping `json:"vipMappings,omitempty"`
	// EnvironmentCapacities - READ-ONLY; Current total, used, and available worker capacities.
	EnvironmentCapacities *[]StampCapacity `json:"environmentCapacities,omitempty"`
	// NetworkAccessControlList - Access control list for controlling traffic to the App Service Environment.
	NetworkAccessControlList *[]NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`
	// EnvironmentIsHealthy - READ-ONLY; True/false indicating whether the App Service Environment is healthy.
	EnvironmentIsHealthy *bool `json:"environmentIsHealthy,omitempty"`
	// EnvironmentStatus - READ-ONLY; Detailed message about with results of the last check of the App Service Environment.
	EnvironmentStatus *string `json:"environmentStatus,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group of the App Service Environment.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FrontEndScaleFactor - Scale factor for front-ends.
	FrontEndScaleFactor *int32 `json:"frontEndScaleFactor,omitempty"`
	// DefaultFrontEndScaleFactor - READ-ONLY; Default Scale Factor for FrontEnds.
	DefaultFrontEndScaleFactor *int32 `json:"defaultFrontEndScaleFactor,omitempty"`
	// APIManagementAccountID - API Management Account associated with the App Service Environment.
	APIManagementAccountID *string `json:"apiManagementAccountId,omitempty"`
	// Suspended - <code>true</code> if the App Service Environment is suspended; otherwise, <code>false</code>. The environment can be suspended, e.g. when the management endpoint is no longer available
	//  (most likely because NSG blocked the incoming traffic).
	Suspended *bool `json:"suspended,omitempty"`
	// DynamicCacheEnabled - True/false indicating whether the App Service Environment is suspended. The environment can be suspended e.g. when the management endpoint is no longer available
	// (most likely because NSG blocked the incoming traffic).
	DynamicCacheEnabled *bool `json:"dynamicCacheEnabled,omitempty"`
	// ClusterSettings - Custom settings for changing the behavior of the App Service Environment.
	ClusterSettings *[]NameValuePair `json:"clusterSettings,omitempty"`
	// UserWhitelistedIPRanges - User added ip ranges to whitelist on ASE db
	UserWhitelistedIPRanges *[]string `json:"userWhitelistedIpRanges,omitempty"`
	// HasLinuxWorkers - Flag that displays whether an ASE has linux workers or not
	HasLinuxWorkers *bool `json:"hasLinuxWorkers,omitempty"`
	// SslCertKeyVaultID - Key Vault ID for ILB App Service Environment default SSL certificate
	SslCertKeyVaultID *string `json:"sslCertKeyVaultId,omitempty"`
	// SslCertKeyVaultSecretName - Key Vault Secret Name for ILB App Service Environment default SSL certificate
	SslCertKeyVaultSecretName *string `json:"sslCertKeyVaultSecretName,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironment.
func (ase AppServiceEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ase.Name != nil {
		objectMap["name"] = ase.Name
	}
	if ase.Location != nil {
		objectMap["location"] = ase.Location
	}
	if ase.VnetName != nil {
		objectMap["vnetName"] = ase.VnetName
	}
	if ase.VnetResourceGroupName != nil {
		objectMap["vnetResourceGroupName"] = ase.VnetResourceGroupName
	}
	if ase.VnetSubnetName != nil {
		objectMap["vnetSubnetName"] = ase.VnetSubnetName
	}
	if ase.VirtualNetwork != nil {
		objectMap["virtualNetwork"] = ase.VirtualNetwork
	}
	if ase.InternalLoadBalancingMode != "" {
		objectMap["internalLoadBalancingMode"] = ase.InternalLoadBalancingMode
	}
	if ase.MultiSize != nil {
		objectMap["multiSize"] = ase.MultiSize
	}
	if ase.MultiRoleCount != nil {
		objectMap["multiRoleCount"] = ase.MultiRoleCount
	}
	if ase.WorkerPools != nil {
		objectMap["workerPools"] = ase.WorkerPools
	}
	if ase.IpsslAddressCount != nil {
		objectMap["ipsslAddressCount"] = ase.IpsslAddressCount
	}
	if ase.DNSSuffix != nil {
		objectMap["dnsSuffix"] = ase.DNSSuffix
	}
	if ase.NetworkAccessControlList != nil {
		objectMap["networkAccessControlList"] = ase.NetworkAccessControlList
	}
	if ase.FrontEndScaleFactor != nil {
		objectMap["frontEndScaleFactor"] = ase.FrontEndScaleFactor
	}
	if ase.APIManagementAccountID != nil {
		objectMap["apiManagementAccountId"] = ase.APIManagementAccountID
	}
	if ase.Suspended != nil {
		objectMap["suspended"] = ase.Suspended
	}
	if ase.DynamicCacheEnabled != nil {
		objectMap["dynamicCacheEnabled"] = ase.DynamicCacheEnabled
	}
	if ase.ClusterSettings != nil {
		objectMap["clusterSettings"] = ase.ClusterSettings
	}
	if ase.UserWhitelistedIPRanges != nil {
		objectMap["userWhitelistedIpRanges"] = ase.UserWhitelistedIPRanges
	}
	if ase.HasLinuxWorkers != nil {
		objectMap["hasLinuxWorkers"] = ase.HasLinuxWorkers
	}
	if ase.SslCertKeyVaultID != nil {
		objectMap["sslCertKeyVaultId"] = ase.SslCertKeyVaultID
	}
	if ase.SslCertKeyVaultSecretName != nil {
		objectMap["sslCertKeyVaultSecretName"] = ase.SslCertKeyVaultSecretName
	}
	return json.Marshal(objectMap)
}

// AppServiceEnvironmentCollection collection of App Service Environments.
type AppServiceEnvironmentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServiceEnvironmentResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironmentCollection.
func (asec AppServiceEnvironmentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asec.Value != nil {
		objectMap["value"] = asec.Value
	}
	return json.Marshal(objectMap)
}

// AppServiceEnvironmentCollectionIterator provides access to a complete listing of
// AppServiceEnvironmentResource values.
type AppServiceEnvironmentCollectionIterator struct {
	i    int
	page AppServiceEnvironmentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServiceEnvironmentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServiceEnvironmentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServiceEnvironmentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServiceEnvironmentCollectionIterator) Response() AppServiceEnvironmentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServiceEnvironmentCollectionIterator) Value() AppServiceEnvironmentResource {
	if !iter.page.NotDone() {
		return AppServiceEnvironmentResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServiceEnvironmentCollectionIterator type.
func NewAppServiceEnvironmentCollectionIterator(page AppServiceEnvironmentCollectionPage) AppServiceEnvironmentCollectionIterator {
	return AppServiceEnvironmentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asec AppServiceEnvironmentCollection) IsEmpty() bool {
	return asec.Value == nil || len(*asec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asec AppServiceEnvironmentCollection) hasNextLink() bool {
	return asec.NextLink != nil && len(*asec.NextLink) != 0
}

// appServiceEnvironmentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asec AppServiceEnvironmentCollection) appServiceEnvironmentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !asec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asec.NextLink)))
}

// AppServiceEnvironmentCollectionPage contains a page of AppServiceEnvironmentResource values.
type AppServiceEnvironmentCollectionPage struct {
	fn   func(context.Context, AppServiceEnvironmentCollection) (AppServiceEnvironmentCollection, error)
	asec AppServiceEnvironmentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServiceEnvironmentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServiceEnvironmentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asec)
		if err != nil {
			return err
		}
		page.asec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServiceEnvironmentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServiceEnvironmentCollectionPage) NotDone() bool {
	return !page.asec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServiceEnvironmentCollectionPage) Response() AppServiceEnvironmentCollection {
	return page.asec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServiceEnvironmentCollectionPage) Values() []AppServiceEnvironmentResource {
	if page.asec.IsEmpty() {
		return nil
	}
	return *page.asec.Value
}

// Creates a new instance of the AppServiceEnvironmentCollectionPage type.
func NewAppServiceEnvironmentCollectionPage(cur AppServiceEnvironmentCollection, getNextPage func(context.Context, AppServiceEnvironmentCollection) (AppServiceEnvironmentCollection, error)) AppServiceEnvironmentCollectionPage {
	return AppServiceEnvironmentCollectionPage{
		fn:   getNextPage,
		asec: cur,
	}
}

// AppServiceEnvironmentPatchResource ARM resource for a app service environment.
type AppServiceEnvironmentPatchResource struct {
	// AppServiceEnvironment - Core resource properties
	*AppServiceEnvironment `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironmentPatchResource.
func (asepr AppServiceEnvironmentPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asepr.AppServiceEnvironment != nil {
		objectMap["properties"] = asepr.AppServiceEnvironment
	}
	if asepr.Kind != nil {
		objectMap["kind"] = asepr.Kind
	}
	if asepr.SystemData != nil {
		objectMap["systemData"] = asepr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceEnvironmentPatchResource struct.
func (asepr *AppServiceEnvironmentPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceEnvironment AppServiceEnvironment
				err = json.Unmarshal(*v, &appServiceEnvironment)
				if err != nil {
					return err
				}
				asepr.AppServiceEnvironment = &appServiceEnvironment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asepr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asepr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asepr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asepr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asepr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceEnvironmentResource app Service Environment ARM resource.
type AppServiceEnvironmentResource struct {
	autorest.Response `json:"-"`
	// AppServiceEnvironment - Core resource properties
	*AppServiceEnvironment `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServiceEnvironmentResource.
func (aser AppServiceEnvironmentResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aser.AppServiceEnvironment != nil {
		objectMap["properties"] = aser.AppServiceEnvironment
	}
	if aser.Kind != nil {
		objectMap["kind"] = aser.Kind
	}
	if aser.Location != nil {
		objectMap["location"] = aser.Location
	}
	if aser.Tags != nil {
		objectMap["tags"] = aser.Tags
	}
	if aser.SystemData != nil {
		objectMap["systemData"] = aser.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServiceEnvironmentResource struct.
func (aser *AppServiceEnvironmentResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServiceEnvironment AppServiceEnvironment
				err = json.Unmarshal(*v, &appServiceEnvironment)
				if err != nil {
					return err
				}
				aser.AppServiceEnvironment = &appServiceEnvironment
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aser.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aser.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aser.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				aser.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aser.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				aser.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aser.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServiceEnvironmentsChangeVnetAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsChangeVnetAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppServiceEnvironmentsChangeVnetFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsChangeVnetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppServiceEnvironmentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppServiceEnvironmentResource, error)
}

// AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (WorkerPoolResource, error)
}

// AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (WorkerPoolResource, error)
}

// AppServiceEnvironmentsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (autorest.Response, error)
}

// AppServiceEnvironmentsResumeAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsResumeAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppServiceEnvironmentsResumeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsResumeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppServiceEnvironmentsSuspendAllFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsSuspendAllFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppServiceEnvironmentsSuspendFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServiceEnvironmentsSuspendFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServiceEnvironmentsClient) (AppCollectionPage, error)
}

// AppserviceGithubToken github access token for Appservice CLI github integration.
type AppserviceGithubToken struct {
	autorest.Response `json:"-"`
	// AccessToken - Github access token for Appservice CLI github integration
	AccessToken *string `json:"accessToken,omitempty"`
	// Scope - Scope of the github access token
	Scope *string `json:"scope,omitempty"`
	// TokenType - token type
	TokenType *string `json:"tokenType,omitempty"`
	// GotToken - True if valid github token received, False otherwise
	GotToken *bool `json:"gotToken,omitempty"`
	// ErrorMessage - Error message if unable to get token
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// AppserviceGithubTokenRequest appservice Github token request content.
type AppserviceGithubTokenRequest struct {
	// Code - Code string to exchange for Github Access token
	Code *string `json:"code,omitempty"`
	// State - State string used for verification.
	State *string `json:"state,omitempty"`
}

// AppServicePlan app Service plan.
type AppServicePlan struct {
	autorest.Response `json:"-"`
	// AppServicePlanProperties - AppServicePlan resource specific properties
	*AppServicePlanProperties `json:"properties,omitempty"`
	Sku                       *SkuDescription `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlan.
func (asp AppServicePlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.AppServicePlanProperties != nil {
		objectMap["properties"] = asp.AppServicePlanProperties
	}
	if asp.Sku != nil {
		objectMap["sku"] = asp.Sku
	}
	if asp.Kind != nil {
		objectMap["kind"] = asp.Kind
	}
	if asp.Location != nil {
		objectMap["location"] = asp.Location
	}
	if asp.Tags != nil {
		objectMap["tags"] = asp.Tags
	}
	if asp.SystemData != nil {
		objectMap["systemData"] = asp.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServicePlan struct.
func (asp *AppServicePlan) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServicePlanProperties AppServicePlanProperties
				err = json.Unmarshal(*v, &appServicePlanProperties)
				if err != nil {
					return err
				}
				asp.AppServicePlanProperties = &appServicePlanProperties
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				asp.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				asp.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asp.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asp.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asp.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServicePlanCollection collection of App Service plans.
type AppServicePlanCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AppServicePlan `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlanCollection.
func (aspc AppServicePlanCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aspc.Value != nil {
		objectMap["value"] = aspc.Value
	}
	return json.Marshal(objectMap)
}

// AppServicePlanCollectionIterator provides access to a complete listing of AppServicePlan values.
type AppServicePlanCollectionIterator struct {
	i    int
	page AppServicePlanCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AppServicePlanCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServicePlanCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AppServicePlanCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AppServicePlanCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AppServicePlanCollectionIterator) Response() AppServicePlanCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AppServicePlanCollectionIterator) Value() AppServicePlan {
	if !iter.page.NotDone() {
		return AppServicePlan{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AppServicePlanCollectionIterator type.
func NewAppServicePlanCollectionIterator(page AppServicePlanCollectionPage) AppServicePlanCollectionIterator {
	return AppServicePlanCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aspc AppServicePlanCollection) IsEmpty() bool {
	return aspc.Value == nil || len(*aspc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aspc AppServicePlanCollection) hasNextLink() bool {
	return aspc.NextLink != nil && len(*aspc.NextLink) != 0
}

// appServicePlanCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aspc AppServicePlanCollection) appServicePlanCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !aspc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aspc.NextLink)))
}

// AppServicePlanCollectionPage contains a page of AppServicePlan values.
type AppServicePlanCollectionPage struct {
	fn   func(context.Context, AppServicePlanCollection) (AppServicePlanCollection, error)
	aspc AppServicePlanCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AppServicePlanCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppServicePlanCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aspc)
		if err != nil {
			return err
		}
		page.aspc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AppServicePlanCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AppServicePlanCollectionPage) NotDone() bool {
	return !page.aspc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AppServicePlanCollectionPage) Response() AppServicePlanCollection {
	return page.aspc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AppServicePlanCollectionPage) Values() []AppServicePlan {
	if page.aspc.IsEmpty() {
		return nil
	}
	return *page.aspc.Value
}

// Creates a new instance of the AppServicePlanCollectionPage type.
func NewAppServicePlanCollectionPage(cur AppServicePlanCollection, getNextPage func(context.Context, AppServicePlanCollection) (AppServicePlanCollection, error)) AppServicePlanCollectionPage {
	return AppServicePlanCollectionPage{
		fn:   getNextPage,
		aspc: cur,
	}
}

// AppServicePlanPatchResource ARM resource for a app service plan.
type AppServicePlanPatchResource struct {
	// AppServicePlanPatchResourceProperties - AppServicePlanPatchResource resource specific properties
	*AppServicePlanPatchResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlanPatchResource.
func (asppr AppServicePlanPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asppr.AppServicePlanPatchResourceProperties != nil {
		objectMap["properties"] = asppr.AppServicePlanPatchResourceProperties
	}
	if asppr.Kind != nil {
		objectMap["kind"] = asppr.Kind
	}
	if asppr.SystemData != nil {
		objectMap["systemData"] = asppr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppServicePlanPatchResource struct.
func (asppr *AppServicePlanPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appServicePlanPatchResourceProperties AppServicePlanPatchResourceProperties
				err = json.Unmarshal(*v, &appServicePlanPatchResourceProperties)
				if err != nil {
					return err
				}
				asppr.AppServicePlanPatchResourceProperties = &appServicePlanPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				asppr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				asppr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				asppr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				asppr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				asppr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AppServicePlanPatchResourceProperties appServicePlanPatchResource resource specific properties
type AppServicePlanPatchResourceProperties struct {
	// WorkerTierName - Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`
	// Status - READ-ONLY; App Service plan status. Possible values include: 'StatusOptionsReady', 'StatusOptionsPending', 'StatusOptionsCreating'
	Status StatusOptions `json:"status,omitempty"`
	// Subscription - READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// MaximumNumberOfWorkers - READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty"`
	// GeoRegion - READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// PerSiteScaling - If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
	// If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`
	// MaximumElasticWorkerCount - Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`
	// NumberOfSites - READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty"`
	// IsSpot - If <code>true</code>, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`
	// SpotExpirationTime - The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *date.Time `json:"spotExpirationTime,omitempty"`
	// FreeOfferExpirationTime - The time when the server farm free offer expires.
	FreeOfferExpirationTime *date.Time `json:"freeOfferExpirationTime,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Reserved - This needs to set to <code>true</code> when creating a Linux App Service Plan, along with <code>kind</code> set to <code>Linux</code>. It should be <code>false</code> otherwise.
	Reserved *bool `json:"reserved,omitempty"`
	// IsXenon - Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`
	// HyperV - If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
	HyperV *bool `json:"hyperV,omitempty"`
	// TargetWorkerCount - Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`
	// TargetWorkerSizeID - Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlanPatchResourceProperties.
func (asppr AppServicePlanPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asppr.WorkerTierName != nil {
		objectMap["workerTierName"] = asppr.WorkerTierName
	}
	if asppr.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = asppr.HostingEnvironmentProfile
	}
	if asppr.PerSiteScaling != nil {
		objectMap["perSiteScaling"] = asppr.PerSiteScaling
	}
	if asppr.MaximumElasticWorkerCount != nil {
		objectMap["maximumElasticWorkerCount"] = asppr.MaximumElasticWorkerCount
	}
	if asppr.IsSpot != nil {
		objectMap["isSpot"] = asppr.IsSpot
	}
	if asppr.SpotExpirationTime != nil {
		objectMap["spotExpirationTime"] = asppr.SpotExpirationTime
	}
	if asppr.FreeOfferExpirationTime != nil {
		objectMap["freeOfferExpirationTime"] = asppr.FreeOfferExpirationTime
	}
	if asppr.Reserved != nil {
		objectMap["reserved"] = asppr.Reserved
	}
	if asppr.IsXenon != nil {
		objectMap["isXenon"] = asppr.IsXenon
	}
	if asppr.HyperV != nil {
		objectMap["hyperV"] = asppr.HyperV
	}
	if asppr.TargetWorkerCount != nil {
		objectMap["targetWorkerCount"] = asppr.TargetWorkerCount
	}
	if asppr.TargetWorkerSizeID != nil {
		objectMap["targetWorkerSizeId"] = asppr.TargetWorkerSizeID
	}
	return json.Marshal(objectMap)
}

// AppServicePlanProperties appServicePlan resource specific properties
type AppServicePlanProperties struct {
	// WorkerTierName - Target worker tier assigned to the App Service plan.
	WorkerTierName *string `json:"workerTierName,omitempty"`
	// Status - READ-ONLY; App Service plan status. Possible values include: 'StatusOptionsReady', 'StatusOptionsPending', 'StatusOptionsCreating'
	Status StatusOptions `json:"status,omitempty"`
	// Subscription - READ-ONLY; App Service plan subscription.
	Subscription *string `json:"subscription,omitempty"`
	// HostingEnvironmentProfile - Specification for the App Service Environment to use for the App Service plan.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// MaximumNumberOfWorkers - READ-ONLY; Maximum number of instances that can be assigned to this App Service plan.
	MaximumNumberOfWorkers *int32 `json:"maximumNumberOfWorkers,omitempty"`
	// GeoRegion - READ-ONLY; Geographical location for the App Service plan.
	GeoRegion *string `json:"geoRegion,omitempty"`
	// PerSiteScaling - If <code>true</code>, apps assigned to this App Service plan can be scaled independently.
	// If <code>false</code>, apps assigned to this App Service plan will scale to all instances of the plan.
	PerSiteScaling *bool `json:"perSiteScaling,omitempty"`
	// MaximumElasticWorkerCount - Maximum number of total workers allowed for this ElasticScaleEnabled App Service Plan
	MaximumElasticWorkerCount *int32 `json:"maximumElasticWorkerCount,omitempty"`
	// NumberOfSites - READ-ONLY; Number of apps assigned to this App Service plan.
	NumberOfSites *int32 `json:"numberOfSites,omitempty"`
	// IsSpot - If <code>true</code>, this App Service Plan owns spot instances.
	IsSpot *bool `json:"isSpot,omitempty"`
	// SpotExpirationTime - The time when the server farm expires. Valid only if it is a spot server farm.
	SpotExpirationTime *date.Time `json:"spotExpirationTime,omitempty"`
	// FreeOfferExpirationTime - The time when the server farm free offer expires.
	FreeOfferExpirationTime *date.Time `json:"freeOfferExpirationTime,omitempty"`
	// ResourceGroup - READ-ONLY; Resource group of the App Service plan.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// Reserved - If Linux app service plan <code>true</code>, <code>false</code> otherwise.
	Reserved *bool `json:"reserved,omitempty"`
	// IsXenon - Obsolete: If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
	IsXenon *bool `json:"isXenon,omitempty"`
	// HyperV - If Hyper-V container app service plan <code>true</code>, <code>false</code> otherwise.
	HyperV *bool `json:"hyperV,omitempty"`
	// TargetWorkerCount - Scaling worker count.
	TargetWorkerCount *int32 `json:"targetWorkerCount,omitempty"`
	// TargetWorkerSizeID - Scaling worker size ID.
	TargetWorkerSizeID *int32 `json:"targetWorkerSizeId,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the App Service Environment. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AppServicePlanProperties.
func (asp AppServicePlanProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.WorkerTierName != nil {
		objectMap["workerTierName"] = asp.WorkerTierName
	}
	if asp.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = asp.HostingEnvironmentProfile
	}
	if asp.PerSiteScaling != nil {
		objectMap["perSiteScaling"] = asp.PerSiteScaling
	}
	if asp.MaximumElasticWorkerCount != nil {
		objectMap["maximumElasticWorkerCount"] = asp.MaximumElasticWorkerCount
	}
	if asp.IsSpot != nil {
		objectMap["isSpot"] = asp.IsSpot
	}
	if asp.SpotExpirationTime != nil {
		objectMap["spotExpirationTime"] = asp.SpotExpirationTime
	}
	if asp.FreeOfferExpirationTime != nil {
		objectMap["freeOfferExpirationTime"] = asp.FreeOfferExpirationTime
	}
	if asp.Reserved != nil {
		objectMap["reserved"] = asp.Reserved
	}
	if asp.IsXenon != nil {
		objectMap["isXenon"] = asp.IsXenon
	}
	if asp.HyperV != nil {
		objectMap["hyperV"] = asp.HyperV
	}
	if asp.TargetWorkerCount != nil {
		objectMap["targetWorkerCount"] = asp.TargetWorkerCount
	}
	if asp.TargetWorkerSizeID != nil {
		objectMap["targetWorkerSizeId"] = asp.TargetWorkerSizeID
	}
	return json.Marshal(objectMap)
}

// AppServicePlansCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppServicePlansCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppServicePlansClient) (AppServicePlan, error)
}

// AppsInstallSiteExtensionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsInstallSiteExtensionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (SiteExtensionInfo, error)
}

// AppsInstallSiteExtensionSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsInstallSiteExtensionSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (SiteExtensionInfo, error)
}

// AppsListPublishingCredentialsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsListPublishingCredentialsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (User, error)
}

// AppsListPublishingCredentialsSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsListPublishingCredentialsSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (User, error)
}

// AppsMigrateMySQLFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsMigrateMySQLFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (Operation, error)
}

// AppsMigrateStorageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsMigrateStorageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (StorageMigrationResponse, error)
}

// AppsRestoreFromBackupBlobFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsRestoreFromBackupBlobFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreFromBackupBlobSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsRestoreFromBackupBlobSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreFromDeletedAppFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsRestoreFromDeletedAppFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreFromDeletedAppSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsRestoreFromDeletedAppSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type AppsRestoreFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsRestoreSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreSnapshotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsRestoreSnapshotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsRestoreSnapshotSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsRestoreSnapshotSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsStartNetworkTraceFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsStartNetworkTraceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (ListNetworkTrace, error)
}

// AppsStartNetworkTraceSlotFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsStartNetworkTraceSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (ListNetworkTrace, error)
}

// AppsStartWebSiteNetworkTraceOperationFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type AppsStartWebSiteNetworkTraceOperationFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (ListNetworkTrace, error)
}

// AppsStartWebSiteNetworkTraceOperationSlotFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type AppsStartWebSiteNetworkTraceOperationSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (ListNetworkTrace, error)
}

// AppsSwapSlotSlotFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppsSwapSlotSlotFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// AppsSwapSlotWithProductionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppsSwapSlotWithProductionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppsClient) (autorest.Response, error)
}

// ArmIDWrapper a wrapper for an ARM resource id
type ArmIDWrapper struct {
	// ID - READ-ONLY
	ID *string `json:"id,omitempty"`
}

// AuthPlatform ...
type AuthPlatform struct {
	// AuthPlatformProperties - AuthPlatform resource specific properties
	*AuthPlatformProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AuthPlatform.
func (ap AuthPlatform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AuthPlatformProperties != nil {
		objectMap["properties"] = ap.AuthPlatformProperties
	}
	if ap.Kind != nil {
		objectMap["kind"] = ap.Kind
	}
	if ap.SystemData != nil {
		objectMap["systemData"] = ap.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AuthPlatform struct.
func (ap *AuthPlatform) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var authPlatformProperties AuthPlatformProperties
				err = json.Unmarshal(*v, &authPlatformProperties)
				if err != nil {
					return err
				}
				ap.AuthPlatformProperties = &authPlatformProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ap.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ap.SystemData = &systemData
			}
		}
	}

	return nil
}

// AuthPlatformProperties authPlatform resource specific properties
type AuthPlatformProperties struct {
	Enabled        *bool   `json:"enabled,omitempty"`
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	ConfigFilePath *string `json:"configFilePath,omitempty"`
}

// AutoHealActions actions which to take by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	// ActionType - Predefined action to be taken. Possible values include: 'Recycle', 'LogEvent', 'CustomAction'
	ActionType AutoHealActionType `json:"actionType,omitempty"`
	// CustomAction - Custom action to be taken.
	CustomAction *AutoHealCustomAction `json:"customAction,omitempty"`
	// MinProcessExecutionTime - Minimum time the process must execute
	// before taking the action
	MinProcessExecutionTime *string `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction custom action to be executed
// when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	// Exe - Executable to be run.
	Exe *string `json:"exe,omitempty"`
	// Parameters - Parameters for the executable.
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules rules that can be defined for auto-heal.
type AutoHealRules struct {
	// Triggers - Conditions that describe when to execute the auto-heal actions.
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
	// Actions - Actions to be executed when a rule is triggered.
	Actions *AutoHealActions `json:"actions,omitempty"`
}

// AutoHealTriggers triggers for auto-heal.
type AutoHealTriggers struct {
	// Requests - A rule based on total requests.
	Requests *RequestsBasedTrigger `json:"requests,omitempty"`
	// PrivateBytesInKB - A rule based on private bytes.
	PrivateBytesInKB *int32 `json:"privateBytesInKB,omitempty"`
	// StatusCodes - A rule based on status codes.
	StatusCodes *[]StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
	// SlowRequests - A rule based on request execution time.
	SlowRequests *SlowRequestsBasedTrigger `json:"slowRequests,omitempty"`
}

// AzureActiveDirectory ...
type AzureActiveDirectory struct {
	// AzureActiveDirectoryProperties - AzureActiveDirectory resource specific properties
	*AzureActiveDirectoryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureActiveDirectory.
func (aad AzureActiveDirectory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aad.AzureActiveDirectoryProperties != nil {
		objectMap["properties"] = aad.AzureActiveDirectoryProperties
	}
	if aad.Kind != nil {
		objectMap["kind"] = aad.Kind
	}
	if aad.SystemData != nil {
		objectMap["systemData"] = aad.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureActiveDirectory struct.
func (aad *AzureActiveDirectory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureActiveDirectoryProperties AzureActiveDirectoryProperties
				err = json.Unmarshal(*v, &azureActiveDirectoryProperties)
				if err != nil {
					return err
				}
				aad.AzureActiveDirectoryProperties = &azureActiveDirectoryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aad.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aad.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aad.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aad.SystemData = &systemData
			}
		}
	}

	return nil
}

// AzureActiveDirectoryLogin ...
type AzureActiveDirectoryLogin struct {
	// AzureActiveDirectoryLoginProperties - AzureActiveDirectoryLogin resource specific properties
	*AzureActiveDirectoryLoginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureActiveDirectoryLogin.
func (aadl AzureActiveDirectoryLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aadl.AzureActiveDirectoryLoginProperties != nil {
		objectMap["properties"] = aadl.AzureActiveDirectoryLoginProperties
	}
	if aadl.Kind != nil {
		objectMap["kind"] = aadl.Kind
	}
	if aadl.SystemData != nil {
		objectMap["systemData"] = aadl.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureActiveDirectoryLogin struct.
func (aadl *AzureActiveDirectoryLogin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureActiveDirectoryLoginProperties AzureActiveDirectoryLoginProperties
				err = json.Unmarshal(*v, &azureActiveDirectoryLoginProperties)
				if err != nil {
					return err
				}
				aadl.AzureActiveDirectoryLoginProperties = &azureActiveDirectoryLoginProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aadl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aadl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aadl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aadl.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aadl.SystemData = &systemData
			}
		}
	}

	return nil
}

// AzureActiveDirectoryLoginProperties azureActiveDirectoryLogin resource specific properties
type AzureActiveDirectoryLoginProperties struct {
	DisableWWWAuthenticate *bool     `json:"disableWWWAuthenticate,omitempty"`
	LoginParameters        *[]string `json:"loginParameters,omitempty"`
}

// AzureActiveDirectoryProperties azureActiveDirectory resource specific properties
type AzureActiveDirectoryProperties struct {
	Enabled           *bool                             `json:"enabled,omitempty"`
	Registration      *AzureActiveDirectoryRegistration `json:"registration,omitempty"`
	Login             *AzureActiveDirectoryLogin        `json:"login,omitempty"`
	Validation        *AzureActiveDirectoryValidation   `json:"validation,omitempty"`
	IsAutoProvisioned *bool                             `json:"isAutoProvisioned,omitempty"`
}

// AzureActiveDirectoryRegistration ...
type AzureActiveDirectoryRegistration struct {
	// AzureActiveDirectoryRegistrationProperties - AzureActiveDirectoryRegistration resource specific properties
	*AzureActiveDirectoryRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureActiveDirectoryRegistration.
func (aadr AzureActiveDirectoryRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aadr.AzureActiveDirectoryRegistrationProperties != nil {
		objectMap["properties"] = aadr.AzureActiveDirectoryRegistrationProperties
	}
	if aadr.Kind != nil {
		objectMap["kind"] = aadr.Kind
	}
	if aadr.SystemData != nil {
		objectMap["systemData"] = aadr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureActiveDirectoryRegistration struct.
func (aadr *AzureActiveDirectoryRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureActiveDirectoryRegistrationProperties AzureActiveDirectoryRegistrationProperties
				err = json.Unmarshal(*v, &azureActiveDirectoryRegistrationProperties)
				if err != nil {
					return err
				}
				aadr.AzureActiveDirectoryRegistrationProperties = &azureActiveDirectoryRegistrationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aadr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aadr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aadr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aadr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aadr.SystemData = &systemData
			}
		}
	}

	return nil
}

// AzureActiveDirectoryRegistrationProperties azureActiveDirectoryRegistration resource specific properties
type AzureActiveDirectoryRegistrationProperties struct {
	OpenIDIssuer                      *string `json:"openIdIssuer,omitempty"`
	ClientID                          *string `json:"clientId,omitempty"`
	ClientSecretSettingName           *string `json:"clientSecretSettingName,omitempty"`
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`
}

// AzureActiveDirectoryValidation ...
type AzureActiveDirectoryValidation struct {
	// AzureActiveDirectoryValidationProperties - AzureActiveDirectoryValidation resource specific properties
	*AzureActiveDirectoryValidationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureActiveDirectoryValidation.
func (aadv AzureActiveDirectoryValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aadv.AzureActiveDirectoryValidationProperties != nil {
		objectMap["properties"] = aadv.AzureActiveDirectoryValidationProperties
	}
	if aadv.Kind != nil {
		objectMap["kind"] = aadv.Kind
	}
	if aadv.SystemData != nil {
		objectMap["systemData"] = aadv.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AzureActiveDirectoryValidation struct.
func (aadv *AzureActiveDirectoryValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var azureActiveDirectoryValidationProperties AzureActiveDirectoryValidationProperties
				err = json.Unmarshal(*v, &azureActiveDirectoryValidationProperties)
				if err != nil {
					return err
				}
				aadv.AzureActiveDirectoryValidationProperties = &azureActiveDirectoryValidationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				aadv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				aadv.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				aadv.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				aadv.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				aadv.SystemData = &systemData
			}
		}
	}

	return nil
}

// AzureActiveDirectoryValidationProperties azureActiveDirectoryValidation resource specific properties
type AzureActiveDirectoryValidationProperties struct {
	JwtClaimChecks   *JwtClaimChecks `json:"jwtClaimChecks,omitempty"`
	AllowedAudiences *[]string       `json:"allowedAudiences,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig application logs azure blob storage configuration.
type AzureBlobStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove blobs older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig http logs to azure blob storage configuration.
type AzureBlobStorageHTTPLogsConfig struct {
	// SasURL - SAS url to a azure blob container with read/write/list/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove blobs older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// AzureStorageInfoValue azure Files or Blob Storage access information value for dictionary storage.
type AzureStorageInfoValue struct {
	// Type - Type of storage. Possible values include: 'AzureFiles', 'AzureBlob'
	Type AzureStorageType `json:"type,omitempty"`
	// AccountName - Name of the storage account.
	AccountName *string `json:"accountName,omitempty"`
	// ShareName - Name of the file share (container name, for Blob storage).
	ShareName *string `json:"shareName,omitempty"`
	// AccessKey - Access key for the storage account.
	AccessKey *string `json:"accessKey,omitempty"`
	// MountPath - Path to mount the storage within the site's runtime environment.
	MountPath *string `json:"mountPath,omitempty"`
	// State - READ-ONLY; State of the storage account. Possible values include: 'Ok', 'InvalidCredentials', 'InvalidShare'
	State AzureStorageState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStorageInfoValue.
func (asiv AzureStorageInfoValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asiv.Type != "" {
		objectMap["type"] = asiv.Type
	}
	if asiv.AccountName != nil {
		objectMap["accountName"] = asiv.AccountName
	}
	if asiv.ShareName != nil {
		objectMap["shareName"] = asiv.ShareName
	}
	if asiv.AccessKey != nil {
		objectMap["accessKey"] = asiv.AccessKey
	}
	if asiv.MountPath != nil {
		objectMap["mountPath"] = asiv.MountPath
	}
	return json.Marshal(objectMap)
}

// AzureStoragePropertyDictionaryResource azureStorageInfo dictionary resource.
type AzureStoragePropertyDictionaryResource struct {
	autorest.Response `json:"-"`
	// Properties - Azure storage accounts.
	Properties map[string]*AzureStorageInfoValue `json:"properties"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureStoragePropertyDictionaryResource.
func (aspdr AzureStoragePropertyDictionaryResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aspdr.Properties != nil {
		objectMap["properties"] = aspdr.Properties
	}
	if aspdr.Kind != nil {
		objectMap["kind"] = aspdr.Kind
	}
	if aspdr.SystemData != nil {
		objectMap["systemData"] = aspdr.SystemData
	}
	return json.Marshal(objectMap)
}

// AzureTableStorageApplicationLogsConfig application logs to Azure table storage configuration.
type AzureTableStorageApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
	// SasURL - SAS URL to an Azure table with add/query/delete permissions.
	SasURL *string `json:"sasUrl,omitempty"`
}

// BackupItem backup description.
type BackupItem struct {
	autorest.Response `json:"-"`
	// BackupItemProperties - BackupItem resource specific properties
	*BackupItemProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupItem.
func (bi BackupItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bi.BackupItemProperties != nil {
		objectMap["properties"] = bi.BackupItemProperties
	}
	if bi.Kind != nil {
		objectMap["kind"] = bi.Kind
	}
	if bi.SystemData != nil {
		objectMap["systemData"] = bi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupItem struct.
func (bi *BackupItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupItemProperties BackupItemProperties
				err = json.Unmarshal(*v, &backupItemProperties)
				if err != nil {
					return err
				}
				bi.BackupItemProperties = &backupItemProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bi.SystemData = &systemData
			}
		}
	}

	return nil
}

// BackupItemCollection collection of backup items.
type BackupItemCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]BackupItem `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupItemCollection.
func (bic BackupItemCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bic.Value != nil {
		objectMap["value"] = bic.Value
	}
	return json.Marshal(objectMap)
}

// BackupItemCollectionIterator provides access to a complete listing of BackupItem values.
type BackupItemCollectionIterator struct {
	i    int
	page BackupItemCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BackupItemCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BackupItemCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BackupItemCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BackupItemCollectionIterator) Response() BackupItemCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BackupItemCollectionIterator) Value() BackupItem {
	if !iter.page.NotDone() {
		return BackupItem{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BackupItemCollectionIterator type.
func NewBackupItemCollectionIterator(page BackupItemCollectionPage) BackupItemCollectionIterator {
	return BackupItemCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bic BackupItemCollection) IsEmpty() bool {
	return bic.Value == nil || len(*bic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bic BackupItemCollection) hasNextLink() bool {
	return bic.NextLink != nil && len(*bic.NextLink) != 0
}

// backupItemCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bic BackupItemCollection) backupItemCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bic.NextLink)))
}

// BackupItemCollectionPage contains a page of BackupItem values.
type BackupItemCollectionPage struct {
	fn  func(context.Context, BackupItemCollection) (BackupItemCollection, error)
	bic BackupItemCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BackupItemCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BackupItemCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bic)
		if err != nil {
			return err
		}
		page.bic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BackupItemCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BackupItemCollectionPage) NotDone() bool {
	return !page.bic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BackupItemCollectionPage) Response() BackupItemCollection {
	return page.bic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BackupItemCollectionPage) Values() []BackupItem {
	if page.bic.IsEmpty() {
		return nil
	}
	return *page.bic.Value
}

// Creates a new instance of the BackupItemCollectionPage type.
func NewBackupItemCollectionPage(cur BackupItemCollection, getNextPage func(context.Context, BackupItemCollection) (BackupItemCollection, error)) BackupItemCollectionPage {
	return BackupItemCollectionPage{
		fn:  getNextPage,
		bic: cur,
	}
}

// BackupItemProperties backupItem resource specific properties
type BackupItemProperties struct {
	// BackupID - READ-ONLY; Id of the backup.
	BackupID *int32 `json:"id,omitempty"`
	// StorageAccountURL - READ-ONLY; SAS URL for the storage account container which contains this backup.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - READ-ONLY; Name of the blob which contains data for this backup.
	BlobName *string `json:"blobName,omitempty"`
	// Name - READ-ONLY; Name of this backup.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Backup status. Possible values include: 'InProgress', 'Failed', 'Succeeded', 'TimedOut', 'Created', 'Skipped', 'PartiallySucceeded', 'DeleteInProgress', 'DeleteFailed', 'Deleted'
	Status BackupItemStatus `json:"status,omitempty"`
	// SizeInBytes - READ-ONLY; Size of the backup in bytes.
	SizeInBytes *int64 `json:"sizeInBytes,omitempty"`
	// Created - READ-ONLY; Timestamp of the backup creation.
	Created *date.Time `json:"created,omitempty"`
	// Log - READ-ONLY; Details regarding this backup. Might contain an error message.
	Log *string `json:"log,omitempty"`
	// Databases - READ-ONLY; List of databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// Scheduled - READ-ONLY; True if this backup has been created due to a schedule being triggered.
	Scheduled *bool `json:"scheduled,omitempty"`
	// LastRestoreTimeStamp - READ-ONLY; Timestamp of a last restore operation which used this backup.
	LastRestoreTimeStamp *date.Time `json:"lastRestoreTimeStamp,omitempty"`
	// FinishedTimeStamp - READ-ONLY; Timestamp when this backup finished.
	FinishedTimeStamp *date.Time `json:"finishedTimeStamp,omitempty"`
	// CorrelationID - READ-ONLY; Unique correlation identifier. Please use this along with the timestamp while communicating with Azure support.
	CorrelationID *string `json:"correlationId,omitempty"`
	// WebsiteSizeInBytes - READ-ONLY; Size of the original web app which has been backed up.
	WebsiteSizeInBytes *int64 `json:"websiteSizeInBytes,omitempty"`
}

// BackupRequest description of a backup which will be performed.
type BackupRequest struct {
	autorest.Response `json:"-"`
	// BackupRequestProperties - BackupRequest resource specific properties
	*BackupRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupRequest.
func (br BackupRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if br.BackupRequestProperties != nil {
		objectMap["properties"] = br.BackupRequestProperties
	}
	if br.Kind != nil {
		objectMap["kind"] = br.Kind
	}
	if br.SystemData != nil {
		objectMap["systemData"] = br.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupRequest struct.
func (br *BackupRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var backupRequestProperties BackupRequestProperties
				err = json.Unmarshal(*v, &backupRequestProperties)
				if err != nil {
					return err
				}
				br.BackupRequestProperties = &backupRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				br.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				br.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				br.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				br.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				br.SystemData = &systemData
			}
		}
	}

	return nil
}

// BackupRequestProperties backupRequest resource specific properties
type BackupRequestProperties struct {
	// BackupName - Name of the backup.
	BackupName *string `json:"backupName,omitempty"`
	// Enabled - True if the backup schedule is enabled (must be included in that case), false if the backup schedule should be disabled.
	Enabled *bool `json:"enabled,omitempty"`
	// StorageAccountURL - SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BackupSchedule - Schedule for the backup if it is executed periodically.
	BackupSchedule *BackupSchedule `json:"backupSchedule,omitempty"`
	// Databases - Databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
}

// BackupSchedule description of a backup schedule. Describes how often should be the backup performed and
// what should be the retention policy.
type BackupSchedule struct {
	// FrequencyInterval - How often the backup should be executed (e.g. for weekly backup, this should be set to 7 and FrequencyUnit should be set to Day)
	FrequencyInterval *int32 `json:"frequencyInterval,omitempty"`
	// FrequencyUnit - The unit of time for how often the backup should be executed (e.g. for weekly backup, this should be set to Day and FrequencyInterval should be set to 7). Possible values include: 'Day', 'Hour'
	FrequencyUnit FrequencyUnit `json:"frequencyUnit,omitempty"`
	// KeepAtLeastOneBackup - True if the retention policy should always keep at least one backup in the storage account, regardless how old it is; false otherwise.
	KeepAtLeastOneBackup *bool `json:"keepAtLeastOneBackup,omitempty"`
	// RetentionPeriodInDays - After how many days backups should be deleted.
	RetentionPeriodInDays *int32 `json:"retentionPeriodInDays,omitempty"`
	// StartTime - When the schedule should start working.
	StartTime *date.Time `json:"startTime,omitempty"`
	// LastExecutionTime - READ-ONLY; Last time when this schedule was triggered.
	LastExecutionTime *date.Time `json:"lastExecutionTime,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupSchedule.
func (bs BackupSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.FrequencyInterval != nil {
		objectMap["frequencyInterval"] = bs.FrequencyInterval
	}
	if bs.FrequencyUnit != "" {
		objectMap["frequencyUnit"] = bs.FrequencyUnit
	}
	if bs.KeepAtLeastOneBackup != nil {
		objectMap["keepAtLeastOneBackup"] = bs.KeepAtLeastOneBackup
	}
	if bs.RetentionPeriodInDays != nil {
		objectMap["retentionPeriodInDays"] = bs.RetentionPeriodInDays
	}
	if bs.StartTime != nil {
		objectMap["startTime"] = bs.StartTime
	}
	return json.Marshal(objectMap)
}

// BillingMeter app Service billing entity that contains information about meter which the Azure billing
// system utilizes to charge users for services.
type BillingMeter struct {
	// BillingMeterProperties - BillingMeter resource specific properties
	*BillingMeterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BillingMeter.
func (bm BillingMeter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bm.BillingMeterProperties != nil {
		objectMap["properties"] = bm.BillingMeterProperties
	}
	if bm.Kind != nil {
		objectMap["kind"] = bm.Kind
	}
	if bm.SystemData != nil {
		objectMap["systemData"] = bm.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BillingMeter struct.
func (bm *BillingMeter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var billingMeterProperties BillingMeterProperties
				err = json.Unmarshal(*v, &billingMeterProperties)
				if err != nil {
					return err
				}
				bm.BillingMeterProperties = &billingMeterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bm.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bm.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bm.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bm.SystemData = &systemData
			}
		}
	}

	return nil
}

// BillingMeterCollection collection of Billing Meters
type BillingMeterCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]BillingMeter `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for BillingMeterCollection.
func (bmc BillingMeterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bmc.Value != nil {
		objectMap["value"] = bmc.Value
	}
	return json.Marshal(objectMap)
}

// BillingMeterCollectionIterator provides access to a complete listing of BillingMeter values.
type BillingMeterCollectionIterator struct {
	i    int
	page BillingMeterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *BillingMeterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BillingMeterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *BillingMeterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter BillingMeterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter BillingMeterCollectionIterator) Response() BillingMeterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter BillingMeterCollectionIterator) Value() BillingMeter {
	if !iter.page.NotDone() {
		return BillingMeter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the BillingMeterCollectionIterator type.
func NewBillingMeterCollectionIterator(page BillingMeterCollectionPage) BillingMeterCollectionIterator {
	return BillingMeterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (bmc BillingMeterCollection) IsEmpty() bool {
	return bmc.Value == nil || len(*bmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (bmc BillingMeterCollection) hasNextLink() bool {
	return bmc.NextLink != nil && len(*bmc.NextLink) != 0
}

// billingMeterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (bmc BillingMeterCollection) billingMeterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !bmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(bmc.NextLink)))
}

// BillingMeterCollectionPage contains a page of BillingMeter values.
type BillingMeterCollectionPage struct {
	fn  func(context.Context, BillingMeterCollection) (BillingMeterCollection, error)
	bmc BillingMeterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *BillingMeterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BillingMeterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.bmc)
		if err != nil {
			return err
		}
		page.bmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *BillingMeterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page BillingMeterCollectionPage) NotDone() bool {
	return !page.bmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page BillingMeterCollectionPage) Response() BillingMeterCollection {
	return page.bmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page BillingMeterCollectionPage) Values() []BillingMeter {
	if page.bmc.IsEmpty() {
		return nil
	}
	return *page.bmc.Value
}

// Creates a new instance of the BillingMeterCollectionPage type.
func NewBillingMeterCollectionPage(cur BillingMeterCollection, getNextPage func(context.Context, BillingMeterCollection) (BillingMeterCollection, error)) BillingMeterCollectionPage {
	return BillingMeterCollectionPage{
		fn:  getNextPage,
		bmc: cur,
	}
}

// BillingMeterProperties billingMeter resource specific properties
type BillingMeterProperties struct {
	// MeterID - Meter GUID onboarded in Commerce
	MeterID *string `json:"meterId,omitempty"`
	// BillingLocation - Azure Location of billable resource
	BillingLocation *string `json:"billingLocation,omitempty"`
	// ShortName - Short Name from App Service Azure pricing Page
	ShortName *string `json:"shortName,omitempty"`
	// FriendlyName - Friendly name of the meter
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ResourceType - App Service ResourceType meter used for
	ResourceType *string `json:"resourceType,omitempty"`
	// OsType - App Service OS type meter used for
	OsType *string `json:"osType,omitempty"`
}

// BlobStorageTokenStore ...
type BlobStorageTokenStore struct {
	// BlobStorageTokenStoreProperties - BlobStorageTokenStore resource specific properties
	*BlobStorageTokenStoreProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BlobStorageTokenStore.
func (bsts BlobStorageTokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bsts.BlobStorageTokenStoreProperties != nil {
		objectMap["properties"] = bsts.BlobStorageTokenStoreProperties
	}
	if bsts.Kind != nil {
		objectMap["kind"] = bsts.Kind
	}
	if bsts.SystemData != nil {
		objectMap["systemData"] = bsts.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BlobStorageTokenStore struct.
func (bsts *BlobStorageTokenStore) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var blobStorageTokenStoreProperties BlobStorageTokenStoreProperties
				err = json.Unmarshal(*v, &blobStorageTokenStoreProperties)
				if err != nil {
					return err
				}
				bsts.BlobStorageTokenStoreProperties = &blobStorageTokenStoreProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bsts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bsts.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				bsts.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bsts.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bsts.SystemData = &systemData
			}
		}
	}

	return nil
}

// BlobStorageTokenStoreProperties blobStorageTokenStore resource specific properties
type BlobStorageTokenStoreProperties struct {
	SasURLSettingName *string `json:"sasUrlSettingName,omitempty"`
}

// Capability describes the capabilities/features allowed for a specific SKU.
type Capability struct {
	// Name - Name of the SKU capability.
	Name *string `json:"name,omitempty"`
	// Value - Value of the SKU capability.
	Value *string `json:"value,omitempty"`
	// Reason - Reason of the SKU capability.
	Reason *string `json:"reason,omitempty"`
}

// Certificate SSL certificate for an app.
type Certificate struct {
	autorest.Response `json:"-"`
	// CertificateProperties - Certificate resource specific properties
	*CertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Certificate.
func (c Certificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.CertificateProperties != nil {
		objectMap["properties"] = c.CertificateProperties
	}
	if c.Kind != nil {
		objectMap["kind"] = c.Kind
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.SystemData != nil {
		objectMap["systemData"] = c.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Certificate struct.
func (c *Certificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateProperties CertificateProperties
				err = json.Unmarshal(*v, &certificateProperties)
				if err != nil {
					return err
				}
				c.CertificateProperties = &certificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				c.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		}
	}

	return nil
}

// CertificateCollection collection of certificates.
type CertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Certificate `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateCollection.
func (cc CertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.Value != nil {
		objectMap["value"] = cc.Value
	}
	return json.Marshal(objectMap)
}

// CertificateCollectionIterator provides access to a complete listing of Certificate values.
type CertificateCollectionIterator struct {
	i    int
	page CertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CertificateCollectionIterator) Response() CertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CertificateCollectionIterator) Value() Certificate {
	if !iter.page.NotDone() {
		return Certificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CertificateCollectionIterator type.
func NewCertificateCollectionIterator(page CertificateCollectionPage) CertificateCollectionIterator {
	return CertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cc CertificateCollection) IsEmpty() bool {
	return cc.Value == nil || len(*cc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cc CertificateCollection) hasNextLink() bool {
	return cc.NextLink != nil && len(*cc.NextLink) != 0
}

// certificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cc CertificateCollection) certificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cc.NextLink)))
}

// CertificateCollectionPage contains a page of Certificate values.
type CertificateCollectionPage struct {
	fn func(context.Context, CertificateCollection) (CertificateCollection, error)
	cc CertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cc)
		if err != nil {
			return err
		}
		page.cc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CertificateCollectionPage) NotDone() bool {
	return !page.cc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CertificateCollectionPage) Response() CertificateCollection {
	return page.cc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CertificateCollectionPage) Values() []Certificate {
	if page.cc.IsEmpty() {
		return nil
	}
	return *page.cc.Value
}

// Creates a new instance of the CertificateCollectionPage type.
func NewCertificateCollectionPage(cur CertificateCollection, getNextPage func(context.Context, CertificateCollection) (CertificateCollection, error)) CertificateCollectionPage {
	return CertificateCollectionPage{
		fn: getNextPage,
		cc: cur,
	}
}

// CertificateDetails SSL certificate details.
type CertificateDetails struct {
	// Version - READ-ONLY; Certificate Version.
	Version *int32 `json:"version,omitempty"`
	// SerialNumber - READ-ONLY; Certificate Serial Number.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// Thumbprint - READ-ONLY; Certificate Thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Subject - READ-ONLY; Certificate Subject.
	Subject *string `json:"subject,omitempty"`
	// NotBefore - READ-ONLY; Date Certificate is valid from.
	NotBefore *date.Time `json:"notBefore,omitempty"`
	// NotAfter - READ-ONLY; Date Certificate is valid to.
	NotAfter *date.Time `json:"notAfter,omitempty"`
	// SignatureAlgorithm - READ-ONLY; Certificate Signature algorithm.
	SignatureAlgorithm *string `json:"signatureAlgorithm,omitempty"`
	// Issuer - READ-ONLY; Certificate Issuer.
	Issuer *string `json:"issuer,omitempty"`
	// RawData - READ-ONLY; Raw certificate data.
	RawData *string `json:"rawData,omitempty"`
}

// CertificateEmail SSL certificate email.
type CertificateEmail struct {
	// CertificateEmailProperties - CertificateEmail resource specific properties
	*CertificateEmailProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateEmail.
func (ce CertificateEmail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CertificateEmailProperties != nil {
		objectMap["properties"] = ce.CertificateEmailProperties
	}
	if ce.Kind != nil {
		objectMap["kind"] = ce.Kind
	}
	if ce.SystemData != nil {
		objectMap["systemData"] = ce.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateEmail struct.
func (ce *CertificateEmail) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateEmailProperties CertificateEmailProperties
				err = json.Unmarshal(*v, &certificateEmailProperties)
				if err != nil {
					return err
				}
				ce.CertificateEmailProperties = &certificateEmailProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ce.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ce.SystemData = &systemData
			}
		}
	}

	return nil
}

// CertificateEmailProperties certificateEmail resource specific properties
type CertificateEmailProperties struct {
	// EmailID - Email id.
	EmailID *string `json:"emailId,omitempty"`
	// TimeStamp - Time stamp.
	TimeStamp *date.Time `json:"timeStamp,omitempty"`
}

// CertificateOrderAction certificate order action.
type CertificateOrderAction struct {
	// CertificateOrderActionProperties - CertificateOrderAction resource specific properties
	*CertificateOrderActionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateOrderAction.
func (coa CertificateOrderAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coa.CertificateOrderActionProperties != nil {
		objectMap["properties"] = coa.CertificateOrderActionProperties
	}
	if coa.Kind != nil {
		objectMap["kind"] = coa.Kind
	}
	if coa.SystemData != nil {
		objectMap["systemData"] = coa.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificateOrderAction struct.
func (coa *CertificateOrderAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificateOrderActionProperties CertificateOrderActionProperties
				err = json.Unmarshal(*v, &certificateOrderActionProperties)
				if err != nil {
					return err
				}
				coa.CertificateOrderActionProperties = &certificateOrderActionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coa.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				coa.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coa.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				coa.SystemData = &systemData
			}
		}
	}

	return nil
}

// CertificateOrderActionProperties certificateOrderAction resource specific properties
type CertificateOrderActionProperties struct {
	// ActionType - READ-ONLY; Action type. Possible values include: 'CertificateIssued', 'CertificateOrderCanceled', 'CertificateOrderCreated', 'CertificateRevoked', 'DomainValidationComplete', 'FraudDetected', 'OrgNameChange', 'OrgValidationComplete', 'SanDrop', 'FraudCleared', 'CertificateExpired', 'CertificateExpirationWarning', 'FraudDocumentationRequired', 'Unknown'
	ActionType CertificateOrderActionType `json:"actionType,omitempty"`
	// CreatedAt - READ-ONLY; Time at which the certificate action was performed.
	CreatedAt *date.Time `json:"createdAt,omitempty"`
}

// CertificatePatchResource ARM resource for a certificate.
type CertificatePatchResource struct {
	// CertificatePatchResourceProperties - CertificatePatchResource resource specific properties
	*CertificatePatchResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificatePatchResource.
func (cpr CertificatePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpr.CertificatePatchResourceProperties != nil {
		objectMap["properties"] = cpr.CertificatePatchResourceProperties
	}
	if cpr.Kind != nil {
		objectMap["kind"] = cpr.Kind
	}
	if cpr.SystemData != nil {
		objectMap["systemData"] = cpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CertificatePatchResource struct.
func (cpr *CertificatePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var certificatePatchResourceProperties CertificatePatchResourceProperties
				err = json.Unmarshal(*v, &certificatePatchResourceProperties)
				if err != nil {
					return err
				}
				cpr.CertificatePatchResourceProperties = &certificatePatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// CertificatePatchResourceProperties certificatePatchResource resource specific properties
type CertificatePatchResourceProperties struct {
	// FriendlyName - READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// SubjectName - READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// HostNames - Host names the certificate applies to.
	HostNames *[]string `json:"hostNames,omitempty"`
	// PfxBlob - Pfx blob.
	PfxBlob *[]byte `json:"pfxBlob,omitempty"`
	// SiteName - READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty"`
	// SelfLink - READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty"`
	// Issuer - READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// IssueDate - READ-ONLY; Certificate issue Date.
	IssueDate *date.Time `json:"issueDate,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Password - Certificate password.
	Password *string `json:"password,omitempty"`
	// Thumbprint - READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Valid - READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty"`
	// CerBlob - READ-ONLY; Raw bytes of .cer file
	CerBlob *[]byte `json:"cerBlob,omitempty"`
	// PublicKeyHash - READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironmentProfile - READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// KeyVaultID - Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// KeyVaultSecretStatus - READ-ONLY; Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	KeyVaultSecretStatus KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// CanonicalName - CNAME of the certificate to be issued via free certificate
	CanonicalName *string `json:"canonicalName,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificatePatchResourceProperties.
func (cpr CertificatePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpr.HostNames != nil {
		objectMap["hostNames"] = cpr.HostNames
	}
	if cpr.PfxBlob != nil {
		objectMap["pfxBlob"] = cpr.PfxBlob
	}
	if cpr.Password != nil {
		objectMap["password"] = cpr.Password
	}
	if cpr.KeyVaultID != nil {
		objectMap["keyVaultId"] = cpr.KeyVaultID
	}
	if cpr.KeyVaultSecretName != nil {
		objectMap["keyVaultSecretName"] = cpr.KeyVaultSecretName
	}
	if cpr.ServerFarmID != nil {
		objectMap["serverFarmId"] = cpr.ServerFarmID
	}
	if cpr.CanonicalName != nil {
		objectMap["canonicalName"] = cpr.CanonicalName
	}
	return json.Marshal(objectMap)
}

// CertificateProperties certificate resource specific properties
type CertificateProperties struct {
	// FriendlyName - READ-ONLY; Friendly name of the certificate.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// SubjectName - READ-ONLY; Subject name of the certificate.
	SubjectName *string `json:"subjectName,omitempty"`
	// HostNames - Host names the certificate applies to.
	HostNames *[]string `json:"hostNames,omitempty"`
	// PfxBlob - Pfx blob.
	PfxBlob *[]byte `json:"pfxBlob,omitempty"`
	// SiteName - READ-ONLY; App name.
	SiteName *string `json:"siteName,omitempty"`
	// SelfLink - READ-ONLY; Self link.
	SelfLink *string `json:"selfLink,omitempty"`
	// Issuer - READ-ONLY; Certificate issuer.
	Issuer *string `json:"issuer,omitempty"`
	// IssueDate - READ-ONLY; Certificate issue Date.
	IssueDate *date.Time `json:"issueDate,omitempty"`
	// ExpirationDate - READ-ONLY; Certificate expiration date.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// Password - Certificate password.
	Password *string `json:"password,omitempty"`
	// Thumbprint - READ-ONLY; Certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// Valid - READ-ONLY; Is the certificate valid?.
	Valid *bool `json:"valid,omitempty"`
	// CerBlob - READ-ONLY; Raw bytes of .cer file
	CerBlob *[]byte `json:"cerBlob,omitempty"`
	// PublicKeyHash - READ-ONLY; Public key hash.
	PublicKeyHash *string `json:"publicKeyHash,omitempty"`
	// HostingEnvironmentProfile - READ-ONLY; Specification for the App Service Environment to use for the certificate.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// KeyVaultID - Key Vault Csm resource Id.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyVaultSecretName - Key Vault secret name.
	KeyVaultSecretName *string `json:"keyVaultSecretName,omitempty"`
	// KeyVaultSecretStatus - READ-ONLY; Status of the Key Vault secret. Possible values include: 'KeyVaultSecretStatusInitialized', 'KeyVaultSecretStatusWaitingOnCertificateOrder', 'KeyVaultSecretStatusSucceeded', 'KeyVaultSecretStatusCertificateOrderFailed', 'KeyVaultSecretStatusOperationNotPermittedOnKeyVault', 'KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault', 'KeyVaultSecretStatusKeyVaultDoesNotExist', 'KeyVaultSecretStatusKeyVaultSecretDoesNotExist', 'KeyVaultSecretStatusUnknownError', 'KeyVaultSecretStatusExternalPrivateKey', 'KeyVaultSecretStatusUnknown'
	KeyVaultSecretStatus KeyVaultSecretStatus `json:"keyVaultSecretStatus,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// CanonicalName - CNAME of the certificate to be issued via free certificate
	CanonicalName *string `json:"canonicalName,omitempty"`
}

// MarshalJSON is the custom marshaler for CertificateProperties.
func (c CertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.HostNames != nil {
		objectMap["hostNames"] = c.HostNames
	}
	if c.PfxBlob != nil {
		objectMap["pfxBlob"] = c.PfxBlob
	}
	if c.Password != nil {
		objectMap["password"] = c.Password
	}
	if c.KeyVaultID != nil {
		objectMap["keyVaultId"] = c.KeyVaultID
	}
	if c.KeyVaultSecretName != nil {
		objectMap["keyVaultSecretName"] = c.KeyVaultSecretName
	}
	if c.ServerFarmID != nil {
		objectMap["serverFarmId"] = c.ServerFarmID
	}
	if c.CanonicalName != nil {
		objectMap["canonicalName"] = c.CanonicalName
	}
	return json.Marshal(objectMap)
}

// ClientRegistration ...
type ClientRegistration struct {
	// ClientRegistrationProperties - ClientRegistration resource specific properties
	*ClientRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ClientRegistration.
func (cr ClientRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.ClientRegistrationProperties != nil {
		objectMap["properties"] = cr.ClientRegistrationProperties
	}
	if cr.Kind != nil {
		objectMap["kind"] = cr.Kind
	}
	if cr.SystemData != nil {
		objectMap["systemData"] = cr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClientRegistration struct.
func (cr *ClientRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clientRegistrationProperties ClientRegistrationProperties
				err = json.Unmarshal(*v, &clientRegistrationProperties)
				if err != nil {
					return err
				}
				cr.ClientRegistrationProperties = &clientRegistrationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cr.SystemData = &systemData
			}
		}
	}

	return nil
}

// ClientRegistrationProperties clientRegistration resource specific properties
type ClientRegistrationProperties struct {
	ClientID                *string `json:"clientId,omitempty"`
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
}

// CloningInfo information needed for cloning operation.
type CloningInfo struct {
	// CorrelationID - Correlation ID of cloning operation. This ID ties multiple cloning operations
	// together to use the same snapshot.
	CorrelationID *uuid.UUID `json:"correlationId,omitempty"`
	// Overwrite - <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
	Overwrite *bool `json:"overwrite,omitempty"`
	// CloneCustomHostNames - <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
	CloneCustomHostNames *bool `json:"cloneCustomHostNames,omitempty"`
	// CloneSourceControl - <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
	CloneSourceControl *bool `json:"cloneSourceControl,omitempty"`
	// SourceWebAppID - ARM resource ID of the source app. App resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
	SourceWebAppID *string `json:"sourceWebAppId,omitempty"`
	// SourceWebAppLocation - Location of source app ex: West US or North Europe
	SourceWebAppLocation *string `json:"sourceWebAppLocation,omitempty"`
	// HostingEnvironment - App Service Environment.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
	// AppSettingsOverrides - Application setting overrides for cloned app. If specified, these settings override the settings cloned
	// from source app. Otherwise, application settings from source app are retained.
	AppSettingsOverrides map[string]*string `json:"appSettingsOverrides"`
	// ConfigureLoadBalancing - <code>true</code> to configure load balancing for source and destination app.
	ConfigureLoadBalancing *bool `json:"configureLoadBalancing,omitempty"`
	// TrafficManagerProfileID - ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
	TrafficManagerProfileID *string `json:"trafficManagerProfileId,omitempty"`
	// TrafficManagerProfileName - Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
	TrafficManagerProfileName *string `json:"trafficManagerProfileName,omitempty"`
}

// MarshalJSON is the custom marshaler for CloningInfo.
func (ci CloningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ci.CorrelationID != nil {
		objectMap["correlationId"] = ci.CorrelationID
	}
	if ci.Overwrite != nil {
		objectMap["overwrite"] = ci.Overwrite
	}
	if ci.CloneCustomHostNames != nil {
		objectMap["cloneCustomHostNames"] = ci.CloneCustomHostNames
	}
	if ci.CloneSourceControl != nil {
		objectMap["cloneSourceControl"] = ci.CloneSourceControl
	}
	if ci.SourceWebAppID != nil {
		objectMap["sourceWebAppId"] = ci.SourceWebAppID
	}
	if ci.SourceWebAppLocation != nil {
		objectMap["sourceWebAppLocation"] = ci.SourceWebAppLocation
	}
	if ci.HostingEnvironment != nil {
		objectMap["hostingEnvironment"] = ci.HostingEnvironment
	}
	if ci.AppSettingsOverrides != nil {
		objectMap["appSettingsOverrides"] = ci.AppSettingsOverrides
	}
	if ci.ConfigureLoadBalancing != nil {
		objectMap["configureLoadBalancing"] = ci.ConfigureLoadBalancing
	}
	if ci.TrafficManagerProfileID != nil {
		objectMap["trafficManagerProfileId"] = ci.TrafficManagerProfileID
	}
	if ci.TrafficManagerProfileName != nil {
		objectMap["trafficManagerProfileName"] = ci.TrafficManagerProfileName
	}
	return json.Marshal(objectMap)
}

// ConnectionStringDictionary string dictionary resource.
type ConnectionStringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Connection strings.
	Properties map[string]*ConnStringValueTypePair `json:"properties"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectionStringDictionary.
func (csd ConnectionStringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if csd.Properties != nil {
		objectMap["properties"] = csd.Properties
	}
	if csd.Kind != nil {
		objectMap["kind"] = csd.Kind
	}
	if csd.SystemData != nil {
		objectMap["systemData"] = csd.SystemData
	}
	return json.Marshal(objectMap)
}

// ConnStringInfo database connection string information.
type ConnStringInfo struct {
	// Name - Name of connection string.
	Name *string `json:"name,omitempty"`
	// ConnectionString - Connection string value.
	ConnectionString *string `json:"connectionString,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus', 'EventHub', 'APIHub', 'DocDb', 'RedisCache', 'PostgreSQL'
	Type ConnectionStringType `json:"type,omitempty"`
}

// ConnStringValueTypePair database connection string value to type pair.
type ConnStringValueTypePair struct {
	// Value - Value of pair.
	Value *string `json:"value,omitempty"`
	// Type - Type of database. Possible values include: 'MySQL', 'SQLServer', 'SQLAzure', 'Custom', 'NotificationHub', 'ServiceBus', 'EventHub', 'APIHub', 'DocDb', 'RedisCache', 'PostgreSQL'
	Type ConnectionStringType `json:"type,omitempty"`
}

// Contact contact information for domain registration. If 'Domain Privacy' option is not selected then the
// contact information is made publicly available through the Whois
// directories as per ICANN requirements.
type Contact struct {
	// AddressMailing - Mailing address.
	AddressMailing *Address `json:"addressMailing,omitempty"`
	// Email - Email address.
	Email *string `json:"email,omitempty"`
	// Fax - Fax number.
	Fax *string `json:"fax,omitempty"`
	// JobTitle - Job title.
	JobTitle *string `json:"jobTitle,omitempty"`
	// NameFirst - First name.
	NameFirst *string `json:"nameFirst,omitempty"`
	// NameLast - Last name.
	NameLast *string `json:"nameLast,omitempty"`
	// NameMiddle - Middle name.
	NameMiddle *string `json:"nameMiddle,omitempty"`
	// Organization - Organization contact belongs to.
	Organization *string `json:"organization,omitempty"`
	// Phone - Phone number.
	Phone *string `json:"phone,omitempty"`
}

// ContainerCPUStatistics ...
type ContainerCPUStatistics struct {
	CPUUsage       *ContainerCPUUsage       `json:"cpuUsage,omitempty"`
	SystemCPUUsage *int64                   `json:"systemCpuUsage,omitempty"`
	OnlineCPUCount *int32                   `json:"onlineCpuCount,omitempty"`
	ThrottlingData *ContainerThrottlingData `json:"throttlingData,omitempty"`
}

// ContainerCPUUsage ...
type ContainerCPUUsage struct {
	TotalUsage      *int64   `json:"totalUsage,omitempty"`
	PerCPUUsage     *[]int64 `json:"perCpuUsage,omitempty"`
	KernelModeUsage *int64   `json:"kernelModeUsage,omitempty"`
	UserModeUsage   *int64   `json:"userModeUsage,omitempty"`
}

// ContainerInfo ...
type ContainerInfo struct {
	CurrentTimeStamp  *date.Time                           `json:"currentTimeStamp,omitempty"`
	PreviousTimeStamp *date.Time                           `json:"previousTimeStamp,omitempty"`
	CurrentCPUStats   *ContainerCPUStatistics              `json:"currentCpuStats,omitempty"`
	PreviousCPUStats  *ContainerCPUStatistics              `json:"previousCpuStats,omitempty"`
	MemoryStats       *ContainerMemoryStatistics           `json:"memoryStats,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	ID                *string                              `json:"id,omitempty"`
	Eth0              *ContainerNetworkInterfaceStatistics `json:"eth0,omitempty"`
}

// ContainerMemoryStatistics ...
type ContainerMemoryStatistics struct {
	Usage    *int64 `json:"usage,omitempty"`
	MaxUsage *int64 `json:"maxUsage,omitempty"`
	Limit    *int64 `json:"limit,omitempty"`
}

// ContainerNetworkInterfaceStatistics ...
type ContainerNetworkInterfaceStatistics struct {
	RxBytes   *int64 `json:"rxBytes,omitempty"`
	RxPackets *int64 `json:"rxPackets,omitempty"`
	RxErrors  *int64 `json:"rxErrors,omitempty"`
	RxDropped *int64 `json:"rxDropped,omitempty"`
	TxBytes   *int64 `json:"txBytes,omitempty"`
	TxPackets *int64 `json:"txPackets,omitempty"`
	TxErrors  *int64 `json:"txErrors,omitempty"`
	TxDropped *int64 `json:"txDropped,omitempty"`
}

// ContainerThrottlingData ...
type ContainerThrottlingData struct {
	Periods          *int32 `json:"periods,omitempty"`
	ThrottledPeriods *int32 `json:"throttledPeriods,omitempty"`
	ThrottledTime    *int32 `json:"throttledTime,omitempty"`
}

// ContinuousWebJob continuous Web Job Information.
type ContinuousWebJob struct {
	autorest.Response `json:"-"`
	// ContinuousWebJobProperties - ContinuousWebJob resource specific properties
	*ContinuousWebJobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ContinuousWebJob.
func (cwj ContinuousWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cwj.ContinuousWebJobProperties != nil {
		objectMap["properties"] = cwj.ContinuousWebJobProperties
	}
	if cwj.Kind != nil {
		objectMap["kind"] = cwj.Kind
	}
	if cwj.SystemData != nil {
		objectMap["systemData"] = cwj.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContinuousWebJob struct.
func (cwj *ContinuousWebJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var continuousWebJobProperties ContinuousWebJobProperties
				err = json.Unmarshal(*v, &continuousWebJobProperties)
				if err != nil {
					return err
				}
				cwj.ContinuousWebJobProperties = &continuousWebJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cwj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cwj.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cwj.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cwj.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cwj.SystemData = &systemData
			}
		}
	}

	return nil
}

// ContinuousWebJobCollection collection of Kudu continuous web job information elements.
type ContinuousWebJobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ContinuousWebJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ContinuousWebJobCollection.
func (cwjc ContinuousWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cwjc.Value != nil {
		objectMap["value"] = cwjc.Value
	}
	return json.Marshal(objectMap)
}

// ContinuousWebJobCollectionIterator provides access to a complete listing of ContinuousWebJob values.
type ContinuousWebJobCollectionIterator struct {
	i    int
	page ContinuousWebJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContinuousWebJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContinuousWebJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContinuousWebJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContinuousWebJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContinuousWebJobCollectionIterator) Response() ContinuousWebJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContinuousWebJobCollectionIterator) Value() ContinuousWebJob {
	if !iter.page.NotDone() {
		return ContinuousWebJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContinuousWebJobCollectionIterator type.
func NewContinuousWebJobCollectionIterator(page ContinuousWebJobCollectionPage) ContinuousWebJobCollectionIterator {
	return ContinuousWebJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cwjc ContinuousWebJobCollection) IsEmpty() bool {
	return cwjc.Value == nil || len(*cwjc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cwjc ContinuousWebJobCollection) hasNextLink() bool {
	return cwjc.NextLink != nil && len(*cwjc.NextLink) != 0
}

// continuousWebJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cwjc ContinuousWebJobCollection) continuousWebJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cwjc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cwjc.NextLink)))
}

// ContinuousWebJobCollectionPage contains a page of ContinuousWebJob values.
type ContinuousWebJobCollectionPage struct {
	fn   func(context.Context, ContinuousWebJobCollection) (ContinuousWebJobCollection, error)
	cwjc ContinuousWebJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContinuousWebJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContinuousWebJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cwjc)
		if err != nil {
			return err
		}
		page.cwjc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContinuousWebJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContinuousWebJobCollectionPage) NotDone() bool {
	return !page.cwjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContinuousWebJobCollectionPage) Response() ContinuousWebJobCollection {
	return page.cwjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContinuousWebJobCollectionPage) Values() []ContinuousWebJob {
	if page.cwjc.IsEmpty() {
		return nil
	}
	return *page.cwjc.Value
}

// Creates a new instance of the ContinuousWebJobCollectionPage type.
func NewContinuousWebJobCollectionPage(cur ContinuousWebJobCollection, getNextPage func(context.Context, ContinuousWebJobCollection) (ContinuousWebJobCollection, error)) ContinuousWebJobCollectionPage {
	return ContinuousWebJobCollectionPage{
		fn:   getNextPage,
		cwjc: cur,
	}
}

// ContinuousWebJobProperties continuousWebJob resource specific properties
type ContinuousWebJobProperties struct {
	// Status - Job status. Possible values include: 'Initializing', 'Starting', 'Running', 'PendingRestart', 'Stopped'
	Status ContinuousWebJobStatus `json:"status,omitempty"`
	// DetailedStatus - Detailed status.
	DetailedStatus *string `json:"detailed_status,omitempty"`
	// LogURL - Log URL.
	LogURL *string `json:"log_url,omitempty"`
	// RunCommand - Run command.
	RunCommand *string `json:"run_command,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`
	// WebJobType - Job type. Possible values include: 'Continuous', 'Triggered'
	WebJobType JobType `json:"web_job_type,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for ContinuousWebJobProperties.
func (cwj ContinuousWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cwj.Status != "" {
		objectMap["status"] = cwj.Status
	}
	if cwj.DetailedStatus != nil {
		objectMap["detailed_status"] = cwj.DetailedStatus
	}
	if cwj.LogURL != nil {
		objectMap["log_url"] = cwj.LogURL
	}
	if cwj.RunCommand != nil {
		objectMap["run_command"] = cwj.RunCommand
	}
	if cwj.URL != nil {
		objectMap["url"] = cwj.URL
	}
	if cwj.ExtraInfoURL != nil {
		objectMap["extra_info_url"] = cwj.ExtraInfoURL
	}
	if cwj.WebJobType != "" {
		objectMap["web_job_type"] = cwj.WebJobType
	}
	if cwj.Error != nil {
		objectMap["error"] = cwj.Error
	}
	if cwj.UsingSdk != nil {
		objectMap["using_sdk"] = cwj.UsingSdk
	}
	if cwj.Settings != nil {
		objectMap["settings"] = cwj.Settings
	}
	return json.Marshal(objectMap)
}

// CookieExpiration ...
type CookieExpiration struct {
	// CookieExpirationProperties - CookieExpiration resource specific properties
	*CookieExpirationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CookieExpiration.
func (ce CookieExpiration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.CookieExpirationProperties != nil {
		objectMap["properties"] = ce.CookieExpirationProperties
	}
	if ce.Kind != nil {
		objectMap["kind"] = ce.Kind
	}
	if ce.SystemData != nil {
		objectMap["systemData"] = ce.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CookieExpiration struct.
func (ce *CookieExpiration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cookieExpirationProperties CookieExpirationProperties
				err = json.Unmarshal(*v, &cookieExpirationProperties)
				if err != nil {
					return err
				}
				ce.CookieExpirationProperties = &cookieExpirationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ce.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ce.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ce.SystemData = &systemData
			}
		}
	}

	return nil
}

// CookieExpirationProperties cookieExpiration resource specific properties
type CookieExpirationProperties struct {
	// Convention - Possible values include: 'FixedTime', 'IdentityProviderDerived'
	Convention       CookieExpirationConvention `json:"convention,omitempty"`
	TimeToExpiration *string                    `json:"timeToExpiration,omitempty"`
}

// CorsSettings cross-Origin Resource Sharing (CORS) settings for the app.
type CorsSettings struct {
	// AllowedOrigins - Gets or sets the list of origins that should be allowed to make cross-origin
	// calls (for example: http://example.com:12345). Use "*" to allow all.
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
	// SupportCredentials - Gets or sets whether CORS requests with credentials are allowed. See
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
	// for more details.
	SupportCredentials *bool `json:"supportCredentials,omitempty"`
}

// CsmCopySlotEntity copy deployment slot parameters.
type CsmCopySlotEntity struct {
	// TargetSlot - Destination deployment slot during copy operation.
	TargetSlot *string `json:"targetSlot,omitempty"`
	// SiteConfig - The site object which will be merged with the source slot site
	// to produce new destination slot site object.
	// <code>null</code> to just copy source slot content. Otherwise a <code>Site</code>
	// object with properties to override source slot site.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
}

// CsmMoveResourceEnvelope object with a list of the resources that need to be moved and the resource group
// they should be moved to.
type CsmMoveResourceEnvelope struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// CsmOperationCollection collection of Azure resource manager operation metadata.
type CsmOperationCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]CsmOperationDescription `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CsmOperationCollection.
func (coc CsmOperationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coc.Value != nil {
		objectMap["value"] = coc.Value
	}
	return json.Marshal(objectMap)
}

// CsmOperationCollectionIterator provides access to a complete listing of CsmOperationDescription values.
type CsmOperationCollectionIterator struct {
	i    int
	page CsmOperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CsmOperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmOperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CsmOperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CsmOperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CsmOperationCollectionIterator) Response() CsmOperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CsmOperationCollectionIterator) Value() CsmOperationDescription {
	if !iter.page.NotDone() {
		return CsmOperationDescription{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CsmOperationCollectionIterator type.
func NewCsmOperationCollectionIterator(page CsmOperationCollectionPage) CsmOperationCollectionIterator {
	return CsmOperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (coc CsmOperationCollection) IsEmpty() bool {
	return coc.Value == nil || len(*coc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (coc CsmOperationCollection) hasNextLink() bool {
	return coc.NextLink != nil && len(*coc.NextLink) != 0
}

// csmOperationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (coc CsmOperationCollection) csmOperationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !coc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(coc.NextLink)))
}

// CsmOperationCollectionPage contains a page of CsmOperationDescription values.
type CsmOperationCollectionPage struct {
	fn  func(context.Context, CsmOperationCollection) (CsmOperationCollection, error)
	coc CsmOperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CsmOperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmOperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.coc)
		if err != nil {
			return err
		}
		page.coc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CsmOperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CsmOperationCollectionPage) NotDone() bool {
	return !page.coc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CsmOperationCollectionPage) Response() CsmOperationCollection {
	return page.coc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CsmOperationCollectionPage) Values() []CsmOperationDescription {
	if page.coc.IsEmpty() {
		return nil
	}
	return *page.coc.Value
}

// Creates a new instance of the CsmOperationCollectionPage type.
func NewCsmOperationCollectionPage(cur CsmOperationCollection, getNextPage func(context.Context, CsmOperationCollection) (CsmOperationCollection, error)) CsmOperationCollectionPage {
	return CsmOperationCollectionPage{
		fn:  getNextPage,
		coc: cur,
	}
}

// CsmOperationDescription description of an operation available for Microsoft.Web resource provider.
type CsmOperationDescription struct {
	Name       *string                            `json:"name,omitempty"`
	Display    *CsmOperationDisplay               `json:"display,omitempty"`
	Origin     *string                            `json:"origin,omitempty"`
	Properties *CsmOperationDescriptionProperties `json:"properties,omitempty"`
}

// CsmOperationDescriptionProperties properties available for a Microsoft.Web resource provider operation.
type CsmOperationDescriptionProperties struct {
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// CsmOperationDisplay meta data about operation used for display in portal.
type CsmOperationDisplay struct {
	Provider    *string `json:"provider,omitempty"`
	Resource    *string `json:"resource,omitempty"`
	Operation   *string `json:"operation,omitempty"`
	Description *string `json:"description,omitempty"`
}

// CsmPublishingCredentialsPoliciesCollection publishing Credentials Policies collection.
type CsmPublishingCredentialsPoliciesCollection struct {
	autorest.Response `json:"-"`
	// CsmPublishingCredentialsPoliciesCollectionProperties - CsmPublishingCredentialsPoliciesCollection resource specific properties
	*CsmPublishingCredentialsPoliciesCollectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CsmPublishingCredentialsPoliciesCollection.
func (cpcpc CsmPublishingCredentialsPoliciesCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpcpc.CsmPublishingCredentialsPoliciesCollectionProperties != nil {
		objectMap["properties"] = cpcpc.CsmPublishingCredentialsPoliciesCollectionProperties
	}
	if cpcpc.Kind != nil {
		objectMap["kind"] = cpcpc.Kind
	}
	if cpcpc.SystemData != nil {
		objectMap["systemData"] = cpcpc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CsmPublishingCredentialsPoliciesCollection struct.
func (cpcpc *CsmPublishingCredentialsPoliciesCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var csmPublishingCredentialsPoliciesCollectionProperties CsmPublishingCredentialsPoliciesCollectionProperties
				err = json.Unmarshal(*v, &csmPublishingCredentialsPoliciesCollectionProperties)
				if err != nil {
					return err
				}
				cpcpc.CsmPublishingCredentialsPoliciesCollectionProperties = &csmPublishingCredentialsPoliciesCollectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpcpc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpcpc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cpcpc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpcpc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cpcpc.SystemData = &systemData
			}
		}
	}

	return nil
}

// CsmPublishingCredentialsPoliciesCollectionProperties csmPublishingCredentialsPoliciesCollection resource
// specific properties
type CsmPublishingCredentialsPoliciesCollectionProperties struct {
	// Ftp - Whether FTP is allowed.
	Ftp *CsmPublishingCredentialsPoliciesEntity `json:"ftp,omitempty"`
	// Scm - Whether Scm Basic Auth is allowed.
	Scm *CsmPublishingCredentialsPoliciesEntity `json:"scm,omitempty"`
}

// CsmPublishingCredentialsPoliciesEntity publishing Credentials Policies parameters.
type CsmPublishingCredentialsPoliciesEntity struct {
	autorest.Response `json:"-"`
	// CsmPublishingCredentialsPoliciesEntityProperties - CsmPublishingCredentialsPoliciesEntity resource specific properties
	*CsmPublishingCredentialsPoliciesEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CsmPublishingCredentialsPoliciesEntity.
func (cpcpe CsmPublishingCredentialsPoliciesEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpcpe.CsmPublishingCredentialsPoliciesEntityProperties != nil {
		objectMap["properties"] = cpcpe.CsmPublishingCredentialsPoliciesEntityProperties
	}
	if cpcpe.Kind != nil {
		objectMap["kind"] = cpcpe.Kind
	}
	if cpcpe.SystemData != nil {
		objectMap["systemData"] = cpcpe.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CsmPublishingCredentialsPoliciesEntity struct.
func (cpcpe *CsmPublishingCredentialsPoliciesEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var csmPublishingCredentialsPoliciesEntityProperties CsmPublishingCredentialsPoliciesEntityProperties
				err = json.Unmarshal(*v, &csmPublishingCredentialsPoliciesEntityProperties)
				if err != nil {
					return err
				}
				cpcpe.CsmPublishingCredentialsPoliciesEntityProperties = &csmPublishingCredentialsPoliciesEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cpcpe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cpcpe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				cpcpe.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cpcpe.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cpcpe.SystemData = &systemData
			}
		}
	}

	return nil
}

// CsmPublishingCredentialsPoliciesEntityProperties csmPublishingCredentialsPoliciesEntity resource
// specific properties
type CsmPublishingCredentialsPoliciesEntityProperties struct {
	// Allow - <code>true</code> to allow access to a publishing method; otherwise, <code>false</code>.
	Allow *bool `json:"allow,omitempty"`
}

// CsmPublishingProfileOptions publishing options for requested profile.
type CsmPublishingProfileOptions struct {
	// Format - Name of the format. Valid values are:
	// FileZilla3
	// WebDeploy -- default
	// Ftp. Possible values include: 'FileZilla3', 'WebDeploy', 'Ftp'
	Format PublishingProfileFormat `json:"format,omitempty"`
	// IncludeDisasterRecoveryEndpoints - Include the DisasterRecover endpoint if true
	IncludeDisasterRecoveryEndpoints *bool `json:"includeDisasterRecoveryEndpoints,omitempty"`
}

// CsmSlotEntity deployment slot parameters.
type CsmSlotEntity struct {
	// TargetSlot - Destination deployment slot during swap operation.
	TargetSlot *string `json:"targetSlot,omitempty"`
	// PreserveVnet - <code>true</code> to preserve Virtual Network to the slot during swap; otherwise, <code>false</code>.
	PreserveVnet *bool `json:"preserveVnet,omitempty"`
}

// CsmUsageQuota usage of the quota resource.
type CsmUsageQuota struct {
	// Unit - Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - Next reset time for the resource counter.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// CurrentValue - The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - The resource limit.
	Limit *int64 `json:"limit,omitempty"`
	// Name - Quota name.
	Name *LocalizableString `json:"name,omitempty"`
}

// CsmUsageQuotaCollection collection of CSM usage quotas.
type CsmUsageQuotaCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]CsmUsageQuota `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for CsmUsageQuotaCollection.
func (cuqc CsmUsageQuotaCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cuqc.Value != nil {
		objectMap["value"] = cuqc.Value
	}
	return json.Marshal(objectMap)
}

// CsmUsageQuotaCollectionIterator provides access to a complete listing of CsmUsageQuota values.
type CsmUsageQuotaCollectionIterator struct {
	i    int
	page CsmUsageQuotaCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CsmUsageQuotaCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *CsmUsageQuotaCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CsmUsageQuotaCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CsmUsageQuotaCollectionIterator) Response() CsmUsageQuotaCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CsmUsageQuotaCollectionIterator) Value() CsmUsageQuota {
	if !iter.page.NotDone() {
		return CsmUsageQuota{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the CsmUsageQuotaCollectionIterator type.
func NewCsmUsageQuotaCollectionIterator(page CsmUsageQuotaCollectionPage) CsmUsageQuotaCollectionIterator {
	return CsmUsageQuotaCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cuqc CsmUsageQuotaCollection) IsEmpty() bool {
	return cuqc.Value == nil || len(*cuqc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cuqc CsmUsageQuotaCollection) hasNextLink() bool {
	return cuqc.NextLink != nil && len(*cuqc.NextLink) != 0
}

// csmUsageQuotaCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cuqc CsmUsageQuotaCollection) csmUsageQuotaCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !cuqc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cuqc.NextLink)))
}

// CsmUsageQuotaCollectionPage contains a page of CsmUsageQuota values.
type CsmUsageQuotaCollectionPage struct {
	fn   func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)
	cuqc CsmUsageQuotaCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CsmUsageQuotaCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CsmUsageQuotaCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cuqc)
		if err != nil {
			return err
		}
		page.cuqc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *CsmUsageQuotaCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CsmUsageQuotaCollectionPage) NotDone() bool {
	return !page.cuqc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CsmUsageQuotaCollectionPage) Response() CsmUsageQuotaCollection {
	return page.cuqc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CsmUsageQuotaCollectionPage) Values() []CsmUsageQuota {
	if page.cuqc.IsEmpty() {
		return nil
	}
	return *page.cuqc.Value
}

// Creates a new instance of the CsmUsageQuotaCollectionPage type.
func NewCsmUsageQuotaCollectionPage(cur CsmUsageQuotaCollection, getNextPage func(context.Context, CsmUsageQuotaCollection) (CsmUsageQuotaCollection, error)) CsmUsageQuotaCollectionPage {
	return CsmUsageQuotaCollectionPage{
		fn:   getNextPage,
		cuqc: cur,
	}
}

// CustomHostnameAnalysisResult custom domain analysis.
type CustomHostnameAnalysisResult struct {
	autorest.Response `json:"-"`
	// CustomHostnameAnalysisResultProperties - CustomHostnameAnalysisResult resource specific properties
	*CustomHostnameAnalysisResultProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomHostnameAnalysisResult.
func (char CustomHostnameAnalysisResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if char.CustomHostnameAnalysisResultProperties != nil {
		objectMap["properties"] = char.CustomHostnameAnalysisResultProperties
	}
	if char.Kind != nil {
		objectMap["kind"] = char.Kind
	}
	if char.SystemData != nil {
		objectMap["systemData"] = char.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomHostnameAnalysisResult struct.
func (char *CustomHostnameAnalysisResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customHostnameAnalysisResultProperties CustomHostnameAnalysisResultProperties
				err = json.Unmarshal(*v, &customHostnameAnalysisResultProperties)
				if err != nil {
					return err
				}
				char.CustomHostnameAnalysisResultProperties = &customHostnameAnalysisResultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				char.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				char.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				char.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				char.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				char.SystemData = &systemData
			}
		}
	}

	return nil
}

// CustomHostnameAnalysisResultProperties customHostnameAnalysisResult resource specific properties
type CustomHostnameAnalysisResultProperties struct {
	// IsHostnameAlreadyVerified - READ-ONLY; <code>true</code> if hostname is already verified; otherwise, <code>false</code>.
	IsHostnameAlreadyVerified *bool `json:"isHostnameAlreadyVerified,omitempty"`
	// CustomDomainVerificationTest - READ-ONLY; DNS verification test result. Possible values include: 'DNSVerificationTestResultPassed', 'DNSVerificationTestResultFailed', 'DNSVerificationTestResultSkipped'
	CustomDomainVerificationTest DNSVerificationTestResult `json:"customDomainVerificationTest,omitempty"`
	// CustomDomainVerificationFailureInfo - READ-ONLY; Raw failure information if DNS verification fails.
	CustomDomainVerificationFailureInfo *ErrorEntity `json:"customDomainVerificationFailureInfo,omitempty"`
	// HasConflictOnScaleUnit - READ-ONLY; <code>true</code> if there is a conflict on a scale unit; otherwise, <code>false</code>.
	HasConflictOnScaleUnit *bool `json:"hasConflictOnScaleUnit,omitempty"`
	// HasConflictAcrossSubscription - READ-ONLY; <code>true</code> if there is a conflict across subscriptions; otherwise, <code>false</code>.
	HasConflictAcrossSubscription *bool `json:"hasConflictAcrossSubscription,omitempty"`
	// ConflictingAppResourceID - READ-ONLY; Name of the conflicting app on scale unit if it's within the same subscription.
	ConflictingAppResourceID *string `json:"conflictingAppResourceId,omitempty"`
	// CNameRecords - CName records controller can see for this hostname.
	CNameRecords *[]string `json:"cNameRecords,omitempty"`
	// TxtRecords - TXT records controller can see for this hostname.
	TxtRecords *[]string `json:"txtRecords,omitempty"`
	// ARecords - A records controller can see for this hostname.
	ARecords *[]string `json:"aRecords,omitempty"`
	// AlternateCNameRecords - Alternate CName records controller can see for this hostname.
	AlternateCNameRecords *[]string `json:"alternateCNameRecords,omitempty"`
	// AlternateTxtRecords - Alternate TXT records controller can see for this hostname.
	AlternateTxtRecords *[]string `json:"alternateTxtRecords,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomHostnameAnalysisResultProperties.
func (char CustomHostnameAnalysisResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if char.CNameRecords != nil {
		objectMap["cNameRecords"] = char.CNameRecords
	}
	if char.TxtRecords != nil {
		objectMap["txtRecords"] = char.TxtRecords
	}
	if char.ARecords != nil {
		objectMap["aRecords"] = char.ARecords
	}
	if char.AlternateCNameRecords != nil {
		objectMap["alternateCNameRecords"] = char.AlternateCNameRecords
	}
	if char.AlternateTxtRecords != nil {
		objectMap["alternateTxtRecords"] = char.AlternateTxtRecords
	}
	return json.Marshal(objectMap)
}

// CustomOpenIDConnectProvider ...
type CustomOpenIDConnectProvider struct {
	// CustomOpenIDConnectProviderProperties - CustomOpenIdConnectProvider resource specific properties
	*CustomOpenIDConnectProviderProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomOpenIDConnectProvider.
func (coicp CustomOpenIDConnectProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if coicp.CustomOpenIDConnectProviderProperties != nil {
		objectMap["properties"] = coicp.CustomOpenIDConnectProviderProperties
	}
	if coicp.Kind != nil {
		objectMap["kind"] = coicp.Kind
	}
	if coicp.SystemData != nil {
		objectMap["systemData"] = coicp.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomOpenIDConnectProvider struct.
func (coicp *CustomOpenIDConnectProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customOpenIDConnectProviderProperties CustomOpenIDConnectProviderProperties
				err = json.Unmarshal(*v, &customOpenIDConnectProviderProperties)
				if err != nil {
					return err
				}
				coicp.CustomOpenIDConnectProviderProperties = &customOpenIDConnectProviderProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				coicp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				coicp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				coicp.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				coicp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				coicp.SystemData = &systemData
			}
		}
	}

	return nil
}

// CustomOpenIDConnectProviderProperties customOpenIdConnectProvider resource specific properties
type CustomOpenIDConnectProviderProperties struct {
	Enabled      *bool                      `json:"enabled,omitempty"`
	Registration *OpenIDConnectRegistration `json:"registration,omitempty"`
	Login        *OpenIDConnectLogin        `json:"login,omitempty"`
}

// DatabaseBackupSetting database backup settings.
type DatabaseBackupSetting struct {
	// DatabaseType - Database type (e.g. SqlAzure / MySql). Possible values include: 'DatabaseTypeSQLAzure', 'DatabaseTypeMySQL', 'DatabaseTypeLocalMySQL', 'DatabaseTypePostgreSQL'
	DatabaseType DatabaseType `json:"databaseType,omitempty"`
	Name         *string      `json:"name,omitempty"`
	// ConnectionStringName - Contains a connection string name that is linked to the SiteConfig.ConnectionStrings.
	// This is used during restore with overwrite connection strings options.
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	// ConnectionString - Contains a connection string to a database which is being backed up or restored. If the restore should happen to a new database, the database name inside is the new one.
	ConnectionString *string `json:"connectionString,omitempty"`
}

// DataSource class representing data source used by the detectors
type DataSource struct {
	// Instructions - Instructions if any for the data source
	Instructions *[]string `json:"instructions,omitempty"`
	// DataSourceURI - Datasource Uri Links
	DataSourceURI *[]NameValuePair `json:"dataSourceUri,omitempty"`
}

// DataTableResponseColumn column definition
type DataTableResponseColumn struct {
	// ColumnName - Name of the column
	ColumnName *string `json:"columnName,omitempty"`
	// DataType - Data type which looks like 'String' or 'Int32'.
	DataType *string `json:"dataType,omitempty"`
	// ColumnType - Column Type
	ColumnType *string `json:"columnType,omitempty"`
}

// DataTableResponseObject data Table which defines columns and raw row values
type DataTableResponseObject struct {
	// TableName - Name of the table
	TableName *string `json:"tableName,omitempty"`
	// Columns - List of columns with data types
	Columns *[]DataTableResponseColumn `json:"columns,omitempty"`
	// Rows - Raw row values
	Rows *[][]string `json:"rows,omitempty"`
}

// DefaultErrorResponse app Service error response.
type DefaultErrorResponse struct {
	// Error - READ-ONLY; Error model.
	Error *DefaultErrorResponseError `json:"error,omitempty"`
}

// DefaultErrorResponseError error model.
type DefaultErrorResponseError struct {
	// Code - READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Detailed error description and debugging information.
	Target  *string                                 `json:"target,omitempty"`
	Details *[]DefaultErrorResponseErrorDetailsItem `json:"details,omitempty"`
	// Innererror - READ-ONLY; More information to debug error.
	Innererror *string `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for DefaultErrorResponseError.
func (der DefaultErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if der.Details != nil {
		objectMap["details"] = der.Details
	}
	return json.Marshal(objectMap)
}

// DefaultErrorResponseErrorDetailsItem detailed errors.
type DefaultErrorResponseErrorDetailsItem struct {
	// Code - READ-ONLY; Standardized string to programmatically identify the error.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Detailed error description and debugging information.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; Detailed error description and debugging information.
	Target *string `json:"target,omitempty"`
}

// DeletedAppRestoreRequest details about restoring a deleted app.
type DeletedAppRestoreRequest struct {
	// DeletedAppRestoreRequestProperties - DeletedAppRestoreRequest resource specific properties
	*DeletedAppRestoreRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedAppRestoreRequest.
func (darr DeletedAppRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if darr.DeletedAppRestoreRequestProperties != nil {
		objectMap["properties"] = darr.DeletedAppRestoreRequestProperties
	}
	if darr.Kind != nil {
		objectMap["kind"] = darr.Kind
	}
	if darr.SystemData != nil {
		objectMap["systemData"] = darr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeletedAppRestoreRequest struct.
func (darr *DeletedAppRestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deletedAppRestoreRequestProperties DeletedAppRestoreRequestProperties
				err = json.Unmarshal(*v, &deletedAppRestoreRequestProperties)
				if err != nil {
					return err
				}
				darr.DeletedAppRestoreRequestProperties = &deletedAppRestoreRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				darr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				darr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				darr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				darr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				darr.SystemData = &systemData
			}
		}
	}

	return nil
}

// DeletedAppRestoreRequestProperties deletedAppRestoreRequest resource specific properties
type DeletedAppRestoreRequestProperties struct {
	// DeletedSiteID - ARM resource ID of the deleted app. Example:
	// /subscriptions/{subId}/providers/Microsoft.Web/deletedSites/{deletedSiteId}
	DeletedSiteID *string `json:"deletedSiteId,omitempty"`
	// RecoverConfiguration - If true, deleted site configuration, in addition to content, will be restored.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`
	// SnapshotTime - Point in time to restore the deleted app from, formatted as a DateTime string.
	// If unspecified, default value is the time that the app was deleted.
	SnapshotTime *string `json:"snapshotTime,omitempty"`
	// UseDRSecondary - If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// DeletedSite a deleted app.
type DeletedSite struct {
	autorest.Response `json:"-"`
	// DeletedSiteProperties - DeletedSite resource specific properties
	*DeletedSiteProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedSite.
func (ds DeletedSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.DeletedSiteProperties != nil {
		objectMap["properties"] = ds.DeletedSiteProperties
	}
	if ds.Kind != nil {
		objectMap["kind"] = ds.Kind
	}
	if ds.SystemData != nil {
		objectMap["systemData"] = ds.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeletedSite struct.
func (ds *DeletedSite) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deletedSiteProperties DeletedSiteProperties
				err = json.Unmarshal(*v, &deletedSiteProperties)
				if err != nil {
					return err
				}
				ds.DeletedSiteProperties = &deletedSiteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ds.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ds.SystemData = &systemData
			}
		}
	}

	return nil
}

// DeletedSiteProperties deletedSite resource specific properties
type DeletedSiteProperties struct {
	// DeletedSiteID - READ-ONLY; Numeric id for the deleted site
	DeletedSiteID *int32 `json:"deletedSiteId,omitempty"`
	// DeletedTimestamp - READ-ONLY; Time in UTC when the app was deleted.
	DeletedTimestamp *string `json:"deletedTimestamp,omitempty"`
	// Subscription - READ-ONLY; Subscription containing the deleted site
	Subscription *string `json:"subscription,omitempty"`
	// ResourceGroup - READ-ONLY; ResourceGroup that contained the deleted site
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// DeletedSiteName - READ-ONLY; Name of the deleted site
	DeletedSiteName *string `json:"deletedSiteName,omitempty"`
	// Slot - READ-ONLY; Slot of the deleted site
	Slot *string `json:"slot,omitempty"`
	// Kind - READ-ONLY; Kind of site that was deleted
	Kind *string `json:"kind,omitempty"`
	// GeoRegionName - READ-ONLY; Geo Region of the deleted site
	GeoRegionName *string `json:"geoRegionName,omitempty"`
}

// DeletedWebAppCollection collection of deleted apps.
type DeletedWebAppCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DeletedSite `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedWebAppCollection.
func (dwac DeletedWebAppCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwac.Value != nil {
		objectMap["value"] = dwac.Value
	}
	return json.Marshal(objectMap)
}

// DeletedWebAppCollectionIterator provides access to a complete listing of DeletedSite values.
type DeletedWebAppCollectionIterator struct {
	i    int
	page DeletedWebAppCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedWebAppCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedWebAppCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedWebAppCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedWebAppCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedWebAppCollectionIterator) Response() DeletedWebAppCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedWebAppCollectionIterator) Value() DeletedSite {
	if !iter.page.NotDone() {
		return DeletedSite{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedWebAppCollectionIterator type.
func NewDeletedWebAppCollectionIterator(page DeletedWebAppCollectionPage) DeletedWebAppCollectionIterator {
	return DeletedWebAppCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dwac DeletedWebAppCollection) IsEmpty() bool {
	return dwac.Value == nil || len(*dwac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dwac DeletedWebAppCollection) hasNextLink() bool {
	return dwac.NextLink != nil && len(*dwac.NextLink) != 0
}

// deletedWebAppCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dwac DeletedWebAppCollection) deletedWebAppCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dwac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dwac.NextLink)))
}

// DeletedWebAppCollectionPage contains a page of DeletedSite values.
type DeletedWebAppCollectionPage struct {
	fn   func(context.Context, DeletedWebAppCollection) (DeletedWebAppCollection, error)
	dwac DeletedWebAppCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedWebAppCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedWebAppCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dwac)
		if err != nil {
			return err
		}
		page.dwac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedWebAppCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedWebAppCollectionPage) NotDone() bool {
	return !page.dwac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedWebAppCollectionPage) Response() DeletedWebAppCollection {
	return page.dwac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedWebAppCollectionPage) Values() []DeletedSite {
	if page.dwac.IsEmpty() {
		return nil
	}
	return *page.dwac.Value
}

// Creates a new instance of the DeletedWebAppCollectionPage type.
func NewDeletedWebAppCollectionPage(cur DeletedWebAppCollection, getNextPage func(context.Context, DeletedWebAppCollection) (DeletedWebAppCollection, error)) DeletedWebAppCollectionPage {
	return DeletedWebAppCollectionPage{
		fn:   getNextPage,
		dwac: cur,
	}
}

// Deployment user credentials used for publishing activity.
type Deployment struct {
	autorest.Response `json:"-"`
	// DeploymentProperties - Deployment resource specific properties
	*DeploymentProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DeploymentProperties != nil {
		objectMap["properties"] = d.DeploymentProperties
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.SystemData != nil {
		objectMap["systemData"] = d.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Deployment struct.
func (d *Deployment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var deploymentProperties DeploymentProperties
				err = json.Unmarshal(*v, &deploymentProperties)
				if err != nil {
					return err
				}
				d.DeploymentProperties = &deploymentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				d.SystemData = &systemData
			}
		}
	}

	return nil
}

// DeploymentCollection collection of app deployments.
type DeploymentCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Deployment `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentCollection.
func (dc DeploymentCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.Value != nil {
		objectMap["value"] = dc.Value
	}
	return json.Marshal(objectMap)
}

// DeploymentCollectionIterator provides access to a complete listing of Deployment values.
type DeploymentCollectionIterator struct {
	i    int
	page DeploymentCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentCollectionIterator) Response() DeploymentCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentCollectionIterator) Value() Deployment {
	if !iter.page.NotDone() {
		return Deployment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentCollectionIterator type.
func NewDeploymentCollectionIterator(page DeploymentCollectionPage) DeploymentCollectionIterator {
	return DeploymentCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DeploymentCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dc DeploymentCollection) hasNextLink() bool {
	return dc.NextLink != nil && len(*dc.NextLink) != 0
}

// deploymentCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DeploymentCollection) deploymentCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DeploymentCollectionPage contains a page of Deployment values.
type DeploymentCollectionPage struct {
	fn func(context.Context, DeploymentCollection) (DeploymentCollection, error)
	dc DeploymentCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dc)
		if err != nil {
			return err
		}
		page.dc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentCollectionPage) Response() DeploymentCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentCollectionPage) Values() []Deployment {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DeploymentCollectionPage type.
func NewDeploymentCollectionPage(cur DeploymentCollection, getNextPage func(context.Context, DeploymentCollection) (DeploymentCollection, error)) DeploymentCollectionPage {
	return DeploymentCollectionPage{
		fn: getNextPage,
		dc: cur,
	}
}

// DeploymentLocations list of available locations (regions or App Service Environments) for
// deployment of App Service resources.
type DeploymentLocations struct {
	autorest.Response `json:"-"`
	// Locations - Available regions.
	Locations *[]GeoRegion `json:"locations,omitempty"`
	// HostingEnvironments - Available App Service Environments with full descriptions of the environments.
	HostingEnvironments *[]AppServiceEnvironment `json:"hostingEnvironments,omitempty"`
	// HostingEnvironmentDeploymentInfos - Available App Service Environments with basic information.
	HostingEnvironmentDeploymentInfos *[]HostingEnvironmentDeploymentInfo `json:"hostingEnvironmentDeploymentInfos,omitempty"`
}

// DeploymentProperties deployment resource specific properties
type DeploymentProperties struct {
	// Status - Deployment status.
	Status *int32 `json:"status,omitempty"`
	// Message - Details about deployment status.
	Message *string `json:"message,omitempty"`
	// Author - Who authored the deployment.
	Author *string `json:"author,omitempty"`
	// Deployer - Who performed the deployment.
	Deployer *string `json:"deployer,omitempty"`
	// AuthorEmail - Author email.
	AuthorEmail *string `json:"author_email,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"start_time,omitempty"`
	// EndTime - End time.
	EndTime *date.Time `json:"end_time,omitempty"`
	// Active - True if deployment is currently active, false if completed and null if not started.
	Active *bool `json:"active,omitempty"`
	// Details - Details on deployment.
	Details *string `json:"details,omitempty"`
}

// DetectorAbnormalTimePeriod class representing Abnormal Time Period detected.
type DetectorAbnormalTimePeriod struct {
	// StartTime - Start time of the correlated event
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the correlated event
	EndTime *date.Time `json:"endTime,omitempty"`
	// Message - Message describing the event
	Message *string `json:"message,omitempty"`
	// Source - Represents the name of the Detector
	Source *string `json:"source,omitempty"`
	// Priority - Represents the rank of the Detector
	Priority *float64 `json:"priority,omitempty"`
	// MetaData - Downtime metadata
	MetaData *[][]NameValuePair `json:"metaData,omitempty"`
	// Type - Represents the type of the Detector. Possible values include: 'ServiceIncident', 'AppDeployment', 'AppCrash', 'RuntimeIssueDetected', 'AseDeployment', 'UserIssue', 'PlatformIssue', 'Other'
	Type IssueType `json:"type,omitempty"`
	// Solutions - List of proposed solutions
	Solutions *[]Solution `json:"solutions,omitempty"`
}

// DetectorDefinition class representing detector definition
type DetectorDefinition struct {
	autorest.Response `json:"-"`
	// DetectorDefinitionProperties - DetectorDefinition resource specific properties
	*DetectorDefinitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DetectorDefinition.
func (dd DetectorDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dd.DetectorDefinitionProperties != nil {
		objectMap["properties"] = dd.DetectorDefinitionProperties
	}
	if dd.Kind != nil {
		objectMap["kind"] = dd.Kind
	}
	if dd.SystemData != nil {
		objectMap["systemData"] = dd.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DetectorDefinition struct.
func (dd *DetectorDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var detectorDefinitionProperties DetectorDefinitionProperties
				err = json.Unmarshal(*v, &detectorDefinitionProperties)
				if err != nil {
					return err
				}
				dd.DetectorDefinitionProperties = &detectorDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dd.SystemData = &systemData
			}
		}
	}

	return nil
}

// DetectorDefinitionProperties detectorDefinition resource specific properties
type DetectorDefinitionProperties struct {
	// DisplayName - READ-ONLY; Display name of the detector
	DisplayName *string `json:"displayName,omitempty"`
	// Description - READ-ONLY; Description of the detector
	Description *string `json:"description,omitempty"`
	// Rank - READ-ONLY; Detector Rank
	Rank *float64 `json:"rank,omitempty"`
	// IsEnabled - READ-ONLY; Flag representing whether detector is enabled or not.
	IsEnabled *bool `json:"isEnabled,omitempty"`
}

// DetectorInfo definition of Detector
type DetectorInfo struct {
	// Description - READ-ONLY; Short description of the detector and its purpose
	Description *string `json:"description,omitempty"`
	// Category - READ-ONLY; Support Category
	Category *string `json:"category,omitempty"`
	// SubCategory - READ-ONLY; Support Sub Category
	SubCategory *string `json:"subCategory,omitempty"`
	// SupportTopicID - READ-ONLY; Support Topic Id
	SupportTopicID *string `json:"supportTopicId,omitempty"`
}

// DetectorResponse class representing Response from Detector
type DetectorResponse struct {
	autorest.Response `json:"-"`
	// DetectorResponseProperties - DetectorResponse resource specific properties
	*DetectorResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DetectorResponse.
func (dr DetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dr.DetectorResponseProperties != nil {
		objectMap["properties"] = dr.DetectorResponseProperties
	}
	if dr.Kind != nil {
		objectMap["kind"] = dr.Kind
	}
	if dr.SystemData != nil {
		objectMap["systemData"] = dr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DetectorResponse struct.
func (dr *DetectorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var detectorResponseProperties DetectorResponseProperties
				err = json.Unmarshal(*v, &detectorResponseProperties)
				if err != nil {
					return err
				}
				dr.DetectorResponseProperties = &detectorResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dr.SystemData = &systemData
			}
		}
	}

	return nil
}

// DetectorResponseCollection collection of detector responses
type DetectorResponseCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DetectorResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DetectorResponseCollection.
func (drc DetectorResponseCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if drc.Value != nil {
		objectMap["value"] = drc.Value
	}
	return json.Marshal(objectMap)
}

// DetectorResponseCollectionIterator provides access to a complete listing of DetectorResponse values.
type DetectorResponseCollectionIterator struct {
	i    int
	page DetectorResponseCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DetectorResponseCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DetectorResponseCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DetectorResponseCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DetectorResponseCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DetectorResponseCollectionIterator) Response() DetectorResponseCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DetectorResponseCollectionIterator) Value() DetectorResponse {
	if !iter.page.NotDone() {
		return DetectorResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DetectorResponseCollectionIterator type.
func NewDetectorResponseCollectionIterator(page DetectorResponseCollectionPage) DetectorResponseCollectionIterator {
	return DetectorResponseCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (drc DetectorResponseCollection) IsEmpty() bool {
	return drc.Value == nil || len(*drc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (drc DetectorResponseCollection) hasNextLink() bool {
	return drc.NextLink != nil && len(*drc.NextLink) != 0
}

// detectorResponseCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (drc DetectorResponseCollection) detectorResponseCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !drc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(drc.NextLink)))
}

// DetectorResponseCollectionPage contains a page of DetectorResponse values.
type DetectorResponseCollectionPage struct {
	fn  func(context.Context, DetectorResponseCollection) (DetectorResponseCollection, error)
	drc DetectorResponseCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DetectorResponseCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DetectorResponseCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.drc)
		if err != nil {
			return err
		}
		page.drc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DetectorResponseCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DetectorResponseCollectionPage) NotDone() bool {
	return !page.drc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DetectorResponseCollectionPage) Response() DetectorResponseCollection {
	return page.drc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DetectorResponseCollectionPage) Values() []DetectorResponse {
	if page.drc.IsEmpty() {
		return nil
	}
	return *page.drc.Value
}

// Creates a new instance of the DetectorResponseCollectionPage type.
func NewDetectorResponseCollectionPage(cur DetectorResponseCollection, getNextPage func(context.Context, DetectorResponseCollection) (DetectorResponseCollection, error)) DetectorResponseCollectionPage {
	return DetectorResponseCollectionPage{
		fn:  getNextPage,
		drc: cur,
	}
}

// DetectorResponseProperties detectorResponse resource specific properties
type DetectorResponseProperties struct {
	// Metadata - metadata for the detector
	Metadata *DetectorInfo `json:"metadata,omitempty"`
	// Dataset - Data Set
	Dataset *[]DiagnosticData `json:"dataset,omitempty"`
}

// DiagnosticAnalysis class representing a diagnostic analysis done on an application
type DiagnosticAnalysis struct {
	autorest.Response `json:"-"`
	// DiagnosticAnalysisProperties - DiagnosticAnalysis resource specific properties
	*DiagnosticAnalysisProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticAnalysis.
func (da DiagnosticAnalysis) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.DiagnosticAnalysisProperties != nil {
		objectMap["properties"] = da.DiagnosticAnalysisProperties
	}
	if da.Kind != nil {
		objectMap["kind"] = da.Kind
	}
	if da.SystemData != nil {
		objectMap["systemData"] = da.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticAnalysis struct.
func (da *DiagnosticAnalysis) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticAnalysisProperties DiagnosticAnalysisProperties
				err = json.Unmarshal(*v, &diagnosticAnalysisProperties)
				if err != nil {
					return err
				}
				da.DiagnosticAnalysisProperties = &diagnosticAnalysisProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				da.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				da.SystemData = &systemData
			}
		}
	}

	return nil
}

// DiagnosticAnalysisCollection collection of Diagnostic Analyses
type DiagnosticAnalysisCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]AnalysisDefinition `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticAnalysisCollection.
func (dac DiagnosticAnalysisCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dac.Value != nil {
		objectMap["value"] = dac.Value
	}
	return json.Marshal(objectMap)
}

// DiagnosticAnalysisCollectionIterator provides access to a complete listing of AnalysisDefinition values.
type DiagnosticAnalysisCollectionIterator struct {
	i    int
	page DiagnosticAnalysisCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticAnalysisCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticAnalysisCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticAnalysisCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticAnalysisCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticAnalysisCollectionIterator) Response() DiagnosticAnalysisCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticAnalysisCollectionIterator) Value() AnalysisDefinition {
	if !iter.page.NotDone() {
		return AnalysisDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticAnalysisCollectionIterator type.
func NewDiagnosticAnalysisCollectionIterator(page DiagnosticAnalysisCollectionPage) DiagnosticAnalysisCollectionIterator {
	return DiagnosticAnalysisCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dac DiagnosticAnalysisCollection) IsEmpty() bool {
	return dac.Value == nil || len(*dac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dac DiagnosticAnalysisCollection) hasNextLink() bool {
	return dac.NextLink != nil && len(*dac.NextLink) != 0
}

// diagnosticAnalysisCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dac DiagnosticAnalysisCollection) diagnosticAnalysisCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dac.NextLink)))
}

// DiagnosticAnalysisCollectionPage contains a page of AnalysisDefinition values.
type DiagnosticAnalysisCollectionPage struct {
	fn  func(context.Context, DiagnosticAnalysisCollection) (DiagnosticAnalysisCollection, error)
	dac DiagnosticAnalysisCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticAnalysisCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticAnalysisCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dac)
		if err != nil {
			return err
		}
		page.dac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticAnalysisCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticAnalysisCollectionPage) NotDone() bool {
	return !page.dac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticAnalysisCollectionPage) Response() DiagnosticAnalysisCollection {
	return page.dac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticAnalysisCollectionPage) Values() []AnalysisDefinition {
	if page.dac.IsEmpty() {
		return nil
	}
	return *page.dac.Value
}

// Creates a new instance of the DiagnosticAnalysisCollectionPage type.
func NewDiagnosticAnalysisCollectionPage(cur DiagnosticAnalysisCollection, getNextPage func(context.Context, DiagnosticAnalysisCollection) (DiagnosticAnalysisCollection, error)) DiagnosticAnalysisCollectionPage {
	return DiagnosticAnalysisCollectionPage{
		fn:  getNextPage,
		dac: cur,
	}
}

// DiagnosticAnalysisProperties diagnosticAnalysis resource specific properties
type DiagnosticAnalysisProperties struct {
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// AbnormalTimePeriods - List of time periods.
	AbnormalTimePeriods *[]AbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`
	// Payload - Data by each detector
	Payload *[]AnalysisData `json:"payload,omitempty"`
	// NonCorrelatedDetectors - Data by each detector for detectors that did not corelate
	NonCorrelatedDetectors *[]DetectorDefinition `json:"nonCorrelatedDetectors,omitempty"`
}

// DiagnosticCategory class representing detector definition
type DiagnosticCategory struct {
	autorest.Response `json:"-"`
	// DiagnosticCategoryProperties - DiagnosticCategory resource specific properties
	*DiagnosticCategoryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticCategory.
func (dc DiagnosticCategory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.DiagnosticCategoryProperties != nil {
		objectMap["properties"] = dc.DiagnosticCategoryProperties
	}
	if dc.Kind != nil {
		objectMap["kind"] = dc.Kind
	}
	if dc.SystemData != nil {
		objectMap["systemData"] = dc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticCategory struct.
func (dc *DiagnosticCategory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticCategoryProperties DiagnosticCategoryProperties
				err = json.Unmarshal(*v, &diagnosticCategoryProperties)
				if err != nil {
					return err
				}
				dc.DiagnosticCategoryProperties = &diagnosticCategoryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dc.SystemData = &systemData
			}
		}
	}

	return nil
}

// DiagnosticCategoryCollection collection of Diagnostic Categories
type DiagnosticCategoryCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DiagnosticCategory `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticCategoryCollection.
func (dcc DiagnosticCategoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dcc.Value != nil {
		objectMap["value"] = dcc.Value
	}
	return json.Marshal(objectMap)
}

// DiagnosticCategoryCollectionIterator provides access to a complete listing of DiagnosticCategory values.
type DiagnosticCategoryCollectionIterator struct {
	i    int
	page DiagnosticCategoryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticCategoryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCategoryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticCategoryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticCategoryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticCategoryCollectionIterator) Response() DiagnosticCategoryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticCategoryCollectionIterator) Value() DiagnosticCategory {
	if !iter.page.NotDone() {
		return DiagnosticCategory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticCategoryCollectionIterator type.
func NewDiagnosticCategoryCollectionIterator(page DiagnosticCategoryCollectionPage) DiagnosticCategoryCollectionIterator {
	return DiagnosticCategoryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dcc DiagnosticCategoryCollection) IsEmpty() bool {
	return dcc.Value == nil || len(*dcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dcc DiagnosticCategoryCollection) hasNextLink() bool {
	return dcc.NextLink != nil && len(*dcc.NextLink) != 0
}

// diagnosticCategoryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dcc DiagnosticCategoryCollection) diagnosticCategoryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dcc.NextLink)))
}

// DiagnosticCategoryCollectionPage contains a page of DiagnosticCategory values.
type DiagnosticCategoryCollectionPage struct {
	fn  func(context.Context, DiagnosticCategoryCollection) (DiagnosticCategoryCollection, error)
	dcc DiagnosticCategoryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticCategoryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticCategoryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dcc)
		if err != nil {
			return err
		}
		page.dcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticCategoryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticCategoryCollectionPage) NotDone() bool {
	return !page.dcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticCategoryCollectionPage) Response() DiagnosticCategoryCollection {
	return page.dcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticCategoryCollectionPage) Values() []DiagnosticCategory {
	if page.dcc.IsEmpty() {
		return nil
	}
	return *page.dcc.Value
}

// Creates a new instance of the DiagnosticCategoryCollectionPage type.
func NewDiagnosticCategoryCollectionPage(cur DiagnosticCategoryCollection, getNextPage func(context.Context, DiagnosticCategoryCollection) (DiagnosticCategoryCollection, error)) DiagnosticCategoryCollectionPage {
	return DiagnosticCategoryCollectionPage{
		fn:  getNextPage,
		dcc: cur,
	}
}

// DiagnosticCategoryProperties diagnosticCategory resource specific properties
type DiagnosticCategoryProperties struct {
	// Description - READ-ONLY; Description of the diagnostic category
	Description *string `json:"description,omitempty"`
}

// DiagnosticData set of data with rendering instructions
type DiagnosticData struct {
	// Table - Data in table form
	Table *DataTableResponseObject `json:"table,omitempty"`
	// RenderingProperties - Properties that describe how the table should be rendered
	RenderingProperties *Rendering `json:"renderingProperties,omitempty"`
}

// DiagnosticDetectorCollection collection of Diagnostic Detectors
type DiagnosticDetectorCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DetectorDefinition `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticDetectorCollection.
func (ddc DiagnosticDetectorCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ddc.Value != nil {
		objectMap["value"] = ddc.Value
	}
	return json.Marshal(objectMap)
}

// DiagnosticDetectorCollectionIterator provides access to a complete listing of DetectorDefinition values.
type DiagnosticDetectorCollectionIterator struct {
	i    int
	page DiagnosticDetectorCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DiagnosticDetectorCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticDetectorCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DiagnosticDetectorCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DiagnosticDetectorCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DiagnosticDetectorCollectionIterator) Response() DiagnosticDetectorCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DiagnosticDetectorCollectionIterator) Value() DetectorDefinition {
	if !iter.page.NotDone() {
		return DetectorDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DiagnosticDetectorCollectionIterator type.
func NewDiagnosticDetectorCollectionIterator(page DiagnosticDetectorCollectionPage) DiagnosticDetectorCollectionIterator {
	return DiagnosticDetectorCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ddc DiagnosticDetectorCollection) IsEmpty() bool {
	return ddc.Value == nil || len(*ddc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ddc DiagnosticDetectorCollection) hasNextLink() bool {
	return ddc.NextLink != nil && len(*ddc.NextLink) != 0
}

// diagnosticDetectorCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ddc DiagnosticDetectorCollection) diagnosticDetectorCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ddc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ddc.NextLink)))
}

// DiagnosticDetectorCollectionPage contains a page of DetectorDefinition values.
type DiagnosticDetectorCollectionPage struct {
	fn  func(context.Context, DiagnosticDetectorCollection) (DiagnosticDetectorCollection, error)
	ddc DiagnosticDetectorCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DiagnosticDetectorCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiagnosticDetectorCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ddc)
		if err != nil {
			return err
		}
		page.ddc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DiagnosticDetectorCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DiagnosticDetectorCollectionPage) NotDone() bool {
	return !page.ddc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DiagnosticDetectorCollectionPage) Response() DiagnosticDetectorCollection {
	return page.ddc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DiagnosticDetectorCollectionPage) Values() []DetectorDefinition {
	if page.ddc.IsEmpty() {
		return nil
	}
	return *page.ddc.Value
}

// Creates a new instance of the DiagnosticDetectorCollectionPage type.
func NewDiagnosticDetectorCollectionPage(cur DiagnosticDetectorCollection, getNextPage func(context.Context, DiagnosticDetectorCollection) (DiagnosticDetectorCollection, error)) DiagnosticDetectorCollectionPage {
	return DiagnosticDetectorCollectionPage{
		fn:  getNextPage,
		ddc: cur,
	}
}

// DiagnosticDetectorResponse class representing Response from Diagnostic Detectors
type DiagnosticDetectorResponse struct {
	autorest.Response `json:"-"`
	// DiagnosticDetectorResponseProperties - DiagnosticDetectorResponse resource specific properties
	*DiagnosticDetectorResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DiagnosticDetectorResponse.
func (ddr DiagnosticDetectorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ddr.DiagnosticDetectorResponseProperties != nil {
		objectMap["properties"] = ddr.DiagnosticDetectorResponseProperties
	}
	if ddr.Kind != nil {
		objectMap["kind"] = ddr.Kind
	}
	if ddr.SystemData != nil {
		objectMap["systemData"] = ddr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DiagnosticDetectorResponse struct.
func (ddr *DiagnosticDetectorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var diagnosticDetectorResponseProperties DiagnosticDetectorResponseProperties
				err = json.Unmarshal(*v, &diagnosticDetectorResponseProperties)
				if err != nil {
					return err
				}
				ddr.DiagnosticDetectorResponseProperties = &diagnosticDetectorResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ddr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ddr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ddr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ddr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ddr.SystemData = &systemData
			}
		}
	}

	return nil
}

// DiagnosticDetectorResponseProperties diagnosticDetectorResponse resource specific properties
type DiagnosticDetectorResponseProperties struct {
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// IssueDetected - Flag representing Issue was detected.
	IssueDetected *bool `json:"issueDetected,omitempty"`
	// DetectorDefinition - Detector's definition
	DetectorDefinition *DetectorDefinition `json:"detectorDefinition,omitempty"`
	// Metrics - Metrics provided by the detector
	Metrics *[]DiagnosticMetricSet `json:"metrics,omitempty"`
	// AbnormalTimePeriods - List of Correlated events found by the detector
	AbnormalTimePeriods *[]DetectorAbnormalTimePeriod `json:"abnormalTimePeriods,omitempty"`
	// Data - Additional Data that detector wants to send.
	Data *[][]NameValuePair `json:"data,omitempty"`
	// ResponseMetaData - Meta Data
	ResponseMetaData *ResponseMetaData `json:"responseMetaData,omitempty"`
}

// DiagnosticMetricSample class representing Diagnostic Metric
type DiagnosticMetricSample struct {
	// Timestamp - Time at which metric is measured
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// RoleInstance - Role Instance. Null if this counter is not per instance
	// This is returned and should be whichever instance name we desire to be returned
	// i.e. CPU and Memory return RDWORKERNAME (LargeDed..._IN_0)
	// where RDWORKERNAME is Machine name below and RoleInstance name in parenthesis
	RoleInstance *string `json:"roleInstance,omitempty"`
	// Total - Total value of the metric. If multiple measurements are made this will have sum of all.
	Total *float64 `json:"total,omitempty"`
	// Maximum - Maximum of the metric sampled during the time period
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - Minimum of the metric sampled during the time period
	Minimum *float64 `json:"minimum,omitempty"`
	// IsAggregated - Whether the values are aggregates across all workers or not
	IsAggregated *bool `json:"isAggregated,omitempty"`
}

// DiagnosticMetricSet class representing Diagnostic Metric information
type DiagnosticMetricSet struct {
	// Name - Name of the metric
	Name *string `json:"name,omitempty"`
	// Unit - Metric's unit
	Unit *string `json:"unit,omitempty"`
	// StartTime - Start time of the period
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - Presented time grain. Supported grains at the moment are PT1M, PT1H, P1D
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Values - Collection of metric values for the selected period based on the {Microsoft.Web.Hosting.Administration.DiagnosticMetricSet.TimeGrain}
	Values *[]DiagnosticMetricSample `json:"values,omitempty"`
}

// Dimension dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
// where instance name is dimension of the metric HTTP request
type Dimension struct {
	Name                   *string `json:"name,omitempty"`
	DisplayName            *string `json:"displayName,omitempty"`
	InternalName           *string `json:"internalName,omitempty"`
	ToBeExportedForShoebox *bool   `json:"toBeExportedForShoebox,omitempty"`
}

// Domain information about a domain.
type Domain struct {
	autorest.Response `json:"-"`
	// DomainProperties - Domain resource specific properties
	*DomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.DomainProperties != nil {
		objectMap["properties"] = d.DomainProperties
	}
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.SystemData != nil {
		objectMap["systemData"] = d.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Domain struct.
func (d *Domain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainProperties DomainProperties
				err = json.Unmarshal(*v, &domainProperties)
				if err != nil {
					return err
				}
				d.DomainProperties = &domainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				d.SystemData = &systemData
			}
		}
	}

	return nil
}

// DomainAvailabilityCheckResult domain availability check result.
type DomainAvailabilityCheckResult struct {
	autorest.Response `json:"-"`
	// Name - Name of the domain.
	Name *string `json:"name,omitempty"`
	// Available - <code>true</code> if domain can be purchased using CreateDomain API; otherwise, <code>false</code>.
	Available *bool `json:"available,omitempty"`
	// DomainType - Valid values are Regular domain: Azure will charge the full price of domain registration, SoftDeleted: Purchasing this domain will simply restore it and this operation will not cost anything. Possible values include: 'Regular', 'SoftDeleted'
	DomainType DomainType `json:"domainType,omitempty"`
}

// DomainCollection collection of domains.
type DomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Domain `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainCollection.
func (dc DomainCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.Value != nil {
		objectMap["value"] = dc.Value
	}
	return json.Marshal(objectMap)
}

// DomainCollectionIterator provides access to a complete listing of Domain values.
type DomainCollectionIterator struct {
	i    int
	page DomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainCollectionIterator) Response() DomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainCollectionIterator) Value() Domain {
	if !iter.page.NotDone() {
		return Domain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainCollectionIterator type.
func NewDomainCollectionIterator(page DomainCollectionPage) DomainCollectionIterator {
	return DomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DomainCollection) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dc DomainCollection) hasNextLink() bool {
	return dc.NextLink != nil && len(*dc.NextLink) != 0
}

// domainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DomainCollection) domainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !dc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DomainCollectionPage contains a page of Domain values.
type DomainCollectionPage struct {
	fn func(context.Context, DomainCollection) (DomainCollection, error)
	dc DomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dc)
		if err != nil {
			return err
		}
		page.dc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainCollectionPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainCollectionPage) Response() DomainCollection {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainCollectionPage) Values() []Domain {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DomainCollectionPage type.
func NewDomainCollectionPage(cur DomainCollection, getNextPage func(context.Context, DomainCollection) (DomainCollection, error)) DomainCollectionPage {
	return DomainCollectionPage{
		fn: getNextPage,
		dc: cur,
	}
}

// DomainControlCenterSsoRequest single sign-on request information for domain management.
type DomainControlCenterSsoRequest struct {
	autorest.Response `json:"-"`
	// URL - READ-ONLY; URL where the single sign-on request is to be made.
	URL *string `json:"url,omitempty"`
	// PostParameterKey - READ-ONLY; Post parameter key.
	PostParameterKey *string `json:"postParameterKey,omitempty"`
	// PostParameterValue - READ-ONLY; Post parameter value. Client should use 'application/x-www-form-urlencoded' encoding for this value.
	PostParameterValue *string `json:"postParameterValue,omitempty"`
}

// DomainOwnershipIdentifier domain ownership Identifier.
type DomainOwnershipIdentifier struct {
	autorest.Response `json:"-"`
	// DomainOwnershipIdentifierProperties - DomainOwnershipIdentifier resource specific properties
	*DomainOwnershipIdentifierProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainOwnershipIdentifier.
func (doi DomainOwnershipIdentifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if doi.DomainOwnershipIdentifierProperties != nil {
		objectMap["properties"] = doi.DomainOwnershipIdentifierProperties
	}
	if doi.Kind != nil {
		objectMap["kind"] = doi.Kind
	}
	if doi.SystemData != nil {
		objectMap["systemData"] = doi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainOwnershipIdentifier struct.
func (doi *DomainOwnershipIdentifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainOwnershipIdentifierProperties DomainOwnershipIdentifierProperties
				err = json.Unmarshal(*v, &domainOwnershipIdentifierProperties)
				if err != nil {
					return err
				}
				doi.DomainOwnershipIdentifierProperties = &domainOwnershipIdentifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				doi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				doi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				doi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				doi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				doi.SystemData = &systemData
			}
		}
	}

	return nil
}

// DomainOwnershipIdentifierCollection collection of domain ownership identifiers.
type DomainOwnershipIdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]DomainOwnershipIdentifier `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainOwnershipIdentifierCollection.
func (doic DomainOwnershipIdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if doic.Value != nil {
		objectMap["value"] = doic.Value
	}
	return json.Marshal(objectMap)
}

// DomainOwnershipIdentifierCollectionIterator provides access to a complete listing of
// DomainOwnershipIdentifier values.
type DomainOwnershipIdentifierCollectionIterator struct {
	i    int
	page DomainOwnershipIdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DomainOwnershipIdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainOwnershipIdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DomainOwnershipIdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DomainOwnershipIdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DomainOwnershipIdentifierCollectionIterator) Response() DomainOwnershipIdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DomainOwnershipIdentifierCollectionIterator) Value() DomainOwnershipIdentifier {
	if !iter.page.NotDone() {
		return DomainOwnershipIdentifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DomainOwnershipIdentifierCollectionIterator type.
func NewDomainOwnershipIdentifierCollectionIterator(page DomainOwnershipIdentifierCollectionPage) DomainOwnershipIdentifierCollectionIterator {
	return DomainOwnershipIdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (doic DomainOwnershipIdentifierCollection) IsEmpty() bool {
	return doic.Value == nil || len(*doic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (doic DomainOwnershipIdentifierCollection) hasNextLink() bool {
	return doic.NextLink != nil && len(*doic.NextLink) != 0
}

// domainOwnershipIdentifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (doic DomainOwnershipIdentifierCollection) domainOwnershipIdentifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !doic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(doic.NextLink)))
}

// DomainOwnershipIdentifierCollectionPage contains a page of DomainOwnershipIdentifier values.
type DomainOwnershipIdentifierCollectionPage struct {
	fn   func(context.Context, DomainOwnershipIdentifierCollection) (DomainOwnershipIdentifierCollection, error)
	doic DomainOwnershipIdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DomainOwnershipIdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DomainOwnershipIdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.doic)
		if err != nil {
			return err
		}
		page.doic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DomainOwnershipIdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DomainOwnershipIdentifierCollectionPage) NotDone() bool {
	return !page.doic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DomainOwnershipIdentifierCollectionPage) Response() DomainOwnershipIdentifierCollection {
	return page.doic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DomainOwnershipIdentifierCollectionPage) Values() []DomainOwnershipIdentifier {
	if page.doic.IsEmpty() {
		return nil
	}
	return *page.doic.Value
}

// Creates a new instance of the DomainOwnershipIdentifierCollectionPage type.
func NewDomainOwnershipIdentifierCollectionPage(cur DomainOwnershipIdentifierCollection, getNextPage func(context.Context, DomainOwnershipIdentifierCollection) (DomainOwnershipIdentifierCollection, error)) DomainOwnershipIdentifierCollectionPage {
	return DomainOwnershipIdentifierCollectionPage{
		fn:   getNextPage,
		doic: cur,
	}
}

// DomainOwnershipIdentifierProperties domainOwnershipIdentifier resource specific properties
type DomainOwnershipIdentifierProperties struct {
	// OwnershipID - Ownership Id.
	OwnershipID *string `json:"ownershipId,omitempty"`
}

// DomainPatchResource ARM resource for a domain.
type DomainPatchResource struct {
	// DomainPatchResourceProperties - DomainPatchResource resource specific properties
	*DomainPatchResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainPatchResource.
func (dpr DomainPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpr.DomainPatchResourceProperties != nil {
		objectMap["properties"] = dpr.DomainPatchResourceProperties
	}
	if dpr.Kind != nil {
		objectMap["kind"] = dpr.Kind
	}
	if dpr.SystemData != nil {
		objectMap["systemData"] = dpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DomainPatchResource struct.
func (dpr *DomainPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var domainPatchResourceProperties DomainPatchResourceProperties
				err = json.Unmarshal(*v, &domainPatchResourceProperties)
				if err != nil {
					return err
				}
				dpr.DomainPatchResourceProperties = &domainPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				dpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// DomainPatchResourceProperties domainPatchResource resource specific properties
type DomainPatchResourceProperties struct {
	// ContactAdmin - Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - READ-ONLY; Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - READ-ONLY; Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - READ-ONLY; Name servers.
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - READ-ONLY; Domain creation timestamp.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - READ-ONLY; Domain expiration timestamp.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - READ-ONLY; <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
	//  it is hosted on name servers Azure has programmatic access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
	// DNSType - Current DNS type. Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	DNSType DNSType `json:"dnsType,omitempty"`
	// DNSZoneID - Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`
	// TargetDNSType - Target DNS type (would be used for migration). Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	TargetDNSType DNSType `json:"targetDnsType,omitempty"`
	AuthCode      *string `json:"authCode,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainPatchResourceProperties.
func (dpr DomainPatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dpr.ContactAdmin != nil {
		objectMap["contactAdmin"] = dpr.ContactAdmin
	}
	if dpr.ContactBilling != nil {
		objectMap["contactBilling"] = dpr.ContactBilling
	}
	if dpr.ContactRegistrant != nil {
		objectMap["contactRegistrant"] = dpr.ContactRegistrant
	}
	if dpr.ContactTech != nil {
		objectMap["contactTech"] = dpr.ContactTech
	}
	if dpr.Privacy != nil {
		objectMap["privacy"] = dpr.Privacy
	}
	if dpr.AutoRenew != nil {
		objectMap["autoRenew"] = dpr.AutoRenew
	}
	if dpr.Consent != nil {
		objectMap["consent"] = dpr.Consent
	}
	if dpr.DNSType != "" {
		objectMap["dnsType"] = dpr.DNSType
	}
	if dpr.DNSZoneID != nil {
		objectMap["dnsZoneId"] = dpr.DNSZoneID
	}
	if dpr.TargetDNSType != "" {
		objectMap["targetDnsType"] = dpr.TargetDNSType
	}
	if dpr.AuthCode != nil {
		objectMap["authCode"] = dpr.AuthCode
	}
	return json.Marshal(objectMap)
}

// DomainProperties domain resource specific properties
type DomainProperties struct {
	// ContactAdmin - Administrative contact.
	ContactAdmin *Contact `json:"contactAdmin,omitempty"`
	// ContactBilling - Billing contact.
	ContactBilling *Contact `json:"contactBilling,omitempty"`
	// ContactRegistrant - Registrant contact.
	ContactRegistrant *Contact `json:"contactRegistrant,omitempty"`
	// ContactTech - Technical contact.
	ContactTech *Contact `json:"contactTech,omitempty"`
	// RegistrationStatus - READ-ONLY; Domain registration status. Possible values include: 'DomainStatusActive', 'DomainStatusAwaiting', 'DomainStatusCancelled', 'DomainStatusConfiscated', 'DomainStatusDisabled', 'DomainStatusExcluded', 'DomainStatusExpired', 'DomainStatusFailed', 'DomainStatusHeld', 'DomainStatusLocked', 'DomainStatusParked', 'DomainStatusPending', 'DomainStatusReserved', 'DomainStatusReverted', 'DomainStatusSuspended', 'DomainStatusTransferred', 'DomainStatusUnknown', 'DomainStatusUnlocked', 'DomainStatusUnparked', 'DomainStatusUpdated', 'DomainStatusJSONConverterFailed'
	RegistrationStatus DomainStatus `json:"registrationStatus,omitempty"`
	// ProvisioningState - READ-ONLY; Domain provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateInProgress', 'ProvisioningStateDeleting'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NameServers - READ-ONLY; Name servers.
	NameServers *[]string `json:"nameServers,omitempty"`
	// Privacy - <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
	// CreatedTime - READ-ONLY; Domain creation timestamp.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ExpirationTime - READ-ONLY; Domain expiration timestamp.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// LastRenewedTime - READ-ONLY; Timestamp when the domain was renewed last time.
	LastRenewedTime *date.Time `json:"lastRenewedTime,omitempty"`
	// AutoRenew - <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
	AutoRenew *bool `json:"autoRenew,omitempty"`
	// ReadyForDNSRecordManagement - READ-ONLY; <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
	//  it is hosted on name servers Azure has programmatic access to.
	ReadyForDNSRecordManagement *bool `json:"readyForDnsRecordManagement,omitempty"`
	// ManagedHostNames - READ-ONLY; All hostnames derived from the domain and assigned to Azure resources.
	ManagedHostNames *[]HostName `json:"managedHostNames,omitempty"`
	// Consent - Legal agreement consent.
	Consent *DomainPurchaseConsent `json:"consent,omitempty"`
	// DomainNotRenewableReasons - READ-ONLY; Reasons why domain is not renewable.
	DomainNotRenewableReasons *[]string `json:"domainNotRenewableReasons,omitempty"`
	// DNSType - Current DNS type. Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	DNSType DNSType `json:"dnsType,omitempty"`
	// DNSZoneID - Azure DNS Zone to use
	DNSZoneID *string `json:"dnsZoneId,omitempty"`
	// TargetDNSType - Target DNS type (would be used for migration). Possible values include: 'AzureDNS', 'DefaultDomainRegistrarDNS'
	TargetDNSType DNSType `json:"targetDnsType,omitempty"`
	AuthCode      *string `json:"authCode,omitempty"`
}

// MarshalJSON is the custom marshaler for DomainProperties.
func (d DomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.ContactAdmin != nil {
		objectMap["contactAdmin"] = d.ContactAdmin
	}
	if d.ContactBilling != nil {
		objectMap["contactBilling"] = d.ContactBilling
	}
	if d.ContactRegistrant != nil {
		objectMap["contactRegistrant"] = d.ContactRegistrant
	}
	if d.ContactTech != nil {
		objectMap["contactTech"] = d.ContactTech
	}
	if d.Privacy != nil {
		objectMap["privacy"] = d.Privacy
	}
	if d.AutoRenew != nil {
		objectMap["autoRenew"] = d.AutoRenew
	}
	if d.Consent != nil {
		objectMap["consent"] = d.Consent
	}
	if d.DNSType != "" {
		objectMap["dnsType"] = d.DNSType
	}
	if d.DNSZoneID != nil {
		objectMap["dnsZoneId"] = d.DNSZoneID
	}
	if d.TargetDNSType != "" {
		objectMap["targetDnsType"] = d.TargetDNSType
	}
	if d.AuthCode != nil {
		objectMap["authCode"] = d.AuthCode
	}
	return json.Marshal(objectMap)
}

// DomainPurchaseConsent domain purchase consent object, representing acceptance of applicable legal
// agreements.
type DomainPurchaseConsent struct {
	// AgreementKeys - List of applicable legal agreement keys. This list can be retrieved using ListLegalAgreements API under <code>TopLevelDomain</code> resource.
	AgreementKeys *[]string `json:"agreementKeys,omitempty"`
	// AgreedBy - Client IP address.
	AgreedBy *string `json:"agreedBy,omitempty"`
	// AgreedAt - Timestamp when the agreements were accepted.
	AgreedAt *date.Time `json:"agreedAt,omitempty"`
}

// DomainRecommendationSearchParameters domain recommendation search parameters.
type DomainRecommendationSearchParameters struct {
	// Keywords - Keywords to be used for generating domain recommendations.
	Keywords *string `json:"keywords,omitempty"`
	// MaxDomainRecommendations - Maximum number of recommendations.
	MaxDomainRecommendations *int32 `json:"maxDomainRecommendations,omitempty"`
}

// DomainsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DomainsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DomainsClient) (Domain, error)
}

// EnabledConfig enabled configuration.
type EnabledConfig struct {
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// EndpointDependency a domain name that a service is reached at, including details of the current
// connection status.
type EndpointDependency struct {
	// DomainName - The domain name of the dependency.
	DomainName *string `json:"domainName,omitempty"`
	// EndpointDetails - The IP Addresses and Ports used when connecting to DomainName.
	EndpointDetails *[]EndpointDetail `json:"endpointDetails,omitempty"`
}

// EndpointDetail current TCP connectivity information from the App Service Environment to a single
// endpoint.
type EndpointDetail struct {
	// IPAddress - An IP Address that Domain Name currently resolves to.
	IPAddress *string `json:"ipAddress,omitempty"`
	// Port - The port an endpoint is connected to.
	Port *int32 `json:"port,omitempty"`
	// Latency - The time in milliseconds it takes for a TCP connection to be created from the App Service Environment to this IpAddress at this Port.
	Latency *float64 `json:"latency,omitempty"`
	// IsAccessible - Whether it is possible to create a TCP connection from the App Service Environment to this IpAddress at this Port.
	IsAccessible *bool `json:"isAccessible,omitempty"`
}

// ErrorEntity body of the error response returned from the API.
type ErrorEntity struct {
	// ExtendedCode - Type of error.
	ExtendedCode *string `json:"extendedCode,omitempty"`
	// MessageTemplate - Message template.
	MessageTemplate *string `json:"messageTemplate,omitempty"`
	// Parameters - Parameters for the template.
	Parameters *[]string `json:"parameters,omitempty"`
	// InnerErrors - Inner errors.
	InnerErrors *[]ErrorEntity `json:"innerErrors,omitempty"`
	// Code - Basic error code.
	Code *string `json:"code,omitempty"`
	// Message - Any details of the error.
	Message *string `json:"message,omitempty"`
}

// Experiments routing rules in production experiments.
type Experiments struct {
	// RampUpRules - List of ramp-up rules.
	RampUpRules *[]RampUpRule `json:"rampUpRules,omitempty"`
}

// Facebook ...
type Facebook struct {
	// FacebookProperties - Facebook resource specific properties
	*FacebookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Facebook.
func (f Facebook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if f.FacebookProperties != nil {
		objectMap["properties"] = f.FacebookProperties
	}
	if f.Kind != nil {
		objectMap["kind"] = f.Kind
	}
	if f.SystemData != nil {
		objectMap["systemData"] = f.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Facebook struct.
func (f *Facebook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var facebookProperties FacebookProperties
				err = json.Unmarshal(*v, &facebookProperties)
				if err != nil {
					return err
				}
				f.FacebookProperties = &facebookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				f.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				f.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				f.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				f.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				f.SystemData = &systemData
			}
		}
	}

	return nil
}

// FacebookProperties facebook resource specific properties
type FacebookProperties struct {
	Enabled         *bool            `json:"enabled,omitempty"`
	Registration    *AppRegistration `json:"registration,omitempty"`
	GraphAPIVersion *string          `json:"graphApiVersion,omitempty"`
	Login           *LoginScopes     `json:"login,omitempty"`
}

// FileSystemApplicationLogsConfig application logs to file system configuration.
type FileSystemApplicationLogsConfig struct {
	// Level - Log level. Possible values include: 'Off', 'Verbose', 'Information', 'Warning', 'Error'
	Level LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig http logs to file system configuration.
type FileSystemHTTPLogsConfig struct {
	// RetentionInMb - Maximum size in megabytes that http log files can use.
	// When reached old log files will be removed to make space for new ones.
	// Value can range between 25 and 100.
	RetentionInMb *int32 `json:"retentionInMb,omitempty"`
	// RetentionInDays - Retention in days.
	// Remove files older than X days.
	// 0 or lower means no retention.
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	// Enabled - True if configuration is enabled, false if it is disabled and null if configuration is not set.
	Enabled *bool `json:"enabled,omitempty"`
}

// FileSystemTokenStore ...
type FileSystemTokenStore struct {
	// FileSystemTokenStoreProperties - FileSystemTokenStore resource specific properties
	*FileSystemTokenStoreProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for FileSystemTokenStore.
func (fsts FileSystemTokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fsts.FileSystemTokenStoreProperties != nil {
		objectMap["properties"] = fsts.FileSystemTokenStoreProperties
	}
	if fsts.Kind != nil {
		objectMap["kind"] = fsts.Kind
	}
	if fsts.SystemData != nil {
		objectMap["systemData"] = fsts.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FileSystemTokenStore struct.
func (fsts *FileSystemTokenStore) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var fileSystemTokenStoreProperties FileSystemTokenStoreProperties
				err = json.Unmarshal(*v, &fileSystemTokenStoreProperties)
				if err != nil {
					return err
				}
				fsts.FileSystemTokenStoreProperties = &fileSystemTokenStoreProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fsts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fsts.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fsts.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fsts.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fsts.SystemData = &systemData
			}
		}
	}

	return nil
}

// FileSystemTokenStoreProperties fileSystemTokenStore resource specific properties
type FileSystemTokenStoreProperties struct {
	Directory *string `json:"directory,omitempty"`
}

// ForwardProxy ...
type ForwardProxy struct {
	// ForwardProxyProperties - ForwardProxy resource specific properties
	*ForwardProxyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ForwardProxy.
func (fp ForwardProxy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.ForwardProxyProperties != nil {
		objectMap["properties"] = fp.ForwardProxyProperties
	}
	if fp.Kind != nil {
		objectMap["kind"] = fp.Kind
	}
	if fp.SystemData != nil {
		objectMap["systemData"] = fp.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ForwardProxy struct.
func (fp *ForwardProxy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var forwardProxyProperties ForwardProxyProperties
				err = json.Unmarshal(*v, &forwardProxyProperties)
				if err != nil {
					return err
				}
				fp.ForwardProxyProperties = &forwardProxyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fp.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fp.SystemData = &systemData
			}
		}
	}

	return nil
}

// ForwardProxyProperties forwardProxy resource specific properties
type ForwardProxyProperties struct {
	// Convention - Possible values include: 'ForwardProxyConventionNoProxy', 'ForwardProxyConventionStandard', 'ForwardProxyConventionCustom'
	Convention            ForwardProxyConvention `json:"convention,omitempty"`
	CustomHostHeaderName  *string                `json:"customHostHeaderName,omitempty"`
	CustomProtoHeaderName *string                `json:"customProtoHeaderName,omitempty"`
}

// FunctionEnvelope function information.
type FunctionEnvelope struct {
	autorest.Response `json:"-"`
	// FunctionEnvelopeProperties - FunctionEnvelope resource specific properties
	*FunctionEnvelopeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionEnvelope.
func (fe FunctionEnvelope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.FunctionEnvelopeProperties != nil {
		objectMap["properties"] = fe.FunctionEnvelopeProperties
	}
	if fe.Kind != nil {
		objectMap["kind"] = fe.Kind
	}
	if fe.SystemData != nil {
		objectMap["systemData"] = fe.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FunctionEnvelope struct.
func (fe *FunctionEnvelope) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var functionEnvelopeProperties FunctionEnvelopeProperties
				err = json.Unmarshal(*v, &functionEnvelopeProperties)
				if err != nil {
					return err
				}
				fe.FunctionEnvelopeProperties = &functionEnvelopeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fe.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fe.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fe.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fe.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				fe.SystemData = &systemData
			}
		}
	}

	return nil
}

// FunctionEnvelopeCollection collection of Kudu function information elements.
type FunctionEnvelopeCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]FunctionEnvelope `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionEnvelopeCollection.
func (fec FunctionEnvelopeCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fec.Value != nil {
		objectMap["value"] = fec.Value
	}
	return json.Marshal(objectMap)
}

// FunctionEnvelopeCollectionIterator provides access to a complete listing of FunctionEnvelope values.
type FunctionEnvelopeCollectionIterator struct {
	i    int
	page FunctionEnvelopeCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FunctionEnvelopeCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionEnvelopeCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FunctionEnvelopeCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FunctionEnvelopeCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FunctionEnvelopeCollectionIterator) Response() FunctionEnvelopeCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FunctionEnvelopeCollectionIterator) Value() FunctionEnvelope {
	if !iter.page.NotDone() {
		return FunctionEnvelope{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FunctionEnvelopeCollectionIterator type.
func NewFunctionEnvelopeCollectionIterator(page FunctionEnvelopeCollectionPage) FunctionEnvelopeCollectionIterator {
	return FunctionEnvelopeCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fec FunctionEnvelopeCollection) IsEmpty() bool {
	return fec.Value == nil || len(*fec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (fec FunctionEnvelopeCollection) hasNextLink() bool {
	return fec.NextLink != nil && len(*fec.NextLink) != 0
}

// functionEnvelopeCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fec FunctionEnvelopeCollection) functionEnvelopeCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !fec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fec.NextLink)))
}

// FunctionEnvelopeCollectionPage contains a page of FunctionEnvelope values.
type FunctionEnvelopeCollectionPage struct {
	fn  func(context.Context, FunctionEnvelopeCollection) (FunctionEnvelopeCollection, error)
	fec FunctionEnvelopeCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FunctionEnvelopeCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FunctionEnvelopeCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.fec)
		if err != nil {
			return err
		}
		page.fec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FunctionEnvelopeCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FunctionEnvelopeCollectionPage) NotDone() bool {
	return !page.fec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FunctionEnvelopeCollectionPage) Response() FunctionEnvelopeCollection {
	return page.fec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FunctionEnvelopeCollectionPage) Values() []FunctionEnvelope {
	if page.fec.IsEmpty() {
		return nil
	}
	return *page.fec.Value
}

// Creates a new instance of the FunctionEnvelopeCollectionPage type.
func NewFunctionEnvelopeCollectionPage(cur FunctionEnvelopeCollection, getNextPage func(context.Context, FunctionEnvelopeCollection) (FunctionEnvelopeCollection, error)) FunctionEnvelopeCollectionPage {
	return FunctionEnvelopeCollectionPage{
		fn:  getNextPage,
		fec: cur,
	}
}

// FunctionEnvelopeProperties functionEnvelope resource specific properties
type FunctionEnvelopeProperties struct {
	// FunctionAppID - Function App ID.
	FunctionAppID *string `json:"function_app_id,omitempty"`
	// ScriptRootPathHref - Script root path URI.
	ScriptRootPathHref *string `json:"script_root_path_href,omitempty"`
	// ScriptHref - Script URI.
	ScriptHref *string `json:"script_href,omitempty"`
	// ConfigHref - Config URI.
	ConfigHref *string `json:"config_href,omitempty"`
	// TestDataHref - Test data URI.
	TestDataHref *string `json:"test_data_href,omitempty"`
	// SecretsFileHref - Secrets file URI.
	SecretsFileHref *string `json:"secrets_file_href,omitempty"`
	// Href - Function URI.
	Href *string `json:"href,omitempty"`
	// Config - Config information.
	Config interface{} `json:"config,omitempty"`
	// Files - File list.
	Files map[string]*string `json:"files"`
	// TestData - Test data used when testing via the Azure Portal.
	TestData *string `json:"test_data,omitempty"`
	// InvokeURLTemplate - The invocation URL
	InvokeURLTemplate *string `json:"invoke_url_template,omitempty"`
	// Language - The function language
	Language *string `json:"language,omitempty"`
	// IsDisabled - Gets or sets a value indicating whether the function is disabled
	IsDisabled *bool `json:"isDisabled,omitempty"`
}

// MarshalJSON is the custom marshaler for FunctionEnvelopeProperties.
func (fe FunctionEnvelopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fe.FunctionAppID != nil {
		objectMap["function_app_id"] = fe.FunctionAppID
	}
	if fe.ScriptRootPathHref != nil {
		objectMap["script_root_path_href"] = fe.ScriptRootPathHref
	}
	if fe.ScriptHref != nil {
		objectMap["script_href"] = fe.ScriptHref
	}
	if fe.ConfigHref != nil {
		objectMap["config_href"] = fe.ConfigHref
	}
	if fe.TestDataHref != nil {
		objectMap["test_data_href"] = fe.TestDataHref
	}
	if fe.SecretsFileHref != nil {
		objectMap["secrets_file_href"] = fe.SecretsFileHref
	}
	if fe.Href != nil {
		objectMap["href"] = fe.Href
	}
	if fe.Config != nil {
		objectMap["config"] = fe.Config
	}
	if fe.Files != nil {
		objectMap["files"] = fe.Files
	}
	if fe.TestData != nil {
		objectMap["test_data"] = fe.TestData
	}
	if fe.InvokeURLTemplate != nil {
		objectMap["invoke_url_template"] = fe.InvokeURLTemplate
	}
	if fe.Language != nil {
		objectMap["language"] = fe.Language
	}
	if fe.IsDisabled != nil {
		objectMap["isDisabled"] = fe.IsDisabled
	}
	return json.Marshal(objectMap)
}

// FunctionSecrets function secrets.
type FunctionSecrets struct {
	autorest.Response `json:"-"`
	// Key - Secret key.
	Key *string `json:"key,omitempty"`
	// TriggerURL - Trigger URL.
	TriggerURL *string `json:"trigger_url,omitempty"`
}

// GeoRegion geographical region.
type GeoRegion struct {
	// GeoRegionProperties - GeoRegion resource specific properties
	*GeoRegionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoRegion.
func (gr GeoRegion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.GeoRegionProperties != nil {
		objectMap["properties"] = gr.GeoRegionProperties
	}
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.SystemData != nil {
		objectMap["systemData"] = gr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoRegion struct.
func (gr *GeoRegion) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoRegionProperties GeoRegionProperties
				err = json.Unmarshal(*v, &geoRegionProperties)
				if err != nil {
					return err
				}
				gr.GeoRegionProperties = &geoRegionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				gr.SystemData = &systemData
			}
		}
	}

	return nil
}

// GeoRegionCollection collection of geographical regions.
type GeoRegionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]GeoRegion `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoRegionCollection.
func (grc GeoRegionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if grc.Value != nil {
		objectMap["value"] = grc.Value
	}
	return json.Marshal(objectMap)
}

// GeoRegionCollectionIterator provides access to a complete listing of GeoRegion values.
type GeoRegionCollectionIterator struct {
	i    int
	page GeoRegionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GeoRegionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GeoRegionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GeoRegionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GeoRegionCollectionIterator) Response() GeoRegionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GeoRegionCollectionIterator) Value() GeoRegion {
	if !iter.page.NotDone() {
		return GeoRegion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GeoRegionCollectionIterator type.
func NewGeoRegionCollectionIterator(page GeoRegionCollectionPage) GeoRegionCollectionIterator {
	return GeoRegionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (grc GeoRegionCollection) IsEmpty() bool {
	return grc.Value == nil || len(*grc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (grc GeoRegionCollection) hasNextLink() bool {
	return grc.NextLink != nil && len(*grc.NextLink) != 0
}

// geoRegionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (grc GeoRegionCollection) geoRegionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !grc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(grc.NextLink)))
}

// GeoRegionCollectionPage contains a page of GeoRegion values.
type GeoRegionCollectionPage struct {
	fn  func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)
	grc GeoRegionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GeoRegionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GeoRegionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.grc)
		if err != nil {
			return err
		}
		page.grc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GeoRegionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GeoRegionCollectionPage) NotDone() bool {
	return !page.grc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GeoRegionCollectionPage) Response() GeoRegionCollection {
	return page.grc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GeoRegionCollectionPage) Values() []GeoRegion {
	if page.grc.IsEmpty() {
		return nil
	}
	return *page.grc.Value
}

// Creates a new instance of the GeoRegionCollectionPage type.
func NewGeoRegionCollectionPage(cur GeoRegionCollection, getNextPage func(context.Context, GeoRegionCollection) (GeoRegionCollection, error)) GeoRegionCollectionPage {
	return GeoRegionCollectionPage{
		fn:  getNextPage,
		grc: cur,
	}
}

// GeoRegionProperties geoRegion resource specific properties
type GeoRegionProperties struct {
	// Description - READ-ONLY; Region description.
	Description *string `json:"description,omitempty"`
	// DisplayName - READ-ONLY; Display name for region.
	DisplayName *string `json:"displayName,omitempty"`
	// OrgDomain - READ-ONLY; Display name for region.
	OrgDomain *string `json:"orgDomain,omitempty"`
}

// GitHub ...
type GitHub struct {
	// GitHubProperties - GitHub resource specific properties
	*GitHubProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GitHub.
func (gh GitHub) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gh.GitHubProperties != nil {
		objectMap["properties"] = gh.GitHubProperties
	}
	if gh.Kind != nil {
		objectMap["kind"] = gh.Kind
	}
	if gh.SystemData != nil {
		objectMap["systemData"] = gh.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GitHub struct.
func (gh *GitHub) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gitHubProperties GitHubProperties
				err = json.Unmarshal(*v, &gitHubProperties)
				if err != nil {
					return err
				}
				gh.GitHubProperties = &gitHubProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gh.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gh.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gh.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				gh.SystemData = &systemData
			}
		}
	}

	return nil
}

// GitHubProperties gitHub resource specific properties
type GitHubProperties struct {
	Enabled      *bool               `json:"enabled,omitempty"`
	Registration *ClientRegistration `json:"registration,omitempty"`
	Login        *LoginScopes        `json:"login,omitempty"`
}

// GlobalCsmSkuDescription a Global SKU Description.
type GlobalCsmSkuDescription struct {
	// Name - Name of the resource SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Service Tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
	// Size - Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`
	// Family - Family code of the resource SKU.
	Family *string `json:"family,omitempty"`
	// Capacity - Min, max, and default scale values of the SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Locations - Locations of the SKU.
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// GlobalValidation ...
type GlobalValidation struct {
	// GlobalValidationProperties - GlobalValidation resource specific properties
	*GlobalValidationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for GlobalValidation.
func (gv GlobalValidation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gv.GlobalValidationProperties != nil {
		objectMap["properties"] = gv.GlobalValidationProperties
	}
	if gv.Kind != nil {
		objectMap["kind"] = gv.Kind
	}
	if gv.SystemData != nil {
		objectMap["systemData"] = gv.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GlobalValidation struct.
func (gv *GlobalValidation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var globalValidationProperties GlobalValidationProperties
				err = json.Unmarshal(*v, &globalValidationProperties)
				if err != nil {
					return err
				}
				gv.GlobalValidationProperties = &globalValidationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gv.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gv.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gv.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				gv.SystemData = &systemData
			}
		}
	}

	return nil
}

// GlobalValidationProperties globalValidation resource specific properties
type GlobalValidationProperties struct {
	RequireAuthentication *bool `json:"requireAuthentication,omitempty"`
	// UnauthenticatedClientAction - Possible values include: 'UnauthenticatedClientActionV2RedirectToLoginPage', 'UnauthenticatedClientActionV2AllowAnonymous', 'UnauthenticatedClientActionV2Return401', 'UnauthenticatedClientActionV2Return403'
	UnauthenticatedClientAction UnauthenticatedClientActionV2 `json:"unauthenticatedClientAction,omitempty"`
	RedirectToProvider          *string                       `json:"redirectToProvider,omitempty"`
	ExcludedPaths               *[]string                     `json:"excludedPaths,omitempty"`
}

// Google ...
type Google struct {
	// GoogleProperties - Google resource specific properties
	*GoogleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Google.
func (g Google) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.GoogleProperties != nil {
		objectMap["properties"] = g.GoogleProperties
	}
	if g.Kind != nil {
		objectMap["kind"] = g.Kind
	}
	if g.SystemData != nil {
		objectMap["systemData"] = g.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Google struct.
func (g *Google) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var googleProperties GoogleProperties
				err = json.Unmarshal(*v, &googleProperties)
				if err != nil {
					return err
				}
				g.GoogleProperties = &googleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				g.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				g.SystemData = &systemData
			}
		}
	}

	return nil
}

// GoogleProperties google resource specific properties
type GoogleProperties struct {
	Enabled      *bool                       `json:"enabled,omitempty"`
	Registration *ClientRegistration         `json:"registration,omitempty"`
	Login        *LoginScopes                `json:"login,omitempty"`
	Validation   *AllowedAudiencesValidation `json:"validation,omitempty"`
}

// HandlerMapping the IIS handler mappings used to define which handler processes HTTP requests with
// certain extension.
// For example, it is used to configure php-cgi.exe process to handle all HTTP requests with *.php
// extension.
type HandlerMapping struct {
	// Extension - Requests with this extension will be handled using the specified FastCGI application.
	Extension *string `json:"extension,omitempty"`
	// ScriptProcessor - The absolute path to the FastCGI application.
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
	// Arguments - Command-line arguments to be passed to the script processor.
	Arguments *string `json:"arguments,omitempty"`
}

// HostingEnvironmentDeploymentInfo information needed to create resources on an App Service Environment.
type HostingEnvironmentDeploymentInfo struct {
	// Name - Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Location - Location of the App Service Environment.
	Location *string `json:"location,omitempty"`
}

// HostingEnvironmentDiagnostics diagnostics for an App Service Environment.
type HostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	// Name - Name/identifier of the diagnostics.
	Name *string `json:"name,omitempty"`
	// DiagnosticsOutput - Diagnostics output.
	DiagnosticsOutput *string `json:"diagnosticsOutput,omitempty"`
}

// HostingEnvironmentProfile specification for an App Service Environment to use for this resource.
type HostingEnvironmentProfile struct {
	// ID - Resource ID of the App Service Environment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the App Service Environment.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the App Service Environment.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HostingEnvironmentProfile.
func (hep HostingEnvironmentProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hep.ID != nil {
		objectMap["id"] = hep.ID
	}
	return json.Marshal(objectMap)
}

// HostKeys functions host level keys.
type HostKeys struct {
	autorest.Response `json:"-"`
	// MasterKey - Secret key.
	MasterKey *string `json:"masterKey,omitempty"`
	// FunctionKeys - Host level function keys.
	FunctionKeys map[string]*string `json:"functionKeys"`
	// SystemKeys - System keys.
	SystemKeys map[string]*string `json:"systemKeys"`
}

// MarshalJSON is the custom marshaler for HostKeys.
func (hk HostKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hk.MasterKey != nil {
		objectMap["masterKey"] = hk.MasterKey
	}
	if hk.FunctionKeys != nil {
		objectMap["functionKeys"] = hk.FunctionKeys
	}
	if hk.SystemKeys != nil {
		objectMap["systemKeys"] = hk.SystemKeys
	}
	return json.Marshal(objectMap)
}

// HostName details of a hostname derived from a domain.
type HostName struct {
	// Name - Name of the hostname.
	Name *string `json:"name,omitempty"`
	// SiteNames - List of apps the hostname is assigned to. This list will have more than one app only if the hostname is pointing to a Traffic Manager.
	SiteNames *[]string `json:"siteNames,omitempty"`
	// AzureResourceName - Name of the Azure resource the hostname is assigned to. If it is assigned to a Traffic Manager then it will be the Traffic Manager name otherwise it will be the app name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Type of the Azure resource the hostname is assigned to. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Type of the DNS record. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Type of the hostname. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
}

// HostNameBinding a hostname binding object.
type HostNameBinding struct {
	autorest.Response `json:"-"`
	// HostNameBindingProperties - HostNameBinding resource specific properties
	*HostNameBindingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HostNameBinding.
func (hnb HostNameBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hnb.HostNameBindingProperties != nil {
		objectMap["properties"] = hnb.HostNameBindingProperties
	}
	if hnb.Kind != nil {
		objectMap["kind"] = hnb.Kind
	}
	if hnb.SystemData != nil {
		objectMap["systemData"] = hnb.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HostNameBinding struct.
func (hnb *HostNameBinding) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hostNameBindingProperties HostNameBindingProperties
				err = json.Unmarshal(*v, &hostNameBindingProperties)
				if err != nil {
					return err
				}
				hnb.HostNameBindingProperties = &hostNameBindingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hnb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hnb.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hnb.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hnb.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hnb.SystemData = &systemData
			}
		}
	}

	return nil
}

// HostNameBindingCollection collection of hostname bindings.
type HostNameBindingCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]HostNameBinding `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HostNameBindingCollection.
func (hnbc HostNameBindingCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hnbc.Value != nil {
		objectMap["value"] = hnbc.Value
	}
	return json.Marshal(objectMap)
}

// HostNameBindingCollectionIterator provides access to a complete listing of HostNameBinding values.
type HostNameBindingCollectionIterator struct {
	i    int
	page HostNameBindingCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HostNameBindingCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HostNameBindingCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HostNameBindingCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HostNameBindingCollectionIterator) Response() HostNameBindingCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HostNameBindingCollectionIterator) Value() HostNameBinding {
	if !iter.page.NotDone() {
		return HostNameBinding{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HostNameBindingCollectionIterator type.
func NewHostNameBindingCollectionIterator(page HostNameBindingCollectionPage) HostNameBindingCollectionIterator {
	return HostNameBindingCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hnbc HostNameBindingCollection) IsEmpty() bool {
	return hnbc.Value == nil || len(*hnbc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hnbc HostNameBindingCollection) hasNextLink() bool {
	return hnbc.NextLink != nil && len(*hnbc.NextLink) != 0
}

// hostNameBindingCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hnbc HostNameBindingCollection) hostNameBindingCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hnbc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hnbc.NextLink)))
}

// HostNameBindingCollectionPage contains a page of HostNameBinding values.
type HostNameBindingCollectionPage struct {
	fn   func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)
	hnbc HostNameBindingCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HostNameBindingCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HostNameBindingCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hnbc)
		if err != nil {
			return err
		}
		page.hnbc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HostNameBindingCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HostNameBindingCollectionPage) NotDone() bool {
	return !page.hnbc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HostNameBindingCollectionPage) Response() HostNameBindingCollection {
	return page.hnbc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HostNameBindingCollectionPage) Values() []HostNameBinding {
	if page.hnbc.IsEmpty() {
		return nil
	}
	return *page.hnbc.Value
}

// Creates a new instance of the HostNameBindingCollectionPage type.
func NewHostNameBindingCollectionPage(cur HostNameBindingCollection, getNextPage func(context.Context, HostNameBindingCollection) (HostNameBindingCollection, error)) HostNameBindingCollectionPage {
	return HostNameBindingCollectionPage{
		fn:   getNextPage,
		hnbc: cur,
	}
}

// HostNameBindingProperties hostNameBinding resource specific properties
type HostNameBindingProperties struct {
	// SiteName - App Service app name.
	SiteName *string `json:"siteName,omitempty"`
	// DomainID - Fully qualified ARM domain resource URI.
	DomainID *string `json:"domainId,omitempty"`
	// AzureResourceName - Azure resource name.
	AzureResourceName *string `json:"azureResourceName,omitempty"`
	// AzureResourceType - Azure resource type. Possible values include: 'Website', 'TrafficManager'
	AzureResourceType AzureResourceType `json:"azureResourceType,omitempty"`
	// CustomHostNameDNSRecordType - Custom DNS record type. Possible values include: 'CName', 'A'
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	// HostNameType - Hostname type. Possible values include: 'Verified', 'Managed'
	HostNameType HostNameType `json:"hostNameType,omitempty"`
	// SslState - SSL type. Possible values include: 'SslStateDisabled', 'SslStateSniEnabled', 'SslStateIPBasedEnabled'
	SslState SslState `json:"sslState,omitempty"`
	// Thumbprint - SSL certificate thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
	// VirtualIP - READ-ONLY; Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
}

// MarshalJSON is the custom marshaler for HostNameBindingProperties.
func (hnb HostNameBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hnb.SiteName != nil {
		objectMap["siteName"] = hnb.SiteName
	}
	if hnb.DomainID != nil {
		objectMap["domainId"] = hnb.DomainID
	}
	if hnb.AzureResourceName != nil {
		objectMap["azureResourceName"] = hnb.AzureResourceName
	}
	if hnb.AzureResourceType != "" {
		objectMap["azureResourceType"] = hnb.AzureResourceType
	}
	if hnb.CustomHostNameDNSRecordType != "" {
		objectMap["customHostNameDnsRecordType"] = hnb.CustomHostNameDNSRecordType
	}
	if hnb.HostNameType != "" {
		objectMap["hostNameType"] = hnb.HostNameType
	}
	if hnb.SslState != "" {
		objectMap["sslState"] = hnb.SslState
	}
	if hnb.Thumbprint != nil {
		objectMap["thumbprint"] = hnb.Thumbprint
	}
	return json.Marshal(objectMap)
}

// HostNameSslState SSL-enabled hostname.
type HostNameSslState struct {
	// Name - Hostname.
	Name *string `json:"name,omitempty"`
	// SslState - SSL type. Possible values include: 'SslStateDisabled', 'SslStateSniEnabled', 'SslStateIPBasedEnabled'
	SslState SslState `json:"sslState,omitempty"`
	// VirtualIP - Virtual IP address assigned to the hostname if IP based SSL is enabled.
	VirtualIP *string `json:"virtualIP,omitempty"`
	// Thumbprint - SSL certificate thumbprint.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// ToUpdate - Set to <code>true</code> to update existing hostname.
	ToUpdate *bool `json:"toUpdate,omitempty"`
	// HostType - Indicates whether the hostname is a standard or repository hostname. Possible values include: 'HostTypeStandard', 'HostTypeRepository'
	HostType HostType `json:"hostType,omitempty"`
}

// HTTPLogsConfig http logs configuration.
type HTTPLogsConfig struct {
	// FileSystem - Http logs to file system configuration.
	FileSystem *FileSystemHTTPLogsConfig `json:"fileSystem,omitempty"`
	// AzureBlobStorage - Http logs to azure blob storage configuration.
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`
}

// HTTPSettings ...
type HTTPSettings struct {
	// HTTPSettingsProperties - HttpSettings resource specific properties
	*HTTPSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPSettings.
func (hs HTTPSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hs.HTTPSettingsProperties != nil {
		objectMap["properties"] = hs.HTTPSettingsProperties
	}
	if hs.Kind != nil {
		objectMap["kind"] = hs.Kind
	}
	if hs.SystemData != nil {
		objectMap["systemData"] = hs.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HTTPSettings struct.
func (hs *HTTPSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var HTTPSettingsProperties HTTPSettingsProperties
				err = json.Unmarshal(*v, &HTTPSettingsProperties)
				if err != nil {
					return err
				}
				hs.HTTPSettingsProperties = &HTTPSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hs.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hs.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hs.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hs.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hs.SystemData = &systemData
			}
		}
	}

	return nil
}

// HTTPSettingsProperties httpSettings resource specific properties
type HTTPSettingsProperties struct {
	RequireHTTPS *bool               `json:"requireHttps,omitempty"`
	Routes       *HTTPSettingsRoutes `json:"routes,omitempty"`
	ForwardProxy *ForwardProxy       `json:"forwardProxy,omitempty"`
}

// HTTPSettingsRoutes ...
type HTTPSettingsRoutes struct {
	// HTTPSettingsRoutesProperties - HttpSettingsRoutes resource specific properties
	*HTTPSettingsRoutesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HTTPSettingsRoutes.
func (hsr HTTPSettingsRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hsr.HTTPSettingsRoutesProperties != nil {
		objectMap["properties"] = hsr.HTTPSettingsRoutesProperties
	}
	if hsr.Kind != nil {
		objectMap["kind"] = hsr.Kind
	}
	if hsr.SystemData != nil {
		objectMap["systemData"] = hsr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HTTPSettingsRoutes struct.
func (hsr *HTTPSettingsRoutes) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var HTTPSettingsRoutesProperties HTTPSettingsRoutesProperties
				err = json.Unmarshal(*v, &HTTPSettingsRoutesProperties)
				if err != nil {
					return err
				}
				hsr.HTTPSettingsRoutesProperties = &HTTPSettingsRoutesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hsr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hsr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hsr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hsr.SystemData = &systemData
			}
		}
	}

	return nil
}

// HTTPSettingsRoutesProperties httpSettingsRoutes resource specific properties
type HTTPSettingsRoutesProperties struct {
	APIPrefix *string `json:"apiPrefix,omitempty"`
}

// HybridConnection hybrid Connection contract. This is used to configure a Hybrid Connection.
type HybridConnection struct {
	autorest.Response `json:"-"`
	// HybridConnectionProperties - HybridConnection resource specific properties
	*HybridConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnection.
func (hc HybridConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hc.HybridConnectionProperties != nil {
		objectMap["properties"] = hc.HybridConnectionProperties
	}
	if hc.Kind != nil {
		objectMap["kind"] = hc.Kind
	}
	if hc.SystemData != nil {
		objectMap["systemData"] = hc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnection struct.
func (hc *HybridConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionProperties HybridConnectionProperties
				err = json.Unmarshal(*v, &hybridConnectionProperties)
				if err != nil {
					return err
				}
				hc.HybridConnectionProperties = &hybridConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hc.SystemData = &systemData
			}
		}
	}

	return nil
}

// HybridConnectionCollection collection of hostname bindings.
type HybridConnectionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]HybridConnection `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionCollection.
func (hcc HybridConnectionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcc.Value != nil {
		objectMap["value"] = hcc.Value
	}
	return json.Marshal(objectMap)
}

// HybridConnectionCollectionIterator provides access to a complete listing of HybridConnection values.
type HybridConnectionCollectionIterator struct {
	i    int
	page HybridConnectionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HybridConnectionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HybridConnectionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HybridConnectionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HybridConnectionCollectionIterator) Response() HybridConnectionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HybridConnectionCollectionIterator) Value() HybridConnection {
	if !iter.page.NotDone() {
		return HybridConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HybridConnectionCollectionIterator type.
func NewHybridConnectionCollectionIterator(page HybridConnectionCollectionPage) HybridConnectionCollectionIterator {
	return HybridConnectionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hcc HybridConnectionCollection) IsEmpty() bool {
	return hcc.Value == nil || len(*hcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hcc HybridConnectionCollection) hasNextLink() bool {
	return hcc.NextLink != nil && len(*hcc.NextLink) != 0
}

// hybridConnectionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hcc HybridConnectionCollection) hybridConnectionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !hcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hcc.NextLink)))
}

// HybridConnectionCollectionPage contains a page of HybridConnection values.
type HybridConnectionCollectionPage struct {
	fn  func(context.Context, HybridConnectionCollection) (HybridConnectionCollection, error)
	hcc HybridConnectionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HybridConnectionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HybridConnectionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hcc)
		if err != nil {
			return err
		}
		page.hcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HybridConnectionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HybridConnectionCollectionPage) NotDone() bool {
	return !page.hcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HybridConnectionCollectionPage) Response() HybridConnectionCollection {
	return page.hcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HybridConnectionCollectionPage) Values() []HybridConnection {
	if page.hcc.IsEmpty() {
		return nil
	}
	return *page.hcc.Value
}

// Creates a new instance of the HybridConnectionCollectionPage type.
func NewHybridConnectionCollectionPage(cur HybridConnectionCollection, getNextPage func(context.Context, HybridConnectionCollection) (HybridConnectionCollection, error)) HybridConnectionCollectionPage {
	return HybridConnectionCollectionPage{
		fn:  getNextPage,
		hcc: cur,
	}
}

// HybridConnectionKey hybrid Connection key contract. This has the send key name and value for a Hybrid
// Connection.
type HybridConnectionKey struct {
	autorest.Response `json:"-"`
	// HybridConnectionKeyProperties - HybridConnectionKey resource specific properties
	*HybridConnectionKeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionKey.
func (hck HybridConnectionKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hck.HybridConnectionKeyProperties != nil {
		objectMap["properties"] = hck.HybridConnectionKeyProperties
	}
	if hck.Kind != nil {
		objectMap["kind"] = hck.Kind
	}
	if hck.SystemData != nil {
		objectMap["systemData"] = hck.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionKey struct.
func (hck *HybridConnectionKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionKeyProperties HybridConnectionKeyProperties
				err = json.Unmarshal(*v, &hybridConnectionKeyProperties)
				if err != nil {
					return err
				}
				hck.HybridConnectionKeyProperties = &hybridConnectionKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hck.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hck.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hck.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hck.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hck.SystemData = &systemData
			}
		}
	}

	return nil
}

// HybridConnectionKeyProperties hybridConnectionKey resource specific properties
type HybridConnectionKeyProperties struct {
	// SendKeyName - READ-ONLY; The name of the send key.
	SendKeyName *string `json:"sendKeyName,omitempty"`
	// SendKeyValue - READ-ONLY; The value of the send key.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`
}

// HybridConnectionLimits hybrid Connection limits contract. This is used to return the plan limits of
// Hybrid Connections.
type HybridConnectionLimits struct {
	autorest.Response `json:"-"`
	// HybridConnectionLimitsProperties - HybridConnectionLimits resource specific properties
	*HybridConnectionLimitsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for HybridConnectionLimits.
func (hcl HybridConnectionLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hcl.HybridConnectionLimitsProperties != nil {
		objectMap["properties"] = hcl.HybridConnectionLimitsProperties
	}
	if hcl.Kind != nil {
		objectMap["kind"] = hcl.Kind
	}
	if hcl.SystemData != nil {
		objectMap["systemData"] = hcl.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HybridConnectionLimits struct.
func (hcl *HybridConnectionLimits) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var hybridConnectionLimitsProperties HybridConnectionLimitsProperties
				err = json.Unmarshal(*v, &hybridConnectionLimitsProperties)
				if err != nil {
					return err
				}
				hcl.HybridConnectionLimitsProperties = &hybridConnectionLimitsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hcl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hcl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				hcl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hcl.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				hcl.SystemData = &systemData
			}
		}
	}

	return nil
}

// HybridConnectionLimitsProperties hybridConnectionLimits resource specific properties
type HybridConnectionLimitsProperties struct {
	// Current - READ-ONLY; The current number of Hybrid Connections.
	Current *int32 `json:"current,omitempty"`
	// Maximum - READ-ONLY; The maximum number of Hybrid Connections allowed.
	Maximum *int32 `json:"maximum,omitempty"`
}

// HybridConnectionProperties hybridConnection resource specific properties
type HybridConnectionProperties struct {
	// ServiceBusNamespace - The name of the Service Bus namespace.
	ServiceBusNamespace *string `json:"serviceBusNamespace,omitempty"`
	// RelayName - The name of the Service Bus relay.
	RelayName *string `json:"relayName,omitempty"`
	// RelayArmURI - The ARM URI to the Service Bus relay.
	RelayArmURI *string `json:"relayArmUri,omitempty"`
	// Hostname - The hostname of the endpoint.
	Hostname *string `json:"hostname,omitempty"`
	// Port - The port of the endpoint.
	Port *int32 `json:"port,omitempty"`
	// SendKeyName - The name of the Service Bus key which has Send permissions. This is used to authenticate to Service Bus.
	SendKeyName *string `json:"sendKeyName,omitempty"`
	// SendKeyValue - The value of the Service Bus key. This is used to authenticate to Service Bus. In ARM this key will not be returned
	// normally, use the POST /listKeys API instead.
	SendKeyValue *string `json:"sendKeyValue,omitempty"`
	// ServiceBusSuffix - The suffix for the service bus endpoint. By default this is .servicebus.windows.net
	ServiceBusSuffix *string `json:"serviceBusSuffix,omitempty"`
}

// Identifier a domain specific resource identifier.
type Identifier struct {
	autorest.Response `json:"-"`
	// IdentifierProperties - Identifier resource specific properties
	*IdentifierProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Identifier.
func (i Identifier) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.IdentifierProperties != nil {
		objectMap["properties"] = i.IdentifierProperties
	}
	if i.Kind != nil {
		objectMap["kind"] = i.Kind
	}
	if i.SystemData != nil {
		objectMap["systemData"] = i.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Identifier struct.
func (i *Identifier) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var identifierProperties IdentifierProperties
				err = json.Unmarshal(*v, &identifierProperties)
				if err != nil {
					return err
				}
				i.IdentifierProperties = &identifierProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				i.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				i.SystemData = &systemData
			}
		}
	}

	return nil
}

// IdentifierCollection collection of identifiers.
type IdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Identifier `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentifierCollection.
func (ic IdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ic.Value != nil {
		objectMap["value"] = ic.Value
	}
	return json.Marshal(objectMap)
}

// IdentifierCollectionIterator provides access to a complete listing of Identifier values.
type IdentifierCollectionIterator struct {
	i    int
	page IdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *IdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *IdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter IdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter IdentifierCollectionIterator) Response() IdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter IdentifierCollectionIterator) Value() Identifier {
	if !iter.page.NotDone() {
		return Identifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the IdentifierCollectionIterator type.
func NewIdentifierCollectionIterator(page IdentifierCollectionPage) IdentifierCollectionIterator {
	return IdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ic IdentifierCollection) IsEmpty() bool {
	return ic.Value == nil || len(*ic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ic IdentifierCollection) hasNextLink() bool {
	return ic.NextLink != nil && len(*ic.NextLink) != 0
}

// identifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ic IdentifierCollection) identifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ic.NextLink)))
}

// IdentifierCollectionPage contains a page of Identifier values.
type IdentifierCollectionPage struct {
	fn func(context.Context, IdentifierCollection) (IdentifierCollection, error)
	ic IdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *IdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ic)
		if err != nil {
			return err
		}
		page.ic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *IdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page IdentifierCollectionPage) NotDone() bool {
	return !page.ic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page IdentifierCollectionPage) Response() IdentifierCollection {
	return page.ic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page IdentifierCollectionPage) Values() []Identifier {
	if page.ic.IsEmpty() {
		return nil
	}
	return *page.ic.Value
}

// Creates a new instance of the IdentifierCollectionPage type.
func NewIdentifierCollectionPage(cur IdentifierCollection, getNextPage func(context.Context, IdentifierCollection) (IdentifierCollection, error)) IdentifierCollectionPage {
	return IdentifierCollectionPage{
		fn: getNextPage,
		ic: cur,
	}
}

// IdentifierProperties identifier resource specific properties
type IdentifierProperties struct {
	// Value - String representation of the identity.
	Value *string `json:"id,omitempty"`
}

// IdentityProviders ...
type IdentityProviders struct {
	// IdentityProvidersProperties - IdentityProviders resource specific properties
	*IdentityProvidersProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityProviders.
func (IP IdentityProviders) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.IdentityProvidersProperties != nil {
		objectMap["properties"] = IP.IdentityProvidersProperties
	}
	if IP.Kind != nil {
		objectMap["kind"] = IP.Kind
	}
	if IP.SystemData != nil {
		objectMap["systemData"] = IP.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for IdentityProviders struct.
func (IP *IdentityProviders) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var identityProvidersProperties IdentityProvidersProperties
				err = json.Unmarshal(*v, &identityProvidersProperties)
				if err != nil {
					return err
				}
				IP.IdentityProvidersProperties = &identityProvidersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				IP.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				IP.SystemData = &systemData
			}
		}
	}

	return nil
}

// IdentityProvidersProperties identityProviders resource specific properties
type IdentityProvidersProperties struct {
	AzureActiveDirectory         *AzureActiveDirectory                   `json:"azureActiveDirectory,omitempty"`
	Facebook                     *Facebook                               `json:"facebook,omitempty"`
	GitHub                       *GitHub                                 `json:"gitHub,omitempty"`
	Google                       *Google                                 `json:"google,omitempty"`
	Twitter                      *Twitter                                `json:"twitter,omitempty"`
	CustomOpenIDConnectProviders map[string]*CustomOpenIDConnectProvider `json:"customOpenIdConnectProviders"`
}

// MarshalJSON is the custom marshaler for IdentityProvidersProperties.
func (IP IdentityProvidersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.AzureActiveDirectory != nil {
		objectMap["azureActiveDirectory"] = IP.AzureActiveDirectory
	}
	if IP.Facebook != nil {
		objectMap["facebook"] = IP.Facebook
	}
	if IP.GitHub != nil {
		objectMap["gitHub"] = IP.GitHub
	}
	if IP.Google != nil {
		objectMap["google"] = IP.Google
	}
	if IP.Twitter != nil {
		objectMap["twitter"] = IP.Twitter
	}
	if IP.CustomOpenIDConnectProviders != nil {
		objectMap["customOpenIdConnectProviders"] = IP.CustomOpenIDConnectProviders
	}
	return json.Marshal(objectMap)
}

// InboundEnvironmentEndpoint the IP Addresses and Ports that require inbound network access to and within
// the subnet of the App Service Environment.
type InboundEnvironmentEndpoint struct {
	// Description - Short text describing the purpose of the network traffic.
	Description *string `json:"description,omitempty"`
	// Endpoints - The IP addresses that network traffic will originate from in cidr notation.
	Endpoints *[]string `json:"endpoints,omitempty"`
	// Ports - The ports that network traffic will arrive to the App Service Environment at.
	Ports *[]string `json:"ports,omitempty"`
}

// InboundEnvironmentEndpointCollection collection of Inbound Environment Endpoints
type InboundEnvironmentEndpointCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]InboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InboundEnvironmentEndpointCollection.
func (ieec InboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ieec.Value != nil {
		objectMap["value"] = ieec.Value
	}
	return json.Marshal(objectMap)
}

// InboundEnvironmentEndpointCollectionIterator provides access to a complete listing of
// InboundEnvironmentEndpoint values.
type InboundEnvironmentEndpointCollectionIterator struct {
	i    int
	page InboundEnvironmentEndpointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InboundEnvironmentEndpointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundEnvironmentEndpointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InboundEnvironmentEndpointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InboundEnvironmentEndpointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InboundEnvironmentEndpointCollectionIterator) Response() InboundEnvironmentEndpointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InboundEnvironmentEndpointCollectionIterator) Value() InboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return InboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InboundEnvironmentEndpointCollectionIterator type.
func NewInboundEnvironmentEndpointCollectionIterator(page InboundEnvironmentEndpointCollectionPage) InboundEnvironmentEndpointCollectionIterator {
	return InboundEnvironmentEndpointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ieec InboundEnvironmentEndpointCollection) IsEmpty() bool {
	return ieec.Value == nil || len(*ieec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ieec InboundEnvironmentEndpointCollection) hasNextLink() bool {
	return ieec.NextLink != nil && len(*ieec.NextLink) != 0
}

// inboundEnvironmentEndpointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ieec InboundEnvironmentEndpointCollection) inboundEnvironmentEndpointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ieec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ieec.NextLink)))
}

// InboundEnvironmentEndpointCollectionPage contains a page of InboundEnvironmentEndpoint values.
type InboundEnvironmentEndpointCollectionPage struct {
	fn   func(context.Context, InboundEnvironmentEndpointCollection) (InboundEnvironmentEndpointCollection, error)
	ieec InboundEnvironmentEndpointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InboundEnvironmentEndpointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InboundEnvironmentEndpointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ieec)
		if err != nil {
			return err
		}
		page.ieec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InboundEnvironmentEndpointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InboundEnvironmentEndpointCollectionPage) NotDone() bool {
	return !page.ieec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InboundEnvironmentEndpointCollectionPage) Response() InboundEnvironmentEndpointCollection {
	return page.ieec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InboundEnvironmentEndpointCollectionPage) Values() []InboundEnvironmentEndpoint {
	if page.ieec.IsEmpty() {
		return nil
	}
	return *page.ieec.Value
}

// Creates a new instance of the InboundEnvironmentEndpointCollectionPage type.
func NewInboundEnvironmentEndpointCollectionPage(cur InboundEnvironmentEndpointCollection, getNextPage func(context.Context, InboundEnvironmentEndpointCollection) (InboundEnvironmentEndpointCollection, error)) InboundEnvironmentEndpointCollectionPage {
	return InboundEnvironmentEndpointCollectionPage{
		fn:   getNextPage,
		ieec: cur,
	}
}

// IPSecurityRestriction IP security restriction on an app.
type IPSecurityRestriction struct {
	// IPAddress - IP address the security restriction is valid for.
	// It can be in form of pure ipv4 address (required SubnetMask property) or
	// CIDR notation such as ipv4/mask (leading bit match). For CIDR,
	// SubnetMask property must not be specified.
	IPAddress *string `json:"ipAddress,omitempty"`
	// SubnetMask - Subnet mask for the range of IP addresses the restriction is valid for.
	SubnetMask *string `json:"subnetMask,omitempty"`
	// VnetSubnetResourceID - Virtual network resource id
	VnetSubnetResourceID *string `json:"vnetSubnetResourceId,omitempty"`
	// VnetTrafficTag - (internal) Vnet traffic tag
	VnetTrafficTag *int32 `json:"vnetTrafficTag,omitempty"`
	// SubnetTrafficTag - (internal) Subnet traffic tag
	SubnetTrafficTag *int32 `json:"subnetTrafficTag,omitempty"`
	// Action - Allow or Deny access for this IP range.
	Action *string `json:"action,omitempty"`
	// Tag - Defines what this IP filter will be used for. This is to support IP filtering on proxies. Possible values include: 'Default', 'XffProxy', 'ServiceTag'
	Tag IPFilterTag `json:"tag,omitempty"`
	// Priority - Priority of IP restriction rule.
	Priority *int32 `json:"priority,omitempty"`
	// Name - IP restriction rule name.
	Name *string `json:"name,omitempty"`
	// Description - IP restriction rule description.
	Description *string `json:"description,omitempty"`
	// Headers - IP restriction rule headers.
	// X-Forwarded-Host (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
	// The matching logic is ..
	// - If the property is null or empty (default), all hosts(or lack of) are allowed.
	// - A value is compared using ordinal-ignore-case (excluding port number).
	// - Subdomain wildcards are permitted but don't match the root domain. For example, *.contoso.com matches the subdomain foo.contoso.com
	//  but not the root domain contoso.com or multi-level foo.bar.contoso.com
	// - Unicode host names are allowed but are converted to Punycode for matching.
	// X-Forwarded-For (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
	// The matching logic is ..
	// - If the property is null or empty (default), any forwarded-for chains (or lack of) are allowed.
	// - If any address (excluding port number) in the chain (comma separated) matches the CIDR defined by the property.
	// X-Azure-FDID and X-FD-HealthProbe.
	// The matching logic is exact match.
	Headers map[string][]string `json:"headers"`
}

// MarshalJSON is the custom marshaler for IPSecurityRestriction.
func (isr IPSecurityRestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if isr.IPAddress != nil {
		objectMap["ipAddress"] = isr.IPAddress
	}
	if isr.SubnetMask != nil {
		objectMap["subnetMask"] = isr.SubnetMask
	}
	if isr.VnetSubnetResourceID != nil {
		objectMap["vnetSubnetResourceId"] = isr.VnetSubnetResourceID
	}
	if isr.VnetTrafficTag != nil {
		objectMap["vnetTrafficTag"] = isr.VnetTrafficTag
	}
	if isr.SubnetTrafficTag != nil {
		objectMap["subnetTrafficTag"] = isr.SubnetTrafficTag
	}
	if isr.Action != nil {
		objectMap["action"] = isr.Action
	}
	if isr.Tag != "" {
		objectMap["tag"] = isr.Tag
	}
	if isr.Priority != nil {
		objectMap["priority"] = isr.Priority
	}
	if isr.Name != nil {
		objectMap["name"] = isr.Name
	}
	if isr.Description != nil {
		objectMap["description"] = isr.Description
	}
	if isr.Headers != nil {
		objectMap["headers"] = isr.Headers
	}
	return json.Marshal(objectMap)
}

// Job web Job Information.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - WebJob resource specific properties
	*JobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.Kind != nil {
		objectMap["kind"] = j.Kind
	}
	if j.SystemData != nil {
		objectMap["systemData"] = j.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				j.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				j.SystemData = &systemData
			}
		}
	}

	return nil
}

// JobCollection collection of Kudu web job information elements.
type JobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCollection.
func (jc JobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jc.Value != nil {
		objectMap["value"] = jc.Value
	}
	return json.Marshal(objectMap)
}

// JobCollectionIterator provides access to a complete listing of Job values.
type JobCollectionIterator struct {
	i    int
	page JobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCollectionIterator) Response() JobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCollectionIterator type.
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return JobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jc JobCollection) IsEmpty() bool {
	return jc.Value == nil || len(*jc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jc JobCollection) hasNextLink() bool {
	return jc.NextLink != nil && len(*jc.NextLink) != 0
}

// jobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jc JobCollection) jobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !jc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jc.NextLink)))
}

// JobCollectionPage contains a page of Job values.
type JobCollectionPage struct {
	fn func(context.Context, JobCollection) (JobCollection, error)
	jc JobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jc)
		if err != nil {
			return err
		}
		page.jc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionPage) NotDone() bool {
	return !page.jc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCollectionPage) Response() JobCollection {
	return page.jc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionPage) Values() []Job {
	if page.jc.IsEmpty() {
		return nil
	}
	return *page.jc.Value
}

// Creates a new instance of the JobCollectionPage type.
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return JobCollectionPage{
		fn: getNextPage,
		jc: cur,
	}
}

// JobProperties webJob resource specific properties
type JobProperties struct {
	// RunCommand - Run command.
	RunCommand *string `json:"run_command,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`
	// WebJobType - Job type. Possible values include: 'Continuous', 'Triggered'
	WebJobType JobType `json:"web_job_type,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (j JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.RunCommand != nil {
		objectMap["run_command"] = j.RunCommand
	}
	if j.URL != nil {
		objectMap["url"] = j.URL
	}
	if j.ExtraInfoURL != nil {
		objectMap["extra_info_url"] = j.ExtraInfoURL
	}
	if j.WebJobType != "" {
		objectMap["web_job_type"] = j.WebJobType
	}
	if j.Error != nil {
		objectMap["error"] = j.Error
	}
	if j.UsingSdk != nil {
		objectMap["using_sdk"] = j.UsingSdk
	}
	if j.Settings != nil {
		objectMap["settings"] = j.Settings
	}
	return json.Marshal(objectMap)
}

// JwtClaimChecks ...
type JwtClaimChecks struct {
	// JwtClaimChecksProperties - JwtClaimChecks resource specific properties
	*JwtClaimChecksProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for JwtClaimChecks.
func (jcc JwtClaimChecks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jcc.JwtClaimChecksProperties != nil {
		objectMap["properties"] = jcc.JwtClaimChecksProperties
	}
	if jcc.Kind != nil {
		objectMap["kind"] = jcc.Kind
	}
	if jcc.SystemData != nil {
		objectMap["systemData"] = jcc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JwtClaimChecks struct.
func (jcc *JwtClaimChecks) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jwtClaimChecksProperties JwtClaimChecksProperties
				err = json.Unmarshal(*v, &jwtClaimChecksProperties)
				if err != nil {
					return err
				}
				jcc.JwtClaimChecksProperties = &jwtClaimChecksProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jcc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jcc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				jcc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jcc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				jcc.SystemData = &systemData
			}
		}
	}

	return nil
}

// JwtClaimChecksProperties jwtClaimChecks resource specific properties
type JwtClaimChecksProperties struct {
	AllowedGroups             *[]string `json:"allowedGroups,omitempty"`
	AllowedClientApplications *[]string `json:"allowedClientApplications,omitempty"`
}

// KeyInfo function key info.
type KeyInfo struct {
	autorest.Response `json:"-"`
	// Name - Key name
	Name *string `json:"name,omitempty"`
	// Value - Key value
	Value *string `json:"value,omitempty"`
}

// ListCapability ...
type ListCapability struct {
	autorest.Response `json:"-"`
	Value             *[]Capability `json:"value,omitempty"`
}

// ListCertificateEmail ...
type ListCertificateEmail struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateEmail `json:"value,omitempty"`
}

// ListCertificateOrderAction ...
type ListCertificateOrderAction struct {
	autorest.Response `json:"-"`
	Value             *[]CertificateOrderAction `json:"value,omitempty"`
}

// ListHostingEnvironmentDiagnostics ...
type ListHostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironmentDiagnostics `json:"value,omitempty"`
}

// ListNetworkTrace ...
type ListNetworkTrace struct {
	autorest.Response `json:"-"`
	Value             *[]NetworkTrace `json:"value,omitempty"`
}

// ListOperation ...
type ListOperation struct {
	autorest.Response `json:"-"`
	Value             *[]Operation `json:"value,omitempty"`
}

// ListVnetInfo ...
type ListVnetInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VnetInfo `json:"value,omitempty"`
}

// ListVnetRoute ...
type ListVnetRoute struct {
	autorest.Response `json:"-"`
	Value             *[]VnetRoute `json:"value,omitempty"`
}

// LocalizableString localizable string object containing the name and a localized value.
type LocalizableString struct {
	// Value - Non-localized name.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - Localized name.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// Login ...
type Login struct {
	// LoginProperties - Login resource specific properties
	*LoginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Login.
func (l Login) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LoginProperties != nil {
		objectMap["properties"] = l.LoginProperties
	}
	if l.Kind != nil {
		objectMap["kind"] = l.Kind
	}
	if l.SystemData != nil {
		objectMap["systemData"] = l.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Login struct.
func (l *Login) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loginProperties LoginProperties
				err = json.Unmarshal(*v, &loginProperties)
				if err != nil {
					return err
				}
				l.LoginProperties = &loginProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				l.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				l.SystemData = &systemData
			}
		}
	}

	return nil
}

// LoginProperties login resource specific properties
type LoginProperties struct {
	Routes                        *LoginRoutes      `json:"routes,omitempty"`
	TokenStore                    *TokenStore       `json:"tokenStore,omitempty"`
	PreserveURLFragmentsForLogins *bool             `json:"preserveUrlFragmentsForLogins,omitempty"`
	AllowedExternalRedirectUrls   *[]string         `json:"allowedExternalRedirectUrls,omitempty"`
	CookieExpiration              *CookieExpiration `json:"cookieExpiration,omitempty"`
	Nonce                         *Nonce            `json:"nonce,omitempty"`
}

// LoginRoutes ...
type LoginRoutes struct {
	// LoginRoutesProperties - LoginRoutes resource specific properties
	*LoginRoutesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for LoginRoutes.
func (lr LoginRoutes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.LoginRoutesProperties != nil {
		objectMap["properties"] = lr.LoginRoutesProperties
	}
	if lr.Kind != nil {
		objectMap["kind"] = lr.Kind
	}
	if lr.SystemData != nil {
		objectMap["systemData"] = lr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoginRoutes struct.
func (lr *LoginRoutes) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loginRoutesProperties LoginRoutesProperties
				err = json.Unmarshal(*v, &loginRoutesProperties)
				if err != nil {
					return err
				}
				lr.LoginRoutesProperties = &loginRoutesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				lr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				lr.SystemData = &systemData
			}
		}
	}

	return nil
}

// LoginRoutesProperties loginRoutes resource specific properties
type LoginRoutesProperties struct {
	LogoutEndpoint *string `json:"logoutEndpoint,omitempty"`
}

// LoginScopes ...
type LoginScopes struct {
	// LoginScopesProperties - LoginScopes resource specific properties
	*LoginScopesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for LoginScopes.
func (ls LoginScopes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ls.LoginScopesProperties != nil {
		objectMap["properties"] = ls.LoginScopesProperties
	}
	if ls.Kind != nil {
		objectMap["kind"] = ls.Kind
	}
	if ls.SystemData != nil {
		objectMap["systemData"] = ls.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LoginScopes struct.
func (ls *LoginScopes) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var loginScopesProperties LoginScopesProperties
				err = json.Unmarshal(*v, &loginScopesProperties)
				if err != nil {
					return err
				}
				ls.LoginScopesProperties = &loginScopesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ls.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ls.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ls.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ls.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ls.SystemData = &systemData
			}
		}
	}

	return nil
}

// LoginScopesProperties loginScopes resource specific properties
type LoginScopesProperties struct {
	Scopes *[]string `json:"scopes,omitempty"`
}

// LogSpecification log Definition of a single resource metric.
type LogSpecification struct {
	Name             *string `json:"name,omitempty"`
	DisplayName      *string `json:"displayName,omitempty"`
	BlobDuration     *string `json:"blobDuration,omitempty"`
	LogFilterPattern *string `json:"logFilterPattern,omitempty"`
}

// ManagedServiceIdentity managed service identity.
type ManagedServiceIdentity struct {
	// Type - Type of managed service identity. Possible values include: 'ManagedServiceIdentityTypeSystemAssigned', 'ManagedServiceIdentityTypeUserAssigned', 'ManagedServiceIdentityTypeSystemAssignedUserAssigned', 'ManagedServiceIdentityTypeNone'
	Type ManagedServiceIdentityType `json:"type,omitempty"`
	// TenantID - READ-ONLY; Tenant of managed service identity.
	TenantID *string `json:"tenantId,omitempty"`
	// PrincipalID - READ-ONLY; Principal Id of managed service identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// UserAssignedIdentities - The list of user assigned identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}
	UserAssignedIdentities map[string]*ManagedServiceIdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for ManagedServiceIdentity.
func (msi ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if msi.Type != "" {
		objectMap["type"] = msi.Type
	}
	if msi.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = msi.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ManagedServiceIdentityUserAssignedIdentitiesValue ...
type ManagedServiceIdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; Principal Id of user assigned identity
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; Client Id of user assigned identity
	ClientID *string `json:"clientId,omitempty"`
}

// MetricAvailability retention policy of a resource metric.
type MetricAvailability struct {
	TimeGrain    *string `json:"timeGrain,omitempty"`
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricSpecification definition of a single resource metric.
type MetricSpecification struct {
	Name                             *string               `json:"name,omitempty"`
	DisplayName                      *string               `json:"displayName,omitempty"`
	DisplayDescription               *string               `json:"displayDescription,omitempty"`
	Unit                             *string               `json:"unit,omitempty"`
	AggregationType                  *string               `json:"aggregationType,omitempty"`
	SupportsInstanceLevelAggregation *bool                 `json:"supportsInstanceLevelAggregation,omitempty"`
	EnableRegionalMdmAccount         *bool                 `json:"enableRegionalMdmAccount,omitempty"`
	SourceMdmAccount                 *string               `json:"sourceMdmAccount,omitempty"`
	SourceMdmNamespace               *string               `json:"sourceMdmNamespace,omitempty"`
	MetricFilterPattern              *string               `json:"metricFilterPattern,omitempty"`
	FillGapWithZero                  *bool                 `json:"fillGapWithZero,omitempty"`
	IsInternal                       *bool                 `json:"isInternal,omitempty"`
	Dimensions                       *[]Dimension          `json:"dimensions,omitempty"`
	Category                         *string               `json:"category,omitempty"`
	Availabilities                   *[]MetricAvailability `json:"availabilities,omitempty"`
	SupportedTimeGrainTypes          *[]string             `json:"supportedTimeGrainTypes,omitempty"`
	SupportedAggregationTypes        *[]string             `json:"supportedAggregationTypes,omitempty"`
}

// MigrateMySQLRequest mySQL migration request.
type MigrateMySQLRequest struct {
	// MigrateMySQLRequestProperties - MigrateMySqlRequest resource specific properties
	*MigrateMySQLRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLRequest.
func (mmsr MigrateMySQLRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmsr.MigrateMySQLRequestProperties != nil {
		objectMap["properties"] = mmsr.MigrateMySQLRequestProperties
	}
	if mmsr.Kind != nil {
		objectMap["kind"] = mmsr.Kind
	}
	if mmsr.SystemData != nil {
		objectMap["systemData"] = mmsr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLRequest struct.
func (mmsr *MigrateMySQLRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var migrateMySQLRequestProperties MigrateMySQLRequestProperties
				err = json.Unmarshal(*v, &migrateMySQLRequestProperties)
				if err != nil {
					return err
				}
				mmsr.MigrateMySQLRequestProperties = &migrateMySQLRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mmsr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmsr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mmsr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mmsr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mmsr.SystemData = &systemData
			}
		}
	}

	return nil
}

// MigrateMySQLRequestProperties migrateMySqlRequest resource specific properties
type MigrateMySQLRequestProperties struct {
	// ConnectionString - Connection string to the remote MySQL database.
	ConnectionString *string `json:"connectionString,omitempty"`
	// MigrationType - The type of migration operation to be done. Possible values include: 'LocalToRemote', 'RemoteToLocal'
	MigrationType MySQLMigrationType `json:"migrationType,omitempty"`
}

// MigrateMySQLStatus mySQL migration status.
type MigrateMySQLStatus struct {
	autorest.Response `json:"-"`
	// MigrateMySQLStatusProperties - MigrateMySqlStatus resource specific properties
	*MigrateMySQLStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MigrateMySQLStatus.
func (mmss MigrateMySQLStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mmss.MigrateMySQLStatusProperties != nil {
		objectMap["properties"] = mmss.MigrateMySQLStatusProperties
	}
	if mmss.Kind != nil {
		objectMap["kind"] = mmss.Kind
	}
	if mmss.SystemData != nil {
		objectMap["systemData"] = mmss.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MigrateMySQLStatus struct.
func (mmss *MigrateMySQLStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var migrateMySQLStatusProperties MigrateMySQLStatusProperties
				err = json.Unmarshal(*v, &migrateMySQLStatusProperties)
				if err != nil {
					return err
				}
				mmss.MigrateMySQLStatusProperties = &migrateMySQLStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mmss.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mmss.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mmss.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mmss.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mmss.SystemData = &systemData
			}
		}
	}

	return nil
}

// MigrateMySQLStatusProperties migrateMySqlStatus resource specific properties
type MigrateMySQLStatusProperties struct {
	// MigrationOperationStatus - READ-ONLY; Status of the migration task. Possible values include: 'OperationStatusInProgress', 'OperationStatusFailed', 'OperationStatusSucceeded', 'OperationStatusTimedOut', 'OperationStatusCreated'
	MigrationOperationStatus OperationStatus `json:"migrationOperationStatus,omitempty"`
	// OperationID - READ-ONLY; Operation ID for the migration task.
	OperationID *string `json:"operationId,omitempty"`
	// LocalMySQLEnabled - READ-ONLY; True if the web app has in app MySql enabled
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`
}

// MSDeploy mSDeploy ARM PUT information
type MSDeploy struct {
	// MSDeployCore - Core resource properties
	*MSDeployCore `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeploy.
func (md MSDeploy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.MSDeployCore != nil {
		objectMap["properties"] = md.MSDeployCore
	}
	if md.Kind != nil {
		objectMap["kind"] = md.Kind
	}
	if md.SystemData != nil {
		objectMap["systemData"] = md.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeploy struct.
func (md *MSDeploy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployCore MSDeployCore
				err = json.Unmarshal(*v, &mSDeployCore)
				if err != nil {
					return err
				}
				md.MSDeployCore = &mSDeployCore
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				md.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				md.SystemData = &systemData
			}
		}
	}

	return nil
}

// MSDeployCore mSDeploy ARM PUT core information
type MSDeployCore struct {
	// PackageURI - Package URI
	PackageURI *string `json:"packageUri,omitempty"`
	// ConnectionString - SQL Connection String
	ConnectionString *string `json:"connectionString,omitempty"`
	// DbType - Database Type
	DbType *string `json:"dbType,omitempty"`
	// SetParametersXMLFileURI - URI of MSDeploy Parameters file. Must not be set if SetParameters is used.
	SetParametersXMLFileURI *string `json:"setParametersXmlFileUri,omitempty"`
	// SetParameters - MSDeploy Parameters. Must not be set if SetParametersXmlFileUri is used.
	SetParameters map[string]*string `json:"setParameters"`
	// SkipAppData - Controls whether the MSDeploy operation skips the App_Data directory.
	// If set to <code>true</code>, the existing App_Data directory on the destination
	// will not be deleted, and any App_Data directory in the source will be ignored.
	// Setting is <code>false</code> by default.
	SkipAppData *bool `json:"skipAppData,omitempty"`
	// AppOffline - Sets the AppOffline rule while the MSDeploy operation executes.
	// Setting is <code>false</code> by default.
	AppOffline *bool `json:"appOffline,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployCore.
func (mdc MSDeployCore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdc.PackageURI != nil {
		objectMap["packageUri"] = mdc.PackageURI
	}
	if mdc.ConnectionString != nil {
		objectMap["connectionString"] = mdc.ConnectionString
	}
	if mdc.DbType != nil {
		objectMap["dbType"] = mdc.DbType
	}
	if mdc.SetParametersXMLFileURI != nil {
		objectMap["setParametersXmlFileUri"] = mdc.SetParametersXMLFileURI
	}
	if mdc.SetParameters != nil {
		objectMap["setParameters"] = mdc.SetParameters
	}
	if mdc.SkipAppData != nil {
		objectMap["skipAppData"] = mdc.SkipAppData
	}
	if mdc.AppOffline != nil {
		objectMap["appOffline"] = mdc.AppOffline
	}
	return json.Marshal(objectMap)
}

// MSDeployLog mSDeploy log
type MSDeployLog struct {
	autorest.Response `json:"-"`
	// MSDeployLogProperties - MSDeployLog resource specific properties
	*MSDeployLogProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployLog.
func (mdl MSDeployLog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdl.MSDeployLogProperties != nil {
		objectMap["properties"] = mdl.MSDeployLogProperties
	}
	if mdl.Kind != nil {
		objectMap["kind"] = mdl.Kind
	}
	if mdl.SystemData != nil {
		objectMap["systemData"] = mdl.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeployLog struct.
func (mdl *MSDeployLog) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployLogProperties MSDeployLogProperties
				err = json.Unmarshal(*v, &mSDeployLogProperties)
				if err != nil {
					return err
				}
				mdl.MSDeployLogProperties = &mSDeployLogProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mdl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdl.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mdl.SystemData = &systemData
			}
		}
	}

	return nil
}

// MSDeployLogEntry mSDeploy log entry
type MSDeployLogEntry struct {
	// Time - READ-ONLY; Timestamp of log entry
	Time *date.Time `json:"time,omitempty"`
	// Type - READ-ONLY; Log entry type. Possible values include: 'MSDeployLogEntryTypeMessage', 'MSDeployLogEntryTypeWarning', 'MSDeployLogEntryTypeError'
	Type MSDeployLogEntryType `json:"type,omitempty"`
	// Message - READ-ONLY; Log entry message
	Message *string `json:"message,omitempty"`
}

// MSDeployLogProperties mSDeployLog resource specific properties
type MSDeployLogProperties struct {
	// Entries - READ-ONLY; List of log entry messages
	Entries *[]MSDeployLogEntry `json:"entries,omitempty"`
}

// MSDeployStatus mSDeploy ARM response
type MSDeployStatus struct {
	autorest.Response `json:"-"`
	// MSDeployStatusProperties - MSDeployStatus resource specific properties
	*MSDeployStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MSDeployStatus.
func (mds MSDeployStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mds.MSDeployStatusProperties != nil {
		objectMap["properties"] = mds.MSDeployStatusProperties
	}
	if mds.Kind != nil {
		objectMap["kind"] = mds.Kind
	}
	if mds.SystemData != nil {
		objectMap["systemData"] = mds.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MSDeployStatus struct.
func (mds *MSDeployStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mSDeployStatusProperties MSDeployStatusProperties
				err = json.Unmarshal(*v, &mSDeployStatusProperties)
				if err != nil {
					return err
				}
				mds.MSDeployStatusProperties = &mSDeployStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mds.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mds.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mds.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mds.SystemData = &systemData
			}
		}
	}

	return nil
}

// MSDeployStatusProperties mSDeployStatus resource specific properties
type MSDeployStatusProperties struct {
	// Deployer - READ-ONLY; Username of deployer
	Deployer *string `json:"deployer,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'MSDeployProvisioningStateAccepted', 'MSDeployProvisioningStateRunning', 'MSDeployProvisioningStateSucceeded', 'MSDeployProvisioningStateFailed', 'MSDeployProvisioningStateCanceled'
	ProvisioningState MSDeployProvisioningState `json:"provisioningState,omitempty"`
	// StartTime - READ-ONLY; Start time of deploy operation
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time of deploy operation
	EndTime *date.Time `json:"endTime,omitempty"`
	// Complete - READ-ONLY; Whether the deployment operation has completed
	Complete *bool `json:"complete,omitempty"`
}

// NameIdentifier identifies an object.
type NameIdentifier struct {
	// Name - Name of the object.
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection collection of domain name identifiers.
type NameIdentifierCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]NameIdentifier `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for NameIdentifierCollection.
func (nic NameIdentifierCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nic.Value != nil {
		objectMap["value"] = nic.Value
	}
	return json.Marshal(objectMap)
}

// NameIdentifierCollectionIterator provides access to a complete listing of NameIdentifier values.
type NameIdentifierCollectionIterator struct {
	i    int
	page NameIdentifierCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *NameIdentifierCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *NameIdentifierCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter NameIdentifierCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter NameIdentifierCollectionIterator) Response() NameIdentifierCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter NameIdentifierCollectionIterator) Value() NameIdentifier {
	if !iter.page.NotDone() {
		return NameIdentifier{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the NameIdentifierCollectionIterator type.
func NewNameIdentifierCollectionIterator(page NameIdentifierCollectionPage) NameIdentifierCollectionIterator {
	return NameIdentifierCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (nic NameIdentifierCollection) IsEmpty() bool {
	return nic.Value == nil || len(*nic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (nic NameIdentifierCollection) hasNextLink() bool {
	return nic.NextLink != nil && len(*nic.NextLink) != 0
}

// nameIdentifierCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (nic NameIdentifierCollection) nameIdentifierCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !nic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(nic.NextLink)))
}

// NameIdentifierCollectionPage contains a page of NameIdentifier values.
type NameIdentifierCollectionPage struct {
	fn  func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)
	nic NameIdentifierCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *NameIdentifierCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/NameIdentifierCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.nic)
		if err != nil {
			return err
		}
		page.nic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *NameIdentifierCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page NameIdentifierCollectionPage) NotDone() bool {
	return !page.nic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page NameIdentifierCollectionPage) Response() NameIdentifierCollection {
	return page.nic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page NameIdentifierCollectionPage) Values() []NameIdentifier {
	if page.nic.IsEmpty() {
		return nil
	}
	return *page.nic.Value
}

// Creates a new instance of the NameIdentifierCollectionPage type.
func NewNameIdentifierCollectionPage(cur NameIdentifierCollection, getNextPage func(context.Context, NameIdentifierCollection) (NameIdentifierCollection, error)) NameIdentifierCollectionPage {
	return NameIdentifierCollectionPage{
		fn:  getNextPage,
		nic: cur,
	}
}

// NameValuePair name value pair.
type NameValuePair struct {
	// Name - Pair name.
	Name *string `json:"name,omitempty"`
	// Value - Pair value.
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry network access control entry.
type NetworkAccessControlEntry struct {
	// Action - Action object. Possible values include: 'Permit', 'Deny'
	Action AccessControlEntryAction `json:"action,omitempty"`
	// Description - Description of network access control entry.
	Description *string `json:"description,omitempty"`
	// Order - Order of precedence.
	Order *int32 `json:"order,omitempty"`
	// RemoteSubnet - Remote subnet.
	RemoteSubnet *string `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures full view of network features for an app (presently VNET integration and Hybrid
// Connections).
type NetworkFeatures struct {
	autorest.Response `json:"-"`
	// NetworkFeaturesProperties - NetworkFeatures resource specific properties
	*NetworkFeaturesProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkFeatures.
func (nf NetworkFeatures) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nf.NetworkFeaturesProperties != nil {
		objectMap["properties"] = nf.NetworkFeaturesProperties
	}
	if nf.Kind != nil {
		objectMap["kind"] = nf.Kind
	}
	if nf.SystemData != nil {
		objectMap["systemData"] = nf.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NetworkFeatures struct.
func (nf *NetworkFeatures) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var networkFeaturesProperties NetworkFeaturesProperties
				err = json.Unmarshal(*v, &networkFeaturesProperties)
				if err != nil {
					return err
				}
				nf.NetworkFeaturesProperties = &networkFeaturesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				nf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nf.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				nf.SystemData = &systemData
			}
		}
	}

	return nil
}

// NetworkFeaturesProperties networkFeatures resource specific properties
type NetworkFeaturesProperties struct {
	// VirtualNetworkName - READ-ONLY; The Virtual Network name.
	VirtualNetworkName *string `json:"virtualNetworkName,omitempty"`
	// VirtualNetworkConnection - READ-ONLY; The Virtual Network summary view.
	VirtualNetworkConnection *VnetInfo `json:"virtualNetworkConnection,omitempty"`
	// HybridConnections - READ-ONLY; The Hybrid Connections summary view.
	HybridConnections *[]RelayServiceConnectionEntity `json:"hybridConnections,omitempty"`
	// HybridConnectionsV2 - READ-ONLY; The Hybrid Connection V2 (Service Bus) view.
	HybridConnectionsV2 *[]HybridConnection `json:"hybridConnectionsV2,omitempty"`
}

// NetworkTrace network trace
type NetworkTrace struct {
	// Path - Local file path for the captured network trace file.
	Path *string `json:"path,omitempty"`
	// Status - Current status of the network trace operation, same as Operation.Status (InProgress/Succeeded/Failed).
	Status *string `json:"status,omitempty"`
	// Message - Detailed message of a network trace operation, e.g. error message in case of failure.
	Message *string `json:"message,omitempty"`
}

// Nonce ...
type Nonce struct {
	// NonceProperties - Nonce resource specific properties
	*NonceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Nonce.
func (n Nonce) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if n.NonceProperties != nil {
		objectMap["properties"] = n.NonceProperties
	}
	if n.Kind != nil {
		objectMap["kind"] = n.Kind
	}
	if n.SystemData != nil {
		objectMap["systemData"] = n.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Nonce struct.
func (n *Nonce) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var nonceProperties NonceProperties
				err = json.Unmarshal(*v, &nonceProperties)
				if err != nil {
					return err
				}
				n.NonceProperties = &nonceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				n.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				n.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				n.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				n.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				n.SystemData = &systemData
			}
		}
	}

	return nil
}

// NonceProperties nonce resource specific properties
type NonceProperties struct {
	ValidateNonce           *bool   `json:"validateNonce,omitempty"`
	NonceExpirationInterval *string `json:"nonceExpirationInterval,omitempty"`
}

// OpenIDConnectClientCredential ...
type OpenIDConnectClientCredential struct {
	// OpenIDConnectClientCredentialProperties - OpenIdConnectClientCredential resource specific properties
	*OpenIDConnectClientCredentialProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenIDConnectClientCredential.
func (oiccc OpenIDConnectClientCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oiccc.OpenIDConnectClientCredentialProperties != nil {
		objectMap["properties"] = oiccc.OpenIDConnectClientCredentialProperties
	}
	if oiccc.Kind != nil {
		objectMap["kind"] = oiccc.Kind
	}
	if oiccc.SystemData != nil {
		objectMap["systemData"] = oiccc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenIDConnectClientCredential struct.
func (oiccc *OpenIDConnectClientCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openIDConnectClientCredentialProperties OpenIDConnectClientCredentialProperties
				err = json.Unmarshal(*v, &openIDConnectClientCredentialProperties)
				if err != nil {
					return err
				}
				oiccc.OpenIDConnectClientCredentialProperties = &openIDConnectClientCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oiccc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oiccc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oiccc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oiccc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				oiccc.SystemData = &systemData
			}
		}
	}

	return nil
}

// OpenIDConnectClientCredentialProperties openIdConnectClientCredential resource specific properties
type OpenIDConnectClientCredentialProperties struct {
	// Method - Possible values include: 'ClientSecretPost'
	Method                  ClientCredentialMethod `json:"method,omitempty"`
	ClientSecretSettingName *string                `json:"clientSecretSettingName,omitempty"`
}

// OpenIDConnectConfig ...
type OpenIDConnectConfig struct {
	// OpenIDConnectConfigProperties - OpenIdConnectConfig resource specific properties
	*OpenIDConnectConfigProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenIDConnectConfig.
func (oicc OpenIDConnectConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oicc.OpenIDConnectConfigProperties != nil {
		objectMap["properties"] = oicc.OpenIDConnectConfigProperties
	}
	if oicc.Kind != nil {
		objectMap["kind"] = oicc.Kind
	}
	if oicc.SystemData != nil {
		objectMap["systemData"] = oicc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenIDConnectConfig struct.
func (oicc *OpenIDConnectConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openIDConnectConfigProperties OpenIDConnectConfigProperties
				err = json.Unmarshal(*v, &openIDConnectConfigProperties)
				if err != nil {
					return err
				}
				oicc.OpenIDConnectConfigProperties = &openIDConnectConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oicc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oicc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oicc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oicc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				oicc.SystemData = &systemData
			}
		}
	}

	return nil
}

// OpenIDConnectConfigProperties openIdConnectConfig resource specific properties
type OpenIDConnectConfigProperties struct {
	AuthorizationEndpoint        *string `json:"authorizationEndpoint,omitempty"`
	TokenEndpoint                *string `json:"tokenEndpoint,omitempty"`
	Issuer                       *string `json:"issuer,omitempty"`
	CertificationURI             *string `json:"certificationUri,omitempty"`
	WellKnownOpenIDConfiguration *string `json:"wellKnownOpenIdConfiguration,omitempty"`
}

// OpenIDConnectLogin ...
type OpenIDConnectLogin struct {
	// OpenIDConnectLoginProperties - OpenIdConnectLogin resource specific properties
	*OpenIDConnectLoginProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenIDConnectLogin.
func (oicl OpenIDConnectLogin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oicl.OpenIDConnectLoginProperties != nil {
		objectMap["properties"] = oicl.OpenIDConnectLoginProperties
	}
	if oicl.Kind != nil {
		objectMap["kind"] = oicl.Kind
	}
	if oicl.SystemData != nil {
		objectMap["systemData"] = oicl.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenIDConnectLogin struct.
func (oicl *OpenIDConnectLogin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openIDConnectLoginProperties OpenIDConnectLoginProperties
				err = json.Unmarshal(*v, &openIDConnectLoginProperties)
				if err != nil {
					return err
				}
				oicl.OpenIDConnectLoginProperties = &openIDConnectLoginProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oicl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oicl.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oicl.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oicl.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				oicl.SystemData = &systemData
			}
		}
	}

	return nil
}

// OpenIDConnectLoginProperties openIdConnectLogin resource specific properties
type OpenIDConnectLoginProperties struct {
	NameClaimType *string   `json:"nameClaimType,omitempty"`
	Scopes        *[]string `json:"scopes,omitempty"`
}

// OpenIDConnectRegistration ...
type OpenIDConnectRegistration struct {
	// OpenIDConnectRegistrationProperties - OpenIdConnectRegistration resource specific properties
	*OpenIDConnectRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for OpenIDConnectRegistration.
func (oicr OpenIDConnectRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oicr.OpenIDConnectRegistrationProperties != nil {
		objectMap["properties"] = oicr.OpenIDConnectRegistrationProperties
	}
	if oicr.Kind != nil {
		objectMap["kind"] = oicr.Kind
	}
	if oicr.SystemData != nil {
		objectMap["systemData"] = oicr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OpenIDConnectRegistration struct.
func (oicr *OpenIDConnectRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var openIDConnectRegistrationProperties OpenIDConnectRegistrationProperties
				err = json.Unmarshal(*v, &openIDConnectRegistrationProperties)
				if err != nil {
					return err
				}
				oicr.OpenIDConnectRegistrationProperties = &openIDConnectRegistrationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				oicr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				oicr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				oicr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				oicr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				oicr.SystemData = &systemData
			}
		}
	}

	return nil
}

// OpenIDConnectRegistrationProperties openIdConnectRegistration resource specific properties
type OpenIDConnectRegistrationProperties struct {
	ClientID                   *string                        `json:"clientId,omitempty"`
	ClientCredential           *OpenIDConnectClientCredential `json:"clientCredential,omitempty"`
	OpenIDConnectConfiguration *OpenIDConnectConfig           `json:"openIdConnectConfiguration,omitempty"`
}

// Operation an operation on a resource.
type Operation struct {
	autorest.Response `json:"-"`
	// ID - Operation ID.
	ID *string `json:"id,omitempty"`
	// Name - Operation name.
	Name *string `json:"name,omitempty"`
	// Status - The current status of the operation. Possible values include: 'OperationStatusInProgress', 'OperationStatusFailed', 'OperationStatusSucceeded', 'OperationStatusTimedOut', 'OperationStatusCreated'
	Status OperationStatus `json:"status,omitempty"`
	// Errors - Any errors associate with the operation.
	Errors *[]ErrorEntity `json:"errors,omitempty"`
	// CreatedTime - Time when operation has started.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ModifiedTime - Time when operation has been updated.
	ModifiedTime *date.Time `json:"modifiedTime,omitempty"`
	// ExpirationTime - Time when operation will expire.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
	// GeoMasterOperationID - Applicable only for stamp operation ids.
	GeoMasterOperationID *uuid.UUID `json:"geoMasterOperationId,omitempty"`
}

// OutboundEnvironmentEndpoint endpoints accessed for a common purpose that the App Service Environment
// requires outbound network access to.
type OutboundEnvironmentEndpoint struct {
	// Category - The type of service accessed by the App Service Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active Directory.
	Category *string `json:"category,omitempty"`
	// Endpoints - The endpoints that the App Service Environment reaches the service at.
	Endpoints *[]EndpointDependency `json:"endpoints,omitempty"`
}

// OutboundEnvironmentEndpointCollection collection of Outbound Environment Endpoints
type OutboundEnvironmentEndpointCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]OutboundEnvironmentEndpoint `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OutboundEnvironmentEndpointCollection.
func (oeec OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oeec.Value != nil {
		objectMap["value"] = oeec.Value
	}
	return json.Marshal(objectMap)
}

// OutboundEnvironmentEndpointCollectionIterator provides access to a complete listing of
// OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionIterator struct {
	i    int
	page OutboundEnvironmentEndpointCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OutboundEnvironmentEndpointCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OutboundEnvironmentEndpointCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OutboundEnvironmentEndpointCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OutboundEnvironmentEndpointCollectionIterator) Response() OutboundEnvironmentEndpointCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OutboundEnvironmentEndpointCollectionIterator) Value() OutboundEnvironmentEndpoint {
	if !iter.page.NotDone() {
		return OutboundEnvironmentEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionIterator type.
func NewOutboundEnvironmentEndpointCollectionIterator(page OutboundEnvironmentEndpointCollectionPage) OutboundEnvironmentEndpointCollectionIterator {
	return OutboundEnvironmentEndpointCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oeec OutboundEnvironmentEndpointCollection) IsEmpty() bool {
	return oeec.Value == nil || len(*oeec.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oeec OutboundEnvironmentEndpointCollection) hasNextLink() bool {
	return oeec.NextLink != nil && len(*oeec.NextLink) != 0
}

// outboundEnvironmentEndpointCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oeec OutboundEnvironmentEndpointCollection) outboundEnvironmentEndpointCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oeec.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oeec.NextLink)))
}

// OutboundEnvironmentEndpointCollectionPage contains a page of OutboundEnvironmentEndpoint values.
type OutboundEnvironmentEndpointCollectionPage struct {
	fn   func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)
	oeec OutboundEnvironmentEndpointCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OutboundEnvironmentEndpointCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OutboundEnvironmentEndpointCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oeec)
		if err != nil {
			return err
		}
		page.oeec = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OutboundEnvironmentEndpointCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OutboundEnvironmentEndpointCollectionPage) NotDone() bool {
	return !page.oeec.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OutboundEnvironmentEndpointCollectionPage) Response() OutboundEnvironmentEndpointCollection {
	return page.oeec
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OutboundEnvironmentEndpointCollectionPage) Values() []OutboundEnvironmentEndpoint {
	if page.oeec.IsEmpty() {
		return nil
	}
	return *page.oeec.Value
}

// Creates a new instance of the OutboundEnvironmentEndpointCollectionPage type.
func NewOutboundEnvironmentEndpointCollectionPage(cur OutboundEnvironmentEndpointCollection, getNextPage func(context.Context, OutboundEnvironmentEndpointCollection) (OutboundEnvironmentEndpointCollection, error)) OutboundEnvironmentEndpointCollectionPage {
	return OutboundEnvironmentEndpointCollectionPage{
		fn:   getNextPage,
		oeec: cur,
	}
}

// PerfMonCounterCollection collection of performance monitor counters.
type PerfMonCounterCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PerfMonResponse `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PerfMonCounterCollection.
func (pmcc PerfMonCounterCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmcc.Value != nil {
		objectMap["value"] = pmcc.Value
	}
	return json.Marshal(objectMap)
}

// PerfMonCounterCollectionIterator provides access to a complete listing of PerfMonResponse values.
type PerfMonCounterCollectionIterator struct {
	i    int
	page PerfMonCounterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PerfMonCounterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PerfMonCounterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PerfMonCounterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PerfMonCounterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PerfMonCounterCollectionIterator) Response() PerfMonCounterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PerfMonCounterCollectionIterator) Value() PerfMonResponse {
	if !iter.page.NotDone() {
		return PerfMonResponse{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PerfMonCounterCollectionIterator type.
func NewPerfMonCounterCollectionIterator(page PerfMonCounterCollectionPage) PerfMonCounterCollectionIterator {
	return PerfMonCounterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmcc PerfMonCounterCollection) IsEmpty() bool {
	return pmcc.Value == nil || len(*pmcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pmcc PerfMonCounterCollection) hasNextLink() bool {
	return pmcc.NextLink != nil && len(*pmcc.NextLink) != 0
}

// perfMonCounterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmcc PerfMonCounterCollection) perfMonCounterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pmcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmcc.NextLink)))
}

// PerfMonCounterCollectionPage contains a page of PerfMonResponse values.
type PerfMonCounterCollectionPage struct {
	fn   func(context.Context, PerfMonCounterCollection) (PerfMonCounterCollection, error)
	pmcc PerfMonCounterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PerfMonCounterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PerfMonCounterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pmcc)
		if err != nil {
			return err
		}
		page.pmcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PerfMonCounterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PerfMonCounterCollectionPage) NotDone() bool {
	return !page.pmcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PerfMonCounterCollectionPage) Response() PerfMonCounterCollection {
	return page.pmcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PerfMonCounterCollectionPage) Values() []PerfMonResponse {
	if page.pmcc.IsEmpty() {
		return nil
	}
	return *page.pmcc.Value
}

// Creates a new instance of the PerfMonCounterCollectionPage type.
func NewPerfMonCounterCollectionPage(cur PerfMonCounterCollection, getNextPage func(context.Context, PerfMonCounterCollection) (PerfMonCounterCollection, error)) PerfMonCounterCollectionPage {
	return PerfMonCounterCollectionPage{
		fn:   getNextPage,
		pmcc: cur,
	}
}

// PerfMonResponse performance monitor API response.
type PerfMonResponse struct {
	// Code - The response code.
	Code *string `json:"code,omitempty"`
	// Message - The message.
	Message *string `json:"message,omitempty"`
	// Data - The performance monitor counters.
	Data *PerfMonSet `json:"data,omitempty"`
}

// PerfMonSample performance monitor sample in a set.
type PerfMonSample struct {
	// Time - Point in time for which counter was measured.
	Time *date.Time `json:"time,omitempty"`
	// InstanceName - Name of the server on which the measurement is made.
	InstanceName *string `json:"instanceName,omitempty"`
	// Value - Value of counter at a certain time.
	Value *float64 `json:"value,omitempty"`
}

// PerfMonSet metric information.
type PerfMonSet struct {
	// Name - Unique key name of the counter.
	Name *string `json:"name,omitempty"`
	// StartTime - Start time of the period.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - End time of the period.
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - Presented time grain.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Values - Collection of workers that are active during this time.
	Values *[]PerfMonSample `json:"values,omitempty"`
}

// PremierAddOn premier add-on.
type PremierAddOn struct {
	autorest.Response `json:"-"`
	// PremierAddOnProperties - PremierAddOn resource specific properties
	*PremierAddOnProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOn.
func (pao PremierAddOn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pao.PremierAddOnProperties != nil {
		objectMap["properties"] = pao.PremierAddOnProperties
	}
	if pao.Kind != nil {
		objectMap["kind"] = pao.Kind
	}
	if pao.Location != nil {
		objectMap["location"] = pao.Location
	}
	if pao.Tags != nil {
		objectMap["tags"] = pao.Tags
	}
	if pao.SystemData != nil {
		objectMap["systemData"] = pao.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PremierAddOn struct.
func (pao *PremierAddOn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var premierAddOnProperties PremierAddOnProperties
				err = json.Unmarshal(*v, &premierAddOnProperties)
				if err != nil {
					return err
				}
				pao.PremierAddOnProperties = &premierAddOnProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pao.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pao.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pao.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pao.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pao.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pao.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pao.SystemData = &systemData
			}
		}
	}

	return nil
}

// PremierAddOnOffer premier add-on offer.
type PremierAddOnOffer struct {
	// PremierAddOnOfferProperties - PremierAddOnOffer resource specific properties
	*PremierAddOnOfferProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnOffer.
func (paoo PremierAddOnOffer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paoo.PremierAddOnOfferProperties != nil {
		objectMap["properties"] = paoo.PremierAddOnOfferProperties
	}
	if paoo.Kind != nil {
		objectMap["kind"] = paoo.Kind
	}
	if paoo.SystemData != nil {
		objectMap["systemData"] = paoo.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PremierAddOnOffer struct.
func (paoo *PremierAddOnOffer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var premierAddOnOfferProperties PremierAddOnOfferProperties
				err = json.Unmarshal(*v, &premierAddOnOfferProperties)
				if err != nil {
					return err
				}
				paoo.PremierAddOnOfferProperties = &premierAddOnOfferProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				paoo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				paoo.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				paoo.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				paoo.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				paoo.SystemData = &systemData
			}
		}
	}

	return nil
}

// PremierAddOnOfferCollection collection of premier add-on offers.
type PremierAddOnOfferCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PremierAddOnOffer `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnOfferCollection.
func (paooc PremierAddOnOfferCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paooc.Value != nil {
		objectMap["value"] = paooc.Value
	}
	return json.Marshal(objectMap)
}

// PremierAddOnOfferCollectionIterator provides access to a complete listing of PremierAddOnOffer values.
type PremierAddOnOfferCollectionIterator struct {
	i    int
	page PremierAddOnOfferCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PremierAddOnOfferCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremierAddOnOfferCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PremierAddOnOfferCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PremierAddOnOfferCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PremierAddOnOfferCollectionIterator) Response() PremierAddOnOfferCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PremierAddOnOfferCollectionIterator) Value() PremierAddOnOffer {
	if !iter.page.NotDone() {
		return PremierAddOnOffer{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PremierAddOnOfferCollectionIterator type.
func NewPremierAddOnOfferCollectionIterator(page PremierAddOnOfferCollectionPage) PremierAddOnOfferCollectionIterator {
	return PremierAddOnOfferCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (paooc PremierAddOnOfferCollection) IsEmpty() bool {
	return paooc.Value == nil || len(*paooc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (paooc PremierAddOnOfferCollection) hasNextLink() bool {
	return paooc.NextLink != nil && len(*paooc.NextLink) != 0
}

// premierAddOnOfferCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (paooc PremierAddOnOfferCollection) premierAddOnOfferCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !paooc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(paooc.NextLink)))
}

// PremierAddOnOfferCollectionPage contains a page of PremierAddOnOffer values.
type PremierAddOnOfferCollectionPage struct {
	fn    func(context.Context, PremierAddOnOfferCollection) (PremierAddOnOfferCollection, error)
	paooc PremierAddOnOfferCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PremierAddOnOfferCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PremierAddOnOfferCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.paooc)
		if err != nil {
			return err
		}
		page.paooc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PremierAddOnOfferCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PremierAddOnOfferCollectionPage) NotDone() bool {
	return !page.paooc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PremierAddOnOfferCollectionPage) Response() PremierAddOnOfferCollection {
	return page.paooc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PremierAddOnOfferCollectionPage) Values() []PremierAddOnOffer {
	if page.paooc.IsEmpty() {
		return nil
	}
	return *page.paooc.Value
}

// Creates a new instance of the PremierAddOnOfferCollectionPage type.
func NewPremierAddOnOfferCollectionPage(cur PremierAddOnOfferCollection, getNextPage func(context.Context, PremierAddOnOfferCollection) (PremierAddOnOfferCollection, error)) PremierAddOnOfferCollectionPage {
	return PremierAddOnOfferCollectionPage{
		fn:    getNextPage,
		paooc: cur,
	}
}

// PremierAddOnOfferProperties premierAddOnOffer resource specific properties
type PremierAddOnOfferProperties struct {
	// Sku - Premier add on SKU.
	Sku *string `json:"sku,omitempty"`
	// Product - Premier add on offer Product.
	Product *string `json:"product,omitempty"`
	// Vendor - Premier add on offer Vendor.
	Vendor *string `json:"vendor,omitempty"`
	// PromoCodeRequired - <code>true</code> if promotion code is required; otherwise, <code>false</code>.
	PromoCodeRequired *bool `json:"promoCodeRequired,omitempty"`
	// Quota - Premier add on offer Quota.
	Quota *int32 `json:"quota,omitempty"`
	// WebHostingPlanRestrictions - App Service plans this offer is restricted to. Possible values include: 'None', 'Free', 'Shared', 'Basic', 'Standard', 'Premium'
	WebHostingPlanRestrictions AppServicePlanRestrictions `json:"webHostingPlanRestrictions,omitempty"`
	// PrivacyPolicyURL - Privacy policy URL.
	PrivacyPolicyURL *string `json:"privacyPolicyUrl,omitempty"`
	// LegalTermsURL - Legal terms URL.
	LegalTermsURL *string `json:"legalTermsUrl,omitempty"`
	// MarketplacePublisher - Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`
	// MarketplaceOffer - Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`
}

// PremierAddOnPatchResource ARM resource for a PremierAddOn.
type PremierAddOnPatchResource struct {
	// PremierAddOnPatchResourceProperties - PremierAddOnPatchResource resource specific properties
	*PremierAddOnPatchResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PremierAddOnPatchResource.
func (paopr PremierAddOnPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if paopr.PremierAddOnPatchResourceProperties != nil {
		objectMap["properties"] = paopr.PremierAddOnPatchResourceProperties
	}
	if paopr.Kind != nil {
		objectMap["kind"] = paopr.Kind
	}
	if paopr.SystemData != nil {
		objectMap["systemData"] = paopr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PremierAddOnPatchResource struct.
func (paopr *PremierAddOnPatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var premierAddOnPatchResourceProperties PremierAddOnPatchResourceProperties
				err = json.Unmarshal(*v, &premierAddOnPatchResourceProperties)
				if err != nil {
					return err
				}
				paopr.PremierAddOnPatchResourceProperties = &premierAddOnPatchResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				paopr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				paopr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				paopr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				paopr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				paopr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PremierAddOnPatchResourceProperties premierAddOnPatchResource resource specific properties
type PremierAddOnPatchResourceProperties struct {
	// Sku - Premier add on SKU.
	Sku *string `json:"sku,omitempty"`
	// Product - Premier add on Product.
	Product *string `json:"product,omitempty"`
	// Vendor - Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
	// MarketplacePublisher - Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`
	// MarketplaceOffer - Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`
}

// PremierAddOnProperties premierAddOn resource specific properties
type PremierAddOnProperties struct {
	// Sku - Premier add on SKU.
	Sku *string `json:"sku,omitempty"`
	// Product - Premier add on Product.
	Product *string `json:"product,omitempty"`
	// Vendor - Premier add on Vendor.
	Vendor *string `json:"vendor,omitempty"`
	// MarketplacePublisher - Premier add on Marketplace publisher.
	MarketplacePublisher *string `json:"marketplacePublisher,omitempty"`
	// MarketplaceOffer - Premier add on Marketplace offer.
	MarketplaceOffer *string `json:"marketplaceOffer,omitempty"`
}

// PrivateAccess description of the parameters of Private Access for a Web Site.
type PrivateAccess struct {
	autorest.Response `json:"-"`
	// PrivateAccessProperties - PrivateAccess resource specific properties
	*PrivateAccessProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateAccess.
func (pa PrivateAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pa.PrivateAccessProperties != nil {
		objectMap["properties"] = pa.PrivateAccessProperties
	}
	if pa.Kind != nil {
		objectMap["kind"] = pa.Kind
	}
	if pa.SystemData != nil {
		objectMap["systemData"] = pa.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateAccess struct.
func (pa *PrivateAccess) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateAccessProperties PrivateAccessProperties
				err = json.Unmarshal(*v, &privateAccessProperties)
				if err != nil {
					return err
				}
				pa.PrivateAccessProperties = &privateAccessProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pa.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pa.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pa.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pa.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateAccessProperties privateAccess resource specific properties
type PrivateAccessProperties struct {
	// Enabled - Whether private access is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// VirtualNetworks - The Virtual Networks (and subnets) allowed to access the site privately.
	VirtualNetworks *[]PrivateAccessVirtualNetwork `json:"virtualNetworks,omitempty"`
}

// PrivateAccessSubnet description of a Virtual Network subnet that is useable for private site access.
type PrivateAccessSubnet struct {
	// Name - The name of the subnet.
	Name *string `json:"name,omitempty"`
	// Key - The key (ID) of the subnet.
	Key *int32 `json:"key,omitempty"`
}

// PrivateAccessVirtualNetwork description of a Virtual Network that is useable for private site access.
type PrivateAccessVirtualNetwork struct {
	// Name - The name of the Virtual Network.
	Name *string `json:"name,omitempty"`
	// Key - The key (ID) of the Virtual Network.
	Key *int32 `json:"key,omitempty"`
	// ResourceID - The ARM uri of the Virtual Network
	ResourceID *string `json:"resourceId,omitempty"`
	// Subnets - A List of subnets that access is allowed to on this Virtual Network. An empty array (but not null) is interpreted to mean that all subnets are allowed within this Virtual Network.
	Subnets *[]PrivateAccessSubnet `json:"subnets,omitempty"`
}

// PrivateEndpointConnectionResource private Endpoint Connection ARM resource.
type PrivateEndpointConnectionResource struct {
	autorest.Response `json:"-"`
	// RemotePrivateEndpointConnection - Core resource properties
	*RemotePrivateEndpointConnection `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionResource.
func (pecr PrivateEndpointConnectionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecr.RemotePrivateEndpointConnection != nil {
		objectMap["properties"] = pecr.RemotePrivateEndpointConnection
	}
	if pecr.Kind != nil {
		objectMap["kind"] = pecr.Kind
	}
	if pecr.SystemData != nil {
		objectMap["systemData"] = pecr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionResource struct.
func (pecr *PrivateEndpointConnectionResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var remotePrivateEndpointConnection RemotePrivateEndpointConnection
				err = json.Unmarshal(*v, &remotePrivateEndpointConnection)
				if err != nil {
					return err
				}
				pecr.RemotePrivateEndpointConnection = &remotePrivateEndpointConnection
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pecr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pecr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pecr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pecr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pecr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateLinkConnectionApprovalRequest a request to approve or reject a private endpoint connection
type PrivateLinkConnectionApprovalRequest struct {
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkConnectionApprovalRequestResource private Endpoint Connection Approval ARM resource.
type PrivateLinkConnectionApprovalRequestResource struct {
	// PrivateLinkConnectionApprovalRequest - Core resource properties
	*PrivateLinkConnectionApprovalRequest `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkConnectionApprovalRequestResource.
func (plcarr PrivateLinkConnectionApprovalRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plcarr.PrivateLinkConnectionApprovalRequest != nil {
		objectMap["properties"] = plcarr.PrivateLinkConnectionApprovalRequest
	}
	if plcarr.Kind != nil {
		objectMap["kind"] = plcarr.Kind
	}
	if plcarr.SystemData != nil {
		objectMap["systemData"] = plcarr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkConnectionApprovalRequestResource struct.
func (plcarr *PrivateLinkConnectionApprovalRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkConnectionApprovalRequest PrivateLinkConnectionApprovalRequest
				err = json.Unmarshal(*v, &privateLinkConnectionApprovalRequest)
				if err != nil {
					return err
				}
				plcarr.PrivateLinkConnectionApprovalRequest = &privateLinkConnectionApprovalRequest
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plcarr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plcarr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				plcarr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plcarr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				plcarr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateLinkConnectionState the state of a private link connection
type PrivateLinkConnectionState struct {
	// Status - Status of a private link connection
	Status *string `json:"status,omitempty"`
	// Description - Description of a private link connection
	Description *string `json:"description,omitempty"`
	// ActionsRequired - ActionsRequired for a private link connection
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	ID *string `json:"id,omitempty"`
	// Name - Name of a private link resource
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
	// Properties - Properties of a private link resource
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; GroupId of a private link resource
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; RequiredMembers of a private link resource
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - READ-ONLY; RequiredZoneNames of a private link resource
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesWrapper wrapper for a collection of private link resources
type PrivateLinkResourcesWrapper struct {
	autorest.Response `json:"-"`
	Value             *[]PrivateLinkResource `json:"value,omitempty"`
}

// ProcessInfo process Information.
type ProcessInfo struct {
	autorest.Response `json:"-"`
	// ProcessInfoProperties - ProcessInfo resource specific properties
	*ProcessInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessInfo.
func (pi ProcessInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.ProcessInfoProperties != nil {
		objectMap["properties"] = pi.ProcessInfoProperties
	}
	if pi.Kind != nil {
		objectMap["kind"] = pi.Kind
	}
	if pi.SystemData != nil {
		objectMap["systemData"] = pi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessInfo struct.
func (pi *ProcessInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processInfoProperties ProcessInfoProperties
				err = json.Unmarshal(*v, &processInfoProperties)
				if err != nil {
					return err
				}
				pi.ProcessInfoProperties = &processInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pi.SystemData = &systemData
			}
		}
	}

	return nil
}

// ProcessInfoCollection collection of Kudu process information elements.
type ProcessInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessInfoCollection.
func (pic ProcessInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pic.Value != nil {
		objectMap["value"] = pic.Value
	}
	return json.Marshal(objectMap)
}

// ProcessInfoCollectionIterator provides access to a complete listing of ProcessInfo values.
type ProcessInfoCollectionIterator struct {
	i    int
	page ProcessInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessInfoCollectionIterator) Response() ProcessInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessInfoCollectionIterator) Value() ProcessInfo {
	if !iter.page.NotDone() {
		return ProcessInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessInfoCollectionIterator type.
func NewProcessInfoCollectionIterator(page ProcessInfoCollectionPage) ProcessInfoCollectionIterator {
	return ProcessInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pic ProcessInfoCollection) IsEmpty() bool {
	return pic.Value == nil || len(*pic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pic ProcessInfoCollection) hasNextLink() bool {
	return pic.NextLink != nil && len(*pic.NextLink) != 0
}

// processInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pic ProcessInfoCollection) processInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pic.NextLink)))
}

// ProcessInfoCollectionPage contains a page of ProcessInfo values.
type ProcessInfoCollectionPage struct {
	fn  func(context.Context, ProcessInfoCollection) (ProcessInfoCollection, error)
	pic ProcessInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pic)
		if err != nil {
			return err
		}
		page.pic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessInfoCollectionPage) NotDone() bool {
	return !page.pic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessInfoCollectionPage) Response() ProcessInfoCollection {
	return page.pic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessInfoCollectionPage) Values() []ProcessInfo {
	if page.pic.IsEmpty() {
		return nil
	}
	return *page.pic.Value
}

// Creates a new instance of the ProcessInfoCollectionPage type.
func NewProcessInfoCollectionPage(cur ProcessInfoCollection, getNextPage func(context.Context, ProcessInfoCollection) (ProcessInfoCollection, error)) ProcessInfoCollectionPage {
	return ProcessInfoCollectionPage{
		fn:  getNextPage,
		pic: cur,
	}
}

// ProcessInfoProperties processInfo resource specific properties
type ProcessInfoProperties struct {
	// Identifier - READ-ONLY; ARM Identifier for deployment.
	Identifier *int32 `json:"identifier,omitempty"`
	// DeploymentName - Deployment name.
	DeploymentName *string `json:"deployment_name,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// Minidump - Minidump URI.
	Minidump *string `json:"minidump,omitempty"`
	// IsProfileRunning - Is profile running?
	IsProfileRunning *bool `json:"is_profile_running,omitempty"`
	// IsIisProfileRunning - Is the IIS Profile running?
	IsIisProfileRunning *bool `json:"is_iis_profile_running,omitempty"`
	// IisProfileTimeoutInSeconds - IIS Profile timeout (seconds).
	IisProfileTimeoutInSeconds *float64 `json:"iis_profile_timeout_in_seconds,omitempty"`
	// Parent - Parent process.
	Parent *string `json:"parent,omitempty"`
	// Children - Child process list.
	Children *[]string `json:"children,omitempty"`
	// Threads - Thread list.
	Threads *[]ProcessThreadInfo `json:"threads,omitempty"`
	// OpenFileHandles - List of open files.
	OpenFileHandles *[]string `json:"open_file_handles,omitempty"`
	// Modules - List of modules.
	Modules *[]ProcessModuleInfo `json:"modules,omitempty"`
	// FileName - File name of this process.
	FileName *string `json:"file_name,omitempty"`
	// CommandLine - Command line.
	CommandLine *string `json:"command_line,omitempty"`
	// UserName - User name.
	UserName *string `json:"user_name,omitempty"`
	// HandleCount - Handle count.
	HandleCount *int32 `json:"handle_count,omitempty"`
	// ModuleCount - Module count.
	ModuleCount *int32 `json:"module_count,omitempty"`
	// ThreadCount - Thread count.
	ThreadCount *int32 `json:"thread_count,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"start_time,omitempty"`
	// TotalCPUTime - Total CPU time.
	TotalCPUTime *string `json:"total_cpu_time,omitempty"`
	// UserCPUTime - User CPU time.
	UserCPUTime *string `json:"user_cpu_time,omitempty"`
	// PrivilegedCPUTime - Privileged CPU time.
	PrivilegedCPUTime *string `json:"privileged_cpu_time,omitempty"`
	// WorkingSet - Working set.
	WorkingSet *int64 `json:"working_set,omitempty"`
	// PeakWorkingSet - Peak working set.
	PeakWorkingSet *int64 `json:"peak_working_set,omitempty"`
	// PrivateMemory - Private memory size.
	PrivateMemory *int64 `json:"private_memory,omitempty"`
	// VirtualMemory - Virtual memory size.
	VirtualMemory *int64 `json:"virtual_memory,omitempty"`
	// PeakVirtualMemory - Peak virtual memory usage.
	PeakVirtualMemory *int64 `json:"peak_virtual_memory,omitempty"`
	// PagedSystemMemory - Paged system memory.
	PagedSystemMemory *int64 `json:"paged_system_memory,omitempty"`
	// NonPagedSystemMemory - Non-paged system memory.
	NonPagedSystemMemory *int64 `json:"non_paged_system_memory,omitempty"`
	// PagedMemory - Paged memory.
	PagedMemory *int64 `json:"paged_memory,omitempty"`
	// PeakPagedMemory - Peak paged memory.
	PeakPagedMemory *int64 `json:"peak_paged_memory,omitempty"`
	// TimeStamp - Time stamp.
	TimeStamp *date.Time `json:"time_stamp,omitempty"`
	// EnvironmentVariables - List of environment variables.
	EnvironmentVariables map[string]*string `json:"environment_variables"`
	// IsScmSite - Is this the SCM site?
	IsScmSite *bool `json:"is_scm_site,omitempty"`
	// IsWebjob - Is this a Web Job?
	IsWebjob *bool `json:"is_webjob,omitempty"`
	// Description - Description of process.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessInfoProperties.
func (pi ProcessInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pi.DeploymentName != nil {
		objectMap["deployment_name"] = pi.DeploymentName
	}
	if pi.Href != nil {
		objectMap["href"] = pi.Href
	}
	if pi.Minidump != nil {
		objectMap["minidump"] = pi.Minidump
	}
	if pi.IsProfileRunning != nil {
		objectMap["is_profile_running"] = pi.IsProfileRunning
	}
	if pi.IsIisProfileRunning != nil {
		objectMap["is_iis_profile_running"] = pi.IsIisProfileRunning
	}
	if pi.IisProfileTimeoutInSeconds != nil {
		objectMap["iis_profile_timeout_in_seconds"] = pi.IisProfileTimeoutInSeconds
	}
	if pi.Parent != nil {
		objectMap["parent"] = pi.Parent
	}
	if pi.Children != nil {
		objectMap["children"] = pi.Children
	}
	if pi.Threads != nil {
		objectMap["threads"] = pi.Threads
	}
	if pi.OpenFileHandles != nil {
		objectMap["open_file_handles"] = pi.OpenFileHandles
	}
	if pi.Modules != nil {
		objectMap["modules"] = pi.Modules
	}
	if pi.FileName != nil {
		objectMap["file_name"] = pi.FileName
	}
	if pi.CommandLine != nil {
		objectMap["command_line"] = pi.CommandLine
	}
	if pi.UserName != nil {
		objectMap["user_name"] = pi.UserName
	}
	if pi.HandleCount != nil {
		objectMap["handle_count"] = pi.HandleCount
	}
	if pi.ModuleCount != nil {
		objectMap["module_count"] = pi.ModuleCount
	}
	if pi.ThreadCount != nil {
		objectMap["thread_count"] = pi.ThreadCount
	}
	if pi.StartTime != nil {
		objectMap["start_time"] = pi.StartTime
	}
	if pi.TotalCPUTime != nil {
		objectMap["total_cpu_time"] = pi.TotalCPUTime
	}
	if pi.UserCPUTime != nil {
		objectMap["user_cpu_time"] = pi.UserCPUTime
	}
	if pi.PrivilegedCPUTime != nil {
		objectMap["privileged_cpu_time"] = pi.PrivilegedCPUTime
	}
	if pi.WorkingSet != nil {
		objectMap["working_set"] = pi.WorkingSet
	}
	if pi.PeakWorkingSet != nil {
		objectMap["peak_working_set"] = pi.PeakWorkingSet
	}
	if pi.PrivateMemory != nil {
		objectMap["private_memory"] = pi.PrivateMemory
	}
	if pi.VirtualMemory != nil {
		objectMap["virtual_memory"] = pi.VirtualMemory
	}
	if pi.PeakVirtualMemory != nil {
		objectMap["peak_virtual_memory"] = pi.PeakVirtualMemory
	}
	if pi.PagedSystemMemory != nil {
		objectMap["paged_system_memory"] = pi.PagedSystemMemory
	}
	if pi.NonPagedSystemMemory != nil {
		objectMap["non_paged_system_memory"] = pi.NonPagedSystemMemory
	}
	if pi.PagedMemory != nil {
		objectMap["paged_memory"] = pi.PagedMemory
	}
	if pi.PeakPagedMemory != nil {
		objectMap["peak_paged_memory"] = pi.PeakPagedMemory
	}
	if pi.TimeStamp != nil {
		objectMap["time_stamp"] = pi.TimeStamp
	}
	if pi.EnvironmentVariables != nil {
		objectMap["environment_variables"] = pi.EnvironmentVariables
	}
	if pi.IsScmSite != nil {
		objectMap["is_scm_site"] = pi.IsScmSite
	}
	if pi.IsWebjob != nil {
		objectMap["is_webjob"] = pi.IsWebjob
	}
	if pi.Description != nil {
		objectMap["description"] = pi.Description
	}
	return json.Marshal(objectMap)
}

// ProcessModuleInfo process Module Information.
type ProcessModuleInfo struct {
	autorest.Response `json:"-"`
	// ProcessModuleInfoProperties - ProcessModuleInfo resource specific properties
	*ProcessModuleInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessModuleInfo.
func (pmi ProcessModuleInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmi.ProcessModuleInfoProperties != nil {
		objectMap["properties"] = pmi.ProcessModuleInfoProperties
	}
	if pmi.Kind != nil {
		objectMap["kind"] = pmi.Kind
	}
	if pmi.SystemData != nil {
		objectMap["systemData"] = pmi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessModuleInfo struct.
func (pmi *ProcessModuleInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processModuleInfoProperties ProcessModuleInfoProperties
				err = json.Unmarshal(*v, &processModuleInfoProperties)
				if err != nil {
					return err
				}
				pmi.ProcessModuleInfoProperties = &processModuleInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pmi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pmi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pmi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pmi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pmi.SystemData = &systemData
			}
		}
	}

	return nil
}

// ProcessModuleInfoCollection collection of Kudu thread information elements.
type ProcessModuleInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessModuleInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessModuleInfoCollection.
func (pmic ProcessModuleInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pmic.Value != nil {
		objectMap["value"] = pmic.Value
	}
	return json.Marshal(objectMap)
}

// ProcessModuleInfoCollectionIterator provides access to a complete listing of ProcessModuleInfo values.
type ProcessModuleInfoCollectionIterator struct {
	i    int
	page ProcessModuleInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessModuleInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessModuleInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessModuleInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessModuleInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessModuleInfoCollectionIterator) Response() ProcessModuleInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessModuleInfoCollectionIterator) Value() ProcessModuleInfo {
	if !iter.page.NotDone() {
		return ProcessModuleInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessModuleInfoCollectionIterator type.
func NewProcessModuleInfoCollectionIterator(page ProcessModuleInfoCollectionPage) ProcessModuleInfoCollectionIterator {
	return ProcessModuleInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pmic ProcessModuleInfoCollection) IsEmpty() bool {
	return pmic.Value == nil || len(*pmic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pmic ProcessModuleInfoCollection) hasNextLink() bool {
	return pmic.NextLink != nil && len(*pmic.NextLink) != 0
}

// processModuleInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pmic ProcessModuleInfoCollection) processModuleInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pmic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pmic.NextLink)))
}

// ProcessModuleInfoCollectionPage contains a page of ProcessModuleInfo values.
type ProcessModuleInfoCollectionPage struct {
	fn   func(context.Context, ProcessModuleInfoCollection) (ProcessModuleInfoCollection, error)
	pmic ProcessModuleInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessModuleInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessModuleInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pmic)
		if err != nil {
			return err
		}
		page.pmic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessModuleInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessModuleInfoCollectionPage) NotDone() bool {
	return !page.pmic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessModuleInfoCollectionPage) Response() ProcessModuleInfoCollection {
	return page.pmic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessModuleInfoCollectionPage) Values() []ProcessModuleInfo {
	if page.pmic.IsEmpty() {
		return nil
	}
	return *page.pmic.Value
}

// Creates a new instance of the ProcessModuleInfoCollectionPage type.
func NewProcessModuleInfoCollectionPage(cur ProcessModuleInfoCollection, getNextPage func(context.Context, ProcessModuleInfoCollection) (ProcessModuleInfoCollection, error)) ProcessModuleInfoCollectionPage {
	return ProcessModuleInfoCollectionPage{
		fn:   getNextPage,
		pmic: cur,
	}
}

// ProcessModuleInfoProperties processModuleInfo resource specific properties
type ProcessModuleInfoProperties struct {
	// BaseAddress - Base address. Used as module identifier in ARM resource URI.
	BaseAddress *string `json:"base_address,omitempty"`
	// FileName - File name.
	FileName *string `json:"file_name,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// FilePath - File path.
	FilePath *string `json:"file_path,omitempty"`
	// ModuleMemorySize - Module memory size.
	ModuleMemorySize *int32 `json:"module_memory_size,omitempty"`
	// FileVersion - File version.
	FileVersion *string `json:"file_version,omitempty"`
	// FileDescription - File description.
	FileDescription *string `json:"file_description,omitempty"`
	// Product - Product name.
	Product *string `json:"product,omitempty"`
	// ProductVersion - Product version.
	ProductVersion *string `json:"product_version,omitempty"`
	// IsDebug - Is debug?
	IsDebug *bool `json:"is_debug,omitempty"`
	// Language - Module language (locale).
	Language *string `json:"language,omitempty"`
}

// ProcessThreadInfo process Thread Information.
type ProcessThreadInfo struct {
	// ProcessThreadInfoProperties - ProcessThreadInfo resource specific properties
	*ProcessThreadInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessThreadInfo.
func (pti ProcessThreadInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pti.ProcessThreadInfoProperties != nil {
		objectMap["properties"] = pti.ProcessThreadInfoProperties
	}
	if pti.Kind != nil {
		objectMap["kind"] = pti.Kind
	}
	if pti.SystemData != nil {
		objectMap["systemData"] = pti.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProcessThreadInfo struct.
func (pti *ProcessThreadInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var processThreadInfoProperties ProcessThreadInfoProperties
				err = json.Unmarshal(*v, &processThreadInfoProperties)
				if err != nil {
					return err
				}
				pti.ProcessThreadInfoProperties = &processThreadInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pti.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pti.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pti.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pti.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pti.SystemData = &systemData
			}
		}
	}

	return nil
}

// ProcessThreadInfoCollection collection of Kudu thread information elements.
type ProcessThreadInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ProcessThreadInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessThreadInfoCollection.
func (ptic ProcessThreadInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ptic.Value != nil {
		objectMap["value"] = ptic.Value
	}
	return json.Marshal(objectMap)
}

// ProcessThreadInfoCollectionIterator provides access to a complete listing of ProcessThreadInfo values.
type ProcessThreadInfoCollectionIterator struct {
	i    int
	page ProcessThreadInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProcessThreadInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessThreadInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProcessThreadInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProcessThreadInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProcessThreadInfoCollectionIterator) Response() ProcessThreadInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProcessThreadInfoCollectionIterator) Value() ProcessThreadInfo {
	if !iter.page.NotDone() {
		return ProcessThreadInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProcessThreadInfoCollectionIterator type.
func NewProcessThreadInfoCollectionIterator(page ProcessThreadInfoCollectionPage) ProcessThreadInfoCollectionIterator {
	return ProcessThreadInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ptic ProcessThreadInfoCollection) IsEmpty() bool {
	return ptic.Value == nil || len(*ptic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ptic ProcessThreadInfoCollection) hasNextLink() bool {
	return ptic.NextLink != nil && len(*ptic.NextLink) != 0
}

// processThreadInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ptic ProcessThreadInfoCollection) processThreadInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ptic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ptic.NextLink)))
}

// ProcessThreadInfoCollectionPage contains a page of ProcessThreadInfo values.
type ProcessThreadInfoCollectionPage struct {
	fn   func(context.Context, ProcessThreadInfoCollection) (ProcessThreadInfoCollection, error)
	ptic ProcessThreadInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProcessThreadInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProcessThreadInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ptic)
		if err != nil {
			return err
		}
		page.ptic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProcessThreadInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProcessThreadInfoCollectionPage) NotDone() bool {
	return !page.ptic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProcessThreadInfoCollectionPage) Response() ProcessThreadInfoCollection {
	return page.ptic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProcessThreadInfoCollectionPage) Values() []ProcessThreadInfo {
	if page.ptic.IsEmpty() {
		return nil
	}
	return *page.ptic.Value
}

// Creates a new instance of the ProcessThreadInfoCollectionPage type.
func NewProcessThreadInfoCollectionPage(cur ProcessThreadInfoCollection, getNextPage func(context.Context, ProcessThreadInfoCollection) (ProcessThreadInfoCollection, error)) ProcessThreadInfoCollectionPage {
	return ProcessThreadInfoCollectionPage{
		fn:   getNextPage,
		ptic: cur,
	}
}

// ProcessThreadInfoProperties processThreadInfo resource specific properties
type ProcessThreadInfoProperties struct {
	// Identifier - READ-ONLY; Site extension ID.
	Identifier *int32 `json:"identifier,omitempty"`
	// Href - HRef URI.
	Href *string `json:"href,omitempty"`
	// Process - Process URI.
	Process *string `json:"process,omitempty"`
	// StartAddress - Start address.
	StartAddress *string `json:"start_address,omitempty"`
	// CurrentPriority - Current thread priority.
	CurrentPriority *int32 `json:"current_priority,omitempty"`
	// PriorityLevel - Thread priority level.
	PriorityLevel *string `json:"priority_level,omitempty"`
	// BasePriority - Base priority.
	BasePriority *int32 `json:"base_priority,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"start_time,omitempty"`
	// TotalProcessorTime - Total processor time.
	TotalProcessorTime *string `json:"total_processor_time,omitempty"`
	// UserProcessorTime - User processor time.
	UserProcessorTime *string `json:"user_processor_time,omitempty"`
	// State - Thread state.
	State *string `json:"state,omitempty"`
	// WaitReason - Wait reason.
	WaitReason *string `json:"wait_reason,omitempty"`
}

// MarshalJSON is the custom marshaler for ProcessThreadInfoProperties.
func (pti ProcessThreadInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pti.Href != nil {
		objectMap["href"] = pti.Href
	}
	if pti.Process != nil {
		objectMap["process"] = pti.Process
	}
	if pti.StartAddress != nil {
		objectMap["start_address"] = pti.StartAddress
	}
	if pti.CurrentPriority != nil {
		objectMap["current_priority"] = pti.CurrentPriority
	}
	if pti.PriorityLevel != nil {
		objectMap["priority_level"] = pti.PriorityLevel
	}
	if pti.BasePriority != nil {
		objectMap["base_priority"] = pti.BasePriority
	}
	if pti.StartTime != nil {
		objectMap["start_time"] = pti.StartTime
	}
	if pti.TotalProcessorTime != nil {
		objectMap["total_processor_time"] = pti.TotalProcessorTime
	}
	if pti.UserProcessorTime != nil {
		objectMap["user_processor_time"] = pti.UserProcessorTime
	}
	if pti.State != nil {
		objectMap["state"] = pti.State
	}
	if pti.WaitReason != nil {
		objectMap["wait_reason"] = pti.WaitReason
	}
	return json.Marshal(objectMap)
}

// ProxyOnlyResource azure proxy only resource. This resource is not tracked by Azure Resource Manager.
type ProxyOnlyResource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyOnlyResource.
func (por ProxyOnlyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if por.Kind != nil {
		objectMap["kind"] = por.Kind
	}
	if por.SystemData != nil {
		objectMap["systemData"] = por.SystemData
	}
	return json.Marshal(objectMap)
}

// PublicCertificate public certificate object
type PublicCertificate struct {
	autorest.Response `json:"-"`
	// PublicCertificateProperties - PublicCertificate resource specific properties
	*PublicCertificateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicCertificate.
func (pc PublicCertificate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.PublicCertificateProperties != nil {
		objectMap["properties"] = pc.PublicCertificateProperties
	}
	if pc.Kind != nil {
		objectMap["kind"] = pc.Kind
	}
	if pc.SystemData != nil {
		objectMap["systemData"] = pc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PublicCertificate struct.
func (pc *PublicCertificate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var publicCertificateProperties PublicCertificateProperties
				err = json.Unmarshal(*v, &publicCertificateProperties)
				if err != nil {
					return err
				}
				pc.PublicCertificateProperties = &publicCertificateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				pc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pc.SystemData = &systemData
			}
		}
	}

	return nil
}

// PublicCertificateCollection collection of public certificates
type PublicCertificateCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]PublicCertificate `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicCertificateCollection.
func (pcc PublicCertificateCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pcc.Value != nil {
		objectMap["value"] = pcc.Value
	}
	return json.Marshal(objectMap)
}

// PublicCertificateCollectionIterator provides access to a complete listing of PublicCertificate values.
type PublicCertificateCollectionIterator struct {
	i    int
	page PublicCertificateCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PublicCertificateCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicCertificateCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PublicCertificateCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PublicCertificateCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PublicCertificateCollectionIterator) Response() PublicCertificateCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PublicCertificateCollectionIterator) Value() PublicCertificate {
	if !iter.page.NotDone() {
		return PublicCertificate{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PublicCertificateCollectionIterator type.
func NewPublicCertificateCollectionIterator(page PublicCertificateCollectionPage) PublicCertificateCollectionIterator {
	return PublicCertificateCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcc PublicCertificateCollection) IsEmpty() bool {
	return pcc.Value == nil || len(*pcc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pcc PublicCertificateCollection) hasNextLink() bool {
	return pcc.NextLink != nil && len(*pcc.NextLink) != 0
}

// publicCertificateCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcc PublicCertificateCollection) publicCertificateCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !pcc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcc.NextLink)))
}

// PublicCertificateCollectionPage contains a page of PublicCertificate values.
type PublicCertificateCollectionPage struct {
	fn  func(context.Context, PublicCertificateCollection) (PublicCertificateCollection, error)
	pcc PublicCertificateCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PublicCertificateCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PublicCertificateCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pcc)
		if err != nil {
			return err
		}
		page.pcc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PublicCertificateCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PublicCertificateCollectionPage) NotDone() bool {
	return !page.pcc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PublicCertificateCollectionPage) Response() PublicCertificateCollection {
	return page.pcc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PublicCertificateCollectionPage) Values() []PublicCertificate {
	if page.pcc.IsEmpty() {
		return nil
	}
	return *page.pcc.Value
}

// Creates a new instance of the PublicCertificateCollectionPage type.
func NewPublicCertificateCollectionPage(cur PublicCertificateCollection, getNextPage func(context.Context, PublicCertificateCollection) (PublicCertificateCollection, error)) PublicCertificateCollectionPage {
	return PublicCertificateCollectionPage{
		fn:  getNextPage,
		pcc: cur,
	}
}

// PublicCertificateProperties publicCertificate resource specific properties
type PublicCertificateProperties struct {
	// Blob - Public Certificate byte array
	Blob *[]byte `json:"blob,omitempty"`
	// PublicCertificateLocation - Public Certificate Location. Possible values include: 'PublicCertificateLocationCurrentUserMy', 'PublicCertificateLocationLocalMachineMy', 'PublicCertificateLocationUnknown'
	PublicCertificateLocation PublicCertificateLocation `json:"publicCertificateLocation,omitempty"`
	// Thumbprint - READ-ONLY; Certificate Thumbprint
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicCertificateProperties.
func (pc PublicCertificateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.Blob != nil {
		objectMap["blob"] = pc.Blob
	}
	if pc.PublicCertificateLocation != "" {
		objectMap["publicCertificateLocation"] = pc.PublicCertificateLocation
	}
	return json.Marshal(objectMap)
}

// PushSettings push settings for the App.
type PushSettings struct {
	autorest.Response `json:"-"`
	// PushSettingsProperties - PushSettings resource specific properties
	*PushSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PushSettings.
func (ps PushSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ps.PushSettingsProperties != nil {
		objectMap["properties"] = ps.PushSettingsProperties
	}
	if ps.Kind != nil {
		objectMap["kind"] = ps.Kind
	}
	if ps.SystemData != nil {
		objectMap["systemData"] = ps.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PushSettings struct.
func (ps *PushSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pushSettingsProperties PushSettingsProperties
				err = json.Unmarshal(*v, &pushSettingsProperties)
				if err != nil {
					return err
				}
				ps.PushSettingsProperties = &pushSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ps.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ps.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ps.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ps.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ps.SystemData = &systemData
			}
		}
	}

	return nil
}

// PushSettingsProperties pushSettings resource specific properties
type PushSettingsProperties struct {
	// IsPushEnabled - Gets or sets a flag indicating whether the Push endpoint is enabled.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// TagWhitelistJSON - Gets or sets a JSON string containing a list of tags that are whitelisted for use by the push registration endpoint.
	TagWhitelistJSON *string `json:"tagWhitelistJson,omitempty"`
	// TagsRequiringAuth - Gets or sets a JSON string containing a list of tags that require user authentication to be used in the push registration endpoint.
	// Tags can consist of alphanumeric characters and the following:
	// '_', '@', '#', '.', ':', '-'.
	// Validation should be performed at the PushRequestHandler.
	TagsRequiringAuth *string `json:"tagsRequiringAuth,omitempty"`
	// DynamicTagsJSON - Gets or sets a JSON string containing a list of dynamic tags that will be evaluated from user claims in the push registration endpoint.
	DynamicTagsJSON *string `json:"dynamicTagsJson,omitempty"`
}

// RampUpRule routing rules for ramp up testing. This rule allows to redirect static traffic % to a slot or
// to gradually change routing % based on performance.
type RampUpRule struct {
	// ActionHostName - Hostname of a slot to which the traffic will be redirected if decided to. E.g. myapp-stage.azurewebsites.net.
	ActionHostName *string `json:"actionHostName,omitempty"`
	// ReroutePercentage - Percentage of the traffic which will be redirected to <code>ActionHostName</code>.
	ReroutePercentage *float64 `json:"reroutePercentage,omitempty"`
	// ChangeStep - In auto ramp up scenario this is the step to add/remove from <code>ReroutePercentage</code> until it reaches \n<code>MinReroutePercentage</code> or
	// <code>MaxReroutePercentage</code>. Site metrics are checked every N minutes specified in <code>ChangeIntervalInMinutes</code>.\nCustom decision algorithm
	// can be provided in TiPCallback site extension which URL can be specified in <code>ChangeDecisionCallbackUrl</code>.
	ChangeStep *float64 `json:"changeStep,omitempty"`
	// ChangeIntervalInMinutes - Specifies interval in minutes to reevaluate ReroutePercentage.
	ChangeIntervalInMinutes *int32 `json:"changeIntervalInMinutes,omitempty"`
	// MinReroutePercentage - Specifies lower boundary above which ReroutePercentage will stay.
	MinReroutePercentage *float64 `json:"minReroutePercentage,omitempty"`
	// MaxReroutePercentage - Specifies upper boundary below which ReroutePercentage will stay.
	MaxReroutePercentage *float64 `json:"maxReroutePercentage,omitempty"`
	// ChangeDecisionCallbackURL - Custom decision algorithm can be provided in TiPCallback site extension which URL can be specified. See TiPCallback site extension for the scaffold and contracts.
	// https://www.siteextensions.net/packages/TiPCallback/
	ChangeDecisionCallbackURL *string `json:"changeDecisionCallbackUrl,omitempty"`
	// Name - Name of the routing rule. The recommended name would be to point to the slot which will receive the traffic in the experiment.
	Name *string `json:"name,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// Recommendation represents a recommendation result generated by the recommendation engine.
type Recommendation struct {
	// RecommendationProperties - Recommendation resource specific properties
	*RecommendationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Recommendation.
func (r Recommendation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RecommendationProperties != nil {
		objectMap["properties"] = r.RecommendationProperties
	}
	if r.Kind != nil {
		objectMap["kind"] = r.Kind
	}
	if r.SystemData != nil {
		objectMap["systemData"] = r.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Recommendation struct.
func (r *Recommendation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendationProperties RecommendationProperties
				err = json.Unmarshal(*v, &recommendationProperties)
				if err != nil {
					return err
				}
				r.RecommendationProperties = &recommendationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				r.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// RecommendationCollection collection of recommendations.
type RecommendationCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Recommendation `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationCollection.
func (rc RecommendationCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rc.Value != nil {
		objectMap["value"] = rc.Value
	}
	return json.Marshal(objectMap)
}

// RecommendationCollectionIterator provides access to a complete listing of Recommendation values.
type RecommendationCollectionIterator struct {
	i    int
	page RecommendationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RecommendationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RecommendationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RecommendationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RecommendationCollectionIterator) Response() RecommendationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RecommendationCollectionIterator) Value() Recommendation {
	if !iter.page.NotDone() {
		return Recommendation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RecommendationCollectionIterator type.
func NewRecommendationCollectionIterator(page RecommendationCollectionPage) RecommendationCollectionIterator {
	return RecommendationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc RecommendationCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rc RecommendationCollection) hasNextLink() bool {
	return rc.NextLink != nil && len(*rc.NextLink) != 0
}

// recommendationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc RecommendationCollection) recommendationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// RecommendationCollectionPage contains a page of Recommendation values.
type RecommendationCollectionPage struct {
	fn func(context.Context, RecommendationCollection) (RecommendationCollection, error)
	rc RecommendationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RecommendationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecommendationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rc)
		if err != nil {
			return err
		}
		page.rc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RecommendationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RecommendationCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RecommendationCollectionPage) Response() RecommendationCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RecommendationCollectionPage) Values() []Recommendation {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the RecommendationCollectionPage type.
func NewRecommendationCollectionPage(cur RecommendationCollection, getNextPage func(context.Context, RecommendationCollection) (RecommendationCollection, error)) RecommendationCollectionPage {
	return RecommendationCollectionPage{
		fn: getNextPage,
		rc: cur,
	}
}

// RecommendationProperties recommendation resource specific properties
type RecommendationProperties struct {
	// CreationTime - Timestamp when this instance was created.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// RecommendationID - A GUID value that each recommendation object is associated with.
	RecommendationID *uuid.UUID `json:"recommendationId,omitempty"`
	// ResourceID - Full ARM resource ID string that this recommendation object is associated with.
	ResourceID *string `json:"resourceId,omitempty"`
	// ResourceScope - Name of a resource type this recommendation applies, e.g. Subscription, ServerFarm, Site. Possible values include: 'ServerFarm', 'Subscription', 'WebSite'
	ResourceScope ResourceScopeType `json:"resourceScope,omitempty"`
	// RuleName - Unique name of the rule.
	RuleName *string `json:"ruleName,omitempty"`
	// DisplayName - UI friendly name of the rule (may not be unique).
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Recommendation text.
	Message *string `json:"message,omitempty"`
	// Level - Level indicating how critical this recommendation can impact. Possible values include: 'NotificationLevelCritical', 'NotificationLevelWarning', 'NotificationLevelInformation', 'NotificationLevelNonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of channels that this recommendation can apply. Possible values include: 'Notification', 'API', 'Email', 'Webhook', 'All'
	Channels Channels `json:"channels,omitempty"`
	// CategoryTags - READ-ONLY; The list of category tags that this recommendation belongs to.
	CategoryTags *[]string `json:"categoryTags,omitempty"`
	// ActionName - Name of action recommended by this object.
	ActionName *string `json:"actionName,omitempty"`
	// Enabled - True if this recommendation is still valid (i.e. "actionable"). False if it is invalid.
	Enabled *int32 `json:"enabled,omitempty"`
	// States - The list of states of this recommendation. If it's null then it should be considered "Active".
	States *[]string `json:"states,omitempty"`
	// StartTime - The beginning time in UTC of a range that the recommendation refers to.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time in UTC of a range that the recommendation refers to.
	EndTime *date.Time `json:"endTime,omitempty"`
	// NextNotificationTime - When to notify this recommendation next in UTC. Null means that this will never be notified anymore.
	NextNotificationTime *date.Time `json:"nextNotificationTime,omitempty"`
	// NotificationExpirationTime - Date and time in UTC when this notification expires.
	NotificationExpirationTime *date.Time `json:"notificationExpirationTime,omitempty"`
	// NotifiedTime - Last timestamp in UTC this instance was actually notified. Null means that this recommendation hasn't been notified yet.
	NotifiedTime *date.Time `json:"notifiedTime,omitempty"`
	// Score - A metric value measured by the rule.
	Score *float64 `json:"score,omitempty"`
	// IsDynamic - True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// ExtensionName - Extension name of the portal if exists.
	ExtensionName *string `json:"extensionName,omitempty"`
	// BladeName - Deep link to a blade on the portal.
	BladeName *string `json:"bladeName,omitempty"`
	// ForwardLink - Forward link to an external document associated with the rule.
	ForwardLink *string `json:"forwardLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationProperties.
func (r RecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.CreationTime != nil {
		objectMap["creationTime"] = r.CreationTime
	}
	if r.RecommendationID != nil {
		objectMap["recommendationId"] = r.RecommendationID
	}
	if r.ResourceID != nil {
		objectMap["resourceId"] = r.ResourceID
	}
	if r.ResourceScope != "" {
		objectMap["resourceScope"] = r.ResourceScope
	}
	if r.RuleName != nil {
		objectMap["ruleName"] = r.RuleName
	}
	if r.DisplayName != nil {
		objectMap["displayName"] = r.DisplayName
	}
	if r.Message != nil {
		objectMap["message"] = r.Message
	}
	if r.Level != "" {
		objectMap["level"] = r.Level
	}
	if r.Channels != "" {
		objectMap["channels"] = r.Channels
	}
	if r.ActionName != nil {
		objectMap["actionName"] = r.ActionName
	}
	if r.Enabled != nil {
		objectMap["enabled"] = r.Enabled
	}
	if r.States != nil {
		objectMap["states"] = r.States
	}
	if r.StartTime != nil {
		objectMap["startTime"] = r.StartTime
	}
	if r.EndTime != nil {
		objectMap["endTime"] = r.EndTime
	}
	if r.NextNotificationTime != nil {
		objectMap["nextNotificationTime"] = r.NextNotificationTime
	}
	if r.NotificationExpirationTime != nil {
		objectMap["notificationExpirationTime"] = r.NotificationExpirationTime
	}
	if r.NotifiedTime != nil {
		objectMap["notifiedTime"] = r.NotifiedTime
	}
	if r.Score != nil {
		objectMap["score"] = r.Score
	}
	if r.IsDynamic != nil {
		objectMap["isDynamic"] = r.IsDynamic
	}
	if r.ExtensionName != nil {
		objectMap["extensionName"] = r.ExtensionName
	}
	if r.BladeName != nil {
		objectMap["bladeName"] = r.BladeName
	}
	if r.ForwardLink != nil {
		objectMap["forwardLink"] = r.ForwardLink
	}
	return json.Marshal(objectMap)
}

// RecommendationRule represents a recommendation rule that the recommendation engine can perform.
type RecommendationRule struct {
	autorest.Response `json:"-"`
	// RecommendationRuleProperties - RecommendationRule resource specific properties
	*RecommendationRuleProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationRule.
func (rr RecommendationRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RecommendationRuleProperties != nil {
		objectMap["properties"] = rr.RecommendationRuleProperties
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.SystemData != nil {
		objectMap["systemData"] = rr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendationRule struct.
func (rr *RecommendationRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendationRuleProperties RecommendationRuleProperties
				err = json.Unmarshal(*v, &recommendationRuleProperties)
				if err != nil {
					return err
				}
				rr.RecommendationRuleProperties = &recommendationRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rr.SystemData = &systemData
			}
		}
	}

	return nil
}

// RecommendationRuleProperties recommendationRule resource specific properties
type RecommendationRuleProperties struct {
	// RecommendationName - Unique name of the rule.
	RecommendationName *string `json:"recommendationName,omitempty"`
	// DisplayName - UI friendly name of the rule.
	DisplayName *string `json:"displayName,omitempty"`
	// Message - Localized name of the rule (Good for UI).
	Message *string `json:"message,omitempty"`
	// RecommendationID - Recommendation ID of an associated recommendation object tied to the rule, if exists.
	// If such an object doesn't exist, it is set to null.
	RecommendationID *uuid.UUID `json:"recommendationId,omitempty"`
	// Description - Localized detailed description of the rule.
	Description *string `json:"description,omitempty"`
	// ActionName - Name of action that is recommended by this rule in string.
	ActionName *string `json:"actionName,omitempty"`
	// Level - Level of impact indicating how critical this rule is. Possible values include: 'NotificationLevelCritical', 'NotificationLevelWarning', 'NotificationLevelInformation', 'NotificationLevelNonUrgentSuggestion'
	Level NotificationLevel `json:"level,omitempty"`
	// Channels - List of available channels that this rule applies. Possible values include: 'Notification', 'API', 'Email', 'Webhook', 'All'
	Channels Channels `json:"channels,omitempty"`
	// CategoryTags - READ-ONLY; The list of category tags that this recommendation rule belongs to.
	CategoryTags *[]string `json:"categoryTags,omitempty"`
	// IsDynamic - True if this is associated with a dynamically added rule
	IsDynamic *bool `json:"isDynamic,omitempty"`
	// ExtensionName - Extension name of the portal if exists. Applicable to dynamic rule only.
	ExtensionName *string `json:"extensionName,omitempty"`
	// BladeName - Deep link to a blade on the portal. Applicable to dynamic rule only.
	BladeName *string `json:"bladeName,omitempty"`
	// ForwardLink - Forward link to an external document associated with the rule. Applicable to dynamic rule only.
	ForwardLink *string `json:"forwardLink,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendationRuleProperties.
func (rr RecommendationRuleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RecommendationName != nil {
		objectMap["recommendationName"] = rr.RecommendationName
	}
	if rr.DisplayName != nil {
		objectMap["displayName"] = rr.DisplayName
	}
	if rr.Message != nil {
		objectMap["message"] = rr.Message
	}
	if rr.RecommendationID != nil {
		objectMap["recommendationId"] = rr.RecommendationID
	}
	if rr.Description != nil {
		objectMap["description"] = rr.Description
	}
	if rr.ActionName != nil {
		objectMap["actionName"] = rr.ActionName
	}
	if rr.Level != "" {
		objectMap["level"] = rr.Level
	}
	if rr.Channels != "" {
		objectMap["channels"] = rr.Channels
	}
	if rr.IsDynamic != nil {
		objectMap["isDynamic"] = rr.IsDynamic
	}
	if rr.ExtensionName != nil {
		objectMap["extensionName"] = rr.ExtensionName
	}
	if rr.BladeName != nil {
		objectMap["bladeName"] = rr.BladeName
	}
	if rr.ForwardLink != nil {
		objectMap["forwardLink"] = rr.ForwardLink
	}
	return json.Marshal(objectMap)
}

// ReissueCertificateOrderRequest class representing certificate reissue request.
type ReissueCertificateOrderRequest struct {
	// ReissueCertificateOrderRequestProperties - ReissueCertificateOrderRequest resource specific properties
	*ReissueCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ReissueCertificateOrderRequest.
func (rcor ReissueCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.ReissueCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.ReissueCertificateOrderRequestProperties
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.SystemData != nil {
		objectMap["systemData"] = rcor.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReissueCertificateOrderRequest struct.
func (rcor *ReissueCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var reissueCertificateOrderRequestProperties ReissueCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &reissueCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.ReissueCertificateOrderRequestProperties = &reissueCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rcor.SystemData = &systemData
			}
		}
	}

	return nil
}

// ReissueCertificateOrderRequestProperties reissueCertificateOrderRequest resource specific properties
type ReissueCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
	// DelayExistingRevokeInHours - Delay in hours to revoke existing certificate after the new certificate is issued.
	DelayExistingRevokeInHours *int32 `json:"delayExistingRevokeInHours,omitempty"`
	// Csr - Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`
	// IsPrivateKeyExternal - Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
}

// RelayServiceConnectionEntity hybrid Connection for an App Service app.
type RelayServiceConnectionEntity struct {
	autorest.Response `json:"-"`
	// RelayServiceConnectionEntityProperties - RelayServiceConnectionEntity resource specific properties
	*RelayServiceConnectionEntityProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RelayServiceConnectionEntity.
func (rsce RelayServiceConnectionEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rsce.RelayServiceConnectionEntityProperties != nil {
		objectMap["properties"] = rsce.RelayServiceConnectionEntityProperties
	}
	if rsce.Kind != nil {
		objectMap["kind"] = rsce.Kind
	}
	if rsce.SystemData != nil {
		objectMap["systemData"] = rsce.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RelayServiceConnectionEntity struct.
func (rsce *RelayServiceConnectionEntity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var relayServiceConnectionEntityProperties RelayServiceConnectionEntityProperties
				err = json.Unmarshal(*v, &relayServiceConnectionEntityProperties)
				if err != nil {
					return err
				}
				rsce.RelayServiceConnectionEntityProperties = &relayServiceConnectionEntityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rsce.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rsce.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rsce.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rsce.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rsce.SystemData = &systemData
			}
		}
	}

	return nil
}

// RelayServiceConnectionEntityProperties relayServiceConnectionEntity resource specific properties
type RelayServiceConnectionEntityProperties struct {
	EntityName               *string `json:"entityName,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
}

// RemotePrivateEndpointConnection a remote private endpoint connection
type RemotePrivateEndpointConnection struct {
	// ProvisioningState - READ-ONLY
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// PrivateEndpoint - PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint                   *ArmIDWrapper               `json:"privateEndpoint,omitempty"`
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// MarshalJSON is the custom marshaler for RemotePrivateEndpointConnection.
func (rpec RemotePrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rpec.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = rpec.PrivateEndpoint
	}
	if rpec.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = rpec.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// Rendering instructions for rendering the data
type Rendering struct {
	// Type - Rendering Type. Possible values include: 'NoGraph', 'Table', 'TimeSeries', 'TimeSeriesPerInstance'
	Type RenderingType `json:"type,omitempty"`
	// Title - Title of data
	Title *string `json:"title,omitempty"`
	// Description - Description of the data that will help it be interpreted
	Description *string `json:"description,omitempty"`
}

// RenewCertificateOrderRequest class representing certificate renew request.
type RenewCertificateOrderRequest struct {
	// RenewCertificateOrderRequestProperties - RenewCertificateOrderRequest resource specific properties
	*RenewCertificateOrderRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RenewCertificateOrderRequest.
func (rcor RenewCertificateOrderRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rcor.RenewCertificateOrderRequestProperties != nil {
		objectMap["properties"] = rcor.RenewCertificateOrderRequestProperties
	}
	if rcor.Kind != nil {
		objectMap["kind"] = rcor.Kind
	}
	if rcor.SystemData != nil {
		objectMap["systemData"] = rcor.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RenewCertificateOrderRequest struct.
func (rcor *RenewCertificateOrderRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var renewCertificateOrderRequestProperties RenewCertificateOrderRequestProperties
				err = json.Unmarshal(*v, &renewCertificateOrderRequestProperties)
				if err != nil {
					return err
				}
				rcor.RenewCertificateOrderRequestProperties = &renewCertificateOrderRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rcor.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rcor.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rcor.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rcor.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rcor.SystemData = &systemData
			}
		}
	}

	return nil
}

// RenewCertificateOrderRequestProperties renewCertificateOrderRequest resource specific properties
type RenewCertificateOrderRequestProperties struct {
	// KeySize - Certificate Key Size.
	KeySize *int32 `json:"keySize,omitempty"`
	// Csr - Csr to be used for re-key operation.
	Csr *string `json:"csr,omitempty"`
	// IsPrivateKeyExternal - Should we change the ASC type (from managed private key to external private key and vice versa).
	IsPrivateKeyExternal *bool `json:"isPrivateKeyExternal,omitempty"`
}

// RequestsBasedTrigger trigger based on total requests.
type RequestsBasedTrigger struct {
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource azure resource. This resource is tracked in Azure Resource Manager
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Kind != nil {
		objectMap["kind"] = r.Kind
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.SystemData != nil {
		objectMap["systemData"] = r.SystemData
	}
	return json.Marshal(objectMap)
}

// ResourceCollection collection of resources.
type ResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]string `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceCollection.
func (rc ResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rc.Value != nil {
		objectMap["value"] = rc.Value
	}
	return json.Marshal(objectMap)
}

// ResourceCollectionIterator provides access to a complete listing of string values.
type ResourceCollectionIterator struct {
	i    int
	page ResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceCollectionIterator) Response() ResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceCollectionIterator) Value() string {
	if !iter.page.NotDone() {
		return ""
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceCollectionIterator type.
func NewResourceCollectionIterator(page ResourceCollectionPage) ResourceCollectionIterator {
	return ResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rc ResourceCollection) IsEmpty() bool {
	return rc.Value == nil || len(*rc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rc ResourceCollection) hasNextLink() bool {
	return rc.NextLink != nil && len(*rc.NextLink) != 0
}

// resourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rc ResourceCollection) resourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rc.NextLink)))
}

// ResourceCollectionPage contains a page of string values.
type ResourceCollectionPage struct {
	fn func(context.Context, ResourceCollection) (ResourceCollection, error)
	rc ResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rc)
		if err != nil {
			return err
		}
		page.rc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceCollectionPage) NotDone() bool {
	return !page.rc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceCollectionPage) Response() ResourceCollection {
	return page.rc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceCollectionPage) Values() []string {
	if page.rc.IsEmpty() {
		return nil
	}
	return *page.rc.Value
}

// Creates a new instance of the ResourceCollectionPage type.
func NewResourceCollectionPage(cur ResourceCollection, getNextPage func(context.Context, ResourceCollection) (ResourceCollection, error)) ResourceCollectionPage {
	return ResourceCollectionPage{
		fn: getNextPage,
		rc: cur,
	}
}

// ResourceHealthMetadata used for getting ResourceHealthCheck settings.
type ResourceHealthMetadata struct {
	autorest.Response `json:"-"`
	// ResourceHealthMetadataProperties - ResourceHealthMetadata resource specific properties
	*ResourceHealthMetadataProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceHealthMetadata.
func (rhm ResourceHealthMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rhm.ResourceHealthMetadataProperties != nil {
		objectMap["properties"] = rhm.ResourceHealthMetadataProperties
	}
	if rhm.Kind != nil {
		objectMap["kind"] = rhm.Kind
	}
	if rhm.SystemData != nil {
		objectMap["systemData"] = rhm.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceHealthMetadata struct.
func (rhm *ResourceHealthMetadata) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceHealthMetadataProperties ResourceHealthMetadataProperties
				err = json.Unmarshal(*v, &resourceHealthMetadataProperties)
				if err != nil {
					return err
				}
				rhm.ResourceHealthMetadataProperties = &resourceHealthMetadataProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rhm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rhm.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rhm.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rhm.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rhm.SystemData = &systemData
			}
		}
	}

	return nil
}

// ResourceHealthMetadataCollection collection of resource health metadata.
type ResourceHealthMetadataCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ResourceHealthMetadata `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceHealthMetadataCollection.
func (rhmc ResourceHealthMetadataCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rhmc.Value != nil {
		objectMap["value"] = rhmc.Value
	}
	return json.Marshal(objectMap)
}

// ResourceHealthMetadataCollectionIterator provides access to a complete listing of ResourceHealthMetadata
// values.
type ResourceHealthMetadataCollectionIterator struct {
	i    int
	page ResourceHealthMetadataCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceHealthMetadataCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceHealthMetadataCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceHealthMetadataCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceHealthMetadataCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceHealthMetadataCollectionIterator) Response() ResourceHealthMetadataCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceHealthMetadataCollectionIterator) Value() ResourceHealthMetadata {
	if !iter.page.NotDone() {
		return ResourceHealthMetadata{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceHealthMetadataCollectionIterator type.
func NewResourceHealthMetadataCollectionIterator(page ResourceHealthMetadataCollectionPage) ResourceHealthMetadataCollectionIterator {
	return ResourceHealthMetadataCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rhmc ResourceHealthMetadataCollection) IsEmpty() bool {
	return rhmc.Value == nil || len(*rhmc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rhmc ResourceHealthMetadataCollection) hasNextLink() bool {
	return rhmc.NextLink != nil && len(*rhmc.NextLink) != 0
}

// resourceHealthMetadataCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rhmc ResourceHealthMetadataCollection) resourceHealthMetadataCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rhmc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rhmc.NextLink)))
}

// ResourceHealthMetadataCollectionPage contains a page of ResourceHealthMetadata values.
type ResourceHealthMetadataCollectionPage struct {
	fn   func(context.Context, ResourceHealthMetadataCollection) (ResourceHealthMetadataCollection, error)
	rhmc ResourceHealthMetadataCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceHealthMetadataCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceHealthMetadataCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rhmc)
		if err != nil {
			return err
		}
		page.rhmc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceHealthMetadataCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceHealthMetadataCollectionPage) NotDone() bool {
	return !page.rhmc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceHealthMetadataCollectionPage) Response() ResourceHealthMetadataCollection {
	return page.rhmc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceHealthMetadataCollectionPage) Values() []ResourceHealthMetadata {
	if page.rhmc.IsEmpty() {
		return nil
	}
	return *page.rhmc.Value
}

// Creates a new instance of the ResourceHealthMetadataCollectionPage type.
func NewResourceHealthMetadataCollectionPage(cur ResourceHealthMetadataCollection, getNextPage func(context.Context, ResourceHealthMetadataCollection) (ResourceHealthMetadataCollection, error)) ResourceHealthMetadataCollectionPage {
	return ResourceHealthMetadataCollectionPage{
		fn:   getNextPage,
		rhmc: cur,
	}
}

// ResourceHealthMetadataProperties resourceHealthMetadata resource specific properties
type ResourceHealthMetadataProperties struct {
	// Category - The category that the resource matches in the RHC Policy File
	Category *string `json:"category,omitempty"`
	// SignalAvailability - Is there a health signal for the resource
	SignalAvailability *bool `json:"signalAvailability,omitempty"`
}

// ResourceMetricAvailability metrics availability and retention.
type ResourceMetricAvailability struct {
	// TimeGrain - READ-ONLY; Time grain .
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - READ-ONLY; Retention period for the current time grain.
	Retention *string `json:"retention,omitempty"`
}

// ResourceMetricDefinition metadata for the metrics.
type ResourceMetricDefinition struct {
	// ResourceMetricDefinitionProperties - ResourceMetricDefinition resource specific properties
	*ResourceMetricDefinitionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceMetricDefinition.
func (rmd ResourceMetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmd.ResourceMetricDefinitionProperties != nil {
		objectMap["properties"] = rmd.ResourceMetricDefinitionProperties
	}
	if rmd.Kind != nil {
		objectMap["kind"] = rmd.Kind
	}
	if rmd.SystemData != nil {
		objectMap["systemData"] = rmd.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ResourceMetricDefinition struct.
func (rmd *ResourceMetricDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var resourceMetricDefinitionProperties ResourceMetricDefinitionProperties
				err = json.Unmarshal(*v, &resourceMetricDefinitionProperties)
				if err != nil {
					return err
				}
				rmd.ResourceMetricDefinitionProperties = &resourceMetricDefinitionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rmd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rmd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rmd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rmd.SystemData = &systemData
			}
		}
	}

	return nil
}

// ResourceMetricDefinitionCollection collection of metric definitions.
type ResourceMetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]ResourceMetricDefinition `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceMetricDefinitionCollection.
func (rmdc ResourceMetricDefinitionCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rmdc.Value != nil {
		objectMap["value"] = rmdc.Value
	}
	return json.Marshal(objectMap)
}

// ResourceMetricDefinitionCollectionIterator provides access to a complete listing of
// ResourceMetricDefinition values.
type ResourceMetricDefinitionCollectionIterator struct {
	i    int
	page ResourceMetricDefinitionCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceMetricDefinitionCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricDefinitionCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceMetricDefinitionCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceMetricDefinitionCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceMetricDefinitionCollectionIterator) Response() ResourceMetricDefinitionCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceMetricDefinitionCollectionIterator) Value() ResourceMetricDefinition {
	if !iter.page.NotDone() {
		return ResourceMetricDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceMetricDefinitionCollectionIterator type.
func NewResourceMetricDefinitionCollectionIterator(page ResourceMetricDefinitionCollectionPage) ResourceMetricDefinitionCollectionIterator {
	return ResourceMetricDefinitionCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rmdc ResourceMetricDefinitionCollection) IsEmpty() bool {
	return rmdc.Value == nil || len(*rmdc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rmdc ResourceMetricDefinitionCollection) hasNextLink() bool {
	return rmdc.NextLink != nil && len(*rmdc.NextLink) != 0
}

// resourceMetricDefinitionCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rmdc ResourceMetricDefinitionCollection) resourceMetricDefinitionCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !rmdc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rmdc.NextLink)))
}

// ResourceMetricDefinitionCollectionPage contains a page of ResourceMetricDefinition values.
type ResourceMetricDefinitionCollectionPage struct {
	fn   func(context.Context, ResourceMetricDefinitionCollection) (ResourceMetricDefinitionCollection, error)
	rmdc ResourceMetricDefinitionCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceMetricDefinitionCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceMetricDefinitionCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rmdc)
		if err != nil {
			return err
		}
		page.rmdc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceMetricDefinitionCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceMetricDefinitionCollectionPage) NotDone() bool {
	return !page.rmdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceMetricDefinitionCollectionPage) Response() ResourceMetricDefinitionCollection {
	return page.rmdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceMetricDefinitionCollectionPage) Values() []ResourceMetricDefinition {
	if page.rmdc.IsEmpty() {
		return nil
	}
	return *page.rmdc.Value
}

// Creates a new instance of the ResourceMetricDefinitionCollectionPage type.
func NewResourceMetricDefinitionCollectionPage(cur ResourceMetricDefinitionCollection, getNextPage func(context.Context, ResourceMetricDefinitionCollection) (ResourceMetricDefinitionCollection, error)) ResourceMetricDefinitionCollectionPage {
	return ResourceMetricDefinitionCollectionPage{
		fn:   getNextPage,
		rmdc: cur,
	}
}

// ResourceMetricDefinitionProperties resourceMetricDefinition resource specific properties
type ResourceMetricDefinitionProperties struct {
	// Unit - READ-ONLY; Unit of the metric.
	Unit *string `json:"unit,omitempty"`
	// PrimaryAggregationType - READ-ONLY; Primary aggregation type.
	PrimaryAggregationType *string `json:"primaryAggregationType,omitempty"`
	// MetricAvailabilities - READ-ONLY; List of time grains supported for the metric together with retention period.
	MetricAvailabilities *[]ResourceMetricAvailability `json:"metricAvailabilities,omitempty"`
	// ResourceURI - READ-ONLY; Resource URI.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Properties - READ-ONLY; Resource metric definition properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ResourceMetricDefinitionProperties.
func (rmd ResourceMetricDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceNameAvailability information regarding availability of a resource name.
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	// NameAvailable - <code>true</code> indicates name is valid and available. <code>false</code> indicates the name is invalid, unavailable, or both.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - <code>Invalid</code> indicates the name provided does not match Azure App Service naming requirements. <code>AlreadyExists</code> indicates that the name is already in use and is therefore unavailable. Possible values include: 'Invalid', 'AlreadyExists'
	Reason InAvailabilityReasonType `json:"reason,omitempty"`
	// Message - If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements so that the user can select a valid name. If reason == AlreadyExists, explain that resource name is already in use, and direct them to select a different name.
	Message *string `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'CheckNameResourceTypesSite', 'CheckNameResourceTypesSlot', 'CheckNameResourceTypesHostingEnvironment', 'CheckNameResourceTypesPublishingUser', 'CheckNameResourceTypesMicrosoftWebsites', 'CheckNameResourceTypesMicrosoftWebsitesslots', 'CheckNameResourceTypesMicrosoftWebhostingEnvironments', 'CheckNameResourceTypesMicrosoftWebpublishingUsers'
	Type CheckNameResourceTypes `json:"type,omitempty"`
	// IsFqdn - Is fully qualified domain name.
	IsFqdn *bool `json:"isFqdn,omitempty"`
}

// ResponseMetaData ...
type ResponseMetaData struct {
	// DataSource - Source of the Data
	DataSource *DataSource `json:"dataSource,omitempty"`
}

// RestoreRequest description of a restore request.
type RestoreRequest struct {
	autorest.Response `json:"-"`
	// RestoreRequestProperties - RestoreRequest resource specific properties
	*RestoreRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreRequest.
func (rr RestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rr.RestoreRequestProperties != nil {
		objectMap["properties"] = rr.RestoreRequestProperties
	}
	if rr.Kind != nil {
		objectMap["kind"] = rr.Kind
	}
	if rr.SystemData != nil {
		objectMap["systemData"] = rr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreRequest struct.
func (rr *RestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restoreRequestProperties RestoreRequestProperties
				err = json.Unmarshal(*v, &restoreRequestProperties)
				if err != nil {
					return err
				}
				rr.RestoreRequestProperties = &restoreRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				rr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				rr.SystemData = &systemData
			}
		}
	}

	return nil
}

// RestoreRequestProperties restoreRequest resource specific properties
type RestoreRequestProperties struct {
	// StorageAccountURL - SAS URL to the container.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
	// BlobName - Name of a blob which contains the backup.
	BlobName *string `json:"blobName,omitempty"`
	// Overwrite - <code>true</code> if the restore operation can overwrite target app; otherwise, <code>false</code>. <code>true</code> is needed if trying to restore over an existing app.
	Overwrite *bool `json:"overwrite,omitempty"`
	// SiteName - Name of an app.
	SiteName *string `json:"siteName,omitempty"`
	// Databases - Collection of databases which should be restored. This list has to match the list of databases included in the backup.
	Databases *[]DatabaseBackupSetting `json:"databases,omitempty"`
	// IgnoreConflictingHostNames - Changes a logic when restoring an app with custom domains. <code>true</code> to remove custom domains automatically. If <code>false</code>, custom domains are added to
	// the app's object when it is being restored, but that might fail due to conflicts during the operation.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`
	// IgnoreDatabases - Ignore the databases and only restore the site content
	IgnoreDatabases *bool `json:"ignoreDatabases,omitempty"`
	// AppServicePlan - Specify app service plan that will own restored site.
	AppServicePlan *string `json:"appServicePlan,omitempty"`
	// OperationType - Operation type. Possible values include: 'BackupRestoreOperationTypeDefault', 'BackupRestoreOperationTypeClone', 'BackupRestoreOperationTypeRelocation', 'BackupRestoreOperationTypeSnapshot', 'BackupRestoreOperationTypeCloudFS'
	OperationType BackupRestoreOperationType `json:"operationType,omitempty"`
	// AdjustConnectionStrings - <code>true</code> if SiteConfig.ConnectionStrings should be set in new app; otherwise, <code>false</code>.
	AdjustConnectionStrings *bool `json:"adjustConnectionStrings,omitempty"`
	// HostingEnvironment - App Service Environment name, if needed (only when restoring an app to an App Service Environment).
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// ServiceSpecification resource metrics service provided by Microsoft.Insights resource provider.
type ServiceSpecification struct {
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
	LogSpecifications    *[]LogSpecification    `json:"logSpecifications,omitempty"`
}

// SetObject ...
type SetObject struct {
	autorest.Response `json:"-"`
	Value             interface{} `json:"value,omitempty"`
}

// Site a web app, a mobile app backend, or an API app.
type Site struct {
	autorest.Response `json:"-"`
	// SiteProperties - Site resource specific properties
	*SiteProperties `json:"properties,omitempty"`
	Identity        *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Site.
func (s Site) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SiteProperties != nil {
		objectMap["properties"] = s.SiteProperties
	}
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.SystemData != nil {
		objectMap["systemData"] = s.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Site struct.
func (s *Site) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteProperties SiteProperties
				err = json.Unmarshal(*v, &siteProperties)
				if err != nil {
					return err
				}
				s.SiteProperties = &siteProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteAuthSettings configuration settings for the Azure App Service Authentication / Authorization
// feature.
type SiteAuthSettings struct {
	autorest.Response `json:"-"`
	// SiteAuthSettingsProperties - SiteAuthSettings resource specific properties
	*SiteAuthSettingsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteAuthSettings.
func (sas SiteAuthSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sas.SiteAuthSettingsProperties != nil {
		objectMap["properties"] = sas.SiteAuthSettingsProperties
	}
	if sas.Kind != nil {
		objectMap["kind"] = sas.Kind
	}
	if sas.SystemData != nil {
		objectMap["systemData"] = sas.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteAuthSettings struct.
func (sas *SiteAuthSettings) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteAuthSettingsProperties SiteAuthSettingsProperties
				err = json.Unmarshal(*v, &siteAuthSettingsProperties)
				if err != nil {
					return err
				}
				sas.SiteAuthSettingsProperties = &siteAuthSettingsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sas.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sas.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sas.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sas.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sas.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteAuthSettingsProperties siteAuthSettings resource specific properties
type SiteAuthSettingsProperties struct {
	// Enabled - <code>true</code> if the Authentication / Authorization feature is enabled for the current app; otherwise, <code>false</code>.
	Enabled *bool `json:"enabled,omitempty"`
	// RuntimeVersion - The RuntimeVersion of the Authentication / Authorization feature in use for the current app.
	// The setting in this value can control the behavior of certain features in the Authentication / Authorization module.
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// UnauthenticatedClientAction - The action to take when an unauthenticated client attempts to access the app. Possible values include: 'RedirectToLoginPage', 'AllowAnonymous'
	UnauthenticatedClientAction UnauthenticatedClientAction `json:"unauthenticatedClientAction,omitempty"`
	// TokenStoreEnabled - <code>true</code> to durably store platform-specific security tokens that are obtained during login flows; otherwise, <code>false</code>.
	//  The default is <code>false</code>.
	TokenStoreEnabled *bool `json:"tokenStoreEnabled,omitempty"`
	// AllowedExternalRedirectUrls - External URLs that can be redirected to as part of logging in or logging out of the app. Note that the query string part of the URL is ignored.
	// This is an advanced setting typically only needed by Windows Store application backends.
	// Note that URLs within the current domain are always implicitly allowed.
	AllowedExternalRedirectUrls *[]string `json:"allowedExternalRedirectUrls,omitempty"`
	// DefaultProvider - The default authentication provider to use when multiple providers are configured.
	// This setting is only needed if multiple providers are configured and the unauthenticated client
	// action is set to "RedirectToLoginPage". Possible values include: 'BuiltInAuthenticationProviderAzureActiveDirectory', 'BuiltInAuthenticationProviderFacebook', 'BuiltInAuthenticationProviderGoogle', 'BuiltInAuthenticationProviderMicrosoftAccount', 'BuiltInAuthenticationProviderTwitter', 'BuiltInAuthenticationProviderGithub'
	DefaultProvider BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`
	// TokenRefreshExtensionHours - The number of hours after session token expiration that a session token can be used to
	// call the token refresh API. The default is 72 hours.
	TokenRefreshExtensionHours *float64 `json:"tokenRefreshExtensionHours,omitempty"`
	// ClientID - The Client ID of this relying party application, known as the client_id.
	// This setting is required for enabling OpenID Connection authentication with Azure Active Directory or
	// other 3rd party OpenID Connect providers.
	// More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - The Client Secret of this relying party application (in Azure Active Directory, this is also referred to as the Key).
	// This setting is optional. If no client secret is configured, the OpenID Connect implicit auth flow is used to authenticate end users.
	// Otherwise, the OpenID Connect Authorization Code Flow is used to authenticate end users.
	// More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html
	ClientSecret *string `json:"clientSecret,omitempty"`
	// ClientSecretSettingName - The app setting name that contains the client secret of the relying party application.
	ClientSecretSettingName *string `json:"clientSecretSettingName,omitempty"`
	// ClientSecretCertificateThumbprint - An alternative to the client secret, that is the thumbprint of a certificate used for signing purposes. This property acts as
	// a replacement for the Client Secret. It is also optional.
	ClientSecretCertificateThumbprint *string `json:"clientSecretCertificateThumbprint,omitempty"`
	// Issuer - The OpenID Connect Issuer URI that represents the entity which issues access tokens for this application.
	// When using Azure Active Directory, this value is the URI of the directory tenant, e.g. https://sts.windows.net/{tenant-guid}/.
	// This URI is a case-sensitive identifier for the token issuer.
	// More information on OpenID Connect Discovery: http://openid.net/specs/openid-connect-discovery-1_0.html
	Issuer *string `json:"issuer,omitempty"`
	// ValidateIssuer - Gets a value indicating whether the issuer should be a valid HTTPS url and be validated as such.
	ValidateIssuer *bool `json:"validateIssuer,omitempty"`
	// AllowedAudiences - Allowed audience values to consider when validating JWTs issued by
	// Azure Active Directory. Note that the <code>ClientID</code> value is always considered an
	// allowed audience, regardless of this setting.
	AllowedAudiences *[]string `json:"allowedAudiences,omitempty"`
	// AdditionalLoginParams - Login parameters to send to the OpenID Connect authorization endpoint when
	// a user logs in. Each parameter must be in the form "key=value".
	AdditionalLoginParams *[]string `json:"additionalLoginParams,omitempty"`
	// AadClaimsAuthorization - Gets a JSON string containing the Azure AD Acl settings.
	AadClaimsAuthorization *string `json:"aadClaimsAuthorization,omitempty"`
	// GoogleClientID - The OpenID Connect Client ID for the Google web application.
	// This setting is required for enabling Google Sign-In.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientID *string `json:"googleClientId,omitempty"`
	// GoogleClientSecret - The client secret associated with the Google web application.
	// This setting is required for enabling Google Sign-In.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleClientSecret *string `json:"googleClientSecret,omitempty"`
	// GoogleClientSecretSettingName - The app setting name that contains the client secret associated with
	// the Google web application.
	GoogleClientSecretSettingName *string `json:"googleClientSecretSettingName,omitempty"`
	// GoogleOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Google Sign-In authentication.
	// This setting is optional. If not specified, "openid", "profile", and "email" are used as default scopes.
	// Google Sign-In documentation: https://developers.google.com/identity/sign-in/web/
	GoogleOAuthScopes *[]string `json:"googleOAuthScopes,omitempty"`
	// FacebookAppID - The App ID of the Facebook app used for login.
	// This setting is required for enabling Facebook Login.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppID *string `json:"facebookAppId,omitempty"`
	// FacebookAppSecret - The App Secret of the Facebook app used for Facebook Login.
	// This setting is required for enabling Facebook Login.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookAppSecret *string `json:"facebookAppSecret,omitempty"`
	// FacebookAppSecretSettingName - The app setting name that contains the app secret used for Facebook Login.
	FacebookAppSecretSettingName *string `json:"facebookAppSecretSettingName,omitempty"`
	// FacebookOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Facebook Login authentication.
	// This setting is optional.
	// Facebook Login documentation: https://developers.facebook.com/docs/facebook-login
	FacebookOAuthScopes *[]string `json:"facebookOAuthScopes,omitempty"`
	// GitHubClientID - The Client Id of the GitHub app used for login.
	// This setting is required for enabling Github login
	GitHubClientID *string `json:"gitHubClientId,omitempty"`
	// GitHubClientSecret - The Client Secret of the GitHub app used for Github Login.
	// This setting is required for enabling Github login.
	GitHubClientSecret *string `json:"gitHubClientSecret,omitempty"`
	// GitHubClientSecretSettingName - The app setting name that contains the client secret of the Github
	// app used for GitHub Login.
	GitHubClientSecretSettingName *string `json:"gitHubClientSecretSettingName,omitempty"`
	// GitHubOAuthScopes - The OAuth 2.0 scopes that will be requested as part of GitHub Login authentication.
	// This setting is optional
	GitHubOAuthScopes *[]string `json:"gitHubOAuthScopes,omitempty"`
	// TwitterConsumerKey - The OAuth 1.0a consumer key of the Twitter application used for sign-in.
	// This setting is required for enabling Twitter Sign-In.
	// Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerKey *string `json:"twitterConsumerKey,omitempty"`
	// TwitterConsumerSecret - The OAuth 1.0a consumer secret of the Twitter application used for sign-in.
	// This setting is required for enabling Twitter Sign-In.
	// Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in
	TwitterConsumerSecret *string `json:"twitterConsumerSecret,omitempty"`
	// TwitterConsumerSecretSettingName - The app setting name that contains the OAuth 1.0a consumer secret of the Twitter
	// application used for sign-in.
	TwitterConsumerSecretSettingName *string `json:"twitterConsumerSecretSettingName,omitempty"`
	// MicrosoftAccountClientID - The OAuth 2.0 client ID that was created for the app used for authentication.
	// This setting is required for enabling Microsoft Account authentication.
	// Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientID *string `json:"microsoftAccountClientId,omitempty"`
	// MicrosoftAccountClientSecret - The OAuth 2.0 client secret that was created for the app used for authentication.
	// This setting is required for enabling Microsoft Account authentication.
	// Microsoft Account OAuth documentation: https://dev.onedrive.com/auth/msa_oauth.htm
	MicrosoftAccountClientSecret *string `json:"microsoftAccountClientSecret,omitempty"`
	// MicrosoftAccountClientSecretSettingName - The app setting name containing the OAuth 2.0 client secret that was created for the
	// app used for authentication.
	MicrosoftAccountClientSecretSettingName *string `json:"microsoftAccountClientSecretSettingName,omitempty"`
	// MicrosoftAccountOAuthScopes - The OAuth 2.0 scopes that will be requested as part of Microsoft Account authentication.
	// This setting is optional. If not specified, "wl.basic" is used as the default scope.
	// Microsoft Account Scopes and permissions documentation: https://msdn.microsoft.com/en-us/library/dn631845.aspx
	MicrosoftAccountOAuthScopes *[]string `json:"microsoftAccountOAuthScopes,omitempty"`
	// IsAuthFromFile - "true" if the auth config settings should be read from a file,
	// "false" otherwise
	IsAuthFromFile *string `json:"isAuthFromFile,omitempty"`
	// AuthFilePath - The path of the config file containing auth settings.
	// If the path is relative, base will the site's root directory.
	AuthFilePath *string `json:"authFilePath,omitempty"`
}

// SiteAuthSettingsV2 ...
type SiteAuthSettingsV2 struct {
	autorest.Response `json:"-"`
	// SiteAuthSettingsV2Properties - SiteAuthSettingsV2 resource specific properties
	*SiteAuthSettingsV2Properties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteAuthSettingsV2.
func (sasv SiteAuthSettingsV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sasv.SiteAuthSettingsV2Properties != nil {
		objectMap["properties"] = sasv.SiteAuthSettingsV2Properties
	}
	if sasv.Kind != nil {
		objectMap["kind"] = sasv.Kind
	}
	if sasv.SystemData != nil {
		objectMap["systemData"] = sasv.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteAuthSettingsV2 struct.
func (sasv *SiteAuthSettingsV2) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteAuthSettingsV2Properties SiteAuthSettingsV2Properties
				err = json.Unmarshal(*v, &siteAuthSettingsV2Properties)
				if err != nil {
					return err
				}
				sasv.SiteAuthSettingsV2Properties = &siteAuthSettingsV2Properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sasv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sasv.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sasv.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sasv.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sasv.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteAuthSettingsV2Properties siteAuthSettingsV2 resource specific properties
type SiteAuthSettingsV2Properties struct {
	Platform          *AuthPlatform      `json:"platform,omitempty"`
	GlobalValidation  *GlobalValidation  `json:"globalValidation,omitempty"`
	IdentityProviders *IdentityProviders `json:"identityProviders,omitempty"`
	Login             *Login             `json:"login,omitempty"`
	HTTPSettings      *HTTPSettings      `json:"httpSettings,omitempty"`
}

// SiteCloneability represents whether or not an app is cloneable.
type SiteCloneability struct {
	autorest.Response `json:"-"`
	// Result - Name of app. Possible values include: 'Cloneable', 'PartiallyCloneable', 'NotCloneable'
	Result CloneAbilityResult `json:"result,omitempty"`
	// BlockingFeatures - List of features enabled on app that prevent cloning.
	BlockingFeatures *[]SiteCloneabilityCriterion `json:"blockingFeatures,omitempty"`
	// UnsupportedFeatures - List of features enabled on app that are non-blocking but cannot be cloned. The app can still be cloned
	// but the features in this list will not be set up on cloned app.
	UnsupportedFeatures *[]SiteCloneabilityCriterion `json:"unsupportedFeatures,omitempty"`
	// BlockingCharacteristics - List of blocking application characteristics.
	BlockingCharacteristics *[]SiteCloneabilityCriterion `json:"blockingCharacteristics,omitempty"`
}

// SiteCloneabilityCriterion an app cloneability criterion.
type SiteCloneabilityCriterion struct {
	// Name - Name of criterion.
	Name *string `json:"name,omitempty"`
	// Description - Description of criterion.
	Description *string `json:"description,omitempty"`
}

// SiteConfig configuration of an App Service app.
type SiteConfig struct {
	// NumberOfWorkers - Number of workers.
	NumberOfWorkers *int32 `json:"numberOfWorkers,omitempty"`
	// DefaultDocuments - Default documents.
	DefaultDocuments *[]string `json:"defaultDocuments,omitempty"`
	// NetFrameworkVersion - .NET Framework version.
	NetFrameworkVersion *string `json:"netFrameworkVersion,omitempty"`
	// PhpVersion - Version of PHP.
	PhpVersion *string `json:"phpVersion,omitempty"`
	// PythonVersion - Version of Python.
	PythonVersion *string `json:"pythonVersion,omitempty"`
	// NodeVersion - Version of Node.js.
	NodeVersion *string `json:"nodeVersion,omitempty"`
	// PowerShellVersion - Version of PowerShell.
	PowerShellVersion *string `json:"powerShellVersion,omitempty"`
	// LinuxFxVersion - Linux App Framework and version
	LinuxFxVersion *string `json:"linuxFxVersion,omitempty"`
	// WindowsFxVersion - Xenon App Framework and version
	WindowsFxVersion *string `json:"windowsFxVersion,omitempty"`
	// RequestTracingEnabled - <code>true</code> if request tracing is enabled; otherwise, <code>false</code>.
	RequestTracingEnabled *bool `json:"requestTracingEnabled,omitempty"`
	// RequestTracingExpirationTime - Request tracing expiration time.
	RequestTracingExpirationTime *date.Time `json:"requestTracingExpirationTime,omitempty"`
	// RemoteDebuggingEnabled - <code>true</code> if remote debugging is enabled; otherwise, <code>false</code>.
	RemoteDebuggingEnabled *bool `json:"remoteDebuggingEnabled,omitempty"`
	// RemoteDebuggingVersion - Remote debugging version.
	RemoteDebuggingVersion *string `json:"remoteDebuggingVersion,omitempty"`
	// HTTPLoggingEnabled - <code>true</code> if HTTP logging is enabled; otherwise, <code>false</code>.
	HTTPLoggingEnabled *bool `json:"httpLoggingEnabled,omitempty"`
	// LogsDirectorySizeLimit - HTTP logs directory size limit.
	LogsDirectorySizeLimit *int32 `json:"logsDirectorySizeLimit,omitempty"`
	// DetailedErrorLoggingEnabled - <code>true</code> if detailed error logging is enabled; otherwise, <code>false</code>.
	DetailedErrorLoggingEnabled *bool `json:"detailedErrorLoggingEnabled,omitempty"`
	// PublishingUsername - Publishing user name.
	PublishingUsername *string `json:"publishingUsername,omitempty"`
	// AppSettings - Application settings.
	AppSettings *[]NameValuePair `json:"appSettings,omitempty"`
	// ConnectionStrings - Connection strings.
	ConnectionStrings *[]ConnStringInfo `json:"connectionStrings,omitempty"`
	// MachineKey - READ-ONLY; Site MachineKey.
	MachineKey *SiteMachineKey `json:"machineKey,omitempty"`
	// HandlerMappings - Handler mappings.
	HandlerMappings *[]HandlerMapping `json:"handlerMappings,omitempty"`
	// DocumentRoot - Document root.
	DocumentRoot *string `json:"documentRoot,omitempty"`
	// ScmType - SCM type. Possible values include: 'ScmTypeNone', 'ScmTypeDropbox', 'ScmTypeTfs', 'ScmTypeLocalGit', 'ScmTypeGitHub', 'ScmTypeCodePlexGit', 'ScmTypeCodePlexHg', 'ScmTypeBitbucketGit', 'ScmTypeBitbucketHg', 'ScmTypeExternalGit', 'ScmTypeExternalHg', 'ScmTypeOneDrive', 'ScmTypeVSO', 'ScmTypeVSTSRM'
	ScmType ScmType `json:"scmType,omitempty"`
	// Use32BitWorkerProcess - <code>true</code> to use 32-bit worker process; otherwise, <code>false</code>.
	Use32BitWorkerProcess *bool `json:"use32BitWorkerProcess,omitempty"`
	// WebSocketsEnabled - <code>true</code> if WebSocket is enabled; otherwise, <code>false</code>.
	WebSocketsEnabled *bool `json:"webSocketsEnabled,omitempty"`
	// AlwaysOn - <code>true</code> if Always On is enabled; otherwise, <code>false</code>.
	AlwaysOn *bool `json:"alwaysOn,omitempty"`
	// JavaVersion - Java version.
	JavaVersion *string `json:"javaVersion,omitempty"`
	// JavaContainer - Java container.
	JavaContainer *string `json:"javaContainer,omitempty"`
	// JavaContainerVersion - Java container version.
	JavaContainerVersion *string `json:"javaContainerVersion,omitempty"`
	// AppCommandLine - App command line to launch.
	AppCommandLine *string `json:"appCommandLine,omitempty"`
	// ManagedPipelineMode - Managed pipeline mode. Possible values include: 'Integrated', 'Classic'
	ManagedPipelineMode ManagedPipelineMode `json:"managedPipelineMode,omitempty"`
	// VirtualApplications - Virtual applications.
	VirtualApplications *[]VirtualApplication `json:"virtualApplications,omitempty"`
	// LoadBalancing - Site load balancing. Possible values include: 'WeightedRoundRobin', 'LeastRequests', 'LeastResponseTime', 'WeightedTotalTraffic', 'RequestHash'
	LoadBalancing SiteLoadBalancing `json:"loadBalancing,omitempty"`
	// Experiments - This is work around for polymorphic types.
	Experiments *Experiments `json:"experiments,omitempty"`
	// Limits - Site limits.
	Limits *SiteLimits `json:"limits,omitempty"`
	// AutoHealEnabled - <code>true</code> if Auto Heal is enabled; otherwise, <code>false</code>.
	AutoHealEnabled *bool `json:"autoHealEnabled,omitempty"`
	// AutoHealRules - Auto Heal rules.
	AutoHealRules *AutoHealRules `json:"autoHealRules,omitempty"`
	// TracingOptions - Tracing options.
	TracingOptions *string `json:"tracingOptions,omitempty"`
	// VnetName - Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
	// VnetRouteAllEnabled - Virtual Network Route All enabled. This causes all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
	VnetRouteAllEnabled *bool `json:"vnetRouteAllEnabled,omitempty"`
	// VnetPrivatePortsCount - The number of private ports assigned to this app. These will be assigned dynamically on runtime.
	VnetPrivatePortsCount *int32 `json:"vnetPrivatePortsCount,omitempty"`
	// Cors - Cross-Origin Resource Sharing (CORS) settings.
	Cors *CorsSettings `json:"cors,omitempty"`
	// Push - Push endpoint settings.
	Push *PushSettings `json:"push,omitempty"`
	// APIDefinition - Information about the formal API definition for the app.
	APIDefinition *APIDefinitionInfo `json:"apiDefinition,omitempty"`
	// APIManagementConfig - Azure API management settings linked to the app.
	APIManagementConfig *APIManagementConfig `json:"apiManagementConfig,omitempty"`
	// AutoSwapSlotName - Auto-swap slot name.
	AutoSwapSlotName *string `json:"autoSwapSlotName,omitempty"`
	// LocalMySQLEnabled - <code>true</code> to enable local MySQL; otherwise, <code>false</code>.
	LocalMySQLEnabled *bool `json:"localMySqlEnabled,omitempty"`
	// ManagedServiceIdentityID - Managed Service Identity Id
	ManagedServiceIdentityID *int32 `json:"managedServiceIdentityId,omitempty"`
	// XManagedServiceIdentityID - Explicit Managed Service Identity Id
	XManagedServiceIdentityID *int32 `json:"xManagedServiceIdentityId,omitempty"`
	// IPSecurityRestrictions - IP security restrictions for main.
	IPSecurityRestrictions *[]IPSecurityRestriction `json:"ipSecurityRestrictions,omitempty"`
	// ScmIPSecurityRestrictions - IP security restrictions for scm.
	ScmIPSecurityRestrictions *[]IPSecurityRestriction `json:"scmIpSecurityRestrictions,omitempty"`
	// ScmIPSecurityRestrictionsUseMain - IP security restrictions for scm to use main.
	ScmIPSecurityRestrictionsUseMain *bool `json:"scmIpSecurityRestrictionsUseMain,omitempty"`
	// HTTP20Enabled - Http20Enabled: configures a web site to allow clients to connect over http2.0
	HTTP20Enabled *bool `json:"http20Enabled,omitempty"`
	// MinTLSVersion - MinTlsVersion: configures the minimum version of TLS required for SSL requests. Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	MinTLSVersion SupportedTLSVersions `json:"minTlsVersion,omitempty"`
	// ScmMinTLSVersion - ScmMinTlsVersion: configures the minimum version of TLS required for SSL requests for SCM site. Possible values include: 'OneFullStopZero', 'OneFullStopOne', 'OneFullStopTwo'
	ScmMinTLSVersion SupportedTLSVersions `json:"scmMinTlsVersion,omitempty"`
	// FtpsState - State of FTP / FTPS service. Possible values include: 'AllAllowed', 'FtpsOnly', 'Disabled'
	FtpsState FtpsState `json:"ftpsState,omitempty"`
	// PreWarmedInstanceCount - Number of preWarmed instances.
	// This setting only applies to the Consumption and Elastic Plans
	PreWarmedInstanceCount *int32 `json:"preWarmedInstanceCount,omitempty"`
	// HealthCheckPath - Health check path
	HealthCheckPath *string `json:"healthCheckPath,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfig.
func (sc SiteConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.NumberOfWorkers != nil {
		objectMap["numberOfWorkers"] = sc.NumberOfWorkers
	}
	if sc.DefaultDocuments != nil {
		objectMap["defaultDocuments"] = sc.DefaultDocuments
	}
	if sc.NetFrameworkVersion != nil {
		objectMap["netFrameworkVersion"] = sc.NetFrameworkVersion
	}
	if sc.PhpVersion != nil {
		objectMap["phpVersion"] = sc.PhpVersion
	}
	if sc.PythonVersion != nil {
		objectMap["pythonVersion"] = sc.PythonVersion
	}
	if sc.NodeVersion != nil {
		objectMap["nodeVersion"] = sc.NodeVersion
	}
	if sc.PowerShellVersion != nil {
		objectMap["powerShellVersion"] = sc.PowerShellVersion
	}
	if sc.LinuxFxVersion != nil {
		objectMap["linuxFxVersion"] = sc.LinuxFxVersion
	}
	if sc.WindowsFxVersion != nil {
		objectMap["windowsFxVersion"] = sc.WindowsFxVersion
	}
	if sc.RequestTracingEnabled != nil {
		objectMap["requestTracingEnabled"] = sc.RequestTracingEnabled
	}
	if sc.RequestTracingExpirationTime != nil {
		objectMap["requestTracingExpirationTime"] = sc.RequestTracingExpirationTime
	}
	if sc.RemoteDebuggingEnabled != nil {
		objectMap["remoteDebuggingEnabled"] = sc.RemoteDebuggingEnabled
	}
	if sc.RemoteDebuggingVersion != nil {
		objectMap["remoteDebuggingVersion"] = sc.RemoteDebuggingVersion
	}
	if sc.HTTPLoggingEnabled != nil {
		objectMap["httpLoggingEnabled"] = sc.HTTPLoggingEnabled
	}
	if sc.LogsDirectorySizeLimit != nil {
		objectMap["logsDirectorySizeLimit"] = sc.LogsDirectorySizeLimit
	}
	if sc.DetailedErrorLoggingEnabled != nil {
		objectMap["detailedErrorLoggingEnabled"] = sc.DetailedErrorLoggingEnabled
	}
	if sc.PublishingUsername != nil {
		objectMap["publishingUsername"] = sc.PublishingUsername
	}
	if sc.AppSettings != nil {
		objectMap["appSettings"] = sc.AppSettings
	}
	if sc.ConnectionStrings != nil {
		objectMap["connectionStrings"] = sc.ConnectionStrings
	}
	if sc.HandlerMappings != nil {
		objectMap["handlerMappings"] = sc.HandlerMappings
	}
	if sc.DocumentRoot != nil {
		objectMap["documentRoot"] = sc.DocumentRoot
	}
	if sc.ScmType != "" {
		objectMap["scmType"] = sc.ScmType
	}
	if sc.Use32BitWorkerProcess != nil {
		objectMap["use32BitWorkerProcess"] = sc.Use32BitWorkerProcess
	}
	if sc.WebSocketsEnabled != nil {
		objectMap["webSocketsEnabled"] = sc.WebSocketsEnabled
	}
	if sc.AlwaysOn != nil {
		objectMap["alwaysOn"] = sc.AlwaysOn
	}
	if sc.JavaVersion != nil {
		objectMap["javaVersion"] = sc.JavaVersion
	}
	if sc.JavaContainer != nil {
		objectMap["javaContainer"] = sc.JavaContainer
	}
	if sc.JavaContainerVersion != nil {
		objectMap["javaContainerVersion"] = sc.JavaContainerVersion
	}
	if sc.AppCommandLine != nil {
		objectMap["appCommandLine"] = sc.AppCommandLine
	}
	if sc.ManagedPipelineMode != "" {
		objectMap["managedPipelineMode"] = sc.ManagedPipelineMode
	}
	if sc.VirtualApplications != nil {
		objectMap["virtualApplications"] = sc.VirtualApplications
	}
	if sc.LoadBalancing != "" {
		objectMap["loadBalancing"] = sc.LoadBalancing
	}
	if sc.Experiments != nil {
		objectMap["experiments"] = sc.Experiments
	}
	if sc.Limits != nil {
		objectMap["limits"] = sc.Limits
	}
	if sc.AutoHealEnabled != nil {
		objectMap["autoHealEnabled"] = sc.AutoHealEnabled
	}
	if sc.AutoHealRules != nil {
		objectMap["autoHealRules"] = sc.AutoHealRules
	}
	if sc.TracingOptions != nil {
		objectMap["tracingOptions"] = sc.TracingOptions
	}
	if sc.VnetName != nil {
		objectMap["vnetName"] = sc.VnetName
	}
	if sc.VnetRouteAllEnabled != nil {
		objectMap["vnetRouteAllEnabled"] = sc.VnetRouteAllEnabled
	}
	if sc.VnetPrivatePortsCount != nil {
		objectMap["vnetPrivatePortsCount"] = sc.VnetPrivatePortsCount
	}
	if sc.Cors != nil {
		objectMap["cors"] = sc.Cors
	}
	if sc.Push != nil {
		objectMap["push"] = sc.Push
	}
	if sc.APIDefinition != nil {
		objectMap["apiDefinition"] = sc.APIDefinition
	}
	if sc.APIManagementConfig != nil {
		objectMap["apiManagementConfig"] = sc.APIManagementConfig
	}
	if sc.AutoSwapSlotName != nil {
		objectMap["autoSwapSlotName"] = sc.AutoSwapSlotName
	}
	if sc.LocalMySQLEnabled != nil {
		objectMap["localMySqlEnabled"] = sc.LocalMySQLEnabled
	}
	if sc.ManagedServiceIdentityID != nil {
		objectMap["managedServiceIdentityId"] = sc.ManagedServiceIdentityID
	}
	if sc.XManagedServiceIdentityID != nil {
		objectMap["xManagedServiceIdentityId"] = sc.XManagedServiceIdentityID
	}
	if sc.IPSecurityRestrictions != nil {
		objectMap["ipSecurityRestrictions"] = sc.IPSecurityRestrictions
	}
	if sc.ScmIPSecurityRestrictions != nil {
		objectMap["scmIpSecurityRestrictions"] = sc.ScmIPSecurityRestrictions
	}
	if sc.ScmIPSecurityRestrictionsUseMain != nil {
		objectMap["scmIpSecurityRestrictionsUseMain"] = sc.ScmIPSecurityRestrictionsUseMain
	}
	if sc.HTTP20Enabled != nil {
		objectMap["http20Enabled"] = sc.HTTP20Enabled
	}
	if sc.MinTLSVersion != "" {
		objectMap["minTlsVersion"] = sc.MinTLSVersion
	}
	if sc.ScmMinTLSVersion != "" {
		objectMap["scmMinTlsVersion"] = sc.ScmMinTLSVersion
	}
	if sc.FtpsState != "" {
		objectMap["ftpsState"] = sc.FtpsState
	}
	if sc.PreWarmedInstanceCount != nil {
		objectMap["preWarmedInstanceCount"] = sc.PreWarmedInstanceCount
	}
	if sc.HealthCheckPath != nil {
		objectMap["healthCheckPath"] = sc.HealthCheckPath
	}
	return json.Marshal(objectMap)
}

// SiteConfigResource web app configuration ARM resource.
type SiteConfigResource struct {
	autorest.Response `json:"-"`
	// SiteConfig - Core resource properties
	*SiteConfig `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigResource.
func (scr SiteConfigResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scr.SiteConfig != nil {
		objectMap["properties"] = scr.SiteConfig
	}
	if scr.Kind != nil {
		objectMap["kind"] = scr.Kind
	}
	if scr.SystemData != nil {
		objectMap["systemData"] = scr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteConfigResource struct.
func (scr *SiteConfigResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteConfig SiteConfig
				err = json.Unmarshal(*v, &siteConfig)
				if err != nil {
					return err
				}
				scr.SiteConfig = &siteConfig
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scr.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteConfigResourceCollection collection of site configurations.
type SiteConfigResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteConfigResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigResourceCollection.
func (scrc SiteConfigResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scrc.Value != nil {
		objectMap["value"] = scrc.Value
	}
	return json.Marshal(objectMap)
}

// SiteConfigResourceCollectionIterator provides access to a complete listing of SiteConfigResource values.
type SiteConfigResourceCollectionIterator struct {
	i    int
	page SiteConfigResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteConfigResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteConfigResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteConfigResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteConfigResourceCollectionIterator) Response() SiteConfigResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteConfigResourceCollectionIterator) Value() SiteConfigResource {
	if !iter.page.NotDone() {
		return SiteConfigResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteConfigResourceCollectionIterator type.
func NewSiteConfigResourceCollectionIterator(page SiteConfigResourceCollectionPage) SiteConfigResourceCollectionIterator {
	return SiteConfigResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scrc SiteConfigResourceCollection) IsEmpty() bool {
	return scrc.Value == nil || len(*scrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scrc SiteConfigResourceCollection) hasNextLink() bool {
	return scrc.NextLink != nil && len(*scrc.NextLink) != 0
}

// siteConfigResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scrc SiteConfigResourceCollection) siteConfigResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scrc.NextLink)))
}

// SiteConfigResourceCollectionPage contains a page of SiteConfigResource values.
type SiteConfigResourceCollectionPage struct {
	fn   func(context.Context, SiteConfigResourceCollection) (SiteConfigResourceCollection, error)
	scrc SiteConfigResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteConfigResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scrc)
		if err != nil {
			return err
		}
		page.scrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteConfigResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteConfigResourceCollectionPage) NotDone() bool {
	return !page.scrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteConfigResourceCollectionPage) Response() SiteConfigResourceCollection {
	return page.scrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteConfigResourceCollectionPage) Values() []SiteConfigResource {
	if page.scrc.IsEmpty() {
		return nil
	}
	return *page.scrc.Value
}

// Creates a new instance of the SiteConfigResourceCollectionPage type.
func NewSiteConfigResourceCollectionPage(cur SiteConfigResourceCollection, getNextPage func(context.Context, SiteConfigResourceCollection) (SiteConfigResourceCollection, error)) SiteConfigResourceCollectionPage {
	return SiteConfigResourceCollectionPage{
		fn:   getNextPage,
		scrc: cur,
	}
}

// SiteConfigurationSnapshotInfo a snapshot of a web app configuration.
type SiteConfigurationSnapshotInfo struct {
	// SiteConfigurationSnapshotInfoProperties - SiteConfigurationSnapshotInfo resource specific properties
	*SiteConfigurationSnapshotInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigurationSnapshotInfo.
func (scsi SiteConfigurationSnapshotInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsi.SiteConfigurationSnapshotInfoProperties != nil {
		objectMap["properties"] = scsi.SiteConfigurationSnapshotInfoProperties
	}
	if scsi.Kind != nil {
		objectMap["kind"] = scsi.Kind
	}
	if scsi.SystemData != nil {
		objectMap["systemData"] = scsi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteConfigurationSnapshotInfo struct.
func (scsi *SiteConfigurationSnapshotInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteConfigurationSnapshotInfoProperties SiteConfigurationSnapshotInfoProperties
				err = json.Unmarshal(*v, &siteConfigurationSnapshotInfoProperties)
				if err != nil {
					return err
				}
				scsi.SiteConfigurationSnapshotInfoProperties = &siteConfigurationSnapshotInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scsi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scsi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scsi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scsi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scsi.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteConfigurationSnapshotInfoCollection collection of metadata for the app configuration snapshots that
// can be restored.
type SiteConfigurationSnapshotInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteConfigurationSnapshotInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteConfigurationSnapshotInfoCollection.
func (scsic SiteConfigurationSnapshotInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scsic.Value != nil {
		objectMap["value"] = scsic.Value
	}
	return json.Marshal(objectMap)
}

// SiteConfigurationSnapshotInfoCollectionIterator provides access to a complete listing of
// SiteConfigurationSnapshotInfo values.
type SiteConfigurationSnapshotInfoCollectionIterator struct {
	i    int
	page SiteConfigurationSnapshotInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteConfigurationSnapshotInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigurationSnapshotInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteConfigurationSnapshotInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) Response() SiteConfigurationSnapshotInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteConfigurationSnapshotInfoCollectionIterator) Value() SiteConfigurationSnapshotInfo {
	if !iter.page.NotDone() {
		return SiteConfigurationSnapshotInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteConfigurationSnapshotInfoCollectionIterator type.
func NewSiteConfigurationSnapshotInfoCollectionIterator(page SiteConfigurationSnapshotInfoCollectionPage) SiteConfigurationSnapshotInfoCollectionIterator {
	return SiteConfigurationSnapshotInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scsic SiteConfigurationSnapshotInfoCollection) IsEmpty() bool {
	return scsic.Value == nil || len(*scsic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scsic SiteConfigurationSnapshotInfoCollection) hasNextLink() bool {
	return scsic.NextLink != nil && len(*scsic.NextLink) != 0
}

// siteConfigurationSnapshotInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scsic SiteConfigurationSnapshotInfoCollection) siteConfigurationSnapshotInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scsic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scsic.NextLink)))
}

// SiteConfigurationSnapshotInfoCollectionPage contains a page of SiteConfigurationSnapshotInfo values.
type SiteConfigurationSnapshotInfoCollectionPage struct {
	fn    func(context.Context, SiteConfigurationSnapshotInfoCollection) (SiteConfigurationSnapshotInfoCollection, error)
	scsic SiteConfigurationSnapshotInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteConfigurationSnapshotInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteConfigurationSnapshotInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scsic)
		if err != nil {
			return err
		}
		page.scsic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteConfigurationSnapshotInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteConfigurationSnapshotInfoCollectionPage) NotDone() bool {
	return !page.scsic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteConfigurationSnapshotInfoCollectionPage) Response() SiteConfigurationSnapshotInfoCollection {
	return page.scsic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteConfigurationSnapshotInfoCollectionPage) Values() []SiteConfigurationSnapshotInfo {
	if page.scsic.IsEmpty() {
		return nil
	}
	return *page.scsic.Value
}

// Creates a new instance of the SiteConfigurationSnapshotInfoCollectionPage type.
func NewSiteConfigurationSnapshotInfoCollectionPage(cur SiteConfigurationSnapshotInfoCollection, getNextPage func(context.Context, SiteConfigurationSnapshotInfoCollection) (SiteConfigurationSnapshotInfoCollection, error)) SiteConfigurationSnapshotInfoCollectionPage {
	return SiteConfigurationSnapshotInfoCollectionPage{
		fn:    getNextPage,
		scsic: cur,
	}
}

// SiteConfigurationSnapshotInfoProperties siteConfigurationSnapshotInfo resource specific properties
type SiteConfigurationSnapshotInfoProperties struct {
	// Time - READ-ONLY; The time the snapshot was taken.
	Time *date.Time `json:"time,omitempty"`
	// SnapshotID - READ-ONLY; The id of the snapshot
	SnapshotID *int32 `json:"snapshotId,omitempty"`
}

// SiteExtensionInfo site Extension Information.
type SiteExtensionInfo struct {
	autorest.Response `json:"-"`
	// SiteExtensionInfoProperties - SiteExtensionInfo resource specific properties
	*SiteExtensionInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteExtensionInfo.
func (sei SiteExtensionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sei.SiteExtensionInfoProperties != nil {
		objectMap["properties"] = sei.SiteExtensionInfoProperties
	}
	if sei.Kind != nil {
		objectMap["kind"] = sei.Kind
	}
	if sei.SystemData != nil {
		objectMap["systemData"] = sei.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteExtensionInfo struct.
func (sei *SiteExtensionInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteExtensionInfoProperties SiteExtensionInfoProperties
				err = json.Unmarshal(*v, &siteExtensionInfoProperties)
				if err != nil {
					return err
				}
				sei.SiteExtensionInfoProperties = &siteExtensionInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sei.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sei.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sei.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sei.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sei.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteExtensionInfoCollection collection of Kudu site extension information elements.
type SiteExtensionInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SiteExtensionInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteExtensionInfoCollection.
func (seic SiteExtensionInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if seic.Value != nil {
		objectMap["value"] = seic.Value
	}
	return json.Marshal(objectMap)
}

// SiteExtensionInfoCollectionIterator provides access to a complete listing of SiteExtensionInfo values.
type SiteExtensionInfoCollectionIterator struct {
	i    int
	page SiteExtensionInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SiteExtensionInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteExtensionInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SiteExtensionInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SiteExtensionInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SiteExtensionInfoCollectionIterator) Response() SiteExtensionInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SiteExtensionInfoCollectionIterator) Value() SiteExtensionInfo {
	if !iter.page.NotDone() {
		return SiteExtensionInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SiteExtensionInfoCollectionIterator type.
func NewSiteExtensionInfoCollectionIterator(page SiteExtensionInfoCollectionPage) SiteExtensionInfoCollectionIterator {
	return SiteExtensionInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (seic SiteExtensionInfoCollection) IsEmpty() bool {
	return seic.Value == nil || len(*seic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (seic SiteExtensionInfoCollection) hasNextLink() bool {
	return seic.NextLink != nil && len(*seic.NextLink) != 0
}

// siteExtensionInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (seic SiteExtensionInfoCollection) siteExtensionInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !seic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(seic.NextLink)))
}

// SiteExtensionInfoCollectionPage contains a page of SiteExtensionInfo values.
type SiteExtensionInfoCollectionPage struct {
	fn   func(context.Context, SiteExtensionInfoCollection) (SiteExtensionInfoCollection, error)
	seic SiteExtensionInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SiteExtensionInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SiteExtensionInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.seic)
		if err != nil {
			return err
		}
		page.seic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SiteExtensionInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SiteExtensionInfoCollectionPage) NotDone() bool {
	return !page.seic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SiteExtensionInfoCollectionPage) Response() SiteExtensionInfoCollection {
	return page.seic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SiteExtensionInfoCollectionPage) Values() []SiteExtensionInfo {
	if page.seic.IsEmpty() {
		return nil
	}
	return *page.seic.Value
}

// Creates a new instance of the SiteExtensionInfoCollectionPage type.
func NewSiteExtensionInfoCollectionPage(cur SiteExtensionInfoCollection, getNextPage func(context.Context, SiteExtensionInfoCollection) (SiteExtensionInfoCollection, error)) SiteExtensionInfoCollectionPage {
	return SiteExtensionInfoCollectionPage{
		fn:   getNextPage,
		seic: cur,
	}
}

// SiteExtensionInfoProperties siteExtensionInfo resource specific properties
type SiteExtensionInfoProperties struct {
	// ExtensionID - Site extension ID.
	ExtensionID *string `json:"extension_id,omitempty"`
	Title       *string `json:"title,omitempty"`
	// ExtensionType - Site extension type. Possible values include: 'Gallery', 'WebRoot'
	ExtensionType SiteExtensionType `json:"extension_type,omitempty"`
	// Summary - Summary description.
	Summary *string `json:"summary,omitempty"`
	// Description - Detailed description.
	Description *string `json:"description,omitempty"`
	// Version - Version information.
	Version *string `json:"version,omitempty"`
	// ExtensionURL - Extension URL.
	ExtensionURL *string `json:"extension_url,omitempty"`
	// ProjectURL - Project URL.
	ProjectURL *string `json:"project_url,omitempty"`
	// IconURL - Icon URL.
	IconURL *string `json:"icon_url,omitempty"`
	// LicenseURL - License URL.
	LicenseURL *string `json:"license_url,omitempty"`
	// FeedURL - Feed URL.
	FeedURL *string `json:"feed_url,omitempty"`
	// Authors - List of authors.
	Authors *[]string `json:"authors,omitempty"`
	// InstallerCommandLineParams - Installer command line parameters.
	InstallerCommandLineParams *string `json:"installer_command_line_params,omitempty"`
	// PublishedDateTime - Published timestamp.
	PublishedDateTime *date.Time `json:"published_date_time,omitempty"`
	// DownloadCount - Count of downloads.
	DownloadCount *int32 `json:"download_count,omitempty"`
	// LocalIsLatestVersion - <code>true</code> if the local version is the latest version; <code>false</code> otherwise.
	LocalIsLatestVersion *bool `json:"local_is_latest_version,omitempty"`
	// LocalPath - Local path.
	LocalPath *string `json:"local_path,omitempty"`
	// InstalledDateTime - Installed timestamp.
	InstalledDateTime *date.Time `json:"installed_date_time,omitempty"`
	// ProvisioningState - Provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Comment - Site Extension comment.
	Comment *string `json:"comment,omitempty"`
}

// SiteInstanceStatus ...
type SiteInstanceStatus struct {
	autorest.Response `json:"-"`
	// SiteInstanceStatusProperties - WebSiteInstanceStatus resource specific properties
	*SiteInstanceStatusProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteInstanceStatus.
func (sis SiteInstanceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sis.SiteInstanceStatusProperties != nil {
		objectMap["properties"] = sis.SiteInstanceStatusProperties
	}
	if sis.Kind != nil {
		objectMap["kind"] = sis.Kind
	}
	if sis.SystemData != nil {
		objectMap["systemData"] = sis.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteInstanceStatus struct.
func (sis *SiteInstanceStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteInstanceStatusProperties SiteInstanceStatusProperties
				err = json.Unmarshal(*v, &siteInstanceStatusProperties)
				if err != nil {
					return err
				}
				sis.SiteInstanceStatusProperties = &siteInstanceStatusProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sis.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sis.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sis.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sis.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sis.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteInstanceStatusProperties webSiteInstanceStatus resource specific properties
type SiteInstanceStatusProperties struct {
	// State - Possible values include: 'READY', 'STOPPED', 'UNKNOWN'
	State SiteRuntimeState `json:"state,omitempty"`
	// StatusURL - Link to the GetStatusApi in Kudu
	StatusURL *string `json:"statusUrl,omitempty"`
	// DetectorURL - Link to the Diagnose and Solve Portal
	DetectorURL *string `json:"detectorUrl,omitempty"`
	// ConsoleURL - Link to the console to web app instance
	ConsoleURL *string `json:"consoleUrl,omitempty"`
	// HealthCheckURL - Link to the console to web app instance
	HealthCheckURL *string                   `json:"healthCheckUrl,omitempty"`
	Containers     map[string]*ContainerInfo `json:"containers"`
}

// MarshalJSON is the custom marshaler for SiteInstanceStatusProperties.
func (sis SiteInstanceStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sis.State != "" {
		objectMap["state"] = sis.State
	}
	if sis.StatusURL != nil {
		objectMap["statusUrl"] = sis.StatusURL
	}
	if sis.DetectorURL != nil {
		objectMap["detectorUrl"] = sis.DetectorURL
	}
	if sis.ConsoleURL != nil {
		objectMap["consoleUrl"] = sis.ConsoleURL
	}
	if sis.HealthCheckURL != nil {
		objectMap["healthCheckUrl"] = sis.HealthCheckURL
	}
	if sis.Containers != nil {
		objectMap["containers"] = sis.Containers
	}
	return json.Marshal(objectMap)
}

// SiteLimits metric limits set on an app.
type SiteLimits struct {
	// MaxPercentageCPU - Maximum allowed CPU usage percentage.
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
	// MaxMemoryInMb - Maximum allowed memory usage in MB.
	MaxMemoryInMb *int64 `json:"maxMemoryInMb,omitempty"`
	// MaxDiskSizeInMb - Maximum allowed disk size usage in MB.
	MaxDiskSizeInMb *int64 `json:"maxDiskSizeInMb,omitempty"`
}

// SiteLogsConfig configuration of App Service site logs.
type SiteLogsConfig struct {
	autorest.Response `json:"-"`
	// SiteLogsConfigProperties - SiteLogsConfig resource specific properties
	*SiteLogsConfigProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteLogsConfig.
func (slc SiteLogsConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slc.SiteLogsConfigProperties != nil {
		objectMap["properties"] = slc.SiteLogsConfigProperties
	}
	if slc.Kind != nil {
		objectMap["kind"] = slc.Kind
	}
	if slc.SystemData != nil {
		objectMap["systemData"] = slc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteLogsConfig struct.
func (slc *SiteLogsConfig) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteLogsConfigProperties SiteLogsConfigProperties
				err = json.Unmarshal(*v, &siteLogsConfigProperties)
				if err != nil {
					return err
				}
				slc.SiteLogsConfigProperties = &siteLogsConfigProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				slc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				slc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				slc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				slc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				slc.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteLogsConfigProperties siteLogsConfig resource specific properties
type SiteLogsConfigProperties struct {
	// ApplicationLogs - Application logs configuration.
	ApplicationLogs *ApplicationLogsConfig `json:"applicationLogs,omitempty"`
	// HTTPLogs - HTTP logs configuration.
	HTTPLogs *HTTPLogsConfig `json:"httpLogs,omitempty"`
	// FailedRequestsTracing - Failed requests tracing configuration.
	FailedRequestsTracing *EnabledConfig `json:"failedRequestsTracing,omitempty"`
	// DetailedErrorMessages - Detailed error messages configuration.
	DetailedErrorMessages *EnabledConfig `json:"detailedErrorMessages,omitempty"`
}

// SiteMachineKey machineKey of an app.
type SiteMachineKey struct {
	// Validation - MachineKey validation.
	Validation *string `json:"validation,omitempty"`
	// ValidationKey - Validation key.
	ValidationKey *string `json:"validationKey,omitempty"`
	// Decryption - Algorithm used for decryption.
	Decryption *string `json:"decryption,omitempty"`
	// DecryptionKey - Decryption key.
	DecryptionKey *string `json:"decryptionKey,omitempty"`
}

// SitePatchResource ARM resource for a site.
type SitePatchResource struct {
	// SitePatchResourceProperties - SitePatchResource resource specific properties
	*SitePatchResourceProperties `json:"properties,omitempty"`
	Identity                     *ManagedServiceIdentity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SitePatchResource.
func (spr SitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spr.SitePatchResourceProperties != nil {
		objectMap["properties"] = spr.SitePatchResourceProperties
	}
	if spr.Identity != nil {
		objectMap["identity"] = spr.Identity
	}
	if spr.Kind != nil {
		objectMap["kind"] = spr.Kind
	}
	if spr.SystemData != nil {
		objectMap["systemData"] = spr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SitePatchResource struct.
func (spr *SitePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sitePatchResourceProperties SitePatchResourceProperties
				err = json.Unmarshal(*v, &sitePatchResourceProperties)
				if err != nil {
					return err
				}
				spr.SitePatchResourceProperties = &sitePatchResourceProperties
			}
		case "identity":
			if v != nil {
				var identity ManagedServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				spr.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				spr.SystemData = &systemData
			}
		}
	}

	return nil
}

// SitePatchResourceProperties sitePatchResource resource specific properties
type SitePatchResourceProperties struct {
	// State - READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty"`
	// HostNames - READ-ONLY; Hostnames associated with the app.
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,
	// the app is not served on those hostnames.
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - READ-ONLY; Management information availability state for the app. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// Reserved - <code>true</code> if reserved; otherwise, <code>false</code>.
	Reserved *bool `json:"reserved,omitempty"`
	// IsXenon - Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`
	// HyperV - Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// ScmSiteAlsoStopped - <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// ClientAffinityEnabled - <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// ClientCertMode - This composes with ClientCertEnabled setting.
	// - ClientCertEnabled: false means ClientCert is ignored.
	// - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted. Possible values include: 'Required', 'Optional'
	ClientCertMode ClientCertMode `json:"clientCertMode,omitempty"`
	// ClientCertExclusionPaths - client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`
	// HostNamesDisabled - <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
	//  If <code>true</code>, the app is only accessible via API management process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// CustomDomainVerificationID - Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty"`
	// OutboundIPAddresses - READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// PossibleOutboundIPAddresses - READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty"`
	// ContainerSize - Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// DailyMemoryTimeQuota - Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`
	// SuspendedTill - READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *date.Time `json:"suspendedTill,omitempty"`
	// MaxNumberOfWorkers - READ-ONLY; Maximum number of workers.
	// This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// ResourceGroup - READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - READ-ONLY; <code>true</code> if the app is a default container; otherwise, <code>false</code>.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty"`
	// SlotSwapStatus - READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty"`
	// HTTPSOnly - HttpsOnly: configures a web site to accept only https requests. Issues redirect for
	// http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
	// RedundancyMode - Site redundancy mode. Possible values include: 'RedundancyModeNone', 'RedundancyModeManual', 'RedundancyModeFailover', 'RedundancyModeActiveActive', 'RedundancyModeGeoRedundant'
	RedundancyMode RedundancyMode `json:"redundancyMode,omitempty"`
	// InProgressOperationID - READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *uuid.UUID `json:"inProgressOperationId,omitempty"`
}

// MarshalJSON is the custom marshaler for SitePatchResourceProperties.
func (spr SitePatchResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spr.Enabled != nil {
		objectMap["enabled"] = spr.Enabled
	}
	if spr.HostNameSslStates != nil {
		objectMap["hostNameSslStates"] = spr.HostNameSslStates
	}
	if spr.ServerFarmID != nil {
		objectMap["serverFarmId"] = spr.ServerFarmID
	}
	if spr.Reserved != nil {
		objectMap["reserved"] = spr.Reserved
	}
	if spr.IsXenon != nil {
		objectMap["isXenon"] = spr.IsXenon
	}
	if spr.HyperV != nil {
		objectMap["hyperV"] = spr.HyperV
	}
	if spr.SiteConfig != nil {
		objectMap["siteConfig"] = spr.SiteConfig
	}
	if spr.ScmSiteAlsoStopped != nil {
		objectMap["scmSiteAlsoStopped"] = spr.ScmSiteAlsoStopped
	}
	if spr.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = spr.HostingEnvironmentProfile
	}
	if spr.ClientAffinityEnabled != nil {
		objectMap["clientAffinityEnabled"] = spr.ClientAffinityEnabled
	}
	if spr.ClientCertEnabled != nil {
		objectMap["clientCertEnabled"] = spr.ClientCertEnabled
	}
	if spr.ClientCertMode != "" {
		objectMap["clientCertMode"] = spr.ClientCertMode
	}
	if spr.ClientCertExclusionPaths != nil {
		objectMap["clientCertExclusionPaths"] = spr.ClientCertExclusionPaths
	}
	if spr.HostNamesDisabled != nil {
		objectMap["hostNamesDisabled"] = spr.HostNamesDisabled
	}
	if spr.CustomDomainVerificationID != nil {
		objectMap["customDomainVerificationId"] = spr.CustomDomainVerificationID
	}
	if spr.ContainerSize != nil {
		objectMap["containerSize"] = spr.ContainerSize
	}
	if spr.DailyMemoryTimeQuota != nil {
		objectMap["dailyMemoryTimeQuota"] = spr.DailyMemoryTimeQuota
	}
	if spr.CloningInfo != nil {
		objectMap["cloningInfo"] = spr.CloningInfo
	}
	if spr.HTTPSOnly != nil {
		objectMap["httpsOnly"] = spr.HTTPSOnly
	}
	if spr.RedundancyMode != "" {
		objectMap["redundancyMode"] = spr.RedundancyMode
	}
	return json.Marshal(objectMap)
}

// SitePhpErrorLogFlag used for getting PHP error logging flag.
type SitePhpErrorLogFlag struct {
	autorest.Response `json:"-"`
	// SitePhpErrorLogFlagProperties - SitePhpErrorLogFlag resource specific properties
	*SitePhpErrorLogFlagProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SitePhpErrorLogFlag.
func (spelf SitePhpErrorLogFlag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spelf.SitePhpErrorLogFlagProperties != nil {
		objectMap["properties"] = spelf.SitePhpErrorLogFlagProperties
	}
	if spelf.Kind != nil {
		objectMap["kind"] = spelf.Kind
	}
	if spelf.SystemData != nil {
		objectMap["systemData"] = spelf.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SitePhpErrorLogFlag struct.
func (spelf *SitePhpErrorLogFlag) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sitePhpErrorLogFlagProperties SitePhpErrorLogFlagProperties
				err = json.Unmarshal(*v, &sitePhpErrorLogFlagProperties)
				if err != nil {
					return err
				}
				spelf.SitePhpErrorLogFlagProperties = &sitePhpErrorLogFlagProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				spelf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				spelf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				spelf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				spelf.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				spelf.SystemData = &systemData
			}
		}
	}

	return nil
}

// SitePhpErrorLogFlagProperties sitePhpErrorLogFlag resource specific properties
type SitePhpErrorLogFlagProperties struct {
	// LocalLogErrors - Local log_errors setting.
	LocalLogErrors *string `json:"localLogErrors,omitempty"`
	// MasterLogErrors - Master log_errors setting.
	MasterLogErrors *string `json:"masterLogErrors,omitempty"`
	// LocalLogErrorsMaxLength - Local log_errors_max_len setting.
	LocalLogErrorsMaxLength *string `json:"localLogErrorsMaxLength,omitempty"`
	// MasterLogErrorsMaxLength - Master log_errors_max_len setting.
	MasterLogErrorsMaxLength *string `json:"masterLogErrorsMaxLength,omitempty"`
}

// SiteProperties site resource specific properties
type SiteProperties struct {
	// State - READ-ONLY; Current state of the app.
	State *string `json:"state,omitempty"`
	// HostNames - READ-ONLY; Hostnames associated with the app.
	HostNames *[]string `json:"hostNames,omitempty"`
	// RepositorySiteName - READ-ONLY; Name of the repository site.
	RepositorySiteName *string `json:"repositorySiteName,omitempty"`
	// UsageState - READ-ONLY; State indicating whether the app has exceeded its quota usage. Read-only. Possible values include: 'UsageStateNormal', 'UsageStateExceeded'
	UsageState UsageState `json:"usageState,omitempty"`
	// Enabled - <code>true</code> if the app is enabled; otherwise, <code>false</code>. Setting this value to false disables the app (takes the app offline).
	Enabled *bool `json:"enabled,omitempty"`
	// EnabledHostNames - READ-ONLY; Enabled hostnames for the app.Hostnames need to be assigned (see HostNames) AND enabled. Otherwise,
	// the app is not served on those hostnames.
	EnabledHostNames *[]string `json:"enabledHostNames,omitempty"`
	// AvailabilityState - READ-ONLY; Management information availability state for the app. Possible values include: 'Normal', 'Limited', 'DisasterRecoveryMode'
	AvailabilityState SiteAvailabilityState `json:"availabilityState,omitempty"`
	// HostNameSslStates - Hostname SSL states are used to manage the SSL bindings for app's hostnames.
	HostNameSslStates *[]HostNameSslState `json:"hostNameSslStates,omitempty"`
	// ServerFarmID - Resource ID of the associated App Service plan, formatted as: "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// Reserved - <code>true</code> if reserved; otherwise, <code>false</code>.
	Reserved *bool `json:"reserved,omitempty"`
	// IsXenon - Obsolete: Hyper-V sandbox.
	IsXenon *bool `json:"isXenon,omitempty"`
	// HyperV - Hyper-V sandbox.
	HyperV *bool `json:"hyperV,omitempty"`
	// LastModifiedTimeUtc - READ-ONLY; Last time the app was modified, in UTC. Read-only.
	LastModifiedTimeUtc *date.Time `json:"lastModifiedTimeUtc,omitempty"`
	// SiteConfig - Configuration of the app.
	SiteConfig *SiteConfig `json:"siteConfig,omitempty"`
	// TrafficManagerHostNames - READ-ONLY; Azure Traffic Manager hostnames associated with the app. Read-only.
	TrafficManagerHostNames *[]string `json:"trafficManagerHostNames,omitempty"`
	// ScmSiteAlsoStopped - <code>true</code> to stop SCM (KUDU) site when the app is stopped; otherwise, <code>false</code>. The default is <code>false</code>.
	ScmSiteAlsoStopped *bool `json:"scmSiteAlsoStopped,omitempty"`
	// TargetSwapSlot - READ-ONLY; Specifies which deployment slot this app will swap into. Read-only.
	TargetSwapSlot *string `json:"targetSwapSlot,omitempty"`
	// HostingEnvironmentProfile - App Service Environment to use for the app.
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	// ClientAffinityEnabled - <code>true</code> to enable client affinity; <code>false</code> to stop sending session affinity cookies, which route client requests in the same session to the same instance. Default is <code>true</code>.
	ClientAffinityEnabled *bool `json:"clientAffinityEnabled,omitempty"`
	// ClientCertEnabled - <code>true</code> to enable client certificate authentication (TLS mutual authentication); otherwise, <code>false</code>. Default is <code>false</code>.
	ClientCertEnabled *bool `json:"clientCertEnabled,omitempty"`
	// ClientCertMode - This composes with ClientCertEnabled setting.
	// - ClientCertEnabled: false means ClientCert is ignored.
	// - ClientCertEnabled: true and ClientCertMode: Required means ClientCert is required.
	// - ClientCertEnabled: true and ClientCertMode: Optional means ClientCert is optional or accepted. Possible values include: 'Required', 'Optional'
	ClientCertMode ClientCertMode `json:"clientCertMode,omitempty"`
	// ClientCertExclusionPaths - client certificate authentication comma-separated exclusion paths
	ClientCertExclusionPaths *string `json:"clientCertExclusionPaths,omitempty"`
	// HostNamesDisabled - <code>true</code> to disable the public hostnames of the app; otherwise, <code>false</code>.
	//  If <code>true</code>, the app is only accessible via API management process.
	HostNamesDisabled *bool `json:"hostNamesDisabled,omitempty"`
	// CustomDomainVerificationID - Unique identifier that verifies the custom domains assigned to the app. Customer will add this id to a txt record for verification.
	CustomDomainVerificationID *string `json:"customDomainVerificationId,omitempty"`
	// OutboundIPAddresses - READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from tenants that site can be hosted with current settings. Read-only.
	OutboundIPAddresses *string `json:"outboundIpAddresses,omitempty"`
	// PossibleOutboundIPAddresses - READ-ONLY; List of IP addresses that the app uses for outbound connections (e.g. database access). Includes VIPs from all tenants except dataComponent. Read-only.
	PossibleOutboundIPAddresses *string `json:"possibleOutboundIpAddresses,omitempty"`
	// ContainerSize - Size of the function container.
	ContainerSize *int32 `json:"containerSize,omitempty"`
	// DailyMemoryTimeQuota - Maximum allowed daily memory-time quota (applicable on dynamic apps only).
	DailyMemoryTimeQuota *int32 `json:"dailyMemoryTimeQuota,omitempty"`
	// SuspendedTill - READ-ONLY; App suspended till in case memory-time quota is exceeded.
	SuspendedTill *date.Time `json:"suspendedTill,omitempty"`
	// MaxNumberOfWorkers - READ-ONLY; Maximum number of workers.
	// This only applies to Functions container.
	MaxNumberOfWorkers *int32 `json:"maxNumberOfWorkers,omitempty"`
	// CloningInfo - If specified during app creation, the app is cloned from a source app.
	CloningInfo *CloningInfo `json:"cloningInfo,omitempty"`
	// ResourceGroup - READ-ONLY; Name of the resource group the app belongs to. Read-only.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// IsDefaultContainer - READ-ONLY; <code>true</code> if the app is a default container; otherwise, <code>false</code>.
	IsDefaultContainer *bool `json:"isDefaultContainer,omitempty"`
	// DefaultHostName - READ-ONLY; Default hostname of the app. Read-only.
	DefaultHostName *string `json:"defaultHostName,omitempty"`
	// SlotSwapStatus - READ-ONLY; Status of the last deployment slot swap operation.
	SlotSwapStatus *SlotSwapStatus `json:"slotSwapStatus,omitempty"`
	// HTTPSOnly - HttpsOnly: configures a web site to accept only https requests. Issues redirect for
	// http requests
	HTTPSOnly *bool `json:"httpsOnly,omitempty"`
	// RedundancyMode - Site redundancy mode. Possible values include: 'RedundancyModeNone', 'RedundancyModeManual', 'RedundancyModeFailover', 'RedundancyModeActiveActive', 'RedundancyModeGeoRedundant'
	RedundancyMode RedundancyMode `json:"redundancyMode,omitempty"`
	// InProgressOperationID - READ-ONLY; Specifies an operation id if this site has a pending operation.
	InProgressOperationID *uuid.UUID `json:"inProgressOperationId,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteProperties.
func (s SiteProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Enabled != nil {
		objectMap["enabled"] = s.Enabled
	}
	if s.HostNameSslStates != nil {
		objectMap["hostNameSslStates"] = s.HostNameSslStates
	}
	if s.ServerFarmID != nil {
		objectMap["serverFarmId"] = s.ServerFarmID
	}
	if s.Reserved != nil {
		objectMap["reserved"] = s.Reserved
	}
	if s.IsXenon != nil {
		objectMap["isXenon"] = s.IsXenon
	}
	if s.HyperV != nil {
		objectMap["hyperV"] = s.HyperV
	}
	if s.SiteConfig != nil {
		objectMap["siteConfig"] = s.SiteConfig
	}
	if s.ScmSiteAlsoStopped != nil {
		objectMap["scmSiteAlsoStopped"] = s.ScmSiteAlsoStopped
	}
	if s.HostingEnvironmentProfile != nil {
		objectMap["hostingEnvironmentProfile"] = s.HostingEnvironmentProfile
	}
	if s.ClientAffinityEnabled != nil {
		objectMap["clientAffinityEnabled"] = s.ClientAffinityEnabled
	}
	if s.ClientCertEnabled != nil {
		objectMap["clientCertEnabled"] = s.ClientCertEnabled
	}
	if s.ClientCertMode != "" {
		objectMap["clientCertMode"] = s.ClientCertMode
	}
	if s.ClientCertExclusionPaths != nil {
		objectMap["clientCertExclusionPaths"] = s.ClientCertExclusionPaths
	}
	if s.HostNamesDisabled != nil {
		objectMap["hostNamesDisabled"] = s.HostNamesDisabled
	}
	if s.CustomDomainVerificationID != nil {
		objectMap["customDomainVerificationId"] = s.CustomDomainVerificationID
	}
	if s.ContainerSize != nil {
		objectMap["containerSize"] = s.ContainerSize
	}
	if s.DailyMemoryTimeQuota != nil {
		objectMap["dailyMemoryTimeQuota"] = s.DailyMemoryTimeQuota
	}
	if s.CloningInfo != nil {
		objectMap["cloningInfo"] = s.CloningInfo
	}
	if s.HTTPSOnly != nil {
		objectMap["httpsOnly"] = s.HTTPSOnly
	}
	if s.RedundancyMode != "" {
		objectMap["redundancyMode"] = s.RedundancyMode
	}
	return json.Marshal(objectMap)
}

// SiteSeal site seal
type SiteSeal struct {
	autorest.Response `json:"-"`
	// HTML - HTML snippet
	HTML *string `json:"html,omitempty"`
}

// SiteSealRequest site seal request.
type SiteSealRequest struct {
	// LightTheme - If <code>true</code> use the light color theme for site seal; otherwise, use the default color theme.
	LightTheme *bool `json:"lightTheme,omitempty"`
	// Locale - Locale of site seal.
	Locale *string `json:"locale,omitempty"`
}

// SiteSourceControl source control configuration for an app.
type SiteSourceControl struct {
	autorest.Response `json:"-"`
	// SiteSourceControlProperties - SiteSourceControl resource specific properties
	*SiteSourceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SiteSourceControl.
func (ssc SiteSourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssc.SiteSourceControlProperties != nil {
		objectMap["properties"] = ssc.SiteSourceControlProperties
	}
	if ssc.Kind != nil {
		objectMap["kind"] = ssc.Kind
	}
	if ssc.SystemData != nil {
		objectMap["systemData"] = ssc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SiteSourceControl struct.
func (ssc *SiteSourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var siteSourceControlProperties SiteSourceControlProperties
				err = json.Unmarshal(*v, &siteSourceControlProperties)
				if err != nil {
					return err
				}
				ssc.SiteSourceControlProperties = &siteSourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssc.SystemData = &systemData
			}
		}
	}

	return nil
}

// SiteSourceControlProperties siteSourceControl resource specific properties
type SiteSourceControlProperties struct {
	// RepoURL - Repository or source control URL.
	RepoURL *string `json:"repoUrl,omitempty"`
	// Branch - Name of branch to use for deployment.
	Branch *string `json:"branch,omitempty"`
	// IsManualIntegration - <code>true</code> to limit to manual integration; <code>false</code> to enable continuous integration (which configures webhooks into online repos like GitHub).
	IsManualIntegration *bool `json:"isManualIntegration,omitempty"`
	// IsGitHubAction - <code>true</code> if this is deployed via GitHub action.
	IsGitHubAction *bool `json:"isGitHubAction,omitempty"`
	// DeploymentRollbackEnabled - <code>true</code> to enable deployment rollback; otherwise, <code>false</code>.
	DeploymentRollbackEnabled *bool `json:"deploymentRollbackEnabled,omitempty"`
	// IsMercurial - <code>true</code> for a Mercurial repository; <code>false</code> for a Git repository.
	IsMercurial *bool `json:"isMercurial,omitempty"`
}

// SkuCapacity description of the App Service plan scale options.
type SkuCapacity struct {
	// Minimum - Minimum number of workers for this App Service plan SKU.
	Minimum *int32 `json:"minimum,omitempty"`
	// Maximum - Maximum number of workers for this App Service plan SKU.
	Maximum *int32 `json:"maximum,omitempty"`
	// Default - Default number of workers for this App Service plan SKU.
	Default *int32 `json:"default,omitempty"`
	// ScaleType - Available scale configurations for an App Service plan.
	ScaleType *string `json:"scaleType,omitempty"`
}

// SkuDescription description of a SKU for a scalable resource.
type SkuDescription struct {
	// Name - Name of the resource SKU.
	Name *string `json:"name,omitempty"`
	// Tier - Service tier of the resource SKU.
	Tier *string `json:"tier,omitempty"`
	// Size - Size specifier of the resource SKU.
	Size *string `json:"size,omitempty"`
	// Family - Family code of the resource SKU.
	Family *string `json:"family,omitempty"`
	// Capacity - Current number of instances assigned to the resource.
	Capacity *int32 `json:"capacity,omitempty"`
	// SkuCapacity - Min, max, and default scale values of the SKU.
	SkuCapacity *SkuCapacity `json:"skuCapacity,omitempty"`
	// Locations - Locations of the SKU.
	Locations *[]string `json:"locations,omitempty"`
	// Capabilities - Capabilities of the SKU, e.g., is traffic manager enabled?
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// SkuInfo SKU discovery information.
type SkuInfo struct {
	// ResourceType - Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Sku - Name and tier of the SKU.
	Sku *SkuDescription `json:"sku,omitempty"`
	// Capacity - Min, max, and default scale values of the SKU.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
}

// SkuInfoCollection collection of SKU information.
type SkuInfoCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SkuInfo `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInfoCollection.
func (sic SkuInfoCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sic.Value != nil {
		objectMap["value"] = sic.Value
	}
	return json.Marshal(objectMap)
}

// SkuInfoCollectionIterator provides access to a complete listing of SkuInfo values.
type SkuInfoCollectionIterator struct {
	i    int
	page SkuInfoCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SkuInfoCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SkuInfoCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SkuInfoCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SkuInfoCollectionIterator) Response() SkuInfoCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SkuInfoCollectionIterator) Value() SkuInfo {
	if !iter.page.NotDone() {
		return SkuInfo{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SkuInfoCollectionIterator type.
func NewSkuInfoCollectionIterator(page SkuInfoCollectionPage) SkuInfoCollectionIterator {
	return SkuInfoCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sic SkuInfoCollection) IsEmpty() bool {
	return sic.Value == nil || len(*sic.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sic SkuInfoCollection) hasNextLink() bool {
	return sic.NextLink != nil && len(*sic.NextLink) != 0
}

// skuInfoCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sic SkuInfoCollection) skuInfoCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sic.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sic.NextLink)))
}

// SkuInfoCollectionPage contains a page of SkuInfo values.
type SkuInfoCollectionPage struct {
	fn  func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)
	sic SkuInfoCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SkuInfoCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SkuInfoCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sic)
		if err != nil {
			return err
		}
		page.sic = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SkuInfoCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SkuInfoCollectionPage) NotDone() bool {
	return !page.sic.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SkuInfoCollectionPage) Response() SkuInfoCollection {
	return page.sic
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SkuInfoCollectionPage) Values() []SkuInfo {
	if page.sic.IsEmpty() {
		return nil
	}
	return *page.sic.Value
}

// Creates a new instance of the SkuInfoCollectionPage type.
func NewSkuInfoCollectionPage(cur SkuInfoCollection, getNextPage func(context.Context, SkuInfoCollection) (SkuInfoCollection, error)) SkuInfoCollectionPage {
	return SkuInfoCollectionPage{
		fn:  getNextPage,
		sic: cur,
	}
}

// SkuInfos collection of SKU information.
type SkuInfos struct {
	autorest.Response `json:"-"`
	// ResourceType - Resource type that this SKU applies to.
	ResourceType *string `json:"resourceType,omitempty"`
	// Skus - List of SKUs the subscription is able to use.
	Skus *[]GlobalCsmSkuDescription `json:"skus,omitempty"`
}

// SlotConfigNames names for connection strings, application settings, and external Azure storage account
// configuration
// identifiers to be marked as sticky to the deployment slot and not moved during a swap operation.
// This is valid for all deployment slots in an app.
type SlotConfigNames struct {
	// ConnectionStringNames - List of connection string names.
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	// AppSettingNames - List of application settings names.
	AppSettingNames *[]string `json:"appSettingNames,omitempty"`
	// AzureStorageConfigNames - List of external Azure storage account identifiers.
	AzureStorageConfigNames *[]string `json:"azureStorageConfigNames,omitempty"`
}

// SlotConfigNamesResource slot Config names azure resource.
type SlotConfigNamesResource struct {
	autorest.Response `json:"-"`
	// SlotConfigNames - Core resource properties
	*SlotConfigNames `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SlotConfigNamesResource.
func (scnr SlotConfigNamesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scnr.SlotConfigNames != nil {
		objectMap["properties"] = scnr.SlotConfigNames
	}
	if scnr.Kind != nil {
		objectMap["kind"] = scnr.Kind
	}
	if scnr.SystemData != nil {
		objectMap["systemData"] = scnr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotConfigNamesResource struct.
func (scnr *SlotConfigNamesResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotConfigNames SlotConfigNames
				err = json.Unmarshal(*v, &slotConfigNames)
				if err != nil {
					return err
				}
				scnr.SlotConfigNames = &slotConfigNames
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scnr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scnr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scnr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				scnr.SystemData = &systemData
			}
		}
	}

	return nil
}

// SlotDifference a setting difference between two deployment slots of an app.
type SlotDifference struct {
	// SlotDifferenceProperties - SlotDifference resource specific properties
	*SlotDifferenceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SlotDifference.
func (sd SlotDifference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.SlotDifferenceProperties != nil {
		objectMap["properties"] = sd.SlotDifferenceProperties
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.SystemData != nil {
		objectMap["systemData"] = sd.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SlotDifference struct.
func (sd *SlotDifference) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var slotDifferenceProperties SlotDifferenceProperties
				err = json.Unmarshal(*v, &slotDifferenceProperties)
				if err != nil {
					return err
				}
				sd.SlotDifferenceProperties = &slotDifferenceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sd.SystemData = &systemData
			}
		}
	}

	return nil
}

// SlotDifferenceCollection collection of slot differences.
type SlotDifferenceCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SlotDifference `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SlotDifferenceCollection.
func (sdc SlotDifferenceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdc.Value != nil {
		objectMap["value"] = sdc.Value
	}
	return json.Marshal(objectMap)
}

// SlotDifferenceCollectionIterator provides access to a complete listing of SlotDifference values.
type SlotDifferenceCollectionIterator struct {
	i    int
	page SlotDifferenceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SlotDifferenceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SlotDifferenceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SlotDifferenceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SlotDifferenceCollectionIterator) Response() SlotDifferenceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SlotDifferenceCollectionIterator) Value() SlotDifference {
	if !iter.page.NotDone() {
		return SlotDifference{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SlotDifferenceCollectionIterator type.
func NewSlotDifferenceCollectionIterator(page SlotDifferenceCollectionPage) SlotDifferenceCollectionIterator {
	return SlotDifferenceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdc SlotDifferenceCollection) IsEmpty() bool {
	return sdc.Value == nil || len(*sdc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sdc SlotDifferenceCollection) hasNextLink() bool {
	return sdc.NextLink != nil && len(*sdc.NextLink) != 0
}

// slotDifferenceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdc SlotDifferenceCollection) slotDifferenceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sdc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdc.NextLink)))
}

// SlotDifferenceCollectionPage contains a page of SlotDifference values.
type SlotDifferenceCollectionPage struct {
	fn  func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)
	sdc SlotDifferenceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SlotDifferenceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SlotDifferenceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sdc)
		if err != nil {
			return err
		}
		page.sdc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SlotDifferenceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SlotDifferenceCollectionPage) NotDone() bool {
	return !page.sdc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SlotDifferenceCollectionPage) Response() SlotDifferenceCollection {
	return page.sdc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SlotDifferenceCollectionPage) Values() []SlotDifference {
	if page.sdc.IsEmpty() {
		return nil
	}
	return *page.sdc.Value
}

// Creates a new instance of the SlotDifferenceCollectionPage type.
func NewSlotDifferenceCollectionPage(cur SlotDifferenceCollection, getNextPage func(context.Context, SlotDifferenceCollection) (SlotDifferenceCollection, error)) SlotDifferenceCollectionPage {
	return SlotDifferenceCollectionPage{
		fn:  getNextPage,
		sdc: cur,
	}
}

// SlotDifferenceProperties slotDifference resource specific properties
type SlotDifferenceProperties struct {
	// Level - READ-ONLY; Level of the difference: Information, Warning or Error.
	Level *string `json:"level,omitempty"`
	// SettingType - READ-ONLY; The type of the setting: General, AppSetting or ConnectionString.
	SettingType *string `json:"settingType,omitempty"`
	// DiffRule - READ-ONLY; Rule that describes how to process the setting difference during a slot swap.
	DiffRule *string `json:"diffRule,omitempty"`
	// SettingName - READ-ONLY; Name of the setting.
	SettingName *string `json:"settingName,omitempty"`
	// ValueInCurrentSlot - READ-ONLY; Value of the setting in the current slot.
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty"`
	// ValueInTargetSlot - READ-ONLY; Value of the setting in the target slot.
	ValueInTargetSlot *string `json:"valueInTargetSlot,omitempty"`
	// Description - READ-ONLY; Description of the setting difference.
	Description *string `json:"description,omitempty"`
}

// SlotSwapStatus the status of the last successful slot swap operation.
type SlotSwapStatus struct {
	// TimestampUtc - READ-ONLY; The time the last successful slot swap completed.
	TimestampUtc *date.Time `json:"timestampUtc,omitempty"`
	// SourceSlotName - READ-ONLY; The source slot of the last swap operation.
	SourceSlotName *string `json:"sourceSlotName,omitempty"`
	// DestinationSlotName - READ-ONLY; The destination slot of the last swap operation.
	DestinationSlotName *string `json:"destinationSlotName,omitempty"`
}

// SlowRequestsBasedTrigger trigger based on request execution time.
type SlowRequestsBasedTrigger struct {
	// TimeTaken - Time taken.
	TimeTaken *string `json:"timeTaken,omitempty"`
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Snapshot a snapshot of an app.
type Snapshot struct {
	// SnapshotProperties - Snapshot resource specific properties
	*SnapshotProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.SnapshotProperties != nil {
		objectMap["properties"] = s.SnapshotProperties
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.SystemData != nil {
		objectMap["systemData"] = s.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Snapshot struct.
func (s *Snapshot) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotProperties SnapshotProperties
				err = json.Unmarshal(*v, &snapshotProperties)
				if err != nil {
					return err
				}
				s.SnapshotProperties = &snapshotProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		}
	}

	return nil
}

// SnapshotCollection collection of snapshots which can be used to revert an app to a previous time.
type SnapshotCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Snapshot `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotCollection.
func (sc SnapshotCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.Value != nil {
		objectMap["value"] = sc.Value
	}
	return json.Marshal(objectMap)
}

// SnapshotCollectionIterator provides access to a complete listing of Snapshot values.
type SnapshotCollectionIterator struct {
	i    int
	page SnapshotCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SnapshotCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SnapshotCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SnapshotCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SnapshotCollectionIterator) Response() SnapshotCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SnapshotCollectionIterator) Value() Snapshot {
	if !iter.page.NotDone() {
		return Snapshot{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SnapshotCollectionIterator type.
func NewSnapshotCollectionIterator(page SnapshotCollectionPage) SnapshotCollectionIterator {
	return SnapshotCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc SnapshotCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc SnapshotCollection) hasNextLink() bool {
	return sc.NextLink != nil && len(*sc.NextLink) != 0
}

// snapshotCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc SnapshotCollection) snapshotCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.NextLink)))
}

// SnapshotCollectionPage contains a page of Snapshot values.
type SnapshotCollectionPage struct {
	fn func(context.Context, SnapshotCollection) (SnapshotCollection, error)
	sc SnapshotCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SnapshotCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SnapshotCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SnapshotCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SnapshotCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SnapshotCollectionPage) Response() SnapshotCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SnapshotCollectionPage) Values() []Snapshot {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the SnapshotCollectionPage type.
func NewSnapshotCollectionPage(cur SnapshotCollection, getNextPage func(context.Context, SnapshotCollection) (SnapshotCollection, error)) SnapshotCollectionPage {
	return SnapshotCollectionPage{
		fn: getNextPage,
		sc: cur,
	}
}

// SnapshotProperties snapshot resource specific properties
type SnapshotProperties struct {
	// Time - READ-ONLY; The time the snapshot was taken.
	Time *string `json:"time,omitempty"`
}

// SnapshotRecoverySource specifies the web app that snapshot contents will be retrieved from.
type SnapshotRecoverySource struct {
	// Location - Geographical location of the source web app, e.g. SouthEastAsia, SouthCentralUS
	Location *string `json:"location,omitempty"`
	// ID - ARM resource ID of the source app.
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production slots and
	// /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName} for other slots.
	ID *string `json:"id,omitempty"`
}

// SnapshotRestoreRequest details about app recovery operation.
type SnapshotRestoreRequest struct {
	// SnapshotRestoreRequestProperties - SnapshotRestoreRequest resource specific properties
	*SnapshotRestoreRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SnapshotRestoreRequest.
func (srr SnapshotRestoreRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if srr.SnapshotRestoreRequestProperties != nil {
		objectMap["properties"] = srr.SnapshotRestoreRequestProperties
	}
	if srr.Kind != nil {
		objectMap["kind"] = srr.Kind
	}
	if srr.SystemData != nil {
		objectMap["systemData"] = srr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SnapshotRestoreRequest struct.
func (srr *SnapshotRestoreRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var snapshotRestoreRequestProperties SnapshotRestoreRequestProperties
				err = json.Unmarshal(*v, &snapshotRestoreRequestProperties)
				if err != nil {
					return err
				}
				srr.SnapshotRestoreRequestProperties = &snapshotRestoreRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				srr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				srr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				srr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				srr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				srr.SystemData = &systemData
			}
		}
	}

	return nil
}

// SnapshotRestoreRequestProperties snapshotRestoreRequest resource specific properties
type SnapshotRestoreRequestProperties struct {
	// SnapshotTime - Point in time in which the app restore should be done, formatted as a DateTime string.
	SnapshotTime *string `json:"snapshotTime,omitempty"`
	// RecoverySource - Optional. Specifies the web app that snapshot contents will be retrieved from.
	// If empty, the targeted web app will be used as the source.
	RecoverySource *SnapshotRecoverySource `json:"recoverySource,omitempty"`
	// Overwrite - If <code>true</code> the restore operation can overwrite source app; otherwise, <code>false</code>.
	Overwrite *bool `json:"overwrite,omitempty"`
	// RecoverConfiguration - If true, site configuration, in addition to content, will be reverted.
	RecoverConfiguration *bool `json:"recoverConfiguration,omitempty"`
	// IgnoreConflictingHostNames - If true, custom hostname conflicts will be ignored when recovering to a target web app.
	// This setting is only necessary when RecoverConfiguration is enabled.
	IgnoreConflictingHostNames *bool `json:"ignoreConflictingHostNames,omitempty"`
	// UseDRSecondary - If true, the snapshot is retrieved from DRSecondary endpoint.
	UseDRSecondary *bool `json:"useDRSecondary,omitempty"`
}

// Solution class Representing Solution for problems detected.
type Solution struct {
	// ID - Solution Id.
	ID *float64 `json:"id,omitempty"`
	// DisplayName - Display Name of the solution
	DisplayName *string `json:"displayName,omitempty"`
	// Order - Order of the solution.
	Order *float64 `json:"order,omitempty"`
	// Description - Description of the solution
	Description *string `json:"description,omitempty"`
	// Type - Type of Solution. Possible values include: 'QuickSolution', 'DeepInvestigation', 'BestPractices'
	Type SolutionType `json:"type,omitempty"`
	// Data - Solution Data.
	Data *[][]NameValuePair `json:"data,omitempty"`
	// Metadata - Solution Metadata.
	Metadata *[][]NameValuePair `json:"metadata,omitempty"`
}

// SourceControl the source control OAuth token.
type SourceControl struct {
	autorest.Response `json:"-"`
	// SourceControlProperties - SourceControl resource specific properties
	*SourceControlProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControl.
func (sc SourceControl) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SourceControlProperties != nil {
		objectMap["properties"] = sc.SourceControlProperties
	}
	if sc.Kind != nil {
		objectMap["kind"] = sc.Kind
	}
	if sc.SystemData != nil {
		objectMap["systemData"] = sc.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SourceControl struct.
func (sc *SourceControl) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sourceControlProperties SourceControlProperties
				err = json.Unmarshal(*v, &sourceControlProperties)
				if err != nil {
					return err
				}
				sc.SourceControlProperties = &sourceControlProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sc.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sc.SystemData = &systemData
			}
		}
	}

	return nil
}

// SourceControlCollection collection of source controls.
type SourceControlCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]SourceControl `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for SourceControlCollection.
func (scc SourceControlCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.Value != nil {
		objectMap["value"] = scc.Value
	}
	return json.Marshal(objectMap)
}

// SourceControlCollectionIterator provides access to a complete listing of SourceControl values.
type SourceControlCollectionIterator struct {
	i    int
	page SourceControlCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SourceControlCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SourceControlCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SourceControlCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SourceControlCollectionIterator) Response() SourceControlCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SourceControlCollectionIterator) Value() SourceControl {
	if !iter.page.NotDone() {
		return SourceControl{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SourceControlCollectionIterator type.
func NewSourceControlCollectionIterator(page SourceControlCollectionPage) SourceControlCollectionIterator {
	return SourceControlCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc SourceControlCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scc SourceControlCollection) hasNextLink() bool {
	return scc.NextLink != nil && len(*scc.NextLink) != 0
}

// sourceControlCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc SourceControlCollection) sourceControlCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// SourceControlCollectionPage contains a page of SourceControl values.
type SourceControlCollectionPage struct {
	fn  func(context.Context, SourceControlCollection) (SourceControlCollection, error)
	scc SourceControlCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SourceControlCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SourceControlCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scc)
		if err != nil {
			return err
		}
		page.scc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SourceControlCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SourceControlCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SourceControlCollectionPage) Response() SourceControlCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SourceControlCollectionPage) Values() []SourceControl {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the SourceControlCollectionPage type.
func NewSourceControlCollectionPage(cur SourceControlCollection, getNextPage func(context.Context, SourceControlCollection) (SourceControlCollection, error)) SourceControlCollectionPage {
	return SourceControlCollectionPage{
		fn:  getNextPage,
		scc: cur,
	}
}

// SourceControlProperties sourceControl resource specific properties
type SourceControlProperties struct {
	// Token - OAuth access token.
	Token *string `json:"token,omitempty"`
	// TokenSecret - OAuth access token secret.
	TokenSecret *string `json:"tokenSecret,omitempty"`
	// RefreshToken - OAuth refresh token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// ExpirationTime - OAuth token expiration.
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// StackMajorVersion application stack major version.
type StackMajorVersion struct {
	// DisplayVersion - Application stack major version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// RuntimeVersion - Application stack major version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// IsDefault - <code>true</code> if this is the default major version; otherwise, <code>false</code>.
	IsDefault *bool `json:"isDefault,omitempty"`
	// MinorVersions - Minor versions associated with the major version.
	MinorVersions *[]StackMinorVersion `json:"minorVersions,omitempty"`
	// ApplicationInsights - <code>true</code> if this supports Application Insights; otherwise, <code>false</code>.
	ApplicationInsights *bool `json:"applicationInsights,omitempty"`
	// IsPreview - <code>true</code> if this stack is in Preview, otherwise <code>false</code>.
	IsPreview *bool `json:"isPreview,omitempty"`
	// IsDeprecated - <code>true</code> if this stack has been deprecated, otherwise <code>false</code>.
	IsDeprecated *bool `json:"isDeprecated,omitempty"`
	// IsHidden - <code>true</code> if this stack should be hidden for new customers on portal, otherwise <code>false</code>.
	IsHidden *bool `json:"isHidden,omitempty"`
}

// StackMinorVersion application stack minor version.
type StackMinorVersion struct {
	// DisplayVersion - Application stack minor version (display only).
	DisplayVersion *string `json:"displayVersion,omitempty"`
	// RuntimeVersion - Application stack minor version (runtime only).
	RuntimeVersion *string `json:"runtimeVersion,omitempty"`
	// IsDefault - <code>true</code> if this is the default minor version; otherwise, <code>false</code>.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsRemoteDebuggingEnabled - <code>true</code> if this supports Remote Debugging, otherwise <code>false</code>.
	IsRemoteDebuggingEnabled *bool `json:"isRemoteDebuggingEnabled,omitempty"`
}

// StampCapacity stamp capacity information.
type StampCapacity struct {
	// Name - Name of the stamp.
	Name *string `json:"name,omitempty"`
	// AvailableCapacity - Available capacity (# of machines, bytes of storage etc...).
	AvailableCapacity *int64 `json:"availableCapacity,omitempty"`
	// TotalCapacity - Total capacity (# of machines, bytes of storage etc...).
	TotalCapacity *int64 `json:"totalCapacity,omitempty"`
	// Unit - Name of the unit.
	Unit *string `json:"unit,omitempty"`
	// ComputeMode - Shared/dedicated workers. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - Size of the machines. Possible values include: 'WorkerSizeOptionsSmall', 'WorkerSizeOptionsMedium', 'WorkerSizeOptionsLarge', 'WorkerSizeOptionsD1', 'WorkerSizeOptionsD2', 'WorkerSizeOptionsD3', 'WorkerSizeOptionsNestedSmall', 'WorkerSizeOptionsDefault'
	WorkerSize WorkerSizeOptions `json:"workerSize,omitempty"`
	// WorkerSizeID - Size ID of machines:
	// 0 - Small
	// 1 - Medium
	// 2 - Large
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ExcludeFromCapacityAllocation - If <code>true</code>, it includes basic apps.
	// Basic apps are not used for capacity allocation.
	ExcludeFromCapacityAllocation *bool `json:"excludeFromCapacityAllocation,omitempty"`
	// IsApplicableForAllComputeModes - <code>true</code> if capacity is applicable for all apps; otherwise, <code>false</code>.
	IsApplicableForAllComputeModes *bool `json:"isApplicableForAllComputeModes,omitempty"`
	// SiteMode - Shared or Dedicated.
	SiteMode *string `json:"siteMode,omitempty"`
	// IsLinux - Is this a linux stamp capacity
	IsLinux *bool `json:"isLinux,omitempty"`
}

// StampCapacityCollection collection of stamp capacities.
type StampCapacityCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StampCapacity `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StampCapacityCollection.
func (scc StampCapacityCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scc.Value != nil {
		objectMap["value"] = scc.Value
	}
	return json.Marshal(objectMap)
}

// StampCapacityCollectionIterator provides access to a complete listing of StampCapacity values.
type StampCapacityCollectionIterator struct {
	i    int
	page StampCapacityCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StampCapacityCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StampCapacityCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StampCapacityCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StampCapacityCollectionIterator) Response() StampCapacityCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StampCapacityCollectionIterator) Value() StampCapacity {
	if !iter.page.NotDone() {
		return StampCapacity{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StampCapacityCollectionIterator type.
func NewStampCapacityCollectionIterator(page StampCapacityCollectionPage) StampCapacityCollectionIterator {
	return StampCapacityCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (scc StampCapacityCollection) IsEmpty() bool {
	return scc.Value == nil || len(*scc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (scc StampCapacityCollection) hasNextLink() bool {
	return scc.NextLink != nil && len(*scc.NextLink) != 0
}

// stampCapacityCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (scc StampCapacityCollection) stampCapacityCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !scc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(scc.NextLink)))
}

// StampCapacityCollectionPage contains a page of StampCapacity values.
type StampCapacityCollectionPage struct {
	fn  func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)
	scc StampCapacityCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StampCapacityCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StampCapacityCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.scc)
		if err != nil {
			return err
		}
		page.scc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StampCapacityCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StampCapacityCollectionPage) NotDone() bool {
	return !page.scc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StampCapacityCollectionPage) Response() StampCapacityCollection {
	return page.scc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StampCapacityCollectionPage) Values() []StampCapacity {
	if page.scc.IsEmpty() {
		return nil
	}
	return *page.scc.Value
}

// Creates a new instance of the StampCapacityCollectionPage type.
func NewStampCapacityCollectionPage(cur StampCapacityCollection, getNextPage func(context.Context, StampCapacityCollection) (StampCapacityCollection, error)) StampCapacityCollectionPage {
	return StampCapacityCollectionPage{
		fn:  getNextPage,
		scc: cur,
	}
}

// StaticSite a static site.
type StaticSite struct {
	// DefaultHostname - READ-ONLY; The default autogenerated hostname for the static site.
	DefaultHostname *string `json:"defaultHostname,omitempty"`
	// RepositoryURL - URL for the repository of the static site.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The target branch in the repository.
	Branch *string `json:"branch,omitempty"`
	// CustomDomains - READ-ONLY; The custom domains associated with this static site.
	CustomDomains *[]string `json:"customDomains,omitempty"`
	// RepositoryToken - A user's github repository token. This is used to setup the Github Actions workflow file and API secrets.
	RepositoryToken *string `json:"repositoryToken,omitempty"`
	// BuildProperties - Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties `json:"buildProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSite.
func (ss StaticSite) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.RepositoryURL != nil {
		objectMap["repositoryUrl"] = ss.RepositoryURL
	}
	if ss.Branch != nil {
		objectMap["branch"] = ss.Branch
	}
	if ss.RepositoryToken != nil {
		objectMap["repositoryToken"] = ss.RepositoryToken
	}
	if ss.BuildProperties != nil {
		objectMap["buildProperties"] = ss.BuildProperties
	}
	return json.Marshal(objectMap)
}

// StaticSiteARMResource static Site ARM resource.
type StaticSiteARMResource struct {
	autorest.Response `json:"-"`
	// StaticSite - Core resource properties
	*StaticSite `json:"properties,omitempty"`
	Sku         *SkuDescription `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource Location.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteARMResource.
func (ssar StaticSiteARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssar.StaticSite != nil {
		objectMap["properties"] = ssar.StaticSite
	}
	if ssar.Sku != nil {
		objectMap["sku"] = ssar.Sku
	}
	if ssar.Kind != nil {
		objectMap["kind"] = ssar.Kind
	}
	if ssar.Location != nil {
		objectMap["location"] = ssar.Location
	}
	if ssar.Tags != nil {
		objectMap["tags"] = ssar.Tags
	}
	if ssar.SystemData != nil {
		objectMap["systemData"] = ssar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteARMResource struct.
func (ssar *StaticSiteARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSite StaticSite
				err = json.Unmarshal(*v, &staticSite)
				if err != nil {
					return err
				}
				ssar.StaticSite = &staticSite
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ssar.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssar.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ssar.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssar.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ssar.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteBuildARMResource static Site Build ARM resource.
type StaticSiteBuildARMResource struct {
	autorest.Response `json:"-"`
	// StaticSiteBuildARMResourceProperties - StaticSiteBuildARMResource resource specific properties
	*StaticSiteBuildARMResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteBuildARMResource.
func (ssbar StaticSiteBuildARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssbar.StaticSiteBuildARMResourceProperties != nil {
		objectMap["properties"] = ssbar.StaticSiteBuildARMResourceProperties
	}
	if ssbar.Kind != nil {
		objectMap["kind"] = ssbar.Kind
	}
	if ssbar.SystemData != nil {
		objectMap["systemData"] = ssbar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteBuildARMResource struct.
func (ssbar *StaticSiteBuildARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteBuildARMResourceProperties StaticSiteBuildARMResourceProperties
				err = json.Unmarshal(*v, &staticSiteBuildARMResourceProperties)
				if err != nil {
					return err
				}
				ssbar.StaticSiteBuildARMResourceProperties = &staticSiteBuildARMResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssbar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssbar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssbar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssbar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssbar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteBuildARMResourceProperties staticSiteBuildARMResource resource specific properties
type StaticSiteBuildARMResourceProperties struct {
	// BuildID - READ-ONLY; An identifier for the static site build.
	BuildID *string `json:"buildId,omitempty"`
	// SourceBranch - READ-ONLY; The source branch.
	SourceBranch *string `json:"sourceBranch,omitempty"`
	// PullRequestTitle - READ-ONLY; The title of a pull request that a static site build is related to.
	PullRequestTitle *string `json:"pullRequestTitle,omitempty"`
	// Hostname - READ-ONLY; The hostname for a static site build.
	Hostname *string `json:"hostname,omitempty"`
	// CreatedTimeUtc - READ-ONLY; When this build was created.
	CreatedTimeUtc *date.Time `json:"createdTimeUtc,omitempty"`
	// LastUpdatedOn - READ-ONLY; When this build was updated.
	LastUpdatedOn *date.Time `json:"lastUpdatedOn,omitempty"`
	// Status - READ-ONLY; The status of the static site build. Possible values include: 'BuildStatusWaitingForDeployment', 'BuildStatusUploading', 'BuildStatusDeploying', 'BuildStatusReady', 'BuildStatusFailed', 'BuildStatusDeleting', 'BuildStatusDetached'
	Status BuildStatus `json:"status,omitempty"`
}

// StaticSiteBuildCollection collection of static site builds.
type StaticSiteBuildCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StaticSiteBuildARMResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteBuildCollection.
func (ssbc StaticSiteBuildCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssbc.Value != nil {
		objectMap["value"] = ssbc.Value
	}
	return json.Marshal(objectMap)
}

// StaticSiteBuildCollectionIterator provides access to a complete listing of StaticSiteBuildARMResource
// values.
type StaticSiteBuildCollectionIterator struct {
	i    int
	page StaticSiteBuildCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StaticSiteBuildCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteBuildCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StaticSiteBuildCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StaticSiteBuildCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StaticSiteBuildCollectionIterator) Response() StaticSiteBuildCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StaticSiteBuildCollectionIterator) Value() StaticSiteBuildARMResource {
	if !iter.page.NotDone() {
		return StaticSiteBuildARMResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StaticSiteBuildCollectionIterator type.
func NewStaticSiteBuildCollectionIterator(page StaticSiteBuildCollectionPage) StaticSiteBuildCollectionIterator {
	return StaticSiteBuildCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssbc StaticSiteBuildCollection) IsEmpty() bool {
	return ssbc.Value == nil || len(*ssbc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssbc StaticSiteBuildCollection) hasNextLink() bool {
	return ssbc.NextLink != nil && len(*ssbc.NextLink) != 0
}

// staticSiteBuildCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssbc StaticSiteBuildCollection) staticSiteBuildCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ssbc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssbc.NextLink)))
}

// StaticSiteBuildCollectionPage contains a page of StaticSiteBuildARMResource values.
type StaticSiteBuildCollectionPage struct {
	fn   func(context.Context, StaticSiteBuildCollection) (StaticSiteBuildCollection, error)
	ssbc StaticSiteBuildCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StaticSiteBuildCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteBuildCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssbc)
		if err != nil {
			return err
		}
		page.ssbc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StaticSiteBuildCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StaticSiteBuildCollectionPage) NotDone() bool {
	return !page.ssbc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StaticSiteBuildCollectionPage) Response() StaticSiteBuildCollection {
	return page.ssbc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StaticSiteBuildCollectionPage) Values() []StaticSiteBuildARMResource {
	if page.ssbc.IsEmpty() {
		return nil
	}
	return *page.ssbc.Value
}

// Creates a new instance of the StaticSiteBuildCollectionPage type.
func NewStaticSiteBuildCollectionPage(cur StaticSiteBuildCollection, getNextPage func(context.Context, StaticSiteBuildCollection) (StaticSiteBuildCollection, error)) StaticSiteBuildCollectionPage {
	return StaticSiteBuildCollectionPage{
		fn:   getNextPage,
		ssbc: cur,
	}
}

// StaticSiteBuildProperties build properties for the static site.
type StaticSiteBuildProperties struct {
	// AppLocation - The path to the app code within the repository.
	AppLocation *string `json:"appLocation,omitempty"`
	// APILocation - The path to the api code within the repository.
	APILocation *string `json:"apiLocation,omitempty"`
	// AppArtifactLocation - The path of the app artifacts after building.
	AppArtifactLocation *string `json:"appArtifactLocation,omitempty"`
}

// StaticSiteCollection collection of static sites.
type StaticSiteCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StaticSiteARMResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteCollection.
func (ssc StaticSiteCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssc.Value != nil {
		objectMap["value"] = ssc.Value
	}
	return json.Marshal(objectMap)
}

// StaticSiteCollectionIterator provides access to a complete listing of StaticSiteARMResource values.
type StaticSiteCollectionIterator struct {
	i    int
	page StaticSiteCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StaticSiteCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StaticSiteCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StaticSiteCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StaticSiteCollectionIterator) Response() StaticSiteCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StaticSiteCollectionIterator) Value() StaticSiteARMResource {
	if !iter.page.NotDone() {
		return StaticSiteARMResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StaticSiteCollectionIterator type.
func NewStaticSiteCollectionIterator(page StaticSiteCollectionPage) StaticSiteCollectionIterator {
	return StaticSiteCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssc StaticSiteCollection) IsEmpty() bool {
	return ssc.Value == nil || len(*ssc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssc StaticSiteCollection) hasNextLink() bool {
	return ssc.NextLink != nil && len(*ssc.NextLink) != 0
}

// staticSiteCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssc StaticSiteCollection) staticSiteCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ssc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssc.NextLink)))
}

// StaticSiteCollectionPage contains a page of StaticSiteARMResource values.
type StaticSiteCollectionPage struct {
	fn  func(context.Context, StaticSiteCollection) (StaticSiteCollection, error)
	ssc StaticSiteCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StaticSiteCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssc)
		if err != nil {
			return err
		}
		page.ssc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StaticSiteCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StaticSiteCollectionPage) NotDone() bool {
	return !page.ssc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StaticSiteCollectionPage) Response() StaticSiteCollection {
	return page.ssc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StaticSiteCollectionPage) Values() []StaticSiteARMResource {
	if page.ssc.IsEmpty() {
		return nil
	}
	return *page.ssc.Value
}

// Creates a new instance of the StaticSiteCollectionPage type.
func NewStaticSiteCollectionPage(cur StaticSiteCollection, getNextPage func(context.Context, StaticSiteCollection) (StaticSiteCollection, error)) StaticSiteCollectionPage {
	return StaticSiteCollectionPage{
		fn:  getNextPage,
		ssc: cur,
	}
}

// StaticSiteCustomDomainOverviewARMResource static Site Custom Domain Overview ARM resource.
type StaticSiteCustomDomainOverviewARMResource struct {
	autorest.Response `json:"-"`
	// StaticSiteCustomDomainOverviewARMResourceProperties - StaticSiteCustomDomainOverviewARMResource resource specific properties
	*StaticSiteCustomDomainOverviewARMResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteCustomDomainOverviewARMResource.
func (sscdoar StaticSiteCustomDomainOverviewARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscdoar.StaticSiteCustomDomainOverviewARMResourceProperties != nil {
		objectMap["properties"] = sscdoar.StaticSiteCustomDomainOverviewARMResourceProperties
	}
	if sscdoar.Kind != nil {
		objectMap["kind"] = sscdoar.Kind
	}
	if sscdoar.SystemData != nil {
		objectMap["systemData"] = sscdoar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteCustomDomainOverviewARMResource struct.
func (sscdoar *StaticSiteCustomDomainOverviewARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteCustomDomainOverviewARMResourceProperties StaticSiteCustomDomainOverviewARMResourceProperties
				err = json.Unmarshal(*v, &staticSiteCustomDomainOverviewARMResourceProperties)
				if err != nil {
					return err
				}
				sscdoar.StaticSiteCustomDomainOverviewARMResourceProperties = &staticSiteCustomDomainOverviewARMResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sscdoar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sscdoar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sscdoar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sscdoar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sscdoar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteCustomDomainOverviewARMResourceProperties staticSiteCustomDomainOverviewARMResource resource
// specific properties
type StaticSiteCustomDomainOverviewARMResourceProperties struct {
	// DomainName - READ-ONLY; The domain name for the static site custom domain.
	DomainName *string `json:"domainName,omitempty"`
	// CreatedOn - READ-ONLY; The date and time on which the custom domain was created for the static site.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
}

// StaticSiteCustomDomainOverviewCollection collection of static site custom domains.
type StaticSiteCustomDomainOverviewCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StaticSiteCustomDomainOverviewARMResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteCustomDomainOverviewCollection.
func (sscdoc StaticSiteCustomDomainOverviewCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sscdoc.Value != nil {
		objectMap["value"] = sscdoc.Value
	}
	return json.Marshal(objectMap)
}

// StaticSiteCustomDomainOverviewCollectionIterator provides access to a complete listing of
// StaticSiteCustomDomainOverviewARMResource values.
type StaticSiteCustomDomainOverviewCollectionIterator struct {
	i    int
	page StaticSiteCustomDomainOverviewCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StaticSiteCustomDomainOverviewCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteCustomDomainOverviewCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StaticSiteCustomDomainOverviewCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StaticSiteCustomDomainOverviewCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StaticSiteCustomDomainOverviewCollectionIterator) Response() StaticSiteCustomDomainOverviewCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StaticSiteCustomDomainOverviewCollectionIterator) Value() StaticSiteCustomDomainOverviewARMResource {
	if !iter.page.NotDone() {
		return StaticSiteCustomDomainOverviewARMResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StaticSiteCustomDomainOverviewCollectionIterator type.
func NewStaticSiteCustomDomainOverviewCollectionIterator(page StaticSiteCustomDomainOverviewCollectionPage) StaticSiteCustomDomainOverviewCollectionIterator {
	return StaticSiteCustomDomainOverviewCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sscdoc StaticSiteCustomDomainOverviewCollection) IsEmpty() bool {
	return sscdoc.Value == nil || len(*sscdoc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sscdoc StaticSiteCustomDomainOverviewCollection) hasNextLink() bool {
	return sscdoc.NextLink != nil && len(*sscdoc.NextLink) != 0
}

// staticSiteCustomDomainOverviewCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sscdoc StaticSiteCustomDomainOverviewCollection) staticSiteCustomDomainOverviewCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sscdoc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sscdoc.NextLink)))
}

// StaticSiteCustomDomainOverviewCollectionPage contains a page of
// StaticSiteCustomDomainOverviewARMResource values.
type StaticSiteCustomDomainOverviewCollectionPage struct {
	fn     func(context.Context, StaticSiteCustomDomainOverviewCollection) (StaticSiteCustomDomainOverviewCollection, error)
	sscdoc StaticSiteCustomDomainOverviewCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StaticSiteCustomDomainOverviewCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteCustomDomainOverviewCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sscdoc)
		if err != nil {
			return err
		}
		page.sscdoc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StaticSiteCustomDomainOverviewCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StaticSiteCustomDomainOverviewCollectionPage) NotDone() bool {
	return !page.sscdoc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StaticSiteCustomDomainOverviewCollectionPage) Response() StaticSiteCustomDomainOverviewCollection {
	return page.sscdoc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StaticSiteCustomDomainOverviewCollectionPage) Values() []StaticSiteCustomDomainOverviewARMResource {
	if page.sscdoc.IsEmpty() {
		return nil
	}
	return *page.sscdoc.Value
}

// Creates a new instance of the StaticSiteCustomDomainOverviewCollectionPage type.
func NewStaticSiteCustomDomainOverviewCollectionPage(cur StaticSiteCustomDomainOverviewCollection, getNextPage func(context.Context, StaticSiteCustomDomainOverviewCollection) (StaticSiteCustomDomainOverviewCollection, error)) StaticSiteCustomDomainOverviewCollectionPage {
	return StaticSiteCustomDomainOverviewCollectionPage{
		fn:     getNextPage,
		sscdoc: cur,
	}
}

// StaticSiteFunctionOverviewARMResource static Site Function Overview ARM resource.
type StaticSiteFunctionOverviewARMResource struct {
	// StaticSiteFunctionOverviewARMResourceProperties - StaticSiteFunctionOverviewARMResource resource specific properties
	*StaticSiteFunctionOverviewARMResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteFunctionOverviewARMResource.
func (ssfoar StaticSiteFunctionOverviewARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssfoar.StaticSiteFunctionOverviewARMResourceProperties != nil {
		objectMap["properties"] = ssfoar.StaticSiteFunctionOverviewARMResourceProperties
	}
	if ssfoar.Kind != nil {
		objectMap["kind"] = ssfoar.Kind
	}
	if ssfoar.SystemData != nil {
		objectMap["systemData"] = ssfoar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteFunctionOverviewARMResource struct.
func (ssfoar *StaticSiteFunctionOverviewARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteFunctionOverviewARMResourceProperties StaticSiteFunctionOverviewARMResourceProperties
				err = json.Unmarshal(*v, &staticSiteFunctionOverviewARMResourceProperties)
				if err != nil {
					return err
				}
				ssfoar.StaticSiteFunctionOverviewARMResourceProperties = &staticSiteFunctionOverviewARMResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssfoar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssfoar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssfoar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssfoar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssfoar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteFunctionOverviewARMResourceProperties staticSiteFunctionOverviewARMResource resource specific
// properties
type StaticSiteFunctionOverviewARMResourceProperties struct {
	// FunctionName - READ-ONLY; The name for the function
	FunctionName *string `json:"functionName,omitempty"`
	// TriggerType - READ-ONLY; The trigger type of the function. Possible values include: 'TriggerTypesHTTPTrigger', 'TriggerTypesUnknown'
	TriggerType TriggerTypes `json:"triggerType,omitempty"`
}

// StaticSiteFunctionOverviewCollection collection of static site functions.
type StaticSiteFunctionOverviewCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StaticSiteFunctionOverviewARMResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteFunctionOverviewCollection.
func (ssfoc StaticSiteFunctionOverviewCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssfoc.Value != nil {
		objectMap["value"] = ssfoc.Value
	}
	return json.Marshal(objectMap)
}

// StaticSiteFunctionOverviewCollectionIterator provides access to a complete listing of
// StaticSiteFunctionOverviewARMResource values.
type StaticSiteFunctionOverviewCollectionIterator struct {
	i    int
	page StaticSiteFunctionOverviewCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StaticSiteFunctionOverviewCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteFunctionOverviewCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StaticSiteFunctionOverviewCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StaticSiteFunctionOverviewCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StaticSiteFunctionOverviewCollectionIterator) Response() StaticSiteFunctionOverviewCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StaticSiteFunctionOverviewCollectionIterator) Value() StaticSiteFunctionOverviewARMResource {
	if !iter.page.NotDone() {
		return StaticSiteFunctionOverviewARMResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StaticSiteFunctionOverviewCollectionIterator type.
func NewStaticSiteFunctionOverviewCollectionIterator(page StaticSiteFunctionOverviewCollectionPage) StaticSiteFunctionOverviewCollectionIterator {
	return StaticSiteFunctionOverviewCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssfoc StaticSiteFunctionOverviewCollection) IsEmpty() bool {
	return ssfoc.Value == nil || len(*ssfoc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssfoc StaticSiteFunctionOverviewCollection) hasNextLink() bool {
	return ssfoc.NextLink != nil && len(*ssfoc.NextLink) != 0
}

// staticSiteFunctionOverviewCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssfoc StaticSiteFunctionOverviewCollection) staticSiteFunctionOverviewCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ssfoc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssfoc.NextLink)))
}

// StaticSiteFunctionOverviewCollectionPage contains a page of StaticSiteFunctionOverviewARMResource
// values.
type StaticSiteFunctionOverviewCollectionPage struct {
	fn    func(context.Context, StaticSiteFunctionOverviewCollection) (StaticSiteFunctionOverviewCollection, error)
	ssfoc StaticSiteFunctionOverviewCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StaticSiteFunctionOverviewCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteFunctionOverviewCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssfoc)
		if err != nil {
			return err
		}
		page.ssfoc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StaticSiteFunctionOverviewCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StaticSiteFunctionOverviewCollectionPage) NotDone() bool {
	return !page.ssfoc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StaticSiteFunctionOverviewCollectionPage) Response() StaticSiteFunctionOverviewCollection {
	return page.ssfoc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StaticSiteFunctionOverviewCollectionPage) Values() []StaticSiteFunctionOverviewARMResource {
	if page.ssfoc.IsEmpty() {
		return nil
	}
	return *page.ssfoc.Value
}

// Creates a new instance of the StaticSiteFunctionOverviewCollectionPage type.
func NewStaticSiteFunctionOverviewCollectionPage(cur StaticSiteFunctionOverviewCollection, getNextPage func(context.Context, StaticSiteFunctionOverviewCollection) (StaticSiteFunctionOverviewCollection, error)) StaticSiteFunctionOverviewCollectionPage {
	return StaticSiteFunctionOverviewCollectionPage{
		fn:    getNextPage,
		ssfoc: cur,
	}
}

// StaticSitePatchResource ARM resource for a static site when patching
type StaticSitePatchResource struct {
	// StaticSite - Core resource properties
	*StaticSite `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSitePatchResource.
func (sspr StaticSitePatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspr.StaticSite != nil {
		objectMap["properties"] = sspr.StaticSite
	}
	if sspr.Kind != nil {
		objectMap["kind"] = sspr.Kind
	}
	if sspr.SystemData != nil {
		objectMap["systemData"] = sspr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSitePatchResource struct.
func (sspr *StaticSitePatchResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSite StaticSite
				err = json.Unmarshal(*v, &staticSite)
				if err != nil {
					return err
				}
				sspr.StaticSite = &staticSite
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sspr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sspr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sspr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sspr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sspr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteResetPropertiesARMResource static Site Reset Properties ARM resource.
type StaticSiteResetPropertiesARMResource struct {
	// StaticSiteResetPropertiesARMResourceProperties - StaticSiteResetPropertiesARMResource resource specific properties
	*StaticSiteResetPropertiesARMResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteResetPropertiesARMResource.
func (ssrpar StaticSiteResetPropertiesARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssrpar.StaticSiteResetPropertiesARMResourceProperties != nil {
		objectMap["properties"] = ssrpar.StaticSiteResetPropertiesARMResourceProperties
	}
	if ssrpar.Kind != nil {
		objectMap["kind"] = ssrpar.Kind
	}
	if ssrpar.SystemData != nil {
		objectMap["systemData"] = ssrpar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteResetPropertiesARMResource struct.
func (ssrpar *StaticSiteResetPropertiesARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteResetPropertiesARMResourceProperties StaticSiteResetPropertiesARMResourceProperties
				err = json.Unmarshal(*v, &staticSiteResetPropertiesARMResourceProperties)
				if err != nil {
					return err
				}
				ssrpar.StaticSiteResetPropertiesARMResourceProperties = &staticSiteResetPropertiesARMResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssrpar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssrpar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssrpar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssrpar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssrpar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteResetPropertiesARMResourceProperties staticSiteResetPropertiesARMResource resource specific
// properties
type StaticSiteResetPropertiesARMResourceProperties struct {
	// RepositoryToken - The token which proves admin privileges to the repository.
	RepositoryToken *string `json:"repositoryToken,omitempty"`
	// ShouldUpdateRepository - Determines whether the repository should be updated with the new properties.
	ShouldUpdateRepository *bool `json:"shouldUpdateRepository,omitempty"`
}

// StaticSitesWorkflowPreview preview for the Static Site Workflow to be generated
type StaticSitesWorkflowPreview struct {
	autorest.Response `json:"-"`
	// StaticSitesWorkflowPreviewProperties - StaticSitesWorkflowPreview resource specific properties
	*StaticSitesWorkflowPreviewProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSitesWorkflowPreview.
func (sswp StaticSitesWorkflowPreview) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sswp.StaticSitesWorkflowPreviewProperties != nil {
		objectMap["properties"] = sswp.StaticSitesWorkflowPreviewProperties
	}
	if sswp.Kind != nil {
		objectMap["kind"] = sswp.Kind
	}
	if sswp.SystemData != nil {
		objectMap["systemData"] = sswp.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSitesWorkflowPreview struct.
func (sswp *StaticSitesWorkflowPreview) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSitesWorkflowPreviewProperties StaticSitesWorkflowPreviewProperties
				err = json.Unmarshal(*v, &staticSitesWorkflowPreviewProperties)
				if err != nil {
					return err
				}
				sswp.StaticSitesWorkflowPreviewProperties = &staticSitesWorkflowPreviewProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sswp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sswp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sswp.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sswp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sswp.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSitesWorkflowPreviewProperties staticSitesWorkflowPreview resource specific properties
type StaticSitesWorkflowPreviewProperties struct {
	// Path - READ-ONLY; The path for the workflow file to be generated
	Path *string `json:"path,omitempty"`
	// Contents - READ-ONLY; The contents for the workflow file to be generated
	Contents *string `json:"contents,omitempty"`
}

// StaticSitesWorkflowPreviewRequest request entity for previewing the Static Site workflow
type StaticSitesWorkflowPreviewRequest struct {
	// StaticSitesWorkflowPreviewRequestProperties - StaticSitesWorkflowPreviewRequest resource specific properties
	*StaticSitesWorkflowPreviewRequestProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSitesWorkflowPreviewRequest.
func (sswpr StaticSitesWorkflowPreviewRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sswpr.StaticSitesWorkflowPreviewRequestProperties != nil {
		objectMap["properties"] = sswpr.StaticSitesWorkflowPreviewRequestProperties
	}
	if sswpr.Kind != nil {
		objectMap["kind"] = sswpr.Kind
	}
	if sswpr.SystemData != nil {
		objectMap["systemData"] = sswpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSitesWorkflowPreviewRequest struct.
func (sswpr *StaticSitesWorkflowPreviewRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSitesWorkflowPreviewRequestProperties StaticSitesWorkflowPreviewRequestProperties
				err = json.Unmarshal(*v, &staticSitesWorkflowPreviewRequestProperties)
				if err != nil {
					return err
				}
				sswpr.StaticSitesWorkflowPreviewRequestProperties = &staticSitesWorkflowPreviewRequestProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sswpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sswpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sswpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sswpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sswpr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSitesWorkflowPreviewRequestProperties staticSitesWorkflowPreviewRequest resource specific
// properties
type StaticSitesWorkflowPreviewRequestProperties struct {
	// RepositoryURL - URL for the repository of the static site.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The target branch in the repository.
	Branch *string `json:"branch,omitempty"`
	// BuildProperties - Build properties to configure on the repository.
	BuildProperties *StaticSiteBuildProperties `json:"buildProperties,omitempty"`
}

// StaticSiteUserARMResource static Site User ARM resource.
type StaticSiteUserARMResource struct {
	autorest.Response `json:"-"`
	// StaticSiteUserARMResourceProperties - StaticSiteUserARMResource resource specific properties
	*StaticSiteUserARMResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteUserARMResource.
func (ssuar StaticSiteUserARMResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssuar.StaticSiteUserARMResourceProperties != nil {
		objectMap["properties"] = ssuar.StaticSiteUserARMResourceProperties
	}
	if ssuar.Kind != nil {
		objectMap["kind"] = ssuar.Kind
	}
	if ssuar.SystemData != nil {
		objectMap["systemData"] = ssuar.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteUserARMResource struct.
func (ssuar *StaticSiteUserARMResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteUserARMResourceProperties StaticSiteUserARMResourceProperties
				err = json.Unmarshal(*v, &staticSiteUserARMResourceProperties)
				if err != nil {
					return err
				}
				ssuar.StaticSiteUserARMResourceProperties = &staticSiteUserARMResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssuar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssuar.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssuar.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssuar.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssuar.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteUserARMResourceProperties staticSiteUserARMResource resource specific properties
type StaticSiteUserARMResourceProperties struct {
	// Provider - READ-ONLY; The identity provider for the static site user.
	Provider *string `json:"provider,omitempty"`
	// UserID - READ-ONLY; The user id for the static site user.
	UserID *string `json:"userId,omitempty"`
	// DisplayName - READ-ONLY; The display name for the static site user.
	DisplayName *string `json:"displayName,omitempty"`
	// Roles - The roles for the static site user, in free-form string format
	Roles *string `json:"roles,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteUserARMResourceProperties.
func (ssuar StaticSiteUserARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssuar.Roles != nil {
		objectMap["roles"] = ssuar.Roles
	}
	return json.Marshal(objectMap)
}

// StaticSiteUserCollection collection of static site custom users.
type StaticSiteUserCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]StaticSiteUserARMResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteUserCollection.
func (ssuc StaticSiteUserCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssuc.Value != nil {
		objectMap["value"] = ssuc.Value
	}
	return json.Marshal(objectMap)
}

// StaticSiteUserCollectionIterator provides access to a complete listing of StaticSiteUserARMResource
// values.
type StaticSiteUserCollectionIterator struct {
	i    int
	page StaticSiteUserCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StaticSiteUserCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteUserCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StaticSiteUserCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StaticSiteUserCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StaticSiteUserCollectionIterator) Response() StaticSiteUserCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StaticSiteUserCollectionIterator) Value() StaticSiteUserARMResource {
	if !iter.page.NotDone() {
		return StaticSiteUserARMResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StaticSiteUserCollectionIterator type.
func NewStaticSiteUserCollectionIterator(page StaticSiteUserCollectionPage) StaticSiteUserCollectionIterator {
	return StaticSiteUserCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ssuc StaticSiteUserCollection) IsEmpty() bool {
	return ssuc.Value == nil || len(*ssuc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ssuc StaticSiteUserCollection) hasNextLink() bool {
	return ssuc.NextLink != nil && len(*ssuc.NextLink) != 0
}

// staticSiteUserCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ssuc StaticSiteUserCollection) staticSiteUserCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ssuc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ssuc.NextLink)))
}

// StaticSiteUserCollectionPage contains a page of StaticSiteUserARMResource values.
type StaticSiteUserCollectionPage struct {
	fn   func(context.Context, StaticSiteUserCollection) (StaticSiteUserCollection, error)
	ssuc StaticSiteUserCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StaticSiteUserCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSiteUserCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ssuc)
		if err != nil {
			return err
		}
		page.ssuc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StaticSiteUserCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StaticSiteUserCollectionPage) NotDone() bool {
	return !page.ssuc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StaticSiteUserCollectionPage) Response() StaticSiteUserCollection {
	return page.ssuc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StaticSiteUserCollectionPage) Values() []StaticSiteUserARMResource {
	if page.ssuc.IsEmpty() {
		return nil
	}
	return *page.ssuc.Value
}

// Creates a new instance of the StaticSiteUserCollectionPage type.
func NewStaticSiteUserCollectionPage(cur StaticSiteUserCollection, getNextPage func(context.Context, StaticSiteUserCollection) (StaticSiteUserCollection, error)) StaticSiteUserCollectionPage {
	return StaticSiteUserCollectionPage{
		fn:   getNextPage,
		ssuc: cur,
	}
}

// StaticSiteUserInvitationRequestResource static sites user roles invitation resource.
type StaticSiteUserInvitationRequestResource struct {
	// StaticSiteUserInvitationRequestResourceProperties - StaticSiteUserInvitationRequestResource resource specific properties
	*StaticSiteUserInvitationRequestResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteUserInvitationRequestResource.
func (ssuirr StaticSiteUserInvitationRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssuirr.StaticSiteUserInvitationRequestResourceProperties != nil {
		objectMap["properties"] = ssuirr.StaticSiteUserInvitationRequestResourceProperties
	}
	if ssuirr.Kind != nil {
		objectMap["kind"] = ssuirr.Kind
	}
	if ssuirr.SystemData != nil {
		objectMap["systemData"] = ssuirr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteUserInvitationRequestResource struct.
func (ssuirr *StaticSiteUserInvitationRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteUserInvitationRequestResourceProperties StaticSiteUserInvitationRequestResourceProperties
				err = json.Unmarshal(*v, &staticSiteUserInvitationRequestResourceProperties)
				if err != nil {
					return err
				}
				ssuirr.StaticSiteUserInvitationRequestResourceProperties = &staticSiteUserInvitationRequestResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssuirr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssuirr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssuirr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssuirr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssuirr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteUserInvitationRequestResourceProperties staticSiteUserInvitationRequestResource resource
// specific properties
type StaticSiteUserInvitationRequestResourceProperties struct {
	// Domain - The domain name for the static site custom domain.
	Domain *string `json:"domain,omitempty"`
	// Provider - The identity provider for the static site user.
	Provider *string `json:"provider,omitempty"`
	// UserDetails - The user id for the static site user.
	UserDetails *string `json:"userDetails,omitempty"`
	// Roles - The roles for the static site user, in free-form string format
	Roles *string `json:"roles,omitempty"`
	// NumHoursToExpiration - The number of hours the sas token stays valid
	NumHoursToExpiration *int32 `json:"numHoursToExpiration,omitempty"`
}

// StaticSiteUserInvitationResponseResource static sites user roles invitation link resource.
type StaticSiteUserInvitationResponseResource struct {
	autorest.Response `json:"-"`
	// StaticSiteUserInvitationResponseResourceProperties - StaticSiteUserInvitationResponseResource resource specific properties
	*StaticSiteUserInvitationResponseResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StaticSiteUserInvitationResponseResource.
func (ssuirr StaticSiteUserInvitationResponseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssuirr.StaticSiteUserInvitationResponseResourceProperties != nil {
		objectMap["properties"] = ssuirr.StaticSiteUserInvitationResponseResourceProperties
	}
	if ssuirr.Kind != nil {
		objectMap["kind"] = ssuirr.Kind
	}
	if ssuirr.SystemData != nil {
		objectMap["systemData"] = ssuirr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StaticSiteUserInvitationResponseResource struct.
func (ssuirr *StaticSiteUserInvitationResponseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var staticSiteUserInvitationResponseResourceProperties StaticSiteUserInvitationResponseResourceProperties
				err = json.Unmarshal(*v, &staticSiteUserInvitationResponseResourceProperties)
				if err != nil {
					return err
				}
				ssuirr.StaticSiteUserInvitationResponseResourceProperties = &staticSiteUserInvitationResponseResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssuirr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssuirr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ssuirr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssuirr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ssuirr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StaticSiteUserInvitationResponseResourceProperties staticSiteUserInvitationResponseResource resource
// specific properties
type StaticSiteUserInvitationResponseResourceProperties struct {
	// ExpiresOn - READ-ONLY; The expiration time of the invitation
	ExpiresOn *date.Time `json:"expiresOn,omitempty"`
	// InvitationURL - READ-ONLY; The url for the invitation link
	InvitationURL *string `json:"invitationUrl,omitempty"`
}

// StatusCodesBasedTrigger trigger based on status code.
type StatusCodesBasedTrigger struct {
	// Status - HTTP status code.
	Status *int32 `json:"status,omitempty"`
	// SubStatus - Request Sub Status.
	SubStatus *int32 `json:"subStatus,omitempty"`
	// Win32Status - Win32 error code.
	Win32Status *int32 `json:"win32Status,omitempty"`
	// Count - Request Count.
	Count *int32 `json:"count,omitempty"`
	// TimeInterval - Time interval.
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StorageMigrationOptions options for app content migration.
type StorageMigrationOptions struct {
	// StorageMigrationOptionsProperties - StorageMigrationOptions resource specific properties
	*StorageMigrationOptionsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageMigrationOptions.
func (smo StorageMigrationOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smo.StorageMigrationOptionsProperties != nil {
		objectMap["properties"] = smo.StorageMigrationOptionsProperties
	}
	if smo.Kind != nil {
		objectMap["kind"] = smo.Kind
	}
	if smo.SystemData != nil {
		objectMap["systemData"] = smo.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageMigrationOptions struct.
func (smo *StorageMigrationOptions) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageMigrationOptionsProperties StorageMigrationOptionsProperties
				err = json.Unmarshal(*v, &storageMigrationOptionsProperties)
				if err != nil {
					return err
				}
				smo.StorageMigrationOptionsProperties = &storageMigrationOptionsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smo.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				smo.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smo.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				smo.SystemData = &systemData
			}
		}
	}

	return nil
}

// StorageMigrationOptionsProperties storageMigrationOptions resource specific properties
type StorageMigrationOptionsProperties struct {
	// AzurefilesConnectionString - AzureFiles connection string.
	AzurefilesConnectionString *string `json:"azurefilesConnectionString,omitempty"`
	// AzurefilesShare - AzureFiles share.
	AzurefilesShare *string `json:"azurefilesShare,omitempty"`
	// SwitchSiteAfterMigration - <code>true</code>if the app should be switched over; otherwise, <code>false</code>.
	SwitchSiteAfterMigration *bool `json:"switchSiteAfterMigration,omitempty"`
	// BlockWriteAccessToSite - <code>true</code> if the app should be read only during copy operation; otherwise, <code>false</code>.
	BlockWriteAccessToSite *bool `json:"blockWriteAccessToSite,omitempty"`
}

// StorageMigrationResponse response for a migration of app content request.
type StorageMigrationResponse struct {
	autorest.Response `json:"-"`
	// StorageMigrationResponseProperties - StorageMigrationResponse resource specific properties
	*StorageMigrationResponseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageMigrationResponse.
func (smr StorageMigrationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smr.StorageMigrationResponseProperties != nil {
		objectMap["properties"] = smr.StorageMigrationResponseProperties
	}
	if smr.Kind != nil {
		objectMap["kind"] = smr.Kind
	}
	if smr.SystemData != nil {
		objectMap["systemData"] = smr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StorageMigrationResponse struct.
func (smr *StorageMigrationResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var storageMigrationResponseProperties StorageMigrationResponseProperties
				err = json.Unmarshal(*v, &storageMigrationResponseProperties)
				if err != nil {
					return err
				}
				smr.StorageMigrationResponseProperties = &storageMigrationResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				smr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				smr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				smr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				smr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				smr.SystemData = &systemData
			}
		}
	}

	return nil
}

// StorageMigrationResponseProperties storageMigrationResponse resource specific properties
type StorageMigrationResponseProperties struct {
	// OperationID - READ-ONLY; When server starts the migration process, it will return an operation ID identifying that particular migration operation.
	OperationID *string `json:"operationId,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// StringDictionary string dictionary resource.
type StringDictionary struct {
	autorest.Response `json:"-"`
	// Properties - Settings.
	Properties map[string]*string `json:"properties"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for StringDictionary.
func (sd StringDictionary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.Properties != nil {
		objectMap["properties"] = sd.Properties
	}
	if sd.Kind != nil {
		objectMap["kind"] = sd.Kind
	}
	if sd.SystemData != nil {
		objectMap["systemData"] = sd.SystemData
	}
	return json.Marshal(objectMap)
}

// SwiftVirtualNetwork swift Virtual Network Contract. This is used to enable the new Swift way of doing
// virtual network integration.
type SwiftVirtualNetwork struct {
	autorest.Response `json:"-"`
	// SwiftVirtualNetworkProperties - SwiftVirtualNetwork resource specific properties
	*SwiftVirtualNetworkProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for SwiftVirtualNetwork.
func (svn SwiftVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if svn.SwiftVirtualNetworkProperties != nil {
		objectMap["properties"] = svn.SwiftVirtualNetworkProperties
	}
	if svn.Kind != nil {
		objectMap["kind"] = svn.Kind
	}
	if svn.SystemData != nil {
		objectMap["systemData"] = svn.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SwiftVirtualNetwork struct.
func (svn *SwiftVirtualNetwork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var swiftVirtualNetworkProperties SwiftVirtualNetworkProperties
				err = json.Unmarshal(*v, &swiftVirtualNetworkProperties)
				if err != nil {
					return err
				}
				svn.SwiftVirtualNetworkProperties = &swiftVirtualNetworkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				svn.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				svn.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				svn.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				svn.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				svn.SystemData = &systemData
			}
		}
	}

	return nil
}

// SwiftVirtualNetworkProperties swiftVirtualNetwork resource specific properties
type SwiftVirtualNetworkProperties struct {
	// SubnetResourceID - The Virtual Network subnet's resource ID. This is the subnet that this Web App will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
	// SwiftSupported - A flag that specifies if the scale unit this Web App is on supports Swift integration.
	SwiftSupported *bool `json:"swiftSupported,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TldLegalAgreement legal agreement for a top level domain.
type TldLegalAgreement struct {
	// AgreementKey - Unique identifier for the agreement.
	AgreementKey *string `json:"agreementKey,omitempty"`
	// Title - Agreement title.
	Title *string `json:"title,omitempty"`
	// Content - Agreement details.
	Content *string `json:"content,omitempty"`
	// URL - URL where a copy of the agreement details is hosted.
	URL *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection collection of top-level domain legal agreements.
type TldLegalAgreementCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TldLegalAgreement `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TldLegalAgreementCollection.
func (tlac TldLegalAgreementCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tlac.Value != nil {
		objectMap["value"] = tlac.Value
	}
	return json.Marshal(objectMap)
}

// TldLegalAgreementCollectionIterator provides access to a complete listing of TldLegalAgreement values.
type TldLegalAgreementCollectionIterator struct {
	i    int
	page TldLegalAgreementCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TldLegalAgreementCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TldLegalAgreementCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TldLegalAgreementCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TldLegalAgreementCollectionIterator) Response() TldLegalAgreementCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TldLegalAgreementCollectionIterator) Value() TldLegalAgreement {
	if !iter.page.NotDone() {
		return TldLegalAgreement{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TldLegalAgreementCollectionIterator type.
func NewTldLegalAgreementCollectionIterator(page TldLegalAgreementCollectionPage) TldLegalAgreementCollectionIterator {
	return TldLegalAgreementCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlac TldLegalAgreementCollection) IsEmpty() bool {
	return tlac.Value == nil || len(*tlac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlac TldLegalAgreementCollection) hasNextLink() bool {
	return tlac.NextLink != nil && len(*tlac.NextLink) != 0
}

// tldLegalAgreementCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlac TldLegalAgreementCollection) tldLegalAgreementCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tlac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlac.NextLink)))
}

// TldLegalAgreementCollectionPage contains a page of TldLegalAgreement values.
type TldLegalAgreementCollectionPage struct {
	fn   func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)
	tlac TldLegalAgreementCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TldLegalAgreementCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TldLegalAgreementCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlac)
		if err != nil {
			return err
		}
		page.tlac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TldLegalAgreementCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TldLegalAgreementCollectionPage) NotDone() bool {
	return !page.tlac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TldLegalAgreementCollectionPage) Response() TldLegalAgreementCollection {
	return page.tlac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TldLegalAgreementCollectionPage) Values() []TldLegalAgreement {
	if page.tlac.IsEmpty() {
		return nil
	}
	return *page.tlac.Value
}

// Creates a new instance of the TldLegalAgreementCollectionPage type.
func NewTldLegalAgreementCollectionPage(cur TldLegalAgreementCollection, getNextPage func(context.Context, TldLegalAgreementCollection) (TldLegalAgreementCollection, error)) TldLegalAgreementCollectionPage {
	return TldLegalAgreementCollectionPage{
		fn:   getNextPage,
		tlac: cur,
	}
}

// TokenStore ...
type TokenStore struct {
	// TokenStoreProperties - TokenStore resource specific properties
	*TokenStoreProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TokenStore.
func (ts TokenStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ts.TokenStoreProperties != nil {
		objectMap["properties"] = ts.TokenStoreProperties
	}
	if ts.Kind != nil {
		objectMap["kind"] = ts.Kind
	}
	if ts.SystemData != nil {
		objectMap["systemData"] = ts.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TokenStore struct.
func (ts *TokenStore) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tokenStoreProperties TokenStoreProperties
				err = json.Unmarshal(*v, &tokenStoreProperties)
				if err != nil {
					return err
				}
				ts.TokenStoreProperties = &tokenStoreProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ts.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ts.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ts.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ts.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ts.SystemData = &systemData
			}
		}
	}

	return nil
}

// TokenStoreProperties tokenStore resource specific properties
type TokenStoreProperties struct {
	Enabled                    *bool                  `json:"enabled,omitempty"`
	TokenRefreshExtensionHours *float64               `json:"tokenRefreshExtensionHours,omitempty"`
	FileSystem                 *FileSystemTokenStore  `json:"fileSystem,omitempty"`
	AzureBlobStorage           *BlobStorageTokenStore `json:"azureBlobStorage,omitempty"`
}

// TopLevelDomain a top level domain object.
type TopLevelDomain struct {
	autorest.Response `json:"-"`
	// TopLevelDomainProperties - TopLevelDomain resource specific properties
	*TopLevelDomainProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TopLevelDomain.
func (tld TopLevelDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tld.TopLevelDomainProperties != nil {
		objectMap["properties"] = tld.TopLevelDomainProperties
	}
	if tld.Kind != nil {
		objectMap["kind"] = tld.Kind
	}
	if tld.SystemData != nil {
		objectMap["systemData"] = tld.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TopLevelDomain struct.
func (tld *TopLevelDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var topLevelDomainProperties TopLevelDomainProperties
				err = json.Unmarshal(*v, &topLevelDomainProperties)
				if err != nil {
					return err
				}
				tld.TopLevelDomainProperties = &topLevelDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tld.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tld.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tld.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tld.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				tld.SystemData = &systemData
			}
		}
	}

	return nil
}

// TopLevelDomainAgreementOption options for retrieving the list of top level domain legal agreements.
type TopLevelDomainAgreementOption struct {
	// IncludePrivacy - If <code>true</code>, then the list of agreements will include agreements for domain privacy as well; otherwise, <code>false</code>.
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
	// ForTransfer - If <code>true</code>, then the list of agreements will include agreements for domain transfer as well; otherwise, <code>false</code>.
	ForTransfer *bool `json:"forTransfer,omitempty"`
}

// TopLevelDomainCollection collection of Top-level domains.
type TopLevelDomainCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TopLevelDomain `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TopLevelDomainCollection.
func (tldc TopLevelDomainCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tldc.Value != nil {
		objectMap["value"] = tldc.Value
	}
	return json.Marshal(objectMap)
}

// TopLevelDomainCollectionIterator provides access to a complete listing of TopLevelDomain values.
type TopLevelDomainCollectionIterator struct {
	i    int
	page TopLevelDomainCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TopLevelDomainCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TopLevelDomainCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TopLevelDomainCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TopLevelDomainCollectionIterator) Response() TopLevelDomainCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TopLevelDomainCollectionIterator) Value() TopLevelDomain {
	if !iter.page.NotDone() {
		return TopLevelDomain{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TopLevelDomainCollectionIterator type.
func NewTopLevelDomainCollectionIterator(page TopLevelDomainCollectionPage) TopLevelDomainCollectionIterator {
	return TopLevelDomainCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tldc TopLevelDomainCollection) IsEmpty() bool {
	return tldc.Value == nil || len(*tldc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tldc TopLevelDomainCollection) hasNextLink() bool {
	return tldc.NextLink != nil && len(*tldc.NextLink) != 0
}

// topLevelDomainCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tldc TopLevelDomainCollection) topLevelDomainCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tldc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tldc.NextLink)))
}

// TopLevelDomainCollectionPage contains a page of TopLevelDomain values.
type TopLevelDomainCollectionPage struct {
	fn   func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)
	tldc TopLevelDomainCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TopLevelDomainCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TopLevelDomainCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tldc)
		if err != nil {
			return err
		}
		page.tldc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TopLevelDomainCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TopLevelDomainCollectionPage) NotDone() bool {
	return !page.tldc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TopLevelDomainCollectionPage) Response() TopLevelDomainCollection {
	return page.tldc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TopLevelDomainCollectionPage) Values() []TopLevelDomain {
	if page.tldc.IsEmpty() {
		return nil
	}
	return *page.tldc.Value
}

// Creates a new instance of the TopLevelDomainCollectionPage type.
func NewTopLevelDomainCollectionPage(cur TopLevelDomainCollection, getNextPage func(context.Context, TopLevelDomainCollection) (TopLevelDomainCollection, error)) TopLevelDomainCollectionPage {
	return TopLevelDomainCollectionPage{
		fn:   getNextPage,
		tldc: cur,
	}
}

// TopLevelDomainProperties topLevelDomain resource specific properties
type TopLevelDomainProperties struct {
	// Privacy - If <code>true</code>, then the top level domain supports domain privacy; otherwise, <code>false</code>.
	Privacy *bool `json:"privacy,omitempty"`
}

// TriggeredJobHistory triggered Web Job History. List of Triggered Web Job Run Information elements.
type TriggeredJobHistory struct {
	autorest.Response `json:"-"`
	// TriggeredJobHistoryProperties - TriggeredJobHistory resource specific properties
	*TriggeredJobHistoryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredJobHistory.
func (tjh TriggeredJobHistory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjh.TriggeredJobHistoryProperties != nil {
		objectMap["properties"] = tjh.TriggeredJobHistoryProperties
	}
	if tjh.Kind != nil {
		objectMap["kind"] = tjh.Kind
	}
	if tjh.SystemData != nil {
		objectMap["systemData"] = tjh.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredJobHistory struct.
func (tjh *TriggeredJobHistory) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredJobHistoryProperties TriggeredJobHistoryProperties
				err = json.Unmarshal(*v, &triggeredJobHistoryProperties)
				if err != nil {
					return err
				}
				tjh.TriggeredJobHistoryProperties = &triggeredJobHistoryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tjh.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tjh.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tjh.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tjh.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				tjh.SystemData = &systemData
			}
		}
	}

	return nil
}

// TriggeredJobHistoryCollection collection of Kudu continuous web job information elements.
type TriggeredJobHistoryCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TriggeredJobHistory `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredJobHistoryCollection.
func (tjhc TriggeredJobHistoryCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjhc.Value != nil {
		objectMap["value"] = tjhc.Value
	}
	return json.Marshal(objectMap)
}

// TriggeredJobHistoryCollectionIterator provides access to a complete listing of TriggeredJobHistory
// values.
type TriggeredJobHistoryCollectionIterator struct {
	i    int
	page TriggeredJobHistoryCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggeredJobHistoryCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredJobHistoryCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggeredJobHistoryCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggeredJobHistoryCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggeredJobHistoryCollectionIterator) Response() TriggeredJobHistoryCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggeredJobHistoryCollectionIterator) Value() TriggeredJobHistory {
	if !iter.page.NotDone() {
		return TriggeredJobHistory{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggeredJobHistoryCollectionIterator type.
func NewTriggeredJobHistoryCollectionIterator(page TriggeredJobHistoryCollectionPage) TriggeredJobHistoryCollectionIterator {
	return TriggeredJobHistoryCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tjhc TriggeredJobHistoryCollection) IsEmpty() bool {
	return tjhc.Value == nil || len(*tjhc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tjhc TriggeredJobHistoryCollection) hasNextLink() bool {
	return tjhc.NextLink != nil && len(*tjhc.NextLink) != 0
}

// triggeredJobHistoryCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tjhc TriggeredJobHistoryCollection) triggeredJobHistoryCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tjhc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tjhc.NextLink)))
}

// TriggeredJobHistoryCollectionPage contains a page of TriggeredJobHistory values.
type TriggeredJobHistoryCollectionPage struct {
	fn   func(context.Context, TriggeredJobHistoryCollection) (TriggeredJobHistoryCollection, error)
	tjhc TriggeredJobHistoryCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggeredJobHistoryCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredJobHistoryCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tjhc)
		if err != nil {
			return err
		}
		page.tjhc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggeredJobHistoryCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggeredJobHistoryCollectionPage) NotDone() bool {
	return !page.tjhc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggeredJobHistoryCollectionPage) Response() TriggeredJobHistoryCollection {
	return page.tjhc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggeredJobHistoryCollectionPage) Values() []TriggeredJobHistory {
	if page.tjhc.IsEmpty() {
		return nil
	}
	return *page.tjhc.Value
}

// Creates a new instance of the TriggeredJobHistoryCollectionPage type.
func NewTriggeredJobHistoryCollectionPage(cur TriggeredJobHistoryCollection, getNextPage func(context.Context, TriggeredJobHistoryCollection) (TriggeredJobHistoryCollection, error)) TriggeredJobHistoryCollectionPage {
	return TriggeredJobHistoryCollectionPage{
		fn:   getNextPage,
		tjhc: cur,
	}
}

// TriggeredJobHistoryProperties triggeredJobHistory resource specific properties
type TriggeredJobHistoryProperties struct {
	// Runs - List of triggered web job runs.
	Runs *[]TriggeredJobRun `json:"runs,omitempty"`
}

// TriggeredJobRun triggered Web Job Run Information.
type TriggeredJobRun struct {
	// TriggeredJobRunProperties - TriggeredJobRun resource specific properties
	*TriggeredJobRunProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredJobRun.
func (tjr TriggeredJobRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tjr.TriggeredJobRunProperties != nil {
		objectMap["properties"] = tjr.TriggeredJobRunProperties
	}
	if tjr.Kind != nil {
		objectMap["kind"] = tjr.Kind
	}
	if tjr.SystemData != nil {
		objectMap["systemData"] = tjr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredJobRun struct.
func (tjr *TriggeredJobRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredJobRunProperties TriggeredJobRunProperties
				err = json.Unmarshal(*v, &triggeredJobRunProperties)
				if err != nil {
					return err
				}
				tjr.TriggeredJobRunProperties = &triggeredJobRunProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tjr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tjr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tjr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tjr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				tjr.SystemData = &systemData
			}
		}
	}

	return nil
}

// TriggeredJobRunProperties triggeredJobRun resource specific properties
type TriggeredJobRunProperties struct {
	// WebJobID - Job ID.
	WebJobID *string `json:"web_job_id,omitempty"`
	// WebJobName - Job name.
	WebJobName *string `json:"web_job_name,omitempty"`
	// Status - Job status. Possible values include: 'TriggeredWebJobStatusSuccess', 'TriggeredWebJobStatusFailed', 'TriggeredWebJobStatusError'
	Status TriggeredWebJobStatus `json:"status,omitempty"`
	// StartTime - Start time.
	StartTime *date.Time `json:"start_time,omitempty"`
	// EndTime - End time.
	EndTime *date.Time `json:"end_time,omitempty"`
	// Duration - Job duration.
	Duration *string `json:"duration,omitempty"`
	// OutputURL - Output URL.
	OutputURL *string `json:"output_url,omitempty"`
	// ErrorURL - Error URL.
	ErrorURL *string `json:"error_url,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// JobName - Job name.
	JobName *string `json:"job_name,omitempty"`
	// Trigger - Job trigger.
	Trigger *string `json:"trigger,omitempty"`
}

// TriggeredWebJob triggered Web Job Information.
type TriggeredWebJob struct {
	autorest.Response `json:"-"`
	// TriggeredWebJobProperties - TriggeredWebJob resource specific properties
	*TriggeredWebJobProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredWebJob.
func (twj TriggeredWebJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if twj.TriggeredWebJobProperties != nil {
		objectMap["properties"] = twj.TriggeredWebJobProperties
	}
	if twj.Kind != nil {
		objectMap["kind"] = twj.Kind
	}
	if twj.SystemData != nil {
		objectMap["systemData"] = twj.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TriggeredWebJob struct.
func (twj *TriggeredWebJob) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var triggeredWebJobProperties TriggeredWebJobProperties
				err = json.Unmarshal(*v, &triggeredWebJobProperties)
				if err != nil {
					return err
				}
				twj.TriggeredWebJobProperties = &triggeredWebJobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				twj.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				twj.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				twj.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				twj.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				twj.SystemData = &systemData
			}
		}
	}

	return nil
}

// TriggeredWebJobCollection collection of Kudu continuous web job information elements.
type TriggeredWebJobCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]TriggeredWebJob `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TriggeredWebJobCollection.
func (twjc TriggeredWebJobCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if twjc.Value != nil {
		objectMap["value"] = twjc.Value
	}
	return json.Marshal(objectMap)
}

// TriggeredWebJobCollectionIterator provides access to a complete listing of TriggeredWebJob values.
type TriggeredWebJobCollectionIterator struct {
	i    int
	page TriggeredWebJobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TriggeredWebJobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredWebJobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TriggeredWebJobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TriggeredWebJobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TriggeredWebJobCollectionIterator) Response() TriggeredWebJobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TriggeredWebJobCollectionIterator) Value() TriggeredWebJob {
	if !iter.page.NotDone() {
		return TriggeredWebJob{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TriggeredWebJobCollectionIterator type.
func NewTriggeredWebJobCollectionIterator(page TriggeredWebJobCollectionPage) TriggeredWebJobCollectionIterator {
	return TriggeredWebJobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (twjc TriggeredWebJobCollection) IsEmpty() bool {
	return twjc.Value == nil || len(*twjc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (twjc TriggeredWebJobCollection) hasNextLink() bool {
	return twjc.NextLink != nil && len(*twjc.NextLink) != 0
}

// triggeredWebJobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (twjc TriggeredWebJobCollection) triggeredWebJobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !twjc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(twjc.NextLink)))
}

// TriggeredWebJobCollectionPage contains a page of TriggeredWebJob values.
type TriggeredWebJobCollectionPage struct {
	fn   func(context.Context, TriggeredWebJobCollection) (TriggeredWebJobCollection, error)
	twjc TriggeredWebJobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TriggeredWebJobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TriggeredWebJobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.twjc)
		if err != nil {
			return err
		}
		page.twjc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TriggeredWebJobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TriggeredWebJobCollectionPage) NotDone() bool {
	return !page.twjc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TriggeredWebJobCollectionPage) Response() TriggeredWebJobCollection {
	return page.twjc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TriggeredWebJobCollectionPage) Values() []TriggeredWebJob {
	if page.twjc.IsEmpty() {
		return nil
	}
	return *page.twjc.Value
}

// Creates a new instance of the TriggeredWebJobCollectionPage type.
func NewTriggeredWebJobCollectionPage(cur TriggeredWebJobCollection, getNextPage func(context.Context, TriggeredWebJobCollection) (TriggeredWebJobCollection, error)) TriggeredWebJobCollectionPage {
	return TriggeredWebJobCollectionPage{
		fn:   getNextPage,
		twjc: cur,
	}
}

// TriggeredWebJobProperties triggeredWebJob resource specific properties
type TriggeredWebJobProperties struct {
	// LatestRun - Latest job run information.
	LatestRun *TriggeredJobRun `json:"latest_run,omitempty"`
	// HistoryURL - History URL.
	HistoryURL *string `json:"history_url,omitempty"`
	// SchedulerLogsURL - Scheduler Logs URL.
	SchedulerLogsURL *string `json:"scheduler_logs_url,omitempty"`
	// RunCommand - Run command.
	RunCommand *string `json:"run_command,omitempty"`
	// URL - Job URL.
	URL *string `json:"url,omitempty"`
	// ExtraInfoURL - Extra Info URL.
	ExtraInfoURL *string `json:"extra_info_url,omitempty"`
	// WebJobType - Job type. Possible values include: 'Continuous', 'Triggered'
	WebJobType JobType `json:"web_job_type,omitempty"`
	// Error - Error information.
	Error *string `json:"error,omitempty"`
	// UsingSdk - Using SDK?
	UsingSdk *bool `json:"using_sdk,omitempty"`
	// Settings - Job settings.
	Settings map[string]interface{} `json:"settings"`
}

// MarshalJSON is the custom marshaler for TriggeredWebJobProperties.
func (twj TriggeredWebJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if twj.LatestRun != nil {
		objectMap["latest_run"] = twj.LatestRun
	}
	if twj.HistoryURL != nil {
		objectMap["history_url"] = twj.HistoryURL
	}
	if twj.SchedulerLogsURL != nil {
		objectMap["scheduler_logs_url"] = twj.SchedulerLogsURL
	}
	if twj.RunCommand != nil {
		objectMap["run_command"] = twj.RunCommand
	}
	if twj.URL != nil {
		objectMap["url"] = twj.URL
	}
	if twj.ExtraInfoURL != nil {
		objectMap["extra_info_url"] = twj.ExtraInfoURL
	}
	if twj.WebJobType != "" {
		objectMap["web_job_type"] = twj.WebJobType
	}
	if twj.Error != nil {
		objectMap["error"] = twj.Error
	}
	if twj.UsingSdk != nil {
		objectMap["using_sdk"] = twj.UsingSdk
	}
	if twj.Settings != nil {
		objectMap["settings"] = twj.Settings
	}
	return json.Marshal(objectMap)
}

// Twitter ...
type Twitter struct {
	// TwitterProperties - Twitter resource specific properties
	*TwitterProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Twitter.
func (t Twitter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TwitterProperties != nil {
		objectMap["properties"] = t.TwitterProperties
	}
	if t.Kind != nil {
		objectMap["kind"] = t.Kind
	}
	if t.SystemData != nil {
		objectMap["systemData"] = t.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Twitter struct.
func (t *Twitter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var twitterProperties TwitterProperties
				err = json.Unmarshal(*v, &twitterProperties)
				if err != nil {
					return err
				}
				t.TwitterProperties = &twitterProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				t.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				t.SystemData = &systemData
			}
		}
	}

	return nil
}

// TwitterProperties twitter resource specific properties
type TwitterProperties struct {
	Enabled      *bool                `json:"enabled,omitempty"`
	Registration *TwitterRegistration `json:"registration,omitempty"`
}

// TwitterRegistration ...
type TwitterRegistration struct {
	// TwitterRegistrationProperties - TwitterRegistration resource specific properties
	*TwitterRegistrationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TwitterRegistration.
func (tr TwitterRegistration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.TwitterRegistrationProperties != nil {
		objectMap["properties"] = tr.TwitterRegistrationProperties
	}
	if tr.Kind != nil {
		objectMap["kind"] = tr.Kind
	}
	if tr.SystemData != nil {
		objectMap["systemData"] = tr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TwitterRegistration struct.
func (tr *TwitterRegistration) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var twitterRegistrationProperties TwitterRegistrationProperties
				err = json.Unmarshal(*v, &twitterRegistrationProperties)
				if err != nil {
					return err
				}
				tr.TwitterRegistrationProperties = &twitterRegistrationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				tr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				tr.SystemData = &systemData
			}
		}
	}

	return nil
}

// TwitterRegistrationProperties twitterRegistration resource specific properties
type TwitterRegistrationProperties struct {
	ConsumerKey               *string `json:"consumerKey,omitempty"`
	ConsumerSecretSettingName *string `json:"consumerSecretSettingName,omitempty"`
}

// Usage usage of the quota resource.
type Usage struct {
	// UsageProperties - Usage resource specific properties
	*UsageProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UsageProperties != nil {
		objectMap["properties"] = u.UsageProperties
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.SystemData != nil {
		objectMap["systemData"] = u.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Usage struct.
func (u *Usage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var usageProperties UsageProperties
				err = json.Unmarshal(*v, &usageProperties)
				if err != nil {
					return err
				}
				u.UsageProperties = &usageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				u.SystemData = &systemData
			}
		}
	}

	return nil
}

// UsageCollection collection of usages.
type UsageCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]Usage `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for UsageCollection.
func (uc UsageCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uc.Value != nil {
		objectMap["value"] = uc.Value
	}
	return json.Marshal(objectMap)
}

// UsageCollectionIterator provides access to a complete listing of Usage values.
type UsageCollectionIterator struct {
	i    int
	page UsageCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UsageCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UsageCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UsageCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UsageCollectionIterator) Response() UsageCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UsageCollectionIterator) Value() Usage {
	if !iter.page.NotDone() {
		return Usage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UsageCollectionIterator type.
func NewUsageCollectionIterator(page UsageCollectionPage) UsageCollectionIterator {
	return UsageCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (uc UsageCollection) IsEmpty() bool {
	return uc.Value == nil || len(*uc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (uc UsageCollection) hasNextLink() bool {
	return uc.NextLink != nil && len(*uc.NextLink) != 0
}

// usageCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (uc UsageCollection) usageCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !uc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(uc.NextLink)))
}

// UsageCollectionPage contains a page of Usage values.
type UsageCollectionPage struct {
	fn func(context.Context, UsageCollection) (UsageCollection, error)
	uc UsageCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UsageCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UsageCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.uc)
		if err != nil {
			return err
		}
		page.uc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UsageCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UsageCollectionPage) NotDone() bool {
	return !page.uc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UsageCollectionPage) Response() UsageCollection {
	return page.uc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UsageCollectionPage) Values() []Usage {
	if page.uc.IsEmpty() {
		return nil
	}
	return *page.uc.Value
}

// Creates a new instance of the UsageCollectionPage type.
func NewUsageCollectionPage(cur UsageCollection, getNextPage func(context.Context, UsageCollection) (UsageCollection, error)) UsageCollectionPage {
	return UsageCollectionPage{
		fn: getNextPage,
		uc: cur,
	}
}

// UsageProperties usage resource specific properties
type UsageProperties struct {
	// DisplayName - READ-ONLY; Friendly name shown in the UI.
	DisplayName *string `json:"displayName,omitempty"`
	// ResourceName - READ-ONLY; Name of the quota resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// Unit - READ-ONLY; Units of measurement for the quota resource.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - READ-ONLY; The current value of the resource counter.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Limit - READ-ONLY; The resource limit.
	Limit *int64 `json:"limit,omitempty"`
	// NextResetTime - READ-ONLY; Next reset time for the resource counter.
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
	// ComputeMode - READ-ONLY; Compute mode used for this usage. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// SiteMode - READ-ONLY; Site mode used for this usage.
	SiteMode *string `json:"siteMode,omitempty"`
}

// User user credentials used for publishing activity.
type User struct {
	autorest.Response `json:"-"`
	// UserProperties - User resource specific properties
	*UserProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.UserProperties != nil {
		objectMap["properties"] = u.UserProperties
	}
	if u.Kind != nil {
		objectMap["kind"] = u.Kind
	}
	if u.SystemData != nil {
		objectMap["systemData"] = u.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for User struct.
func (u *User) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var userProperties UserProperties
				err = json.Unmarshal(*v, &userProperties)
				if err != nil {
					return err
				}
				u.UserProperties = &userProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				u.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				u.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				u.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				u.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				u.SystemData = &systemData
			}
		}
	}

	return nil
}

// UserProperties user resource specific properties
type UserProperties struct {
	// PublishingUserName - Username used for publishing.
	PublishingUserName *string `json:"publishingUserName,omitempty"`
	// PublishingPassword - Password used for publishing.
	PublishingPassword *string `json:"publishingPassword,omitempty"`
	// PublishingPasswordHash - Password hash used for publishing.
	PublishingPasswordHash *string `json:"publishingPasswordHash,omitempty"`
	// PublishingPasswordHashSalt - Password hash salt used for publishing.
	PublishingPasswordHashSalt *string `json:"publishingPasswordHashSalt,omitempty"`
	// ScmURI - Url of SCM site.
	ScmURI *string `json:"scmUri,omitempty"`
}

// ValidateProperties app properties used for validation.
type ValidateProperties struct {
	// ServerFarmID - ARM resource ID of an App Service plan that would host the app.
	ServerFarmID *string `json:"serverFarmId,omitempty"`
	// SkuName - Name of the target SKU for the App Service plan.
	SkuName *string `json:"skuName,omitempty"`
	// NeedLinuxWorkers - <code>true</code> if App Service plan is for Linux workers; otherwise, <code>false</code>.
	NeedLinuxWorkers *bool `json:"needLinuxWorkers,omitempty"`
	// IsSpot - <code>true</code> if App Service plan is for Spot instances; otherwise, <code>false</code>.
	IsSpot *bool `json:"isSpot,omitempty"`
	// Capacity - Target capacity of the App Service plan (number of VMs).
	Capacity *int32 `json:"capacity,omitempty"`
	// HostingEnvironment - Name of App Service Environment where app or App Service plan should be created.
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
	// IsXenon - <code>true</code> if App Service plan is running as a windows container
	IsXenon *bool `json:"isXenon,omitempty"`
	// ContainerRegistryBaseURL - Base URL of the container registry
	ContainerRegistryBaseURL *string `json:"containerRegistryBaseUrl,omitempty"`
	// ContainerRegistryUsername - Username for to access the container registry
	ContainerRegistryUsername *string `json:"containerRegistryUsername,omitempty"`
	// ContainerRegistryPassword - Password for to access the container registry
	ContainerRegistryPassword *string `json:"containerRegistryPassword,omitempty"`
	// ContainerImageRepository - Repository name (image name)
	ContainerImageRepository *string `json:"containerImageRepository,omitempty"`
	// ContainerImageTag - Image tag
	ContainerImageTag *string `json:"containerImageTag,omitempty"`
	// ContainerImagePlatform - Platform (windows or linux)
	ContainerImagePlatform *string `json:"containerImagePlatform,omitempty"`
}

// ValidateRequest resource validation request content.
type ValidateRequest struct {
	// Name - Resource name to verify.
	Name *string `json:"name,omitempty"`
	// Type - Resource type used for verification. Possible values include: 'ValidateResourceTypesServerFarm', 'ValidateResourceTypesSite'
	Type ValidateResourceTypes `json:"type,omitempty"`
	// Location - Expected location of the resource.
	Location *string `json:"location,omitempty"`
	// ValidateProperties - Properties of the resource to validate.
	*ValidateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateRequest.
func (vr ValidateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.Name != nil {
		objectMap["name"] = vr.Name
	}
	if vr.Type != "" {
		objectMap["type"] = vr.Type
	}
	if vr.Location != nil {
		objectMap["location"] = vr.Location
	}
	if vr.ValidateProperties != nil {
		objectMap["properties"] = vr.ValidateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ValidateRequest struct.
func (vr *ValidateRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar ValidateResourceTypes
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vr.Location = &location
			}
		case "properties":
			if v != nil {
				var validateProperties ValidateProperties
				err = json.Unmarshal(*v, &validateProperties)
				if err != nil {
					return err
				}
				vr.ValidateProperties = &validateProperties
			}
		}
	}

	return nil
}

// ValidateResponse describes the result of resource validation.
type ValidateResponse struct {
	autorest.Response `json:"-"`
	// Status - Result of validation.
	Status *string `json:"status,omitempty"`
	// Error - Error details for the case when validation fails.
	Error *ValidateResponseError `json:"error,omitempty"`
}

// ValidateResponseError error details for when validation fails.
type ValidateResponseError struct {
	// Code - Validation error code.
	Code *string `json:"code,omitempty"`
	// Message - Validation error message.
	Message *string `json:"message,omitempty"`
}

// VirtualApplication virtual application in an app.
type VirtualApplication struct {
	// VirtualPath - Virtual path.
	VirtualPath *string `json:"virtualPath,omitempty"`
	// PhysicalPath - Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`
	// PreloadEnabled - <code>true</code> if preloading is enabled; otherwise, <code>false</code>.
	PreloadEnabled *bool `json:"preloadEnabled,omitempty"`
	// VirtualDirectories - Virtual directories for virtual application.
	VirtualDirectories *[]VirtualDirectory `json:"virtualDirectories,omitempty"`
}

// VirtualDirectory directory for virtual application.
type VirtualDirectory struct {
	// VirtualPath - Path to virtual application.
	VirtualPath *string `json:"virtualPath,omitempty"`
	// PhysicalPath - Physical path.
	PhysicalPath *string `json:"physicalPath,omitempty"`
}

// VirtualIPMapping virtual IP mapping.
type VirtualIPMapping struct {
	// VirtualIP - Virtual IP address.
	VirtualIP *string `json:"virtualIP,omitempty"`
	// InternalHTTPPort - Internal HTTP port.
	InternalHTTPPort *int32 `json:"internalHttpPort,omitempty"`
	// InternalHTTPSPort - Internal HTTPS port.
	InternalHTTPSPort *int32 `json:"internalHttpsPort,omitempty"`
	// InUse - Is virtual IP mapping in use.
	InUse *bool `json:"inUse,omitempty"`
	// ServiceName - name of the service that virtual IP is assigned to
	ServiceName *string `json:"serviceName,omitempty"`
}

// VirtualNetworkProfile specification for using a Virtual Network.
type VirtualNetworkProfile struct {
	// ID - Resource id of the Virtual Network.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the Virtual Network (read-only).
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the Virtual Network (read-only).
	Type *string `json:"type,omitempty"`
	// Subnet - Subnet within the Virtual Network.
	Subnet *string `json:"subnet,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkProfile.
func (vnp VirtualNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnp.ID != nil {
		objectMap["id"] = vnp.ID
	}
	if vnp.Subnet != nil {
		objectMap["subnet"] = vnp.Subnet
	}
	return json.Marshal(objectMap)
}

// VnetGateway the Virtual Network gateway contract. This is used to give the Virtual Network gateway
// access to the VPN package.
type VnetGateway struct {
	autorest.Response `json:"-"`
	// VnetGatewayProperties - VnetGateway resource specific properties
	*VnetGatewayProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetGateway.
func (vg VnetGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vg.VnetGatewayProperties != nil {
		objectMap["properties"] = vg.VnetGatewayProperties
	}
	if vg.Kind != nil {
		objectMap["kind"] = vg.Kind
	}
	if vg.SystemData != nil {
		objectMap["systemData"] = vg.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetGateway struct.
func (vg *VnetGateway) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetGatewayProperties VnetGatewayProperties
				err = json.Unmarshal(*v, &vnetGatewayProperties)
				if err != nil {
					return err
				}
				vg.VnetGatewayProperties = &vnetGatewayProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vg.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vg.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vg.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vg.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetGatewayProperties vnetGateway resource specific properties
type VnetGatewayProperties struct {
	// VnetName - The Virtual Network name.
	VnetName *string `json:"vnetName,omitempty"`
	// VpnPackageURI - The URI where the VPN package can be downloaded.
	VpnPackageURI *string `json:"vpnPackageUri,omitempty"`
}

// VnetInfo virtual Network information contract.
type VnetInfo struct {
	autorest.Response `json:"-"`
	// VnetInfoProperties - VnetInfo resource specific properties
	*VnetInfoProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetInfo.
func (vi VnetInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vi.VnetInfoProperties != nil {
		objectMap["properties"] = vi.VnetInfoProperties
	}
	if vi.Kind != nil {
		objectMap["kind"] = vi.Kind
	}
	if vi.SystemData != nil {
		objectMap["systemData"] = vi.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetInfo struct.
func (vi *VnetInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetInfoProperties VnetInfoProperties
				err = json.Unmarshal(*v, &vnetInfoProperties)
				if err != nil {
					return err
				}
				vi.VnetInfoProperties = &vnetInfoProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vi.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vi.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vi.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vi.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetInfoProperties vnetInfo resource specific properties
type VnetInfoProperties struct {
	// VnetResourceID - The Virtual Network's resource ID.
	VnetResourceID *string `json:"vnetResourceId,omitempty"`
	// CertThumbprint - READ-ONLY; The client certificate thumbprint.
	CertThumbprint *string `json:"certThumbprint,omitempty"`
	// CertBlob - A certificate file (.cer) blob containing the public key of the private key used to authenticate a
	// Point-To-Site VPN connection.
	CertBlob *string `json:"certBlob,omitempty"`
	// Routes - READ-ONLY; The routes that this Virtual Network connection uses.
	Routes *[]VnetRoute `json:"routes,omitempty"`
	// ResyncRequired - READ-ONLY; <code>true</code> if a resync is required; otherwise, <code>false</code>.
	ResyncRequired *bool `json:"resyncRequired,omitempty"`
	// DNSServers - DNS servers to be used by this Virtual Network. This should be a comma-separated list of IP addresses.
	DNSServers *string `json:"dnsServers,omitempty"`
	// IsSwift - Flag that is used to denote if this is VNET injection
	IsSwift *bool `json:"isSwift,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetInfoProperties.
func (vi VnetInfoProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vi.VnetResourceID != nil {
		objectMap["vnetResourceId"] = vi.VnetResourceID
	}
	if vi.CertBlob != nil {
		objectMap["certBlob"] = vi.CertBlob
	}
	if vi.DNSServers != nil {
		objectMap["dnsServers"] = vi.DNSServers
	}
	if vi.IsSwift != nil {
		objectMap["isSwift"] = vi.IsSwift
	}
	return json.Marshal(objectMap)
}

// VnetParameters the required set of inputs to validate a VNET
type VnetParameters struct {
	// VnetParametersProperties - VnetParameters resource specific properties
	*VnetParametersProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetParameters.
func (vp VnetParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.VnetParametersProperties != nil {
		objectMap["properties"] = vp.VnetParametersProperties
	}
	if vp.Kind != nil {
		objectMap["kind"] = vp.Kind
	}
	if vp.SystemData != nil {
		objectMap["systemData"] = vp.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetParameters struct.
func (vp *VnetParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetParametersProperties VnetParametersProperties
				err = json.Unmarshal(*v, &vnetParametersProperties)
				if err != nil {
					return err
				}
				vp.VnetParametersProperties = &vnetParametersProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vp.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vp.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vp.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vp.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetParametersProperties vnetParameters resource specific properties
type VnetParametersProperties struct {
	// VnetResourceGroup - The Resource Group of the VNET to be validated
	VnetResourceGroup *string `json:"vnetResourceGroup,omitempty"`
	// VnetName - The name of the VNET to be validated
	VnetName *string `json:"vnetName,omitempty"`
	// VnetSubnetName - The subnet name to be validated
	VnetSubnetName *string `json:"vnetSubnetName,omitempty"`
}

// VnetRoute virtual Network route contract used to pass routing information for a Virtual Network.
type VnetRoute struct {
	autorest.Response `json:"-"`
	// VnetRouteProperties - VnetRoute resource specific properties
	*VnetRouteProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetRoute.
func (vr VnetRoute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vr.VnetRouteProperties != nil {
		objectMap["properties"] = vr.VnetRouteProperties
	}
	if vr.Kind != nil {
		objectMap["kind"] = vr.Kind
	}
	if vr.SystemData != nil {
		objectMap["systemData"] = vr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetRoute struct.
func (vr *VnetRoute) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetRouteProperties VnetRouteProperties
				err = json.Unmarshal(*v, &vnetRouteProperties)
				if err != nil {
					return err
				}
				vr.VnetRouteProperties = &vnetRouteProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vr.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetRouteProperties vnetRoute resource specific properties
type VnetRouteProperties struct {
	// StartAddress - The starting address for this route. This may also include a CIDR notation, in which case the end address must not be specified.
	StartAddress *string `json:"startAddress,omitempty"`
	// EndAddress - The ending address for this route. If the start address is specified in CIDR notation, this must be omitted.
	EndAddress *string `json:"endAddress,omitempty"`
	// RouteType - The type of route this is:
	// DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
	// INHERITED - Routes inherited from the real Virtual Network routes
	// STATIC - Static route set on the app only
	// These values will be used for syncing an app's routes with those from a Virtual Network. Possible values include: 'DEFAULT', 'INHERITED', 'STATIC'
	RouteType RouteType `json:"routeType,omitempty"`
}

// VnetValidationFailureDetails a class that describes the reason for a validation failure.
type VnetValidationFailureDetails struct {
	autorest.Response `json:"-"`
	// VnetValidationFailureDetailsProperties - VnetValidationFailureDetails resource specific properties
	*VnetValidationFailureDetailsProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetValidationFailureDetails.
func (vvfd VnetValidationFailureDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvfd.VnetValidationFailureDetailsProperties != nil {
		objectMap["properties"] = vvfd.VnetValidationFailureDetailsProperties
	}
	if vvfd.Kind != nil {
		objectMap["kind"] = vvfd.Kind
	}
	if vvfd.SystemData != nil {
		objectMap["systemData"] = vvfd.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetValidationFailureDetails struct.
func (vvfd *VnetValidationFailureDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetValidationFailureDetailsProperties VnetValidationFailureDetailsProperties
				err = json.Unmarshal(*v, &vnetValidationFailureDetailsProperties)
				if err != nil {
					return err
				}
				vvfd.VnetValidationFailureDetailsProperties = &vnetValidationFailureDetailsProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vvfd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vvfd.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vvfd.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vvfd.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vvfd.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetValidationFailureDetailsProperties vnetValidationFailureDetails resource specific properties
type VnetValidationFailureDetailsProperties struct {
	// Failed - A flag describing whether or not validation failed.
	Failed *bool `json:"failed,omitempty"`
	// FailedTests - A list of tests that failed in the validation.
	FailedTests *[]VnetValidationTestFailure `json:"failedTests,omitempty"`
}

// VnetValidationTestFailure a class that describes a test that failed during NSG and UDR validation.
type VnetValidationTestFailure struct {
	// VnetValidationTestFailureProperties - VnetValidationTestFailure resource specific properties
	*VnetValidationTestFailureProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for VnetValidationTestFailure.
func (vvtf VnetValidationTestFailure) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vvtf.VnetValidationTestFailureProperties != nil {
		objectMap["properties"] = vvtf.VnetValidationTestFailureProperties
	}
	if vvtf.Kind != nil {
		objectMap["kind"] = vvtf.Kind
	}
	if vvtf.SystemData != nil {
		objectMap["systemData"] = vvtf.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VnetValidationTestFailure struct.
func (vvtf *VnetValidationTestFailure) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var vnetValidationTestFailureProperties VnetValidationTestFailureProperties
				err = json.Unmarshal(*v, &vnetValidationTestFailureProperties)
				if err != nil {
					return err
				}
				vvtf.VnetValidationTestFailureProperties = &vnetValidationTestFailureProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vvtf.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vvtf.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				vvtf.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vvtf.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				vvtf.SystemData = &systemData
			}
		}
	}

	return nil
}

// VnetValidationTestFailureProperties vnetValidationTestFailure resource specific properties
type VnetValidationTestFailureProperties struct {
	// TestName - The name of the test that failed.
	TestName *string `json:"testName,omitempty"`
	// Details - The details of what caused the failure, e.g. the blocking rule name, etc.
	Details *string `json:"details,omitempty"`
}

// WorkerPool worker pool of an App Service Environment.
type WorkerPool struct {
	// WorkerSizeID - Worker size ID for referencing this worker pool.
	WorkerSizeID *int32 `json:"workerSizeId,omitempty"`
	// ComputeMode - Shared or dedicated app hosting. Possible values include: 'ComputeModeOptionsShared', 'ComputeModeOptionsDedicated', 'ComputeModeOptionsDynamic'
	ComputeMode ComputeModeOptions `json:"computeMode,omitempty"`
	// WorkerSize - VM size of the worker pool instances.
	WorkerSize *string `json:"workerSize,omitempty"`
	// WorkerCount - Number of instances in the worker pool.
	WorkerCount *int32 `json:"workerCount,omitempty"`
	// InstanceNames - READ-ONLY; Names of all instances in the worker pool (read only).
	InstanceNames *[]string `json:"instanceNames,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkerPool.
func (wp WorkerPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.WorkerSizeID != nil {
		objectMap["workerSizeId"] = wp.WorkerSizeID
	}
	if wp.ComputeMode != "" {
		objectMap["computeMode"] = wp.ComputeMode
	}
	if wp.WorkerSize != nil {
		objectMap["workerSize"] = wp.WorkerSize
	}
	if wp.WorkerCount != nil {
		objectMap["workerCount"] = wp.WorkerCount
	}
	return json.Marshal(objectMap)
}

// WorkerPoolCollection collection of worker pools.
type WorkerPoolCollection struct {
	autorest.Response `json:"-"`
	// Value - Collection of resources.
	Value *[]WorkerPoolResource `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkerPoolCollection.
func (wpc WorkerPoolCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpc.Value != nil {
		objectMap["value"] = wpc.Value
	}
	return json.Marshal(objectMap)
}

// WorkerPoolCollectionIterator provides access to a complete listing of WorkerPoolResource values.
type WorkerPoolCollectionIterator struct {
	i    int
	page WorkerPoolCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkerPoolCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkerPoolCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkerPoolCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkerPoolCollectionIterator) Response() WorkerPoolCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkerPoolCollectionIterator) Value() WorkerPoolResource {
	if !iter.page.NotDone() {
		return WorkerPoolResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkerPoolCollectionIterator type.
func NewWorkerPoolCollectionIterator(page WorkerPoolCollectionPage) WorkerPoolCollectionIterator {
	return WorkerPoolCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpc WorkerPoolCollection) IsEmpty() bool {
	return wpc.Value == nil || len(*wpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wpc WorkerPoolCollection) hasNextLink() bool {
	return wpc.NextLink != nil && len(*wpc.NextLink) != 0
}

// workerPoolCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpc WorkerPoolCollection) workerPoolCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !wpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpc.NextLink)))
}

// WorkerPoolCollectionPage contains a page of WorkerPoolResource values.
type WorkerPoolCollectionPage struct {
	fn  func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)
	wpc WorkerPoolCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkerPoolCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkerPoolCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wpc)
		if err != nil {
			return err
		}
		page.wpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkerPoolCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkerPoolCollectionPage) NotDone() bool {
	return !page.wpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkerPoolCollectionPage) Response() WorkerPoolCollection {
	return page.wpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkerPoolCollectionPage) Values() []WorkerPoolResource {
	if page.wpc.IsEmpty() {
		return nil
	}
	return *page.wpc.Value
}

// Creates a new instance of the WorkerPoolCollectionPage type.
func NewWorkerPoolCollectionPage(cur WorkerPoolCollection, getNextPage func(context.Context, WorkerPoolCollection) (WorkerPoolCollection, error)) WorkerPoolCollectionPage {
	return WorkerPoolCollectionPage{
		fn:  getNextPage,
		wpc: cur,
	}
}

// WorkerPoolResource worker pool of an App Service Environment ARM resource.
type WorkerPoolResource struct {
	autorest.Response `json:"-"`
	// WorkerPool - Core resource properties
	*WorkerPool `json:"properties,omitempty"`
	Sku         *SkuDescription `json:"sku,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource Name.
	Name *string `json:"name,omitempty"`
	// Kind - Kind of resource.
	Kind *string `json:"kind,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
	// SystemData - The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkerPoolResource.
func (wpr WorkerPoolResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpr.WorkerPool != nil {
		objectMap["properties"] = wpr.WorkerPool
	}
	if wpr.Sku != nil {
		objectMap["sku"] = wpr.Sku
	}
	if wpr.Kind != nil {
		objectMap["kind"] = wpr.Kind
	}
	if wpr.SystemData != nil {
		objectMap["systemData"] = wpr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkerPoolResource struct.
func (wpr *WorkerPoolResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workerPool WorkerPool
				err = json.Unmarshal(*v, &workerPool)
				if err != nil {
					return err
				}
				wpr.WorkerPool = &workerPool
			}
		case "sku":
			if v != nil {
				var sku SkuDescription
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				wpr.Sku = &sku
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wpr.Name = &name
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				wpr.Kind = &kind
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wpr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				wpr.SystemData = &systemData
			}
		}
	}

	return nil
}
