package batchai

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AllocationState enumerates the values for allocation state.
type AllocationState string

const (
	// Resizing ...
	Resizing AllocationState = "resizing"
	// Steady ...
	Steady AllocationState = "steady"
)

// PossibleAllocationStateValues returns an array of possible values for the AllocationState const type.
func PossibleAllocationStateValues() []AllocationState {
	return []AllocationState{Resizing, Steady}
}

// CachingType enumerates the values for caching type.
type CachingType string

const (
	// None ...
	None CachingType = "none"
	// Readonly ...
	Readonly CachingType = "readonly"
	// Readwrite ...
	Readwrite CachingType = "readwrite"
)

// PossibleCachingTypeValues returns an array of possible values for the CachingType const type.
func PossibleCachingTypeValues() []CachingType {
	return []CachingType{None, Readonly, Readwrite}
}

// DeallocationOption enumerates the values for deallocation option.
type DeallocationOption string

const (
	// Requeue ...
	Requeue DeallocationOption = "requeue"
	// Terminate ...
	Terminate DeallocationOption = "terminate"
	// Unknown ...
	Unknown DeallocationOption = "unknown"
	// Waitforjobcompletion ...
	Waitforjobcompletion DeallocationOption = "waitforjobcompletion"
)

// PossibleDeallocationOptionValues returns an array of possible values for the DeallocationOption const type.
func PossibleDeallocationOptionValues() []DeallocationOption {
	return []DeallocationOption{Requeue, Terminate, Unknown, Waitforjobcompletion}
}

// ExecutionState enumerates the values for execution state.
type ExecutionState string

const (
	// Failed ...
	Failed ExecutionState = "failed"
	// Queued ...
	Queued ExecutionState = "queued"
	// Running ...
	Running ExecutionState = "running"
	// Succeeded ...
	Succeeded ExecutionState = "succeeded"
	// Terminating ...
	Terminating ExecutionState = "terminating"
)

// PossibleExecutionStateValues returns an array of possible values for the ExecutionState const type.
func PossibleExecutionStateValues() []ExecutionState {
	return []ExecutionState{Failed, Queued, Running, Succeeded, Terminating}
}

// FileServerProvisioningState enumerates the values for file server provisioning state.
type FileServerProvisioningState string

const (
	// FileServerProvisioningStateCreating ...
	FileServerProvisioningStateCreating FileServerProvisioningState = "creating"
	// FileServerProvisioningStateDeleting ...
	FileServerProvisioningStateDeleting FileServerProvisioningState = "deleting"
	// FileServerProvisioningStateFailed ...
	FileServerProvisioningStateFailed FileServerProvisioningState = "failed"
	// FileServerProvisioningStateSucceeded ...
	FileServerProvisioningStateSucceeded FileServerProvisioningState = "succeeded"
	// FileServerProvisioningStateUpdating ...
	FileServerProvisioningStateUpdating FileServerProvisioningState = "updating"
)

// PossibleFileServerProvisioningStateValues returns an array of possible values for the FileServerProvisioningState const type.
func PossibleFileServerProvisioningStateValues() []FileServerProvisioningState {
	return []FileServerProvisioningState{FileServerProvisioningStateCreating, FileServerProvisioningStateDeleting, FileServerProvisioningStateFailed, FileServerProvisioningStateSucceeded, FileServerProvisioningStateUpdating}
}

// FileServerType enumerates the values for file server type.
type FileServerType string

const (
	// Glusterfs ...
	Glusterfs FileServerType = "glusterfs"
	// Nfs ...
	Nfs FileServerType = "nfs"
)

// PossibleFileServerTypeValues returns an array of possible values for the FileServerType const type.
func PossibleFileServerTypeValues() []FileServerType {
	return []FileServerType{Glusterfs, Nfs}
}

// OutputType enumerates the values for output type.
type OutputType string

const (
	// Custom ...
	Custom OutputType = "custom"
	// Logs ...
	Logs OutputType = "logs"
	// Model ...
	Model OutputType = "model"
	// Summary ...
	Summary OutputType = "summary"
)

// PossibleOutputTypeValues returns an array of possible values for the OutputType const type.
func PossibleOutputTypeValues() []OutputType {
	return []OutputType{Custom, Logs, Model, Summary}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// PremiumLRS ...
	PremiumLRS StorageAccountType = "Premium_LRS"
	// StandardLRS ...
	StandardLRS StorageAccountType = "Standard_LRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{PremiumLRS, StandardLRS}
}

// ToolType enumerates the values for tool type.
type ToolType string

const (
	// ToolTypeCaffe ...
	ToolTypeCaffe ToolType = "caffe"
	// ToolTypeCaffe2 ...
	ToolTypeCaffe2 ToolType = "caffe2"
	// ToolTypeChainer ...
	ToolTypeChainer ToolType = "chainer"
	// ToolTypeCntk ...
	ToolTypeCntk ToolType = "cntk"
	// ToolTypeCustom ...
	ToolTypeCustom ToolType = "custom"
	// ToolTypeTensorflow ...
	ToolTypeTensorflow ToolType = "tensorflow"
)

// PossibleToolTypeValues returns an array of possible values for the ToolType const type.
func PossibleToolTypeValues() []ToolType {
	return []ToolType{ToolTypeCaffe, ToolTypeCaffe2, ToolTypeChainer, ToolTypeCntk, ToolTypeCustom, ToolTypeTensorflow}
}

// VMPriority enumerates the values for vm priority.
type VMPriority string

const (
	// Dedicated ...
	Dedicated VMPriority = "dedicated"
	// Lowpriority ...
	Lowpriority VMPriority = "lowpriority"
)

// PossibleVMPriorityValues returns an array of possible values for the VMPriority const type.
func PossibleVMPriorityValues() []VMPriority {
	return []VMPriority{Dedicated, Lowpriority}
}
