package workloadmonitorapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/workloadmonitor/mgmt/2020-01-13-preview/workloadmonitor"
	"github.com/Azure/go-autorest/autorest/date"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result workloadmonitor.OperationListPage, err error)
	ListComplete(ctx context.Context) (result workloadmonitor.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*workloadmonitor.OperationsClient)(nil)

// HealthMonitorsClientAPI contains the set of methods on the HealthMonitorsClient type.
type HealthMonitorsClientAPI interface {
	Get(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, monitorID string, expand string) (result workloadmonitor.HealthMonitor, err error)
	GetStateChange(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, monitorID string, timestampUnix string, expand string) (result workloadmonitor.HealthMonitorStateChange, err error)
	List(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, filter string, expand string) (result workloadmonitor.HealthMonitorListPage, err error)
	ListComplete(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, filter string, expand string) (result workloadmonitor.HealthMonitorListIterator, err error)
	ListStateChanges(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, monitorID string, filter string, expand string, startTimestampUtc *date.Time, endTimestampUtc *date.Time) (result workloadmonitor.HealthMonitorStateChangeListPage, err error)
	ListStateChangesComplete(ctx context.Context, subscriptionID string, resourceGroupName string, providerName string, resourceCollectionName string, resourceName string, monitorID string, filter string, expand string, startTimestampUtc *date.Time, endTimestampUtc *date.Time) (result workloadmonitor.HealthMonitorStateChangeListIterator, err error)
}

var _ HealthMonitorsClientAPI = (*workloadmonitor.HealthMonitorsClient)(nil)
