//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package quota

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/quota/mgmt/2021-03-15-preview/quota"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type LimitObjectType = original.LimitObjectType

const (
	LimitObjectTypeLimitJSONObject LimitObjectType = original.LimitObjectTypeLimitJSONObject
)

type LimitType = original.LimitType

const (
	LimitTypeLimitValue LimitType = original.LimitTypeLimitValue
)

type LimitTypes = original.LimitTypes

const (
	LimitTypesIndependent LimitTypes = original.LimitTypesIndependent
	LimitTypesShared      LimitTypes = original.LimitTypesShared
)

type RequestState = original.RequestState

const (
	RequestStateAccepted   RequestState = original.RequestStateAccepted
	RequestStateFailed     RequestState = original.RequestStateFailed
	RequestStateInProgress RequestState = original.RequestStateInProgress
	RequestStateInvalid    RequestState = original.RequestStateInvalid
	RequestStateSucceeded  RequestState = original.RequestStateSucceeded
)

type UsagesTypes = original.UsagesTypes

const (
	UsagesTypesCombined   UsagesTypes = original.UsagesTypesCombined
	UsagesTypesIndividual UsagesTypes = original.UsagesTypesIndividual
)

type BaseClient = original.BaseClient
type BasicLimitJSONObject = original.BasicLimitJSONObject
type Client = original.Client
type CommonResourceProperties = original.CommonResourceProperties
type CreateGenericQuotaRequestParameters = original.CreateGenericQuotaRequestParameters
type CreateOrUpdateFuture = original.CreateOrUpdateFuture
type CurrentQuotaLimitBase = original.CurrentQuotaLimitBase
type CurrentUsagesBase = original.CurrentUsagesBase
type ExceptionResponse = original.ExceptionResponse
type LimitJSONObject = original.LimitJSONObject
type LimitObject = original.LimitObject
type LimitValue = original.LimitValue
type Limits = original.Limits
type LimitsIterator = original.LimitsIterator
type LimitsPage = original.LimitsPage
type LimitsResponse = original.LimitsResponse
type OperationClient = original.OperationClient
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationListIterator = original.OperationListIterator
type OperationListPage = original.OperationListPage
type OperationResponse = original.OperationResponse
type Properties = original.Properties
type RequestDetails = original.RequestDetails
type RequestDetailsList = original.RequestDetailsList
type RequestDetailsListIterator = original.RequestDetailsListIterator
type RequestDetailsListPage = original.RequestDetailsListPage
type RequestOneResourceProperties = original.RequestOneResourceProperties
type RequestOneResourceSubmitResponse = original.RequestOneResourceSubmitResponse
type RequestProperties = original.RequestProperties
type RequestStatusClient = original.RequestStatusClient
type RequestStatusDetails = original.RequestStatusDetails
type RequestSubmitResponse = original.RequestSubmitResponse
type RequestSubmitResponse202 = original.RequestSubmitResponse202
type ResourceName = original.ResourceName
type ServiceError = original.ServiceError
type ServiceErrorDetail = original.ServiceErrorDetail
type SubRequest = original.SubRequest
type UpdateFuture = original.UpdateFuture
type UsagesClient = original.UsagesClient
type UsagesLimits = original.UsagesLimits
type UsagesLimitsIterator = original.UsagesLimitsIterator
type UsagesLimitsPage = original.UsagesLimitsPage
type UsagesObject = original.UsagesObject
type UsagesProperties = original.UsagesProperties

func New() BaseClient {
	return original.New()
}
func NewClient() Client {
	return original.NewClient()
}
func NewClientWithBaseURI(baseURI string) Client {
	return original.NewClientWithBaseURI(baseURI)
}
func NewLimitsIterator(page LimitsPage) LimitsIterator {
	return original.NewLimitsIterator(page)
}
func NewLimitsPage(cur Limits, getNextPage func(context.Context, Limits) (Limits, error)) LimitsPage {
	return original.NewLimitsPage(cur, getNextPage)
}
func NewOperationClient() OperationClient {
	return original.NewOperationClient()
}
func NewOperationClientWithBaseURI(baseURI string) OperationClient {
	return original.NewOperationClientWithBaseURI(baseURI)
}
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return original.NewOperationListIterator(page)
}
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return original.NewOperationListPage(cur, getNextPage)
}
func NewRequestDetailsListIterator(page RequestDetailsListPage) RequestDetailsListIterator {
	return original.NewRequestDetailsListIterator(page)
}
func NewRequestDetailsListPage(cur RequestDetailsList, getNextPage func(context.Context, RequestDetailsList) (RequestDetailsList, error)) RequestDetailsListPage {
	return original.NewRequestDetailsListPage(cur, getNextPage)
}
func NewRequestStatusClient() RequestStatusClient {
	return original.NewRequestStatusClient()
}
func NewRequestStatusClientWithBaseURI(baseURI string) RequestStatusClient {
	return original.NewRequestStatusClientWithBaseURI(baseURI)
}
func NewUsagesClient() UsagesClient {
	return original.NewUsagesClient()
}
func NewUsagesClientWithBaseURI(baseURI string) UsagesClient {
	return original.NewUsagesClientWithBaseURI(baseURI)
}
func NewUsagesLimitsIterator(page UsagesLimitsPage) UsagesLimitsIterator {
	return original.NewUsagesLimitsIterator(page)
}
func NewUsagesLimitsPage(cur UsagesLimits, getNextPage func(context.Context, UsagesLimits) (UsagesLimits, error)) UsagesLimitsPage {
	return original.NewUsagesLimitsPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}
func PossibleLimitObjectTypeValues() []LimitObjectType {
	return original.PossibleLimitObjectTypeValues()
}
func PossibleLimitTypeValues() []LimitType {
	return original.PossibleLimitTypeValues()
}
func PossibleLimitTypesValues() []LimitTypes {
	return original.PossibleLimitTypesValues()
}
func PossibleRequestStateValues() []RequestState {
	return original.PossibleRequestStateValues()
}
func PossibleUsagesTypesValues() []UsagesTypes {
	return original.PossibleUsagesTypesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
