// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package guestconfiguration

import original "github.com/Azure/azure-sdk-for-go/services/guestconfiguration/mgmt/2020-06-25/guestconfiguration"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ActionAfterReboot = original.ActionAfterReboot

const (
	ContinueConfiguration ActionAfterReboot = original.ContinueConfiguration
	StopConfiguration     ActionAfterReboot = original.StopConfiguration
)

type AllowModuleOverwrite = original.AllowModuleOverwrite

const (
	False AllowModuleOverwrite = original.False
	True  AllowModuleOverwrite = original.True
)

type ComplianceStatus = original.ComplianceStatus

const (
	Compliant    ComplianceStatus = original.Compliant
	NonCompliant ComplianceStatus = original.NonCompliant
	Pending      ComplianceStatus = original.Pending
)

type ConfigurationMode = original.ConfigurationMode

const (
	ApplyAndAutoCorrect ConfigurationMode = original.ApplyAndAutoCorrect
	ApplyAndMonitor     ConfigurationMode = original.ApplyAndMonitor
	ApplyOnly           ConfigurationMode = original.ApplyOnly
)

type Kind = original.Kind

const (
	DSC Kind = original.DSC
)

type ProvisioningState = original.ProvisioningState

const (
	Canceled  ProvisioningState = original.Canceled
	Created   ProvisioningState = original.Created
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
)

type RebootIfNeeded = original.RebootIfNeeded

const (
	RebootIfNeededFalse RebootIfNeeded = original.RebootIfNeededFalse
	RebootIfNeededTrue  RebootIfNeeded = original.RebootIfNeededTrue
)

type Type = original.Type

const (
	Consistency Type = original.Consistency
	Initial     Type = original.Initial
)

type Assignment = original.Assignment
type AssignmentInfo = original.AssignmentInfo
type AssignmentList = original.AssignmentList
type AssignmentProperties = original.AssignmentProperties
type AssignmentReport = original.AssignmentReport
type AssignmentReportDetails = original.AssignmentReportDetails
type AssignmentReportList = original.AssignmentReportList
type AssignmentReportProperties = original.AssignmentReportProperties
type AssignmentReportResource = original.AssignmentReportResource
type AssignmentReportResourceComplianceReason = original.AssignmentReportResourceComplianceReason
type AssignmentReportType = original.AssignmentReportType
type AssignmentReportsClient = original.AssignmentReportsClient
type AssignmentsClient = original.AssignmentsClient
type AssignmentsCreateOrUpdateFuture = original.AssignmentsCreateOrUpdateFuture
type AssignmentsDeleteFuture = original.AssignmentsDeleteFuture
type BaseClient = original.BaseClient
type ConfigurationInfo = original.ConfigurationInfo
type ConfigurationParameter = original.ConfigurationParameter
type ConfigurationSetting = original.ConfigurationSetting
type ErrorResponse = original.ErrorResponse
type ErrorResponseError = original.ErrorResponseError
type HCRPAssignmentReportsClient = original.HCRPAssignmentReportsClient
type HCRPAssignmentsClient = original.HCRPAssignmentsClient
type HCRPAssignmentsCreateOrUpdateFuture = original.HCRPAssignmentsCreateOrUpdateFuture
type HCRPAssignmentsDeleteFuture = original.HCRPAssignmentsDeleteFuture
type Navigation = original.Navigation
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type TrackedResource = original.TrackedResource
type VMInfo = original.VMInfo

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAssignmentReportsClient(subscriptionID string) AssignmentReportsClient {
	return original.NewAssignmentReportsClient(subscriptionID)
}
func NewAssignmentReportsClientWithBaseURI(baseURI string, subscriptionID string) AssignmentReportsClient {
	return original.NewAssignmentReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssignmentsClient(subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClient(subscriptionID)
}
func NewAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHCRPAssignmentReportsClient(subscriptionID string) HCRPAssignmentReportsClient {
	return original.NewHCRPAssignmentReportsClient(subscriptionID)
}
func NewHCRPAssignmentReportsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentReportsClient {
	return original.NewHCRPAssignmentReportsClientWithBaseURI(baseURI, subscriptionID)
}
func NewHCRPAssignmentsClient(subscriptionID string) HCRPAssignmentsClient {
	return original.NewHCRPAssignmentsClient(subscriptionID)
}
func NewHCRPAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) HCRPAssignmentsClient {
	return original.NewHCRPAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleActionAfterRebootValues() []ActionAfterReboot {
	return original.PossibleActionAfterRebootValues()
}
func PossibleAllowModuleOverwriteValues() []AllowModuleOverwrite {
	return original.PossibleAllowModuleOverwriteValues()
}
func PossibleComplianceStatusValues() []ComplianceStatus {
	return original.PossibleComplianceStatusValues()
}
func PossibleConfigurationModeValues() []ConfigurationMode {
	return original.PossibleConfigurationModeValues()
}
func PossibleKindValues() []Kind {
	return original.PossibleKindValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleRebootIfNeededValues() []RebootIfNeeded {
	return original.PossibleRebootIfNeededValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
