// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package anomalydetector

import original "github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v1.0/anomalydetector"

type TimeGranularity = original.TimeGranularity

const (
	Daily     TimeGranularity = original.Daily
	Hourly    TimeGranularity = original.Hourly
	Monthly   TimeGranularity = original.Monthly
	PerMinute TimeGranularity = original.PerMinute
	PerSecond TimeGranularity = original.PerSecond
	Weekly    TimeGranularity = original.Weekly
	Yearly    TimeGranularity = original.Yearly
)

type BaseClient = original.BaseClient
type ChangePointDetectRequest = original.ChangePointDetectRequest
type ChangePointDetectResponse = original.ChangePointDetectResponse
type DetectRequest = original.DetectRequest
type EntireDetectResponse = original.EntireDetectResponse
type Error = original.Error
type LastDetectResponse = original.LastDetectResponse
type TimeSeriesPoint = original.TimeSeriesPoint

func New(endpoint string) BaseClient {
	return original.New(endpoint)
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func PossibleTimeGranularityValues() []TimeGranularity {
	return original.PossibleTimeGranularityValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
