package autosuggest

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ResponseFormat enumerates the values for response format.
type ResponseFormat string

const (
	// JSON ...
	JSON ResponseFormat = "Json"
	// JSONLd ...
	JSONLd ResponseFormat = "JsonLd"
)

// PossibleResponseFormatValues returns an array of possible values for the ResponseFormat const type.
func PossibleResponseFormatValues() []ResponseFormat {
	return []ResponseFormat{JSON, JSONLd}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// ScenarioType enumerates the values for scenario type.
type ScenarioType string

const (
	// Custom ...
	Custom ScenarioType = "Custom"
	// PersonalSearchDocuments ...
	PersonalSearchDocuments ScenarioType = "PersonalSearchDocuments"
	// PersonalSearchTags ...
	PersonalSearchTags ScenarioType = "PersonalSearchTags"
	// SearchHistory ...
	SearchHistory ScenarioType = "SearchHistory"
	// StoreApps ...
	StoreApps ScenarioType = "StoreApps"
	// Unknown ...
	Unknown ScenarioType = "Unknown"
	// Web ...
	Web ScenarioType = "Web"
)

// PossibleScenarioTypeValues returns an array of possible values for the ScenarioType const type.
func PossibleScenarioTypeValues() []ScenarioType {
	return []ScenarioType{Custom, PersonalSearchDocuments, PersonalSearchTags, SearchHistory, StoreApps, Unknown, Web}
}

// SearchKind enumerates the values for search kind.
type SearchKind string

const (
	// CustomSearch ...
	CustomSearch SearchKind = "CustomSearch"
	// DocumentSearch ...
	DocumentSearch SearchKind = "DocumentSearch"
	// HistorySearch ...
	HistorySearch SearchKind = "HistorySearch"
	// LocationSearch ...
	LocationSearch SearchKind = "LocationSearch"
	// TagSearch ...
	TagSearch SearchKind = "TagSearch"
	// WebSearch ...
	WebSearch SearchKind = "WebSearch"
)

// PossibleSearchKindValues returns an array of possible values for the SearchKind const type.
func PossibleSearchKindValues() []SearchKind {
	return []SearchKind{CustomSearch, DocumentSearch, HistorySearch, LocationSearch, TagSearch, WebSearch}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeSuggestionsSuggestionGroup ...
	TypeSuggestionsSuggestionGroup Type = "Suggestions/SuggestionGroup"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeSuggestionsSuggestionGroup}
}

// TypeBasicError enumerates the values for type basic error.
type TypeBasicError string

const (
	// TypeError ...
	TypeError TypeBasicError = "Error"
)

// PossibleTypeBasicErrorValues returns an array of possible values for the TypeBasicError const type.
func PossibleTypeBasicErrorValues() []TypeBasicError {
	return []TypeBasicError{TypeError}
}

// TypeBasicQueryContext enumerates the values for type basic query context.
type TypeBasicQueryContext string

const (
	// TypeQueryContext ...
	TypeQueryContext TypeBasicQueryContext = "QueryContext"
)

// PossibleTypeBasicQueryContextValues returns an array of possible values for the TypeBasicQueryContext const type.
func PossibleTypeBasicQueryContextValues() []TypeBasicQueryContext {
	return []TypeBasicQueryContext{TypeQueryContext}
}

// TypeBasicResponseBase enumerates the values for type basic response base.
type TypeBasicResponseBase string

const (
	// TypeAction ...
	TypeAction TypeBasicResponseBase = "Action"
	// TypeAnswer ...
	TypeAnswer TypeBasicResponseBase = "Answer"
	// TypeCreativeWork ...
	TypeCreativeWork TypeBasicResponseBase = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse TypeBasicResponseBase = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable TypeBasicResponseBase = "Identifiable"
	// TypeResponse ...
	TypeResponse TypeBasicResponseBase = "Response"
	// TypeResponseBase ...
	TypeResponseBase TypeBasicResponseBase = "ResponseBase"
	// TypeSearchAction ...
	TypeSearchAction TypeBasicResponseBase = "SearchAction"
	// TypeSearchResultsAnswer ...
	TypeSearchResultsAnswer TypeBasicResponseBase = "SearchResultsAnswer"
	// TypeSuggestions ...
	TypeSuggestions TypeBasicResponseBase = "Suggestions"
	// TypeThing ...
	TypeThing TypeBasicResponseBase = "Thing"
)

// PossibleTypeBasicResponseBaseValues returns an array of possible values for the TypeBasicResponseBase const type.
func PossibleTypeBasicResponseBaseValues() []TypeBasicResponseBase {
	return []TypeBasicResponseBase{TypeAction, TypeAnswer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeResponse, TypeResponseBase, TypeSearchAction, TypeSearchResultsAnswer, TypeSuggestions, TypeThing}
}
