package consumption

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ReservationTransactionsClient is the consumption management client provides access to consumption resources for
// Azure Enterprise Subscriptions.
type ReservationTransactionsClient struct {
	BaseClient
}

// NewReservationTransactionsClient creates an instance of the ReservationTransactionsClient client.
func NewReservationTransactionsClient(subscriptionID string) ReservationTransactionsClient {
	return NewReservationTransactionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewReservationTransactionsClientWithBaseURI creates an instance of the ReservationTransactionsClient client using a
// custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds,
// Azure stack).
func NewReservationTransactionsClientWithBaseURI(baseURI string, subscriptionID string) ReservationTransactionsClient {
	return ReservationTransactionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List list of transactions for reserved instances on billing account scope
// Parameters:
// billingAccountID - billingAccount ID
// filter - filter reservation transactions by date range. The properties/EventDate for start date and end
// date. The filter supports 'le' and  'ge'
func (client ReservationTransactionsClient) List(ctx context.Context, billingAccountID string, filter string) (result ReservationTransactionsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsClient.List")
		defer func() {
			sc := -1
			if result.rtlr.Response.Response != nil {
				sc = result.rtlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, billingAccountID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rtlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "List", resp, "Failure sending request")
		return
	}

	result.rtlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.rtlr.hasNextLink() && result.rtlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ReservationTransactionsClient) ListPreparer(ctx context.Context, billingAccountID string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/providers/Microsoft.Consumption/reservationTransactions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ReservationTransactionsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ReservationTransactionsClient) ListResponder(resp *http.Response) (result ReservationTransactionsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ReservationTransactionsClient) listNextResults(ctx context.Context, lastResults ReservationTransactionsListResult) (result ReservationTransactionsListResult, err error) {
	req, err := lastResults.reservationTransactionsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReservationTransactionsClient) ListComplete(ctx context.Context, billingAccountID string, filter string) (result ReservationTransactionsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, billingAccountID, filter)
	return
}

// ListByBillingProfile list of transactions for reserved instances on billing account scope
// Parameters:
// billingAccountID - billingAccount ID
// billingProfileID - azure Billing Profile ID.
// filter - filter reservation transactions by date range. The properties/EventDate for start date and end
// date. The filter supports 'le' and  'ge'
func (client ReservationTransactionsClient) ListByBillingProfile(ctx context.Context, billingAccountID string, billingProfileID string, filter string) (result ModernReservationTransactionsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsClient.ListByBillingProfile")
		defer func() {
			sc := -1
			if result.mrtlr.Response.Response != nil {
				sc = result.mrtlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByBillingProfileNextResults
	req, err := client.ListByBillingProfilePreparer(ctx, billingAccountID, billingProfileID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "ListByBillingProfile", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByBillingProfileSender(req)
	if err != nil {
		result.mrtlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "ListByBillingProfile", resp, "Failure sending request")
		return
	}

	result.mrtlr, err = client.ListByBillingProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "ListByBillingProfile", resp, "Failure responding to request")
		return
	}
	if result.mrtlr.hasNextLink() && result.mrtlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByBillingProfilePreparer prepares the ListByBillingProfile request.
func (client ReservationTransactionsClient) ListByBillingProfilePreparer(ctx context.Context, billingAccountID string, billingProfileID string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"billingAccountId": autorest.Encode("path", billingAccountID),
		"billingProfileId": autorest.Encode("path", billingProfileID),
	}

	const APIVersion = "2019-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Billing/billingAccounts/{billingAccountId}/billingProfiles/{billingProfileId}/providers/Microsoft.Consumption/reservationTransactions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByBillingProfileSender sends the ListByBillingProfile request. The method will close the
// http.Response Body if it receives an error.
func (client ReservationTransactionsClient) ListByBillingProfileSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByBillingProfileResponder handles the response to the ListByBillingProfile request. The method always
// closes the http.Response Body.
func (client ReservationTransactionsClient) ListByBillingProfileResponder(resp *http.Response) (result ModernReservationTransactionsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByBillingProfileNextResults retrieves the next set of results, if any.
func (client ReservationTransactionsClient) listByBillingProfileNextResults(ctx context.Context, lastResults ModernReservationTransactionsListResult) (result ModernReservationTransactionsListResult, err error) {
	req, err := lastResults.modernReservationTransactionsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listByBillingProfileNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByBillingProfileSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listByBillingProfileNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByBillingProfileResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "consumption.ReservationTransactionsClient", "listByBillingProfileNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByBillingProfileComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReservationTransactionsClient) ListByBillingProfileComplete(ctx context.Context, billingAccountID string, billingProfileID string, filter string) (result ModernReservationTransactionsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReservationTransactionsClient.ListByBillingProfile")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByBillingProfile(ctx, billingAccountID, billingProfileID, filter)
	return
}
