package databox

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/databox/mgmt/2020-04-01/databox"

// AccountCopyLogDetails copy log details for a storage account of a DataBox job
type AccountCopyLogDetails struct {
	// AccountName - READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - READ-ONLY; Link for copy logs.
	CopyLogLink *string `json:"copyLogLink,omitempty"`
	// CopyVerboseLogLink - READ-ONLY; Link for copy verbose logs. This will be set only when LogCollectionLevel is set to Verbose.
	CopyVerboseLogLink *string `json:"copyVerboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	acld.CopyLogDetailsType = CopyLogDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if acld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = acld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return &acld, true
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for AccountCopyLogDetails.
func (acld AccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &acld, true
}

// AccountCredentialDetails credential details of the account.
type AccountCredentialDetails struct {
	// AccountName - READ-ONLY; Name of the account.
	AccountName *string `json:"accountName,omitempty"`
	// DataAccountType - READ-ONLY; Type of the account. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataAccountType DataAccountType `json:"dataAccountType,omitempty"`
	// AccountConnectionString - READ-ONLY; Connection string of the account endpoint to use the account as a storage endpoint on the device.
	AccountConnectionString *string `json:"accountConnectionString,omitempty"`
	// ShareCredentialDetails - READ-ONLY; Per share level unencrypted access credentials.
	ShareCredentialDetails *[]ShareCredentialDetails `json:"shareCredentialDetails,omitempty"`
}

// AdditionalErrorInfo additional error info.
type AdditionalErrorInfo struct {
	// Type - Additional error type.
	Type *string `json:"type,omitempty"`
	// Info - Additional error info.
	Info interface{} `json:"info,omitempty"`
}

// AddressValidationOutput output of the address validation api.
type AddressValidationOutput struct {
	autorest.Response `json:"-"`
	// AddressValidationProperties - READ-ONLY; The address validation properties.
	*AddressValidationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationOutput.
func (avo AddressValidationOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AddressValidationOutput struct.
func (avo *AddressValidationOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var addressValidationProperties AddressValidationProperties
				err = json.Unmarshal(*v, &addressValidationProperties)
				if err != nil {
					return err
				}
				avo.AddressValidationProperties = &addressValidationProperties
			}
		}
	}

	return nil
}

// AddressValidationProperties the address validation output.
type AddressValidationProperties struct {
	// ValidationStatus - READ-ONLY; The address validation status. Possible values include: 'Valid', 'Invalid', 'Ambiguous'
	ValidationStatus AddressValidationStatus `json:"validationStatus,omitempty"`
	// AlternateAddresses - READ-ONLY; List of alternate addresses.
	AlternateAddresses *[]ShippingAddress `json:"alternateAddresses,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for AddressValidationProperties.
func (avp AddressValidationProperties) MarshalJSON() ([]byte, error) {
	avp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress
	objectMap := make(map[string]interface{})
	if avp.ValidationType != "" {
		objectMap["validationType"] = avp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return &avp, true
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for AddressValidationProperties.
func (avp AddressValidationProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &avp, true
}

// APIError ...
type APIError struct {
	Error *ErrorDetail `json:"error,omitempty"`
}

// ApplianceNetworkConfiguration the Network Adapter configuration of a DataBox.
type ApplianceNetworkConfiguration struct {
	// Name - READ-ONLY; Name of the network.
	Name *string `json:"name,omitempty"`
	// MacAddress - READ-ONLY; Mac Address.
	MacAddress *string `json:"macAddress,omitempty"`
}

// ArmBaseObject base class for all objects under resource.
type ArmBaseObject struct {
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
}

// AvailableSkuRequest the filters for showing the available skus.
type AvailableSkuRequest struct {
	// TransferType - Type of the transfer. Possible values include: 'ImportToAzure', 'ExportFromAzure'
	TransferType TransferType `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
	// SkuNames - Sku Names to filter for available skus
	SkuNames *[]SkuName `json:"skuNames,omitempty"`
}

// AvailableSkusResult the available skus operation response.
type AvailableSkusResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of available skus.
	Value *[]SkuInformation `json:"value,omitempty"`
	// NextLink - Link for the next set of skus.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailableSkusResult.
func (asr AvailableSkusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asr.NextLink != nil {
		objectMap["nextLink"] = asr.NextLink
	}
	return json.Marshal(objectMap)
}

// AvailableSkusResultIterator provides access to a complete listing of SkuInformation values.
type AvailableSkusResultIterator struct {
	i    int
	page AvailableSkusResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AvailableSkusResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AvailableSkusResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AvailableSkusResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AvailableSkusResultIterator) Response() AvailableSkusResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AvailableSkusResultIterator) Value() SkuInformation {
	if !iter.page.NotDone() {
		return SkuInformation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AvailableSkusResultIterator type.
func NewAvailableSkusResultIterator(page AvailableSkusResultPage) AvailableSkusResultIterator {
	return AvailableSkusResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asr AvailableSkusResult) IsEmpty() bool {
	return asr.Value == nil || len(*asr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asr AvailableSkusResult) hasNextLink() bool {
	return asr.NextLink != nil && len(*asr.NextLink) != 0
}

// availableSkusResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asr AvailableSkusResult) availableSkusResultPreparer(ctx context.Context) (*http.Request, error) {
	if !asr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asr.NextLink)))
}

// AvailableSkusResultPage contains a page of SkuInformation values.
type AvailableSkusResultPage struct {
	fn  func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)
	asr AvailableSkusResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AvailableSkusResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AvailableSkusResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asr)
		if err != nil {
			return err
		}
		page.asr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AvailableSkusResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AvailableSkusResultPage) NotDone() bool {
	return !page.asr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AvailableSkusResultPage) Response() AvailableSkusResult {
	return page.asr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AvailableSkusResultPage) Values() []SkuInformation {
	if page.asr.IsEmpty() {
		return nil
	}
	return *page.asr.Value
}

// Creates a new instance of the AvailableSkusResultPage type.
func NewAvailableSkusResultPage(cur AvailableSkusResult, getNextPage func(context.Context, AvailableSkusResult) (AvailableSkusResult, error)) AvailableSkusResultPage {
	return AvailableSkusResultPage{
		fn:  getNextPage,
		asr: cur,
	}
}

// AzureFileFilterDetails filter details to transfer Azure files
type AzureFileFilterDetails struct {
	// FilePrefixList - Prefix list of the Azure files to be transferred.
	FilePrefixList *[]string `json:"filePrefixList,omitempty"`
	// FilePathList - List of full path of the files to be transferred.
	FilePathList *[]string `json:"filePathList,omitempty"`
	// FileShareList - List of file shares to be transferred.
	FileShareList *[]string `json:"fileShareList,omitempty"`
}

// BlobFilterDetails filter details to transfer Azure Blobs
type BlobFilterDetails struct {
	// BlobPrefixList - Prefix list of the Azure blobs to be transferred.
	BlobPrefixList *[]string `json:"blobPrefixList,omitempty"`
	// BlobPathList - List of full path of the blobs to be transferred.
	BlobPathList *[]string `json:"blobPathList,omitempty"`
	// ContainerList - List of blob containers to be transferred.
	ContainerList *[]string `json:"containerList,omitempty"`
}

// CancellationReason reason for cancellation.
type CancellationReason struct {
	// Reason - Reason for cancellation.
	Reason *string `json:"reason,omitempty"`
}

// CloudError cloud error.
type CloudError struct {
	// Code - Cloud error code.
	Code *string `json:"code,omitempty"`
	// Message - Cloud error message.
	Message *string `json:"message,omitempty"`
	// Target - Cloud error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; Cloud error details.
	Details *[]CloudError `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; Cloud error additional info.
	AdditionalInfo *[]AdditionalErrorInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for CloudError.
func (ce CloudError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ce.Code != nil {
		objectMap["code"] = ce.Code
	}
	if ce.Message != nil {
		objectMap["message"] = ce.Message
	}
	if ce.Target != nil {
		objectMap["target"] = ce.Target
	}
	return json.Marshal(objectMap)
}

// ContactDetails contact Details.
type ContactDetails struct {
	// ContactName - Contact name of the person.
	ContactName *string `json:"contactName,omitempty"`
	// Phone - Phone number of the contact person.
	Phone *string `json:"phone,omitempty"`
	// PhoneExtension - Phone extension number of the contact person.
	PhoneExtension *string `json:"phoneExtension,omitempty"`
	// Mobile - Mobile number of the contact person.
	Mobile *string `json:"mobile,omitempty"`
	// EmailList - List of Email-ids to be notified about job progress.
	EmailList *[]string `json:"emailList,omitempty"`
	// NotificationPreference - Notification preference for a job stage.
	NotificationPreference *[]NotificationPreference `json:"notificationPreference,omitempty"`
}

// BasicCopyLogDetails details for log generated during copy.
type BasicCopyLogDetails interface {
	AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool)
	AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool)
	AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool)
	AsCopyLogDetails() (*CopyLogDetails, bool)
}

// CopyLogDetails details for log generated during copy.
type CopyLogDetails struct {
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

func unmarshalBasicCopyLogDetails(body []byte) (BasicCopyLogDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["copyLogDetailsType"] {
	case string(CopyLogDetailsTypeDataBox):
		var acld AccountCopyLogDetails
		err := json.Unmarshal(body, &acld)
		return acld, err
	case string(CopyLogDetailsTypeDataBoxDisk):
		var dcld DiskCopyLogDetails
		err := json.Unmarshal(body, &dcld)
		return dcld, err
	case string(CopyLogDetailsTypeDataBoxHeavy):
		var hacld HeavyAccountCopyLogDetails
		err := json.Unmarshal(body, &hacld)
		return hacld, err
	default:
		var cld CopyLogDetails
		err := json.Unmarshal(body, &cld)
		return cld, err
	}
}
func unmarshalBasicCopyLogDetailsArray(body []byte) ([]BasicCopyLogDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cldArray := make([]BasicCopyLogDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cld, err := unmarshalBasicCopyLogDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		cldArray[index] = cld
	}
	return cldArray, nil
}

// MarshalJSON is the custom marshaler for CopyLogDetails.
func (cld CopyLogDetails) MarshalJSON() ([]byte, error) {
	cld.CopyLogDetailsType = CopyLogDetailsTypeCopyLogDetails
	objectMap := make(map[string]interface{})
	if cld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = cld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return &cld, true
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for CopyLogDetails.
func (cld CopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &cld, true
}

// CopyProgress copy progress.
type CopyProgress struct {
	// StorageAccountName - READ-ONLY; Name of the storage account. This will be empty for data account types other than storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// TransferType - READ-ONLY; Transfer type of data. Possible values include: 'ImportToAzure', 'ExportFromAzure'
	TransferType TransferType `json:"transferType,omitempty"`
	// DataAccountType - READ-ONLY; Data Account Type. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataAccountType DataAccountType `json:"dataAccountType,omitempty"`
	// AccountID - READ-ONLY; Id of the account where the data needs to be uploaded.
	AccountID *string `json:"accountId,omitempty"`
	// BytesProcessed - READ-ONLY; To indicate bytes transferred.
	BytesProcessed *int64 `json:"bytesProcessed,omitempty"`
	// TotalBytesToProcess - READ-ONLY; Total amount of data to be processed by the job.
	TotalBytesToProcess *int64 `json:"totalBytesToProcess,omitempty"`
	// FilesProcessed - READ-ONLY; Number of files processed
	FilesProcessed *int64 `json:"filesProcessed,omitempty"`
	// TotalFilesToProcess - READ-ONLY; Total files to process
	TotalFilesToProcess *int64 `json:"totalFilesToProcess,omitempty"`
	// InvalidFilesProcessed - READ-ONLY; Number of files not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFilesProcessed *int64 `json:"invalidFilesProcessed,omitempty"`
	// InvalidFileBytesUploaded - READ-ONLY; Total amount of data not adhering to azure naming conventions which were processed by automatic renaming
	InvalidFileBytesUploaded *int64 `json:"invalidFileBytesUploaded,omitempty"`
	// RenamedContainerCount - READ-ONLY; Number of folders not adhering to azure naming conventions which were processed by automatic renaming
	RenamedContainerCount *int64 `json:"renamedContainerCount,omitempty"`
	// FilesErroredOut - READ-ONLY; Number of files which could not be copied
	FilesErroredOut *int64 `json:"filesErroredOut,omitempty"`
	// DirectoriesErroredOut - READ-ONLY; To indicate directories errored out in the job.
	DirectoriesErroredOut *int64 `json:"directoriesErroredOut,omitempty"`
	// InvalidDirectoriesProcessed - READ-ONLY; To indicate directories renamed
	InvalidDirectoriesProcessed *int64 `json:"invalidDirectoriesProcessed,omitempty"`
	// IsEnumerationInProgress - READ-ONLY; To indicate if enumeration of data is in progress.
	// Until this is true, the TotalBytesToProcess may not be valid.
	IsEnumerationInProgress *bool `json:"isEnumerationInProgress,omitempty"`
}

// CreateJobValidations it does all pre-job creation validations.
type CreateJobValidations struct {
	// IndividualRequestDetails - List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails *[]BasicValidationInputRequest `json:"individualRequestDetails,omitempty"`
	// ValidationCategory - Possible values include: 'ValidationCategoryValidationRequest', 'ValidationCategoryJobCreationValidation'
	ValidationCategory ValidationCategory `json:"validationCategory,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateJobValidations.
func (cjv CreateJobValidations) MarshalJSON() ([]byte, error) {
	cjv.ValidationCategory = ValidationCategoryJobCreationValidation
	objectMap := make(map[string]interface{})
	if cjv.IndividualRequestDetails != nil {
		objectMap["individualRequestDetails"] = cjv.IndividualRequestDetails
	}
	if cjv.ValidationCategory != "" {
		objectMap["validationCategory"] = cjv.ValidationCategory
	}
	return json.Marshal(objectMap)
}

// AsCreateJobValidations is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsCreateJobValidations() (*CreateJobValidations, bool) {
	return &cjv, true
}

// AsValidationRequest is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsValidationRequest() (*ValidationRequest, bool) {
	return nil, false
}

// AsBasicValidationRequest is the BasicValidationRequest implementation for CreateJobValidations.
func (cjv CreateJobValidations) AsBasicValidationRequest() (BasicValidationRequest, bool) {
	return &cjv, true
}

// UnmarshalJSON is the custom unmarshaler for CreateJobValidations struct.
func (cjv *CreateJobValidations) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "individualRequestDetails":
			if v != nil {
				individualRequestDetails, err := unmarshalBasicValidationInputRequestArray(*v)
				if err != nil {
					return err
				}
				cjv.IndividualRequestDetails = &individualRequestDetails
			}
		case "validationCategory":
			if v != nil {
				var validationCategory ValidationCategory
				err = json.Unmarshal(*v, &validationCategory)
				if err != nil {
					return err
				}
				cjv.ValidationCategory = validationCategory
			}
		}
	}

	return nil
}

// CreateOrderLimitForSubscriptionValidationRequest request to validate create order limit for current
// subscription.
type CreateOrderLimitForSubscriptionValidationRequest struct {
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) MarshalJSON() ([]byte, error) {
	colfsvr.ValidationType = ValidationTypeValidateCreateOrderLimit
	objectMap := make(map[string]interface{})
	if colfsvr.DeviceType != "" {
		objectMap["deviceType"] = colfsvr.DeviceType
	}
	if colfsvr.ValidationType != "" {
		objectMap["validationType"] = colfsvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return &colfsvr, true
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for CreateOrderLimitForSubscriptionValidationRequest.
func (colfsvr CreateOrderLimitForSubscriptionValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &colfsvr, true
}

// CreateOrderLimitForSubscriptionValidationResponseProperties properties of create order limit for
// subscription validation response.
type CreateOrderLimitForSubscriptionValidationResponseProperties struct {
	// Status - READ-ONLY; Create order limit validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) MarshalJSON() ([]byte, error) {
	colfsvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit
	objectMap := make(map[string]interface{})
	if colfsvrp.ValidationType != "" {
		objectMap["validationType"] = colfsvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return &colfsvrp, true
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for CreateOrderLimitForSubscriptionValidationResponseProperties.
func (colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &colfsvrp, true
}

// BasicDataAccountDetails account details of the data to be transferred
type BasicDataAccountDetails interface {
	AsManagedDiskDetails() (*ManagedDiskDetails, bool)
	AsStorageAccountDetails() (*StorageAccountDetails, bool)
	AsDataAccountDetails() (*DataAccountDetails, bool)
}

// DataAccountDetails account details of the data to be transferred
type DataAccountDetails struct {
	// SharePassword - Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataAccountType - Possible values include: 'DataAccountTypeDataAccountDetails', 'DataAccountTypeManagedDisk', 'DataAccountTypeStorageAccount'
	DataAccountType DataAccountTypeBasicDataAccountDetails `json:"dataAccountType,omitempty"`
}

func unmarshalBasicDataAccountDetails(body []byte) (BasicDataAccountDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["dataAccountType"] {
	case string(DataAccountTypeManagedDisk):
		var mdd ManagedDiskDetails
		err := json.Unmarshal(body, &mdd)
		return mdd, err
	case string(DataAccountTypeStorageAccount):
		var sad StorageAccountDetails
		err := json.Unmarshal(body, &sad)
		return sad, err
	default:
		var dad DataAccountDetails
		err := json.Unmarshal(body, &dad)
		return dad, err
	}
}
func unmarshalBasicDataAccountDetailsArray(body []byte) ([]BasicDataAccountDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	dadArray := make([]BasicDataAccountDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dad, err := unmarshalBasicDataAccountDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		dadArray[index] = dad
	}
	return dadArray, nil
}

// MarshalJSON is the custom marshaler for DataAccountDetails.
func (dad DataAccountDetails) MarshalJSON() ([]byte, error) {
	dad.DataAccountType = DataAccountTypeDataAccountDetails
	objectMap := make(map[string]interface{})
	if dad.SharePassword != nil {
		objectMap["sharePassword"] = dad.SharePassword
	}
	if dad.DataAccountType != "" {
		objectMap["dataAccountType"] = dad.DataAccountType
	}
	return json.Marshal(objectMap)
}

// AsManagedDiskDetails is the BasicDataAccountDetails implementation for DataAccountDetails.
func (dad DataAccountDetails) AsManagedDiskDetails() (*ManagedDiskDetails, bool) {
	return nil, false
}

// AsStorageAccountDetails is the BasicDataAccountDetails implementation for DataAccountDetails.
func (dad DataAccountDetails) AsStorageAccountDetails() (*StorageAccountDetails, bool) {
	return nil, false
}

// AsDataAccountDetails is the BasicDataAccountDetails implementation for DataAccountDetails.
func (dad DataAccountDetails) AsDataAccountDetails() (*DataAccountDetails, bool) {
	return &dad, true
}

// AsBasicDataAccountDetails is the BasicDataAccountDetails implementation for DataAccountDetails.
func (dad DataAccountDetails) AsBasicDataAccountDetails() (BasicDataAccountDetails, bool) {
	return &dad, true
}

// DataExportDetails details of the data to be used for exporting data from azure.
type DataExportDetails struct {
	// TransferConfiguration - Configuration for the data transfer.
	TransferConfiguration *TransferConfiguration `json:"transferConfiguration,omitempty"`
	// LogCollectionLevel - Level of the logs to be collected. Possible values include: 'Error', 'Verbose'
	LogCollectionLevel LogCollectionLevel `json:"logCollectionLevel,omitempty"`
	// AccountDetails - Account details of the data to be transferred
	AccountDetails BasicDataAccountDetails `json:"accountDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataExportDetails struct.
func (ded *DataExportDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "transferConfiguration":
			if v != nil {
				var transferConfiguration TransferConfiguration
				err = json.Unmarshal(*v, &transferConfiguration)
				if err != nil {
					return err
				}
				ded.TransferConfiguration = &transferConfiguration
			}
		case "logCollectionLevel":
			if v != nil {
				var logCollectionLevel LogCollectionLevel
				err = json.Unmarshal(*v, &logCollectionLevel)
				if err != nil {
					return err
				}
				ded.LogCollectionLevel = logCollectionLevel
			}
		case "accountDetails":
			if v != nil {
				accountDetails, err := unmarshalBasicDataAccountDetails(*v)
				if err != nil {
					return err
				}
				ded.AccountDetails = accountDetails
			}
		}
	}

	return nil
}

// DataImportDetails details of the data to be used for importing data to azure.
type DataImportDetails struct {
	// AccountDetails - Account details of the data to be transferred
	AccountDetails BasicDataAccountDetails `json:"accountDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DataImportDetails struct.
func (did *DataImportDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "accountDetails":
			if v != nil {
				accountDetails, err := unmarshalBasicDataAccountDetails(*v)
				if err != nil {
					return err
				}
				did.AccountDetails = accountDetails
			}
		}
	}

	return nil
}

// DataLocationToServiceLocationMap map of data location to service location
type DataLocationToServiceLocationMap struct {
	// DataLocation - READ-ONLY; Location of the data.
	DataLocation *string `json:"dataLocation,omitempty"`
	// ServiceLocation - READ-ONLY; Location of the service.
	ServiceLocation *string `json:"serviceLocation,omitempty"`
}

// DataTransferDetailsValidationRequest request to validate export and import data details.
type DataTransferDetailsValidationRequest struct {
	// DataExportDetails - List of DataTransfer details to be used to export data from azure.
	DataExportDetails *[]DataExportDetails `json:"dataExportDetails,omitempty"`
	// DataImportDetails - List of DataTransfer details to be used to import data to azure.
	DataImportDetails *[]DataImportDetails `json:"dataImportDetails,omitempty"`
	// DeviceType - Device type. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// TransferType - Type of the transfer. Possible values include: 'ImportToAzure', 'ExportFromAzure'
	TransferType TransferType `json:"transferType,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) MarshalJSON() ([]byte, error) {
	dtdvr.ValidationType = ValidationTypeValidateDataTransferDetails
	objectMap := make(map[string]interface{})
	if dtdvr.DataExportDetails != nil {
		objectMap["dataExportDetails"] = dtdvr.DataExportDetails
	}
	if dtdvr.DataImportDetails != nil {
		objectMap["dataImportDetails"] = dtdvr.DataImportDetails
	}
	if dtdvr.DeviceType != "" {
		objectMap["deviceType"] = dtdvr.DeviceType
	}
	if dtdvr.TransferType != "" {
		objectMap["transferType"] = dtdvr.TransferType
	}
	if dtdvr.ValidationType != "" {
		objectMap["validationType"] = dtdvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return &dtdvr, true
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for DataTransferDetailsValidationRequest.
func (dtdvr DataTransferDetailsValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &dtdvr, true
}

// DataTransferDetailsValidationResponseProperties properties of data transfer details validation response.
type DataTransferDetailsValidationResponseProperties struct {
	// Status - READ-ONLY; Data transfer details validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) MarshalJSON() ([]byte, error) {
	dtdvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails
	objectMap := make(map[string]interface{})
	if dtdvrp.ValidationType != "" {
		objectMap["validationType"] = dtdvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return &dtdvrp, true
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for DataTransferDetailsValidationResponseProperties.
func (dtdvrp DataTransferDetailsValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &dtdvrp, true
}

// DcAccessSecurityCode dc access security code
type DcAccessSecurityCode struct {
	// ReverseDcAccessCode - Reverse Dc access security code.
	ReverseDcAccessCode *string `json:"reverseDcAccessCode,omitempty"`
	// ForwardDcAccessCode - Forward Dc access security code.
	ForwardDcAccessCode *string `json:"forwardDcAccessCode,omitempty"`
}

// Details ...
type Details struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// DiskCopyLogDetails copy Log Details for a disk
type DiskCopyLogDetails struct {
	// DiskSerialNumber - READ-ONLY; Disk Serial Number.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// ErrorLogLink - READ-ONLY; Link for copy error logs.
	ErrorLogLink *string `json:"errorLogLink,omitempty"`
	// VerboseLogLink - READ-ONLY; Link for copy verbose logs.
	VerboseLogLink *string `json:"verboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) MarshalJSON() ([]byte, error) {
	dcld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if dcld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = dcld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return &dcld, true
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return nil, false
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for DiskCopyLogDetails.
func (dcld DiskCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &dcld, true
}

// DiskCopyProgress dataBox Disk Copy Progress
type DiskCopyProgress struct {
	// SerialNumber - READ-ONLY; The serial number of the disk
	SerialNumber *string `json:"serialNumber,omitempty"`
	// BytesCopied - READ-ONLY; Bytes copied during the copy of disk.
	BytesCopied *int64 `json:"bytesCopied,omitempty"`
	// PercentComplete - READ-ONLY; Indicates the percentage completed for the copy of the disk.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// Status - READ-ONLY; The Status of the copy. Possible values include: 'NotStarted', 'InProgress', 'Completed', 'CompletedWithErrors', 'Failed', 'NotReturned', 'HardwareError', 'DeviceFormatted', 'DeviceMetadataModified', 'StorageAccountNotAccessible', 'UnsupportedData'
	Status CopyStatus `json:"status,omitempty"`
}

// DiskJobDetails dataBox Disk Job Details.
type DiskJobDetails struct {
	// PreferredDisks - User preference on what size disks are needed for the job. The map is from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but will be checked against an int.
	PreferredDisks map[string]*int32 `json:"preferredDisks"`
	// CopyProgress - READ-ONLY; Copy progress per disk.
	CopyProgress *[]DiskCopyProgress `json:"copyProgress,omitempty"`
	// DisksAndSizeDetails - READ-ONLY; Contains the map of disk serial number to the disk size being used for the job. Is returned only after the disks are shipped to the customer.
	DisksAndSizeDetails map[string]*int32 `json:"disksAndSizeDetails"`
	// Passkey - User entered passkey for DataBox Disk job.
	Passkey *string `json:"passkey,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DataImportDetails - Details of the data to be imported into azure.
	DataImportDetails *[]DataImportDetails `json:"dataImportDetails,omitempty"`
	// DataExportDetails - Details of the data to be exported from azure.
	DataExportDetails *[]DataExportDetails `json:"dataExportDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// KeyEncryptionKey - READ-ONLY; Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobDetails.
func (djd DiskJobDetails) MarshalJSON() ([]byte, error) {
	djd.JobDetailsType = JobDetailsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djd.PreferredDisks != nil {
		objectMap["preferredDisks"] = djd.PreferredDisks
	}
	if djd.Passkey != nil {
		objectMap["passkey"] = djd.Passkey
	}
	if djd.ContactDetails != nil {
		objectMap["contactDetails"] = djd.ContactDetails
	}
	if djd.ShippingAddress != nil {
		objectMap["shippingAddress"] = djd.ShippingAddress
	}
	if djd.DataImportDetails != nil {
		objectMap["dataImportDetails"] = djd.DataImportDetails
	}
	if djd.DataExportDetails != nil {
		objectMap["dataExportDetails"] = djd.DataExportDetails
	}
	if djd.Preferences != nil {
		objectMap["preferences"] = djd.Preferences
	}
	if djd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = djd.ExpectedDataSizeInTerabytes
	}
	if djd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = djd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return &djd, true
}

// AsHeavyJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for DiskJobDetails.
func (djd DiskJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &djd, true
}

// UnmarshalJSON is the custom unmarshaler for DiskJobDetails struct.
func (djd *DiskJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "preferredDisks":
			if v != nil {
				var preferredDisks map[string]*int32
				err = json.Unmarshal(*v, &preferredDisks)
				if err != nil {
					return err
				}
				djd.PreferredDisks = preferredDisks
			}
		case "copyProgress":
			if v != nil {
				var copyProgress []DiskCopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				djd.CopyProgress = &copyProgress
			}
		case "disksAndSizeDetails":
			if v != nil {
				var disksAndSizeDetails map[string]*int32
				err = json.Unmarshal(*v, &disksAndSizeDetails)
				if err != nil {
					return err
				}
				djd.DisksAndSizeDetails = disksAndSizeDetails
			}
		case "passkey":
			if v != nil {
				var passkey string
				err = json.Unmarshal(*v, &passkey)
				if err != nil {
					return err
				}
				djd.Passkey = &passkey
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				djd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				djd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				djd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				djd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				djd.ReturnPackage = &returnPackage
			}
		case "dataImportDetails":
			if v != nil {
				var dataImportDetails []DataImportDetails
				err = json.Unmarshal(*v, &dataImportDetails)
				if err != nil {
					return err
				}
				djd.DataImportDetails = &dataImportDetails
			}
		case "dataExportDetails":
			if v != nil {
				var dataExportDetails []DataExportDetails
				err = json.Unmarshal(*v, &dataExportDetails)
				if err != nil {
					return err
				}
				djd.DataExportDetails = &dataExportDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				djd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				djd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				djd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				djd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "keyEncryptionKey":
			if v != nil {
				var keyEncryptionKey KeyEncryptionKey
				err = json.Unmarshal(*v, &keyEncryptionKey)
				if err != nil {
					return err
				}
				djd.KeyEncryptionKey = &keyEncryptionKey
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				djd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				djd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// DiskJobSecrets the secrets related to disk job.
type DiskJobSecrets struct {
	// DiskSecrets - READ-ONLY; Contains the list of secrets object for that device.
	DiskSecrets *[]DiskSecret `json:"diskSecrets,omitempty"`
	// PassKey - READ-ONLY; PassKey for the disk Job.
	PassKey *string `json:"passKey,omitempty"`
	// IsPasskeyUserDefined - READ-ONLY; Whether passkey was provided by user.
	IsPasskeyUserDefined *bool `json:"isPasskeyUserDefined,omitempty"`
	// DcAccessSecurityCode - READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// Error - READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskJobSecrets.
func (djs DiskJobSecrets) MarshalJSON() ([]byte, error) {
	djs.JobSecretsType = JobSecretsTypeDataBoxDisk
	objectMap := make(map[string]interface{})
	if djs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = djs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return &djs, true
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for DiskJobSecrets.
func (djs DiskJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &djs, true
}

// DiskScheduleAvailabilityRequest request body to get the availability for scheduling disk orders.
type DiskScheduleAvailabilityRequest struct {
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// StorageLocation - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// Country - Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	dsar.SkuName = SkuNameDataBoxDisk
	objectMap := make(map[string]interface{})
	if dsar.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = dsar.ExpectedDataSizeInTerabytes
	}
	if dsar.StorageLocation != nil {
		objectMap["storageLocation"] = dsar.StorageLocation
	}
	if dsar.Country != nil {
		objectMap["country"] = dsar.Country
	}
	if dsar.SkuName != "" {
		objectMap["skuName"] = dsar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return &dsar, true
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for DiskScheduleAvailabilityRequest.
func (dsar DiskScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &dsar, true
}

// DiskSecret contains all the secrets of a Disk.
type DiskSecret struct {
	// DiskSerialNumber - READ-ONLY; Serial number of the assigned disk.
	DiskSerialNumber *string `json:"diskSerialNumber,omitempty"`
	// BitLockerKey - READ-ONLY; Bit Locker key of the disk which can be used to unlock the disk to copy data.
	BitLockerKey *string `json:"bitLockerKey,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	Code    *string    `json:"code,omitempty"`
	Message *string    `json:"message,omitempty"`
	Details *[]Details `json:"details,omitempty"`
	Target  *string    `json:"target,omitempty"`
}

// FilterFileDetails details of the filter files to be used for data transfer.
type FilterFileDetails struct {
	// FilterFileType - Type of the filter file. Possible values include: 'AzureBlob', 'AzureFile'
	FilterFileType FilterFileType `json:"filterFileType,omitempty"`
	// FilterFilePath - Path of the file that contains the details of all items to transfer.
	FilterFilePath *string `json:"filterFilePath,omitempty"`
}

// HeavyAccountCopyLogDetails copy log details for a storage account for Databox heavy
type HeavyAccountCopyLogDetails struct {
	// AccountName - READ-ONLY; Account name.
	AccountName *string `json:"accountName,omitempty"`
	// CopyLogLink - READ-ONLY; Link for copy logs.
	CopyLogLink *[]string `json:"copyLogLink,omitempty"`
	// CopyVerboseLogLink - READ-ONLY; Link for copy verbose logs. This will be set only when the LogCollectionLevel is set to verbose.
	CopyVerboseLogLink *[]string `json:"copyVerboseLogLink,omitempty"`
	// CopyLogDetailsType - Possible values include: 'CopyLogDetailsTypeCopyLogDetails', 'CopyLogDetailsTypeDataBox', 'CopyLogDetailsTypeDataBoxDisk', 'CopyLogDetailsTypeDataBoxHeavy'
	CopyLogDetailsType CopyLogDetailsType `json:"copyLogDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) MarshalJSON() ([]byte, error) {
	hacld.CopyLogDetailsType = CopyLogDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hacld.CopyLogDetailsType != "" {
		objectMap["copyLogDetailsType"] = hacld.CopyLogDetailsType
	}
	return json.Marshal(objectMap)
}

// AsAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsAccountCopyLogDetails() (*AccountCopyLogDetails, bool) {
	return nil, false
}

// AsDiskCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsDiskCopyLogDetails() (*DiskCopyLogDetails, bool) {
	return nil, false
}

// AsHeavyAccountCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsHeavyAccountCopyLogDetails() (*HeavyAccountCopyLogDetails, bool) {
	return &hacld, true
}

// AsCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsCopyLogDetails() (*CopyLogDetails, bool) {
	return nil, false
}

// AsBasicCopyLogDetails is the BasicCopyLogDetails implementation for HeavyAccountCopyLogDetails.
func (hacld HeavyAccountCopyLogDetails) AsBasicCopyLogDetails() (BasicCopyLogDetails, bool) {
	return &hacld, true
}

// HeavyJobDetails databox Heavy Device Job Details
type HeavyJobDetails struct {
	// CopyProgress - READ-ONLY; Copy progress per account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// DevicePassword - Set Device password for unlocking Databox Heavy. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
	DevicePassword *string `json:"devicePassword,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DataImportDetails - Details of the data to be imported into azure.
	DataImportDetails *[]DataImportDetails `json:"dataImportDetails,omitempty"`
	// DataExportDetails - Details of the data to be exported from azure.
	DataExportDetails *[]DataExportDetails `json:"dataExportDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// KeyEncryptionKey - READ-ONLY; Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobDetails.
func (hjd HeavyJobDetails) MarshalJSON() ([]byte, error) {
	hjd.JobDetailsType = JobDetailsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjd.DevicePassword != nil {
		objectMap["devicePassword"] = hjd.DevicePassword
	}
	if hjd.ContactDetails != nil {
		objectMap["contactDetails"] = hjd.ContactDetails
	}
	if hjd.ShippingAddress != nil {
		objectMap["shippingAddress"] = hjd.ShippingAddress
	}
	if hjd.DataImportDetails != nil {
		objectMap["dataImportDetails"] = hjd.DataImportDetails
	}
	if hjd.DataExportDetails != nil {
		objectMap["dataExportDetails"] = hjd.DataExportDetails
	}
	if hjd.Preferences != nil {
		objectMap["preferences"] = hjd.Preferences
	}
	if hjd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = hjd.ExpectedDataSizeInTerabytes
	}
	if hjd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = hjd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return &hjd, true
}

// AsJobDetailsType is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for HeavyJobDetails.
func (hjd HeavyJobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &hjd, true
}

// UnmarshalJSON is the custom unmarshaler for HeavyJobDetails struct.
func (hjd *HeavyJobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				hjd.CopyProgress = &copyProgress
			}
		case "devicePassword":
			if v != nil {
				var devicePassword string
				err = json.Unmarshal(*v, &devicePassword)
				if err != nil {
					return err
				}
				hjd.DevicePassword = &devicePassword
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				hjd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				hjd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				hjd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				hjd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				hjd.ReturnPackage = &returnPackage
			}
		case "dataImportDetails":
			if v != nil {
				var dataImportDetails []DataImportDetails
				err = json.Unmarshal(*v, &dataImportDetails)
				if err != nil {
					return err
				}
				hjd.DataImportDetails = &dataImportDetails
			}
		case "dataExportDetails":
			if v != nil {
				var dataExportDetails []DataExportDetails
				err = json.Unmarshal(*v, &dataExportDetails)
				if err != nil {
					return err
				}
				hjd.DataExportDetails = &dataExportDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				hjd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				hjd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				hjd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				hjd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "keyEncryptionKey":
			if v != nil {
				var keyEncryptionKey KeyEncryptionKey
				err = json.Unmarshal(*v, &keyEncryptionKey)
				if err != nil {
					return err
				}
				hjd.KeyEncryptionKey = &keyEncryptionKey
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				hjd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				hjd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// HeavyJobSecrets the secrets related to a databox heavy job.
type HeavyJobSecrets struct {
	// CabinetPodSecrets - READ-ONLY; Contains the list of secret objects for a databox heavy job.
	CabinetPodSecrets *[]HeavySecret `json:"cabinetPodSecrets,omitempty"`
	// DcAccessSecurityCode - READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// Error - READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyJobSecrets.
func (hjs HeavyJobSecrets) MarshalJSON() ([]byte, error) {
	hjs.JobSecretsType = JobSecretsTypeDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hjs.JobSecretsType != "" {
		objectMap["jobSecretsType"] = hjs.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return &hjs, true
}

// AsJobSecretsType is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for HeavyJobSecrets.
func (hjs HeavyJobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &hjs, true
}

// HeavyScheduleAvailabilityRequest request body to get the availability for scheduling heavy orders.
type HeavyScheduleAvailabilityRequest struct {
	// StorageLocation - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// Country - Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	hsar.SkuName = SkuNameDataBoxHeavy
	objectMap := make(map[string]interface{})
	if hsar.StorageLocation != nil {
		objectMap["storageLocation"] = hsar.StorageLocation
	}
	if hsar.Country != nil {
		objectMap["country"] = hsar.Country
	}
	if hsar.SkuName != "" {
		objectMap["skuName"] = hsar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return &hsar, true
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for HeavyScheduleAvailabilityRequest.
func (hsar HeavyScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &hsar, true
}

// HeavySecret the secrets related to a databox heavy.
type HeavySecret struct {
	// DeviceSerialNumber - READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - READ-ONLY; Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// JobDeliveryInfo additional delivery info.
type JobDeliveryInfo struct {
	// ScheduledDateTime - Scheduled date time.
	ScheduledDateTime *date.Time `json:"scheduledDateTime,omitempty"`
}

// BasicJobDetails job details.
type BasicJobDetails interface {
	AsDiskJobDetails() (*DiskJobDetails, bool)
	AsHeavyJobDetails() (*HeavyJobDetails, bool)
	AsJobDetailsType() (*JobDetailsType, bool)
	AsJobDetails() (*JobDetails, bool)
}

// JobDetails job details.
type JobDetails struct {
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DataImportDetails - Details of the data to be imported into azure.
	DataImportDetails *[]DataImportDetails `json:"dataImportDetails,omitempty"`
	// DataExportDetails - Details of the data to be exported from azure.
	DataExportDetails *[]DataExportDetails `json:"dataExportDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// KeyEncryptionKey - READ-ONLY; Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

func unmarshalBasicJobDetails(body []byte) (BasicJobDetails, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobDetailsType"] {
	case string(JobDetailsTypeDataBoxDisk):
		var djd DiskJobDetails
		err := json.Unmarshal(body, &djd)
		return djd, err
	case string(JobDetailsTypeDataBoxHeavy):
		var hjd HeavyJobDetails
		err := json.Unmarshal(body, &hjd)
		return hjd, err
	case string(JobDetailsTypeDataBox):
		var jdt JobDetailsType
		err := json.Unmarshal(body, &jdt)
		return jdt, err
	default:
		var jd JobDetails
		err := json.Unmarshal(body, &jd)
		return jd, err
	}
}
func unmarshalBasicJobDetailsArray(body []byte) ([]BasicJobDetails, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jdArray := make([]BasicJobDetails, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jd, err := unmarshalBasicJobDetails(*rawMessage)
		if err != nil {
			return nil, err
		}
		jdArray[index] = jd
	}
	return jdArray, nil
}

// MarshalJSON is the custom marshaler for JobDetails.
func (jd JobDetails) MarshalJSON() ([]byte, error) {
	jd.JobDetailsType = JobDetailsTypeJobDetails
	objectMap := make(map[string]interface{})
	if jd.ContactDetails != nil {
		objectMap["contactDetails"] = jd.ContactDetails
	}
	if jd.ShippingAddress != nil {
		objectMap["shippingAddress"] = jd.ShippingAddress
	}
	if jd.DataImportDetails != nil {
		objectMap["dataImportDetails"] = jd.DataImportDetails
	}
	if jd.DataExportDetails != nil {
		objectMap["dataExportDetails"] = jd.DataExportDetails
	}
	if jd.Preferences != nil {
		objectMap["preferences"] = jd.Preferences
	}
	if jd.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = jd.ExpectedDataSizeInTerabytes
	}
	if jd.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jd.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetailsType() (*JobDetailsType, bool) {
	return nil, false
}

// AsJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsJobDetails() (*JobDetails, bool) {
	return &jd, true
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetails.
func (jd JobDetails) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jd, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetails struct.
func (jd *JobDetails) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jd.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jd.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jd.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jd.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jd.ReturnPackage = &returnPackage
			}
		case "dataImportDetails":
			if v != nil {
				var dataImportDetails []DataImportDetails
				err = json.Unmarshal(*v, &dataImportDetails)
				if err != nil {
					return err
				}
				jd.DataImportDetails = &dataImportDetails
			}
		case "dataExportDetails":
			if v != nil {
				var dataExportDetails []DataExportDetails
				err = json.Unmarshal(*v, &dataExportDetails)
				if err != nil {
					return err
				}
				jd.DataExportDetails = &dataExportDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jd.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jd.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jd.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jd.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "keyEncryptionKey":
			if v != nil {
				var keyEncryptionKey KeyEncryptionKey
				err = json.Unmarshal(*v, &keyEncryptionKey)
				if err != nil {
					return err
				}
				jd.KeyEncryptionKey = &keyEncryptionKey
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				jd.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jd.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobDetailsType databox Job Details
type JobDetailsType struct {
	// CopyProgress - READ-ONLY; Copy progress per storage account.
	CopyProgress *[]CopyProgress `json:"copyProgress,omitempty"`
	// DevicePassword - Set Device password for unlocking Databox. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
	DevicePassword *string `json:"devicePassword,omitempty"`
	// JobStages - READ-ONLY; List of stages that run in the job.
	JobStages *[]JobStages `json:"jobStages,omitempty"`
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeliveryPackage - READ-ONLY; Delivery package shipping details.
	DeliveryPackage *PackageShippingDetails `json:"deliveryPackage,omitempty"`
	// ReturnPackage - READ-ONLY; Return package shipping details.
	ReturnPackage *PackageShippingDetails `json:"returnPackage,omitempty"`
	// DataImportDetails - Details of the data to be imported into azure.
	DataImportDetails *[]DataImportDetails `json:"dataImportDetails,omitempty"`
	// DataExportDetails - Details of the data to be exported from azure.
	DataExportDetails *[]DataExportDetails `json:"dataExportDetails,omitempty"`
	// Preferences - Preferences for the order.
	Preferences *Preferences `json:"preferences,omitempty"`
	// CopyLogDetails - READ-ONLY; List of copy log details.
	CopyLogDetails *[]BasicCopyLogDetails `json:"copyLogDetails,omitempty"`
	// ReverseShipmentLabelSasKey - READ-ONLY; Shared access key to download the return shipment label
	ReverseShipmentLabelSasKey *string `json:"reverseShipmentLabelSasKey,omitempty"`
	// ChainOfCustodySasKey - READ-ONLY; Shared access key to download the chain of custody logs
	ChainOfCustodySasKey *string `json:"chainOfCustodySasKey,omitempty"`
	// KeyEncryptionKey - READ-ONLY; Details about which key encryption type is being used.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`
	// ExpectedDataSizeInTerabytes - The expected size of the data, which needs to be transferred in this job, in terabytes.
	ExpectedDataSizeInTerabytes *int32 `json:"expectedDataSizeInTerabytes,omitempty"`
	// JobDetailsType - Possible values include: 'JobDetailsTypeJobDetails', 'JobDetailsTypeDataBoxDisk', 'JobDetailsTypeDataBoxHeavy', 'JobDetailsTypeDataBox'
	JobDetailsType JobDetailsTypeEnum `json:"jobDetailsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobDetailsType.
func (jdt JobDetailsType) MarshalJSON() ([]byte, error) {
	jdt.JobDetailsType = JobDetailsTypeDataBox
	objectMap := make(map[string]interface{})
	if jdt.DevicePassword != nil {
		objectMap["devicePassword"] = jdt.DevicePassword
	}
	if jdt.ContactDetails != nil {
		objectMap["contactDetails"] = jdt.ContactDetails
	}
	if jdt.ShippingAddress != nil {
		objectMap["shippingAddress"] = jdt.ShippingAddress
	}
	if jdt.DataImportDetails != nil {
		objectMap["dataImportDetails"] = jdt.DataImportDetails
	}
	if jdt.DataExportDetails != nil {
		objectMap["dataExportDetails"] = jdt.DataExportDetails
	}
	if jdt.Preferences != nil {
		objectMap["preferences"] = jdt.Preferences
	}
	if jdt.ExpectedDataSizeInTerabytes != nil {
		objectMap["expectedDataSizeInTerabytes"] = jdt.ExpectedDataSizeInTerabytes
	}
	if jdt.JobDetailsType != "" {
		objectMap["jobDetailsType"] = jdt.JobDetailsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsDiskJobDetails() (*DiskJobDetails, bool) {
	return nil, false
}

// AsHeavyJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsHeavyJobDetails() (*HeavyJobDetails, bool) {
	return nil, false
}

// AsJobDetailsType is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetailsType() (*JobDetailsType, bool) {
	return &jdt, true
}

// AsJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsJobDetails() (*JobDetails, bool) {
	return nil, false
}

// AsBasicJobDetails is the BasicJobDetails implementation for JobDetailsType.
func (jdt JobDetailsType) AsBasicJobDetails() (BasicJobDetails, bool) {
	return &jdt, true
}

// UnmarshalJSON is the custom unmarshaler for JobDetailsType struct.
func (jdt *JobDetailsType) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "copyProgress":
			if v != nil {
				var copyProgress []CopyProgress
				err = json.Unmarshal(*v, &copyProgress)
				if err != nil {
					return err
				}
				jdt.CopyProgress = &copyProgress
			}
		case "devicePassword":
			if v != nil {
				var devicePassword string
				err = json.Unmarshal(*v, &devicePassword)
				if err != nil {
					return err
				}
				jdt.DevicePassword = &devicePassword
			}
		case "jobStages":
			if v != nil {
				var jobStages []JobStages
				err = json.Unmarshal(*v, &jobStages)
				if err != nil {
					return err
				}
				jdt.JobStages = &jobStages
			}
		case "contactDetails":
			if v != nil {
				var contactDetails ContactDetails
				err = json.Unmarshal(*v, &contactDetails)
				if err != nil {
					return err
				}
				jdt.ContactDetails = &contactDetails
			}
		case "shippingAddress":
			if v != nil {
				var shippingAddress ShippingAddress
				err = json.Unmarshal(*v, &shippingAddress)
				if err != nil {
					return err
				}
				jdt.ShippingAddress = &shippingAddress
			}
		case "deliveryPackage":
			if v != nil {
				var deliveryPackage PackageShippingDetails
				err = json.Unmarshal(*v, &deliveryPackage)
				if err != nil {
					return err
				}
				jdt.DeliveryPackage = &deliveryPackage
			}
		case "returnPackage":
			if v != nil {
				var returnPackage PackageShippingDetails
				err = json.Unmarshal(*v, &returnPackage)
				if err != nil {
					return err
				}
				jdt.ReturnPackage = &returnPackage
			}
		case "dataImportDetails":
			if v != nil {
				var dataImportDetails []DataImportDetails
				err = json.Unmarshal(*v, &dataImportDetails)
				if err != nil {
					return err
				}
				jdt.DataImportDetails = &dataImportDetails
			}
		case "dataExportDetails":
			if v != nil {
				var dataExportDetails []DataExportDetails
				err = json.Unmarshal(*v, &dataExportDetails)
				if err != nil {
					return err
				}
				jdt.DataExportDetails = &dataExportDetails
			}
		case "preferences":
			if v != nil {
				var preferences Preferences
				err = json.Unmarshal(*v, &preferences)
				if err != nil {
					return err
				}
				jdt.Preferences = &preferences
			}
		case "copyLogDetails":
			if v != nil {
				copyLogDetails, err := unmarshalBasicCopyLogDetailsArray(*v)
				if err != nil {
					return err
				}
				jdt.CopyLogDetails = &copyLogDetails
			}
		case "reverseShipmentLabelSasKey":
			if v != nil {
				var reverseShipmentLabelSasKey string
				err = json.Unmarshal(*v, &reverseShipmentLabelSasKey)
				if err != nil {
					return err
				}
				jdt.ReverseShipmentLabelSasKey = &reverseShipmentLabelSasKey
			}
		case "chainOfCustodySasKey":
			if v != nil {
				var chainOfCustodySasKey string
				err = json.Unmarshal(*v, &chainOfCustodySasKey)
				if err != nil {
					return err
				}
				jdt.ChainOfCustodySasKey = &chainOfCustodySasKey
			}
		case "keyEncryptionKey":
			if v != nil {
				var keyEncryptionKey KeyEncryptionKey
				err = json.Unmarshal(*v, &keyEncryptionKey)
				if err != nil {
					return err
				}
				jdt.KeyEncryptionKey = &keyEncryptionKey
			}
		case "expectedDataSizeInTerabytes":
			if v != nil {
				var expectedDataSizeInTerabytes int32
				err = json.Unmarshal(*v, &expectedDataSizeInTerabytes)
				if err != nil {
					return err
				}
				jdt.ExpectedDataSizeInTerabytes = &expectedDataSizeInTerabytes
			}
		case "jobDetailsType":
			if v != nil {
				var jobDetailsType JobDetailsTypeEnum
				err = json.Unmarshal(*v, &jobDetailsType)
				if err != nil {
					return err
				}
				jdt.JobDetailsType = jobDetailsType
			}
		}
	}

	return nil
}

// JobProperties job Properties
type JobProperties struct {
	// TransferType - Type of the data transfer. Possible values include: 'ImportToAzure', 'ExportFromAzure'
	TransferType TransferType `json:"transferType,omitempty"`
	// IsCancellable - READ-ONLY; Describes whether the job is cancellable or not.
	IsCancellable *bool `json:"isCancellable,omitempty"`
	// IsDeletable - READ-ONLY; Describes whether the job is deletable or not.
	IsDeletable *bool `json:"isDeletable,omitempty"`
	// IsShippingAddressEditable - READ-ONLY; Describes whether the shipping address is editable or not.
	IsShippingAddressEditable *bool `json:"isShippingAddressEditable,omitempty"`
	// IsPrepareToShipEnabled - READ-ONLY; Is Prepare To Ship Enabled on this job
	IsPrepareToShipEnabled *bool `json:"isPrepareToShipEnabled,omitempty"`
	// Status - READ-ONLY; Name of the stage which is in progress. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted', 'StageNameCompletedWithWarnings', 'StageNameReadyToDispatchFromAzureDC', 'StageNameReadyToReceiveAtAzureDC'
	Status StageName `json:"status,omitempty"`
	// StartTime - READ-ONLY; Time at which the job was started in UTC ISO 8601 format.
	StartTime *date.Time `json:"startTime,omitempty"`
	// Error - READ-ONLY; Top level error for the job.
	Error *CloudError `json:"error,omitempty"`
	// Details - Details of a job run. This field will only be sent for expand details filter.
	Details BasicJobDetails `json:"details,omitempty"`
	// CancellationReason - READ-ONLY; Reason for cancellation.
	CancellationReason *string `json:"cancellationReason,omitempty"`
	// DeliveryType - Delivery type of Job. Possible values include: 'NonScheduled', 'Scheduled'
	DeliveryType JobDeliveryType `json:"deliveryType,omitempty"`
	// DeliveryInfo - Delivery Info of Job.
	DeliveryInfo *JobDeliveryInfo `json:"deliveryInfo,omitempty"`
	// IsCancellableWithoutFee - READ-ONLY; Flag to indicate cancellation of scheduled job.
	IsCancellableWithoutFee *bool `json:"isCancellableWithoutFee,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.TransferType != "" {
		objectMap["transferType"] = jp.TransferType
	}
	objectMap["details"] = jp.Details
	if jp.DeliveryType != "" {
		objectMap["deliveryType"] = jp.DeliveryType
	}
	if jp.DeliveryInfo != nil {
		objectMap["deliveryInfo"] = jp.DeliveryInfo
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "transferType":
			if v != nil {
				var transferType TransferType
				err = json.Unmarshal(*v, &transferType)
				if err != nil {
					return err
				}
				jp.TransferType = transferType
			}
		case "isCancellable":
			if v != nil {
				var isCancellable bool
				err = json.Unmarshal(*v, &isCancellable)
				if err != nil {
					return err
				}
				jp.IsCancellable = &isCancellable
			}
		case "isDeletable":
			if v != nil {
				var isDeletable bool
				err = json.Unmarshal(*v, &isDeletable)
				if err != nil {
					return err
				}
				jp.IsDeletable = &isDeletable
			}
		case "isShippingAddressEditable":
			if v != nil {
				var isShippingAddressEditable bool
				err = json.Unmarshal(*v, &isShippingAddressEditable)
				if err != nil {
					return err
				}
				jp.IsShippingAddressEditable = &isShippingAddressEditable
			}
		case "isPrepareToShipEnabled":
			if v != nil {
				var isPrepareToShipEnabled bool
				err = json.Unmarshal(*v, &isPrepareToShipEnabled)
				if err != nil {
					return err
				}
				jp.IsPrepareToShipEnabled = &isPrepareToShipEnabled
			}
		case "status":
			if v != nil {
				var status StageName
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				jp.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "error":
			if v != nil {
				var errorVar CloudError
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				jp.Error = &errorVar
			}
		case "details":
			if v != nil {
				details, err := unmarshalBasicJobDetails(*v)
				if err != nil {
					return err
				}
				jp.Details = details
			}
		case "cancellationReason":
			if v != nil {
				var cancellationReason string
				err = json.Unmarshal(*v, &cancellationReason)
				if err != nil {
					return err
				}
				jp.CancellationReason = &cancellationReason
			}
		case "deliveryType":
			if v != nil {
				var deliveryType JobDeliveryType
				err = json.Unmarshal(*v, &deliveryType)
				if err != nil {
					return err
				}
				jp.DeliveryType = deliveryType
			}
		case "deliveryInfo":
			if v != nil {
				var deliveryInfo JobDeliveryInfo
				err = json.Unmarshal(*v, &deliveryInfo)
				if err != nil {
					return err
				}
				jp.DeliveryInfo = &deliveryInfo
			}
		case "isCancellableWithoutFee":
			if v != nil {
				var isCancellableWithoutFee bool
				err = json.Unmarshal(*v, &isCancellableWithoutFee)
				if err != nil {
					return err
				}
				jp.IsCancellableWithoutFee = &isCancellableWithoutFee
			}
		}
	}

	return nil
}

// JobResource job Resource.
type JobResource struct {
	autorest.Response `json:"-"`
	// JobProperties - Properties of a job.
	*JobProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; Name of the object.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the object.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the object.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jr.JobProperties != nil {
		objectMap["properties"] = jr.JobProperties
	}
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.Sku != nil {
		objectMap["sku"] = jr.Sku
	}
	if jr.Identity != nil {
		objectMap["identity"] = jr.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				jr.JobProperties = &jobProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				jr.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				jr.Identity = &identity
			}
		}
	}

	return nil
}

// JobResourceList job Resource Collection
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of job resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - Link for the next set of job resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResourceListIterator type.
func NewJobResourceListIterator(page JobResourceListPage) JobResourceListIterator {
	return JobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jrl JobResourceList) hasNextLink() bool {
	return jrl.NextLink != nil && len(*jrl.NextLink) != 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !jrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(context.Context, JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jrl)
		if err != nil {
			return err
		}
		page.jrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// Creates a new instance of the JobResourceListPage type.
func NewJobResourceListPage(cur JobResourceList, getNextPage func(context.Context, JobResourceList) (JobResourceList, error)) JobResourceListPage {
	return JobResourceListPage{
		fn:  getNextPage,
		jrl: cur,
	}
}

// JobResourceUpdateParameter the JobResourceUpdateParameter.
type JobResourceUpdateParameter struct {
	// UpdateJobProperties - Properties of a job to be updated.
	*UpdateJobProperties `json:"properties,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Identity - Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResourceUpdateParameter.
func (jrup JobResourceUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jrup.UpdateJobProperties != nil {
		objectMap["properties"] = jrup.UpdateJobProperties
	}
	if jrup.Tags != nil {
		objectMap["tags"] = jrup.Tags
	}
	if jrup.Identity != nil {
		objectMap["identity"] = jrup.Identity
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResourceUpdateParameter struct.
func (jrup *JobResourceUpdateParameter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var updateJobProperties UpdateJobProperties
				err = json.Unmarshal(*v, &updateJobProperties)
				if err != nil {
					return err
				}
				jrup.UpdateJobProperties = &updateJobProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jrup.Tags = tags
			}
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				jrup.Identity = &identity
			}
		}
	}

	return nil
}

// JobsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (JobResource, error)
}

// JobsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (autorest.Response, error)
}

// BasicJobSecrets the base class for the secrets
type BasicJobSecrets interface {
	AsDiskJobSecrets() (*DiskJobSecrets, bool)
	AsHeavyJobSecrets() (*HeavyJobSecrets, bool)
	AsJobSecretsType() (*JobSecretsType, bool)
	AsJobSecrets() (*JobSecrets, bool)
}

// JobSecrets the base class for the secrets
type JobSecrets struct {
	// DcAccessSecurityCode - READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// Error - READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

func unmarshalBasicJobSecrets(body []byte) (BasicJobSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobSecretsType"] {
	case string(JobSecretsTypeDataBoxDisk):
		var djs DiskJobSecrets
		err := json.Unmarshal(body, &djs)
		return djs, err
	case string(JobSecretsTypeDataBoxHeavy):
		var hjs HeavyJobSecrets
		err := json.Unmarshal(body, &hjs)
		return hjs, err
	case string(JobSecretsTypeDataBox):
		var jst JobSecretsType
		err := json.Unmarshal(body, &jst)
		return jst, err
	default:
		var js JobSecrets
		err := json.Unmarshal(body, &js)
		return js, err
	}
}
func unmarshalBasicJobSecretsArray(body []byte) ([]BasicJobSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jsArray := make([]BasicJobSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		js, err := unmarshalBasicJobSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		jsArray[index] = js
	}
	return jsArray, nil
}

// MarshalJSON is the custom marshaler for JobSecrets.
func (js JobSecrets) MarshalJSON() ([]byte, error) {
	js.JobSecretsType = JobSecretsTypeJobSecrets
	objectMap := make(map[string]interface{})
	if js.JobSecretsType != "" {
		objectMap["jobSecretsType"] = js.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecretsType() (*JobSecretsType, bool) {
	return nil, false
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsJobSecrets() (*JobSecrets, bool) {
	return &js, true
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecrets.
func (js JobSecrets) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &js, true
}

// JobSecretsType the secrets related to a databox job.
type JobSecretsType struct {
	// PodSecrets - Contains the list of secret objects for a job.
	PodSecrets *[]Secret `json:"podSecrets,omitempty"`
	// DcAccessSecurityCode - READ-ONLY; Dc Access Security Code for Customer Managed Shipping
	DcAccessSecurityCode *DcAccessSecurityCode `json:"dcAccessSecurityCode,omitempty"`
	// Error - READ-ONLY; Error while fetching the secrets.
	Error *CloudError `json:"error,omitempty"`
	// JobSecretsType - Possible values include: 'JobSecretsTypeJobSecrets', 'JobSecretsTypeDataBoxDisk', 'JobSecretsTypeDataBoxHeavy', 'JobSecretsTypeDataBox'
	JobSecretsType JobSecretsTypeEnum `json:"jobSecretsType,omitempty"`
}

// MarshalJSON is the custom marshaler for JobSecretsType.
func (jst JobSecretsType) MarshalJSON() ([]byte, error) {
	jst.JobSecretsType = JobSecretsTypeDataBox
	objectMap := make(map[string]interface{})
	if jst.PodSecrets != nil {
		objectMap["podSecrets"] = jst.PodSecrets
	}
	if jst.JobSecretsType != "" {
		objectMap["jobSecretsType"] = jst.JobSecretsType
	}
	return json.Marshal(objectMap)
}

// AsDiskJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsDiskJobSecrets() (*DiskJobSecrets, bool) {
	return nil, false
}

// AsHeavyJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsHeavyJobSecrets() (*HeavyJobSecrets, bool) {
	return nil, false
}

// AsJobSecretsType is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecretsType() (*JobSecretsType, bool) {
	return &jst, true
}

// AsJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsJobSecrets() (*JobSecrets, bool) {
	return nil, false
}

// AsBasicJobSecrets is the BasicJobSecrets implementation for JobSecretsType.
func (jst JobSecretsType) AsBasicJobSecrets() (BasicJobSecrets, bool) {
	return &jst, true
}

// JobStages job stages.
type JobStages struct {
	// StageName - READ-ONLY; Name of the job stage. Possible values include: 'StageNameDeviceOrdered', 'StageNameDevicePrepared', 'StageNameDispatched', 'StageNameDelivered', 'StageNamePickedUp', 'StageNameAtAzureDC', 'StageNameDataCopy', 'StageNameCompleted', 'StageNameCompletedWithErrors', 'StageNameCancelled', 'StageNameFailedIssueReportedAtCustomer', 'StageNameFailedIssueDetectedAtAzureDC', 'StageNameAborted', 'StageNameCompletedWithWarnings', 'StageNameReadyToDispatchFromAzureDC', 'StageNameReadyToReceiveAtAzureDC'
	StageName StageName `json:"stageName,omitempty"`
	// DisplayName - READ-ONLY; Display name of the job stage.
	DisplayName *string `json:"displayName,omitempty"`
	// StageStatus - READ-ONLY; Status of the job stage. Possible values include: 'StageStatusNone', 'StageStatusInProgress', 'StageStatusSucceeded', 'StageStatusFailed', 'StageStatusCancelled', 'StageStatusCancelling', 'StageStatusSucceededWithErrors', 'StageStatusWaitingForCustomerAction', 'StageStatusSucceededWithWarnings'
	StageStatus StageStatus `json:"stageStatus,omitempty"`
	// StageTime - READ-ONLY; Time for the job stage in UTC ISO 8601 format.
	StageTime *date.Time `json:"stageTime,omitempty"`
	// JobStageDetails - READ-ONLY; Job Stage Details
	JobStageDetails interface{} `json:"jobStageDetails,omitempty"`
}

// JobsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type JobsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(JobsClient) (JobResource, error)
}

// KeyEncryptionKey encryption key containing details about key to encrypt different keys.
type KeyEncryptionKey struct {
	// KekType - Type of encryption key used for key encryption. Possible values include: 'MicrosoftManaged', 'CustomerManaged'
	KekType KekType `json:"kekType,omitempty"`
	// KekURL - Key encryption key. It is required in case of Customer managed KekType.
	KekURL *string `json:"kekUrl,omitempty"`
	// KekVaultResourceID - Kek vault resource id. It is required in case of Customer managed KekType.
	KekVaultResourceID *string `json:"kekVaultResourceID,omitempty"`
}

// ManagedDiskDetails details of the managed disks.
type ManagedDiskDetails struct {
	// ResourceGroupID - Resource Group Id of the compute disks.
	ResourceGroupID *string `json:"resourceGroupId,omitempty"`
	// StagingStorageAccountID - Resource Id of the storage account that can be used to copy the vhd for staging.
	StagingStorageAccountID *string `json:"stagingStorageAccountId,omitempty"`
	// SharePassword - Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataAccountType - Possible values include: 'DataAccountTypeDataAccountDetails', 'DataAccountTypeManagedDisk', 'DataAccountTypeStorageAccount'
	DataAccountType DataAccountTypeBasicDataAccountDetails `json:"dataAccountType,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDiskDetails.
func (mdd ManagedDiskDetails) MarshalJSON() ([]byte, error) {
	mdd.DataAccountType = DataAccountTypeManagedDisk
	objectMap := make(map[string]interface{})
	if mdd.ResourceGroupID != nil {
		objectMap["resourceGroupId"] = mdd.ResourceGroupID
	}
	if mdd.StagingStorageAccountID != nil {
		objectMap["stagingStorageAccountId"] = mdd.StagingStorageAccountID
	}
	if mdd.SharePassword != nil {
		objectMap["sharePassword"] = mdd.SharePassword
	}
	if mdd.DataAccountType != "" {
		objectMap["dataAccountType"] = mdd.DataAccountType
	}
	return json.Marshal(objectMap)
}

// AsManagedDiskDetails is the BasicDataAccountDetails implementation for ManagedDiskDetails.
func (mdd ManagedDiskDetails) AsManagedDiskDetails() (*ManagedDiskDetails, bool) {
	return &mdd, true
}

// AsStorageAccountDetails is the BasicDataAccountDetails implementation for ManagedDiskDetails.
func (mdd ManagedDiskDetails) AsStorageAccountDetails() (*StorageAccountDetails, bool) {
	return nil, false
}

// AsDataAccountDetails is the BasicDataAccountDetails implementation for ManagedDiskDetails.
func (mdd ManagedDiskDetails) AsDataAccountDetails() (*DataAccountDetails, bool) {
	return nil, false
}

// AsBasicDataAccountDetails is the BasicDataAccountDetails implementation for ManagedDiskDetails.
func (mdd ManagedDiskDetails) AsBasicDataAccountDetails() (BasicDataAccountDetails, bool) {
	return &mdd, true
}

// NotificationPreference notification preference for a job stage.
type NotificationPreference struct {
	// StageName - Name of the stage. Possible values include: 'DevicePrepared', 'Dispatched', 'Delivered', 'PickedUp', 'AtAzureDC', 'DataCopy'
	StageName NotificationStageName `json:"stageName,omitempty"`
	// SendNotification - Notification is required or not.
	SendNotification *bool `json:"sendNotification,omitempty"`
}

// Operation operation entity.
type Operation struct {
	// Name - READ-ONLY; Name of the operation. Format: {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; Operation display values.
	Display *OperationDisplay `json:"display,omitempty"`
	// Properties - READ-ONLY; Operation properties.
	Properties interface{} `json:"properties,omitempty"`
	// Origin - READ-ONLY; Origin of the operation. Can be : user|system|user,system
	Origin *string `json:"origin,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// OperationDisplay operation display
type OperationDisplay struct {
	// Provider - Provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource name.
	Resource *string `json:"resource,omitempty"`
	// Operation - Localized name of the operation for display purpose.
	Operation *string `json:"operation,omitempty"`
	// Description - Localized description of the operation for display purpose.
	Description *string `json:"description,omitempty"`
}

// OperationList operation Collection.
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link for the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationList.
func (ol OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ol.NextLink != nil {
		objectMap["nextLink"] = ol.NextLink
	}
	return json.Marshal(objectMap)
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(cur OperationList, getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{
		fn: getNextPage,
		ol: cur,
	}
}

// PackageShippingDetails shipping details.
type PackageShippingDetails struct {
	// CarrierName - READ-ONLY; Name of the carrier.
	CarrierName *string `json:"carrierName,omitempty"`
	// TrackingID - READ-ONLY; Tracking Id of shipment.
	TrackingID *string `json:"trackingId,omitempty"`
	// TrackingURL - READ-ONLY; Url where shipment can be tracked.
	TrackingURL *string `json:"trackingUrl,omitempty"`
}

// Preferences preferences related to the order
type Preferences struct {
	// PreferredDataCenterRegion - Preferred data center region.
	PreferredDataCenterRegion *[]string `json:"preferredDataCenterRegion,omitempty"`
	// TransportPreferences - Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
}

// PreferencesValidationRequest request to validate preference of transport and data center.
type PreferencesValidationRequest struct {
	// Preference - Preference of transport and data center.
	Preference *Preferences `json:"preference,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) MarshalJSON() ([]byte, error) {
	pvr.ValidationType = ValidationTypeValidatePreferences
	objectMap := make(map[string]interface{})
	if pvr.Preference != nil {
		objectMap["preference"] = pvr.Preference
	}
	if pvr.DeviceType != "" {
		objectMap["deviceType"] = pvr.DeviceType
	}
	if pvr.ValidationType != "" {
		objectMap["validationType"] = pvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return &pvr, true
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for PreferencesValidationRequest.
func (pvr PreferencesValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &pvr, true
}

// PreferencesValidationResponseProperties properties of data center and transport preference validation
// response.
type PreferencesValidationResponseProperties struct {
	// Status - READ-ONLY; Validation status of requested data center and transport. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) MarshalJSON() ([]byte, error) {
	pvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences
	objectMap := make(map[string]interface{})
	if pvrp.ValidationType != "" {
		objectMap["validationType"] = pvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return &pvrp, true
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for PreferencesValidationResponseProperties.
func (pvrp PreferencesValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &pvrp, true
}

// RegionConfigurationRequest request body to get the configuration for the region.
type RegionConfigurationRequest struct {
	// ScheduleAvailabilityRequest - Request body to get the availability for scheduling orders.
	ScheduleAvailabilityRequest BasicScheduleAvailabilityRequest `json:"scheduleAvailabilityRequest,omitempty"`
	// TransportAvailabilityRequest - Request body to get the transport availability for given sku.
	TransportAvailabilityRequest *TransportAvailabilityRequest `json:"transportAvailabilityRequest,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for RegionConfigurationRequest struct.
func (rcr *RegionConfigurationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "scheduleAvailabilityRequest":
			if v != nil {
				scheduleAvailabilityRequest, err := unmarshalBasicScheduleAvailabilityRequest(*v)
				if err != nil {
					return err
				}
				rcr.ScheduleAvailabilityRequest = scheduleAvailabilityRequest
			}
		case "transportAvailabilityRequest":
			if v != nil {
				var transportAvailabilityRequest TransportAvailabilityRequest
				err = json.Unmarshal(*v, &transportAvailabilityRequest)
				if err != nil {
					return err
				}
				rcr.TransportAvailabilityRequest = &transportAvailabilityRequest
			}
		}
	}

	return nil
}

// RegionConfigurationResponse configuration response specific to a region.
type RegionConfigurationResponse struct {
	autorest.Response `json:"-"`
	// ScheduleAvailabilityResponse - READ-ONLY; Schedule availability for given sku in a region.
	ScheduleAvailabilityResponse *ScheduleAvailabilityResponse `json:"scheduleAvailabilityResponse,omitempty"`
	// TransportAvailabilityResponse - READ-ONLY; Transport options available for given sku in a region.
	TransportAvailabilityResponse *TransportAvailabilityResponse `json:"transportAvailabilityResponse,omitempty"`
}

// Resource model of the Resource.
type Resource struct {
	// Location - The location of the resource. This will be one of the supported and registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be changed once it is created, but if an identical region is specified on update the request will succeed.
	Location *string `json:"location,omitempty"`
	// Tags - The list of key value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups).
	Tags map[string]*string `json:"tags"`
	// Sku - The sku type.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - Msi identity of the resource
	Identity *ResourceIdentity `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	return json.Marshal(objectMap)
}

// ResourceIdentity msi identity details of the resource
type ResourceIdentity struct {
	// Type - Identity type
	Type *string `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; Service Principal Id backing the Msi
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; Home Tenant Id
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceIdentity.
func (ri ResourceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.Type != nil {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// BasicScheduleAvailabilityRequest request body to get the availability for scheduling orders.
type BasicScheduleAvailabilityRequest interface {
	AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool)
	AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool)
	AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool)
	AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool)
}

// ScheduleAvailabilityRequest request body to get the availability for scheduling orders.
type ScheduleAvailabilityRequest struct {
	// StorageLocation - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// Country - Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

func unmarshalBasicScheduleAvailabilityRequest(body []byte) (BasicScheduleAvailabilityRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["skuName"] {
	case string(SkuNameDataBox):
		var sart ScheduleAvailabilityRequestType
		err := json.Unmarshal(body, &sart)
		return sart, err
	case string(SkuNameDataBoxDisk):
		var dsar DiskScheduleAvailabilityRequest
		err := json.Unmarshal(body, &dsar)
		return dsar, err
	case string(SkuNameDataBoxHeavy):
		var hsar HeavyScheduleAvailabilityRequest
		err := json.Unmarshal(body, &hsar)
		return hsar, err
	default:
		var sar ScheduleAvailabilityRequest
		err := json.Unmarshal(body, &sar)
		return sar, err
	}
}
func unmarshalBasicScheduleAvailabilityRequestArray(body []byte) ([]BasicScheduleAvailabilityRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	sarArray := make([]BasicScheduleAvailabilityRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sar, err := unmarshalBasicScheduleAvailabilityRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		sarArray[index] = sar
	}
	return sarArray, nil
}

// MarshalJSON is the custom marshaler for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) MarshalJSON() ([]byte, error) {
	sar.SkuName = SkuNameScheduleAvailabilityRequest
	objectMap := make(map[string]interface{})
	if sar.StorageLocation != nil {
		objectMap["storageLocation"] = sar.StorageLocation
	}
	if sar.Country != nil {
		objectMap["country"] = sar.Country
	}
	if sar.SkuName != "" {
		objectMap["skuName"] = sar.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return nil, false
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return &sar, true
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequest.
func (sar ScheduleAvailabilityRequest) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &sar, true
}

// ScheduleAvailabilityRequestType request body to get the availability for scheduling data box orders
// orders.
type ScheduleAvailabilityRequestType struct {
	// StorageLocation - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	StorageLocation *string `json:"storageLocation,omitempty"`
	// Country - Country in which storage location should be supported.
	Country *string `json:"country,omitempty"`
	// SkuName - Possible values include: 'SkuNameScheduleAvailabilityRequest', 'SkuNameDataBox', 'SkuNameDataBoxDisk', 'SkuNameDataBoxHeavy'
	SkuName SkuNameBasicScheduleAvailabilityRequest `json:"skuName,omitempty"`
}

// MarshalJSON is the custom marshaler for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) MarshalJSON() ([]byte, error) {
	sart.SkuName = SkuNameDataBox
	objectMap := make(map[string]interface{})
	if sart.StorageLocation != nil {
		objectMap["storageLocation"] = sart.StorageLocation
	}
	if sart.Country != nil {
		objectMap["country"] = sart.Country
	}
	if sart.SkuName != "" {
		objectMap["skuName"] = sart.SkuName
	}
	return json.Marshal(objectMap)
}

// AsScheduleAvailabilityRequestType is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsScheduleAvailabilityRequestType() (*ScheduleAvailabilityRequestType, bool) {
	return &sart, true
}

// AsDiskScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsDiskScheduleAvailabilityRequest() (*DiskScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsHeavyScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsHeavyScheduleAvailabilityRequest() (*HeavyScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsScheduleAvailabilityRequest() (*ScheduleAvailabilityRequest, bool) {
	return nil, false
}

// AsBasicScheduleAvailabilityRequest is the BasicScheduleAvailabilityRequest implementation for ScheduleAvailabilityRequestType.
func (sart ScheduleAvailabilityRequestType) AsBasicScheduleAvailabilityRequest() (BasicScheduleAvailabilityRequest, bool) {
	return &sart, true
}

// ScheduleAvailabilityResponse schedule availability for given sku in a region.
type ScheduleAvailabilityResponse struct {
	// AvailableDates - READ-ONLY; List of dates available to schedule
	AvailableDates *[]date.Time `json:"availableDates,omitempty"`
}

// Secret the secrets related to a DataBox.
type Secret struct {
	// DeviceSerialNumber - READ-ONLY; Serial number of the assigned device.
	DeviceSerialNumber *string `json:"deviceSerialNumber,omitempty"`
	// DevicePassword - READ-ONLY; Password for out of the box experience on device.
	DevicePassword *string `json:"devicePassword,omitempty"`
	// NetworkConfigurations - READ-ONLY; Network configuration of the appliance.
	NetworkConfigurations *[]ApplianceNetworkConfiguration `json:"networkConfigurations,omitempty"`
	// EncodedValidationCertPubKey - READ-ONLY; The base 64 encoded public key to authenticate with the device
	EncodedValidationCertPubKey *string `json:"encodedValidationCertPubKey,omitempty"`
	// AccountCredentialDetails - READ-ONLY; Per account level access credentials.
	AccountCredentialDetails *[]AccountCredentialDetails `json:"accountCredentialDetails,omitempty"`
}

// ShareCredentialDetails credential details of the shares in account.
type ShareCredentialDetails struct {
	// ShareName - READ-ONLY; Name of the share.
	ShareName *string `json:"shareName,omitempty"`
	// ShareType - READ-ONLY; Type of the share. Possible values include: 'ShareDestinationFormatTypeUnknownType', 'ShareDestinationFormatTypeHCS', 'ShareDestinationFormatTypeBlockBlob', 'ShareDestinationFormatTypePageBlob', 'ShareDestinationFormatTypeAzureFile', 'ShareDestinationFormatTypeManagedDisk'
	ShareType ShareDestinationFormatType `json:"shareType,omitempty"`
	// UserName - READ-ONLY; User name for the share.
	UserName *string `json:"userName,omitempty"`
	// Password - READ-ONLY; Password for the share.
	Password *string `json:"password,omitempty"`
	// SupportedAccessProtocols - READ-ONLY; Access protocols supported on the device.
	SupportedAccessProtocols *[]AccessProtocol `json:"supportedAccessProtocols,omitempty"`
}

// ShipmentPickUpRequest shipment pick up request details.
type ShipmentPickUpRequest struct {
	// StartTime - Minimum date after which the pick up should commence, this must be in local time of pick up area.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Maximum date before which the pick up should commence, this must be in local time of pick up area.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ShipmentLocation - Shipment Location in the pickup place. Eg.front desk
	ShipmentLocation *string `json:"shipmentLocation,omitempty"`
}

// ShipmentPickUpResponse shipment pick up response.
type ShipmentPickUpResponse struct {
	autorest.Response `json:"-"`
	// ConfirmationNumber - READ-ONLY; Confirmation number for the pick up request.
	ConfirmationNumber *string `json:"confirmationNumber,omitempty"`
	// ReadyByTime - READ-ONLY; Time by which shipment should be ready for pick up, this is in local time of pick up area.
	ReadyByTime *date.Time `json:"readyByTime,omitempty"`
}

// ShippingAddress shipping address where customer wishes to receive the device.
type ShippingAddress struct {
	// StreetAddress1 - Street Address line 1.
	StreetAddress1 *string `json:"streetAddress1,omitempty"`
	// StreetAddress2 - Street Address line 2.
	StreetAddress2 *string `json:"streetAddress2,omitempty"`
	// StreetAddress3 - Street Address line 3.
	StreetAddress3 *string `json:"streetAddress3,omitempty"`
	// City - Name of the City.
	City *string `json:"city,omitempty"`
	// StateOrProvince - Name of the State or Province.
	StateOrProvince *string `json:"stateOrProvince,omitempty"`
	// Country - Name of the Country.
	Country *string `json:"country,omitempty"`
	// PostalCode - Postal code.
	PostalCode *string `json:"postalCode,omitempty"`
	// ZipExtendedCode - Extended Zip Code.
	ZipExtendedCode *string `json:"zipExtendedCode,omitempty"`
	// CompanyName - Name of the company.
	CompanyName *string `json:"companyName,omitempty"`
	// AddressType - Type of address. Possible values include: 'None', 'Residential', 'Commercial'
	AddressType AddressType `json:"addressType,omitempty"`
}

// Sku the Sku.
type Sku struct {
	// Name - The sku name. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	Name SkuName `json:"name,omitempty"`
	// DisplayName - The display name of the sku.
	DisplayName *string `json:"displayName,omitempty"`
	// Family - The sku family.
	Family *string `json:"family,omitempty"`
}

// SkuAvailabilityValidationRequest request to validate sku availability.
type SkuAvailabilityValidationRequest struct {
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// TransferType - Type of the transfer. Possible values include: 'ImportToAzure', 'ExportFromAzure'
	TransferType TransferType `json:"transferType,omitempty"`
	// Country - ISO country code. Country for hardware shipment. For codes check: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements
	Country *string `json:"country,omitempty"`
	// Location - Location for data transfer. For locations check: https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01
	Location *string `json:"location,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) MarshalJSON() ([]byte, error) {
	savr.ValidationType = ValidationTypeValidateSkuAvailability
	objectMap := make(map[string]interface{})
	if savr.DeviceType != "" {
		objectMap["deviceType"] = savr.DeviceType
	}
	if savr.TransferType != "" {
		objectMap["transferType"] = savr.TransferType
	}
	if savr.Country != nil {
		objectMap["country"] = savr.Country
	}
	if savr.Location != nil {
		objectMap["location"] = savr.Location
	}
	if savr.ValidationType != "" {
		objectMap["validationType"] = savr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return &savr, true
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for SkuAvailabilityValidationRequest.
func (savr SkuAvailabilityValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &savr, true
}

// SkuAvailabilityValidationResponseProperties properties of sku availability validation response.
type SkuAvailabilityValidationResponseProperties struct {
	// Status - READ-ONLY; Sku availability validation status. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) MarshalJSON() ([]byte, error) {
	savrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability
	objectMap := make(map[string]interface{})
	if savrp.ValidationType != "" {
		objectMap["validationType"] = savrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return &savrp, true
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for SkuAvailabilityValidationResponseProperties.
func (savrp SkuAvailabilityValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &savrp, true
}

// SkuCapacity capacity of the sku.
type SkuCapacity struct {
	// Usable - READ-ONLY; Usable capacity in TB.
	Usable *string `json:"usable,omitempty"`
	// Maximum - READ-ONLY; Maximum capacity in TB.
	Maximum *string `json:"maximum,omitempty"`
}

// SkuCost describes metadata for retrieving price info.
type SkuCost struct {
	// MeterID - READ-ONLY; Meter id of the Sku.
	MeterID *string `json:"meterId,omitempty"`
	// MeterType - READ-ONLY; The type of the meter.
	MeterType *string `json:"meterType,omitempty"`
	// Multiplier - READ-ONLY; Multiplier specifies the region specific value to be multiplied with 1$ guid. Eg: Our new regions will be using 1$ shipping guid with appropriate multiplier specific to region.
	Multiplier *float64 `json:"multiplier,omitempty"`
}

// SkuInformation information of the sku.
type SkuInformation struct {
	// Sku - READ-ONLY; The Sku.
	Sku *Sku `json:"sku,omitempty"`
	// Enabled - READ-ONLY; The sku is enabled or not.
	Enabled *bool `json:"enabled,omitempty"`
	// SkuProperties - READ-ONLY; Properties of the sku.
	*SkuProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SkuInformation.
func (si SkuInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SkuInformation struct.
func (si *SkuInformation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				si.Sku = &sku
			}
		case "enabled":
			if v != nil {
				var enabled bool
				err = json.Unmarshal(*v, &enabled)
				if err != nil {
					return err
				}
				si.Enabled = &enabled
			}
		case "properties":
			if v != nil {
				var skuProperties SkuProperties
				err = json.Unmarshal(*v, &skuProperties)
				if err != nil {
					return err
				}
				si.SkuProperties = &skuProperties
			}
		}
	}

	return nil
}

// SkuProperties properties of the sku.
type SkuProperties struct {
	// DataLocationToServiceLocationMap - READ-ONLY; The map of data location to service location.
	DataLocationToServiceLocationMap *[]DataLocationToServiceLocationMap `json:"dataLocationToServiceLocationMap,omitempty"`
	// Capacity - READ-ONLY; Capacity of the Sku.
	Capacity *SkuCapacity `json:"capacity,omitempty"`
	// Costs - READ-ONLY; Cost of the Sku.
	Costs *[]SkuCost `json:"costs,omitempty"`
	// APIVersions - READ-ONLY; Api versions that support this Sku.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// DisabledReason - READ-ONLY; Reason why the Sku is disabled. Possible values include: 'SkuDisabledReasonNone', 'SkuDisabledReasonCountry', 'SkuDisabledReasonRegion', 'SkuDisabledReasonFeature', 'SkuDisabledReasonOfferType', 'SkuDisabledReasonNoSubscriptionInfo'
	DisabledReason SkuDisabledReason `json:"disabledReason,omitempty"`
	// DisabledReasonMessage - READ-ONLY; Message for why the Sku is disabled.
	DisabledReasonMessage *string `json:"disabledReasonMessage,omitempty"`
	// RequiredFeature - READ-ONLY; Required feature to access the sku.
	RequiredFeature *string `json:"requiredFeature,omitempty"`
}

// StorageAccountDetails details for the storage account.
type StorageAccountDetails struct {
	// StorageAccountID - Storage Account Resource Id.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// SharePassword - Password for all the shares to be created on the device. Should not be passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password itself. This will not be returned in Get Call. Password Requirements :  Password must be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet, one number and one special character. Password cannot have the following characters : IilLoO0 Password can have only alphabets, numbers and these characters : @#\-$%^!+=;:_()]+
	SharePassword *string `json:"sharePassword,omitempty"`
	// DataAccountType - Possible values include: 'DataAccountTypeDataAccountDetails', 'DataAccountTypeManagedDisk', 'DataAccountTypeStorageAccount'
	DataAccountType DataAccountTypeBasicDataAccountDetails `json:"dataAccountType,omitempty"`
}

// MarshalJSON is the custom marshaler for StorageAccountDetails.
func (sad StorageAccountDetails) MarshalJSON() ([]byte, error) {
	sad.DataAccountType = DataAccountTypeStorageAccount
	objectMap := make(map[string]interface{})
	if sad.StorageAccountID != nil {
		objectMap["storageAccountId"] = sad.StorageAccountID
	}
	if sad.SharePassword != nil {
		objectMap["sharePassword"] = sad.SharePassword
	}
	if sad.DataAccountType != "" {
		objectMap["dataAccountType"] = sad.DataAccountType
	}
	return json.Marshal(objectMap)
}

// AsManagedDiskDetails is the BasicDataAccountDetails implementation for StorageAccountDetails.
func (sad StorageAccountDetails) AsManagedDiskDetails() (*ManagedDiskDetails, bool) {
	return nil, false
}

// AsStorageAccountDetails is the BasicDataAccountDetails implementation for StorageAccountDetails.
func (sad StorageAccountDetails) AsStorageAccountDetails() (*StorageAccountDetails, bool) {
	return &sad, true
}

// AsDataAccountDetails is the BasicDataAccountDetails implementation for StorageAccountDetails.
func (sad StorageAccountDetails) AsDataAccountDetails() (*DataAccountDetails, bool) {
	return nil, false
}

// AsBasicDataAccountDetails is the BasicDataAccountDetails implementation for StorageAccountDetails.
func (sad StorageAccountDetails) AsBasicDataAccountDetails() (BasicDataAccountDetails, bool) {
	return &sad, true
}

// SubscriptionIsAllowedToCreateJobValidationRequest request to validate subscription permission to create
// jobs.
type SubscriptionIsAllowedToCreateJobValidationRequest struct {
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) MarshalJSON() ([]byte, error) {
	siatcjvr.ValidationType = ValidationTypeValidateSubscriptionIsAllowedToCreateJob
	objectMap := make(map[string]interface{})
	if siatcjvr.ValidationType != "" {
		objectMap["validationType"] = siatcjvr.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return &siatcjvr, true
}

// AsValidateAddress is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for SubscriptionIsAllowedToCreateJobValidationRequest.
func (siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &siatcjvr, true
}

// SubscriptionIsAllowedToCreateJobValidationResponseProperties properties of subscription permission to
// create job validation response.
type SubscriptionIsAllowedToCreateJobValidationResponseProperties struct {
	// Status - READ-ONLY; Validation status of subscription permission to create job. Possible values include: 'ValidationStatusValid', 'ValidationStatusInvalid', 'ValidationStatusSkipped'
	Status ValidationStatus `json:"status,omitempty"`
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) MarshalJSON() ([]byte, error) {
	siatcjvrp.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob
	objectMap := make(map[string]interface{})
	if siatcjvrp.ValidationType != "" {
		objectMap["validationType"] = siatcjvrp.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return &siatcjvrp, true
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return nil, false
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for SubscriptionIsAllowedToCreateJobValidationResponseProperties.
func (siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &siatcjvrp, true
}

// TransferAllDetails details to transfer all data.
type TransferAllDetails struct {
	// DataAccountType - Type of the account of data. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataAccountType DataAccountType `json:"dataAccountType,omitempty"`
	// TransferAllBlobs - To indicate if all Azure blobs have to be transferred
	TransferAllBlobs *bool `json:"transferAllBlobs,omitempty"`
	// TransferAllFiles - To indicate if all Azure Files have to be transferred
	TransferAllFiles *bool `json:"transferAllFiles,omitempty"`
}

// TransferConfiguration configuration for defining the transfer of data.
type TransferConfiguration struct {
	// TransferConfigurationType - Type of the configuration for transfer. Possible values include: 'TransferAll', 'TransferUsingFilter'
	TransferConfigurationType TransferConfigurationType `json:"transferConfigurationType,omitempty"`
	// TransferFilterDetails - Map of filter type and the details to filter. This field is required only if the TransferConfigurationType is given as TransferUsingFilter.
	TransferFilterDetails *TransferConfigurationTransferFilterDetails `json:"transferFilterDetails,omitempty"`
	// TransferAllDetails - Map of filter type and the details to transfer all data. This field is required only if the TransferConfigurationType is given as TransferAll
	TransferAllDetails *TransferConfigurationTransferAllDetails `json:"transferAllDetails,omitempty"`
}

// TransferConfigurationTransferAllDetails map of filter type and the details to transfer all data. This
// field is required only if the TransferConfigurationType is given as TransferAll
type TransferConfigurationTransferAllDetails struct {
	// Include - Details to transfer all data.
	Include *TransferAllDetails `json:"include,omitempty"`
}

// TransferConfigurationTransferFilterDetails map of filter type and the details to filter. This field is
// required only if the TransferConfigurationType is given as TransferUsingFilter.
type TransferConfigurationTransferFilterDetails struct {
	// Include - Details of the filtering the transfer of data.
	Include *TransferFilterDetails `json:"include,omitempty"`
}

// TransferFilterDetails details of the filtering the transfer of data.
type TransferFilterDetails struct {
	// DataAccountType - Type of the account of data. Possible values include: 'StorageAccount', 'ManagedDisk'
	DataAccountType DataAccountType `json:"dataAccountType,omitempty"`
	// BlobFilterDetails - Filter details to transfer blobs.
	BlobFilterDetails *BlobFilterDetails `json:"blobFilterDetails,omitempty"`
	// AzureFileFilterDetails - Filter details to transfer Azure files.
	AzureFileFilterDetails *AzureFileFilterDetails `json:"azureFileFilterDetails,omitempty"`
	// FilterFileDetails - Details of the filter files to be used for data transfer.
	FilterFileDetails *[]FilterFileDetails `json:"filterFileDetails,omitempty"`
}

// TransportAvailabilityDetails transport options availability details for given region.
type TransportAvailabilityDetails struct {
	// ShipmentType - READ-ONLY; Transport Shipment Type supported for given region. Possible values include: 'TransportShipmentTypesCustomerManaged', 'TransportShipmentTypesMicrosoftManaged'
	ShipmentType TransportShipmentTypes `json:"shipmentType,omitempty"`
}

// TransportAvailabilityRequest request body to get the transport availability for given sku.
type TransportAvailabilityRequest struct {
	// SkuName - Type of the device. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	SkuName SkuName `json:"skuName,omitempty"`
}

// TransportAvailabilityResponse transport options available for given sku in a region.
type TransportAvailabilityResponse struct {
	// TransportAvailabilityDetails - READ-ONLY; List of transport availability details for given region
	TransportAvailabilityDetails *[]TransportAvailabilityDetails `json:"transportAvailabilityDetails,omitempty"`
}

// TransportPreferences preferences related to the shipment logistics of the sku
type TransportPreferences struct {
	// PreferredShipmentType - Indicates Shipment Logistics type that the customer preferred. Possible values include: 'TransportShipmentTypesCustomerManaged', 'TransportShipmentTypesMicrosoftManaged'
	PreferredShipmentType TransportShipmentTypes `json:"preferredShipmentType,omitempty"`
}

// UnencryptedCredentials unencrypted credentials for accessing device.
type UnencryptedCredentials struct {
	// JobName - READ-ONLY; Name of the job.
	JobName *string `json:"jobName,omitempty"`
	// JobSecrets - READ-ONLY; Secrets related to this job.
	JobSecrets BasicJobSecrets `json:"jobSecrets,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for UnencryptedCredentials struct.
func (uc *UnencryptedCredentials) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "jobName":
			if v != nil {
				var jobName string
				err = json.Unmarshal(*v, &jobName)
				if err != nil {
					return err
				}
				uc.JobName = &jobName
			}
		case "jobSecrets":
			if v != nil {
				jobSecrets, err := unmarshalBasicJobSecrets(*v)
				if err != nil {
					return err
				}
				uc.JobSecrets = jobSecrets
			}
		}
	}

	return nil
}

// UnencryptedCredentialsList list of unencrypted credentials for accessing device.
type UnencryptedCredentialsList struct {
	autorest.Response `json:"-"`
	// Value - List of unencrypted credentials.
	Value *[]UnencryptedCredentials `json:"value,omitempty"`
	// NextLink - Link for the next set of unencrypted credentials.
	NextLink *string `json:"nextLink,omitempty"`
}

// UpdateJobDetails job details for update.
type UpdateJobDetails struct {
	// ContactDetails - Contact details for notification and shipping.
	ContactDetails *ContactDetails `json:"contactDetails,omitempty"`
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// KeyEncryptionKey - Key encryption key for the job.
	KeyEncryptionKey *KeyEncryptionKey `json:"keyEncryptionKey,omitempty"`
}

// UpdateJobProperties job Properties for update
type UpdateJobProperties struct {
	// Details - Details of a job to be updated.
	Details *UpdateJobDetails `json:"details,omitempty"`
}

// ValidateAddress the requirements to validate customer address where the device needs to be shipped.
type ValidateAddress struct {
	// ShippingAddress - Shipping address of the customer.
	ShippingAddress *ShippingAddress `json:"shippingAddress,omitempty"`
	// DeviceType - Device type to be used for the job. Possible values include: 'DataBox', 'DataBoxDisk', 'DataBoxHeavy'
	DeviceType SkuName `json:"deviceType,omitempty"`
	// TransportPreferences - Preferences related to the shipment logistics of the sku.
	TransportPreferences *TransportPreferences `json:"transportPreferences,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidateAddress.
func (va ValidateAddress) MarshalJSON() ([]byte, error) {
	va.ValidationType = ValidationTypeValidateAddress
	objectMap := make(map[string]interface{})
	if va.ShippingAddress != nil {
		objectMap["shippingAddress"] = va.ShippingAddress
	}
	if va.DeviceType != "" {
		objectMap["deviceType"] = va.DeviceType
	}
	if va.TransportPreferences != nil {
		objectMap["transportPreferences"] = va.TransportPreferences
	}
	if va.ValidationType != "" {
		objectMap["validationType"] = va.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsValidateAddress() (*ValidateAddress, bool) {
	return &va, true
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return nil, false
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for ValidateAddress.
func (va ValidateAddress) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &va, true
}

// BasicValidationInputRequest minimum fields that must be present in any type of validation request.
type BasicValidationInputRequest interface {
	AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool)
	AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool)
	AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool)
	AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool)
	AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool)
	AsValidateAddress() (*ValidateAddress, bool)
	AsValidationInputRequest() (*ValidationInputRequest, bool)
}

// ValidationInputRequest minimum fields that must be present in any type of validation request.
type ValidationInputRequest struct {
	// ValidationType - Possible values include: 'ValidationTypeValidationInputRequest', 'ValidationTypeValidateCreateOrderLimit', 'ValidationTypeValidateDataTransferDetails', 'ValidationTypeValidatePreferences', 'ValidationTypeValidateSkuAvailability', 'ValidationTypeValidateSubscriptionIsAllowedToCreateJob', 'ValidationTypeValidateAddress'
	ValidationType ValidationType `json:"validationType,omitempty"`
}

func unmarshalBasicValidationInputRequest(body []byte) (BasicValidationInputRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationType"] {
	case string(ValidationTypeValidateCreateOrderLimit):
		var colfsvr CreateOrderLimitForSubscriptionValidationRequest
		err := json.Unmarshal(body, &colfsvr)
		return colfsvr, err
	case string(ValidationTypeValidateDataTransferDetails):
		var dtdvr DataTransferDetailsValidationRequest
		err := json.Unmarshal(body, &dtdvr)
		return dtdvr, err
	case string(ValidationTypeValidatePreferences):
		var pvr PreferencesValidationRequest
		err := json.Unmarshal(body, &pvr)
		return pvr, err
	case string(ValidationTypeValidateSkuAvailability):
		var savr SkuAvailabilityValidationRequest
		err := json.Unmarshal(body, &savr)
		return savr, err
	case string(ValidationTypeValidateSubscriptionIsAllowedToCreateJob):
		var siatcjvr SubscriptionIsAllowedToCreateJobValidationRequest
		err := json.Unmarshal(body, &siatcjvr)
		return siatcjvr, err
	case string(ValidationTypeValidateAddress):
		var va ValidateAddress
		err := json.Unmarshal(body, &va)
		return va, err
	default:
		var vir ValidationInputRequest
		err := json.Unmarshal(body, &vir)
		return vir, err
	}
}
func unmarshalBasicValidationInputRequestArray(body []byte) ([]BasicValidationInputRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	virArray := make([]BasicValidationInputRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vir, err := unmarshalBasicValidationInputRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		virArray[index] = vir
	}
	return virArray, nil
}

// MarshalJSON is the custom marshaler for ValidationInputRequest.
func (vir ValidationInputRequest) MarshalJSON() ([]byte, error) {
	vir.ValidationType = ValidationTypeValidationInputRequest
	objectMap := make(map[string]interface{})
	if vir.ValidationType != "" {
		objectMap["validationType"] = vir.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsCreateOrderLimitForSubscriptionValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsCreateOrderLimitForSubscriptionValidationRequest() (*CreateOrderLimitForSubscriptionValidationRequest, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsDataTransferDetailsValidationRequest() (*DataTransferDetailsValidationRequest, bool) {
	return nil, false
}

// AsPreferencesValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsPreferencesValidationRequest() (*PreferencesValidationRequest, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsSkuAvailabilityValidationRequest() (*SkuAvailabilityValidationRequest, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsSubscriptionIsAllowedToCreateJobValidationRequest() (*SubscriptionIsAllowedToCreateJobValidationRequest, bool) {
	return nil, false
}

// AsValidateAddress is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsValidateAddress() (*ValidateAddress, bool) {
	return nil, false
}

// AsValidationInputRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsValidationInputRequest() (*ValidationInputRequest, bool) {
	return &vir, true
}

// AsBasicValidationInputRequest is the BasicValidationInputRequest implementation for ValidationInputRequest.
func (vir ValidationInputRequest) AsBasicValidationInputRequest() (BasicValidationInputRequest, bool) {
	return &vir, true
}

// BasicValidationInputResponse minimum properties that should be present in each individual validation response.
type BasicValidationInputResponse interface {
	AsAddressValidationProperties() (*AddressValidationProperties, bool)
	AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool)
	AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool)
	AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool)
	AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool)
	AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool)
	AsValidationInputResponse() (*ValidationInputResponse, bool)
}

// ValidationInputResponse minimum properties that should be present in each individual validation response.
type ValidationInputResponse struct {
	// Error - READ-ONLY; Error code and message of validation response.
	Error *CloudError `json:"error,omitempty"`
	// ValidationType - Possible values include: 'ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails', 'ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability', 'ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob'
	ValidationType ValidationTypeBasicValidationInputResponse `json:"validationType,omitempty"`
}

func unmarshalBasicValidationInputResponse(body []byte) (BasicValidationInputResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationType"] {
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateAddress):
		var avp AddressValidationProperties
		err := json.Unmarshal(body, &avp)
		return avp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateCreateOrderLimit):
		var colfsvrp CreateOrderLimitForSubscriptionValidationResponseProperties
		err := json.Unmarshal(body, &colfsvrp)
		return colfsvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateDataTransferDetails):
		var dtdvrp DataTransferDetailsValidationResponseProperties
		err := json.Unmarshal(body, &dtdvrp)
		return dtdvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidatePreferences):
		var pvrp PreferencesValidationResponseProperties
		err := json.Unmarshal(body, &pvrp)
		return pvrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateSkuAvailability):
		var savrp SkuAvailabilityValidationResponseProperties
		err := json.Unmarshal(body, &savrp)
		return savrp, err
	case string(ValidationTypeBasicValidationInputResponseValidationTypeValidateSubscriptionIsAllowedToCreateJob):
		var siatcjvrp SubscriptionIsAllowedToCreateJobValidationResponseProperties
		err := json.Unmarshal(body, &siatcjvrp)
		return siatcjvrp, err
	default:
		var vir ValidationInputResponse
		err := json.Unmarshal(body, &vir)
		return vir, err
	}
}
func unmarshalBasicValidationInputResponseArray(body []byte) ([]BasicValidationInputResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	virArray := make([]BasicValidationInputResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vir, err := unmarshalBasicValidationInputResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		virArray[index] = vir
	}
	return virArray, nil
}

// MarshalJSON is the custom marshaler for ValidationInputResponse.
func (vir ValidationInputResponse) MarshalJSON() ([]byte, error) {
	vir.ValidationType = ValidationTypeBasicValidationInputResponseValidationTypeValidationInputResponse
	objectMap := make(map[string]interface{})
	if vir.ValidationType != "" {
		objectMap["validationType"] = vir.ValidationType
	}
	return json.Marshal(objectMap)
}

// AsAddressValidationProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsAddressValidationProperties() (*AddressValidationProperties, bool) {
	return nil, false
}

// AsCreateOrderLimitForSubscriptionValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsCreateOrderLimitForSubscriptionValidationResponseProperties() (*CreateOrderLimitForSubscriptionValidationResponseProperties, bool) {
	return nil, false
}

// AsDataTransferDetailsValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsDataTransferDetailsValidationResponseProperties() (*DataTransferDetailsValidationResponseProperties, bool) {
	return nil, false
}

// AsPreferencesValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsPreferencesValidationResponseProperties() (*PreferencesValidationResponseProperties, bool) {
	return nil, false
}

// AsSkuAvailabilityValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsSkuAvailabilityValidationResponseProperties() (*SkuAvailabilityValidationResponseProperties, bool) {
	return nil, false
}

// AsSubscriptionIsAllowedToCreateJobValidationResponseProperties is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsSubscriptionIsAllowedToCreateJobValidationResponseProperties() (*SubscriptionIsAllowedToCreateJobValidationResponseProperties, bool) {
	return nil, false
}

// AsValidationInputResponse is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsValidationInputResponse() (*ValidationInputResponse, bool) {
	return &vir, true
}

// AsBasicValidationInputResponse is the BasicValidationInputResponse implementation for ValidationInputResponse.
func (vir ValidationInputResponse) AsBasicValidationInputResponse() (BasicValidationInputResponse, bool) {
	return &vir, true
}

// BasicValidationRequest minimum request requirement of any validation category.
type BasicValidationRequest interface {
	AsCreateJobValidations() (*CreateJobValidations, bool)
	AsValidationRequest() (*ValidationRequest, bool)
}

// ValidationRequest minimum request requirement of any validation category.
type ValidationRequest struct {
	// IndividualRequestDetails - List of request details contain validationType and its request as key and value respectively.
	IndividualRequestDetails *[]BasicValidationInputRequest `json:"individualRequestDetails,omitempty"`
	// ValidationCategory - Possible values include: 'ValidationCategoryValidationRequest', 'ValidationCategoryJobCreationValidation'
	ValidationCategory ValidationCategory `json:"validationCategory,omitempty"`
}

func unmarshalBasicValidationRequest(body []byte) (BasicValidationRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["validationCategory"] {
	case string(ValidationCategoryJobCreationValidation):
		var cjv CreateJobValidations
		err := json.Unmarshal(body, &cjv)
		return cjv, err
	default:
		var vr ValidationRequest
		err := json.Unmarshal(body, &vr)
		return vr, err
	}
}
func unmarshalBasicValidationRequestArray(body []byte) ([]BasicValidationRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vrArray := make([]BasicValidationRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vr, err := unmarshalBasicValidationRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		vrArray[index] = vr
	}
	return vrArray, nil
}

// MarshalJSON is the custom marshaler for ValidationRequest.
func (vr ValidationRequest) MarshalJSON() ([]byte, error) {
	vr.ValidationCategory = ValidationCategoryValidationRequest
	objectMap := make(map[string]interface{})
	if vr.IndividualRequestDetails != nil {
		objectMap["individualRequestDetails"] = vr.IndividualRequestDetails
	}
	if vr.ValidationCategory != "" {
		objectMap["validationCategory"] = vr.ValidationCategory
	}
	return json.Marshal(objectMap)
}

// AsCreateJobValidations is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsCreateJobValidations() (*CreateJobValidations, bool) {
	return nil, false
}

// AsValidationRequest is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsValidationRequest() (*ValidationRequest, bool) {
	return &vr, true
}

// AsBasicValidationRequest is the BasicValidationRequest implementation for ValidationRequest.
func (vr ValidationRequest) AsBasicValidationRequest() (BasicValidationRequest, bool) {
	return &vr, true
}

// UnmarshalJSON is the custom unmarshaler for ValidationRequest struct.
func (vr *ValidationRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "individualRequestDetails":
			if v != nil {
				individualRequestDetails, err := unmarshalBasicValidationInputRequestArray(*v)
				if err != nil {
					return err
				}
				vr.IndividualRequestDetails = &individualRequestDetails
			}
		case "validationCategory":
			if v != nil {
				var validationCategory ValidationCategory
				err = json.Unmarshal(*v, &validationCategory)
				if err != nil {
					return err
				}
				vr.ValidationCategory = validationCategory
			}
		}
	}

	return nil
}

// ValidationResponse response of pre job creation validations.
type ValidationResponse struct {
	autorest.Response `json:"-"`
	// ValidationResponseProperties - READ-ONLY; Properties of pre job creation validation response.
	*ValidationResponseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ValidationResponse.
func (vr ValidationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ValidationResponse struct.
func (vr *ValidationResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var validationResponseProperties ValidationResponseProperties
				err = json.Unmarshal(*v, &validationResponseProperties)
				if err != nil {
					return err
				}
				vr.ValidationResponseProperties = &validationResponseProperties
			}
		}
	}

	return nil
}

// ValidationResponseProperties properties of pre job creation validation response.
type ValidationResponseProperties struct {
	// Status - READ-ONLY; Overall validation status. Possible values include: 'AllValidToProceed', 'InputsRevisitRequired', 'CertainInputValidationsSkipped'
	Status OverallValidationStatus `json:"status,omitempty"`
	// IndividualResponseDetails - READ-ONLY; List of response details contain validationType and its response as key and value respectively.
	IndividualResponseDetails *[]BasicValidationInputResponse `json:"individualResponseDetails,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ValidationResponseProperties struct.
func (vrp *ValidationResponseProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status OverallValidationStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				vrp.Status = status
			}
		case "individualResponseDetails":
			if v != nil {
				individualResponseDetails, err := unmarshalBasicValidationInputResponseArray(*v)
				if err != nil {
					return err
				}
				vrp.IndividualResponseDetails = &individualResponseDetails
			}
		}
	}

	return nil
}
