package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// AS2 ...
	AS2 AgreementType = "AS2"
	// Edifact ...
	Edifact AgreementType = "Edifact"
	// NotSpecified ...
	NotSpecified AgreementType = "NotSpecified"
	// X12 ...
	X12 AgreementType = "X12"
)

// PossibleAgreementTypeValues returns an array of possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{AS2, Edifact, NotSpecified, X12}
}

// APIDeploymentParameterVisibility enumerates the values for api deployment parameter visibility.
type APIDeploymentParameterVisibility string

const (
	// APIDeploymentParameterVisibilityDefault ...
	APIDeploymentParameterVisibilityDefault APIDeploymentParameterVisibility = "Default"
	// APIDeploymentParameterVisibilityInternal ...
	APIDeploymentParameterVisibilityInternal APIDeploymentParameterVisibility = "Internal"
	// APIDeploymentParameterVisibilityNotSpecified ...
	APIDeploymentParameterVisibilityNotSpecified APIDeploymentParameterVisibility = "NotSpecified"
)

// PossibleAPIDeploymentParameterVisibilityValues returns an array of possible values for the APIDeploymentParameterVisibility const type.
func PossibleAPIDeploymentParameterVisibilityValues() []APIDeploymentParameterVisibility {
	return []APIDeploymentParameterVisibility{APIDeploymentParameterVisibilityDefault, APIDeploymentParameterVisibilityInternal, APIDeploymentParameterVisibilityNotSpecified}
}

// APITier enumerates the values for api tier.
type APITier string

const (
	// APITierEnterprise ...
	APITierEnterprise APITier = "Enterprise"
	// APITierNotSpecified ...
	APITierNotSpecified APITier = "NotSpecified"
	// APITierPremium ...
	APITierPremium APITier = "Premium"
	// APITierStandard ...
	APITierStandard APITier = "Standard"
)

// PossibleAPITierValues returns an array of possible values for the APITier const type.
func PossibleAPITierValues() []APITier {
	return []APITier{APITierEnterprise, APITierNotSpecified, APITierPremium, APITierStandard}
}

// APIType enumerates the values for api type.
type APIType string

const (
	// APITypeNotSpecified ...
	APITypeNotSpecified APIType = "NotSpecified"
	// APITypeRest ...
	APITypeRest APIType = "Rest"
	// APITypeSoap ...
	APITypeSoap APIType = "Soap"
)

// PossibleAPITypeValues returns an array of possible values for the APIType const type.
func PossibleAPITypeValues() []APIType {
	return []APIType{APITypeNotSpecified, APITypeRest, APITypeSoap}
}

// AzureAsyncOperationState enumerates the values for azure async operation state.
type AzureAsyncOperationState string

const (
	// Canceled ...
	Canceled AzureAsyncOperationState = "Canceled"
	// Failed ...
	Failed AzureAsyncOperationState = "Failed"
	// Pending ...
	Pending AzureAsyncOperationState = "Pending"
	// Succeeded ...
	Succeeded AzureAsyncOperationState = "Succeeded"
)

// PossibleAzureAsyncOperationStateValues returns an array of possible values for the AzureAsyncOperationState const type.
func PossibleAzureAsyncOperationStateValues() []AzureAsyncOperationState {
	return []AzureAsyncOperationState{Canceled, Failed, Pending, Succeeded}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// EdifactCharacterSet enumerates the values for edifact character set.
type EdifactCharacterSet string

const (
	// EdifactCharacterSetKECA ...
	EdifactCharacterSetKECA EdifactCharacterSet = "KECA"
	// EdifactCharacterSetNotSpecified ...
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	// EdifactCharacterSetUNOA ...
	EdifactCharacterSetUNOA EdifactCharacterSet = "UNOA"
	// EdifactCharacterSetUNOB ...
	EdifactCharacterSetUNOB EdifactCharacterSet = "UNOB"
	// EdifactCharacterSetUNOC ...
	EdifactCharacterSetUNOC EdifactCharacterSet = "UNOC"
	// EdifactCharacterSetUNOD ...
	EdifactCharacterSetUNOD EdifactCharacterSet = "UNOD"
	// EdifactCharacterSetUNOE ...
	EdifactCharacterSetUNOE EdifactCharacterSet = "UNOE"
	// EdifactCharacterSetUNOF ...
	EdifactCharacterSetUNOF EdifactCharacterSet = "UNOF"
	// EdifactCharacterSetUNOG ...
	EdifactCharacterSetUNOG EdifactCharacterSet = "UNOG"
	// EdifactCharacterSetUNOH ...
	EdifactCharacterSetUNOH EdifactCharacterSet = "UNOH"
	// EdifactCharacterSetUNOI ...
	EdifactCharacterSetUNOI EdifactCharacterSet = "UNOI"
	// EdifactCharacterSetUNOJ ...
	EdifactCharacterSetUNOJ EdifactCharacterSet = "UNOJ"
	// EdifactCharacterSetUNOK ...
	EdifactCharacterSetUNOK EdifactCharacterSet = "UNOK"
	// EdifactCharacterSetUNOX ...
	EdifactCharacterSetUNOX EdifactCharacterSet = "UNOX"
	// EdifactCharacterSetUNOY ...
	EdifactCharacterSetUNOY EdifactCharacterSet = "UNOY"
)

// PossibleEdifactCharacterSetValues returns an array of possible values for the EdifactCharacterSet const type.
func PossibleEdifactCharacterSetValues() []EdifactCharacterSet {
	return []EdifactCharacterSet{EdifactCharacterSetKECA, EdifactCharacterSetNotSpecified, EdifactCharacterSetUNOA, EdifactCharacterSetUNOB, EdifactCharacterSetUNOC, EdifactCharacterSetUNOD, EdifactCharacterSetUNOE, EdifactCharacterSetUNOF, EdifactCharacterSetUNOG, EdifactCharacterSetUNOH, EdifactCharacterSetUNOI, EdifactCharacterSetUNOJ, EdifactCharacterSetUNOK, EdifactCharacterSetUNOX, EdifactCharacterSetUNOY}
}

// EdifactDecimalIndicator enumerates the values for edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	// EdifactDecimalIndicatorComma ...
	EdifactDecimalIndicatorComma EdifactDecimalIndicator = "Comma"
	// EdifactDecimalIndicatorDecimal ...
	EdifactDecimalIndicatorDecimal EdifactDecimalIndicator = "Decimal"
	// EdifactDecimalIndicatorNotSpecified ...
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
)

// PossibleEdifactDecimalIndicatorValues returns an array of possible values for the EdifactDecimalIndicator const type.
func PossibleEdifactDecimalIndicatorValues() []EdifactDecimalIndicator {
	return []EdifactDecimalIndicator{EdifactDecimalIndicatorComma, EdifactDecimalIndicatorDecimal, EdifactDecimalIndicatorNotSpecified}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES128 ...
	EncryptionAlgorithmAES128 EncryptionAlgorithm = "AES128"
	// EncryptionAlgorithmAES192 ...
	EncryptionAlgorithmAES192 EncryptionAlgorithm = "AES192"
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmDES3 ...
	EncryptionAlgorithmDES3 EncryptionAlgorithm = "DES3"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmNotSpecified ...
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	// EncryptionAlgorithmRC2 ...
	EncryptionAlgorithmRC2 EncryptionAlgorithm = "RC2"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES128, EncryptionAlgorithmAES192, EncryptionAlgorithmAES256, EncryptionAlgorithmDES3, EncryptionAlgorithmNone, EncryptionAlgorithmNotSpecified, EncryptionAlgorithmRC2}
}

// ErrorResponseCode enumerates the values for error response code.
type ErrorResponseCode string

const (
	// ErrorResponseCodeIntegrationServiceEnvironmentNotFound ...
	ErrorResponseCodeIntegrationServiceEnvironmentNotFound ErrorResponseCode = "IntegrationServiceEnvironmentNotFound"
	// ErrorResponseCodeInternalServerError ...
	ErrorResponseCodeInternalServerError ErrorResponseCode = "InternalServerError"
	// ErrorResponseCodeInvalidOperationID ...
	ErrorResponseCodeInvalidOperationID ErrorResponseCode = "InvalidOperationId"
	// ErrorResponseCodeNotSpecified ...
	ErrorResponseCodeNotSpecified ErrorResponseCode = "NotSpecified"
)

// PossibleErrorResponseCodeValues returns an array of possible values for the ErrorResponseCode const type.
func PossibleErrorResponseCodeValues() []ErrorResponseCode {
	return []ErrorResponseCode{ErrorResponseCodeIntegrationServiceEnvironmentNotFound, ErrorResponseCodeInternalServerError, ErrorResponseCodeInvalidOperationID, ErrorResponseCodeNotSpecified}
}

// EventLevel enumerates the values for event level.
type EventLevel string

const (
	// Critical ...
	Critical EventLevel = "Critical"
	// Error ...
	Error EventLevel = "Error"
	// Informational ...
	Informational EventLevel = "Informational"
	// LogAlways ...
	LogAlways EventLevel = "LogAlways"
	// Verbose ...
	Verbose EventLevel = "Verbose"
	// Warning ...
	Warning EventLevel = "Warning"
)

// PossibleEventLevelValues returns an array of possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{Critical, Error, Informational, LogAlways, Verbose, Warning}
}

// HashingAlgorithm enumerates the values for hashing algorithm.
type HashingAlgorithm string

const (
	// HashingAlgorithmMD5 ...
	HashingAlgorithmMD5 HashingAlgorithm = "MD5"
	// HashingAlgorithmNone ...
	HashingAlgorithmNone HashingAlgorithm = "None"
	// HashingAlgorithmNotSpecified ...
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	// HashingAlgorithmSHA1 ...
	HashingAlgorithmSHA1 HashingAlgorithm = "SHA1"
	// HashingAlgorithmSHA2256 ...
	HashingAlgorithmSHA2256 HashingAlgorithm = "SHA2256"
	// HashingAlgorithmSHA2384 ...
	HashingAlgorithmSHA2384 HashingAlgorithm = "SHA2384"
	// HashingAlgorithmSHA2512 ...
	HashingAlgorithmSHA2512 HashingAlgorithm = "SHA2512"
)

// PossibleHashingAlgorithmValues returns an array of possible values for the HashingAlgorithm const type.
func PossibleHashingAlgorithmValues() []HashingAlgorithm {
	return []HashingAlgorithm{HashingAlgorithmMD5, HashingAlgorithmNone, HashingAlgorithmNotSpecified, HashingAlgorithmSHA1, HashingAlgorithmSHA2256, HashingAlgorithmSHA2384, HashingAlgorithmSHA2512}
}

// IntegrationAccountSkuName enumerates the values for integration account sku name.
type IntegrationAccountSkuName string

const (
	// IntegrationAccountSkuNameBasic ...
	IntegrationAccountSkuNameBasic IntegrationAccountSkuName = "Basic"
	// IntegrationAccountSkuNameFree ...
	IntegrationAccountSkuNameFree IntegrationAccountSkuName = "Free"
	// IntegrationAccountSkuNameNotSpecified ...
	IntegrationAccountSkuNameNotSpecified IntegrationAccountSkuName = "NotSpecified"
	// IntegrationAccountSkuNameStandard ...
	IntegrationAccountSkuNameStandard IntegrationAccountSkuName = "Standard"
)

// PossibleIntegrationAccountSkuNameValues returns an array of possible values for the IntegrationAccountSkuName const type.
func PossibleIntegrationAccountSkuNameValues() []IntegrationAccountSkuName {
	return []IntegrationAccountSkuName{IntegrationAccountSkuNameBasic, IntegrationAccountSkuNameFree, IntegrationAccountSkuNameNotSpecified, IntegrationAccountSkuNameStandard}
}

// IntegrationServiceEnvironmentAccessEndpointType enumerates the values for integration service environment
// access endpoint type.
type IntegrationServiceEnvironmentAccessEndpointType string

const (
	// IntegrationServiceEnvironmentAccessEndpointTypeExternal ...
	IntegrationServiceEnvironmentAccessEndpointTypeExternal IntegrationServiceEnvironmentAccessEndpointType = "External"
	// IntegrationServiceEnvironmentAccessEndpointTypeInternal ...
	IntegrationServiceEnvironmentAccessEndpointTypeInternal IntegrationServiceEnvironmentAccessEndpointType = "Internal"
	// IntegrationServiceEnvironmentAccessEndpointTypeNotSpecified ...
	IntegrationServiceEnvironmentAccessEndpointTypeNotSpecified IntegrationServiceEnvironmentAccessEndpointType = "NotSpecified"
)

// PossibleIntegrationServiceEnvironmentAccessEndpointTypeValues returns an array of possible values for the IntegrationServiceEnvironmentAccessEndpointType const type.
func PossibleIntegrationServiceEnvironmentAccessEndpointTypeValues() []IntegrationServiceEnvironmentAccessEndpointType {
	return []IntegrationServiceEnvironmentAccessEndpointType{IntegrationServiceEnvironmentAccessEndpointTypeExternal, IntegrationServiceEnvironmentAccessEndpointTypeInternal, IntegrationServiceEnvironmentAccessEndpointTypeNotSpecified}
}

// IntegrationServiceEnvironmentNetworkDependencyCategoryType enumerates the values for integration service
// environment network dependency category type.
type IntegrationServiceEnvironmentNetworkDependencyCategoryType string

const (
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAccessEndpoints ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAccessEndpoints IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AccessEndpoints"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureActiveDirectory ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureActiveDirectory IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureActiveDirectory"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureManagement ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureManagement IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureManagement"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureStorage ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureStorage IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureStorage"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeDiagnosticLogsAndMetrics ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeDiagnosticLogsAndMetrics IntegrationServiceEnvironmentNetworkDependencyCategoryType = "DiagnosticLogsAndMetrics"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeIntegrationServiceEnvironmentConnectors ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeIntegrationServiceEnvironmentConnectors IntegrationServiceEnvironmentNetworkDependencyCategoryType = "IntegrationServiceEnvironmentConnectors"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeNotSpecified ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeNotSpecified IntegrationServiceEnvironmentNetworkDependencyCategoryType = "NotSpecified"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRecoveryService ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRecoveryService IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RecoveryService"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRedisCache ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRedisCache IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RedisCache"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRegionalService ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRegionalService IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RegionalService"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSQL ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSQL IntegrationServiceEnvironmentNetworkDependencyCategoryType = "SQL"
	// IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSSLCertificateVerification ...
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSSLCertificateVerification IntegrationServiceEnvironmentNetworkDependencyCategoryType = "SSLCertificateVerification"
)

// PossibleIntegrationServiceEnvironmentNetworkDependencyCategoryTypeValues returns an array of possible values for the IntegrationServiceEnvironmentNetworkDependencyCategoryType const type.
func PossibleIntegrationServiceEnvironmentNetworkDependencyCategoryTypeValues() []IntegrationServiceEnvironmentNetworkDependencyCategoryType {
	return []IntegrationServiceEnvironmentNetworkDependencyCategoryType{IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAccessEndpoints, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureActiveDirectory, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureManagement, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureStorage, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeDiagnosticLogsAndMetrics, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeIntegrationServiceEnvironmentConnectors, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeNotSpecified, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRecoveryService, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRedisCache, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRegionalService, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSQL, IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSSLCertificateVerification}
}

// IntegrationServiceEnvironmentNetworkDependencyHealthState enumerates the values for integration service
// environment network dependency health state.
type IntegrationServiceEnvironmentNetworkDependencyHealthState string

const (
	// IntegrationServiceEnvironmentNetworkDependencyHealthStateHealthy ...
	IntegrationServiceEnvironmentNetworkDependencyHealthStateHealthy IntegrationServiceEnvironmentNetworkDependencyHealthState = "Healthy"
	// IntegrationServiceEnvironmentNetworkDependencyHealthStateNotSpecified ...
	IntegrationServiceEnvironmentNetworkDependencyHealthStateNotSpecified IntegrationServiceEnvironmentNetworkDependencyHealthState = "NotSpecified"
	// IntegrationServiceEnvironmentNetworkDependencyHealthStateUnhealthy ...
	IntegrationServiceEnvironmentNetworkDependencyHealthStateUnhealthy IntegrationServiceEnvironmentNetworkDependencyHealthState = "Unhealthy"
	// IntegrationServiceEnvironmentNetworkDependencyHealthStateUnknown ...
	IntegrationServiceEnvironmentNetworkDependencyHealthStateUnknown IntegrationServiceEnvironmentNetworkDependencyHealthState = "Unknown"
)

// PossibleIntegrationServiceEnvironmentNetworkDependencyHealthStateValues returns an array of possible values for the IntegrationServiceEnvironmentNetworkDependencyHealthState const type.
func PossibleIntegrationServiceEnvironmentNetworkDependencyHealthStateValues() []IntegrationServiceEnvironmentNetworkDependencyHealthState {
	return []IntegrationServiceEnvironmentNetworkDependencyHealthState{IntegrationServiceEnvironmentNetworkDependencyHealthStateHealthy, IntegrationServiceEnvironmentNetworkDependencyHealthStateNotSpecified, IntegrationServiceEnvironmentNetworkDependencyHealthStateUnhealthy, IntegrationServiceEnvironmentNetworkDependencyHealthStateUnknown}
}

// IntegrationServiceEnvironmentNetworkEndPointAccessibilityState enumerates the values for integration service
// environment network end point accessibility state.
type IntegrationServiceEnvironmentNetworkEndPointAccessibilityState string

const (
	// IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateAvailable ...
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateAvailable IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "Available"
	// IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotAvailable ...
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotAvailable IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "NotAvailable"
	// IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotSpecified ...
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotSpecified IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "NotSpecified"
	// IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateUnknown ...
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateUnknown IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "Unknown"
)

// PossibleIntegrationServiceEnvironmentNetworkEndPointAccessibilityStateValues returns an array of possible values for the IntegrationServiceEnvironmentNetworkEndPointAccessibilityState const type.
func PossibleIntegrationServiceEnvironmentNetworkEndPointAccessibilityStateValues() []IntegrationServiceEnvironmentNetworkEndPointAccessibilityState {
	return []IntegrationServiceEnvironmentNetworkEndPointAccessibilityState{IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateAvailable, IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotAvailable, IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotSpecified, IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateUnknown}
}

// IntegrationServiceEnvironmentSkuName enumerates the values for integration service environment sku name.
type IntegrationServiceEnvironmentSkuName string

const (
	// IntegrationServiceEnvironmentSkuNameDeveloper ...
	IntegrationServiceEnvironmentSkuNameDeveloper IntegrationServiceEnvironmentSkuName = "Developer"
	// IntegrationServiceEnvironmentSkuNameNotSpecified ...
	IntegrationServiceEnvironmentSkuNameNotSpecified IntegrationServiceEnvironmentSkuName = "NotSpecified"
	// IntegrationServiceEnvironmentSkuNamePremium ...
	IntegrationServiceEnvironmentSkuNamePremium IntegrationServiceEnvironmentSkuName = "Premium"
)

// PossibleIntegrationServiceEnvironmentSkuNameValues returns an array of possible values for the IntegrationServiceEnvironmentSkuName const type.
func PossibleIntegrationServiceEnvironmentSkuNameValues() []IntegrationServiceEnvironmentSkuName {
	return []IntegrationServiceEnvironmentSkuName{IntegrationServiceEnvironmentSkuNameDeveloper, IntegrationServiceEnvironmentSkuNameNotSpecified, IntegrationServiceEnvironmentSkuNamePremium}
}

// IntegrationServiceEnvironmentSkuScaleType enumerates the values for integration service environment sku
// scale type.
type IntegrationServiceEnvironmentSkuScaleType string

const (
	// Automatic ...
	Automatic IntegrationServiceEnvironmentSkuScaleType = "Automatic"
	// Manual ...
	Manual IntegrationServiceEnvironmentSkuScaleType = "Manual"
	// None ...
	None IntegrationServiceEnvironmentSkuScaleType = "None"
)

// PossibleIntegrationServiceEnvironmentSkuScaleTypeValues returns an array of possible values for the IntegrationServiceEnvironmentSkuScaleType const type.
func PossibleIntegrationServiceEnvironmentSkuScaleTypeValues() []IntegrationServiceEnvironmentSkuScaleType {
	return []IntegrationServiceEnvironmentSkuScaleType{Automatic, Manual, None}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// KeyTypeNotSpecified ...
	KeyTypeNotSpecified KeyType = "NotSpecified"
	// KeyTypePrimary ...
	KeyTypePrimary KeyType = "Primary"
	// KeyTypeSecondary ...
	KeyTypeSecondary KeyType = "Secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{KeyTypeNotSpecified, KeyTypePrimary, KeyTypeSecondary}
}

// MapType enumerates the values for map type.
type MapType string

const (
	// MapTypeLiquid ...
	MapTypeLiquid MapType = "Liquid"
	// MapTypeNotSpecified ...
	MapTypeNotSpecified MapType = "NotSpecified"
	// MapTypeXslt ...
	MapTypeXslt MapType = "Xslt"
	// MapTypeXslt20 ...
	MapTypeXslt20 MapType = "Xslt20"
	// MapTypeXslt30 ...
	MapTypeXslt30 MapType = "Xslt30"
)

// PossibleMapTypeValues returns an array of possible values for the MapType const type.
func PossibleMapTypeValues() []MapType {
	return []MapType{MapTypeLiquid, MapTypeNotSpecified, MapTypeXslt, MapTypeXslt20, MapTypeXslt30}
}

// MessageFilterType enumerates the values for message filter type.
type MessageFilterType string

const (
	// MessageFilterTypeExclude ...
	MessageFilterTypeExclude MessageFilterType = "Exclude"
	// MessageFilterTypeInclude ...
	MessageFilterTypeInclude MessageFilterType = "Include"
	// MessageFilterTypeNotSpecified ...
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// PossibleMessageFilterTypeValues returns an array of possible values for the MessageFilterType const type.
func PossibleMessageFilterTypeValues() []MessageFilterType {
	return []MessageFilterType{MessageFilterTypeExclude, MessageFilterTypeInclude, MessageFilterTypeNotSpecified}
}

// OpenAuthenticationProviderType enumerates the values for open authentication provider type.
type OpenAuthenticationProviderType string

const (
	// AAD ...
	AAD OpenAuthenticationProviderType = "AAD"
)

// PossibleOpenAuthenticationProviderTypeValues returns an array of possible values for the OpenAuthenticationProviderType const type.
func PossibleOpenAuthenticationProviderTypeValues() []OpenAuthenticationProviderType {
	return []OpenAuthenticationProviderType{AAD}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeNotSpecified ...
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureObject ...
	ParameterTypeSecureObject ParameterType = "SecureObject"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeNotSpecified, ParameterTypeObject, ParameterTypeSecureObject, ParameterTypeSecureString, ParameterTypeString}
}

// PartnerType enumerates the values for partner type.
type PartnerType string

const (
	// PartnerTypeB2B ...
	PartnerTypeB2B PartnerType = "B2B"
	// PartnerTypeNotSpecified ...
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// PossiblePartnerTypeValues returns an array of possible values for the PartnerType const type.
func PossiblePartnerTypeValues() []PartnerType {
	return []PartnerType{PartnerTypeB2B, PartnerTypeNotSpecified}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNotSpecified ...
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	// RecurrenceFrequencySecond ...
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNotSpecified, RecurrenceFrequencySecond, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// SchemaType enumerates the values for schema type.
type SchemaType string

const (
	// SchemaTypeNotSpecified ...
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	// SchemaTypeXML ...
	SchemaTypeXML SchemaType = "Xml"
)

// PossibleSchemaTypeValues returns an array of possible values for the SchemaType const type.
func PossibleSchemaTypeValues() []SchemaType {
	return []SchemaType{SchemaTypeNotSpecified, SchemaTypeXML}
}

// SegmentTerminatorSuffix enumerates the values for segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	// SegmentTerminatorSuffixCR ...
	SegmentTerminatorSuffixCR SegmentTerminatorSuffix = "CR"
	// SegmentTerminatorSuffixCRLF ...
	SegmentTerminatorSuffixCRLF SegmentTerminatorSuffix = "CRLF"
	// SegmentTerminatorSuffixLF ...
	SegmentTerminatorSuffixLF SegmentTerminatorSuffix = "LF"
	// SegmentTerminatorSuffixNone ...
	SegmentTerminatorSuffixNone SegmentTerminatorSuffix = "None"
	// SegmentTerminatorSuffixNotSpecified ...
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
)

// PossibleSegmentTerminatorSuffixValues returns an array of possible values for the SegmentTerminatorSuffix const type.
func PossibleSegmentTerminatorSuffixValues() []SegmentTerminatorSuffix {
	return []SegmentTerminatorSuffix{SegmentTerminatorSuffixCR, SegmentTerminatorSuffixCRLF, SegmentTerminatorSuffixLF, SegmentTerminatorSuffixNone, SegmentTerminatorSuffixNotSpecified}
}

// SigningAlgorithm enumerates the values for signing algorithm.
type SigningAlgorithm string

const (
	// SigningAlgorithmDefault ...
	SigningAlgorithmDefault SigningAlgorithm = "Default"
	// SigningAlgorithmNotSpecified ...
	SigningAlgorithmNotSpecified SigningAlgorithm = "NotSpecified"
	// SigningAlgorithmSHA1 ...
	SigningAlgorithmSHA1 SigningAlgorithm = "SHA1"
	// SigningAlgorithmSHA2256 ...
	SigningAlgorithmSHA2256 SigningAlgorithm = "SHA2256"
	// SigningAlgorithmSHA2384 ...
	SigningAlgorithmSHA2384 SigningAlgorithm = "SHA2384"
	// SigningAlgorithmSHA2512 ...
	SigningAlgorithmSHA2512 SigningAlgorithm = "SHA2512"
)

// PossibleSigningAlgorithmValues returns an array of possible values for the SigningAlgorithm const type.
func PossibleSigningAlgorithmValues() []SigningAlgorithm {
	return []SigningAlgorithm{SigningAlgorithmDefault, SigningAlgorithmNotSpecified, SigningAlgorithmSHA1, SigningAlgorithmSHA2256, SigningAlgorithmSHA2384, SigningAlgorithmSHA2512}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified ...
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameFree, SkuNameNotSpecified, SkuNamePremium, SkuNameShared, SkuNameStandard}
}

// StatusAnnotation enumerates the values for status annotation.
type StatusAnnotation string

const (
	// StatusAnnotationNotSpecified ...
	StatusAnnotationNotSpecified StatusAnnotation = "NotSpecified"
	// StatusAnnotationPreview ...
	StatusAnnotationPreview StatusAnnotation = "Preview"
	// StatusAnnotationProduction ...
	StatusAnnotationProduction StatusAnnotation = "Production"
)

// PossibleStatusAnnotationValues returns an array of possible values for the StatusAnnotation const type.
func PossibleStatusAnnotationValues() []StatusAnnotation {
	return []StatusAnnotation{StatusAnnotationNotSpecified, StatusAnnotationPreview, StatusAnnotationProduction}
}

// SwaggerSchemaType enumerates the values for swagger schema type.
type SwaggerSchemaType string

const (
	// Array ...
	Array SwaggerSchemaType = "Array"
	// Boolean ...
	Boolean SwaggerSchemaType = "Boolean"
	// File ...
	File SwaggerSchemaType = "File"
	// Integer ...
	Integer SwaggerSchemaType = "Integer"
	// Null ...
	Null SwaggerSchemaType = "Null"
	// Number ...
	Number SwaggerSchemaType = "Number"
	// Object ...
	Object SwaggerSchemaType = "Object"
	// String ...
	String SwaggerSchemaType = "String"
)

// PossibleSwaggerSchemaTypeValues returns an array of possible values for the SwaggerSchemaType const type.
func PossibleSwaggerSchemaTypeValues() []SwaggerSchemaType {
	return []SwaggerSchemaType{Array, Boolean, File, Integer, Null, Number, Object, String}
}

// TrackEventsOperationOptions enumerates the values for track events operation options.
type TrackEventsOperationOptions string

const (
	// TrackEventsOperationOptionsDisableSourceInfoEnrich ...
	TrackEventsOperationOptionsDisableSourceInfoEnrich TrackEventsOperationOptions = "DisableSourceInfoEnrich"
	// TrackEventsOperationOptionsNone ...
	TrackEventsOperationOptionsNone TrackEventsOperationOptions = "None"
)

// PossibleTrackEventsOperationOptionsValues returns an array of possible values for the TrackEventsOperationOptions const type.
func PossibleTrackEventsOperationOptionsValues() []TrackEventsOperationOptions {
	return []TrackEventsOperationOptions{TrackEventsOperationOptionsDisableSourceInfoEnrich, TrackEventsOperationOptionsNone}
}

// TrackingRecordType enumerates the values for tracking record type.
type TrackingRecordType string

const (
	// TrackingRecordTypeAS2MDN ...
	TrackingRecordTypeAS2MDN TrackingRecordType = "AS2MDN"
	// TrackingRecordTypeAS2Message ...
	TrackingRecordTypeAS2Message TrackingRecordType = "AS2Message"
	// TrackingRecordTypeCustom ...
	TrackingRecordTypeCustom TrackingRecordType = "Custom"
	// TrackingRecordTypeEdifactFunctionalGroup ...
	TrackingRecordTypeEdifactFunctionalGroup TrackingRecordType = "EdifactFunctionalGroup"
	// TrackingRecordTypeEdifactFunctionalGroupAcknowledgment ...
	TrackingRecordTypeEdifactFunctionalGroupAcknowledgment TrackingRecordType = "EdifactFunctionalGroupAcknowledgment"
	// TrackingRecordTypeEdifactInterchange ...
	TrackingRecordTypeEdifactInterchange TrackingRecordType = "EdifactInterchange"
	// TrackingRecordTypeEdifactInterchangeAcknowledgment ...
	TrackingRecordTypeEdifactInterchangeAcknowledgment TrackingRecordType = "EdifactInterchangeAcknowledgment"
	// TrackingRecordTypeEdifactTransactionSet ...
	TrackingRecordTypeEdifactTransactionSet TrackingRecordType = "EdifactTransactionSet"
	// TrackingRecordTypeEdifactTransactionSetAcknowledgment ...
	TrackingRecordTypeEdifactTransactionSetAcknowledgment TrackingRecordType = "EdifactTransactionSetAcknowledgment"
	// TrackingRecordTypeNotSpecified ...
	TrackingRecordTypeNotSpecified TrackingRecordType = "NotSpecified"
	// TrackingRecordTypeX12FunctionalGroup ...
	TrackingRecordTypeX12FunctionalGroup TrackingRecordType = "X12FunctionalGroup"
	// TrackingRecordTypeX12FunctionalGroupAcknowledgment ...
	TrackingRecordTypeX12FunctionalGroupAcknowledgment TrackingRecordType = "X12FunctionalGroupAcknowledgment"
	// TrackingRecordTypeX12Interchange ...
	TrackingRecordTypeX12Interchange TrackingRecordType = "X12Interchange"
	// TrackingRecordTypeX12InterchangeAcknowledgment ...
	TrackingRecordTypeX12InterchangeAcknowledgment TrackingRecordType = "X12InterchangeAcknowledgment"
	// TrackingRecordTypeX12TransactionSet ...
	TrackingRecordTypeX12TransactionSet TrackingRecordType = "X12TransactionSet"
	// TrackingRecordTypeX12TransactionSetAcknowledgment ...
	TrackingRecordTypeX12TransactionSetAcknowledgment TrackingRecordType = "X12TransactionSetAcknowledgment"
)

// PossibleTrackingRecordTypeValues returns an array of possible values for the TrackingRecordType const type.
func PossibleTrackingRecordTypeValues() []TrackingRecordType {
	return []TrackingRecordType{TrackingRecordTypeAS2MDN, TrackingRecordTypeAS2Message, TrackingRecordTypeCustom, TrackingRecordTypeEdifactFunctionalGroup, TrackingRecordTypeEdifactFunctionalGroupAcknowledgment, TrackingRecordTypeEdifactInterchange, TrackingRecordTypeEdifactInterchangeAcknowledgment, TrackingRecordTypeEdifactTransactionSet, TrackingRecordTypeEdifactTransactionSetAcknowledgment, TrackingRecordTypeNotSpecified, TrackingRecordTypeX12FunctionalGroup, TrackingRecordTypeX12FunctionalGroupAcknowledgment, TrackingRecordTypeX12Interchange, TrackingRecordTypeX12InterchangeAcknowledgment, TrackingRecordTypeX12TransactionSet, TrackingRecordTypeX12TransactionSetAcknowledgment}
}

// TrailingSeparatorPolicy enumerates the values for trailing separator policy.
type TrailingSeparatorPolicy string

const (
	// TrailingSeparatorPolicyMandatory ...
	TrailingSeparatorPolicyMandatory TrailingSeparatorPolicy = "Mandatory"
	// TrailingSeparatorPolicyNotAllowed ...
	TrailingSeparatorPolicyNotAllowed TrailingSeparatorPolicy = "NotAllowed"
	// TrailingSeparatorPolicyNotSpecified ...
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	// TrailingSeparatorPolicyOptional ...
	TrailingSeparatorPolicyOptional TrailingSeparatorPolicy = "Optional"
)

// PossibleTrailingSeparatorPolicyValues returns an array of possible values for the TrailingSeparatorPolicy const type.
func PossibleTrailingSeparatorPolicyValues() []TrailingSeparatorPolicy {
	return []TrailingSeparatorPolicy{TrailingSeparatorPolicyMandatory, TrailingSeparatorPolicyNotAllowed, TrailingSeparatorPolicyNotSpecified, TrailingSeparatorPolicyOptional}
}

// UsageIndicator enumerates the values for usage indicator.
type UsageIndicator string

const (
	// UsageIndicatorInformation ...
	UsageIndicatorInformation UsageIndicator = "Information"
	// UsageIndicatorNotSpecified ...
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	// UsageIndicatorProduction ...
	UsageIndicatorProduction UsageIndicator = "Production"
	// UsageIndicatorTest ...
	UsageIndicatorTest UsageIndicator = "Test"
)

// PossibleUsageIndicatorValues returns an array of possible values for the UsageIndicator const type.
func PossibleUsageIndicatorValues() []UsageIndicator {
	return []UsageIndicator{UsageIndicatorInformation, UsageIndicatorNotSpecified, UsageIndicatorProduction, UsageIndicatorTest}
}

// WorkflowProvisioningState enumerates the values for workflow provisioning state.
type WorkflowProvisioningState string

const (
	// WorkflowProvisioningStateAccepted ...
	WorkflowProvisioningStateAccepted WorkflowProvisioningState = "Accepted"
	// WorkflowProvisioningStateCanceled ...
	WorkflowProvisioningStateCanceled WorkflowProvisioningState = "Canceled"
	// WorkflowProvisioningStateCompleted ...
	WorkflowProvisioningStateCompleted WorkflowProvisioningState = "Completed"
	// WorkflowProvisioningStateCreated ...
	WorkflowProvisioningStateCreated WorkflowProvisioningState = "Created"
	// WorkflowProvisioningStateCreating ...
	WorkflowProvisioningStateCreating WorkflowProvisioningState = "Creating"
	// WorkflowProvisioningStateDeleted ...
	WorkflowProvisioningStateDeleted WorkflowProvisioningState = "Deleted"
	// WorkflowProvisioningStateDeleting ...
	WorkflowProvisioningStateDeleting WorkflowProvisioningState = "Deleting"
	// WorkflowProvisioningStateFailed ...
	WorkflowProvisioningStateFailed WorkflowProvisioningState = "Failed"
	// WorkflowProvisioningStateInProgress ...
	WorkflowProvisioningStateInProgress WorkflowProvisioningState = "InProgress"
	// WorkflowProvisioningStateMoving ...
	WorkflowProvisioningStateMoving WorkflowProvisioningState = "Moving"
	// WorkflowProvisioningStateNotSpecified ...
	WorkflowProvisioningStateNotSpecified WorkflowProvisioningState = "NotSpecified"
	// WorkflowProvisioningStatePending ...
	WorkflowProvisioningStatePending WorkflowProvisioningState = "Pending"
	// WorkflowProvisioningStateReady ...
	WorkflowProvisioningStateReady WorkflowProvisioningState = "Ready"
	// WorkflowProvisioningStateRegistered ...
	WorkflowProvisioningStateRegistered WorkflowProvisioningState = "Registered"
	// WorkflowProvisioningStateRegistering ...
	WorkflowProvisioningStateRegistering WorkflowProvisioningState = "Registering"
	// WorkflowProvisioningStateRenewing ...
	WorkflowProvisioningStateRenewing WorkflowProvisioningState = "Renewing"
	// WorkflowProvisioningStateRunning ...
	WorkflowProvisioningStateRunning WorkflowProvisioningState = "Running"
	// WorkflowProvisioningStateSucceeded ...
	WorkflowProvisioningStateSucceeded WorkflowProvisioningState = "Succeeded"
	// WorkflowProvisioningStateUnregistered ...
	WorkflowProvisioningStateUnregistered WorkflowProvisioningState = "Unregistered"
	// WorkflowProvisioningStateUnregistering ...
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = "Unregistering"
	// WorkflowProvisioningStateUpdating ...
	WorkflowProvisioningStateUpdating WorkflowProvisioningState = "Updating"
	// WorkflowProvisioningStateWaiting ...
	WorkflowProvisioningStateWaiting WorkflowProvisioningState = "Waiting"
)

// PossibleWorkflowProvisioningStateValues returns an array of possible values for the WorkflowProvisioningState const type.
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return []WorkflowProvisioningState{WorkflowProvisioningStateAccepted, WorkflowProvisioningStateCanceled, WorkflowProvisioningStateCompleted, WorkflowProvisioningStateCreated, WorkflowProvisioningStateCreating, WorkflowProvisioningStateDeleted, WorkflowProvisioningStateDeleting, WorkflowProvisioningStateFailed, WorkflowProvisioningStateInProgress, WorkflowProvisioningStateMoving, WorkflowProvisioningStateNotSpecified, WorkflowProvisioningStatePending, WorkflowProvisioningStateReady, WorkflowProvisioningStateRegistered, WorkflowProvisioningStateRegistering, WorkflowProvisioningStateRenewing, WorkflowProvisioningStateRunning, WorkflowProvisioningStateSucceeded, WorkflowProvisioningStateUnregistered, WorkflowProvisioningStateUnregistering, WorkflowProvisioningStateUpdating, WorkflowProvisioningStateWaiting}
}

// WorkflowState enumerates the values for workflow state.
type WorkflowState string

const (
	// WorkflowStateCompleted ...
	WorkflowStateCompleted WorkflowState = "Completed"
	// WorkflowStateDeleted ...
	WorkflowStateDeleted WorkflowState = "Deleted"
	// WorkflowStateDisabled ...
	WorkflowStateDisabled WorkflowState = "Disabled"
	// WorkflowStateEnabled ...
	WorkflowStateEnabled WorkflowState = "Enabled"
	// WorkflowStateNotSpecified ...
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	// WorkflowStateSuspended ...
	WorkflowStateSuspended WorkflowState = "Suspended"
)

// PossibleWorkflowStateValues returns an array of possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{WorkflowStateCompleted, WorkflowStateDeleted, WorkflowStateDisabled, WorkflowStateEnabled, WorkflowStateNotSpecified, WorkflowStateSuspended}
}

// WorkflowStatus enumerates the values for workflow status.
type WorkflowStatus string

const (
	// WorkflowStatusAborted ...
	WorkflowStatusAborted WorkflowStatus = "Aborted"
	// WorkflowStatusCancelled ...
	WorkflowStatusCancelled WorkflowStatus = "Cancelled"
	// WorkflowStatusFailed ...
	WorkflowStatusFailed WorkflowStatus = "Failed"
	// WorkflowStatusFaulted ...
	WorkflowStatusFaulted WorkflowStatus = "Faulted"
	// WorkflowStatusIgnored ...
	WorkflowStatusIgnored WorkflowStatus = "Ignored"
	// WorkflowStatusNotSpecified ...
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	// WorkflowStatusPaused ...
	WorkflowStatusPaused WorkflowStatus = "Paused"
	// WorkflowStatusRunning ...
	WorkflowStatusRunning WorkflowStatus = "Running"
	// WorkflowStatusSkipped ...
	WorkflowStatusSkipped WorkflowStatus = "Skipped"
	// WorkflowStatusSucceeded ...
	WorkflowStatusSucceeded WorkflowStatus = "Succeeded"
	// WorkflowStatusSuspended ...
	WorkflowStatusSuspended WorkflowStatus = "Suspended"
	// WorkflowStatusTimedOut ...
	WorkflowStatusTimedOut WorkflowStatus = "TimedOut"
	// WorkflowStatusWaiting ...
	WorkflowStatusWaiting WorkflowStatus = "Waiting"
)

// PossibleWorkflowStatusValues returns an array of possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{WorkflowStatusAborted, WorkflowStatusCancelled, WorkflowStatusFailed, WorkflowStatusFaulted, WorkflowStatusIgnored, WorkflowStatusNotSpecified, WorkflowStatusPaused, WorkflowStatusRunning, WorkflowStatusSkipped, WorkflowStatusSucceeded, WorkflowStatusSuspended, WorkflowStatusTimedOut, WorkflowStatusWaiting}
}

// WorkflowTriggerProvisioningState enumerates the values for workflow trigger provisioning state.
type WorkflowTriggerProvisioningState string

const (
	// WorkflowTriggerProvisioningStateAccepted ...
	WorkflowTriggerProvisioningStateAccepted WorkflowTriggerProvisioningState = "Accepted"
	// WorkflowTriggerProvisioningStateCanceled ...
	WorkflowTriggerProvisioningStateCanceled WorkflowTriggerProvisioningState = "Canceled"
	// WorkflowTriggerProvisioningStateCompleted ...
	WorkflowTriggerProvisioningStateCompleted WorkflowTriggerProvisioningState = "Completed"
	// WorkflowTriggerProvisioningStateCreated ...
	WorkflowTriggerProvisioningStateCreated WorkflowTriggerProvisioningState = "Created"
	// WorkflowTriggerProvisioningStateCreating ...
	WorkflowTriggerProvisioningStateCreating WorkflowTriggerProvisioningState = "Creating"
	// WorkflowTriggerProvisioningStateDeleted ...
	WorkflowTriggerProvisioningStateDeleted WorkflowTriggerProvisioningState = "Deleted"
	// WorkflowTriggerProvisioningStateDeleting ...
	WorkflowTriggerProvisioningStateDeleting WorkflowTriggerProvisioningState = "Deleting"
	// WorkflowTriggerProvisioningStateFailed ...
	WorkflowTriggerProvisioningStateFailed WorkflowTriggerProvisioningState = "Failed"
	// WorkflowTriggerProvisioningStateMoving ...
	WorkflowTriggerProvisioningStateMoving WorkflowTriggerProvisioningState = "Moving"
	// WorkflowTriggerProvisioningStateNotSpecified ...
	WorkflowTriggerProvisioningStateNotSpecified WorkflowTriggerProvisioningState = "NotSpecified"
	// WorkflowTriggerProvisioningStateReady ...
	WorkflowTriggerProvisioningStateReady WorkflowTriggerProvisioningState = "Ready"
	// WorkflowTriggerProvisioningStateRegistered ...
	WorkflowTriggerProvisioningStateRegistered WorkflowTriggerProvisioningState = "Registered"
	// WorkflowTriggerProvisioningStateRegistering ...
	WorkflowTriggerProvisioningStateRegistering WorkflowTriggerProvisioningState = "Registering"
	// WorkflowTriggerProvisioningStateRunning ...
	WorkflowTriggerProvisioningStateRunning WorkflowTriggerProvisioningState = "Running"
	// WorkflowTriggerProvisioningStateSucceeded ...
	WorkflowTriggerProvisioningStateSucceeded WorkflowTriggerProvisioningState = "Succeeded"
	// WorkflowTriggerProvisioningStateUnregistered ...
	WorkflowTriggerProvisioningStateUnregistered WorkflowTriggerProvisioningState = "Unregistered"
	// WorkflowTriggerProvisioningStateUnregistering ...
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = "Unregistering"
	// WorkflowTriggerProvisioningStateUpdating ...
	WorkflowTriggerProvisioningStateUpdating WorkflowTriggerProvisioningState = "Updating"
)

// PossibleWorkflowTriggerProvisioningStateValues returns an array of possible values for the WorkflowTriggerProvisioningState const type.
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return []WorkflowTriggerProvisioningState{WorkflowTriggerProvisioningStateAccepted, WorkflowTriggerProvisioningStateCanceled, WorkflowTriggerProvisioningStateCompleted, WorkflowTriggerProvisioningStateCreated, WorkflowTriggerProvisioningStateCreating, WorkflowTriggerProvisioningStateDeleted, WorkflowTriggerProvisioningStateDeleting, WorkflowTriggerProvisioningStateFailed, WorkflowTriggerProvisioningStateMoving, WorkflowTriggerProvisioningStateNotSpecified, WorkflowTriggerProvisioningStateReady, WorkflowTriggerProvisioningStateRegistered, WorkflowTriggerProvisioningStateRegistering, WorkflowTriggerProvisioningStateRunning, WorkflowTriggerProvisioningStateSucceeded, WorkflowTriggerProvisioningStateUnregistered, WorkflowTriggerProvisioningStateUnregistering, WorkflowTriggerProvisioningStateUpdating}
}

// WsdlImportMethod enumerates the values for wsdl import method.
type WsdlImportMethod string

const (
	// WsdlImportMethodNotSpecified ...
	WsdlImportMethodNotSpecified WsdlImportMethod = "NotSpecified"
	// WsdlImportMethodSoapPassThrough ...
	WsdlImportMethodSoapPassThrough WsdlImportMethod = "SoapPassThrough"
	// WsdlImportMethodSoapToRest ...
	WsdlImportMethodSoapToRest WsdlImportMethod = "SoapToRest"
)

// PossibleWsdlImportMethodValues returns an array of possible values for the WsdlImportMethod const type.
func PossibleWsdlImportMethodValues() []WsdlImportMethod {
	return []WsdlImportMethod{WsdlImportMethodNotSpecified, WsdlImportMethodSoapPassThrough, WsdlImportMethodSoapToRest}
}

// X12CharacterSet enumerates the values for x12 character set.
type X12CharacterSet string

const (
	// X12CharacterSetBasic ...
	X12CharacterSetBasic X12CharacterSet = "Basic"
	// X12CharacterSetExtended ...
	X12CharacterSetExtended X12CharacterSet = "Extended"
	// X12CharacterSetNotSpecified ...
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	// X12CharacterSetUTF8 ...
	X12CharacterSetUTF8 X12CharacterSet = "UTF8"
)

// PossibleX12CharacterSetValues returns an array of possible values for the X12CharacterSet const type.
func PossibleX12CharacterSetValues() []X12CharacterSet {
	return []X12CharacterSet{X12CharacterSetBasic, X12CharacterSetExtended, X12CharacterSetNotSpecified, X12CharacterSetUTF8}
}

// X12DateFormat enumerates the values for x12 date format.
type X12DateFormat string

const (
	// X12DateFormatCCYYMMDD ...
	X12DateFormatCCYYMMDD X12DateFormat = "CCYYMMDD"
	// X12DateFormatNotSpecified ...
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	// X12DateFormatYYMMDD ...
	X12DateFormatYYMMDD X12DateFormat = "YYMMDD"
)

// PossibleX12DateFormatValues returns an array of possible values for the X12DateFormat const type.
func PossibleX12DateFormatValues() []X12DateFormat {
	return []X12DateFormat{X12DateFormatCCYYMMDD, X12DateFormatNotSpecified, X12DateFormatYYMMDD}
}

// X12TimeFormat enumerates the values for x12 time format.
type X12TimeFormat string

const (
	// X12TimeFormatHHMM ...
	X12TimeFormatHHMM X12TimeFormat = "HHMM"
	// X12TimeFormatHHMMSS ...
	X12TimeFormatHHMMSS X12TimeFormat = "HHMMSS"
	// X12TimeFormatHHMMSSd ...
	X12TimeFormatHHMMSSd X12TimeFormat = "HHMMSSd"
	// X12TimeFormatHHMMSSdd ...
	X12TimeFormatHHMMSSdd X12TimeFormat = "HHMMSSdd"
	// X12TimeFormatNotSpecified ...
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// PossibleX12TimeFormatValues returns an array of possible values for the X12TimeFormat const type.
func PossibleX12TimeFormatValues() []X12TimeFormat {
	return []X12TimeFormat{X12TimeFormatHHMM, X12TimeFormatHHMMSS, X12TimeFormatHHMMSSd, X12TimeFormatHHMMSSdd, X12TimeFormatNotSpecified}
}
