package network

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Access enumerates the values for access.
type Access string

const (
	// Allow ...
	Allow Access = "Allow"
	// Deny ...
	Deny Access = "Deny"
)

// PossibleAccessValues returns an array of possible values for the Access const type.
func PossibleAccessValues() []Access {
	return []Access{Allow, Deny}
}

// ApplicationGatewayBackendHealthServerHealth enumerates the values for application gateway backend health
// server health.
type ApplicationGatewayBackendHealthServerHealth string

const (
	// Down ...
	Down ApplicationGatewayBackendHealthServerHealth = "Down"
	// Draining ...
	Draining ApplicationGatewayBackendHealthServerHealth = "Draining"
	// Partial ...
	Partial ApplicationGatewayBackendHealthServerHealth = "Partial"
	// Unknown ...
	Unknown ApplicationGatewayBackendHealthServerHealth = "Unknown"
	// Up ...
	Up ApplicationGatewayBackendHealthServerHealth = "Up"
)

// PossibleApplicationGatewayBackendHealthServerHealthValues returns an array of possible values for the ApplicationGatewayBackendHealthServerHealth const type.
func PossibleApplicationGatewayBackendHealthServerHealthValues() []ApplicationGatewayBackendHealthServerHealth {
	return []ApplicationGatewayBackendHealthServerHealth{Down, Draining, Partial, Unknown, Up}
}

// ApplicationGatewayCookieBasedAffinity enumerates the values for application gateway cookie based affinity.
type ApplicationGatewayCookieBasedAffinity string

const (
	// Disabled ...
	Disabled ApplicationGatewayCookieBasedAffinity = "Disabled"
	// Enabled ...
	Enabled ApplicationGatewayCookieBasedAffinity = "Enabled"
)

// PossibleApplicationGatewayCookieBasedAffinityValues returns an array of possible values for the ApplicationGatewayCookieBasedAffinity const type.
func PossibleApplicationGatewayCookieBasedAffinityValues() []ApplicationGatewayCookieBasedAffinity {
	return []ApplicationGatewayCookieBasedAffinity{Disabled, Enabled}
}

// ApplicationGatewayCustomErrorStatusCode enumerates the values for application gateway custom error status
// code.
type ApplicationGatewayCustomErrorStatusCode string

const (
	// HTTPStatus403 ...
	HTTPStatus403 ApplicationGatewayCustomErrorStatusCode = "HttpStatus403"
	// HTTPStatus502 ...
	HTTPStatus502 ApplicationGatewayCustomErrorStatusCode = "HttpStatus502"
)

// PossibleApplicationGatewayCustomErrorStatusCodeValues returns an array of possible values for the ApplicationGatewayCustomErrorStatusCode const type.
func PossibleApplicationGatewayCustomErrorStatusCodeValues() []ApplicationGatewayCustomErrorStatusCode {
	return []ApplicationGatewayCustomErrorStatusCode{HTTPStatus403, HTTPStatus502}
}

// ApplicationGatewayFirewallMode enumerates the values for application gateway firewall mode.
type ApplicationGatewayFirewallMode string

const (
	// Detection ...
	Detection ApplicationGatewayFirewallMode = "Detection"
	// Prevention ...
	Prevention ApplicationGatewayFirewallMode = "Prevention"
)

// PossibleApplicationGatewayFirewallModeValues returns an array of possible values for the ApplicationGatewayFirewallMode const type.
func PossibleApplicationGatewayFirewallModeValues() []ApplicationGatewayFirewallMode {
	return []ApplicationGatewayFirewallMode{Detection, Prevention}
}

// ApplicationGatewayOperationalState enumerates the values for application gateway operational state.
type ApplicationGatewayOperationalState string

const (
	// Running ...
	Running ApplicationGatewayOperationalState = "Running"
	// Starting ...
	Starting ApplicationGatewayOperationalState = "Starting"
	// Stopped ...
	Stopped ApplicationGatewayOperationalState = "Stopped"
	// Stopping ...
	Stopping ApplicationGatewayOperationalState = "Stopping"
)

// PossibleApplicationGatewayOperationalStateValues returns an array of possible values for the ApplicationGatewayOperationalState const type.
func PossibleApplicationGatewayOperationalStateValues() []ApplicationGatewayOperationalState {
	return []ApplicationGatewayOperationalState{Running, Starting, Stopped, Stopping}
}

// ApplicationGatewayProtocol enumerates the values for application gateway protocol.
type ApplicationGatewayProtocol string

const (
	// HTTP ...
	HTTP ApplicationGatewayProtocol = "Http"
	// HTTPS ...
	HTTPS ApplicationGatewayProtocol = "Https"
)

// PossibleApplicationGatewayProtocolValues returns an array of possible values for the ApplicationGatewayProtocol const type.
func PossibleApplicationGatewayProtocolValues() []ApplicationGatewayProtocol {
	return []ApplicationGatewayProtocol{HTTP, HTTPS}
}

// ApplicationGatewayRedirectType enumerates the values for application gateway redirect type.
type ApplicationGatewayRedirectType string

const (
	// Found ...
	Found ApplicationGatewayRedirectType = "Found"
	// Permanent ...
	Permanent ApplicationGatewayRedirectType = "Permanent"
	// SeeOther ...
	SeeOther ApplicationGatewayRedirectType = "SeeOther"
	// Temporary ...
	Temporary ApplicationGatewayRedirectType = "Temporary"
)

// PossibleApplicationGatewayRedirectTypeValues returns an array of possible values for the ApplicationGatewayRedirectType const type.
func PossibleApplicationGatewayRedirectTypeValues() []ApplicationGatewayRedirectType {
	return []ApplicationGatewayRedirectType{Found, Permanent, SeeOther, Temporary}
}

// ApplicationGatewayRequestRoutingRuleType enumerates the values for application gateway request routing rule
// type.
type ApplicationGatewayRequestRoutingRuleType string

const (
	// Basic ...
	Basic ApplicationGatewayRequestRoutingRuleType = "Basic"
	// PathBasedRouting ...
	PathBasedRouting ApplicationGatewayRequestRoutingRuleType = "PathBasedRouting"
)

// PossibleApplicationGatewayRequestRoutingRuleTypeValues returns an array of possible values for the ApplicationGatewayRequestRoutingRuleType const type.
func PossibleApplicationGatewayRequestRoutingRuleTypeValues() []ApplicationGatewayRequestRoutingRuleType {
	return []ApplicationGatewayRequestRoutingRuleType{Basic, PathBasedRouting}
}

// ApplicationGatewaySkuName enumerates the values for application gateway sku name.
type ApplicationGatewaySkuName string

const (
	// StandardLarge ...
	StandardLarge ApplicationGatewaySkuName = "Standard_Large"
	// StandardMedium ...
	StandardMedium ApplicationGatewaySkuName = "Standard_Medium"
	// StandardSmall ...
	StandardSmall ApplicationGatewaySkuName = "Standard_Small"
	// StandardV2 ...
	StandardV2 ApplicationGatewaySkuName = "Standard_v2"
	// WAFLarge ...
	WAFLarge ApplicationGatewaySkuName = "WAF_Large"
	// WAFMedium ...
	WAFMedium ApplicationGatewaySkuName = "WAF_Medium"
	// WAFV2 ...
	WAFV2 ApplicationGatewaySkuName = "WAF_v2"
)

// PossibleApplicationGatewaySkuNameValues returns an array of possible values for the ApplicationGatewaySkuName const type.
func PossibleApplicationGatewaySkuNameValues() []ApplicationGatewaySkuName {
	return []ApplicationGatewaySkuName{StandardLarge, StandardMedium, StandardSmall, StandardV2, WAFLarge, WAFMedium, WAFV2}
}

// ApplicationGatewaySslCipherSuite enumerates the values for application gateway ssl cipher suite.
type ApplicationGatewaySslCipherSuite string

const (
	// TLSDHEDSSWITH3DESEDECBCSHA ...
	TLSDHEDSSWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA"
	// TLSDHEDSSWITHAES128CBCSHA ...
	TLSDHEDSSWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"
	// TLSDHEDSSWITHAES128CBCSHA256 ...
	TLSDHEDSSWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256"
	// TLSDHEDSSWITHAES256CBCSHA ...
	TLSDHEDSSWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA"
	// TLSDHEDSSWITHAES256CBCSHA256 ...
	TLSDHEDSSWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256"
	// TLSDHERSAWITHAES128CBCSHA ...
	TLSDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA"
	// TLSDHERSAWITHAES128GCMSHA256 ...
	TLSDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"
	// TLSDHERSAWITHAES256CBCSHA ...
	TLSDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_CBC_SHA"
	// TLSDHERSAWITHAES256GCMSHA384 ...
	TLSDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"
	// TLSECDHEECDSAWITHAES128CBCSHA ...
	TLSECDHEECDSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA"
	// TLSECDHEECDSAWITHAES128CBCSHA256 ...
	TLSECDHEECDSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"
	// TLSECDHEECDSAWITHAES128GCMSHA256 ...
	TLSECDHEECDSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"
	// TLSECDHEECDSAWITHAES256CBCSHA ...
	TLSECDHEECDSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA"
	// TLSECDHEECDSAWITHAES256CBCSHA384 ...
	TLSECDHEECDSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"
	// TLSECDHEECDSAWITHAES256GCMSHA384 ...
	TLSECDHEECDSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
	// TLSECDHERSAWITHAES128CBCSHA ...
	TLSECDHERSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"
	// TLSECDHERSAWITHAES128CBCSHA256 ...
	TLSECDHERSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"
	// TLSECDHERSAWITHAES128GCMSHA256 ...
	TLSECDHERSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"
	// TLSECDHERSAWITHAES256CBCSHA ...
	TLSECDHERSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA"
	// TLSECDHERSAWITHAES256CBCSHA384 ...
	TLSECDHERSAWITHAES256CBCSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"
	// TLSECDHERSAWITHAES256GCMSHA384 ...
	TLSECDHERSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"
	// TLSRSAWITH3DESEDECBCSHA ...
	TLSRSAWITH3DESEDECBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_3DES_EDE_CBC_SHA"
	// TLSRSAWITHAES128CBCSHA ...
	TLSRSAWITHAES128CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA"
	// TLSRSAWITHAES128CBCSHA256 ...
	TLSRSAWITHAES128CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_CBC_SHA256"
	// TLSRSAWITHAES128GCMSHA256 ...
	TLSRSAWITHAES128GCMSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_128_GCM_SHA256"
	// TLSRSAWITHAES256CBCSHA ...
	TLSRSAWITHAES256CBCSHA ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA"
	// TLSRSAWITHAES256CBCSHA256 ...
	TLSRSAWITHAES256CBCSHA256 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_CBC_SHA256"
	// TLSRSAWITHAES256GCMSHA384 ...
	TLSRSAWITHAES256GCMSHA384 ApplicationGatewaySslCipherSuite = "TLS_RSA_WITH_AES_256_GCM_SHA384"
)

// PossibleApplicationGatewaySslCipherSuiteValues returns an array of possible values for the ApplicationGatewaySslCipherSuite const type.
func PossibleApplicationGatewaySslCipherSuiteValues() []ApplicationGatewaySslCipherSuite {
	return []ApplicationGatewaySslCipherSuite{TLSDHEDSSWITH3DESEDECBCSHA, TLSDHEDSSWITHAES128CBCSHA, TLSDHEDSSWITHAES128CBCSHA256, TLSDHEDSSWITHAES256CBCSHA, TLSDHEDSSWITHAES256CBCSHA256, TLSDHERSAWITHAES128CBCSHA, TLSDHERSAWITHAES128GCMSHA256, TLSDHERSAWITHAES256CBCSHA, TLSDHERSAWITHAES256GCMSHA384, TLSECDHEECDSAWITHAES128CBCSHA, TLSECDHEECDSAWITHAES128CBCSHA256, TLSECDHEECDSAWITHAES128GCMSHA256, TLSECDHEECDSAWITHAES256CBCSHA, TLSECDHEECDSAWITHAES256CBCSHA384, TLSECDHEECDSAWITHAES256GCMSHA384, TLSECDHERSAWITHAES128CBCSHA, TLSECDHERSAWITHAES128CBCSHA256, TLSECDHERSAWITHAES128GCMSHA256, TLSECDHERSAWITHAES256CBCSHA, TLSECDHERSAWITHAES256CBCSHA384, TLSECDHERSAWITHAES256GCMSHA384, TLSRSAWITH3DESEDECBCSHA, TLSRSAWITHAES128CBCSHA, TLSRSAWITHAES128CBCSHA256, TLSRSAWITHAES128GCMSHA256, TLSRSAWITHAES256CBCSHA, TLSRSAWITHAES256CBCSHA256, TLSRSAWITHAES256GCMSHA384}
}

// ApplicationGatewaySslPolicyName enumerates the values for application gateway ssl policy name.
type ApplicationGatewaySslPolicyName string

const (
	// AppGwSslPolicy20150501 ...
	AppGwSslPolicy20150501 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20150501"
	// AppGwSslPolicy20170401 ...
	AppGwSslPolicy20170401 ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401"
	// AppGwSslPolicy20170401S ...
	AppGwSslPolicy20170401S ApplicationGatewaySslPolicyName = "AppGwSslPolicy20170401S"
)

// PossibleApplicationGatewaySslPolicyNameValues returns an array of possible values for the ApplicationGatewaySslPolicyName const type.
func PossibleApplicationGatewaySslPolicyNameValues() []ApplicationGatewaySslPolicyName {
	return []ApplicationGatewaySslPolicyName{AppGwSslPolicy20150501, AppGwSslPolicy20170401, AppGwSslPolicy20170401S}
}

// ApplicationGatewaySslPolicyType enumerates the values for application gateway ssl policy type.
type ApplicationGatewaySslPolicyType string

const (
	// Custom ...
	Custom ApplicationGatewaySslPolicyType = "Custom"
	// Predefined ...
	Predefined ApplicationGatewaySslPolicyType = "Predefined"
)

// PossibleApplicationGatewaySslPolicyTypeValues returns an array of possible values for the ApplicationGatewaySslPolicyType const type.
func PossibleApplicationGatewaySslPolicyTypeValues() []ApplicationGatewaySslPolicyType {
	return []ApplicationGatewaySslPolicyType{Custom, Predefined}
}

// ApplicationGatewaySslProtocol enumerates the values for application gateway ssl protocol.
type ApplicationGatewaySslProtocol string

const (
	// TLSv10 ...
	TLSv10 ApplicationGatewaySslProtocol = "TLSv1_0"
	// TLSv11 ...
	TLSv11 ApplicationGatewaySslProtocol = "TLSv1_1"
	// TLSv12 ...
	TLSv12 ApplicationGatewaySslProtocol = "TLSv1_2"
)

// PossibleApplicationGatewaySslProtocolValues returns an array of possible values for the ApplicationGatewaySslProtocol const type.
func PossibleApplicationGatewaySslProtocolValues() []ApplicationGatewaySslProtocol {
	return []ApplicationGatewaySslProtocol{TLSv10, TLSv11, TLSv12}
}

// ApplicationGatewayTier enumerates the values for application gateway tier.
type ApplicationGatewayTier string

const (
	// ApplicationGatewayTierStandard ...
	ApplicationGatewayTierStandard ApplicationGatewayTier = "Standard"
	// ApplicationGatewayTierStandardV2 ...
	ApplicationGatewayTierStandardV2 ApplicationGatewayTier = "Standard_v2"
	// ApplicationGatewayTierWAF ...
	ApplicationGatewayTierWAF ApplicationGatewayTier = "WAF"
	// ApplicationGatewayTierWAFV2 ...
	ApplicationGatewayTierWAFV2 ApplicationGatewayTier = "WAF_v2"
)

// PossibleApplicationGatewayTierValues returns an array of possible values for the ApplicationGatewayTier const type.
func PossibleApplicationGatewayTierValues() []ApplicationGatewayTier {
	return []ApplicationGatewayTier{ApplicationGatewayTierStandard, ApplicationGatewayTierStandardV2, ApplicationGatewayTierWAF, ApplicationGatewayTierWAFV2}
}

// AssociationType enumerates the values for association type.
type AssociationType string

const (
	// Associated ...
	Associated AssociationType = "Associated"
	// Contains ...
	Contains AssociationType = "Contains"
)

// PossibleAssociationTypeValues returns an array of possible values for the AssociationType const type.
func PossibleAssociationTypeValues() []AssociationType {
	return []AssociationType{Associated, Contains}
}

// AuthenticationMethod enumerates the values for authentication method.
type AuthenticationMethod string

const (
	// EAPMSCHAPv2 ...
	EAPMSCHAPv2 AuthenticationMethod = "EAPMSCHAPv2"
	// EAPTLS ...
	EAPTLS AuthenticationMethod = "EAPTLS"
)

// PossibleAuthenticationMethodValues returns an array of possible values for the AuthenticationMethod const type.
func PossibleAuthenticationMethodValues() []AuthenticationMethod {
	return []AuthenticationMethod{EAPMSCHAPv2, EAPTLS}
}

// AuthorizationUseStatus enumerates the values for authorization use status.
type AuthorizationUseStatus string

const (
	// Available ...
	Available AuthorizationUseStatus = "Available"
	// InUse ...
	InUse AuthorizationUseStatus = "InUse"
)

// PossibleAuthorizationUseStatusValues returns an array of possible values for the AuthorizationUseStatus const type.
func PossibleAuthorizationUseStatusValues() []AuthorizationUseStatus {
	return []AuthorizationUseStatus{Available, InUse}
}

// AzureFirewallApplicationRuleProtocolType enumerates the values for azure firewall application rule protocol
// type.
type AzureFirewallApplicationRuleProtocolType string

const (
	// AzureFirewallApplicationRuleProtocolTypeHTTP ...
	AzureFirewallApplicationRuleProtocolTypeHTTP AzureFirewallApplicationRuleProtocolType = "Http"
	// AzureFirewallApplicationRuleProtocolTypeHTTPS ...
	AzureFirewallApplicationRuleProtocolTypeHTTPS AzureFirewallApplicationRuleProtocolType = "Https"
	// AzureFirewallApplicationRuleProtocolTypeMssql ...
	AzureFirewallApplicationRuleProtocolTypeMssql AzureFirewallApplicationRuleProtocolType = "Mssql"
)

// PossibleAzureFirewallApplicationRuleProtocolTypeValues returns an array of possible values for the AzureFirewallApplicationRuleProtocolType const type.
func PossibleAzureFirewallApplicationRuleProtocolTypeValues() []AzureFirewallApplicationRuleProtocolType {
	return []AzureFirewallApplicationRuleProtocolType{AzureFirewallApplicationRuleProtocolTypeHTTP, AzureFirewallApplicationRuleProtocolTypeHTTPS, AzureFirewallApplicationRuleProtocolTypeMssql}
}

// AzureFirewallNatRCActionType enumerates the values for azure firewall nat rc action type.
type AzureFirewallNatRCActionType string

const (
	// Dnat ...
	Dnat AzureFirewallNatRCActionType = "Dnat"
	// Snat ...
	Snat AzureFirewallNatRCActionType = "Snat"
)

// PossibleAzureFirewallNatRCActionTypeValues returns an array of possible values for the AzureFirewallNatRCActionType const type.
func PossibleAzureFirewallNatRCActionTypeValues() []AzureFirewallNatRCActionType {
	return []AzureFirewallNatRCActionType{Dnat, Snat}
}

// AzureFirewallNetworkRuleProtocol enumerates the values for azure firewall network rule protocol.
type AzureFirewallNetworkRuleProtocol string

const (
	// Any ...
	Any AzureFirewallNetworkRuleProtocol = "Any"
	// ICMP ...
	ICMP AzureFirewallNetworkRuleProtocol = "ICMP"
	// TCP ...
	TCP AzureFirewallNetworkRuleProtocol = "TCP"
	// UDP ...
	UDP AzureFirewallNetworkRuleProtocol = "UDP"
)

// PossibleAzureFirewallNetworkRuleProtocolValues returns an array of possible values for the AzureFirewallNetworkRuleProtocol const type.
func PossibleAzureFirewallNetworkRuleProtocolValues() []AzureFirewallNetworkRuleProtocol {
	return []AzureFirewallNetworkRuleProtocol{Any, ICMP, TCP, UDP}
}

// AzureFirewallRCActionType enumerates the values for azure firewall rc action type.
type AzureFirewallRCActionType string

const (
	// AzureFirewallRCActionTypeAllow ...
	AzureFirewallRCActionTypeAllow AzureFirewallRCActionType = "Allow"
	// AzureFirewallRCActionTypeDeny ...
	AzureFirewallRCActionTypeDeny AzureFirewallRCActionType = "Deny"
)

// PossibleAzureFirewallRCActionTypeValues returns an array of possible values for the AzureFirewallRCActionType const type.
func PossibleAzureFirewallRCActionTypeValues() []AzureFirewallRCActionType {
	return []AzureFirewallRCActionType{AzureFirewallRCActionTypeAllow, AzureFirewallRCActionTypeDeny}
}

// AzureFirewallThreatIntelMode enumerates the values for azure firewall threat intel mode.
type AzureFirewallThreatIntelMode string

const (
	// AzureFirewallThreatIntelModeAlert ...
	AzureFirewallThreatIntelModeAlert AzureFirewallThreatIntelMode = "Alert"
	// AzureFirewallThreatIntelModeDeny ...
	AzureFirewallThreatIntelModeDeny AzureFirewallThreatIntelMode = "Deny"
	// AzureFirewallThreatIntelModeOff ...
	AzureFirewallThreatIntelModeOff AzureFirewallThreatIntelMode = "Off"
)

// PossibleAzureFirewallThreatIntelModeValues returns an array of possible values for the AzureFirewallThreatIntelMode const type.
func PossibleAzureFirewallThreatIntelModeValues() []AzureFirewallThreatIntelMode {
	return []AzureFirewallThreatIntelMode{AzureFirewallThreatIntelModeAlert, AzureFirewallThreatIntelModeDeny, AzureFirewallThreatIntelModeOff}
}

// BgpPeerState enumerates the values for bgp peer state.
type BgpPeerState string

const (
	// BgpPeerStateConnected ...
	BgpPeerStateConnected BgpPeerState = "Connected"
	// BgpPeerStateConnecting ...
	BgpPeerStateConnecting BgpPeerState = "Connecting"
	// BgpPeerStateIdle ...
	BgpPeerStateIdle BgpPeerState = "Idle"
	// BgpPeerStateStopped ...
	BgpPeerStateStopped BgpPeerState = "Stopped"
	// BgpPeerStateUnknown ...
	BgpPeerStateUnknown BgpPeerState = "Unknown"
)

// PossibleBgpPeerStateValues returns an array of possible values for the BgpPeerState const type.
func PossibleBgpPeerStateValues() []BgpPeerState {
	return []BgpPeerState{BgpPeerStateConnected, BgpPeerStateConnecting, BgpPeerStateIdle, BgpPeerStateStopped, BgpPeerStateUnknown}
}

// CircuitConnectionStatus enumerates the values for circuit connection status.
type CircuitConnectionStatus string

const (
	// Connected ...
	Connected CircuitConnectionStatus = "Connected"
	// Connecting ...
	Connecting CircuitConnectionStatus = "Connecting"
	// Disconnected ...
	Disconnected CircuitConnectionStatus = "Disconnected"
)

// PossibleCircuitConnectionStatusValues returns an array of possible values for the CircuitConnectionStatus const type.
func PossibleCircuitConnectionStatusValues() []CircuitConnectionStatus {
	return []CircuitConnectionStatus{Connected, Connecting, Disconnected}
}

// ConnectionMonitorSourceStatus enumerates the values for connection monitor source status.
type ConnectionMonitorSourceStatus string

const (
	// ConnectionMonitorSourceStatusActive ...
	ConnectionMonitorSourceStatusActive ConnectionMonitorSourceStatus = "Active"
	// ConnectionMonitorSourceStatusInactive ...
	ConnectionMonitorSourceStatusInactive ConnectionMonitorSourceStatus = "Inactive"
	// ConnectionMonitorSourceStatusUnknown ...
	ConnectionMonitorSourceStatusUnknown ConnectionMonitorSourceStatus = "Unknown"
)

// PossibleConnectionMonitorSourceStatusValues returns an array of possible values for the ConnectionMonitorSourceStatus const type.
func PossibleConnectionMonitorSourceStatusValues() []ConnectionMonitorSourceStatus {
	return []ConnectionMonitorSourceStatus{ConnectionMonitorSourceStatusActive, ConnectionMonitorSourceStatusInactive, ConnectionMonitorSourceStatusUnknown}
}

// ConnectionState enumerates the values for connection state.
type ConnectionState string

const (
	// ConnectionStateReachable ...
	ConnectionStateReachable ConnectionState = "Reachable"
	// ConnectionStateUnknown ...
	ConnectionStateUnknown ConnectionState = "Unknown"
	// ConnectionStateUnreachable ...
	ConnectionStateUnreachable ConnectionState = "Unreachable"
)

// PossibleConnectionStateValues returns an array of possible values for the ConnectionState const type.
func PossibleConnectionStateValues() []ConnectionState {
	return []ConnectionState{ConnectionStateReachable, ConnectionStateUnknown, ConnectionStateUnreachable}
}

// ConnectionStatus enumerates the values for connection status.
type ConnectionStatus string

const (
	// ConnectionStatusConnected ...
	ConnectionStatusConnected ConnectionStatus = "Connected"
	// ConnectionStatusDegraded ...
	ConnectionStatusDegraded ConnectionStatus = "Degraded"
	// ConnectionStatusDisconnected ...
	ConnectionStatusDisconnected ConnectionStatus = "Disconnected"
	// ConnectionStatusUnknown ...
	ConnectionStatusUnknown ConnectionStatus = "Unknown"
)

// PossibleConnectionStatusValues returns an array of possible values for the ConnectionStatus const type.
func PossibleConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{ConnectionStatusConnected, ConnectionStatusDegraded, ConnectionStatusDisconnected, ConnectionStatusUnknown}
}

// DdosCustomPolicyProtocol enumerates the values for ddos custom policy protocol.
type DdosCustomPolicyProtocol string

const (
	// DdosCustomPolicyProtocolSyn ...
	DdosCustomPolicyProtocolSyn DdosCustomPolicyProtocol = "Syn"
	// DdosCustomPolicyProtocolTCP ...
	DdosCustomPolicyProtocolTCP DdosCustomPolicyProtocol = "Tcp"
	// DdosCustomPolicyProtocolUDP ...
	DdosCustomPolicyProtocolUDP DdosCustomPolicyProtocol = "Udp"
)

// PossibleDdosCustomPolicyProtocolValues returns an array of possible values for the DdosCustomPolicyProtocol const type.
func PossibleDdosCustomPolicyProtocolValues() []DdosCustomPolicyProtocol {
	return []DdosCustomPolicyProtocol{DdosCustomPolicyProtocolSyn, DdosCustomPolicyProtocolTCP, DdosCustomPolicyProtocolUDP}
}

// DdosCustomPolicyTriggerSensitivityOverride enumerates the values for ddos custom policy trigger sensitivity
// override.
type DdosCustomPolicyTriggerSensitivityOverride string

const (
	// Default ...
	Default DdosCustomPolicyTriggerSensitivityOverride = "Default"
	// High ...
	High DdosCustomPolicyTriggerSensitivityOverride = "High"
	// Low ...
	Low DdosCustomPolicyTriggerSensitivityOverride = "Low"
	// Relaxed ...
	Relaxed DdosCustomPolicyTriggerSensitivityOverride = "Relaxed"
)

// PossibleDdosCustomPolicyTriggerSensitivityOverrideValues returns an array of possible values for the DdosCustomPolicyTriggerSensitivityOverride const type.
func PossibleDdosCustomPolicyTriggerSensitivityOverrideValues() []DdosCustomPolicyTriggerSensitivityOverride {
	return []DdosCustomPolicyTriggerSensitivityOverride{Default, High, Low, Relaxed}
}

// DdosSettingsProtectionCoverage enumerates the values for ddos settings protection coverage.
type DdosSettingsProtectionCoverage string

const (
	// DdosSettingsProtectionCoverageBasic ...
	DdosSettingsProtectionCoverageBasic DdosSettingsProtectionCoverage = "Basic"
	// DdosSettingsProtectionCoverageStandard ...
	DdosSettingsProtectionCoverageStandard DdosSettingsProtectionCoverage = "Standard"
)

// PossibleDdosSettingsProtectionCoverageValues returns an array of possible values for the DdosSettingsProtectionCoverage const type.
func PossibleDdosSettingsProtectionCoverageValues() []DdosSettingsProtectionCoverage {
	return []DdosSettingsProtectionCoverage{DdosSettingsProtectionCoverageBasic, DdosSettingsProtectionCoverageStandard}
}

// DhGroup enumerates the values for dh group.
type DhGroup string

const (
	// DHGroup1 ...
	DHGroup1 DhGroup = "DHGroup1"
	// DHGroup14 ...
	DHGroup14 DhGroup = "DHGroup14"
	// DHGroup2 ...
	DHGroup2 DhGroup = "DHGroup2"
	// DHGroup2048 ...
	DHGroup2048 DhGroup = "DHGroup2048"
	// DHGroup24 ...
	DHGroup24 DhGroup = "DHGroup24"
	// ECP256 ...
	ECP256 DhGroup = "ECP256"
	// ECP384 ...
	ECP384 DhGroup = "ECP384"
	// None ...
	None DhGroup = "None"
)

// PossibleDhGroupValues returns an array of possible values for the DhGroup const type.
func PossibleDhGroupValues() []DhGroup {
	return []DhGroup{DHGroup1, DHGroup14, DHGroup2, DHGroup2048, DHGroup24, ECP256, ECP384, None}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Inbound ...
	Inbound Direction = "Inbound"
	// Outbound ...
	Outbound Direction = "Outbound"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Inbound, Outbound}
}

// EffectiveRouteSource enumerates the values for effective route source.
type EffectiveRouteSource string

const (
	// EffectiveRouteSourceDefault ...
	EffectiveRouteSourceDefault EffectiveRouteSource = "Default"
	// EffectiveRouteSourceUnknown ...
	EffectiveRouteSourceUnknown EffectiveRouteSource = "Unknown"
	// EffectiveRouteSourceUser ...
	EffectiveRouteSourceUser EffectiveRouteSource = "User"
	// EffectiveRouteSourceVirtualNetworkGateway ...
	EffectiveRouteSourceVirtualNetworkGateway EffectiveRouteSource = "VirtualNetworkGateway"
)

// PossibleEffectiveRouteSourceValues returns an array of possible values for the EffectiveRouteSource const type.
func PossibleEffectiveRouteSourceValues() []EffectiveRouteSource {
	return []EffectiveRouteSource{EffectiveRouteSourceDefault, EffectiveRouteSourceUnknown, EffectiveRouteSourceUser, EffectiveRouteSourceVirtualNetworkGateway}
}

// EffectiveRouteState enumerates the values for effective route state.
type EffectiveRouteState string

const (
	// Active ...
	Active EffectiveRouteState = "Active"
	// Invalid ...
	Invalid EffectiveRouteState = "Invalid"
)

// PossibleEffectiveRouteStateValues returns an array of possible values for the EffectiveRouteState const type.
func PossibleEffectiveRouteStateValues() []EffectiveRouteState {
	return []EffectiveRouteState{Active, Invalid}
}

// EffectiveSecurityRuleProtocol enumerates the values for effective security rule protocol.
type EffectiveSecurityRuleProtocol string

const (
	// EffectiveSecurityRuleProtocolAll ...
	EffectiveSecurityRuleProtocolAll EffectiveSecurityRuleProtocol = "All"
	// EffectiveSecurityRuleProtocolTCP ...
	EffectiveSecurityRuleProtocolTCP EffectiveSecurityRuleProtocol = "Tcp"
	// EffectiveSecurityRuleProtocolUDP ...
	EffectiveSecurityRuleProtocolUDP EffectiveSecurityRuleProtocol = "Udp"
)

// PossibleEffectiveSecurityRuleProtocolValues returns an array of possible values for the EffectiveSecurityRuleProtocol const type.
func PossibleEffectiveSecurityRuleProtocolValues() []EffectiveSecurityRuleProtocol {
	return []EffectiveSecurityRuleProtocol{EffectiveSecurityRuleProtocolAll, EffectiveSecurityRuleProtocolTCP, EffectiveSecurityRuleProtocolUDP}
}

// EvaluationState enumerates the values for evaluation state.
type EvaluationState string

const (
	// Completed ...
	Completed EvaluationState = "Completed"
	// InProgress ...
	InProgress EvaluationState = "InProgress"
	// NotStarted ...
	NotStarted EvaluationState = "NotStarted"
)

// PossibleEvaluationStateValues returns an array of possible values for the EvaluationState const type.
func PossibleEvaluationStateValues() []EvaluationState {
	return []EvaluationState{Completed, InProgress, NotStarted}
}

// ExpressRouteCircuitPeeringAdvertisedPublicPrefixState enumerates the values for express route circuit
// peering advertised public prefix state.
type ExpressRouteCircuitPeeringAdvertisedPublicPrefixState string

const (
	// Configured ...
	Configured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configured"
	// Configuring ...
	Configuring ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "Configuring"
	// NotConfigured ...
	NotConfigured ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "NotConfigured"
	// ValidationNeeded ...
	ValidationNeeded ExpressRouteCircuitPeeringAdvertisedPublicPrefixState = "ValidationNeeded"
)

// PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues returns an array of possible values for the ExpressRouteCircuitPeeringAdvertisedPublicPrefixState const type.
func PossibleExpressRouteCircuitPeeringAdvertisedPublicPrefixStateValues() []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState {
	return []ExpressRouteCircuitPeeringAdvertisedPublicPrefixState{Configured, Configuring, NotConfigured, ValidationNeeded}
}

// ExpressRouteCircuitPeeringState enumerates the values for express route circuit peering state.
type ExpressRouteCircuitPeeringState string

const (
	// ExpressRouteCircuitPeeringStateDisabled ...
	ExpressRouteCircuitPeeringStateDisabled ExpressRouteCircuitPeeringState = "Disabled"
	// ExpressRouteCircuitPeeringStateEnabled ...
	ExpressRouteCircuitPeeringStateEnabled ExpressRouteCircuitPeeringState = "Enabled"
)

// PossibleExpressRouteCircuitPeeringStateValues returns an array of possible values for the ExpressRouteCircuitPeeringState const type.
func PossibleExpressRouteCircuitPeeringStateValues() []ExpressRouteCircuitPeeringState {
	return []ExpressRouteCircuitPeeringState{ExpressRouteCircuitPeeringStateDisabled, ExpressRouteCircuitPeeringStateEnabled}
}

// ExpressRouteCircuitSkuFamily enumerates the values for express route circuit sku family.
type ExpressRouteCircuitSkuFamily string

const (
	// MeteredData ...
	MeteredData ExpressRouteCircuitSkuFamily = "MeteredData"
	// UnlimitedData ...
	UnlimitedData ExpressRouteCircuitSkuFamily = "UnlimitedData"
)

// PossibleExpressRouteCircuitSkuFamilyValues returns an array of possible values for the ExpressRouteCircuitSkuFamily const type.
func PossibleExpressRouteCircuitSkuFamilyValues() []ExpressRouteCircuitSkuFamily {
	return []ExpressRouteCircuitSkuFamily{MeteredData, UnlimitedData}
}

// ExpressRouteCircuitSkuTier enumerates the values for express route circuit sku tier.
type ExpressRouteCircuitSkuTier string

const (
	// ExpressRouteCircuitSkuTierBasic ...
	ExpressRouteCircuitSkuTierBasic ExpressRouteCircuitSkuTier = "Basic"
	// ExpressRouteCircuitSkuTierLocal ...
	ExpressRouteCircuitSkuTierLocal ExpressRouteCircuitSkuTier = "Local"
	// ExpressRouteCircuitSkuTierPremium ...
	ExpressRouteCircuitSkuTierPremium ExpressRouteCircuitSkuTier = "Premium"
	// ExpressRouteCircuitSkuTierStandard ...
	ExpressRouteCircuitSkuTierStandard ExpressRouteCircuitSkuTier = "Standard"
)

// PossibleExpressRouteCircuitSkuTierValues returns an array of possible values for the ExpressRouteCircuitSkuTier const type.
func PossibleExpressRouteCircuitSkuTierValues() []ExpressRouteCircuitSkuTier {
	return []ExpressRouteCircuitSkuTier{ExpressRouteCircuitSkuTierBasic, ExpressRouteCircuitSkuTierLocal, ExpressRouteCircuitSkuTierPremium, ExpressRouteCircuitSkuTierStandard}
}

// ExpressRouteLinkAdminState enumerates the values for express route link admin state.
type ExpressRouteLinkAdminState string

const (
	// ExpressRouteLinkAdminStateDisabled ...
	ExpressRouteLinkAdminStateDisabled ExpressRouteLinkAdminState = "Disabled"
	// ExpressRouteLinkAdminStateEnabled ...
	ExpressRouteLinkAdminStateEnabled ExpressRouteLinkAdminState = "Enabled"
)

// PossibleExpressRouteLinkAdminStateValues returns an array of possible values for the ExpressRouteLinkAdminState const type.
func PossibleExpressRouteLinkAdminStateValues() []ExpressRouteLinkAdminState {
	return []ExpressRouteLinkAdminState{ExpressRouteLinkAdminStateDisabled, ExpressRouteLinkAdminStateEnabled}
}

// ExpressRouteLinkConnectorType enumerates the values for express route link connector type.
type ExpressRouteLinkConnectorType string

const (
	// LC ...
	LC ExpressRouteLinkConnectorType = "LC"
	// SC ...
	SC ExpressRouteLinkConnectorType = "SC"
)

// PossibleExpressRouteLinkConnectorTypeValues returns an array of possible values for the ExpressRouteLinkConnectorType const type.
func PossibleExpressRouteLinkConnectorTypeValues() []ExpressRouteLinkConnectorType {
	return []ExpressRouteLinkConnectorType{LC, SC}
}

// ExpressRouteLinkMacSecCipher enumerates the values for express route link mac sec cipher.
type ExpressRouteLinkMacSecCipher string

const (
	// GcmAes128 ...
	GcmAes128 ExpressRouteLinkMacSecCipher = "gcm-aes-128"
	// GcmAes256 ...
	GcmAes256 ExpressRouteLinkMacSecCipher = "gcm-aes-256"
)

// PossibleExpressRouteLinkMacSecCipherValues returns an array of possible values for the ExpressRouteLinkMacSecCipher const type.
func PossibleExpressRouteLinkMacSecCipherValues() []ExpressRouteLinkMacSecCipher {
	return []ExpressRouteLinkMacSecCipher{GcmAes128, GcmAes256}
}

// ExpressRoutePeeringState enumerates the values for express route peering state.
type ExpressRoutePeeringState string

const (
	// ExpressRoutePeeringStateDisabled ...
	ExpressRoutePeeringStateDisabled ExpressRoutePeeringState = "Disabled"
	// ExpressRoutePeeringStateEnabled ...
	ExpressRoutePeeringStateEnabled ExpressRoutePeeringState = "Enabled"
)

// PossibleExpressRoutePeeringStateValues returns an array of possible values for the ExpressRoutePeeringState const type.
func PossibleExpressRoutePeeringStateValues() []ExpressRoutePeeringState {
	return []ExpressRoutePeeringState{ExpressRoutePeeringStateDisabled, ExpressRoutePeeringStateEnabled}
}

// ExpressRoutePeeringType enumerates the values for express route peering type.
type ExpressRoutePeeringType string

const (
	// AzurePrivatePeering ...
	AzurePrivatePeering ExpressRoutePeeringType = "AzurePrivatePeering"
	// AzurePublicPeering ...
	AzurePublicPeering ExpressRoutePeeringType = "AzurePublicPeering"
	// MicrosoftPeering ...
	MicrosoftPeering ExpressRoutePeeringType = "MicrosoftPeering"
)

// PossibleExpressRoutePeeringTypeValues returns an array of possible values for the ExpressRoutePeeringType const type.
func PossibleExpressRoutePeeringTypeValues() []ExpressRoutePeeringType {
	return []ExpressRoutePeeringType{AzurePrivatePeering, AzurePublicPeering, MicrosoftPeering}
}

// ExpressRoutePortsEncapsulation enumerates the values for express route ports encapsulation.
type ExpressRoutePortsEncapsulation string

const (
	// Dot1Q ...
	Dot1Q ExpressRoutePortsEncapsulation = "Dot1Q"
	// QinQ ...
	QinQ ExpressRoutePortsEncapsulation = "QinQ"
)

// PossibleExpressRoutePortsEncapsulationValues returns an array of possible values for the ExpressRoutePortsEncapsulation const type.
func PossibleExpressRoutePortsEncapsulationValues() []ExpressRoutePortsEncapsulation {
	return []ExpressRoutePortsEncapsulation{Dot1Q, QinQ}
}

// FirewallPolicyFilterRuleActionType enumerates the values for firewall policy filter rule action type.
type FirewallPolicyFilterRuleActionType string

const (
	// FirewallPolicyFilterRuleActionTypeAlert ...
	FirewallPolicyFilterRuleActionTypeAlert FirewallPolicyFilterRuleActionType = "Alert "
	// FirewallPolicyFilterRuleActionTypeAllow ...
	FirewallPolicyFilterRuleActionTypeAllow FirewallPolicyFilterRuleActionType = "Allow"
	// FirewallPolicyFilterRuleActionTypeDeny ...
	FirewallPolicyFilterRuleActionTypeDeny FirewallPolicyFilterRuleActionType = "Deny"
)

// PossibleFirewallPolicyFilterRuleActionTypeValues returns an array of possible values for the FirewallPolicyFilterRuleActionType const type.
func PossibleFirewallPolicyFilterRuleActionTypeValues() []FirewallPolicyFilterRuleActionType {
	return []FirewallPolicyFilterRuleActionType{FirewallPolicyFilterRuleActionTypeAlert, FirewallPolicyFilterRuleActionTypeAllow, FirewallPolicyFilterRuleActionTypeDeny}
}

// FirewallPolicyNatRuleActionType enumerates the values for firewall policy nat rule action type.
type FirewallPolicyNatRuleActionType string

const (
	// DNAT ...
	DNAT FirewallPolicyNatRuleActionType = "DNAT"
	// SNAT ...
	SNAT FirewallPolicyNatRuleActionType = "SNAT"
)

// PossibleFirewallPolicyNatRuleActionTypeValues returns an array of possible values for the FirewallPolicyNatRuleActionType const type.
func PossibleFirewallPolicyNatRuleActionTypeValues() []FirewallPolicyNatRuleActionType {
	return []FirewallPolicyNatRuleActionType{DNAT, SNAT}
}

// FirewallPolicyRuleConditionApplicationProtocolType enumerates the values for firewall policy rule condition
// application protocol type.
type FirewallPolicyRuleConditionApplicationProtocolType string

const (
	// FirewallPolicyRuleConditionApplicationProtocolTypeHTTP ...
	FirewallPolicyRuleConditionApplicationProtocolTypeHTTP FirewallPolicyRuleConditionApplicationProtocolType = "Http"
	// FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS ...
	FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS FirewallPolicyRuleConditionApplicationProtocolType = "Https"
)

// PossibleFirewallPolicyRuleConditionApplicationProtocolTypeValues returns an array of possible values for the FirewallPolicyRuleConditionApplicationProtocolType const type.
func PossibleFirewallPolicyRuleConditionApplicationProtocolTypeValues() []FirewallPolicyRuleConditionApplicationProtocolType {
	return []FirewallPolicyRuleConditionApplicationProtocolType{FirewallPolicyRuleConditionApplicationProtocolTypeHTTP, FirewallPolicyRuleConditionApplicationProtocolTypeHTTPS}
}

// FirewallPolicyRuleConditionNetworkProtocol enumerates the values for firewall policy rule condition network
// protocol.
type FirewallPolicyRuleConditionNetworkProtocol string

const (
	// FirewallPolicyRuleConditionNetworkProtocolAny ...
	FirewallPolicyRuleConditionNetworkProtocolAny FirewallPolicyRuleConditionNetworkProtocol = "Any"
	// FirewallPolicyRuleConditionNetworkProtocolICMP ...
	FirewallPolicyRuleConditionNetworkProtocolICMP FirewallPolicyRuleConditionNetworkProtocol = "ICMP"
	// FirewallPolicyRuleConditionNetworkProtocolTCP ...
	FirewallPolicyRuleConditionNetworkProtocolTCP FirewallPolicyRuleConditionNetworkProtocol = "TCP"
	// FirewallPolicyRuleConditionNetworkProtocolUDP ...
	FirewallPolicyRuleConditionNetworkProtocolUDP FirewallPolicyRuleConditionNetworkProtocol = "UDP"
)

// PossibleFirewallPolicyRuleConditionNetworkProtocolValues returns an array of possible values for the FirewallPolicyRuleConditionNetworkProtocol const type.
func PossibleFirewallPolicyRuleConditionNetworkProtocolValues() []FirewallPolicyRuleConditionNetworkProtocol {
	return []FirewallPolicyRuleConditionNetworkProtocol{FirewallPolicyRuleConditionNetworkProtocolAny, FirewallPolicyRuleConditionNetworkProtocolICMP, FirewallPolicyRuleConditionNetworkProtocolTCP, FirewallPolicyRuleConditionNetworkProtocolUDP}
}

// FlowLogFormatType enumerates the values for flow log format type.
type FlowLogFormatType string

const (
	// JSON ...
	JSON FlowLogFormatType = "JSON"
)

// PossibleFlowLogFormatTypeValues returns an array of possible values for the FlowLogFormatType const type.
func PossibleFlowLogFormatTypeValues() []FlowLogFormatType {
	return []FlowLogFormatType{JSON}
}

// HTTPMethod enumerates the values for http method.
type HTTPMethod string

const (
	// Get ...
	Get HTTPMethod = "Get"
)

// PossibleHTTPMethodValues returns an array of possible values for the HTTPMethod const type.
func PossibleHTTPMethodValues() []HTTPMethod {
	return []HTTPMethod{Get}
}

// HubVirtualNetworkConnectionStatus enumerates the values for hub virtual network connection status.
type HubVirtualNetworkConnectionStatus string

const (
	// HubVirtualNetworkConnectionStatusConnected ...
	HubVirtualNetworkConnectionStatusConnected HubVirtualNetworkConnectionStatus = "Connected"
	// HubVirtualNetworkConnectionStatusConnecting ...
	HubVirtualNetworkConnectionStatusConnecting HubVirtualNetworkConnectionStatus = "Connecting"
	// HubVirtualNetworkConnectionStatusNotConnected ...
	HubVirtualNetworkConnectionStatusNotConnected HubVirtualNetworkConnectionStatus = "NotConnected"
	// HubVirtualNetworkConnectionStatusUnknown ...
	HubVirtualNetworkConnectionStatusUnknown HubVirtualNetworkConnectionStatus = "Unknown"
)

// PossibleHubVirtualNetworkConnectionStatusValues returns an array of possible values for the HubVirtualNetworkConnectionStatus const type.
func PossibleHubVirtualNetworkConnectionStatusValues() []HubVirtualNetworkConnectionStatus {
	return []HubVirtualNetworkConnectionStatus{HubVirtualNetworkConnectionStatusConnected, HubVirtualNetworkConnectionStatusConnecting, HubVirtualNetworkConnectionStatusNotConnected, HubVirtualNetworkConnectionStatusUnknown}
}

// IkeEncryption enumerates the values for ike encryption.
type IkeEncryption string

const (
	// AES128 ...
	AES128 IkeEncryption = "AES128"
	// AES192 ...
	AES192 IkeEncryption = "AES192"
	// AES256 ...
	AES256 IkeEncryption = "AES256"
	// DES ...
	DES IkeEncryption = "DES"
	// DES3 ...
	DES3 IkeEncryption = "DES3"
	// GCMAES128 ...
	GCMAES128 IkeEncryption = "GCMAES128"
	// GCMAES256 ...
	GCMAES256 IkeEncryption = "GCMAES256"
)

// PossibleIkeEncryptionValues returns an array of possible values for the IkeEncryption const type.
func PossibleIkeEncryptionValues() []IkeEncryption {
	return []IkeEncryption{AES128, AES192, AES256, DES, DES3, GCMAES128, GCMAES256}
}

// IkeIntegrity enumerates the values for ike integrity.
type IkeIntegrity string

const (
	// IkeIntegrityGCMAES128 ...
	IkeIntegrityGCMAES128 IkeIntegrity = "GCMAES128"
	// IkeIntegrityGCMAES256 ...
	IkeIntegrityGCMAES256 IkeIntegrity = "GCMAES256"
	// IkeIntegrityMD5 ...
	IkeIntegrityMD5 IkeIntegrity = "MD5"
	// IkeIntegritySHA1 ...
	IkeIntegritySHA1 IkeIntegrity = "SHA1"
	// IkeIntegritySHA256 ...
	IkeIntegritySHA256 IkeIntegrity = "SHA256"
	// IkeIntegritySHA384 ...
	IkeIntegritySHA384 IkeIntegrity = "SHA384"
)

// PossibleIkeIntegrityValues returns an array of possible values for the IkeIntegrity const type.
func PossibleIkeIntegrityValues() []IkeIntegrity {
	return []IkeIntegrity{IkeIntegrityGCMAES128, IkeIntegrityGCMAES256, IkeIntegrityMD5, IkeIntegritySHA1, IkeIntegritySHA256, IkeIntegritySHA384}
}

// IPAllocationMethod enumerates the values for ip allocation method.
type IPAllocationMethod string

const (
	// Dynamic ...
	Dynamic IPAllocationMethod = "Dynamic"
	// Static ...
	Static IPAllocationMethod = "Static"
)

// PossibleIPAllocationMethodValues returns an array of possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{Dynamic, Static}
}

// IPFlowProtocol enumerates the values for ip flow protocol.
type IPFlowProtocol string

const (
	// IPFlowProtocolTCP ...
	IPFlowProtocolTCP IPFlowProtocol = "TCP"
	// IPFlowProtocolUDP ...
	IPFlowProtocolUDP IPFlowProtocol = "UDP"
)

// PossibleIPFlowProtocolValues returns an array of possible values for the IPFlowProtocol const type.
func PossibleIPFlowProtocolValues() []IPFlowProtocol {
	return []IPFlowProtocol{IPFlowProtocolTCP, IPFlowProtocolUDP}
}

// IpsecEncryption enumerates the values for ipsec encryption.
type IpsecEncryption string

const (
	// IpsecEncryptionAES128 ...
	IpsecEncryptionAES128 IpsecEncryption = "AES128"
	// IpsecEncryptionAES192 ...
	IpsecEncryptionAES192 IpsecEncryption = "AES192"
	// IpsecEncryptionAES256 ...
	IpsecEncryptionAES256 IpsecEncryption = "AES256"
	// IpsecEncryptionDES ...
	IpsecEncryptionDES IpsecEncryption = "DES"
	// IpsecEncryptionDES3 ...
	IpsecEncryptionDES3 IpsecEncryption = "DES3"
	// IpsecEncryptionGCMAES128 ...
	IpsecEncryptionGCMAES128 IpsecEncryption = "GCMAES128"
	// IpsecEncryptionGCMAES192 ...
	IpsecEncryptionGCMAES192 IpsecEncryption = "GCMAES192"
	// IpsecEncryptionGCMAES256 ...
	IpsecEncryptionGCMAES256 IpsecEncryption = "GCMAES256"
	// IpsecEncryptionNone ...
	IpsecEncryptionNone IpsecEncryption = "None"
)

// PossibleIpsecEncryptionValues returns an array of possible values for the IpsecEncryption const type.
func PossibleIpsecEncryptionValues() []IpsecEncryption {
	return []IpsecEncryption{IpsecEncryptionAES128, IpsecEncryptionAES192, IpsecEncryptionAES256, IpsecEncryptionDES, IpsecEncryptionDES3, IpsecEncryptionGCMAES128, IpsecEncryptionGCMAES192, IpsecEncryptionGCMAES256, IpsecEncryptionNone}
}

// IpsecIntegrity enumerates the values for ipsec integrity.
type IpsecIntegrity string

const (
	// IpsecIntegrityGCMAES128 ...
	IpsecIntegrityGCMAES128 IpsecIntegrity = "GCMAES128"
	// IpsecIntegrityGCMAES192 ...
	IpsecIntegrityGCMAES192 IpsecIntegrity = "GCMAES192"
	// IpsecIntegrityGCMAES256 ...
	IpsecIntegrityGCMAES256 IpsecIntegrity = "GCMAES256"
	// IpsecIntegrityMD5 ...
	IpsecIntegrityMD5 IpsecIntegrity = "MD5"
	// IpsecIntegritySHA1 ...
	IpsecIntegritySHA1 IpsecIntegrity = "SHA1"
	// IpsecIntegritySHA256 ...
	IpsecIntegritySHA256 IpsecIntegrity = "SHA256"
)

// PossibleIpsecIntegrityValues returns an array of possible values for the IpsecIntegrity const type.
func PossibleIpsecIntegrityValues() []IpsecIntegrity {
	return []IpsecIntegrity{IpsecIntegrityGCMAES128, IpsecIntegrityGCMAES192, IpsecIntegrityGCMAES256, IpsecIntegrityMD5, IpsecIntegritySHA1, IpsecIntegritySHA256}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// IssueType enumerates the values for issue type.
type IssueType string

const (
	// IssueTypeAgentStopped ...
	IssueTypeAgentStopped IssueType = "AgentStopped"
	// IssueTypeDNSResolution ...
	IssueTypeDNSResolution IssueType = "DnsResolution"
	// IssueTypeGuestFirewall ...
	IssueTypeGuestFirewall IssueType = "GuestFirewall"
	// IssueTypeNetworkSecurityRule ...
	IssueTypeNetworkSecurityRule IssueType = "NetworkSecurityRule"
	// IssueTypePlatform ...
	IssueTypePlatform IssueType = "Platform"
	// IssueTypePortThrottled ...
	IssueTypePortThrottled IssueType = "PortThrottled"
	// IssueTypeSocketBind ...
	IssueTypeSocketBind IssueType = "SocketBind"
	// IssueTypeUnknown ...
	IssueTypeUnknown IssueType = "Unknown"
	// IssueTypeUserDefinedRoute ...
	IssueTypeUserDefinedRoute IssueType = "UserDefinedRoute"
)

// PossibleIssueTypeValues returns an array of possible values for the IssueType const type.
func PossibleIssueTypeValues() []IssueType {
	return []IssueType{IssueTypeAgentStopped, IssueTypeDNSResolution, IssueTypeGuestFirewall, IssueTypeNetworkSecurityRule, IssueTypePlatform, IssueTypePortThrottled, IssueTypeSocketBind, IssueTypeUnknown, IssueTypeUserDefinedRoute}
}

// LoadBalancerOutboundRuleProtocol enumerates the values for load balancer outbound rule protocol.
type LoadBalancerOutboundRuleProtocol string

const (
	// LoadBalancerOutboundRuleProtocolAll ...
	LoadBalancerOutboundRuleProtocolAll LoadBalancerOutboundRuleProtocol = "All"
	// LoadBalancerOutboundRuleProtocolTCP ...
	LoadBalancerOutboundRuleProtocolTCP LoadBalancerOutboundRuleProtocol = "Tcp"
	// LoadBalancerOutboundRuleProtocolUDP ...
	LoadBalancerOutboundRuleProtocolUDP LoadBalancerOutboundRuleProtocol = "Udp"
)

// PossibleLoadBalancerOutboundRuleProtocolValues returns an array of possible values for the LoadBalancerOutboundRuleProtocol const type.
func PossibleLoadBalancerOutboundRuleProtocolValues() []LoadBalancerOutboundRuleProtocol {
	return []LoadBalancerOutboundRuleProtocol{LoadBalancerOutboundRuleProtocolAll, LoadBalancerOutboundRuleProtocolTCP, LoadBalancerOutboundRuleProtocolUDP}
}

// LoadBalancerSkuName enumerates the values for load balancer sku name.
type LoadBalancerSkuName string

const (
	// LoadBalancerSkuNameBasic ...
	LoadBalancerSkuNameBasic LoadBalancerSkuName = "Basic"
	// LoadBalancerSkuNameStandard ...
	LoadBalancerSkuNameStandard LoadBalancerSkuName = "Standard"
)

// PossibleLoadBalancerSkuNameValues returns an array of possible values for the LoadBalancerSkuName const type.
func PossibleLoadBalancerSkuNameValues() []LoadBalancerSkuName {
	return []LoadBalancerSkuName{LoadBalancerSkuNameBasic, LoadBalancerSkuNameStandard}
}

// LoadDistribution enumerates the values for load distribution.
type LoadDistribution string

const (
	// LoadDistributionDefault ...
	LoadDistributionDefault LoadDistribution = "Default"
	// LoadDistributionSourceIP ...
	LoadDistributionSourceIP LoadDistribution = "SourceIP"
	// LoadDistributionSourceIPProtocol ...
	LoadDistributionSourceIPProtocol LoadDistribution = "SourceIPProtocol"
)

// PossibleLoadDistributionValues returns an array of possible values for the LoadDistribution const type.
func PossibleLoadDistributionValues() []LoadDistribution {
	return []LoadDistribution{LoadDistributionDefault, LoadDistributionSourceIP, LoadDistributionSourceIPProtocol}
}

// NatGatewaySkuName enumerates the values for nat gateway sku name.
type NatGatewaySkuName string

const (
	// Standard ...
	Standard NatGatewaySkuName = "Standard"
)

// PossibleNatGatewaySkuNameValues returns an array of possible values for the NatGatewaySkuName const type.
func PossibleNatGatewaySkuNameValues() []NatGatewaySkuName {
	return []NatGatewaySkuName{Standard}
}

// NextHopType enumerates the values for next hop type.
type NextHopType string

const (
	// NextHopTypeHyperNetGateway ...
	NextHopTypeHyperNetGateway NextHopType = "HyperNetGateway"
	// NextHopTypeInternet ...
	NextHopTypeInternet NextHopType = "Internet"
	// NextHopTypeNone ...
	NextHopTypeNone NextHopType = "None"
	// NextHopTypeVirtualAppliance ...
	NextHopTypeVirtualAppliance NextHopType = "VirtualAppliance"
	// NextHopTypeVirtualNetworkGateway ...
	NextHopTypeVirtualNetworkGateway NextHopType = "VirtualNetworkGateway"
	// NextHopTypeVnetLocal ...
	NextHopTypeVnetLocal NextHopType = "VnetLocal"
)

// PossibleNextHopTypeValues returns an array of possible values for the NextHopType const type.
func PossibleNextHopTypeValues() []NextHopType {
	return []NextHopType{NextHopTypeHyperNetGateway, NextHopTypeInternet, NextHopTypeNone, NextHopTypeVirtualAppliance, NextHopTypeVirtualNetworkGateway, NextHopTypeVnetLocal}
}

// OfficeTrafficCategory enumerates the values for office traffic category.
type OfficeTrafficCategory string

const (
	// OfficeTrafficCategoryAll ...
	OfficeTrafficCategoryAll OfficeTrafficCategory = "All"
	// OfficeTrafficCategoryNone ...
	OfficeTrafficCategoryNone OfficeTrafficCategory = "None"
	// OfficeTrafficCategoryOptimize ...
	OfficeTrafficCategoryOptimize OfficeTrafficCategory = "Optimize"
	// OfficeTrafficCategoryOptimizeAndAllow ...
	OfficeTrafficCategoryOptimizeAndAllow OfficeTrafficCategory = "OptimizeAndAllow"
)

// PossibleOfficeTrafficCategoryValues returns an array of possible values for the OfficeTrafficCategory const type.
func PossibleOfficeTrafficCategoryValues() []OfficeTrafficCategory {
	return []OfficeTrafficCategory{OfficeTrafficCategoryAll, OfficeTrafficCategoryNone, OfficeTrafficCategoryOptimize, OfficeTrafficCategoryOptimizeAndAllow}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusFailed ...
	OperationStatusFailed OperationStatus = "Failed"
	// OperationStatusInProgress ...
	OperationStatusInProgress OperationStatus = "InProgress"
	// OperationStatusSucceeded ...
	OperationStatusSucceeded OperationStatus = "Succeeded"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusFailed, OperationStatusInProgress, OperationStatusSucceeded}
}

// Origin enumerates the values for origin.
type Origin string

const (
	// OriginInbound ...
	OriginInbound Origin = "Inbound"
	// OriginLocal ...
	OriginLocal Origin = "Local"
	// OriginOutbound ...
	OriginOutbound Origin = "Outbound"
)

// PossibleOriginValues returns an array of possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{OriginInbound, OriginLocal, OriginOutbound}
}

// PcError enumerates the values for pc error.
type PcError string

const (
	// AgentStopped ...
	AgentStopped PcError = "AgentStopped"
	// CaptureFailed ...
	CaptureFailed PcError = "CaptureFailed"
	// InternalError ...
	InternalError PcError = "InternalError"
	// LocalFileFailed ...
	LocalFileFailed PcError = "LocalFileFailed"
	// StorageFailed ...
	StorageFailed PcError = "StorageFailed"
)

// PossiblePcErrorValues returns an array of possible values for the PcError const type.
func PossiblePcErrorValues() []PcError {
	return []PcError{AgentStopped, CaptureFailed, InternalError, LocalFileFailed, StorageFailed}
}

// PcProtocol enumerates the values for pc protocol.
type PcProtocol string

const (
	// PcProtocolAny ...
	PcProtocolAny PcProtocol = "Any"
	// PcProtocolTCP ...
	PcProtocolTCP PcProtocol = "TCP"
	// PcProtocolUDP ...
	PcProtocolUDP PcProtocol = "UDP"
)

// PossiblePcProtocolValues returns an array of possible values for the PcProtocol const type.
func PossiblePcProtocolValues() []PcProtocol {
	return []PcProtocol{PcProtocolAny, PcProtocolTCP, PcProtocolUDP}
}

// PcStatus enumerates the values for pc status.
type PcStatus string

const (
	// PcStatusError ...
	PcStatusError PcStatus = "Error"
	// PcStatusNotStarted ...
	PcStatusNotStarted PcStatus = "NotStarted"
	// PcStatusRunning ...
	PcStatusRunning PcStatus = "Running"
	// PcStatusStopped ...
	PcStatusStopped PcStatus = "Stopped"
	// PcStatusUnknown ...
	PcStatusUnknown PcStatus = "Unknown"
)

// PossiblePcStatusValues returns an array of possible values for the PcStatus const type.
func PossiblePcStatusValues() []PcStatus {
	return []PcStatus{PcStatusError, PcStatusNotStarted, PcStatusRunning, PcStatusStopped, PcStatusUnknown}
}

// PfsGroup enumerates the values for pfs group.
type PfsGroup string

const (
	// PfsGroupECP256 ...
	PfsGroupECP256 PfsGroup = "ECP256"
	// PfsGroupECP384 ...
	PfsGroupECP384 PfsGroup = "ECP384"
	// PfsGroupNone ...
	PfsGroupNone PfsGroup = "None"
	// PfsGroupPFS1 ...
	PfsGroupPFS1 PfsGroup = "PFS1"
	// PfsGroupPFS14 ...
	PfsGroupPFS14 PfsGroup = "PFS14"
	// PfsGroupPFS2 ...
	PfsGroupPFS2 PfsGroup = "PFS2"
	// PfsGroupPFS2048 ...
	PfsGroupPFS2048 PfsGroup = "PFS2048"
	// PfsGroupPFS24 ...
	PfsGroupPFS24 PfsGroup = "PFS24"
	// PfsGroupPFSMM ...
	PfsGroupPFSMM PfsGroup = "PFSMM"
)

// PossiblePfsGroupValues returns an array of possible values for the PfsGroup const type.
func PossiblePfsGroupValues() []PfsGroup {
	return []PfsGroup{PfsGroupECP256, PfsGroupECP384, PfsGroupNone, PfsGroupPFS1, PfsGroupPFS14, PfsGroupPFS2, PfsGroupPFS2048, PfsGroupPFS24, PfsGroupPFSMM}
}

// ProbeProtocol enumerates the values for probe protocol.
type ProbeProtocol string

const (
	// ProbeProtocolHTTP ...
	ProbeProtocolHTTP ProbeProtocol = "Http"
	// ProbeProtocolHTTPS ...
	ProbeProtocolHTTPS ProbeProtocol = "Https"
	// ProbeProtocolTCP ...
	ProbeProtocolTCP ProbeProtocol = "Tcp"
)

// PossibleProbeProtocolValues returns an array of possible values for the ProbeProtocol const type.
func PossibleProbeProtocolValues() []ProbeProtocol {
	return []ProbeProtocol{ProbeProtocolHTTP, ProbeProtocolHTTPS, ProbeProtocolTCP}
}

// ProcessorArchitecture enumerates the values for processor architecture.
type ProcessorArchitecture string

const (
	// Amd64 ...
	Amd64 ProcessorArchitecture = "Amd64"
	// X86 ...
	X86 ProcessorArchitecture = "X86"
)

// PossibleProcessorArchitectureValues returns an array of possible values for the ProcessorArchitecture const type.
func PossibleProcessorArchitectureValues() []ProcessorArchitecture {
	return []ProcessorArchitecture{Amd64, X86}
}

// Protocol enumerates the values for protocol.
type Protocol string

const (
	// ProtocolHTTP ...
	ProtocolHTTP Protocol = "Http"
	// ProtocolHTTPS ...
	ProtocolHTTPS Protocol = "Https"
	// ProtocolIcmp ...
	ProtocolIcmp Protocol = "Icmp"
	// ProtocolTCP ...
	ProtocolTCP Protocol = "Tcp"
)

// PossibleProtocolValues returns an array of possible values for the Protocol const type.
func PossibleProtocolValues() []Protocol {
	return []Protocol{ProtocolHTTP, ProtocolHTTPS, ProtocolIcmp, ProtocolTCP}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Deleting, Failed, Succeeded, Updating}
}

// PublicIPAddressSkuName enumerates the values for public ip address sku name.
type PublicIPAddressSkuName string

const (
	// PublicIPAddressSkuNameBasic ...
	PublicIPAddressSkuNameBasic PublicIPAddressSkuName = "Basic"
	// PublicIPAddressSkuNameStandard ...
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = "Standard"
)

// PossiblePublicIPAddressSkuNameValues returns an array of possible values for the PublicIPAddressSkuName const type.
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return []PublicIPAddressSkuName{PublicIPAddressSkuNameBasic, PublicIPAddressSkuNameStandard}
}

// PublicIPPrefixSkuName enumerates the values for public ip prefix sku name.
type PublicIPPrefixSkuName string

const (
	// PublicIPPrefixSkuNameStandard ...
	PublicIPPrefixSkuNameStandard PublicIPPrefixSkuName = "Standard"
)

// PossiblePublicIPPrefixSkuNameValues returns an array of possible values for the PublicIPPrefixSkuName const type.
func PossiblePublicIPPrefixSkuNameValues() []PublicIPPrefixSkuName {
	return []PublicIPPrefixSkuName{PublicIPPrefixSkuNameStandard}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// RouteNextHopType enumerates the values for route next hop type.
type RouteNextHopType string

const (
	// RouteNextHopTypeInternet ...
	RouteNextHopTypeInternet RouteNextHopType = "Internet"
	// RouteNextHopTypeNone ...
	RouteNextHopTypeNone RouteNextHopType = "None"
	// RouteNextHopTypeVirtualAppliance ...
	RouteNextHopTypeVirtualAppliance RouteNextHopType = "VirtualAppliance"
	// RouteNextHopTypeVirtualNetworkGateway ...
	RouteNextHopTypeVirtualNetworkGateway RouteNextHopType = "VirtualNetworkGateway"
	// RouteNextHopTypeVnetLocal ...
	RouteNextHopTypeVnetLocal RouteNextHopType = "VnetLocal"
)

// PossibleRouteNextHopTypeValues returns an array of possible values for the RouteNextHopType const type.
func PossibleRouteNextHopTypeValues() []RouteNextHopType {
	return []RouteNextHopType{RouteNextHopTypeInternet, RouteNextHopTypeNone, RouteNextHopTypeVirtualAppliance, RouteNextHopTypeVirtualNetworkGateway, RouteNextHopTypeVnetLocal}
}

// RuleConditionType enumerates the values for rule condition type.
type RuleConditionType string

const (
	// RuleConditionTypeApplicationRuleCondition ...
	RuleConditionTypeApplicationRuleCondition RuleConditionType = "ApplicationRuleCondition"
	// RuleConditionTypeFirewallPolicyRuleCondition ...
	RuleConditionTypeFirewallPolicyRuleCondition RuleConditionType = "FirewallPolicyRuleCondition"
	// RuleConditionTypeNetworkRuleCondition ...
	RuleConditionTypeNetworkRuleCondition RuleConditionType = "NetworkRuleCondition"
)

// PossibleRuleConditionTypeValues returns an array of possible values for the RuleConditionType const type.
func PossibleRuleConditionTypeValues() []RuleConditionType {
	return []RuleConditionType{RuleConditionTypeApplicationRuleCondition, RuleConditionTypeFirewallPolicyRuleCondition, RuleConditionTypeNetworkRuleCondition}
}

// RuleType enumerates the values for rule type.
type RuleType string

const (
	// RuleTypeFirewallPolicyFilterRule ...
	RuleTypeFirewallPolicyFilterRule RuleType = "FirewallPolicyFilterRule"
	// RuleTypeFirewallPolicyNatRule ...
	RuleTypeFirewallPolicyNatRule RuleType = "FirewallPolicyNatRule"
	// RuleTypeFirewallPolicyRule ...
	RuleTypeFirewallPolicyRule RuleType = "FirewallPolicyRule"
)

// PossibleRuleTypeValues returns an array of possible values for the RuleType const type.
func PossibleRuleTypeValues() []RuleType {
	return []RuleType{RuleTypeFirewallPolicyFilterRule, RuleTypeFirewallPolicyNatRule, RuleTypeFirewallPolicyRule}
}

// SecurityRuleAccess enumerates the values for security rule access.
type SecurityRuleAccess string

const (
	// SecurityRuleAccessAllow ...
	SecurityRuleAccessAllow SecurityRuleAccess = "Allow"
	// SecurityRuleAccessDeny ...
	SecurityRuleAccessDeny SecurityRuleAccess = "Deny"
)

// PossibleSecurityRuleAccessValues returns an array of possible values for the SecurityRuleAccess const type.
func PossibleSecurityRuleAccessValues() []SecurityRuleAccess {
	return []SecurityRuleAccess{SecurityRuleAccessAllow, SecurityRuleAccessDeny}
}

// SecurityRuleDirection enumerates the values for security rule direction.
type SecurityRuleDirection string

const (
	// SecurityRuleDirectionInbound ...
	SecurityRuleDirectionInbound SecurityRuleDirection = "Inbound"
	// SecurityRuleDirectionOutbound ...
	SecurityRuleDirectionOutbound SecurityRuleDirection = "Outbound"
)

// PossibleSecurityRuleDirectionValues returns an array of possible values for the SecurityRuleDirection const type.
func PossibleSecurityRuleDirectionValues() []SecurityRuleDirection {
	return []SecurityRuleDirection{SecurityRuleDirectionInbound, SecurityRuleDirectionOutbound}
}

// SecurityRuleProtocol enumerates the values for security rule protocol.
type SecurityRuleProtocol string

const (
	// SecurityRuleProtocolAsterisk ...
	SecurityRuleProtocolAsterisk SecurityRuleProtocol = "*"
	// SecurityRuleProtocolEsp ...
	SecurityRuleProtocolEsp SecurityRuleProtocol = "Esp"
	// SecurityRuleProtocolIcmp ...
	SecurityRuleProtocolIcmp SecurityRuleProtocol = "Icmp"
	// SecurityRuleProtocolTCP ...
	SecurityRuleProtocolTCP SecurityRuleProtocol = "Tcp"
	// SecurityRuleProtocolUDP ...
	SecurityRuleProtocolUDP SecurityRuleProtocol = "Udp"
)

// PossibleSecurityRuleProtocolValues returns an array of possible values for the SecurityRuleProtocol const type.
func PossibleSecurityRuleProtocolValues() []SecurityRuleProtocol {
	return []SecurityRuleProtocol{SecurityRuleProtocolAsterisk, SecurityRuleProtocolEsp, SecurityRuleProtocolIcmp, SecurityRuleProtocolTCP, SecurityRuleProtocolUDP}
}

// ServiceProviderProvisioningState enumerates the values for service provider provisioning state.
type ServiceProviderProvisioningState string

const (
	// Deprovisioning ...
	Deprovisioning ServiceProviderProvisioningState = "Deprovisioning"
	// NotProvisioned ...
	NotProvisioned ServiceProviderProvisioningState = "NotProvisioned"
	// Provisioned ...
	Provisioned ServiceProviderProvisioningState = "Provisioned"
	// Provisioning ...
	Provisioning ServiceProviderProvisioningState = "Provisioning"
)

// PossibleServiceProviderProvisioningStateValues returns an array of possible values for the ServiceProviderProvisioningState const type.
func PossibleServiceProviderProvisioningStateValues() []ServiceProviderProvisioningState {
	return []ServiceProviderProvisioningState{Deprovisioning, NotProvisioned, Provisioned, Provisioning}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// SeverityError ...
	SeverityError Severity = "Error"
	// SeverityWarning ...
	SeverityWarning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{SeverityError, SeverityWarning}
}

// TransportProtocol enumerates the values for transport protocol.
type TransportProtocol string

const (
	// TransportProtocolAll ...
	TransportProtocolAll TransportProtocol = "All"
	// TransportProtocolTCP ...
	TransportProtocolTCP TransportProtocol = "Tcp"
	// TransportProtocolUDP ...
	TransportProtocolUDP TransportProtocol = "Udp"
)

// PossibleTransportProtocolValues returns an array of possible values for the TransportProtocol const type.
func PossibleTransportProtocolValues() []TransportProtocol {
	return []TransportProtocol{TransportProtocolAll, TransportProtocolTCP, TransportProtocolUDP}
}

// TunnelConnectionStatus enumerates the values for tunnel connection status.
type TunnelConnectionStatus string

const (
	// TunnelConnectionStatusConnected ...
	TunnelConnectionStatusConnected TunnelConnectionStatus = "Connected"
	// TunnelConnectionStatusConnecting ...
	TunnelConnectionStatusConnecting TunnelConnectionStatus = "Connecting"
	// TunnelConnectionStatusNotConnected ...
	TunnelConnectionStatusNotConnected TunnelConnectionStatus = "NotConnected"
	// TunnelConnectionStatusUnknown ...
	TunnelConnectionStatusUnknown TunnelConnectionStatus = "Unknown"
)

// PossibleTunnelConnectionStatusValues returns an array of possible values for the TunnelConnectionStatus const type.
func PossibleTunnelConnectionStatusValues() []TunnelConnectionStatus {
	return []TunnelConnectionStatus{TunnelConnectionStatusConnected, TunnelConnectionStatusConnecting, TunnelConnectionStatusNotConnected, TunnelConnectionStatusUnknown}
}

// VerbosityLevel enumerates the values for verbosity level.
type VerbosityLevel string

const (
	// Full ...
	Full VerbosityLevel = "Full"
	// Minimum ...
	Minimum VerbosityLevel = "Minimum"
	// Normal ...
	Normal VerbosityLevel = "Normal"
)

// PossibleVerbosityLevelValues returns an array of possible values for the VerbosityLevel const type.
func PossibleVerbosityLevelValues() []VerbosityLevel {
	return []VerbosityLevel{Full, Minimum, Normal}
}

// VirtualNetworkGatewayConnectionProtocol enumerates the values for virtual network gateway connection
// protocol.
type VirtualNetworkGatewayConnectionProtocol string

const (
	// IKEv1 ...
	IKEv1 VirtualNetworkGatewayConnectionProtocol = "IKEv1"
	// IKEv2 ...
	IKEv2 VirtualNetworkGatewayConnectionProtocol = "IKEv2"
)

// PossibleVirtualNetworkGatewayConnectionProtocolValues returns an array of possible values for the VirtualNetworkGatewayConnectionProtocol const type.
func PossibleVirtualNetworkGatewayConnectionProtocolValues() []VirtualNetworkGatewayConnectionProtocol {
	return []VirtualNetworkGatewayConnectionProtocol{IKEv1, IKEv2}
}

// VirtualNetworkGatewayConnectionStatus enumerates the values for virtual network gateway connection status.
type VirtualNetworkGatewayConnectionStatus string

const (
	// VirtualNetworkGatewayConnectionStatusConnected ...
	VirtualNetworkGatewayConnectionStatusConnected VirtualNetworkGatewayConnectionStatus = "Connected"
	// VirtualNetworkGatewayConnectionStatusConnecting ...
	VirtualNetworkGatewayConnectionStatusConnecting VirtualNetworkGatewayConnectionStatus = "Connecting"
	// VirtualNetworkGatewayConnectionStatusNotConnected ...
	VirtualNetworkGatewayConnectionStatusNotConnected VirtualNetworkGatewayConnectionStatus = "NotConnected"
	// VirtualNetworkGatewayConnectionStatusUnknown ...
	VirtualNetworkGatewayConnectionStatusUnknown VirtualNetworkGatewayConnectionStatus = "Unknown"
)

// PossibleVirtualNetworkGatewayConnectionStatusValues returns an array of possible values for the VirtualNetworkGatewayConnectionStatus const type.
func PossibleVirtualNetworkGatewayConnectionStatusValues() []VirtualNetworkGatewayConnectionStatus {
	return []VirtualNetworkGatewayConnectionStatus{VirtualNetworkGatewayConnectionStatusConnected, VirtualNetworkGatewayConnectionStatusConnecting, VirtualNetworkGatewayConnectionStatusNotConnected, VirtualNetworkGatewayConnectionStatusUnknown}
}

// VirtualNetworkGatewayConnectionType enumerates the values for virtual network gateway connection type.
type VirtualNetworkGatewayConnectionType string

const (
	// ExpressRoute ...
	ExpressRoute VirtualNetworkGatewayConnectionType = "ExpressRoute"
	// IPsec ...
	IPsec VirtualNetworkGatewayConnectionType = "IPsec"
	// Vnet2Vnet ...
	Vnet2Vnet VirtualNetworkGatewayConnectionType = "Vnet2Vnet"
	// VPNClient ...
	VPNClient VirtualNetworkGatewayConnectionType = "VPNClient"
)

// PossibleVirtualNetworkGatewayConnectionTypeValues returns an array of possible values for the VirtualNetworkGatewayConnectionType const type.
func PossibleVirtualNetworkGatewayConnectionTypeValues() []VirtualNetworkGatewayConnectionType {
	return []VirtualNetworkGatewayConnectionType{ExpressRoute, IPsec, Vnet2Vnet, VPNClient}
}

// VirtualNetworkGatewaySkuName enumerates the values for virtual network gateway sku name.
type VirtualNetworkGatewaySkuName string

const (
	// VirtualNetworkGatewaySkuNameBasic ...
	VirtualNetworkGatewaySkuNameBasic VirtualNetworkGatewaySkuName = "Basic"
	// VirtualNetworkGatewaySkuNameErGw1AZ ...
	VirtualNetworkGatewaySkuNameErGw1AZ VirtualNetworkGatewaySkuName = "ErGw1AZ"
	// VirtualNetworkGatewaySkuNameErGw2AZ ...
	VirtualNetworkGatewaySkuNameErGw2AZ VirtualNetworkGatewaySkuName = "ErGw2AZ"
	// VirtualNetworkGatewaySkuNameErGw3AZ ...
	VirtualNetworkGatewaySkuNameErGw3AZ VirtualNetworkGatewaySkuName = "ErGw3AZ"
	// VirtualNetworkGatewaySkuNameHighPerformance ...
	VirtualNetworkGatewaySkuNameHighPerformance VirtualNetworkGatewaySkuName = "HighPerformance"
	// VirtualNetworkGatewaySkuNameStandard ...
	VirtualNetworkGatewaySkuNameStandard VirtualNetworkGatewaySkuName = "Standard"
	// VirtualNetworkGatewaySkuNameUltraPerformance ...
	VirtualNetworkGatewaySkuNameUltraPerformance VirtualNetworkGatewaySkuName = "UltraPerformance"
	// VirtualNetworkGatewaySkuNameVpnGw1 ...
	VirtualNetworkGatewaySkuNameVpnGw1 VirtualNetworkGatewaySkuName = "VpnGw1"
	// VirtualNetworkGatewaySkuNameVpnGw1AZ ...
	VirtualNetworkGatewaySkuNameVpnGw1AZ VirtualNetworkGatewaySkuName = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuNameVpnGw2 ...
	VirtualNetworkGatewaySkuNameVpnGw2 VirtualNetworkGatewaySkuName = "VpnGw2"
	// VirtualNetworkGatewaySkuNameVpnGw2AZ ...
	VirtualNetworkGatewaySkuNameVpnGw2AZ VirtualNetworkGatewaySkuName = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuNameVpnGw3 ...
	VirtualNetworkGatewaySkuNameVpnGw3 VirtualNetworkGatewaySkuName = "VpnGw3"
	// VirtualNetworkGatewaySkuNameVpnGw3AZ ...
	VirtualNetworkGatewaySkuNameVpnGw3AZ VirtualNetworkGatewaySkuName = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuNameVpnGw4 ...
	VirtualNetworkGatewaySkuNameVpnGw4 VirtualNetworkGatewaySkuName = "VpnGw4"
	// VirtualNetworkGatewaySkuNameVpnGw4AZ ...
	VirtualNetworkGatewaySkuNameVpnGw4AZ VirtualNetworkGatewaySkuName = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuNameVpnGw5 ...
	VirtualNetworkGatewaySkuNameVpnGw5 VirtualNetworkGatewaySkuName = "VpnGw5"
	// VirtualNetworkGatewaySkuNameVpnGw5AZ ...
	VirtualNetworkGatewaySkuNameVpnGw5AZ VirtualNetworkGatewaySkuName = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuNameValues returns an array of possible values for the VirtualNetworkGatewaySkuName const type.
func PossibleVirtualNetworkGatewaySkuNameValues() []VirtualNetworkGatewaySkuName {
	return []VirtualNetworkGatewaySkuName{VirtualNetworkGatewaySkuNameBasic, VirtualNetworkGatewaySkuNameErGw1AZ, VirtualNetworkGatewaySkuNameErGw2AZ, VirtualNetworkGatewaySkuNameErGw3AZ, VirtualNetworkGatewaySkuNameHighPerformance, VirtualNetworkGatewaySkuNameStandard, VirtualNetworkGatewaySkuNameUltraPerformance, VirtualNetworkGatewaySkuNameVpnGw1, VirtualNetworkGatewaySkuNameVpnGw1AZ, VirtualNetworkGatewaySkuNameVpnGw2, VirtualNetworkGatewaySkuNameVpnGw2AZ, VirtualNetworkGatewaySkuNameVpnGw3, VirtualNetworkGatewaySkuNameVpnGw3AZ, VirtualNetworkGatewaySkuNameVpnGw4, VirtualNetworkGatewaySkuNameVpnGw4AZ, VirtualNetworkGatewaySkuNameVpnGw5, VirtualNetworkGatewaySkuNameVpnGw5AZ}
}

// VirtualNetworkGatewaySkuTier enumerates the values for virtual network gateway sku tier.
type VirtualNetworkGatewaySkuTier string

const (
	// VirtualNetworkGatewaySkuTierBasic ...
	VirtualNetworkGatewaySkuTierBasic VirtualNetworkGatewaySkuTier = "Basic"
	// VirtualNetworkGatewaySkuTierErGw1AZ ...
	VirtualNetworkGatewaySkuTierErGw1AZ VirtualNetworkGatewaySkuTier = "ErGw1AZ"
	// VirtualNetworkGatewaySkuTierErGw2AZ ...
	VirtualNetworkGatewaySkuTierErGw2AZ VirtualNetworkGatewaySkuTier = "ErGw2AZ"
	// VirtualNetworkGatewaySkuTierErGw3AZ ...
	VirtualNetworkGatewaySkuTierErGw3AZ VirtualNetworkGatewaySkuTier = "ErGw3AZ"
	// VirtualNetworkGatewaySkuTierHighPerformance ...
	VirtualNetworkGatewaySkuTierHighPerformance VirtualNetworkGatewaySkuTier = "HighPerformance"
	// VirtualNetworkGatewaySkuTierStandard ...
	VirtualNetworkGatewaySkuTierStandard VirtualNetworkGatewaySkuTier = "Standard"
	// VirtualNetworkGatewaySkuTierUltraPerformance ...
	VirtualNetworkGatewaySkuTierUltraPerformance VirtualNetworkGatewaySkuTier = "UltraPerformance"
	// VirtualNetworkGatewaySkuTierVpnGw1 ...
	VirtualNetworkGatewaySkuTierVpnGw1 VirtualNetworkGatewaySkuTier = "VpnGw1"
	// VirtualNetworkGatewaySkuTierVpnGw1AZ ...
	VirtualNetworkGatewaySkuTierVpnGw1AZ VirtualNetworkGatewaySkuTier = "VpnGw1AZ"
	// VirtualNetworkGatewaySkuTierVpnGw2 ...
	VirtualNetworkGatewaySkuTierVpnGw2 VirtualNetworkGatewaySkuTier = "VpnGw2"
	// VirtualNetworkGatewaySkuTierVpnGw2AZ ...
	VirtualNetworkGatewaySkuTierVpnGw2AZ VirtualNetworkGatewaySkuTier = "VpnGw2AZ"
	// VirtualNetworkGatewaySkuTierVpnGw3 ...
	VirtualNetworkGatewaySkuTierVpnGw3 VirtualNetworkGatewaySkuTier = "VpnGw3"
	// VirtualNetworkGatewaySkuTierVpnGw3AZ ...
	VirtualNetworkGatewaySkuTierVpnGw3AZ VirtualNetworkGatewaySkuTier = "VpnGw3AZ"
	// VirtualNetworkGatewaySkuTierVpnGw4 ...
	VirtualNetworkGatewaySkuTierVpnGw4 VirtualNetworkGatewaySkuTier = "VpnGw4"
	// VirtualNetworkGatewaySkuTierVpnGw4AZ ...
	VirtualNetworkGatewaySkuTierVpnGw4AZ VirtualNetworkGatewaySkuTier = "VpnGw4AZ"
	// VirtualNetworkGatewaySkuTierVpnGw5 ...
	VirtualNetworkGatewaySkuTierVpnGw5 VirtualNetworkGatewaySkuTier = "VpnGw5"
	// VirtualNetworkGatewaySkuTierVpnGw5AZ ...
	VirtualNetworkGatewaySkuTierVpnGw5AZ VirtualNetworkGatewaySkuTier = "VpnGw5AZ"
)

// PossibleVirtualNetworkGatewaySkuTierValues returns an array of possible values for the VirtualNetworkGatewaySkuTier const type.
func PossibleVirtualNetworkGatewaySkuTierValues() []VirtualNetworkGatewaySkuTier {
	return []VirtualNetworkGatewaySkuTier{VirtualNetworkGatewaySkuTierBasic, VirtualNetworkGatewaySkuTierErGw1AZ, VirtualNetworkGatewaySkuTierErGw2AZ, VirtualNetworkGatewaySkuTierErGw3AZ, VirtualNetworkGatewaySkuTierHighPerformance, VirtualNetworkGatewaySkuTierStandard, VirtualNetworkGatewaySkuTierUltraPerformance, VirtualNetworkGatewaySkuTierVpnGw1, VirtualNetworkGatewaySkuTierVpnGw1AZ, VirtualNetworkGatewaySkuTierVpnGw2, VirtualNetworkGatewaySkuTierVpnGw2AZ, VirtualNetworkGatewaySkuTierVpnGw3, VirtualNetworkGatewaySkuTierVpnGw3AZ, VirtualNetworkGatewaySkuTierVpnGw4, VirtualNetworkGatewaySkuTierVpnGw4AZ, VirtualNetworkGatewaySkuTierVpnGw5, VirtualNetworkGatewaySkuTierVpnGw5AZ}
}

// VirtualNetworkGatewayType enumerates the values for virtual network gateway type.
type VirtualNetworkGatewayType string

const (
	// VirtualNetworkGatewayTypeExpressRoute ...
	VirtualNetworkGatewayTypeExpressRoute VirtualNetworkGatewayType = "ExpressRoute"
	// VirtualNetworkGatewayTypeVpn ...
	VirtualNetworkGatewayTypeVpn VirtualNetworkGatewayType = "Vpn"
)

// PossibleVirtualNetworkGatewayTypeValues returns an array of possible values for the VirtualNetworkGatewayType const type.
func PossibleVirtualNetworkGatewayTypeValues() []VirtualNetworkGatewayType {
	return []VirtualNetworkGatewayType{VirtualNetworkGatewayTypeExpressRoute, VirtualNetworkGatewayTypeVpn}
}

// VirtualNetworkPeeringState enumerates the values for virtual network peering state.
type VirtualNetworkPeeringState string

const (
	// VirtualNetworkPeeringStateConnected ...
	VirtualNetworkPeeringStateConnected VirtualNetworkPeeringState = "Connected"
	// VirtualNetworkPeeringStateDisconnected ...
	VirtualNetworkPeeringStateDisconnected VirtualNetworkPeeringState = "Disconnected"
	// VirtualNetworkPeeringStateInitiated ...
	VirtualNetworkPeeringStateInitiated VirtualNetworkPeeringState = "Initiated"
)

// PossibleVirtualNetworkPeeringStateValues returns an array of possible values for the VirtualNetworkPeeringState const type.
func PossibleVirtualNetworkPeeringStateValues() []VirtualNetworkPeeringState {
	return []VirtualNetworkPeeringState{VirtualNetworkPeeringStateConnected, VirtualNetworkPeeringStateDisconnected, VirtualNetworkPeeringStateInitiated}
}

// VirtualWanSecurityProviderType enumerates the values for virtual wan security provider type.
type VirtualWanSecurityProviderType string

const (
	// External ...
	External VirtualWanSecurityProviderType = "External"
	// Native ...
	Native VirtualWanSecurityProviderType = "Native"
)

// PossibleVirtualWanSecurityProviderTypeValues returns an array of possible values for the VirtualWanSecurityProviderType const type.
func PossibleVirtualWanSecurityProviderTypeValues() []VirtualWanSecurityProviderType {
	return []VirtualWanSecurityProviderType{External, Native}
}

// VpnClientProtocol enumerates the values for vpn client protocol.
type VpnClientProtocol string

const (
	// IkeV2 ...
	IkeV2 VpnClientProtocol = "IkeV2"
	// OpenVPN ...
	OpenVPN VpnClientProtocol = "OpenVPN"
	// SSTP ...
	SSTP VpnClientProtocol = "SSTP"
)

// PossibleVpnClientProtocolValues returns an array of possible values for the VpnClientProtocol const type.
func PossibleVpnClientProtocolValues() []VpnClientProtocol {
	return []VpnClientProtocol{IkeV2, OpenVPN, SSTP}
}

// VpnConnectionStatus enumerates the values for vpn connection status.
type VpnConnectionStatus string

const (
	// VpnConnectionStatusConnected ...
	VpnConnectionStatusConnected VpnConnectionStatus = "Connected"
	// VpnConnectionStatusConnecting ...
	VpnConnectionStatusConnecting VpnConnectionStatus = "Connecting"
	// VpnConnectionStatusNotConnected ...
	VpnConnectionStatusNotConnected VpnConnectionStatus = "NotConnected"
	// VpnConnectionStatusUnknown ...
	VpnConnectionStatusUnknown VpnConnectionStatus = "Unknown"
)

// PossibleVpnConnectionStatusValues returns an array of possible values for the VpnConnectionStatus const type.
func PossibleVpnConnectionStatusValues() []VpnConnectionStatus {
	return []VpnConnectionStatus{VpnConnectionStatusConnected, VpnConnectionStatusConnecting, VpnConnectionStatusNotConnected, VpnConnectionStatusUnknown}
}

// VpnGatewayGeneration enumerates the values for vpn gateway generation.
type VpnGatewayGeneration string

const (
	// VpnGatewayGenerationGeneration1 ...
	VpnGatewayGenerationGeneration1 VpnGatewayGeneration = "Generation1"
	// VpnGatewayGenerationGeneration2 ...
	VpnGatewayGenerationGeneration2 VpnGatewayGeneration = "Generation2"
	// VpnGatewayGenerationNone ...
	VpnGatewayGenerationNone VpnGatewayGeneration = "None"
)

// PossibleVpnGatewayGenerationValues returns an array of possible values for the VpnGatewayGeneration const type.
func PossibleVpnGatewayGenerationValues() []VpnGatewayGeneration {
	return []VpnGatewayGeneration{VpnGatewayGenerationGeneration1, VpnGatewayGenerationGeneration2, VpnGatewayGenerationNone}
}

// VpnGatewayTunnelingProtocol enumerates the values for vpn gateway tunneling protocol.
type VpnGatewayTunnelingProtocol string

const (
	// VpnGatewayTunnelingProtocolIkeV2 ...
	VpnGatewayTunnelingProtocolIkeV2 VpnGatewayTunnelingProtocol = "IkeV2"
	// VpnGatewayTunnelingProtocolOpenVPN ...
	VpnGatewayTunnelingProtocolOpenVPN VpnGatewayTunnelingProtocol = "OpenVPN"
)

// PossibleVpnGatewayTunnelingProtocolValues returns an array of possible values for the VpnGatewayTunnelingProtocol const type.
func PossibleVpnGatewayTunnelingProtocolValues() []VpnGatewayTunnelingProtocol {
	return []VpnGatewayTunnelingProtocol{VpnGatewayTunnelingProtocolIkeV2, VpnGatewayTunnelingProtocolOpenVPN}
}

// VpnType enumerates the values for vpn type.
type VpnType string

const (
	// PolicyBased ...
	PolicyBased VpnType = "PolicyBased"
	// RouteBased ...
	RouteBased VpnType = "RouteBased"
)

// PossibleVpnTypeValues returns an array of possible values for the VpnType const type.
func PossibleVpnTypeValues() []VpnType {
	return []VpnType{PolicyBased, RouteBased}
}

// WebApplicationFirewallAction enumerates the values for web application firewall action.
type WebApplicationFirewallAction string

const (
	// WebApplicationFirewallActionAllow ...
	WebApplicationFirewallActionAllow WebApplicationFirewallAction = "Allow"
	// WebApplicationFirewallActionBlock ...
	WebApplicationFirewallActionBlock WebApplicationFirewallAction = "Block"
	// WebApplicationFirewallActionLog ...
	WebApplicationFirewallActionLog WebApplicationFirewallAction = "Log"
)

// PossibleWebApplicationFirewallActionValues returns an array of possible values for the WebApplicationFirewallAction const type.
func PossibleWebApplicationFirewallActionValues() []WebApplicationFirewallAction {
	return []WebApplicationFirewallAction{WebApplicationFirewallActionAllow, WebApplicationFirewallActionBlock, WebApplicationFirewallActionLog}
}

// WebApplicationFirewallEnabledState enumerates the values for web application firewall enabled state.
type WebApplicationFirewallEnabledState string

const (
	// WebApplicationFirewallEnabledStateDisabled ...
	WebApplicationFirewallEnabledStateDisabled WebApplicationFirewallEnabledState = "Disabled"
	// WebApplicationFirewallEnabledStateEnabled ...
	WebApplicationFirewallEnabledStateEnabled WebApplicationFirewallEnabledState = "Enabled"
)

// PossibleWebApplicationFirewallEnabledStateValues returns an array of possible values for the WebApplicationFirewallEnabledState const type.
func PossibleWebApplicationFirewallEnabledStateValues() []WebApplicationFirewallEnabledState {
	return []WebApplicationFirewallEnabledState{WebApplicationFirewallEnabledStateDisabled, WebApplicationFirewallEnabledStateEnabled}
}

// WebApplicationFirewallMatchVariable enumerates the values for web application firewall match variable.
type WebApplicationFirewallMatchVariable string

const (
	// PostArgs ...
	PostArgs WebApplicationFirewallMatchVariable = "PostArgs"
	// QueryString ...
	QueryString WebApplicationFirewallMatchVariable = "QueryString"
	// RemoteAddr ...
	RemoteAddr WebApplicationFirewallMatchVariable = "RemoteAddr"
	// RequestBody ...
	RequestBody WebApplicationFirewallMatchVariable = "RequestBody"
	// RequestCookies ...
	RequestCookies WebApplicationFirewallMatchVariable = "RequestCookies"
	// RequestHeaders ...
	RequestHeaders WebApplicationFirewallMatchVariable = "RequestHeaders"
	// RequestMethod ...
	RequestMethod WebApplicationFirewallMatchVariable = "RequestMethod"
	// RequestURI ...
	RequestURI WebApplicationFirewallMatchVariable = "RequestUri"
)

// PossibleWebApplicationFirewallMatchVariableValues returns an array of possible values for the WebApplicationFirewallMatchVariable const type.
func PossibleWebApplicationFirewallMatchVariableValues() []WebApplicationFirewallMatchVariable {
	return []WebApplicationFirewallMatchVariable{PostArgs, QueryString, RemoteAddr, RequestBody, RequestCookies, RequestHeaders, RequestMethod, RequestURI}
}

// WebApplicationFirewallMode enumerates the values for web application firewall mode.
type WebApplicationFirewallMode string

const (
	// WebApplicationFirewallModeDetection ...
	WebApplicationFirewallModeDetection WebApplicationFirewallMode = "Detection"
	// WebApplicationFirewallModePrevention ...
	WebApplicationFirewallModePrevention WebApplicationFirewallMode = "Prevention"
)

// PossibleWebApplicationFirewallModeValues returns an array of possible values for the WebApplicationFirewallMode const type.
func PossibleWebApplicationFirewallModeValues() []WebApplicationFirewallMode {
	return []WebApplicationFirewallMode{WebApplicationFirewallModeDetection, WebApplicationFirewallModePrevention}
}

// WebApplicationFirewallOperator enumerates the values for web application firewall operator.
type WebApplicationFirewallOperator string

const (
	// WebApplicationFirewallOperatorBeginsWith ...
	WebApplicationFirewallOperatorBeginsWith WebApplicationFirewallOperator = "BeginsWith"
	// WebApplicationFirewallOperatorContains ...
	WebApplicationFirewallOperatorContains WebApplicationFirewallOperator = "Contains"
	// WebApplicationFirewallOperatorEndsWith ...
	WebApplicationFirewallOperatorEndsWith WebApplicationFirewallOperator = "EndsWith"
	// WebApplicationFirewallOperatorEqual ...
	WebApplicationFirewallOperatorEqual WebApplicationFirewallOperator = "Equal"
	// WebApplicationFirewallOperatorGreaterThan ...
	WebApplicationFirewallOperatorGreaterThan WebApplicationFirewallOperator = "GreaterThan"
	// WebApplicationFirewallOperatorGreaterThanOrEqual ...
	WebApplicationFirewallOperatorGreaterThanOrEqual WebApplicationFirewallOperator = "GreaterThanOrEqual"
	// WebApplicationFirewallOperatorIPMatch ...
	WebApplicationFirewallOperatorIPMatch WebApplicationFirewallOperator = "IPMatch"
	// WebApplicationFirewallOperatorLessThan ...
	WebApplicationFirewallOperatorLessThan WebApplicationFirewallOperator = "LessThan"
	// WebApplicationFirewallOperatorLessThanOrEqual ...
	WebApplicationFirewallOperatorLessThanOrEqual WebApplicationFirewallOperator = "LessThanOrEqual"
	// WebApplicationFirewallOperatorRegex ...
	WebApplicationFirewallOperatorRegex WebApplicationFirewallOperator = "Regex"
)

// PossibleWebApplicationFirewallOperatorValues returns an array of possible values for the WebApplicationFirewallOperator const type.
func PossibleWebApplicationFirewallOperatorValues() []WebApplicationFirewallOperator {
	return []WebApplicationFirewallOperator{WebApplicationFirewallOperatorBeginsWith, WebApplicationFirewallOperatorContains, WebApplicationFirewallOperatorEndsWith, WebApplicationFirewallOperatorEqual, WebApplicationFirewallOperatorGreaterThan, WebApplicationFirewallOperatorGreaterThanOrEqual, WebApplicationFirewallOperatorIPMatch, WebApplicationFirewallOperatorLessThan, WebApplicationFirewallOperatorLessThanOrEqual, WebApplicationFirewallOperatorRegex}
}

// WebApplicationFirewallPolicyResourceState enumerates the values for web application firewall policy resource
// state.
type WebApplicationFirewallPolicyResourceState string

const (
	// WebApplicationFirewallPolicyResourceStateCreating ...
	WebApplicationFirewallPolicyResourceStateCreating WebApplicationFirewallPolicyResourceState = "Creating"
	// WebApplicationFirewallPolicyResourceStateDeleting ...
	WebApplicationFirewallPolicyResourceStateDeleting WebApplicationFirewallPolicyResourceState = "Deleting"
	// WebApplicationFirewallPolicyResourceStateDisabled ...
	WebApplicationFirewallPolicyResourceStateDisabled WebApplicationFirewallPolicyResourceState = "Disabled"
	// WebApplicationFirewallPolicyResourceStateDisabling ...
	WebApplicationFirewallPolicyResourceStateDisabling WebApplicationFirewallPolicyResourceState = "Disabling"
	// WebApplicationFirewallPolicyResourceStateEnabled ...
	WebApplicationFirewallPolicyResourceStateEnabled WebApplicationFirewallPolicyResourceState = "Enabled"
	// WebApplicationFirewallPolicyResourceStateEnabling ...
	WebApplicationFirewallPolicyResourceStateEnabling WebApplicationFirewallPolicyResourceState = "Enabling"
)

// PossibleWebApplicationFirewallPolicyResourceStateValues returns an array of possible values for the WebApplicationFirewallPolicyResourceState const type.
func PossibleWebApplicationFirewallPolicyResourceStateValues() []WebApplicationFirewallPolicyResourceState {
	return []WebApplicationFirewallPolicyResourceState{WebApplicationFirewallPolicyResourceStateCreating, WebApplicationFirewallPolicyResourceStateDeleting, WebApplicationFirewallPolicyResourceStateDisabled, WebApplicationFirewallPolicyResourceStateDisabling, WebApplicationFirewallPolicyResourceStateEnabled, WebApplicationFirewallPolicyResourceStateEnabling}
}

// WebApplicationFirewallRuleType enumerates the values for web application firewall rule type.
type WebApplicationFirewallRuleType string

const (
	// WebApplicationFirewallRuleTypeInvalid ...
	WebApplicationFirewallRuleTypeInvalid WebApplicationFirewallRuleType = "Invalid"
	// WebApplicationFirewallRuleTypeMatchRule ...
	WebApplicationFirewallRuleTypeMatchRule WebApplicationFirewallRuleType = "MatchRule"
)

// PossibleWebApplicationFirewallRuleTypeValues returns an array of possible values for the WebApplicationFirewallRuleType const type.
func PossibleWebApplicationFirewallRuleTypeValues() []WebApplicationFirewallRuleType {
	return []WebApplicationFirewallRuleType{WebApplicationFirewallRuleTypeInvalid, WebApplicationFirewallRuleTypeMatchRule}
}

// WebApplicationFirewallTransform enumerates the values for web application firewall transform.
type WebApplicationFirewallTransform string

const (
	// HTMLEntityDecode ...
	HTMLEntityDecode WebApplicationFirewallTransform = "HtmlEntityDecode"
	// Lowercase ...
	Lowercase WebApplicationFirewallTransform = "Lowercase"
	// RemoveNulls ...
	RemoveNulls WebApplicationFirewallTransform = "RemoveNulls"
	// Trim ...
	Trim WebApplicationFirewallTransform = "Trim"
	// URLDecode ...
	URLDecode WebApplicationFirewallTransform = "UrlDecode"
	// URLEncode ...
	URLEncode WebApplicationFirewallTransform = "UrlEncode"
)

// PossibleWebApplicationFirewallTransformValues returns an array of possible values for the WebApplicationFirewallTransform const type.
func PossibleWebApplicationFirewallTransformValues() []WebApplicationFirewallTransform {
	return []WebApplicationFirewallTransform{HTMLEntityDecode, Lowercase, RemoveNulls, Trim, URLDecode, URLEncode}
}
