package authorization

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// PrincipalType enumerates the values for principal type.
type PrincipalType string

const (
	// Application ...
	Application PrincipalType = "Application"
	// DirectoryObjectOrGroup ...
	DirectoryObjectOrGroup PrincipalType = "DirectoryObjectOrGroup"
	// DirectoryRoleTemplate ...
	DirectoryRoleTemplate PrincipalType = "DirectoryRoleTemplate"
	// Everyone ...
	Everyone PrincipalType = "Everyone"
	// ForeignGroup ...
	ForeignGroup PrincipalType = "ForeignGroup"
	// Group ...
	Group PrincipalType = "Group"
	// MSI ...
	MSI PrincipalType = "MSI"
	// ServicePrincipal ...
	ServicePrincipal PrincipalType = "ServicePrincipal"
	// Unknown ...
	Unknown PrincipalType = "Unknown"
	// User ...
	User PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns an array of possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{Application, DirectoryObjectOrGroup, DirectoryRoleTemplate, Everyone, ForeignGroup, Group, MSI, ServicePrincipal, Unknown, User}
}
