package avs

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// Cancelled ...
	Cancelled ClusterProvisioningState = "Cancelled"
	// Deleting ...
	Deleting ClusterProvisioningState = "Deleting"
	// Failed ...
	Failed ClusterProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ClusterProvisioningState = "Succeeded"
	// Updating ...
	Updating ClusterProvisioningState = "Updating"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{Cancelled, Deleting, Failed, Succeeded, Updating}
}

// DhcpType enumerates the values for dhcp type.
type DhcpType string

const (
	// DhcpTypeRELAY ...
	DhcpTypeRELAY DhcpType = "RELAY"
	// DhcpTypeSERVER ...
	DhcpTypeSERVER DhcpType = "SERVER"
	// DhcpTypeWorkloadNetworkDhcpEntity ...
	DhcpTypeWorkloadNetworkDhcpEntity DhcpType = "WorkloadNetworkDhcpEntity"
)

// PossibleDhcpTypeValues returns an array of possible values for the DhcpType const type.
func PossibleDhcpTypeValues() []DhcpType {
	return []DhcpType{DhcpTypeRELAY, DhcpTypeSERVER, DhcpTypeWorkloadNetworkDhcpEntity}
}

// ExpressRouteAuthorizationProvisioningState enumerates the values for express route authorization
// provisioning state.
type ExpressRouteAuthorizationProvisioningState string

const (
	// ExpressRouteAuthorizationProvisioningStateFailed ...
	ExpressRouteAuthorizationProvisioningStateFailed ExpressRouteAuthorizationProvisioningState = "Failed"
	// ExpressRouteAuthorizationProvisioningStateSucceeded ...
	ExpressRouteAuthorizationProvisioningStateSucceeded ExpressRouteAuthorizationProvisioningState = "Succeeded"
	// ExpressRouteAuthorizationProvisioningStateUpdating ...
	ExpressRouteAuthorizationProvisioningStateUpdating ExpressRouteAuthorizationProvisioningState = "Updating"
)

// PossibleExpressRouteAuthorizationProvisioningStateValues returns an array of possible values for the ExpressRouteAuthorizationProvisioningState const type.
func PossibleExpressRouteAuthorizationProvisioningStateValues() []ExpressRouteAuthorizationProvisioningState {
	return []ExpressRouteAuthorizationProvisioningState{ExpressRouteAuthorizationProvisioningStateFailed, ExpressRouteAuthorizationProvisioningStateSucceeded, ExpressRouteAuthorizationProvisioningStateUpdating}
}

// GlobalReachConnectionProvisioningState enumerates the values for global reach connection provisioning state.
type GlobalReachConnectionProvisioningState string

const (
	// GlobalReachConnectionProvisioningStateFailed ...
	GlobalReachConnectionProvisioningStateFailed GlobalReachConnectionProvisioningState = "Failed"
	// GlobalReachConnectionProvisioningStateSucceeded ...
	GlobalReachConnectionProvisioningStateSucceeded GlobalReachConnectionProvisioningState = "Succeeded"
	// GlobalReachConnectionProvisioningStateUpdating ...
	GlobalReachConnectionProvisioningStateUpdating GlobalReachConnectionProvisioningState = "Updating"
)

// PossibleGlobalReachConnectionProvisioningStateValues returns an array of possible values for the GlobalReachConnectionProvisioningState const type.
func PossibleGlobalReachConnectionProvisioningStateValues() []GlobalReachConnectionProvisioningState {
	return []GlobalReachConnectionProvisioningState{GlobalReachConnectionProvisioningStateFailed, GlobalReachConnectionProvisioningStateSucceeded, GlobalReachConnectionProvisioningStateUpdating}
}

// GlobalReachConnectionStatus enumerates the values for global reach connection status.
type GlobalReachConnectionStatus string

const (
	// Connected ...
	Connected GlobalReachConnectionStatus = "Connected"
	// Connecting ...
	Connecting GlobalReachConnectionStatus = "Connecting"
	// Disconnected ...
	Disconnected GlobalReachConnectionStatus = "Disconnected"
)

// PossibleGlobalReachConnectionStatusValues returns an array of possible values for the GlobalReachConnectionStatus const type.
func PossibleGlobalReachConnectionStatusValues() []GlobalReachConnectionStatus {
	return []GlobalReachConnectionStatus{Connected, Connecting, Disconnected}
}

// HcxEnterpriseSiteStatus enumerates the values for hcx enterprise site status.
type HcxEnterpriseSiteStatus string

const (
	// Available ...
	Available HcxEnterpriseSiteStatus = "Available"
	// Consumed ...
	Consumed HcxEnterpriseSiteStatus = "Consumed"
	// Deactivated ...
	Deactivated HcxEnterpriseSiteStatus = "Deactivated"
	// Deleted ...
	Deleted HcxEnterpriseSiteStatus = "Deleted"
)

// PossibleHcxEnterpriseSiteStatusValues returns an array of possible values for the HcxEnterpriseSiteStatus const type.
func PossibleHcxEnterpriseSiteStatusValues() []HcxEnterpriseSiteStatus {
	return []HcxEnterpriseSiteStatus{Available, Consumed, Deactivated, Deleted}
}

// InternetEnum enumerates the values for internet enum.
type InternetEnum string

const (
	// Disabled ...
	Disabled InternetEnum = "Disabled"
	// Enabled ...
	Enabled InternetEnum = "Enabled"
)

// PossibleInternetEnumValues returns an array of possible values for the InternetEnum const type.
func PossibleInternetEnumValues() []InternetEnum {
	return []InternetEnum{Disabled, Enabled}
}

// NsxtAdminRotateEnum enumerates the values for nsxt admin rotate enum.
type NsxtAdminRotateEnum string

const (
	// OnetimeRotate ...
	OnetimeRotate NsxtAdminRotateEnum = "OnetimeRotate"
)

// PossibleNsxtAdminRotateEnumValues returns an array of possible values for the NsxtAdminRotateEnum const type.
func PossibleNsxtAdminRotateEnumValues() []NsxtAdminRotateEnum {
	return []NsxtAdminRotateEnum{OnetimeRotate}
}

// PortMirroringDirectionEnum enumerates the values for port mirroring direction enum.
type PortMirroringDirectionEnum string

const (
	// INGRESSEGRESSBIDIRECTIONAL ...
	INGRESSEGRESSBIDIRECTIONAL PortMirroringDirectionEnum = "INGRESS, EGRESS, BIDIRECTIONAL"
)

// PossiblePortMirroringDirectionEnumValues returns an array of possible values for the PortMirroringDirectionEnum const type.
func PossiblePortMirroringDirectionEnumValues() []PortMirroringDirectionEnum {
	return []PortMirroringDirectionEnum{INGRESSEGRESSBIDIRECTIONAL}
}

// PortMirroringStatusEnum enumerates the values for port mirroring status enum.
type PortMirroringStatusEnum string

const (
	// SUCCESSFAILURE ...
	SUCCESSFAILURE PortMirroringStatusEnum = "SUCCESS, FAILURE"
)

// PossiblePortMirroringStatusEnumValues returns an array of possible values for the PortMirroringStatusEnum const type.
func PossiblePortMirroringStatusEnumValues() []PortMirroringStatusEnum {
	return []PortMirroringStatusEnum{SUCCESSFAILURE}
}

// PrivateCloudProvisioningState enumerates the values for private cloud provisioning state.
type PrivateCloudProvisioningState string

const (
	// PrivateCloudProvisioningStateBuilding ...
	PrivateCloudProvisioningStateBuilding PrivateCloudProvisioningState = "Building"
	// PrivateCloudProvisioningStateCancelled ...
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = "Cancelled"
	// PrivateCloudProvisioningStateDeleting ...
	PrivateCloudProvisioningStateDeleting PrivateCloudProvisioningState = "Deleting"
	// PrivateCloudProvisioningStateFailed ...
	PrivateCloudProvisioningStateFailed PrivateCloudProvisioningState = "Failed"
	// PrivateCloudProvisioningStatePending ...
	PrivateCloudProvisioningStatePending PrivateCloudProvisioningState = "Pending"
	// PrivateCloudProvisioningStateSucceeded ...
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = "Succeeded"
	// PrivateCloudProvisioningStateUpdating ...
	PrivateCloudProvisioningStateUpdating PrivateCloudProvisioningState = "Updating"
)

// PossiblePrivateCloudProvisioningStateValues returns an array of possible values for the PrivateCloudProvisioningState const type.
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return []PrivateCloudProvisioningState{PrivateCloudProvisioningStateBuilding, PrivateCloudProvisioningStateCancelled, PrivateCloudProvisioningStateDeleting, PrivateCloudProvisioningStateFailed, PrivateCloudProvisioningStatePending, PrivateCloudProvisioningStateSucceeded, PrivateCloudProvisioningStateUpdating}
}

// QuotaEnabled enumerates the values for quota enabled.
type QuotaEnabled string

const (
	// QuotaEnabledDisabled ...
	QuotaEnabledDisabled QuotaEnabled = "Disabled"
	// QuotaEnabledEnabled ...
	QuotaEnabledEnabled QuotaEnabled = "Enabled"
)

// PossibleQuotaEnabledValues returns an array of possible values for the QuotaEnabled const type.
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return []QuotaEnabled{QuotaEnabledDisabled, QuotaEnabledEnabled}
}

// SegmentStatusEnum enumerates the values for segment status enum.
type SegmentStatusEnum string

const (
	// SegmentStatusEnumSUCCESSFAILURE ...
	SegmentStatusEnumSUCCESSFAILURE SegmentStatusEnum = "SUCCESS, FAILURE"
)

// PossibleSegmentStatusEnumValues returns an array of possible values for the SegmentStatusEnum const type.
func PossibleSegmentStatusEnumValues() []SegmentStatusEnum {
	return []SegmentStatusEnum{SegmentStatusEnumSUCCESSFAILURE}
}

// SslEnum enumerates the values for ssl enum.
type SslEnum string

const (
	// SslEnumDisabled ...
	SslEnumDisabled SslEnum = "Disabled"
	// SslEnumEnabled ...
	SslEnumEnabled SslEnum = "Enabled"
)

// PossibleSslEnumValues returns an array of possible values for the SslEnum const type.
func PossibleSslEnumValues() []SslEnum {
	return []SslEnum{SslEnumDisabled, SslEnumEnabled}
}

// TrialStatus enumerates the values for trial status.
type TrialStatus string

const (
	// TrialAvailable ...
	TrialAvailable TrialStatus = "TrialAvailable"
	// TrialDisabled ...
	TrialDisabled TrialStatus = "TrialDisabled"
	// TrialUsed ...
	TrialUsed TrialStatus = "TrialUsed"
)

// PossibleTrialStatusValues returns an array of possible values for the TrialStatus const type.
func PossibleTrialStatusValues() []TrialStatus {
	return []TrialStatus{TrialAvailable, TrialDisabled, TrialUsed}
}

// VcsaAdminRotateEnum enumerates the values for vcsa admin rotate enum.
type VcsaAdminRotateEnum string

const (
	// VcsaAdminRotateEnumOnetimeRotate ...
	VcsaAdminRotateEnumOnetimeRotate VcsaAdminRotateEnum = "OnetimeRotate"
)

// PossibleVcsaAdminRotateEnumValues returns an array of possible values for the VcsaAdminRotateEnum const type.
func PossibleVcsaAdminRotateEnumValues() []VcsaAdminRotateEnum {
	return []VcsaAdminRotateEnum{VcsaAdminRotateEnumOnetimeRotate}
}

// VMGroupStatusEnum enumerates the values for vm group status enum.
type VMGroupStatusEnum string

const (
	// VMGroupStatusEnumSUCCESSFAILURE ...
	VMGroupStatusEnumSUCCESSFAILURE VMGroupStatusEnum = "SUCCESS, FAILURE"
)

// PossibleVMGroupStatusEnumValues returns an array of possible values for the VMGroupStatusEnum const type.
func PossibleVMGroupStatusEnumValues() []VMGroupStatusEnum {
	return []VMGroupStatusEnum{VMGroupStatusEnumSUCCESSFAILURE}
}

// VMTypeEnum enumerates the values for vm type enum.
type VMTypeEnum string

const (
	// REGULAREDGESERVICE ...
	REGULAREDGESERVICE VMTypeEnum = "REGULAR, EDGE, SERVICE"
)

// PossibleVMTypeEnumValues returns an array of possible values for the VMTypeEnum const type.
func PossibleVMTypeEnumValues() []VMTypeEnum {
	return []VMTypeEnum{REGULAREDGESERVICE}
}

// WorkloadNetworkDhcpProvisioningState enumerates the values for workload network dhcp provisioning state.
type WorkloadNetworkDhcpProvisioningState string

const (
	// WorkloadNetworkDhcpProvisioningStateBuilding ...
	WorkloadNetworkDhcpProvisioningStateBuilding WorkloadNetworkDhcpProvisioningState = "Building"
	// WorkloadNetworkDhcpProvisioningStateDeleting ...
	WorkloadNetworkDhcpProvisioningStateDeleting WorkloadNetworkDhcpProvisioningState = "Deleting"
	// WorkloadNetworkDhcpProvisioningStateFailed ...
	WorkloadNetworkDhcpProvisioningStateFailed WorkloadNetworkDhcpProvisioningState = "Failed"
	// WorkloadNetworkDhcpProvisioningStateSucceeded ...
	WorkloadNetworkDhcpProvisioningStateSucceeded WorkloadNetworkDhcpProvisioningState = "Succeeded"
	// WorkloadNetworkDhcpProvisioningStateUpdating ...
	WorkloadNetworkDhcpProvisioningStateUpdating WorkloadNetworkDhcpProvisioningState = "Updating"
)

// PossibleWorkloadNetworkDhcpProvisioningStateValues returns an array of possible values for the WorkloadNetworkDhcpProvisioningState const type.
func PossibleWorkloadNetworkDhcpProvisioningStateValues() []WorkloadNetworkDhcpProvisioningState {
	return []WorkloadNetworkDhcpProvisioningState{WorkloadNetworkDhcpProvisioningStateBuilding, WorkloadNetworkDhcpProvisioningStateDeleting, WorkloadNetworkDhcpProvisioningStateFailed, WorkloadNetworkDhcpProvisioningStateSucceeded, WorkloadNetworkDhcpProvisioningStateUpdating}
}

// WorkloadNetworkPortMirroringProvisioningState enumerates the values for workload network port mirroring
// provisioning state.
type WorkloadNetworkPortMirroringProvisioningState string

const (
	// WorkloadNetworkPortMirroringProvisioningStateBuilding ...
	WorkloadNetworkPortMirroringProvisioningStateBuilding WorkloadNetworkPortMirroringProvisioningState = "Building"
	// WorkloadNetworkPortMirroringProvisioningStateDeleting ...
	WorkloadNetworkPortMirroringProvisioningStateDeleting WorkloadNetworkPortMirroringProvisioningState = "Deleting"
	// WorkloadNetworkPortMirroringProvisioningStateFailed ...
	WorkloadNetworkPortMirroringProvisioningStateFailed WorkloadNetworkPortMirroringProvisioningState = "Failed"
	// WorkloadNetworkPortMirroringProvisioningStateSucceeded ...
	WorkloadNetworkPortMirroringProvisioningStateSucceeded WorkloadNetworkPortMirroringProvisioningState = "Succeeded"
	// WorkloadNetworkPortMirroringProvisioningStateUpdating ...
	WorkloadNetworkPortMirroringProvisioningStateUpdating WorkloadNetworkPortMirroringProvisioningState = "Updating"
)

// PossibleWorkloadNetworkPortMirroringProvisioningStateValues returns an array of possible values for the WorkloadNetworkPortMirroringProvisioningState const type.
func PossibleWorkloadNetworkPortMirroringProvisioningStateValues() []WorkloadNetworkPortMirroringProvisioningState {
	return []WorkloadNetworkPortMirroringProvisioningState{WorkloadNetworkPortMirroringProvisioningStateBuilding, WorkloadNetworkPortMirroringProvisioningStateDeleting, WorkloadNetworkPortMirroringProvisioningStateFailed, WorkloadNetworkPortMirroringProvisioningStateSucceeded, WorkloadNetworkPortMirroringProvisioningStateUpdating}
}

// WorkloadNetworkSegmentProvisioningState enumerates the values for workload network segment provisioning
// state.
type WorkloadNetworkSegmentProvisioningState string

const (
	// WorkloadNetworkSegmentProvisioningStateBuilding ...
	WorkloadNetworkSegmentProvisioningStateBuilding WorkloadNetworkSegmentProvisioningState = "Building"
	// WorkloadNetworkSegmentProvisioningStateDeleting ...
	WorkloadNetworkSegmentProvisioningStateDeleting WorkloadNetworkSegmentProvisioningState = "Deleting"
	// WorkloadNetworkSegmentProvisioningStateFailed ...
	WorkloadNetworkSegmentProvisioningStateFailed WorkloadNetworkSegmentProvisioningState = "Failed"
	// WorkloadNetworkSegmentProvisioningStateSucceeded ...
	WorkloadNetworkSegmentProvisioningStateSucceeded WorkloadNetworkSegmentProvisioningState = "Succeeded"
	// WorkloadNetworkSegmentProvisioningStateUpdating ...
	WorkloadNetworkSegmentProvisioningStateUpdating WorkloadNetworkSegmentProvisioningState = "Updating"
)

// PossibleWorkloadNetworkSegmentProvisioningStateValues returns an array of possible values for the WorkloadNetworkSegmentProvisioningState const type.
func PossibleWorkloadNetworkSegmentProvisioningStateValues() []WorkloadNetworkSegmentProvisioningState {
	return []WorkloadNetworkSegmentProvisioningState{WorkloadNetworkSegmentProvisioningStateBuilding, WorkloadNetworkSegmentProvisioningStateDeleting, WorkloadNetworkSegmentProvisioningStateFailed, WorkloadNetworkSegmentProvisioningStateSucceeded, WorkloadNetworkSegmentProvisioningStateUpdating}
}

// WorkloadNetworkVMGroupProvisioningState enumerates the values for workload network vm group provisioning
// state.
type WorkloadNetworkVMGroupProvisioningState string

const (
	// WorkloadNetworkVMGroupProvisioningStateBuilding ...
	WorkloadNetworkVMGroupProvisioningStateBuilding WorkloadNetworkVMGroupProvisioningState = "Building"
	// WorkloadNetworkVMGroupProvisioningStateDeleting ...
	WorkloadNetworkVMGroupProvisioningStateDeleting WorkloadNetworkVMGroupProvisioningState = "Deleting"
	// WorkloadNetworkVMGroupProvisioningStateFailed ...
	WorkloadNetworkVMGroupProvisioningStateFailed WorkloadNetworkVMGroupProvisioningState = "Failed"
	// WorkloadNetworkVMGroupProvisioningStateSucceeded ...
	WorkloadNetworkVMGroupProvisioningStateSucceeded WorkloadNetworkVMGroupProvisioningState = "Succeeded"
	// WorkloadNetworkVMGroupProvisioningStateUpdating ...
	WorkloadNetworkVMGroupProvisioningStateUpdating WorkloadNetworkVMGroupProvisioningState = "Updating"
)

// PossibleWorkloadNetworkVMGroupProvisioningStateValues returns an array of possible values for the WorkloadNetworkVMGroupProvisioningState const type.
func PossibleWorkloadNetworkVMGroupProvisioningStateValues() []WorkloadNetworkVMGroupProvisioningState {
	return []WorkloadNetworkVMGroupProvisioningState{WorkloadNetworkVMGroupProvisioningStateBuilding, WorkloadNetworkVMGroupProvisioningStateDeleting, WorkloadNetworkVMGroupProvisioningStateFailed, WorkloadNetworkVMGroupProvisioningStateSucceeded, WorkloadNetworkVMGroupProvisioningStateUpdating}
}
