package digitaltwins

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ModelsClient is the a service for managing and querying digital twins and digital twin models.
type ModelsClient struct {
	BaseClient
}

// NewModelsClient creates an instance of the ModelsClient client.
func NewModelsClient() ModelsClient {
	return NewModelsClientWithBaseURI(DefaultBaseURI)
}

// NewModelsClientWithBaseURI creates an instance of the ModelsClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewModelsClientWithBaseURI(baseURI string) ModelsClient {
	return ModelsClient{NewWithBaseURI(baseURI)}
}

// Add uploads one or more models. When any error occurs, no models are uploaded.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 409 (Conflict): One or more of the provided models already exist.
// Parameters:
// models - an array of models to add.
func (client ModelsClient) Add(ctx context.Context, models []interface{}) (result ListModelData, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: models,
			Constraints: []validation.Constraint{{Target: "models", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "models", Name: validation.MinItems, Rule: 1, Chain: nil},
					{Target: "models", Name: validation.UniqueItems, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("digitaltwins.ModelsClient", "Add", err.Error())
	}

	req, err := client.AddPreparer(ctx, models)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Add", resp, "Failure responding to request")
		return
	}

	return
}

// AddPreparer prepares the Add request.
func (client ModelsClient) AddPreparer(ctx context.Context, models []interface{}) (*http.Request, error) {
	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/models"),
		autorest.WithQueryParameters(queryParameters))
	if models != nil && len(models) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(models))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client ModelsClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client ModelsClient) AddResponder(resp *http.Response) (result ListModelData, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a model. A model can only be deleted if no other models reference it.
// Status codes:
// 204 (No Content): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no model with the provided id.
// 409 (Conflict): There are dependencies on the model that prevent it from being deleted.
// Parameters:
// ID - the id for the model. The id is globally unique and case sensitive.
func (client ModelsClient) Delete(ctx context.Context, ID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ModelsClient) DeletePreparer(ctx context.Context, ID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/models/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ModelsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ModelsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetByID retrieves model metadata and optionally the model definition.
// Status codes:
// 200 (OK): Success.
// 404 (Not Found): There is no model with the provided id.
// Parameters:
// ID - the id for the model. The id is globally unique and case sensitive.
// includeModelDefinition - when true the model definition will be returned as part of the result.
func (client ModelsClient) GetByID(ctx context.Context, ID string, includeModelDefinition *bool) (result ModelData, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.GetByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByIDPreparer(ctx, ID, includeModelDefinition)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "GetByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "GetByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "GetByID", resp, "Failure responding to request")
		return
	}

	return
}

// GetByIDPreparer prepares the GetByID request.
func (client ModelsClient) GetByIDPreparer(ctx context.Context, ID string, includeModelDefinition *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if includeModelDefinition != nil {
		queryParameters["includeModelDefinition"] = autorest.Encode("query", *includeModelDefinition)
	} else {
		queryParameters["includeModelDefinition"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/models/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByIDSender sends the GetByID request. The method will close the
// http.Response Body if it receives an error.
func (client ModelsClient) GetByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetByIDResponder handles the response to the GetByID request. The method always
// closes the http.Response Body.
func (client ModelsClient) GetByIDResponder(resp *http.Response) (result ModelData, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List retrieves model metadata and, optionally, model definitions.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// Parameters:
// dependenciesFor - the set of the models which will have their dependencies retrieved. If omitted, all models
// are retrieved.
// includeModelDefinition - when true the model definition will be returned as part of the result.
// maxItemCount - the maximum number of items to retrieve per request. The server may choose to return less
// than the requested max.
func (client ModelsClient) List(ctx context.Context, dependenciesFor []string, includeModelDefinition *bool, maxItemCount *int32) (result PagedModelDataCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.List")
		defer func() {
			sc := -1
			if result.pmdc.Response.Response != nil {
				sc = result.pmdc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, dependenciesFor, includeModelDefinition, maxItemCount)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.pmdc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "List", resp, "Failure sending request")
		return
	}

	result.pmdc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "List", resp, "Failure responding to request")
		return
	}
	if result.pmdc.hasNextLink() && result.pmdc.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ModelsClient) ListPreparer(ctx context.Context, dependenciesFor []string, includeModelDefinition *bool, maxItemCount *int32) (*http.Request, error) {
	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if dependenciesFor != nil && len(dependenciesFor) > 0 {
		queryParameters["dependenciesFor"] = dependenciesFor
	}
	if includeModelDefinition != nil {
		queryParameters["includeModelDefinition"] = autorest.Encode("query", *includeModelDefinition)
	} else {
		queryParameters["includeModelDefinition"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/models"),
		autorest.WithQueryParameters(queryParameters))
	if maxItemCount != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-max-item-count", autorest.String(*maxItemCount)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-max-item-count", autorest.String(-1)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ModelsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ModelsClient) ListResponder(resp *http.Response) (result PagedModelDataCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ModelsClient) listNextResults(ctx context.Context, lastResults PagedModelDataCollection) (result PagedModelDataCollection, err error) {
	req, err := lastResults.pagedModelDataCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ModelsClient) ListComplete(ctx context.Context, dependenciesFor []string, includeModelDefinition *bool, maxItemCount *int32) (result PagedModelDataCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, dependenciesFor, includeModelDefinition, maxItemCount)
	return
}

// Update updates the metadata for a model.
// Status codes:
// 200 (OK): Success.
// 400 (Bad Request): The request is invalid.
// 404 (Not Found): There is no model with the provided id.
// Parameters:
// ID - the id for the model. The id is globally unique and case sensitive.
// updateModel - an update specification described by JSON Patch. Only the decommissioned property can be
// replaced.
func (client ModelsClient) Update(ctx context.Context, ID string, updateModel []interface{}) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ModelsClient.Update")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: updateModel,
			Constraints: []validation.Constraint{{Target: "updateModel", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("digitaltwins.ModelsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, ID, updateModel)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "digitaltwins.ModelsClient", "Update", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ModelsClient) UpdatePreparer(ctx context.Context, ID string, updateModel []interface{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"id": autorest.Encode("path", ID),
	}

	const APIVersion = "2020-05-31-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json-patch+json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/models/{id}", pathParameters),
		autorest.WithJSON(updateModel),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ModelsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ModelsClient) UpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
