package mysqlflexibleservers

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// Default ...
	Default CreateMode = "Default"
	// PointInTimeRestore ...
	PointInTimeRestore CreateMode = "PointInTimeRestore"
	// Replica ...
	Replica CreateMode = "Replica"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{Default, PointInTimeRestore, Replica}
}

// HaEnabledEnum enumerates the values for ha enabled enum.
type HaEnabledEnum string

const (
	// Disabled ...
	Disabled HaEnabledEnum = "Disabled"
	// Enabled ...
	Enabled HaEnabledEnum = "Enabled"
)

// PossibleHaEnabledEnumValues returns an array of possible values for the HaEnabledEnum const type.
func PossibleHaEnabledEnumValues() []HaEnabledEnum {
	return []HaEnabledEnum{Disabled, Enabled}
}

// InfrastructureEncryptionEnum enumerates the values for infrastructure encryption enum.
type InfrastructureEncryptionEnum string

const (
	// InfrastructureEncryptionEnumDisabled ...
	InfrastructureEncryptionEnumDisabled InfrastructureEncryptionEnum = "Disabled"
	// InfrastructureEncryptionEnumEnabled ...
	InfrastructureEncryptionEnumEnabled InfrastructureEncryptionEnum = "Enabled"
)

// PossibleInfrastructureEncryptionEnumValues returns an array of possible values for the InfrastructureEncryptionEnum const type.
func PossibleInfrastructureEncryptionEnumValues() []InfrastructureEncryptionEnum {
	return []InfrastructureEncryptionEnum{InfrastructureEncryptionEnumDisabled, InfrastructureEncryptionEnumEnabled}
}

// IsConfigPendingRestart enumerates the values for is config pending restart.
type IsConfigPendingRestart string

const (
	// False ...
	False IsConfigPendingRestart = "False"
	// True ...
	True IsConfigPendingRestart = "True"
)

// PossibleIsConfigPendingRestartValues returns an array of possible values for the IsConfigPendingRestart const type.
func PossibleIsConfigPendingRestartValues() []IsConfigPendingRestart {
	return []IsConfigPendingRestart{False, True}
}

// IsDynamicConfig enumerates the values for is dynamic config.
type IsDynamicConfig string

const (
	// IsDynamicConfigFalse ...
	IsDynamicConfigFalse IsDynamicConfig = "False"
	// IsDynamicConfigTrue ...
	IsDynamicConfigTrue IsDynamicConfig = "True"
)

// PossibleIsDynamicConfigValues returns an array of possible values for the IsDynamicConfig const type.
func PossibleIsDynamicConfigValues() []IsDynamicConfig {
	return []IsDynamicConfig{IsDynamicConfigFalse, IsDynamicConfigTrue}
}

// IsReadOnly enumerates the values for is read only.
type IsReadOnly string

const (
	// IsReadOnlyFalse ...
	IsReadOnlyFalse IsReadOnly = "False"
	// IsReadOnlyTrue ...
	IsReadOnlyTrue IsReadOnly = "True"
)

// PossibleIsReadOnlyValues returns an array of possible values for the IsReadOnly const type.
func PossibleIsReadOnlyValues() []IsReadOnly {
	return []IsReadOnly{IsReadOnlyFalse, IsReadOnlyTrue}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// NotSpecified ...
	NotSpecified OperationOrigin = "NotSpecified"
	// System ...
	System OperationOrigin = "system"
	// User ...
	User OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{NotSpecified, System, User}
}

// PublicNetworkAccessEnum enumerates the values for public network access enum.
type PublicNetworkAccessEnum string

const (
	// PublicNetworkAccessEnumDisabled ...
	PublicNetworkAccessEnumDisabled PublicNetworkAccessEnum = "Disabled"
	// PublicNetworkAccessEnumEnabled ...
	PublicNetworkAccessEnumEnabled PublicNetworkAccessEnum = "Enabled"
)

// PossiblePublicNetworkAccessEnumValues returns an array of possible values for the PublicNetworkAccessEnum const type.
func PossiblePublicNetworkAccessEnumValues() []PublicNetworkAccessEnum {
	return []PublicNetworkAccessEnum{PublicNetworkAccessEnumDisabled, PublicNetworkAccessEnumEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}

// ServerHAState enumerates the values for server ha state.
type ServerHAState string

const (
	// CreatingStandby ...
	CreatingStandby ServerHAState = "CreatingStandby"
	// FailingOver ...
	FailingOver ServerHAState = "FailingOver"
	// Healthy ...
	Healthy ServerHAState = "Healthy"
	// NotEnabled ...
	NotEnabled ServerHAState = "NotEnabled"
	// RemovingStandby ...
	RemovingStandby ServerHAState = "RemovingStandby"
	// ReplicatingData ...
	ReplicatingData ServerHAState = "ReplicatingData"
)

// PossibleServerHAStateValues returns an array of possible values for the ServerHAState const type.
func PossibleServerHAStateValues() []ServerHAState {
	return []ServerHAState{CreatingStandby, FailingOver, Healthy, NotEnabled, RemovingStandby, ReplicatingData}
}

// ServerState enumerates the values for server state.
type ServerState string

const (
	// ServerStateDisabled ...
	ServerStateDisabled ServerState = "Disabled"
	// ServerStateDropping ...
	ServerStateDropping ServerState = "Dropping"
	// ServerStateReady ...
	ServerStateReady ServerState = "Ready"
	// ServerStateStarting ...
	ServerStateStarting ServerState = "Starting"
	// ServerStateStopped ...
	ServerStateStopped ServerState = "Stopped"
	// ServerStateStopping ...
	ServerStateStopping ServerState = "Stopping"
	// ServerStateUpdating ...
	ServerStateUpdating ServerState = "Updating"
)

// PossibleServerStateValues returns an array of possible values for the ServerState const type.
func PossibleServerStateValues() []ServerState {
	return []ServerState{ServerStateDisabled, ServerStateDropping, ServerStateReady, ServerStateStarting, ServerStateStopped, ServerStateStopping, ServerStateUpdating}
}

// ServerVersion enumerates the values for server version.
type ServerVersion string

const (
	// FiveFullStopSeven ...
	FiveFullStopSeven ServerVersion = "5.7"
)

// PossibleServerVersionValues returns an array of possible values for the ServerVersion const type.
func PossibleServerVersionValues() []ServerVersion {
	return []ServerVersion{FiveFullStopSeven}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Burstable ...
	Burstable SkuTier = "Burstable"
	// GeneralPurpose ...
	GeneralPurpose SkuTier = "GeneralPurpose"
	// MemoryOptimized ...
	MemoryOptimized SkuTier = "MemoryOptimized"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Burstable, GeneralPurpose, MemoryOptimized}
}

// SslEnforcementEnum enumerates the values for ssl enforcement enum.
type SslEnforcementEnum string

const (
	// SslEnforcementEnumDisabled ...
	SslEnforcementEnumDisabled SslEnforcementEnum = "Disabled"
	// SslEnforcementEnumEnabled ...
	SslEnforcementEnumEnabled SslEnforcementEnum = "Enabled"
)

// PossibleSslEnforcementEnumValues returns an array of possible values for the SslEnforcementEnum const type.
func PossibleSslEnforcementEnumValues() []SslEnforcementEnum {
	return []SslEnforcementEnum{SslEnforcementEnumDisabled, SslEnforcementEnumEnabled}
}

// StorageAutogrow enumerates the values for storage autogrow.
type StorageAutogrow string

const (
	// StorageAutogrowDisabled ...
	StorageAutogrowDisabled StorageAutogrow = "Disabled"
	// StorageAutogrowEnabled ...
	StorageAutogrowEnabled StorageAutogrow = "Enabled"
)

// PossibleStorageAutogrowValues returns an array of possible values for the StorageAutogrow const type.
func PossibleStorageAutogrowValues() []StorageAutogrow {
	return []StorageAutogrow{StorageAutogrowDisabled, StorageAutogrowEnabled}
}
